;;; un-tools.el --- useful functions for UNICODE special features.

;; Copyright (C) 1997 Miyashita Hisashi

;; Keywords: mule, multilingual, 
;;           character set, coding-system, ISO10646, Unicode

;; This file is part of MULE-UCS

;; MULE-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; MULE-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;; Comment:
;;  This module supports useful functions for unicode.
;;  If you want to use auto detecting utf? .etc, 
;;  add (require 'un-tools) to your .emacs.

(require 'un-data)

(defvar unicode-set-auto-coding-enable-p t
  "* non-nil means unicode-set-auto-coding detect UTF signatures.")

(defvar unicode-original-auto-coding-function nil)

(defvar unicode-set-auto-coding-alist
  (list 
   (cons utf16-le-dos-signature-regexp 'utf16-le-dos)
   (cons utf16-le-unix-signature-regexp 'utf16-le-unix)
   (cons utf16-le-mac-signature-regexp 'utf16-le-mac)
   (cons utf16-le-signature-regexp 'utf16-le)
   (cons utf16-be-dos-signature-regexp 'utf16-be-dos)
   (cons utf16-be-unix-signature-regexp 'utf16-be-unix)
   (cons utf16-be-mac-signature-regexp 'utf16-be-mac)
   (cons utf16-be-signature-regexp 'utf16-be)
   (cons utf8-dos-signature-regexp 'utf8-dos)
   (cons utf8-unix-signature-regexp 'utf8-unix)
   (cons utf8-mac-signature-regexp 'utf8-mac)
   (cons utf8-signature-regexp 'utf8))
  "* Specify the correspond coding-system of each signature(regexp).")

;; Automatic ditection for unicode signature.
;;  You should set `unicode-set-auto-coding-alist'
;;   to specify the correspond coding-system of each signature.

(defun unicode-set-auto-coding (string)
  (let ((curlist unicode-set-auto-coding-alist)
	coding)

    (or
     (funcall unicode-original-auto-coding-function string)
     (progn
       (while
	   (cond ((null curlist)
		  (setq coding nil))
		 ((and
		   (coding-system-p (setq coding (cdr (car curlist))))
		   (string-match (car (car curlist)) string))
		  nil)
		 (t
		  (setq curlist (cdr curlist)
			coding nil)
		  t)))
       coding))))
	       
	       

	
(if (and unicode-set-auto-coding-enable-p
	 (not (eq set-auto-coding-function
		  'unicode-set-auto-coding)))
    (progn
      (setq unicode-original-auto-coding-function 
	    set-auto-coding-function)
      (setq set-auto-coding-function
	    'unicode-set-auto-coding)))

(provide 'un-tools)
