# XXX is this right - it was /var/lib before FHS macros
%define _localstatedir	/var/lib
%define _libexecdir	/var/www/cgi-bin

Summary: Namazu is a full-text search engine
Name: namazu
Version: 2.0.11
Release: 1
Copyright: GPL
Group: Applications/Text
BuildRequires: perl, perl-NKF >= 1.70, perl-Text-Kakasi >= 1.00
Requires: perl, perl-File-MMagic >= 1.12, perl-NKF >= 1.70
Requires: kakasi >= 2.3.0, perl-Text-Kakasi >= 1.00
Source: http://www.namazu.org/stable/%{name}-%{version}.tar.gz
URL: http://www.namazu.org/
BuildRoot: %{_tmppath}/%{name}-buildroot

%description
Namazu is a full-text search engine software intended for easy use.
Not only it works as CGI program for small or medium scale WWW
search engine, but also works as personal use such as search system
for local HDD.

%package devel
Summary: Libraries and include files of Namazu
Group: Development/Libraries
Requires: %{name} = %{version}

%description devel
Libraries and include files of Namazu.

%package cgi
Summary: a CGI interface for Namazu
Group: Applications/Text
Requires: %{name} = %{version}
Requires: webserver

%description cgi
A CGI interface for Namazu.

%changelog
* Thu Jul 26 2001 Ryuji Abe <rug@namazu.org>
- fix %files

* Sat Jun 23 2001 Ryuji Abe <rug@namazu.org>
- fix summary and %description

* Thu May 31 2001 Ryuji Abe <rug@namazu.org>
- fix %files
- fix again cgi-bin location to /var/www/cgi-bin

* Mon May 28 2001 Ryuji Abe <rug@namazu.org>
- clean up spec file
- more macros
- provide cgi package
- fix cgi-bin location /home/httpd/cgi-bin to /var/www/namazu-cgi-bin

* Wed Mar 21 2001 Ryuji Abe <rug@namazu.org>
- Rebuilt for 7.1 beta
- more macros
- fix dependencies
- exclude unnecessary ja_JP.SJIS catalog.

* Thu Oct 26 2000 Ryuji Abe <rug@namazu.org>
- Requires perl-File-MMagic >= 1.09.
- Add BuildRequires.

* Tue Aug 22 2000 Ryuji Abe <rug@namazu.org>
- Fixed %localstatedir /var to /var/lib.

* Tue Apr 25 2000 Ryuji Abe <rug@namazu.org>
- Ignore %{prefix}/share/namazu/etc.

* Sun Feb 20 2000 Ryuji Abe <raeva@t3.rim.or.jp>
- Install namazu.cgi at /home/httpd/cgi-bin.
- Fixed typo.

* Sat Feb 19 2000 Satoru Takabayashi <satoru-t@is.aist-nara.ac.jp>
- Change URL.

* Tue Feb 15 2000 Ryuji Abe <raeva@t3.rim.or.jp>
- Delete package entries elisp and cgi.

* Wed Feb 02 2000 Ryuji Abe <raeva@t3.rim.or.jp>
- Adapted for namazu-current.
- Changed group Utilities/Text -> Applications/Text.

* Thu Dec 30 1999 Ryuji Abe <raeva@t3.rim.or.jp>
- rpm-3.0.x adaptations.
- Added package entries elisp and cgi (currently comment out). 
  [Merged SAKA Toshihide's changes for Kondara MNU/Linux.]

* Mon Nov 08 1999 Ryuji Abe <raeva@t3.rim.or.jp>
- Changed includedir %{prefix}/include/namazu.
- Bug fix at configure section.

* Thu Nov 04 1999 Ryuji Abe <raeva@t3.rim.or.jp>
- Added nmz-config in devel package.

* Wed Nov 03 1999 Ryuji Abe <raeva@t3.rim.or.jp>
- Use our definite macros, ver, rel, prefix, sysconfdir, and localstatedir.
- If configure not found, use autogen.sh.
- Optimized for SMP environment.
- Build devel package.

* Tue Oct 12 1999 Ryuji Abe <raeva@t3.rim.or.jp>
- Fixed correctly executables entry at %files.
- Added missing /usr/share/locale entry at %files.
 
* Thu Aug 26 1999 Ryuji Abe <raeva@t3.rim.or.jp>
- Requires perl >= 5.004.
- Delete Packager tag.
- Clean up at %prep.
- Use CFLAGS="$RPM_OPT_FLAGS" at %build.
- Use $RPM_BUILD_ROOT variables at %install.
- Change configure option at %build and %files for new namazu directory structure.

* Sun May 23 1999 Taku Kudoh <taku@TAHOO.ORG>
- 

%prep 
%setup -q

%build
%configure

if [ "$SMP" != "" ]; then
  make -j$SMP "MAKE=make -j$SMP"
else
  make
fi

%install
rm -rf %{buildroot}
%makeinstall

mv %{buildroot}%{_sysconfdir}/namazu/namazurc-sample \
	%{buildroot}%{_sysconfdir}/namazu/namazurc
mv %{buildroot}%{_sysconfdir}/namazu/mknmzrc-sample \
	%{buildroot}%{_sysconfdir}/namazu/mknmzrc
chmod a+rw -R %{buildroot}%{_localstatedir}/namazu
chmod a+rw -R %{buildroot}%{_localstatedir}/namazu/index

%find_lang %{name}

%clean
rm -rf %{buildroot}

%post -p /sbin/ldconfig
%postun -p /sbin/ldconfig

%files -f %{name}.lang
%defattr(-, root, root)
%doc AUTHORS ChangeLog ChangeLog.1 CREDITS COPYING HACKING HACKING-ja
%doc INSTALL INSTALL-ja README README-es README-ja NEWS THANKS TODO
%doc etc/namazu.png
%config %{_sysconfdir}/namazu/*
%{_bindir}/namazu
%{_bindir}/bnamazu
%{_bindir}/*nmz
%{_bindir}/mailutime
%{_bindir}/nmzgrep
%{_bindir}/nmzmerge
%{_libdir}/*.so.*
%{_mandir}/man1/*
%{_datadir}/namazu/doc/*
%{_datadir}/namazu/filter/*
%{_datadir}/namazu/pl/*
%{_datadir}/namazu/template/*
%dir %{_localstatedir}/namazu
%dir %{_localstatedir}/namazu/index

%files devel
%defattr(-, root, root)
%{_bindir}/nmz-config
%{_includedir}/namazu/*.h
%{_libdir}/*.so
%{_libdir}/*a

%files cgi
%defattr(-, root, root)
%{_libexecdir}/namazu.cgi
