###################################################################### 
#
# Makefile fo building the dynamically loaded lib libmagick.dl
#   and libwand.dl
# 
###################################################################### 

###################################################################### 
# Variables

MAGICK_LIB_NAME = libmagick
MAGICK_TARGET   = $(MAGICK_LIB_NAME).dl

WAND_LIB_NAME   = libwand
WAND_TARGET     = $(WAND_LIB_NAME).dl

LNK = ch dllink 
CC  = ch dlcomp 

######################################################################
# Objects 

MAGICK_OBJS = \
       animate_chdl.$(OBJ) \
       annotate_chdl.$(OBJ) \
       attribute_chdl.$(OBJ) \
       blob_chdl.$(OBJ) \
       cache_chdl.$(OBJ) \
       cache-view_chdl.$(OBJ) \
       client_chdl.$(OBJ) \
       coder_chdl.$(OBJ) \
       color_chdl.$(OBJ) \
       colorspace_chdl.$(OBJ) \
       compare_chdl.$(OBJ) \
       composite_chdl.$(OBJ) \
       compress_chdl.$(OBJ) \
       configure_chdl.$(OBJ) \
       conjure_chdl.$(OBJ) \
       constitute_chdl.$(OBJ) \
       convert_chdl.$(OBJ) \
       decorate_chdl.$(OBJ) \
       delegate_chdl.$(OBJ) \
       display_chdl.$(OBJ) \
       draw_chdl.$(OBJ) \
       effect_chdl.$(OBJ) \
       enhance_chdl.$(OBJ) \
       exception_chdl.$(OBJ) \
       fx_chdl.$(OBJ) \
       gem_chdl.$(OBJ) \
       geometry_chdl.$(OBJ) \
       hashmap_chdl.$(OBJ) \
       identify_chdl.$(OBJ) \
       image_chdl.$(OBJ) \
       import_chdl.$(OBJ) \
       list_chdl.$(OBJ) \
       locale__chdl.$(OBJ) \
       log_chdl.$(OBJ) \
       magic_chdl.$(OBJ) \
       magick_chdl.$(OBJ) \
       memory__chdl.$(OBJ) \
       module_chdl.$(OBJ) \
       mogrify_chdl.$(OBJ) \
       montage_chdl.$(OBJ) \
       option_chdl.$(OBJ) \
       paint_chdl.$(OBJ) \
       pixel_chdl.$(OBJ) \
       profile_chdl.$(OBJ) \
       quantize_chdl.$(OBJ) \
       random__chdl.$(OBJ) \
       registry_chdl.$(OBJ) \
       resize_chdl.$(OBJ) \
       resource__chdl.$(OBJ) \
       segment_chdl.$(OBJ) \
       semaphore_chdl.$(OBJ) \
       shear_chdl.$(OBJ) \
       signature_chdl.$(OBJ) \
       statistic_chdl.$(OBJ) \
       stream_chdl.$(OBJ) \
       string__chdl.$(OBJ) \
       timer_chdl.$(OBJ) \
       token_chdl.$(OBJ) \
       transform_chdl.$(OBJ) \
       type_chdl.$(OBJ) \
       utility_chdl.$(OBJ) \
       version_chdl.$(OBJ) \
       xwindow_chdl.$(OBJ)               

MAGICK_HANDMADE_OBJS = \
        FormatStringList_chdl.$(OBJ) \
        ThrowMagickExceptionList_chdl.$(OBJ) \
        NewHashmap_chdl.$(OBJ) \
	DestroyLinkedList_chdl.$(OBJ) \
	ClearLinkedList_chdl.$(OBJ) \
	InsertValueInSortedLinkedList_chdl.$(OBJ) \
	FormatMagickStringList_chdl.$(OBJ) \
	NewSplayTree_chdl.$(OBJ) \
        LogMagickEventList_chdl.$(OBJ) \
        FormatImageAttributeList_chdl.$(OBJ)

WAND_OBJS = \
        drawing-wand_chdl.$(OBJ) \
	magick-attribute_chdl.$(OBJ) \
        magick-image_chdl.$(OBJ) \
        magick-wand_chdl.$(OBJ) \
        pixel-iterator_chdl.$(OBJ) \
        pixel-wand_chdl.$(OBJ) \
        wand_chdl.$(OBJ)

######################################################################
# Targets

all: $(MAGICK_TARGET) $(WAND_TARGET)

$(MAGICK_TARGET): $(MAGICK_OBJS) $(MAGICK_HANDMADE_OBJS)
	$(LNK) $(MAGICK_TARGET) $(MAGICK_OBJS) $(MAGICK_HANDMADE_OBJS) $(MAGICK_LFLAGS)
$(MAGICK_OBJS): 
	$(CC) $(MAGICK_TARGET) $(CFLAGS) -c $*.c $(IFLAGS)
$(MAGICK_HANDMADE_OBJS): 
	$(CC) $(MAGICK_TARGET) $(CFLAGS) -c handmade/magick/$*.c $(IFLAGS)

$(WAND_TARGET): $(WAND_OBJS) $(WAND_HANDMADE_OBJS)
	$(LNK) $(WAND_TARGET) $(WAND_OBJS) $(WAND_HANDMADE_OBJS) $(WAND_LFLAGS)
$(WAND_OBJS): 
	$(CC) $(WAND_TARGET) $(CFLAGS) -c $*.c $(IFLAGS)
#$(WAND_HANDMADE_OBJS): 
#	$(CC) $(WAND_TARGET) $(CFLAGS) -c handmade/wand/$*.c $(IFLAGS)

clean:
	rm -f *.o *.obj *.a *.dll *.exp *.lib logfile

######################################################################
