#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <magick/ImageMagick.h>
#include <ch.h>

/* Structures taken from hashmap.h */
 
typedef struct _ElementInfo
{
  void
    *value;

  struct _ElementInfo
    *next;
} ElementInfo;

struct _LinkedListInfo
{
  unsigned long
    capacity,
    elements;

  ElementInfo
    *head,
    *tail,
    *next;

  MagickBooleanType
    debug;

  SemaphoreInfo
    *semaphore;

  unsigned long
    signature;
};


typedef void *(*relinquish_value)(void *);

static ChInterp_t interp;
static void *relinquish_value_funptr;
static void *relinquish_value_funarg(void *arg);

EXPORTCH LinkedListInfo *DestroyLinkedList_chdl(void *varg) {
    LinkedListInfo *list_info;
    relinquish_value relinquish_value_func;
    ChVaList_t ap;
    LinkedListInfo *retval;

    Ch_VaStart(interp, ap, varg);

    list_info = Ch_VaArg(interp, ap, LinkedListInfo *);

    relinquish_value_func = Ch_VaArg(interp, ap, relinquish_value);
    if(relinquish_value_func != NULL)
    {
       relinquish_value_funptr = (void *)relinquish_value_func; 
       relinquish_value_func = (relinquish_value)relinquish_value_funarg;
    }

    retval = DestroyLinkedList(list_info, 
		               relinquish_value_func);
    Ch_VaEnd(interp, ap);
    return retval;
}

static void *relinquish_value_funarg(void *arg)
{
	void *retval;
	Ch_CallFuncByAddr(interp, &retval, relinquish_value_funptr, arg);
	return retval;
}
