#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <magick/ImageMagick.h>
#include <ch.h>

/* Structures taken from hashmap.c */
 
typedef struct _ElementInfo
{
  void
    *value;

  struct _ElementInfo
    *next;
} ElementInfo;

typedef struct _EntryInfo
{
  size_t
    hash;

  void
    *key,
    *value;
} EntryInfo;

struct _LinkedListInfo
{
  unsigned long
    capacity,
    elements;

  ElementInfo
    *head,
    *tail,
    *next;

  MagickBooleanType
    debug;

  SemaphoreInfo
    *semaphore;

  unsigned long
    signature;
};

struct _HashmapInfo
{
  size_t
    (*hash)(const void *);

  MagickBooleanType
    (*compare)(const void *,const void *);

  void
    *(*relinquish_key)(void *),
    *(*relinquish_value)(void *);

  unsigned long
    capacity,
    entries,
    next;

  MagickBooleanType
    head_of_list;

  LinkedListInfo
    **map;

  MagickBooleanType
    debug;

  SemaphoreInfo
    *semaphore;

  unsigned long
    signature;
};


typedef size_t (*hash)(const void *);
typedef MagickBooleanType (*compare)(const void *,const void *);
typedef void *(*relinquish_key)(void *);
typedef void *(*relinquish_value)(void *);

static ChInterp_t interp;
static void *hash_funptr;
static void *compare_funptr;
static void *relinquish_key_funptr;
static void *relinquish_value_funptr;

static size_t hash_funarg(const void *arg);
static MagickBooleanType compare_funarg(const void *arg1, const void *arg2);
static void *relinquish_key_funarg(void *arg);
static void *relinquish_value_funarg(void *arg);

EXPORTCH HashmapInfo *NewHashmap_chdl(void *varg) {
    unsigned long capacity;
    hash hash_func;
    compare compare_func;
    relinquish_key relinquish_key_func;
    relinquish_value relinquish_value_func;
    ChVaList_t ap;
    HashmapInfo *retval;

    Ch_VaStart(interp, ap, varg);

    capacity = Ch_VaArg(interp, ap, unsigned long);

    hash_func = Ch_VaArg(interp, ap, hash);
    if(hash_func != NULL)
    {
       hash_funptr = (void *)hash_func; 
       hash_func = (hash)hash_funarg;
    }

    compare_func = Ch_VaArg(interp, ap, compare);
    if(compare_func != NULL)
    {
       compare_funptr = (void *)compare_func; 
       compare_func = (compare)compare_funarg;
    }

    relinquish_key_func = Ch_VaArg(interp, ap, relinquish_key);
    if(relinquish_key_func != NULL)
    {
       relinquish_key_funptr = (void *)relinquish_key_func; 
       relinquish_key_func = (relinquish_key)relinquish_key_funarg;
    }

    relinquish_value_func = Ch_VaArg(interp, ap, relinquish_value);
    if(relinquish_value_func != NULL)
    {
       relinquish_value_funptr = (void *)relinquish_value_func; 
       relinquish_value_func = (relinquish_value)relinquish_value_funarg;
    }

    retval = NewHashmap(capacity, 
		        hash_func, 
			compare_func, 
			relinquish_key_func,
		        relinquish_value_func);
    Ch_VaEnd(interp, ap);
    return retval;
}

static size_t hash_funarg(const void *arg)
{
	size_t retval;
	Ch_CallFuncByAddr(interp, &retval, hash_funptr, arg);
	return retval;
}

static MagickBooleanType compare_funarg(const void *arg1, const void *arg2)
{
	MagickBooleanType retval;
	Ch_CallFuncByAddr(interp, &retval, compare_funptr, arg1, arg2);
	return retval;
}

static void *relinquish_key_funarg(void *arg)
{
	void *retval;
	Ch_CallFuncByAddr(interp, &retval, relinquish_key_funptr, arg);
	return retval;
}

static void *relinquish_value_funarg(void *arg)
{
	void *retval;
	Ch_CallFuncByAddr(interp, &retval, relinquish_value_funptr, arg);
	return retval;
}
