#!/bin/ch

/* For creating Ch Magick 1.0, April 10th, 2005
 *
 * this script does the following:
 * + Copies headers from <IMAGEMAGICK_HOME>/magick/include to 
 *     ./chmagick/include subfolder
 * + Copies C/Ch samples from ./demos/ directory to ./chming/demos
 * + Generates *.h files in ./chfcreate/ directory, those files contain a
 *     list of function prototypes for Magick from the Magick header files. 
 * + Processes each function list with c2chf
 * + Moves *.chf files generated by c2chf to ./chmagick/lib subfolder and
 *     *_chdl.c files to ./c subfolder
 * + Builds .dl files using Ch SDK and places them to ./chmagick/dl
 *
 */

#include <unistd.h>   // for access()
#include <dlfcn.h>    // for dlopen()
#include <chshell.h>  // for chinfo()

int addChdlHeader(char *headerfile, char *macro, char *chdlheader);
int parseHeaderFile(char *filename, char *fileout, char *macro);

string_t pkgname="chmagick";       // define package name
chinfo_t info;                  // for Ch version number
string_t cwd = _cwd;            // the current working directory
string_t lib_header_dir;        // library header files directory
string_t lib_dll_dir;           // library dll files directory
string_t lib_lib_dir;           // library lib files directory
string_t magick_list, wand_list;
string_t debug;
string_t debugFile;
string_t makecmd;
string_t token;
char     win_binary = 0;        // First assume Windows source of ImageMagick
#if defined(_WIN32_)
    if(!access("../VisualMagick", "r"))
    {
       lib_header_dir = "../";
       lib_lib_dir =    "../VisualMagick/lib";
       lib_dll_dir =    "../VisualMagick/bin";
    }
    else
    {
       win_binary = 1;          // Windows binary of ImageMagick
       lib_header_dir = "../include/";
       lib_lib_dir =    "../lib";
       lib_dll_dir =    "../";
    }

    debug=">nul 2>nul";        // comment this for message in compilation 
    debugFile =">logfile 2>&1"; // compilation debug information in 'logfile'
    makecmd = "nmake -f Makefile.win";
#elif defined(_SOLARIS_)
    lib_header_dir = "../";
    makecmd = "make -f Makefile.solaris";
#else
    lib_header_dir = "../";
    makecmd = "make -f Makefile";
#endif


//make sure pgkcreate.ch is run from the current working directory
if(access("pkgcreate.ch", R_OK)) {
    echo Run ./pkgcreate.ch in the current directory.
    exit(-1);
}


// run this script in proper Ch version
chinfo(&info);
if ((info.vermajor*100+ info.verminor*10 +  info.vermicro) < 503) {
   echo "To run this script, you need to install Ch version 5.0.3.12331 or higher"
   echo "You can download the latest version from http://www.softintegration.com/download"
   exit(-1);
}

echo Clean up existing directories and create new ones ...
if (!access(pkgname, F_OK))
  rm -rf $pkgname
mkdir $pkgname
mkdir $pkgname/dl $pkgname/lib $pkgname/include $pkgname/include/magick $pkgname/include/wand $pkgname/bin $pkgname/demos

echo Copying header files ...
cp -rf $lib_header_dir/magick/*.h   $pkgname/include/magick
cp -rf $lib_header_dir/wand/*.h   $pkgname/include/wand
rm -f $pkgname/include/magick/*-private*.h
rm -f $pkgname/include/magick/mac.h
rm -f $pkgname/include/magick/studio.h
rm -f $pkgname/include/wand/*-private*.h
rm -f $pkgname/include/wand/magick_wand.h

echo Adding LOAD_CHDL into magick/ImageMagick.h ...

//if the original package doesn't have the modiciation for Ch
if(`grep LOAD_CHDL $pkgname/include/magick/ImageMagick.h` == NULL)
{
   char *headerfile = stradd(pkgname, "/include/magick/ImageMagick.h");
   char *macro ="#define _MAGICK_IMAGEMAGICK_H";
   char *chdlheader =
     "\n"
     "\n#ifdef _CH_"
     "\n#pragma package <chmagick>"
     "\n#include <chdl.h>"
     "\nLOAD_CHDL(magick);"
#ifdef _WIN32_
     "\n"
     "\nif(getenv(\"MAGICK_HOME\") == NULL)"
     "\n{"
     "\n  char *path;"
     "\n  foreach(path; _path; NULL; \";\")"
     "\n  {"
     "\n    if(strstr(path, \"chmagick\") != NULL)"
     "\n    {"
     "\n      putenv(stradd(\"MAGICK_HOME=\", path));"
     "\n      break;"
     "\n    }"
     "\n  }"
     "\n}"
     "\n"
#endif //_WIN32_
     "\n#endif"
     "\n";
   addChdlHeader(headerfile, macro, chdlheader);
}
if(`grep LOAD_CHDL $pkgname/include/wand/magick-wand.h` == NULL)
{
   char *headerfile = stradd(pkgname, "/include/wand/magick-wand.h");
   char *macro ="#define _WAND_MAGICK_WAND_H";
   char *chdlheader =
     "\n"
     "\n#ifdef _CH_"
     "\n#pragma package <chmagick>"
     "\n#include <chdl.h>"
     "\nLOAD_CHDL(wand);"
     "\n#endif"
     "\n";
   addChdlHeader(headerfile, macro, chdlheader);
}

echo Echo copying demo programs ...
if(win_binary) 
   cp -rf demos $pkgname $debug
else
{
   cp -f ../tests/*.c       $pkgname/demos >nul 2>nul
   cp -f ../utilities/*.c   $pkgname/demos >nul 2>nul
   cp -f ../utilities/*.msl $pkgname/demos >nul 2>nul
   cp -f ../utilities/*.jpg $pkgname/demos >nul 2>nul
   cp -f demos/*.msl        $pkgname/demos >nul 2>nul
   cp -f demos/*.jpg        $pkgname/demos >nul 2>nul
   cp -f ../wand/*test.c    $pkgname/demos >nul 2>nul
   cp -f ../wand/sequence.miff     $pkgname/demos >nul 2>nul
   cp -f demos/wand.c       $pkgname/demos >nul 2>nul
}
#ifdef _WIN32_
  rm -rf $pkgname/demos/animate.c >nul 2>nul
  rm -rf $pkgname/demos/display.c >nul 2>nul
  rm -rf $pkgname/demos/import.c >nul 2>nul
#endif
chmod 755 $pkgname/demos/*.c

#if defined(_WIN32_)
echo copying DLLs ...
cp -f $lib_dll_dir/*.dll  $pkgname/bin
if(!win_binary)
{
  cp -f $lib_dll_dir/*.xml  $pkgname/bin
}

echo copying library file ...
mkdir lib >nul 2>nul
cp -f $lib_lib_dir/CORE_RL_magick_.lib lib/
cp -f $lib_lib_dir/CORE_RL_wand_.lib   lib/
#else
cp -f ../config/*.xml $pkgname/demos
#endif // _WIN32_

echo Extracting function prototypes ...
cd $pkgname/include/magick
magick_list = `grep -l "extern MagickExport" *.h`;
cd ../wand
wand_list = `grep -l "extern WandExport" *.h`;
cd ../../../
rm -rf chfcreate/*
mkdir chfcreate/magick chfcreate/wand
foreach(token; magick_list)
{
   parseHeaderFile(stradd(pkgname, "/include/magick/", token), 
      stradd("chfcreate/", token), "extern MagickExport");
   sed -f magick.sed chfcreate/$token > chfcreate/magick/$token 
   rm -f chfcreate/$token
}
foreach(token; wand_list)
{
   parseHeaderFile(stradd(pkgname, "/include/wand/", token), 
      stradd("chfcreate/", token), "extern WandExport");
   sed -f wand.sed chfcreate/$token > chfcreate/wand/$token 
   rm -f chfcreate/$token
}


echo Removing special functions from the headerfiles ...
/* special cases: ... and their vfunc */
removeFuncProto("chfcreate/magick/deprecate.h", "FormatString", 0);
removeFuncProto("chfcreate/magick/deprecate.h", "FormatStringList", 0);
removeFuncProto("chfcreate/magick/exception.h", "ThrowMagickException", 0);
removeFuncProto("chfcreate/magick/exception.h", "ThrowMagickExceptionList", 0);
removeFuncProto("chfcreate/magick/log.h", "LogMagickEvent", 0);
removeFuncProto("chfcreate/magick/log.h", "LogMagickEventList", 0);
removeFuncProto("chfcreate/magick/string_.h", "FormatMagickString", 0);
removeFuncProto("chfcreate/magick/string_.h", "FormatMagickStringList", 0);
removeFuncProto("chfcreate/magick/attribute.h", "FormatImageAttribute", 0);
removeFuncProto("chfcreate/magick/attribute.h", "FormatImageAttributeList", 0);

/* special cases: point to functions */
removeFuncProto("chfcreate/magick/hashmap.h", "NewHashmap", 0);
removeFuncProto("chfcreate/magick/hashmap.h", "DestroyLinkedList", 0);
removeFuncProto("chfcreate/magick/hashmap.h", "ClearLinkedList", 0);
removeFuncProto("chfcreate/magick/hashmap.h", 
		"InsertValueInSortedLinkedList", 0);
removeFuncProto("chfcreate/magick/splay-tree.h", "NewSplayTree", 0);

echo Generating xxx_chdl.c in c/ and xxx.chf in $pkgname/lib ...
magick_list = `ls chfcreate/magick/*.h`;
wand_list   = `ls chfcreate/wand/*.h`;

foreach(token; magick_list; NULL; " ")
{
   c2chf $token -h _Chmagick_handle -i c stdio.h -i c stdlib.h -i c string.h -i c stdarg.h -i c magick/ImageMagick.h -o c c -o chf $pkgname/lib 
}
foreach(token; wand_list; NULL; " ")
{
   c2chf $token -h _Chwand_handle -i c stdio.h -i c stdlib.h -i c string.h -i c stdarg.h -i c wand/magick-wand.h -o c c -o chf $pkgname/lib 
}

chmod 666 $pkgname/lib/*.chf

echo Patching special .chf files ...
cp -f chfhandmade/*.chf $pkgname/lib
chmod 644 $pkgname/lib/*.chf

echo Building the dynamically loaded library ...
cd c
$makecmd clean $debug
$makecmd $debugFile

// go back to original directory
cd $cwd

echo Adding .DLL path and testing the dynamically loaded library ...
#pragma exec _path=stradd(_path, "chmagick/bin");
if (dlopen("c/libmagick.dl", RTLD_LAZY) == NULL) {
    printf("Error: test of loading libmagick.dl: %s\n", dlerror());
    exit(-1);
}
if (dlopen("c/libwand.dl", RTLD_LAZY) == NULL) {
    printf("Error: test of loading libwand.dl: %s\n", dlerror());
    exit(-1);
}
mv -f c/libmagick.dl $pkgname/dl/libmagick.dl
mv -f c/libwand.dl   $pkgname/dl/libwand.dl
rm -rf lib

#if !defined(_WIN32_)
  if(!access("nul", W_OK))
    rm -f nul
#endif

echo package $pkgname created successfully!

/*******************************************************************
 * * This function will add the required preprocessing directives
 * * needed by Ch to a header file.
 * * headerfile:   header file to be changed
 * * macro:        token to be recoganized for insertion of chdlheader
 * * chdlheader:   preprocessing directives to be inserted
 * *******************************************************************/
int addChdlHeader(char *headerfile, char *macro, char *chdlheader)
{
   char *stop_ptr;
   string_t tempfile, token;
   string_t result;
   FILE *stream;
                            
   tempfile = ``cat $headerfile``;
   token = strstr( tempfile, macro);
   stop_ptr = strstr(token, "\n");
   strncpy(result, tempfile, strlen(tempfile)-strlen(stop_ptr));
   result=stradd(result, chdlheader);
   result=stradd(result, stop_ptr);
   if(!(stream = fopen("_tmpfile", "w")))
   {
      perror("_tmpfile");
      return -1;
   }
   fprintf(stream, "%s", result);
   fclose(stream);
   mv -f _tmpfile $(headerfile)
   return 0;
}

/*************************************************************************
 * This function modifies a header file with prototye listings such as
 *     extern MACRO int 
 *        func1(int i),
 *        func2(double f, int a),
 *        func3(size_t z, double l);
 * to
 *     extern MACRO int 
 *        func1(int i);
 *     extern MACRO int
 *        func2(double f, int a);
 *     extern MACRO int
 *        func3(size_t z, double l);
 *
 * Argumnets:
 *    filename: name of the file to process
 *    fileout:  name of the file to save the output to
 *    macro:  macro to search for
 *
 * Example:
 *    parseHeaderFile("nt-base.h", "nt-base2.h", "extern MagickExport");
 *    
 ***************************************************************/
int parseHeaderFile(char *filename, char *fileout, char *macro)
{
    FILE *fptr_out;
    string_t infile;
    string_t outfile;
    string_t rettype;
    char *startFile;
    char *startMacro; 
    char *endptr; 
    char *stop;
    char *position;
    int number;
    int sameline;

    /* Can we open the output file for writing? */
    if( (fptr_out = fopen(fileout, "w")) == NULL)
    {
       printf("Error while parsing header file.\n");
       printf("Unable to open '%s' for output.\n", fileout);
       return -1;
    }

    /* Can we open the intput file for reading? */
    if(access(filename, R_OK)) 
    {
       printf("Error while parsing header file.\n");
       printf("Unable to open '%s' for reading.\n", filename);
       return -1;
    }

    /* Store the input file into the string_t infile. */
    infile = ``cat $filename``;

    /* Set the endptr char point to the begnning of infile. */
    endptr = infile;

    /* Start the while loop that will look for the given macro. */
    while( (startMacro = strstr(endptr, macro)) != NULL )
    {
        number = 0;
        strncat(outfile, endptr, strlen(endptr)-strlen(startMacro));
        endptr = strstr(startMacro, "\n")+1;
        strncpy(rettype, startMacro, strlen(startMacro)-strlen(endptr)); 

        sameline = 1;
        while(sameline)
        {
        strcat(outfile, rettype);
        position = strstr(endptr, "(");
        number++;
        while(number)
        {
            position++;
            if(*position == '(')
                number++;
            if(*position == ')')
                number--;
        }
        position++;

        if(*position == ';')
            sameline = 0;

        stop = position;
        strncat(outfile, endptr, strlen(endptr)-strlen(stop));
        strcat(outfile, ";\n");
        endptr = strstr(stop, "\n")+1;
        }
    }

    strcat(outfile, endptr);
    fprintf(fptr_out, "%s", outfile);
    fclose(fptr_out);
    return 0;
}
