# DESCRIP.MMS: Make file for VMS using MMS or MMK
#
#
# Copyright 1996-2001 by
# David Turner, Robert Wilhelm, and Werner Lemberg.
#
# This file is part of the FreeType project, and may only be used, modified,
# and distributed under the terms of the FreeType project license,
# LICENSE.TXT.  By continuing to use, modify, or distribute this file you
# indicate that you have read the license and understand and accept it
# fully.
# Created by Jouk Jansen (joukj@hrem.stm.tudelft.nl)

ARCH = arch.unix

CC = cc/name=(as_is,short)/float=ieee

############### PORTABILITY COMPONENTS ########################

# location of memory component
MEMSRC = ttmemory.c

# location of file component
FILESRC = ttfile.c

# location of mutex component
MUTEXSRC = ttmutex.c

# location of default extensions
FTEXTDIR = [.lib.extend]

# default extensions sources
EXTSRC = $(FTEXTDIR)ftxkern.c  \
         $(FTEXTDIR)ftxgasp.c  \
         $(FTEXTDIR)ftxpost.c  \
         $(FTEXTDIR)ftxcmap.c  \
         $(FTEXTDIR)ftxsbit.c  \
         $(FTEXTDIR)ftxwidth.c \
         $(FTEXTDIR)ftxerr18.c \
         $(FTEXTDIR)ftxgsub.c  \
         $(FTEXTDIR)ftxgpos.c  \
         $(FTEXTDIR)ftxopen.c  \
         $(FTEXTDIR)ftxgdef.c

EXTOBJ = [.lib]ftxkern.obj,  \
         [.lib]ftxgasp.obj,  \
         [.lib]ftxpost.obj,  \
         [.lib]ftxcmap.obj,  \
         [.lib]ftxsbit.obj,  \
         [.lib]ftxwidth.obj, \
         [.lib]ftxerr18.obj, \
         [.lib]ftxgsub.obj,  \
         [.lib]ftxgpos.obj,  \
         [.lib]ftxopen.obj,  \
         [.lib]ftxgdef.obj

# all engine sources
SRC_M = [.lib]ttapi.c     \
        [.lib]ttcache.c   \
        [.lib]ttcalc.c    \
        [.lib]ttcmap.c    \
        [.lib]ttdebug.c   \
        [.lib]ttextend.c  \
        [.lib]ttgload.c   \
        [.lib]ttinterp.c  \
        [.lib]ttload.c    \
        [.lib]ttobjs.c    \
        [.lib]ttraster.c  \
        [.lib]$(FILESRC)  \
        [.lib]$(MEMSRC)   \
        [.lib]$(MUTEXSRC)
SRC_S = [.lib.$(ARCH)]freetype.c

# all header files with path
HEADERS = [.lib]freetype.h      \
          [.lib]fterrid.h       \
          [.lib]ftnameid.h      \
          $(FTEXTDIR)ftxkern.h  \
          $(FTEXTDIR)ftxgasp.h  \
          $(FTEXTDIR)ftxcmap.h  \
          $(FTEXTDIR)ftxsbit.h  \
          $(FTEXTDIR)ftxpost.h  \
          $(FTEXTDIR)ftxwidth.h \
          $(FTEXTDIR)ftxerr18.h \
          $(FTEXTDIR)ftxgsub.h  \
          $(FTEXTDIR)ftxgpos.h  \
          $(FTEXTDIR)ftxgdef.h  \
          $(FTEXTDIR)ftxopen.h

# all engine objects
OBJ_M = [.lib]ttapi.obj,    \
        [.lib]ttcache.obj,  \
        [.lib]ttcalc.obj,   \
        [.lib]ttcmap.obj,   \
        [.lib]ttdebug.obj,  \
        [.lib]ttextend.obj, \
        [.lib]ttgload.obj,  \
        [.lib]ttinterp.obj, \
        [.lib]ttload.obj,   \
        [.lib]ttobjs.obj,   \
        [.lib]ttraster.obj, \
        [.lib]file.obj,     \
        [.lib]memory.obj,   \
        [.lib]mutex.obj,    \
        $(EXTOBJ)
OBJ_S = [.lib]freetype.obj

DISPOBJS = [.test]common.obj,[.test]gmain.obj,[.test]display.obj,\
	[.test]gwin_x11.obj,[.test]blitter.obj

# include paths
INCLUDES = /include=([.lib],[],$(FTEXTDIR),[.test])

# C flags
CFLAGS = $(INCLUDES)/obj=[.lib]
CFLAGS_T = $(INCLUDES)/obj=[.test]

all : do_link [.lib]libttf.olb [.test]ftdump.exe [.test]fterror.exe\
	[.test]ftlint.exe [.test]ftmetric.exe [.test]ftsbit.exe\
	[.test]ftstrpnm.exe [.test]ftstring.exe [.test]ftstrtto.exe\
	[.test]fttimer.exe [.test]ftview.exe [.test]ftzoom.exe
	@ write sys$output "All done for freetype1"

do_link :
	if f$search( "[.lib]memory.c" ) .nes. "" then set file/remove [.lib]memory.c;
	if f$search( "[.lib]file.c" ) .nes. "" then set file/remove [.lib]file.c;
	if f$search( "[.lib]mutex.c" ) .nes. "" then set file/remove [.lib]mutex.c;
	if f$search( "[.lib]ft_conf.h" ) .nes. "" then set file/remove [.lib]ft_conf.h;
	set file/enter=[.lib]memory.c [.lib]$(MEMSRC)
	set file/enter=[.lib]file.c [.lib]$(FILESRC)
	set file/enter=[.lib]mutex.c [.lib]$(MUTEXSRC)
	set file/enter=[.lib]ft_conf.h [.lib.arch.vms]ft_conf.h

[.lib]ftxkern.obj : $(FTEXTDIR)ftxkern.c

[.lib]ftxgasp.obj : $(FTEXTDIR)ftxgasp.c

[.lib]ftxpost.obj : $(FTEXTDIR)ftxpost.c

[.lib]ftxcmap.obj : $(FTEXTDIR)ftxcmap.c

[.lib]ftxsbit.obj : $(FTEXTDIR)ftxsbit.c

[.lib]ftxwidth.obj : $(FTEXTDIR)ftxwidth.c

[.lib]ftxerr18.obj : $(FTEXTDIR)ftxerr18.c

[.lib]ftxgsub.obj : $(FTEXTDIR)ftxgsub.c

[.lib]ftxgpos.obj : $(FTEXTDIR)ftxgpos.c

[.lib]ftxgdef.obj : $(FTEXTDIR)ftxgdef.c

[.lib]ftxopen.obj : $(FTEXTDIR)ftxopen.c

[.lib]freetype.obj : $(SRC_S) $(SRC_M)

[.lib]file.obj : [.lib]file.c

[.lib]memory.obj : [.lib]memory.c

[.lib]mutex.obj : [.lib]mutex.c

[.lib]libttf.olb : $(OBJ_M)
	library/create [.lib]libttf.olb $(OBJ_M)
	library/compress [.lib]libttf.olb

[.test]gwin_x11.obj : [.test.arch.unix]gwin_x11.c
	$(CC) $(CFLAGS_T) [.test.arch.unix]gwin_x11.c

[.test]arabic.obj : [.test]arabic.c
	$(CC) $(CFLAGS_T) [.test]arabic.c

[.test]common.obj : [.test]common.c
	$(CC) $(CFLAGS_T) [.test]common.c

[.test]textdis.obj : [.test]textdis.c
	$(CC) $(CFLAGS_T) [.test]textdis.c

[.test]ftdump.obj : [.test]ftdump.c
	$(CC) $(CFLAGS_T) [.test]ftdump.c

[.test]fterror.obj : [.test]fterror.c
	$(CC) $(CFLAGS_T) [.test]fterror.c

[.test]ftlint.obj : [.test]ftlint.c
	$(CC) $(CFLAGS_T) [.test]ftlint.c

[.test]ftmetric.obj : [.test]ftmetric.c
	$(CC) $(CFLAGS_T) [.test]ftmetric.c

[.test]ftsbit.obj : [.test]ftsbit.c
	$(CC) $(CFLAGS_T) [.test]ftsbit.c

[.test]ftstring.obj : [.test]ftstring.c
	$(CC) $(CFLAGS_T) [.test]ftstring.c

[.test]ftstrpnm.obj : [.test]ftstrpnm.c
	$(CC) $(CFLAGS_T) [.test]ftstrpnm.c

[.test]fttimer.obj : [.test]fttimer.c
	$(CC) $(CFLAGS_T) [.test]fttimer.c

[.test]ftview.obj : [.test]ftview.c
	$(CC) $(CFLAGS_T) [.test]ftview.c

[.test]ftzoom.obj : [.test]ftzoom.c
	$(CC) $(CFLAGS_T) [.test]ftzoom.c

[.test]ftstrtto.obj : [.test]ftstrtto.c
	$(CC) $(CFLAGS_T) [.test]ftstrtto.c

[.test]gmain.obj : [.test]gmain.c
	$(CC) $(CFLAGS_T) [.test]gmain.c

[.test]textdisp.obj : [.test]textdisp.c
	$(CC) $(CFLAGS_T) [.test]textdisp.c

[.test]display.obj : [.test]display.c
	$(CC) $(CFLAGS_T) [.test]display.c

[.test]blitter.obj : [.test]blitter.c
	$(CC) $(CFLAGS_T) [.test]blitter.c

[.test]ftzoom.exe : [.test]ftzoom.obj $(DISPOBJS) [.lib]libttf.olb\
	[.test]vms.opt
	link/exec=[.test]ftzoom.exe [.test]ftzoom.obj,$(DISPOBJS),\
	[.lib]libttf.olb/lib,[.test]vms/opt

[.test]fttimer.exe : [.test]fttimer.obj $(DISPOBJS) [.lib]libttf.olb\
	[.test]vms.opt
	link/exec=[.test]fttimer.exe [.test]fttimer.obj,$(DISPOBJS),\
	[.lib]libttf.olb/lib,[.test]vms/opt

[.test]ftview.exe : [.test]ftview.obj $(DISPOBJS) [.lib]libttf.olb\
	[.test]vms.opt
	link/exec=[.test]ftview.exe [.test]ftview.obj,$(DISPOBJS),\
	[.lib]libttf.olb/lib,[.test]vms/opt

[.test]ftlint.exe : [.test]ftlint.obj [.test]common.obj [.lib]libttf.olb
	link/exec=[.test]ftlint.exe [.test]ftlint.obj,[.test]common.obj,\
	[.lib]libttf.olb/lib

[.test]ftdump.exe : [.test]ftdump.obj [.test]common.obj [.lib]libttf.olb
	link/exec=[.test]ftdump.exe [.test]ftdump.obj,[.test]common.obj,\
	[.lib]libttf.olb/lib

[.test]ftmetric.exe : [.test]ftmetric.obj [.test]common.obj\
	[.test]textdisp.obj [.lib]libttf.olb
	link/exec=[.test]ftmetric.exe [.test]ftmetric.obj,[.test]common.obj,\
	[.test]textdisp.obj,[.lib]libttf.olb/lib

[.test]ftsbit.exe : [.test]ftsbit.obj [.test]common.obj\
	[.test]textdisp.obj [.lib]libttf.olb
	link/exec=[.test]ftsbit.exe [.test]ftsbit.obj,[.test]common.obj,\
	[.test]textdisp.obj,[.lib]libttf.olb/lib

[.test]ftstring.exe : [.test]ftstring.obj $(DISPOBJS) [.lib]libttf.olb\
	[.test]vms.opt
	link/exec=[.test]ftstring.exe [.test]ftstring.obj,$(DISPOBJS),\
	[.lib]libttf.olb/lib,[.test]vms/opt

[.test]ftstrpnm.exe : [.test]ftstrpnm.obj [.test]common.obj [.lib]libttf.olb
	link/exec=[.test]ftstrpnm.exe [.test]ftstrpnm.obj,[.test]common.obj,\
	[.lib]libttf.olb/lib

[.test]fterror.exe : [.test]fterror.obj [.test]common.obj [.lib]libttf.olb
	link/exec=[.test]fterror.exe [.test]fterror.obj,[.test]common.obj,\
	[.lib]libttf.olb/lib

[.test]ftstrtto.exe : [.test]ftstrtto.obj $(DISPOBJS) [.test]arabic.obj\
	[.lib]libttf.olb [.test]vms.opt
	link/exec=[.test]ftstrtto.exe [.test]ftstrtto.obj,$(DISPOBJS),\
	[.test]arabic.obj,[.lib]libttf.olb/lib,[.test]vms/opt

clean :
	delete [.lib]*.obj;*
	delete [.lib]*.olb;*
	delete [.test]*.obj;*
	delete [.test]*.exe;*
	if f$search( "[.lib]memory.c" ) .nes. "" then set file/remove [.lib]memory.c;
	if f$search( "[.lib]file.c" ) .nes. "" then set file/remove [.lib]file.c;
	if f$search( "[.lib]mutex.c" ) .nes. "" then set file/remove [.lib]mutex.c;
	if f$search( "[.lib]ft_conf.h" ) .nes. "" then set file/remove [.lib]ft_conf.h;
