/*
 * newobj.c
 *
 * This file is part of the ttf2pk package.
 *
 * Copyright 1997-1998 by
 *    Frederic Loyer <loyer@ensta.fr>
 *    Werner Lemberg <a7971428@unet.univie.ac.at>
 */

#include <stdlib.h>

#include "ttf2tfm.h"
#include "errormsg.h"


char *
mymalloc(unsigned long len)
{
  register char *p;
  int i;


#ifdef SMALLMALLOC
  if (len > 65500L)
    oops("Can't allocate more than 64kByte");
#endif

  p = malloc((unsigned)len);
  if (p == NULL)
    oops("Out of memory");

  for (i = 0; i < len; i++)
    p[i] = '\0';
  return p;
}


char *
newstring(char *s)
{
  char *q = mymalloc((unsigned long)(strlen(s) + 1));
  (void)strcpy(q, s);
  return q;
}


struct ttfinfo *
newchar(struct Font *fnt)
{
  register struct ttfinfo *ti;


  ti = (struct ttfinfo *)mymalloc((unsigned long)sizeof (struct ttfinfo));
  ti->charcode = -1;
  ti->glyphindex = -1;
  ti->incode = -1;
  ti->outcode = -1;
  ti->width = -1;
  ti->adobename = NULL;
  ti->llx = -1;
  ti->lly = -1;
  ti->urx = -1;
  ti->ury = -1;
  ti->ligs = NULL;
  ti->kerns = NULL;
  ti->kern_equivs = NULL;
  ti->pccs = NULL;
  ti->next = fnt->charlist;
  fnt->charlist = ti;

  return ti;
}


struct kern *
newkern()
{
  register struct kern *nk;


  nk = (struct kern *)mymalloc((unsigned long)sizeof (struct kern));
  nk->next = NULL;
  nk->succ = NULL;
  nk->delta = 0;

  return nk;
}


struct pcc *
newpcc()
{
  register struct pcc *np;


  np = (struct pcc *)mymalloc((unsigned long)sizeof (struct pcc));
  np->next = NULL;
  np->partname = NULL;
  np->xoffset = 0;
  np->yoffset = 0;

  return np;
}


struct lig *
newlig()
{
  register struct lig *nl;


  nl = (struct lig *)mymalloc((unsigned long)sizeof (struct lig));
  nl->next = NULL;
  nl->succ = NULL;
  nl->sub = NULL;
  nl->op = 0;               /* the default =: op */
  nl->boundleft = 0;

  return nl;
}


/* end */
