/*
 *   ttflib.h
 *
 *   This file is part of the ttf2pk package.
 *
 *   Copyright 1997-1998 by
 *     Frederic Loyer <loyer@ensta.fr>
 *     Werner Lemberg <wl@gnu.org>
 */

#ifndef TTFLIB_H
#define TTFLIB_H

#include "pklib.h"      /* for the `byte' type */

void TTFopen(char *filename, int new_dpi, int new_ptsize, 
             int new_extend, int new_slant,
             long fontindex, int platform, int encoding,
             Boolean quiet);

Boolean TTFprocess(long Code, byte **bitmap,
                   int *width, int *height, int *hoff, int *voff,
                   Boolean hinting, Boolean quiet);

void TTFget_first_glyphs(long *array);
void TTFget_subfont(Font *fnt, long *array);

#endif /* TTFLIB_H */


/* end */
