/* This file has been generated by the Perl script `afblue.pl', */
/* using data from file `./tablue.dat'.                         */

/* tablue.h */

/*
 * Copyright (C) 2013-2016 by Werner Lemberg.
 *
 * This file is part of the ttfautohint library, and may only be used,
 * modified, and distributed under the terms given in `COPYING'.  By
 * continuing to use, modify, or distribute this file you indicate that you
 * have read `COPYING' and understand and accept it fully.
 *
 * The file `COPYING' mentioned in the previous paragraph is distributed
 * with the ttfautohint library.
 */


/* originally file `afblue.h' (2013-Sep-11) from FreeType */


#ifndef __TABLUE_H__
#define __TABLUE_H__


  /* an auxiliary macro to decode a UTF-8 character -- since we only use */
  /* hard-coded, self-converted data, no error checking is performed */
#define GET_UTF8_CHAR(ch, p) \
  do \
  { \
    ch = (unsigned char)*p++; \
    if (ch >= 0x80) \
    { \
      FT_UInt len_; \
\
\
      if (ch < 0xE0) \
      { \
        len_ = 1; \
        ch &= 0x1F; \
      } \
      else if (ch < 0xF0) \
      { \
        len_ = 2; \
        ch &= 0x0F; \
      } \
      else \
      { \
        len_ = 3;\
        ch &= 0x07; \
      } \
\
      for (; len_ > 0; len_--) \
        ch = (ch << 6) | (*p++ & 0x3F); \
    } \
  } while (0)


/****************************************************************
 *
 *                        BLUE STRINGS
 *
 ****************************************************************/

/* At the bottommost level, we define strings for finding blue zones. */


#define TA_BLUE_STRING_MAX_LEN 27

/* The TA_Blue_String enumeration values are offsets into the */
/* `ta_blue_strings' array. */

typedef enum TA_Blue_String_
{
    TA_BLUE_STRING_ARABIC_TOP = 0,
    TA_BLUE_STRING_ARABIC_BOTTOM = 18,
    TA_BLUE_STRING_ARABIC_JOIN = 33,
    TA_BLUE_STRING_BENGALI_BASE = 36,
    TA_BLUE_STRING_BENGALI_TOP = 68,
    TA_BLUE_STRING_BENGALI_HEAD = 96,
    TA_BLUE_STRING_CYRILLIC_CAPITAL_TOP = 128,
    TA_BLUE_STRING_CYRILLIC_CAPITAL_BOTTOM = 152,
    TA_BLUE_STRING_CYRILLIC_SMALL = 176,
    TA_BLUE_STRING_CYRILLIC_SMALL_DESCENDER = 200,
    TA_BLUE_STRING_DEVANAGARI_BASE = 209,
    TA_BLUE_STRING_DEVANAGARI_TOP = 241,
    TA_BLUE_STRING_DEVANAGARI_HEAD = 273,
    TA_BLUE_STRING_DEVANAGARI_BOTTOM = 305,
    TA_BLUE_STRING_GREEK_CAPITAL_TOP = 313,
    TA_BLUE_STRING_GREEK_CAPITAL_BOTTOM = 334,
    TA_BLUE_STRING_GREEK_SMALL_BETA_TOP = 352,
    TA_BLUE_STRING_GREEK_SMALL = 370,
    TA_BLUE_STRING_GREEK_SMALL_DESCENDER = 394,
    TA_BLUE_STRING_HEBREW_TOP = 418,
    TA_BLUE_STRING_HEBREW_BOTTOM = 442,
    TA_BLUE_STRING_HEBREW_DESCENDER = 460,
    TA_BLUE_STRING_KHMER_TOP = 475,
    TA_BLUE_STRING_KHMER_SUBSCRIPT_TOP = 499,
    TA_BLUE_STRING_KHMER_BOTTOM = 539,
    TA_BLUE_STRING_KHMER_DESCENDER = 571,
    TA_BLUE_STRING_KHMER_LARGE_DESCENDER = 605,
    TA_BLUE_STRING_KHMER_SYMBOLS_WAXING_TOP = 692,
    TA_BLUE_STRING_KHMER_SYMBOLS_WANING_BOTTOM = 700,
    TA_BLUE_STRING_LAO_TOP = 708,
    TA_BLUE_STRING_LAO_BOTTOM = 740,
    TA_BLUE_STRING_LAO_ASCENDER = 772,
    TA_BLUE_STRING_LAO_LARGE_ASCENDER = 788,
    TA_BLUE_STRING_LAO_DESCENDER = 800,
    TA_BLUE_STRING_LATIN_CAPITAL_TOP = 824,
    TA_BLUE_STRING_LATIN_CAPITAL_BOTTOM = 840,
    TA_BLUE_STRING_LATIN_SMALL_F_TOP = 856,
    TA_BLUE_STRING_LATIN_SMALL = 870,
    TA_BLUE_STRING_LATIN_SMALL_DESCENDER = 884,
    TA_BLUE_STRING_LATIN_SUBS_CAPITAL_TOP = 894,
    TA_BLUE_STRING_LATIN_SUBS_CAPITAL_BOTTOM = 914,
    TA_BLUE_STRING_LATIN_SUBS_SMALL_F_TOP = 934,
    TA_BLUE_STRING_LATIN_SUBS_SMALL = 954,
    TA_BLUE_STRING_LATIN_SUBS_SMALL_DESCENDER = 990,
    TA_BLUE_STRING_LATIN_SUPS_CAPITAL_TOP = 1010,
    TA_BLUE_STRING_LATIN_SUPS_CAPITAL_BOTTOM = 1041,
    TA_BLUE_STRING_LATIN_SUPS_SMALL_F_TOP = 1070,
    TA_BLUE_STRING_LATIN_SUPS_SMALL = 1096,
    TA_BLUE_STRING_LATIN_SUPS_SMALL_DESCENDER = 1121,
    TA_BLUE_STRING_MYANMAR_TOP = 1132,
    TA_BLUE_STRING_MYANMAR_BOTTOM = 1164,
    TA_BLUE_STRING_MYANMAR_ASCENDER = 1196,
    TA_BLUE_STRING_MYANMAR_DESCENDER = 1224,
    TA_BLUE_STRING_TELUGU_TOP = 1256,
    TA_BLUE_STRING_TELUGU_BOTTOM = 1284,
    TA_BLUE_STRING_THAI_TOP = 1312,
    TA_BLUE_STRING_THAI_BOTTOM = 1336,
    TA_BLUE_STRING_THAI_ASCENDER = 1364,
    TA_BLUE_STRING_THAI_LARGE_ASCENDER = 1376,
    TA_BLUE_STRING_THAI_DESCENDER = 1388,
    TA_BLUE_STRING_THAI_LARGE_DESCENDER = 1404,
    TA_BLUE_STRING_THAI_DIGIT_TOP = 1412,


  TA_BLUE_STRING_MAX   /* do not remove */
} TA_Blue_String;


extern const char ta_blue_strings[];


/****************************************************************
 *
 *                      BLUE STRINGSETS
 *
 ****************************************************************/

/* The next level is to group blue strings into style-specific sets. */


/* Properties are specific to a writing system.  We assume that a given */
/* blue string can't be used in more than a single writing system, which */
/* is a safe bet. */
#define TA_BLUE_PROPERTY_LATIN_TOP (1U << 0) /* must have value 1 */
#define TA_BLUE_PROPERTY_LATIN_SUB_TOP (1U << 1)
#define TA_BLUE_PROPERTY_LATIN_NEUTRAL (1U << 2)
#define TA_BLUE_PROPERTY_LATIN_X_HEIGHT (1U << 3)
#define TA_BLUE_PROPERTY_LATIN_LONG (1U << 4)


#define TA_BLUE_STRINGSET_MAX_LEN 8

/* The TA_Blue_Stringset enumeration values are offsets into the */
/* `ta_blue_stringsets' array. */

typedef enum TA_Blue_Stringset_
{
    TA_BLUE_STRINGSET_ARAB = 0,
    TA_BLUE_STRINGSET_BENG = 4,
    TA_BLUE_STRINGSET_CYRL = 9,
    TA_BLUE_STRINGSET_DEVA = 15,
    TA_BLUE_STRINGSET_GREK = 21,
    TA_BLUE_STRINGSET_HEBR = 28,
    TA_BLUE_STRINGSET_KHMR = 32,
    TA_BLUE_STRINGSET_KHMS = 38,
    TA_BLUE_STRINGSET_LAO = 41,
    TA_BLUE_STRINGSET_LATN = 47,
    TA_BLUE_STRINGSET_LATB = 54,
    TA_BLUE_STRINGSET_LATP = 61,
    TA_BLUE_STRINGSET_MYMR = 68,
    TA_BLUE_STRINGSET_TELU = 73,
    TA_BLUE_STRINGSET_THAI = 76,


  TA_BLUE_STRINGSET_MAX   /* do not remove */
} TA_Blue_Stringset;


typedef struct TA_Blue_StringRec_
{
  TA_Blue_String string;
  FT_UShort properties;
} TA_Blue_StringRec;


extern const TA_Blue_StringRec ta_blue_stringsets[];

#endif /* __TABLUE_H__ */

/* end of tablue.h */
