const
(* These values can be changed, but WIN_WIDTH should remain for now a  *)
(* multiple of 32 to avoid padding issues.                             *)

  WIN_WIDTH   = 640;
{$IFDEF WIN32}
  WIN_HEIGHT  = 450;
{$ELSE}
  WIN_HEIGHT  = 400;
(* The values will be divided by 2 for gray-scale rendering.           *)

(* Also, to avoid 16-bit overflowing issues, the product               *)
(* WIN_WIDTH * WIN_HEIGHT should not excess 512K for monochrome        *)
(* rendering, and 256K for gray-scale rendering.                       *)
{$ENDIF}

{$IFNDEF WIN32}
   NameOfClassWin = 'FreeTypeTestGraphicDriver16';
{$ELSE}
   NameOfClassWin = 'FreeTypeTestGraphicDriver32';
{$ENDIF}

var
  (* handle of the window. *)
  hwndGraphic : HWND;

  (* bitmap information *)
  pbmi : PBITMAPINFO;
  hbm  : HBITMAP;

  (* Declarations of the Windows-specific functions that are below. *)
  function RegisterTheClass : Boolean; forward;
  function CreateTheWindow ( width, height : Integer ) : Boolean; forward;

  procedure Free_pbmi;
  begin
    if pbmi <> nil then
      FreeMem ( pbmi, sizeof ( TBITMAPINFOHEADER ) + sizeof ( TRGBQUAD ) * 256  );
    pbmi := nil;
  end;


  { Restores screen to the original state }

  function Driver_Restore_Mode: boolean;
  begin
    (* The graphical window has perhaps already destroyed itself *)
    if hwndGraphic <> 0 then begin
      DestroyWindow ( hwndGraphic );
      PostMessage ( hwndGraphic, WM_QUIT, 0, 0 );
    end;

    Free_pbmi;

    Driver_Restore_Mode := True;
  end;


  { set graphics mode and create the window class and the message handling. }

  function Driver_Set_Graphics( mode : Int ) : boolean;
  var
    i : Integer;
  const
    gray_scale : array [0..4] of TRGBQUAD = (
      (rgbBlue: $FF; rgbGreen: $FF; rgbRed: $FF; rgbReserved:0), (* white *)
      (rgbBlue: $C0; rgbGreen: $C0; rgbRed: $C0; rgbReserved:0),
      (rgbBlue: $80; rgbGreen: $80; rgbRed: $80; rgbReserved:0),
      (rgbBlue: $40; rgbGreen: $40; rgbRed: $40; rgbReserved:0),
      (rgbBlue: $00; rgbGreen: $00; rgbRed: $00; rgbReserved:0));(* black *)
  begin
    Driver_Set_Graphics := False;

    if not RegisterTheClass then Exit;  (* if already running, fails. *)

    (* find some memory for the bitmap header *)
    GetMem( pbmi, sizeof ( TBITMAPINFOHEADER ) + sizeof ( TRGBQUAD ) * 256 );
    if pbmi = nil then Exit;     (* lack of memory; fails the process *)

    (* initialize the header to appropriate values *)
    FillChar( pbmi^,
          sizeof ( TBITMAPINFOHEADER ) + sizeof ( TRGBQUAD ) * 256, 0 );

    case Mode of

      Graphics_Mode_Mono : begin
                             pbmi^.bmiHeader.biBitCount := 1;
               (* The "normal" code used to be
                             pbmi^.bmiColors[1] := gray_scale[4];
                  but unfortunately, Borland's guys did declare
                       bmiColors: array[0..0] of TRGBQuad;
                  in tBitmapInfo, so the second line refuse to compile :-(.
                  So we have to use a nasty hack to get the job done *)
                             Move ( gray_scale[3], pbmi^.bmiColors,
                                          2 * sizeof(gray_scale[1]) );
                               { copy [3] to [0] and [4] to [1] }
                             pbmi^.bmiColors[0] := gray_scale[0];
                               { erase the previous [0]. Yes this is nasty. }

                             Vio_ScanLineWidth := WIN_WIDTH div 8;
                             Vio_Width         := WIN_WIDTH;
                             Vio_Height        := WIN_HEIGHT;
                           end;

      Graphics_Mode_Gray : begin
                             pbmi^.bmiHeader.biBitCount := 8;
                             pbmi^.bmiHeader.biClrUsed  := 5;
                             Move ( gray_scale, pbmi^.bmiColors,
                                          sizeof(gray_scale) );

                             Vio_ScanLineWidth := WIN_WIDTH  div 2;
                             Vio_Width         := WIN_WIDTH  div 2;
                             Vio_Height        := WIN_HEIGHT div 2;

                             for i := 0 to 4 do
                               gray_palette[i] := i;

                           end;
    else
      Free_pbmi;
      Exit;
    end;

{$IFNDEF WIN32}
    if Vio_Height * Vio_ScanLineWidth > $FFE0 then begin
        (* too big to work on 16-bit; fails the process *)
      Free_pbmi;
      Exit;
    end;
{$ENDIF}

    pbmi^.bmiHeader.biSize   := sizeof ( TBITMAPINFOHEADER );
    pbmi^.bmiHeader.biWidth  := Vio_Width;
    pbmi^.bmiHeader.biHeight := Vio_Height;
    pbmi^.bmiHeader.biPlanes := 1;

    if not CreateTheWindow ( vio_Width, vio_Height ) then begin
      Free_pbmi;
      Exit;
    end;

    (* success even if the window was not built. *)
    Driver_Set_Graphics := True;
  end;


  procedure Driver_Display_Bitmap ( var buff; line, col : Int );
  var DC : HDC;
  begin
    if col * 8 <> pbmi^.bmiHeader.biWidth * pbmi^.bmiHeader.biBitCount then
      pbmi^.bmiHeader.biWidth  := col * 8 div pbmi^.bmiHeader.biBitCount;

    DC := GetDC ( hwndGraphic );
    SetDIBits ( DC, hbm, 0, line, @buff, pbmi^, DIB_RGB_COLORS );
    ReleaseDC ( hwndGraphic, DC );

    ShowWindow( hwndGraphic, SW_SHOW );
    InvalidateRect ( hwndGraphic, nil, FALSE );  (* XXX pb with FPC *)
    UpdateWindow ( hwndGraphic );
  end;


(* ---- Windows-specific stuff ------------------------------------------- *)

  function Message_Process( handle : HWND; mess : Word;
               wParam : Word; lParam : Longint): Longint; export; forward;

  function RegisterTheClass : Boolean;
  const ourClass : TWNDCLASS  = (
      style: 0;
      lpfnWndProc: @Message_Process;  (* XXX pb with FPC *)
      cbClsExtra: 0;
      cbWndExtra: 0;
      hInstance: 0;
      hIcon: 0;
      hCursor: 0;
      hbrBackground: 0;
      lpszMenuName: nil;
      lpszClassName: NameOfClassWin);
  begin
{$IFNDEF WIN32}
    if hPrevInst <> 0 then begin
      (* There is another instance of the same program. *)
      (* No need to register the class.                 *)
        RegisterTheClass := True;
        Exit;
    end;
{$ENDIF}

    ourClass.hInstance    := hInstance;
    ourClass.hIcon        := LoadIcon(0, IDI_APPLICATION);
    ourClass.hCursor      := LoadCursor(0, IDC_ARROW);
    ourClass.hbrBackground:= GetStockObject(BLACK_BRUSH);

    RegisterTheClass := Longint(RegisterClass(ourClass)) <> 0;
  end;


  function CreateTheWindow ( width, height : Integer ) : Boolean;
  begin
    hwndGraphic := CreateWindow(
        (* LPCSTR lpszClassName;    *)  NameOfClassWin,
        (* LPCSTR lpszWindowName;   *) 'FreeType Test Graphic Driver',
        (* DWORD dwStyle;           *)  WS_OVERLAPPED or WS_SYSMENU,
        (* int x;                   *)  CW_USEDEFAULT,
        (* int y;                   *)  CW_USEDEFAULT,
        (* int nWidth;              *)  width + 2*GetSystemMetrics(SM_CXBORDER),
        (* int nHeight;             *)  height+ GetSystemMetrics(SM_CYBORDER)
                                              + GetSystemMetrics(SM_CYCAPTION),
        (* HWND hwndParent;         *)  0 {HWND_DESKTOP},
        (* HMENU hmenu;             *)  0,
        (* HINSTANCE hinst;         *)  hInstance,
        (* void FAR* lpvParam;      *)  nil);

    CreateTheWindow := hwndGraphic <> 0;
  end;


  (* We have our own process of event creation. *)
{$DEFINE HAVE_OUREVENT}
const
  eventToProcess : Boolean = False;
var
  ourevent       : Event;

  procedure Process_Key( var ev : Event; c : Char ); forward;


  (* Message processing for our Windows class *)
  function Message_Process( handle : HWND; mess : Word;
               wParam : Word; lParam : Longint): Longint; (*export;*)
  var DC, memDC : hDC;
      oldbm     : THANDLE;
      ps        : TPAINTSTRUCT;
  begin
    Message_Process := 0;

    case mess of

    WM_DESTROY:
      begin
        (* warn the main thread to quit if it didn't know *)
        ourevent.what := event_Quit;
        ourevent.info := 0;
        eventToProcess := True;
        hwndGraphic := 0;
        PostQuitMessage ( 0 );
        DeleteObject ( hbm );
      end;

    WM_CREATE:
      begin
        DC := GetDC ( handle );
        hbm := CreateDIBitmap (
          (* HDC hdc;     handle of device context        *) DC,
          (* BITMAPINFOHEADER FAR* lpbmih;  addr.of header*) pbmi^.bmiHeader,
          (* DWORD dwInit;  CBM_INIT to initialize bitmap *) 0,
          (* const void FAR* lpvBits;   address of values *) nil,
          (* BITMAPINFO FAR* lpbmi;   addr.of bitmap data *) pbmi^,
          (* UINT fnColorUse;      RGB or palette indices *) DIB_RGB_COLORS);
        ReleaseDC ( handle, DC );
      end;

    WM_PAINT:
      begin
        DC := BeginPaint ( handle, ps );
        memDC := CreateCompatibleDC ( DC );
        oldbm := SelectObject ( memDC, hbm );
        BitBlt ( DC, 0, 0, vio_Width, vio_Height, memDC, 0, 0, SRCCOPY);
        ReleaseDC ( handle, DC );
        SelectObject ( memDC, oldbm );
        DeleteObject ( memDC );
        EndPaint ( handle, ps );
      end;

    WM_KEYDOWN:
      begin
        case wParam of
        VK_ESCAPE:
          begin
            ourevent.what := event_Quit;
            ourevent.info := 0;
            eventToProcess := True;
          end;
        VK_F1:            (*  bring up help and about dialog window *)
          begin
          end;
        end;
      end;

    WM_CHAR:
      begin
        Process_Key( ourevent, Chr(wParam) );
        eventToProcess := True;
      end;
    else
       Message_Process := DefWindowProc( handle, mess, wParam, lParam );
    end;
  end;


  procedure MessageLoop;
    var msg : TMsg;
  begin
    if (hwndGraphic <> 0) and (Header <> '') then
    begin
      if Header[Length(Header)] <> #0 then
        Header := Header + #0;     (* append a trailing NULL *)
      SetWindowText( hwndGraphic, @Header[1] );
    end;

    while not eventToProcess do
    begin
      while PeekMessage( msg, 0, 0, 0, PM_REMOVE ) do  (* XXX pb with FPC *)
      begin
        TranslateMessage( msg );
        DispatchMessage ( msg );
      end;
      if not eventToProcess then
        WaitMessage;
    end;
    eventToProcess := False;
  end;

(* end of gdrv_win.inc *)
