/*
 *  VideoRGB plug-in v1.0 by Adam D. Moss, adam@foxbox.org.  1997/3/3
 */

/* The GIMP -- an image manipulation program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "config.h"

#include <libgimp/gimp.h>
#include <libgimp/gimpui.h>

#include "libgimp/stdplugins-intl.h"


#define MAX_PATTERNS 9

#define MAX_PATTERN_SIZE 108

const gint   pattern_width[MAX_PATTERNS] = { 2, 4, 1, 1, 2, 3, 6, 6, 5 };
const gint   pattern_height[MAX_PATTERNS] = { 6, 12, 3, 6, 12, 3, 6, 18, 15 };
const gchar *pattern_name[MAX_PATTERNS] =
{
  N_("_Staggered"),
  N_("_Large staggered"),
  N_("S_triped"),
  N_("_Wide-striped"),
  N_("Lo_ng-staggered"),
  N_("_3x3"),
  N_("Larg_e 3x3"),
  N_("_Hex"),
  N_("_Dots")
};

const gint pattern[MAX_PATTERNS][MAX_PATTERN_SIZE] =
{
  {
    0, 1,
    0, 2,
    1, 2,
    1, 0,
    2, 0,
    2, 1,
  },
  {
    0, 0, 1, 1,
    0, 0, 1, 1,
    0, 0, 2, 2,
    0, 0, 2, 2,
    1, 1, 2, 2,
    1, 1, 2, 2,
    1, 1, 0, 0,
    1, 1, 0, 0,
    2, 2, 0, 0,
    2, 2, 0, 0,
    2, 2, 1, 1,
    2, 2, 1, 1,
  },
  {
    0,
    1,
    2,
  },
  {
    0,
    0,
    1,
    1,
    2,
    2,
  },
  {
    0, 1,
    0, 1,
    0, 2,
    0, 2,
    1, 2,
    1, 2,
    1, 0,
    1, 0,
    2, 0,
    2, 0,
    2, 1,
    2, 1,
  },
  {
    0, 1, 2,
    2, 0, 1,
    1, 2, 0,
  },
  {
    0, 0, 1, 1, 2, 2,
    0, 0, 1, 1, 2, 2,
    2, 2, 0, 0, 1, 1,
    2, 2, 0, 0, 1, 1,
    1, 1, 2, 2, 0, 0,
    1, 1, 2, 2, 0, 0,
  },
  {
    2, 2, 0, 0, 0, 0,
    2, 2, 2, 0, 0, 2,
    2, 2, 2, 2, 2, 2,
    2, 2, 2, 1, 1, 2,
    2, 2, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1,
    0, 0, 1, 1, 1, 1,
    0, 0, 0, 1, 1, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 2, 2, 0,
    0, 0, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2,
    1, 1, 2, 2, 2, 2,
    1, 1, 1, 2, 2, 1,
    1, 1, 1, 1, 1, 1,
    1, 1, 1, 0, 0, 1,
    1, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
  },
  {
    0, 1, 2, 0, 0,
    1, 1, 1, 2, 0,
    0, 1, 2, 2, 2,
    0, 0, 1, 2, 0,
    0, 1, 1, 1, 2,
    2, 0, 1, 2, 2,
    0, 0, 0, 1, 2,
    2, 0, 1, 1, 1,
    2, 2, 0, 1, 2,
    2, 0, 0, 0, 1,
    1, 2, 0, 1, 1,
    2, 2, 2, 0, 1,
    1, 2, 0, 0, 0,
    1, 1, 2, 0, 1,
    1, 2, 2, 2, 0,
  }
};


#define PREVIEW_WIDTH  100
#define PREVIEW_HEIGHT 100

/* The raw preview image */
const guchar preview_raw[3 * PREVIEW_WIDTH * PREVIEW_HEIGHT] =
{
223,233,242,223,233,242,219,229,238,220,230,239,224,234,243,225,235,244,225,
235,244,226,236,245,226,232,243,228,234,245,227,233,244,226,231,242,230,236,
247,228,234,245,228,234,245,227,233,244,228,234,245,232,238,249,232,238,249,
228,234,245,232,238,249,231,237,248,230,236,247,230,236,247,227,233,244,230,
236,247,231,237,248,231,237,248,228,234,245,222,228,238,209,216,227,204,209,
219,196,197,202,181,180,180,169,161,154,159,145,129,159,140,118,163,139,115,
159,133,107,154,126,102,145,119,93,139,112,85,145,115,85,140,108,77,139,
107,74,128,100,70,123,100,71,123,95,68,128,95,68,135,102,75,142,111,
81,144,114,81,142,114,79,141,114,75,139,113,73,141,109,72,141,107,74,
138,110,82,144,124,101,148,132,113,146,129,107,147,126,102,140,113,86,133,
105,74,132,103,69,130,103,71,135,107,79,134,108,82,140,113,90,145,120,
98,150,124,104,150,127,107,150,130,110,157,138,118,157,140,121,162,148,130,
168,158,140,170,163,145,178,173,155,193,185,168,212,199,185,220,208,196,226,
217,208,233,225,217,241,236,232,239,236,235,242,240,240,251,249,251,253,250,
255,252,250,255,251,250,255,250,250,255,248,248,255,248,248,255,245,247,255,
245,245,255,245,245,255,245,245,255,245,245,255,245,245,255,220,229,239,222,
231,241,222,231,241,222,231,241,222,231,241,222,231,241,220,229,239,226,232,
242,226,232,243,227,233,244,230,235,247,228,233,242,233,237,247,234,238,248,
231,236,245,230,235,247,231,238,248,231,238,248,228,234,245,227,234,244,228,
234,245,230,237,247,226,233,243,232,238,249,230,235,247,228,233,245,228,235,
247,230,238,249,229,235,248,219,226,237,211,217,226,198,203,210,184,184,184,
175,170,167,166,154,145,163,144,128,160,136,112,163,137,111,156,127,103,148,
118,95,145,117,90,140,113,86,142,111,84,140,108,77,135,102,72,127,97,
67,126,95,65,125,95,65,130,99,69,133,102,71,136,104,71,139,109,74,
140,110,73,141,113,74,140,112,70,139,107,69,136,105,70,133,104,74,136,
112,83,141,120,94,142,121,96,139,117,91,128,102,76,127,100,67,122,94,
59,123,96,63,126,101,71,133,107,82,138,115,92,139,117,96,148,125,107,
150,128,111,147,126,108,151,132,114,153,137,120,153,138,121,153,143,126,162,
155,138,171,165,149,186,178,162,199,191,178,211,203,193,221,213,204,232,226,
221,239,232,230,241,234,234,245,241,242,244,241,245,245,245,249,246,246,251,
245,245,249,250,250,255,250,250,255,250,250,255,248,249,255,245,245,255,245,
245,255,245,245,255,245,245,255,245,245,255,225,230,241,225,230,241,225,230,
241,225,230,241,226,232,243,226,232,243,225,230,241,227,233,244,228,232,242,
230,234,244,231,235,245,230,234,244,233,237,247,234,238,248,231,235,245,234,
238,248,226,233,242,230,237,247,230,237,247,227,235,244,228,236,245,227,235,
244,231,238,248,227,235,244,233,235,245,231,236,248,230,237,250,225,234,249,
215,225,238,208,217,226,202,208,214,185,189,192,175,175,174,171,165,160,165,
152,141,163,141,124,154,128,107,157,127,103,151,121,97,146,117,94,142,112,
87,140,109,83,138,107,81,133,101,74,133,99,71,135,100,71,133,97,67,
130,97,65,130,98,67,135,104,71,138,107,72,135,103,68,136,105,67,138,
107,67,139,108,67,136,105,67,130,102,67,126,97,63,129,99,69,134,106,
77,134,108,80,128,102,76,119,94,70,116,91,60,111,84,50,114,88,55,
108,85,56,123,99,74,132,111,89,133,112,95,138,119,104,144,123,107,144,
123,107,141,123,106,142,126,110,144,131,116,144,134,119,150,142,128,156,150,
136,168,163,150,177,173,162,200,195,186,211,207,201,225,220,216,235,228,228,
238,234,235,247,243,245,243,241,245,245,246,250,248,249,253,246,247,251,250,
251,255,250,251,255,250,251,255,250,251,255,245,245,255,245,245,255,245,245,
255,245,245,255,245,245,255,223,228,239,223,228,239,225,230,241,226,231,242,
226,231,242,226,232,243,226,231,242,228,234,245,227,231,241,233,237,247,228,
232,242,231,235,245,231,235,245,234,238,248,230,234,244,233,237,247,230,235,
244,231,237,245,231,237,245,230,236,244,236,241,251,234,238,248,234,238,248,
229,234,243,229,233,243,231,236,248,229,236,248,220,228,241,217,226,235,203,
208,215,187,189,192,168,169,169,168,166,162,169,161,153,164,151,138,160,140,
124,159,134,113,150,122,99,142,114,91,135,108,86,139,110,84,138,108,82,
133,103,78,130,98,71,125,92,64,127,93,64,132,99,68,134,102,70,132,
100,69,135,104,71,138,107,72,135,104,69,134,103,66,134,103,66,135,104,
65,134,103,67,125,97,62,123,95,62,120,93,62,114,86,57,115,88,61,
111,86,62,104,80,57,103,80,52,102,77,47,103,79,51,107,84,57,119,
98,73,122,103,80,129,112,92,134,117,98,136,118,100,141,120,103,145,127,
111,142,125,111,134,123,109,127,119,106,129,122,109,138,133,122,150,148,137,
159,159,150,188,188,181,201,201,195,217,215,213,229,227,227,235,235,235,243,
242,244,245,245,249,244,244,248,248,249,253,250,251,255,249,250,254,250,251,
255,250,251,255,250,251,255,245,245,255,245,245,255,245,245,255,245,245,255,
245,245,255,222,228,238,223,228,239,225,230,241,226,232,243,225,230,241,226,
232,243,226,231,242,230,236,247,228,232,242,230,234,244,231,235,245,230,234,
244,230,234,244,233,237,247,230,234,244,231,235,245,233,237,247,230,234,244,
230,234,244,230,234,244,235,240,250,234,238,248,235,240,250,235,239,249,233,
237,247,228,234,245,222,230,241,214,221,232,202,209,217,190,192,195,171,171,
171,163,160,157,162,155,146,160,151,140,159,144,129,159,138,121,152,130,108,
142,117,96,140,114,93,132,106,84,130,103,76,129,100,74,125,96,70,122,
92,64,127,97,67,130,98,67,136,103,71,140,108,76,135,103,72,134,102,
70,135,104,69,133,102,67,133,102,67,136,105,71,135,103,68,128,99,64,
123,95,61,120,91,59,113,84,55,107,80,53,109,83,58,111,86,62,104,
80,58,98,74,51,102,78,53,99,75,52,99,78,55,102,84,61,104,89,
66,116,101,79,120,105,83,133,117,98,134,116,101,135,118,104,126,112,99,
115,105,94,110,103,93,114,109,101,125,122,114,145,145,137,161,163,157,185,
187,182,199,201,197,218,218,218,231,231,231,236,238,238,243,244,247,245,245,
249,245,246,250,249,250,254,250,251,255,249,250,254,250,251,255,250,251,255,
250,251,255,245,245,255,245,245,255,245,245,255,245,245,255,245,245,255,222,
228,238,223,228,239,223,228,239,225,230,241,226,231,242,226,232,243,226,232,
243,227,233,244,231,235,245,231,235,245,233,237,247,233,237,247,230,234,244,
235,239,249,231,235,245,233,237,247,229,232,243,235,238,247,235,238,247,230,
233,244,237,240,249,238,241,250,243,246,255,235,240,250,232,238,249,225,230,
241,220,227,236,210,215,223,192,195,199,176,175,175,158,151,146,152,144,136,
157,141,129,156,141,127,154,137,121,154,137,119,144,124,104,138,117,96,129,
106,86,126,101,79,132,105,78,123,97,71,121,94,67,122,94,66,123,93,
63,134,103,72,138,106,74,136,104,71,135,104,71,132,100,68,132,99,66,
128,96,64,133,101,68,140,108,75,136,104,71,128,97,64,119,91,59,109,
81,51,105,78,51,103,76,50,102,77,53,102,78,55,101,76,55,92,69,
47,91,69,48,89,69,48,89,71,50,87,72,52,91,77,56,101,88,67,
98,86,65,114,99,81,115,98,84,116,101,89,113,101,90,107,99,90,109,
104,98,114,112,107,132,130,126,150,150,147,169,172,170,192,195,193,208,210,
210,220,223,224,232,235,236,236,239,243,244,246,248,244,245,248,246,247,251,
249,250,254,250,251,255,250,251,255,250,251,255,250,251,255,250,251,255,245,
245,255,245,245,255,245,245,255,245,245,255,245,245,255,222,228,238,223,228,
239,223,228,239,225,230,241,228,234,245,226,231,242,225,230,241,232,238,249,
228,232,242,230,234,244,229,233,243,233,237,247,233,237,247,230,234,244,234,
238,248,231,235,245,236,238,248,236,237,248,237,238,249,238,239,250,242,243,
254,243,244,255,243,244,255,242,244,254,232,238,249,218,226,236,209,218,227,
190,196,202,172,172,172,158,153,149,142,133,123,140,127,114,139,121,103,145,
127,108,139,124,105,136,120,102,129,112,93,133,115,94,120,100,80,120,98,
76,122,97,71,119,93,67,116,89,63,119,92,64,123,94,64,132,101,70,
138,107,75,135,104,71,133,102,67,130,99,65,129,97,65,130,98,67,132,
100,69,135,103,72,136,105,74,129,98,68,119,90,60,108,79,51,97,70,
44,95,68,44,109,82,59,104,80,58,98,74,54,91,70,49,83,65,44,
78,61,41,75,60,41,72,60,41,71,59,42,78,67,51,78,67,51,87,
74,61,95,81,69,90,79,68,102,92,84,119,111,106,135,131,127,138,137,
136,156,156,156,175,176,178,196,200,204,211,214,217,225,228,231,228,231,235,
234,237,241,240,243,247,243,246,250,246,248,251,249,250,254,248,249,253,248,
249,253,250,251,255,248,249,253,246,247,251,249,250,254,245,245,255,245,245,
255,245,245,255,245,245,255,245,245,255,222,228,238,225,230,241,226,232,243,
227,233,244,222,228,238,231,237,248,227,233,244,228,234,245,230,234,244,233,
237,247,233,237,247,231,235,245,235,240,250,234,238,248,233,237,247,235,240,
250,238,238,250,241,241,253,245,245,255,245,245,255,245,245,255,245,245,255,
241,241,253,242,243,254,228,236,247,215,223,233,200,206,214,176,181,183,157,
156,154,146,138,130,134,118,106,132,114,96,130,108,86,128,109,86,122,106,
86,127,111,93,133,118,100,129,114,95,117,100,79,119,100,77,115,91,65,
116,91,64,114,89,63,117,93,63,121,92,63,127,98,67,130,101,69,134,
102,70,133,102,67,130,99,65,130,98,65,129,98,68,126,95,65,134,101,
74,138,105,79,125,95,65,119,90,60,111,83,55,102,75,48,96,71,46,
97,72,49,97,72,52,91,68,49,80,62,40,73,56,35,69,55,35,66,
54,35,63,51,35,65,55,41,67,58,46,68,60,49,68,59,47,78,67,
56,85,75,65,115,107,99,146,141,138,164,161,161,163,163,164,181,182,186,
207,208,213,223,224,232,229,229,236,238,238,245,238,238,245,240,240,247,241,
242,251,244,244,251,245,246,250,248,249,253,246,247,251,248,249,253,249,250,
254,248,249,253,246,247,251,250,251,255,245,245,255,245,245,255,245,245,255,
245,245,255,245,245,255,226,231,242,226,232,243,227,233,244,227,233,244,227,
233,244,228,234,245,230,236,247,223,228,239,217,220,230,224,228,238,235,240,
250,235,240,250,234,238,248,238,242,253,235,240,250,239,243,254,245,245,255,
245,245,255,245,245,255,245,245,255,245,245,255,245,245,255,244,244,254,239,
240,251,219,228,237,207,216,225,186,193,200,165,166,168,140,138,135,132,122,
113,119,103,87,120,98,77,121,96,71,119,98,73,116,99,77,123,108,90,
126,114,98,125,110,92,119,101,81,115,96,74,114,91,64,110,87,60,115,
90,64,110,87,58,117,89,60,122,93,63,121,93,61,126,97,62,123,92,
58,120,90,56,120,89,57,123,92,62,127,96,67,133,101,74,130,98,73,
122,91,65,120,91,62,115,87,59,111,84,57,110,82,59,93,67,47,91,
67,48,87,64,45,81,62,39,71,57,32,67,54,31,65,53,34,61,50,
36,78,68,56,84,75,66,92,84,77,96,86,77,97,86,75,101,92,83,
128,120,113,158,154,152,181,180,181,191,191,194,212,214,220,229,231,241,239,
238,250,239,238,250,246,245,255,245,244,254,244,243,253,245,244,254,244,243,
253,245,245,249,246,247,251,246,247,251,246,247,251,248,249,253,246,247,251,
250,251,255,250,251,255,245,245,255,245,245,255,245,245,255,245,245,255,245,
245,255,228,234,242,226,234,243,224,233,243,224,233,243,232,239,249,233,236,
242,224,224,224,150,146,146,108,106,103,125,125,124,171,174,176,222,229,236,
230,238,247,234,243,251,243,247,255,240,243,249,243,245,250,248,248,255,244,
243,255,244,241,253,245,243,255,243,243,255,243,245,255,229,234,243,217,224,
235,199,203,213,177,179,184,151,150,151,134,126,122,125,109,99,115,95,81,
113,90,72,116,92,69,119,96,73,119,98,78,126,106,87,126,108,90,126,
108,90,129,106,88,119,98,77,114,90,62,114,87,60,117,89,61,109,81,
53,116,87,57,120,89,59,119,89,59,120,89,58,119,90,55,114,84,51,
114,83,52,117,89,61,116,88,65,129,102,84,133,111,96,138,113,93,139,
111,85,128,101,76,121,95,69,117,89,66,116,90,65,99,75,52,91,66,
45,86,65,40,77,59,32,73,58,33,72,58,37,83,71,54,121,111,97,
145,138,128,150,145,137,160,150,138,147,132,115,133,118,102,151,137,123,169,
156,146,187,180,178,206,204,206,224,227,233,235,237,247,239,239,251,238,238,
250,245,245,255,245,245,255,246,245,255,245,244,254,246,246,251,241,242,248,
244,249,251,233,237,236,229,233,231,230,235,237,250,251,255,248,248,255,251,
250,255,248,248,255,245,245,255,245,245,255,245,245,255,245,245,255,230,234,
237,228,234,242,229,238,248,227,240,249,227,234,241,241,241,241,215,204,200,
164,148,138,132,120,102,81,75,61,71,70,64,92,96,96,133,142,146,192,
201,206,227,233,238,243,247,250,245,247,249,241,241,245,246,244,254,244,240,
255,242,238,255,243,243,255,231,236,245,216,226,232,208,212,221,183,184,192,
162,160,164,139,133,133,133,121,116,125,109,98,116,97,84,110,88,74,108,
85,62,115,91,67,117,94,70,123,100,77,127,103,82,127,103,83,117,93,
74,120,95,76,115,89,61,117,90,61,114,86,57,115,86,58,117,85,59,
119,86,59,121,88,61,120,90,59,119,91,56,116,86,53,113,82,52,119,
90,64,133,107,87,148,128,114,151,138,130,159,138,125,157,130,109,147,120,
98,139,112,88,133,105,80,147,119,92,130,102,75,115,87,60,103,78,48,
104,79,48,102,81,51,98,80,54,119,102,81,159,147,128,182,173,159,170,
164,152,172,159,142,168,144,120,164,139,114,174,148,124,183,160,140,204,186,
174,217,208,204,222,222,224,229,229,236,228,226,232,234,234,241,242,242,249,
245,246,255,244,244,248,241,241,245,223,223,225,179,181,184,143,150,150,115,
121,112,109,114,102,137,139,134,228,228,232,248,245,255,252,250,255,248,248,
255,245,245,255,245,245,255,245,245,255,245,245,255,232,236,241,229,235,243,
229,238,248,230,240,249,238,247,253,234,234,236,226,218,215,169,154,144,152,
132,110,119,103,84,66,59,47,67,64,58,60,61,60,71,77,78,114,122,
125,202,207,210,237,242,244,244,246,251,241,241,251,244,243,255,242,240,255,
230,232,244,222,230,238,210,219,223,192,192,195,167,167,168,144,142,142,125,
120,117,132,124,117,133,121,111,123,109,96,113,97,81,103,85,54,108,89,
56,111,90,60,111,91,62,110,89,63,111,90,66,111,90,68,113,91,69,
113,90,63,114,91,63,110,85,59,113,86,60,117,89,64,123,94,67,121,
91,66,117,88,60,117,87,58,116,85,55,111,81,52,117,87,61,148,123,
100,169,147,129,171,156,141,171,149,132,162,134,111,158,129,105,151,120,94,
144,115,87,153,122,92,151,119,88,141,110,78,135,102,69,142,110,76,138,
107,75,134,106,76,140,113,87,163,139,115,176,153,131,168,147,126,168,142,
118,163,134,105,166,135,105,183,149,119,188,155,128,194,167,146,202,184,170,
204,192,186,204,195,192,223,215,215,221,217,218,241,240,242,228,229,230,199,
200,201,150,150,150,95,95,94,70,71,72,64,67,66,77,79,68,89,86,
68,135,127,115,208,200,200,248,244,251,248,250,255,245,245,255,245,245,255,
245,245,255,245,245,255,245,245,255,233,236,242,230,235,244,231,238,248,231,
238,248,235,241,247,243,243,245,235,228,226,192,177,171,180,153,128,136,111,
86,104,87,66,68,58,43,61,55,47,51,51,48,53,56,56,74,81,83,
145,150,151,211,214,217,244,245,254,242,244,254,238,239,253,219,224,235,215,
224,231,195,203,207,171,170,168,148,145,141,130,125,121,125,119,112,135,128,
119,145,136,125,133,124,111,119,108,91,105,89,56,96,79,45,98,81,49,
104,86,59,104,86,60,113,94,71,126,106,85,121,102,82,122,99,75,122,
97,72,115,92,67,116,91,67,126,99,75,136,107,83,128,100,76,125,94,
69,123,92,66,122,90,65,123,93,67,122,93,69,139,115,91,156,134,113,
172,153,135,166,142,122,153,124,100,159,129,104,158,126,100,160,127,98,157,
123,90,154,119,85,154,119,84,157,120,84,169,129,93,163,126,89,157,118,
85,156,117,85,159,122,90,157,119,87,156,118,88,158,120,89,164,128,92,
176,135,101,178,136,100,180,138,103,181,145,115,180,150,126,184,162,144,190,
171,158,208,196,186,194,185,179,166,165,162,130,130,128,77,78,75,65,65,
61,63,62,56,59,59,57,71,71,67,69,63,47,108,94,69,166,148,125,
220,203,198,255,250,255,240,245,255,245,246,255,245,245,255,245,245,255,245,
245,255,245,245,255,233,236,242,235,239,247,234,239,248,238,244,253,237,241,
249,240,240,244,250,245,247,218,208,205,205,174,150,178,148,118,132,105,77,
98,79,53,65,52,34,60,54,44,51,51,47,53,55,55,49,51,50,82,
85,85,146,149,153,214,219,225,213,218,226,213,219,226,192,201,204,171,178,
178,154,149,142,134,127,118,120,113,104,123,116,105,128,121,109,136,129,115,
130,123,108,108,100,85,96,80,53,95,77,50,102,85,59,114,94,71,127,
107,87,140,119,101,148,127,110,150,128,113,148,128,103,144,120,96,134,110,
86,134,109,85,139,114,89,142,116,91,139,113,88,142,113,89,134,102,80,
139,109,88,138,111,89,136,111,89,147,124,102,136,115,93,151,129,108,151,
126,105,142,114,90,158,128,102,157,125,98,158,125,94,156,121,86,157,121,
85,159,121,83,160,118,82,166,122,87,162,117,81,157,113,77,159,112,75,
160,115,76,152,105,67,157,109,70,172,127,90,184,141,104,174,127,87,175,
126,86,176,128,88,178,136,100,177,144,114,210,183,158,198,176,157,144,130,
116,96,88,79,56,55,51,58,59,56,47,48,45,57,57,50,55,52,43,
62,57,51,67,60,51,89,74,52,151,129,97,202,177,152,244,223,215,254,
249,253,240,246,255,245,246,255,245,245,255,245,245,255,245,245,255,245,245,
255,238,240,250,238,241,250,235,239,247,239,243,251,240,241,250,244,244,248,
247,245,249,229,225,225,214,189,172,201,173,147,181,149,116,144,116,80,102,
80,49,61,49,30,53,47,38,44,43,39,56,55,51,54,54,52,55,56,
56,83,87,87,137,142,145,180,187,187,167,172,171,149,152,149,140,131,121,
126,116,105,116,105,94,116,105,93,117,107,93,116,107,91,111,103,87,101,
90,75,96,76,55,108,86,65,125,100,80,146,122,104,152,127,110,153,128,
114,152,127,114,163,137,123,164,139,115,158,134,108,151,126,100,144,118,93,
146,120,94,154,125,101,158,131,105,150,121,98,145,117,96,134,107,89,154,
130,113,156,132,117,162,140,122,133,112,95,129,108,92,136,113,93,166,139,
117,169,141,117,160,130,103,159,125,96,160,125,92,165,126,90,165,126,88,
162,118,81,160,116,80,157,112,76,154,109,73,156,110,72,158,111,72,157,
107,66,156,106,64,163,116,77,184,140,102,174,127,87,174,125,84,168,121,
81,165,128,91,156,127,97,153,132,106,108,93,75,65,55,45,56,52,46,
84,85,80,71,74,71,72,74,70,48,47,40,63,57,44,65,54,41,91,
74,57,133,113,83,184,161,126,224,200,177,255,239,235,254,250,255,240,245,
255,245,246,255,245,245,255,245,245,255,245,245,255,245,245,255,237,240,249,
238,240,250,240,241,249,244,246,254,244,244,251,244,244,248,246,246,251,239,
238,242,223,208,201,198,176,157,202,175,142,181,147,105,153,122,80,93,71,
40,63,49,32,49,41,32,40,37,30,41,40,34,50,50,45,53,54,51,
42,45,42,66,68,65,106,107,103,133,132,126,130,120,110,119,107,96,114,
101,89,114,100,86,111,97,82,105,91,74,110,94,76,114,98,79,121,97,
77,127,102,81,141,115,94,157,129,107,164,136,114,148,121,100,139,112,91,
141,114,91,145,119,90,139,116,87,140,113,86,147,119,92,148,118,92,154,
124,98,157,125,98,141,112,89,138,114,94,168,146,128,156,139,124,132,117,
106,166,149,138,176,158,147,145,125,112,140,120,103,189,164,144,177,151,130,
170,142,118,172,140,112,164,131,99,160,124,88,160,122,85,158,116,81,158,
114,79,152,109,73,145,103,67,146,106,66,153,112,71,165,122,80,159,117,
74,147,105,67,157,113,77,151,107,70,152,109,70,152,114,76,139,109,78,
117,98,74,62,53,38,45,39,30,48,45,39,113,113,109,175,182,181,136,
145,146,94,97,94,49,48,40,65,56,41,77,58,39,129,101,74,175,151,
116,204,185,153,232,220,202,255,250,250,250,248,255,245,248,255,245,245,255,
245,245,255,245,245,255,245,245,255,245,245,255,234,238,248,237,239,249,240,
240,250,243,243,250,244,244,251,243,243,250,247,247,254,244,245,251,231,229,
229,199,186,176,200,176,146,199,164,120,187,153,103,154,123,84,97,75,49,
54,41,27,47,40,30,40,36,28,48,47,40,56,57,51,32,34,29,26,
26,23,60,60,53,62,58,51,91,80,71,110,95,85,120,104,92,134,116,
102,128,107,90,139,119,98,135,113,91,142,119,96,148,119,95,140,111,83,
141,113,84,144,114,84,142,114,81,139,111,76,144,116,80,141,114,77,146,
118,87,136,107,78,132,103,74,170,139,108,153,121,91,152,118,89,150,115,
87,146,120,94,142,122,101,194,178,162,175,163,151,169,158,151,188,176,170,
186,169,164,170,152,145,189,168,157,180,160,143,164,141,123,164,138,117,159,
131,104,151,120,90,154,120,87,162,125,88,163,126,89,160,119,85,148,112,
76,145,108,72,148,111,74,154,117,79,163,127,87,159,124,82,146,108,71,
146,105,71,144,101,65,135,99,63,116,85,54,72,54,31,49,42,29,31,
30,23,38,38,33,32,32,30,120,126,126,93,105,109,126,138,141,55,59,
58,48,45,37,57,46,32,115,85,60,184,146,111,205,177,142,207,195,168,
232,228,219,248,248,253,245,245,255,249,249,254,248,248,255,245,245,255,245,
245,255,245,245,255,245,245,255,238,240,245,238,240,245,240,241,247,241,243,
248,241,244,251,242,244,249,241,244,248,240,244,250,229,231,236,208,202,196,
195,179,155,202,176,132,201,167,115,188,154,104,154,125,82,96,72,43,60,
45,29,44,35,23,37,32,23,28,28,20,29,29,21,24,24,17,34,32,
21,34,29,19,35,27,16,67,57,42,103,91,75,130,115,97,142,123,103,
168,142,120,148,119,94,153,121,95,156,124,97,144,114,85,144,117,83,141,
112,77,148,117,79,150,117,77,146,113,73,147,112,74,150,115,81,146,110,
78,139,105,71,170,134,99,147,112,77,144,109,74,151,115,79,150,119,87,
145,122,96,192,173,154,194,177,167,205,192,185,210,196,189,198,179,167,147,
124,109,180,151,128,162,133,104,151,118,91,150,118,87,150,115,84,150,115,
80,162,123,88,162,122,85,162,124,86,165,126,90,156,116,83,154,116,82,
159,124,88,157,123,87,154,121,85,154,121,85,145,112,80,142,108,80,119,
90,62,79,55,31,59,42,24,50,40,27,51,47,38,28,29,24,23,23,
21,66,68,67,117,124,125,105,115,117,85,92,92,49,51,45,55,47,35,
96,77,55,162,127,91,215,176,132,211,186,152,206,195,178,231,231,231,243,
246,255,243,244,255,250,248,253,248,248,255,245,245,255,245,245,255,245,245,
255,245,245,255,232,234,239,232,234,239,233,236,242,233,237,245,235,240,247,
238,241,247,235,238,244,238,241,245,239,240,248,219,216,215,199,187,170,202,
182,144,205,175,128,202,169,120,194,157,111,159,124,83,91,66,42,57,42,
23,43,36,21,36,34,21,26,26,15,32,30,18,28,25,12,34,28,13,
31,25,11,32,27,12,42,36,22,69,62,46,122,109,92,150,131,110,154,
128,107,163,134,110,176,142,115,153,122,92,148,117,83,150,118,80,156,123,
82,150,113,74,150,111,72,148,106,72,145,103,70,145,103,70,141,99,64,
151,109,73,146,107,68,141,101,61,148,108,69,158,121,84,139,109,78,157,
132,109,159,140,125,194,174,163,184,165,150,159,133,112,133,102,72,150,112,
74,153,109,71,156,110,72,154,109,71,153,109,71,150,105,68,157,112,74,
153,109,71,158,116,78,162,122,85,157,116,82,157,118,82,159,121,86,154,
118,84,157,121,88,153,119,86,135,107,79,114,91,68,71,52,33,45,32,
18,47,36,24,36,28,20,44,39,31,38,35,29,30,29,25,39,40,37,
124,127,124,153,156,153,116,116,108,54,49,37,81,66,44,135,110,79,206,
170,126,220,183,137,215,192,162,221,210,199,237,237,239,242,245,254,245,245,
255,249,246,253,248,248,255,245,245,255,245,245,255,245,245,255,245,245,255,
231,233,245,228,230,242,228,229,242,230,231,242,230,230,239,234,234,243,232,
230,239,233,232,239,230,226,237,225,219,220,211,196,184,202,178,152,199,169,
132,208,173,134,206,168,130,194,157,121,164,131,99,98,74,47,69,53,30,
50,42,24,40,36,20,35,30,15,26,21,8,35,27,12,30,23,9,36,
29,16,32,28,18,45,40,31,71,65,57,151,141,130,163,149,139,152,135,
121,163,133,103,162,128,94,162,127,90,151,116,73,144,105,64,145,105,63,
151,109,68,151,107,70,151,105,68,152,106,69,147,102,65,148,102,64,146,
102,62,144,100,57,144,101,58,142,101,60,140,103,66,144,112,81,159,131,
107,162,136,112,153,125,100,136,105,74,145,108,70,154,112,70,164,116,76,
160,112,72,156,108,68,157,110,70,158,110,70,156,108,68,153,106,66,160,
115,76,159,116,78,163,123,84,170,131,92,164,126,89,165,128,91,162,126,
90,140,105,70,111,83,55,83,61,40,72,52,31,60,44,26,57,43,27,
53,40,25,49,39,26,50,39,27,51,44,33,51,46,38,115,111,102,113,
110,100,60,56,45,83,72,54,119,98,73,193,164,128,214,176,135,223,188,
148,211,188,165,218,208,201,232,232,236,239,243,251,243,246,255,249,248,253,
247,247,254,245,245,255,245,245,255,245,245,255,245,245,255,220,222,236,218,
218,229,214,213,221,213,209,215,219,213,216,224,216,219,219,211,214,217,209,
211,218,208,211,215,201,198,208,189,175,199,175,150,198,169,137,202,169,134,
205,168,132,201,162,127,202,163,124,177,142,105,103,79,47,67,50,25,61,
49,26,43,33,14,53,40,20,61,46,25,55,39,20,63,48,29,59,46,
32,73,64,52,160,151,141,196,188,181,192,186,181,166,156,148,164,130,99,
159,122,86,164,123,82,164,121,76,157,112,66,153,108,63,158,109,67,158,
109,68,156,108,68,154,105,64,153,104,62,152,104,61,151,105,59,152,105,
58,145,98,51,135,90,44,127,84,40,127,89,49,132,97,60,123,89,55,
136,100,64,148,108,66,154,110,65,162,114,67,162,112,69,163,112,69,164,
114,69,164,114,71,165,114,71,160,111,66,166,115,72,163,115,74,171,128,
86,178,135,95,175,133,91,174,133,93,180,140,101,160,122,84,135,99,63,
128,97,67,104,79,55,107,84,58,96,73,48,87,64,42,84,62,40,80,
59,36,71,51,29,81,63,43,75,61,44,73,60,44,87,75,58,84,72,
53,111,92,67,194,167,134,217,186,146,223,188,148,217,183,150,213,190,171,
226,216,211,236,236,238,238,243,250,241,245,253,245,247,250,248,248,255,245,
245,255,245,245,255,245,245,255,245,245,255,212,212,212,202,200,198,198,192,
187,194,181,173,188,171,160,183,167,156,177,162,151,171,156,144,178,158,145,
172,152,133,180,158,134,193,169,138,196,168,132,196,165,126,201,167,127,200,
162,124,208,166,125,201,161,119,181,146,105,117,90,54,77,56,26,74,55,
27,89,68,41,92,70,43,97,66,36,108,75,47,87,60,36,121,96,74,
160,138,120,139,122,109,164,151,140,158,145,132,157,123,88,162,121,81,171,
127,83,156,108,61,159,111,63,156,108,60,159,111,64,162,114,67,159,107,
63,154,102,59,153,101,57,156,108,60,153,105,57,157,108,59,147,98,49,
140,91,41,129,82,33,132,87,40,135,91,46,140,96,52,142,98,53,158,
112,64,160,111,60,165,115,65,160,111,63,170,121,72,166,117,69,165,116,
68,163,114,66,163,114,66,170,121,72,162,115,69,195,149,104,190,145,101,
174,130,87,184,142,100,187,145,103,171,130,89,158,118,78,152,117,81,142,
112,81,160,129,98,138,107,75,128,96,64,113,82,50,127,94,60,132,99,
64,117,88,57,99,73,47,104,81,54,91,70,45,126,103,74,195,170,135,
223,192,154,220,185,143,221,185,146,218,186,155,213,190,171,229,217,211,235,
234,236,238,240,245,241,246,251,244,248,251,248,248,255,245,245,255,245,245,
255,245,245,255,245,245,255,212,204,189,198,188,169,187,171,148,175,152,126,
168,144,116,150,127,99,152,131,105,144,123,98,146,121,90,145,118,87,157,
133,98,178,154,116,193,167,126,196,167,124,199,169,124,205,170,126,208,169,
127,207,170,125,201,165,121,187,152,109,120,89,51,99,70,36,114,83,52,
123,91,58,126,84,46,123,79,42,123,80,44,126,86,53,158,122,91,130,
100,75,125,100,78,147,123,100,144,108,72,159,118,78,159,114,69,160,108,
64,160,108,61,154,103,56,162,113,65,158,111,64,153,103,57,154,104,59,
154,104,59,148,99,51,158,109,61,158,108,59,153,103,53,147,97,46,142,
93,45,148,98,49,145,97,47,156,109,57,162,113,62,164,113,63,168,118,
68,162,113,64,165,116,68,165,116,68,164,116,68,168,119,71,169,120,71,
160,112,64,162,113,65,168,120,73,171,124,77,177,130,84,174,128,82,187,
141,96,190,145,101,184,141,98,176,134,92,162,123,83,156,118,80,156,117,
78,151,113,73,151,111,71,145,104,64,154,113,71,152,110,67,148,108,69,
138,102,65,129,95,60,133,103,66,195,163,125,226,194,154,225,191,151,220,
188,148,218,184,144,217,184,152,207,184,162,224,209,200,235,228,228,237,237,
241,243,245,250,242,246,249,248,248,255,245,245,255,244,244,254,241,241,251,
244,244,254,194,174,148,183,160,132,180,149,117,172,137,102,162,127,91,154,
124,88,169,142,110,153,128,98,148,115,79,142,111,74,147,119,83,158,131,
97,188,160,126,193,165,126,193,163,122,204,171,129,204,172,131,207,173,131,
204,169,125,204,167,121,192,155,110,130,94,54,102,66,30,136,98,60,132,
90,51,138,92,53,133,84,44,132,86,45,145,101,60,133,92,55,162,127,
91,175,141,107,151,117,79,141,103,64,151,106,64,156,104,60,166,110,64,
148,97,51,159,111,64,163,118,71,158,111,64,154,106,59,163,114,69,159,
111,63,158,110,61,159,111,61,153,105,56,153,105,57,153,106,60,151,103,
55,151,103,53,156,107,57,170,121,70,170,121,72,177,129,82,164,117,71,
164,117,71,159,113,66,171,124,77,170,123,77,169,123,75,157,111,65,165,
118,71,174,126,79,165,116,68,178,130,81,175,128,79,180,132,85,176,130,
83,178,134,88,182,137,91,178,134,88,169,124,77,157,112,65,172,126,80,
160,115,69,163,117,71,165,119,73,157,111,63,174,128,82,174,131,87,182,
139,95,192,153,110,214,177,133,218,183,140,215,182,142,219,189,149,218,185,
144,210,176,139,205,176,148,215,195,181,227,217,214,236,232,235,244,244,248,
244,246,254,245,245,255,244,244,254,243,243,253,241,241,251,240,240,250,181,
151,125,172,139,111,170,129,97,163,118,82,162,117,81,162,123,90,172,139,
112,159,130,104,147,110,74,144,108,72,146,115,84,154,127,101,181,154,127,
190,162,133,187,156,124,193,160,126,194,165,130,201,171,133,211,181,136,213,
176,130,211,171,123,195,151,106,142,100,59,121,78,42,183,145,107,145,106,
67,144,102,60,128,84,40,135,90,46,133,91,47,125,87,47,130,96,56,
168,135,96,165,127,88,139,94,55,157,105,62,165,111,65,159,109,63,162,
116,70,169,126,78,175,129,83,153,106,62,162,115,69,157,110,63,160,112,
64,160,112,64,154,107,59,157,112,68,159,113,74,151,106,61,159,112,64,
160,112,64,172,125,76,174,129,84,169,122,83,166,124,82,154,110,65,160,
116,72,166,122,77,172,128,83,170,125,80,172,127,81,177,133,87,171,124,
76,182,131,81,180,130,80,175,126,76,172,125,76,171,124,77,169,124,77,
170,125,79,175,126,76,169,118,65,169,116,63,171,119,67,169,119,68,177,
128,77,174,125,75,175,126,76,162,115,67,186,140,92,208,162,115,215,171,
125,217,177,131,225,191,147,217,188,146,213,187,147,208,177,134,193,158,114,
193,163,130,201,180,159,217,201,194,232,223,225,239,234,241,247,245,255,245,
245,255,244,244,254,241,241,251,240,240,250,241,241,251,170,133,102,164,124,
92,164,121,86,154,110,74,157,112,76,150,108,75,150,115,84,144,113,81,
139,101,63,142,104,69,150,115,87,156,125,100,169,141,119,189,162,137,189,
162,135,189,162,131,190,167,132,194,167,130,202,175,134,212,178,136,211,174,
127,211,170,121,200,154,104,147,102,56,141,104,67,164,125,86,163,120,77,
154,106,61,146,95,52,140,90,47,132,86,45,123,82,41,121,83,46,134,
94,55,152,106,67,166,120,75,166,120,74,175,129,83,175,133,86,176,136,
88,172,127,83,157,110,70,168,123,79,166,122,77,175,130,83,162,116,69,
162,114,67,162,112,70,153,105,65,150,103,60,169,124,80,156,113,71,164,
122,78,163,121,79,166,124,83,164,122,81,144,103,60,180,135,90,183,138,
92,188,144,96,176,132,87,180,135,90,178,134,89,180,135,90,186,140,93,
176,130,83,184,138,91,170,124,77,169,123,75,162,114,67,165,118,70,168,
118,68,168,116,63,175,122,67,174,122,67,182,128,73,196,142,87,180,133,
76,175,129,74,170,124,72,210,162,112,211,168,119,213,172,126,223,186,141,
219,186,145,215,187,145,213,185,145,208,176,132,199,161,114,196,163,126,200,
174,146,214,196,182,229,220,216,235,231,234,237,236,245,243,243,250,241,241,
248,241,241,248,241,241,248,242,242,249,169,129,90,163,120,84,157,113,77,
153,108,72,153,110,74,142,104,66,130,95,58,125,93,54,132,96,55,127,
91,55,132,99,66,134,105,77,144,117,91,176,150,124,190,166,137,187,162,
131,199,172,138,196,169,134,199,171,136,198,170,129,207,173,131,207,171,121,
210,166,112,186,141,86,160,119,76,152,109,66,172,121,78,174,120,74,168,
110,64,154,99,54,142,89,46,133,83,42,130,83,45,140,94,55,151,107,
64,175,131,88,166,127,80,164,125,79,181,143,96,170,131,85,168,122,83,
166,120,82,165,123,80,175,132,88,175,130,84,163,117,72,166,115,72,180,
126,81,165,112,68,148,102,60,181,138,96,177,136,96,162,124,85,151,113,
71,159,120,77,150,109,68,160,118,76,183,139,96,190,146,97,177,135,85,
192,147,98,174,131,86,188,145,102,195,153,112,171,130,89,176,135,92,176,
132,88,171,128,83,171,124,77,164,116,68,162,112,62,153,105,56,160,111,
60,177,125,70,189,134,78,200,143,84,183,131,72,170,121,63,193,145,87,
213,164,109,215,170,119,213,172,122,217,180,135,223,191,150,218,189,149,214,
186,144,206,178,136,196,161,118,188,147,104,192,158,116,200,173,140,212,192,
170,219,208,198,229,225,225,233,232,239,234,235,241,234,235,238,237,237,241,
240,240,244,244,244,248,166,127,88,158,115,79,147,103,68,151,106,70,154,
110,74,147,108,70,130,95,58,129,96,57,132,96,56,128,92,56,127,94,
60,123,93,64,134,107,80,171,144,117,196,173,144,195,173,141,200,173,142,
202,176,144,205,178,146,202,174,138,211,178,138,207,171,127,206,165,114,207,
163,110,190,146,101,154,110,65,152,103,55,176,124,73,176,118,69,164,107,
58,154,100,54,147,95,52,153,103,63,160,112,72,164,120,76,160,118,76,
178,137,91,163,125,79,187,150,103,174,136,91,169,123,85,171,128,86,170,
128,85,171,131,86,158,116,72,169,123,78,174,123,79,183,130,85,159,107,
63,152,106,64,170,126,87,178,139,100,168,130,90,157,117,77,157,117,77,
160,118,77,164,122,81,172,128,85,177,133,87,184,142,92,169,125,80,171,
128,84,190,147,105,171,130,89,174,134,93,171,132,88,174,131,87,176,131,
85,177,130,84,160,112,64,160,110,61,162,112,62,171,122,71,189,135,80,
200,144,86,199,143,86,183,132,74,207,159,100,214,167,110,217,172,118,212,
167,117,214,175,127,220,184,139,218,185,144,212,182,143,200,170,130,183,153,
112,181,145,102,184,143,100,189,152,110,196,167,132,206,185,159,211,199,184,
220,214,212,227,226,232,232,233,236,237,237,241,238,238,242,243,243,247,244,
244,248,162,121,81,151,107,70,146,102,65,142,97,60,142,99,62,142,103,
64,141,103,65,138,104,64,136,100,59,130,93,56,126,92,57,116,85,54,
125,95,67,151,123,96,183,159,129,195,172,141,202,174,146,199,172,144,198,
173,143,195,168,139,192,163,129,194,160,121,199,161,116,200,159,110,199,157,
106,193,148,97,157,108,57,160,108,55,174,119,65,163,108,54,154,102,51,
148,98,49,159,109,67,164,115,74,177,130,87,169,126,82,159,117,75,150,
113,68,162,125,81,154,116,73,158,115,76,168,124,84,157,117,76,154,116,
73,151,110,67,152,108,64,162,112,70,163,111,67,151,101,59,157,110,70,
159,118,78,150,112,74,165,128,90,164,126,86,156,117,77,165,125,85,152,
111,70,171,128,86,180,137,90,172,130,83,177,134,87,180,137,94,163,121,
80,157,117,77,170,131,91,158,117,76,178,135,91,169,124,78,177,130,84,
182,133,84,176,126,76,168,118,68,177,126,75,195,141,86,198,144,88,186,
131,75,196,147,87,213,166,109,213,169,116,212,170,119,213,174,124,221,185,
140,223,188,145,214,183,144,212,182,143,206,175,136,192,159,118,181,143,100,
178,135,93,184,146,104,192,160,121,204,179,149,211,194,178,215,208,203,223,
222,224,234,235,238,243,243,247,240,240,244,245,245,249,241,241,245,156,113,
74,147,104,67,147,102,64,138,91,54,138,94,56,140,97,59,146,108,69,
145,110,67,142,105,64,133,98,58,125,88,52,119,83,52,123,91,60,139,
110,81,172,148,119,195,173,143,196,168,140,189,163,137,192,167,139,192,168,
139,194,168,136,199,169,132,200,166,126,190,153,109,196,155,104,211,166,112,
195,145,90,162,109,54,159,104,48,158,104,48,159,107,53,152,102,51,171,
121,76,169,123,77,156,111,66,172,128,83,154,113,70,154,116,73,163,126,
84,144,105,65,147,104,67,188,146,104,190,150,109,172,134,92,163,122,80,
159,115,72,168,119,78,152,102,61,142,96,54,138,96,54,156,116,77,132,
97,61,168,132,95,166,128,90,153,119,77,175,136,95,171,130,89,150,110,
68,182,143,95,182,142,93,181,141,95,147,109,67,160,120,80,151,112,73,
157,117,77,178,139,95,170,127,82,174,130,84,183,135,88,187,137,88,175,
124,74,177,127,75,192,139,85,204,150,94,188,134,78,192,141,83,212,161,
104,213,168,113,212,171,119,206,169,118,211,176,129,214,180,135,218,190,147,
212,183,143,200,170,132,195,162,123,181,146,105,174,134,93,178,135,93,184,
144,102,190,155,116,198,170,137,206,186,165,214,204,195,223,223,223,232,233,
236,238,238,242,240,240,244,241,241,245,243,243,247,147,106,65,142,97,60,
145,98,61,138,90,54,140,93,56,140,96,59,146,106,66,147,111,70,144,
109,68,140,103,63,128,90,53,123,85,51,128,90,59,139,108,77,162,137,
107,193,171,141,196,171,140,187,160,133,180,154,128,178,155,127,181,159,127,
189,161,127,192,161,123,188,154,111,190,150,99,199,155,102,200,150,94,184,
130,74,165,110,53,159,104,50,154,102,48,156,106,54,150,103,56,168,121,
74,159,114,67,156,113,68,158,116,73,150,113,71,162,125,83,145,108,69,
145,103,67,169,128,88,189,149,108,148,112,72,146,106,66,162,119,77,160,
112,72,146,97,57,141,94,54,141,97,60,147,110,73,132,98,63,166,130,
93,160,127,87,153,117,77,178,139,100,153,114,75,156,116,75,178,141,95,
178,139,93,170,132,87,170,130,89,165,125,86,152,113,75,168,129,88,172,
132,88,175,132,88,183,138,92,182,135,88,192,142,93,178,127,77,195,143,
90,198,145,90,193,139,83,188,134,78,212,158,102,213,167,111,211,169,117,
207,167,118,205,172,123,213,182,135,215,187,145,210,183,143,196,168,130,193,
162,124,183,148,110,174,135,96,172,132,90,177,134,91,183,139,96,189,150,
106,194,162,125,204,182,156,214,202,189,221,219,217,235,236,239,232,233,236,
237,237,241,239,239,243,241,241,245,142,97,60,141,96,58,144,96,58,141,
93,55,144,99,60,151,106,68,154,114,73,142,105,64,135,101,61,136,98,
59,132,92,52,130,87,52,122,84,51,148,115,83,168,143,113,182,162,133,
194,169,138,182,158,128,178,156,127,175,155,125,177,158,126,183,160,125,184,
157,118,184,153,111,190,150,101,193,148,97,199,148,96,196,142,87,176,120,
64,169,114,60,168,115,63,159,108,58,166,118,70,164,117,69,154,110,64,
154,111,67,136,96,55,162,122,81,142,105,66,169,131,92,158,115,79,146,
108,71,145,108,70,156,120,78,159,120,78,172,129,86,152,107,66,154,107,
67,147,101,62,148,105,69,144,106,68,147,112,77,158,125,89,162,130,90,
160,124,85,180,141,103,158,120,83,162,123,81,176,139,94,177,139,94,178,
142,97,190,150,109,156,118,80,151,113,76,170,131,91,153,113,71,168,125,
81,177,133,87,188,140,93,192,142,93,182,131,81,193,141,89,193,140,85,
192,138,83,196,142,87,215,162,108,214,169,114,206,166,116,204,169,121,208,
178,132,212,188,143,205,179,138,200,174,134,193,166,128,190,158,120,178,144,
106,165,126,86,159,116,77,166,124,82,181,137,91,192,148,102,195,156,117,
200,174,142,208,194,177,214,211,208,228,229,232,233,234,237,237,237,241,238,
238,242,238,238,242,142,100,59,141,94,55,140,93,54,144,96,57,144,96,
58,151,106,65,153,112,71,142,105,63,125,92,53,128,91,52,127,87,47,
127,83,47,123,82,48,126,94,62,152,128,98,176,157,127,195,171,139,186,
164,129,177,156,124,175,155,125,171,152,120,175,154,118,180,156,117,187,158,
116,188,149,102,194,148,101,199,148,98,192,139,85,194,138,82,175,121,67,
170,118,67,181,129,78,169,119,70,166,119,70,163,118,71,156,113,68,154,
113,70,150,111,71,166,127,88,187,148,109,171,129,93,165,126,88,141,105,
67,159,124,83,166,127,87,178,135,93,162,116,77,163,115,75,158,111,72,
158,117,76,163,126,89,159,125,90,157,123,88,158,125,89,166,131,93,183,
146,107,165,128,90,159,121,82,160,124,80,188,151,104,186,149,103,181,142,
102,157,120,82,157,119,81,157,117,77,146,108,65,180,136,92,184,138,92,
184,137,91,190,141,92,195,143,92,190,138,84,190,137,82,201,147,91,207,
153,98,212,162,106,213,169,116,206,167,118,205,172,123,202,177,130,208,185,
140,210,187,145,201,177,139,193,167,128,189,158,121,174,137,100,159,119,80,
157,115,74,169,126,83,177,131,85,184,138,92,189,152,108,193,166,132,204,
190,168,210,208,202,221,222,225,233,234,237,237,237,241,237,237,241,238,238,
242,138,95,52,134,87,47,135,88,49,133,86,47,136,90,52,132,90,51,
135,94,54,139,99,60,125,88,50,128,89,50,127,88,49,121,81,45,111,
75,42,116,87,57,150,124,98,172,151,124,196,172,136,193,169,134,194,172,
140,200,178,146,192,171,139,188,165,132,184,160,124,181,152,116,184,150,111,
187,145,103,195,147,100,195,141,88,195,139,84,187,132,77,177,125,73,181,
130,80,187,142,88,156,112,64,170,125,80,153,113,71,160,121,82,151,114,
78,157,121,85,181,144,107,174,136,98,160,123,85,156,118,80,180,142,103,
166,127,87,175,136,95,169,128,88,164,119,81,158,113,73,172,131,90,186,
147,108,162,127,90,157,121,85,154,121,84,163,127,90,189,154,114,159,124,
86,171,136,98,154,120,79,188,154,111,177,143,100,171,136,98,165,131,93,
163,127,89,170,131,92,162,122,81,165,122,80,182,137,91,190,143,94,193,
142,91,198,146,94,195,143,90,196,144,91,205,153,99,210,164,108,207,163,
110,208,169,121,210,174,129,205,175,130,205,179,138,202,178,142,201,177,141,
204,179,145,193,165,132,183,150,116,158,119,81,152,109,70,160,112,72,165,
118,75,172,128,85,182,143,99,186,150,107,190,157,124,202,181,160,212,205,
198,223,223,225,228,229,232,230,232,237,232,235,239,238,240,245,140,94,52,
138,92,50,134,88,49,133,91,50,129,85,48,125,84,47,123,82,45,126,
87,48,121,80,45,123,83,47,122,82,48,115,80,46,115,83,52,125,99,
73,152,130,108,175,156,133,195,170,135,188,164,128,186,165,133,180,160,130,
177,156,130,183,159,130,186,161,131,187,159,130,180,149,116,187,152,113,193,
149,103,205,152,99,202,145,89,193,138,83,176,124,73,174,126,79,187,143,
88,187,146,94,159,121,74,166,127,88,159,124,88,166,132,97,168,136,100,
171,139,101,171,134,96,159,121,83,175,137,97,188,150,110,174,135,96,176,
138,99,174,135,96,170,131,91,168,127,86,181,139,98,180,139,99,171,133,
93,169,131,93,159,122,86,154,118,82,183,148,110,188,155,115,174,142,103,
177,144,105,172,139,100,180,147,108,175,143,104,182,150,110,171,136,100,163,
127,90,152,114,75,180,140,98,195,151,106,194,146,97,196,146,95,196,144,
91,193,142,89,199,152,100,201,158,105,205,163,113,206,170,124,198,164,121,
202,173,132,198,171,131,200,175,138,208,183,152,204,179,149,198,172,141,182,
155,122,171,137,103,164,122,86,152,107,69,160,108,64,164,112,68,170,128,
87,178,141,100,182,143,104,187,151,116,199,171,148,212,201,193,221,219,221,
226,226,230,232,233,239,231,235,243,233,237,245,138,92,50,136,90,48,140,
93,54,138,96,54,142,97,60,133,92,54,123,82,45,116,78,40,123,82,
48,122,82,48,113,75,43,116,83,50,140,109,82,163,139,116,159,142,125,
174,159,141,193,169,136,186,161,129,182,162,132,178,159,132,180,160,135,181,
160,133,175,150,123,171,143,115,168,140,105,177,143,105,190,147,103,202,150,
99,207,153,100,206,152,99,194,145,94,184,138,91,187,145,92,195,153,102,
189,150,104,176,137,97,170,135,99,154,121,87,180,148,110,177,145,107,182,
146,108,172,134,95,171,134,95,181,143,104,171,134,95,166,128,90,194,156,
117,154,116,76,171,130,89,184,143,102,166,126,87,178,139,100,177,139,100,
164,128,91,162,127,90,181,147,109,177,144,105,180,147,108,176,143,104,169,
138,99,186,153,114,189,156,116,190,157,118,141,108,72,153,117,82,181,142,
104,205,163,121,204,160,115,202,156,108,200,153,100,198,150,96,192,144,95,
201,155,107,219,174,128,213,170,126,196,161,118,193,160,120,195,165,127,200,
170,134,202,177,142,206,181,149,199,175,144,190,164,133,176,146,115,158,123,
89,160,119,82,147,101,62,163,112,66,164,115,66,169,126,83,177,140,98,
183,146,101,186,148,110,188,160,132,201,188,175,214,210,211,224,224,226,226,
227,232,230,234,242,231,235,245,135,90,48,134,88,47,145,98,58,141,99,
57,144,99,61,138,96,57,132,90,52,125,86,47,115,75,42,113,73,41,
114,77,46,120,85,57,153,123,98,176,154,132,160,146,132,152,139,127,189,
165,135,182,161,128,180,159,128,169,152,126,162,145,119,164,144,119,175,150,
125,171,146,118,171,142,107,178,146,106,196,156,112,205,158,109,204,153,102,
202,151,101,199,152,104,196,150,104,202,161,110,195,156,106,187,150,105,183,
146,107,181,145,109,181,149,113,158,129,92,176,145,106,181,146,105,184,147,
107,175,138,98,180,144,103,158,123,84,172,137,97,178,142,102,163,124,84,
176,136,94,183,142,101,166,126,87,181,143,104,183,146,107,177,143,105,151,
117,81,172,138,100,192,160,120,172,139,100,186,153,114,178,146,106,192,160,
120,187,155,115,188,155,115,160,127,90,178,142,106,194,156,117,189,148,108,
193,151,107,200,155,110,207,160,112,207,161,110,207,161,114,201,157,113,200,
157,114,195,155,114,188,152,113,196,163,126,192,162,127,199,171,136,202,175,
142,206,181,147,199,174,142,190,164,132,180,149,116,166,131,95,151,112,73,
146,99,60,158,108,61,164,114,64,169,128,82,175,138,91,181,142,96,184,
148,104,184,154,124,194,178,163,210,206,206,217,215,217,225,225,229,227,230,
238,231,236,245,129,84,43,132,86,45,136,90,51,136,94,52,133,88,51,
129,88,50,132,90,52,130,91,52,128,86,53,119,79,47,120,83,51,114,
80,52,144,115,90,164,143,122,182,167,153,168,155,142,180,157,125,186,163,
129,186,165,134,178,160,132,181,162,134,183,161,134,183,159,130,178,153,122,
171,142,107,183,149,108,192,156,112,202,162,116,212,168,119,215,170,123,192,
150,104,193,152,105,192,151,102,195,157,110,204,166,123,190,153,116,182,148,
112,177,146,110,171,141,103,168,140,98,182,149,108,186,151,110,177,142,101,
178,144,102,162,128,88,181,146,105,188,154,113,165,130,88,183,142,101,184,
145,104,168,130,90,172,137,97,192,155,116,187,152,113,153,118,83,182,149,
112,183,150,110,187,155,115,180,147,108,189,156,116,196,163,124,189,156,116,
180,147,108,189,153,116,196,159,122,189,152,114,204,165,125,211,170,127,219,
179,134,214,175,127,202,161,114,201,159,115,201,160,119,201,161,121,196,158,
120,192,158,120,189,157,121,190,161,126,206,175,143,208,179,146,207,179,145,
199,173,140,184,157,124,162,130,98,153,117,82,145,102,64,145,97,57,152,
102,52,163,114,64,169,130,82,176,138,90,181,141,93,183,144,97,186,155,
120,195,177,158,206,200,198,215,211,212,225,225,229,225,229,236,226,234,243,
133,88,46,135,90,48,140,93,54,134,92,50,129,85,48,123,82,45,126,
85,47,123,84,46,132,92,56,126,89,52,121,82,49,109,75,44,119,87,
60,126,102,79,154,137,116,158,141,121,188,160,126,187,159,124,180,155,123,
178,155,125,171,147,118,163,139,110,174,145,115,171,140,108,172,142,105,182,
150,110,196,162,120,208,172,129,202,166,120,195,156,112,204,167,121,194,156,
111,198,159,113,194,156,113,198,160,121,187,152,115,192,158,121,186,156,120,
182,153,113,181,154,113,180,148,107,180,147,105,168,136,95,181,147,105,177,
144,103,183,150,108,175,143,102,176,141,99,163,124,84,171,135,91,166,131,
90,174,140,98,186,151,110,181,147,107,172,140,102,180,147,108,175,143,104,
184,152,113,184,152,113,192,160,120,190,157,118,181,148,109,193,160,120,195,
158,121,182,147,110,181,144,107,187,150,111,190,152,113,204,167,125,207,170,
125,207,170,125,217,178,135,219,181,141,219,182,143,213,178,139,204,170,133,
196,165,128,195,165,129,205,175,138,208,179,144,207,179,145,204,174,141,198,
169,135,171,140,105,156,119,83,156,113,74,151,102,61,153,104,56,162,114,
64,168,129,81,172,134,88,180,139,90,182,138,93,181,147,111,189,170,150,
201,192,189,215,209,210,224,223,225,228,230,237,228,233,242,138,92,50,139,
93,51,139,92,53,133,91,50,125,81,44,121,80,43,121,80,43,123,84,
46,117,81,45,120,83,46,115,78,41,110,74,38,104,71,38,104,74,44,
141,117,87,168,143,113,192,160,120,198,165,125,188,159,123,184,158,124,183,
155,123,190,162,130,182,149,115,186,152,116,182,151,112,183,153,112,193,161,
120,205,173,132,206,172,130,207,173,129,201,165,121,202,167,122,207,168,125,
205,164,123,194,158,121,200,164,128,192,161,123,186,157,120,183,156,116,187,
160,118,184,153,111,184,152,111,178,145,104,183,150,108,178,145,104,178,145,
104,168,136,95,172,137,95,157,122,79,169,134,92,159,124,83,180,146,105,
168,135,95,181,147,107,181,148,109,183,151,112,177,144,105,177,144,105,181,
148,109,184,152,113,184,152,113,178,146,106,183,150,110,192,158,120,193,157,
120,205,169,132,198,162,125,208,173,134,206,171,130,205,171,130,201,167,125,
206,171,130,215,180,138,217,181,139,211,177,136,201,167,127,192,160,121,193,
162,124,202,171,132,202,172,136,204,174,139,190,160,126,174,145,110,154,121,
87,152,114,76,163,119,79,152,102,60,150,98,54,159,112,66,163,122,79,
166,128,85,178,134,89,182,139,95,178,142,107,186,163,144,202,190,186,214,
208,208,219,217,221,221,224,230,222,228,238,133,88,46,136,90,48,133,86,
47,130,88,47,127,83,46,122,81,44,123,82,45,136,97,58,122,87,48,
115,80,40,114,75,35,110,71,31,115,77,38,113,80,40,122,91,55,144,
113,75,184,148,105,201,165,121,186,153,114,171,141,105,169,137,102,157,124,
90,172,136,100,175,139,102,172,140,100,177,148,107,187,158,118,195,166,127,
195,164,125,195,162,121,208,176,132,210,175,131,207,171,127,206,167,128,196,
160,124,207,172,137,204,174,137,190,160,122,180,155,114,182,155,112,182,152,
110,182,149,108,182,149,108,178,145,104,181,148,107,172,140,99,154,122,82,
169,134,92,154,119,77,182,147,104,159,126,85,180,146,105,154,122,84,174,
142,103,171,139,101,178,147,109,175,143,104,172,139,100,192,160,120,190,157,
118,177,144,105,180,147,108,195,161,121,206,172,134,204,168,131,204,168,131,
204,168,131,211,177,138,201,168,129,205,173,134,213,180,141,205,173,132,204,
170,127,200,165,122,193,160,116,188,155,113,190,158,118,188,158,117,189,159,
118,195,165,127,200,170,134,181,151,116,158,129,95,144,111,77,146,107,71,
162,115,75,154,102,59,151,99,56,158,107,65,160,119,79,166,127,87,176,
134,92,182,136,95,182,144,112,187,161,144,200,187,182,212,204,204,218,216,
218,220,223,229,227,232,241,129,80,38,132,84,43,130,86,47,128,87,49,
126,87,48,121,83,45,125,85,45,146,106,65,139,103,66,120,84,47,115,
78,40,109,71,32,111,72,34,117,81,44,120,84,47,141,106,70,168,133,
90,195,160,116,186,150,105,176,140,96,166,127,87,174,136,94,171,131,91,
171,131,91,186,151,108,196,161,118,201,167,125,198,165,123,194,162,121,194,
162,121,184,152,111,200,168,124,202,167,124,199,165,124,205,170,130,192,158,
121,187,156,118,188,157,119,182,153,113,181,154,113,180,152,110,171,143,101,
182,153,113,178,148,111,178,145,111,181,147,109,156,121,86,177,140,103,151,
117,81,182,148,110,166,131,93,180,147,107,151,120,81,168,136,96,165,136,
95,183,153,112,180,149,110,169,139,102,183,153,116,187,157,120,186,156,120,
196,166,128,186,155,116,198,165,125,200,166,126,202,169,128,205,171,132,195,
160,121,195,162,125,204,172,133,207,175,137,199,164,124,205,169,126,205,169,
126,208,176,132,207,175,131,205,173,128,198,164,121,193,159,116,196,162,122,
193,159,122,166,133,97,150,115,80,144,107,70,145,104,64,152,104,64,151,
101,59,150,99,57,152,104,64,157,114,71,166,124,80,170,128,85,176,136,
96,178,145,113,184,159,138,192,179,171,210,201,198,218,216,217,226,227,230,
221,224,232,133,81,40,132,81,41,130,84,46,125,81,45,123,85,47,116,
78,41,117,79,41,132,94,55,128,92,57,119,83,48,117,80,43,115,72,
37,114,74,35,119,78,41,122,84,46,133,95,58,148,114,73,186,150,105,
188,149,102,187,144,96,180,135,89,178,134,89,182,141,99,187,148,105,194,
156,111,199,161,114,195,160,116,207,172,127,210,175,131,208,176,132,201,167,
125,199,166,124,201,167,125,199,165,124,198,164,123,190,157,118,199,169,130,
187,157,120,180,153,116,178,152,113,171,149,105,170,147,106,177,150,116,171,
142,112,175,140,111,181,147,113,153,118,83,172,137,102,147,113,80,180,145,
110,165,131,96,174,141,105,150,118,81,178,148,107,170,141,99,184,156,115,
171,143,107,172,144,109,182,152,121,187,157,128,195,165,135,177,149,114,205,
175,138,205,174,134,190,157,116,199,167,126,198,165,125,199,166,126,204,171,
131,198,165,125,207,174,135,212,174,136,208,167,125,200,164,120,207,173,129,
207,174,129,207,173,129,199,162,118,195,155,114,194,157,115,195,158,117,180,
142,103,165,126,86,154,113,73,144,100,60,139,92,52,146,97,56,145,97,
56,150,102,62,154,109,65,162,118,72,168,130,83,171,138,98,169,141,110,
182,161,137,193,181,172,207,200,195,213,210,209,223,222,224,227,227,233,126,
79,42,127,79,41,129,81,42,125,77,38,121,75,37,114,73,39,108,75,
42,109,78,47,115,83,49,119,83,48,119,76,40,116,70,32,117,71,29,
125,76,35,134,88,45,126,82,42,138,101,61,174,137,93,188,148,100,184,
138,92,178,133,86,184,141,94,195,153,110,202,163,120,207,169,123,215,178,
132,213,178,133,204,168,125,208,173,129,205,172,130,199,166,124,199,166,126,
205,174,134,204,173,135,189,158,121,181,152,116,168,140,105,183,155,121,171,
146,112,184,158,126,175,150,112,172,148,112,169,142,110,171,142,112,177,143,
110,157,123,87,162,126,88,165,130,93,142,108,74,163,128,93,159,125,91,
170,137,101,156,125,88,174,144,107,174,144,107,172,143,107,175,146,112,160,
131,100,200,170,140,168,138,111,174,145,117,196,166,136,189,160,125,193,163,
126,208,175,138,214,180,142,201,168,129,201,168,129,204,170,129,201,167,127,
200,168,124,208,172,129,218,178,136,214,177,133,213,179,135,206,173,128,211,
175,131,214,177,133,211,170,127,204,164,123,199,162,120,181,143,100,162,122,
80,145,103,61,148,102,63,147,99,58,142,94,53,145,98,58,151,104,64,
153,109,65,159,115,70,165,125,81,163,131,92,165,138,108,177,156,135,196,
185,177,205,196,193,208,206,206,222,221,223,227,227,233,117,74,45,120,74,
40,125,73,35,122,71,30,127,79,41,111,73,42,141,110,85,116,92,72,
132,106,81,125,95,65,113,79,45,115,75,36,115,68,28,119,72,33,122,
77,37,116,73,35,136,96,56,162,120,77,182,137,91,180,133,85,180,136,
87,186,144,97,193,154,107,196,160,116,201,162,119,201,162,119,206,170,126,
201,165,121,195,160,119,201,167,127,200,167,126,200,167,128,196,167,132,192,
165,131,188,160,126,190,164,132,164,140,109,175,150,119,174,150,119,182,158,
128,182,157,126,175,150,118,168,142,111,158,130,97,175,140,105,156,123,83,
164,129,87,156,122,80,156,123,83,145,112,76,151,120,82,145,114,79,172,
139,105,178,147,116,174,143,112,180,149,117,169,140,110,184,155,126,159,129,
104,176,146,122,178,148,122,180,151,123,192,162,131,198,166,135,207,174,141,
196,162,128,202,169,132,201,168,129,204,171,129,210,178,131,202,170,122,210,
174,129,220,179,137,217,180,135,215,180,136,208,176,132,211,175,131,212,176,
132,202,163,122,194,155,111,196,156,112,187,145,103,169,128,85,152,109,66,
147,100,61,148,100,60,148,99,58,147,99,59,151,104,64,152,108,64,156,
113,71,159,119,78,151,118,85,157,132,107,176,158,141,193,183,178,204,197,
196,207,205,207,220,221,224,223,226,232,121,81,49,122,79,44,126,79,42,
129,82,46,123,80,48,128,95,70,175,150,130,166,148,133,154,139,122,133,
113,92,105,79,53,108,74,40,113,76,39,110,74,38,104,71,38,121,88,
55,142,101,60,169,124,80,182,135,86,181,133,84,188,142,91,200,157,106,
202,164,116,205,168,121,208,169,127,212,173,130,205,169,126,204,168,127,200,
166,126,199,166,126,193,159,122,183,153,116,177,150,116,186,159,125,187,161,
130,186,161,129,169,144,115,158,134,105,176,153,124,166,143,115,176,150,122,
181,155,125,178,152,120,174,145,110,160,128,90,169,134,95,156,122,80,145,
112,72,157,121,85,151,117,82,142,110,76,146,114,81,166,135,102,164,134,
104,186,154,125,184,154,124,168,138,108,158,129,102,147,118,95,164,134,112,
182,152,128,165,136,108,157,128,99,200,168,136,181,147,116,180,147,114,196,
163,126,193,161,122,189,156,114,194,163,117,201,170,121,205,168,123,212,172,
130,213,177,133,214,179,135,219,186,141,212,177,134,213,177,133,211,170,129,
202,160,116,196,151,106,198,153,107,178,133,88,162,117,73,150,106,62,148,
101,61,165,116,76,150,102,63,147,100,61,148,102,63,151,109,67,151,114,
76,150,120,90,157,135,112,181,166,153,196,187,187,206,200,202,211,210,214,
217,220,226,221,224,232,122,82,42,126,83,48,121,82,49,122,88,59,114,
85,62,146,119,101,133,113,98,172,154,140,151,137,121,146,125,104,114,87,
60,107,73,40,142,104,66,140,105,69,135,104,73,158,128,98,148,105,66,
170,123,77,183,135,87,189,141,91,194,148,97,206,164,112,207,169,118,204,
169,121,211,172,129,213,174,133,202,166,126,210,173,135,211,177,136,208,175,
138,204,170,133,196,163,126,186,154,121,171,141,110,168,137,106,174,147,117,
183,158,127,151,125,97,176,152,122,163,138,110,172,147,119,188,162,130,178,
150,116,168,139,103,163,130,92,160,125,90,159,123,88,152,117,83,148,114,
80,156,122,88,152,119,86,145,112,80,152,121,89,163,133,102,169,138,107,
188,157,125,170,140,109,141,113,84,139,110,84,169,138,112,182,151,124,176,
146,117,178,147,116,169,137,104,177,144,110,177,144,108,177,144,107,190,157,
118,198,165,123,205,173,128,199,167,122,198,161,117,211,170,127,213,177,133,
208,173,129,210,178,133,213,179,135,212,176,132,206,166,124,211,166,121,201,
154,105,200,152,104,183,135,88,160,114,69,148,100,60,147,100,61,153,106,
66,142,95,56,142,95,57,145,98,58,146,105,65,148,112,76,151,123,94,
157,138,118,182,169,159,196,189,190,204,200,204,209,209,213,214,218,225,220,
223,231,129,84,39,129,89,50,122,91,61,142,121,100,150,133,117,128,114,
100,136,120,105,170,150,131,154,132,108,142,114,86,119,83,48,121,79,37,
117,71,33,105,66,30,166,131,97,182,150,119,152,105,66,174,126,79,188,
138,89,189,139,87,204,158,102,210,167,114,206,171,118,202,169,120,208,168,
127,208,169,129,198,161,121,201,163,125,198,162,125,195,162,125,193,160,124,
192,158,121,183,150,116,188,155,121,181,149,115,183,151,119,176,146,115,165,
137,108,117,92,64,136,111,83,174,149,117,200,176,140,175,149,111,163,137,
97,151,118,81,144,110,77,168,131,101,148,112,85,144,109,81,152,117,89,
152,118,89,147,115,83,146,114,82,158,128,95,159,129,94,180,150,114,154,
126,91,148,118,88,136,108,81,180,151,123,181,151,122,163,133,102,164,136,
101,171,141,103,183,151,112,194,161,121,204,171,131,198,165,125,187,155,115,
187,155,115,195,162,121,201,166,123,202,163,122,205,168,123,211,175,131,211,
178,133,211,175,131,211,174,129,207,167,125,212,165,119,200,151,100,201,153,
103,192,144,96,171,125,79,153,105,65,150,102,62,142,96,57,142,95,57,
150,98,62,150,104,65,151,110,70,150,114,78,152,125,98,163,144,126,182,
171,162,199,192,195,205,202,206,209,209,215,214,218,225,215,221,231,129,81,
34,120,81,40,120,93,65,172,158,138,174,164,152,126,116,103,125,109,92,
140,116,93,126,94,63,129,91,53,132,86,43,126,76,26,120,67,22,125,
78,35,125,85,48,162,122,88,168,118,76,180,127,83,189,135,87,196,145,
95,200,153,100,204,162,111,205,167,119,212,177,130,210,174,129,205,166,126,
201,163,125,190,153,116,186,150,114,182,148,112,181,148,113,181,147,111,180,
144,108,168,132,96,177,143,107,175,140,105,169,135,102,183,151,119,168,137,
106,132,104,76,157,133,101,190,165,128,162,135,96,156,129,88,152,120,83,
152,118,86,158,122,95,157,120,95,145,109,85,141,108,82,144,111,84,153,
121,89,148,118,82,153,124,88,163,133,97,178,149,113,157,130,96,139,113,
80,163,136,105,148,120,91,145,116,85,154,125,90,159,131,93,171,138,98,
178,145,104,187,153,111,188,154,113,184,151,111,178,146,106,183,151,112,192,
158,121,196,159,122,201,161,119,207,172,129,211,176,133,207,173,131,202,168,
126,205,168,123,205,163,121,202,157,110,196,145,95,194,145,96,187,138,90,
181,134,87,163,117,72,154,106,65,142,96,57,146,99,59,147,100,61,148,
102,64,151,107,70,148,114,80,157,131,106,175,156,140,187,178,171,202,196,
199,209,205,211,211,211,217,215,218,226,213,220,229,121,76,38,117,75,41,
113,81,50,181,151,125,162,134,107,119,91,65,107,73,45,107,69,38,114,
74,34,122,78,35,127,77,32,121,72,23,128,77,30,125,77,32,133,88,
43,141,97,54,162,113,65,180,130,80,189,137,86,195,146,96,193,149,103,
193,154,111,202,169,130,206,176,139,212,176,132,201,162,119,194,156,113,195,
156,116,187,148,109,193,153,114,182,142,106,187,145,109,192,150,104,177,135,
91,156,117,74,157,119,79,165,130,93,158,125,92,182,152,122,156,128,100,
172,146,117,177,151,119,174,144,108,141,108,74,144,110,75,151,120,87,144,
114,84,141,112,82,151,122,93,139,109,84,147,117,92,138,108,74,133,102,
63,160,128,87,172,137,102,170,143,116,163,143,119,171,150,124,158,132,108,
157,125,99,115,83,52,147,111,74,158,123,79,175,132,90,178,131,93,182,
135,95,181,138,95,189,147,104,186,150,105,186,152,110,181,151,107,190,158,
114,196,162,120,202,171,134,210,179,145,211,180,146,204,172,133,204,169,125,
205,167,115,206,160,112,204,155,109,196,147,98,192,142,93,183,135,85,168,
121,73,154,108,62,151,103,59,146,101,56,144,99,55,144,102,60,146,105,
71,151,116,88,159,133,113,172,154,145,187,176,174,198,191,191,207,205,206,
210,210,214,210,213,221,212,218,227,122,76,37,120,77,42,113,77,46,123,
90,63,123,90,63,105,74,45,108,71,40,111,70,36,111,69,27,113,68,
24,117,68,23,122,73,24,119,70,21,122,75,29,132,86,40,144,98,52,
160,110,61,177,126,75,186,135,84,192,144,95,205,160,113,202,163,122,218,
185,147,196,164,132,193,159,118,193,158,116,192,155,116,192,154,114,194,154,
115,200,156,116,192,149,110,175,129,91,187,146,100,175,135,91,169,130,88,
162,124,85,136,102,66,160,127,92,181,148,116,171,141,110,188,157,126,171,
140,108,165,131,96,135,100,65,140,105,69,148,114,80,142,111,79,141,111,
79,142,112,81,144,113,88,174,141,114,172,138,104,147,116,73,150,116,74,
162,127,90,157,125,93,154,124,93,162,130,99,184,149,120,130,94,65,117,
82,48,156,117,77,168,130,84,165,124,83,168,121,86,169,121,83,158,111,
72,162,113,73,175,131,88,183,141,99,183,142,101,193,157,114,195,161,121,
194,164,127,199,169,138,208,177,146,202,171,134,194,160,117,199,163,110,207,
160,112,202,153,108,198,148,99,188,139,89,176,127,76,166,119,70,158,111,
65,153,106,62,147,101,56,144,99,55,144,102,60,148,108,72,150,117,84,
165,139,116,168,151,137,189,179,172,200,193,190,205,201,203,209,209,213,216,
217,224,217,222,233,127,77,36,123,78,40,117,78,45,110,76,48,110,77,
49,107,72,42,123,81,47,111,68,32,111,68,26,115,68,25,115,67,20,
114,65,16,116,67,19,120,72,24,128,80,36,148,101,55,164,114,64,180,
129,78,187,136,85,192,144,95,186,142,97,189,150,110,195,162,125,195,165,
131,189,158,121,189,157,120,184,149,113,182,144,106,186,145,105,170,127,85,
153,107,68,162,116,75,169,132,90,170,133,94,157,121,85,146,111,76,130,
96,63,138,103,69,171,136,101,162,128,93,163,129,95,158,122,87,145,108,
70,135,98,59,145,106,67,138,103,67,139,107,73,148,117,79,152,119,86,
159,124,96,180,145,116,141,106,70,129,95,52,148,113,69,162,124,85,163,
123,84,148,107,67,145,106,67,166,127,92,125,91,57,136,101,67,162,128,
90,163,130,89,164,129,94,178,138,106,170,127,92,147,101,64,140,93,54,
138,89,50,163,114,75,182,134,95,186,146,107,187,153,116,181,150,116,180,
150,119,190,159,128,190,159,122,198,163,119,196,158,110,194,148,101,200,150,
104,199,150,102,189,141,91,176,127,76,165,117,68,159,112,66,152,104,61,
146,101,56,146,101,56,145,101,58,151,111,71,158,124,89,175,147,119,171,
153,132,186,177,162,192,186,183,200,196,197,208,208,212,217,219,226,220,226,
236,123,73,31,120,72,34,138,95,60,116,79,48,103,71,40,127,88,55,
164,119,81,125,78,39,113,69,25,115,69,23,117,69,22,121,70,20,121,
70,20,135,84,37,140,92,44,151,103,56,162,112,62,178,127,77,183,132,
81,188,140,91,190,146,101,184,145,105,182,149,113,184,153,122,188,159,128,
176,146,115,171,139,103,176,139,101,164,124,84,144,102,60,147,101,56,162,
116,70,169,132,95,171,137,103,174,141,107,156,124,91,139,108,76,117,85,
53,156,120,83,156,118,80,147,110,73,147,109,70,150,109,68,140,99,59,
140,100,61,134,98,61,160,126,88,152,117,81,152,118,83,154,119,90,168,
131,100,130,93,56,122,85,41,138,100,54,152,112,72,153,112,71,140,98,
56,120,83,46,121,88,55,79,54,28,123,100,71,125,102,73,107,86,56,
99,80,52,105,82,54,102,75,42,114,77,40,113,73,33,114,70,31,130,
86,49,147,104,68,164,126,91,166,132,98,165,134,103,175,144,112,181,151,
118,187,156,118,194,160,117,195,158,112,195,149,104,194,144,99,194,145,97,
190,142,92,182,133,82,171,123,74,160,114,68,153,106,62,150,102,59,147,
99,56,147,102,61,154,113,73,159,123,86,160,134,103,168,150,123,176,165,
145,184,177,173,201,197,198,214,214,218,222,224,231,220,225,236,128,78,36,
116,69,31,144,100,65,120,83,52,105,73,41,116,78,46,116,74,39,113,
68,30,121,74,30,119,69,24,120,71,22,126,72,22,133,78,28,138,85,
36,148,96,49,159,111,63,170,119,68,180,129,78,184,132,81,186,139,90,
184,139,94,180,141,101,189,157,120,180,149,117,178,152,120,175,145,114,164,
131,97,148,112,76,133,94,56,123,81,40,119,74,30,129,82,40,121,89,
54,108,81,51,95,72,44,95,73,46,115,92,63,89,64,34,108,79,44,
134,97,59,144,104,65,153,110,71,145,103,61,145,101,58,145,104,63,150,
113,75,141,108,74,151,117,81,152,118,83,153,117,88,146,109,79,135,98,
61,133,97,51,150,112,65,154,113,73,156,117,78,145,109,73,91,64,36,
78,57,32,55,42,22,36,28,13,26,19,7,24,18,6,30,24,8,31,
24,5,35,22,0,60,37,4,73,44,7,105,72,32,125,90,54,145,113,
80,146,114,82,164,130,99,166,135,103,175,144,112,181,151,116,184,153,116,
190,155,114,187,149,107,183,139,96,188,139,93,181,133,86,181,132,82,171,
122,72,170,122,74,164,117,71,158,109,65,153,106,62,152,106,60,153,108,
63,156,114,72,166,128,90,154,127,94,159,140,112,168,157,137,192,185,181,
214,212,213,217,217,221,222,224,231,220,225,236,126,76,35,115,71,33,113,
73,40,125,89,60,180,144,114,128,92,61,113,72,38,117,73,36,120,74,
28,120,71,23,123,72,21,128,75,22,134,80,27,139,87,35,141,92,43,
142,92,46,159,109,59,176,125,74,183,132,81,181,133,84,183,139,94,187,
151,107,188,155,119,182,151,119,171,140,110,159,127,96,159,125,91,148,111,
74,122,84,47,96,58,20,85,46,7,63,28,0,49,26,2,43,26,4,
42,29,8,32,21,5,28,19,3,32,21,3,51,35,7,91,67,31,123,
85,47,141,100,60,142,99,57,150,107,65,148,108,69,159,123,86,150,117,
84,151,120,84,148,115,82,157,123,95,150,115,87,132,98,63,139,104,60,
130,95,52,151,113,76,145,112,79,148,119,89,109,88,62,40,30,14,13,
11,3,19,17,7,22,18,7,24,18,7,28,22,7,25,18,1,55,40,
11,90,63,23,93,62,23,103,74,36,108,84,50,111,92,63,132,105,78,
140,107,80,154,124,94,183,152,119,182,153,117,175,144,107,182,147,108,186,
147,108,182,135,95,181,132,87,177,129,82,183,135,85,177,128,77,171,123,
74,166,119,72,163,115,71,159,111,66,154,106,59,154,108,62,151,109,67,
162,125,88,168,138,108,158,138,114,180,167,152,200,193,190,205,201,202,210,
210,214,217,219,226,219,225,235,119,73,35,111,69,34,104,69,39,145,111,
83,199,164,134,163,130,97,164,124,91,136,92,56,121,72,30,123,74,25,
129,77,26,134,78,27,141,84,32,142,89,36,153,101,53,166,114,67,172,
121,71,175,124,74,176,125,74,178,131,82,187,143,98,184,148,105,182,149,
113,188,157,125,183,149,116,158,122,89,142,108,73,126,89,53,114,77,40,
107,69,30,104,65,25,105,70,28,86,60,25,40,24,2,31,21,4,22,
17,3,17,14,3,22,17,2,18,11,0,59,42,11,135,98,59,142,102,
62,138,97,57,146,105,65,156,118,80,148,115,82,141,112,82,147,118,86,
157,127,95,152,120,95,150,117,90,154,121,87,156,122,80,115,82,43,119,
86,52,110,81,52,95,71,47,165,146,118,41,32,15,14,11,2,16,12,
2,19,12,0,35,22,4,61,42,19,98,73,45,127,93,58,127,87,47,
117,77,38,104,69,35,119,92,64,158,138,116,157,131,109,154,121,94,154,
124,94,168,140,106,189,160,123,186,155,116,189,155,116,189,151,114,188,141,
102,181,132,87,175,127,79,172,124,74,172,123,73,174,125,77,169,122,75,
164,115,71,164,116,68,159,110,61,154,107,61,146,104,62,151,112,78,168,
136,111,168,146,128,190,176,166,201,193,191,208,206,207,213,213,217,212,214,
223,217,224,233,121,77,40,109,68,33,104,68,38,109,78,50,121,91,61,
133,97,67,135,96,63,122,79,44,115,65,23,122,72,22,128,76,24,133,
74,24,144,87,35,148,93,42,156,105,54,162,110,62,165,114,63,169,118,
68,175,126,76,186,139,90,183,140,96,182,142,102,184,152,115,184,151,118,
171,134,101,156,120,85,139,103,69,128,92,57,126,88,51,126,87,48,126,
87,47,122,85,44,132,104,63,103,80,45,50,37,13,24,19,4,14,12,
2,14,11,0,16,11,0,36,26,3,110,76,39,119,80,42,122,83,44,
145,106,67,163,127,89,157,127,93,152,124,96,142,114,84,164,134,104,152,
121,96,151,120,94,166,133,100,146,115,75,158,125,84,142,110,76,96,68,
41,63,41,19,49,33,16,32,22,6,36,25,6,47,33,8,79,56,25,
115,85,48,129,94,60,130,90,60,130,84,49,129,78,40,127,77,39,132,
87,56,128,92,68,164,138,120,152,123,104,135,102,75,132,102,72,150,121,
87,168,138,101,182,151,113,187,152,116,183,146,110,192,146,108,184,137,91,
181,133,86,172,124,74,171,121,71,176,128,78,174,125,77,162,115,69,160,
112,64,156,106,57,153,106,59,153,106,66,160,120,87,166,134,112,170,146,
133,184,169,162,193,186,184,205,203,204,207,207,211,216,218,227,216,223,232,
120,77,41,117,73,37,119,72,34,122,72,32,128,76,32,127,75,32,125,
74,32,123,72,29,128,72,22,127,74,21,129,71,22,130,75,25,132,78,
28,140,86,37,147,96,45,151,99,47,163,112,58,170,122,68,172,127,81,
176,133,90,174,135,96,187,151,113,181,144,107,171,136,101,153,120,88,130,
97,65,104,72,40,110,75,40,122,82,46,134,90,54,127,82,44,126,83,
41,129,93,48,135,100,56,132,95,57,101,67,32,74,45,15,59,34,7,
45,25,3,45,25,0,83,49,16,101,64,30,121,85,48,144,108,71,159,
127,91,172,142,107,153,126,92,147,117,86,165,131,103,151,118,90,157,123,
93,157,123,90,148,114,79,144,111,75,116,85,50,79,54,24,55,35,11,
59,35,11,71,45,17,89,58,27,97,63,28,123,83,44,129,86,43,117,
76,36,111,69,33,116,70,32,126,76,35,144,91,52,152,101,66,126,82,
53,103,67,43,107,72,43,113,78,43,138,103,67,146,112,75,158,126,87,
178,144,107,183,148,112,192,157,121,183,144,105,180,136,92,171,124,77,171,
121,71,168,116,63,172,119,66,172,121,68,172,121,69,163,116,67,163,116,
69,154,108,62,154,109,65,160,119,82,165,131,103,169,149,129,178,167,157,
189,185,182,198,197,198,207,207,211,214,218,225,220,223,233,113,73,36,111,
67,30,119,70,30,117,65,23,123,68,24,123,68,24,123,69,26,123,70,
25,129,73,21,126,68,19,128,70,21,133,78,27,132,80,28,136,82,33,
136,86,36,154,102,50,162,112,56,162,112,60,162,117,70,169,128,85,165,
127,88,183,146,108,194,155,117,183,145,108,150,116,83,133,100,67,114,81,
48,117,81,45,138,97,60,133,89,52,123,78,40,121,79,37,107,68,25,
103,63,23,113,72,32,117,74,38,117,75,39,99,63,28,89,58,24,73,
45,12,72,39,7,84,50,17,133,96,60,135,102,68,163,131,95,169,140,
104,153,125,91,154,123,91,157,121,93,156,121,91,158,125,92,158,124,91,
148,114,79,107,76,42,96,67,32,68,44,16,75,53,26,102,73,44,113,
82,50,104,71,37,109,71,34,109,69,29,104,63,22,102,59,23,103,60,
24,109,64,26,120,73,34,144,96,55,141,96,58,145,103,70,153,115,85,
151,116,82,140,106,68,153,117,80,166,131,93,169,136,99,164,132,96,158,
128,92,170,140,104,172,136,99,172,129,86,166,120,75,168,118,69,168,115,
63,171,118,64,168,115,61,169,118,65,160,112,64,158,111,65,156,109,63,
160,112,69,164,124,84,168,135,105,172,151,131,183,173,162,192,188,185,202,
202,202,209,210,213,212,216,223,217,220,230,108,68,32,110,66,29,117,67,
27,120,68,24,123,68,24,125,69,24,125,71,25,126,72,27,126,70,18,
129,71,22,130,72,23,126,72,22,123,71,20,134,80,31,135,84,34,147,
95,43,157,104,49,163,112,59,156,110,63,147,108,64,156,117,78,168,132,
95,180,141,103,175,137,100,151,118,84,169,134,99,174,135,100,164,125,87,
159,116,78,163,121,79,153,110,68,127,85,44,107,67,27,103,62,22,107,
61,23,111,66,28,116,71,33,111,69,33,110,72,35,97,63,27,86,53,
20,92,57,27,117,81,48,151,117,81,168,133,98,172,140,105,168,140,105,
157,125,93,162,127,98,174,140,107,172,138,105,158,124,91,144,111,77,125,
92,58,117,85,52,91,63,34,89,65,37,164,135,102,176,143,108,113,80,
46,113,76,40,99,62,25,105,66,27,122,78,41,121,80,42,128,84,45,
136,90,52,144,103,62,159,120,80,170,135,97,169,136,102,171,139,103,174,
140,103,176,143,106,170,138,102,171,140,103,158,129,94,150,121,87,145,118,
85,144,111,77,146,107,68,151,109,67,159,112,66,162,112,62,165,113,62,
163,112,59,165,115,63,159,111,63,154,108,62,153,106,60,154,109,65,156,
116,77,159,126,96,162,141,120,174,164,152,189,185,182,201,201,201,213,214,
217,216,220,227,221,225,235,115,74,37,121,75,37,113,65,24,117,66,22,
123,67,21,123,67,21,122,69,24,122,70,22,129,73,21,128,70,21,127,
69,20,123,69,20,127,75,23,132,79,30,140,89,38,147,95,43,154,101,
48,147,96,46,142,98,52,150,110,69,164,128,89,166,133,93,164,131,94,
176,140,104,181,147,111,182,147,110,183,147,110,183,145,108,175,137,97,158,
118,79,154,114,74,141,101,61,125,83,44,120,76,39,115,69,32,117,70,
30,129,80,40,129,82,43,122,79,43,116,75,40,96,61,31,157,118,85,
156,121,86,163,128,93,171,137,103,174,142,107,175,145,111,157,125,93,172,
138,105,157,123,90,169,134,100,170,136,101,159,125,91,154,121,87,135,102,
68,126,95,65,95,68,41,105,77,48,114,84,53,129,95,61,119,84,48,
109,72,36,111,73,35,111,71,35,123,81,46,145,104,64,154,115,76,164,
130,89,170,137,97,181,155,115,181,155,116,183,156,118,184,153,116,192,162,
127,188,160,125,186,158,123,184,158,126,188,162,130,188,163,132,186,156,123,
176,140,104,166,125,85,158,113,68,151,103,56,159,109,58,163,112,59,165,
115,63,158,111,62,153,106,60,154,108,62,156,111,66,153,113,74,158,125,
95,165,144,124,183,174,162,195,191,188,202,202,202,211,212,215,218,222,229,
221,225,235,136,95,55,111,67,27,123,73,31,120,69,22,119,65,16,123,
69,20,120,68,20,121,67,21,126,70,18,120,63,14,122,64,16,128,74,
24,128,76,25,133,80,31,138,87,36,138,87,36,141,90,40,156,109,60,
164,121,76,174,135,96,174,141,105,181,151,115,177,149,114,190,159,122,196,
165,128,190,159,122,189,155,121,194,160,125,198,162,125,184,151,113,175,139,
102,151,115,78,129,91,57,130,89,54,127,85,46,119,73,34,132,85,45,
127,81,42,125,83,47,120,80,47,122,87,57,146,109,79,163,126,95,169,
135,102,168,134,100,177,143,107,168,136,100,171,136,101,178,144,109,166,132,
97,163,128,93,165,131,96,163,129,95,158,125,92,147,114,81,135,104,73,
111,83,55,98,70,42,110,81,49,132,99,65,132,98,63,117,82,47,122,
85,49,122,87,51,119,85,52,133,99,64,158,128,91,168,139,103,175,149,
111,183,160,121,168,146,106,184,160,124,187,160,128,183,157,125,193,167,134,
189,164,133,198,173,143,195,172,141,193,171,141,199,173,142,188,155,121,184,
146,109,184,141,98,177,130,82,164,115,64,163,113,61,158,108,57,159,112,
63,157,110,63,153,106,60,154,107,65,154,115,76,157,126,95,168,147,126,
188,178,166,198,194,191,206,206,206,214,215,218,216,220,227,222,226,236,120,
79,39,108,66,24,120,71,27,123,71,24,126,72,22,126,72,22,123,71,
23,128,77,26,129,73,21,130,72,23,132,73,24,132,77,27,132,80,28,
132,79,30,132,82,32,138,88,39,150,100,54,164,119,74,175,135,95,184,
153,115,190,163,130,199,175,142,206,183,149,201,177,145,196,170,136,190,163,
130,183,156,123,182,155,122,186,159,125,187,161,128,183,156,123,182,155,121,
153,122,92,151,117,84,147,111,73,141,101,61,121,81,42,129,90,52,135,
99,63,123,88,56,148,113,85,154,119,91,164,129,101,164,129,99,171,137,
103,176,141,106,178,144,109,172,137,102,158,124,89,165,131,95,171,136,101,
160,126,93,164,130,97,154,118,88,147,112,83,139,108,77,123,93,63,108,
80,49,111,82,50,127,94,61,138,105,71,134,100,66,150,114,78,152,118,
84,151,122,90,169,142,110,184,159,129,181,160,131,175,152,123,172,150,117,
186,162,127,188,163,130,189,165,135,188,163,132,183,159,130,199,176,148,198,
178,149,198,178,149,192,172,146,196,174,146,200,169,138,198,163,127,192,152,
110,178,134,88,170,123,74,165,116,65,158,109,59,156,109,60,154,108,62,
151,105,59,152,106,63,152,112,73,166,133,103,176,155,134,184,173,162,196,
192,189,214,214,214,223,224,227,220,224,231,222,226,236,110,70,30,114,71,
28,115,68,22,119,69,20,128,72,22,128,75,22,125,73,22,129,77,26,
128,72,20,125,67,18,127,69,20,132,77,27,130,78,26,133,80,31,134,
84,34,147,96,46,157,109,68,170,125,87,176,139,103,182,155,121,188,167,
138,189,169,140,202,186,156,204,188,158,201,178,149,192,169,139,186,163,134,
188,167,136,189,167,138,194,172,142,189,169,140,187,165,137,169,145,119,163,
137,106,151,122,87,134,102,62,140,106,65,141,109,70,133,101,68,139,106,
78,142,109,83,152,118,90,162,127,99,168,133,103,163,129,95,177,142,107,
164,129,94,156,121,86,162,130,90,159,124,88,163,128,93,158,124,91,162,
129,96,152,118,89,154,119,91,142,111,80,134,105,73,121,93,61,126,95,
63,125,94,62,133,102,67,133,100,67,148,114,80,157,129,98,170,148,119,
186,166,140,180,163,139,170,152,131,181,163,138,178,155,129,189,160,131,183,
159,129,184,162,133,175,154,125,198,177,149,189,170,142,188,170,143,189,173,
148,186,170,146,181,160,134,178,151,123,182,149,115,186,147,108,183,139,94,
177,130,82,169,120,71,166,117,67,158,112,64,154,108,62,151,105,59,152,
106,63,156,116,77,164,133,102,178,157,136,189,180,169,196,192,189,205,205,
205,215,216,219,220,224,231,222,226,236,142,98,54,130,85,41,113,67,21,
122,71,21,123,69,19,127,74,22,125,73,22,126,72,23,127,74,21,130,
73,24,133,74,24,130,73,26,129,77,26,134,82,34,132,83,35,144,94,
47,148,105,66,164,127,91,176,143,111,188,163,134,193,176,149,195,181,155,
199,187,160,201,187,161,193,175,147,195,177,149,193,174,145,188,169,141,187,
169,143,177,159,133,187,169,144,192,174,150,200,180,158,187,168,139,171,147,
113,153,126,88,151,120,81,134,106,70,138,111,78,138,111,83,140,108,83,
159,126,99,158,124,97,169,135,104,166,132,98,172,137,102,162,127,93,153,
118,83,164,129,94,165,131,95,164,131,96,158,125,92,164,129,99,153,117,
89,154,119,91,140,108,79,138,107,76,121,91,61,128,98,67,128,96,64,
144,112,80,144,113,80,157,126,92,172,148,119,186,172,147,193,180,155,187,
174,154,184,169,151,186,168,147,189,165,142,190,161,135,186,160,133,181,160,
134,182,163,135,190,170,145,195,179,155,195,179,156,187,171,148,181,165,143,
186,168,144,193,168,139,196,164,132,193,155,116,187,144,100,181,134,86,164,
116,66,164,116,66,157,110,62,157,110,63,153,106,60,154,107,65,158,118,
79,166,133,103,169,147,126,183,172,160,201,196,193,208,208,208,214,215,218,
221,224,230,221,225,235,134,84,41,121,72,30,115,63,20,123,69,24,123,
69,20,130,72,23,129,75,21,130,74,23,125,70,24,129,74,28,126,70,
23,126,72,26,128,75,30,126,77,35,132,85,45,147,102,65,162,126,91,
180,148,116,190,165,137,192,173,150,200,186,166,202,190,172,198,187,169,196,
184,165,186,172,151,183,168,145,178,162,136,175,159,130,192,173,144,194,173,
148,199,176,156,194,173,156,199,182,164,204,186,164,199,174,148,176,149,117,
154,125,91,138,112,79,127,105,73,135,111,81,142,107,89,156,124,102,156,
127,99,152,127,93,169,143,105,170,139,102,168,133,98,162,128,94,164,131,
101,156,123,94,166,133,103,154,121,91,150,117,89,151,118,90,152,118,90,
139,112,85,122,97,72,125,99,73,133,105,76,128,98,68,140,110,80,151,
122,94,172,145,117,188,170,151,201,190,179,205,194,183,195,183,170,192,181,
164,192,179,160,184,170,148,182,166,142,181,164,140,181,164,140,188,171,151,
196,179,163,199,184,170,194,180,167,192,179,164,188,177,160,189,175,152,188,
168,138,186,158,127,177,144,107,189,148,106,189,145,99,184,137,91,174,127,
79,170,123,75,162,114,67,154,108,62,154,106,65,152,108,72,163,127,98,
175,150,126,183,169,152,199,191,186,212,207,204,212,212,212,219,221,225,220,
223,231,119,68,27,121,69,28,125,71,28,129,77,29,128,72,25,133,74,
24,130,73,21,129,75,22,130,75,29,130,75,29,130,73,26,134,78,30,
136,82,36,152,102,57,168,123,78,178,135,93,175,138,104,189,157,125,199,
172,146,208,187,165,204,189,168,196,181,163,199,186,168,194,181,163,190,179,
162,193,181,161,186,173,149,175,161,135,158,142,117,180,163,141,201,182,163,
204,184,170,198,185,169,208,193,175,206,186,163,184,158,131,168,142,111,142,
117,87,141,118,88,138,113,86,148,113,94,147,112,90,162,133,103,183,156,
119,169,142,104,158,128,92,160,125,90,154,119,88,168,133,103,157,122,93,
157,122,93,159,123,94,153,118,89,148,114,85,147,112,83,138,111,83,123,
99,74,120,95,69,132,105,77,139,111,83,144,117,90,144,120,96,165,142,
119,195,180,166,210,204,196,201,193,183,192,184,173,193,185,170,196,186,171,
193,183,165,187,177,158,188,175,155,189,175,154,192,178,160,195,182,166,198,
184,173,196,182,169,183,170,154,174,161,143,175,159,135,183,161,132,183,156,
123,184,151,111,176,136,92,180,135,89,178,130,82,172,124,76,163,116,67,
158,112,64,156,108,61,157,107,66,159,114,78,164,129,99,166,140,117,177,
162,144,194,185,179,206,200,198,210,210,210,216,217,220,216,219,227,121,69,
28,125,74,32,125,71,28,125,70,24,128,72,25,134,75,26,130,73,21,
130,75,21,133,80,27,132,79,27,138,84,31,140,87,34,144,91,39,144,
95,45,136,92,48,132,90,48,148,109,73,168,134,100,169,140,112,170,147,
123,186,168,146,190,173,154,192,175,156,200,184,166,190,182,166,192,184,168,
189,182,163,188,179,158,183,172,152,166,156,138,178,164,150,200,187,174,202,
195,182,217,208,194,219,203,184,199,178,156,171,147,124,144,119,96,150,123,
101,139,111,88,164,127,105,163,127,103,153,121,91,169,140,104,163,132,95,
153,120,85,169,134,99,162,126,93,158,122,91,156,119,88,159,122,91,162,
125,94,160,123,93,152,116,86,147,111,80,142,113,84,129,107,80,120,97,
70,126,101,75,134,108,82,136,113,90,162,140,122,200,183,166,212,201,191,
206,204,198,194,191,185,189,185,176,184,179,170,181,174,163,175,167,154,174,
167,152,180,173,157,181,173,158,183,175,160,189,179,167,189,177,165,182,168,
152,187,171,152,183,167,143,176,157,131,182,158,128,181,151,116,188,151,111,
180,136,92,172,125,76,163,115,66,164,114,64,162,114,65,160,112,64,158,
111,65,157,109,68,158,114,78,163,127,97,166,140,117,166,151,133,181,172,
167,193,188,186,204,202,203,211,212,215,218,221,229,122,71,29,123,72,30,
125,71,28,132,79,31,132,75,28,139,80,30,138,80,27,138,83,28,134,
80,27,130,77,24,132,78,24,123,69,16,125,73,22,122,75,26,129,85,
39,146,103,59,162,122,83,163,126,92,164,133,102,189,163,137,194,174,150,
195,177,156,198,180,159,193,176,155,188,183,170,194,190,177,195,190,178,187,
183,167,182,177,161,182,177,162,184,179,166,181,174,163,170,169,159,194,191,
181,215,206,194,213,199,184,186,166,149,141,117,101,138,112,94,139,111,92,
160,124,101,159,123,99,163,127,98,170,136,102,163,128,93,172,137,102,183,
148,114,158,122,91,162,128,94,164,130,96,154,118,87,153,116,86,159,122,
91,152,118,86,146,109,79,141,114,84,130,109,80,127,105,77,126,104,77,
127,105,83,160,141,122,204,189,174,214,203,193,202,198,192,184,184,179,172,
172,169,171,171,165,158,156,149,164,162,153,170,166,157,174,171,161,181,179,
167,182,181,168,182,178,168,183,177,167,188,179,166,187,174,158,189,173,152,
195,177,151,189,169,140,175,150,119,183,153,116,182,146,102,188,142,96,187,
139,90,175,124,74,160,110,60,154,106,57,152,105,58,154,108,62,157,107,
66,157,113,77,159,123,94,170,144,121,178,163,145,184,176,170,192,187,185,
202,200,200,206,207,210,214,217,225,122,71,29,123,72,30,129,75,31,129,
77,29,136,80,32,138,79,29,136,78,26,135,80,26,132,79,26,132,80,
26,126,72,19,132,78,24,128,77,26,135,87,38,136,91,45,146,103,59,
158,118,79,172,133,100,190,158,126,192,166,139,188,166,143,188,170,149,184,
167,146,183,167,147,182,178,166,177,175,163,164,162,151,171,169,158,176,175,
164,168,167,157,168,167,157,188,188,177,193,193,186,190,190,183,182,180,172,
202,194,184,204,191,180,144,125,113,130,108,94,138,113,96,147,116,92,157,
123,96,168,132,103,169,135,102,160,126,93,164,130,99,163,130,102,156,125,
96,153,121,91,154,121,91,144,111,84,151,119,90,150,117,87,152,119,90,
148,115,86,136,110,83,129,109,84,122,101,76,99,80,58,127,109,89,180,
167,152,201,193,183,176,173,168,175,176,173,186,190,185,180,182,179,168,170,
164,158,158,154,144,144,139,163,163,157,166,166,160,167,168,160,168,170,159,
169,170,160,169,165,156,165,157,146,177,165,149,184,169,146,186,168,142,183,
164,134,176,152,122,159,130,96,168,133,93,177,135,91,172,125,76,172,124,
74,163,113,64,163,115,66,159,112,64,156,108,61,157,107,66,159,114,78,
164,129,99,170,144,121,178,163,145,190,182,175,204,198,196,204,202,202,210,
211,214,212,215,223,116,65,24,119,68,27,127,74,30,129,75,29,132,75,
28,134,75,26,135,78,25,135,80,26,127,75,23,125,72,20,129,76,24,
133,80,27,136,84,33,133,85,38,139,95,51,146,104,62,164,123,87,195,
160,125,186,156,127,182,158,133,170,152,131,172,155,136,182,166,146,199,184,
166,190,184,171,186,183,172,180,178,170,168,167,160,168,168,160,181,182,172,
174,175,163,158,159,147,148,148,141,174,174,168,205,205,197,194,192,185,190,
182,173,150,138,126,120,104,89,138,117,100,147,120,98,158,129,105,162,129,
103,166,132,103,165,131,103,157,125,99,146,119,94,146,118,94,151,121,96,
144,117,90,147,119,92,144,117,90,141,114,87,141,113,88,146,118,91,140,
116,93,135,115,95,113,94,74,102,86,67,111,97,82,144,136,124,169,169,
161,191,194,189,199,204,198,181,184,179,155,158,152,146,148,143,157,158,152,
165,165,161,166,166,162,162,161,158,173,174,166,178,182,172,183,183,174,195,
193,184,195,189,178,192,184,168,182,170,150,188,173,147,183,166,140,181,158,
131,189,162,129,182,149,112,174,133,93,171,126,81,163,118,72,159,114,67,
157,111,63,154,107,61,153,106,60,153,104,63,157,113,77,166,130,100,172,
147,123,182,168,150,190,181,175,201,195,193,201,199,200,206,207,210,211,215,
224,122,71,29,122,71,29,128,74,30,127,74,26,132,75,28,134,75,26,
135,78,25,135,78,27,134,78,31,130,75,29,134,78,30,136,80,32,134,
82,34,146,95,53,164,119,74,174,131,89,178,142,106,163,131,100,169,143,
117,162,141,120,181,165,145,198,185,167,199,186,168,188,174,158,187,181,167,
175,171,160,175,172,165,170,168,164,172,171,166,169,170,160,149,152,139,152,
154,141,153,152,143,158,158,152,174,174,169,170,171,165,190,189,181,154,148,
136,96,86,71,148,134,113,160,138,116,162,137,112,159,129,105,153,122,97,
156,126,102,153,127,105,139,115,96,135,111,91,140,115,93,133,108,86,140,
115,93,139,114,91,139,114,91,139,114,91,150,124,101,154,130,111,134,112,
98,133,114,98,77,62,49,86,76,64,176,173,161,183,187,178,157,168,160,
166,172,166,157,159,152,138,139,131,127,127,121,139,139,133,145,144,140,152,
150,146,157,154,150,159,159,150,143,146,133,161,162,151,158,157,146,169,165,
154,177,170,156,187,178,159,190,179,156,186,173,147,190,174,149,177,153,124,
165,135,99,176,139,101,183,141,99,180,136,92,168,124,79,153,109,63,158,
111,64,158,111,64,157,107,66,156,111,75,159,123,94,164,139,115,171,156,
139,186,179,172,194,189,187,202,200,200,210,211,214,214,218,225,120,69,27,
122,71,29,129,75,30,130,75,29,136,80,30,136,80,29,135,80,26,134,
80,27,129,75,29,134,80,34,134,78,33,145,87,41,152,98,52,151,101,
58,144,97,58,148,108,69,154,120,87,177,146,116,180,154,128,183,163,141,
181,166,147,177,165,149,175,162,147,178,167,150,182,175,161,180,173,162,180,
176,168,181,179,174,171,171,165,155,156,147,156,157,145,154,156,141,147,146,
137,152,152,145,157,158,152,180,182,175,180,181,171,145,145,131,107,102,84,
154,144,122,162,144,122,175,153,130,148,122,101,154,127,105,158,132,110,127,
105,88,104,86,72,108,91,74,92,75,57,111,92,73,133,112,92,144,123,
103,136,116,96,144,122,101,158,137,116,157,136,118,157,135,123,148,130,116,
103,90,77,86,79,67,146,144,133,145,151,141,140,152,144,152,160,152,159,
160,151,168,169,159,152,153,143,168,168,160,172,171,166,165,164,157,175,172,
167,169,169,159,176,177,165,168,168,157,184,183,172,181,178,167,188,184,170,
178,172,155,182,175,153,184,173,151,178,162,139,186,165,138,188,161,128,170,
137,101,159,122,80,151,111,70,159,117,75,152,108,64,154,107,61,151,105,
59,152,104,64,156,113,77,160,125,95,162,138,114,166,151,133,186,177,170,
184,178,175,193,192,192,204,204,208,209,212,219,119,68,27,122,69,27,128,
72,27,135,76,27,132,78,24,133,79,26,133,82,30,130,82,29,133,82,
31,135,82,33,148,91,43,139,83,38,138,86,42,141,93,50,146,105,62,
151,115,71,166,138,102,182,155,122,182,156,130,183,160,138,184,165,146,177,
160,142,187,172,154,195,181,164,188,182,168,184,183,168,181,182,168,178,182,
168,160,164,150,148,152,140,160,163,152,148,150,140,164,171,160,175,181,169,
173,177,167,162,164,151,142,142,128,121,119,106,119,114,98,147,140,123,166,
152,128,172,157,133,147,131,109,133,118,99,122,109,93,55,51,38,22,22,
14,23,22,14,30,28,19,44,39,28,83,72,59,129,114,99,121,105,90,
163,147,128,165,148,129,162,145,125,157,140,120,126,112,95,132,122,107,97,
91,81,136,135,128,151,154,150,139,144,143,150,154,150,140,142,134,158,160,
152,161,163,155,151,152,145,168,169,161,163,164,156,168,169,161,166,168,160,
162,163,157,163,163,157,159,158,150,172,169,159,177,173,162,176,169,157,187,
179,165,180,169,152,193,176,159,181,161,140,172,146,121,178,147,116,177,142,
105,171,131,91,156,114,72,157,113,70,153,106,63,152,109,66,152,109,70,
150,113,77,152,123,93,154,132,108,166,151,133,177,168,156,188,182,173,189,
187,184,200,200,202,205,208,213,125,75,34,126,74,31,128,73,27,133,74,
24,136,82,28,136,83,29,135,85,32,132,85,32,132,84,30,133,81,30,
133,77,30,128,72,27,128,75,31,145,95,50,148,102,57,168,125,81,157,
127,90,151,124,91,157,131,106,166,144,122,170,150,133,195,178,162,187,173,
158,188,175,160,184,178,168,182,180,170,179,180,168,172,176,164,149,154,144,
160,165,156,144,146,138,152,153,147,162,169,161,169,176,168,170,175,167,164,
166,157,156,156,146,116,114,103,157,154,142,154,148,134,180,172,152,189,178,
159,176,164,147,122,112,97,66,59,47,18,17,10,19,20,12,20,23,14,
13,14,8,17,17,11,36,32,23,73,64,54,116,104,93,174,163,150,189,
179,165,182,172,157,159,148,132,163,155,141,122,116,104,103,101,92,138,138,
132,123,126,123,142,146,143,173,175,172,160,162,154,155,157,150,144,146,139,
145,147,140,144,146,139,163,165,157,166,168,160,166,168,162,171,172,167,167,
168,162,183,182,176,172,169,160,183,178,169,177,170,160,176,168,155,182,171,
157,190,174,158,186,166,147,182,159,137,177,149,121,171,137,103,156,119,82,
163,122,82,152,110,69,151,105,67,153,109,71,159,118,80,160,125,90,154,
127,98,154,135,113,166,153,137,174,166,154,184,179,170,189,188,186,198,200,
202,205,208,213,125,75,35,126,77,35,133,79,34,138,83,32,141,87,34,
140,87,34,136,85,33,133,85,32,132,84,31,133,83,31,134,82,30,139,
85,35,148,92,46,145,91,48,162,109,65,146,97,56,145,109,72,147,118,
83,162,136,107,172,148,128,181,161,145,180,167,152,180,171,157,174,167,154,
170,165,157,175,174,167,173,174,166,163,166,160,163,168,160,153,157,151,158,
160,156,159,159,156,159,163,159,164,170,164,161,165,161,150,152,146,123,123,
116,140,139,133,156,154,147,184,181,173,188,183,173,205,199,189,168,162,152,
97,92,82,31,30,23,23,24,16,17,20,12,16,20,11,12,16,8,21,
24,15,20,20,14,25,24,19,83,81,73,174,172,164,184,182,177,180,177,
171,177,175,167,151,150,142,135,135,129,138,139,134,122,123,120,130,133,128,
165,168,165,173,176,171,178,180,175,181,183,178,176,178,173,180,182,177,163,
165,159,175,177,172,169,171,165,164,166,160,152,153,149,158,158,152,156,155,
149,169,166,158,181,176,165,190,183,171,190,183,170,178,169,155,182,168,155,
186,170,155,194,173,152,184,160,133,189,157,125,177,142,105,166,127,88,152,
112,72,147,105,67,145,106,67,152,116,80,158,126,94,160,134,108,164,147,
127,162,152,137,176,168,159,183,180,173,190,190,189,196,199,202,204,208,214,
125,78,39,127,78,37,133,80,36,139,87,35,144,87,36,141,87,34,136,
85,33,133,83,32,130,82,29,127,79,26,134,84,33,141,90,40,145,90,
44,152,98,54,144,91,47,156,103,61,154,116,77,163,132,95,169,140,112,
181,158,136,187,169,154,177,167,156,178,172,161,190,187,177,192,187,183,176,
173,171,166,166,162,166,169,164,171,174,171,169,172,169,175,176,175,168,168,
168,168,171,170,162,166,165,156,160,156,156,157,156,168,168,167,157,157,154,
160,160,159,164,164,163,200,202,200,198,198,198,180,179,177,62,62,58,25,
25,20,19,22,16,12,16,9,12,18,9,10,17,8,15,20,12,19,23,
16,26,29,25,64,66,63,171,174,173,173,178,178,185,190,190,162,166,166,
166,172,169,168,171,169,153,157,153,140,144,140,173,177,172,170,174,168,179,
182,177,175,178,173,173,176,171,170,174,168,167,171,165,162,166,160,165,169,
163,180,183,178,177,180,175,176,177,172,159,159,153,159,158,150,166,162,153,
170,165,155,172,166,154,182,175,161,180,171,159,186,175,162,178,164,150,175,
156,137,177,153,128,169,139,110,174,140,105,166,130,92,163,125,87,154,115,
77,146,108,71,150,114,78,152,121,90,159,137,112,165,150,131,170,161,147,
182,176,168,186,183,179,193,193,193,194,198,202,205,208,215,127,85,44,122,
79,37,133,82,38,138,86,35,146,93,40,141,88,36,132,82,32,132,82,
32,136,87,36,145,95,44,159,110,59,133,86,38,136,88,43,133,81,40,
152,98,58,156,105,64,151,114,76,174,142,107,189,161,133,187,163,144,187,
172,158,187,177,167,189,183,174,176,173,164,175,169,165,187,185,182,181,181,
178,177,178,177,178,181,178,172,175,174,163,164,163,171,171,171,170,171,171,
171,174,173,159,162,161,168,171,170,158,159,158,163,164,164,195,196,196,186,
186,187,187,191,194,202,205,208,187,188,190,67,68,67,24,25,22,19,23,
17,10,14,9,17,25,16,11,18,10,16,23,15,19,24,19,26,31,27,
65,73,71,188,198,199,181,193,196,164,175,178,182,191,193,187,196,198,172,
181,181,163,169,168,160,164,160,163,168,162,159,162,156,153,158,152,146,152,
146,140,145,140,142,147,142,140,145,140,147,153,147,147,153,147,173,178,173,
175,178,173,165,166,162,176,176,171,165,164,157,166,162,153,163,158,149,169,
163,151,177,170,156,171,162,149,164,153,140,163,148,134,163,145,126,162,139,
116,150,122,93,153,121,88,157,121,84,151,113,74,144,106,68,139,101,64,
145,109,74,147,116,86,157,134,109,160,144,125,175,166,153,180,173,168,192,
189,187,194,194,195,200,204,208,200,206,215,129,88,48,127,85,44,139,90,
45,136,84,37,136,84,33,132,80,28,138,87,36,138,86,39,130,82,34,
148,102,54,148,102,55,121,79,36,122,82,40,140,96,56,148,101,63,168,
120,81,177,145,107,187,156,124,181,156,131,182,162,142,184,169,155,181,170,
158,169,163,151,182,177,168,187,182,178,187,185,182,174,174,169,167,169,166,
179,182,179,162,165,162,173,174,173,166,166,166,161,164,161,156,160,156,142,
146,142,159,162,161,156,160,160,173,176,176,200,204,206,200,204,206,193,202,
205,191,199,201,193,199,201,84,86,86,25,28,25,21,24,20,15,19,15,
17,23,16,13,19,12,17,22,16,16,20,16,25,28,25,91,98,97,196,
205,206,177,189,192,185,197,201,180,188,193,183,192,194,185,193,194,156,162,
160,139,144,139,150,156,149,165,171,163,164,170,164,150,154,151,156,160,157,
155,159,156,158,162,159,160,164,161,142,146,143,144,148,145,150,154,148,161,
162,158,163,163,157,172,171,164,176,173,164,160,155,146,162,155,143,165,157,
144,164,156,142,164,151,138,162,146,130,158,137,117,147,124,98,150,120,89,
144,110,75,140,103,65,144,104,65,146,106,66,145,106,67,147,110,74,154,
122,90,159,133,107,162,145,124,169,160,146,171,166,163,182,181,181,189,189,
192,190,195,202,198,208,215,159,119,78,129,89,47,127,81,36,128,78,32,
135,82,33,145,91,41,138,86,39,135,84,37,130,80,38,148,101,57,156,
113,69,160,122,77,180,141,99,138,102,64,150,112,74,159,121,83,162,136,
103,159,138,107,170,148,125,174,156,138,186,170,155,172,160,147,176,167,154,
188,180,168,182,176,170,177,175,169,157,157,150,175,177,172,165,169,163,167,
171,166,158,159,155,165,165,164,153,156,152,150,153,149,160,164,160,155,159,
155,148,152,150,143,147,147,193,199,201,198,204,206,192,204,204,194,203,204,
206,212,212,144,145,145,38,40,38,21,24,21,22,26,22,20,25,19,19,
25,18,20,24,19,23,24,21,52,53,51,160,164,163,197,205,205,192,203,
204,181,188,190,186,191,193,193,197,198,178,183,182,156,160,158,147,153,147,
130,135,129,120,125,118,149,156,149,158,166,161,136,144,139,149,156,152,143,
150,146,150,157,153,152,160,155,158,166,161,159,164,158,155,156,152,150,150,
144,157,156,150,163,159,150,166,161,152,163,156,146,163,154,142,166,155,140,
160,144,128,158,140,122,162,139,116,156,128,100,151,118,85,151,114,78,145,
105,64,138,97,56,146,101,63,147,102,65,148,108,72,157,122,88,159,131,
104,165,145,123,170,157,142,182,176,175,182,181,182,188,189,193,194,200,206,
196,205,213,142,103,62,123,83,41,132,86,41,134,86,38,139,86,38,135,
82,34,136,84,36,134,82,38,126,76,35,125,78,39,122,82,42,128,92,
52,128,96,56,132,101,63,141,107,72,159,124,88,146,123,92,159,137,109,
163,143,119,168,149,130,162,146,130,163,148,134,171,159,144,175,166,153,175,
168,160,168,165,157,168,169,159,177,181,172,167,170,165,156,159,155,167,169,
166,159,160,157,162,166,160,155,159,153,149,152,148,170,174,169,158,162,159,
146,150,148,158,166,164,191,198,198,195,205,204,194,202,200,193,198,197,202,
204,204,125,126,125,35,37,36,25,28,27,22,26,22,22,25,20,36,38,
34,87,87,85,159,159,158,195,196,195,189,194,193,181,190,189,189,194,194,
181,183,184,179,182,182,165,168,167,143,147,144,133,138,133,136,144,136,138,
146,139,120,129,122,116,123,119,128,136,131,133,141,136,141,148,144,147,154,
150,146,153,149,156,162,158,169,172,169,158,160,154,160,160,156,148,148,141,
169,166,158,160,155,146,159,152,142,162,155,143,162,150,135,170,153,135,166,
146,125,154,130,105,154,125,96,152,118,83,144,105,67,140,99,59,136,94,
52,138,93,52,142,99,60,153,110,74,153,119,85,148,121,94,162,141,117,
170,155,140,171,167,166,182,182,183,195,197,201,194,199,206,196,204,212,123,
77,31,123,77,31,129,83,37,130,83,36,132,84,36,133,83,38,125,77,
30,129,80,35,125,80,35,133,88,44,151,108,64,187,143,100,153,113,72,
129,91,53,146,108,71,146,109,73,154,121,88,151,119,88,150,123,92,141,
119,91,139,119,96,153,136,118,157,143,129,163,151,142,165,156,149,164,157,
150,177,172,167,176,174,171,165,165,162,159,162,159,155,159,158,154,160,158,
154,158,154,141,146,141,167,172,168,179,184,180,142,146,143,127,132,128,146,
150,147,165,170,168,191,198,198,188,193,195,193,199,201,190,194,195,198,203,
204,166,171,172,137,142,142,111,115,116,137,141,141,169,173,174,191,193,194,
192,194,195,184,188,189,188,191,193,173,176,178,178,183,182,173,178,176,160,
166,164,145,152,149,146,153,150,144,151,148,133,141,137,140,147,144,158,166,
162,121,130,125,120,129,124,130,138,133,135,140,137,139,144,140,148,152,148,
148,152,148,159,163,159,158,162,158,158,160,156,163,163,157,154,152,145,164,
160,151,156,151,141,157,152,139,150,139,123,150,134,113,159,140,117,171,145,
118,165,135,104,151,116,82,144,106,68,134,94,54,140,98,56,140,99,59,
138,101,64,142,109,76,147,120,93,158,137,116,157,143,125,162,152,140,170,
169,164,174,174,174,188,188,189,197,198,205,195,197,205,127,80,34,127,80,
34,130,83,36,129,82,35,132,84,37,130,83,36,127,80,34,135,87,40,
135,90,45,129,84,40,142,96,54,130,88,47,130,89,49,130,90,51,128,
89,50,126,88,51,134,100,66,136,103,70,138,107,75,130,105,73,142,119,
91,156,138,116,168,153,138,176,160,150,177,167,158,165,156,147,175,169,161,
159,158,152,162,162,158,160,163,159,162,168,163,150,157,154,135,140,136,156,
160,157,154,158,155,140,145,141,149,153,150,130,135,131,146,150,147,159,163,
160,171,176,176,165,170,170,177,182,182,176,181,181,172,177,177,178,183,183,
161,165,165,140,144,144,131,135,135,162,165,165,155,159,159,148,152,152,155,
159,159,153,157,157,158,162,162,149,153,152,140,147,144,141,148,145,146,153,
150,132,140,137,127,135,132,140,147,144,140,147,144,131,139,136,126,135,130,
120,129,124,131,139,134,128,134,130,137,142,138,138,142,138,147,151,147,155,
159,155,165,168,165,154,157,153,161,162,156,158,156,149,157,154,145,159,155,
144,160,154,143,156,146,130,153,139,117,142,123,101,145,121,95,163,133,103,
152,118,84,153,115,77,145,102,64,134,94,54,140,101,61,142,106,70,146,
114,82,146,121,95,158,139,119,157,143,129,165,156,146,159,159,153,166,166,
165,178,178,181,185,186,190,189,189,198,122,75,29,126,79,33,129,83,37,
126,79,33,133,86,39,133,85,38,133,85,38,136,89,43,140,94,49,128,
83,39,129,84,40,130,86,43,126,84,43,125,84,43,127,87,47,142,101,
60,135,97,60,140,104,68,142,108,74,144,115,80,153,127,97,160,138,114,
154,133,116,162,144,132,159,149,136,157,149,137,162,156,146,153,151,141,159,
159,150,157,159,152,151,157,150,140,145,140,155,159,156,154,158,155,136,141,
137,133,138,134,123,128,124,135,140,136,130,135,131,194,200,195,178,183,182,
137,142,142,144,148,148,129,134,134,115,119,119,92,96,96,58,62,62,41,
44,44,40,42,42,59,62,62,75,78,78,105,109,109,124,127,127,120,123,
123,127,130,130,117,123,121,122,129,127,121,128,125,171,180,176,119,126,123,
119,126,123,126,134,131,126,133,131,126,135,131,134,144,138,128,136,131,132,
140,135,130,135,132,144,148,145,142,146,142,140,144,140,150,154,150,156,160,
156,153,156,150,152,152,146,151,150,142,150,146,137,159,155,144,163,157,146,
160,150,135,151,135,114,148,131,107,135,114,87,145,117,87,156,123,88,145,
108,70,136,97,58,132,92,53,138,99,61,142,107,71,145,116,85,152,128,
104,159,141,123,158,145,132,169,161,151,167,168,162,177,177,176,188,188,189,
189,190,194,186,186,195,116,72,28,125,81,37,130,85,41,127,82,37,132,
87,43,133,88,44,135,90,46,132,86,43,133,84,44,127,82,41,130,84,
43,121,75,37,138,92,50,129,83,44,138,92,53,135,89,50,130,89,51,
134,95,57,138,102,64,150,117,81,141,112,82,144,119,94,162,139,120,164,
144,128,152,141,127,150,141,126,168,161,147,158,154,141,152,152,140,153,156,
144,142,147,137,149,154,147,146,152,146,144,148,145,146,150,147,131,136,132,
125,130,126,136,141,137,133,138,134,193,198,194,170,175,173,131,136,134,133,
138,136,143,147,145,155,159,158,149,153,151,139,144,142,118,122,121,121,126,
124,125,130,128,142,146,144,144,148,146,140,145,143,125,130,128,100,105,103,
108,113,111,109,117,112,118,125,121,140,147,143,111,119,114,106,113,109,120,
127,123,132,140,135,137,145,141,126,135,130,132,140,136,132,140,135,150,157,
152,142,146,143,155,159,155,141,145,141,152,156,152,156,160,156,155,158,152,
155,156,149,146,145,138,130,127,119,141,136,127,148,142,131,160,151,135,152,
139,119,148,133,110,134,114,89,140,113,84,142,110,77,140,105,68,146,107,
68,135,97,59,139,103,67,142,110,76,145,116,87,152,131,107,150,133,117,
164,154,142,163,157,149,169,169,164,181,181,180,191,191,192,188,188,193,191,
191,201,121,81,40,122,82,42,126,86,46,129,88,47,130,89,49,130,89,
49,126,85,45,126,86,46,127,85,46,122,80,42,123,80,44,123,80,44,
130,85,47,125,80,42,126,80,42,122,78,40,125,83,47,125,86,47,134,
97,59,128,95,61,140,111,80,151,125,99,142,119,100,146,125,110,162,150,
133,164,154,138,160,153,136,145,142,127,145,145,132,149,150,138,145,148,138,
151,156,147,149,153,149,152,156,153,148,152,149,131,136,132,131,136,132,137,
142,138,133,138,134,159,163,160,128,133,131,120,125,123,125,130,128,124,129,
127,163,168,166,171,176,174,158,162,161,157,163,160,158,166,163,152,160,157,
147,154,152,136,144,141,113,120,117,92,99,97,88,95,92,97,104,101,97,
104,100,114,121,117,111,119,114,121,128,124,111,119,114,113,120,116,114,121,
117,125,134,128,114,123,118,124,133,127,127,135,130,157,163,159,154,158,154,
144,148,144,155,159,155,153,157,153,153,157,153,151,154,150,157,158,152,154,
153,145,144,141,133,133,128,119,139,132,121,144,135,120,148,135,116,138,123,
101,139,119,95,136,111,83,142,111,80,140,105,69,135,98,60,133,96,59,
140,105,70,141,110,79,140,116,89,152,131,111,158,144,128,158,151,140,159,
156,150,172,172,167,180,180,179,185,185,188,191,191,196,191,191,201,120,84,
48,123,88,51,127,91,54,128,91,54,122,87,51,123,88,51,122,87,51,
127,91,54,122,84,49,119,80,47,120,80,46,119,79,45,117,75,40,127,
83,47,122,79,42,123,80,44,122,83,44,116,78,40,119,84,48,140,106,
72,134,106,76,126,101,77,148,127,106,168,148,133,169,155,141,153,141,127,
145,138,124,144,139,126,146,144,133,150,150,140,151,153,143,154,158,151,153,
157,153,144,148,145,135,140,136,142,146,143,148,152,149,134,139,135,140,145,
141,135,140,136,134,139,135,102,107,103,124,129,125,120,125,121,144,148,145,
140,145,141,117,121,118,115,122,117,128,136,131,120,127,123,108,116,111,115,
122,118,98,105,101,92,99,95,85,92,88,91,98,93,96,104,97,100,108,
101,123,132,124,115,123,116,112,120,113,120,128,121,112,120,113,121,130,123,
118,128,122,117,125,120,131,139,134,133,140,135,152,156,153,149,153,149,150,
154,150,155,159,155,153,157,153,151,154,150,151,152,145,153,151,144,151,147,
138,136,132,122,128,122,112,127,121,105,151,139,121,141,127,106,132,115,90,
130,106,80,126,96,66,139,105,71,142,106,69,133,97,62,130,98,65,138,
109,79,145,123,96,144,127,107,151,140,126,157,150,140,162,160,156,174,174,
169,177,177,176,181,181,184,191,191,196,183,183,192,120,89,57,119,87,56,
117,86,55,117,86,54,120,89,57,123,92,61,122,91,59,122,90,59,117,
83,55,114,81,50,115,80,50,114,77,47,119,80,48,120,79,46,122,81,
47,123,82,47,122,81,47,130,93,56,136,102,66,125,97,62,129,102,74,
146,123,100,158,138,121,159,141,126,148,134,122,135,123,111,139,130,119,147,
140,131,148,144,135,148,148,141,153,154,148,150,153,149,147,151,147,143,147,
144,135,140,136,140,145,141,148,152,149,134,139,135,154,158,155,131,136,132,
115,119,116,123,128,124,121,126,122,121,126,122,106,110,107,134,139,135,127,
132,128,139,146,142,98,107,102,118,128,122,100,109,104,113,122,117,106,115,
110,106,115,110,99,108,103,84,93,86,95,103,96,97,105,98,120,129,121,
113,121,114,117,125,118,123,132,124,113,121,114,117,125,119,126,135,130,120,
129,124,131,139,134,136,141,138,146,150,146,149,153,149,150,154,150,152,156,
152,156,160,156,154,157,151,146,146,141,146,145,138,152,149,140,147,142,131,
142,136,125,125,117,103,122,110,94,135,122,102,148,131,107,134,111,85,128,
100,71,130,97,63,139,103,67,140,105,70,140,108,76,136,109,81,134,112,
89,145,130,111,156,147,133,160,156,148,166,166,162,169,169,164,171,171,170,
176,176,177,184,184,189,184,184,193,147,123,95,138,112,86,129,103,78,128,
103,77,132,107,81,126,100,75,156,130,103,130,105,80,113,86,63,130,101,
76,139,109,83,127,95,69,116,83,55,127,92,63,116,80,50,116,79,49,
120,84,48,117,82,48,114,81,48,126,98,65,150,126,96,153,131,109,128,
111,94,166,149,135,147,134,123,145,132,122,148,138,129,148,140,132,150,146,
138,148,146,141,152,152,148,145,146,142,144,148,145,136,141,137,139,144,140,
139,144,140,140,145,141,131,136,132,146,150,147,117,121,118,120,126,120,124,
130,124,123,129,123,122,128,122,113,120,113,124,130,124,124,130,124,120,128,
122,115,125,118,117,127,120,113,122,116,121,130,124,113,122,116,105,114,109,
98,107,101,91,99,93,93,101,94,103,111,104,119,127,119,108,116,108,113,
121,114,121,130,121,121,130,121,121,130,124,113,122,117,130,138,134,131,139,
134,134,141,136,144,148,145,144,148,144,152,156,152,153,157,153,154,158,154,
156,159,155,151,152,145,144,143,136,144,141,132,140,135,125,139,132,121,130,
121,107,142,129,114,123,108,89,127,108,87,141,117,91,130,102,73,125,92,
59,130,97,62,136,102,68,139,110,78,138,112,86,136,116,93,145,133,114,
153,146,135,153,151,144,157,157,154,166,166,163,172,172,172,175,175,178,179,
180,184,183,184,192,158,151,144,162,155,148,159,151,145,152,145,139,154,148,
141,159,151,145,153,146,140,146,138,133,130,122,115,166,157,150,162,151,146,
160,146,141,157,139,132,145,127,115,129,109,95,101,81,62,113,84,54,121,
93,59,128,102,70,138,115,85,126,107,79,110,97,72,152,136,114,150,136,
117,147,137,123,145,135,122,145,136,125,138,131,122,150,146,137,150,149,141,
148,148,143,145,145,141,146,153,149,133,141,138,141,148,145,127,135,132,139,
146,143,139,146,143,137,145,142,126,134,131,124,133,129,130,139,135,128,136,
132,123,132,128,114,123,120,111,119,115,108,116,112,130,139,136,124,134,132,
116,126,124,127,138,136,133,144,144,114,125,125,110,120,122,105,115,117,94,
102,102,95,99,97,96,101,98,118,122,120,119,123,121,109,113,111,122,127,
124,124,129,126,123,129,125,123,132,124,128,136,129,134,142,134,140,145,140,
137,141,136,149,152,148,148,150,146,150,154,150,147,153,149,152,156,152,154,
154,148,148,147,138,150,145,134,145,137,122,139,127,113,144,129,114,128,110,
95,150,130,113,128,107,86,123,99,76,115,89,63,122,91,63,115,84,53,
116,88,60,126,104,77,134,117,93,136,126,107,145,140,127,152,149,145,153,
152,152,159,159,163,165,165,166,168,168,171,185,185,188,179,181,184,176,179,
183,170,170,169,177,176,176,176,175,175,176,175,175,175,175,174,175,174,174,
182,181,181,171,171,170,176,175,173,183,180,180,183,178,178,182,175,176,172,
161,160,172,159,155,176,162,152,148,133,119,115,96,71,104,84,60,105,86,
62,103,85,63,108,94,73,127,113,93,160,147,128,148,136,119,132,120,107,
140,131,118,140,132,121,157,151,142,146,144,138,136,136,131,143,145,141,149,
150,149,150,154,151,161,165,162,133,138,134,144,148,145,146,150,147,139,144,
140,144,148,145,129,134,130,133,141,136,133,141,136,137,145,140,126,134,129,
111,119,114,126,134,129,125,132,128,111,120,116,107,117,113,112,123,120,127,
138,135,138,148,147,133,144,144,123,134,135,116,126,127,119,126,125,102,107,
103,104,109,105,129,134,130,116,120,117,115,119,116,118,122,119,125,130,126,
113,120,115,121,130,124,138,146,140,137,145,138,134,139,134,140,145,140,137,
141,136,156,159,155,147,151,147,144,151,147,144,148,144,146,148,141,147,146,
137,144,139,127,147,139,125,140,131,115,145,130,115,132,113,97,126,106,87,
133,111,90,130,106,82,127,100,74,115,87,58,127,98,67,120,94,66,114,
94,70,125,110,88,133,124,106,135,130,118,153,151,146,164,164,164,163,163,
166,167,168,170,172,173,175,180,181,183,192,195,199,188,191,195,178,181,183,
179,182,184,182,185,187,190,193,195,183,186,188,185,186,188,190,191,193,179,
180,182,183,185,186,177,179,180,183,183,186,185,183,186,182,179,182,182,177,
177,171,165,161,164,156,148,165,153,142,160,148,136,139,128,116,127,117,105,
157,146,134,160,149,136,146,135,123,132,122,110,135,125,113,129,119,109,140,
132,122,126,122,115,125,125,122,148,151,149,169,174,174,168,175,175,142,146,
143,142,146,142,130,134,130,143,147,143,142,146,142,137,141,137,144,148,144,
130,135,131,140,145,141,139,144,140,142,146,143,128,133,129,131,136,132,118,
122,119,147,151,148,120,129,123,105,116,110,121,132,127,127,138,134,124,134,
132,117,127,125,129,140,140,124,134,134,117,125,124,90,97,93,96,103,99,
132,140,135,118,125,121,120,127,123,119,126,122,126,133,129,108,116,112,121,
130,125,137,147,142,137,145,142,145,152,149,130,135,133,140,144,142,140,144,
142,149,153,151,147,153,148,145,150,144,143,146,139,150,150,141,145,142,131,
145,139,125,132,125,110,138,126,110,134,116,98,116,97,78,125,105,84,123,
101,77,128,104,76,126,101,71,128,102,70,115,91,64,115,95,74,122,106,
87,133,124,107,139,133,121,148,146,141,162,161,161,161,160,163,172,173,175,
181,182,184,179,182,186,196,200,204,198,203,208,178,186,189,181,188,192,189,
197,201,183,190,194,185,191,196,192,200,204,193,201,205,190,196,202,185,190,
194,182,188,193,185,189,196,185,187,196,185,186,194,181,182,186,180,180,180,
172,172,171,176,175,175,169,168,168,164,162,161,158,154,154,152,148,145,130,
124,121,128,122,118,111,104,99,123,115,105,134,125,117,119,112,106,127,126,
122,147,148,147,172,180,181,179,189,192,182,192,195,162,165,163,135,136,134,
133,134,132,135,136,134,140,141,139,143,144,142,148,148,147,140,142,140,140,
144,140,142,146,142,136,140,136,127,130,127,130,133,130,125,128,125,137,141,
137,134,142,136,109,121,113,134,145,139,136,146,141,129,140,136,124,134,132,
126,136,134,103,113,112,86,95,92,91,98,94,97,104,100,111,119,114,119,
126,122,119,126,122,121,128,124,120,127,123,114,123,120,114,125,123,145,154,
153,151,160,159,149,156,155,146,152,152,137,142,142,144,148,148,143,150,147,
146,153,149,144,151,145,141,145,138,140,141,133,133,133,124,139,137,126,135,
133,121,134,124,109,128,112,96,120,105,86,101,85,66,111,93,72,111,92,
69,113,92,67,109,88,62,121,100,78,116,99,81,120,106,90,130,124,110,
139,135,124,144,142,137,153,152,152,162,161,162,164,166,170,183,186,190,189,
192,196,200,205,210,197,202,207,183,193,201,190,200,208,190,200,208,196,205,
212,196,206,213,194,203,210,194,203,210,190,199,206,192,200,206,184,193,202,
189,197,207,193,200,212,189,194,205,186,192,202,185,189,194,181,185,188,181,
188,194,175,182,190,174,181,187,174,176,181,168,169,171,167,167,168,183,182,
183,154,151,152,140,136,131,144,139,136,127,126,125,140,141,140,166,170,172,
184,191,195,188,199,206,182,194,200,178,181,181,150,153,152,124,126,126,133,
135,135,144,146,146,139,141,141,145,147,147,140,144,143,136,141,140,140,145,
144,134,139,137,130,135,133,136,141,140,124,129,128,117,123,121,118,126,122,
105,116,110,124,134,130,134,145,141,133,144,142,120,130,128,118,128,127,104,
114,114,106,115,114,102,110,108,105,114,111,113,122,119,119,129,125,120,129,
126,121,130,127,121,130,127,116,126,125,139,150,151,182,192,193,190,201,202,
171,179,181,155,162,164,147,154,156,149,154,158,150,156,157,150,157,155,152,
158,157,147,151,149,143,145,143,135,136,132,138,138,133,129,129,123,130,124,
115,129,118,106,114,104,91,114,102,88,98,86,71,102,90,73,95,82,63,
93,81,63,99,86,71,110,97,85,119,109,99,123,118,110,129,129,123,150,
150,147,160,160,160,176,175,176,175,178,182,186,189,193,194,199,204,195,199,
207,193,200,207,191,204,212,196,209,217,196,209,217,194,207,215,192,205,213,
191,204,212,193,206,214,191,204,212,190,201,206,196,205,212,194,203,213,197,
204,218,192,199,215,193,201,211,191,199,207,186,196,202,184,194,204,186,196,
206,191,198,207,185,192,201,187,191,198,190,194,200,192,194,199,185,187,192,
174,178,181,157,161,163,160,165,168,187,192,196,194,201,206,192,200,206,190,
200,208,185,195,201,178,186,189,161,167,169,141,148,151,154,160,163,149,155,
158,145,152,154,142,148,151,142,149,151,138,147,148,136,146,147,129,139,140,
130,140,141,136,145,146,117,127,128,109,120,121,109,119,119,106,116,115,112,
122,121,123,133,133,123,134,135,120,131,133,123,133,136,141,152,156,133,143,
146,107,116,117,99,108,109,119,129,130,137,146,147,127,137,138,137,146,147,
171,180,181,172,183,186,181,193,198,197,209,214,198,209,215,196,206,212,196,
204,210,189,196,205,196,202,210,199,205,211,200,209,212,200,207,212,179,185,
188,162,168,170,164,169,170,178,181,181,152,156,156,136,136,135,122,118,115,
134,130,126,130,127,123,130,127,121,136,133,127,123,120,112,99,97,89,105,
100,95,117,111,109,119,117,115,124,125,124,138,140,140,164,169,169,173,176,
178,186,189,193,199,203,207,194,199,204,194,200,206,200,206,214,197,206,214,
194,207,215,192,205,213,198,209,217,200,211,219,194,207,215,194,205,213,196,
209,217,195,206,214,203,210,215,200,208,214,203,211,220,197,205,218,195,205,
219,197,207,218,195,205,214,193,204,212,196,205,213,195,204,211,196,206,213,
192,201,208,186,196,202,189,197,205,194,201,208,188,197,204,188,199,208,196,
208,217,199,210,218,203,212,220,208,216,223,205,213,220,200,207,212,202,211,
217,201,212,218,198,209,217,179,190,196,173,184,190,188,199,206,176,187,193,
159,170,176,168,178,184,159,172,178,161,174,180,154,167,172,151,165,171,154,
169,175,145,158,164,140,153,158,130,141,145,111,121,123,114,124,126,137,148,
152,153,164,169,143,154,160,146,155,163,188,197,206,183,193,201,170,179,186,
176,187,193,191,200,207,200,210,217,195,204,211,182,192,200,194,204,210,201,
213,220,205,218,227,205,218,227,211,223,231,215,225,233,215,224,233,215,223,
233,217,224,235,220,227,236,221,228,237,220,227,236,217,224,233,215,222,231,
210,216,225,219,224,232,214,219,227,204,207,214,182,184,187,193,194,198,202,
204,208,210,215,218,217,221,223,200,205,206,202,207,208,165,167,170,191,191,
196,194,196,199,172,179,182,182,191,193,200,210,215,211,219,224,213,219,226,
216,221,227,211,217,224,212,218,225,215,223,231,214,223,232,198,209,217,202,
211,221,204,214,224,203,213,223,195,205,214,194,205,215,202,211,221,205,215,
225,201,211,218,203,212,220,201,210,220,205,214,225,199,208,221,201,211,223,
202,211,221,201,211,220,198,207,215,200,210,217,202,211,219,200,210,217,200,
209,217,204,213,221,203,212,220,204,213,221,199,211,221,202,213,224,205,216,
227,209,219,229,213,222,231,207,216,224,210,218,225,210,218,225,210,221,230,
211,223,231,204,215,224,201,212,220,202,213,221,191,204,212,190,200,208,190,
200,208,190,203,211,200,211,219,194,207,215,196,209,217,203,215,223,201,212,
220,199,211,218,189,199,207,182,192,200,187,197,205,193,205,212,200,210,219,
201,211,220,204,214,224,214,223,232,215,224,233,215,225,233,217,227,235,209,
219,227,211,221,229,215,225,233,207,217,225,206,215,223,209,220,229,213,225,
233,214,227,235,218,228,236,219,228,237,218,227,236,219,229,238,219,228,238,
219,228,238,219,228,238,218,226,236,219,227,237,219,228,238,218,226,236,220,
229,239,219,227,237,223,228,239,216,221,232,220,225,236,221,226,237,215,222,
231,219,226,235,215,222,231,216,224,232,217,224,233,216,221,229,216,223,232,
212,222,230,207,218,225,211,222,231,215,224,233,215,224,233,216,223,232,215,
222,231,217,224,233,220,228,236,217,225,235,201,211,223,203,213,225,202,212,
224,205,215,227,198,208,220,199,209,221,203,213,225,210,219,230,210,219,230,
205,215,227,204,214,226,204,214,226,205,215,227,205,215,227,204,214,226,203,
213,225,202,212,221,203,213,223,205,215,225,204,214,224,203,213,223,204,214,
224,205,215,225,205,215,225,204,214,224,207,217,227,209,219,229,206,216,226,
209,219,229,210,220,230,214,223,232,215,224,233,218,227,236,215,224,233,215,
224,233,207,217,227,205,215,225,203,213,223,202,212,221,206,216,226,205,215,
225,215,224,233,209,219,229,214,223,232,214,223,232,214,223,232,214,223,232,
217,226,235,219,229,238,220,230,239,215,224,233,210,220,230,214,223,232,219,
228,237,219,229,238,220,230,239,223,233,242,222,232,241,222,232,241,219,228,
237,217,226,235,217,226,235,218,227,236,217,226,235,219,229,238,220,230,239,
219,229,238,220,230,239,219,229,238,220,230,239,223,233,242,222,232,241,219,
228,237,218,227,236,219,228,237,220,230,239,220,230,239,220,230,239,220,230,
239,222,231,241,223,228,239,222,228,238,223,228,239,223,228,239,223,228,239,
221,227,237,222,228,238,219,227,237,218,227,236,218,227,236,218,227,236,218,
227,236,215,224,233,218,227,236,219,228,237,216,223,232,216,223,232,219,226,
235,219,226,235,219,226,235,201,211,223,204,214,226,203,213,225,203,213,225,
203,213,225,204,214,226,207,217,229,210,219,230,205,215,227,204,214,226,204,
214,226,207,217,229,198,207,219,198,208,220,202,212,224,207,217,229,206,216,
226,205,215,225,205,215,225,206,216,226,206,216,226,206,216,226,207,217,227,
209,219,229,210,220,230,214,223,232,204,214,224,206,216,226,204,214,224,209,
219,229,211,221,231,210,220,230,217,226,235,214,223,232,214,223,232,209,219,
229,206,216,226,209,219,229,209,219,229,215,224,233,214,223,232,217,226,235,
217,226,235,219,228,237,218,227,236,219,229,238,220,230,239,219,228,237,219,
228,237,222,232,241,222,232,241,220,230,239,219,229,238,220,230,239,222,232,
241,222,232,241,222,232,241,223,233,242,223,233,242,220,230,239,220,230,239,
223,233,242,220,230,239,219,228,237,223,233,242,224,234,243,220,230,239,219,
229,238,219,228,237,219,229,238,222,232,241,222,232,241,220,230,239,220,230,
239,220,230,239,219,229,238,219,229,238,220,230,239,220,230,239,220,229,239,
221,227,237,222,228,238,226,231,242,225,230,241,225,230,241,222,228,238,222,
228,238,219,228,238,219,228,237,219,228,237,219,228,237,219,228,237,219,228,
237,219,228,237,220,230,239,220,227,236,222,229,238,222,229,238,220,227,236,
217,224,233,203,213,225,204,214,226,201,211,223,203,213,225,204,214,226,207,
217,229,207,217,229,204,214,226,203,213,225,202,212,224,202,212,224,203,213,
225,202,212,224,198,208,220,199,209,221,204,214,226,209,219,229,210,220,230,
209,219,229,206,216,226,209,219,229,209,219,229,210,220,230,211,221,231,217,
226,235,210,220,230,207,217,227,207,217,227,207,217,227,207,217,227,207,217,
227,207,217,227,215,224,233,209,219,229,211,221,231,210,220,230,210,220,230,
215,224,233,214,223,232,217,226,235,219,228,237,219,228,237,220,230,239,223,
233,242,222,232,241,222,232,241,222,232,241,223,233,242,224,234,243,224,234,
243,223,233,242,223,233,242,222,232,241,220,230,239,220,230,239,224,234,243,
226,236,245,225,235,244,225,235,244,223,233,242,222,232,241,219,229,238,218,
227,236,219,228,237,223,233,242,223,233,242,219,229,238,219,229,238,218,227,
236,219,228,237,222,232,241,222,232,241,222,232,241,223,233,242,222,232,241,
222,232,241,222,232,241,220,230,239,219,228,237,219,227,237,215,221,233,217,
223,235,222,228,238,222,228,238,222,228,238,220,226,236,220,226,236,218,226,
236,218,227,236,218,227,236,218,227,236,217,226,235,219,229,238,219,228,237,
219,229,238,222,229,238,221,228,237,221,228,237,220,227,236,217,224,233
};

typedef struct
{
  gint pattern_number;
  gint additive;
  gint rotated;
} VideoValues;


static GtkWidget *preview      = NULL;
static gboolean   in_main_loop = FALSE;

static VideoValues vvals =
{
  2,
  TRUE,
  FALSE,
};


/* Declare local functions.
 */
static void      query  (void);
static void      run    (const gchar      *name,
                         gint              nparams,
                         const GimpParam  *param,
                         gint             *nreturn_vals,
                         GimpParam       **return_vals);

static void      video  (GimpDrawable     *drawable);


static gboolean  video_dialog          (void);
static void      video_toggle_update   (GtkWidget *widget,
                                        gpointer   data);
static void      video_radio_update    (GtkWidget *widget,
                                        gpointer   data);

static void      video_render_preview  (gboolean raw);

GimpPlugInInfo PLUG_IN_INFO =
{
  NULL,  /* init_proc  */
  NULL,  /* quit_proc  */
  query, /* query_proc */
  run,   /* run_proc   */
};

MAIN ()

static void
query (void)
{
  static GimpParamDef args[] =
  {
    { GIMP_PDB_INT32,    "run_mode",       "Interactive, non-interactive" },
    { GIMP_PDB_IMAGE,    "image",          "Input image (unused)" },
    { GIMP_PDB_DRAWABLE, "drawable",       "Input drawable" },
    { GIMP_PDB_INT32,    "pattern_number", "Type of RGB pattern to use" },
    { GIMP_PDB_INT32,    "additive",       "Whether the function adds the result to the original image" },
    { GIMP_PDB_INT32,    "rotated",        "Whether to rotate the RGB pattern by ninety degrees" }
  };

  gimp_install_procedure ("plug_in_video",
                          "Apply low-dotpitch RGB simulation to the "
                          "specified drawable",
                          "This function simulates the degradation of "
                          "being on an old low-dotpitch RGB video monitor "
                          "to the specified drawable.",
                          "Adam D. Moss (adam@foxbox.org)",
                          "Adam D. Moss (adam@foxbox.org)",
                          "2nd March 1997",
                          N_("Vi_deo..."),
                          "RGB*",
                          GIMP_PLUGIN,
                          G_N_ELEMENTS (args), 0,
                          args, NULL);

  gimp_plugin_menu_register ("plug_in_video", "<Image>/Filters/Distorts");
}

static void
run (const gchar      *name,
     gint              nparams,
     const GimpParam  *param,
     gint             *nreturn_vals,
     GimpParam       **return_vals)
{
  static GimpParam   values[1];
  GimpDrawable      *drawable;
  GimpRunMode        run_mode;
  GimpPDBStatusType  status = GIMP_PDB_SUCCESS;

  run_mode = param[0].data.d_int32;

  INIT_I18N ();

  *nreturn_vals = 1;
  *return_vals  = values;

  values[0].type          = GIMP_PDB_STATUS;
  values[0].data.d_status = status;

  switch (run_mode)
    {
    case GIMP_RUN_INTERACTIVE:
      /*  Possibly retrieve data  */
      gimp_get_data ("plug_in_video", &vvals);

      /*  First acquire information with a dialog  */
      if (! video_dialog ())
        return;
      break;

    case GIMP_RUN_NONINTERACTIVE:
      /*  Make sure all the arguments are there!  */
      if (nparams != 6)
        status = GIMP_PDB_CALLING_ERROR;
      if (status == GIMP_PDB_SUCCESS)
        {
          vvals.pattern_number = param[3].data.d_int32;
          vvals.additive = param[4].data.d_int32;
          vvals.rotated = param[5].data.d_int32;
        }
      break;

      case GIMP_RUN_WITH_LAST_VALS:
      /*  Possibly retrieve data  */
      gimp_get_data ("plug_in_video", &vvals);
      break;

    default:
      break;
    }


  /*  Get the specified drawable  */
  drawable = gimp_drawable_get (param[2].data.d_drawable);

  if (status == GIMP_PDB_SUCCESS)
    {
      /*  Make sure that the drawable is gray or RGB color  */
      if (gimp_drawable_is_rgb (drawable->drawable_id))
        {
          gimp_progress_init (_("Video/RGB..."));
          gimp_tile_cache_ntiles (2 * (drawable->width / gimp_tile_width ()
                                       + 1));
          video (drawable);

          if (run_mode != GIMP_RUN_NONINTERACTIVE)
            gimp_displays_flush ();

          /*  Store vvals data  */
          if (run_mode == GIMP_RUN_INTERACTIVE)
            gimp_set_data ("plug_in_video", &vvals, sizeof (VideoValues));
        }
      else
        {
          status = GIMP_PDB_EXECUTION_ERROR;
        }
    }

  values[0].data.d_status = status;

  gimp_drawable_detach (drawable);
}

static void
video_func (gint x,
            gint y,
            const guchar *src,
            guchar *dest,
            gint bpp,
            gpointer data)
{
  gint b, sel_b;

  if (vvals.rotated)
    {
      sel_b = pattern[vvals.pattern_number]
        [pattern_width[vvals.pattern_number]*
         (x % pattern_height[vvals.pattern_number]) +
         y % pattern_width[vvals.pattern_number] ];
    }
  else
    {
      sel_b = pattern[vvals.pattern_number]
        [pattern_width[vvals.pattern_number]*
         (y % pattern_height[vvals.pattern_number]) +
         x % pattern_width[vvals.pattern_number] ];
    }

  for (b = 0; b < bpp; b++)
    {
      if (b < 3 )
        {
          dest [b] = (sel_b == b) ? src[b] : 0;
          if (vvals.additive)
            {
              gint temp = (gint) dest[b] + src[b];
              dest[b] = MIN (temp, 255);
            }
        }
      else
        {
          dest[b] = src[b];
        }
    }
}

static void
video (GimpDrawable *drawable)
{
  GimpRgnIterator *iter;

  iter = gimp_rgn_iterator_new (drawable, 0);
  gimp_rgn_iterator_src_dest (iter, video_func, NULL);
  gimp_rgn_iterator_free (iter);
}

static void
video_render_preview (gboolean raw)
{
  gint x, y;
  guchar preview_row[PREVIEW_WIDTH * PREVIEW_WIDTH * 3];

  if (vvals.pattern_number == -1)
    {
      vvals.pattern_number = 0;
      return;
    }

  for (y = 0; y < PREVIEW_HEIGHT; y++)
    {
      for (x = 0; x < PREVIEW_WIDTH; x++)
        {
          if (raw)
            {
              preview_row[(y*PREVIEW_WIDTH+x)*3+0] =
                preview_raw[x*3+0 + y*PREVIEW_WIDTH*3];
              preview_row[(y*PREVIEW_WIDTH+x)*3+1] =
                preview_raw[x*3+1 + y*PREVIEW_WIDTH*3];
              preview_row[(y*PREVIEW_WIDTH+x)*3+2] =
                preview_raw[x*3+2 + y*PREVIEW_WIDTH*3];
            }
          else
            {
              video_func (x, y, 
                          &preview_raw[y * PREVIEW_WIDTH * 3 + x * 3], 
                          preview_row + (y * PREVIEW_WIDTH + x) * 3, 3,
                          NULL);
            }
        }
    }
  gimp_preview_area_draw (GIMP_PREVIEW_AREA (preview),
                          0, 0, PREVIEW_WIDTH, PREVIEW_HEIGHT,
                          GIMP_RGB_IMAGE,
                          preview_row,
                          PREVIEW_WIDTH * 3);
}

static gboolean
video_dialog (void)
{
  GtkWidget *dlg;
  GtkWidget *frame;
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *toggle;
  GSList    *group = NULL;
  gint       y;
  gboolean   run;

  gimp_ui_init ("video", TRUE);

  dlg = gimp_dialog_new (_("Video"), "video",
                         NULL, 0,
                         gimp_standard_help_func, "plug-in-video",

                         GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                         GTK_STOCK_OK,     GTK_RESPONSE_OK,

                         NULL);

  gtk_dialog_set_alternative_button_order (GTK_DIALOG (dlg),
                                              GTK_RESPONSE_OK,
                                              GTK_RESPONSE_CANCEL,
                                              -1);

  hbox = gtk_hbox_new (FALSE, 12);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 12);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dlg)->vbox), hbox, TRUE, TRUE, 0);
  gtk_widget_show (hbox);

  /* frame for the radio buttons */
  frame = gimp_frame_new ( _("Video Pattern"));
  gtk_box_pack_start (GTK_BOX (hbox), frame, FALSE, FALSE, 0);
  gtk_widget_show (frame);

  /* vbox for RGB pattern typees */
  vbox = gtk_vbox_new (FALSE, 2);
  gtk_container_add (GTK_CONTAINER (frame), vbox);
  gtk_widget_show (vbox);

  /* radio buttons */
  for (y = 0; y < MAX_PATTERNS; y++)
    {
      toggle = gtk_radio_button_new_with_mnemonic (group,
                                                gettext(pattern_name[y]));
      group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (toggle));
      gtk_box_pack_start (GTK_BOX (vbox), toggle, FALSE, FALSE, 0);
      gtk_widget_show (toggle);

      g_object_set_data (G_OBJECT (toggle), "gimp-item-data",
                         GINT_TO_POINTER (y));

      g_signal_connect (toggle, "toggled",
                        G_CALLBACK (video_radio_update),
                        &vvals.pattern_number);

      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (toggle),
                                    vvals.pattern_number == y);
    }

  /* vbox for preview and toggles */
  vbox = gtk_vbox_new (FALSE, 12);
  gtk_box_pack_start (GTK_BOX (hbox), vbox, FALSE, FALSE, 0);
  gtk_widget_show (vbox);

  frame = gtk_frame_new (NULL);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_IN);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);
  gtk_widget_show (frame);

  preview = gimp_preview_area_new ();
  gtk_widget_set_size_request (preview, PREVIEW_WIDTH, PREVIEW_HEIGHT);
  gtk_container_add (GTK_CONTAINER (frame), preview);
  gtk_widget_show (preview);

  toggle = gtk_check_button_new_with_mnemonic (_("_Additive"));
  gtk_box_pack_start (GTK_BOX (vbox), toggle, FALSE, FALSE, 0);
  gtk_widget_show (toggle);

  g_signal_connect (toggle, "toggled",
                    G_CALLBACK (video_toggle_update),
                    &vvals.additive);

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (toggle), vvals.additive);

  toggle = gtk_check_button_new_with_mnemonic ( _("_Rotated"));
  gtk_box_pack_start (GTK_BOX (vbox), toggle, FALSE, FALSE, 0);
  gtk_widget_show (toggle);

  g_signal_connect (toggle, "toggled",
                    G_CALLBACK (video_toggle_update),
                    &vvals.rotated);

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (toggle), vvals.rotated);

  gtk_widget_show (dlg);

  video_render_preview (FALSE);

  in_main_loop = TRUE;

  run = (gimp_dialog_run (GIMP_DIALOG (dlg)) == GTK_RESPONSE_OK);

  in_main_loop = FALSE;

  gtk_widget_destroy (dlg);

  return run;
}

static void
video_toggle_update (GtkWidget *widget,
                     gpointer   data)
{
  gimp_toggle_button_update (widget, data);

  if (in_main_loop)
    video_render_preview (FALSE);
}

static void
video_radio_update (GtkWidget *widget,
                    gpointer   data)
{
  gimp_radio_button_update (widget, data);

  if (in_main_loop)
    video_render_preview (FALSE);
}
