/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpfloatingsel_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "stamp-pdbgen.h"

#include "gimp.h"


/**
 * SECTION: gimpfloatingsel
 * @title: gimpfloatingsel
 * @short_description: Functions for removing or attaching floating selections.
 *
 * Functions for removing or attaching floating selections.
 **/


/**
 * gimp_floating_sel_remove:
 * @floating_sel: The floating selection.
 *
 * Remove the specified floating selection from its associated
 * drawable.
 *
 * This procedure removes the floating selection completely, without
 * any side effects. The associated drawable is then set to active.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_floating_sel_remove (GimpLayer *floating_sel)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_LAYER, floating_sel,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-floating-sel-remove",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_floating_sel_anchor:
 * @floating_sel: The floating selection.
 *
 * Anchor the specified floating selection to its associated drawable.
 *
 * This procedure anchors the floating selection to its associated
 * drawable. This is similar to merging with a merge type of
 * ClipToBottomLayer. The floating selection layer is no longer valid
 * after this operation.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_floating_sel_anchor (GimpLayer *floating_sel)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_LAYER, floating_sel,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-floating-sel-anchor",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_floating_sel_to_layer:
 * @floating_sel: The floating selection.
 *
 * Transforms the specified floating selection into a layer.
 *
 * This procedure transforms the specified floating selection into a
 * layer with the same offsets and extents. The composited image will
 * look precisely the same, but the floating selection layer will no
 * longer be clipped to the extents of the drawable it was attached to.
 * The floating selection will become the active layer. This procedure
 * will not work if the floating selection has a different base type
 * from the underlying image. This might be the case if the floating
 * selection is above an auxiliary channel or a layer mask.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_floating_sel_to_layer (GimpLayer *floating_sel)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_LAYER, floating_sel,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-floating-sel-to-layer",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_floating_sel_attach:
 * @layer: The layer (is attached as floating selection).
 * @drawable: The drawable (where to attach the floating selection).
 *
 * Attach the specified layer as floating to the specified drawable.
 *
 * This procedure attaches the layer as floating selection to the
 * drawable.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_floating_sel_attach (GimpLayer    *layer,
                          GimpDrawable *drawable)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_LAYER, layer,
                                          GIMP_TYPE_DRAWABLE, drawable,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-floating-sel-attach",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}
