/*
 * Author:      William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990-1994, William Cheng.
 *
 * Permission limited to the use, copy, modify, and distribute this software
 * and its documentation for any purpose is hereby granted by the Author without
 * fee, provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the Author not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.  All other
 * rights (including the right to sell "tgif" and the right to sell derivative
 * works of tgif) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /export/bourbon/multimedia/william/X11/TGIF2/RCS/color.e,v 2.26 1994/12/28 06:37:11 william Exp $
 */

#ifndef _COLOR_E_
#define _COLOR_E_

extern int	maxColors;
extern int	defaultColorIndex;
extern int	colorIndex;
extern char	myFgColorStr[];
extern char	myBgColorStr[];
extern char	* * colorMenuItems;
extern int	* colorPixels;
extern int	* xorColorPixels;
extern XColor	* tgifColors;
extern XColor	* tgifRequestedColors;
extern XColor	myBgColor;
extern int	maxRGB;
extern int	colorDump;
extern int	useLocalRGBTxt;
extern int	printUsingRequestedColor;

extern void	DefaultColorArrays ARGS_DECL((int Entries, int **ForePixels,
		                              int **Valid, int **InitRV,
		                              char ***StatusStr));
extern int	TgifParseColor ARGS_DECL((char*, XColor*));
extern void	InitColor ARGS_DECL((void));
extern int	OneColorObject ARGS_DECL((struct ObjRec *, int *ColorIndex));
extern int	ChangeObjColor ARGS_DECL((struct ObjRec *, int ColorIndex));
extern void	ChangeAllSelColor ARGS_DECL((int ColorIndex, int HighLight));
extern void	SetUpColorMenuPixmap ARGS_DECL((int **ForeColors,
		                                int **InitRV, Pixmap **,
		                                int *Rows, int *Cols));
extern int	ColorMenu ARGS_DECL((int X, int Y, int TrackMenubar));
extern void	CleanUpColors ARGS_DECL((void));
extern int	FlushColormap ARGS_DECL((void));
extern void	AddColor ARGS_DECL((void));

#endif /*_COLOR_E_*/
