/*
 * Author:      William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990-1994, William Cheng.
 *
 * Permission limited to the use, copy, modify, and distribute this software
 * and its documentation for any purpose is hereby granted by the Author without
 * fee, provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the Author not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.  All other
 * rights (including the right to sell "tgif" and the right to sell derivative
 * works of tgif) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /export/bourbon/multimedia/william/X11/TGIF2/RCS/names.e,v 2.26 1994/11/17 05:31:21 william Exp $
 */

#ifndef _NAME_E_
#define _NAME_E_

extern char	curDomainName[];
extern char	curDomainPath[];
extern char	curDir[];
extern char	curLocalDir[];
extern char	curImportDir[];
extern char	curSymDir[];

extern int	doubleClickInterval;
extern int	importFromLibrary;
extern int	curDirIsLocal;

extern Window	nameBaseWin;
extern Window	nameDspWin;
extern Window	nameScrollWin;
extern int	nameEntries;
extern char	* * nameDspPtr;
extern int	nameFirst;
extern int	nameMarked;
extern struct BBRec	buttonBBox[];
extern int	numButtons;
extern char	buttonStr[][8];

extern int	nameDspH;
extern int	nameDspW;
extern int	nameDspWinH;
extern int	nameDspWinW;

extern int	justClicked;
extern int	domainInResource;

extern int	ignoreDirectoryFlag;
		/* use to be ignoreDirectoryFlagInMakeNameDspItemArray; */

extern void	ParseSymPath ARGS_DECL((char *));
extern void	InitNames ARGS_DECL((void));
extern void	UpdateDirInfo ARGS_DECL((void));
extern void	UpdateSymInfo ARGS_DECL((void));
extern void	CleanUpNames ARGS_DECL((void));

extern void	RedrawNameScrollWin ARGS_DECL((void));
extern void	RedrawDspWindow ARGS_DECL((void));
extern void	RedrawNamePath ARGS_DECL((char *Path, int X, int Y));
extern void	RedrawNameBaseWindow ARGS_DECL((char *Str, char *Path,
		                                int StrStart, int PathStart,
		                                int ButtonStart, int W, int H));
extern char	* * MakeNameDspItemArray ARGS_DECL((int Entries, DspList *));
extern void	NameScrollHandler ARGS_DECL((XButtonEvent *));
extern int	NameDspHandler ARGS_DECL((XButtonEvent *));
extern int	ControlChar ARGS_DECL((XKeyEvent *, KeySym));

extern int	SelectFileName ARGS_DECL((char *MsgStr, char *SelStr));
extern int	SelectFileNameToPaste ARGS_DECL((char *MsgStr, char *SelStr));
extern int	SelectFileNameToImport ARGS_DECL((char *MsgStr, char *ExtStr,
		                                  char *SelStr));
extern int	GetSymbolPath ARGS_DECL((char *SymName, char *PathName));
extern int	NameInCurDir ARGS_DECL((char *FileName));
extern int	DirInSymPath ARGS_DECL((char *DirName));
extern int	SelectDomain ARGS_DECL((char *SelStr));
extern int	SelectSymDir ARGS_DECL((char *SelStr));
extern int	SelectFromLibrary ARGS_DECL((char *MsgStr, char *ExtStr,
		                             char *SelStr, char *PathStr));
extern void	SetCurDir ARGS_DECL((char *FileName));
extern void	SetCurSymDir ARGS_DECL((char *FileName));
extern void	SetCurImportDir ARGS_DECL((char *FileName));

#endif /*_NAME_E_*/
