/*
 * Author:      William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990-1994, William Cheng.
 *
 * Permission limited to the use, copy, modify, and distribute this software
 * and its documentation for any purpose is hereby granted by the Author without
 * fee, provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the Author not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.  All other
 * rights (including the right to sell "tgif" and the right to sell derivative
 * works of tgif) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /export/bourbon/multimedia/william/X11/TGIF2/RCS/poly.e,v 2.18 1994/03/21 03:14:18 william Exp $
 */

#ifndef _POLY_E_
#define _POLY_E_

extern int	polyDrawn;

extern short	origWidthOfLine[];
extern short	origArrowHeadH[];
extern short	origArrowHeadW[];

extern short	*curWidthOfLine;
extern short	*curArrowHeadH;
extern short	*curArrowHeadW;

extern XPoint	* MakePolyVertex ARGS_DECL((int XOff, int YOff, int NumVs,
		                            XPoint *));
extern void	CalcPolyBBox ARGS_DECL((struct BBRec OBBox, int NumPts,
		                        XPoint *, int Style, int W, int AW,
		                        int AH, int *LtX, int *LtY, int *RbX,
		                        int *RbY));
/* extern void	RotatePolyObj ARGS_DECL((void)); */
extern void	UpdPolyBBox ARGS_DECL((struct ObjRec *, int NumPts, XPoint *));
extern void	DrawPoly ARGS_DECL((XEvent *));
extern void	InputPolyPts ARGS_DECL((void));
extern void	DumpPolyObj ARGS_DECL((FILE *, struct ObjRec *));
extern void	DrawPolyObj ARGS_DECL((Window, int XOff, int YOff,
		                       struct ObjRec *));
extern void	SaveSmoothHinge ARGS_DECL((FILE *, int Curved, int NumPts,
		                           char *Smooth));
extern void	SavePolyObj ARGS_DECL((FILE *, struct ObjRec *));
extern int	ReadSmoothHinge ARGS_DECL((FILE *, int Curved, int NumPts,
		                           char *Smooth));
extern void	ReadPolyObj ARGS_DECL((FILE *, char *Inbuf, struct ObjRec **));
extern void	FreePolyObj ARGS_DECL((struct ObjRec *));

#endif /*_POLY_E_*/
