/*
 * Author:      William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990-1994, William Cheng.
 *
 * Permission limited to the use, copy, modify, and distribute this software
 * and its documentation for any purpose is hereby granted by the Author without
 * fee, provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the Author not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.  All other
 * rights (including the right to sell "tgif" and the right to sell derivative
 * works of tgif) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /export/bourbon/multimedia/william/X11/TGIF2/RCS/remote.e,v 2.10 1994/12/23 06:58:58 william Exp $
 */

#ifndef _TGIF_REMOTE_E_
#define _TGIF_REMOTE_E_

extern int	GetClientID ARGS_DECL((char *psz_buf, int buf_sz));
extern int	GetUserID ARGS_DECL((char *psz_buf, int buf_sz));
extern int	UserAbortComm ARGS_DECL((void));
extern void	FreeRemoteBuf ARGS_DECL((char*));
extern int	DirIsRemote ARGS_DECL((char*));
extern int	FileIsRemote ARGS_DECL((char*));
extern int	UrlIsHtml ARGS_DECL((char*));
extern int	FormRemoteName ARGS_DECL((char *psz_file, char *psz_def_ext,
		                          char *psz_return));
extern int	FormNewFileName ARGS_DECL((char *psz_dir, char *psz_file,
		                           char *psz_def_ext,
		                           char *psz_return));
extern void	ShowRemoteStatus ARGS_DECL((char*));
extern int	LoadRemoteFileInMem ARGS_DECL((char *url, char **ppsz_buf,
		                               char **ppsz_content_type,
		                               int *pn_buf_sz, int *pn_html));
extern char	*WriteRemoteFileIntoTemp ARGS_DECL((char *psz_buf, int buf_sz));
extern int	UseViewer ARGS_DECL((char *psz_url, char *psz_content_type,
		                     char *tmp_fname));
extern int	LoadRemoteFileFromMem ARGS_DECL((char *psz_url, char *psz_buf,
		                                 char *psz_content_type,
		                                 int buf_sz, int is_html));
extern void	InitRemote ARGS_DECL((void));
extern void	CleanUpRemote ARGS_DECL((void));

#endif /*_TGIF_REMOTE_E_*/
