/*
 * Author:      William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990-1994, William Cheng.
 *
 * Permission limited to the use, copy, modify, and distribute this software
 * and its documentation for any purpose is hereby granted by the Author without
 * fee, provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the Author not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.  All other
 * rights (including the right to sell "tgif" and the right to sell derivative
 * works of tgif) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /export/bourbon/multimedia/william/X11/TGIF2/RCS/xbitmap.e,v 2.31 1994/04/23 05:35:06 william Exp $
 */

#ifndef _XBITMAP_E_
#define _XBITMAP_E_

extern GC	xbmGC;
extern int	askForXBmSpec;
extern int	stripEPSComments;
extern int	saveEPSLines;
extern Pixmap	dummyBitmap;

extern void	InitXBm ARGS_DECL((void));
extern void	CleanUpXBm ARGS_DECL((void));
extern void	CalcTransform ARGS_DECL((struct MtrxRec *));
extern void	MakeCachedBitmap ARGS_DECL((struct ObjRec *));
extern int	ExtractBitmap ARGS_DECL((Pixmap OrigBitmap, XImage *OrigImage,
		                         int X, int Y, int W, int H,
		                         Pixmap *Bitmap, XImage **Image));
extern void	InvertXBitmaps ARGS_DECL((void));
extern void	ParseCutSpec ARGS_DECL((char *Spec, int ImageW, int ImageH,
		                        float *Mag, int *SrcX, int *SrcY,
		                        int *SrcW, int *SrcH));
extern void	CutXBitmap ARGS_DECL((void));
extern void	GenPreviewBitmap ARGS_DECL((FILE *, int llxPage, int llyPage,
		                            int urxPage, int uryPage));
extern void	DumpXBitmapFile ARGS_DECL((void));
extern void	DumpXBmObj ARGS_DECL((FILE *, struct ObjRec *));
extern int	NeedsToCacheXBmObj ARGS_DECL((struct ObjRec *));
extern void	DrawXBmObj ARGS_DECL((Window, int XOff, int YOff,
		                      struct ObjRec *));
extern struct ObjRec	* CreateXBmObj ARGS_DECL((int ImageW, int ImageH, int W,
			                          int H, Pixmap, XImage *));
extern void	SaveXBmObj ARGS_DECL((FILE *, struct ObjRec *));
extern void	ReadXBmObj ARGS_DECL((FILE *, char *Inbuf, struct ObjRec **));
extern void	FreeXBmObj ARGS_DECL((struct ObjRec *));

#endif /*_XBITMAP_E_*/
