# automatically generated file, don't edit



# Copyright 2024 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::DE;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20240607153920;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            3[02]|
            40|
            [68]9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,13})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            2(?:
              0[1-389]|
              12[0-8]
            )|
            3(?:
              [35-9][15]|
              4[015]
            )|
            906|
            2(?:
              [13][14]|
              2[18]
            )|
            (?:
              2[4-9]|
              4[2-9]|
              [579][1-9]|
              [68][1-8]
            )1
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [24-6]|
            3(?:
              3(?:
                0[1-467]|
                2[127-9]|
                3[124578]|
                7[1257-9]|
                8[1256]|
                9[145]
              )|
              4(?:
                2[135]|
                4[13578]|
                9[1346]
              )|
              5(?:
                0[14]|
                2[1-3589]|
                6[1-4]|
                7[13468]|
                8[13568]
              )|
              6(?:
                2[1-489]|
                3[124-6]|
                6[13]|
                7[12579]|
                8[1-356]|
                9[135]
              )|
              7(?:
                2[1-7]|
                4[145]|
                6[1-5]|
                7[1-4]
              )|
              8(?:
                21|
                3[1468]|
                6|
                7[1467]|
                8[136]
              )|
              9(?:
                0[12479]|
                2[1358]|
                4[134679]|
                6[1-9]|
                7[136]|
                8[147]|
                9[1468]
              )
            )|
            70[2-8]|
            8(?:
              0[2-9]|
              [1-8]
            )|
            90[7-9]|
            [79][1-9]|
            3[68]4[1347]|
            3(?:
              47|
              60
            )[1356]|
            3(?:
              3[46]|
              46|
              5[49]
            )[1246]|
            3[4579]3[1357]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2,11})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '138',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '3',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{2,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '181',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{5,11})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              3|
              80
            )|
            9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d)(\\d{4,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '1[67]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18500',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18[68]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[1279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            15(?:
              [0568]|
              31
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              6[023]|
              7
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15[279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{7})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{8})'
                }
              ];

my $validators = {
                'fixed_line' => '
          32\\d{9,11}|
          49[1-6]\\d{10}|
          322\\d{6}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'geographic' => '
          32\\d{9,11}|
          49[1-6]\\d{10}|
          322\\d{6}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'mobile' => '
          15(?:
            [0-25-9]\\d\\d|
            310
          )\\d{6}|
          1(?:
            6[023]|
            7\\d
          )\\d{7,8}
        ',
                'pager' => '
          16(?:
            4\\d{1,10}|
            [89]\\d{1,11}
          )
        ',
                'personal_number' => '700\\d{8}',
                'specialrate' => '(
          180\\d{5,11}|
          13(?:
            7[1-6]\\d\\d|
            8
          )\\d{4}
        )|(
          (?:
            137[7-9]|
            900(?:
              [135]|
              9\\d
            )
          )\\d{6}
        )|(
          18(?:
            1\\d{5,11}|
            [2-9]\\d{8}
          )
        )',
                'toll_free' => '800\\d{7,12}',
                'voip' => ''
              };
my %areanames = ();
$areanames{en} = {"497151", "Waiblingen",
"498093", "Glonn\ Kreis\ Ebersberg",
"499090", "Rain\ Lech",
"497361", "Aalen",
"497054", "Wildberg\ Württemberg",
"4936949", "Obermassfeld\-Grimmenthal",
"4936965", "Stadtlengsfeld",
"496660", "Steinau\-Marjoss",
"496572", "Manderscheid\ Eifel",
"499733", "Münnerstadt",
"4939241", "Leitzkau",
"496586", "Beuren\ Hochwald",
"4935696", "Briesnig",
"4938377", "Zinnowitz",
"492585", "Warendorf\-Hoetmar",
"492753", "Erndtebrück",
"498136", "Markt\ Indersdorf",
"498241", "Buchloe",
"492334", "Hagen\-Hohenlimburg",
"4939928", "Möllenhagen",
"4934783", "Gerbstedt",
"496578", "Salmtal",
"496691", "Schwalmstadt",
"4934386", "Dürrweitzschen\ bei\ Grimma",
"499354", "Rieneck",
"499164", "Langenfeld\ Mittelfranken",
"492722", "Attendorn",
"4935974", "Hinterhermsdorf",
"496461", "Biedenkopf",
"492427", "Nideggen",
"4938872", "Rehna",
"495808", "Gerdau",
"492243", "Eitorf",
"497130", "Löwenstein\ Württemberg",
"494856", "Kronprinzenkoog",
"494802", "Wrohm",
"494204", "Thedinghausen",
"498751", "Mainburg",
"497736", "Tengen",
"4936871", "Bad\ Colberg\-Heldburg",
"495204", "Steinhagen\ Westfalen",
"495802", "Wrestedt",
"499627", "Freudenberg\ Oberpfalz",
"497947", "Forchtenberg",
"493629", "Stadtilm",
"4933747", "Marzahna",
"492301", "Holzwickede",
"4935203", "Tharandt",
"496420", "Lahntal",
"4933870", "Zollchow\ bei\ Rathenow",
"497841", "Achern",
"498326", "Fischen\ im\ Allgäu",
"496276", "Hesseneck",
"4933838", "Päwesin",
"492275", "Kerpen\-Buir",
"492971", "Schmallenberg\-Dorlar",
"495250", "Delbrück\ Westfalen",
"496282", "Walldürn",
"4933055", "Kremmen",
"498052", "Aschau\ im\ Chiemgau",
"494554", "Wahlstedt",
"495483", "Lienen",
"494231", "Verden\ Aller",
"494935", "Juist",
"496621", "Bad\ Hersfeld",
"495231", "Detmold",
"495935", "Twist\-Schöninghsdorf",
"492667", "Stein\-Neukirch",
"495554", "Moringen",
"494483", "Ovelgönne\-Grossenmeer",
"4938300", "Insel\ Hiddensee",
"495146", "Wietze",
"498023", "Bayrischzell",
"499467", "Michelsneukirchen",
"4934492", "Lucka",
"499762", "Saal\ an\ der\ Saale",
"494740", "Loxstedt\-Dedesdorf",
"493563", "Spremberg",
"4934636", "Schafstädt",
"4938223", "Saal\ Vorpom",
"494146", "Stade\-Bützfleth",
"498303", "Waltenhofen",
"4935752", "Ruhland",
"497822", "Ettenheim",
"4939329", "Möringen",
"4935055", "Höckendorf\ bei\ Dippoldiswalde",
"497224", "Gernsbach",
"492836", "Wachtendonk",
"492501", "Münster\-Hiltrup",
"497175", "Leinzell",
"496835", "Beckingen",
"494627", "Dörpstedt",
"4939389", "Schollene",
"499856", "Dürrwangen",
"499802", "Ansbach\-Katterbach",
"496237", "Maxdorf",
"4933203", "Kleinmachnow",
"499204", "Plankenfels",
"498292", "Dinkelscherben",
"495733", "Vlotho",
"497853", "Kehl\-Bodersweier",
"4939404", "Ausleben",
"498503", "Neuhaus\ am\ Inn",
"4936732", "Könitz",
"494733", "Butjadingen\-Burhave",
"496642", "Schlitz",
"494164", "Harsefeld",
"4934344", "Kohren\-Sahlis",
"494354", "Fleckeby",
"495164", "Hodenhagen",
"495354", "Jerxheim",
"4939052", "Erxleben\ bei\ Haldensleben",
"497520", "Bodnegg",
"496648", "Bad\ Salzschlirf",
"4938731", "Lübz",
"492534", "Münster\-Roxel",
"495768", "Petershagen\-Heimsen",
"492251", "Euskirchen",
"492955", "Büren\-Wewelsburg",
"498177", "Münsing\ Starnberger\ See",
"4938451", "Hoppenrade\ bei\ Güstrow",
"4938827", "Kalkhorst",
"499554", "Untersteinbach\ Unterfranken",
"4937363", "Zöblitz",
"499935", "Stephansposching",
"493338", "Bernau\ Brandenburg",
"499231", "Marktredwitz",
"4938750", "Malliss",
"494768", "Hipstedt",
"496372", "Bruchmühlbach\-Miesau",
"494959", "Dollart",
"4933432", "Müncheberg",
"498222", "Burgau\ Schwaben",
"498824", "Oberau\ Loisach",
"4936452", "Berlstedt",
"495467", "Voltlage",
"499146", "Markt\ Berolzheim",
"497561", "Leutkirch\ im\ Allgäu",
"495300", "Salzgitter\-Üfingen",
"494467", "Wittmund\-Funnix",
"492385", "Hamm\-Rhynern",
"492683", "Asbach\ Westerwald",
"498743", "Geisenhausen",
"494762", "Kutenholz",
"493332", "Schwedt\/Oder",
"496386", "Altenkirchen\ Pfalz",
"493843", "Güstrow",
"49861", "Traunstein",
"4933678", "Storkow\ Mark",
"497478", "Hirrlingen",
"492741", "Betzdorf",
"498681", "Waging\ am\ See",
"493425", "Wurzen",
"493724", "Burgstädt",
"499279", "Mistelgau",
"497143", "Besigheim",
"4938322", "Richtenberg",
"497777", "Sauldorf",
"4934445", "Stössen",
"4933974", "Dessow",
"497472", "Rottenburg\ am\ Neckar",
"497486", "Horb\-Altheim",
"498253", "Pöttmes",
"496083", "Weilrod",
"497229", "Iffezheim",
"498431", "Neuburg\ an\ der\ Donau",
"492622", "Bendorf\ am\ Rhein",
"4935435", "Gollmitz\ bei\ Calau",
"499280", "Selbitz\ Oberfranken",
"498283", "Neuburg\ an\ der\ Kammel",
"4936962", "Vacha",
"497707", "Bräunlingen",
"496053", "Wächtersbach",
"499195", "Adelsdorf\ Mittelfranken",
"497402", "Fluorn\-Winzeln",
"497456", "Haiterbach",
"499428", "Kirchroth",
"499209", "Emtmannsberg",
"498651", "Bad\ Reichenhall",
"492628", "Rhens",
"4935797", "Schwepnitz",
"499727", "Schonungen\-Marktsteinach",
"499422", "Bogen\ Niederbayern",
"497636", "Münstertal\ Schwarzwald",
"499633", "Mitterteich",
"498630", "Oberneukirchen",
"496022", "Obernburg\ am\ Main",
"4938759", "Tewswoos",
"4938875", "Schlagsdorf\ bei\ Gadebusch",
"499335", "Aub\ Kreis\ Würzburg",
"498545", "Hofkirchen\ Bayern",
"492653", "Kaisersesch",
"4936376", "Straussfurt",
"496356", "Carlsberg\ Pfalz",
"496302", "Winnweiler",
"496166", "Fischbachtal",
"492355", "Schalksmühle",
"492165", "Jüchen",
"498450", "Ingolstadt\-Zuchering",
"492985", "Winterberg\-Niedersfeld",
"499453", "Thalmassing",
"49221", "Cologne",
"496028", "Sulzbach\ am\ Main",
"496308", "Olsbrücken",
"494169", "Sauensiek",
"492433", "Hückelhoven",
"4935241", "Lommatzsch",
"4936704", "Steinheid",
"494384", "Selent",
"4939752", "Blumenhagen\ bei\ Strasburg",
"493963", "Woldegk",
"492462", "Linnich",
"495384", "Seesen\-Gross\ Rhüden",
"496721", "Bingen\ am\ Rhein",
"4933052", "Leegebruch",
"499662", "Vilseck",
"495954", "Lorup",
"4936844", "Rohr\ Thüringen",
"498404", "Oberdolling",
"498573", "Ering",
"496092", "Heimbuchenthal",
"495535", "Polle",
"494535", "Nahe",
"4933473", "Zechin",
"494954", "Moormerland",
"498705", "Altfraunhofen",
"4939320", "Schinne",
"499872", "Heilsbronn",
"499274", "Hollfeld",
"4938208", "Kavelstorf",
"492571", "Greven\ Westfalen",
"499492", "Parsberg",
"494441", "Vechta",
"4935755", "Ortrand",
"492692", "Kelberg",
"4939203", "Barleben",
"499498", "Laaber",
"4934495", "Dobitschen",
"495441", "Diepholz",
"493464", "Sangerhausen",
"495335", "Schladen",
"4938309", "Trent",
"498373", "Altusried",
"495633", "Diemelsee",
"4935052", "Kipsdorf\ Kurort",
"496223", "Neckargemünd",
"4939291", "Calbe\ Saale",
"496742", "Boppard",
"494633", "Satrup",
"493765", "Reichenbach\ Vogtland",
"494335", "Hohn\ bei\ Rendsburg",
"496447", "Langgöns\-Niederkleen",
"4935473", "Neu\ Lübbenau",
"499359", "Karlstadt\-Wiesenfeld",
"495453", "Recke",
"494453", "Zetel",
"495584", "Hattorf\ am\ Harz",
"4933334", "Greiffenberg",
"492339", "Sprockhövel\-Hasslinghausen",
"494195", "Hartenholm",
"4936735", "Probstzella",
"4938424", "Bobitz",
"498076", "Pfaffing",
"4935389", "Holzdorf\ Elster",
"497347", "Dietenheim",
"496252", "Heppenheim\ Bergstrasse",
"4939956", "Neukalen",
"496206", "Lampertheim",
"4939747", "Züsedom",
"498082", "Schwindegg",
"495428", "Melle\-Neuenkirchen",
"492205", "Rösrath",
"495195", "Neuenkirchen\ bei\ Soltau",
"496854", "Oberthal\ Saar",
"495209", "Gütersloh\-Friedrichsdorf",
"4938484", "Ventschow",
"4939055", "Hörsingen",
"4935329", "Dollenchen",
"494422", "Sande\ Kreis\ Friesl",
"495422", "Melle",
"496258", "Gernsheim",
"494209", "Schwanewede",
"4937348", "Oberwiesenthal\ Kurort",
"498267", "Dirlewang",
"492371", "Iserlohn",
"492641", "Bad\ Neuenahr\-Ahrweiler",
"498781", "Rottenburg\ an\ der\ Laaber",
"495274", "Nieheim",
"492129", "Haan\ Rheinland",
"494492", "Saterland",
"495872", "Stoetze",
"49871", "Landshut",
"494872", "Hanerau\-Hademarschen",
"4937381", "Penig",
"495492", "Steinfeld\ Oldenburg",
"493624", "Ohrdruf",
"494274", "Varrel\ bei\ Sulingen",
"494125", "Seestermühe",
"494498", "Saterland\-Ramsloh",
"499441", "Kelheim",
"4937321", "Frankenstein\ Sachsen",
"4933435", "Rehfelde",
"4938325", "Rolofshagen",
"4936766", "Schalkau",
"492440", "Nettersheim\-Tondorf",
"496041", "Glauburg",
"496144", "Bischofsheim\ bei\ Rüsselsheim",
"499384", "Schwanfeld",
"494668", "Klanxbüll",
"497961", "Ellwangen\ Jagst",
"4936940", "Oepfershausen",
"497265", "Angelbachtal",
"496508", "Hetzerath\ Mosel",
"494559", "Wensin",
"49711", "Stuttgart",
"499535", "Pfarrweisach",
"493987", "Templin",
"495662", "Felsberg\ Hessen",
"499954", "Simbach\ Niederbayern",
"496293", "Schefflenz",
"497084", "Schömberg\ bei\ Neuenbürg",
"497181", "Schorndorf\ Württemberg",
"4939991", "Daberkow",
"49381", "Rostock",
"492555", "Schöppingen",
"494662", "Leck",
"492934", "Sundern\-Altenhellefeld",
"493881", "Grevesmühlen",
"4933928", "Wildberg\ Brandenburg",
"498345", "Stöttwang",
"496502", "Schweich",
"496556", "Pronsfeld",
"495661", "Melsungen",
"492237", "Kerpen\ Rheinland\-Türnich",
"4936695", "Söllmnitz",
"497182", "Welzheim",
"496048", "Büdingen\-Eckartshausen",
"499855", "Dentlein\ am\ Forst",
"493876", "Perleberg",
"499257", "Zell\ Oberfranken",
"496501", "Konz",
"496836", "Überherrn",
"493496", "Köthen\ Anhalt",
"497176", "Spraitbach",
"494661", "Niebüll",
"4935877", "Cunewalde",
"492835", "Issum",
"4933608", "Jacobsdorf\ Mark",
"495839", "Wittingen\-Ohrdorf",
"496042", "Büdingen\ Hessen",
"494839", "Wöhrden\ Dithmarschen",
"4933973", "Zernitz\ bei\ Neustadt\ Dosse",
"497962", "Fichtenau",
"4937436", "Weischlitz",
"495027", "Linsburg",
"494307", "Raisdorf",
"498369", "Rückholz",
"4939062", "Bebertal",
"4937364", "Reitzenhain\ Erzgebirge",
"499747", "Geroda\ Bayern",
"499442", "Riedenburg",
"49202", "Wuppertal",
"495307", "Braunschweig\-Wenden",
"494491", "Friesoythe",
"494977", "Blomberg\ Ostfriesland",
"498170", "Strasslach\-Dingharting",
"4936074", "Worbis",
"499173", "Thalmässing",
"497249", "Stutensee",
"498782", "Pfeffenhausen",
"492642", "Remagen",
"4933762", "Zeuthen",
"495977", "Spelle",
"499448", "Hausen\ Niederbayern",
"494871", "Hohenwestedt",
"495491", "Damme\ Dümmer",
"496385", "Reichenbach\-Steegen",
"494421", "Wilhelmshaven",
"4939403", "Gröningen\ Sachsen\-Anhalt",
"496683", "Ehrenberg\ Rhön",
"4935935", "Kleinwelka",
"499145", "Solnhofen",
"4936462", "Ossmannstedt",
"492372", "Hemer",
"495421", "Dissen\ am\ Teutoburger\ Wald",
"497527", "Wolfegg",
"4934295", "Krensitz",
"499936", "Wallerfing",
"493574", "Lauchhammer",
"4934746", "Giersleben",
"4937756", "Breitenbrunn\ Erzgebirge",
"4938461", "Bützow",
"492902", "Warstein",
"492378", "Fröndenberg\-Langschede",
"4938757", "Neustadt\-Glewe",
"496534", "Mülheim\ Mosel",
"4934343", "Regis\-Breitingen",
"496251", "Bensheim",
"49209", "Gelsenkirchen",
"498081", "Dorfen\ Stadt",
"4937465", "Tannenbergsthal\ Vogtland",
"497485", "Empfingen",
"49385", "Schwerin",
"4933637", "Beerfelde",
"497933", "Creglingen",
"4933204", "Beelitz\ Mark",
"49906", "Donauwörth",
"4935266", "Heyda\ bei\ Riesa",
"4939932", "Malchow\ bei\ Waren",
"496741", "St\ Goar",
"492691", "Adenau",
"4936642", "Harra",
"494747", "Beverstedt",
"494442", "Lohne\ Oldenburg",
"498463", "Greding",
"495442", "Barnstorf\ Kreis\ Diepholz",
"499307", "Altertheim",
"496334", "Thaleischweiler\-Fröschen",
"498135", "Sulzemoos",
"493904", "Haldensleben",
"492586", "Beelen",
"496753", "Meisenheim",
"496585", "Ralingen",
"499871", "Windsbach",
"495173", "Uetze",
"4938224", "Gresenhorst",
"495448", "Barver",
"4938370", "Kröslin",
"494173", "Wulfsen",
"499977", "Arnschwang",
"499491", "Hemau",
"497327", "Dischingen",
"492572", "Emsdetten",
"494257", "Schweringen",
"495855", "Nahrendorf",
"4936741", "Bad\ Blankenburg",
"4935204", "Wilsdruff",
"499661", "Sulzbach\-Rosenberg",
"497735", "Öhningen",
"496728", "Ober\-Hilbersheim",
"497434", "Winterlingen",
"494855", "Eddelak",
"495257", "Hövelhof",
"496243", "Monsheim",
"497940", "Künzelsau",
"497654", "Löffingen",
"492859", "Wesel\-Bislich",
"496722", "Rüdesheim\ am\ Rhein",
"496427", "Cölbe\-Schönstadt",
"498395", "Tannheim\ Württemberg",
"492461", "Jülich",
"493931", "Stendal",
"4935608", "Gross\ Ossnig",
"4935327", "Priessen",
"498623", "Kirchweidach",
"496275", "Rothenberg\ Odenwald",
"498325", "Oberstaufen\-Thalkirchdorf",
"4935973", "Stolpen",
"4939885", "Jakobshagen",
"4934242", "Hohenpriessnitz",
"496124", "Bad\ Schwalbach",
"496021", "Aschaffenburg",
"4939749", "Grambow\ bei\ Pasewalk",
"4935387", "Seyda",
"4933877", "Nitzahn",
"4939825", "Wokuhl",
"4933966", "Dranse",
"496301", "Otterbach\ Pfalz",
"498652", "Berchtesgaden",
"4939456", "Altenbrak",
"499421", "Straubing",
"4936255", "Goldbach\ bei\ Gotha",
"4933235", "Friesack",
"495145", "Beedenbostel",
"4935822", "Hagenwerder",
"496667", "Steinau\-Ulmbach",
"492621", "Lahnstein",
"495936", "Twist",
"498432", "Burgheim",
"499097", "Marxheim",
"495507", "Ebergötzen",
"494936", "Grossheide",
"4938307", "Poseritz",
"493644", "Apolda",
"4933456", "Wriezen",
"496339", "Grosssteinhausen",
"497471", "Hechingen",
"493379", "Mahlow",
"4936692", "Bürgel",
"499647", "Kirchenthumbach",
"498682", "Laufen\ Salzach",
"492742", "Wissen",
"494336", "Owschlag",
"492447", "Dahlem\ bei\ Kall",
"492223", "Königswinter",
"495336", "Semmenstedt",
"493909", "Klötze\ Altmark",
"497562", "Isny\ im\ Allgäu",
"496371", "Landstuhl",
"498221", "Günzburg",
"495761", "Stolzenau",
"499238", "Röslau",
"493331", "Angermünde",
"494761", "Bremervörde",
"495196", "Wietzendorf",
"497568", "Bad\ Wurzach\-Hauerz",
"492206", "Overath",
"492252", "Zülpich",
"496205", "Hockenheim",
"4936028", "Kammerforst\ Thüringen",
"499232", "Wunsiedel",
"498075", "Amerang",
"4933765", "Märkisch\ Buchholz",
"4939740", "Nechlin",
"495033", "Wunstorf\-Grossenheidorn",
"499834", "Theilenhofen",
"4938792", "Lenzen\ \(Elbe\)",
"4934292", "Brandis\ bei\ Wurzen",
"498043", "Jachenau",
"495126", "Algermissen",
"4939266", "Förderstedt",
"4936465", "Oberndorf\ bei\ Apolda",
"4939488", "Güntersberge",
"4935932", "Guttau",
"4938423", "Bad\ Kleinen",
"499263", "Ludwigsstadt",
"495062", "Holle\ bei\ Hildesheim",
"494126", "Horst\ Holstein",
"497684", "Glottertal",
"497533", "Allensbach",
"498291", "Zusmarshausen",
"4939428", "Pabstorf",
"49228", "Bonn",
"494287", "Heeslingen\-Boitzen",
"494885", "Bergenhusen",
"4936041", "Bad\ Tennstedt",
"4938483", "Brüel",
"496641", "Lauterbach\ Hessen",
"497340", "Neenstetten",
"495068", "Elze\ Leine",
"496129", "Schlangenbad",
"496555", "Bleialf",
"496783", "Baumholder",
"4935474", "Schönwalde\ bei\ Lübben",
"498346", "Pforzen",
"494103", "Wedel",
"499907", "Zenting",
"492556", "Metelen",
"492502", "Nottuln",
"4939036", "Binde",
"495103", "Wennigsen\ Deister",
"4937462", "Rothenkirchen\ Vogtland",
"499536", "Kirchlauter",
"492293", "Nümbrecht",
"499377", "Freudenberg\-Boxtal",
"4938379", "Benz\ Usedom",
"497266", "Kirchardt",
"4933333", "Tantow",
"492508", "Drensteinfurt",
"493304", "Velten",
"492041", "Bottrop",
"496440", "Kölschhausen",
"4936947", "Jüchsen",
"497821", "Lahr\ Schwarzwald",
"498564", "Johanniskirchen",
"497635", "Schliengen",
"499761", "Bad\ Königshofen\ im\ Grabfeld",
"494238", "Neddenaverbergen",
"497333", "Laichingen",
"4934467", "Eckartsberga",
"4936645", "Mühltroff",
"495238", "Nieheim\-Himmighausen",
"496628", "Oberaula",
"492053", "Velbert\-Neviges",
"494232", "Langwedel\ Kreis\ Verden",
"497455", "Dornhan",
"4933932", "Fehrbellin",
"499196", "Wiesenttal",
"494834", "Büsum",
"4939204", "Niederndodeleben",
"495834", "Wittingen\-Knesebeck",
"497754", "Görwihl",
"496622", "Bebra",
"495232", "Lage\ Lippe",
"496433", "Hadamar",
"492972", "Schmallenberg",
"492308", "Unna\-Hemmerde",
"4938296", "Rerik\ Ostseebad",
"4937297", "Thum\ Sachsen",
"496281", "Buchen\ Odenwald",
"498364", "Seeg",
"497193", "Sulzbach\ an\ der\ Murr",
"498051", "Prien\ am\ Chiemsee",
"4934652", "Allstedt",
"495647", "Lichtenau\-Kleinenberg",
"493504", "Dippoldiswalde",
"493473", "Aschersleben\ Sachsen\-Anhalt",
"49621", "Mannheim",
"492166", "Mönchengladbach\-Rheydt",
"492302", "Witten",
"496653", "Burghaun",
"496165", "Breuberg",
"496355", "Albisheim\ Pfrimm",
"498546", "Windorf\-Otterskirchen",
"4933474", "Neutrebbin",
"499336", "Bütthard",
"497842", "Kappelrodeck",
"497244", "Weingarten\ Baden",
"4936843", "Benshausen",
"498706", "Vilsheim",
"498752", "Au\ in\ der\ Hallertau",
"4939882", "Gollin",
"496468", "Dautphetal\-Mornshausen",
"494536", "Steinhorst\ Lauenburg",
"495907", "Geeste",
"498457", "Vohburg\ an\ der\ Donau",
"495536", "Holzminden\-Neuhaus",
"499103", "Cadolzburg",
"496462", "Gladenbach",
"4936703", "Gräfenthal",
"4939822", "Kratzeburg",
"498637", "Lohkirchen",
"495377", "Ehra\-Lessien",
"493445", "Naumburg\ Saale",
"4935456", "Terpt",
"492721", "Lennestadt",
"497123", "Metzingen\ Württemberg",
"493744", "Auerbach\ Vogtland",
"4933232", "Brieselang",
"494263", "Scheessel",
"4935825", "Kodersdorf",
"497158", "Neuhausen\ auf\ den\ Fildern",
"499126", "Eckental",
"4939387", "Havelberg",
"4936252", "Tambach\-Dietharz",
"499720", "Üchtelhausen",
"496692", "Neustadt\ Hessen",
"498723", "Arnstorf",
"495263", "Barntrup",
"496571", "Wittlich",
"4939973", "Altkalen",
"498248", "Lamerdingen",
"4939327", "Klietz",
"497362", "Bopfingen",
"497152", "Leonberg\ Württemberg",
"499287", "Selb",
"493531", "Finsterwalde",
"496698", "Schrecksbach",
"4939608", "Staven",
"499401", "Neutraubling",
"493994", "Malchin",
"492273", "Kerpen\-Horrem",
"495527", "Duderstadt",
"4936870", "Masserberg",
"498239", "Langenneufnach",
"499397", "Wertheim\-Dertingen",
"492601", "Nauort",
"4937329", "Grosshartmannsdorf",
"493329", "Stahnsdorf",
"494527", "Bosau",
"4934656", "Wallhausen\ Sachsen\-Anhalt",
"496542", "Bullay",
"4934423", "Heuckewalde",
"498025", "Miesbach",
"4938292", "Kröpelin",
"495933", "Lathen",
"497620", "Schopfheim\-Gersbach",
"496321", "Neustadt\ an\ der\ Weinstrasse",
"492367", "Henrichenburg",
"498271", "Meitingen",
"494485", "Elsfleth\-Huntorf",
"492157", "Nettetal\-Kaldenkirchen",
"4939999", "Tutow",
"495485", "Ladbergen",
"496104", "Heusenstamm",
"494933", "Dornum\ Ostfriesland",
"494188", "Welle\ Nordheide",
"498466", "Denkendorf\ Oberbayern",
"499654", "Pleystein",
"495962", "Herzlake",
"496708", "Bad\ Münster\ am\ Stein\-Ebernburg",
"4938301", "Putbus",
"496391", "Dahn",
"4939886", "Milmersdorf",
"492634", "Rengsdorf",
"497839", "Schapbach",
"494962", "Papenburg\-Aschendorf",
"496756", "Winterbach\ Soonwald",
"499434", "Bodenwöhr",
"494182", "Tostedt",
"495176", "Edemissen",
"492583", "Sassenberg",
"494770", "Wischhafen",
"492755", "Bad\ Berleburg\-Schwarzenau",
"496407", "Rabenau\ Hessen",
"4935894", "Hähnichen",
"498095", "Aying",
"4939363", "Angern",
"4933965", "Herzsprung\ bei\ Wittstock",
"496150", "Weiterstadt",
"4939826", "Blankensee\ bei\ Neustrelitz",
"492454", "Gangelt",
"4935452", "Golssen",
"499735", "Massbach",
"495182", "Gronau\ Leine",
"494968", "Neulehe",
"494176", "Marschacht",
"497661", "Kirchzarten",
"497977", "Oberrot\ bei\ Gaildorf",
"494249", "Bassum\-Nordwohlde",
"49851", "Passau",
"496034", "Wöllstadt",
"496131", "Mainz",
"498581", "Waldkirchen\ Niederbayern",
"4936256", "Wechmar",
"4939455", "Schierke",
"4934691", "Könnern",
"496246", "Eich\ Rheinhessen",
"497307", "Senden\ Iller",
"492941", "Lippstadt",
"492245", "Much",
"4934978", "Radegast\ Kreis\ Köthen",
"493632", "Sondershausen",
"492383", "Bönen",
"498745", "Bodenkirchen",
"492685", "Flammersfeld",
"498444", "Schweitenkirchen",
"4933452", "Neulewin",
"496672", "Eiterfeld",
"4934603", "Nauendorf\ Sachsen\-Anhalt",
"4939773", "Altwarp",
"496591", "Gerolstein",
"499933", "Wallersdorf",
"494137", "Barendorf",
"495137", "Seelze",
"492953", "Wünnenberg",
"496678", "Wildeck\-Hönebach",
"492928", "Soest\-Ostönnen",
"496085", "Waldsolms",
"495401", "Georgsmarienhütte",
"4937435", "Reuth\ bei\ Plauen",
"4939398", "Gross\ Garz",
"498857", "Benediktbeuern",
"494401", "Brake\ Unterweser",
"497936", "Schrozberg\-Bartenstein",
"496868", "Mettlach\-Tünsdorf",
"497145", "Markgröningen",
"492922", "Werl",
"499527", "Knetzgau",
"4938796", "Viesecke",
"496264", "Neudenau",
"4938393", "Binz\ Ostseebad",
"498381", "Lindenberg\ im\ Allgäu",
"493423", "Eilenburg",
"49831", "Kempten\ Allgäu",
"492992", "Marsberg",
"4936203", "Vieselbach",
"495327", "Bad\ Grund\ Harz",
"492771", "Dillenburg",
"497448", "Seewald",
"497173", "Heubach",
"4934296", "Groitzsch\ bei\ Pegau",
"493529", "Heidenau\ Sachsen",
"494327", "Grossenaspe",
"4939262", "Güsten\ Anh",
"4935936", "Sohland\ Spree",
"496833", "Rehlingen\-Siersburg",
"493493", "Bitterfeld",
"4933631", "Bad\ Saarow\-Pieskow",
"4934745", "Winningen\ Sachsen\-Anhalt",
"497747", "Berau",
"497442", "Baiersbronn",
"4936651", "Lobenstein",
"4937755", "Schönheide\ Erzgebirge",
"492739", "Wilnsdorf",
"496348", "Offenbach\ an\ der\ Queich",
"4939032", "Mahlsdorf\ bei\ Salzwedel",
"492567", "Ahaus\-Alstätte",
"4938751", "Picher",
"499962", "Schwarzach\ Niederbayern",
"495654", "Herleshausen",
"499188", "Postbauer\-Heng",
"4938450", "Tarnow\ bei\ Bützow",
"493663", "Schleiz",
"4933732", "Hennickendorf\ bei\ Luckenwalde",
"498505", "Hutthurm",
"496342", "Schweigen\-Rechtenbach",
"497257", "Bruchsal\-Untergrombach",
"499176", "Allersberg",
"494735", "Butjadingen\-Stollhamm",
"495434", "Essen\ Oldenburg",
"499182", "Velburg",
"4935249", "Basslitz",
"494434", "Colnrade",
"4935265", "Glaubitz",
"498773", "Neufahrn\ in\ Niederbayern",
"494533", "Reinfeld\ Holstein",
"49345", "Halle\ Saale",
"498703", "Essenbach",
"492132", "Meerbusch\-Büderich",
"4938459", "Laage",
"4936646", "Tanna\ bei\ Schleiz",
"499152", "Hartenstein\ Mittelfranken",
"499106", "Markt\ Erlbach",
"495533", "Bodenwerder",
"494340", "Achterwehr",
"4933844", "Brück\ Brandenburg",
"4935240", "Tauscha\ bei\ Grossenhain",
"495684", "Frielendorf",
"497062", "Beilstein\ Württemberg",
"497720", "Schwenningen\ am\ Neckar",
"4937291", "Augustusburg",
"497126", "Burladingen\-Melchingen",
"493965", "Burow\ bei\ Altentreptow",
"499158", "Offenhausen\ Mittelfranken",
"494684", "Langeness\ Hallig",
"4938295", "Satow\ bei\ Bad\ Doberan",
"494927", "Krummhörn\-Loquard",
"499123", "Lauf\ an\ der\ Pegnitz",
"495821", "Bad\ Bevensen",
"494266", "Brockel",
"4939348", "Klitsche",
"492392", "Werdohl",
"498726", "Schönau\ Niederbayern",
"495266", "Lemgo\-Kirchheide",
"494821", "Itzehoe",
"493594", "Bischofswerda",
"496269", "Gundelsheim\ Württemberg",
"4930", "Berlin",
"4934461", "Nebra\ Unstrut",
"499842", "Uffenheim",
"497336", "Lonsee",
"499244", "Betzenstein",
"492541", "Coesfeld",
"4939321", "Arneburg",
"498064", "Au\ bei\ Bad\ Aibling",
"4933398", "Werneuchen",
"498161", "Freising",
"496055", "Freigericht",
"499193", "Höchstadt\ an\ der\ Aisch",
"499848", "Simmershofen",
"494471", "Cloppenburg",
"4935455", "Walddrehna",
"498285", "Burtenbach",
"492056", "Heiligenhaus",
"4933962", "Heiligengrabe",
"495471", "Bohmte",
"497577", "Veringenstadt",
"492435", "Erkelenz\-Lövenich",
"4939452", "Ilsenburg",
"4933704", "Baruth\ Mark",
"497033", "Weil\ Der\ Stadt",
"4935363", "Fermerswalde",
"496436", "Dornburg\ Hessen",
"4935826", "Königshain\ bei\ Görlitz",
"492983", "Winterberg\-Siedlinghausen",
"493476", "Hettstedt\ Sachsen\-Anhalt",
"495659", "Ringgau",
"492734", "Freudenberg\ Westfalen",
"4939004", "Köckte\ bei\ Gardelegen",
"498543", "Aidenbach",
"494562", "Grömitz",
"492655", "Weibern",
"492353", "Halver",
"492163", "Schwalmtal\ Niederrhein",
"496656", "Ebersburg",
"495439", "Bersenbrück",
"497761", "Bad\ Säckingen",
"499635", "Bärnau",
"498330", "Legau",
"499333", "Sommerhausen",
"495562", "Dassel\-Markoldendorf",
"498046", "Bad\ Heilbrunn",
"495123", "Schellerten",
"4938724", "Siggelkow",
"494123", "Barmstedt",
"499927", "Kirchberg\ Wald",
"4934924", "Zahna",
"492522", "Oelde",
"499266", "Mitwitz",
"499077", "Bachhagel",
"4938784", "Kleinow\ Kreis\ Prignitz",
"497907", "Schwäbisch\ Hall\-Sulzdorf",
"498551", "Freyung",
"492528", "Ennigerloh\-Enniger",
"498234", "Bobingen",
"496897", "Sulzbach\ Saar",
"493437", "Grimma",
"4936928", "Neuenhof\ Thüringen",
"492553", "Ochtrup",
"496786", "Kempfeld",
"494362", "Heiligenhafen",
"499340", "Königheim\-Brehmen",
"494106", "Quickborn\ Kreis\ Pinneberg",
"498343", "Aitrang",
"494152", "Geesthacht",
"499533", "Untermerzbach",
"4937432", "Pausa\ Vogtland",
"495362", "Wolfsburg\-Fallersleben",
"495152", "Hessisch\ Oldendorf",
"496772", "Nastätten",
"492296", "Reichshof\-Brüchermühle",
"496477", "Greifenstein\-Nenderoth",
"4935773", "Schleife",
"492484", "Mechernich\-Eiserfey",
"496295", "Rosenberg\ Baden",
"4933363", "Altenhof\ Kreis\ Barnim",
"497263", "Waibstadt",
"4936624", "Teichwolframsdorf",
"494158", "Roseburg",
"496109", "Frankfurt\-Bergen\-Enkheim",
"495368", "Parsau",
"495158", "Hemeringen",
"4933766", "Teupitz",
"496174", "Königstein\ im\ Taunus",
"497232", "Königsbach\-Stein",
"4936941", "Wasungen",
"496071", "Dieburg",
"495754", "Extertal\-Bremke",
"4939265", "Löderburg",
"494455", "Jade\-Schweiburg",
"4936334", "Wolkramshausen",
"497834", "Wolfach",
"492639", "Anhausen\ Kreis\ Neuwied",
"499568", "Neustadt\ bei\ Coburg",
"494754", "Bülkau",
"495455", "Tecklenburg\-Brochterbeck",
"499659", "Leuchtenberg",
"492861", "Borken\ Westfalen",
"4937752", "Eibenstock",
"494635", "Sörup",
"496827", "Eppelborn",
"494333", "Erfde",
"493763", "Glauchau",
"4935844", "Oybin\ Kurort",
"499562", "Sonnefeld",
"495333", "Dettum",
"492226", "Rheinbach",
"499439", "Neunburg\-Kemnath",
"498375", "Weitnau",
"4934742", "Sylda",
"495635", "Vöhl",
"4935032", "Langenhennersdorf",
"493394", "Wittstock\ Dosse",
"495244", "Rietberg",
"492671", "Cochem",
"495842", "Schnega",
"496039", "Karben",
"4937203", "Gersdorf\ bei\ Chemnitz",
"4939858", "Bietikow",
"494842", "Nordstrand",
"494244", "Harpstedt",
"4939035", "Kuhfelde",
"492598", "Senden\-Ottmarsbocholt",
"4937320", "Mulda\ Sachsen",
"495193", "Schneverdingen",
"492203", "Cologne\-Porz",
"495848", "Trebel",
"4934224", "Belgern\ Sachsen",
"494848", "Rantrum",
"499471", "Burglengenfeld",
"495036", "Neustadt\-Schneeren",
"4938853", "Drönnewitz\ bei\ Hagenow",
"494193", "Henstedt\-Ulzburg",
"492592", "Selm",
"4938737", "Ganzlin",
"492678", "Büchel\ bei\ Cochem",
"4934261", "Kühren\ bei\ Wurzen",
"499294", "Regnitzlosau",
"497250", "Kraichtal",
"4934208", "Löbnitz\ bei\ Delitzsch",
"492591", "Lüdinghausen",
"499777", "Ostheim\ von\ der\ Rhön",
"499472", "Hohenfels\ Oberpfalz",
"4935056", "Altenberg\ Sachsen",
"495841", "Lüchow\ Wendland",
"499143", "Pappenheim\ Mittelfranken",
"494947", "Aurich\-Ogenbargen",
"4935955", "Pulsnitz",
"4938848", "Vellahn",
"492672", "Treis\-Karden",
"492686", "Weyerbusch",
"496383", "Glan\-Münchweiler",
"494841", "Husum\ Nordsee",
"495947", "Laar\ Vechte",
"4939952", "Grammentin",
"492264", "Marienheide",
"492862", "Südlohn",
"496078", "Gross\-Umstadt",
"498208", "Eurasburg\ bei\ Augsburg",
"4936204", "Stotternheim",
"499561", "Coburg",
"497146", "Remseck\ am\ Neckar",
"495320", "Torfhaus",
"497554", "Heiligenberg\ Baden",
"498593", "Untergriesbach",
"497231", "Pforzheim",
"497935", "Schrozberg",
"4933657", "Steinsdorf\ Brandenburg",
"498202", "Althegnenberg",
"496086", "Grävenwiesbach",
"497483", "Horb\-Mühringen",
"494320", "Heidmühlen",
"4936608", "Seelingstädt\ bei\ Gera",
"4935728", "Uhyst\ Spree",
"494151", "Schwarzenbek",
"493731", "Freiberg\ Sachsen",
"494361", "Oldenburg\ in\ Holstein",
"492833", "Kerken",
"499853", "Wilburgstetten",
"495151", "Hameln",
"495054", "Bergen\-Sülze",
"495361", "Wolfsburg",
"496771", "St\ Goarshausen",
"4934604", "Niemberg",
"499828", "Rügland",
"497802", "Oberkirch\ Baden",
"497204", "Malsch\-Völkersbach",
"493366", "Beeskow",
"4936762", "Steinach\ Thüringen",
"494736", "Butjadingen\-Tossens",
"499175", "Spalt",
"498552", "Grafenau\ Niederbayern",
"495130", "Wedemark",
"498506", "Bad\ Höhenstadt",
"497808", "Hohberg\ bei\ Offenburg",
"495607", "Fuldatal",
"499822", "Bechhofen\ an\ der\ Heide",
"4938821", "Lüdersdorf",
"4934446", "Grosskorbetha",
"493544", "Luckau\ Brandenburg",
"496567", "Oberkail",
"498669", "Traunreut",
"4934673", "Heldrungen",
"4938457", "Krakow\ am\ See",
"492521", "Beckum",
"494607", "Janneby",
"498558", "Hohenau\ Niederbayern",
"4939774", "Mönkebude",
"497959", "Frankenhardt",
"499089", "Bissingen\-Unterringingen",
"4936966", "Kaltennordheim",
"497300", "Roggenburg",
"494561", "Neustadt\ in\ Holstein",
"495561", "Einbeck",
"497467", "Neuhausen\ ob\ Eck",
"4935695", "Simmersdorf",
"497762", "Wehr\ Baden",
"4934325", "Mochau\-Lüttewitz",
"498323", "Immenstadt\ im\ Allgäu",
"49341", "Leipzig",
"4934385", "Mutzschen",
"497389", "Heroldstatt",
"4939088", "Letzlingen",
"4936372", "Kleinneuhausen",
"493344", "Bad\ Freienwalde",
"494777", "Cadenberge",
"492104", "Mettmann",
"496400", "Mücke",
"495294", "Hövelhof\-Espeln",
"494472", "Lastrup",
"498168", "Attenkirchen",
"494486", "Edewecht\-Friedrichsfehn",
"495472", "Bad\ Essen",
"494892", "Schenefeld\ Mittelholstein",
"496157", "Pfungstadt",
"494294", "Riede\ Kreis\ Verden",
"495777", "Diepenau\-Essern",
"492548", "Dülmen\-Rorup",
"4938371", "Karlshagen",
"498026", "Hausham",
"499841", "Bad\ Windsheim",
"494478", "Cappeln\ Oldenburg",
"4939364", "Dolle",
"495143", "Winsen\ Aller",
"4935893", "Mücka",
"499947", "Neukirchen\ bei\ Hl\ Blut",
"4939247", "Güterglück",
"494143", "Drochtersen",
"498306", "Ronsberg",
"492542", "Gescher",
"496454", "Lichtenfels\-Sachsenberg",
"492150", "Meerbusch\-Lank",
"494175", "Egestorf\ Nordheide",
"499736", "Oberthulba",
"492360", "Haltern\-Lippramsdorf",
"495828", "Himbergen",
"497627", "Steinen\ Kreis\ Lörrach",
"493949", "Oschersleben\ Bode",
"498133", "Haimhausen\ Oberbayern",
"494828", "Lägerdorf",
"4934424", "Reuden\ bei\ Zeitz",
"495175", "Lehrte\-Arpke",
"492407", "Herzogenrath\-Kohlscheid",
"496755", "Odernheim\ am\ Glan",
"496583", "Palzem",
"495224", "Enger\ Westfalen",
"498764", "Mauern\ Kreis\ Freising",
"496634", "Gemünden\ Felda",
"495822", "Ebstorf",
"499607", "Luhe\-Wildenau",
"494822", "Kellinghusen",
"4933056", "Mühlenbeck\ Kreis\ Oberhavel",
"492391", "Plettenberg",
"498465", "Kipfenberg",
"494224", "Gross\ Ippener",
"4936428", "Stadtroda",
"495520", "Braunlage",
"498393", "Holzgünz",
"497164", "Boll\ Kreis\ Göppingen",
"497354", "Erolzheim",
"492246", "Lohmar\ Rheinland",
"496245", "Biblis",
"492131", "Neuss",
"494853", "Sankt\ Michaelisdonn",
"495853", "Neu\ Darchau",
"499151", "Hersbruck",
"497733", "Engen\ Hegau",
"4933741", "Niedergörsdorf",
"4934635", "Bad\ Lauchstädt",
"494883", "Süderstapel",
"496341", "Landau\ in\ der\ Pfalz",
"4937204", "Lichtenstein\ Sachsen",
"49911", "Nuremberg",
"495883", "Lemgow",
"499181", "Neumarkt\ in\ der\ Oberpfalz",
"499084", "Bissingen\ Schwaben",
"497954", "Kirchberg\ an\ der\ Jagst",
"499265", "Pressig",
"499961", "Mitterfels",
"497384", "Schelklingen\-Hütten",
"496522", "Mettendorf",
"4934223", "Dommitzsch",
"4939741", "Jatznick",
"4938854", "Redefin",
"498045", "Lenggries\-Fall",
"4935952", "Grossröhrsdorf\ OL",
"499867", "Geslau",
"497441", "Freudenstadt",
"492778", "Siegbach",
"4936736", "Arnsgereuth",
"4936333", "Heringen\ Helme",
"494547", "Gudow\ Lauenburg",
"499677", "Oberviechtach\-Pullenried",
"4939955", "Jürgenstorf",
"496296", "Ahorn\ Baden",
"4939056", "Klüden",
"492772", "Herborn\ Hessen",
"492295", "Ruppichteroth",
"492991", "Marsberg\-Bredelar",
"496484", "Beselich",
"4935843", "Hirschfelde\ bei\ Zittau",
"4939297", "Eickendorf\ Kreis\ Schönebeck",
"495105", "Barsinghausen",
"494105", "Seevetal",
"496553", "Schönecken",
"496785", "Herrstein",
"495636", "Lichtenfels\-Goddelsheim",
"4935774", "Boxberg\ Sachsen",
"498376", "Sulzberg\ Allgäu",
"496226", "Meckesheim",
"492225", "Meckenheim\ Rheinland",
"492921", "Soest",
"4939997", "Jarmen",
"492827", "Goch\-Hassum",
"493944", "Blankenburg\ Harz",
"496861", "Merzig",
"498382", "Lindau\ Bodensee",
"494636", "Langballig",
"494408", "Hude\ Oldenburg",
"493679", "Neuhaus\ am\ Rennweg",
"495402", "Bissendorf\ Kreis\ Osnabrück",
"499347", "Wittighausen",
"495456", "Westerkappeln\-Velpe",
"495707", "Petershagen\ Weser",
"4936623", "Berga\ Elster",
"496187", "Schöneck",
"4933436", "Prötzel",
"494707", "Langen\-Neuenwalde",
"492174", "Burscheid\ Rheinland",
"498537", "Bad\ Füssing\-Aigen",
"4933364", "Gross\ Ziethen\ Kreis\ Barnim",
"498388", "Hergensweiler",
"496639", "Ottrau",
"494402", "Rastede",
"494456", "Varel\-Altjührden",
"498073", "Gars\ am\ Inn",
"499070", "Tapfheim",
"493869", "Dümmer",
"4937327", "Rechenberg\-Bienenmühle",
"495035", "Gross\ Munzel",
"4938326", "Grimmen",
"496592", "Daun",
"4934923", "Cobbelsdorf",
"4938723", "Kladrum",
"496203", "Ladenburg",
"4937608", "Waldenburg\ Sachsen",
"493631", "Nordhausen\ Thüringen",
"4933088", "Falkenthal",
"4939728", "Medow\ bei\ Anklam",
"4938783", "Dallmin",
"499920", "Bischofsmais",
"493966", "Cölpin",
"4934322", "Rosswein",
"492942", "Geseke",
"497125", "Bad\ Urach",
"4935692", "Kerkwitz",
"4935247", "Zehren\ Sachsen",
"499547", "Zapfendorf",
"495677", "Calden\-Westuffeln",
"498337", "Altenstadt\ Iller",
"4935364", "Lebusa",
"4933703", "Sperenberg",
"496138", "Mommenheim",
"4935436", "Laasow\ bei\ Calau",
"493443", "Weissenfels\ Sachsen\-Anhalt",
"499105", "Grosshabersdorf",
"4934382", "Nerchau",
"492948", "Lippstadt\-Rebbeke",
"498582", "Röhrnbach",
"496132", "Ingelheim\ am\ Rhein",
"4939003", "Jübar",
"497274", "Germersheim",
"496398", "Vorderweidenthal",
"4938876", "Roggendorf",
"496701", "Sprendlingen\ Rheinhessen",
"494181", "Buchholz\ in\ der\ Nordheide",
"495084", "Hambühren",
"495181", "Alfeld\ Leine",
"497662", "Vogtsburg\ im\ Kaiserstuhl",
"497570", "Sigmaringen\-Gutenstein",
"492269", "Kierspe\-Rönsahl",
"4936375", "Kindelbrück",
"4938231", "Barth",
"49511", "Hannover",
"4935028", "Krippen",
"498809", "Wessobrunn",
"496392", "Hauenstein\ Pfalz",
"495961", "Haselünne",
"495265", "Dörentrup",
"498725", "Wurmannsquick",
"497668", "Ihringen",
"494961", "Papenburg",
"494265", "Fintel",
"498424", "Nassenfels",
"496322", "Bad\ Dürkheim",
"498272", "Wertingen",
"497584", "Altshausen",
"497453", "Altensteig\ Württemberg",
"496056", "Bad\ Soden\-Salmünster",
"496002", "Ober\-Mörlen",
"496328", "Elmstein",
"496541", "Traben\-Trarbach",
"494920", "Wirdum",
"497633", "Staufen\ im\ Breisgau",
"497335", "Wiesensteig",
"496008", "Echzell",
"4933843", "Niemegk",
"497727", "Vöhrenbach",
"499408", "Altenthann",
"499636", "Plössberg",
"497422", "Schramberg",
"496655", "Neuhof\ Kreis\ Fulda",
"492656", "Virneburg",
"492602", "Montabaur",
"496163", "Höchst\ im\ Odenwald",
"496353", "Freinsheim",
"497195", "Winnenden",
"4934632", "Mücheln\ Geiseltal",
"497428", "Rosenfeld",
"496734", "Flonheim",
"4935756", "Hosena",
"499402", "Regenstauf",
"495347", "Burgdorf\ bei\ Salzgitter",
"493475", "Lutherstadt\ Eisleben",
"498664", "Chieming",
"494347", "Flintbek",
"49234", "Bochum",
"493774", "Schwarzenberg",
"4934496", "Nöbdenitz",
"499229", "Mainleus",
"496435", "Wallmerod",
"492608", "Welschneudorf",
"492436", "Wegberg\-Rödgen",
"4936878", "Oberland",
"493836", "Wolgast",
"4934605", "Gröbers",
"493501", "Pirna",
"498151", "Starnberg",
"495850", "Neetze",
"498361", "Nesselwang",
"498054", "Breitbrunn\ am\ Chiemsee",
"496284", "Mudau",
"497136", "Bad\ Friedrichshall",
"496876", "Weiskirchen\ Saar",
"494499", "Barssel",
"496888", "Lebach\-Steinbach",
"497945", "Wüstenrot",
"4933976", "Wutike",
"494523", "Malente",
"4939087", "Jerchel\ Altmark",
"495523", "Bad\ Sachsa",
"499393", "Rothenfels\ Unterfranken",
"4939775", "Ahlbeck\ bei\ Torgelow",
"492066", "Duisburg\-Homberg",
"4939859", "Fürstenwerder",
"499465", "Neukirchen\-Balbini",
"4937433", "Gutenfürst",
"496509", "Büdlich",
"494558", "Todesfelde",
"499764", "Höchheim",
"4935772", "Rietschen",
"4939921", "Ankershagen",
"4933362", "Liepe\ Kreis\ Barnim",
"496580", "Zemmer",
"497751", "Waldshut",
"4969", "Frankfurt\ am\ Main",
"495552", "Katlenburg",
"495506", "Adelebsen",
"499133", "Baiersdorf\ Mittelfranken",
"495831", "Wittingen",
"494506", "Stockelsdorf\-Krumbeck",
"495937", "Geeste\-Gross\ Hesepe",
"494552", "Leezen",
"496666", "Freiensteinau",
"4939248", "Dobritz",
"492153", "Nettetal\-Lobberich",
"492363", "Datteln",
"495746", "Rödinghausen",
"499306", "Kist",
"499352", "Lohr\ am\ Main",
"494140", "Estorf\ Kreis\ Stade",
"499162", "Scheinfeld",
"498841", "Murnau\ am\ Staffelsee",
"493385", "Rathenow",
"493683", "Schmalkalden",
"4936205", "Gräfenroda",
"492332", "Gevelsberg",
"494746", "Hagen\ bei\ Bremerhaven",
"4939406", "Harbke",
"4934346", "Narsdorf",
"499358", "Gössenheim",
"499976", "Rötz",
"497326", "Neresheim",
"497052", "Bad\ Liebenzell",
"4936929", "Ruhla",
"492587", "Ennigerloh\-Westkirchen",
"492338", "Breckerfeld",
"4939221", "Möckern\ bei\ Magdeburg",
"496574", "Hasborn",
"496403", "Linden\ Hessen",
"4934743", "Ermsleben",
"4935033", "Rosenthal\ Sächsische\ Schweiz",
"495202", "Oerlinghausen",
"492192", "Hückeswagen",
"495804", "Rätzlingen\ Kreis\ Uelzen",
"4936427", "Dornburg\ Saale",
"4937202", "Claussnitz\ bei\ Chemnitz",
"494804", "Nordhastedt",
"498320", "Missen\-Wilhams",
"499323", "Iphofen",
"497973", "Obersontheim",
"495593", "Bovenden\-Lenglern",
"495429", "Melle\-Wellingholzhausen",
"499625", "Kastl\ bei\ Amberg",
"4933831", "Weseram",
"494256", "Hilgermissen",
"494202", "Achim\ bei\ Bremen",
"496426", "Fronhausen",
"4935263", "Gröditz\ bei\ Riesa",
"4935954", "Grossharthau",
"492843", "Rheinberg",
"495208", "Leopoldshöhe",
"492425", "Nideggen\-Embken",
"493741", "Plauen",
"497023", "Weilheim\ an\ der\ Teck",
"497303", "Illertissen",
"4938852", "Wittenburg",
"492724", "Finnentrop\-Serkenrode",
"494208", "Grasberg",
"4934207", "Zwochau",
"4938738", "Karow\ bei\ Lübz",
"494764", "Gnarrenburg\-Klenkendorf",
"495465", "Neuenkirchen\ bei\ Bramsche",
"493334", "Eberswalde",
"492387", "Drensteinfurt\-Walstedde",
"492538", "Drensteinfurt\-Rinkerode",
"495764", "Steyerberg",
"498224", "Offingen\ Donau",
"494465", "Friedeburg\ Ostfriesland",
"496374", "Weilerbach",
"498822", "Oberammergau",
"499831", "Gunzenhausen",
"4938847", "Boizenburg\ Elbe",
"499552", "Burghaslach",
"492957", "Wünnenberg\-Haaren",
"492532", "Ostbevern",
"492851", "Rees",
"493585", "Löbau",
"494133", "Wittorf\ Kreis\ Lüneburg",
"499937", "Oberpöring",
"497775", "Mühlingen",
"4934425", "Droyssig",
"497503", "Wilhelmsdorf\ Württemberg",
"497474", "Haigerloch",
"494393", "Boostedt",
"493722", "Limbach\-Oberfrohna",
"4939390", "Iden",
"495695", "Twistetal",
"499499", "Painten",
"499523", "Hofheim\ in\ Unterfranken",
"494323", "Bornhöved",
"499804", "Aurach",
"499256", "Stammbach",
"499202", "Waischenfeld",
"494625", "Jübek",
"493971", "Anklam",
"496837", "Wallerfangen",
"497228", "Forbach",
"499429", "Rain\ Niederbayern",
"496235", "Schifferstadt",
"493877", "Wittenberge",
"495625", "Naumburg\ Hessen",
"4936607", "Niederpöllnitz",
"495323", "Clausthal\-Zellerfeld",
"4935727", "Burghammer",
"492236", "Wesseling\ Rheinland",
"498561", "Pfarrkirchen\ Niederbayern",
"4939349", "Parey\ Elbe",
"497824", "Schwanau",
"497222", "Rastatt",
"499208", "Bindlach",
"493301", "Oranienburg",
"4939365", "Bellingen\ bei\ Stendal",
"4933963", "Wulfersdorf\ bei\ Wittstock",
"4933671", "Lieberose",
"497743", "Ühlingen\-Birkendorf",
"497681", "Waldkirch\ Breisgau",
"4939453", "Derenburg",
"495162", "Fallingbostel",
"495306", "Cremlingen",
"495352", "Schöningen",
"499746", "Zeitlofs",
"4935362", "Schönewalde\ bei\ Herzberg",
"49761", "Freiburg\ im\ Breisgau",
"4935694", "Gosda\ bei\ Klinge",
"492563", "Stadtlohn",
"4934324", "Ostrau\ Sachsen",
"494162", "Jork",
"494352", "Damp",
"498143", "Inning\ am\ Ammersee",
"495026", "Steimbke",
"495976", "Salzbergen",
"495168", "Walsrode\-Stellichte",
"496029", "Mömbris",
"495358", "Bahrdorf\-Mackendorf",
"4934907", "Jeber\-Bergfrieden",
"496644", "Grebenhain",
"497253", "Bad\ Schönborn",
"498294", "Horgau",
"4938458", "Zehna",
"494976", "Spiekeroog",
"4934384", "Grossbothen",
"494168", "Neu\ Wulmstorf\-Elstorf",
"494358", "Loose\ bei\ Eckernförde",
"4935248", "Schönfeld\ bei\ Grossenhain",
"494952", "Rhauderfehn",
"4936764", "Neuhaus\-Schierschnitz",
"497431", "Albstadt\-Ebingen",
"495769", "Steyerberg\-Voigtei",
"494769", "Bremervörde\-Iselersheim",
"499664", "Hahnbach",
"494537", "Sülfeld\ Holstein",
"495952", "Sögel",
"495906", "Lünne",
"498456", "Lenting",
"498402", "Münchsmünster",
"498707", "Adlkofen",
"496094", "Weibersbrunn",
"4934602", "Landsberg\ Sachsen\-Anhalt",
"492464", "Aldenhoven\ bei\ Jülich",
"4939772", "Rothemühl",
"497651", "Titisee\-Neustadt",
"494958", "Jemgum",
"495382", "Bad\ Gandersheim",
"494382", "Wangels",
"498636", "Ampfing",
"495376", "Wesendorf\ Kreis\ Gifhorn",
"496766", "Kisselbach",
"496331", "Pirmasens",
"4935775", "Pechern",
"495923", "Schüttorf",
"499127", "Rosstal\ Mittelfranken",
"494923", "Krummhörn\-Pewsum",
"493371", "Luckenwalde",
"499278", "Weidenberg",
"492694", "Wershofen",
"497545", "Immenstaad\ am\ Bodensee",
"499286", "Oberkotzau",
"4935027", "Weesenstein",
"495073", "Neustadt\-Esperke",
"499874", "Neuendettelsau",
"4938392", "Sassnitz",
"499272", "Fichtelberg",
"498035", "Raubling",
"493901", "Salzwedel",
"4933365", "Lüdersdorf\ Kreis\ Barnim",
"4938426", "Neuburg\-Steinhausen",
"495045", "Springe\-Bennigsen",
"4936202", "Neudietendorf",
"499424", "Strasskirchen",
"499725", "Poppenhausen\ Unterfranken",
"4939263", "Unseburg",
"4939954", "Stavenhagen\ Reuterstadt",
"4938201", "Gelbensande",
"493641", "Jena",
"4938486", "Gustävel",
"497573", "Stetten\ am\ kalten\ Markt",
"497404", "Epfendorf",
"499197", "Egloffstein",
"497705", "Wolterdingen\ Schwarzw",
"492624", "Höhr\-Grenzhausen",
"4939399", "Kleinau",
"4939033", "Wallstawe",
"495646", "Willebadessen",
"49281", "Wesel",
"494646", "Mohrkirch",
"499576", "Lichtenfels\-Isling",
"498105", "Gilching",
"4933733", "Stülpe",
"496304", "Wolfstein\ Pfalz",
"499337", "Gaukönigshofen",
"4938855", "Lübtheen",
"4934979", "Wulfen\ Sachsen\-Anhalt",
"498547", "Osterhofen\-Gergweis",
"492357", "Herscheid\ Westfalen",
"4933336", "Passow\ Kreis\ Uckermark",
"496024", "Schöllkrippen",
"499923", "Teisnach",
"4937341", "Ehrenfriedersdorf",
"49212", "Solingen",
"494127", "Westerhorn",
"497373", "Zwiefalten",
"497675", "Bernau\ Baden",
"493628", "Arnstadt",
"4939831", "Feldberg",
"495278", "Höxter\-Ovenhausen",
"495127", "Harsum",
"497903", "Mainhardt",
"495494", "Holdorf\ Niedersachsen",
"494795", "Garlstedt",
"494874", "Todenbüttel",
"493622", "Waltershausen\ Thüringen",
"495286", "Ottenstein\ Niedersachsen",
"494272", "Siedenburg",
"494286", "Gyhum",
"495272", "Brakel\ Westfalen",
"495874", "Soltendieck",
"499073", "Gundelfingen\ an\ der\ Donau",
"494494", "Bösel\ Oldenburg",
"494664", "Neukirchen\ bei\ Niebüll",
"496473", "Leun",
"496504", "Thalfang",
"492932", "Neheim\-Hüsten",
"4934422", "Osterfeld",
"492557", "Wettringen\ Kreis\ Steinfurt",
"496893", "Saarbrücken\-Ensheim",
"493433", "Borna\ Stadt",
"497082", "Neuenbürg\ Württemberg",
"498347", "Friesenried",
"4938293", "Kühlungsborn\ Ostseebad",
"499952", "Eichendorf",
"499906", "Mariaposching",
"495664", "Morschen",
"4936920", "Grossenlupnitz",
"4939298", "Barby\ Elbe",
"499382", "Gerolzhofen",
"492938", "Ense",
"4936846", "Suhl\-Dietzhausen",
"497267", "Gemmingen",
"496142", "Rüsselsheim",
"499376", "Collenberg",
"49771", "Donaueschingen",
"4939998", "Loitz\ bei\ Demmin",
"499646", "Freihung",
"495582", "Sankt\ Andreasberg",
"496550", "Irrhausen",
"4933921", "Zechlinerhütte",
"492183", "Rommerskirchen",
"4936374", "Weissensee",
"498677", "Burghausen\ Salzach",
"495337", "Kissenbrück",
"496744", "Oberwesel",
"4933981", "Putlitz",
"492963", "Brilon\-Messinghausen",
"492446", "Heimbach\ Eifel",
"493462", "Bad\ Dürrenberg",
"4939362", "Grieben\ bei\ Tangerhütte",
"4935453", "Drahnsdorf",
"496445", "Schöffengrund",
"494337", "Jevenstedt",
"4937328", "Grossschirma",
"498867", "Rottenbuch\ Oberbayern",
"495424", "Bad\ Rothenfelde",
"494725", "Helgoland",
"496858", "Ottweiler\-Fürth",
"4935365", "Falkenberg\ Elster",
"4937607", "Ebersbrunn\ Sachsen",
"495725", "Lindhorst\ bei\ Stadthagen",
"498265", "Pfaffenhausen\ Schwaben",
"4939727", "Spantekow",
"498084", "Taufkirchen\ Vils",
"4933087", "Bredereiche",
"496254", "Lautertal\ Odenwald",
"496531", "Bernkastel\-Kues",
"496852", "Nohfelden",
"496806", "Heusweiler",
"49811", "Hallbergmoos",
"493571", "Hoyerswerda",
"497345", "Langenau\ Württemberg",
"4939976", "Gross\ Bützin",
"497643", "Herbolzheim\ Breisgau",
"495197", "Soltau\-Frielingen",
"492207", "Kürten\-Dürscheid",
"496851", "St\ Wendel",
"496532", "Zeltingen\-Rachtig",
"492904", "Bestwig",
"499773", "Unsleben",
"493586", "Neugersdorf\ Sachsen",
"4935693", "Lauschütz",
"4934977", "Quellendorf",
"498176", "Egling\ bei\ Wolfratshausen",
"4933702", "Wünsdorf",
"499505", "Litzendorf",
"4939454", "Elbingerode\ Harz",
"492374", "Iserlohn\-Letmathe",
"496387", "Sankt\ Julian",
"493691", "Eisenach\ Thüringen",
"4934383", "Trebsen\ Mulde",
"495943", "Emlichheim",
"494466", "Wittmund\-Ardorf",
"494943", "Grossefehn",
"495466", "Merzen",
"499147", "Nennslingen",
"497525", "Aulendorf",
"493578", "Kamenz",
"4939002", "Oebisfelde",
"4939397", "Geestgottberg",
"497159", "Renningen",
"495696", "Bad\ Arolsen\-Landau",
"4933601", "Podelzig",
"493461", "Merseburg\ Saale",
"49551", "Göttingen",
"4935895", "Klitten",
"498249", "Ettringen\ Wertach",
"4933964", "Fretzdorf",
"49451", "Lübeck",
"49931", "Würzburg",
"4935206", "Kreischa\ bei\ Dresden",
"494239", "Dörverden\-Westen",
"497964", "Stödtlen",
"499381", "Volkach",
"496629", "Schenklengsfeld",
"496044", "Schotten\ Hessen",
"492235", "Erftstadt",
"492931", "Arnsberg",
"4962199", "Ludwigshafen",
"495626", "Bad\ Zwesten",
"499857", "Schopfloch\ Mittelfranken",
"496236", "Neuhofen\ Pfalz",
"497184", "Kaisersbach",
"497081", "Bad\ Wildbad",
"499951", "Landau\ an\ der\ Isar",
"494626", "Treia",
"499255", "Marktleugast",
"492837", "Weeze",
"494271", "Sulingen",
"494975", "Westerholt\ Ostfriesland",
"493621", "Gotha\ Thüringen",
"492309", "Waltrop",
"495271", "Höxter",
"492644", "Linz\ am\ Rhein",
"498784", "Hohenthann",
"495975", "Rheine\-Mesum",
"4934633", "Braunsbedra",
"496563", "Kyllburg",
"495025", "Estorf\ Weser",
"494305", "Westensee",
"4938226", "Dierhagen\ Ostseebad",
"499444", "Siegenburg",
"494603", "Havetoft",
"499745", "Wildflecken",
"495603", "Gudensberg",
"495305", "Sickte",
"492065", "Duisburg\-Rheinhausen",
"497463", "Mühlheim\ an\ der\ Donau",
"496066", "Michelstadt\-Vielbrunn",
"496122", "Hofheim\-Wallau",
"497946", "Bretzfeld",
"4939080", "Kalbe\ Milde",
"4933089", "Himmelpfort",
"496875", "Nonnweiler\-Primstal",
"4934222", "Arzberg\ bei\ Torgau",
"49951", "Bamberg",
"4933206", "Fichtenwalde",
"4937609", "Wolkenburg\ Mulde",
"497135", "Brackenheim",
"496128", "Taunusstein",
"495069", "Nordstemmen",
"4935953", "Burkau",
"498327", "Rettenberg",
"4935264", "Strehla",
"498735", "Gangkofen\-Kollbach",
"496665", "Sinntal\-Altengronau",
"496363", "Niederkirchen",
"492666", "Freilingen\ Westerwald",
"495773", "Stemwede\-Wehdem",
"494505", "Stockelsdorf\-Curau",
"495505", "Hardegsen",
"494773", "Lamstedt",
"4936332", "Ellrich",
"498434", "Rennertshofen",
"492509", "Nottuln\-Appelhülsen",
"49214", "Leverkusen",
"499943", "Lam\ Oberpfalz",
"4935842", "Oderwitz",
"497395", "Ehingen\-Dächingen",
"4938331", "Rakow\ Vorpom",
"498654", "Freilassing",
"4937754", "Zwönitz",
"495147", "Uetze\-Hänigsen",
"499466", "Stamsried",
"498137", "Petershausen",
"4937366", "Rübenau",
"492574", "Saerbeck",
"492403", "Eschweiler\ Rheinland",
"4937434", "Bobenneukirchen",
"496587", "Zerf",
"496338", "Hornbach\ Pfalz",
"497325", "Sontheim\ an\ der\ Brenz",
"499975", "Waldmünchen\-Geigant",
"493902", "Diesdorf\ Altm",
"499271", "Thurnau\-Alladorf",
"493378", "Ludwigsfelde",
"497623", "Rheinfelden\ Baden",
"495444", "Wagenfeld",
"494745", "Bad\ Bederkesa",
"496332", "Zweibrücken",
"493386", "Premnitz",
"4936076", "Niederorschel",
"499305", "Estenfeld",
"4936622", "Triebes",
"493372", "Jüterbog",
"499603", "Floss",
"495745", "Stemwede\-Levern",
"494444", "Goldenstedt",
"497652", "Hinterzarten",
"496724", "Stromberg\ Hunsrück",
"495381", "Seesen",
"49531", "Braunschweig",
"4934922", "Mühlanger",
"496843", "Gersheim",
"4938722", "Raduhn",
"496198", "Eppstein",
"492426", "Nörvenich",
"4936781", "Grossbreitenbach",
"49431", "Kiel",
"494381", "Lütjenburg",
"496425", "Rauschenberg\ Hessen",
"494255", "Martfeld",
"495857", "Bleckede\-Brackede",
"499626", "Hohenburg",
"494951", "Weener",
"497432", "Albstadt\-Tailfingen",
"497569", "Isny\-Eisenbach",
"496192", "Hofheim\ am\ Taunus",
"4938782", "Reetz\ bei\ Perleberg",
"4935601", "Peitz",
"494857", "Barlt",
"495255", "Altenbeken",
"495951", "Werlte",
"49491", "Leer\ Ostfriesland",
"4936021", "Schlotheim",
"494285", "Rhade\ bei\ Zeven",
"495190", "Soltau\-Emmingen",
"495285", "Bad\ Pyrmont\-Kleinenberg",
"49591", "Lingen\ \(Ems\)",
"494796", "Teufelsmoor",
"4934361", "Dahlen\ Sachsen",
"4939005", "Kusey",
"4936081", "Arenshausen",
"497682", "Elzach",
"498860", "Bernbeuren",
"495064", "Gross\ Düngen",
"495351", "Helmstedt",
"495161", "Walsrode",
"494351", "Eckernförde",
"494161", "Buxtehude",
"497676", "Feldberg\ Schwarzwald",
"4936373", "Buttstädt",
"497221", "Baden\-Baden",
"493302", "Hennigsdorf",
"499375", "Freudenberg\ Baden",
"494543", "Nusse",
"499673", "Tiefenbach\ Oberpfalz",
"498670", "Reischach\ Kreis\ Altötting",
"498562", "Triftern",
"4936927", "Unterellen",
"494330", "Emkendorf",
"495543", "Staufenberg\ Niedersachsen",
"499905", "Bernried\ Niederbayern",
"4935454", "Uckro",
"499201", "Gesees",
"496557", "Hallschlag",
"4935892", "Horka\ OL",
"492504", "Telgte",
"492473", "Simmerath",
"492823", "Goch",
"4938294", "Neubukow",
"496446", "Hohenahr",
"497043", "Maulbronn",
"493721", "Meinersdorf",
"492445", "Schleiden\ Eifel",
"498684", "Fridolfing",
"492744", "Herdorf",
"497260", "Sinsheim\-Hilsbach",
"496183", "Erlensee",
"494703", "Loxstedt\-Donnern",
"4933476", "Neuhardenberg",
"498533", "Rotthalmünster",
"499343", "Lauda\-Königshofen",
"498340", "Baisweil",
"499645", "Eschenbach\ in\ der\ Oberpfalz",
"495703", "Hille",
"4939857", "Drense",
"499234", "Neusorg",
"497346", "Illerkirchberg",
"496207", "Wald\-Michelbach",
"499551", "Burgwindheim",
"499832", "Wassertrüdingen",
"4933080", "Marienthal\ Kreis\ Oberhavel",
"4939089", "Bismark\ Altmark",
"492254", "Weilerswist",
"496805", "Kleinblittersdorf",
"492852", "Hamminkeln",
"4933845", "Borkheide",
"4939421", "Osterwieck",
"498266", "Kirchheim\ in\ Schwaben",
"495726", "Wiedensahl",
"494120", "Ellerhoop",
"497564", "Bad\ Wurzach",
"498821", "Garmisch\-Partenkirchen",
"4939481", "Hedersleben\ bei\ Aschersleben",
"4937600", "Neumark\ Sachsen",
"4939206", "Eichenbarleben",
"492858", "Hünxe",
"498333", "Babenhausen\ Schwaben",
"495673", "Immenhausen\ Hessen",
"496765", "Gemünden\ Hunsrück",
"493447", "Altenburg\ Thüringen",
"495375", "Müden\ Aller",
"4935476", "Wittmannsdorf\-Bückchen",
"498635", "Pleiskirchen",
"496464", "Angelburg",
"4934909", "Aken\ Elbe",
"4939034", "Fleetmark",
"499543", "Hirschaid",
"494673", "Joldelund",
"495201", "Halle\ Westfalen",
"495905", "Beesten",
"492191", "Remscheid",
"498754", "Volkenschwand",
"4933734", "Felgentreu",
"492379", "Menden\-Asbeck",
"4935020", "Struppen",
"498036", "Stephanskirchen\ Simssee",
"4939953", "Schwinkendorf",
"4939264", "Kroppenstedt",
"4936335", "Grosswechsungen",
"49991", "Deggendorf",
"498193", "Geltendorf",
"497364", "Oberkochen",
"497051", "Calw",
"497154", "Kornwestheim",
"499190", "Heroldsbach",
"4939347", "Kade",
"499285", "Kirchenlamitz",
"497546", "Oberteuringen",
"495863", "Zernien",
"499161", "Neustadt\ an\ der\ Aisch",
"499351", "Gemünden\ am\ Main",
"496694", "Neukirchen\ Knüll",
"492331", "Hagen\ Westfalen",
"494863", "Sankt\ Peter\-Ording",
"497457", "Rottenburg\-Ergenzingen",
"496049", "Kefenrod",
"495832", "Hankensbüttel",
"495551", "Northeim",
"4939601", "Friedland",
"495234", "Horn\-Bad\ Meinberg",
"497706", "Oberbaldingen",
"496624", "Heringen\ Werra",
"4933397", "Wandlitz",
"494234", "Dörverden",
"494832", "Meldorf",
"494551", "Bad\ Segeberg",
"495838", "Gross\ Oesingen",
"499726", "Euerbach",
"4936625", "Langenwetzendorf",
"4934771", "Querfurt",
"494838", "Tellingstedt",
"498123", "Moosinning",
"499120", "Leinburg",
"497844", "Rheinau",
"498368", "Halblech",
"498158", "Tutzing",
"4938725", "Gross\ Godems",
"4933454", "Wölsickendorf\/Wollenberg",
"496357", "Standenbühl",
"497242", "Rheinstetten",
"496167", "Modautal",
"497723", "Furtwangen\ im\ Schwarzwald",
"4934925", "Bad\ Schmiedeberg",
"492304", "Schwerte",
"498362", "Füssen",
"498152", "Herrsching\ am\ Ammersee",
"494343", "Laboe",
"498106", "Vaterstetten",
"49681", "Saarbrücken",
"497248", "Marxzell",
"496881", "Lebach",
"499575", "Weismain",
"4938785", "Berge\ bei\ Perleberg",
"492974", "Schmallenberg\-Fredeburg",
"495645", "Borgentreich\-Borgholz",
"4934672", "Rossleben",
"492638", "Waldbreitbach",
"4937464", "Schöneck\ Vogtland",
"492452", "Heinsberg\ Rheinland",
"492406", "Herzogenrath",
"4933929", "Gühlen\-Glienicke",
"4935053", "Glashütte\ Sachsen",
"496405", "Laubach\ Hessen",
"495184", "Freden\ Leine",
"494184", "Hanstedt\ Nordheide",
"499658", "Georgenberg",
"497626", "Kandern",
"496704", "Langenlonsheim",
"499569", "Sesslach",
"4935472", "Schlepzig",
"499737", "Wartmannsroth",
"4933205", "Michendorf",
"492632", "Andernach",
"498421", "Eichstätt\ Bayern",
"493685", "Hildburghausen",
"494964", "Rhede\ Ems",
"4933989", "Sadenbeck",
"499438", "Fensterbach",
"495964", "Lähden",
"499652", "Waidhaus",
"499606", "Pfreimd",
"497305", "Erbach\ Donau",
"492247", "Neunkirchen\-Seelscheid",
"492845", "Neukirchen\-Vluyn",
"492599", "Ascheberg\-Herbern",
"4935934", "Grossdubrau",
"497025", "Neuffen",
"4934294", "Rackwitz",
"492423", "Langerwehe",
"4935341", "Bad\ Liebenwerda",
"497271", "Wörth\ am\ Rhein",
"496032", "Bad\ Nauheim",
"495849", "Waddeweitz",
"497975", "Untergröningen",
"493928", "Schönebeck\ Elbe",
"499325", "Kleinlangheim",
"494849", "Hooge",
"493998", "Demmin",
"496063", "Bad\ König",
"499395", "Triefenstein",
"4937349", "Scheibenberg",
"495525", "Walkenried",
"4937365", "Sayda",
"4935607", "Jänschwalde",
"4933830", "Ziesar",
"497466", "Beuron",
"497943", "Schöntal\ Jagst",
"494525", "Ahrensbök",
"4936075", "Dingelstädt\ Eichsfeld",
"492873", "Isselburg\-Werth",
"4938794", "Cumlosen",
"493771", "Aue\ Sachsen",
"498661", "Grabenstätt\ Chiemsee",
"496731", "Alzey",
"492529", "Oelde\-Stromberg",
"4933878", "Nennhausen",
"4935388", "Klöden",
"496102", "Neu\-Isenburg",
"4936694", "Schkölen\ Thüringen",
"495776", "Preussisch\ Ströhen",
"492663", "Westerburg\ Westerwald",
"494487", "Grossenkneten\-Huntlosen",
"492365", "Marl",
"497581", "Saulgau",
"494776", "Osten\-Altendorf",
"499135", "Hessdorf\ Mittelfranken",
"49751", "Ravensburg",
"494159", "Basthorst",
"496108", "Mühlheim\ am\ Main",
"499946", "Hohenwarth\ bei\ Kötzing",
"499463", "Wald\ Oberpfalz",
"498460", "Berching\-Holnstein",
"498027", "Dietramszell",
"496544", "Rhaunen",
"4938308", "Göhren\ Rügen",
"4934443", "Teuchern",
"495159", "Coppenbrügge\-Bisperode",
"497745", "Jestetten",
"4936254", "Friedrichswerth",
"4936963", "Dorndorf\ Rhön",
"493601", "Mühlhausen\ Thüringen",
"4933234", "Wustermark",
"497444", "Alpirsbach",
"4938209", "Sanitz\ bei\ Rostock",
"4933607", "Briesen\ Mark",
"495623", "Edertal",
"496233", "Frankenthal\ Pfalz",
"497930", "Boxberg\ Baden",
"495325", "Goslar\-Hahnenklee",
"4934785", "Sandersleben",
"492994", "Marsberg\-Westheim",
"49641", "Giessen",
"4939391", "Lückstedt",
"494623", "Böklund",
"497255", "Graben\-Neudorf",
"497951", "Crailsheim",
"499081", "Nördlingen",
"498507", "Neuburg\ am\ Inn",
"494432", "Dötlingen\-Brettorf",
"499184", "Deining\ Oberpfalz",
"494737", "Stadland\-Schwei",
"496344", "Schwegenheim",
"495658", "Wehretal",
"4939884", "Hassleben\ bei\ Prenzlau",
"495432", "Löningen",
"492565", "Gronau\-Epe",
"494606", "Wanderup",
"496566", "Körperich",
"498145", "Mammendorf",
"49731", "Ulm\ Donau",
"497381", "Münsingen",
"495652", "Bad\ Sooden\-Allendorf",
"499964", "Stallwang",
"4939824", "Hohenzieritz",
"495606", "Zierenberg",
"495438", "Bakum\-Lüsche",
"4939753", "Strasburg",
"493583", "Zittau",
"4934654", "Stolberg\ Harz",
"494135", "Kirchgellersen",
"4935205", "Ottendorf\-Okrilla",
"499776", "Mellrichstadt",
"495135", "Burgwedel\-Fuhrberg",
"499170", "Schwanstetten",
"4933053", "Zehlendorf\ Kreis\ Oberhavel",
"498442", "Wolnzach",
"494463", "Wangerland",
"495946", "Georgsdorf",
"492687", "Horhausen\ Westerwald",
"496674", "Friedewald\ Hessen",
"499369", "Uettingen",
"493634", "Sömmerda",
"4933472", "Golzow\ bei\ Seelow",
"494946", "Grossefehn\-Bagband",
"4938758", "Dömitz",
"497147", "Sachsenheim\ Württemberg",
"496262", "Aglasterhausen",
"495693", "Volkmarsen",
"496864", "Mettlach",
"499525", "Königsberg\ in\ Bayern",
"493941", "Halberstadt",
"492924", "Möhnesee",
"493847", "Sternberg",
"4933638", "Rüdersdorf\ bei\ Berlin",
"496268", "Hüffenhardt",
"4938225", "Trinwillershagen",
"492171", "Leverkusen\-Opladen",
"498257", "Inchenhofen",
"4939202", "Gross\ Ammensleben",
"497505", "Fronreute",
"496087", "Waldems",
"497773", "Bodman\-Ludwigshafen",
"492324", "Hattingen\ Ruhr",
"497449", "Baiersbronn\-Obertal",
"4935475", "Straupitz",
"496057", "Flörsbachtal",
"497703", "Bonndorf\ im\ Schwarzwald",
"497575", "Messkirch",
"493528", "Radeberg",
"493341", "Strausberg",
"499723", "Röthlein",
"4939341", "Redekin",
"498062", "Bruckmühl\ Mangfall",
"4939934", "Gross\ Plasten",
"499844", "Obernzenn",
"4933679", "Wendisch\ Rietz",
"495043", "Lauenau",
"493522", "Grossenhain\ Sachsen",
"4933202", "Töplitz",
"499242", "Gössweinstein",
"494260", "Visselhövede\-Wittorf",
"49465", "Sylt",
"492657", "Uersfeld",
"4936336", "Klettenberg",
"4937298", "Oelsnitz\ Erzgebirge",
"496349", "Billigheim\-Ingenheim",
"492738", "Netphen",
"4936464", "Wormstedt",
"495564", "Dassel",
"499637", "Falkenberg\ Oberpfalz",
"494564", "Schashagen",
"499189", "Berg\ bei\ Neumarkt\ in\ der\ Oberpfalz",
"497726", "Bad\ Dürrheim",
"4936733", "Kaulsdorf",
"492732", "Kreuztal",
"494346", "Gettorf",
"4939053", "Süplingen",
"495346", "Liebenburg",
"493861", "Plate",
"492763", "Drolshagen\-Bleche",
"495676", "Liebenau\ Hessen",
"494682", "Amrum",
"498336", "Erkheim",
"497351", "Biberach\ an\ der\ Riss",
"497161", "Göppingen",
"4937362", "Seiffen\ Erzgebirge",
"499546", "Burgebrach",
"495682", "Borken\ Hessen",
"493967", "Oertzenhof\ bei\ Strasburg",
"496650", "Hosenfeld",
"4936626", "Auma",
"49791", "Schwäbisch\ Hall",
"4933433", "Buckow\ Märkische\ Schweiz",
"4936453", "Mellingen",
"499154", "Pommelsbrunn",
"499364", "Zellingen",
"4933764", "Mittenwalde\ Mark",
"496430", "Hahnstätten",
"4936072", "Weissenborn\-Lüderode",
"4939388", "Goldbeck\ Altm",
"4938726", "Spornitz",
"498033", "Oberaudorf",
"498196", "Pürgen",
"496869", "Merzig\-Silwingen",
"4934926", "Pretzsch\ Elbe",
"493592", "Kirschau",
"4938323", "Prohn",
"496451", "Frankenberg\ Eder",
"494221", "Delmenhorst",
"493671", "Saalfeld\ Saale",
"494925", "Hinte",
"4939328", "Rochau",
"492394", "Neuenrade\-Affeln",
"497543", "Kressbronn\ am\ Bodensee",
"4939607", "Kotelow",
"496631", "Alsfeld",
"495221", "Herford",
"498761", "Moosburg\ an\ der\ Isar",
"495925", "Wietmarschen",
"496825", "Illingen\ Saar",
"497046", "Zaberfeld",
"494637", "Sterup",
"499564", "Bad\ Rodach",
"494758", "Nordleda",
"496709", "Fürfeld\ Kreis\ Bad\ Kreuznach",
"492826", "Kranenburg\ Niederrhein",
"4934722", "Preusslitz",
"4935433", "Vetschau",
"496443", "Ehringshausen\ Dill",
"494189", "Undeloh",
"492261", "Gummersbach",
"498377", "Unterthingau",
"497838", "Nordrach",
"496227", "Walldorf\ Baden",
"498536", "Kösslarn",
"498801", "Seeshaupt",
"496186", "Grosskrotzenburg",
"494706", "Schiffdorf",
"4939006", "Miesterhorst",
"494752", "Neuhaus\ Oste",
"4934782", "Mansfeld\ Südharz",
"495706", "Porta\ Westfalica",
"495752", "Auetal\-Hattendorf",
"496172", "Bad\ Homburg\ von\ der\ Höhe",
"497234", "Tiefenbronn",
"4936921", "Wutha\-Farnroda",
"497832", "Haslach\ im\ Kinzigtal",
"497551", "Überlingen\ Bodensee",
"499346", "Grünsfeld",
"495457", "Hopsten\-Schale",
"497343", "Buch\ bei\ Illertissen",
"4934244", "Mockrehna",
"494248", "Bassum\-Neubruchhausen",
"497645", "Freiamt",
"492594", "Dülmen",
"4938873", "Carlow",
"495248", "Langenberg\ Kreis\ Gütersloh",
"492803", "Wesel\-Büderich",
"4933839", "Wusterwitz",
"4936087", "Wüstheuterode",
"494844", "Pellworm",
"494242", "Syke",
"499260", "Wilhelmsthal\ Oberfranken",
"498263", "Breitenbrunn\ Schwaben",
"495723", "Bad\ Nenndorf",
"495242", "Rheda\-Wiedenbrück",
"494723", "Cuxhaven\-Altenwalde",
"4936027", "Lengenfeld\ Unterm\ Stein",
"495844", "Clenze",
"4939487", "Friedrichsbrunn",
"498232", "Schwabmünchen",
"499075", "Glött",
"493322", "Falkensee",
"4935202", "Klingenberg\ Sachsen",
"494793", "Hambergen",
"497905", "Langenburg",
"4939427", "Ströbeck",
"492524", "Ennigerloh",
"4933475", "Letschin",
"498238", "Gessertshausen",
"497375", "Obermarchtal",
"493541", "Calau",
"499925", "Bayerisch\ Eisenstein",
"499221", "Kulmbach",
"493328", "Teltow",
"4939851", "Göritz\ bei\ Prenzlau",
"497673", "Schönau\ im\ Schwarzwald",
"499676", "Winklarn",
"494546", "Mustin\ Lauenburg",
"4933846", "Dippmannsdorf",
"4939929", "Jabel\ bei\ Waren",
"4933920", "Walsleben\ bei\ Neuruppin",
"499682", "Erbendorf",
"4936644", "Hirschberg\ Saale",
"495546", "Scheden",
"496774", "Kaub",
"495364", "Velpke",
"495051", "Bergen\ Kreis\ Celle",
"493435", "Oschatz",
"4934493", "Gössnitz\ Thüringen",
"495154", "Aerzen",
"492482", "Hellenthal",
"4938222", "Semlow",
"4936948", "Römhild",
"4939205", "Langenweddingen",
"496297", "Ravenstein\ Baden",
"494364", "Dahme\ Kreis\ Ostholstein",
"494154", "Trittau",
"4935753", "Grossräschen",
"496475", "Weilmünster\-Wolfenhausen",
"498250", "Hilgertshausen\-Tandern",
"499253", "Weissenstadt",
"49241", "Aachen",
"494326", "Wankendorf",
"495052", "Hermannsburg",
"492233", "Hürth\ Rheinland",
"495326", "Langelsheim",
"4933933", "Lindow\ Mark",
"496329", "Weidenthal\ Pfalz",
"4934779", "Abberode",
"499681", "Windischeschenbach",
"49961", "Weiden\ in\ der\ Oberpfalz",
"497746", "Wutöschingen",
"492680", "Mündersbach",
"495605", "Kaufungen\ Hessen",
"499409", "Pielenhofen",
"495303", "Wendeburg",
"495023", "Liebenau\ Kreis\ Nieburg\ Weser",
"498146", "Moorenweis",
"494303", "Schlesen",
"499824", "Dietenhofen",
"4934653", "Rottleberode",
"496565", "Dudeldorf",
"499222", "Presseck",
"4938841", "Neuhaus\ Elbe",
"4939754", "Löcknitz\ Vorpom",
"4934426", "Kayna",
"493542", "Lübbenau\ Spreewald",
"492566", "Legden",
"494605", "Medelby",
"498231", "Königsbrunn\ bei\ Augsburg",
"497429", "Egesheim",
"498554", "Schönberg\ Niederbayern",
"495973", "Neuenkirchen\ Kreis\ Steinfurt",
"497804", "Oppenau",
"499177", "Heideck",
"499480", "Sünching",
"494973", "Wittmund\-Burhafe",
"499228", "Thurnau",
"493321", "Nauen\ Brandenburg",
"4933054", "Liebenwalde",
"4936842", "Oberhof\ Thüringen",
"497202", "Karlsbad",
"497256", "Philippsburg",
"4935975", "Hohnstein",
"4939883", "Gross\ Dölln",
"494945", "Grossefehn\-Timmel",
"494241", "Bassum",
"496139", "Budenheim",
"492674", "Bad\ Bertrich",
"495945", "Wilsum",
"495241", "Gütersloh",
"493391", "Neuruppin",
"4938828", "Schönberg",
"4934901", "Rosslau\ Elbe",
"4939366", "Kehnert",
"4936702", "Lauscha",
"4939823", "Rechlin",
"499503", "Oberhaid\ Oberfranken",
"499474", "Schmidmühlen",
"495136", "Burgdorf\ Kreis\ Hannover",
"499775", "Schönau\ an\ der\ Brend",
"494136", "Scharnebeck",
"499292", "Konradsreuth",
"4933233", "Ketzin",
"494751", "Otterndorf",
"498204", "Mickhausen",
"498856", "Penzberg",
"4933677", "Glienicke\ bei\ Beeskow",
"498802", "Huglfing",
"497937", "Dörzbach",
"4936964", "Dermbach\ Rhön",
"4936253", "Georgenthal\ Thüringer\ Wald",
"497552", "Pfullendorf",
"497506", "Wangen\-Leupolz",
"497831", "Hausach",
"492268", "Kürten",
"495751", "Rinteln",
"496074", "Rödermark",
"496171", "Oberursel\ Taunus",
"4936601", "Hermsdorf\ Thüringen",
"4939972", "Walkendorf",
"498808", "Pähl",
"492262", "Wiehl",
"499526", "Riedbach",
"497558", "Illmensee",
"497669", "St\ Märgen",
"492864", "Reken",
"494824", "Krempe",
"499303", "Eibelstadt",
"493672", "Rudolstadt",
"499605", "Weiherhammer",
"495743", "Espelkamp\-Gestringen",
"4934606", "Teicha\ Sachsen\-Anhalt",
"494222", "Ganderkesee",
"495409", "Hilter\ am\ Teutoburger\ Wald",
"494409", "Westerstede\-Ocholt",
"496458", "Rosenthal\ Hessen",
"4938378", "Heringsdorf\ Seebad",
"494743", "Langen\ bei\ Bremerhaven",
"498762", "Wartenberg\ Oberbayern",
"493686", "Eisfeld",
"495222", "Bad\ Salzuflen",
"498467", "Kinding",
"498020", "Weyarn",
"4936693", "Crossen\ an\ der\ Elster",
"495824", "Bad\ Bodenteich",
"499973", "Furth\ im\ Wald",
"494177", "Drage\ Elbe",
"4934444", "Lützen",
"494480", "Ovelgönne\-Strückhausen",
"4939927", "Nossentiner\ Hütte",
"497323", "Gerstetten",
"4933975", "Dannenwalde\ Kreis\ Prignitz",
"497625", "Zell\ im\ Wiesental",
"4939776", "Hintersee",
"495228", "Vlotho\-Exter",
"496406", "Lollar",
"496452", "Battenberg\ Eder",
"498389", "Weissensberg",
"496638", "Schwalmtal\-Renzendorf",
"493591", "Bautzen",
"496757", "Becherbach\ bei\ Kirn",
"492405", "Würselen",
"495177", "Edemissen\-Abbensen",
"495253", "Bad\ Driburg",
"493868", "Rastow",
"4939081", "Kakerbeck\ Sachsen\-Anhalt",
"494253", "Asendorf\ Kreis\ Diepholz",
"499326", "Markt\ Einersheim",
"497976", "Sulzbach\-Laufen",
"497358", "Eberhardzell\-Füramoos",
"494681", "Wyk\ auf\ Föhr",
"496599", "Weidenbach\ bei\ Gerolstein",
"497026", "Lenningen",
"496423", "Wetter\ Hessen",
"49461", "Flensburg",
"49561", "Kassel",
"497162", "Süssen",
"497352", "Ochsenhausen",
"497306", "Vöhringen\ Iller",
"496247", "Worms\-Pfeddersheim",
"495681", "Homberg\ Efze",
"4939489", "Strassberg\ Harz",
"4938793", "Dergenthin",
"4934293", "Naunhof\ bei\ Grimma",
"4936029", "Menteroda",
"4933748", "Treuenbrietzen",
"4935933", "Neschwitz",
"4939405", "Hötensleben",
"4936206", "Grossfahner",
"4936481", "Neustadt\ an\ der\ Orla",
"4938422", "Neukloster",
"496873", "Nonnweiler",
"497133", "Lauffen\ am\ Neckar",
"4935600", "Döbern\ NL",
"494526", "Ascheberg\ Holstein",
"4933837", "Brielow",
"4934345", "Bad\ Lausick",
"497764", "Herrischried",
"497465", "Emmingen\-Liptingen",
"4936421", "Camburg",
"4938482", "Warin",
"499396", "Urspringen\ bei\ Lohr",
"4938351", "Mesekenhagen",
"497393", "Munderkingen",
"498061", "Bad\ Aibling",
"492779", "Greifenstein\-Beilstein",
"494298", "Lilienthal",
"499241", "Pegnitz",
"4935054", "Lauenstein\ Sachsen",
"499945", "Arnbruck",
"493521", "Meissen",
"4937463", "Bergen\ Vogtland",
"494775", "Grossenwörden",
"495503", "Nörten\-Hardenberg",
"495474", "Stemwede\-Dielingen",
"492750", "Diedenshausen",
"4933332", "Gartz\ Oder",
"494292", "Ritterhude",
"496663", "Steinau\ an\ der\ Strasse",
"495292", "Lichtenau\-Atteln",
"492366", "Herten\ Westfalen",
"493342", "Neuenhagen\ bei\ Berlin",
"498733", "Mengkofen",
"492102", "Ratingen",
"492156", "Willich\-Anrath",
"495775", "Diepenau",
"494474", "Garrel",
"494503", "Timmendorfer\ Strand",
"499093", "Polsingen",
"496155", "Griesheim\ Hessen",
"499345", "Külsheim\ Baden",
"495829", "Wriedel",
"4936643", "Thimmendorf",
"498640", "Reit\ Im\ Winkl",
"495705", "Petershagen\-Windheim",
"499643", "Auerbach\ in\ der\ Oberpfalz",
"494404", "Elsfleth",
"495404", "Westerkappeln",
"495573", "Uslar\-Volpriehausen",
"494705", "Wremen",
"496185", "Hammersbach\ Hessen",
"494829", "Wewelsfleth",
"498535", "Haarbach",
"4935754", "Klettwitz",
"498384", "Röthenbach\ Allgäu",
"492227", "Bornheim\-Merten",
"496261", "Mosbach\ Baden",
"492825", "Uedem",
"492443", "Mechernich",
"4934494", "Ehrenhain",
"496826", "Bexbach",
"497045", "Oberderdingen",
"498441", "Pfaffenhofen\ an\ der\ Ilm",
"4936020", "Ebeleben",
"4939748", "Viereck",
"496803", "Mandelbachtal\-Ommersheim",
"4936845", "Gehlberg",
"495037", "Bad\ Rehburg",
"497646", "Weisweil\ Breisgau",
"49971", "Bad\ Kissingen",
"4935609", "Drachhausen",
"49203", "Duisburg",
"4937347", "Bärenstein\ Kreis\ Annaberg",
"496594", "Birresborn",
"4939861", "Gramzow\ bei\ Prenzlau",
"499267", "Nordhalben",
"4938874", "Lützow",
"499926", "Frauenau",
"499088", "Mönchsdeggingen",
"497958", "Rot\ Am\ See\-Brettheim",
"497376", "Langenenslingen",
"497382", "Römerstein",
"495651", "Eschwege",
"4939721", "Liepen\ bei\ Anklam",
"499865", "Adelshofen\ Mittelfranken",
"4934243", "Bad\ Düben",
"496524", "Rodershausen",
"495283", "Lügde\-Rischenau",
"497952", "Gerabronn",
"497906", "Braunsbach",
"494431", "Wildeshausen",
"499082", "Oettingen\ in\ Bayern",
"4937601", "Mülsen\ Skt\ Jacob",
"495431", "Quakenbrück",
"499076", "Wittislingen",
"497388", "Pfronstetten",
"494283", "Tarmstedt",
"4936705", "Oberweissbach\ Thüringer\ Wald",
"496476", "Mengerskirchen",
"497073", "Ammerbuch",
"492297", "Wildbergerhütte",
"496787", "Niederbrombach",
"492774", "Dietzhölztal",
"499903", "Schöllnach",
"4935434", "Altdöbern",
"494107", "Siek\ Kreis\ Stormarn",
"4935823", "Ostritz",
"496482", "Runkel",
"495545", "Hedemünden",
"494479", "Molbergen\-Peheim",
"494630", "Barderup",
"498370", "Wiggensbach",
"499373", "Amorbach",
"496220", "Wilhelmsfeld",
"4933927", "Linum",
"4939975", "Thürkow",
"494545", "Seedorf\ Lauenburg",
"499675", "Altendorf\ am\ Nabburg",
"4938324", "Velgast",
"4935021", "Königstein\ Sächsische\ Schweiz",
"497337", "Nellingen\ Alb",
"49471", "Bremerhaven",
"497576", "Krauchenwies",
"496004", "Lich\-Eberstadt",
"496101", "Bad\ Vilbel",
"498274", "Buttenwiesen",
"496324", "Hassloch",
"4933972", "Breddin",
"497582", "Bad\ Buchau",
"49571", "Minden\ Westfalen",
"495643", "Borgentreich",
"493772", "Schneeberg\ Erzgebirge",
"495345", "Baddeckenstedt",
"499829", "Flachslanden",
"493991", "Waren\ Müritz",
"499573", "Staffelstein\ Oberfranken",
"494643", "Gelting\ Angeln",
"499404", "Nittendorf",
"498662", "Siegsdorf\ Kreis\ Traunstein",
"496732", "Wörrstadt",
"497725", "Königsfeld\ im\ Schwarzwald",
"4933763", "Bestensee",
"492604", "Nassau\ Lahn",
"4933366", "Chorin",
"4936454", "Magdala",
"496657", "Hofbieber",
"497424", "Spaichingen",
"4933434", "Herzfelde\ bei\ Strausberg",
"4936734", "Leutenberg",
"499107", "Trautskirchen",
"494903", "Wymeer",
"498584", "Breitenberg\ Niederbayern",
"496134", "Mainz\-Kastel",
"496031", "Friedberg\ Hessen",
"497272", "Rülzheim",
"4939402", "Völpke",
"4938425", "Kirchdorf\ Poel",
"4936463", "Gebstedt",
"498453", "Reichertshofen\ Oberbayern",
"495903", "Emsbüren",
"497127", "Neckartenzlingen",
"4939054", "Flechtingen",
"4938485", "Dabel",
"499545", "Buttenheim",
"493921", "Burg\ bei\ Magdeburg",
"498335", "Fellheim",
"495675", "Trendelburg",
"492944", "Rietberg\-Mastholte",
"4934342", "Neukieritzsch",
"495373", "Hillerse\ Kreis\ Gifhorn",
"498633", "Tüssling",
"496763", "Kirchberg\ Hunsrück",
"495926", "Engden",
"498422", "Dollnstein",
"494865", "Osterhever",
"498727", "Falkenberg\ Niederbayern",
"492631", "Neuwied",
"496394", "Bundenthal",
"495865", "Gusborn",
"494267", "Lauenbrück",
"499651", "Vohenstrauss",
"4939600", "Zwiedorf",
"4937206", "Frankenberg\ Sachsen",
"494926", "Krummhörn\-Greetsiel",
"4933609", "Brieskow\-Finkenheerd",
"4938207", "Stäbelow",
"497664", "Freiburg\-Tiengen",
"495082", "Langlingen",
"4938856", "Pritzier\ bei\ Hagenow",
"492451", "Geilenkirchen",
"499283", "Rehau",
"498195", "Weil\ Kreis\ Landsberg\ am\ Lech",
"496050", "Biebergemünd",
"4933335", "Pinnow\ Kreis\ Uckermark",
"4939933", "Vollrathsruhe",
"4937421", "Oelsnitz\ Vogtland",
"499431", "Schwandorf",
"4933086", "Grieben\ Kreis\ Oberhavel",
"4939726", "Ducherow",
"496457", "Burgwald\ Eder",
"497624", "Grenzach\-Wyhlen",
"496752", "Kirn\ Nahe",
"496706", "Wallhausen\ Nahe",
"494186", "Buchholz\-Trelde",
"498468", "Altmannstein\-Pondorf",
"4938234", "Born\ Darss",
"495172", "Ilsede",
"495186", "Salzhemmendorf\-Wallensen",
"494172", "Salzhausen",
"4939977", "Jördenstorf",
"4939323", "Schönhausen\ Elbe",
"4933925", "Wustrau\-Altfriesack",
"492573", "Nordwalde",
"492404", "Alsdorf\ Rheinland",
"496637", "Feldatal",
"4938328", "Miltzow",
"494825", "Burg\ Dithmarschen",
"498462", "Berching",
"499604", "Wernberg\-Köblitz",
"495966", "Meppen\-Apeldorn",
"494443", "Dinklage",
"496758", "Waldböckelheim",
"495443", "Lemförde",
"494966", "Neubörger",
"4939200", "Gommern",
"494178", "Radbruch",
"4933209", "Caputh",
"4937606", "Lengenfeld\ Vogtland",
"4933672", "Pfaffendorfb\ Beeskow",
"493677", "Ilmenau\ Thüringen",
"495825", "Wieren",
"4939383", "Sandau\ Elbe",
"499349", "Werbach\-Wenkheim",
"493961", "Altentreptow",
"4935361", "Schlieben",
"496844", "Blieskastel\-Altheim",
"497357", "Attenweiler",
"496242", "Osthofen",
"496723", "Oestrich\-Winkel",
"4936458", "Bad\ Berka",
"4933438", "Altlandsberg",
"493867", "Lübstorf",
"49781", "Offenburg",
"4933470", "Lietzen",
"498571", "Simbach\ am\ Inn",
"499631", "Tirschenreuth",
"4936847", "Steinbach\-Hallenberg",
"497765", "Rickenbach\ Hotzenwald",
"4939058", "Uthmöden",
"497464", "Talheim\ Kreis\ Tuttlingen",
"498628", "Kienberg\ Oberbayern",
"492651", "Mayen",
"4937369", "Wolkenstein",
"4936738", "Königsee",
"499869", "Wettringen\ Mittelfranken",
"499451", "Schierling",
"498622", "Tacherting\-Peterskirchen",
"492431", "Erkelenz",
"4937293", "Eppendorf\ Sachsen",
"494774", "Hechthausen",
"495475", "Bohmte\-Hunteburg",
"498433", "Königsmoos",
"49821", "Augsburg",
"494475", "Molbergen",
"495774", "Wagenfeld\-Ströhen",
"498281", "Thannhausen\ Schwaben",
"496154", "Ober\-Ramstadt",
"496051", "Gelnhausen",
"496364", "Nussbach\ Pfalz",
"494297", "Ottersberg\-Posthausen",
"498165", "Neufahrn\ bei\ Freising",
"4934463", "Bad\ Kösen",
"492545", "Rosendahl\-Darfeld",
"499944", "Miltach",
"492630", "Mülheim\-Kärlich",
"497446", "Lossburg",
"4936943", "Bettenhausen\ Thüringen",
"496043", "Nidda",
"4933337", "Altkünkendorf",
"4934498", "Rositz",
"497963", "Adelmannsfelden",
"496291", "Adelsheim",
"497183", "Rudersberg\ Württemberg",
"49271", "Siegen",
"4939222", "Möser",
"493883", "Hagenow",
"4938205", "Tessin\ bei\ Rostock",
"498641", "Grassau\ Kreis\ Traunstein",
"499172", "Georgensgmünd",
"498783", "Rohr\ in\ Niederbayern",
"492643", "Altenahr",
"498555", "Perlesreut",
"496346", "Annweiler\ am\ Trifels",
"497805", "Appenweier",
"4933832", "Rogäsen",
"499186", "Lauterhofen\ Oberpfalz",
"497729", "Tennenbronn",
"499966", "Wiesenfelden",
"499178", "Abenberg\ Mittelfranken",
"495604", "Grossalmerode",
"4938427", "Blowatz",
"494349", "Dänischenhagen",
"499227", "Neuenmarkt",
"499825", "Herrieden",
"496564", "Neuerburg\ Eifel",
"494604", "Grossenwiehe",
"499443", "Abensberg",
"4939744", "Rothenklempenow",
"4938851", "Zarrentin",
"4935026", "Dürrröhrsdorf\-Dittersbach",
"492903", "Meschede\-Freienohl",
"499774", "Oberelsbach",
"499549", "Lisberg",
"4935209", "Mohorn",
"494944", "Wiesmoor",
"495650", "Cornberg",
"493636", "Greussen",
"496682", "Tann\ Rhön",
"496676", "Hohenroda\ Hessen",
"4962196", "Ludwigshafen",
"492373", "Menden\ Sauerland",
"492675", "Ediger\-Eller",
"495944", "Hoogstede",
"492267", "Wipperfürth",
"495631", "Korbach",
"496221", "Heidelberg",
"4935771", "Bad\ Muskau",
"4939922", "Dambeck\ bei\ Röbel",
"496866", "Perl\-Nennig",
"497938", "Mulfingen\ Jagst",
"492865", "Raesfeld",
"494631", "Glücksburg\ Ostsee",
"497557", "Herdwangen\-Schönach",
"498205", "Dasing",
"495451", "Ibbenbüren",
"4933361", "Joachimsthal",
"494451", "Varel\ Jadebusen",
"498807", "Diessen\ am\ Ammersee",
"4938229", "Bad\ Sülze",
"497932", "Niederstetten\ Württemberg",
"494233", "Blender",
"49541", "Osnabrück",
"492052", "Velbert\-Langenberg",
"4933922", "Karwesee",
"4938303", "Sellin\ Ostseebad",
"4934906", "Raguhn",
"497587", "Hosskirch",
"495481", "Lengerich\ Westfalen",
"494481", "Hatten\-Sandkrug",
"496325", "Lambrecht\ Pfalz",
"496623", "Rotenburg\ an\ der\ Fulda",
"495233", "Steinheim\ Westfalen",
"49441", "Oldenburg",
"4933982", "Hoppenrade\ Kreis\ Prignitz",
"4933675", "Tauche",
"492058", "Wülfrath",
"499846", "Ipsheim",
"4938220", "Wustrow\ Ostseebad",
"498021", "Waakirchen",
"498124", "Forstern\ Oberbayern",
"497332", "Lauterstein",
"4938374", "Lassan\ bei\ Wolgast",
"493561", "Guben",
"4939361", "Lüderitz",
"492303", "Unna",
"497724", "St\ Georgen\ im\ Schwarzwald",
"4935383", "Elster\ Elbe",
"496438", "Hünfelden",
"4933873", "Grosswudicke",
"4933094", "Löwenberg",
"496652", "Hünfeld",
"492605", "Löf",
"4935200", "Arnsdorf\ bei\ Dresden",
"497843", "Renchen",
"497425", "Trossingen",
"496432", "Diez",
"4935323", "Sonnewalde",
"496658", "Poppenhausen\ Wasserkuppe",
"494609", "Eggebek",
"492973", "Eslohe\ Sauerland",
"499704", "Euerdorf",
"495344", "Lengede",
"496569", "Bickendorf",
"498667", "Seeon\-Seebruck",
"496737", "Köngernheim",
"494344", "Schönberg\ Holstein",
"497192", "Murrhardt",
"4935726", "Gross\ Särchen",
"499405", "Bad\ Abbach",
"4936606", "Kraftsdorf",
"495609", "Ahnatal",
"4939832", "Wesenberg",
"494674", "Ockholm",
"499544", "Baunach",
"4937342", "Cranzahl",
"497066", "Bad\ Rappenau\-Bonfeld",
"499779", "Nordheim\ von\ der\ Rhön",
"497122", "St\ Johann\ Württemberg",
"492945", "Lippstadt\-Benninghausen",
"495674", "Grebenstein",
"498334", "Bad\ Grönenbach",
"492241", "Siegburg",
"498585", "Grainet",
"498753", "Elsendorf\ Niederbayern",
"496135", "Bodenheim\ Rhein",
"4933744", "Hohenseefeld",
"49340", "Dessau\ Anh",
"499156", "Neuhaus\ an\ der\ Pegnitz",
"499102", "Wilhermsdorf",
"499366", "Geroldshausen\ Unterfranken",
"497128", "Sonnenbühl",
"497277", "Wörth\-Büchelberg",
"497665", "March\ Breisgau",
"494268", "Bötersen",
"49208", "Oberhausen\ Rheinland",
"498091", "Kirchseeon",
"497153", "Plochingen",
"498194", "Vilgertshofen",
"497363", "Lauchheim",
"492751", "Bad\ Berleburg",
"498728", "Geratskirchen",
"494262", "Visselhövede",
"4934206", "Rötha",
"498243", "Fuchstal",
"494864", "Oldenswort",
"496395", "Münchweiler\ an\ der\ Rodalb",
"498427", "Wellheim",
"495864", "Jameln",
"4935058", "Pretzschendorf",
"498722", "Gangkofen",
"495262", "Extertal",
"496693", "Neuental",
"492409", "Stolberg\-Gressenich",
"498683", "Tittmoning",
"492743", "Daaden",
"493841", "Wismar",
"4936201", "Walschleben",
"498385", "Hergatz",
"492824", "Kalkar",
"497629", "Tegernau\ Baden",
"493947", "Thale",
"499566", "Meeder",
"492222", "Bornheim\ Rheinland",
"497044", "Mönsheim",
"497141", "Ludwigsburg\ Württemberg",
"499344", "Gerchsheim",
"4936653", "Lehesten\ Thüringer\ Wald",
"4933633", "Spreenhagen",
"497236", "Keltern",
"4936426", "Ottendorf\ bei\ Stadtroda",
"495704", "Petershagen\-Friedewalde",
"494405", "Edewecht",
"4939225", "Altengrabow",
"4938202", "Volkenshagen",
"495405", "Hasbergen\ Kreis\ Osnabrück",
"498251", "Aichach",
"494704", "Drangstedt",
"496081", "Usingen",
"496184", "Langenselbold",
"498534", "Tettenweis",
"492228", "Remagen\-Rolandseck",
"4938753", "Wöbbelin",
"499481", "Pfatter",
"492253", "Bad\ Münstereifel",
"4934347", "Oelzschau\ bei\ Borna",
"49941", "Regensburg",
"4937360", "Olbernhau",
"4933835", "Golzow\ bei\ Brandenburg",
"492596", "Nordkirchen",
"498230", "Gablingen",
"499233", "Arzberg\ Oberfranken",
"4938356", "Behrenhoff",
"496595", "Dockweiler",
"4934953", "Gräfenhainichen",
"496849", "Kirkel",
"495032", "Neustadt\ am\ Rübenberge",
"495846", "Gartow\ Niedersachsen",
"497563", "Kisslegg",
"498741", "Vilsbiburg",
"492681", "Altenkirchen\ Westerwald",
"4939407", "Seehausen\ Börde",
"49261", "Koblenz\ am\ Rhein",
"494846", "Hattstedt",
"497532", "Meersburg",
"497851", "Kehl",
"495731", "Bad\ Oeynhausen",
"4934601", "Teutschenthal",
"499268", "Teuschnitz",
"494731", "Nordenham",
"493361", "Fürstenwalde\ Spree",
"497957", "Kressberg",
"498501", "Thyrnau",
"499087", "Marktoffingen",
"497387", "Hohenstein\ Württemberg",
"498042", "Lenggries",
"4939771", "Ueckermünde",
"492526", "Sendenhorst",
"494240", "Syke\-Heiligenfelde",
"499262", "Wallenfels",
"4938824", "Mallentin",
"495063", "Bad\ Salzdetfurth",
"4933479", "Küstrin\-Kietz",
"496525", "Irrel",
"494108", "Rosengarten\ Kreis\ Harburg",
"496159", "Messel",
"495544", "Reinhardshagen",
"496788", "Sien",
"4933977", "Gumtow",
"4939925", "Wredenhagen",
"4939086", "Jävenitz",
"494779", "Freiburg\ Elbe",
"494544", "Berkenthin",
"499674", "Schönsee",
"495108", "Gehrden\ Han",
"496782", "Birkenfeld\ Nahe",
"4939209", "Wanzleben",
"494366", "Grömitz\-Cismar",
"4933200", "Bergholz\-Rehbrücke",
"494156", "Talkau",
"494102", "Ahrensburg",
"4936968", "Rossdorf\ Rhön",
"492474", "Nideggen\-Schmidt",
"4935873", "Herrnhut",
"492775", "Driedorf",
"495366", "Jembke",
"495156", "Coppenbrügge",
"495102", "Laatzen",
"4938391", "Altenkirchen\ Rügen",
"496776", "Dachsenhausen",
"492292", "Windeck\ Sieg",
"49671", "Bad\ Kreuznach",
"496781", "Idar\-Oberstein",
"494101", "Pinneberg",
"495324", "Vienenburg",
"495101", "Pattensen",
"499803", "Colmberg",
"494324", "Brokstedt",
"492291", "Waldbröl",
"4939605", "Gross\ Nemerow",
"4935828", "Reichenbach\ OL",
"497744", "Stühlingen",
"4934775", "Wippra",
"497579", "Schwenningen\ Baden",
"497823", "Seelbach\ Schutter",
"4936621", "Elsterberg\ bei\ Plauen",
"492043", "Gladbeck",
"497445", "Pfalzgrafenweiler",
"492564", "Vreden",
"4934921", "Kemberg",
"495657", "Meissner",
"498144", "Grafrath",
"499826", "Weidenbach\ Mittelfranken",
"498041", "Bad\ Tölz",
"499261", "Kronach",
"4936782", "Schmiedefeld\ am\ Rennsteig",
"4938721", "Ziegendorf",
"499965", "Sankt\ Englmar",
"498293", "Welden\ bei\ Augsburg",
"497254", "Waghäusel",
"499185", "Mühlhausen\ Oberpfalz",
"495732", "Löhne",
"495437", "Menslage",
"497806", "Bad\ Peterstal\-Griesbach",
"497852", "Willstätt",
"497531", "Konstanz",
"496345", "Albersweiler",
"4933396", "Klosterfelde",
"498556", "Haidmühle",
"498502", "Fürstenzell",
"494732", "Stadland\-Rodenkirchen",
"493362", "Erkner",
"4935602", "Drebkau",
"4938781", "Mellen",
"496643", "Herbstein",
"496373", "Schönenberg\-Kübelberg",
"498223", "Ichenhausen",
"495763", "Uchte",
"492676", "Ulmen",
"499220", "Kasendorf\-Azendorf",
"496675", "Breitenbach\ am\ Herzberg",
"493635", "Kölleda",
"494763", "Gnarrenburg",
"492682", "Hamm\ Sieg",
"498742", "Velden\ Vils",
"4934221", "Schildau\ Gneisenaustadt",
"4939743", "Zerrenthin",
"499482", "Wörth\ an\ der\ Donau",
"494134", "Embsen\ Kreis\ Lüneburg",
"495031", "Wunstorf",
"492688", "Kroppach",
"4939346", "Tucheim",
"497473", "Mössingen",
"497504", "Horgenzell",
"497148", "Grossbottwar",
"4936944", "Rentwertshausen",
"4936331", "Ilfeld",
"498252", "Schrobenhausen",
"498206", "Egling\ an\ der\ Paar",
"494929", "Ihlow\ Kreis\ Aurich",
"496082", "Niederreifenberg",
"4935841", "Grossschönau\ Sachsen",
"492866", "Dorsten\-Rhade",
"496865", "Mettlach\-Orscholz",
"499524", "Zeil\ am\ Main",
"4935477", "Rietzneuendorf\-Friedrichshof",
"492925", "Warstein\-Allagen",
"497142", "Bietigheim\-Bissingen",
"496267", "Fahrenbach\ Baden",
"494394", "Bokhorst",
"4936648", "Dittersdorf\ bei\ Schleiz",
"4938332", "Gross\ Bisdorf",
"498258", "Sielenbach",
"495826", "Suderburg",
"499657", "Waldthurn",
"494965", "Surwold",
"494261", "Rotenburg\ Wümme",
"499738", "Rottershausen",
"492637", "Weissenthurm",
"495965", "Klein\ Berssen",
"495261", "Lemgo",
"498721", "Eggenfelden",
"494826", "Hohenlockstedt",
"492758", "Bad\ Berleburg\-Girkhausen",
"4939207", "Colbitz",
"4939856", "Beenz\ bei\ Prenzlau",
"498092", "Grafing\ bei\ München",
"496573", "Gillenfeld",
"496404", "Lich\ Hessen",
"499732", "Hammelburg",
"495185", "Duingen",
"493533", "Elsterwerda",
"494185", "Marxen\ Auetal",
"4933979", "Wusterhausen\ Dosse",
"492752", "Bad\ Laasphe",
"4934464", "Freyburg\ Unstrut",
"497974", "Bühlerzell",
"495594", "Bovenden\-Reyershausen",
"4933477", "Trebnitz\ bei\ Müncheberg",
"499324", "Dettelbach",
"494803", "Pahlen",
"4939425", "Dingelstedt\ am\ Huy",
"4933841", "Belzig",
"492248", "Hennef\-Uckerath",
"499101", "Langenzenn",
"495803", "Rosche",
"4940", "Hamburg",
"492723", "Kirchhundem",
"4937294", "Grünhainichen",
"497304", "Blaustein\ Württemberg",
"4939485", "Gernrode\ Harz",
"493821", "Ribnitz\-Damgarten",
"492844", "Rheinberg\-Orsoy",
"497121", "Reutlingen",
"497024", "Wendlingen\ am\ Neckar",
"492242", "Hennef\ Sieg",
"4939409", "Eilsleben",
"499929", "Ruhmannsfelden",
"496431", "Limburg\ an\ der\ Lahn",
"4936025", "Körner",
"493471", "Bernburg\ Saale",
"4933701", "Grossbeeren",
"4933768", "Prieros",
"496283", "Hardheim\ Odenwald",
"498053", "Bad\ Endorf",
"497191", "Backnang",
"499394", "Esselbach",
"495524", "Bad\ Lauterberg\ im\ Harz",
"4936840", "Trusetal",
"496651", "Rasdorf",
"4936926", "Creuzburg",
"4939001", "Apenburg",
"493860", "Raben\ Steinfeld",
"4936085", "Reinholterode",
"494524", "Scharbeutz\-Pönitz",
"496479", "Waldbrunn\ Westerwald",
"498022", "Tegernsee",
"4935793", "Elstra",
"4939324", "Kläden\ bei\ Stendal",
"497331", "Geislingen\ an\ der\ Steige",
"496630", "Schwalmtal\-Storndorf",
"499763", "Sulzdorf\ an\ der\ Lederhecke",
"493562", "Forst\ Lausitz",
"4933602", "Alt\ Zeschdorf",
"492546", "Coesfeld\-Lette",
"4938233", "Prerow\ Ostseebad",
"496545", "Blankenrath",
"498166", "Allershausen\ Oberbayern",
"494488", "Westerstede",
"498302", "Görisried",
"495482", "Tecklenburg",
"4939384", "Arendsee\ Altmark",
"498028", "Fischbachau",
"492051", "Velbert",
"492364", "Haltern\ Westfalen",
"492154", "Willich",
"496107", "Kelsterbach",
"494482", "Hatten",
"499134", "Neunkirchen\ am\ Brand",
"495476", "Ostercappeln\-Venne",
"4939602", "Kleeth",
"496228", "Schönau\ Odenwald",
"497837", "Oberharmersbach",
"498378", "Buchenberg\ bei\ Kempten",
"49201", "Essen",
"495452", "Mettingen\ Westfalen",
"495406", "Belm",
"494638", "Tarp",
"494452", "Zetel\-Neuenburg",
"494406", "Berne",
"497235", "Unterreichenbach\ Kreis\ Calw",
"497931", "Bad\ Mergentheim",
"494757", "Wanna",
"496824", "Ottweiler",
"499565", "Untersiemau",
"495632", "Willingen\ Upland",
"498372", "Obergünzburg",
"495458", "Hopsten",
"496222", "Wiesloch",
"4936258", "Friemar",
"496743", "Bacharach",
"498386", "Oberstaufen",
"4935874", "Bernstadt\ an\ der\ Eigen",
"494632", "Steinbergkirche",
"494458", "Wiefelstede\-Spohle",
"496409", "Biebertal",
"492964", "Brilon\-Alme",
"4934772", "Helbra",
"4933238", "Senzke",
"495247", "Harsewinkel",
"494845", "Ostenfeld\ Husum",
"4936785", "Gräfinau\-Angstedt",
"496681", "Hilders",
"49661", "Fulda",
"4936077", "Grossbodungen",
"494423", "Fedderwarden",
"495423", "Versmold",
"4939400", "Wefensleben",
"4939828", "Wustrow\ Kreis\ Mecklenburg\-Strelitz",
"495845", "Bergen\ Dumme",
"494247", "Affinghausen",
"4938823", "Selmsdorf",
"4937367", "Lengefeld\ Erzgebirge",
"4935605", "Komptendorf",
"496596", "Üdersdorf",
"497644", "Kenzingen",
"492595", "Olfen",
"496253", "Fürth\ Odenwald",
"497950", "Schnelldorf",
"4936849", "Kleinschmalkalden",
"499080", "Harburg\ Schwaben",
"498083", "Isen",
"497309", "Weissenhorn",
"4934671", "Bad\ Frankenhausen\ Kyffhäuser",
"4939888", "Lychen",
"4934954", "Roitzsch\ bei\ Bitterfeld",
"496526", "Bollendorf",
"4934263", "Hohburg",
"492525", "Beckum\-Neubeckum",
"497374", "Uttenweiler",
"499924", "Bodenmais",
"4938754", "Leussow\ bei\ Ludwigslust",
"493327", "Werder\ Havel",
"494529", "Süsel\-Bujendorf",
"494493", "Friesoythe\-Gehlenberg",
"4934658", "Hayn\ Harz",
"499074", "Höchstädt\ an\ der\ Donau",
"499171", "Roth\ Mittelfranken",
"495873", "Eimke",
"494873", "Aukrug",
"497904", "Ilshofen",
"495493", "Neuenkirchen\ Kreis\ Vechta",
"495529", "Rhumspringe",
"498237", "Aindling",
"496775", "Strüth\ Taunus",
"495155", "Emmerthal",
"496894", "St\ Ingbert",
"495365", "Wolfsburg\-Neindorf",
"496292", "Seckach",
"4933207", "Gross\ Kreutz",
"495663", "Spangenberg",
"492776", "Bad\ Endbach\-Hartenrod",
"494663", "Süderlügum",
"498642", "Übersee",
"494155", "Büchen",
"494365", "Heringsdorf\ Holstein",
"493735", "Marienberg\ Sachsen",
"496503", "Hermeskeil",
"496474", "Villmar\-Aumenau",
"4933970", "Neustadt\ Dosse",
"496298", "Möckmühl",
"4933634", "Berkenbrück\ Kreis\ Oder\-Spree",
"492159", "Meerbusch\-Osterath",
"492369", "Dorsten\-Wulfen",
"4938227", "Lüdershagen\ bei\ Barth",
"494329", "Langwedel\ Holstein",
"496058", "Gründau",
"495329", "Schulenberg\ im\ Oberharz",
"499845", "Oberdachstetten",
"498067", "Tuntenhausen",
"499423", "Geiselhöring",
"492325", "Wanne\-Eickel",
"4937468", "Treuen\ Vogtland",
"496326", "Deidesheim",
"492623", "Ransbach\-Baumbach",
"498276", "Baar\ Schwaben",
"498282", "Krumbach\ Schwaben",
"496052", "Bad\ Orb",
"497403", "Dunningen",
"497574", "Gammertingen",
"499452", "Langquaid",
"499406", "Mintraching",
"499638", "Neualbenreuth",
"493933", "Genthin",
"492432", "Wassenberg",
"4939422", "Badersleben",
"492737", "Netphen\-Deuz",
"498621", "Trostberg",
"499632", "Waldsassen",
"4935207", "Moritzburg",
"497426", "Gosheim",
"496023", "Alzenau\ in\ Unterfranken",
"495565", "Einbeck\-Wenzen",
"492652", "Mendig",
"4935938", "Grosspostwitz\ OL",
"492606", "Winningen\ Mosel",
"4939482", "Gatersleben",
"4933743", "Blönsdorf",
"496303", "Enkenbach\-Alsenborn",
"497259", "Östringen\-Odenheim",
"4934298", "Taucha\ bei\ Leipzig",
"498572", "Tann\ Niederbayern",
"499663", "Neukirchen\ bei\ Sulzbach\-Rosenberg",
"499365", "Rimpar",
"4936022", "Grossengottern",
"493968", "Schönbeck",
"499155", "Simmelsdorf",
"496093", "Laufach",
"496136", "Nieder\-Olm",
"4938429", "Glasin",
"4933093", "Fürstenberg\ Havel",
"4935384", "Steinsdorf\ bei\ Jessen",
"498586", "Hauzenberg",
"4933874", "Stechow\ Brandenburg",
"4939396", "Neukirchen\ Altmark",
"496241", "Worms",
"4936082", "Ershausen",
"493962", "Penzlin\ bei\ Waren",
"4934362", "Mügeln\ bei\ Oschatz",
"495139", "Burgwedel",
"494139", "Hohnstorf\ Elbe",
"492463", "Titz",
"4935324", "Crinitz",
"494924", "Moormerland\-Oldersum",
"498461", "Beilngries",
"492395", "Finnentrop\-Rönkhausen",
"492693", "Antweiler",
"496396", "Hinterweidenthal",
"4933605", "Boossen",
"495924", "Bad\ Bentheim\-Gildehaus",
"4938304", "Garz\ Rügen",
"496751", "Bad\ Sobernheim",
"499873", "Abenberg\-Wassermungenau",
"495171", "Peine",
"495074", "Rodewald",
"4934976", "Gröbzig",
"4938373", "Katzow",
"499529", "Oberaurach",
"494171", "Winsen\ Luhe",
"499493", "Beratzhausen",
"497666", "Denzlingen",
"4935891", "Rothenburg\ OL",
"496874", "Wadern\-Nunkirchen",
"498322", "Oberstdorf",
"496272", "Hirschhorn\ Neckar",
"497031", "Böblingen",
"497134", "Weinsberg",
"496286", "Walldürn\-Rippberg",
"49291", "Meschede",
"4934609", "Salzmünde",
"498056", "Eggstätt",
"492981", "Winterberg\ Westfalen",
"493834", "Greifswald",
"492064", "Dinslaken",
"492351", "Lüdenscheid",
"492161", "Mönchengladbach",
"496127", "Niedernhausen\ Taunus",
"4939855", "Parmen\-Weggun",
"498541", "Vilshofen\ Niederbayern",
"4939779", "Eggesin",
"498328", "Balderschwang",
"4933847", "Görzke",
"499331", "Ochsenfurt",
"494289", "Kirchtimke",
"497763", "Murg",
"4939038", "Henningen",
"499766", "Grosswenkheim",
"4939426", "Hessen",
"492330", "Herdecke",
"495142", "Eschede",
"494142", "Steinkirchen\ Kreis\ Stade",
"499350", "Eussenheim\-Hundsbach",
"497394", "Schelklingen",
"492543", "Billerbeck\ Westfalen",
"4939201", "Wolmirstedt",
"498734", "Reisbach\ Niederbayern",
"496664", "Sinntal\-Sterbfritz",
"4939268", "Egeln",
"499094", "Tagmersheim",
"499191", "Forchheim\ Oberfranken",
"495148", "Steinhorst\ Niedersachsen",
"494504", "Ratekau",
"494473", "Emstek",
"495473", "Ostercappeln",
"495504", "Friedland\ Kreis\ Göttingen",
"494148", "Drochtersen\-Assel",
"494893", "Hohenaspe",
"498435", "Ehekirchen",
"493647", "Pössneck",
"494744", "Loxstedt",
"495445", "Drebber",
"493377", "Zossen\ Brandenburg",
"4936209", "Klettbach",
"495823", "Bienenbüttel",
"498138", "Schwabhausen\ bei\ Dachau",
"494823", "Wilster",
"496337", "Grossbundenbach",
"496588", "Pluwig",
"4936026", "Struth\ bei\ Mühlhausen",
"495744", "Hüllhorst",
"494445", "Visbek\ Kreis\ Vechta",
"4936925", "Marksuhl",
"493907", "Gardelegen",
"494550", "Bühnsdorf",
"492575", "Greven\-Reckenfeld",
"4939392", "Rönnebeck\ Sachsen\-Anhalt",
"497324", "Herbrechtingen",
"492449", "Blankenheim\ Ahr",
"499974", "Traitsching",
"496582", "Freudenburg",
"494254", "Eystrup",
"494806", "Sarzbüttel",
"494852", "Brunsbüttel",
"494531", "Bad\ Oldesloe",
"4939007", "Tangeln",
"495806", "Barum\ bei\ Bad\ Bevensen",
"495852", "Bleckede",
"495531", "Holzminden",
"497732", "Radolfzell\ am\ Bodensee",
"495254", "Paderborn\-Schloss\ Neuhaus",
"496725", "Gau\-Algesheim",
"494858", "Sankt\ Margarethen\ Holstein",
"496809", "Grossrosseln",
"4933458", "Falkenberg\ Mark",
"498392", "Markt\ Rettenbach",
"497657", "Eisenbach\ Hochschwarzwald",
"495858", "Hitzacker\-Wietzetze",
"497738", "Steisslingen",
"496424", "Ebsdorfergrund",
"4935243", "Weinböhla",
"4938787", "Glöwen",
"492375", "Balve",
"499142", "Treuchtlingen",
"498226", "Bibertal",
"492673", "Ellenz\-Poltersdorf",
"495766", "Rehburg\-Loccum",
"4937200", "Wittgensdorf\ bei\ Chemnitz",
"494766", "Basdahl",
"4939606", "Glienke",
"498459", "Manching",
"496382", "Lauterecken",
"495909", "Wettrup",
"497524", "Bad\ Waldsee",
"4937383", "Lunzenau",
"498861", "Schongau",
"495191", "Soltau",
"4938727", "Mestlin",
"499148", "Ettenstatt",
"492905", "Bestwig\-Ramsbeck",
"4934776", "Rothenschirmbach",
"4938850", "Gammelin",
"495379", "Sassenburg\-Grussendorf",
"498639", "Neumarkt\-Sankt\ Veit",
"499473", "Kallmünz",
"499504", "Stadelhofen",
"4937323", "Lichtenberg\ Erzgebirge",
"494191", "Kaltenkirchen\ Holstein",
"4934927", "Globig\-Bleddin",
"498592", "Wegscheid\ Niederbayern",
"497476", "Bisingen",
"496073", "Babenhausen\ Hessen",
"498203", "Grossaitingen",
"497482", "Horb\-Dettingen",
"499289", "Schwarzenbach\ am\ Wald",
"493761", "Werdau\ Sachsen",
"494331", "Rendsburg",
"492863", "Velen",
"497220", "Forbach\-Hundsbach",
"495331", "Wolfenbüttel",
"498671", "Altötting",
"4933395", "Zerpenschleuse",
"4939993", "Hohenmocker",
"492234", "Frechen",
"498341", "Kaufbeuren",
"492832", "Kevelaer",
"492551", "Steinfurt\-Burgsteinfurt",
"499254", "Gefrees",
"4935471", "Birkenhainchen",
"499531", "Ebern",
"4939293", "Dreileben",
"499852", "Feuchtwangen",
"4936337", "Schiedungen",
"497965", "Ellwangen\-Röhlingen",
"497261", "Sinsheim",
"492838", "Sonsbeck",
"4939345", "Parchen",
"497826", "Schuttertal",
"496045", "Gedern",
"495121", "Hildesheim",
"499823", "Leutershausen",
"495024", "Rohrsen\ Kreis\ Nienburg\ Weser",
"499445", "Neustadt\ an\ der\ Donau",
"499744", "Zeitlofs\-Detter",
"4935342", "Mühlberg\ Elbe",
"494121", "Elmshorn",
"495304", "Meine",
"494974", "Neuharlingersiel",
"497803", "Gengenbach",
"498296", "Villenbach",
"496215", "Ludwigshafen",
"496646", "Grebenau",
"492645", "Vettelschoss",
"498785", "Rottenburg\-Oberroning",
"498553", "Spiegelau",
"496096", "Wiesen\ Unterfranken",
"497529", "Waldburg\ Württemberg",
"499666", "Illschwang",
"495904", "Lengerich\ Emsl",
"498454", "Karlshuld",
"498583", "Neureichenau",
"4936744", "Remda",
"4935201", "Langebrück",
"493448", "Meuselwitz\ Thüringen",
"4935268", "Stauchitz",
"496133", "Oppenheim",
"492943", "Erwitte",
"496764", "Rheinböllen",
"498634", "Garching\ an\ der\ Alz",
"495374", "Isenbüttel",
"4939852", "Schönermark\ bei\ Prenzlau",
"496465", "Breidenbach\ bei\ Biedenkopf",
"492696", "Nohn\ Eifel",
"496393", "Fischbach\ bei\ Dahn",
"496695", "Jesberg",
"498847", "Obersöchering",
"498245", "Türkheim\ Wertach",
"492581", "Warendorf",
"49251", "Münster",
"4933369", "Oderberg",
"499876", "Rohr\ Mittelfranken",
"497663", "Eichstetten",
"497365", "Essingen\ Württemberg",
"499284", "Schwarzenbach\ an\ der\ Saale",
"4938221", "Marlow",
"4934721", "Nienburg\ Saale",
"4939243", "Nedlitz\ bei\ Zerbst",
"499426", "Oberschneiding",
"497632", "Badenweiler",
"497458", "Ebhausen",
"496323", "Edenkoben",
"498273", "Nordendorf",
"4934781", "Greifenhagen",
"492626", "Selters\ Westerwald",
"499270", "Creussen",
"495235", "Blomberg\ Lippe",
"494837", "Neuenkirchen\ Dithmarschen",
"495931", "Meppen",
"496625", "Niederaula",
"4939395", "Wanzer",
"4937438", "Bad\ Brambach",
"497452", "Nagold",
"494235", "Langwedel\-Etelsen",
"495837", "Sprakensehl",
"494931", "Norden",
"4936922", "Gerstungen",
"496003", "Rosbach\ von\ der\ Höhe",
"4937209", "Einsiedel\ bei\ Chemnitz",
"4933606", "Müllrose",
"495309", "Lehre\-Wendhausen",
"499749", "Oberbach\ Unterfranken",
"499574", "Marktzeuln",
"494644", "Karby",
"499403", "Donaustauf",
"492271", "Bergheim\ Erft",
"498367", "Rosshaupten\ Forggensee",
"498157", "Feldafing",
"492975", "Schmallenberg\-Oberkirchen",
"495644", "Willebadessen\-Peckelsheim",
"494950", "Holtland",
"496358", "Kriegsfeld",
"496026", "Grossostheim",
"4934975", "Görzig\ Kreis\ Köthen",
"497423", "Oberndorf\ am\ Neckar",
"492305", "Castrop\-Rauxel",
"492603", "Bad\ Ems",
"4938859", "Alt\ Zachun",
"497247", "Linkenheim\-Hochstetten",
"496306", "Trippstadt",
"496352", "Kirchheimbolanden",
"496162", "Reinheim\ Odenwald",
"4936873", "Themar",
"4938453", "Mistorf",
"496523", "Holsthum",
"495065", "Sibbesse",
"497139", "Neuenstadt\ am\ Kocher",
"4937361", "Neuhausen\ Erzgebirge",
"494496", "Friesoythe\-Markhausen",
"494882", "Lunden",
"493661", "Greiz",
"494284", "Selsingen",
"495284", "Schwalenberg",
"4936071", "Teistungen",
"498771", "Ergoldsbach",
"494876", "Reher\ Holstein",
"495882", "Gorleben",
"4939458", "Heudeber",
"492773", "Haiger",
"499904", "Lalling",
"493871", "Parchim",
"4933968", "Meyenburg\ Kreis\ Prignitz",
"493491", "Lutherstadt\ Wittenberg",
"496831", "Saarlouis",
"496506", "Welschbillig",
"496552", "Olzheim",
"497171", "Schwäbisch\ Gmünd",
"492505", "Altenberge\ Westfalen",
"494666", "Ladelund",
"4936200", "Elxleben\ bei\ Arnstadt",
"499374", "Eschau",
"4935606", "Briesen\ bei\ Cottbus",
"495509", "Rosdorf\ Kreis\ Göttingen",
"494509", "Gross\ Grönau",
"496558", "Büdesheim\ Eifel",
"493307", "Zehdenick",
"499099", "Kaisheim",
"496669", "Neuhof\-Hauswurz",
"495574", "Oberweser",
"495403", "Bad\ Iburg",
"494403", "Bad\ Zwischenahn",
"499644", "Pressath",
"494749", "Schiffdorf\-Geestenseth",
"4933653", "Ziltendorf",
"4939342", "Gladau",
"497329", "Steinheim\ am\ Albuch",
"492444", "Schleiden\-Gemünd",
"498685", "Kirchanschöring",
"492745", "Brachbach\ Sieg",
"493421", "Torgau",
"4933201", "Gross\ Glienicke",
"496746", "Pfalzfeld",
"498383", "Grünenbach\ Allgäu",
"495259", "Bad\ Driburg\-Neuenheerse",
"494426", "Wangerland\-Horumersiel",
"49231", "Dortmund",
"4934600", "Ostrau\ Saalkreis",
"492381", "Hamm\ Westfalen",
"497565", "Aichstetten\ Kreis\ Ravensburg",
"495426", "Glandorf",
"4938464", "Bernitt",
"499931", "Plattling",
"496429", "Schweinsberg\ Hessen",
"499235", "Thierstein",
"498072", "Haag\ in\ Oberbayern",
"496593", "Hillesheim\ Eifel",
"492857", "Rees\-Mehr",
"492255", "Euskirchen\-Flamersheim",
"492951", "Büren",
"4938733", "Karbow\-Vietlübbe",
"496804", "Mandelbachtal",
"496202", "Schwetzingen",
"496256", "Lampertheim\-Hüttenfeld",
"498086", "Buchbach\ Oberbayern",
"499837", "Haundorf",
"492388", "Hamm\-Uentrop",
"4938720", "Grebbin",
"498071", "Wasserburg\ am\ Inn",
"499932", "Osterhofen",
"496201", "Weinheim\ Bergstr",
"4934920", "Kropstädt",
"492952", "Rüthen",
"4936482", "Triptis",
"492382", "Ahlen\ Westfalen",
"495464", "Alfhausen",
"494765", "Ebersdorf\ bei\ Bremervörde",
"4938780", "Lanz\ Brandenburg",
"493335", "Finowfurt",
"499938", "Moos\ Niederbayern",
"498225", "Jettingen\-Scheppach",
"495765", "Raddestorf",
"494464", "Wittmund\-Carolinensiel",
"496375", "Wallhalben",
"4936043", "Kirchheilingen",
"496673", "Haunetal",
"4938481", "Witzin",
"492958", "Büren\-Harth",
"4938206", "Graal\-Müritz\ Seeheilbad",
"4936422", "Reinstädt\ Thüringen",
"4937207", "Hainichen\ Sachsen",
"498039", "Rott\ am\ Inn",
"4939294", "Gross\ Rosenburg",
"492923", "Lippetal\-Herzfeld",
"4938352", "Kemnitz\ bei\ Greifswald",
"495694", "Diemelstadt",
"493727", "Mittweida",
"4933331", "Casekow",
"497774", "Eigeltingen",
"497475", "Burladingen",
"4935025", "Liebstadt",
"497825", "Kippenheim",
"496046", "Ortenberg\ Hessen",
"497443", "Dornstetten",
"497709", "Wutach",
"492045", "Bottrop\-Kirchhellen",
"4936330", "Grossberndten",
"4933367", "Friedrichswalde\ Brandenburg",
"497966", "Unterschneidheim",
"496838", "Saarwellingen",
"497227", "Lichtenau\ Baden",
"492993", "Marsberg\-Canstein",
"499805", "Burgoberbach",
"4939994", "Metschow",
"494624", "Kropp",
"499729", "Grettstadt",
"496234", "Mutterstadt",
"497172", "Lorch\ Württemberg",
"495624", "Bad\ Emstal",
"499207", "Königsfeld\ Oberfranken",
"4962195", "Ludwigshafen",
"493886", "Gadebusch",
"496551", "Prüm",
"496832", "Beckingen\-Reimsbach",
"4936378", "Ostramondra",
"49481", "Heide\ Holstein",
"4939082", "Mieste",
"4937384", "Wechselburg",
"492646", "Königsfeld\ Eifel",
"496343", "Bad\ Bergzabern",
"496645", "Ulrichstein",
"494881", "Friedrichstadt",
"499183", "Burgthann",
"498295", "Altenmünster\ Schwaben",
"496216", "Ludwigshafen",
"498772", "Mallersdorf\-Pfaffenberg",
"49581", "Uelzen",
"4937324", "Reinsberg\ Sachsen",
"494167", "Apensen",
"494357", "Sehestedt\ Eider",
"499963", "Konzell",
"495167", "Walsrode\-Westenholz",
"495357", "Grasleben",
"499446", "Altmannstein",
"497944", "Kupferzell",
"4933085", "Seilershof",
"496161", "Brensbach",
"4933926", "Herzberg\ Mark",
"496351", "Eisenberg\ Pfalz",
"4935244", "Krögis",
"498055", "Halfing",
"4936701", "Lichte",
"496190", "Hattersheim\ am\ Main",
"496285", "Walldürn\-Altheim",
"496887", "Schmelz\ Saar",
"4933986", "Falkenhagen\ Kreis\ Prignitz",
"492874", "Isselburg",
"4937605", "Hartenstein\ Sachsen",
"492272", "Bedburg\ Erft",
"495932", "Haren\ Ems",
"494557", "Blunk",
"492664", "Rennerod",
"497451", "Horb\ am\ Neckar",
"494932", "Norderney",
"498656", "Anger",
"499464", "Walderbach",
"4935722", "Lauta\ bei\ Hoyerswerda",
"4936602", "Ronneburg\ Thüringen",
"496543", "Büchenbeuren",
"4939971", "Gnoien",
"494938", "Hagermarsch",
"499765", "Trappstadt",
"497631", "Müllheim\ Baden",
"496703", "Wöllstein\ Rheinhessen",
"496449", "Ehringshausen\-Katzenfurt",
"493535", "Herzberg\ Elster",
"494183", "Jesteburg",
"492582", "Everswinkel",
"49981", "Ansbach",
"4937346", "Geyer",
"495183", "Lamspringe",
"496575", "Landscheid",
"494446", "Bakum\ Kreis\ Vechta",
"495963", "Bawinkel",
"492588", "Harsewinkel\-Greffen",
"492337", "Hagen\-Dahl",
"499357", "Gräfendorf\ Bayern",
"495446", "Rehden",
"494963", "Dörpen",
"499167", "Oberscheinfeld",
"492424", "Vettweiss",
"496120", "Aarbergen",
"4938842", "Lüttenmark",
"493441", "Zeitz",
"492725", "Lennestadt\-Oedingen",
"496726", "Lorch\ Rheingau",
"4939000", "Beetzendorf",
"498269", "Unteregg\ bei\ Mindelheim",
"495805", "Oetzen",
"494207", "Oyten",
"4936841", "Schleusingen",
"4934202", "Delitzsch",
"494805", "Schafstedt",
"495207", "Schloss\ Holte\-Stukenbrock",
"499624", "Ensdorf\ Oberpfalz",
"494794", "Worpswede\-Ostersode",
"495495", "Vörden\ Kreis\ Vechta",
"495277", "Höxter\-Fürstenau",
"4939401", "Neuwegersleben",
"494875", "Stafstedt",
"492850", "Rees\-Haldern",
"495128", "Hohenhameln",
"494128", "Kollmar",
"497949", "Pfedelbach\-Untersteinbach",
"495875", "Emmendorf",
"494277", "Schwaförden",
"494495", "Friesoythe\-Thüle",
"4934638", "Zöschen",
"4939226", "Hohenziatz",
"4936425", "Isserstedt",
"497674", "Todtmoos",
"4939009", "Badel",
"495066", "Sarstedt",
"494122", "Uetersen",
"4934341", "Geithain",
"492523", "Wadersloh",
"497262", "Eppingen",
"496147", "Trebur",
"492558", "Horstmar",
"4933836", "Butzow\ bei\ Brandenburg",
"4933654", "Fünfeichen",
"498348", "Bidingen",
"4938355", "Züssow",
"494665", "Emmelsbüll\-Horsbüll",
"492506", "Münster\-Wolbeck",
"492552", "Steinfurt\-Borghorst",
"493984", "Prenzlau",
"492831", "Geldern",
"497268", "Bad\ Rappenau\-Obergimpern",
"496505", "Kordel",
"498342", "Marktoberdorf",
"494153", "Lauenburg\ Elbe",
"493733", "Annaberg\-Buchholz",
"494363", "Lensahn",
"499851", "Dinkelsbühl",
"495153", "Salzhemmendorf",
"499532", "Maroldsweisach",
"4936207", "Plaue\ Thüringen",
"495363", "Wolfsburg\-Vorsfelde",
"4937422", "Markneukirchen",
"496773", "Kamp\-Bornhofen",
"499469", "Roding\-Neubäu",
"492937", "Arnsberg\-Oeventrop",
"495665", "Guxhagen",
"496745", "Gondershausen",
"498686", "Petting",
"494332", "Hamdorf\ bei\ Rendsburg",
"493762", "Crimmitschau",
"499563", "Rödental",
"495332", "Schöppenstedt",
"496444", "Bischoffen",
"4935022", "Bad\ Schandau",
"497233", "Niefern\-Öschelbronn",
"494338", "Alt\ Duvenstedt",
"498591", "Obernzell",
"498678", "Marktl",
"4933971", "Kyritz\ Brandenburg",
"49741", "Rottweil",
"492804", "Xanten\-Marienbaum",
"498085", "Sankt\ Wolfgang",
"4939926", "Grabowhöfe",
"496255", "Lindenfels",
"495192", "Munster",
"492256", "Mechernich\-Satzvey",
"492202", "Bergisch\ Gladbach",
"4933849", "Wiesenburg\ Mark",
"4939777", "Borkenfriede",
"498868", "Schwabsoien",
"497344", "Blaubeuren",
"492429", "Hürtgenwald",
"494192", "Bad\ Bramstedt",
"492593", "Ascheberg\ Westfalen",
"496857", "Namborn",
"499236", "Nagel",
"4939085", "Zichtau",
"4938454", "Kritzkow",
"495425", "Borgholzhausen",
"494724", "Cuxhaven\-Lüdingworth",
"495843", "Wustrow\ Wendland",
"499141", "Weissenburg\ in\ Bayern",
"4934607", "Wettin",
"492208", "Niederkassel",
"495198", "Schneverdingen\-Wintermoor",
"497566", "Argenbühl",
"49631", "Kaiserslautern",
"494843", "Viöl",
"4935698", "Hornow",
"498862", "Steingaden\ Oberbayern",
"495724", "Obernkirchen",
"494425", "Wangerland\-Hooksiel",
"4934328", "Hartha\ bei\ Döbeln",
"496381", "Kusel",
"492465", "Inden",
"497063", "Bad\ Wimpfen",
"4934905", "Wörlitz",
"496466", "Dautphetal\-Friedensdorf",
"498708", "Weihmichl\-Unterneuhausen",
"4939862", "Schmölln\ bei\ Prenzlau",
"4939722", "Sarnow\ bei\ Anklam",
"4933082", "Menz\ Kreis\ Oberhavel",
"498179", "Eurasburg\ an\ der\ Loisach",
"4935971", "Sebnitz",
"497240", "Pfinztal",
"492764", "Welschen\ Ennest",
"495957", "Lindern\ Oldenburg",
"4936874", "Schönbrunn\ bei\ Hildburghaus",
"494532", "Bargteheide",
"4937602", "Kirchberg\ Sachsen",
"494851", "Marne",
"498407", "Grossmehring",
"498702", "Wörth\ an\ der\ Isar",
"498756", "Nandlstadt",
"492133", "Dormagen",
"4933676", "Friedland\ bei\ Beeskow",
"494469", "Wangerooge",
"497731", "Singen\ Hohentwiel",
"499665", "Königstein\ Oberpfalz",
"494957", "Detern",
"499363", "Arnstein\ Unterfranken",
"495532", "Stadtoldendorf",
"496095", "Bessenbach",
"499153", "Schnaittach",
"495851", "Dahlenburg",
"499128", "Feucht",
"494830", "Süderhastedt",
"497366", "Abtsgmünd",
"497156", "Ditzingen",
"499495", "Breitenbrunn\ Oberpfalz",
"499277", "Warmensteinach",
"499875", "Wolframs\-Eschenbach",
"496581", "Saarburg",
"49651", "Trier",
"498131", "Dachau",
"498034", "Brannenburg",
"4939244", "Steutz",
"499122", "Schwabach",
"498246", "Waal",
"492393", "Sundern\-Allendorf",
"4935725", "Wittichenau",
"4936605", "Bad\ Köstritz",
"496696", "Gilserberg",
"492695", "Insul",
"497544", "Markdorf",
"499192", "Gräfenberg",
"494236", "Kirchlinteln",
"497704", "Geisingen\ Baden",
"496626", "Wildeck\-Obersuhl",
"492323", "Herne",
"495236", "Blomberg\-Grossenmarpe",
"492625", "Ochtendung",
"495044", "Springe\-Eldagsen",
"495141", "Celle",
"499843", "Burgbernheim",
"499198", "Heiligenstadt\ in\ Oberfranken",
"496239", "Bobenheim\-Roxheim",
"499724", "Stadtlauringen",
"494141", "Stade",
"4934929", "Straach",
"496305", "Hochspeyer",
"494563", "Scharbeutz\-Haffkrug",
"498542", "Ortenburg",
"492162", "Viersen",
"4938845", "Kaarssen",
"492306", "Lünen",
"492352", "Altena\ Westfalen",
"4936743", "Teichel",
"495563", "Kreiensen",
"499332", "Marktbreit",
"4938729", "Marnitz",
"498321", "Sonthofen",
"498548", "Vilshofen\-Sandbach",
"497032", "Herrenberg",
"496271", "Eberbach\ Baden",
"4934205", "Markranstädt",
"492358", "Meinerzhagen\-Valbert",
"492982", "Medebach",
"499338", "Röttingen\ Unterfranken",
"493935", "Tangerhütte",
"498104", "Sauerlach",
"4938789", "Wolfshagen\ bei\ Perleberg",
"498624", "Obing",
"4938452", "Lalendorf",
"493996", "Teterow",
"49371", "Chemnitz\ Sachsen",
"4939030", "Brunau",
"499269", "Tettau\ Kreis\ Kronach",
"4937325", "Niederbobritzsch",
"4936451", "Buttelstedt",
"497462", "Immendingen",
"496123", "Eltville\ am\ Rhein",
"498167", "Zolling",
"499942", "Viechtach",
"4935024", "Stadt\ Wehlen",
"496789", "Heimbach\ Nahe",
"492547", "Rosendahl\-Osterwick",
"496158", "Riedstadt",
"494109", "Tangstedt\ Bz\ Hamburg",
"495109", "Ronnenberg",
"494778", "Wingst",
"4938321", "Martensdorf\ bei\ Stralsund",
"4933393", "Gross\ Schönebeck\ Kreis\ Barnim",
"499948", "Eschlkam",
"4939995", "Nossendorf",
"495295", "Lichtenau\ Westfalen",
"497571", "Sigmaringen",
"496106", "Rodgau",
"496152", "Gross\-Gerau",
"496362", "Alsenz",
"495772", "Espelkamp",
"49881", "Weilheim\ in\ Oberbayern",
"493643", "Weimar\ Thüringen",
"494772", "Oberndorf\ Oste",
"494295", "Emtinghausen",
"494180", "Königsmoor",
"494477", "Lastrup\-Hemmelte",
"494827", "Wacken",
"498765", "Bruckberg\ Niederbayern",
"495225", "Spenge",
"495921", "Nordhorn",
"496635", "Kirtorf",
"4939295", "Zuchau",
"496333", "Waldfischbach\-Burgalben",
"492636", "Burgbrohl",
"492408", "Aachen\-Kornelimünster",
"497628", "Efringen\-Kirchen",
"495827", "Unterlüss",
"498464", "Dietfurt\ an\ der\ Altmühl",
"499656", "Moosbach\ bei\ Vohenstrauss",
"499602", "Neustadt\ an\ der\ Waldnaab",
"494921", "Emden\ Stadt",
"493675", "Sonneberg\ Thüringen",
"4933652", "Neuzelle",
"4933969", "Stepenitz",
"496455", "Frankenau\ Hessen",
"494174", "Stelle\ Kreis\ Harburg",
"492402", "Stolberg\ Rheinland",
"492456", "Selfkant",
"4939343", "Jerichow",
"4939957", "Gielow",
"4939746", "Krackow",
"499436", "Nittenau",
"495071", "Schwarmstedt",
"495174", "Lahstedt",
"499608", "Kohlberg\ Oberpfalz",
"497622", "Schopfheim",
"496754", "Martinstein",
"497433", "Balingen",
"496036", "Wölfersheim",
"4939459", "Hasselfelde",
"4936731", "Unterloquitz",
"496848", "Homburg\-Einöd",
"49721", "Karlsruhe",
"497653", "Lenzkirch",
"497355", "Hochdorf\ Riss",
"497165", "Göppingen\-Hohenstaufen",
"496842", "Blieskastel",
"4938732", "Gallin\ bei\ Lübz",
"493865", "Holthusen",
"4939051", "Calvörde",
"496244", "Westhofen\ Rheinhessenen",
"499778", "Fladungen",
"4938858", "Lassahn",
"498446", "Pörnbach",
"495942", "Uelsen",
"494942", "Südbrookmerland",
"496684", "Hofbieber\-Schwarzbach",
"492677", "Lutzerath",
"496533", "Morbach\ Hunsrück",
"499772", "Bischofsheim\ an\ der\ Rhön",
"499180", "Pyrbaum",
"495948", "Itterbeck",
"499295", "Töpen",
"4937208", "Auerswalde",
"497641", "Emmendingen",
"4939853", "Holzendorf\ bei\ Prenzlau",
"494948", "Wiesmoor\-Marcardsmoor",
"497129", "Lichtenstein\ Württemberg",
"493573", "Senftenberg",
"496340", "Wörth\-Schaidt",
"498207", "Affing",
"497555", "Deggenhausertal",
"497934", "Weikersheim",
"494269", "Ahausen\-Kirchwalsede",
"49211", "Düsseldorf",
"492181", "Grevenbroich",
"498805", "Hohenpeissenberg",
"4937439", "Jocketa",
"492961", "Brilon",
"492265", "Reichshof\-Eckenhagen",
"4934491", "Schmölln\ Thüringen",
"496266", "Hassmersheim",
"497440", "Bad\ Rippoldsau",
"4935751", "Welzow",
"492867", "Heiden\ Kreis\ Borken",
"496821", "Neunkirchen\ Saar",
"496471", "Weilburg",
"4939242", "Prödel",
"495055", "Fassberg",
"493431", "Döbeln",
"4933368", "Hohensaaten",
"4936377", "Rastenberg",
"4936923", "Treffurt",
"496670", "Ludwigsau\ Hessen",
"496562", "Speicher",
"494602", "Freienwill",
"499921", "Regen",
"4933084", "Gutengermendorf",
"499225", "Stadtsteinach",
"496439", "Holzappel",
"4939724", "Klein\ Bünzow",
"497371", "Riedlingen\ Württemberg",
"4935796", "Panschwitz\-Kuckau",
"495656", "Waldkappel",
"495602", "Hessisch\ Lichtenau",
"499827", "Lichtenau\ Mittelfranken",
"4938871", "Mühlen\ Eichsen",
"4935245", "Burkhardswalde\-Munzig",
"496568", "Wolsfeld",
"498557", "Mauth",
"494608", "Handewitt",
"496659", "Eichenzell",
"499174", "Hilpoltstein",
"495608", "Söhrewald",
"495436", "Nortrup",
"499071", "Dillingen\ an\ der\ Donau",
"497807", "Neuried\ Ortenaukreis",
"4937604", "Mosel",
"499104", "Emskirchen",
"498338", "Böhen",
"4938455", "Plaaz",
"499548", "Mühlhausen\ Mittelfranken",
"4937382", "Geringswalde",
"4939084", "Lindstedt",
"499321", "Kitzingen",
"497275", "Kandel",
"497971", "Gaildorf",
"495672", "Bad\ Karlshafen",
"498332", "Ottobeuren",
"497021", "Kirchheim\ unter\ Teck",
"497124", "Trochtelfingen\ Hohenz",
"492841", "Moers",
"492947", "Anröchte",
"499542", "Schesslitz",
"4937322", "Brand\-Erbisdorf",
"494672", "Langenhorn",
"495686", "Schwarzenborn\ Knüll",
"495862", "Hitzacker\ Elbe",
"495264", "Kalletal",
"498724", "Massing",
"493681", "Suhl",
"496397", "Leimen\ Pfalz",
"494264", "Sottrum\ Kreis\ Rotenburg",
"497939", "Schrozberg\-Spielbach",
"49361", "Erfurt",
"494862", "Garding",
"497667", "Breisach\ am\ Rhein",
"4938826", "Dassow",
"4934441", "Hohenmölsen",
"495085", "Burgdorf\-Ehlershausen",
"493596", "Neustadt\ in\ Sachsen",
"496401", "Grünberg\ Hessen",
"498192", "Schondorf\ am\ Ammersee",
"4939992", "Görmin",
"498066", "Bad\ Feilnbach",
"4933655", "Grunow\ Kreis\ Oder\-Spree",
"4937430", "Eichigt",
"4938354", "Wusterhusen",
"499246", "Pegnitz\-Trockau",
"4939292", "Biederitz",
"497334", "Deggingen",
"498122", "Erding",
"499131", "Erlangen",
"495833", "Brome",
"497585", "Ostrach",
"496007", "Rosbach\-Rodheim",
"497753", "Albbruck",
"496327", "Neustadt\-Lachen",
"492151", "Krefeld",
"492361", "Recklinghausen",
"492054", "Essen\-Kettwig",
"494833", "Wesselburen",
"499360", "Thüngen",
"498153", "Wessling",
"494342", "Preetz\ Kreis\ Plön",
"4936484", "Knau\ bei\ Pössneck",
"492736", "Burbach\ Siegerl",
"498363", "Pfronten",
"497194", "Spiegelberg",
"496735", "Eppelsheim",
"498665", "Inzell",
"497728", "Niedereschach",
"496434", "Bad\ Camberg",
"4935343", "Hirschfeld\ bei\ Elsterwerda",
"499407", "Wenzenbach",
"494348", "Schönkirchen",
"4936424", "Kahla\ Thüringen",
"494521", "Eutin",
"492607", "Kobern\-Gondorf",
"4938735", "Plau\ am\ See",
"497243", "Ettlingen",
"499179", "Freystadt",
"497722", "Triberg\ im\ Schwarzwald",
"496654", "Gersfeld\ Rhön",
"499708", "Bad\ Bocklet",
"495521", "Herzberg\ am\ Harz",
"497427", "Schömberg\ bei\ Balingen",
"499391", "Marktheidenfeld",
"499264", "Küps",
"497385", "Gomadingen",
"497683", "Simonswald",
"4939751", "Penkun",
"4938844", "Gülze",
"495840", "Schnackenburg",
"498141", "Fürstenfeldbruck",
"4934637", "Frankleben",
"498629", "Palling",
"496527", "Oberweis",
"492561", "Ahaus",
"492590", "Dülmen\-Buldern",
"498236", "Fischach",
"499868", "Schillingsfürst",
"4934204", "Schkeuditz",
"4933051", "Nassenheide",
"497534", "Reichenau\ Baden",
"499085", "Alerheim",
"497251", "Bruchsal",
"497955", "Wallhausen\ Württemberg",
"492486", "Nettersheim",
"493973", "Pasewalk",
"496485", "Nentershausen\ Westerwald",
"492294", "Morsbach\ Sieg",
"494321", "Neumünster",
"495321", "Goslar",
"492777", "Breitscheid\ Hessen",
"494104", "Aumühle\ bei\ Hamburg",
"496784", "Weierbach",
"492472", "Monschau",
"493303", "Birkenwerder",
"4933746", "Werbig\ bei\ Jüterbog",
"498563", "Bad\ Birnbach\ Rottal",
"499560", "Grub\ am\ Forst",
"499672", "Neunburg\ vorm\ Wald",
"494542", "Mölln\ Lauenburg",
"493605", "Leinefelde",
"495542", "Witzenhausen",
"4936208", "Ermstedt",
"497741", "Tiengen\ Hochrhein",
"498469", "Freystadt\-Burggriesbach",
"496182", "Seligenstadt",
"494756", "Odisheim",
"494702", "Sandstedt",
"492828", "Emmerich\-Elten",
"498532", "Griesbach\ im\ Rottal",
"494407", "Wardenburg",
"498851", "Kochel\ am\ See",
"497836", "Schiltach",
"492175", "Leichlingen\ Rheinland",
"499342", "Wertheim",
"495407", "Wallenhorst",
"495702", "Petershagen\-Lahde",
"4939245", "Loburg",
"4936961", "Bad\ Liebenstein",
"494708", "Ringstedt",
"492822", "Emmerich",
"496188", "Kahl\ am\ Main",
"497042", "Vaihingen\ an\ der\ Enz",
"498538", "Pocking\-Hartkirchen",
"498387", "Weiler\-Simmerberg",
"492224", "Bad\ Honnef",
"499521", "Hassfurt",
"4935724", "Lohsa",
"499348", "Werbach\-Gamburg",
"4939393", "Werben\ Elbe",
"4936604", "Münchenbernsdorf",
"494179", "Winsen\-Tönnhausen",
"494246", "Twistringen\-Heiligenloh",
"492520", "Wadersloh\-Diestedde",
"4939039", "Bonese",
"4934904", "Oranienbaum",
"495246", "Verl",
"4939778", "Ferdinandshof\ bei\ Torgelow",
"496249", "Guntersblum",
"4936875", "Straufhain\-Streufdorf",
"495131", "Garbsen",
"499833", "Heidenheim\ Mittelfranken",
"495034", "Neustadt\-Hagen",
"494131", "Lüneburg",
"4934327", "Waldheim\ Sachsen",
"4935697", "Bagenz",
"4935242", "Nossen",
"4938376", "Zirchow",
"496597", "Jünkerath",
"4934973", "Osternienburg",
"492853", "Schermbeck",
"493969", "Siedenbollentin",
"499553", "Ebrach\ Oberfranken",
"498550", "Philippsreut",
"495132", "Lehrte",
"4938788", "Gross\ Warnow",
"4939863", "Seehausen\ bei\ Prenzlau",
"4939723", "Krien",
"4933083", "Schulzendorf\ Kreis\ Oberhavel",
"4934241", "Jesewitz",
"492533", "Münster\-Nienberge",
"494132", "Amelinghausen",
"499484", "Brennberg",
"495138", "Sehnde",
"4937603", "Wildenfels",
"496677", "Neuenstein\ Hessen",
"4938728", "Domsühl",
"498744", "Gerzen",
"4939386", "Seehausen\ Altmark",
"492684", "Puderbach\ Westerwald",
"4934928", "Seegrehna",
"498445", "Gerolsbach",
"499820", "Lehrberg",
"494138", "Betzendorf\ Kreis\ Lüneburg",
"498823", "Mittenwald",
"497144", "Marbach\ am\ Neckar",
"497041", "Mühlacker",
"494392", "Nortorf\ bei\ Neumünster",
"498858", "Kochel\-Walchensee",
"493723", "Hohenstein\-Ernstthal",
"492821", "Kleve\ Niederrhein",
"496867", "Perl",
"4936628", "Zeulenroda",
"496265", "Billigheim\ Baden",
"492927", "Neuengeseke",
"493844", "Schwaan",
"492266", "Lindlar",
"499522", "Eltmann",
"498806", "Utting\ am\ Ammersee",
"498531", "Pocking",
"49611", "Wiesbaden",
"4936924", "Mihla",
"496181", "Hanau",
"496084", "Schmitten\ Taunus",
"498254", "Altomünster",
"497502", "Wolpertswende",
"497556", "Uhldingen\-Mühlhofen",
"499341", "Tauberbischofsheim",
"499528", "Donnersdorf",
"499671", "Oberviechtach",
"494541", "Ratzeburg",
"494328", "Rickling",
"497223", "Bühl\ Baden",
"497742", "Klettgau",
"497447", "Baiersbronn\-Schwarzenberg",
"4936370", "Grossenehrich",
"495541", "Hann\.\ Münden",
"496059", "Jossgrund",
"495328", "Altenau\ Harz",
"495056", "Winsen\-Meissendorf",
"494322", "Bordesholm",
"499203", "Neudrossenfeld",
"4937296", "Stollberg\ Erzgebirge",
"4936338", "Bleicherode",
"4938297", "Moitin",
"497748", "Grafenhausen\ Hochschwarzwald",
"492471", "Roetgen\ Eifel",
"495322", "Bad\ Harzburg",
"498504", "Tittling",
"499187", "Altdorf\ bei\ Nürnberg",
"499639", "Mähring",
"495435", "Berge\ bei\ Quakenbrück",
"4936742", "Uhlstädt",
"494734", "Stadland\-Seefeld",
"493364", "Eisenhüttenstadt",
"494435", "Grossenkneten",
"495734", "Bergkirchen\ Westfalen",
"492568", "Heek",
"497252", "Bretten",
"496347", "Hochstadt\ Pfalz",
"497854", "Kehl\-Goldscheuer",
"495353", "Königslutter\ am\ Elm",
"495163", "Fallingbostel\-Dorfmark",
"499861", "Rothenburg\ ob\ der\ Tauber",
"495655", "Wanfried",
"4939854", "Kleptow",
"497258", "Oberderdingen\-Flehingen",
"492562", "Gronau\ Westfalen",
"493546", "Lübben\ Spreewald",
"4934466", "Janisroda",
"494353", "Ascheffel",
"498142", "Olching",
"494163", "Horneburg\ Niederelbe",
"494522", "Plön",
"495522", "Osterode\ am\ Harz",
"499392", "Faulbach\ Unterfranken",
"497721", "Villingen\ im\ Schwarzwald",
"4936946", "Erbenhausen\ Thüringen",
"4936461", "Bad\ Sulza",
"494528", "Schönwalde\ am\ Bungsberg",
"499398", "Birkenfeld\ bei\ Würzburg",
"495528", "Gieboldehausen",
"4939037", "Pretzier",
"495341", "Salzgitter",
"499701", "Sandberg\ Unterfranken",
"4938462", "Baumgarten",
"4933848", "Raben",
"494296", "Schwanewede\-Aschwarden",
"499132", "Herzogenaurach",
"494484", "Hude\-Wüsting",
"495553", "Kalefeld",
"495484", "Lienen\-Kattenvenne",
"494553", "Geschendorf",
"496105", "Mörfelden\-Walldorf",
"492362", "Dorsten",
"493346", "Seelow",
"492152", "Kempen",
"493564", "Schwarze\ Pumpe",
"4939267", "Schneidlingen",
"498304", "Wildpoldsried",
"4937423", "Adorf\ Vogtland",
"498121", "Markt\ Schwaben",
"49365", "Gera",
"498024", "Holzkirchen",
"495820", "Suhlendorf",
"4939344", "Güsen",
"492368", "Oer\-Erkenschwick",
"492158", "Grefrath\ bei\ Krefeld",
"498649", "Schleching",
"4939931", "Röbel\ Müritz",
"498379", "Waltenhofen\-Oberdorf",
"499435", "Schwarzenfeld",
"496229", "Neckarsteinach",
"495187", "Delligsen",
"492754", "Bad\ Laasphe\-Feudingen",
"497053", "Bad\ Teinach\-Zavelstein",
"498191", "Landsberg\ am\ Lech",
"496707", "Windesheim",
"498094", "Steinhöring",
"492455", "Waldfeucht",
"494187", "Holm\-Seppensen",
"499734", "Burkardroth",
"496402", "Hungen",
"496456", "Haina\ Kloster",
"4935023", "Bad\ Gottleuba",
"494639", "Schafflund",
"499655", "Tännesberg",
"495459", "Hörstel",
"495861", "Dannenberg\ Elbe",
"499163", "Dachsbach",
"494967", "Rhauderfehn\-Burlage",
"499353", "Karlstadt",
"494861", "Tönning",
"492635", "Rheinbrohl",
"496408", "Buseck",
"496636", "Romrod",
"4933394", "Blumberg\ Kreis\ Barnim",
"492333", "Ennepetal",
"498766", "Gammelsdorf",
"495226", "Bruchmühlen\ Westfalen",
"493682", "Zella\-Mehlis",
"4939008", "Kunrau",
"493866", "Cambs",
"4939061", "Weferlingen",
"492842", "Kamp\-Lintfort",
"498331", "Memmingen",
"492244", "Königswinter\-Oberpleis",
"495671", "Hofgeismar",
"497022", "Nürtingen",
"497166", "Adelberg",
"497356", "Schemmerhofen",
"497302", "Pfaffenhofen\ an\ der\ Roth",
"493925", "Stassfurt",
"494671", "Bredstedt",
"495203", "Werther\ Westfalen",
"4933457", "Altreetz",
"492193", "Dabringhausen",
"4933708", "Rangsdorf",
"4934639", "Wallendorf\ Luppe",
"495592", "Gleichen\-Bremke",
"497972", "Gschwend\ bei\ Gaildorf",
"497308", "Nersingen",
"496035", "Reichelsheim\ Wetterau",
"494203", "Weyhe\ bei\ Bremen",
"499086", "Fremdingen",
"499928", "Kirchdorf\ im\ Wald",
"494273", "Kirchdorf\ bei\ Sulingen",
"4939881", "Ringenwalde\ bei\ Templin",
"493623", "Friedrichroda",
"495273", "Beverungen",
"4934903", "Coswig\ Anhalt",
"4938306", "Samtens",
"499072", "Lauingen\ Donau",
"499922", "Zwiesel",
"496561", "Bitburg",
"4939821", "Carpin",
"492527", "Lippetal\-Lippborg",
"4939457", "Benneckenstein\ Harz",
"497386", "Hayingen",
"499078", "Mertingen",
"495601", "Schauenburg",
"499383", "Wiesentheid",
"498380", "Achberg",
"4933231", "Pausin",
"4939959", "Dargun",
"496478", "Greifenstein\-Ulm",
"494489", "Apen",
"493606", "Heiligenstadt\ Heilbad",
"4933876", "Buschow",
"496898", "Völklingen",
"4935386", "Prettin",
"4933967", "Freyenstein",
"495367", "Rühen",
"495157", "Emmerthal\-Börry",
"4939394", "Hohenberg\-Krusemark",
"498029", "Kreuth\ bei\ Tegernsee",
"496472", "Weilmünster",
"4936603", "Weida",
"4935723", "Bernsdorf\ OL",
"492933", "Sundern\ Sauerland",
"4935326", "Schönborn\ Kreis\ Elbe\-Elster",
"496486", "Katzenelnbogen",
"497083", "Bad\ Herrenalb",
"499953", "Pilsting",
"496294", "Krautheim\ Jagst",
"494367", "Grossenbrode",
"493737", "Rochlitz",
"492485", "Schleiden\-Dreiborn",
"499567", "Sesslach\-Gemünda",
"494634", "Husby",
"493946", "Quedlinburg",
"492962", "Olsberg",
"492759", "Bad\ Berleburg\-Aue",
"496224", "Sandhausen\ Baden",
"495634", "Waldeck\-Sachsenhausen",
"498374", "Dietmannsried",
"496175", "Friedrichsdorf\ Taunus",
"495583", "Braunlage\-Hohegeiss",
"495755", "Kalletal\-Varenholz",
"494454", "Jade",
"497835", "Zell\ am\ Harmersbach",
"4933931", "Rheinsberg\ Mark",
"497237", "Neulingen\ Enzkreis",
"492182", "Grevenbroich\-Kapellen",
"495454", "Hörstel\-Riesenbeck",
"494755", "Ihlienworth",
"492770", "Eschenburg",
"492597", "Senden\ Westfalen",
"496853", "Marpingen",
"499771", "Bad\ Neustadt\ an\ der\ Saale",
"4938843", "Bennin",
"497642", "Endingen\ Kaiserstuhl",
"4934651", "Rossla",
"493395", "Pritzwalk",
"495941", "Neuenhaus\ Dinkel",
"494847", "Oster\-Ohrstedt",
"495245", "Herzebrock\-Clarholz",
"493693", "Meiningen",
"4934203", "Zwenkau",
"494941", "Aurich",
"494245", "Neuenkirchen\ bei\ Bassum",
"495685", "Knüllwald",
"4935931", "Königswartha",
"4934291", "Borsdorf",
"495383", "Lutter\ am\ Barenberge",
"4935267", "Diesbar\-Seusslitz",
"494383", "Grebin",
"497420", "Deisslingen",
"496841", "Homburg\ Saar",
"4936483", "Ziegenrück",
"493964", "Bredenfelde\ bei\ Strasburg",
"497276", "Herxheim\ bei\ Landau\ Pfalz",
"499157", "Alfeld\ Mittelfranken",
"499367", "Unterpleichfeld",
"494953", "Bunde",
"492689", "Dierdorf",
"498574", "Wittibreut",
"498403", "Pförring",
"495953", "Börger",
"49375", "Zwickau",
"4936042", "Tonna",
"4933636", "Steinhöfel\ Kreis\ Oder\-Spree",
"492137", "Neuss\-Norf",
"4936423", "Orlamünde",
"492401", "Baesweiler",
"4938353", "Gützkow\ bei\ Greifswald",
"4934956", "Zörbig",
"495086", "Celle\-Scheuen",
"4936379", "Holzengel",
"4938756", "Grabow",
"494928", "Ihlow\-Riepe",
"4937757", "Rittersgrün",
"495072", "Neustadt\-Mandelsloh",
"497621", "Lörrach",
"499273", "Bad\ Berneck\ im\ Fichtelgebirge",
"495922", "Bad\ Bentheim",
"498426", "Walting\ Kreis\ Eichstätt",
"498259", "Schiltberg",
"494922", "Borkum",
"496054", "Birstein",
"496361", "Rockenhausen",
"496151", "Darmstadt",
"498284", "Ziemetshausen",
"495771", "Rahden\ Westfalen",
"492327", "Bochum\-Wattenscheid",
"497572", "Mengen\ Württemberg",
"497660", "St\ Peter\ Schwarzwald",
"4936691", "Eisenberg\ Thüringen",
"497586", "Herbertingen",
"494771", "Hemmoor",
"4937437", "Bad\ Elster",
"497578", "Wald\ Hohenz",
"499245", "Obertrubach",
"493525", "Riesa",
"499941", "Kötzting",
"499847", "Ergersheim",
"498065", "Tuntenhausen\-Schönau",
"4939083", "Messdorf",
"492654", "Polch",
"497461", "Tuttlingen",
"499634", "Wiesau",
"498509", "Ruderting",
"492434", "Wegberg",
"496130", "Schwabenheim\ an\ der\ Selz",
"4989", "Munich",
"499454", "Aufhausen\ Oberpfalz",
"498666", "Teisendorf",
"4938791", "Bad\ Wilsnack",
"496736", "Bechenheim",
"4935876", "Weissenberg\ Sachsen",
"492735", "Neunkirchen\ Siegerl",
"4938320", "Tribsees",
"498031", "Rosenheim\ Oberbayern",
"498134", "Odelzhausen",
"499972", "Waldmünchen",
"497322", "Giengen\ an\ der\ Brenz",
"496584", "Wellen\ Mosel",
"494748", "Stubben\ bei\ Bremerhaven",
"4936945", "Henneberg",
"4939208", "Loitsche",
"496453", "Gemünden\ Wohra",
"4936969", "Merkers",
"497056", "Gechingen",
"497541", "Friedrichshafen",
"497328", "Königsbronn",
"495447", "Lembruch",
"499356", "Burgsinn",
"499302", "Rottendorf\ Unterfranken",
"4936652", "Wurzbach",
"493375", "Königs\ Wusterhausen",
"499978", "Schönthal\ Oberpfalz",
"499166", "Münchsteinach",
"494223", "Ganderkesee\-Bookholzberg",
"4933632", "Hangelsberg",
"495742", "Preussisch\ Oldendorf",
"4938203", "Bad\ Doberan",
"496633", "Homberg\ Ohm",
"495223", "Bünde",
"492336", "Schwelm",
"494742", "Dorum",
"494447", "Vechta\-Langförden",
"496335", "Trulben",
"492761", "Olpe\ Biggesee",
"4938752", "Zierzow\ bei\ Ludwigslust",
"496727", "Gensingen",
"496422", "Kirchhain",
"4933478", "Gross\ Neuendorf",
"4939031", "Dähre",
"493863", "Crivitz",
"495258", "Salzkotten",
"494258", "Schwarme",
"496209", "Mörlenbach",
"497655", "Feldberg\-Altglashütten",
"497353", "Schwendi",
"497163", "Ebersbach\ an\ der\ Fils",
"498394", "Lautrach",
"495854", "Bleckede\-Barskamp",
"496195", "Kelkheim\ Taunus",
"4933731", "Trebbin",
"495252", "Bad\ Lippspringe",
"495206", "Bielefeld\-Jöllenbeck",
"497734", "Gailingen",
"496428", "Stadtallendorf",
"492196", "Wermelskirchen",
"497435", "Albstadt\-Laufen",
"4936450", "Kranichfeld",
"494206", "Stuhr\-Heiligenrode",
"494252", "Bruchhausen\-Vilsen",
"494854", "Friedrichskoog",
"4936730", "Sitzendorf",
"493838", "Bergen\ auf\ Rügen",
"4933451", "Heckelberg",
"4933767", "Friedersdorf\ bei\ Berlin",
"497138", "Schwaigern",
"4939050", "Bartensleben",
"496872", "Losheim\ am\ See",
"496274", "Waldbrunn\ Odenwald",
"497132", "Neckarsulm",
"498324", "Hindelang",
"495502", "Dransfeld",
"495556", "Lindau\ Harz",
"494293", "Ottersberg\-Fischerhude",
"495293", "Paderborn\-Dahl",
"498732", "Frontenhausen",
"492103", "Hilden",
"494502", "Lübeck\-Travemünde",
"494556", "Ahrensbök\-Gnissau",
"4939604", "Wildberg\ bei\ Altentreptow",
"499092", "Wemding",
"4934774", "Röblingen\ am\ See",
"495508", "Gleichen\-Rittmarshausen",
"494144", "Himmelpforten",
"497392", "Laupheim",
"499721", "Schweinfurt",
"4935872", "Neusalza\-Spremberg",
"496668", "Birstein\-Lichenroth",
"496559", "Leidenborn",
"498657", "Ramsau\ bei\ Berchtesgaden",
"495144", "Wathlingen",
"494508", "Krummesse",
"495041", "Springe\ Deister",
"497226", "Bühl\-Sand",
"4939325", "Vinzelberg",
"4938302", "Sagard",
"4933923", "Flecken\ Zechlin",
"497967", "Jagstzell",
"492238", "Pulheim",
"497459", "Nagold\-Hochdorf",
"496047", "Altenstadt\ Hessen",
"499206", "Mistelgau\-Obernsees",
"499252", "Helmbrechts",
"4933983", "Gross\ Pankow\ Kreis\ Prignitz",
"495053", "Fassberg\-Müden",
"4935827", "Nieder\-Seifersdorf",
"499854", "Wittelshofen",
"49391", "Magdeburg",
"4935451", "Dahme\ Brandenburg",
"492232", "Brühl\ Rheinland",
"492834", "Straelen",
"493981", "Neustrelitz",
"499748", "Motten",
"4933872", "Hohennauen",
"495308", "Lehre",
"494972", "Langeoog",
"496359", "Grünstadt",
"494308", "Schwedeneck",
"495028", "Pennigsehl",
"4936024", "Diedorf\ bei\ Mühlhausen",
"492647", "Kesseling",
"497203", "Walzbachtal",
"494791", "Osterholz\-Scharmbeck",
"4935322", "Doberlug\-Kirchhain",
"499742", "Kalbach\ Rhön",
"4934692", "Alsleben\ Saale",
"495166", "Walsrode\-Kirchboitzen",
"495978", "Hörstel\-Dreierwalde",
"499447", "Essing",
"495302", "Vechelde",
"495356", "Helmstedt\-Barmke",
"494166", "Ahlerstedt",
"4934364", "Wermsdorf",
"4936084", "Heuthen",
"495022", "Wietzen",
"494356", "Gross\ Wittensee",
"494302", "Kirchbarkau",
"497671", "Todtnau",
"499223", "Rugendorf",
"4939833", "Mirow\ Kreis\ Neustrelitz",
"4937343", "Jöhstadt",
"497528", "Neukirch\ bei\ Tettnang",
"4939424", "Schwanebeck\ Sachsen\-Anhalt",
"499502", "Frensdorf",
"499556", "Geiselwind",
"496535", "Osann\-Monzel",
"499293", "Berg\ Oberfranken",
"492536", "Münster\-Albachten",
"492801", "Xanten",
"4937295", "Lugau\ Erzgebirge",
"496384", "Konken",
"498261", "Mindelheim",
"492377", "Wickede\ Ruhr",
"495721", "Stadthagen",
"4939484", "Harzgerode",
"497522", "Wangen\ im\ Allgäu",
"499144", "Pleinfeld",
"494721", "Cuxhaven",
"496441", "Wetzlar",
"493726", "Flöha",
"492263", "Engelskirchen",
"4935478", "Goyatz",
"498803", "Peissenberg",
"497484", "Simmersfeld",
"497553", "Salem\ Baden",
"4936647", "Saalburg\ Thüringen",
"4934465", "Bad\ Bibra",
"4935439", "Zinnitz",
"497454", "Sulz\ am\ Neckar",
"496627", "Nentershausen\ Hessen",
"4938228", "Dettmannsdorf\-Kölzow",
"492661", "Bad\ Marienberg\ Westerwald",
"494835", "Albersdorf\ Holstein",
"495237", "Augustdorf",
"495835", "Wahrenholz",
"494237", "Bendingbostel",
"497583", "Bad\ Schussenried",
"497755", "Weilheim\ Kreis\ Waldshut",
"497634", "Sulzburg",
"492839", "Straelen\-Herongen",
"4938334", "Grammendorf",
"4938466", "Jürgenshagen",
"4937467", "Klingenthal\ Sachsen",
"4939223", "Theessen",
"4934741", "Frose",
"4933635", "Arensdorf\ Kreis\ Oder\-Spree",
"499461", "Roding",
"495648", "Brakel\-Gehrden",
"4934955", "Gossa",
"496061", "Michelstadt",
"496164", "Reichelsheim\ Odenwald",
"492307", "Kamen",
"4933833", "Wollin\ bei\ Brandenburg",
"497941", "Öhringen",
"497245", "Durmersheim",
"4938755", "Eldena",
"493773", "Johanngeorgenstadt",
"495642", "Warburg\-Scherfede",
"492871", "Bocholt",
"4935208", "Radeburg",
"4934297", "Liebertwolkwitz",
"492977", "Schmallenberg\-Bödefeld",
"498365", "Wertach",
"498663", "Ruhpolding",
"494642", "Kappeln\ Schlei",
"499572", "Burgkunstadt",
"496733", "Gau\-Odernheim",
"4935937", "Prischwitz",
"494372", "Westfehmarn",
"4936784", "Stützerbach",
"4938797", "Karstädt\ Kreis\ Prignitz",
"496467", "Hatzfeld\ Eder",
"496020", "Heigenbrücken",
"493745", "Falkenstein\ Vogtland",
"492421", "Düren",
"495908", "Wietmarschen\-Lohne",
"498458", "Gaimersheim",
"495372", "Meinersen",
"496762", "Kastellaun",
"499621", "Amberg\ Oberpfalz",
"494956", "Uplengen",
"494902", "Jemgum\-Ditzum",
"4935604", "Krieschow",
"499149", "Weissenburg\-Suffersheim",
"497273", "Hagenbach\ Pfalz",
"495956", "Rastdorf",
"498638", "Waldkraiburg",
"495902", "Freren",
"498452", "Geisenfeld",
"498406", "Böhmfeld",
"495378", "Sassenburg\-Platendorf",
"495083", "Hohne\ bei\ Celle",
"499282", "Naila",
"4939923", "Priborn",
"499276", "Bischofsgrün",
"492620", "Neuhäusel\ Westerwald",
"4937431", "Mehltheuer\ Vogtland",
"497367", "Aalen\-Ebnat",
"497157", "Waldenbuch",
"498423", "Titting",
"499420", "Feldkirchen\ Niederbayern",
"49331", "Potsdam",
"498845", "Bad\ Kohlgrub",
"499288", "Bad\ Steben",
"496697", "Willingshausen",
"493381", "Brandenburg\ an\ der\ Havel",
"498247", "Bad\ Wörishofen",
"4935875", "Obercunnersdorf\ bei\ Löbau",
"493943", "Wernigerode",
"4933604", "Lebus",
"499648", "Neustadt\ am\ Kulm",
"495691", "Bad\ Arolsen",
"498687", "Taching\-Tengling",
"496589", "Kell\ am\ See",
"492747", "Molzhain",
"4939322", "Tangermünde",
"493466", "Artern\ Unstrut",
"4938305", "Gingst",
"498139", "Röhrmoos",
"492173", "Langenfeld\ Rheinland",
"496500", "Waldrach",
"499642", "Kemnath\ Stadt",
"495586", "Wieda",
"495572", "Bodenfelde",
"4933237", "Paulinenaue",
"4933673", "Weichensdorf",
"497771", "Stockach",
"4939382", "Kamern",
"492448", "Hellenthal\-Rescheid",
"4936257", "Luisenthal\ Thüringen",
"496856", "St\ Wendel\-Niederkirchen",
"496802", "Völklingen\-Lauterbach",
"493581", "Görlitz",
"49351", "Dresden",
"492855", "Voerde\ Niederrhein",
"4939451", "Wasserleben",
"496204", "Viernheim",
"498171", "Wolfratshausen",
"4936739", "Rottenbach",
"4939827", "Schwarz\ bei\ Neustrelitz",
"498074", "Schnaitsee",
"492257", "Reckerscheid",
"499835", "Ehingen\ Mittelfranken",
"4935385", "Annaburg",
"4933875", "Rhinow",
"494859", "Windbergen",
"4937368", "Deutschneudorf",
"494461", "Jever",
"495461", "Bramsche\ Hase",
"497739", "Hilzingen",
"4939887", "Gerswalde",
"497567", "Leutkirch\-Friesenhofen",
"495859", "Thomasburg",
"4935325", "Rückersdorf\ bei\ Finsterwalde",
"4939059", "Wegenstedt",
"495282", "Schieder\-Schwalenberg",
"494276", "Borstel\ bei\ Sulingen",
"497953", "Blaufelden",
"499083", "Möttingen",
"494884", "Schwabstedt",
"494282", "Sittensen",
"495276", "Marienmünster",
"4936459", "Blankenhain\ Thüringen",
"495067", "Bockenem",
"4933439", "Fredersdorf\-Vogelsdorf",
"497383", "Münsingen\-Buttenhausen",
"494288", "Horstedt\ Kreis\ Rotenburg",
"497685", "Gutach\-Bleibach",
"4937292", "Oederan",
"4933208", "Fahrland",
"499386", "Prosselsheim",
"499372", "Klingenberg\ am\ Main",
"499908", "Schöfweg",
"496146", "Hochheim\ am\ Main",
"498565", "Dietersburg\-Baumgarten",
"493603", "Bad\ Langensalza",
"495149", "Wienhausen",
"496554", "Waxweiler",
"4934462", "Laucha\ Unstrut",
"495621", "Bad\ Wildungen",
"496231", "Hochdorf\-Assenheim",
"497072", "Gomaringen",
"499378", "Eichenbühl\-Riedern",
"494621", "Schleswig",
"499956", "Eichendorf\-Aufhausen",
"492507", "Havixbeck",
"496483", "Selters\ Taunus",
"494149", "Fredenbeck",
"495622", "Fritzlar",
"4935820", "Zodel",
"496232", "Speyer",
"497071", "Tübingen",
"497174", "Mögglingen",
"496834", "Bous",
"493494", "Wolfen",
"493874", "Ludwigslust",
"4934497", "Langenleuba\-Niederhain",
"4933338", "Stolpe\/Oder",
"499901", "Hengersberg\ Bayern",
"494622", "Taarstedt",
"499205", "Vorbach",
"496238", "Dirmstein",
"499199", "Kunreuth",
"499371", "Miltenberg",
"497225", "Gaggenau",
"4938488", "Demen",
"494355", "Rieseby",
"494165", "Hollenstedt\ Nordheide",
"495355", "Frellstedt",
"4937344", "Crottendorf\ Sachsen",
"495165", "Rethem\ Aller",
"4939423", "Wegeleben",
"495653", "Sontra",
"492359", "Kierspe",
"49355", "Cottbus",
"494433", "Dötlingen",
"49521", "Bielefeld",
"498774", "Bayerbach\ bei\ Ergoldsbach",
"495281", "Bad\ Pyrmont",
"498549", "Vilshofen\-Pleinting",
"496647", "Herbstein\-Stockhausen",
"4938428", "Hohenkirchen\ bei\ Wismar",
"499339", "Ippesheim",
"4939483", "Ballenstedt",
"4933742", "Oehna\ Brandenburg",
"494281", "Zeven",
"495433", "Badbergen",
"49421", "Bremen",
"4935939", "Hochkirch",
"498709", "Eching\ Niederbayern",
"494462", "Wittmund",
"498443", "Hohenwart\ Paar",
"498825", "Krün",
"494767", "Bremervörde\-Bevern",
"493337", "Biesenthal\ Brandenburg",
"493588", "Niesky",
"4936023", "Horsmar",
"4934299", "Gaschwitz",
"494539", "Westerau",
"492384", "Welver",
"495767", "Warmsen",
"495462", "Ankum",
"498178", "Icking",
"494468", "Friedeburg\-Reepsholt",
"492535", "Sendenhorst\-Albersloh",
"4936083", "Uder",
"4934363", "Cavertitz",
"496536", "Kleinich",
"492954", "Rüthen\-Oestereiden",
"499555", "Schlüsselfeld\-Aschbach",
"493576", "Weisswasser",
"495468", "Bramsche\-Engter",
"499641", "Grafenwöhr",
"4936371", "Schlossvippach",
"499129", "Wendelstein",
"495571", "Uslar",
"4936640", "Remptendorf",
"4933924", "Rägelin",
"497477", "Jungingen\ bei\ Hechingen",
"4935795", "Königsbrück",
"496263", "Neckargerach",
"495692", "Wolfhagen",
"4938372", "Usedom",
"4935246", "Ziegenhain\ Sachsen",
"493725", "Zschopau",
"492441", "Kall",
"4933984", "Blumenthal\ bei\ Pritzwalk",
"4939603", "Burg\ Stargard",
"496336", "Dellfeld",
"493382", "Lehnin",
"492633", "Brohl\-Lützing",
"492335", "Wetter\ Ruhr",
"499653", "Eslarn",
"498650", "Marktschellenberg",
"499165", "Sugenheim",
"4939978", "Gross\ Roge",
"499355", "Frammersbach",
"492453", "Heinsberg\-Randerath",
"499281", "Hof\ Saale",
"493537", "Jessen\ Elster",
"497055", "Neuweiler\ Kreis\ Calw",
"494339", "Christiansholm",
"4938327", "Elmenhorst\ Vorpom",
"49921", "Bayreuth",
"4937326", "Frauenstein\ Sachsen",
"499433", "Nabburg",
"495339", "Gielde",
"498679", "Burgkirchen\ an\ der\ Alz",
"4934773", "Schwittersdorf",
"492584", "Warendorf\-Milte",
"496033", "Butzbach",
"495807", "Altenmedingen",
"494205", "Ottersberg",
"499622", "Hirschau\ Oberpfalz",
"497436", "Messstetten\-Oberdigisheim",
"492195", "Radevormwald",
"495205", "Bielefeld\-Sennestadt",
"495901", "Fürstenau\ bei\ Bramsche",
"4933437", "Reichenberg\ bei\ Strausberg",
"496196", "Bad\ Soden\ am\ Taunus",
"4934659", "Blankenheim\ bei\ Sangerhausen",
"492428", "Niederzier",
"4936761", "Heubisch",
"498869", "Kinsau",
"495199", "Schneverdingen\-Heber",
"4938822", "Diedrichshagen\ bei\ Grevesmühlen",
"493923", "Zerbst",
"497656", "Schluchsee",
"4939996", "Törpin",
"494371", "Burg\ auf\ Fehmarn",
"499628", "Ursensollen",
"495371", "Gifhorn",
"498631", "Mühldorf\ am\ Inn",
"496761", "Simmern\ Hunsrück",
"492422", "Kreuzau",
"492872", "Rhede\ Westfalen",
"4939057", "Rätzlingen\ Sachsen\-Anhalt",
"4934262", "Falkenhain\ bei\ Wurzen",
"4936848", "Wernshausen",
"495129", "Söhlde",
"496068", "Beerfelden",
"4939296", "Welsleben",
"496287", "Limbach\ Baden",
"4939889", "Boitzenburg",
"495641", "Warburg",
"492274", "Elsdorf\ Rheinland",
"498057", "Aschau\-Sachrang",
"494641", "Süderbrarup",
"499571", "Lichtenfels\ Bayern",
"497948", "Öhringen\-Ohrnberg",
"494129", "Haseldorf",
"496062", "Erbach\ Odenwald",
"4939829", "Blankenförde",
"4936737", "Drognitz",
"497942", "Neuenstein\ Württemberg",
"4933760", "Münchehofe\ Kreis\ Dahme\-Spreewald",
"4939745", "Hetzdorf\ bei\ Strasburg",
"496126", "Idstein",
"4936259", "Tabarz\ Thüringer\ Wald",
"498349", "Stötten\ am\ Auerberg",
"4939951", "Faulenrost",
"4933239", "Gross\ Behnitz",
"49335", "Frankfurt\ \(Oder\)",
"499462", "Falkenstein\ Oberpfalz",
"496103", "Langen\ Hessen",
"494555", "Seedorf\ bei\ Bad\ Segeberg",
"492662", "Hachenburg",
"494934", "Marienhafe",
"497269", "Sulzfeld\ Baden",
"4938204", "Broderstorf",
"495934", "Haren\-Rütenbrock",
"499468", "Zell\ Oberpfalz",
"495555", "Moringen\-Fredelsloh",
"494753", "Balje",
"495585", "Herzberg\-Sieber",
"495753", "Auetal\-Bernsen",
"496173", "Kronberg\ im\ Taunus",
"497833", "Hornberg\ Schwarzwaldbahn",
"4933230", "Börnicke\ Kreis\ Havelland",
"49395", "Neubrandenburg",
"496747", "Emmelshausen",
"495334", "Hornburg\ Kreis\ Wolfenbüttel",
"496442", "Braunfels",
"494334", "Bredenbek\ bei\ Rendsburg",
"493764", "Meerane",
"495060", "Bodenburg",
"495427", "Melle\-Buer",
"497348", "Beimerstetten",
"4934348", "Frohburg",
"49760", "Oberried\ Breisgau",
"495722", "Bückeburg",
"498262", "Mittelneufnach",
"494243", "Twistringen",
"494722", "Cuxhaven\-Altenbruch",
"493695", "Bad\ Salzungen",
"496257", "Seeheim\-Jugenheim",
"494194", "Sievershütten",
"4933769", "Töpchin",
"499836", "Gunzenhausen\-Cronheim",
"498268", "Tussenhausen",
"4933745", "Petkus",
"4939408", "Hadmersleben",
"492856", "Hamminkeln\-Brünen",
"492802", "Alpen",
"4939820", "Triepkendorf",
"492204", "Bensberg",
"496855", "Freisen",
"495194", "Bispingen",
"4935691", "Bärenklau\ NL",
"495301", "Lehre\-Essenrode",
"494124", "Glückstadt",
"4934321", "Leisnig",
"499741", "Bad\ Brückenau",
"4939246", "Lindau\ Anh",
"495021", "Nienburg\ Weser",
"497672", "St\ Blasien",
"495275", "Höxter\-Ottbergen",
"494877", "Hennstedt\ bei\ Itzehoe",
"495971", "Rheine",
"4934381", "Colditz",
"498233", "Kissing",
"49841", "Ingolstadt\ Donau",
"494792", "Worpswede",
"494497", "Barssel\-Harkebrügge",
"494275", "Ehrenburg",
"494971", "Esens",
"4935792", "Ossling",
"494667", "Dagebüll",
"499534", "Burgpreppach",
"4933978", "Segeletz",
"499955", "Mamming",
"493976", "Torgelow\ bei\ Ueckermünde",
"499251", "Münchberg",
"497085", "Enzklösterle",
"496507", "Neumagen\-Dhron",
"4933603", "Falkenhagen\ bei\ Seelow",
"492554", "Laer\ Kreis\ Steinfurt",
"4938232", "Zingst\ Ostseebad",
"498344", "Westendorf\ bei\ Kaufbeuren",
"492935", "Sundern\-Hachen",
"4933674", "Trebatsch",
"496145", "Flörsheim\ am\ Main",
"4936967", "Geisa",
"495939", "Sustrum",
"493306", "Gransee",
"499385", "Kolitzheim",
"4938375", "Koserow",
"497264", "Bad\ Rappenau",
"494939", "Baltrum",
"499683", "Friedenfels",
"497708", "Geisingen\-Leipferdingen",
"499722", "Werneck",
"497391", "Ehingen\ Donau",
"499427", "Leiblfing",
"4936649", "Gefell\ bei\ Schleiz",
"498063", "Feldkirchen\-Westerham",
"4939924", "Stuer",
"495042", "Bad\ Münder\ am\ Deister",
"4938456", "Langhagen\ bei\ Güstrow",
"499243", "Pottenstein",
"493523", "Coswig\ bei\ Dresden",
"499728", "Wülfershausen\ Unterfranken",
"497702", "Blumberg\ Baden",
"495836", "Wittingen\-Radenbeck",
"494836", "Hennstedt\ Dithmarschen",
"494501", "Kastorf\ Holstein",
"497150", "Korntal\-Münchingen",
"499194", "Ebermannstadt",
"499091", "Monheim\ Schwaben",
"496661", "Schlüchtern",
"492627", "Braubach",
"498731", "Dingolfing",
"492984", "Hallenberg",
"493831", "Stralsund",
"498366", "Oy\-Mittelberg",
"498102", "Höhenkirchen\-Siegertsbrunn",
"492733", "Hilchenbach",
"497131", "Heilbronn\ Neckar",
"497034", "Ehningen",
"4935930", "Seitschen",
"493937", "Osterburg\ Altmark",
"496871", "Wadern",
"4936783", "Gehren\ Thüringen",
"497246", "Malsch\ Kreis\ Karlsruhe",
"496307", "Schopp",
"499334", "Giebelstadt",
"498544", "Eging\ am\ See",
"496027", "Stockstadt\ am\ Main",
"4935603", "Burg\ Spreewald",
"492164", "Jüchen\-Otzenrath",
"492354", "Meinerzhagen",
"4938825", "Klütz",
"498405", "Stammham\ bei\ Ingolstadt",
"495251", "Paderborn",
"495955", "Esterwegen",
"492389", "Werne",
"495534", "Eschershausen\ an\ der\ Lenne",
"4933834", "Pritzerbe",
"4933656", "Bahro",
"494534", "Steinburg\ Kreis\ Storman",
"494251", "Hoya",
"498704", "Altdorf\-Pfettrach",
"494955", "Westoverledingen",
"496421", "Marburg",
"4939742", "Brüssow\ bei\ Pasewalk",
"494385", "Hohenfelde\ bei\ Kiel",
"494683", "Oldsum",
"492762", "Wenden\ Südsauerland",
"4935951", "Neukirch\ Lausitz",
"495683", "Wabern\ Hessen",
"495741", "Lübbecke",
"497542", "Tettnang",
"498038", "Vogtareuth",
"4935829", "Gersdorf\ bei\ Görlitz",
"498846", "Uffing\ am\ Staffelsee",
"492697", "Blankenheim\-Ahrhütte",
"494741", "Nordholz\ bei\ Bremerhaven",
"496620", "Philippsthal\ Werra",
"4938736", "Goldberg",
"499971", "Cham",
"498032", "Rohrdorf\ Kreis\ Rosenheim",
"499275", "Speichersdorf",
"4939224", "Büden",
"499497", "Seubersdorf\ in\ der\ Oberpfalz",
"497321", "Heidenheim\ an\ der\ Brenz",
"494230", "Verden\-Walle",
"4935057", "Hermsdorf\ Erzgebirge",
"4938333", "Horst\ bei\ Grimmen",};
$areanames{de} = {"499636", "Plößberg",
"4935952", "Großröhrsdorf\ OL",
"49911", "Nürnberg",
"492203", "Köln\-Porz",
"494684", "Langeneß\ Hallig",
"4935240", "Tauscha\ bei\ Großenhain",
"496321", "Neustadt\ an\ der\ Weinstraße",
"498170", "Straßlach\-Dingharting",
"492339", "Sprockhövel\-Haßlinghausen",
"496252", "Heppenheim\ Bergstraße",
"495384", "Seesen\-Groß\ Rhüden",
"49221", "Köln",
"4934445", "Stößen",
"494483", "Ovelgönne\-Großenmeer",
"4936949", "Obermaßfeld\-Grimmenthal",
"498633", "Tüßling",
"4936705", "Oberweißbach\ Thüringer\ Wald",
"496663", "Steinau\ an\ der\ Straße",
"497162", "Süßen",
"4934901", "Roßlau\ Elbe",
"4939883", "Groß\ Dölln",
"4935753", "Großräschen",
"4934493", "Gößnitz\ Thüringen",
"498536", "Kößlarn",
"4936072", "Weißenborn\-Lüderode",
"497351", "Biberach\ an\ der\ Riß",
"499242", "Gößweinstein",
"4939934", "Groß\ Plasten",
"495064", "Groß\ Düngen",
"4939976", "Groß\ Bützin",
"4935248", "Schönfeld\ bei\ Großenhain",
"499141", "Weißenburg\ in\ Bayern",
"494509", "Groß\ Grönau",
"498367", "Roßhaupten\ Forggensee",
"493647", "Pößneck",
"4935938", "Großpostwitz\ OL",
"4935841", "Großschönau\ Sachsen",
"4935726", "Groß\ Särchen",
"498807", "Dießen\ am\ Ammersee",
"496364", "Nußbach\ Pfalz",
"4938234", "Born\ Darß",
"494497", "Barßel\-Harkebrügge",
"495053", "Faßberg\-Müden",
"4989", "München",
"499567", "Seßlach\-Gemünda",
"4936484", "Knau\ bei\ Pößneck",
"499656", "Moosbach\ bei\ Vohenstrauß",
"495827", "Unterlüß",
"497355", "Hochdorf\ Riß",};
my $timezones = {
               '' => [
                       'Europe/Berlin'
                     ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+49|\D)//g;
      my $self = bless({ country_code => '49', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '49', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;