/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DropStatementNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;

public class DropSchemaNode
extends DropStatementNode {
    private int dropBehavior;
    private String schemaName;

    public void init(Object object, Object object2) throws StandardException {
        this.initAndCheck(null);
        this.schemaName = (String)object;
        this.dropBehavior = (Integer)object2;
    }

    public QueryTreeNode bind() throws StandardException {
        LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext();
        if (this.getDataDictionary().isSystemSchemaName(this.schemaName)) {
            throw StandardException.newException("42Y67", this.schemaName);
        }
        return this;
    }

    public String toString() {
        return "";
    }

    public String statementToString() {
        return "DROP SCHEMA";
    }

    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getDropSchemaConstantAction(this.schemaName);
    }
}

