use 5.16.0;
use strict;
use warnings;

package REST::Cot::Generators;
use Email::MIME::ContentType;
use JSON;
use Carp qw[confess];
use namespace::clean;

sub progenitor {
    my $self = shift;
    return sub {
        return $self unless $self->{parent};
        return $self->{parent}->{progenitor}->();
    };
}

sub path {
    my $self = shift;
    return sub {
        state $path;
        return undef unless ref($self->{progenitor}->());
        return $path if $path;

        $path = @{ $self->{args} }?
        join ( '/', $self->{parent}
                        ->{path}
                        ->(),
                    @{ $self->{args} },
                    $self->{name}
        ) :
        join ( '/', $self->{parent}
                        ->{path}
                        ->(),
                        $self->{name}
        );

        return $path;
    };
}

sub method {
    my $self = shift;
    return sub {
        my $method = shift;
        my $self = shift;
        my $response = $self->{client}->$method( "$self", @_? \@_ : undef );

        if (my $content_type = $response->responseHeader('Content-Type')) {
          $content_type = parse_content_type($content_type);
          my $body = $response->responseContent;
          my $code = $response->responseCode;
          my $type = $content_type->{type};
          my $subtype = $content_type->{subtype};

          if ($type eq 'application') {
            my $decoded = $body;

            $decoded = from_json($body)
              if ($subtype eq 'json');

            $decoded = $response->responseXpath
              if ($subtype eq 'xml'); 

            return !wantarray? $decoded : ($decoded, $code, $response);
          } else {
              return $response;
          }

        } else {
          confess('Response Content-Type header missing')
        }
    }
}

no namespace::clean;
1;

__END__

=pod

=encoding UTF-8

=head1 NAME

REST::Cot::Generators

=head1 VERSION

version 0.001_1

=head1 AUTHOR

Jason Mills <jmmills@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Jason Mills.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
