package CSAF::Util::CWE;

use 5.010001;
use strict;
use warnings;
use utf8;

use Exporter 'import';
our @EXPORT_OK = (qw[get_weakness_name weakness_exists]);

use constant WEAKNESSES => (

    # WEAKNESS
    'CWE-5'  => q"J2EE Misconfiguration: Data Transmission Without Encryption",
    'CWE-6'  => q"J2EE Misconfiguration: Insufficient Session-ID Length",
    'CWE-7'  => q"J2EE Misconfiguration: Missing Custom Error Page",
    'CWE-8'  => q"J2EE Misconfiguration: Entity Bean Declared Remote",
    'CWE-9'  => q"J2EE Misconfiguration: Weak Access Permissions for EJB Methods",
    'CWE-11' => q"ASP.NET Misconfiguration: Creating Debug Binary",
    'CWE-12' => q"ASP.NET Misconfiguration: Missing Custom Error Page",
    'CWE-13' => q"ASP.NET Misconfiguration: Password in Configuration File",
    'CWE-14' => q"Compiler Removal of Code to Clear Buffers",
    'CWE-15' => q"External Control of System or Configuration Setting",
    'CWE-20' => q"Improper Input Validation",
    'CWE-22' => q"Improper Limitation of a Pathname to a Restricted Directory ('Path Traversal')",
    'CWE-23' => q"Relative Path Traversal",
    'CWE-24' => q"Path Traversal: '../filedir'",
    'CWE-25' => q"Path Traversal: '/../filedir'",
    'CWE-26' => q"Path Traversal: '/dir/../filename'",
    'CWE-27' => q"Path Traversal: 'dir/../../filename'",
    'CWE-28' => q"Path Traversal: '..\filedir'",
    'CWE-29' => q"Path Traversal: '\..\filename'",
    'CWE-30' => q"Path Traversal: '\dir\..\filename'",
    'CWE-31' => q"Path Traversal: 'dir\..\..\filename'",
    'CWE-32' => q"Path Traversal: '...' (Triple Dot)",
    'CWE-33' => q"Path Traversal: '....' (Multiple Dot)",
    'CWE-34' => q"Path Traversal: '....//'",
    'CWE-35' => q"Path Traversal: '.../...//'",
    'CWE-36' => q"Absolute Path Traversal",
    'CWE-37' => q"Path Traversal: '/absolute/pathname/here'",
    'CWE-38' => q"Path Traversal: '\absolute\pathname\here'",
    'CWE-39' => q"Path Traversal: 'C:dirname'",
    'CWE-40' => q"Path Traversal: '\\UNC\share\name\' (Windows UNC Share)",
    'CWE-41' => q"Improper Resolution of Path Equivalence",
    'CWE-42' => q"Path Equivalence: 'filename.' (Trailing Dot)",
    'CWE-43' => q"Path Equivalence: 'filename....' (Multiple Trailing Dot)",
    'CWE-44' => q"Path Equivalence: 'file.name' (Internal Dot)",
    'CWE-45' => q"Path Equivalence: 'file...name' (Multiple Internal Dot)",
    'CWE-46' => q"Path Equivalence: 'filename ' (Trailing Space)",
    'CWE-47' => q"Path Equivalence: ' filename' (Leading Space)",
    'CWE-48' => q"Path Equivalence: 'file name' (Internal Whitespace)",
    'CWE-49' => q"Path Equivalence: 'filename/' (Trailing Slash)",
    'CWE-50' => q"Path Equivalence: '//multiple/leading/slash'",
    'CWE-51' => q"Path Equivalence: '/multiple//internal/slash'",
    'CWE-52' => q"Path Equivalence: '/multiple/trailing/slash//'",
    'CWE-53' => q"Path Equivalence: '\multiple\\internal\backslash'",
    'CWE-54' => q"Path Equivalence: 'filedir\' (Trailing Backslash)",
    'CWE-55' => q"Path Equivalence: '/./' (Single Dot Directory)",
    'CWE-56' => q"Path Equivalence: 'filedir*' (Wildcard)",
    'CWE-57' => q"Path Equivalence: 'fakedir/../realdir/filename'",
    'CWE-58' => q"Path Equivalence: Windows 8.3 Filename",
    'CWE-59' => q"Improper Link Resolution Before File Access ('Link Following')",
    'CWE-61' => q"UNIX Symbolic Link (Symlink) Following",
    'CWE-62' => q"UNIX Hard Link",
    'CWE-64' => q"Windows Shortcut Following (.LNK)",
    'CWE-65' => q"Windows Hard Link",
    'CWE-66' => q"Improper Handling of File Names that Identify Virtual Resources",
    'CWE-67' => q"Improper Handling of Windows Device Names",
    'CWE-69' => q"Improper Handling of Windows ::DATA Alternate Data Stream",
    'CWE-71' => q"DEPRECATED: Apple '.DS_Store'",
    'CWE-72' => q"Improper Handling of Apple HFS+ Alternate Data Stream Path",
    'CWE-73' => q"External Control of File Name or Path",
    'CWE-74' => q"Improper Neutralization of Special Elements in Output Used by a Downstream Component ('Injection')",
    'CWE-75' => q"Failure to Sanitize Special Elements into a Different Plane (Special Element Injection)",
    'CWE-76' => q"Improper Neutralization of Equivalent Special Elements",
    'CWE-77' => q"Improper Neutralization of Special Elements used in a Command ('Command Injection')",
    'CWE-78' => q"Improper Neutralization of Special Elements used in an OS Command ('OS Command Injection')",
    'CWE-79' => q"Improper Neutralization of Input During Web Page Generation ('Cross-site Scripting')",
    'CWE-80' => q"Improper Neutralization of Script-Related HTML Tags in a Web Page (Basic XSS)",
    'CWE-81' => q"Improper Neutralization of Script in an Error Message Web Page",
    'CWE-82' => q"Improper Neutralization of Script in Attributes of IMG Tags in a Web Page",
    'CWE-83' => q"Improper Neutralization of Script in Attributes in a Web Page",
    'CWE-84' => q"Improper Neutralization of Encoded URI Schemes in a Web Page",
    'CWE-85' => q"Doubled Character XSS Manipulations",
    'CWE-86' => q"Improper Neutralization of Invalid Characters in Identifiers in Web Pages",
    'CWE-87' => q"Improper Neutralization of Alternate XSS Syntax",
    'CWE-88' => q"Improper Neutralization of Argument Delimiters in a Command ('Argument Injection')",
    'CWE-89' => q"Improper Neutralization of Special Elements used in an SQL Command ('SQL Injection')",
    'CWE-90' => q"Improper Neutralization of Special Elements used in an LDAP Query ('LDAP Injection')",
    'CWE-91' => q"XML Injection (aka Blind XPath Injection)",
    'CWE-92' => q"DEPRECATED: Improper Sanitization of Custom Special Characters",
    'CWE-93' => q"Improper Neutralization of CRLF Sequences ('CRLF Injection')",
    'CWE-94' => q"Improper Control of Generation of Code ('Code Injection')",
    'CWE-95' => q"Improper Neutralization of Directives in Dynamically Evaluated Code ('Eval Injection')",
    'CWE-96' => q"Improper Neutralization of Directives in Statically Saved Code ('Static Code Injection')",
    'CWE-97' => q"Improper Neutralization of Server-Side Includes (SSI) Within a Web Page",
    'CWE-98' =>
        "Improper Control of Filename for Include/Require Statement in PHP Program ('PHP Remote File Inclusion')",
    'CWE-99'  => q"Improper Control of Resource Identifiers ('Resource Injection')",
    'CWE-102' => q"Struts: Duplicate Validation Forms",
    'CWE-103' => q"Struts: Incomplete validate() Method Definition",
    'CWE-104' => q"Struts: Form Bean Does Not Extend Validation Class",
    'CWE-105' => q"Struts: Form Field Without Validator",
    'CWE-106' => q"Struts: Plug-in Framework not in Use",
    'CWE-107' => q"Struts: Unused Validation Form",
    'CWE-108' => q"Struts: Unvalidated Action Form",
    'CWE-109' => q"Struts: Validator Turned Off",
    'CWE-110' => q"Struts: Validator Without Form Field",
    'CWE-111' => q"Direct Use of Unsafe JNI",
    'CWE-112' => q"Missing XML Validation",
    'CWE-113' => q"Improper Neutralization of CRLF Sequences in HTTP Headers ('HTTP Request/Response Splitting')",
    'CWE-114' => q"Process Control",
    'CWE-115' => q"Misinterpretation of Input",
    'CWE-116' => q"Improper Encoding or Escaping of Output",
    'CWE-117' => q"Improper Output Neutralization for Logs",
    'CWE-118' => q"Incorrect Access of Indexable Resource ('Range Error')",
    'CWE-119' => q"Improper Restriction of Operations within the Bounds of a Memory Buffer",
    'CWE-120' => q"Buffer Copy without Checking Size of Input ('Classic Buffer Overflow')",
    'CWE-121' => q"Stack-based Buffer Overflow",
    'CWE-122' => q"Heap-based Buffer Overflow",
    'CWE-123' => q"Write-what-where Condition",
    'CWE-124' => q"Buffer Underwrite ('Buffer Underflow')",
    'CWE-125' => q"Out-of-bounds Read",
    'CWE-126' => q"Buffer Over-read",
    'CWE-127' => q"Buffer Under-read",
    'CWE-128' => q"Wrap-around Error",
    'CWE-129' => q"Improper Validation of Array Index",
    'CWE-130' => q"Improper Handling of Length Parameter Inconsistency",
    'CWE-131' => q"Incorrect Calculation of Buffer Size",
    'CWE-132' => q"DEPRECATED: Miscalculated Null Termination",
    'CWE-134' => q"Use of Externally-Controlled Format String",
    'CWE-135' => q"Incorrect Calculation of Multi-Byte String Length",
    'CWE-138' => q"Improper Neutralization of Special Elements",
    'CWE-140' => q"Improper Neutralization of Delimiters",
    'CWE-141' => q"Improper Neutralization of Parameter/Argument Delimiters",
    'CWE-142' => q"Improper Neutralization of Value Delimiters",
    'CWE-143' => q"Improper Neutralization of Record Delimiters",
    'CWE-144' => q"Improper Neutralization of Line Delimiters",
    'CWE-145' => q"Improper Neutralization of Section Delimiters",
    'CWE-146' => q"Improper Neutralization of Expression/Command Delimiters",
    'CWE-147' => q"Improper Neutralization of Input Terminators",
    'CWE-148' => q"Improper Neutralization of Input Leaders",
    'CWE-149' => q"Improper Neutralization of Quoting Syntax",
    'CWE-150' => q"Improper Neutralization of Escape, Meta, or Control Sequences",
    'CWE-151' => q"Improper Neutralization of Comment Delimiters",
    'CWE-152' => q"Improper Neutralization of Macro Symbols",
    'CWE-153' => q"Improper Neutralization of Substitution Characters",
    'CWE-154' => q"Improper Neutralization of Variable Name Delimiters",
    'CWE-155' => q"Improper Neutralization of Wildcards or Matching Symbols",
    'CWE-156' => q"Improper Neutralization of Whitespace",
    'CWE-157' => q"Failure to Sanitize Paired Delimiters",
    'CWE-158' => q"Improper Neutralization of Null Byte or NUL Character",
    'CWE-159' => q"Improper Handling of Invalid Use of Special Elements",
    'CWE-160' => q"Improper Neutralization of Leading Special Elements",
    'CWE-161' => q"Improper Neutralization of Multiple Leading Special Elements",
    'CWE-162' => q"Improper Neutralization of Trailing Special Elements",
    'CWE-163' => q"Improper Neutralization of Multiple Trailing Special Elements",
    'CWE-164' => q"Improper Neutralization of Internal Special Elements",
    'CWE-165' => q"Improper Neutralization of Multiple Internal Special Elements",
    'CWE-166' => q"Improper Handling of Missing Special Element",
    'CWE-167' => q"Improper Handling of Additional Special Element",
    'CWE-168' => q"Improper Handling of Inconsistent Special Elements",
    'CWE-170' => q"Improper Null Termination",
    'CWE-172' => q"Encoding Error",
    'CWE-173' => q"Improper Handling of Alternate Encoding",
    'CWE-174' => q"Double Decoding of the Same Data",
    'CWE-175' => q"Improper Handling of Mixed Encoding",
    'CWE-176' => q"Improper Handling of Unicode Encoding",
    'CWE-177' => q"Improper Handling of URL Encoding (Hex Encoding)",
    'CWE-178' => q"Improper Handling of Case Sensitivity",
    'CWE-179' => q"Incorrect Behavior Order: Early Validation",
    'CWE-180' => q"Incorrect Behavior Order: Validate Before Canonicalize",
    'CWE-181' => q"Incorrect Behavior Order: Validate Before Filter",
    'CWE-182' => q"Collapse of Data into Unsafe Value",
    'CWE-183' => q"Permissive List of Allowed Inputs",
    'CWE-184' => q"Incomplete List of Disallowed Inputs",
    'CWE-185' => q"Incorrect Regular Expression",
    'CWE-186' => q"Overly Restrictive Regular Expression",
    'CWE-187' => q"Partial String Comparison",
    'CWE-188' => q"Reliance on Data/Memory Layout",
    'CWE-190' => q"Integer Overflow or Wraparound",
    'CWE-191' => q"Integer Underflow (Wrap or Wraparound)",
    'CWE-192' => q"Integer Coercion Error",
    'CWE-193' => q"Off-by-one Error",
    'CWE-194' => q"Unexpected Sign Extension",
    'CWE-195' => q"Signed to Unsigned Conversion Error",
    'CWE-196' => q"Unsigned to Signed Conversion Error",
    'CWE-197' => q"Numeric Truncation Error",
    'CWE-198' => q"Use of Incorrect Byte Ordering",
    'CWE-200' => q"Exposure of Sensitive Information to an Unauthorized Actor",
    'CWE-201' => q"Insertion of Sensitive Information Into Sent Data",
    'CWE-202' => q"Exposure of Sensitive Information Through Data Queries",
    'CWE-203' => q"Observable Discrepancy",
    'CWE-204' => q"Observable Response Discrepancy",
    'CWE-205' => q"Observable Behavioral Discrepancy",
    'CWE-206' => q"Observable Internal Behavioral Discrepancy",
    'CWE-207' => q"Observable Behavioral Discrepancy With Equivalent Products",
    'CWE-208' => q"Observable Timing Discrepancy",
    'CWE-209' => q"Generation of Error Message Containing Sensitive Information",
    'CWE-210' => q"Self-generated Error Message Containing Sensitive Information",
    'CWE-211' => q"Externally-Generated Error Message Containing Sensitive Information",
    'CWE-212' => q"Improper Removal of Sensitive Information Before Storage or Transfer",
    'CWE-213' => q"Exposure of Sensitive Information Due to Incompatible Policies",
    'CWE-214' => q"Invocation of Process Using Visible Sensitive Information",
    'CWE-215' => q"Insertion of Sensitive Information Into Debugging Code",
    'CWE-216' => q"DEPRECATED: Containment Errors (Container Errors)",
    'CWE-217' => q"DEPRECATED: Failure to Protect Stored Data from Modification",
    'CWE-218' => q"DEPRECATED: Failure to provide confidentiality for stored data",
    'CWE-219' => q"Storage of File with Sensitive Data Under Web Root",
    'CWE-220' => q"Storage of File With Sensitive Data Under FTP Root",
    'CWE-221' => q"Information Loss or Omission",
    'CWE-222' => q"Truncation of Security-relevant Information",
    'CWE-223' => q"Omission of Security-relevant Information",
    'CWE-224' => q"Obscured Security-relevant Information by Alternate Name",
    'CWE-225' => q"DEPRECATED: General Information Management Problems",
    'CWE-226' => q"Sensitive Information in Resource Not Removed Before Reuse",
    'CWE-228' => q"Improper Handling of Syntactically Invalid Structure",
    'CWE-229' => q"Improper Handling of Values",
    'CWE-230' => q"Improper Handling of Missing Values",
    'CWE-231' => q"Improper Handling of Extra Values",
    'CWE-232' => q"Improper Handling of Undefined Values",
    'CWE-233' => q"Improper Handling of Parameters",
    'CWE-234' => q"Failure to Handle Missing Parameter",
    'CWE-235' => q"Improper Handling of Extra Parameters",
    'CWE-236' => q"Improper Handling of Undefined Parameters",
    'CWE-237' => q"Improper Handling of Structural Elements",
    'CWE-238' => q"Improper Handling of Incomplete Structural Elements",
    'CWE-239' => q"Failure to Handle Incomplete Element",
    'CWE-240' => q"Improper Handling of Inconsistent Structural Elements",
    'CWE-241' => q"Improper Handling of Unexpected Data Type",
    'CWE-242' => q"Use of Inherently Dangerous Function",
    'CWE-243' => q"Creation of chroot Jail Without Changing Working Directory",
    'CWE-244' => q"Improper Clearing of Heap Memory Before Release ('Heap Inspection')",
    'CWE-245' => q"J2EE Bad Practices: Direct Management of Connections",
    'CWE-246' => q"J2EE Bad Practices: Direct Use of Sockets",
    'CWE-247' => q"DEPRECATED: Reliance on DNS Lookups in a Security Decision",
    'CWE-248' => q"Uncaught Exception",
    'CWE-249' => q"DEPRECATED: Often Misused: Path Manipulation",
    'CWE-250' => q"Execution with Unnecessary Privileges",
    'CWE-252' => q"Unchecked Return Value",
    'CWE-253' => q"Incorrect Check of Function Return Value",
    'CWE-256' => q"Plaintext Storage of a Password",
    'CWE-257' => q"Storing Passwords in a Recoverable Format",
    'CWE-258' => q"Empty Password in Configuration File",
    'CWE-259' => q"Use of Hard-coded Password",
    'CWE-260' => q"Password in Configuration File",
    'CWE-261' => q"Weak Encoding for Password",
    'CWE-262' => q"Not Using Password Aging",
    'CWE-263' => q"Password Aging with Long Expiration",
    'CWE-266' => q"Incorrect Privilege Assignment",
    'CWE-267' => q"Privilege Defined With Unsafe Actions",
    'CWE-268' => q"Privilege Chaining",
    'CWE-269' => q"Improper Privilege Management",
    'CWE-270' => q"Privilege Context Switching Error",
    'CWE-271' => q"Privilege Dropping / Lowering Errors",
    'CWE-272' => q"Least Privilege Violation",
    'CWE-273' => q"Improper Check for Dropped Privileges",
    'CWE-274' => q"Improper Handling of Insufficient Privileges",
    'CWE-276' => q"Incorrect Default Permissions",
    'CWE-277' => q"Insecure Inherited Permissions",
    'CWE-278' => q"Insecure Preserved Inherited Permissions",
    'CWE-279' => q"Incorrect Execution-Assigned Permissions",
    'CWE-280' => q"Improper Handling of Insufficient Permissions or Privileges ",
    'CWE-281' => q"Improper Preservation of Permissions",
    'CWE-282' => q"Improper Ownership Management",
    'CWE-283' => q"Unverified Ownership",
    'CWE-284' => q"Improper Access Control",
    'CWE-285' => q"Improper Authorization",
    'CWE-286' => q"Incorrect User Management",
    'CWE-287' => q"Improper Authentication",
    'CWE-288' => q"Authentication Bypass Using an Alternate Path or Channel",
    'CWE-289' => q"Authentication Bypass by Alternate Name",
    'CWE-290' => q"Authentication Bypass by Spoofing",
    'CWE-291' => q"Reliance on IP Address for Authentication",
    'CWE-292' => q"DEPRECATED: Trusting Self-reported DNS Name",
    'CWE-293' => q"Using Referer Field for Authentication",
    'CWE-294' => q"Authentication Bypass by Capture-replay",
    'CWE-295' => q"Improper Certificate Validation",
    'CWE-296' => q"Improper Following of a Certificate's Chain of Trust",
    'CWE-297' => q"Improper Validation of Certificate with Host Mismatch",
    'CWE-298' => q"Improper Validation of Certificate Expiration",
    'CWE-299' => q"Improper Check for Certificate Revocation",
    'CWE-300' => q"Channel Accessible by Non-Endpoint",
    'CWE-301' => q"Reflection Attack in an Authentication Protocol",
    'CWE-302' => q"Authentication Bypass by Assumed-Immutable Data",
    'CWE-303' => q"Incorrect Implementation of Authentication Algorithm",
    'CWE-304' => q"Missing Critical Step in Authentication",
    'CWE-305' => q"Authentication Bypass by Primary Weakness",
    'CWE-306' => q"Missing Authentication for Critical Function",
    'CWE-307' => q"Improper Restriction of Excessive Authentication Attempts",
    'CWE-308' => q"Use of Single-factor Authentication",
    'CWE-309' => q"Use of Password System for Primary Authentication",
    'CWE-311' => q"Missing Encryption of Sensitive Data",
    'CWE-312' => q"Cleartext Storage of Sensitive Information",
    'CWE-313' => q"Cleartext Storage in a File or on Disk",
    'CWE-314' => q"Cleartext Storage in the Registry",
    'CWE-315' => q"Cleartext Storage of Sensitive Information in a Cookie",
    'CWE-316' => q"Cleartext Storage of Sensitive Information in Memory",
    'CWE-317' => q"Cleartext Storage of Sensitive Information in GUI",
    'CWE-318' => q"Cleartext Storage of Sensitive Information in Executable",
    'CWE-319' => q"Cleartext Transmission of Sensitive Information",
    'CWE-321' => q"Use of Hard-coded Cryptographic Key",
    'CWE-322' => q"Key Exchange without Entity Authentication",
    'CWE-323' => q"Reusing a Nonce, Key Pair in Encryption",
    'CWE-324' => q"Use of a Key Past its Expiration Date",
    'CWE-325' => q"Missing Cryptographic Step",
    'CWE-326' => q"Inadequate Encryption Strength",
    'CWE-327' => q"Use of a Broken or Risky Cryptographic Algorithm",
    'CWE-328' => q"Use of Weak Hash",
    'CWE-329' => q"Generation of Predictable IV with CBC Mode",
    'CWE-330' => q"Use of Insufficiently Random Values",
    'CWE-331' => q"Insufficient Entropy",
    'CWE-332' => q"Insufficient Entropy in PRNG",
    'CWE-333' => q"Improper Handling of Insufficient Entropy in TRNG",
    'CWE-334' => q"Small Space of Random Values",
    'CWE-335' => q"Incorrect Usage of Seeds in Pseudo-Random Number Generator (PRNG)",
    'CWE-336' => q"Same Seed in Pseudo-Random Number Generator (PRNG)",
    'CWE-337' => q"Predictable Seed in Pseudo-Random Number Generator (PRNG)",
    'CWE-338' => q"Use of Cryptographically Weak Pseudo-Random Number Generator (PRNG)",
    'CWE-339' => q"Small Seed Space in PRNG",
    'CWE-340' => q"Generation of Predictable Numbers or Identifiers",
    'CWE-341' => q"Predictable from Observable State",
    'CWE-342' => q"Predictable Exact Value from Previous Values",
    'CWE-343' => q"Predictable Value Range from Previous Values",
    'CWE-344' => q"Use of Invariant Value in Dynamically Changing Context",
    'CWE-345' => q"Insufficient Verification of Data Authenticity",
    'CWE-346' => q"Origin Validation Error",
    'CWE-347' => q"Improper Verification of Cryptographic Signature",
    'CWE-348' => q"Use of Less Trusted Source",
    'CWE-349' => q"Acceptance of Extraneous Untrusted Data With Trusted Data",
    'CWE-350' => q"Reliance on Reverse DNS Resolution for a Security-Critical Action",
    'CWE-351' => q"Insufficient Type Distinction",
    'CWE-352' => q"Cross-Site Request Forgery (CSRF)",
    'CWE-353' => q"Missing Support for Integrity Check",
    'CWE-354' => q"Improper Validation of Integrity Check Value",
    'CWE-356' => q"Product UI does not Warn User of Unsafe Actions",
    'CWE-357' => q"Insufficient UI Warning of Dangerous Operations",
    'CWE-358' => q"Improperly Implemented Security Check for Standard",
    'CWE-359' => q"Exposure of Private Personal Information to an Unauthorized Actor",
    'CWE-360' => q"Trust of System Event Data",
    'CWE-362' => q"Concurrent Execution using Shared Resource with Improper Synchronization ('Race Condition')",
    'CWE-363' => q"Race Condition Enabling Link Following",
    'CWE-364' => q"Signal Handler Race Condition",
    'CWE-365' => q"DEPRECATED: Race Condition in Switch",
    'CWE-366' => q"Race Condition within a Thread",
    'CWE-367' => q"Time-of-check Time-of-use (TOCTOU) Race Condition",
    'CWE-368' => q"Context Switching Race Condition",
    'CWE-369' => q"Divide By Zero",
    'CWE-370' => q"Missing Check for Certificate Revocation after Initial Check",
    'CWE-372' => q"Incomplete Internal State Distinction",
    'CWE-373' => q"DEPRECATED: State Synchronization Error",
    'CWE-374' => q"Passing Mutable Objects to an Untrusted Method",
    'CWE-375' => q"Returning a Mutable Object to an Untrusted Caller",
    'CWE-377' => q"Insecure Temporary File",
    'CWE-378' => q"Creation of Temporary File With Insecure Permissions",
    'CWE-379' => q"Creation of Temporary File in Directory with Insecure Permissions",
    'CWE-382' => q"J2EE Bad Practices: Use of System.exit()",
    'CWE-383' => q"J2EE Bad Practices: Direct Use of Threads",
    'CWE-384' => q"Session Fixation",
    'CWE-385' => q"Covert Timing Channel",
    'CWE-386' => q"Symbolic Name not Mapping to Correct Object",
    'CWE-390' => q"Detection of Error Condition Without Action",
    'CWE-391' => q"Unchecked Error Condition",
    'CWE-392' => q"Missing Report of Error Condition",
    'CWE-393' => q"Return of Wrong Status Code",
    'CWE-394' => q"Unexpected Status Code or Return Value",
    'CWE-395' => q"Use of NullPointerException Catch to Detect NULL Pointer Dereference",
    'CWE-396' => q"Declaration of Catch for Generic Exception",
    'CWE-397' => q"Declaration of Throws for Generic Exception",
    'CWE-400' => q"Uncontrolled Resource Consumption",
    'CWE-401' => q"Missing Release of Memory after Effective Lifetime",
    'CWE-402' => q"Transmission of Private Resources into a New Sphere ('Resource Leak')",
    'CWE-403' => q"Exposure of File Descriptor to Unintended Control Sphere ('File Descriptor Leak')",
    'CWE-404' => q"Improper Resource Shutdown or Release",
    'CWE-405' => q"Asymmetric Resource Consumption (Amplification)",
    'CWE-406' => q"Insufficient Control of Network Message Volume (Network Amplification)",
    'CWE-407' => q"Inefficient Algorithmic Complexity",
    'CWE-408' => q"Incorrect Behavior Order: Early Amplification",
    'CWE-409' => q"Improper Handling of Highly Compressed Data (Data Amplification)",
    'CWE-410' => q"Insufficient Resource Pool",
    'CWE-412' => q"Unrestricted Externally Accessible Lock",
    'CWE-413' => q"Improper Resource Locking",
    'CWE-414' => q"Missing Lock Check",
    'CWE-415' => q"Double Free",
    'CWE-416' => q"Use After Free",
    'CWE-419' => q"Unprotected Primary Channel",
    'CWE-420' => q"Unprotected Alternate Channel",
    'CWE-421' => q"Race Condition During Access to Alternate Channel",
    'CWE-422' => q"Unprotected Windows Messaging Channel ('Shatter')",
    'CWE-423' => q"DEPRECATED: Proxied Trusted Channel",
    'CWE-424' => q"Improper Protection of Alternate Path",
    'CWE-425' => q"Direct Request ('Forced Browsing')",
    'CWE-426' => q"Untrusted Search Path",
    'CWE-427' => q"Uncontrolled Search Path Element",
    'CWE-428' => q"Unquoted Search Path or Element",
    'CWE-430' => q"Deployment of Wrong Handler",
    'CWE-431' => q"Missing Handler",
    'CWE-432' => q"Dangerous Signal Handler not Disabled During Sensitive Operations",
    'CWE-433' => q"Unparsed Raw Web Content Delivery",
    'CWE-434' => q"Unrestricted Upload of File with Dangerous Type",
    'CWE-435' => q"Improper Interaction Between Multiple Correctly-Behaving Entities",
    'CWE-436' => q"Interpretation Conflict",
    'CWE-437' => q"Incomplete Model of Endpoint Features",
    'CWE-439' => q"Behavioral Change in New Version or Environment",
    'CWE-440' => q"Expected Behavior Violation",
    'CWE-441' => q"Unintended Proxy or Intermediary ('Confused Deputy')",
    'CWE-443' => q"DEPRECATED: HTTP response splitting",
    'CWE-444' => q"Inconsistent Interpretation of HTTP Requests ('HTTP Request/Response Smuggling')",
    'CWE-446' => q"UI Discrepancy for Security Feature",
    'CWE-447' => q"Unimplemented or Unsupported Feature in UI",
    'CWE-448' => q"Obsolete Feature in UI",
    'CWE-449' => q"The UI Performs the Wrong Action",
    'CWE-450' => q"Multiple Interpretations of UI Input",
    'CWE-451' => q"User Interface (UI) Misrepresentation of Critical Information",
    'CWE-453' => q"Insecure Default Variable Initialization",
    'CWE-454' => q"External Initialization of Trusted Variables or Data Stores",
    'CWE-455' => q"Non-exit on Failed Initialization",
    'CWE-456' => q"Missing Initialization of a Variable",
    'CWE-457' => q"Use of Uninitialized Variable",
    'CWE-458' => q"DEPRECATED: Incorrect Initialization",
    'CWE-459' => q"Incomplete Cleanup",
    'CWE-460' => q"Improper Cleanup on Thrown Exception",
    'CWE-462' => q"Duplicate Key in Associative List (Alist)",
    'CWE-463' => q"Deletion of Data Structure Sentinel",
    'CWE-464' => q"Addition of Data Structure Sentinel",
    'CWE-466' => q"Return of Pointer Value Outside of Expected Range",
    'CWE-467' => q"Use of sizeof() on a Pointer Type",
    'CWE-468' => q"Incorrect Pointer Scaling",
    'CWE-469' => q"Use of Pointer Subtraction to Determine Size",
    'CWE-470' => q"Use of Externally-Controlled Input to Select Classes or Code ('Unsafe Reflection')",
    'CWE-471' => q"Modification of Assumed-Immutable Data (MAID)",
    'CWE-472' => q"External Control of Assumed-Immutable Web Parameter",
    'CWE-473' => q"PHP External Variable Modification",
    'CWE-474' => q"Use of Function with Inconsistent Implementations",
    'CWE-475' => q"Undefined Behavior for Input to API",
    'CWE-476' => q"NULL Pointer Dereference",
    'CWE-477' => q"Use of Obsolete Function",
    'CWE-478' => q"Missing Default Case in Multiple Condition Expression",
    'CWE-479' => q"Signal Handler Use of a Non-reentrant Function",
    'CWE-480' => q"Use of Incorrect Operator",
    'CWE-481' => q"Assigning instead of Comparing",
    'CWE-482' => q"Comparing instead of Assigning",
    'CWE-483' => q"Incorrect Block Delimitation",
    'CWE-484' => q"Omitted Break Statement in Switch",
    'CWE-486' => q"Comparison of Classes by Name",
    'CWE-487' => q"Reliance on Package-level Scope",
    'CWE-488' => q"Exposure of Data Element to Wrong Session",
    'CWE-489' => q"Active Debug Code",
    'CWE-491' => q"Public cloneable() Method Without Final ('Object Hijack')",
    'CWE-492' => q"Use of Inner Class Containing Sensitive Data",
    'CWE-493' => q"Critical Public Variable Without Final Modifier",
    'CWE-494' => q"Download of Code Without Integrity Check",
    'CWE-495' => q"Private Data Structure Returned From A Public Method",
    'CWE-496' => q"Public Data Assigned to Private Array-Typed Field",
    'CWE-497' => q"Exposure of Sensitive System Information to an Unauthorized Control Sphere",
    'CWE-498' => q"Cloneable Class Containing Sensitive Information",
    'CWE-499' => q"Serializable Class Containing Sensitive Data",
    'CWE-500' => q"Public Static Field Not Marked Final",
    'CWE-501' => q"Trust Boundary Violation",
    'CWE-502' => q"Deserialization of Untrusted Data",
    'CWE-506' => q"Embedded Malicious Code",
    'CWE-507' => q"Trojan Horse",
    'CWE-508' => q"Non-Replicating Malicious Code",
    'CWE-509' => q"Replicating Malicious Code (Virus or Worm)",
    'CWE-510' => q"Trapdoor",
    'CWE-511' => q"Logic/Time Bomb",
    'CWE-512' => q"Spyware",
    'CWE-514' => q"Covert Channel",
    'CWE-515' => q"Covert Storage Channel",
    'CWE-516' => q"DEPRECATED: Covert Timing Channel",
    'CWE-520' => q".NET Misconfiguration: Use of Impersonation",
    'CWE-521' => q"Weak Password Requirements",
    'CWE-522' => q"Insufficiently Protected Credentials",
    'CWE-523' => q"Unprotected Transport of Credentials",
    'CWE-524' => q"Use of Cache Containing Sensitive Information",
    'CWE-525' => q"Use of Web Browser Cache Containing Sensitive Information",
    'CWE-526' => q"Cleartext Storage of Sensitive Information in an Environment Variable",
    'CWE-527' => q"Exposure of Version-Control Repository to an Unauthorized Control Sphere",
    'CWE-528' => q"Exposure of Core Dump File to an Unauthorized Control Sphere",
    'CWE-529' => q"Exposure of Access Control List Files to an Unauthorized Control Sphere",
    'CWE-530' => q"Exposure of Backup File to an Unauthorized Control Sphere",
    'CWE-531' => q"Inclusion of Sensitive Information in Test Code",
    'CWE-532' => q"Insertion of Sensitive Information into Log File",
    'CWE-533' => q"DEPRECATED: Information Exposure Through Server Log Files",
    'CWE-534' => q"DEPRECATED: Information Exposure Through Debug Log Files",
    'CWE-535' => q"Exposure of Information Through Shell Error Message",
    'CWE-536' => q"Servlet Runtime Error Message Containing Sensitive Information",
    'CWE-537' => q"Java Runtime Error Message Containing Sensitive Information",
    'CWE-538' => q"Insertion of Sensitive Information into Externally-Accessible File or Directory",
    'CWE-539' => q"Use of Persistent Cookies Containing Sensitive Information",
    'CWE-540' => q"Inclusion of Sensitive Information in Source Code",
    'CWE-541' => q"Inclusion of Sensitive Information in an Include File",
    'CWE-542' => q"DEPRECATED: Information Exposure Through Cleanup Log Files",
    'CWE-543' => q"Use of Singleton Pattern Without Synchronization in a Multithreaded Context",
    'CWE-544' => q"Missing Standardized Error Handling Mechanism",
    'CWE-545' => q"DEPRECATED: Use of Dynamic Class Loading",
    'CWE-546' => q"Suspicious Comment",
    'CWE-547' => q"Use of Hard-coded, Security-relevant Constants",
    'CWE-548' => q"Exposure of Information Through Directory Listing",
    'CWE-549' => q"Missing Password Field Masking",
    'CWE-550' => q"Server-generated Error Message Containing Sensitive Information",
    'CWE-551' => q"Incorrect Behavior Order: Authorization Before Parsing and Canonicalization",
    'CWE-552' => q"Files or Directories Accessible to External Parties",
    'CWE-553' => q"Command Shell in Externally Accessible Directory",
    'CWE-554' => q"ASP.NET Misconfiguration: Not Using Input Validation Framework",
    'CWE-555' => q"J2EE Misconfiguration: Plaintext Password in Configuration File",
    'CWE-556' => q"ASP.NET Misconfiguration: Use of Identity Impersonation",
    'CWE-558' => q"Use of getlogin() in Multithreaded Application",
    'CWE-560' => q"Use of umask() with chmod-style Argument",
    'CWE-561' => q"Dead Code",
    'CWE-562' => q"Return of Stack Variable Address",
    'CWE-563' => q"Assignment to Variable without Use",
    'CWE-564' => q"SQL Injection: Hibernate",
    'CWE-565' => q"Reliance on Cookies without Validation and Integrity Checking",
    'CWE-566' => q"Authorization Bypass Through User-Controlled SQL Primary Key",
    'CWE-567' => q"Unsynchronized Access to Shared Data in a Multithreaded Context",
    'CWE-568' => q"finalize() Method Without super.finalize()",
    'CWE-570' => q"Expression is Always False",
    'CWE-571' => q"Expression is Always True",
    'CWE-572' => q"Call to Thread run() instead of start()",
    'CWE-573' => q"Improper Following of Specification by Caller",
    'CWE-574' => q"EJB Bad Practices: Use of Synchronization Primitives",
    'CWE-575' => q"EJB Bad Practices: Use of AWT Swing",
    'CWE-576' => q"EJB Bad Practices: Use of Java I/O",
    'CWE-577' => q"EJB Bad Practices: Use of Sockets",
    'CWE-578' => q"EJB Bad Practices: Use of Class Loader",
    'CWE-579' => q"J2EE Bad Practices: Non-serializable Object Stored in Session",
    'CWE-580' => q"clone() Method Without super.clone()",
    'CWE-581' => q"Object Model Violation: Just One of Equals and Hashcode Defined",
    'CWE-582' => q"Array Declared Public, Final, and Static",
    'CWE-583' => q"finalize() Method Declared Public",
    'CWE-584' => q"Return Inside Finally Block",
    'CWE-585' => q"Empty Synchronized Block",
    'CWE-586' => q"Explicit Call to Finalize()",
    'CWE-587' => q"Assignment of a Fixed Address to a Pointer",
    'CWE-588' => q"Attempt to Access Child of a Non-structure Pointer",
    'CWE-589' => q"Call to Non-ubiquitous API",
    'CWE-590' => q"Free of Memory not on the Heap",
    'CWE-591' => q"Sensitive Data Storage in Improperly Locked Memory",
    'CWE-592' => q"DEPRECATED: Authentication Bypass Issues",
    'CWE-593' => q"Authentication Bypass: OpenSSL CTX Object Modified after SSL Objects are Created",
    'CWE-594' => q"J2EE Framework: Saving Unserializable Objects to Disk",
    'CWE-595' => q"Comparison of Object References Instead of Object Contents",
    'CWE-596' => q"DEPRECATED: Incorrect Semantic Object Comparison",
    'CWE-597' => q"Use of Wrong Operator in String Comparison",
    'CWE-598' => q"Use of GET Request Method With Sensitive Query Strings",
    'CWE-599' => q"Missing Validation of OpenSSL Certificate",
    'CWE-600' => q"Uncaught Exception in Servlet ",
    'CWE-601' => q"URL Redirection to Untrusted Site ('Open Redirect')",
    'CWE-602' => q"Client-Side Enforcement of Server-Side Security",
    'CWE-603' => q"Use of Client-Side Authentication",
    'CWE-605' => q"Multiple Binds to the Same Port",
    'CWE-606' => q"Unchecked Input for Loop Condition",
    'CWE-607' => q"Public Static Final Field References Mutable Object",
    'CWE-608' => q"Struts: Non-private Field in ActionForm Class",
    'CWE-609' => q"Double-Checked Locking",
    'CWE-610' => q"Externally Controlled Reference to a Resource in Another Sphere",
    'CWE-611' => q"Improper Restriction of XML External Entity Reference",
    'CWE-612' => q"Improper Authorization of Index Containing Sensitive Information",
    'CWE-613' => q"Insufficient Session Expiration",
    'CWE-614' => q"Sensitive Cookie in HTTPS Session Without 'Secure' Attribute",
    'CWE-615' => q"Inclusion of Sensitive Information in Source Code Comments",
    'CWE-616' => q"Incomplete Identification of Uploaded File Variables (PHP)",
    'CWE-617' => q"Reachable Assertion",
    'CWE-618' => q"Exposed Unsafe ActiveX Method",
    'CWE-619' => q"Dangling Database Cursor ('Cursor Injection')",
    'CWE-620' => q"Unverified Password Change",
    'CWE-621' => q"Variable Extraction Error",
    'CWE-622' => q"Improper Validation of Function Hook Arguments",
    'CWE-623' => q"Unsafe ActiveX Control Marked Safe For Scripting",
    'CWE-624' => q"Executable Regular Expression Error",
    'CWE-625' => q"Permissive Regular Expression",
    'CWE-626' => q"Null Byte Interaction Error (Poison Null Byte)",
    'CWE-627' => q"Dynamic Variable Evaluation",
    'CWE-628' => q"Function Call with Incorrectly Specified Arguments",
    'CWE-636' => q"Not Failing Securely ('Failing Open')",
    'CWE-637' => q"Unnecessary Complexity in Protection Mechanism (Not Using 'Economy of Mechanism')",
    'CWE-638' => q"Not Using Complete Mediation",
    'CWE-639' => q"Authorization Bypass Through User-Controlled Key",
    'CWE-640' => q"Weak Password Recovery Mechanism for Forgotten Password",
    'CWE-641' => q"Improper Restriction of Names for Files and Other Resources",
    'CWE-642' => q"External Control of Critical State Data",
    'CWE-643' => q"Improper Neutralization of Data within XPath Expressions ('XPath Injection')",
    'CWE-644' => q"Improper Neutralization of HTTP Headers for Scripting Syntax",
    'CWE-645' => q"Overly Restrictive Account Lockout Mechanism",
    'CWE-646' => q"Reliance on File Name or Extension of Externally-Supplied File",
    'CWE-647' => q"Use of Non-Canonical URL Paths for Authorization Decisions",
    'CWE-648' => q"Incorrect Use of Privileged APIs",
    'CWE-649' => q"Reliance on Obfuscation or Encryption of Security-Relevant Inputs without Integrity Checking",
    'CWE-650' => q"Trusting HTTP Permission Methods on the Server Side",
    'CWE-651' => q"Exposure of WSDL File Containing Sensitive Information",
    'CWE-652' => q"Improper Neutralization of Data within XQuery Expressions ('XQuery Injection')",
    'CWE-653' => q"Improper Isolation or Compartmentalization",
    'CWE-654' => q"Reliance on a Single Factor in a Security Decision",
    'CWE-655' => q"Insufficient Psychological Acceptability",
    'CWE-656' => q"Reliance on Security Through Obscurity",
    'CWE-657' => q"Violation of Secure Design Principles",
    'CWE-662' => q"Improper Synchronization",
    'CWE-663' => q"Use of a Non-reentrant Function in a Concurrent Context",
    'CWE-664' => q"Improper Control of a Resource Through its Lifetime",
    'CWE-665' => q"Improper Initialization",
    'CWE-666' => q"Operation on Resource in Wrong Phase of Lifetime",
    'CWE-667' => q"Improper Locking",
    'CWE-668' => q"Exposure of Resource to Wrong Sphere",
    'CWE-669' => q"Incorrect Resource Transfer Between Spheres",
    'CWE-670' => q"Always-Incorrect Control Flow Implementation",
    'CWE-671' => q"Lack of Administrator Control over Security",
    'CWE-672' => q"Operation on a Resource after Expiration or Release",
    'CWE-673' => q"External Influence of Sphere Definition",
    'CWE-674' => q"Uncontrolled Recursion",
    'CWE-675' => q"Multiple Operations on Resource in Single-Operation Context",
    'CWE-676' => q"Use of Potentially Dangerous Function",
    'CWE-680' => q"Integer Overflow to Buffer Overflow",
    'CWE-681' => q"Incorrect Conversion between Numeric Types",
    'CWE-682' => q"Incorrect Calculation",
    'CWE-683' => q"Function Call With Incorrect Order of Arguments",
    'CWE-684' => q"Incorrect Provision of Specified Functionality",
    'CWE-685' => q"Function Call With Incorrect Number of Arguments",
    'CWE-686' => q"Function Call With Incorrect Argument Type",
    'CWE-687' => q"Function Call With Incorrectly Specified Argument Value",
    'CWE-688' => q"Function Call With Incorrect Variable or Reference as Argument",
    'CWE-689' => q"Permission Race Condition During Resource Copy",
    'CWE-690' => q"Unchecked Return Value to NULL Pointer Dereference",
    'CWE-691' => q"Insufficient Control Flow Management",
    'CWE-692' => q"Incomplete Denylist to Cross-Site Scripting",
    'CWE-693' => q"Protection Mechanism Failure",
    'CWE-694' => q"Use of Multiple Resources with Duplicate Identifier",
    'CWE-695' => q"Use of Low-Level Functionality",
    'CWE-696' => q"Incorrect Behavior Order",
    'CWE-697' => q"Incorrect Comparison",
    'CWE-698' => q"Execution After Redirect (EAR)",
    'CWE-703' => q"Improper Check or Handling of Exceptional Conditions",
    'CWE-704' => q"Incorrect Type Conversion or Cast",
    'CWE-705' => q"Incorrect Control Flow Scoping",
    'CWE-706' => q"Use of Incorrectly-Resolved Name or Reference",
    'CWE-707' => q"Improper Neutralization",
    'CWE-708' => q"Incorrect Ownership Assignment",
    'CWE-710' => q"Improper Adherence to Coding Standards",
    'CWE-732' => q"Incorrect Permission Assignment for Critical Resource",
    'CWE-733' => q"Compiler Optimization Removal or Modification of Security-critical Code",
    'CWE-749' => q"Exposed Dangerous Method or Function",
    'CWE-754' => q"Improper Check for Unusual or Exceptional Conditions",
    'CWE-755' => q"Improper Handling of Exceptional Conditions",
    'CWE-756' => q"Missing Custom Error Page",
    'CWE-757' => q"Selection of Less-Secure Algorithm During Negotiation ('Algorithm Downgrade')",
    'CWE-758' => q"Reliance on Undefined, Unspecified, or Implementation-Defined Behavior",
    'CWE-759' => q"Use of a One-Way Hash without a Salt",
    'CWE-760' => q"Use of a One-Way Hash with a Predictable Salt",
    'CWE-761' => q"Free of Pointer not at Start of Buffer",
    'CWE-762' => q"Mismatched Memory Management Routines",
    'CWE-763' => q"Release of Invalid Pointer or Reference",
    'CWE-764' => q"Multiple Locks of a Critical Resource",
    'CWE-765' => q"Multiple Unlocks of a Critical Resource",
    'CWE-766' => q"Critical Data Element Declared Public",
    'CWE-767' => q"Access to Critical Private Variable via Public Method",
    'CWE-768' => q"Incorrect Short Circuit Evaluation",
    'CWE-769' => q"DEPRECATED: Uncontrolled File Descriptor Consumption",
    'CWE-770' => q"Allocation of Resources Without Limits or Throttling",
    'CWE-771' => q"Missing Reference to Active Allocated Resource",
    'CWE-772' => q"Missing Release of Resource after Effective Lifetime",
    'CWE-773' => q"Missing Reference to Active File Descriptor or Handle",
    'CWE-774' => q"Allocation of File Descriptors or Handles Without Limits or Throttling",
    'CWE-775' => q"Missing Release of File Descriptor or Handle after Effective Lifetime",
    'CWE-776' => q"Improper Restriction of Recursive Entity References in DTDs ('XML Entity Expansion')",
    'CWE-777' => q"Regular Expression without Anchors",
    'CWE-778' => q"Insufficient Logging",
    'CWE-779' => q"Logging of Excessive Data",
    'CWE-780' => q"Use of RSA Algorithm without OAEP",
    'CWE-781' => q"Improper Address Validation in IOCTL with METHOD_NEITHER I/O Control Code",
    'CWE-782' => q"Exposed IOCTL with Insufficient Access Control",
    'CWE-783' => q"Operator Precedence Logic Error",
    'CWE-784' => q"Reliance on Cookies without Validation and Integrity Checking in a Security Decision",
    'CWE-785' => q"Use of Path Manipulation Function without Maximum-sized Buffer",
    'CWE-786' => q"Access of Memory Location Before Start of Buffer",
    'CWE-787' => q"Out-of-bounds Write",
    'CWE-788' => q"Access of Memory Location After End of Buffer",
    'CWE-789' => q"Memory Allocation with Excessive Size Value",
    'CWE-790' => q"Improper Filtering of Special Elements",
    'CWE-791' => q"Incomplete Filtering of Special Elements",
    'CWE-792' => q"Incomplete Filtering of One or More Instances of Special Elements",
    'CWE-793' => q"Only Filtering One Instance of a Special Element",
    'CWE-794' => q"Incomplete Filtering of Multiple Instances of Special Elements",
    'CWE-795' => q"Only Filtering Special Elements at a Specified Location",
    'CWE-796' => q"Only Filtering Special Elements Relative to a Marker",
    'CWE-797' => q"Only Filtering Special Elements at an Absolute Position",
    'CWE-798' => q"Use of Hard-coded Credentials",
    'CWE-799' => q"Improper Control of Interaction Frequency",
    'CWE-804' => q"Guessable CAPTCHA",
    'CWE-805' => q"Buffer Access with Incorrect Length Value",
    'CWE-806' => q"Buffer Access Using Size of Source Buffer",
    'CWE-807' => q"Reliance on Untrusted Inputs in a Security Decision",
    'CWE-820' => q"Missing Synchronization",
    'CWE-821' => q"Incorrect Synchronization",
    'CWE-822' => q"Untrusted Pointer Dereference",
    'CWE-823' => q"Use of Out-of-range Pointer Offset",
    'CWE-824' => q"Access of Uninitialized Pointer",
    'CWE-825' => q"Expired Pointer Dereference",
    'CWE-826' => q"Premature Release of Resource During Expected Lifetime",
    'CWE-827' => q"Improper Control of Document Type Definition",
    'CWE-828' => q"Signal Handler with Functionality that is not Asynchronous-Safe",
    'CWE-829' => q"Inclusion of Functionality from Untrusted Control Sphere",
    'CWE-830' => q"Inclusion of Web Functionality from an Untrusted Source",
    'CWE-831' => q"Signal Handler Function Associated with Multiple Signals",
    'CWE-832' => q"Unlock of a Resource that is not Locked",
    'CWE-833' => q"Deadlock",
    'CWE-834' => q"Excessive Iteration",
    'CWE-835' => q"Loop with Unreachable Exit Condition ('Infinite Loop')",
    'CWE-836' => q"Use of Password Hash Instead of Password for Authentication",
    'CWE-837' => q"Improper Enforcement of a Single, Unique Action",
    'CWE-838' => q"Inappropriate Encoding for Output Context",
    'CWE-839' => q"Numeric Range Comparison Without Minimum Check",
    'CWE-841' => q"Improper Enforcement of Behavioral Workflow",
    'CWE-842' => q"Placement of User into Incorrect Group",
    'CWE-843' => q"Access of Resource Using Incompatible Type ('Type Confusion')",
    'CWE-862' => q"Missing Authorization",
    'CWE-863' => q"Incorrect Authorization",
    'CWE-908' => q"Use of Uninitialized Resource",
    'CWE-909' => q"Missing Initialization of Resource",
    'CWE-910' => q"Use of Expired File Descriptor",
    'CWE-911' => q"Improper Update of Reference Count",
    'CWE-912' => q"Hidden Functionality",
    'CWE-913' => q"Improper Control of Dynamically-Managed Code Resources",
    'CWE-914' => q"Improper Control of Dynamically-Identified Variables",
    'CWE-915' => q"Improperly Controlled Modification of Dynamically-Determined Object Attributes",
    'CWE-916' => q"Use of Password Hash With Insufficient Computational Effort",
    'CWE-917' =>
        "Improper Neutralization of Special Elements used in an Expression Language Statement ('Expression Language Injection')",
    'CWE-918'  => q"Server-Side Request Forgery (SSRF)",
    'CWE-920'  => q"Improper Restriction of Power Consumption",
    'CWE-921'  => q"Storage of Sensitive Data in a Mechanism without Access Control",
    'CWE-922'  => q"Insecure Storage of Sensitive Information",
    'CWE-923'  => q"Improper Restriction of Communication Channel to Intended Endpoints",
    'CWE-924'  => q"Improper Enforcement of Message Integrity During Transmission in a Communication Channel",
    'CWE-925'  => q"Improper Verification of Intent by Broadcast Receiver",
    'CWE-926'  => q"Improper Export of Android Application Components",
    'CWE-927'  => q"Use of Implicit Intent for Sensitive Communication",
    'CWE-939'  => q"Improper Authorization in Handler for Custom URL Scheme",
    'CWE-940'  => q"Improper Verification of Source of a Communication Channel",
    'CWE-941'  => q"Incorrectly Specified Destination in a Communication Channel",
    'CWE-942'  => q"Permissive Cross-domain Policy with Untrusted Domains",
    'CWE-943'  => q"Improper Neutralization of Special Elements in Data Query Logic",
    'CWE-1004' => q"Sensitive Cookie Without 'HttpOnly' Flag",
    'CWE-1007' => q"Insufficient Visual Distinction of Homoglyphs Presented to User",
    'CWE-1021' => q"Improper Restriction of Rendered UI Layers or Frames",
    'CWE-1022' => q"Use of Web Link to Untrusted Target with window.opener Access",
    'CWE-1023' => q"Incomplete Comparison with Missing Factors",
    'CWE-1024' => q"Comparison of Incompatible Types",
    'CWE-1025' => q"Comparison Using Wrong Factors",
    'CWE-1037' => q"Processor Optimization Removal or Modification of Security-critical Code",
    'CWE-1038' => q"Insecure Automated Optimizations",
    'CWE-1039' =>
        "Automated Recognition Mechanism with Inadequate Detection or Handling of Adversarial Input Perturbations",
    'CWE-1041' => q"Use of Redundant Code",
    'CWE-1042' => q"Static Member Data Element outside of a Singleton Class Element",
    'CWE-1043' => q"Data Element Aggregating an Excessively Large Number of Non-Primitive Elements",
    'CWE-1044' => q"Architecture with Number of Horizontal Layers Outside of Expected Range",
    'CWE-1045' => q"Parent Class with a Virtual Destructor and a Child Class without a Virtual Destructor",
    'CWE-1046' => q"Creation of Immutable Text Using String Concatenation",
    'CWE-1047' => q"Modules with Circular Dependencies",
    'CWE-1048' => q"Invokable Control Element with Large Number of Outward Calls",
    'CWE-1049' => q"Excessive Data Query Operations in a Large Data Table",
    'CWE-1050' => q"Excessive Platform Resource Consumption within a Loop",
    'CWE-1051' => q"Initialization with Hard-Coded Network Resource Configuration Data",
    'CWE-1052' => q"Excessive Use of Hard-Coded Literals in Initialization",
    'CWE-1053' => q"Missing Documentation for Design",
    'CWE-1054' => q"Invocation of a Control Element at an Unnecessarily Deep Horizontal Layer",
    'CWE-1055' => q"Multiple Inheritance from Concrete Classes",
    'CWE-1056' => q"Invokable Control Element with Variadic Parameters",
    'CWE-1057' => q"Data Access Operations Outside of Expected Data Manager Component",
    'CWE-1058' => q"Invokable Control Element in Multi-Thread Context with non-Final Static Storable or Member Element",
    'CWE-1059' => q"Insufficient Technical Documentation",
    'CWE-1060' => q"Excessive Number of Inefficient Server-Side Data Accesses",
    'CWE-1061' => q"Insufficient Encapsulation",
    'CWE-1062' => q"Parent Class with References to Child Class",
    'CWE-1063' => q"Creation of Class Instance within a Static Code Block",
    'CWE-1064' => q"Invokable Control Element with Signature Containing an Excessive Number of Parameters",
    'CWE-1065' => q"Runtime Resource Management Control Element in a Component Built to Run on Application Servers",
    'CWE-1066' => q"Missing Serialization Control Element",
    'CWE-1067' => q"Excessive Execution of Sequential Searches of Data Resource",
    'CWE-1068' => q"Inconsistency Between Implementation and Documented Design",
    'CWE-1069' => q"Empty Exception Block",
    'CWE-1070' => q"Serializable Data Element Containing non-Serializable Item Elements",
    'CWE-1071' => q"Empty Code Block",
    'CWE-1072' => q"Data Resource Access without Use of Connection Pooling",
    'CWE-1073' => q"Non-SQL Invokable Control Element with Excessive Number of Data Resource Accesses",
    'CWE-1074' => q"Class with Excessively Deep Inheritance",
    'CWE-1075' => q"Unconditional Control Flow Transfer outside of Switch Block",
    'CWE-1076' => q"Insufficient Adherence to Expected Conventions",
    'CWE-1077' => q"Floating Point Comparison with Incorrect Operator",
    'CWE-1078' => q"Inappropriate Source Code Style or Formatting",
    'CWE-1079' => q"Parent Class without Virtual Destructor Method",
    'CWE-1080' => q"Source Code File with Excessive Number of Lines of Code",
    'CWE-1082' => q"Class Instance Self Destruction Control Element",
    'CWE-1083' => q"Data Access from Outside Expected Data Manager Component",
    'CWE-1084' => q"Invokable Control Element with Excessive File or Data Access Operations",
    'CWE-1085' => q"Invokable Control Element with Excessive Volume of Commented-out Code",
    'CWE-1086' => q"Class with Excessive Number of Child Classes",
    'CWE-1087' => q"Class with Virtual Method without a Virtual Destructor",
    'CWE-1088' => q"Synchronous Access of Remote Resource without Timeout",
    'CWE-1089' => q"Large Data Table with Excessive Number of Indices",
    'CWE-1090' => q"Method Containing Access of a Member Element from Another Class",
    'CWE-1091' => q"Use of Object without Invoking Destructor Method",
    'CWE-1092' => q"Use of Same Invokable Control Element in Multiple Architectural Layers",
    'CWE-1093' => q"Excessively Complex Data Representation",
    'CWE-1094' => q"Excessive Index Range Scan for a Data Resource",
    'CWE-1095' => q"Loop Condition Value Update within the Loop",
    'CWE-1096' => q"Singleton Class Instance Creation without Proper Locking or Synchronization",
    'CWE-1097' => q"Persistent Storable Data Element without Associated Comparison Control Element",
    'CWE-1098' => q"Data Element containing Pointer Item without Proper Copy Control Element",
    'CWE-1099' => q"Inconsistent Naming Conventions for Identifiers",
    'CWE-1100' => q"Insufficient Isolation of System-Dependent Functions",
    'CWE-1101' => q"Reliance on Runtime Component in Generated Code",
    'CWE-1102' => q"Reliance on Machine-Dependent Data Representation",
    'CWE-1103' => q"Use of Platform-Dependent Third Party Components",
    'CWE-1104' => q"Use of Unmaintained Third Party Components",
    'CWE-1105' => q"Insufficient Encapsulation of Machine-Dependent Functionality",
    'CWE-1106' => q"Insufficient Use of Symbolic Constants",
    'CWE-1107' => q"Insufficient Isolation of Symbolic Constant Definitions",
    'CWE-1108' => q"Excessive Reliance on Global Variables",
    'CWE-1109' => q"Use of Same Variable for Multiple Purposes",
    'CWE-1110' => q"Incomplete Design Documentation",
    'CWE-1111' => q"Incomplete I/O Documentation",
    'CWE-1112' => q"Incomplete Documentation of Program Execution",
    'CWE-1113' => q"Inappropriate Comment Style",
    'CWE-1114' => q"Inappropriate Whitespace Style",
    'CWE-1115' => q"Source Code Element without Standard Prologue",
    'CWE-1116' => q"Inaccurate Comments",
    'CWE-1117' => q"Callable with Insufficient Behavioral Summary",
    'CWE-1118' => q"Insufficient Documentation of Error Handling Techniques",
    'CWE-1119' => q"Excessive Use of Unconditional Branching",
    'CWE-1120' => q"Excessive Code Complexity",
    'CWE-1121' => q"Excessive McCabe Cyclomatic Complexity",
    'CWE-1122' => q"Excessive Halstead Complexity",
    'CWE-1123' => q"Excessive Use of Self-Modifying Code",
    'CWE-1124' => q"Excessively Deep Nesting",
    'CWE-1125' => q"Excessive Attack Surface",
    'CWE-1126' => q"Declaration of Variable with Unnecessarily Wide Scope",
    'CWE-1127' => q"Compilation with Insufficient Warnings or Errors",
    'CWE-1164' => q"Irrelevant Code",
    'CWE-1173' => q"Improper Use of Validation Framework",
    'CWE-1174' => q"ASP.NET Misconfiguration: Improper Model Validation",
    'CWE-1176' => q"Inefficient CPU Computation",
    'CWE-1177' => q"Use of Prohibited Code",
    'CWE-1187' => q"DEPRECATED: Use of Uninitialized Resource",
    'CWE-1188' => q"Initialization of a Resource with an Insecure Default",
    'CWE-1189' => q"Improper Isolation of Shared Resources on System-on-a-Chip (SoC)",
    'CWE-1190' => q"DMA Device Enabled Too Early in Boot Phase",
    'CWE-1191' => q"On-Chip Debug and Test Interface With Improper Access Control",
    'CWE-1192' => q"Improper Identifier for IP Block used in System-On-Chip (SOC)",
    'CWE-1193' => q"Power-On of Untrusted Execution Core Before Enabling Fabric Access Control",
    'CWE-1204' => q"Generation of Weak Initialization Vector (IV)",
    'CWE-1209' => q"Failure to Disable Reserved Bits",
    'CWE-1220' => q"Insufficient Granularity of Access Control",
    'CWE-1221' => q"Incorrect Register Defaults or Module Parameters",
    'CWE-1222' => q"Insufficient Granularity of Address Regions Protected by Register Locks",
    'CWE-1223' => q"Race Condition for Write-Once Attributes",
    'CWE-1224' => q"Improper Restriction of Write-Once Bit Fields",
    'CWE-1229' => q"Creation of Emergent Resource",
    'CWE-1230' => q"Exposure of Sensitive Information Through Metadata",
    'CWE-1231' => q"Improper Prevention of Lock Bit Modification",
    'CWE-1232' => q"Improper Lock Behavior After Power State Transition",
    'CWE-1233' => q"Security-Sensitive Hardware Controls with Missing Lock Bit Protection",
    'CWE-1234' => q"Hardware Internal or Debug Modes Allow Override of Locks",
    'CWE-1235' => q"Incorrect Use of Autoboxing and Unboxing for Performance Critical Operations",
    'CWE-1236' => q"Improper Neutralization of Formula Elements in a CSV File",
    'CWE-1239' => q"Improper Zeroization of Hardware Register",
    'CWE-1240' => q"Use of a Cryptographic Primitive with a Risky Implementation",
    'CWE-1241' => q"Use of Predictable Algorithm in Random Number Generator",
    'CWE-1242' => q"Inclusion of Undocumented Features or Chicken Bits",
    'CWE-1243' => q"Sensitive Non-Volatile Information Not Protected During Debug",
    'CWE-1244' => q"Internal Asset Exposed to Unsafe Debug Access Level or State",
    'CWE-1245' => q"Improper Finite State Machines (FSMs) in Hardware Logic",
    'CWE-1246' => q"Improper Write Handling in Limited-write Non-Volatile Memories",
    'CWE-1247' => q"Improper Protection Against Voltage and Clock Glitches",
    'CWE-1248' => q"Semiconductor Defects in Hardware Logic with Security-Sensitive Implications",
    'CWE-1249' => q"Application-Level Admin Tool with Inconsistent View of Underlying Operating System",
    'CWE-1250' => q"Improper Preservation of Consistency Between Independent Representations of Shared State",
    'CWE-1251' => q"Mirrored Regions with Different Values",
    'CWE-1252' => q"CPU Hardware Not Configured to Support Exclusivity of Write and Execute Operations",
    'CWE-1253' => q"Incorrect Selection of Fuse Values",
    'CWE-1254' => q"Incorrect Comparison Logic Granularity",
    'CWE-1255' => q"Comparison Logic is Vulnerable to Power Side-Channel Attacks",
    'CWE-1256' => q"Improper Restriction of Software Interfaces to Hardware Features",
    'CWE-1257' => q"Improper Access Control Applied to Mirrored or Aliased Memory Regions",
    'CWE-1258' => q"Exposure of Sensitive System Information Due to Uncleared Debug Information",
    'CWE-1259' => q"Improper Restriction of Security Token Assignment",
    'CWE-1260' => q"Improper Handling of Overlap Between Protected Memory Ranges",
    'CWE-1261' => q"Improper Handling of Single Event Upsets",
    'CWE-1262' => q"Improper Access Control for Register Interface",
    'CWE-1263' => q"Improper Physical Access Control",
    'CWE-1264' => q"Hardware Logic with Insecure De-Synchronization between Control and Data Channels",
    'CWE-1265' => q"Unintended Reentrant Invocation of Non-reentrant Code Via Nested Calls",
    'CWE-1266' => q"Improper Scrubbing of Sensitive Data from Decommissioned Device",
    'CWE-1267' => q"Policy Uses Obsolete Encoding",
    'CWE-1268' => q"Policy Privileges are not Assigned Consistently Between Control and Data Agents",
    'CWE-1269' => q"Product Released in Non-Release Configuration",
    'CWE-1270' => q"Generation of Incorrect Security Tokens",
    'CWE-1271' => q"Uninitialized Value on Reset for Registers Holding Security Settings",
    'CWE-1272' => q"Sensitive Information Uncleared Before Debug/Power State Transition",
    'CWE-1273' => q"Device Unlock Credential Sharing",
    'CWE-1274' => q"Improper Access Control for Volatile Memory Containing Boot Code",
    'CWE-1275' => q"Sensitive Cookie with Improper SameSite Attribute",
    'CWE-1276' => q"Hardware Child Block Incorrectly Connected to Parent System",
    'CWE-1277' => q"Firmware Not Updateable",
    'CWE-1278' =>
        "Missing Protection Against Hardware Reverse Engineering Using Integrated Circuit (IC) Imaging Techniques",
    'CWE-1279' => q"Cryptographic Operations are run Before Supporting Units are Ready",
    'CWE-1280' => q"Access Control Check Implemented After Asset is Accessed",
    'CWE-1281' => q"Sequence of Processor Instructions Leads to Unexpected Behavior",
    'CWE-1282' => q"Assumed-Immutable Data is Stored in Writable Memory",
    'CWE-1283' => q"Mutable Attestation or Measurement Reporting Data",
    'CWE-1284' => q"Improper Validation of Specified Quantity in Input",
    'CWE-1285' => q"Improper Validation of Specified Index, Position, or Offset in Input",
    'CWE-1286' => q"Improper Validation of Syntactic Correctness of Input",
    'CWE-1287' => q"Improper Validation of Specified Type of Input",
    'CWE-1288' => q"Improper Validation of Consistency within Input",
    'CWE-1289' => q"Improper Validation of Unsafe Equivalence in Input",
    'CWE-1290' => q"Incorrect Decoding of Security Identifiers ",
    'CWE-1291' => q"Public Key Re-Use for Signing both Debug and Production Code",
    'CWE-1292' => q"Incorrect Conversion of Security Identifiers",
    'CWE-1293' => q"Missing Source Correlation of Multiple Independent Data",
    'CWE-1294' => q"Insecure Security Identifier Mechanism",
    'CWE-1295' => q"Debug Messages Revealing Unnecessary Information",
    'CWE-1296' => q"Incorrect Chaining or Granularity of Debug Components",
    'CWE-1297' => q"Unprotected Confidential Information on Device is Accessible by OSAT Vendors",
    'CWE-1298' => q"Hardware Logic Contains Race Conditions",
    'CWE-1299' => q"Missing Protection Mechanism for Alternate Hardware Interface",
    'CWE-1300' => q"Improper Protection of Physical Side Channels",
    'CWE-1301' => q"Insufficient or Incomplete Data Removal within Hardware Component",
    'CWE-1302' => q"Missing Source Identifier in Entity Transactions on a System-On-Chip (SOC)",
    'CWE-1303' => q"Non-Transparent Sharing of Microarchitectural Resources",
    'CWE-1304' =>
        "Improperly Preserved Integrity of Hardware Configuration State During a Power Save/Restore Operation",
    'CWE-1310' => q"Missing Ability to Patch ROM Code",
    'CWE-1311' => q"Improper Translation of Security Attributes by Fabric Bridge",
    'CWE-1312' => q"Missing Protection for Mirrored Regions in On-Chip Fabric Firewall",
    'CWE-1313' => q"Hardware Allows Activation of Test or Debug Logic at Runtime",
    'CWE-1314' => q"Missing Write Protection for Parametric Data Values",
    'CWE-1315' => q"Improper Setting of Bus Controlling Capability in Fabric End-point",
    'CWE-1316' => q"Fabric-Address Map Allows Programming of Unwarranted Overlaps of Protected and Unprotected Ranges",
    'CWE-1317' => q"Improper Access Control in Fabric Bridge",
    'CWE-1318' => q"Missing Support for Security Features in On-chip Fabrics or Buses",
    'CWE-1319' => q"Improper Protection against Electromagnetic Fault Injection (EM-FI)",
    'CWE-1320' => q"Improper Protection for Outbound Error Messages and Alert Signals",
    'CWE-1321' => q"Improperly Controlled Modification of Object Prototype Attributes ('Prototype Pollution')",
    'CWE-1322' => q"Use of Blocking Code in Single-threaded, Non-blocking Context",
    'CWE-1323' => q"Improper Management of Sensitive Trace Data",
    'CWE-1324' => q"DEPRECATED: Sensitive Information Accessible by Physical Probing of JTAG Interface",
    'CWE-1325' => q"Improperly Controlled Sequential Memory Allocation",
    'CWE-1326' => q"Missing Immutable Root of Trust in Hardware",
    'CWE-1327' => q"Binding to an Unrestricted IP Address",
    'CWE-1328' => q"Security Version Number Mutable to Older Versions",
    'CWE-1329' => q"Reliance on Component That is Not Updateable",
    'CWE-1330' => q"Remanent Data Readable after Memory Erase",
    'CWE-1331' => q"Improper Isolation of Shared Resources in Network On Chip (NoC)",
    'CWE-1332' => q"Improper Handling of Faults that Lead to Instruction Skips",
    'CWE-1333' => q"Inefficient Regular Expression Complexity",
    'CWE-1334' => q"Unauthorized Error Injection Can Degrade Hardware Redundancy",
    'CWE-1335' => q"Incorrect Bitwise Shift of Integer",
    'CWE-1336' => q"Improper Neutralization of Special Elements Used in a Template Engine",
    'CWE-1338' => q"Improper Protections Against Hardware Overheating",
    'CWE-1339' => q"Insufficient Precision or Accuracy of a Real Number",
    'CWE-1341' => q"Multiple Releases of Same Resource or Handle",
    'CWE-1342' => q"Information Exposure through Microarchitectural State after Transient Execution",
    'CWE-1351' => q"Improper Handling of Hardware Behavior in Exceptionally Cold Environments",
    'CWE-1357' => q"Reliance on Insufficiently Trustworthy Component",
    'CWE-1384' => q"Improper Handling of Physical or Environmental Conditions",
    'CWE-1385' => q"Missing Origin Validation in WebSockets",
    'CWE-1386' => q"Insecure Operation on Windows Junction / Mount Point",
    'CWE-1389' => q"Incorrect Parsing of Numbers with Different Radices",
    'CWE-1390' => q"Weak Authentication",
    'CWE-1391' => q"Use of Weak Credentials",
    'CWE-1392' => q"Use of Default Credentials",
    'CWE-1393' => q"Use of Default Password",
    'CWE-1394' => q"Use of Default Cryptographic Key",
    'CWE-1395' => q"Dependency on Vulnerable Third-Party Component",
    'CWE-1419' => q"Incorrect Initialization of Resource",
    'CWE-1420' => q"Exposure of Sensitive Information during Transient Execution",
    'CWE-1421' =>
        "Exposure of Sensitive Information in Shared Microarchitectural Structures during Transient Execution",
    'CWE-1422' => q"Exposure of Sensitive Information caused by Incorrect Data Forwarding during Transient Execution",
    'CWE-1423' =>
        "Exposure of Sensitive Information caused by Shared Microarchitectural Predictor State that Influences Transient Execution",

    # CATEGORY
    'CWE-1'   => q"DEPRECATED: Location",
    'CWE-2'   => q"7PK - Environment",
    'CWE-3'   => q"DEPRECATED: Technology-specific Environment Issues",
    'CWE-4'   => q"DEPRECATED: J2EE Environment Issues",
    'CWE-10'  => q"DEPRECATED: ASP.NET Environment Issues",
    'CWE-16'  => q"Configuration",
    'CWE-17'  => q"DEPRECATED: Code",
    'CWE-18'  => q"DEPRECATED: Source Code",
    'CWE-19'  => q"Data Processing Errors",
    'CWE-21'  => q"DEPRECATED: Pathname Traversal and Equivalence Errors",
    'CWE-60'  => q"DEPRECATED: UNIX Path Link Problems",
    'CWE-63'  => q"DEPRECATED: Windows Path Link Problems",
    'CWE-68'  => q"DEPRECATED: Windows Virtual File Problems",
    'CWE-70'  => q"DEPRECATED: Mac Virtual File Problems",
    'CWE-100' => q"DEPRECATED: Technology-Specific Input Validation Problems",
    'CWE-101' => q"DEPRECATED: Struts Validation Problems",
    'CWE-133' => q"String Errors",
    'CWE-136' => q"Type Errors",
    'CWE-137' => q"Data Neutralization Issues",
    'CWE-139' => q"DEPRECATED: General Special Element Problems",
    'CWE-169' => q"DEPRECATED: Technology-Specific Special Elements",
    'CWE-171' => q"DEPRECATED: Cleansing, Canonicalization, and Comparison Errors",
    'CWE-189' => q"Numeric Errors",
    'CWE-199' => q"Information Management Errors",
    'CWE-227' => q"7PK - API Abuse",
    'CWE-251' => q"Often Misused: String Management",
    'CWE-254' => q"7PK - Security Features",
    'CWE-255' => q"Credentials Management Errors",
    'CWE-264' => q"Permissions, Privileges, and Access Controls",
    'CWE-265' => q"Privilege Issues",
    'CWE-275' => q"Permission Issues",
    'CWE-310' => q"Cryptographic Issues",
    'CWE-320' => q"Key Management Errors",
    'CWE-355' => q"User Interface Security Issues",
    'CWE-361' => q"7PK - Time and State",
    'CWE-371' => q"State Issues",
    'CWE-376' => q"DEPRECATED: Temporary File Issues",
    'CWE-380' => q"DEPRECATED: Technology-Specific Time and State Issues",
    'CWE-381' => q"DEPRECATED: J2EE Time and State Issues",
    'CWE-387' => q"Signal Errors",
    'CWE-388' => q"7PK - Errors",
    'CWE-389' => q"Error Conditions, Return Values, Status Codes",
    'CWE-398' => q"7PK - Code Quality",
    'CWE-399' => q"Resource Management Errors",
    'CWE-411' => q"Resource Locking Problems",
    'CWE-417' => q"Communication Channel Errors",
    'CWE-418' => q"DEPRECATED: Channel Errors",
    'CWE-429' => q"Handler Errors",
    'CWE-438' => q"Behavioral Problems",
    'CWE-442' => q"DEPRECATED: Web Problems",
    'CWE-445' => q"DEPRECATED: User Interface Errors",
    'CWE-452' => q"Initialization and Cleanup Errors",
    'CWE-461' => q"DEPRECATED: Data Structure Issues",
    'CWE-465' => q"Pointer Issues",
    'CWE-485' => q"7PK - Encapsulation",
    'CWE-490' => q"DEPRECATED: Mobile Code Issues",
    'CWE-503' => q"DEPRECATED: Byte/Object Code",
    'CWE-504' => q"DEPRECATED: Motivation/Intent",
    'CWE-505' => q"DEPRECATED: Intentionally Introduced Weakness",
    'CWE-513' => q"DEPRECATED: Intentionally Introduced Nonmalicious Weakness",
    'CWE-517' => q"DEPRECATED: Other Intentional, Nonmalicious Weakness",
    'CWE-518' => q"DEPRECATED: Inadvertently Introduced Weakness",
    'CWE-519' => q"DEPRECATED: .NET Environment Issues",
    'CWE-557' => q"Concurrency Issues",
    'CWE-559' => q"DEPRECATED: Often Misused: Arguments and Parameters",
    'CWE-569' => q"Expression Issues",
    'CWE-632' => q"DEPRECATED: Weaknesses that Affect Files or Directories",
    'CWE-633' => q"DEPRECATED: Weaknesses that Affect Memory",
    'CWE-634' => q"DEPRECATED: Weaknesses that Affect System Processes",
    'CWE-712' => q"OWASP Top Ten 2007 Category A1 - Cross Site Scripting (XSS)",
    'CWE-713' => q"OWASP Top Ten 2007 Category A2 - Injection Flaws",
    'CWE-714' => q"OWASP Top Ten 2007 Category A3 - Malicious File Execution",
    'CWE-715' => q"OWASP Top Ten 2007 Category A4 - Insecure Direct Object Reference",
    'CWE-716' => q"OWASP Top Ten 2007 Category A5 - Cross Site Request Forgery (CSRF)",
    'CWE-717' => q"OWASP Top Ten 2007 Category A6 - Information Leakage and Improper Error Handling",
    'CWE-718' => q"OWASP Top Ten 2007 Category A7 - Broken Authentication and Session Management",
    'CWE-719' => q"OWASP Top Ten 2007 Category A8 - Insecure Cryptographic Storage",
    'CWE-720' => q"OWASP Top Ten 2007 Category A9 - Insecure Communications",
    'CWE-721' => q"OWASP Top Ten 2007 Category A10 - Failure to Restrict URL Access",
    'CWE-722' => q"OWASP Top Ten 2004 Category A1 - Unvalidated Input",
    'CWE-723' => q"OWASP Top Ten 2004 Category A2 - Broken Access Control",
    'CWE-724' => q"OWASP Top Ten 2004 Category A3 - Broken Authentication and Session Management",
    'CWE-725' => q"OWASP Top Ten 2004 Category A4 - Cross-Site Scripting (XSS) Flaws",
    'CWE-726' => q"OWASP Top Ten 2004 Category A5 - Buffer Overflows",
    'CWE-727' => q"OWASP Top Ten 2004 Category A6 - Injection Flaws",
    'CWE-728' => q"OWASP Top Ten 2004 Category A7 - Improper Error Handling",
    'CWE-729' => q"OWASP Top Ten 2004 Category A8 - Insecure Storage",
    'CWE-730' => q"OWASP Top Ten 2004 Category A9 - Denial of Service",
    'CWE-731' => q"OWASP Top Ten 2004 Category A10 - Insecure Configuration Management",
    'CWE-735' => q"CERT C Secure Coding Standard (2008) Chapter 2 - Preprocessor (PRE)",
    'CWE-736' => q"CERT C Secure Coding Standard (2008) Chapter 3 - Declarations and Initialization (DCL)",
    'CWE-737' => q"CERT C Secure Coding Standard (2008) Chapter 4 - Expressions (EXP)",
    'CWE-738' => q"CERT C Secure Coding Standard (2008) Chapter 5 - Integers (INT)",
    'CWE-739' => q"CERT C Secure Coding Standard (2008) Chapter 6 - Floating Point (FLP)",
    'CWE-740' => q"CERT C Secure Coding Standard (2008) Chapter 7 - Arrays (ARR)",
    'CWE-741' => q"CERT C Secure Coding Standard (2008) Chapter 8 - Characters and Strings (STR)",
    'CWE-742' => q"CERT C Secure Coding Standard (2008) Chapter 9 - Memory Management (MEM)",
    'CWE-743' => q"CERT C Secure Coding Standard (2008) Chapter 10 - Input Output (FIO)",
    'CWE-744' => q"CERT C Secure Coding Standard (2008) Chapter 11 - Environment (ENV)",
    'CWE-745' => q"CERT C Secure Coding Standard (2008) Chapter 12 - Signals (SIG)",
    'CWE-746' => q"CERT C Secure Coding Standard (2008) Chapter 13 - Error Handling (ERR)",
    'CWE-747' => q"CERT C Secure Coding Standard (2008) Chapter 14 - Miscellaneous (MSC)",
    'CWE-748' => q"CERT C Secure Coding Standard (2008) Appendix - POSIX (POS)",
    'CWE-751' => q"2009 Top 25 - Insecure Interaction Between Components",
    'CWE-752' => q"2009 Top 25 - Risky Resource Management",
    'CWE-753' => q"2009 Top 25 - Porous Defenses",
    'CWE-801' => q"2010 Top 25 - Insecure Interaction Between Components",
    'CWE-802' => q"2010 Top 25 - Risky Resource Management",
    'CWE-803' => q"2010 Top 25 - Porous Defenses",
    'CWE-808' => q"2010 Top 25 - Weaknesses On the Cusp",
    'CWE-810' => q"OWASP Top Ten 2010 Category A1 - Injection",
    'CWE-811' => q"OWASP Top Ten 2010 Category A2 - Cross-Site Scripting (XSS)",
    'CWE-812' => q"OWASP Top Ten 2010 Category A3 - Broken Authentication and Session Management",
    'CWE-813' => q"OWASP Top Ten 2010 Category A4 - Insecure Direct Object References",
    'CWE-814' => q"OWASP Top Ten 2010 Category A5 - Cross-Site Request Forgery(CSRF)",
    'CWE-815' => q"OWASP Top Ten 2010 Category A6 - Security Misconfiguration",
    'CWE-816' => q"OWASP Top Ten 2010 Category A7 - Insecure Cryptographic Storage",
    'CWE-817' => q"OWASP Top Ten 2010 Category A8 - Failure to Restrict URL Access",
    'CWE-818' => q"OWASP Top Ten 2010 Category A9 - Insufficient Transport Layer Protection",
    'CWE-819' => q"OWASP Top Ten 2010 Category A10 - Unvalidated Redirects and Forwards",
    'CWE-840' => q"Business Logic Errors",
    'CWE-845' =>
        q"The CERT Oracle Secure Coding Standard for Java (2011) Chapter 2 - Input Validation and Data Sanitization (IDS)",
    'CWE-846' =>
        q"The CERT Oracle Secure Coding Standard for Java (2011) Chapter 3 - Declarations and Initialization (DCL)",
    'CWE-847' => q"The CERT Oracle Secure Coding Standard for Java (2011) Chapter 4 - Expressions (EXP)",
    'CWE-848' =>
        q"The CERT Oracle Secure Coding Standard for Java (2011) Chapter 5 - Numeric Types and Operations (NUM)",
    'CWE-849' => q"The CERT Oracle Secure Coding Standard for Java (2011) Chapter 6 - Object Orientation (OBJ)",
    'CWE-850' => q"The CERT Oracle Secure Coding Standard for Java (2011) Chapter 7 - Methods (MET)",
    'CWE-851' => q"The CERT Oracle Secure Coding Standard for Java (2011) Chapter 8 - Exceptional Behavior (ERR)",
    'CWE-852' => q"The CERT Oracle Secure Coding Standard for Java (2011) Chapter 9 - Visibility and Atomicity (VNA)",
    'CWE-853' => q"The CERT Oracle Secure Coding Standard for Java (2011) Chapter 10 - Locking (LCK)",
    'CWE-854' => q"The CERT Oracle Secure Coding Standard for Java (2011) Chapter 11 - Thread APIs (THI)",
    'CWE-855' => q"The CERT Oracle Secure Coding Standard for Java (2011) Chapter 12 - Thread Pools (TPS)",
    'CWE-856' =>
        q"The CERT Oracle Secure Coding Standard for Java (2011) Chapter 13 - Thread-Safety Miscellaneous (TSM)",
    'CWE-857'  => q"The CERT Oracle Secure Coding Standard for Java (2011) Chapter 14 - Input Output (FIO)",
    'CWE-858'  => q"The CERT Oracle Secure Coding Standard for Java (2011) Chapter 15 - Serialization (SER)",
    'CWE-859'  => q"The CERT Oracle Secure Coding Standard for Java (2011) Chapter 16 - Platform Security (SEC)",
    'CWE-860'  => q"The CERT Oracle Secure Coding Standard for Java (2011) Chapter 17 - Runtime Environment (ENV)",
    'CWE-861'  => q"The CERT Oracle Secure Coding Standard for Java (2011) Chapter 18 - Miscellaneous (MSC)",
    'CWE-864'  => q"2011 Top 25 - Insecure Interaction Between Components",
    'CWE-865'  => q"2011 Top 25 - Risky Resource Management",
    'CWE-866'  => q"2011 Top 25 - Porous Defenses",
    'CWE-867'  => q"2011 Top 25 - Weaknesses On the Cusp",
    'CWE-869'  => q"CERT C++ Secure Coding Section 01 - Preprocessor (PRE)",
    'CWE-870'  => q"CERT C++ Secure Coding Section 02 - Declarations and Initialization (DCL)",
    'CWE-871'  => q"CERT C++ Secure Coding Section 03 - Expressions (EXP)",
    'CWE-872'  => q"CERT C++ Secure Coding Section 04 - Integers (INT)",
    'CWE-873'  => q"CERT C++ Secure Coding Section 05 - Floating Point Arithmetic (FLP)",
    'CWE-874'  => q"CERT C++ Secure Coding Section 06 - Arrays and the STL (ARR)",
    'CWE-875'  => q"CERT C++ Secure Coding Section 07 - Characters and Strings (STR)",
    'CWE-876'  => q"CERT C++ Secure Coding Section 08 - Memory Management (MEM)",
    'CWE-877'  => q"CERT C++ Secure Coding Section 09 - Input Output (FIO)",
    'CWE-878'  => q"CERT C++ Secure Coding Section 10 - Environment (ENV)",
    'CWE-879'  => q"CERT C++ Secure Coding Section 11 - Signals (SIG)",
    'CWE-880'  => q"CERT C++ Secure Coding Section 12 - Exceptions and Error Handling (ERR)",
    'CWE-881'  => q"CERT C++ Secure Coding Section 13 - Object Oriented Programming (OOP)",
    'CWE-882'  => q"CERT C++ Secure Coding Section 14 - Concurrency (CON)",
    'CWE-883'  => q"CERT C++ Secure Coding Section 49 - Miscellaneous (MSC)",
    'CWE-885'  => q"SFP Primary Cluster: Risky Values",
    'CWE-886'  => q"SFP Primary Cluster: Unused entities",
    'CWE-887'  => q"SFP Primary Cluster: API",
    'CWE-889'  => q"SFP Primary Cluster: Exception Management",
    'CWE-890'  => q"SFP Primary Cluster: Memory Access",
    'CWE-891'  => q"SFP Primary Cluster: Memory Management",
    'CWE-892'  => q"SFP Primary Cluster: Resource Management",
    'CWE-893'  => q"SFP Primary Cluster: Path Resolution",
    'CWE-894'  => q"SFP Primary Cluster: Synchronization",
    'CWE-895'  => q"SFP Primary Cluster: Information Leak",
    'CWE-896'  => q"SFP Primary Cluster: Tainted Input",
    'CWE-897'  => q"SFP Primary Cluster: Entry Points",
    'CWE-898'  => q"SFP Primary Cluster: Authentication",
    'CWE-899'  => q"SFP Primary Cluster: Access Control",
    'CWE-901'  => q"SFP Primary Cluster: Privilege",
    'CWE-902'  => q"SFP Primary Cluster: Channel",
    'CWE-903'  => q"SFP Primary Cluster: Cryptography",
    'CWE-904'  => q"SFP Primary Cluster: Malware",
    'CWE-905'  => q"SFP Primary Cluster: Predictability",
    'CWE-906'  => q"SFP Primary Cluster: UI",
    'CWE-907'  => q"SFP Primary Cluster: Other",
    'CWE-929'  => q"OWASP Top Ten 2013 Category A1 - Injection",
    'CWE-930'  => q"OWASP Top Ten 2013 Category A2 - Broken Authentication and Session Management",
    'CWE-931'  => q"OWASP Top Ten 2013 Category A3 - Cross-Site Scripting (XSS)",
    'CWE-932'  => q"OWASP Top Ten 2013 Category A4 - Insecure Direct Object References",
    'CWE-933'  => q"OWASP Top Ten 2013 Category A5 - Security Misconfiguration",
    'CWE-934'  => q"OWASP Top Ten 2013 Category A6 - Sensitive Data Exposure",
    'CWE-935'  => q"OWASP Top Ten 2013 Category A7 - Missing Function Level Access Control",
    'CWE-936'  => q"OWASP Top Ten 2013 Category A8 - Cross-Site Request Forgery (CSRF)",
    'CWE-937'  => q"OWASP Top Ten 2013 Category A9 - Using Components with Known Vulnerabilities",
    'CWE-938'  => q"OWASP Top Ten 2013 Category A10 - Unvalidated Redirects and Forwards",
    'CWE-944'  => q"SFP Secondary Cluster: Access Management",
    'CWE-945'  => q"SFP Secondary Cluster: Insecure Resource Access",
    'CWE-946'  => q"SFP Secondary Cluster: Insecure Resource Permissions",
    'CWE-947'  => q"SFP Secondary Cluster: Authentication Bypass",
    'CWE-948'  => q"SFP Secondary Cluster: Digital Certificate",
    'CWE-949'  => q"SFP Secondary Cluster: Faulty Endpoint Authentication",
    'CWE-950'  => q"SFP Secondary Cluster: Hardcoded Sensitive Data",
    'CWE-951'  => q"SFP Secondary Cluster: Insecure Authentication Policy",
    'CWE-952'  => q"SFP Secondary Cluster: Missing Authentication",
    'CWE-953'  => q"SFP Secondary Cluster: Missing Endpoint Authentication",
    'CWE-954'  => q"SFP Secondary Cluster: Multiple Binds to the Same Port",
    'CWE-955'  => q"SFP Secondary Cluster: Unrestricted Authentication",
    'CWE-956'  => q"SFP Secondary Cluster: Channel Attack",
    'CWE-957'  => q"SFP Secondary Cluster: Protocol Error",
    'CWE-958'  => q"SFP Secondary Cluster: Broken Cryptography",
    'CWE-959'  => q"SFP Secondary Cluster: Weak Cryptography",
    'CWE-960'  => q"SFP Secondary Cluster: Ambiguous Exception Type",
    'CWE-961'  => q"SFP Secondary Cluster: Incorrect Exception Behavior",
    'CWE-962'  => q"SFP Secondary Cluster: Unchecked Status Condition",
    'CWE-963'  => q"SFP Secondary Cluster: Exposed Data",
    'CWE-964'  => q"SFP Secondary Cluster: Exposure Temporary File",
    'CWE-965'  => q"SFP Secondary Cluster: Insecure Session Management",
    'CWE-966'  => q"SFP Secondary Cluster: Other Exposures",
    'CWE-967'  => q"SFP Secondary Cluster: State Disclosure",
    'CWE-968'  => q"SFP Secondary Cluster: Covert Channel",
    'CWE-969'  => q"SFP Secondary Cluster: Faulty Memory Release",
    'CWE-970'  => q"SFP Secondary Cluster: Faulty Buffer Access",
    'CWE-971'  => q"SFP Secondary Cluster: Faulty Pointer Use",
    'CWE-972'  => q"SFP Secondary Cluster: Faulty String Expansion",
    'CWE-973'  => q"SFP Secondary Cluster: Improper NULL Termination",
    'CWE-974'  => q"SFP Secondary Cluster: Incorrect Buffer Length Computation",
    'CWE-975'  => q"SFP Secondary Cluster: Architecture",
    'CWE-976'  => q"SFP Secondary Cluster: Compiler",
    'CWE-977'  => q"SFP Secondary Cluster: Design",
    'CWE-978'  => q"SFP Secondary Cluster: Implementation",
    'CWE-979'  => q"SFP Secondary Cluster: Failed Chroot Jail",
    'CWE-980'  => q"SFP Secondary Cluster: Link in Resource Name Resolution",
    'CWE-981'  => q"SFP Secondary Cluster: Path Traversal",
    'CWE-982'  => q"SFP Secondary Cluster: Failure to Release Resource",
    'CWE-983'  => q"SFP Secondary Cluster: Faulty Resource Use",
    'CWE-984'  => q"SFP Secondary Cluster: Life Cycle",
    'CWE-985'  => q"SFP Secondary Cluster: Unrestricted Consumption",
    'CWE-986'  => q"SFP Secondary Cluster: Missing Lock",
    'CWE-987'  => q"SFP Secondary Cluster: Multiple Locks/Unlocks",
    'CWE-988'  => q"SFP Secondary Cluster: Race Condition Window",
    'CWE-989'  => q"SFP Secondary Cluster: Unrestricted Lock",
    'CWE-990'  => q"SFP Secondary Cluster: Tainted Input to Command",
    'CWE-991'  => q"SFP Secondary Cluster: Tainted Input to Environment",
    'CWE-992'  => q"SFP Secondary Cluster: Faulty Input Transformation",
    'CWE-993'  => q"SFP Secondary Cluster: Incorrect Input Handling",
    'CWE-994'  => q"SFP Secondary Cluster: Tainted Input to Variable",
    'CWE-995'  => q"SFP Secondary Cluster: Feature",
    'CWE-996'  => q"SFP Secondary Cluster: Security",
    'CWE-997'  => q"SFP Secondary Cluster: Information Loss",
    'CWE-998'  => q"SFP Secondary Cluster: Glitch in Computation",
    'CWE-1001' => q"SFP Secondary Cluster: Use of an Improper API",
    'CWE-1002' => q"SFP Secondary Cluster: Unexpected Entry Points",
    'CWE-1005' => q"7PK - Input Validation and Representation",
    'CWE-1006' => q"Bad Coding Practices",
    'CWE-1009' => q"Audit",
    'CWE-1010' => q"Authenticate Actors",
    'CWE-1011' => q"Authorize Actors",
    'CWE-1012' => q"Cross Cutting",
    'CWE-1013' => q"Encrypt Data",
    'CWE-1014' => q"Identify Actors",
    'CWE-1015' => q"Limit Access",
    'CWE-1016' => q"Limit Exposure",
    'CWE-1017' => q"Lock Computer",
    'CWE-1018' => q"Manage User Sessions",
    'CWE-1019' => q"Validate Inputs",
    'CWE-1020' => q"Verify Message Integrity",
    'CWE-1027' => q"OWASP Top Ten 2017 Category A1 - Injection",
    'CWE-1028' => q"OWASP Top Ten 2017 Category A2 - Broken Authentication",
    'CWE-1029' => q"OWASP Top Ten 2017 Category A3 - Sensitive Data Exposure",
    'CWE-1030' => q"OWASP Top Ten 2017 Category A4 - XML External Entities (XXE)",
    'CWE-1031' => q"OWASP Top Ten 2017 Category A5 - Broken Access Control",
    'CWE-1032' => q"OWASP Top Ten 2017 Category A6 - Security Misconfiguration",
    'CWE-1033' => q"OWASP Top Ten 2017 Category A7 - Cross-Site Scripting (XSS)",
    'CWE-1034' => q"OWASP Top Ten 2017 Category A8 - Insecure Deserialization",
    'CWE-1035' => q"OWASP Top Ten 2017 Category A9 - Using Components with Known Vulnerabilities",
    'CWE-1036' => q"OWASP Top Ten 2017 Category A10 - Insufficient Logging & Monitoring",
    'CWE-1129' => q"CISQ Quality Measures (2016) - Reliability",
    'CWE-1130' => q"CISQ Quality Measures (2016) - Maintainability",
    'CWE-1131' => q"CISQ Quality Measures (2016) - Security",
    'CWE-1132' => q"CISQ Quality Measures (2016) - Performance Efficiency",
    'CWE-1134' =>
        q"SEI CERT Oracle Secure Coding Standard for Java - Guidelines 00. Input Validation and Data Sanitization (IDS)",
    'CWE-1135' =>
        q"SEI CERT Oracle Secure Coding Standard for Java - Guidelines 01. Declarations and Initialization (DCL)",
    'CWE-1136' => q"SEI CERT Oracle Secure Coding Standard for Java - Guidelines 02. Expressions (EXP)",
    'CWE-1137' =>
        q"SEI CERT Oracle Secure Coding Standard for Java - Guidelines 03. Numeric Types and Operations (NUM)",
    'CWE-1138' => q"SEI CERT Oracle Secure Coding Standard for Java - Guidelines 04. Characters and Strings (STR)",
    'CWE-1139' => q"SEI CERT Oracle Secure Coding Standard for Java - Guidelines 05. Object Orientation (OBJ)",
    'CWE-1140' => q"SEI CERT Oracle Secure Coding Standard for Java - Guidelines 06. Methods (MET)",
    'CWE-1141' => q"SEI CERT Oracle Secure Coding Standard for Java - Guidelines 07. Exceptional Behavior (ERR)",
    'CWE-1142' => q"SEI CERT Oracle Secure Coding Standard for Java - Guidelines 08. Visibility and Atomicity (VNA)",
    'CWE-1143' => q"SEI CERT Oracle Secure Coding Standard for Java - Guidelines 09. Locking (LCK)",
    'CWE-1144' => q"SEI CERT Oracle Secure Coding Standard for Java - Guidelines 10. Thread APIs (THI)",
    'CWE-1145' => q"SEI CERT Oracle Secure Coding Standard for Java - Guidelines 11. Thread Pools (TPS)",
    'CWE-1146' => q"SEI CERT Oracle Secure Coding Standard for Java - Guidelines 12. Thread-Safety Miscellaneous (TSM)",
    'CWE-1147' => q"SEI CERT Oracle Secure Coding Standard for Java - Guidelines 13. Input Output (FIO)",
    'CWE-1148' => q"SEI CERT Oracle Secure Coding Standard for Java - Guidelines 14. Serialization (SER)",
    'CWE-1149' => q"SEI CERT Oracle Secure Coding Standard for Java - Guidelines 15. Platform Security (SEC)",
    'CWE-1150' => q"SEI CERT Oracle Secure Coding Standard for Java - Guidelines 16. Runtime Environment (ENV)",
    'CWE-1151' => q"SEI CERT Oracle Secure Coding Standard for Java - Guidelines 17. Java Native Interface (JNI)",
    'CWE-1152' => q"SEI CERT Oracle Secure Coding Standard for Java - Guidelines 49. Miscellaneous (MSC)",
    'CWE-1153' => q"SEI CERT Oracle Secure Coding Standard for Java - Guidelines 50. Android (DRD)",
    'CWE-1155' => q"SEI CERT C Coding Standard - Guidelines 01. Preprocessor (PRE)",
    'CWE-1156' => q"SEI CERT C Coding Standard - Guidelines 02. Declarations and Initialization (DCL)",
    'CWE-1157' => q"SEI CERT C Coding Standard - Guidelines 03. Expressions (EXP)",
    'CWE-1158' => q"SEI CERT C Coding Standard - Guidelines 04. Integers (INT)",
    'CWE-1159' => q"SEI CERT C Coding Standard - Guidelines 05. Floating Point (FLP)",
    'CWE-1160' => q"SEI CERT C Coding Standard - Guidelines 06. Arrays (ARR)",
    'CWE-1161' => q"SEI CERT C Coding Standard - Guidelines 07. Characters and Strings (STR)",
    'CWE-1162' => q"SEI CERT C Coding Standard - Guidelines 08. Memory Management (MEM)",
    'CWE-1163' => q"SEI CERT C Coding Standard - Guidelines 09. Input Output (FIO)",
    'CWE-1165' => q"SEI CERT C Coding Standard - Guidelines 10. Environment (ENV)",
    'CWE-1166' => q"SEI CERT C Coding Standard - Guidelines 11. Signals (SIG)",
    'CWE-1167' => q"SEI CERT C Coding Standard - Guidelines 12. Error Handling (ERR)",
    'CWE-1168' => q"SEI CERT C Coding Standard - Guidelines 13. Application Programming Interfaces (API)",
    'CWE-1169' => q"SEI CERT C Coding Standard - Guidelines 14. Concurrency (CON)",
    'CWE-1170' => q"SEI CERT C Coding Standard - Guidelines 48. Miscellaneous (MSC)",
    'CWE-1171' => q"SEI CERT C Coding Standard - Guidelines 50. POSIX (POS)",
    'CWE-1172' => q"SEI CERT C Coding Standard - Guidelines 51. Microsoft Windows (WIN) ",
    'CWE-1175' => q"SEI CERT Oracle Secure Coding Standard for Java - Guidelines 18. Concurrency (CON)",
    'CWE-1179' => q"SEI CERT Perl Coding Standard - Guidelines 01. Input Validation and Data Sanitization (IDS)",
    'CWE-1180' => q"SEI CERT Perl Coding Standard - Guidelines 02. Declarations and Initialization (DCL)",
    'CWE-1181' => q"SEI CERT Perl Coding Standard - Guidelines 03. Expressions (EXP)",
    'CWE-1182' => q"SEI CERT Perl Coding Standard - Guidelines 04. Integers (INT)",
    'CWE-1183' => q"SEI CERT Perl Coding Standard - Guidelines 05. Strings (STR)",
    'CWE-1184' => q"SEI CERT Perl Coding Standard - Guidelines 06. Object-Oriented Programming (OOP)",
    'CWE-1185' => q"SEI CERT Perl Coding Standard - Guidelines 07. File Input and Output (FIO)",
    'CWE-1186' => q"SEI CERT Perl Coding Standard - Guidelines 50. Miscellaneous (MSC)",
    'CWE-1195' => q"Manufacturing and Life Cycle Management Concerns",
    'CWE-1196' => q"Security Flow Issues",
    'CWE-1197' => q"Integration Issues",
    'CWE-1198' => q"Privilege Separation and Access Control Issues",
    'CWE-1199' => q"General Circuit and Logic Design Concerns",
    'CWE-1201' => q"Core and Compute Issues",
    'CWE-1202' => q"Memory and Storage Issues",
    'CWE-1203' => q"Peripherals, On-chip Fabric, and Interface/IO Problems",
    'CWE-1205' => q"Security Primitives and Cryptography Issues",
    'CWE-1206' => q"Power, Clock, Thermal, and Reset Concerns",
    'CWE-1207' => q"Debug and Test Problems",
    'CWE-1208' => q"Cross-Cutting Problems",
    'CWE-1210' => q"Audit / Logging Errors",
    'CWE-1211' => q"Authentication Errors",
    'CWE-1212' => q"Authorization Errors",
    'CWE-1213' => q"Random Number Issues",
    'CWE-1214' => q"Data Integrity Issues",
    'CWE-1215' => q"Data Validation Issues",
    'CWE-1216' => q"Lockout Mechanism Errors",
    'CWE-1217' => q"User Session Errors",
    'CWE-1218' => q"Memory Buffer Errors",
    'CWE-1219' => q"File Handling Issues",
    'CWE-1225' => q"Documentation Issues",
    'CWE-1226' => q"Complexity Issues",
    'CWE-1227' => q"Encapsulation Issues",
    'CWE-1228' => q"API / Function Errors",
    'CWE-1237' => q"SFP Primary Cluster: Faulty Resource Release",
    'CWE-1238' => q"SFP Primary Cluster: Failure to Release Memory",
    'CWE-1306' => q"CISQ Quality Measures - Reliability",
    'CWE-1307' => q"CISQ Quality Measures - Maintainability",
    'CWE-1308' => q"CISQ Quality Measures - Security",
    'CWE-1309' => q"CISQ Quality Measures - Efficiency",
    'CWE-1345' => q"OWASP Top Ten 2021 Category A01:2021 - Broken Access Control",
    'CWE-1346' => q"OWASP Top Ten 2021 Category A02:2021 - Cryptographic Failures",
    'CWE-1347' => q"OWASP Top Ten 2021 Category A03:2021 - Injection",
    'CWE-1348' => q"OWASP Top Ten 2021 Category A04:2021 - Insecure Design",
    'CWE-1349' => q"OWASP Top Ten 2021 Category A05:2021 - Security Misconfiguration",
    'CWE-1352' => q"OWASP Top Ten 2021 Category A06:2021 - Vulnerable and Outdated Components",
    'CWE-1353' => q"OWASP Top Ten 2021 Category A07:2021 - Identification and Authentication Failures",
    'CWE-1354' => q"OWASP Top Ten 2021 Category A08:2021 - Software and Data Integrity Failures",
    'CWE-1355' => q"OWASP Top Ten 2021 Category A09:2021 - Security Logging and Monitoring Failures",
    'CWE-1356' => q"OWASP Top Ten 2021 Category A10:2021 - Server-Side Request Forgery (SSRF)",
    'CWE-1359' => q"ICS Communications",
    'CWE-1360' => q"ICS Dependencies (& Architecture)",
    'CWE-1361' => q"ICS Supply Chain",
    'CWE-1362' => q"ICS Engineering (Constructions/Deployment)",
    'CWE-1363' => q"ICS Operations (& Maintenance)",
    'CWE-1364' => q"ICS Communications: Zone Boundary Failures",
    'CWE-1365' => q"ICS Communications: Unreliability",
    'CWE-1366' => q"ICS Communications: Frail Security in Protocols",
    'CWE-1367' => q"ICS Dependencies (& Architecture): External Physical Systems",
    'CWE-1368' => q"ICS Dependencies (& Architecture): External Digital Systems",
    'CWE-1369' => q"ICS Supply Chain: IT/OT Convergence/Expansion",
    'CWE-1370' => q"ICS Supply Chain: Common Mode Frailties",
    'CWE-1371' => q"ICS Supply Chain: Poorly Documented or Undocumented Features",
    'CWE-1372' => q"ICS Supply Chain: OT Counterfeit and Malicious Corruption",
    'CWE-1373' => q"ICS Engineering (Construction/Deployment): Trust Model Problems",
    'CWE-1374' => q"ICS Engineering (Construction/Deployment): Maker Breaker Blindness",
    'CWE-1375' => q"ICS Engineering (Construction/Deployment): Gaps in Details/Data",
    'CWE-1376' => q"ICS Engineering (Construction/Deployment): Security Gaps in Commissioning",
    'CWE-1377' => q"ICS Engineering (Construction/Deployment): Inherent Predictability in Design",
    'CWE-1378' => q"ICS Operations (& Maintenance): Gaps in obligations and training",
    'CWE-1379' => q"ICS Operations (& Maintenance): Human factors in ICS environments",
    'CWE-1380' => q"ICS Operations (& Maintenance): Post-analysis changes",
    'CWE-1381' => q"ICS Operations (& Maintenance): Exploitable Standard Operational Procedures",
    'CWE-1382' => q"ICS Operations (& Maintenance): Emerging Energy Technologies",
    'CWE-1383' => q"ICS Operations (& Maintenance): Compliance/Conformance with Regulatory Requirements",
    'CWE-1388' => q"Physical Access Issues and Concerns",
    'CWE-1396' => q"Comprehensive Categorization: Access Control",
    'CWE-1397' => q"Comprehensive Categorization: Comparison",
    'CWE-1398' => q"Comprehensive Categorization: Component Interaction",
    'CWE-1399' => q"Comprehensive Categorization: Memory Safety",
    'CWE-1401' => q"Comprehensive Categorization: Concurrency",
    'CWE-1402' => q"Comprehensive Categorization: Encryption",
    'CWE-1403' => q"Comprehensive Categorization: Exposed Resource",
    'CWE-1404' => q"Comprehensive Categorization: File Handling",
    'CWE-1405' => q"Comprehensive Categorization: Improper Check or Handling of Exceptional Conditions",
    'CWE-1406' => q"Comprehensive Categorization: Improper Input Validation",
    'CWE-1407' => q"Comprehensive Categorization: Improper Neutralization",
    'CWE-1408' => q"Comprehensive Categorization: Incorrect Calculation",
    'CWE-1409' => q"Comprehensive Categorization: Injection",
    'CWE-1410' => q"Comprehensive Categorization: Insufficient Control Flow Management",
    'CWE-1411' => q"Comprehensive Categorization: Insufficient Verification of Data Authenticity",
    'CWE-1412' => q"Comprehensive Categorization: Poor Coding Practices",
    'CWE-1413' => q"Comprehensive Categorization: Protection Mechanism Failure",
    'CWE-1414' => q"Comprehensive Categorization: Randomness",
    'CWE-1415' => q"Comprehensive Categorization: Resource Control",
    'CWE-1416' => q"Comprehensive Categorization: Resource Lifecycle Management",
    'CWE-1417' => q"Comprehensive Categorization: Sensitive Information Exposure",
    'CWE-1418' => q"Comprehensive Categorization: Violation of Secure Design Principles",
);

sub get_weakness_name {

    my $id = shift;
    return unless $id;

    my %cwes = WEAKNESSES;

    if (defined $cwes{$id}) {
        return $cwes{$id};
    }

}

sub weakness_exists {

    my $id = shift;
    return unless $id;

    my %cwes = WEAKNESSES;

    return defined($cwes{$id});

}

1;
__END__

=encoding utf-8

=head1 NAME

CSAF::Util - CWE utility for CSAF

=head1 SYNOPSIS

    use CSAF::Util::CWE qw(get_weakness_name);

    say get_weakness_name('CWE-200');

=head1 DESCRIPTION

CWE utility for L<CSAF>.

=head2 FUNCTIONS

=over

=item get_weakness_name

=item weakness_exxists

=back

=head1 SUPPORT

=head2 Bugs / Feature Requests

Please report any bugs or feature requests through the issue tracker
at L<https://github.com/giterlizzi/perl-CSAF/issues>.
You will be notified automatically of any progress on your issue.

=head2 Source Code

This is open source software.  The code repository is available for
public review and contribution under the terms of the license.

L<https://github.com/giterlizzi/perl-CSAF>

    git clone https://github.com/giterlizzi/perl-CSAF.git


=head1 AUTHOR

=over 4

=item * Giuseppe Di Terlizzi <gdt@cpan.org>

=back


=head1 LICENSE AND COPYRIGHT

This software is copyright (c) 2023-2025 by Giuseppe Di Terlizzi.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
