# Generated by default/object.tt
package Paws::Athena::Database;
  use Moose;
  has Description => (is => 'ro', isa => 'Str');
  has Name => (is => 'ro', isa => 'Str', required => 1);
  has Parameters => (is => 'ro', isa => 'Paws::Athena::ParametersMap');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Athena::Database

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Athena::Database object:

  $service_obj->Method(Att1 => { Description => $value, ..., Parameters => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Athena::Database object:

  $result = $service_obj->Method(...);
  $result->Att1->Description

=head1 DESCRIPTION

Contains metadata information for a database in a data catalog.

=head1 ATTRIBUTES


=head2 Description => Str

An optional description of the database.


=head2 B<REQUIRED> Name => Str

The name of the database.


=head2 Parameters => L<Paws::Athena::ParametersMap>

A set of custom key/value pairs.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Athena>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

