# Generated by default/object.tt
package Paws::SageMaker::ImageVersion;
  use Moose;
  has CreationTime => (is => 'ro', isa => 'Str', required => 1);
  has FailureReason => (is => 'ro', isa => 'Str');
  has ImageArn => (is => 'ro', isa => 'Str', required => 1);
  has ImageVersionArn => (is => 'ro', isa => 'Str', required => 1);
  has ImageVersionStatus => (is => 'ro', isa => 'Str', required => 1);
  has LastModifiedTime => (is => 'ro', isa => 'Str', required => 1);
  has Version => (is => 'ro', isa => 'Int', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::ImageVersion

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::ImageVersion object:

  $service_obj->Method(Att1 => { CreationTime => $value, ..., Version => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::ImageVersion object:

  $result = $service_obj->Method(...);
  $result->Att1->CreationTime

=head1 DESCRIPTION

A version of a SageMaker C<Image>. A version represents an existing
container image.

=head1 ATTRIBUTES


=head2 B<REQUIRED> CreationTime => Str

When the version was created.


=head2 FailureReason => Str

When a create or delete operation fails, the reason for the failure.


=head2 B<REQUIRED> ImageArn => Str

The Amazon Resource Name (ARN) of the image the version is based on.


=head2 B<REQUIRED> ImageVersionArn => Str

The ARN of the version.


=head2 B<REQUIRED> ImageVersionStatus => Str

The status of the version.


=head2 B<REQUIRED> LastModifiedTime => Str

When the version was last modified.


=head2 B<REQUIRED> Version => Int

The version number.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

