/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.tsurgeon;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPatternRoot;
import edu.stanford.nlp.util.Pair;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TreeLocation {
    private final String relation;
    private final TsurgeonPattern p;
    private static final Pattern daughterPattern = Pattern.compile(">-?([0-9]+)");

    public TreeLocation(String relation, TsurgeonPattern p) {
        this.relation = relation;
        this.p = p;
    }

    void setRoot(TsurgeonPatternRoot root) {
        this.p.setRoot(root);
    }

    Pair<Tree, Integer> evaluate(Tree t, TregexMatcher tm) {
        int newIndex = -1;
        Tree parent = null;
        Tree relativeNode = this.p.evaluate(t, tm);
        Matcher m = daughterPattern.matcher(this.relation);
        if (m.matches()) {
            newIndex = Integer.parseInt(m.group(1)) - 1;
            parent = relativeNode;
            if (this.relation.charAt(1) == '-') {
                newIndex = parent.children().length - newIndex;
            }
        } else {
            parent = relativeNode.parent(t);
            if (parent == null) {
                throw new RuntimeException("Error: looking for a non-existent parent in tree " + t + " for \"" + this.toString() + "\"");
            }
            int index = parent.indexOf(relativeNode);
            if (this.relation.equals("$+")) {
                newIndex = index;
            } else if (this.relation.equals("$-")) {
                newIndex = index + 1;
            } else {
                throw new RuntimeException("Error: Haven't dealt with relation " + this.relation + " yet.");
            }
        }
        return new Pair<Tree, Integer>(parent, newIndex);
    }

    public String toString() {
        return this.relation + " " + this.p;
    }
}

