/*                                                                
**  Copyright (C) 1996,2007,2010  Smithsonian Astrophysical Observatory 
*/                                                                

/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 3 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License along */
/*  with this program; if not, write to the Free Software Foundation, Inc., */
/*  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.             */
/*                                                                          */

/* listhook.c
**/

#include <stdlib.h>
#include <string.h>
#include "pfile.h"

#include "listhook.h"

static Value Here;

Value *
NextListValue (ParamFile pfile, Parameter * p)
{
  char line[SZ_PFLINE];
  int len;
  do
    {
      if (fgets (line, SZ_PFLINE, ((listrecord *) p->extension)->file) ==
	  NULL)
	return (NULL);
      len = strlen (line);
      if (line[len - 1] == '\n')
	line[len - 1] = '\0';
      VNewValue (&Here, line, StringType);
    }
  while (!cxcValidate (pfile, p, &Here, 0));
  return (&Here);
}

void
InitList (Parameter * p)
{
  fclose (((listrecord *) p->extension)->file);
  free (p->extension);
  p->extension = NULL;
  p->phook = NULL;
}
