/*
 * Decompiled with CFR 0.152.
 */
package com.optimaize.langdetect.ngram;

import com.google.common.collect.ImmutableList;
import com.optimaize.langdetect.ngram.NgramFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NgramExtractor {
    @NotNull
    private final List<Integer> gramLengths = new ArrayList<Integer>(4);
    @Nullable
    private final NgramFilter filter;
    @Nullable
    private final Character textPadding;

    public static NgramExtractor gramLength(int gramLength) {
        return new NgramExtractor(ImmutableList.of(Integer.valueOf(gramLength)), null, null);
    }

    public static NgramExtractor gramLengths(Integer ... gramLength) {
        return new NgramExtractor(Arrays.asList(gramLength), null, null);
    }

    public NgramExtractor filter(NgramFilter filter) {
        return new NgramExtractor(this.gramLengths, filter, this.textPadding);
    }

    public NgramExtractor textPadding(char textPadding) {
        return new NgramExtractor(this.gramLengths, this.filter, Character.valueOf(textPadding));
    }

    private NgramExtractor(@NotNull List<Integer> gramLengths, @Nullable NgramFilter filter, @Nullable Character textPadding) {
        if (gramLengths.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.gramLengths.addAll(gramLengths);
        this.filter = filter;
        this.textPadding = textPadding;
    }

    public List<Integer> getGramLengths() {
        return Collections.unmodifiableList(this.gramLengths);
    }

    @NotNull
    public List<String> extractGrams(@NotNull CharSequence text) {
        text = this.applyPadding(text);
        int len = text.length();
        int totalNumGrams = 0;
        for (Integer gramLength : this.gramLengths) {
            int num = len - (gramLength - 1);
            if (num < 1) continue;
            totalNumGrams += num;
        }
        if (totalNumGrams <= 0) {
            return Collections.emptyList();
        }
        ArrayList<String> grams = new ArrayList<String>(totalNumGrams);
        for (Integer gramLength : this.gramLengths) {
            int numGrams = len - (gramLength - 1);
            if (numGrams < 1) continue;
            for (int pos = 0; pos < numGrams; ++pos) {
                String gram = text.subSequence(pos, pos + gramLength).toString();
                if (this.filter != null && !this.filter.use(gram)) continue;
                grams.add(gram);
            }
        }
        return grams;
    }

    @NotNull
    public Map<String, Integer> extractCountedGrams(@NotNull CharSequence text) {
        text = this.applyPadding(text);
        int len = text.length();
        int initialCapacity = 0;
        for (Integer gramLength : this.gramLengths) {
            initialCapacity += NgramExtractor.guessNumDistinctiveGrams(len, gramLength);
        }
        LinkedHashMap<String, Integer> grams = new LinkedHashMap<String, Integer>(initialCapacity);
        for (Integer gramLength : this.gramLengths) {
            this._extractCounted(text, gramLength, len, grams);
        }
        return grams;
    }

    private void _extractCounted(CharSequence text, int gramLength, int len, Map<String, Integer> grams) {
        int endPos = len - (gramLength - 1);
        for (int pos = 0; pos < endPos; ++pos) {
            String gram = text.subSequence(pos, pos + gramLength).toString();
            if (this.filter != null && !this.filter.use(gram)) continue;
            Integer counter = grams.get(gram);
            if (counter == null) {
                grams.put(gram, 1);
                continue;
            }
            grams.put(gram, counter + 1);
        }
    }

    private static int guessNumDistinctiveGrams(int textLength, int gramLength) {
        switch (gramLength) {
            case 1: {
                return Math.min(80, textLength);
            }
            case 2: {
                if (textLength < 40) {
                    return textLength;
                }
                if (textLength < 100) {
                    return (int)((double)textLength * 0.8);
                }
                if (textLength < 1000) {
                    return (int)((double)textLength * 0.6);
                }
                return (int)((double)textLength * 0.5);
            }
            case 3: {
                if (textLength < 40) {
                    return textLength;
                }
                if (textLength < 100) {
                    return (int)((double)textLength * 0.9);
                }
                if (textLength < 1000) {
                    return (int)((double)textLength * 0.8);
                }
                return (int)((double)textLength * 0.6);
            }
        }
        if (textLength < 100) {
            return textLength;
        }
        if (textLength < 1000) {
            return (int)((double)textLength * 0.95);
        }
        return (int)((double)textLength * 0.9);
    }

    private CharSequence applyPadding(CharSequence text) {
        if (this.textPadding == null) {
            return text;
        }
        if (text.length() == 0) {
            return text;
        }
        if (text.charAt(0) == this.textPadding.charValue() && text.charAt(text.length() - 1) == this.textPadding.charValue()) {
            return text;
        }
        StringBuilder sb = new StringBuilder();
        if (text.charAt(0) != this.textPadding.charValue()) {
            sb.append(this.textPadding);
        }
        sb.append(text);
        if (text.charAt(text.length() - 1) != this.textPadding.charValue()) {
            sb.append(this.textPadding);
        }
        return sb;
    }
}

