/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.executable;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Date;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LittleEndian;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.EndianUtils;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.executable.MachineMetadata;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ExecutableParser
extends AbstractParser
implements MachineMetadata {
    private static final long serialVersionUID = 32128791892482L;
    private static final MediaType PE_EXE = MediaType.application("x-msdownload");
    private static final MediaType ELF_GENERAL = MediaType.application("x-elf");
    private static final MediaType ELF_OBJECT = MediaType.application("x-object");
    private static final MediaType ELF_EXECUTABLE = MediaType.application("x-executable");
    private static final MediaType ELF_SHAREDLIB = MediaType.application("x-sharedlib");
    private static final MediaType ELF_COREDUMP = MediaType.application("x-coredump");
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(PE_EXE, ELF_GENERAL, ELF_OBJECT, ELF_EXECUTABLE, ELF_SHAREDLIB, ELF_COREDUMP)));

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        byte[] first4 = new byte[4];
        IOUtils.readFully(stream, first4);
        if (first4[0] == 77 && first4[1] == 90) {
            this.parsePE(xhtml, metadata, stream, first4);
        } else if (first4[0] == 127 && first4[1] == 69 && first4[2] == 76 && first4[3] == 70) {
            this.parseELF(xhtml, metadata, stream, first4);
        }
        xhtml.endDocument();
    }

    public void parsePE(XHTMLContentHandler xhtml, Metadata metadata, InputStream stream, byte[] first4) throws TikaException, IOException {
        metadata.set("Content-Type", PE_EXE.toString());
        metadata.set(PLATFORM, "Windows");
        byte[] msdosSection = new byte[56];
        IOUtils.readFully(stream, msdosSection);
        int peOffset = LittleEndian.readInt(stream);
        if (peOffset > 4096 || peOffset < 63) {
            return;
        }
        stream.skip(peOffset - 64);
        byte[] pe = new byte[24];
        IOUtils.readFully(stream, pe);
        if (pe[0] != 80 || pe[1] != 69 || pe[2] != 0 || pe[3] != 0) {
            return;
        }
        int machine = LittleEndian.getUShort(pe, 4);
        int numSectors = LittleEndian.getUShort(pe, 6);
        long createdAt = LittleEndian.getInt(pe, 8);
        long symbolTableOffset = LittleEndian.getInt(pe, 12);
        long numSymbols = LittleEndian.getInt(pe, 16);
        int sizeOptHdrs = LittleEndian.getUShort(pe, 20);
        int characteristcs = LittleEndian.getUShort(pe, 22);
        Date createdAtD = new Date(createdAt * 1000L);
        metadata.set(Metadata.CREATION_DATE, createdAtD);
        switch (machine) {
            case 332: {
                metadata.set(MACHINE_TYPE, "x86-32");
                metadata.set(ENDIAN, MachineMetadata.Endian.LITTLE.getName());
                metadata.set(ARCHITECTURE_BITS, "32");
                break;
            }
            case 34404: {
                metadata.set(MACHINE_TYPE, "x86-32");
                metadata.set(ENDIAN, MachineMetadata.Endian.LITTLE.getName());
                metadata.set(ARCHITECTURE_BITS, "64");
                break;
            }
            case 512: {
                metadata.set(MACHINE_TYPE, "IA-64");
                metadata.set(ENDIAN, MachineMetadata.Endian.LITTLE.getName());
                metadata.set(ARCHITECTURE_BITS, "64");
                break;
            }
            case 388: {
                metadata.set(MACHINE_TYPE, "Alpha");
                metadata.set(ENDIAN, MachineMetadata.Endian.LITTLE.getName());
                metadata.set(ARCHITECTURE_BITS, "32");
                break;
            }
            case 644: {
                metadata.set(MACHINE_TYPE, "Alpha");
                metadata.set(ENDIAN, MachineMetadata.Endian.LITTLE.getName());
                metadata.set(ARCHITECTURE_BITS, "64");
                break;
            }
            case 448: 
            case 452: {
                metadata.set(MACHINE_TYPE, "ARM");
                metadata.set(ENDIAN, MachineMetadata.Endian.LITTLE.getName());
                metadata.set(ARCHITECTURE_BITS, "32");
                break;
            }
            case 616: {
                metadata.set(MACHINE_TYPE, "Motorola-68000");
                metadata.set(ENDIAN, MachineMetadata.Endian.BIG.getName());
                metadata.set(ARCHITECTURE_BITS, "32");
                break;
            }
            case 614: 
            case 870: 
            case 1126: {
                metadata.set(MACHINE_TYPE, "MIPS");
                metadata.set(ENDIAN, MachineMetadata.Endian.BIG.getName());
                metadata.set(ARCHITECTURE_BITS, "16");
                break;
            }
            case 354: 
            case 358: 
            case 360: 
            case 361: {
                metadata.set(MACHINE_TYPE, "MIPS");
                metadata.set(ENDIAN, MachineMetadata.Endian.LITTLE.getName());
                metadata.set(ARCHITECTURE_BITS, "16");
                break;
            }
            case 496: 
            case 497: {
                metadata.set(MACHINE_TYPE, "PPC");
                metadata.set(ENDIAN, MachineMetadata.Endian.LITTLE.getName());
                metadata.set(ARCHITECTURE_BITS, "32");
                break;
            }
            case 418: 
            case 419: {
                metadata.set(MACHINE_TYPE, "SH3");
                metadata.set(ENDIAN, MachineMetadata.Endian.BIG.getName());
                metadata.set(ARCHITECTURE_BITS, "32");
                break;
            }
            case 422: {
                metadata.set(MACHINE_TYPE, "SH4");
                metadata.set(ENDIAN, MachineMetadata.Endian.BIG.getName());
                metadata.set(ARCHITECTURE_BITS, "32");
                break;
            }
            case 424: {
                metadata.set(MACHINE_TYPE, "SH3");
                metadata.set(ENDIAN, MachineMetadata.Endian.BIG.getName());
                metadata.set(ARCHITECTURE_BITS, "32");
                break;
            }
            case 36929: {
                metadata.set(MACHINE_TYPE, "M32R");
                metadata.set(ENDIAN, MachineMetadata.Endian.BIG.getName());
                metadata.set(ARCHITECTURE_BITS, "32");
                break;
            }
            case 3772: {
                metadata.set(MACHINE_TYPE, "EFI");
                break;
            }
            default: {
                metadata.set(MACHINE_TYPE, "Unknown");
            }
        }
    }

    public void parseELF(XHTMLContentHandler xhtml, Metadata metadata, InputStream stream, byte[] first4) throws TikaException, IOException {
        int architecture = stream.read();
        if (architecture == 1) {
            metadata.set(ARCHITECTURE_BITS, "32");
        } else if (architecture == 2) {
            metadata.set(ARCHITECTURE_BITS, "64");
        }
        int endian = stream.read();
        if (endian == 1) {
            metadata.set(ENDIAN, MachineMetadata.Endian.LITTLE.getName());
        } else if (endian == 2) {
            metadata.set(ENDIAN, MachineMetadata.Endian.BIG.getName());
        }
        int elfVer = stream.read();
        int os = stream.read();
        int osVer = stream.read();
        if (os > 0 || osVer > 0) {
            switch (os) {
                case 0: {
                    metadata.set(PLATFORM, "System V");
                    break;
                }
                case 1: {
                    metadata.set(PLATFORM, "HP-UX");
                    break;
                }
                case 2: {
                    metadata.set(PLATFORM, "NetBSD");
                    break;
                }
                case 3: {
                    metadata.set(PLATFORM, "Linux");
                    break;
                }
                case 6: {
                    metadata.set(PLATFORM, "Solaris");
                    break;
                }
                case 7: {
                    metadata.set(PLATFORM, "AIX");
                    break;
                }
                case 8: {
                    metadata.set(PLATFORM, "IRIX");
                    break;
                }
                case 9: {
                    metadata.set(PLATFORM, "FreeBSD");
                    break;
                }
                case 10: {
                    metadata.set(PLATFORM, "Tru64");
                    break;
                }
                case 12: {
                    metadata.set(PLATFORM, "FreeBSD");
                    break;
                }
                case 64: 
                case 97: {
                    metadata.set(PLATFORM, "ARM");
                    break;
                }
                case 255: {
                    metadata.set(PLATFORM, "Embedded");
                }
            }
        }
        byte[] padLength = new byte[7];
        IOUtils.readFully(stream, padLength);
        int type = endian == 1 ? EndianUtils.readUShortLE(stream) : EndianUtils.readUShortBE(stream);
        switch (type) {
            case 1: {
                metadata.set("Content-Type", ELF_OBJECT.toString());
                break;
            }
            case 2: {
                metadata.set("Content-Type", ELF_EXECUTABLE.toString());
                break;
            }
            case 3: {
                metadata.set("Content-Type", ELF_SHAREDLIB.toString());
                break;
            }
            case 4: {
                metadata.set("Content-Type", ELF_COREDUMP.toString());
                break;
            }
            default: {
                metadata.set("Content-Type", ELF_GENERAL.toString());
            }
        }
        int machine = endian == 1 ? EndianUtils.readUShortLE(stream) : EndianUtils.readUShortBE(stream);
        switch (machine) {
            case 2: 
            case 18: 
            case 43: {
                metadata.set(MACHINE_TYPE, "SPARC");
                break;
            }
            case 3: {
                metadata.set(MACHINE_TYPE, "x86-32");
                break;
            }
            case 4: {
                metadata.set(MACHINE_TYPE, "Motorola-68000");
                break;
            }
            case 5: {
                metadata.set(MACHINE_TYPE, "Motorola-88000");
                break;
            }
            case 8: 
            case 10: {
                metadata.set(MACHINE_TYPE, "MIPS");
                break;
            }
            case 7: {
                metadata.set(MACHINE_TYPE, "S370");
                break;
            }
            case 20: 
            case 21: {
                metadata.set(MACHINE_TYPE, "PPC");
                break;
            }
            case 22: {
                metadata.set(MACHINE_TYPE, "S390");
                break;
            }
            case 40: {
                metadata.set(MACHINE_TYPE, "ARM");
                break;
            }
            case 41: 
            case 36902: {
                metadata.set(MACHINE_TYPE, "Alpha");
                break;
            }
            case 50: {
                metadata.set(MACHINE_TYPE, "IA-64");
                break;
            }
            case 62: {
                metadata.set(MACHINE_TYPE, "x86-64");
                break;
            }
            case 75: {
                metadata.set(MACHINE_TYPE, "Vax");
                break;
            }
            case 88: {
                metadata.set(MACHINE_TYPE, "M32R");
            }
        }
    }
}

