package RDF::SKOS::STW;

use base 'RDF::SKOS::Redland';

=head1 NAME

RDF::SKOS::STW - SKOS Representation of STW

=head1 SYNOPSIS

   use RDF::SKOS::STW;
   my $stw = new RDF::SKOS::STW;
   # API like RDF::SKOS

=head1 DESCRIPTION

@@@@

=head1 INTERFACE

=head2 Constructor

The construct does not expect any parameters.

=cut

our $model;
sub _initialize {
    use RDF::Redland;
    my $storage = new RDF::Redland::Storage ("hashes", "test", "hash-type='memory'");
    $model   = new RDF::Redland::Model ($storage, "");

    my $parser  = new RDF::Redland::Parser (undef, "application/rdf+xml")
	or die "Failed to find parser\n";
    my $uri = new RDF::Redland::URI ("file:data/stw.rdf");

    $/ = undef;
    my $rdf = <DATA>;
    $parser->parse_string_into_model ($rdf, $uri, $model);
}

sub new {
    my $class = shift;

    _initialize unless $model;
    my $skos = new RDF::SKOS::Redland ($model);
    return bless $skos, $class; # rebless it
}

=pod

=head2 Methods

See L<RDF::SKOS>.

=head1 AUTHOR

Robert Barta, C<< <drrho at cpan.org> >>

=head1 BUGS

Please report any bugs or feature requests to C<bug-rdf-skos at rt.cpan.org>, or through
the web interface at L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=RDF-SKOS>.  I will be notified, and then you'll
automatically be notified of progress on your bug as I make changes.

=head1 COPYRIGHT & LICENSE

Copyright 2009 Robert Barta, all rights reserved.

This program is free software; you can redistribute it and/or modify it under the same terms as Perl
itself.

=cut

our $VERSION = '0.01';

"against all odds";


__DATA__
<?xml version="1.0" encoding="utf-8"?>
<rdf:RDF xmlns:cc="http://creativecommons.org/ns#" xmlns:dcterms="http://purl.org/dc/terms/" xmlns:owl="http://www.w3.org/2002/07/owl#" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#" xmlns:skos="http://www.w3.org/2004/02/skos/core#" xmlns:stw="http://zbw.eu/stw/" xmlns:xsd="http://www.w3.org/2001/XMLSchema#" xmlns:zbwext="http://zbw.eu/namespaces/skos-extensions/" xml:base="http://zbw.eu/stw/">
  <rdf:Description rdf:about="descriptor/17782-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/72180">
    <skos:notation rdf:datatype="http://www.w3.org/2001/XMLSchema#string">V.16</skos:notation>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16207-5">
    <skos:broader rdf:resource="thsys/73376"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16207-5">
    <skos:broader rdf:resource="descriptor/15654-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14066-0">
    <skos:prefLabel xml:lang="en">Coconut</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14066-0">
    <skos:prefLabel xml:lang="de">Kokosnuss</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70324">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71097">
    <skos:notation rdf:datatype="http://www.w3.org/2001/XMLSchema#string">V.07.02.01</skos:notation>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18847-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13553-1">
    <skos:altLabel xml:lang="de">Transportschifffahrt</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13553-1">
    <skos:altLabel xml:lang="de">Transportschiffahrt</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13553-1">
    <skos:altLabel xml:lang="de">Schiffsfrachtverkehr</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13553-1">
    <skos:altLabel xml:lang="de">Frachtschiffahrt</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14438-3">
    <skos:narrower rdf:resource="descriptor/14439-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14438-3">
    <skos:narrower rdf:resource="descriptor/14436-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14144-6">
    <skos:related rdf:resource="descriptor/19346-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14144-6">
    <skos:related rdf:resource="descriptor/19345-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14144-6">
    <skos:related rdf:resource="descriptor/12953-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14144-6">
    <skos:related rdf:resource="descriptor/18219-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11664-2">
    <skos:related rdf:resource="descriptor/13742-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11664-2">
    <skos:related rdf:resource="descriptor/19321-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19068-6">
    <skos:prefLabel xml:lang="en">Stock</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19068-6">
    <skos:prefLabel xml:lang="de">Bestand</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18764-5">
    <skos:related rdf:resource="descriptor/13960-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18764-5">
    <skos:related rdf:resource="descriptor/15609-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19514-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71078">
    <rdfs:label xml:lang="de">Öffentliches Vermögen und öffentliche Schulden</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18851-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10533-1">
    <skos:prefLabel xml:lang="en">Key sector</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10533-1">
    <skos:prefLabel xml:lang="de">Schlüsselsektor</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11892-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18431-4">
    <skos:related rdf:resource="descriptor/14626-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/21094-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id94">
    <rdf:value xml:lang="de">Für gemeinsame kulturelle Identitäten, Mentalitäten, Konventionen u.ä. von Menschen eines breiteren Kulturkreises</rdf:value>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18337-3">
    <skos:broader rdf:resource="thsys/73351"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18337-3">
    <skos:broader rdf:resource="thsys/71019"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18337-3">
    <skos:broader rdf:resource="thsys/70238"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11392-2">
    <zbwext:useInsteadNote rdf:nodeID="id48"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11304-4">
    <skos:prefLabel xml:lang="en">Employers' organization</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11304-4">
    <skos:prefLabel xml:lang="de">Arbeitgeberverband</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18449-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73342">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12372-3">
    <skos:scopeNote xml:lang="de">Nur für die bilanzielle und steuerrechtliche Gewinnermittlung.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12246-1">
    <skos:narrower rdf:resource="descriptor/10824-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12246-1">
    <skos:narrower rdf:resource="descriptor/10693-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12246-1">
    <skos:narrower rdf:resource="descriptor/12236-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70854">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11434-5">
    <skos:related rdf:resource="descriptor/11436-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11434-5">
    <skos:related rdf:resource="descriptor/18149-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11434-5">
    <skos:related rdf:resource="descriptor/11426-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19779-1">
    <skos:altLabel xml:lang="de">Redetechnik</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19779-1">
    <skos:altLabel xml:lang="de">Moderationstechnik</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18182-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16743-2">
    <skos:related rdf:resource="descriptor/16740-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16743-2">
    <skos:related rdf:resource="descriptor/10252-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16743-2">
    <skos:related rdf:resource="descriptor/16738-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16743-2">
    <skos:related rdf:resource="descriptor/16737-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18970-2">
    <skos:related rdf:resource="descriptor/19762-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18970-2">
    <skos:related rdf:resource="descriptor/19788-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18970-2">
    <skos:related rdf:resource="descriptor/16146-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18970-2">
    <skos:related rdf:resource="descriptor/18911-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18970-2">
    <skos:related rdf:resource="descriptor/18968-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19509-2">
    <skos:related rdf:resource="descriptor/11328-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19509-2">
    <skos:related rdf:resource="descriptor/11201-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19509-2">
    <skos:related rdf:resource="descriptor/16140-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19509-2">
    <skos:related rdf:resource="descriptor/16438-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19509-2">
    <skos:related rdf:resource="descriptor/11187-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19509-2">
    <skos:related rdf:resource="descriptor/12609-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19509-2">
    <skos:related rdf:resource="descriptor/11305-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13456-6">
    <skos:broader rdf:resource="thsys/70953"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13456-6">
    <skos:broader rdf:resource="thsys/70854"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13456-6">
    <skos:broader rdf:resource="descriptor/12180-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13456-6">
    <skos:broader rdf:resource="descriptor/12668-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18620-1">
    <skos:broader rdf:resource="thsys/70940"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18620-1">
    <skos:broader rdf:resource="thsys/70927"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18620-1">
    <skos:broader rdf:resource="thsys/70394"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18620-1">
    <skos:broader rdf:resource="thsys/70386"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18620-1">
    <skos:broader rdf:resource="descriptor/12670-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10895-2">
    <skos:related rdf:resource="descriptor/10913-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10895-2">
    <skos:related rdf:resource="descriptor/10956-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10895-2">
    <skos:related rdf:resource="descriptor/19565-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10895-2">
    <skos:related rdf:resource="descriptor/10964-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10895-2">
    <skos:related rdf:resource="descriptor/10963-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10895-2">
    <skos:related rdf:resource="descriptor/10942-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10895-2">
    <skos:related rdf:resource="descriptor/10949-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10895-2">
    <skos:related rdf:resource="descriptor/10948-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10895-2">
    <skos:related rdf:resource="descriptor/10891-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10895-2">
    <skos:related rdf:resource="descriptor/10944-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11670-0">
    <skos:broader rdf:resource="thsys/71074"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11670-0">
    <skos:broader rdf:resource="descriptor/11657-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15011-6">
    <skos:prefLabel xml:lang="en">Recycling product</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15011-6">
    <skos:prefLabel xml:lang="de">Sekundärrohstoff</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16525-5">
    <skos:narrower rdf:resource="descriptor/13310-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12607-2">
    <skos:narrower rdf:resource="descriptor/12625-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16460-0">
    <skos:broader rdf:resource="thsys/73363"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16460-0">
    <skos:broader rdf:resource="thsys/70865"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16460-0">
    <skos:broader rdf:resource="descriptor/19720-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10745-0">
    <skos:related rdf:resource="descriptor/10722-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10745-0">
    <skos:related rdf:resource="descriptor/10772-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10745-0">
    <skos:related rdf:resource="descriptor/10771-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10745-0">
    <skos:related rdf:resource="descriptor/10770-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10745-0">
    <skos:related rdf:resource="descriptor/10746-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15700-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12276-6">
    <skos:related rdf:resource="descriptor/12876-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12276-6">
    <skos:related rdf:resource="descriptor/12372-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12276-6">
    <skos:related rdf:resource="descriptor/12270-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12424-3">
    <skos:broader rdf:resource="thsys/71043"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12424-3">
    <skos:broader rdf:resource="descriptor/10011-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12424-3">
    <skos:broader rdf:resource="descriptor/12408-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18541-4">
    <skos:altLabel xml:lang="de">Marktzutritt in Auslandsmärkte</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18541-4">
    <skos:altLabel xml:lang="de">Markteintritt in Auslandsmärkte</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18541-4">
    <skos:altLabel xml:lang="de">Internationale Markterschließungsstrategie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18541-4">
    <skos:altLabel xml:lang="de">Erschließungsstrategie von Auslandsmärkten</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11191-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17791-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10298-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70346">
    <skos:prefLabel xml:lang="de">P.07.02  Metallprodukte</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12914-0">
    <skos:altLabel xml:lang="de">Großanlagenbau</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18090-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10411-1">
    <skos:broader rdf:resource="thsys/70406"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10411-1">
    <skos:broader rdf:resource="thsys/70209"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/24663-4">
    <skos:related rdf:resource="descriptor/16429-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/24663-4">
    <skos:related rdf:resource="descriptor/19756-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/24663-4">
    <skos:related rdf:resource="descriptor/18142-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/24663-4">
    <skos:related rdf:resource="descriptor/21306-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16229-2">
    <skos:prefLabel xml:lang="en">Utopia</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16229-2">
    <skos:prefLabel xml:lang="de">Utopie</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19335-2">
    <skos:narrower rdf:resource="descriptor/10761-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19335-2">
    <skos:narrower rdf:resource="descriptor/10751-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19335-2">
    <skos:narrower rdf:resource="descriptor/10736-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19335-2">
    <skos:narrower rdf:resource="descriptor/10735-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18092-0">
    <skos:prefLabel xml:lang="en">Inventory control system</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18092-0">
    <skos:prefLabel xml:lang="de">Warenwirtschaftssystem</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15762-3">
    <skos:prefLabel xml:lang="en">Environment agency</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15762-3">
    <skos:prefLabel xml:lang="de">Umweltbehörde</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10754-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19805-5">
    <skos:broader rdf:resource="thsys/73340"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19805-5">
    <skos:broader rdf:resource="descriptor/12612-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15728-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19358-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18871-4">
    <skos:prefLabel xml:lang="en">Study of economics</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18871-4">
    <skos:prefLabel xml:lang="de">Wirtschaftsstudium</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18276-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11088-5">
    <skos:narrower rdf:resource="descriptor/11073-4"/>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id229">
    <rdfs:seeAlso rdf:resource="descriptor/16510-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14318-6">
    <skos:prefLabel xml:lang="en">Transport container</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14318-6">
    <skos:prefLabel xml:lang="de">Container</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16048-6">
    <skos:prefLabel xml:lang="en">EU economic law</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16048-6">
    <skos:prefLabel xml:lang="de">EU-Wirtschaftsrecht</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18030-1">
    <skos:broader rdf:resource="thsys/73345"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18030-1">
    <skos:broader rdf:resource="descriptor/15679-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20314-0">
    <skos:prefLabel xml:lang="en">Product information</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20314-0">
    <skos:prefLabel xml:lang="de">Produktinformation</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12722-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15063-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13082-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14021-1">
    <skos:prefLabel xml:lang="en">Construction material</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14021-1">
    <skos:prefLabel xml:lang="de">Baustoff</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11521-3">
    <skos:related rdf:resource="descriptor/21101-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11222-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16541-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11679-3">
    <skos:related rdf:resource="descriptor/11678-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11679-3">
    <skos:related rdf:resource="descriptor/12876-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11679-3">
    <skos:related rdf:resource="descriptor/12880-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11679-3">
    <skos:related rdf:resource="descriptor/12863-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11679-3">
    <skos:related rdf:resource="descriptor/12848-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19612-2">
    <skos:altLabel xml:lang="de">Ländergröße</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15977-3">
    <skos:narrower rdf:resource="descriptor/18790-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18137-4">
    <skos:broader rdf:resource="thsys/71024"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18137-4">
    <skos:broader rdf:resource="descriptor/18313-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10958-4">
    <skos:narrower rdf:resource="descriptor/10961-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10958-4">
    <skos:narrower rdf:resource="descriptor/10957-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18374-4">
    <skos:prefLabel xml:lang="en">Coal policy</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18374-4">
    <skos:prefLabel xml:lang="de">Kohlepolitik</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19040-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12738-1">
    <skos:related rdf:resource="descriptor/12732-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12738-1">
    <skos:related rdf:resource="descriptor/12730-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13066-5">
    <skos:altLabel xml:lang="de">Werftindustrie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13066-5">
    <skos:altLabel xml:lang="de">Schiffsbau</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12436-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10001-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12963-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11066-1">
    <skos:broader rdf:resource="thsys/70039"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11066-1">
    <skos:broader rdf:resource="descriptor/10032-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16745-5">
    <skos:narrower rdf:resource="descriptor/10166-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16745-5">
    <skos:narrower rdf:resource="descriptor/19732-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16745-5">
    <skos:narrower rdf:resource="descriptor/16743-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16745-5">
    <skos:narrower rdf:resource="descriptor/16742-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16745-5">
    <skos:narrower rdf:resource="descriptor/11174-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16745-5">
    <skos:narrower rdf:resource="descriptor/10054-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16745-5">
    <skos:narrower rdf:resource="descriptor/16741-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16745-5">
    <skos:narrower rdf:resource="descriptor/16740-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16745-5">
    <skos:narrower rdf:resource="descriptor/10252-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16745-5">
    <skos:narrower rdf:resource="descriptor/10250-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16745-5">
    <skos:narrower rdf:resource="descriptor/15704-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16745-5">
    <skos:narrower rdf:resource="descriptor/16738-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16745-5">
    <skos:narrower rdf:resource="descriptor/10041-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16745-5">
    <skos:narrower rdf:resource="descriptor/10247-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16745-5">
    <skos:narrower rdf:resource="descriptor/11161-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16745-5">
    <skos:narrower rdf:resource="descriptor/16712-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16745-5">
    <skos:narrower rdf:resource="descriptor/19206-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16745-5">
    <skos:narrower rdf:resource="descriptor/16737-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="http://www.w3.org/2004/02/skos/core#topConceptOf">
    <rdfs:isDefinedBy rdf:resource="http://www.w3.org/2004/02/skos/core"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19732-6">
    <skos:altLabel xml:lang="de">Universalökonomie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16308-6">
    <skos:related rdf:resource="descriptor/16421-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16308-6">
    <skos:related rdf:resource="descriptor/16226-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16308-6">
    <skos:related rdf:resource="descriptor/16512-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16308-6">
    <skos:related rdf:resource="descriptor/19773-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16308-6">
    <skos:related rdf:resource="descriptor/16297-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17639-6">
    <skos:prefLabel xml:lang="en">United Arab Emirates</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17639-6">
    <skos:prefLabel xml:lang="de">Vereinigte Arabische Emirate</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13075-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13341-2">
    <skos:prefLabel xml:lang="en">Archive</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13341-2">
    <skos:prefLabel xml:lang="de">Archiv</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18589-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12313-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18860-2">
    <skos:related rdf:resource="descriptor/15861-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18860-2">
    <skos:related rdf:resource="descriptor/15666-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18860-2">
    <skos:related rdf:resource="descriptor/19601-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18860-2">
    <skos:related rdf:resource="descriptor/16759-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18860-2">
    <skos:related rdf:resource="descriptor/11407-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18860-2">
    <skos:related rdf:resource="descriptor/11354-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18860-2">
    <skos:related rdf:resource="descriptor/11394-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18860-2">
    <skos:related rdf:resource="descriptor/11400-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18860-2">
    <skos:related rdf:resource="descriptor/11355-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18860-2">
    <skos:related rdf:resource="descriptor/18856-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14204-0">
    <skos:narrower rdf:resource="descriptor/14190-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73387">
    <skos:prefLabel xml:lang="en">N.02.01  Economic history</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73387">
    <skos:prefLabel xml:lang="de">N.02.01  Wirtschaftsgeschichte</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19124-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12901-2">
    <skos:related rdf:resource="descriptor/12903-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12901-2">
    <skos:related rdf:resource="descriptor/19856-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12901-2">
    <skos:related rdf:resource="descriptor/12882-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14436-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18788-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15909-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19801-6">
    <skos:prefLabel xml:lang="en">User interface</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19801-6">
    <skos:prefLabel xml:lang="de">Benutzerschnittstelle</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16602-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19417-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10137-2">
    <skos:broader rdf:resource="thsys/70455"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10137-2">
    <skos:broader rdf:resource="descriptor/10236-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70321">
    <rdfs:label xml:lang="de">Gesellschaft und sozialer Wandel</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16648-3">
    <skos:broader rdf:resource="thsys/73366"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16648-3">
    <skos:broader rdf:resource="thsys/70866"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16648-3">
    <skos:broader rdf:resource="thsys/70828"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16648-3">
    <skos:broader rdf:resource="descriptor/16441-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11324-5">
    <skos:prefLabel xml:lang="en">Wage drift</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11324-5">
    <skos:prefLabel xml:lang="de">Lohndrift</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14989-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14301-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18856-0">
    <skos:related rdf:resource="descriptor/11378-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18856-0">
    <skos:related rdf:resource="descriptor/11375-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18856-0">
    <skos:related rdf:resource="descriptor/11367-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18856-0">
    <skos:related rdf:resource="descriptor/18860-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18856-0">
    <skos:related rdf:resource="descriptor/11288-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18856-0">
    <skos:related rdf:resource="descriptor/11355-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11532-5">
    <skos:prefLabel xml:lang="en">Tax court</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11532-5">
    <skos:prefLabel xml:lang="de">Finanzgericht</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14622-3">
    <skos:prefLabel xml:lang="en">Household cleaning agent</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14622-3">
    <skos:prefLabel xml:lang="de">Pflegemittel</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18892-3">
    <skos:altLabel xml:lang="de">Prophylaxe</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18892-3">
    <skos:altLabel xml:lang="de">Krankheitsprävention</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18892-3">
    <skos:altLabel xml:lang="de">Gesundheitsbewegung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12004-4">
    <skos:prefLabel xml:lang="en">Infrastructure policy</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12004-4">
    <skos:prefLabel xml:lang="de">Infrastrukturpolitik</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70406">
    <skos:broader rdf:resource="thsys/70021"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12046-2">
    <skos:altLabel xml:lang="de">Unternehmensgeschichte</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19144-2">
    <skos:prefLabel xml:lang="en">Wide-area networks</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19144-2">
    <skos:prefLabel xml:lang="de">WAN</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12963-1">
    <skos:broader rdf:resource="thsys/71018"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12963-1">
    <skos:broader rdf:resource="descriptor/12964-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18773-4">
    <skos:prefLabel xml:lang="en">European science and technology policy</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18773-4">
    <skos:prefLabel xml:lang="de">Europäische Forschungs- und Technologiepolitik</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11651-4">
    <skos:related rdf:resource="descriptor/11682-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11651-4">
    <skos:related rdf:resource="descriptor/16029-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11651-4">
    <skos:related rdf:resource="descriptor/16028-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19803-2">
    <skos:prefLabel xml:lang="en">Object-oriented programming</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19803-2">
    <skos:prefLabel xml:lang="de">Objektorientierte Programmierung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19615-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11421-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19152-3">
    <skos:prefLabel xml:lang="en">Lean management</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19152-3">
    <skos:prefLabel xml:lang="de">Lean Management</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12268-5">
    <skos:broader rdf:resource="thsys/70900"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12268-5">
    <skos:broader rdf:resource="descriptor/12282-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18601-5">
    <skos:related rdf:resource="descriptor/18603-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18601-5">
    <skos:related rdf:resource="descriptor/18602-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18601-5">
    <skos:related rdf:resource="descriptor/13536-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18601-5">
    <skos:related rdf:resource="descriptor/13535-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18601-5">
    <skos:related rdf:resource="descriptor/13533-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15023-6">
    <skos:broader rdf:resource="thsys/72183"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15023-6">
    <skos:broader rdf:resource="descriptor/15119-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13555-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19728-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70040">
    <rdfs:label xml:lang="de">Konditionen- und Preispolitik</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10339-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13649-2">
    <skos:broader rdf:resource="thsys/70922"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13649-2">
    <skos:broader rdf:resource="thsys/70135"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13649-2">
    <skos:broader rdf:resource="descriptor/13667-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13649-2">
    <skos:broader rdf:resource="descriptor/18170-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18363-2">
    <skos:altLabel xml:lang="de">Sonnenenergieförderung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id297">
    <rdfs:seeAlso rdf:resource="descriptor/13418-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11427-2">
    <skos:narrower rdf:resource="descriptor/11519-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11427-2">
    <skos:narrower rdf:resource="descriptor/11432-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71014">
    <skos:broader rdf:resource="thsys/71016"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14444-1">
    <skos:prefLabel xml:lang="en">Bicycle and motorcycle</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14444-1">
    <skos:prefLabel xml:lang="de">Zweirad</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10830-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16792-3">
    <skos:narrower rdf:resource="descriptor/18179-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12053-5">
    <skos:related rdf:resource="descriptor/15075-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12053-5">
    <skos:related rdf:resource="descriptor/12073-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12053-5">
    <skos:related rdf:resource="descriptor/12088-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12053-5">
    <skos:related rdf:resource="descriptor/12069-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12053-5">
    <skos:related rdf:resource="descriptor/24856-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12053-5">
    <skos:related rdf:resource="descriptor/12884-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12053-5">
    <skos:related rdf:resource="descriptor/12470-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12053-5">
    <skos:related rdf:resource="descriptor/12216-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12053-5">
    <skos:related rdf:resource="descriptor/19069-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12053-5">
    <skos:related rdf:resource="descriptor/12039-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12053-5">
    <skos:related rdf:resource="descriptor/19108-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12053-5">
    <skos:related rdf:resource="descriptor/12164-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12053-5">
    <skos:related rdf:resource="descriptor/19834-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14705-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70020">
    <rdfs:label xml:lang="en">Business cycle</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70020">
    <rdfs:label xml:lang="de">Konjunktur</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16290-6">
    <skos:narrower rdf:resource="descriptor/11127-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16290-6">
    <skos:narrower rdf:resource="descriptor/16306-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16290-6">
    <skos:narrower rdf:resource="descriptor/16283-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16290-6">
    <skos:narrower rdf:resource="descriptor/16268-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15429-6">
    <skos:prefLabel xml:lang="en">Systems theory</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15429-6">
    <skos:prefLabel xml:lang="de">Systemtheorie</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14121-4">
    <skos:altLabel xml:lang="de">Hühnerei</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14121-4">
    <skos:altLabel xml:lang="de">Geflügelei</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70485">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12087-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19203-5">
    <skos:scopeNote xml:lang="de">Anwendung biologischer Erkenntnisse und Verfahren in der ökonomischen Theorie.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70358">
    <skos:prefLabel xml:lang="de">P.07  Metalle</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16692-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19117-5">
    <skos:broader rdf:resource="thsys/71036"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19117-5">
    <skos:broader rdf:resource="thsys/70471"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19117-5">
    <skos:broader rdf:resource="descriptor/12713-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19117-5">
    <skos:broader rdf:resource="descriptor/18002-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13979-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17433-5">
    <skos:altLabel xml:lang="de">Nederland</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17433-5">
    <skos:altLabel xml:lang="de">Königreich der Niederlande</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17433-5">
    <skos:altLabel xml:lang="de">Holland</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11590-5">
    <skos:related rdf:resource="descriptor/11591-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11590-5">
    <skos:related rdf:resource="descriptor/19378-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12670-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18240-4">
    <skos:prefLabel xml:lang="en">Titanium</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18240-4">
    <skos:prefLabel xml:lang="de">Titan</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14776-4">
    <skos:narrower rdf:resource="descriptor/14779-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14776-4">
    <skos:narrower rdf:resource="descriptor/14778-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14776-4">
    <skos:narrower rdf:resource="descriptor/14777-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14776-4">
    <skos:narrower rdf:resource="descriptor/14775-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12640-4">
    <skos:narrower rdf:resource="descriptor/12573-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12640-4">
    <skos:narrower rdf:resource="descriptor/11579-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12640-4">
    <skos:narrower rdf:resource="descriptor/20503-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12640-4">
    <skos:narrower rdf:resource="descriptor/15473-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12640-4">
    <skos:narrower rdf:resource="descriptor/16767-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12640-4">
    <skos:narrower rdf:resource="descriptor/12668-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12640-4">
    <skos:narrower rdf:resource="descriptor/12656-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12640-4">
    <skos:narrower rdf:resource="descriptor/12651-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18854-4">
    <skos:related rdf:resource="descriptor/18123-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18854-4">
    <skos:related rdf:resource="descriptor/18852-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19550-5">
    <skos:broader rdf:resource="thsys/70307"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19550-5">
    <skos:broader rdf:resource="thsys/70091"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16325-6">
    <skos:broader rdf:resource="thsys/73363"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16325-6">
    <skos:broader rdf:resource="thsys/70865"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16325-6">
    <skos:broader rdf:resource="descriptor/13412-5"/>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id166">
    <rdfs:seeAlso rdf:resource="descriptor/13004-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11721-2">
    <skos:narrower rdf:resource="descriptor/11724-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="../stw">
    <cc:license rdf:resource="http://creativecommons.org/licenses/by-nc-sa/3.0/de/"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19707-5">
    <skos:altLabel xml:lang="de">Sprachenregelung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19707-5">
    <skos:altLabel xml:lang="de">Sprachenrecht</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19707-5">
    <skos:altLabel xml:lang="de">Sprachenpolitik</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19707-5">
    <skos:altLabel xml:lang="de">Sprachengesetzgebung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11636-0">
    <skos:prefLabel xml:lang="en">Tax burden</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11636-0">
    <skos:prefLabel xml:lang="de">Steuerbelastung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70957">
    <skos:narrower rdf:resource="descriptor/19390-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70957">
    <skos:narrower rdf:resource="descriptor/13236-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70957">
    <skos:narrower rdf:resource="descriptor/13190-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70957">
    <skos:narrower rdf:resource="descriptor/18995-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70957">
    <skos:narrower rdf:resource="descriptor/13472-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70957">
    <skos:narrower rdf:resource="descriptor/13193-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70957">
    <skos:narrower rdf:resource="descriptor/19393-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70957">
    <skos:narrower rdf:resource="descriptor/19182-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70957">
    <skos:narrower rdf:resource="descriptor/13221-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70957">
    <skos:narrower rdf:resource="descriptor/19184-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70957">
    <skos:narrower rdf:resource="descriptor/13224-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70957">
    <skos:narrower rdf:resource="descriptor/19185-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70957">
    <skos:narrower rdf:resource="descriptor/19192-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70957">
    <skos:narrower rdf:resource="descriptor/19367-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70957">
    <skos:narrower rdf:resource="descriptor/13215-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70957">
    <skos:narrower rdf:resource="descriptor/13214-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70957">
    <skos:narrower rdf:resource="descriptor/18547-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70957">
    <skos:narrower rdf:resource="descriptor/19181-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70957">
    <skos:narrower rdf:resource="descriptor/19388-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70957">
    <skos:narrower rdf:resource="descriptor/19385-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70957">
    <skos:narrower rdf:resource="descriptor/19397-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70957">
    <skos:narrower rdf:resource="descriptor/13199-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70957">
    <skos:narrower rdf:resource="descriptor/13198-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70957">
    <skos:narrower rdf:resource="descriptor/13194-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70957">
    <skos:narrower rdf:resource="descriptor/19675-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70957">
    <skos:narrower rdf:resource="descriptor/13192-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70957">
    <skos:narrower rdf:resource="descriptor/13191-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12307-0">
    <skos:related rdf:resource="descriptor/12882-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12307-0">
    <skos:related rdf:resource="descriptor/11589-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12307-0">
    <skos:related rdf:resource="descriptor/12848-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18224-2">
    <skos:prefLabel xml:lang="en">Czech Republic</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18224-2">
    <skos:prefLabel xml:lang="de">Tschechische Republik</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10323-5">
    <skos:prefLabel xml:lang="en">Multiproduct production</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10323-5">
    <skos:prefLabel xml:lang="de">Mehrproduktproduktion</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15968-4">
    <skos:scopeNote xml:lang="de">Literatur über die Geschichte des Rechts allgemein oder des Rechtssystems in einem Land bzw. über die Geschichte eines Rechtsgebiets.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14292-5">
    <skos:related rdf:resource="descriptor/14642-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16729-3">
    <skos:broader rdf:resource="thsys/73393"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16729-3">
    <skos:broader rdf:resource="descriptor/16732-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18889-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11675-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18089-3">
    <skos:scopeNote xml:lang="de">Nur für Eisenbahnverkehr.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19186-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10618-0">
    <skos:broader rdf:resource="thsys/73366"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10618-0">
    <skos:broader rdf:resource="thsys/71097"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10618-0">
    <skos:broader rdf:resource="descriptor/16439-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14440-2">
    <zbwext:useInsteadNote rdf:nodeID="id251"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17919-0">
    <skos:prefLabel xml:lang="en">Chile</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17919-0">
    <skos:prefLabel xml:lang="de">Chile</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19146-5">
    <skos:related rdf:resource="descriptor/18070-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19146-5">
    <skos:related rdf:resource="descriptor/19151-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19146-5">
    <skos:related rdf:resource="descriptor/19601-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19146-5">
    <skos:related rdf:resource="descriptor/10459-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19146-5">
    <skos:related rdf:resource="descriptor/20468-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16301-6">
    <skos:related rdf:resource="descriptor/16335-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16301-6">
    <skos:related rdf:resource="descriptor/11347-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16301-6">
    <skos:related rdf:resource="descriptor/15977-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16301-6">
    <skos:related rdf:resource="descriptor/15972-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16301-6">
    <skos:related rdf:resource="descriptor/19715-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16301-6">
    <skos:related rdf:resource="descriptor/12879-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11990-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="http://www.w3.org/2004/02/skos/core#narrower">
    <rdfs:subPropertyOf rdf:resource="http://www.w3.org/2004/02/skos/core#narrowerTransitive"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13320-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13355-5">
    <skos:narrower rdf:resource="descriptor/18788-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14057-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16344-2">
    <skos:altLabel xml:lang="de">Fraktion des Parlaments</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18290-3">
    <skos:prefLabel xml:lang="en">Liquid cristal display</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18290-3">
    <skos:prefLabel xml:lang="de">Flüssigkristallanzeige</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73358">
    <rdfs:label xml:lang="de">Soziale Gruppen</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11159-1">
    <skos:altLabel xml:lang="en">Psychological contracts</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11159-1">
    <skos:altLabel xml:lang="en">Psychological contract</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11159-1">
    <skos:altLabel xml:lang="en">Implicit contract theory</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11159-1">
    <skos:altLabel xml:lang="de">Psychologischer Vertrag</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11159-1">
    <skos:altLabel xml:lang="de">Impliziter Vertrag</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11159-1">
    <skos:altLabel xml:lang="de">Implizite-Kontrakte-Theorie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70021">
    <skos:prefLabel xml:lang="de">V.04  Konjunktur, Wachstum und Wirtschaftsstruktur</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15988-5">
    <skos:narrower rdf:resource="descriptor/18272-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15988-5">
    <skos:narrower rdf:resource="descriptor/18961-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19607-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14513-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14127-6">
    <skos:broader rdf:resource="thsys/70467"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14127-6">
    <skos:broader rdf:resource="descriptor/14129-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10880-1">
    <skos:scopeNote xml:lang="de">Dem allgemeinen Handelsbrauch oder rechtlichen Festlegungen entsprechende Liefer- und Zahlungsmodalitäten im Außenhandel.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18649-5">
    <skos:narrower rdf:resource="descriptor/18650-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16445-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11825-4">
    <skos:altLabel xml:lang="x-other">Economie sociale</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17978-5">
    <skos:broader rdf:resource="thsys/70307"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17201-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13724-0">
    <skos:related rdf:resource="descriptor/19538-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15941-3">
    <skos:related rdf:resource="descriptor/15672-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15941-3">
    <skos:related rdf:resource="descriptor/19525-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15941-3">
    <skos:related rdf:resource="descriptor/19788-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15941-3">
    <skos:related rdf:resource="descriptor/15939-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15941-3">
    <skos:related rdf:resource="descriptor/10173-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15941-3">
    <skos:related rdf:resource="descriptor/15938-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15941-3">
    <skos:related rdf:resource="descriptor/14724-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15941-3">
    <skos:related rdf:resource="descriptor/15061-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15941-3">
    <skos:related rdf:resource="descriptor/15708-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15941-3">
    <skos:related rdf:resource="descriptor/19638-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12865-1">
    <skos:broader rdf:resource="thsys/71040"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12865-1">
    <skos:broader rdf:resource="thsys/70814"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12865-1">
    <skos:broader rdf:resource="thsys/70087"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12865-1">
    <skos:broader rdf:resource="descriptor/12072-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10029-5">
    <skos:related rdf:resource="descriptor/10966-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10029-5">
    <skos:related rdf:resource="descriptor/10913-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10029-5">
    <skos:related rdf:resource="descriptor/10968-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10029-5">
    <skos:related rdf:resource="descriptor/18850-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10833-3">
    <skos:editorialNote xml:lang="de">Nur zur Postkoordination verwenden.</skos:editorialNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10948-0">
    <skos:altLabel xml:lang="en">Contestable market</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10948-0">
    <skos:altLabel xml:lang="de">Potenzielle Konkurrenz</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10948-0">
    <skos:altLabel xml:lang="de">Potentieller Wettbewerb</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10948-0">
    <skos:altLabel xml:lang="de">Potentielle Konkurrenz</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10948-0">
    <skos:altLabel xml:lang="de">Latenter Wettbewerb</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18413-6">
    <skos:related rdf:resource="descriptor/14384-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18413-6">
    <skos:related rdf:resource="descriptor/13160-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18413-6">
    <skos:related rdf:resource="descriptor/18443-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18413-6">
    <skos:related rdf:resource="descriptor/18562-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10763-5">
    <skos:altLabel xml:lang="de">Dollar</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18901-0">
    <skos:related rdf:resource="descriptor/13374-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18901-0">
    <skos:related rdf:resource="descriptor/14731-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18901-0">
    <skos:related rdf:resource="descriptor/14169-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14317-1">
    <skos:related rdf:resource="descriptor/13576-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14317-1">
    <skos:related rdf:resource="descriptor/13066-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14317-1">
    <skos:related rdf:resource="descriptor/18394-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14317-1">
    <skos:related rdf:resource="descriptor/18393-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16290-6">
    <skos:related rdf:resource="descriptor/15720-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16290-6">
    <skos:related rdf:resource="descriptor/16286-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16290-6">
    <skos:related rdf:resource="descriptor/19683-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11736-3">
    <skos:altLabel xml:lang="de">Funktionale Einkommensverteilung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19503-0">
    <skos:altLabel xml:lang="en">Trade union rights</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19503-0">
    <skos:altLabel xml:lang="de">Gewerkschaftsrechte</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11348-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19273-5">
    <skos:altLabel xml:lang="de">Ländlicher Kapitalmarkt</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11688-2">
    <skos:prefLabel xml:lang="en">Optimal taxation</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11688-2">
    <skos:prefLabel xml:lang="de">Optimale Besteuerung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15266-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/24708-1">
    <skos:editorialNote xml:lang="de">Der Begriff darf nur verwendet werden, wenn mindestens 2 der genannten Branchen gemeinsam behandelt werden. Ansonsten muß der spezielle Deskriptor vergeben werden.</skos:editorialNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19009-1">
    <skos:related rdf:resource="descriptor/15713-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10986-6">
    <skos:broader rdf:resource="thsys/71102"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10986-6">
    <skos:broader rdf:resource="descriptor/11068-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10986-6">
    <skos:broader rdf:resource="descriptor/16411-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12283-2">
    <skos:broader rdf:resource="thsys/70876"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12283-2">
    <skos:broader rdf:resource="thsys/70212"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16252-0">
    <skos:related rdf:resource="descriptor/19725-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16252-0">
    <skos:related rdf:resource="descriptor/16684-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16252-0">
    <skos:related rdf:resource="descriptor/18815-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16252-0">
    <skos:related rdf:resource="descriptor/12085-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16252-0">
    <skos:related rdf:resource="descriptor/15825-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16252-0">
    <skos:related rdf:resource="descriptor/15823-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16252-0">
    <skos:related rdf:resource="descriptor/11289-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11590-5">
    <skos:prefLabel xml:lang="en">Municipal budgeting</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11590-5">
    <skos:prefLabel xml:lang="de">Kommunale Finanzplanung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10501-0">
    <skos:broader rdf:resource="thsys/70575"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10501-0">
    <skos:broader rdf:resource="thsys/70091"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11616-6">
    <skos:prefLabel xml:lang="en">State-Owned Assets</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11616-6">
    <skos:prefLabel xml:lang="de">Öffentliches Vermögen</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12294-4">
    <skos:related rdf:resource="descriptor/10015-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12294-4">
    <skos:related rdf:resource="descriptor/12699-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11411-3">
    <skos:related rdf:resource="descriptor/11436-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11411-3">
    <skos:related rdf:resource="descriptor/11426-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11411-3">
    <skos:related rdf:resource="descriptor/11419-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11411-3">
    <skos:related rdf:resource="descriptor/11444-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11411-3">
    <skos:related rdf:resource="descriptor/11443-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18266-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12648-2">
    <skos:related rdf:resource="descriptor/12649-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12648-2">
    <skos:related rdf:resource="descriptor/10027-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12648-2">
    <skos:related rdf:resource="descriptor/12922-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12648-2">
    <skos:related rdf:resource="descriptor/12670-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12648-2">
    <skos:related rdf:resource="descriptor/12640-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12725-3">
    <skos:prefLabel xml:lang="en">Manufacturing system</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12725-3">
    <skos:prefLabel xml:lang="de">Fertigungssystem</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16680-0">
    <skos:related rdf:resource="descriptor/19611-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16680-0">
    <skos:related rdf:resource="descriptor/15720-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16680-0">
    <skos:related rdf:resource="descriptor/18932-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16680-0">
    <skos:related rdf:resource="descriptor/16215-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16680-0">
    <skos:related rdf:resource="descriptor/13355-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16680-0">
    <skos:related rdf:resource="descriptor/18924-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16680-0">
    <skos:related rdf:resource="descriptor/15694-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16680-0">
    <skos:related rdf:resource="descriptor/15654-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16680-0">
    <skos:related rdf:resource="descriptor/16679-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16680-0">
    <skos:related rdf:resource="descriptor/16556-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13128-2">
    <skos:altLabel xml:lang="en">Garment industry</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13128-2">
    <skos:altLabel xml:lang="en">Apparel industry</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13128-2">
    <skos:altLabel xml:lang="de">Konfektionsindustrie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16774-5">
    <skos:prefLabel xml:lang="en">Database</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16774-5">
    <skos:prefLabel xml:lang="de">Datenbank</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13473-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12254-2">
    <skos:related rdf:resource="descriptor/11203-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12254-2">
    <skos:related rdf:resource="descriptor/18760-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12254-2">
    <skos:related rdf:resource="descriptor/18759-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12254-2">
    <skos:related rdf:resource="descriptor/12274-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14945-0">
    <skos:related rdf:resource="descriptor/14088-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13632-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12433-2">
    <skos:prefLabel xml:lang="en">Group valuation</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12433-2">
    <skos:prefLabel xml:lang="de">Sammelbewertung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19337-5">
    <skos:related rdf:resource="descriptor/10722-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19337-5">
    <skos:related rdf:resource="descriptor/19665-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19337-5">
    <skos:related rdf:resource="descriptor/10746-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19337-5">
    <skos:related rdf:resource="descriptor/10781-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19337-5">
    <skos:related rdf:resource="descriptor/10779-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19337-5">
    <skos:related rdf:resource="descriptor/18730-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19337-5">
    <skos:related rdf:resource="descriptor/13688-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19569-5">
    <skos:scopeNote xml:lang="de">Nur für statistische Literatur; nicht für Bootstrapping in der Computer- und Software-Technik und nicht für die Steuerung von gesellschaftlichen Prozessen im Sinne des US-amerikanischen Bootstrapping.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71086">
    <rdfs:label xml:lang="en">Development theory</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71086">
    <rdfs:label xml:lang="de">Entwicklungstheorie</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71084">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19248-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10473-0">
    <skos:prefLabel xml:lang="en">Choice of technology</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10473-0">
    <skos:prefLabel xml:lang="de">Technologiewahl</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19728-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13860-6">
    <skos:prefLabel xml:lang="en">Housing research</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13860-6">
    <skos:prefLabel xml:lang="de">Wohnungswissenschaft</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10000-1">
    <skos:prefLabel xml:lang="en">Supply</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10000-1">
    <skos:prefLabel xml:lang="de">Angebot</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18071-1">
    <skos:prefLabel xml:lang="en">Environmental restoration</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18071-1">
    <skos:prefLabel xml:lang="de">Umweltsanierung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73338">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71038">
    <rdfs:label xml:lang="de">IS-Komponenten</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17500-2">
    <skos:prefLabel xml:lang="en">Tajikistan</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17500-2">
    <skos:prefLabel xml:lang="de">Tadschikistan</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11160-2">
    <skos:broader rdf:resource="thsys/70274"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11160-2">
    <skos:broader rdf:resource="descriptor/10975-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11160-2">
    <skos:broader rdf:resource="descriptor/11161-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12720-6">
    <skos:broader rdf:resource="thsys/70310"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12720-6">
    <skos:broader rdf:resource="descriptor/12725-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15755-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18075-0">
    <skos:prefLabel xml:lang="en">CD-ROM</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18075-0">
    <skos:prefLabel xml:lang="de">CD-ROM</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15010-1">
    <skos:related rdf:resource="descriptor/18623-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15010-1">
    <skos:related rdf:resource="descriptor/14640-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15010-1">
    <skos:related rdf:resource="descriptor/14603-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15010-1">
    <skos:related rdf:resource="descriptor/15728-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12361-1">
    <skos:broader rdf:resource="thsys/73391"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12361-1">
    <skos:broader rdf:resource="thsys/71043"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12361-1">
    <skos:broader rdf:resource="descriptor/12326-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12361-1">
    <skos:broader rdf:resource="descriptor/19142-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11318-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10672-1">
    <skos:altLabel xml:lang="de">Monetaristische Zahlungsbilanztheorie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19464-5">
    <skos:broader rdf:resource="thsys/71065"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19464-5">
    <skos:broader rdf:resource="descriptor/19460-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19464-5">
    <skos:broader rdf:resource="descriptor/12913-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10494-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13224-6">
    <skos:broader rdf:resource="thsys/70957"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13224-6">
    <skos:broader rdf:resource="descriptor/13472-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17783-6">
    <skos:prefLabel xml:lang="en">Haiti</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17783-6">
    <skos:prefLabel xml:lang="de">Haiti</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19334-4">
    <skos:altLabel xml:lang="de">Währungsrealignment</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/24856-0">
    <skos:related rdf:resource="descriptor/12079-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/24856-0">
    <skos:related rdf:resource="descriptor/18106-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/24856-0">
    <skos:related rdf:resource="descriptor/12053-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11051-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14331-0">
    <skos:broader rdf:resource="thsys/70549"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14331-0">
    <skos:broader rdf:resource="descriptor/12705-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14331-0">
    <skos:broader rdf:resource="descriptor/14336-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15770-4">
    <skos:narrower rdf:resource="descriptor/15746-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15770-4">
    <skos:narrower rdf:resource="descriptor/19632-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15770-4">
    <skos:narrower rdf:resource="descriptor/19481-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15770-4">
    <skos:narrower rdf:resource="descriptor/15737-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15770-4">
    <skos:narrower rdf:resource="descriptor/15734-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15770-4">
    <skos:narrower rdf:resource="descriptor/12021-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70169">
    <skos:broader rdf:resource="thsys/70341"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19338-3">
    <skos:scopeNote xml:lang="de">Für die verschiedenen Formen des Lebensmittelhandels BENUTZE die entsprechenden Deskriptoren.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19338-3">
    <skos:scopeNote xml:lang="de">Nur für den Nahrungsmittelmarkt im ökonomischen Sinne.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18317-2">
    <skos:altLabel xml:lang="de">Landwirtschaftliche Biotechnik</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18317-2">
    <skos:altLabel xml:lang="de">Agrarbiotechnik</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16687-0">
    <skos:broader rdf:resource="thsys/73355"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16687-0">
    <skos:broader rdf:resource="descriptor/16564-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14043-5">
    <skos:related rdf:resource="descriptor/12921-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14043-5">
    <skos:related rdf:resource="descriptor/13222-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18060-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14060-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16265-5">
    <skos:related rdf:resource="descriptor/12837-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16265-5">
    <skos:related rdf:resource="descriptor/15858-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16265-5">
    <skos:related rdf:resource="descriptor/16269-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16265-5">
    <skos:related rdf:resource="descriptor/12775-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16265-5">
    <skos:related rdf:resource="descriptor/13661-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16265-5">
    <skos:related rdf:resource="descriptor/15798-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13527-2">
    <skos:prefLabel xml:lang="en">Rail track</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13527-2">
    <skos:prefLabel xml:lang="de">Schienenstrecke</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18338-1">
    <skos:related rdf:resource="descriptor/12961-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18338-1">
    <skos:related rdf:resource="descriptor/18311-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18338-1">
    <skos:related rdf:resource="descriptor/18988-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18338-1">
    <skos:related rdf:resource="descriptor/18336-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18338-1">
    <skos:related rdf:resource="descriptor/11801-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12325-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18207-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18484-4">
    <skos:altLabel xml:lang="de">Industriearbeiterinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14418-2">
    <skos:narrower rdf:resource="descriptor/18246-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14418-2">
    <skos:narrower rdf:resource="descriptor/18297-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14418-2">
    <skos:narrower rdf:resource="descriptor/14353-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14450-6">
    <skos:altLabel xml:lang="de">U-Boot</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18496-4">
    <skos:broader rdf:resource="thsys/71066"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18496-4">
    <skos:broader rdf:resource="thsys/70889"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18496-4">
    <skos:broader rdf:resource="descriptor/12029-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19293-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10926-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10994-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14954-6">
    <skos:prefLabel xml:lang="en">Cheese</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14954-6">
    <skos:prefLabel xml:lang="de">Käse</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19247-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19842-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19132-2">
    <skos:prefLabel xml:lang="en">Advertising restriction</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19132-2">
    <skos:prefLabel xml:lang="de">Werbebeschränkung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18830-4">
    <skos:related rdf:resource="descriptor/16272-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18830-4">
    <skos:related rdf:resource="descriptor/12047-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18830-4">
    <skos:related rdf:resource="descriptor/19680-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18830-4">
    <skos:related rdf:resource="descriptor/16409-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18830-4">
    <skos:related rdf:resource="descriptor/16587-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18830-4">
    <skos:related rdf:resource="descriptor/11037-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19129-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15740-6">
    <skos:broader rdf:resource="thsys/70239"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15740-6">
    <skos:broader rdf:resource="descriptor/15737-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71071">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11589-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11957-1">
    <skos:related rdf:resource="descriptor/19613-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11957-1">
    <skos:related rdf:resource="descriptor/14814-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13137-1">
    <skos:altLabel xml:lang="de">Lederwarenindustrie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13137-1">
    <skos:altLabel xml:lang="de">Ledertaschenindustrie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13137-1">
    <skos:altLabel xml:lang="de">Lederbekleidungsindustrie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13137-1">
    <skos:altLabel xml:lang="de">Kofferindustrie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19570-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18523-6">
    <skos:altLabel xml:lang="de">PC-Handel</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19619-2">
    <skos:broader rdf:resource="thsys/73353"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/21042-2">
    <skos:altLabel xml:lang="de">Osttimor</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/21042-2">
    <skos:altLabel xml:lang="de">Ost-Timor</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/21042-2">
    <skos:altLabel xml:lang="de">Demokratische Republik Timor-Leste</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/21042-2">
    <skos:altLabel xml:lang="de">Demokratische Republik Osttimor</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15917-0">
    <skos:prefLabel xml:lang="en">Inuit</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15917-0">
    <skos:prefLabel xml:lang="de">Inuit</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11444-2">
    <skos:prefLabel xml:lang="en">Currency school</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11444-2">
    <skos:prefLabel xml:lang="de">Currency-Theorie</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10054-6">
    <skos:broader rdf:resource="thsys/70141"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10054-6">
    <skos:broader rdf:resource="descriptor/16745-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13871-1">
    <skos:broader rdf:resource="thsys/71055"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13871-1">
    <skos:broader rdf:resource="thsys/70958"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13871-1">
    <skos:broader rdf:resource="descriptor/18535-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15124-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19344-1">
    <skos:related rdf:resource="descriptor/19343-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19344-1">
    <skos:related rdf:resource="descriptor/12950-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19344-1">
    <skos:related rdf:resource="descriptor/14142-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71061">
    <skos:notation rdf:datatype="http://www.w3.org/2001/XMLSchema#string">V.13.01.02</skos:notation>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15954-1">
    <skos:prefLabel xml:lang="en">International migration</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15954-1">
    <skos:prefLabel xml:lang="de">Internationale Wanderung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13472-1">
    <skos:narrower rdf:resource="descriptor/13224-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13472-1">
    <skos:narrower rdf:resource="descriptor/13215-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12216-3">
    <skos:related rdf:resource="descriptor/12226-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12216-3">
    <skos:related rdf:resource="descriptor/12898-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12216-3">
    <skos:related rdf:resource="descriptor/12218-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12216-3">
    <skos:related rdf:resource="descriptor/12458-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12216-3">
    <skos:related rdf:resource="descriptor/12357-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12216-3">
    <skos:related rdf:resource="descriptor/12053-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19250-3">
    <skos:prefLabel xml:lang="en">Economies of scope</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19250-3">
    <skos:prefLabel xml:lang="de">Verbundvorteil</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19841-1">
    <skos:narrower rdf:resource="descriptor/15979-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19841-1">
    <skos:narrower rdf:resource="descriptor/15962-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19841-1">
    <skos:narrower rdf:resource="descriptor/13410-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17980-4">
    <skos:narrower rdf:resource="descriptor/17433-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17980-4">
    <skos:narrower rdf:resource="descriptor/17198-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17980-4">
    <skos:narrower rdf:resource="descriptor/17201-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16727-0">
    <skos:narrower rdf:resource="descriptor/15064-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16727-0">
    <skos:narrower rdf:resource="descriptor/20022-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16727-0">
    <skos:narrower rdf:resource="descriptor/19989-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16727-0">
    <skos:narrower rdf:resource="descriptor/19219-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16727-0">
    <skos:narrower rdf:resource="descriptor/16726-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16727-0">
    <skos:narrower rdf:resource="descriptor/19218-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16727-0">
    <skos:narrower rdf:resource="descriptor/19743-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16727-0">
    <skos:narrower rdf:resource="descriptor/19070-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16727-0">
    <skos:narrower rdf:resource="descriptor/19742-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12244-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18852-1">
    <skos:scopeNote xml:lang="de">Organisatorische Gestaltung und Aufbau von Gewerkschaften.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18368-6">
    <skos:related rdf:resource="descriptor/12605-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18368-6">
    <skos:related rdf:resource="descriptor/15757-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18368-6">
    <skos:related rdf:resource="descriptor/14035-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18368-6">
    <skos:related rdf:resource="descriptor/16001-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16387-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10891-3">
    <skos:prefLabel xml:lang="en">Industrial economics</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10891-3">
    <skos:prefLabel xml:lang="de">Industrieökonomik</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16603-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13627-5">
    <skos:broader rdf:resource="thsys/70940"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13627-5">
    <skos:broader rdf:resource="thsys/70934"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13627-5">
    <skos:broader rdf:resource="descriptor/13553-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12748-5">
    <skos:prefLabel xml:lang="en">Work scheduling</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12748-5">
    <skos:prefLabel xml:lang="de">Arbeitsplanung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19016-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10513-0">
    <skos:prefLabel xml:lang="en">Economic development</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10513-0">
    <skos:prefLabel xml:lang="de">Entwicklung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73354">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18429-5">
    <skos:scopeNote xml:lang="de">Für alle Verfahrenstechniken, die in der Chemischen Industrie angewendet werden.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13464-0">
    <skos:related rdf:resource="descriptor/16081-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13464-0">
    <skos:related rdf:resource="descriptor/15977-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13464-0">
    <skos:related rdf:resource="descriptor/12191-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13464-0">
    <skos:related rdf:resource="descriptor/12787-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13464-0">
    <skos:related rdf:resource="descriptor/13210-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13464-0">
    <skos:related rdf:resource="descriptor/19819-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13464-0">
    <skos:related rdf:resource="descriptor/16053-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13464-0">
    <skos:related rdf:resource="descriptor/16050-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13464-0">
    <skos:related rdf:resource="descriptor/19080-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13464-0">
    <skos:related rdf:resource="descriptor/12033-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13135-5">
    <skos:related rdf:resource="descriptor/14630-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13135-5">
    <skos:related rdf:resource="descriptor/14829-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13135-5">
    <skos:related rdf:resource="descriptor/14127-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18027-4">
    <skos:prefLabel xml:lang="en">Broadcast programme</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18027-4">
    <skos:prefLabel xml:lang="de">Rundfunkprogramm</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19508-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18079-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14385-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13291-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12722-2">
    <skos:related rdf:resource="descriptor/12718-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14354-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14306-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10005-5">
    <skos:narrower rdf:resource="descriptor/11124-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10005-5">
    <skos:narrower rdf:resource="descriptor/12026-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10005-5">
    <skos:narrower rdf:resource="descriptor/11044-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18130-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13053-0">
    <skos:broader rdf:resource="thsys/70997"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13053-0">
    <skos:broader rdf:resource="descriptor/13051-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18383-3">
    <skos:broader rdf:resource="thsys/71009"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18383-3">
    <skos:broader rdf:resource="descriptor/12041-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11422-5">
    <skos:related rdf:resource="descriptor/11460-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11422-5">
    <skos:related rdf:resource="descriptor/11449-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18149-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15126-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10854-2">
    <skos:broader rdf:resource="thsys/71091"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10854-2">
    <skos:broader rdf:resource="thsys/70951"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10854-2">
    <skos:broader rdf:resource="descriptor/25742-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18396-1">
    <skos:related rdf:resource="descriptor/13079-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18396-1">
    <skos:related rdf:resource="descriptor/18252-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18396-1">
    <skos:related rdf:resource="descriptor/13078-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18396-1">
    <skos:related rdf:resource="descriptor/13076-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15610-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12744-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70871">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18165-6">
    <skos:prefLabel xml:lang="en">Environmental management</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18165-6">
    <skos:prefLabel xml:lang="de">Umweltmanagement</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15839-1">
    <zbwext:useInsteadNote rdf:nodeID="id192"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19477-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19731-1">
    <skos:broader rdf:resource="thsys/73394"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19731-1">
    <skos:broader rdf:resource="descriptor/16719-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18752-5">
    <skos:related rdf:resource="descriptor/13840-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17201-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11888-1">
    <skos:broader rdf:resource="thsys/70572"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11888-1">
    <skos:broader rdf:resource="thsys/70058"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11888-1">
    <skos:broader rdf:resource="descriptor/15709-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19147-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18235-4">
    <skos:related rdf:resource="descriptor/18024-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13198-2">
    <skos:prefLabel xml:lang="en">Chemicals trade</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13198-2">
    <skos:prefLabel xml:lang="de">Chemikalienhandel</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14997-2">
    <skos:broader rdf:resource="thsys/73298"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14997-2">
    <skos:broader rdf:resource="descriptor/18222-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12845-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10324-3">
    <skos:broader rdf:resource="thsys/70310"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10324-3">
    <skos:broader rdf:resource="descriptor/12725-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14490-1">
    <skos:prefLabel xml:lang="en">Telecommunications equipment</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14490-1">
    <skos:prefLabel xml:lang="de">Nachrichtentechnisches Gerät</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18257-1">
    <skos:broader rdf:resource="thsys/70476"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18257-1">
    <skos:broader rdf:resource="descriptor/14710-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18257-1">
    <skos:broader rdf:resource="descriptor/14151-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10481-1">
    <skos:broader rdf:resource="thsys/73391"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10481-1">
    <skos:broader rdf:resource="thsys/71109"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10481-1">
    <skos:broader rdf:resource="descriptor/16053-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10115-5">
    <skos:related rdf:resource="descriptor/11129-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10115-5">
    <skos:related rdf:resource="descriptor/12354-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10115-5">
    <skos:related rdf:resource="descriptor/10287-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16329-5">
    <skos:narrower rdf:resource="descriptor/19694-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16329-5">
    <skos:narrower rdf:resource="descriptor/16330-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16329-5">
    <skos:narrower rdf:resource="descriptor/16327-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16329-5">
    <skos:narrower rdf:resource="descriptor/16324-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14502-6">
    <skos:related rdf:resource="descriptor/14554-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14502-6">
    <skos:related rdf:resource="descriptor/13075-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11036-3">
    <skos:prefLabel xml:lang="en">Worker self-management</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11036-3">
    <skos:prefLabel xml:lang="de">Arbeiterselbstverwaltung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20817-2">
    <skos:broader rdf:resource="thsys/71091"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20817-2">
    <skos:broader rdf:resource="thsys/70091"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20817-2">
    <skos:broader rdf:resource="descriptor/10587-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12738-1">
    <skos:altLabel xml:lang="de">PC-Werkzeugmaschine</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12738-1">
    <skos:altLabel xml:lang="de">DNC-Werkzeugmaschine</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12738-1">
    <skos:altLabel xml:lang="de">CNC-Werkzeugmaschine</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12738-1">
    <skos:altLabel xml:lang="de">AC-Werkzeugmaschine</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/21020-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12777-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10587-6">
    <skos:narrower rdf:resource="descriptor/20817-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18250-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71081">
    <skos:notation rdf:datatype="http://www.w3.org/2001/XMLSchema#string">V.09.03</skos:notation>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13302-5">
    <skos:broader rdf:resource="thsys/70888"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13302-5">
    <skos:broader rdf:resource="thsys/70855"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13302-5">
    <skos:broader rdf:resource="descriptor/13305-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13302-5">
    <skos:broader rdf:resource="descriptor/11825-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16487-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10062-0">
    <skos:narrower rdf:resource="descriptor/10113-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10062-0">
    <skos:narrower rdf:resource="descriptor/10956-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10062-0">
    <skos:narrower rdf:resource="descriptor/11090-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10062-0">
    <skos:narrower rdf:resource="descriptor/10144-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10062-0">
    <skos:narrower rdf:resource="descriptor/18310-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10062-0">
    <skos:narrower rdf:resource="descriptor/10249-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10062-0">
    <skos:narrower rdf:resource="descriptor/10181-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10062-0">
    <skos:narrower rdf:resource="descriptor/10891-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10062-0">
    <skos:narrower rdf:resource="descriptor/10076-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10062-0">
    <skos:narrower rdf:resource="descriptor/10236-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10062-0">
    <skos:narrower rdf:resource="descriptor/11715-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10062-0">
    <skos:narrower rdf:resource="descriptor/10525-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10062-0">
    <skos:narrower rdf:resource="descriptor/10629-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10062-0">
    <skos:narrower rdf:resource="descriptor/11219-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12071-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14957-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11833-5">
    <skos:related rdf:resource="descriptor/11834-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11833-5">
    <skos:related rdf:resource="descriptor/13569-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11833-5">
    <skos:related rdf:resource="descriptor/18187-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11833-5">
    <skos:related rdf:resource="descriptor/11832-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11833-5">
    <skos:related rdf:resource="descriptor/13588-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11833-5">
    <skos:related rdf:resource="descriptor/13264-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11833-5">
    <skos:related rdf:resource="descriptor/13510-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11833-5">
    <skos:related rdf:resource="descriptor/13639-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16250-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18558-1">
    <skos:prefLabel xml:lang="en">Bar code</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18558-1">
    <skos:prefLabel xml:lang="de">Barcode</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13727-1">
    <skos:prefLabel xml:lang="en">Action de jouissance</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13727-1">
    <skos:prefLabel xml:lang="de">Genussschein</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12192-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19139-2">
    <skos:prefLabel xml:lang="en">Sales management</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19139-2">
    <skos:prefLabel xml:lang="de">Verkauf</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15055-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19034-2">
    <skos:prefLabel xml:lang="en">Standardization</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19034-2">
    <skos:prefLabel xml:lang="de">Normung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70951">
    <skos:broader rdf:resource="thsys/70952"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12016-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70811">
    <skos:broader rdf:resource="thsys/70082"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18903-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16008-4">
    <skos:broader rdf:resource="thsys/73378"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16008-4">
    <skos:broader rdf:resource="thsys/73361"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16008-4">
    <skos:broader rdf:resource="descriptor/16017-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10043-4">
    <skos:prefLabel xml:lang="en">Small open economy</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10043-4">
    <skos:prefLabel xml:lang="de">Kleines-offenes-Land</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12138-4">
    <skos:altLabel xml:lang="de">Organisatorische Zentralisierung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70934">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12255-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12313-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70306">
    <skos:notation rdf:datatype="http://www.w3.org/2001/XMLSchema#string">V.05.01</skos:notation>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10912-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18744-4">
    <skos:altLabel xml:lang="de">Vertrieb von Versicherungen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18744-4">
    <skos:altLabel xml:lang="de">Versicherungsvertrieb</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10963-4">
    <skos:narrower rdf:resource="descriptor/10962-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10963-4">
    <skos:narrower rdf:resource="descriptor/10894-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10963-4">
    <skos:narrower rdf:resource="descriptor/10958-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10963-4">
    <skos:narrower rdf:resource="descriptor/18011-5"/>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id77">
    <rdfs:seeAlso rdf:resource="descriptor/19081-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19831-4">
    <skos:broader rdf:resource="thsys/70209"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19831-4">
    <skos:broader rdf:resource="descriptor/15767-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70082">
    <skos:prefLabel xml:lang="de">V.12  Umwelt- und Ressourcenökonomik</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13649-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70832">
    <skos:narrower rdf:resource="descriptor/13411-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70832">
    <skos:narrower rdf:resource="descriptor/19515-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70832">
    <skos:narrower rdf:resource="descriptor/16160-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70832">
    <skos:narrower rdf:resource="descriptor/18913-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70832">
    <skos:narrower rdf:resource="descriptor/16547-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70832">
    <skos:narrower rdf:resource="descriptor/13418-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70832">
    <skos:narrower rdf:resource="descriptor/19512-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70832">
    <skos:narrower rdf:resource="descriptor/16539-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70832">
    <skos:narrower rdf:resource="descriptor/18739-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70832">
    <skos:narrower rdf:resource="descriptor/18180-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70832">
    <skos:narrower rdf:resource="descriptor/18105-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70832">
    <skos:narrower rdf:resource="descriptor/16548-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70832">
    <skos:narrower rdf:resource="descriptor/19514-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70832">
    <skos:narrower rdf:resource="descriptor/19551-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70832">
    <skos:narrower rdf:resource="descriptor/13292-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70832">
    <skos:narrower rdf:resource="descriptor/19513-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70832">
    <skos:narrower rdf:resource="descriptor/13416-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70832">
    <skos:narrower rdf:resource="descriptor/13415-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70832">
    <skos:narrower rdf:resource="descriptor/16531-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70832">
    <skos:narrower rdf:resource="descriptor/12591-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70832">
    <skos:narrower rdf:resource="descriptor/13406-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70832">
    <skos:narrower rdf:resource="descriptor/16527-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70832">
    <skos:narrower rdf:resource="descriptor/16526-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17739-2">
    <skos:prefLabel xml:lang="en">Sao Tome and Principe</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17739-2">
    <skos:prefLabel xml:lang="de">Sao Tome und Principe</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14816-4">
    <skos:altLabel xml:lang="de">Vervielfältigungsprodukt</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14816-4">
    <skos:altLabel xml:lang="de">Photokopie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14816-4">
    <skos:altLabel xml:lang="de">Fotokopie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10804-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18809-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11574-3">
    <skos:broader rdf:resource="thsys/71080"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11574-3">
    <skos:broader rdf:resource="thsys/70888"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11574-3">
    <skos:broader rdf:resource="thsys/70884"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11574-3">
    <skos:broader rdf:resource="descriptor/11570-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11574-3">
    <skos:broader rdf:resource="descriptor/18754-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11574-3">
    <skos:broader rdf:resource="descriptor/18755-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19175-5">
    <skos:related rdf:resource="descriptor/17687-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19175-5">
    <skos:related rdf:resource="descriptor/17672-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12303-1">
    <skos:broader rdf:resource="thsys/71034"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11738-6">
    <skos:broader rdf:resource="thsys/71114"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11738-6">
    <skos:broader rdf:resource="thsys/70269"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11738-6">
    <skos:broader rdf:resource="descriptor/15045-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11738-6">
    <skos:broader rdf:resource="descriptor/11753-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15686-0">
    <skos:scopeNote xml:lang="de">Befasst sich u.a. mit der Entwicklung der Wissenschaft oder einzelner Disziplinen, ihren Inhalten und ihrer Vermittlung bzw. mit dem Wissenschaftssystem (Einrichtungen, Scientific Community) einzelner Länder/Regionen. Zunehmend werden quantitative Analysen unternommen (Scientometrie).</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18112-6">
    <skos:prefLabel xml:lang="en">Telework</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18112-6">
    <skos:prefLabel xml:lang="de">Telearbeit</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="http://www.w3.org/2004/02/skos/core#narrower">
    <rdfs:label xml:lang="en">has narrower</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20002-5">
    <skos:broader rdf:resource="thsys/70952"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20002-5">
    <skos:broader rdf:resource="descriptor/10838-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19779-1">
    <skos:broader rdf:resource="thsys/70580"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17590-3">
    <skos:prefLabel xml:lang="en">Thailand</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17590-3">
    <skos:prefLabel xml:lang="de">Thailand</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10944-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14215-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18218-4">
    <skos:related rdf:resource="descriptor/12941-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18218-4">
    <skos:related rdf:resource="descriptor/14135-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19171-6">
    <skos:related rdf:resource="descriptor/19172-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19477-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11211-4">
    <skos:prefLabel xml:lang="en">Labour market segmentation</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11211-4">
    <skos:prefLabel xml:lang="de">Arbeitsmarktsegmentierung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="http://www.w3.org/2004/02/skos/core#narrowMatch">
    <rdfs:subPropertyOf rdf:resource="http://www.w3.org/2004/02/skos/core#narrower"/>
  </rdf:Description>
  <rdf:Description rdf:about="http://www.w3.org/2004/02/skos/core#narrowMatch">
    <rdfs:subPropertyOf rdf:resource="http://www.w3.org/2004/02/skos/core#mappingRelation"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18248-2">
    <skos:related rdf:resource="descriptor/13627-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18967-5">
    <skos:scopeNote xml:lang="de">Landschaftliche Neugestaltung eines durch wirtschaftliche oder militärische Nutzung zerstörten Geländes.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13229-3">
    <skos:prefLabel xml:lang="en">Photographic shop</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13229-3">
    <skos:prefLabel xml:lang="de">Fotohandel</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13985-0">
    <skos:altLabel xml:lang="en">Clerical occupations</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13985-0">
    <skos:altLabel xml:lang="de">Sekretärinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13985-0">
    <skos:altLabel xml:lang="de">Sekretäre</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13985-0">
    <skos:altLabel xml:lang="de">Schreibkräfte</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13985-0">
    <skos:altLabel xml:lang="de">Sachbearbeiterinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13985-0">
    <skos:altLabel xml:lang="de">Sachbearbeiter</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13985-0">
    <skos:altLabel xml:lang="de">Datentypistinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13985-0">
    <skos:altLabel xml:lang="de">Datentypisten</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13985-0">
    <skos:altLabel xml:lang="de">Bürokaufleute</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13985-0">
    <skos:altLabel xml:lang="de">Bürofachkräfte</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13985-0">
    <skos:altLabel xml:lang="de">Büroangestellte</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11237-0">
    <skos:broader rdf:resource="thsys/73380"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11237-0">
    <skos:broader rdf:resource="thsys/71061"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11237-0">
    <skos:broader rdf:resource="thsys/70868"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11237-0">
    <skos:broader rdf:resource="descriptor/13413-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19427-4">
    <skos:scopeNote xml:lang="de">Zerlegung des Rohöls</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11441-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18741-3">
    <skos:altLabel xml:lang="de">Versicherungsökonomie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18741-3">
    <skos:altLabel xml:lang="de">Ökonomische Theorie der Versicherungsmärkte</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70301">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11206-4">
    <skos:related rdf:resource="descriptor/10658-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11206-4">
    <skos:related rdf:resource="descriptor/10614-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11071-1">
    <skos:altLabel xml:lang="en">Law of value</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11071-1">
    <skos:altLabel xml:lang="en">Labor theory of value</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11071-1">
    <skos:altLabel xml:lang="de">Wertgesetz</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11071-1">
    <skos:altLabel xml:lang="de">Ricardianische Wertlehre</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11071-1">
    <skos:altLabel xml:lang="de">Ricardianische Arbeitswertlehre</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11071-1">
    <skos:altLabel xml:lang="de">Marxistische Werttheorie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11071-1">
    <skos:altLabel xml:lang="de">Marxistische Wertlehre</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11071-1">
    <skos:altLabel xml:lang="de">Arbeitswerttheorie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11071-1">
    <skos:altLabel xml:lang="de">Arbeitswert</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13706-2">
    <skos:broader rdf:resource="thsys/70903"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13706-2">
    <skos:broader rdf:resource="descriptor/13283-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12883-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17553-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11969-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17704-0">
    <skos:broader rdf:resource="thsys/70560"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17704-0">
    <skos:broader rdf:resource="descriptor/17724-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15470-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19842-6">
    <skos:scopeNote xml:lang="de">Für die Vollstreckung von Forderungen aller Art.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18958-6">
    <skos:broader rdf:resource="thsys/73371"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18958-6">
    <skos:broader rdf:resource="thsys/70818"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18958-6">
    <skos:broader rdf:resource="thsys/70239"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18958-6">
    <skos:broader rdf:resource="descriptor/15752-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11407-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14483-5">
    <zbwext:useInsteadNote rdf:nodeID="id160"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18655-3">
    <zbwext:useInsteadNote rdf:nodeID="id210"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18324-5">
    <skos:broader rdf:resource="thsys/71024"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18324-5">
    <skos:broader rdf:resource="thsys/71019"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18324-5">
    <skos:broader rdf:resource="descriptor/18315-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18324-5">
    <skos:broader rdf:resource="descriptor/12961-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18324-5">
    <skos:broader rdf:resource="descriptor/13452-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17829-1">
    <skos:altLabel xml:lang="en">United States of America</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17829-1">
    <skos:altLabel xml:lang="de">Vereinigte Staaten von Amerika</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17829-1">
    <skos:altLabel xml:lang="de">Vereinigte Staaten</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18475-5">
    <skos:broader rdf:resource="thsys/70891"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18475-5">
    <skos:broader rdf:resource="descriptor/18737-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14488-2">
    <skos:related rdf:resource="descriptor/14486-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14434-4">
    <skos:broader rdf:resource="thsys/70258"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14434-4">
    <skos:broader rdf:resource="descriptor/14441-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/24704-2">
    <skos:related rdf:resource="descriptor/19155-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18017-0">
    <skos:narrower rdf:resource="descriptor/18662-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18017-0">
    <skos:narrower rdf:resource="descriptor/18767-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18017-0">
    <skos:narrower rdf:resource="descriptor/20341-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18837-4">
    <skos:broader rdf:resource="thsys/71064"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18837-4">
    <skos:broader rdf:resource="thsys/70856"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18837-4">
    <skos:broader rdf:resource="descriptor/19448-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11912-2">
    <skos:broader rdf:resource="thsys/71070"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11912-2">
    <skos:broader rdf:resource="descriptor/10032-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11912-2">
    <skos:broader rdf:resource="descriptor/11951-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19357-6">
    <skos:related rdf:resource="descriptor/10833-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11353-5">
    <skos:related rdf:resource="descriptor/19253-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11353-5">
    <skos:related rdf:resource="descriptor/15656-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11353-5">
    <skos:related rdf:resource="descriptor/11367-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11353-5">
    <skos:related rdf:resource="descriptor/11397-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11353-5">
    <skos:related rdf:resource="descriptor/11354-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11353-5">
    <skos:related rdf:resource="descriptor/11394-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11353-5">
    <skos:related rdf:resource="descriptor/11400-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11353-5">
    <skos:related rdf:resource="descriptor/19916-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19300-0">
    <skos:prefLabel xml:lang="en">Rice price</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19300-0">
    <skos:prefLabel xml:lang="de">Reispreis</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18399-2">
    <skos:related rdf:resource="descriptor/12905-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15704-3">
    <skos:broader rdf:resource="thsys/73387"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15704-3">
    <skos:broader rdf:resource="thsys/70141"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15704-3">
    <skos:broader rdf:resource="thsys/70109"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15704-3">
    <skos:broader rdf:resource="descriptor/15706-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15704-3">
    <skos:broader rdf:resource="descriptor/16745-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19777-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18328-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13117-0">
    <skos:altLabel xml:lang="de">Zellstoff- und Papierindustrie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13117-0">
    <skos:altLabel xml:lang="de">Pappeindustrie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13117-0">
    <skos:altLabel xml:lang="de">Papiermühle</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13117-0">
    <skos:altLabel xml:lang="de">Papierindustrie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13117-0">
    <skos:altLabel xml:lang="de">Papier- und Zellstoffindustrie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13117-0">
    <skos:altLabel xml:lang="de">Kartonindustrie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id372">
    <rdf:value xml:lang="de">Für langfristige qualitative Entwicklungsprozesse</rdf:value>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id390">
    <rdfs:seeAlso rdf:resource="descriptor/19042-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14083-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12882-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20002-5">
    <skos:prefLabel xml:lang="en">Parallel imports</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20002-5">
    <skos:prefLabel xml:lang="de">Parallelimport</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11671-5">
    <skos:prefLabel xml:lang="en">Luxury tax</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11671-5">
    <skos:prefLabel xml:lang="de">Luxussteuer</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12387-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18829-3">
    <skos:related rdf:resource="descriptor/11559-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18829-3">
    <skos:related rdf:resource="descriptor/11318-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18829-3">
    <skos:related rdf:resource="descriptor/11185-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15026-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70179">
    <skos:prefLabel xml:lang="de">V.07  Außenwirtschaft und internationale Wirtschaftsbeziehungen</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19570-6">
    <skos:prefLabel xml:lang="en">Structural break</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19570-6">
    <skos:prefLabel xml:lang="de">Strukturbruch</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20002-5">
    <skos:related rdf:resource="descriptor/12778-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20002-5">
    <skos:related rdf:resource="descriptor/18066-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20002-5">
    <skos:related rdf:resource="descriptor/12800-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20002-5">
    <skos:related rdf:resource="descriptor/10876-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20002-5">
    <skos:related rdf:resource="descriptor/10872-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20002-5">
    <skos:related rdf:resource="descriptor/16053-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19022-2">
    <skos:narrower rdf:resource="descriptor/14135-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18000-3">
    <skos:related rdf:resource="descriptor/18649-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18000-3">
    <skos:related rdf:resource="descriptor/19431-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18000-3">
    <skos:related rdf:resource="descriptor/18647-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18000-3">
    <skos:related rdf:resource="descriptor/18655-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19365-0">
    <zbwext:useInsteadNote rdf:nodeID="id166"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12470-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14916-0">
    <skos:prefLabel xml:lang="en">Furs</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14916-0">
    <skos:prefLabel xml:lang="de">Pelzwaren</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11350-4">
    <skos:broader rdf:resource="thsys/70852"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11350-4">
    <skos:broader rdf:resource="thsys/70235"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11350-4">
    <skos:broader rdf:resource="descriptor/10984-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12170-1">
    <skos:scopeNote xml:lang="de">Messung des Informationswertes z.B. von Börsen- oder Firmeninformationen, von statistischen Erhebungen, usw.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70879">
    <skos:broader rdf:resource="thsys/w"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19111-3">
    <skos:prefLabel xml:lang="en">Job</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19111-3">
    <skos:prefLabel xml:lang="de">Arbeitsplatz</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15718-6">
    <skos:related rdf:resource="descriptor/16597-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15718-6">
    <skos:related rdf:resource="descriptor/15721-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15718-6">
    <skos:related rdf:resource="descriptor/15719-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15718-6">
    <skos:related rdf:resource="descriptor/15717-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15718-6">
    <skos:related rdf:resource="descriptor/16654-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15718-6">
    <skos:related rdf:resource="descriptor/16623-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15718-6">
    <skos:related rdf:resource="descriptor/16674-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15718-6">
    <skos:related rdf:resource="descriptor/15698-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15718-6">
    <skos:related rdf:resource="descriptor/16645-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15718-6">
    <skos:related rdf:resource="descriptor/16663-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15718-6">
    <skos:related rdf:resource="descriptor/19772-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15718-6">
    <skos:related rdf:resource="descriptor/11073-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15718-6">
    <skos:related rdf:resource="descriptor/15713-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15718-6">
    <skos:related rdf:resource="descriptor/11400-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15718-6">
    <skos:related rdf:resource="descriptor/10488-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11579-0">
    <skos:broader rdf:resource="thsys/70859"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11579-0">
    <skos:broader rdf:resource="thsys/70144"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11579-0">
    <skos:broader rdf:resource="descriptor/12640-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10774-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14334-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16042-4">
    <skos:prefLabel xml:lang="en">Private law</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16042-4">
    <skos:prefLabel xml:lang="de">Privatrecht</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13156-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18897-0">
    <skos:broader rdf:resource="thsys/73346"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18897-0">
    <skos:broader rdf:resource="descriptor/16670-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18791-2">
    <skos:broader rdf:resource="thsys/70875"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18791-2">
    <skos:broader rdf:resource="descriptor/12881-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18791-2">
    <skos:broader rdf:resource="descriptor/13389-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19396-3">
    <skos:related rdf:resource="descriptor/18103-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19396-3">
    <skos:related rdf:resource="descriptor/18425-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19396-3">
    <skos:related rdf:resource="descriptor/18424-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19396-3">
    <skos:related rdf:resource="descriptor/18523-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12188-3">
    <skos:broader rdf:resource="thsys/70087"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12188-3">
    <skos:broader rdf:resource="descriptor/12186-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19276-6">
    <skos:broader rdf:resource="thsys/71108"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19276-6">
    <skos:broader rdf:resource="descriptor/13726-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19276-6">
    <skos:broader rdf:resource="descriptor/11441-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10891-3">
    <skos:broader rdf:resource="thsys/70101"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10891-3">
    <skos:broader rdf:resource="descriptor/10062-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16842-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16066-4">
    <skos:broader rdf:resource="thsys/73366"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16066-4">
    <skos:broader rdf:resource="thsys/73332"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16066-4">
    <skos:broader rdf:resource="thsys/71084"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16066-4">
    <skos:broader rdf:resource="descriptor/16184-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16066-4">
    <skos:broader rdf:resource="descriptor/19350-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18839-0">
    <skos:related rdf:resource="descriptor/18841-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73360">
    <skos:broader rdf:resource="thsys/70160"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15810-4">
    <skos:broader rdf:resource="thsys/73358"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19037-3">
    <skos:editorialNote xml:lang="de">Möglichst spezifischer indexieren.</skos:editorialNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19641-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16551-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19568-0">
    <skos:narrower rdf:resource="descriptor/19569-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14722-6">
    <skos:narrower rdf:resource="descriptor/14725-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71035">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14122-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12818-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11294-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19724-5">
    <skos:broader rdf:resource="thsys/73363"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19724-5">
    <skos:broader rdf:resource="thsys/70865"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19724-5">
    <skos:broader rdf:resource="descriptor/12670-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17754-6">
    <skos:broader rdf:resource="thsys/70085"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17754-6">
    <skos:broader rdf:resource="descriptor/17750-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17754-6">
    <skos:broader rdf:resource="descriptor/17978-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16828-1">
    <skos:scopeNote xml:lang="de">Durch Parlamentsbeschluss aufgelöst am 31.12.1992; Nachfolgestaaten: Slowakei und Tschechische Republik.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18281-4">
    <skos:broader rdf:resource="thsys/71015"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18281-4">
    <skos:broader rdf:resource="descriptor/12977-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13515-2">
    <skos:prefLabel xml:lang="en">Transport mode</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13515-2">
    <skos:prefLabel xml:lang="de">Verkehrsträger</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18365-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18520-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18767-6">
    <skos:altLabel xml:lang="de">Dokument-Management-System</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18767-6">
    <skos:altLabel xml:lang="de">Dokumentenverwaltungssystem</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18767-6">
    <skos:altLabel xml:lang="de">Dokumentenmanagementsystem</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18767-6">
    <skos:altLabel xml:lang="de">Dokumentenmanagement-System</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18767-6">
    <skos:altLabel xml:lang="de">Dokumenten-Management-System</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18767-6">
    <skos:altLabel xml:lang="de">Dokumentenmanagement System</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18767-6">
    <skos:altLabel xml:lang="de">DMS (Dokumentenmanagement-System)</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16146-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12915-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18590-5">
    <skos:prefLabel xml:lang="en">Ship finance</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18590-5">
    <skos:prefLabel xml:lang="de">Schifffahrtsfinanzierung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15690-2">
    <skos:narrower rdf:resource="descriptor/15700-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15690-2">
    <skos:narrower rdf:resource="descriptor/15706-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15690-2">
    <skos:narrower rdf:resource="descriptor/15699-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15690-2">
    <skos:narrower rdf:resource="descriptor/13511-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15690-2">
    <skos:narrower rdf:resource="descriptor/10465-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15690-2">
    <skos:narrower rdf:resource="descriptor/15695-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15690-2">
    <skos:narrower rdf:resource="descriptor/15723-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15690-2">
    <skos:narrower rdf:resource="descriptor/15968-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15690-2">
    <skos:narrower rdf:resource="descriptor/15696-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15690-2">
    <skos:narrower rdf:resource="descriptor/15694-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15690-2">
    <skos:narrower rdf:resource="descriptor/15689-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11156-0">
    <skos:broader rdf:resource="thsys/70274"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11156-0">
    <skos:broader rdf:resource="thsys/70180"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11156-0">
    <skos:broader rdf:resource="descriptor/19213-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16312-1">
    <skos:broader rdf:resource="thsys/73382"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16312-1">
    <skos:broader rdf:resource="descriptor/16305-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19120-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20104-4">
    <skos:altLabel xml:lang="de">Taylor Regel</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19323-2">
    <skos:scopeNote xml:lang="de">Nationale und internationale Bestimmungen zur Regelung des Aufenthaltsrechts sowie des Rechts zur Aufnahme und Ausübung einer beruflichen und gewerblichen Tätigkeit.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18260-5">
    <skos:altLabel xml:lang="en">Biotech industry</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12964-6">
    <skos:altLabel xml:lang="de">Seefischerei</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11879-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70051">
    <skos:broader rdf:resource="thsys/70052"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10514-5">
    <skos:altLabel xml:lang="de">Wirtschaftliche Unterentwicklung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16134-6">
    <skos:broader rdf:resource="thsys/73360"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16134-6">
    <skos:broader rdf:resource="thsys/70843"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16134-6">
    <skos:broader rdf:resource="thsys/70176"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16134-6">
    <skos:broader rdf:resource="descriptor/16019-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11464-3">
    <skos:broader rdf:resource="thsys/70306"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14377-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14635-1">
    <skos:broader rdf:resource="thsys/70014"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14635-1">
    <skos:broader rdf:resource="descriptor/14599-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15315-0">
    <skos:prefLabel xml:lang="en">Nonparametric statistics</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15315-0">
    <skos:prefLabel xml:lang="de">Nichtparametrisches Verfahren</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19585-0">
    <skos:broader rdf:resource="thsys/72181"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19585-0">
    <skos:broader rdf:resource="thsys/71019"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19585-0">
    <skos:broader rdf:resource="descriptor/15076-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18421-0">
    <skos:related rdf:resource="descriptor/18585-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18421-0">
    <skos:related rdf:resource="descriptor/18422-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18421-0">
    <skos:related rdf:resource="descriptor/13051-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18421-0">
    <skos:related rdf:resource="descriptor/14433-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18421-0">
    <skos:related rdf:resource="descriptor/18423-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18631-3">
    <skos:related rdf:resource="descriptor/11876-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18631-3">
    <skos:related rdf:resource="descriptor/19463-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18631-3">
    <skos:related rdf:resource="descriptor/11864-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11454-6">
    <skos:altLabel xml:lang="de">Vorsichtskasse</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11454-6">
    <skos:altLabel xml:lang="de">Transaktionskasse</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11454-6">
    <skos:altLabel xml:lang="de">Spekulationskasse</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11454-6">
    <skos:altLabel xml:lang="de">Kassenmittelansatz</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11454-6">
    <skos:altLabel xml:lang="de">Kassenhaltungstheorie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11454-6">
    <skos:altLabel xml:lang="de">Cambridge-Gleichung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10565-2">
    <skos:broader rdf:resource="thsys/71098"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10565-2">
    <skos:broader rdf:resource="thsys/71085"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10565-2">
    <skos:broader rdf:resource="descriptor/18481-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18298-1">
    <skos:related rdf:resource="descriptor/18590-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18298-1">
    <skos:related rdf:resource="descriptor/14455-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12786-4">
    <skos:altLabel xml:lang="en">Service management</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12786-4">
    <skos:altLabel xml:lang="de">Verkaufsgespräch</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12786-4">
    <skos:altLabel xml:lang="de">Nachkaufmarketing</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12786-4">
    <skos:altLabel xml:lang="de">Lieferservice</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12786-4">
    <skos:altLabel xml:lang="de">Kundenservice</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12786-4">
    <skos:altLabel xml:lang="de">Kundenbetreuung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12786-4">
    <skos:altLabel xml:lang="de">Kundenberatung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11409-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18570-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16698-2">
    <skos:broader rdf:resource="thsys/73357"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16698-2">
    <skos:broader rdf:resource="thsys/70814"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16698-2">
    <skos:broader rdf:resource="descriptor/16564-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13809-6">
    <skos:broader rdf:resource="thsys/70891"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13809-6">
    <skos:broader rdf:resource="descriptor/13816-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10077-1">
    <skos:related rdf:resource="descriptor/10156-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10077-1">
    <skos:related rdf:resource="descriptor/10148-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10077-1">
    <skos:related rdf:resource="descriptor/10221-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10077-1">
    <skos:related rdf:resource="descriptor/10085-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10077-1">
    <skos:related rdf:resource="descriptor/10179-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10077-1">
    <skos:related rdf:resource="descriptor/10210-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10077-1">
    <skos:related rdf:resource="descriptor/10073-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/24707-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="http://www.w3.org/2004/02/skos/core#broaderTransitive">
    <owl:inverseOf rdf:resource="http://www.w3.org/2004/02/skos/core#narrowerTransitive"/>
  </rdf:Description>
  <rdf:Description rdf:about="http://www.w3.org/2004/02/skos/core#note">
    <skos:definition xml:lang="en">A general note, for any purpose.</skos:definition>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14269-0">
    <skos:related rdf:resource="descriptor/14273-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14269-0">
    <skos:related rdf:resource="descriptor/13034-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14269-0">
    <skos:related rdf:resource="descriptor/14382-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14269-0">
    <skos:related rdf:resource="descriptor/14266-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13120-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73351">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70128">
    <skos:prefLabel xml:lang="de">G.05  Australien und südpazifischer Inselraum</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/21082-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15635-3">
    <skos:prefLabel xml:lang="en">Biotechnology</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15635-3">
    <skos:prefLabel xml:lang="de">Biotechnologie</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="http://www.w3.org/2004/02/skos/core#mappingRelation">
    <rdfs:label xml:lang="en">mapping relation</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15019-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14831-1">
    <skos:altLabel xml:lang="de">Täschnerwaren</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14831-1">
    <skos:altLabel xml:lang="de">Sattlerwaren</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14831-1">
    <skos:altLabel xml:lang="de">Ledertasche</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14831-1">
    <skos:altLabel xml:lang="de">Koffer</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14831-1">
    <skos:altLabel xml:lang="de">Handtasche</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18415-2">
    <skos:related rdf:resource="descriptor/18398-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18415-2">
    <skos:related rdf:resource="descriptor/14343-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18415-2">
    <skos:related rdf:resource="descriptor/12930-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70811">
    <skos:narrower rdf:resource="descriptor/18378-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70811">
    <skos:narrower rdf:resource="descriptor/18379-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70811">
    <skos:narrower rdf:resource="descriptor/18377-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70811">
    <skos:narrower rdf:resource="descriptor/12922-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70811">
    <skos:narrower rdf:resource="descriptor/15753-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70811">
    <skos:narrower rdf:resource="descriptor/19490-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70811">
    <skos:narrower rdf:resource="descriptor/11675-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70811">
    <skos:narrower rdf:resource="descriptor/15754-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70811">
    <skos:narrower rdf:resource="descriptor/18382-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70811">
    <skos:narrower rdf:resource="descriptor/15752-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70811">
    <skos:narrower rdf:resource="descriptor/18995-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70811">
    <skos:narrower rdf:resource="descriptor/10593-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70811">
    <skos:narrower rdf:resource="descriptor/14047-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70811">
    <skos:narrower rdf:resource="descriptor/18381-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70811">
    <skos:narrower rdf:resource="descriptor/15745-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70811">
    <skos:narrower rdf:resource="descriptor/15741-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70811">
    <skos:narrower rdf:resource="descriptor/19489-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70811">
    <skos:narrower rdf:resource="descriptor/18343-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70811">
    <skos:narrower rdf:resource="descriptor/18387-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70811">
    <skos:narrower rdf:resource="descriptor/15751-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70811">
    <skos:narrower rdf:resource="descriptor/18286-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70811">
    <skos:narrower rdf:resource="descriptor/18372-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70811">
    <skos:narrower rdf:resource="descriptor/10545-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70811">
    <skos:narrower rdf:resource="descriptor/18352-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70811">
    <skos:narrower rdf:resource="descriptor/19488-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15067-0">
    <skos:broader rdf:resource="thsys/71035"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15067-0">
    <skos:broader rdf:resource="descriptor/15060-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15067-0">
    <skos:broader rdf:resource="descriptor/15483-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/72181">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13479-1">
    <skos:related rdf:resource="descriptor/13492-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13479-1">
    <skos:related rdf:resource="descriptor/13475-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13479-1">
    <skos:related rdf:resource="descriptor/19141-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13479-1">
    <skos:related rdf:resource="descriptor/18527-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13479-1">
    <skos:related rdf:resource="descriptor/14335-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70562">
    <skos:notation rdf:datatype="http://www.w3.org/2001/XMLSchema#string">B.01.02</skos:notation>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18298-1">
    <skos:broader rdf:resource="thsys/70876"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18298-1">
    <skos:broader rdf:resource="descriptor/12283-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19360-3">
    <skos:related rdf:resource="descriptor/19839-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19360-3">
    <skos:related rdf:resource="descriptor/10815-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19360-3">
    <skos:related rdf:resource="descriptor/10813-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19360-3">
    <skos:related rdf:resource="descriptor/10786-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19360-3">
    <skos:related rdf:resource="descriptor/10613-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19360-3">
    <skos:related rdf:resource="descriptor/11268-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15768-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14028-1">
    <skos:broader rdf:resource="thsys/70201"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16268-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17911-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16619-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12357-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18737-1">
    <skos:narrower rdf:resource="descriptor/18475-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19854-6">
    <skos:altLabel xml:lang="de">Visumpflicht</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19854-6">
    <skos:altLabel xml:lang="de">Sichtvermerk</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19854-6">
    <skos:altLabel xml:lang="de">Reiseverkehrsvorschriften</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19854-6">
    <skos:altLabel xml:lang="de">Reisepass</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19854-6">
    <skos:altLabel xml:lang="de">Reisepaß</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19854-6">
    <skos:altLabel xml:lang="de">Reiseformalitäten</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19854-6">
    <skos:altLabel xml:lang="de">Passrecht</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19854-6">
    <skos:altLabel xml:lang="de">Pass</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19854-6">
    <skos:altLabel xml:lang="de">Paßrecht</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19854-6">
    <skos:altLabel xml:lang="de">Paß</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19854-6">
    <skos:altLabel xml:lang="de">Einreisebestimmungen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19854-6">
    <skos:altLabel xml:lang="de">Einreisebedingungen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19854-6">
    <skos:altLabel xml:lang="de">Ausreisebestimmungen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19854-6">
    <skos:altLabel xml:lang="de">Ausreisebedingungen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19420-4">
    <skos:altLabel xml:lang="en">Lump-sum tax</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19420-4">
    <skos:altLabel xml:lang="de">Pauschsteuer</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19420-4">
    <skos:altLabel xml:lang="de">Pauschalsteuer</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19420-4">
    <skos:altLabel xml:lang="de">Einheitssteuer (Kopfsteuer)</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19797-6">
    <skos:related rdf:resource="descriptor/19798-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19797-6">
    <skos:related rdf:resource="descriptor/10455-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12458-0">
    <skos:related rdf:resource="descriptor/12337-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12458-0">
    <skos:related rdf:resource="descriptor/12325-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12458-0">
    <skos:related rdf:resource="descriptor/12217-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12458-0">
    <skos:related rdf:resource="descriptor/12216-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12458-0">
    <skos:related rdf:resource="descriptor/12357-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15979-6">
    <skos:related rdf:resource="descriptor/11217-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15979-6">
    <skos:related rdf:resource="descriptor/19763-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15979-6">
    <skos:related rdf:resource="descriptor/16198-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15979-6">
    <skos:related rdf:resource="descriptor/16504-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15979-6">
    <skos:related rdf:resource="descriptor/19511-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15979-6">
    <skos:related rdf:resource="descriptor/19813-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15979-6">
    <skos:related rdf:resource="descriptor/13995-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15979-6">
    <skos:related rdf:resource="descriptor/19704-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15979-6">
    <skos:related rdf:resource="descriptor/16195-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15979-6">
    <skos:related rdf:resource="descriptor/15962-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16476-6">
    <skos:narrower rdf:resource="descriptor/18992-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16709-2">
    <skos:broader rdf:resource="thsys/73394"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16709-2">
    <skos:broader rdf:resource="thsys/70120"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16709-2">
    <skos:broader rdf:resource="descriptor/15671-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16709-2">
    <skos:broader rdf:resource="descriptor/16719-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20018-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12867-4">
    <skos:altLabel xml:lang="de">Mitunternehmerschaft</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12867-4">
    <skos:altLabel xml:lang="de">Mitunternehmerinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70934">
    <skos:prefLabel xml:lang="en">W.12.01.03.02  Cargo shipping</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70934">
    <skos:prefLabel xml:lang="de">W.12.01.03.02  Frachtschifffahrt</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10524-2">
    <skos:broader rdf:resource="thsys/73368"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10524-2">
    <skos:broader rdf:resource="thsys/71085"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10524-2">
    <skos:broader rdf:resource="descriptor/19163-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10524-2">
    <skos:broader rdf:resource="descriptor/10560-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15905-0">
    <skos:related rdf:resource="descriptor/19760-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19682-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70141">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14107-5">
    <skos:prefLabel xml:lang="en">Pome</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14107-5">
    <skos:prefLabel xml:lang="de">Kernobst</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10829-1">
    <zbwext:useInsteadNote rdf:nodeID="id157"/>
  </rdf:Description>
  <rdf:Description rdf:about="http://www.w3.org/2004/02/skos/core#broader">
    <owl:inverseOf rdf:resource="http://www.w3.org/2004/02/skos/core#narrower"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71119">
    <skos:broader rdf:resource="thsys/70180"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11667-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18200-2">
    <skos:related rdf:resource="descriptor/18189-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18200-2">
    <skos:related rdf:resource="descriptor/19365-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11063-0">
    <skos:scopeNote xml:lang="de">Vergleichende Studien verschiedener Wirtschafts- und/oder politischer Systeme.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11160-2">
    <skos:prefLabel xml:lang="en">New institutional economics</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11160-2">
    <skos:prefLabel xml:lang="de">Neue Institutionenökonomik</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16349-6">
    <skos:prefLabel xml:lang="en">European election</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16349-6">
    <skos:prefLabel xml:lang="de">Europawahl</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18550-3">
    <skos:narrower rdf:resource="descriptor/18515-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10145-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14712-2">
    <skos:prefLabel xml:lang="en">Polystyrene</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14712-2">
    <skos:prefLabel xml:lang="de">Polystyrol</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13083-5">
    <skos:broader rdf:resource="thsys/70995"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13083-5">
    <skos:broader rdf:resource="descriptor/12993-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13440-0">
    <skos:altLabel xml:lang="de">Landwirtschaftliches Familienunternehmen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13440-0">
    <skos:altLabel xml:lang="de">Landwirtschaftlicher Familienhaushalt</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13440-0">
    <skos:altLabel xml:lang="de">Bauernhof</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13440-0">
    <skos:altLabel xml:lang="de">Bäuerlicher Familienbetrieb</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13440-0">
    <skos:altLabel xml:lang="de">Agrarwirtschaftliches Familienunternehmen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13440-0">
    <skos:altLabel xml:lang="de">Agrarwirtschaftlicher Familienhaushalt</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19806-3">
    <skos:related rdf:resource="descriptor/19809-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19806-3">
    <skos:related rdf:resource="descriptor/12733-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19806-3">
    <skos:related rdf:resource="descriptor/18170-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19050-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18335-0">
    <skos:prefLabel xml:lang="en">Food habit</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18335-0">
    <skos:prefLabel xml:lang="de">Ernährungsgewohnheit</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19811-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/24622-4">
    <skos:broader rdf:resource="thsys/70180"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/24622-4">
    <skos:broader rdf:resource="descriptor/15982-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19846-5">
    <skos:altLabel xml:lang="de">Konsumentenboykott</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19846-5">
    <skos:altLabel xml:lang="de">Käuferstreik</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10835-6">
    <skos:altLabel xml:lang="de">Außenwirtschaftsstatistik</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12069-4">
    <skos:related rdf:resource="descriptor/18115-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12069-4">
    <skos:related rdf:resource="descriptor/12072-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12069-4">
    <skos:related rdf:resource="descriptor/12057-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12069-4">
    <skos:related rdf:resource="descriptor/12046-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12069-4">
    <skos:related rdf:resource="descriptor/12039-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12069-4">
    <skos:related rdf:resource="descriptor/12053-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12847-3">
    <skos:altLabel xml:lang="de">Zeitungsbeilage</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12847-3">
    <skos:altLabel xml:lang="de">Zeitungsanzeige</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12847-3">
    <skos:altLabel xml:lang="de">Zeitschriftenwerbung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12847-3">
    <skos:altLabel xml:lang="de">Werbeanzeige</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12847-3">
    <skos:altLabel xml:lang="de">Inserat</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12847-3">
    <skos:altLabel xml:lang="de">Anzeigenwerbung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12847-3">
    <skos:altLabel xml:lang="de">Annonce</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12847-3">
    <skos:altLabel xml:lang="de">Adressbuchwerbung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12847-3">
    <skos:altLabel xml:lang="de">Adreßbuchwerbung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12287-1">
    <skos:altLabel xml:lang="de">Kapitalsammelstelle</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12287-1">
    <skos:altLabel xml:lang="de">Institutioneller Investor</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14368-5">
    <skos:prefLabel xml:lang="en">Mining machinery</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14368-5">
    <skos:prefLabel xml:lang="de">Bergwerksmaschine</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10710-5">
    <skos:broader rdf:resource="thsys/71096"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10710-5">
    <skos:broader rdf:resource="thsys/71081"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10710-5">
    <skos:broader rdf:resource="thsys/71074"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10710-5">
    <skos:broader rdf:resource="descriptor/11545-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10710-5">
    <skos:broader rdf:resource="descriptor/10683-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10847-6">
    <skos:prefLabel xml:lang="en">Export processing</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10847-6">
    <skos:prefLabel xml:lang="de">Veredelungsverkehr</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18077-3">
    <skos:related rdf:resource="descriptor/14958-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14056-3">
    <skos:prefLabel xml:lang="en">Groundnut</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14056-3">
    <skos:prefLabel xml:lang="de">Erdnuss</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13185-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19696-5">
    <skos:broader rdf:resource="thsys/73378"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19696-5">
    <skos:broader rdf:resource="descriptor/10968-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14078-0">
    <skos:broader rdf:resource="thsys/70341"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14078-0">
    <skos:broader rdf:resource="descriptor/14070-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18486-0">
    <skos:prefLabel xml:lang="en">Manufacturing employment</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18486-0">
    <skos:prefLabel xml:lang="de">Industrielle Beschäftigung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16435-6">
    <skos:broader rdf:resource="thsys/73366"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16435-6">
    <skos:broader rdf:resource="descriptor/16273-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18340-0">
    <skos:prefLabel xml:lang="en">Tropical forest</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18340-0">
    <skos:prefLabel xml:lang="de">Tropischer Regenwald</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16370-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19652-4">
    <skos:broader rdf:resource="thsys/70893"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19652-4">
    <skos:broader rdf:resource="descriptor/18682-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19353-0">
    <skos:prefLabel xml:lang="en">Euro</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19353-0">
    <skos:prefLabel xml:lang="de">Euro</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18932-3">
    <skos:broader rdf:resource="thsys/70825"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18932-3">
    <skos:broader rdf:resource="thsys/70013"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18932-3">
    <skos:broader rdf:resource="descriptor/10300-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12254-2">
    <skos:narrower rdf:resource="descriptor/19057-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12254-2">
    <skos:narrower rdf:resource="descriptor/18369-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12254-2">
    <skos:narrower rdf:resource="descriptor/12030-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12254-2">
    <skos:narrower rdf:resource="descriptor/12243-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12254-2">
    <skos:narrower rdf:resource="descriptor/19066-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12254-2">
    <skos:narrower rdf:resource="descriptor/18758-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11792-0">
    <skos:prefLabel xml:lang="en">Sectoral crisis</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11792-0">
    <skos:prefLabel xml:lang="de">Branchenkrise</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19829-5">
    <skos:related rdf:resource="descriptor/11572-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19829-5">
    <skos:related rdf:resource="descriptor/16552-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19829-5">
    <skos:related rdf:resource="descriptor/10973-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19829-5">
    <skos:related rdf:resource="descriptor/19446-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19829-5">
    <skos:related rdf:resource="descriptor/11820-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19829-5">
    <skos:related rdf:resource="descriptor/11817-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11800-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10342-1">
    <skos:related rdf:resource="descriptor/10031-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10342-1">
    <skos:related rdf:resource="descriptor/10343-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10342-1">
    <skos:related rdf:resource="descriptor/15075-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10342-1">
    <skos:related rdf:resource="descriptor/10025-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10342-1">
    <skos:related rdf:resource="descriptor/15715-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10342-1">
    <skos:related rdf:resource="descriptor/10513-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10342-1">
    <skos:related rdf:resource="descriptor/11270-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15018-6">
    <skos:broader rdf:resource="thsys/70238"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15018-6">
    <skos:broader rdf:resource="thsys/70161"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15018-6">
    <skos:broader rdf:resource="descriptor/15009-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13113-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10229-4">
    <skos:related rdf:resource="descriptor/10327-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10229-4">
    <skos:related rdf:resource="descriptor/11464-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10229-4">
    <skos:related rdf:resource="descriptor/10241-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10229-4">
    <skos:related rdf:resource="descriptor/10237-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10917-4">
    <skos:prefLabel xml:lang="en">Non-discrimination principle (Competition law)</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10917-4">
    <skos:prefLabel xml:lang="de">Diskriminierungsverbot (Wettbewerbsrecht)</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11981-4">
    <skos:related rdf:resource="descriptor/18031-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11981-4">
    <skos:related rdf:resource="descriptor/11973-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11981-4">
    <skos:related rdf:resource="descriptor/19446-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11981-4">
    <skos:related rdf:resource="descriptor/18489-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11981-4">
    <skos:related rdf:resource="descriptor/18748-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11981-4">
    <skos:related rdf:resource="descriptor/11817-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11981-4">
    <skos:related rdf:resource="descriptor/11940-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11981-4">
    <skos:related rdf:resource="descriptor/11905-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11981-4">
    <skos:related rdf:resource="descriptor/11904-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18252-4">
    <skos:narrower rdf:resource="descriptor/14469-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19363-4">
    <skos:related rdf:resource="descriptor/10512-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19363-4">
    <skos:related rdf:resource="descriptor/11972-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19363-4">
    <skos:related rdf:resource="descriptor/11983-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19363-4">
    <skos:related rdf:resource="descriptor/11988-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19363-4">
    <skos:related rdf:resource="descriptor/10510-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19363-4">
    <skos:related rdf:resource="descriptor/11943-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18500-4">
    <skos:broader rdf:resource="thsys/70969"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18500-4">
    <skos:broader rdf:resource="descriptor/13177-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13592-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17618-0">
    <skos:prefLabel xml:lang="en">Bahrain</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17618-0">
    <skos:prefLabel xml:lang="de">Bahrain</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id54">
    <rdfs:seeAlso rdf:resource="descriptor/15107-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10699-2">
    <skos:related rdf:resource="descriptor/10706-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10699-2">
    <skos:related rdf:resource="descriptor/10838-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12049-3">
    <skos:broader rdf:resource="thsys/71034"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12049-3">
    <skos:broader rdf:resource="descriptor/12072-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15555-1">
    <skos:narrower rdf:resource="descriptor/15437-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13065-0">
    <skos:prefLabel xml:lang="en">Road vehicle construction</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13065-0">
    <skos:prefLabel xml:lang="de">Straßenfahrzeugbau</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18519-4">
    <skos:related rdf:resource="descriptor/19295-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18519-4">
    <skos:related rdf:resource="descriptor/19294-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18519-4">
    <skos:related rdf:resource="descriptor/18518-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18519-4">
    <skos:related rdf:resource="descriptor/18192-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18519-4">
    <skos:related rdf:resource="descriptor/18191-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18519-4">
    <skos:related rdf:resource="descriptor/14064-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16563-4">
    <skos:related rdf:resource="descriptor/18859-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16563-4">
    <skos:related rdf:resource="descriptor/15429-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16563-4">
    <skos:related rdf:resource="descriptor/14015-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16563-4">
    <skos:related rdf:resource="descriptor/16723-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16563-4">
    <skos:related rdf:resource="descriptor/15790-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16563-4">
    <skos:related rdf:resource="descriptor/19635-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16563-4">
    <skos:related rdf:resource="descriptor/15644-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17570-2">
    <skos:altLabel xml:lang="en">Republic of Korea</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17570-2">
    <skos:altLabel xml:lang="de">Republik Korea</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17570-2">
    <skos:altLabel xml:lang="de">Korea (Republik)</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11231-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70847">
    <skos:prefLabel xml:lang="en">W.24  Education system</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70847">
    <skos:prefLabel xml:lang="de">W.24  Bildungswesen</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18119-6">
    <skos:prefLabel xml:lang="en">Affiliate corporation</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18119-6">
    <skos:prefLabel xml:lang="de">Tochtergesellschaft</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16729-3">
    <skos:scopeNote xml:lang="de">Problematisierung des Verhältnisses von Theorie und Praxis in der Wissenschaft. Realitätsnähe theoretischer Annahmen.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13117-0">
    <skos:broader rdf:resource="thsys/70990"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13117-0">
    <skos:broader rdf:resource="descriptor/12993-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10320-4">
    <skos:altLabel xml:lang="en">By-product</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10320-4">
    <skos:altLabel xml:lang="de">Verbundene Produktion</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10320-4">
    <skos:altLabel xml:lang="de">Nebenprodukt</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10320-4">
    <skos:altLabel xml:lang="de">Kumulative Produktion</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18728-2">
    <skos:related rdf:resource="descriptor/13742-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18728-2">
    <skos:related rdf:resource="descriptor/18676-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18728-2">
    <skos:related rdf:resource="descriptor/18730-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18728-2">
    <skos:related rdf:resource="descriptor/13687-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15669-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19301-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12030-3">
    <skos:broader rdf:resource="thsys/71066"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12030-3">
    <skos:broader rdf:resource="thsys/70889"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12030-3">
    <skos:broader rdf:resource="thsys/70883"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12030-3">
    <skos:broader rdf:resource="descriptor/12254-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12030-3">
    <skos:broader rdf:resource="descriptor/18747-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18134-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71114">
    <skos:narrower rdf:resource="descriptor/21082-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71114">
    <skos:narrower rdf:resource="descriptor/11765-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71114">
    <skos:narrower rdf:resource="descriptor/11752-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71114">
    <skos:narrower rdf:resource="descriptor/11751-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71114">
    <skos:narrower rdf:resource="descriptor/19234-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71114">
    <skos:narrower rdf:resource="descriptor/11872-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71114">
    <skos:narrower rdf:resource="descriptor/10099-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71114">
    <skos:narrower rdf:resource="descriptor/11742-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71114">
    <skos:narrower rdf:resource="descriptor/19233-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71114">
    <skos:narrower rdf:resource="descriptor/11739-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71114">
    <skos:narrower rdf:resource="descriptor/11738-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71114">
    <skos:narrower rdf:resource="descriptor/11736-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71114">
    <skos:narrower rdf:resource="descriptor/11735-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71114">
    <skos:narrower rdf:resource="descriptor/11753-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71114">
    <skos:narrower rdf:resource="descriptor/11713-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16012-6">
    <skos:prefLabel xml:lang="en">Radio law</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16012-6">
    <skos:prefLabel xml:lang="de">Rundfunkrecht</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13699-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13067-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18753-3">
    <skos:prefLabel xml:lang="en">Urban housing construction</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18753-3">
    <skos:prefLabel xml:lang="de">Städtischer Wohnungsbau</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15609-4">
    <skos:prefLabel xml:lang="en">Computer science</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15609-4">
    <skos:prefLabel xml:lang="de">Informatik</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18216-1">
    <skos:prefLabel xml:lang="en">Food substitute</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18216-1">
    <skos:prefLabel xml:lang="de">Nahrungsmittelimitat</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12589-6">
    <skos:narrower rdf:resource="descriptor/11366-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15026-0">
    <skos:related rdf:resource="descriptor/15372-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15026-0">
    <skos:related rdf:resource="descriptor/10035-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20314-0">
    <skos:scopeNote xml:lang="de">Für Texte, die über Produkte informieren, BENUTZE Publikationsart Marktinformation.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14602-2">
    <skos:altLabel xml:lang="de">Verdünnungsmittel</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14602-2">
    <skos:altLabel xml:lang="de">Trockenmittel</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14602-2">
    <skos:altLabel xml:lang="de">Lösemittel</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14602-2">
    <skos:altLabel xml:lang="de">Laborchemikalie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14602-2">
    <skos:altLabel xml:lang="de">Kautschukhilfsmittel</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14602-2">
    <skos:altLabel xml:lang="de">Kältehilfsmittel</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14602-2">
    <skos:altLabel xml:lang="de">Holzschutzmittel</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14602-2">
    <skos:altLabel xml:lang="de">Frostschutzmittel</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14602-2">
    <skos:altLabel xml:lang="de">Flammschutzmittel</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14602-2">
    <skos:altLabel xml:lang="de">Feuerlöschmittel</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14602-2">
    <skos:altLabel xml:lang="de">Feinchemikalie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14602-2">
    <skos:altLabel xml:lang="de">Elektronikchemikalie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14602-2">
    <skos:altLabel xml:lang="de">Chemisches Hilfsmittel</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14602-2">
    <skos:altLabel xml:lang="de">Betonschutzmittel</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14602-2">
    <skos:altLabel xml:lang="de">Bautenschutzmittel</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14602-2">
    <skos:altLabel xml:lang="de">Antioxidantien</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14602-2">
    <skos:altLabel xml:lang="de">Additiv</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10030-6">
    <skos:related rdf:resource="descriptor/21061-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10030-6">
    <skos:related rdf:resource="descriptor/10016-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10030-6">
    <skos:related rdf:resource="descriptor/13301-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13202-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18428-0">
    <skos:broader rdf:resource="thsys/70996"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18428-0">
    <skos:broader rdf:resource="descriptor/24708-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18428-0">
    <skos:broader rdf:resource="descriptor/13076-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19035-0">
    <skos:broader rdf:resource="thsys/70582"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19603-3">
    <skos:prefLabel xml:lang="en">Higher education statistics</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19603-3">
    <skos:prefLabel xml:lang="de">Hochschulstatistik</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19131-4">
    <skos:related rdf:resource="descriptor/19132-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13161-4">
    <skos:broader rdf:resource="thsys/70986"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13161-4">
    <skos:broader rdf:resource="descriptor/13160-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70897">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70993">
    <skos:broader rdf:resource="thsys/70994"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13537-6">
    <skos:narrower rdf:resource="descriptor/18596-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15755-0">
    <skos:broader rdf:resource="thsys/73351"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15755-0">
    <skos:broader rdf:resource="thsys/70238"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15755-0">
    <skos:broader rdf:resource="descriptor/15763-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16480-1">
    <skos:broader rdf:resource="thsys/73370"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16480-1">
    <skos:broader rdf:resource="thsys/70833"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16480-1">
    <skos:broader rdf:resource="thsys/70324"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16480-1">
    <skos:broader rdf:resource="descriptor/16545-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15711-6">
    <skos:narrower rdf:resource="descriptor/16389-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15711-6">
    <skos:narrower rdf:resource="descriptor/16629-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15711-6">
    <skos:narrower rdf:resource="descriptor/16391-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15711-6">
    <skos:narrower rdf:resource="descriptor/16628-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15711-6">
    <skos:narrower rdf:resource="descriptor/16382-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15711-6">
    <skos:narrower rdf:resource="descriptor/16387-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14261-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70416">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19583-4">
    <skos:altLabel xml:lang="de">Eulersche Gleichung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19583-4">
    <skos:altLabel xml:lang="de">Eulersche Formel</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19583-4">
    <skos:altLabel xml:lang="de">Eulergleichungsmodell</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71003">
    <skos:broader rdf:resource="thsys/71004"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18832-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10773-2">
    <skos:prefLabel xml:lang="en">Exchange rate</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10773-2">
    <skos:prefLabel xml:lang="de">Wechselkurs</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15009-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13793-2">
    <skos:broader rdf:resource="thsys/70114"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13793-2">
    <skos:broader rdf:resource="descriptor/13807-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16384-4">
    <skos:altLabel xml:lang="de">Verbandsdemokratie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16384-4">
    <skos:altLabel xml:lang="de">Ständestaat</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16384-4">
    <skos:altLabel xml:lang="de">Ständegesellschaft</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16384-4">
    <skos:altLabel xml:lang="de">Neokorporatismus</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16384-4">
    <skos:altLabel xml:lang="de">Korporativismus</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13032-1">
    <skos:prefLabel xml:lang="en">Iron and steel industry</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13032-1">
    <skos:prefLabel xml:lang="de">Hüttenindustrie</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18980-6">
    <skos:broader rdf:resource="thsys/71028"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18980-6">
    <skos:broader rdf:resource="descriptor/19231-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12643-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12697-3">
    <zbwext:useInsteadNote rdf:nodeID="id366"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12697-3">
    <zbwext:useInsteadNote rdf:nodeID="id365"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70936">
    <skos:narrower rdf:resource="descriptor/13298-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70936">
    <skos:narrower rdf:resource="descriptor/18594-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70936">
    <skos:narrower rdf:resource="descriptor/18593-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70936">
    <skos:narrower rdf:resource="descriptor/18592-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70936">
    <skos:narrower rdf:resource="descriptor/13546-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70936">
    <skos:narrower rdf:resource="descriptor/13576-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70936">
    <skos:narrower rdf:resource="descriptor/18591-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70936">
    <skos:narrower rdf:resource="descriptor/13545-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70936">
    <skos:narrower rdf:resource="descriptor/18590-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70936">
    <skos:narrower rdf:resource="descriptor/13983-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70936">
    <skos:narrower rdf:resource="descriptor/13256-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70936">
    <skos:narrower rdf:resource="descriptor/13252-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70936">
    <skos:narrower rdf:resource="descriptor/18589-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70936">
    <skos:narrower rdf:resource="descriptor/14317-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70936">
    <skos:narrower rdf:resource="descriptor/18588-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70936">
    <skos:narrower rdf:resource="descriptor/18587-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70936">
    <skos:narrower rdf:resource="descriptor/13530-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70936">
    <skos:narrower rdf:resource="thsys/70933"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70936">
    <skos:narrower rdf:resource="thsys/70935"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70936">
    <skos:narrower rdf:resource="thsys/70934"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12354-5">
    <skos:altLabel xml:lang="de">Anlagevermögen des Betriebs</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10693-0">
    <skos:related rdf:resource="descriptor/10866-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10693-0">
    <skos:related rdf:resource="descriptor/10836-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10693-0">
    <skos:related rdf:resource="descriptor/12236-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10693-0">
    <skos:related rdf:resource="descriptor/10858-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10693-0">
    <skos:related rdf:resource="descriptor/10854-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12357-6">
    <skos:prefLabel xml:lang="en">Balance sheet</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12357-6">
    <skos:prefLabel xml:lang="de">Bilanz</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14293-3">
    <skos:prefLabel xml:lang="en">Aluminium</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14293-3">
    <skos:prefLabel xml:lang="de">Aluminium</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13029-4">
    <skos:altLabel xml:lang="de">Warmwalzwerk</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13029-4">
    <skos:altLabel xml:lang="de">Walzwerk</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13029-4">
    <skos:altLabel xml:lang="de">Stahlerzeugung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13029-4">
    <skos:altLabel xml:lang="de">Rohstahlerzeugung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13029-4">
    <skos:altLabel xml:lang="de">Roheisenerzeugung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13029-4">
    <skos:altLabel xml:lang="de">Eisenschaffende Industrie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13029-4">
    <skos:altLabel xml:lang="de">Eisenindustrie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13029-4">
    <skos:altLabel xml:lang="de">Eisen- und Stahlindustrie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18009-6">
    <skos:altLabel xml:lang="en">Alcohol fuel</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18009-6">
    <skos:altLabel xml:lang="de">Methanolkraftstoff</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18009-6">
    <skos:altLabel xml:lang="de">Ethanolkraftstoff</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18009-6">
    <skos:altLabel xml:lang="de">Biosprit</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18009-6">
    <skos:altLabel xml:lang="de">Biodiesel</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18009-6">
    <skos:altLabel xml:lang="de">Äthanolkraftstoff</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18009-6">
    <skos:altLabel xml:lang="de">Alkoholischer Kraftstoff</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73386">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11754-1">
    <skos:narrower rdf:resource="descriptor/10180-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11754-1">
    <skos:narrower rdf:resource="descriptor/12022-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71031">
    <rdfs:label xml:lang="en">Central Africa</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71031">
    <rdfs:label xml:lang="de">Zentralafrika</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14381-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18075-0">
    <skos:broader rdf:resource="thsys/73305"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18075-0">
    <skos:broader rdf:resource="descriptor/14514-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14381-6">
    <skos:prefLabel xml:lang="en">Machinery</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14381-6">
    <skos:prefLabel xml:lang="de">Maschine</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73299">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11529-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12980-1">
    <skos:broader rdf:resource="thsys/71009"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12980-1">
    <skos:broader rdf:resource="descriptor/12922-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12980-1">
    <skos:broader rdf:resource="descriptor/12913-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10897-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18767-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18619-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19270-4">
    <skos:prefLabel xml:lang="en">Financial market regulation</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19270-4">
    <skos:prefLabel xml:lang="de">Börsenregulierung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10489-6">
    <skos:broader rdf:resource="thsys/70182"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10489-6">
    <skos:broader rdf:resource="descriptor/15708-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11401-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14626-2">
    <skos:narrower rdf:resource="descriptor/18266-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19396-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19154-6">
    <skos:related rdf:resource="descriptor/12903-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19154-6">
    <skos:related rdf:resource="descriptor/12090-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19154-6">
    <skos:related rdf:resource="descriptor/20261-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19154-6">
    <skos:related rdf:resource="descriptor/19102-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19154-6">
    <skos:related rdf:resource="descriptor/12185-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19154-6">
    <skos:related rdf:resource="descriptor/12120-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19154-6">
    <skos:related rdf:resource="descriptor/19522-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19154-6">
    <skos:related rdf:resource="descriptor/10192-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19154-6">
    <skos:related rdf:resource="descriptor/19156-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19154-6">
    <skos:related rdf:resource="descriptor/12175-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19154-6">
    <skos:related rdf:resource="descriptor/13714-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19154-6">
    <skos:related rdf:resource="descriptor/11153-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10475-3">
    <skos:broader rdf:resource="thsys/71109"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10475-3">
    <skos:broader rdf:resource="descriptor/10466-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17977-0">
    <skos:broader rdf:resource="thsys/70307"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17977-0">
    <skos:broader rdf:resource="descriptor/10492-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11417-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10064-3">
    <skos:prefLabel xml:lang="en">Global model</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10064-3">
    <skos:prefLabel xml:lang="de">Weltmodell</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10542-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18961-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13236-6">
    <skos:broader rdf:resource="thsys/70957"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13236-6">
    <skos:broader rdf:resource="descriptor/13224-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70046">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18329-2">
    <skos:narrower rdf:resource="descriptor/19455-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15668-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11649-5">
    <skos:altLabel xml:lang="de">Umsatzausgleichsteuer</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11917-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20077-2">
    <skos:prefLabel xml:lang="en">Social contract</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20077-2">
    <skos:prefLabel xml:lang="de">Sozialvertrag</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11446-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73301">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70372">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17580-6">
    <skos:altLabel xml:lang="de">Königreich Kambodscha</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17580-6">
    <skos:altLabel xml:lang="de">Khmer-Republik</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17580-6">
    <skos:altLabel xml:lang="de">Kamputschea</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18850-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12985-5">
    <skos:broader rdf:resource="thsys/71007"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12985-5">
    <skos:broader rdf:resource="descriptor/12980-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16081-1">
    <skos:narrower rdf:resource="descriptor/11848-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16081-1">
    <skos:narrower rdf:resource="descriptor/16023-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16081-1">
    <skos:narrower rdf:resource="descriptor/11417-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16081-1">
    <skos:narrower rdf:resource="descriptor/13731-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16081-1">
    <skos:narrower rdf:resource="descriptor/16102-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16081-1">
    <skos:narrower rdf:resource="descriptor/10621-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16081-1">
    <skos:narrower rdf:resource="descriptor/16052-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16081-1">
    <skos:narrower rdf:resource="descriptor/18311-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16081-1">
    <skos:narrower rdf:resource="descriptor/18312-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16081-1">
    <skos:narrower rdf:resource="descriptor/15993-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16081-1">
    <skos:narrower rdf:resource="descriptor/19818-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16081-1">
    <skos:narrower rdf:resource="descriptor/18352-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16081-1">
    <skos:narrower rdf:resource="descriptor/13693-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16081-1">
    <skos:narrower rdf:resource="descriptor/10606-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16081-1">
    <skos:narrower rdf:resource="descriptor/13426-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10160-0">
    <skos:related rdf:resource="descriptor/10112-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18698-6">
    <skos:scopeNote xml:lang="de">Politische Maßnahmen des Staates und der Zentralbank zur Beeinflussung der Kreditkonditionen und der Kreditvergabe.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18607-0">
    <skos:broader rdf:resource="thsys/70932"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18607-0">
    <skos:broader rdf:resource="descriptor/13570-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13644-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11640-2">
    <skos:narrower rdf:resource="descriptor/12558-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11640-2">
    <skos:narrower rdf:resource="descriptor/12849-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11640-2">
    <skos:narrower rdf:resource="descriptor/16111-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11640-2">
    <skos:narrower rdf:resource="descriptor/12874-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11640-2">
    <skos:narrower rdf:resource="descriptor/16104-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11640-2">
    <skos:narrower rdf:resource="descriptor/10829-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11640-2">
    <skos:narrower rdf:resource="descriptor/18831-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11640-2">
    <skos:narrower rdf:resource="descriptor/16092-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11640-2">
    <skos:narrower rdf:resource="descriptor/18302-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11640-2">
    <skos:narrower rdf:resource="descriptor/10827-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12433-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16024-6">
    <skos:prefLabel xml:lang="en">Military law</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16024-6">
    <skos:prefLabel xml:lang="de">Wehrrecht</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10176-6">
    <skos:related rdf:resource="descriptor/18301-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10176-6">
    <skos:related rdf:resource="descriptor/18144-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10176-6">
    <skos:related rdf:resource="descriptor/19205-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10176-6">
    <skos:related rdf:resource="descriptor/10173-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10176-6">
    <skos:related rdf:resource="descriptor/11272-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10176-6">
    <skos:related rdf:resource="descriptor/19521-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11904-1">
    <skos:broader rdf:resource="thsys/71040"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11904-1">
    <skos:broader rdf:resource="thsys/71034"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11904-1">
    <skos:broader rdf:resource="descriptor/11915-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15668-2">
    <skos:broader rdf:resource="thsys/70819"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15668-2">
    <skos:broader rdf:resource="thsys/70581"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15668-2">
    <skos:broader rdf:resource="descriptor/15675-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12119-1">
    <skos:broader rdf:resource="thsys/73385"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12119-1">
    <skos:broader rdf:resource="thsys/73358"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12119-1">
    <skos:broader rdf:resource="thsys/71050"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12119-1">
    <skos:broader rdf:resource="descriptor/12621-1"/>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id208">
    <rdf:value xml:lang="de">Für rechtliche Regelungen bezüglich Rundfunk und Fernsehen</rdf:value>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70878">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18181-1">
    <skos:broader rdf:resource="thsys/71093"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18181-1">
    <skos:broader rdf:resource="descriptor/10626-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18181-1">
    <skos:broader rdf:resource="descriptor/16421-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17709-4">
    <skos:altLabel xml:lang="de">Republik Liberia</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17709-4">
    <skos:altLabel xml:lang="de">Liberien</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11305-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18216-1">
    <skos:broader rdf:resource="thsys/70074"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18216-1">
    <skos:broader rdf:resource="descriptor/14611-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18216-1">
    <skos:broader rdf:resource="descriptor/14926-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11676-2">
    <skos:prefLabel xml:lang="en">Capital levy</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11676-2">
    <skos:prefLabel xml:lang="de">Substanzsteuer</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14337-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11154-4">
    <skos:prefLabel xml:lang="en">Bureaucracy</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11154-4">
    <skos:prefLabel xml:lang="de">Bürokratie</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19607-2">
    <skos:related rdf:resource="descriptor/11068-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19607-2">
    <skos:related rdf:resource="descriptor/11063-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19607-2">
    <skos:related rdf:resource="descriptor/15976-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19607-2">
    <skos:related rdf:resource="descriptor/15972-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19607-2">
    <skos:related rdf:resource="descriptor/15970-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19607-2">
    <skos:related rdf:resource="descriptor/15966-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19607-2">
    <skos:related rdf:resource="descriptor/16292-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19607-2">
    <skos:related rdf:resource="descriptor/19822-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19607-2">
    <skos:related rdf:resource="descriptor/16258-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19607-2">
    <skos:related rdf:resource="descriptor/19841-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19607-2">
    <skos:related rdf:resource="descriptor/16602-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16042-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70057">
    <skos:broader rdf:resource="thsys/70049"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19603-3">
    <skos:altLabel xml:lang="de">Universitätsstatistik</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70904">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11613-5">
    <skos:altLabel xml:lang="en">Fiscal debt</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11613-5">
    <skos:altLabel xml:lang="de">Staatsverschuldung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11613-5">
    <skos:altLabel xml:lang="de">Staatsschulden</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11613-5">
    <skos:altLabel xml:lang="de">Schuldenpolitik des Staates</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11613-5">
    <skos:altLabel xml:lang="de">Öffentliches Darlehen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11613-5">
    <skos:altLabel xml:lang="de">Öffentlicher Kredit</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11613-5">
    <skos:altLabel xml:lang="de">Öffentliche Verschuldung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11613-5">
    <skos:altLabel xml:lang="de">Öffentliche Schuldenpolitik</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70554">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12884-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19350-6">
    <skos:narrower rdf:resource="descriptor/16066-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13281-1">
    <skos:broader rdf:resource="thsys/70905"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16104-1">
    <skos:altLabel xml:lang="de">KStG</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16104-1">
    <skos:altLabel xml:lang="de">Körperschaftsteuergesetz</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16104-1">
    <skos:altLabel xml:lang="de">Körperschaftssteuerrecht</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11210-6">
    <skos:related rdf:resource="descriptor/11790-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70985">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19287-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10374-2">
    <skos:related rdf:resource="descriptor/19587-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10374-2">
    <skos:related rdf:resource="descriptor/10373-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18979-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10499-3">
    <skos:related rdf:resource="descriptor/16603-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10499-3">
    <skos:related rdf:resource="descriptor/10568-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19511-1">
    <skos:scopeNote xml:lang="de">Staatliche und private Fürsorgemaßnahmen für Straftäter/innen und ihre Angehörigen während und nach der Strafverbüßung.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19784-1">
    <skos:narrower rdf:resource="descriptor/13591-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19784-1">
    <skos:narrower rdf:resource="descriptor/18678-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19784-1">
    <skos:narrower rdf:resource="descriptor/11194-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19784-1">
    <skos:narrower rdf:resource="descriptor/19074-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19784-1">
    <skos:narrower rdf:resource="descriptor/11187-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10565-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10052-3">
    <skos:related rdf:resource="descriptor/10220-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13024-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18291-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11676-2">
    <skos:narrower rdf:resource="descriptor/11682-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11676-2">
    <skos:narrower rdf:resource="descriptor/11659-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11676-2">
    <skos:narrower rdf:resource="descriptor/11651-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19451-0">
    <skos:related rdf:resource="descriptor/18490-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19451-0">
    <skos:related rdf:resource="descriptor/11940-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19451-0">
    <skos:related rdf:resource="descriptor/18060-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19451-0">
    <skos:related rdf:resource="descriptor/10822-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18652-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15336-6">
    <skos:broader rdf:resource="thsys/72394"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15336-6">
    <skos:broader rdf:resource="thsys/72186"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15336-6">
    <skos:broader rdf:resource="descriptor/15340-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15336-6">
    <skos:broader rdf:resource="descriptor/15405-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18984-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="http://zbw.eu/namespaces/skos-extensions/indexedItem">
    <rdfs:isDefinedBy rdf:resource="../namespaces/skos-extensions/skos-extensions.rdf"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13306-4">
    <skos:prefLabel xml:lang="en">Catering business</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13306-4">
    <skos:prefLabel xml:lang="de">Gastronomie</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13888-5">
    <skos:related rdf:resource="descriptor/13959-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13888-5">
    <skos:related rdf:resource="descriptor/12996-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19144-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14961-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19571-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19817-5">
    <skos:prefLabel xml:lang="en">European environmental law</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19817-5">
    <skos:prefLabel xml:lang="de">EU-Umweltrecht</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18616-6">
    <skos:prefLabel xml:lang="en">Freight transport policy</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18616-6">
    <skos:prefLabel xml:lang="de">Güterverkehrspolitik</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11378-3">
    <skos:broader rdf:resource="thsys/70844"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11378-3">
    <skos:broader rdf:resource="descriptor/15909-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18689-0">
    <skos:altLabel xml:lang="en">Stock Index derivatives</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18689-0">
    <skos:altLabel xml:lang="en">Index futures</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18689-0">
    <skos:altLabel xml:lang="de">SMI-Futures</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18689-0">
    <skos:altLabel xml:lang="de">Indexterminmarkt</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18689-0">
    <skos:altLabel xml:lang="de">Index-Terminmarkt</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18689-0">
    <skos:altLabel xml:lang="de">Indexoption</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18689-0">
    <skos:altLabel xml:lang="de">DAX-Futures</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18689-0">
    <skos:altLabel xml:lang="de">Aktienindex-Termingeschäft</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16429-1">
    <skos:related rdf:resource="descriptor/16623-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16429-1">
    <skos:related rdf:resource="descriptor/15998-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16429-1">
    <skos:related rdf:resource="descriptor/19768-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16429-1">
    <skos:related rdf:resource="descriptor/24663-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16429-1">
    <skos:related rdf:resource="descriptor/18142-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16429-1">
    <skos:related rdf:resource="descriptor/16678-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16429-1">
    <skos:related rdf:resource="descriptor/15713-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16429-1">
    <skos:related rdf:resource="descriptor/11400-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11406-3">
    <skos:broader rdf:resource="thsys/70843"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11406-3">
    <skos:broader rdf:resource="thsys/70176"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11406-3">
    <skos:broader rdf:resource="descriptor/18884-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10736-1">
    <skos:prefLabel xml:lang="en">Flexible exchange rate</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10736-1">
    <skos:prefLabel xml:lang="de">Flexibler Wechselkurs</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11164-1">
    <skos:prefLabel xml:lang="en">Power (Social Sciences)</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11164-1">
    <skos:prefLabel xml:lang="de">Macht</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19663-6">
    <skos:broader rdf:resource="thsys/73362"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19663-6">
    <skos:broader rdf:resource="thsys/71092"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19663-6">
    <skos:broader rdf:resource="descriptor/16495-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10851-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14686-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10586-1">
    <skos:broader rdf:resource="thsys/71097"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10586-1">
    <skos:broader rdf:resource="thsys/71084"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10586-1">
    <skos:broader rdf:resource="descriptor/10625-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18627-1">
    <skos:altLabel xml:lang="de">Gemeinsame Verkehrspolitik</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14014-5">
    <skos:related rdf:resource="descriptor/14015-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14014-5">
    <skos:related rdf:resource="descriptor/15674-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14014-5">
    <skos:related rdf:resource="descriptor/16543-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14014-5">
    <skos:related rdf:resource="descriptor/18906-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14014-5">
    <skos:related rdf:resource="descriptor/14012-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13475-2">
    <skos:altLabel xml:lang="en">Sales personnel</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13475-2">
    <skos:altLabel xml:lang="de">Verkaufsfahrerinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13475-2">
    <skos:altLabel xml:lang="de">Verkaufsfahrer</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13475-2">
    <skos:altLabel xml:lang="de">Verkaufsberufe</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13475-2">
    <skos:altLabel xml:lang="de">Verkäuferinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13475-2">
    <skos:altLabel xml:lang="de">Verkäufer</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13475-2">
    <skos:altLabel xml:lang="de">Fachverkäuferinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13475-2">
    <skos:altLabel xml:lang="de">Fachverkäufer</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70998">
    <skos:broader rdf:resource="thsys/70999"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12521-5">
    <skos:narrower rdf:resource="descriptor/12520-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12521-5">
    <skos:narrower rdf:resource="descriptor/12513-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14488-2">
    <zbwext:useInsteadNote rdf:nodeID="id193"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16724-6">
    <skos:prefLabel xml:lang="en">Structuralism</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16724-6">
    <skos:prefLabel xml:lang="de">Strukturalismus</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19297-5">
    <skos:prefLabel xml:lang="en">Rice market</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19297-5">
    <skos:prefLabel xml:lang="de">Reismarkt</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12424-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16202-1">
    <skos:broader rdf:resource="thsys/73390"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16202-1">
    <skos:broader rdf:resource="thsys/73334"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16202-1">
    <skos:broader rdf:resource="descriptor/16198-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18179-2">
    <skos:altLabel xml:lang="en">OPAC (Online Public Access Catalogue)</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18179-2">
    <skos:altLabel xml:lang="de">Online-Publikumskatalog</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18179-2">
    <skos:altLabel xml:lang="de">Online-Benutzerkatalog</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18843-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15872-3">
    <skos:narrower rdf:resource="descriptor/15902-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15872-3">
    <skos:narrower rdf:resource="descriptor/11987-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15872-3">
    <skos:narrower rdf:resource="descriptor/19611-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15872-3">
    <skos:narrower rdf:resource="descriptor/11957-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15872-3">
    <skos:narrower rdf:resource="descriptor/15874-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16010-3">
    <skos:broader rdf:resource="thsys/73360"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16010-3">
    <skos:broader rdf:resource="thsys/73296"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16010-3">
    <skos:broader rdf:resource="thsys/70825"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16010-3">
    <skos:broader rdf:resource="descriptor/13660-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19784-1">
    <zbwext:useInsteadNote rdf:nodeID="id384"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19784-1">
    <zbwext:useInsteadNote rdf:nodeID="id383"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14450-6">
    <skos:prefLabel xml:lang="en">Warship</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14450-6">
    <skos:prefLabel xml:lang="de">Kriegsschiff</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12855-4">
    <skos:related rdf:resource="descriptor/11709-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14586-2">
    <skos:related rdf:resource="descriptor/13097-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14586-2">
    <skos:related rdf:resource="descriptor/13235-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14586-2">
    <skos:related rdf:resource="descriptor/15675-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14586-2">
    <skos:related rdf:resource="descriptor/14581-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14586-2">
    <skos:related rdf:resource="descriptor/14029-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14586-2">
    <skos:related rdf:resource="descriptor/14446-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18435-3">
    <skos:prefLabel xml:lang="en">Textile processing</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18435-3">
    <skos:prefLabel xml:lang="de">Textiltechnik</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70498">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19660-5">
    <skos:broader rdf:resource="thsys/73342"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19660-5">
    <skos:broader rdf:resource="thsys/71036"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12980-1">
    <skos:altLabel xml:lang="en">Minerals industries</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12980-1">
    <skos:altLabel xml:lang="de">Montanindustrie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12980-1">
    <skos:altLabel xml:lang="de">Mineralbergbau</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18118-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15971-1">
    <skos:broader rdf:resource="thsys/70154"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14464-2">
    <skos:broader rdf:resource="thsys/70135"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14464-2">
    <skos:broader rdf:resource="descriptor/14473-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13210-3">
    <skos:prefLabel xml:lang="en">Trade</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13210-3">
    <skos:prefLabel xml:lang="de">Handel</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14971-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16277-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16361-2">
    <skos:prefLabel xml:lang="en">Communist party</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16361-2">
    <skos:prefLabel xml:lang="de">Kommunistische Partei</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18314-1">
    <skos:prefLabel xml:lang="en">Malnutrition</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18314-1">
    <skos:prefLabel xml:lang="de">Unterernährung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10537-0">
    <skos:altLabel xml:lang="de">Stufentheorie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10537-0">
    <skos:altLabel xml:lang="de">Rostowsche Stufentheorie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10537-0">
    <skos:altLabel xml:lang="de">Entwicklungsstadium</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10537-0">
    <skos:altLabel xml:lang="de">Entwicklungsphase</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11965-2">
    <skos:broader rdf:resource="thsys/72181"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11965-2">
    <skos:broader rdf:resource="thsys/71064"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11965-2">
    <skos:broader rdf:resource="descriptor/19072-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10037-6">
    <skos:broader rdf:resource="thsys/70878"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10037-6">
    <skos:broader rdf:resource="thsys/70175"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10037-6">
    <skos:broader rdf:resource="descriptor/10032-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10037-6">
    <skos:broader rdf:resource="descriptor/16554-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12088-0">
    <skos:related rdf:resource="descriptor/12087-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12088-0">
    <skos:related rdf:resource="descriptor/15483-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12088-0">
    <skos:related rdf:resource="descriptor/12085-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12088-0">
    <skos:related rdf:resource="descriptor/12884-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12088-0">
    <skos:related rdf:resource="descriptor/12053-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18717-0">
    <skos:narrower rdf:resource="descriptor/18743-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18717-0">
    <skos:narrower rdf:resource="descriptor/18531-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18717-0">
    <skos:narrower rdf:resource="descriptor/18716-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19033-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11230-0">
    <skos:altLabel xml:lang="en">Dual labour market theory</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11230-0">
    <skos:altLabel xml:lang="en">Dual labor market hypothesis</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11230-0">
    <skos:altLabel xml:lang="en">Dual labor market</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11230-0">
    <skos:altLabel xml:lang="de">Duale Arbeitsmarkttheorie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11663-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15775-1">
    <skos:broader rdf:resource="thsys/70239"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13643-0">
    <skos:prefLabel xml:lang="en">Package tourism</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13643-0">
    <skos:prefLabel xml:lang="de">Pauschaltourismus</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10981-2">
    <skos:altLabel xml:lang="de">Sektorpolitik</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10981-2">
    <skos:altLabel xml:lang="de">Sektorale Wirtschaftspolitik</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10981-2">
    <skos:altLabel xml:lang="de">Sektorale Strukturpolitik</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10981-2">
    <skos:altLabel xml:lang="de">Branchenpolitik</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18545-3">
    <skos:related rdf:resource="descriptor/13488-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18545-3">
    <skos:related rdf:resource="descriptor/13200-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10872-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13306-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17743-4">
    <skos:prefLabel xml:lang="en">Central Africa</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17743-4">
    <skos:prefLabel xml:lang="de">Zentralafrika</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16023-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19681-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15935-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19503-0">
    <skos:related rdf:resource="descriptor/16038-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19503-0">
    <skos:related rdf:resource="descriptor/16484-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19503-0">
    <skos:related rdf:resource="descriptor/11349-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19503-0">
    <skos:related rdf:resource="descriptor/18123-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19503-0">
    <skos:related rdf:resource="descriptor/11313-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="http://www.w3.org/2004/02/skos/core#narrower">
    <rdf:type rdf:resource="http://www.w3.org/1999/02/22-rdf-syntax-ns#Property"/>
  </rdf:Description>
  <rdf:Description rdf:about="http://www.w3.org/2004/02/skos/core#narrower">
    <rdf:type rdf:resource="http://www.w3.org/2002/07/owl#ObjectProperty"/>
  </rdf:Description>
  <rdf:Description rdf:about="http://www.w3.org/2004/02/skos/core#broaderTransitive">
    <rdfs:label xml:lang="en">broader transitive</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13469-4">
    <skos:altLabel xml:lang="de">Verbundgruppe im Handel</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13469-4">
    <skos:altLabel xml:lang="de">Ladengemeinschaft</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13469-4">
    <skos:altLabel xml:lang="de">Kooperation im Handel</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13469-4">
    <skos:altLabel xml:lang="de">Handelsverbundsystem</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13469-4">
    <skos:altLabel xml:lang="de">Handelsverbundgruppe</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13469-4">
    <skos:altLabel xml:lang="de">Gemeinschaftswarenhaus</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11158-3">
    <skos:broader rdf:resource="thsys/73395"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11158-3">
    <skos:broader rdf:resource="thsys/70562"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13269-5">
    <skos:scopeNote xml:lang="de">Datennetz in einem begrenzten geographischen Gebiet, meist im Besitz und Gebrauch einer einzelnen Organisation, z.B. eines Unternehmens oder einer Verwaltung.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11563-1">
    <skos:broader rdf:resource="thsys/70967"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11563-1">
    <skos:broader rdf:resource="thsys/70899"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11563-1">
    <skos:broader rdf:resource="thsys/70888"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11563-1">
    <skos:broader rdf:resource="descriptor/11845-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11563-1">
    <skos:broader rdf:resource="descriptor/18752-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11563-1">
    <skos:broader rdf:resource="descriptor/11571-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15874-6">
    <skos:prefLabel xml:lang="en">Geomorphology</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15874-6">
    <skos:prefLabel xml:lang="de">Geomorphologie</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12919-4">
    <skos:broader rdf:resource="thsys/70989"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12919-4">
    <skos:broader rdf:resource="descriptor/12913-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10412-6">
    <skos:altLabel xml:lang="de">Stabilisierungskrise</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19787-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10904-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11804-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19111-3">
    <skos:related rdf:resource="descriptor/11239-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19111-3">
    <skos:related rdf:resource="descriptor/18140-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19111-3">
    <skos:related rdf:resource="descriptor/11246-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19111-3">
    <skos:related rdf:resource="descriptor/11266-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19111-3">
    <skos:related rdf:resource="descriptor/12607-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19111-3">
    <skos:related rdf:resource="descriptor/11303-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13565-1">
    <skos:related rdf:resource="descriptor/13299-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13565-1">
    <skos:related rdf:resource="descriptor/16070-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13565-1">
    <skos:related rdf:resource="descriptor/18616-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13565-1">
    <skos:related rdf:resource="descriptor/18615-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13565-1">
    <skos:related rdf:resource="descriptor/13621-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18848-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14643-2">
    <skos:prefLabel xml:lang="en">Magnesite</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14643-2">
    <skos:prefLabel xml:lang="de">Magnesit</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10610-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19837-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19956-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18032-4">
    <skos:altLabel xml:lang="de">Verkauf des Betriebs</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18032-4">
    <skos:altLabel xml:lang="de">Unternehmensverkauf</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18032-4">
    <skos:altLabel xml:lang="de">Betriebsveräußerung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18032-4">
    <skos:altLabel xml:lang="de">Betriebsübertragung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18032-4">
    <skos:altLabel xml:lang="de">Betriebsüberlassung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14267-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18560-0">
    <skos:altLabel xml:lang="en">Meals on wheels</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18560-0">
    <skos:altLabel xml:lang="de">Partyservice</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18560-0">
    <skos:altLabel xml:lang="de">Essen auf Rädern</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18560-0">
    <skos:altLabel xml:lang="de">Caterer</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12296-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70931">
    <skos:broader rdf:resource="thsys/70932"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70905">
    <skos:narrower rdf:resource="descriptor/18670-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70905">
    <skos:narrower rdf:resource="descriptor/13281-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70905">
    <skos:narrower rdf:resource="descriptor/18672-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70905">
    <skos:narrower rdf:resource="descriptor/13801-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70905">
    <skos:narrower rdf:resource="descriptor/13731-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70905">
    <skos:narrower rdf:resource="descriptor/12287-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70905">
    <skos:narrower rdf:resource="descriptor/18673-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70905">
    <skos:narrower rdf:resource="descriptor/18671-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70905">
    <skos:narrower rdf:resource="descriptor/13723-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70905">
    <skos:narrower rdf:resource="descriptor/11414-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70905">
    <skos:narrower rdf:resource="descriptor/11441-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70905">
    <skos:narrower rdf:resource="descriptor/12243-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70905">
    <skos:narrower rdf:resource="descriptor/18085-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70905">
    <skos:narrower rdf:resource="descriptor/18668-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70905">
    <skos:narrower rdf:resource="descriptor/18703-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70905">
    <skos:narrower rdf:resource="descriptor/13694-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70905">
    <skos:narrower rdf:resource="descriptor/13693-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70905">
    <skos:narrower rdf:resource="descriptor/18709-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70905">
    <skos:narrower rdf:resource="descriptor/13691-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70905">
    <skos:narrower rdf:resource="descriptor/13773-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70905">
    <skos:narrower rdf:resource="descriptor/13689-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70905">
    <skos:narrower rdf:resource="descriptor/18708-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70905">
    <skos:narrower rdf:resource="descriptor/18707-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70905">
    <skos:narrower rdf:resource="descriptor/13688-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70905">
    <skos:narrower rdf:resource="descriptor/13687-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70905">
    <skos:narrower rdf:resource="descriptor/13965-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70905">
    <skos:narrower rdf:resource="descriptor/13283-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70905">
    <skos:narrower rdf:resource="thsys/70900"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70905">
    <skos:narrower rdf:resource="thsys/70903"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70905">
    <skos:narrower rdf:resource="thsys/70904"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10500-2">
    <skos:narrower rdf:resource="descriptor/18459-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17707-1">
    <skos:prefLabel xml:lang="en">Cape Verde</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17707-1">
    <skos:prefLabel xml:lang="de">Kap Verde</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12287-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18317-2">
    <skos:related rdf:resource="descriptor/12956-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18317-2">
    <skos:related rdf:resource="descriptor/12951-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18317-2">
    <skos:related rdf:resource="descriptor/13450-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11710-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70278">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14368-5">
    <skos:altLabel xml:lang="de">Bergbaumaschine</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14368-5">
    <skos:altLabel xml:lang="de">Bergbauausrüstung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10251-4">
    <skos:broader rdf:resource="thsys/70234"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10251-4">
    <skos:broader rdf:resource="descriptor/10249-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10251-4">
    <skos:broader rdf:resource="descriptor/10247-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16454-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12079-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13957-5">
    <skos:related rdf:resource="descriptor/13960-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13957-5">
    <skos:related rdf:resource="descriptor/13871-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13957-5">
    <skos:related rdf:resource="descriptor/18787-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13957-5">
    <skos:related rdf:resource="descriptor/13953-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13957-5">
    <skos:related rdf:resource="descriptor/13376-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13957-5">
    <skos:related rdf:resource="descriptor/18492-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18281-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17758-5">
    <skos:prefLabel xml:lang="en">America</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17758-5">
    <skos:prefLabel xml:lang="de">Amerika</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18135-1">
    <skos:broader rdf:resource="thsys/70361"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18135-1">
    <skos:broader rdf:resource="descriptor/18012-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18161-0">
    <skos:altLabel xml:lang="en">Statistical services</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18161-0">
    <skos:altLabel xml:lang="en">Bureau of statistics</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18161-0">
    <skos:altLabel xml:lang="de">Statistische Behörde</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20810-2">
    <skos:broader rdf:resource="thsys/71092"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20810-2">
    <skos:broader rdf:resource="descriptor/19354-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13816-2">
    <skos:altLabel xml:lang="de">Hausratversicherung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13816-2">
    <skos:altLabel xml:lang="de">Glasversicherung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13816-2">
    <skos:altLabel xml:lang="de">Einbruchdiebstahlversicherung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14969-0">
    <skos:broader rdf:resource="thsys/73301"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14969-0">
    <skos:broader rdf:resource="descriptor/14129-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14969-0">
    <skos:broader rdf:resource="descriptor/14931-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14969-0">
    <skos:broader rdf:resource="descriptor/14161-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13387-6">
    <skos:altLabel xml:lang="de">Service-Rechenzentrum</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15480-6">
    <skos:broader rdf:resource="thsys/73103"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15480-6">
    <skos:broader rdf:resource="descriptor/15467-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11819-6">
    <skos:altLabel xml:lang="de">Handwerksförderung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11819-6">
    <skos:altLabel xml:lang="de">Förderung des Handwerks</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10251-4">
    <skos:narrower rdf:resource="descriptor/11929-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18582-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12648-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13473-6">
    <skos:prefLabel xml:lang="en">Self-service</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13473-6">
    <skos:prefLabel xml:lang="de">Selbstbedienung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18605-4">
    <skos:broader rdf:resource="thsys/73389"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18605-4">
    <skos:broader rdf:resource="thsys/73332"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18605-4">
    <skos:broader rdf:resource="thsys/70932"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18605-4">
    <skos:broader rdf:resource="descriptor/16170-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18605-4">
    <skos:broader rdf:resource="descriptor/18567-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18574-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19134-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16017-3">
    <skos:narrower rdf:resource="descriptor/15983-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16017-3">
    <skos:narrower rdf:resource="descriptor/19703-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16017-3">
    <skos:narrower rdf:resource="descriptor/19687-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16017-3">
    <skos:narrower rdf:resource="descriptor/16309-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16017-3">
    <skos:narrower rdf:resource="descriptor/16008-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16017-3">
    <skos:narrower rdf:resource="descriptor/15998-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16017-3">
    <skos:narrower rdf:resource="descriptor/19649-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70477">
    <skos:narrower rdf:resource="descriptor/14512-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70477">
    <skos:narrower rdf:resource="descriptor/14511-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70477">
    <skos:narrower rdf:resource="descriptor/14561-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70477">
    <skos:narrower rdf:resource="descriptor/14510-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70477">
    <skos:narrower rdf:resource="descriptor/14509-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70477">
    <skos:narrower rdf:resource="descriptor/14554-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70477">
    <skos:narrower rdf:resource="descriptor/14507-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70477">
    <skos:narrower rdf:resource="descriptor/14504-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70477">
    <skos:narrower rdf:resource="descriptor/14502-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14545-2">
    <skos:related rdf:resource="descriptor/14561-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17181-6">
    <skos:prefLabel xml:lang="en">Hungary</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17181-6">
    <skos:prefLabel xml:lang="de">Ungarn</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19773-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16325-6">
    <skos:altLabel xml:lang="de">Luftstreitkräfte</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18655-3">
    <skos:narrower rdf:resource="descriptor/13666-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18655-3">
    <skos:narrower rdf:resource="descriptor/18771-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18655-3">
    <skos:narrower rdf:resource="descriptor/18659-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18655-3">
    <skos:narrower rdf:resource="descriptor/18660-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18655-3">
    <skos:narrower rdf:resource="descriptor/18712-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18655-3">
    <skos:narrower rdf:resource="descriptor/18763-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15666-6">
    <skos:altLabel xml:lang="de">Soziologie der Erziehung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15666-6">
    <skos:altLabel xml:lang="de">Pädagogische Soziologie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15666-6">
    <skos:altLabel xml:lang="de">Erziehungswissenschaft</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15666-6">
    <skos:altLabel xml:lang="de">Erziehungssoziologie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15666-6">
    <skos:altLabel xml:lang="de">Bildungstheorie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15994-3">
    <skos:broader rdf:resource="thsys/73361"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15994-3">
    <skos:broader rdf:resource="descriptor/15998-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16160-5">
    <skos:prefLabel xml:lang="en">Social security legislation</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16160-5">
    <skos:prefLabel xml:lang="de">Sozialversicherungsrecht</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19138-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11741-3">
    <skos:related rdf:resource="descriptor/12574-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11741-3">
    <skos:related rdf:resource="descriptor/12594-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11741-3">
    <skos:related rdf:resource="descriptor/15839-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11741-3">
    <skos:related rdf:resource="descriptor/11037-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16927-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12363-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13308-0">
    <skos:broader rdf:resource="thsys/70944"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13308-0">
    <skos:broader rdf:resource="descriptor/13307-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19566-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11220-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14633-5">
    <skos:prefLabel xml:lang="en">Wax</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14633-5">
    <skos:prefLabel xml:lang="de">Wachs</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14962-0">
    <skos:prefLabel xml:lang="en">Animal fat</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14962-0">
    <skos:prefLabel xml:lang="de">Tierfett</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12721-4">
    <skos:broader rdf:resource="thsys/71005"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12721-4">
    <skos:broader rdf:resource="descriptor/19231-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14082-2">
    <zbwext:useInsteadNote rdf:nodeID="id324"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18024-3">
    <skos:narrower rdf:resource="descriptor/18231-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18024-3">
    <skos:narrower rdf:resource="descriptor/14189-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18024-3">
    <skos:narrower rdf:resource="descriptor/14186-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18024-3">
    <skos:narrower rdf:resource="descriptor/14180-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18024-3">
    <skos:narrower rdf:resource="descriptor/18203-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18024-3">
    <skos:narrower rdf:resource="descriptor/14171-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70575">
    <skos:broader rdf:resource="thsys/w"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14407-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10056-2">
    <skos:altLabel xml:lang="de">Rationale Erwartungsbildung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10056-2">
    <skos:altLabel xml:lang="de">Rationale Erwartungen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10056-2">
    <skos:altLabel xml:lang="de">Ratex</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10613-3">
    <skos:prefLabel xml:lang="en">International labour mobility</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10613-3">
    <skos:prefLabel xml:lang="de">Internationale Arbeitsmobilität</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18823-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71070">
    <rdfs:label xml:lang="en">Regional economics</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71070">
    <rdfs:label xml:lang="de">Regionalökonomik</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13426-1">
    <skos:altLabel xml:lang="de">Landwirtschaftsrecht</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13426-1">
    <skos:altLabel xml:lang="de">Flurbereinigungsgesetz</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13426-1">
    <skos:altLabel xml:lang="de">Agrargesetz</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19423-5">
    <skos:broader rdf:resource="thsys/71074"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19423-5">
    <skos:broader rdf:resource="descriptor/19422-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19239-5">
    <skos:prefLabel xml:lang="en">Real business cycle</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19239-5">
    <skos:prefLabel xml:lang="de">Real Business Cycle</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16545-6">
    <skos:narrower rdf:resource="descriptor/18754-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16545-6">
    <skos:narrower rdf:resource="descriptor/16542-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16545-6">
    <skos:narrower rdf:resource="descriptor/16540-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16545-6">
    <skos:narrower rdf:resource="descriptor/16480-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16545-6">
    <skos:narrower rdf:resource="descriptor/19509-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16545-6">
    <skos:narrower rdf:resource="descriptor/18142-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16545-6">
    <skos:narrower rdf:resource="descriptor/16477-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16545-6">
    <skos:narrower rdf:resource="descriptor/18909-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16545-6">
    <skos:narrower rdf:resource="descriptor/16476-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16545-6">
    <skos:narrower rdf:resource="descriptor/15911-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16545-6">
    <skos:narrower rdf:resource="descriptor/12592-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16545-6">
    <skos:narrower rdf:resource="descriptor/16529-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16545-6">
    <skos:narrower rdf:resource="descriptor/16533-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16545-6">
    <skos:narrower rdf:resource="descriptor/16475-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10265-0">
    <skos:broader rdf:resource="thsys/71111"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10265-0">
    <skos:broader rdf:resource="descriptor/10272-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14270-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13716-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17705-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13362-1">
    <skos:broader rdf:resource="thsys/70819"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12357-6">
    <skos:broader rdf:resource="thsys/71043"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12357-6">
    <skos:broader rdf:resource="descriptor/12381-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19084-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10627-6">
    <skos:related rdf:resource="descriptor/10628-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10627-6">
    <skos:related rdf:resource="descriptor/10771-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10627-6">
    <skos:related rdf:resource="descriptor/10969-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10627-6">
    <skos:related rdf:resource="descriptor/19351-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10627-6">
    <skos:related rdf:resource="descriptor/10612-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16050-5">
    <skos:prefLabel xml:lang="en">Corporate law</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16050-5">
    <skos:prefLabel xml:lang="de">Gesellschaftsrecht</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13004-6">
    <skos:related rdf:resource="descriptor/13142-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13004-6">
    <skos:related rdf:resource="descriptor/12919-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13004-6">
    <skos:related rdf:resource="descriptor/19366-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13004-6">
    <skos:related rdf:resource="descriptor/19365-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13004-6">
    <skos:related rdf:resource="descriptor/14151-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13004-6">
    <skos:related rdf:resource="descriptor/14817-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13004-6">
    <skos:related rdf:resource="descriptor/12996-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16329-5">
    <skos:related rdf:resource="descriptor/16233-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16329-5">
    <skos:related rdf:resource="descriptor/16305-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16329-5">
    <skos:related rdf:resource="descriptor/16306-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16329-5">
    <skos:related rdf:resource="descriptor/13989-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16329-5">
    <skos:related rdf:resource="descriptor/13413-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16329-5">
    <skos:related rdf:resource="descriptor/20855-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16329-5">
    <skos:related rdf:resource="descriptor/20842-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16329-5">
    <skos:related rdf:resource="descriptor/20826-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16329-5">
    <skos:related rdf:resource="descriptor/16315-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14042-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10981-2">
    <skos:broader rdf:resource="thsys/73368"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10981-2">
    <skos:broader rdf:resource="thsys/71110"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10981-2">
    <skos:broader rdf:resource="thsys/70575"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10981-2">
    <skos:broader rdf:resource="descriptor/10987-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17610-2">
    <skos:prefLabel xml:lang="en">Pakistan</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17610-2">
    <skos:prefLabel xml:lang="de">Pakistan</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19449-1">
    <skos:broader rdf:resource="thsys/73351"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19449-1">
    <skos:broader rdf:resource="thsys/71068"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19449-1">
    <skos:broader rdf:resource="thsys/70239"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19449-1">
    <skos:broader rdf:resource="descriptor/19483-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19449-1">
    <skos:broader rdf:resource="descriptor/11900-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13441-5">
    <skos:altLabel xml:lang="en">Crop insurance</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13441-5">
    <skos:altLabel xml:lang="de">Viehversicherung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13441-5">
    <skos:altLabel xml:lang="de">Ernteversicherung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13441-5">
    <skos:altLabel xml:lang="de">Agrarversicherung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12087-2">
    <skos:altLabel xml:lang="de">Unternehmensplanspiel</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12087-2">
    <skos:altLabel xml:lang="de">Management-Planspiel</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14163-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16771-4">
    <skos:prefLabel xml:lang="en">Library science</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16771-4">
    <skos:prefLabel xml:lang="de">Bibliothekswissenschaft</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13437-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12490-4">
    <skos:prefLabel xml:lang="en">Direct costs</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12490-4">
    <skos:prefLabel xml:lang="de">Einzelkosten</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17584-5">
    <skos:prefLabel xml:lang="en">Malaysia</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17584-5">
    <skos:prefLabel xml:lang="de">Malaysia</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13848-3">
    <skos:prefLabel xml:lang="en">Housing investment</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13848-3">
    <skos:prefLabel xml:lang="de">Wohnungsbauinvestition</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18443-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12277-4">
    <skos:prefLabel xml:lang="en">Creditor protection</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12277-4">
    <skos:prefLabel xml:lang="de">Gläubigerschutz</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11824-6">
    <skos:broader rdf:resource="thsys/70963"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11824-6">
    <skos:broader rdf:resource="descriptor/11782-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19725-3">
    <skos:related rdf:resource="descriptor/18366-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19725-3">
    <skos:related rdf:resource="descriptor/16024-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19725-3">
    <skos:related rdf:resource="descriptor/16458-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19725-3">
    <skos:related rdf:resource="descriptor/19720-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19725-3">
    <skos:related rdf:resource="descriptor/19724-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19725-3">
    <skos:related rdf:resource="descriptor/16252-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19725-3">
    <skos:related rdf:resource="descriptor/13412-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19725-3">
    <skos:related rdf:resource="descriptor/15415-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19725-3">
    <skos:related rdf:resource="descriptor/16470-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19725-3">
    <skos:related rdf:resource="descriptor/16204-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19745-4">
    <skos:scopeNote xml:lang="de">Für die Formalkatalogisierung BENUTZE Publikationsart Interview.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19745-4">
    <skos:scopeNote xml:lang="de">Nur für Methode, Technik und Auswertung von Befragungen zur Erhebung von Daten.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16411-6">
    <skos:broader rdf:resource="thsys/73383"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16411-6">
    <skos:broader rdf:resource="descriptor/16405-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18615-1">
    <skos:narrower rdf:resource="descriptor/24787-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18615-1">
    <skos:narrower rdf:resource="descriptor/18582-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18615-1">
    <skos:narrower rdf:resource="descriptor/18621-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13681-6">
    <skos:narrower rdf:resource="descriptor/13679-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13681-6">
    <skos:narrower rdf:resource="descriptor/13656-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16989-5">
    <skos:prefLabel xml:lang="en">Sweden</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16989-5">
    <skos:prefLabel xml:lang="de">Schweden</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70307">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19683-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16670-3">
    <skos:broader rdf:resource="thsys/73346"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16670-3">
    <skos:broader rdf:resource="thsys/70573"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11564-6">
    <skos:prefLabel xml:lang="en">Family benefits</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11564-6">
    <skos:prefLabel xml:lang="de">Familienleistungsausgleich</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13321-1">
    <skos:broader rdf:resource="thsys/70958"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18956-3">
    <skos:altLabel xml:lang="de">Sportverein</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18956-3">
    <skos:altLabel xml:lang="de">Sportveranstalter</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19683-0">
    <skos:related rdf:resource="descriptor/10343-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19683-0">
    <skos:related rdf:resource="descriptor/19285-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19683-0">
    <skos:related rdf:resource="descriptor/19755-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19683-0">
    <skos:related rdf:resource="descriptor/16295-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19683-0">
    <skos:related rdf:resource="descriptor/15720-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19683-0">
    <skos:related rdf:resource="descriptor/19769-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19683-0">
    <skos:related rdf:resource="descriptor/16290-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19683-0">
    <skos:related rdf:resource="descriptor/16286-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19683-0">
    <skos:related rdf:resource="descriptor/19668-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19683-0">
    <skos:related rdf:resource="descriptor/16521-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19683-0">
    <skos:related rdf:resource="descriptor/10816-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19683-0">
    <skos:related rdf:resource="descriptor/16510-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19683-0">
    <skos:related rdf:resource="descriptor/19198-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13250-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12356-1">
    <skos:broader rdf:resource="thsys/71043"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12356-1">
    <skos:broader rdf:resource="thsys/70184"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12356-1">
    <skos:broader rdf:resource="descriptor/10024-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19589-6">
    <skos:broader rdf:resource="thsys/72181"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19589-6">
    <skos:broader rdf:resource="thsys/71115"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19589-6">
    <skos:broader rdf:resource="descriptor/15076-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16957-4">
    <skos:prefLabel xml:lang="en">Appenzell</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16957-4">
    <skos:prefLabel xml:lang="de">Appenzell</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11268-3">
    <skos:altLabel xml:lang="de">Gastarbeiterinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11268-3">
    <skos:altLabel xml:lang="de">Gastarbeiter</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11268-3">
    <skos:altLabel xml:lang="de">Fremdarbeiterinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11268-3">
    <skos:altLabel xml:lang="de">Fremdarbeiter</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11268-3">
    <skos:altLabel xml:lang="de">Ausländerbeschäftigung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11268-3">
    <skos:altLabel xml:lang="de">Arbeitsimmigrantinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11268-3">
    <skos:altLabel xml:lang="de">Arbeitsimmigranten</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19140-3">
    <skos:narrower rdf:resource="descriptor/12812-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18024-3">
    <skos:altLabel xml:lang="en">Tidal power</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18024-3">
    <skos:altLabel xml:lang="en">Renewable energy technology</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18024-3">
    <skos:altLabel xml:lang="de">Regenerierbarer Energieträger</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18024-3">
    <skos:altLabel xml:lang="de">Regenerierbarer Energierohstoff</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18024-3">
    <skos:altLabel xml:lang="de">Regenerativer Energieträger</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18024-3">
    <skos:altLabel xml:lang="de">Gezeitenenergie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18024-3">
    <skos:altLabel xml:lang="de">Erneuerbarer Energieträger</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18024-3">
    <skos:altLabel xml:lang="de">Erneuerbare Energietechnik</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18024-3">
    <skos:altLabel xml:lang="de">Erneuerbare Energiequelle</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18024-3">
    <skos:altLabel xml:lang="de">Erneuerbare Energie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18024-3">
    <skos:altLabel xml:lang="de">Alternative Energie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12927-5">
    <skos:narrower rdf:resource="descriptor/13253-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13414-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12407-3">
    <skos:prefLabel xml:lang="en">Acquisition costs</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12407-3">
    <skos:prefLabel xml:lang="de">Anschaffungskosten</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12501-4">
    <skos:altLabel xml:lang="en">Staff costs</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11642-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12964-6">
    <skos:prefLabel xml:lang="en">Fishery</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12964-6">
    <skos:prefLabel xml:lang="de">Fischerei</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19483-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10980-4">
    <skos:related rdf:resource="descriptor/19686-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10980-4">
    <skos:related rdf:resource="descriptor/11054-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10746-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10028-0">
    <zbwext:useInsteadNote rdf:nodeID="id363"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13541-1">
    <skos:prefLabel xml:lang="en">Canal</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13541-1">
    <skos:prefLabel xml:lang="de">Kanal</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14969-0">
    <skos:narrower rdf:resource="descriptor/14967-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18551-1">
    <skos:broader rdf:resource="thsys/70960"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18551-1">
    <skos:broader rdf:resource="descriptor/13473-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18551-1">
    <skos:broader rdf:resource="descriptor/13218-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13154-1">
    <skos:broader rdf:resource="thsys/70986"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13154-1">
    <skos:broader rdf:resource="descriptor/13160-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13154-1">
    <skos:broader rdf:resource="descriptor/19383-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10898-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13716-6">
    <skos:prefLabel xml:lang="en">Stockbrokers</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13716-6">
    <skos:prefLabel xml:lang="de">Börsenmakler</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11661-1">
    <skos:related rdf:resource="descriptor/11648-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10948-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13483-3">
    <skos:prefLabel xml:lang="en">Specialized retailer</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13483-3">
    <skos:prefLabel xml:lang="de">Facheinzelhandel</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17015-2">
    <skos:prefLabel xml:lang="en">San Marino</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17015-2">
    <skos:prefLabel xml:lang="de">San Marino</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id226">
    <rdf:value xml:lang="de">für die Industrie</rdf:value>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12648-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19916-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15467-5">
    <skos:prefLabel xml:lang="en">Decision under risk</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15467-5">
    <skos:prefLabel xml:lang="de">Entscheidung bei Risiko</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13693-6">
    <skos:narrower rdf:resource="descriptor/16072-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13693-6">
    <skos:narrower rdf:resource="descriptor/16061-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13693-6">
    <skos:narrower rdf:resource="descriptor/18703-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13693-6">
    <skos:narrower rdf:resource="descriptor/13694-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13693-6">
    <skos:narrower rdf:resource="descriptor/18722-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18682-0">
    <skos:narrower rdf:resource="descriptor/19652-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18351-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12027-6">
    <skos:prefLabel xml:lang="en">Property management</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12027-6">
    <skos:prefLabel xml:lang="de">Immobilienverwaltung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19028-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15981-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70151">
    <rdfs:label xml:lang="de">Naturwissenschaften und Technik</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13264-1">
    <skos:related rdf:resource="descriptor/11834-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13264-1">
    <skos:related rdf:resource="descriptor/18625-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13264-1">
    <skos:related rdf:resource="descriptor/13569-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13264-1">
    <skos:related rdf:resource="descriptor/11833-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13264-1">
    <skos:related rdf:resource="descriptor/13588-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13264-1">
    <skos:related rdf:resource="descriptor/13979-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13264-1">
    <skos:related rdf:resource="descriptor/13510-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13264-1">
    <skos:related rdf:resource="descriptor/12927-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14355-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19205-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12930-2">
    <skos:broader rdf:resource="thsys/70985"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12930-2">
    <skos:broader rdf:resource="descriptor/12993-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13699-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15759-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15811-2">
    <skos:narrower rdf:resource="descriptor/18924-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15811-2">
    <skos:narrower rdf:resource="descriptor/12103-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15811-2">
    <skos:narrower rdf:resource="descriptor/12617-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15979-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18782-3">
    <skos:related rdf:resource="descriptor/10458-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18782-3">
    <skos:related rdf:resource="descriptor/11372-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18782-3">
    <skos:related rdf:resource="descriptor/11373-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19365-0">
    <skos:broader rdf:resource="thsys/71019"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19365-0">
    <skos:broader rdf:resource="descriptor/12961-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10717-5">
    <skos:related rdf:resource="descriptor/19313-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10797-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14794-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18632-1">
    <skos:broader rdf:resource="thsys/71069"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18632-1">
    <skos:broader rdf:resource="thsys/70925"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18632-1">
    <skos:broader rdf:resource="descriptor/11833-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18632-1">
    <skos:broader rdf:resource="descriptor/16552-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11551-1">
    <skos:scopeNote xml:lang="de">Kosten, die den Unternehmen oder den Bürger/innen aufgrund politischer oder administrativer Maßnahmen entstehen.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19094-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19140-3">
    <skos:related rdf:resource="descriptor/12778-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19140-3">
    <skos:related rdf:resource="descriptor/12510-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19140-3">
    <skos:related rdf:resource="descriptor/10940-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19140-3">
    <skos:related rdf:resource="descriptor/19139-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19140-3">
    <skos:related rdf:resource="descriptor/12766-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19140-3">
    <skos:related rdf:resource="descriptor/18007-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19390-1">
    <skos:related rdf:resource="descriptor/18405-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19390-1">
    <skos:related rdf:resource="descriptor/13029-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19390-1">
    <skos:related rdf:resource="descriptor/13236-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19390-1">
    <skos:related rdf:resource="descriptor/14285-2"/>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id99">
    <rdfs:seeAlso rdf:resource="descriptor/13691-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11142-4">
    <skos:altLabel xml:lang="en">Soviet-type enterprise</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11142-4">
    <skos:altLabel xml:lang="de">Volkseigener Betrieb</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11142-4">
    <skos:altLabel xml:lang="de">VEB</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11142-4">
    <skos:altLabel xml:lang="de">Staatsunternehmen im Sozialismus</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17723-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13273-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10977-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18523-6">
    <skos:prefLabel xml:lang="en">Computer trade</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18523-6">
    <skos:prefLabel xml:lang="de">Computerhandel</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70073">
    <skos:broader rdf:resource="thsys/70174"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13127-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13155-6">
    <skos:related rdf:resource="descriptor/12955-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13155-6">
    <skos:related rdf:resource="descriptor/14964-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13155-6">
    <skos:related rdf:resource="descriptor/19340-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13155-6">
    <skos:related rdf:resource="descriptor/13940-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16039-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19343-3">
    <skos:related rdf:resource="descriptor/19344-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19343-3">
    <skos:related rdf:resource="descriptor/12950-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19343-3">
    <skos:related rdf:resource="descriptor/14142-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19343-3">
    <skos:related rdf:resource="descriptor/12946-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16502-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14449-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13621-3">
    <skos:altLabel xml:lang="de">Warenverkehr</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13621-3">
    <skos:altLabel xml:lang="de">Warentransport</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13621-3">
    <skos:altLabel xml:lang="de">Gütertransport</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13621-3">
    <skos:altLabel xml:lang="de">Güterbeförderung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13621-3">
    <skos:altLabel xml:lang="de">Frachtverkehr</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13621-3">
    <skos:altLabel xml:lang="de">Frachttransport</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16150-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12612-2">
    <skos:altLabel xml:lang="en">Human-factors engineering</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12612-2">
    <skos:altLabel xml:lang="en">Human factors engineering</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12612-2">
    <skos:altLabel xml:lang="de">Arbeitsphysiologie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12612-2">
    <skos:altLabel xml:lang="de">Arbeitsmedizin</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70938">
    <skos:notation rdf:datatype="http://www.w3.org/2001/XMLSchema#string">W.12.01.02</skos:notation>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12046-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19600-2">
    <skos:broader rdf:resource="thsys/70017"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15491-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18595-2">
    <skos:prefLabel xml:lang="en">Container shipping</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18595-2">
    <skos:prefLabel xml:lang="de">Containerschifffahrt</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13231-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13780-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19226-0">
    <skos:related rdf:resource="descriptor/10206-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19226-0">
    <skos:related rdf:resource="descriptor/10205-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14964-3">
    <skos:altLabel xml:lang="de">Wurst</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14964-3">
    <skos:altLabel xml:lang="de">Verarbeitetes Fleisch</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14964-3">
    <skos:altLabel xml:lang="de">Trockenfleisch</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14964-3">
    <skos:altLabel xml:lang="de">Speck</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14964-3">
    <skos:altLabel xml:lang="de">Schinken</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14964-3">
    <skos:altLabel xml:lang="de">Räucherfleisch</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14964-3">
    <skos:altLabel xml:lang="de">Pökelfleisch</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14964-3">
    <skos:altLabel xml:lang="de">Fleischpastete</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13097-1">
    <skos:broader rdf:resource="thsys/71004"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13097-1">
    <skos:broader rdf:resource="descriptor/12993-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14049-0">
    <skos:broader rdf:resource="thsys/70461"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14049-0">
    <skos:broader rdf:resource="descriptor/13427-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16112-2">
    <skos:broader rdf:resource="thsys/73337"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16112-2">
    <skos:broader rdf:resource="thsys/73334"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16112-2">
    <skos:broader rdf:resource="thsys/71077"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16112-2">
    <skos:broader rdf:resource="thsys/71073"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16112-2">
    <skos:broader rdf:resource="descriptor/16195-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19745-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11366-3">
    <skos:prefLabel xml:lang="en">Employer-provided training</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11366-3">
    <skos:prefLabel xml:lang="de">Betriebliche Bildungsarbeit</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18430-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12699-6">
    <skos:altLabel xml:lang="de">Wartung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12699-6">
    <skos:altLabel xml:lang="de">Reparatur</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12699-6">
    <skos:altLabel xml:lang="de">Instandsetzung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12699-6">
    <skos:altLabel xml:lang="de">Anlagenerhaltung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19532-0">
    <skos:altLabel xml:lang="en">Housing tenure choice</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19532-0">
    <skos:altLabel xml:lang="de">Wohnungsbesitzwahl</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19532-0">
    <skos:altLabel xml:lang="de">Besitzwahltheorie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11642-5">
    <skos:prefLabel xml:lang="en">Tax system</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11642-5">
    <skos:prefLabel xml:lang="de">Steuersystem</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19711-0">
    <skos:prefLabel xml:lang="en">International conference</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19711-0">
    <skos:prefLabel xml:lang="de">Internationale Konferenz</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17688-0">
    <skos:altLabel xml:lang="de">Republik Südafrika</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18143-2">
    <skos:broader rdf:resource="thsys/70843"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18143-2">
    <skos:broader rdf:resource="thsys/70244"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18143-2">
    <skos:broader rdf:resource="descriptor/11361-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11987-6">
    <skos:prefLabel xml:lang="en">Urban geography</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11987-6">
    <skos:prefLabel xml:lang="de">Stadtgeographie</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16402-0">
    <skos:prefLabel xml:lang="en">Social democracy</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16402-0">
    <skos:prefLabel xml:lang="de">Sozialdemokratie</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15728-3">
    <skos:prefLabel xml:lang="en">Exhaust emission technology</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15728-3">
    <skos:prefLabel xml:lang="de">Abgastechnik</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17982-0">
    <skos:altLabel xml:lang="de">EFTA-Länder</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11530-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11648-0">
    <skos:broader rdf:resource="thsys/71076"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11648-0">
    <skos:broader rdf:resource="thsys/71074"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11648-0">
    <skos:broader rdf:resource="descriptor/11547-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14177-5">
    <skos:related rdf:resource="descriptor/12977-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10598-1">
    <skos:broader rdf:resource="thsys/73366"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10598-1">
    <skos:broader rdf:resource="thsys/71084"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10598-1">
    <skos:broader rdf:resource="descriptor/10452-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10598-1">
    <skos:broader rdf:resource="descriptor/10555-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73385">
    <rdfs:label xml:lang="de">Arbeits- und Organisationspsychologie</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13282-6">
    <skos:prefLabel xml:lang="en">Insurance agents</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13282-6">
    <skos:prefLabel xml:lang="de">Versicherungsvermittlung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20077-2">
    <skos:altLabel xml:lang="de">Gesellschaftsvertrag</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70814">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18879-2">
    <skos:related rdf:resource="descriptor/11379-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18879-2">
    <skos:related rdf:resource="descriptor/11378-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18879-2">
    <skos:related rdf:resource="descriptor/18874-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15571-3">
    <skos:prefLabel xml:lang="en">Inventory model</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15571-3">
    <skos:prefLabel xml:lang="de">Lagerhaltungsmodell</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19411-5">
    <skos:broader rdf:resource="thsys/71076"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19411-5">
    <skos:broader rdf:resource="descriptor/11696-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18170-6">
    <skos:narrower rdf:resource="descriptor/13653-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18170-6">
    <skos:narrower rdf:resource="descriptor/15410-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18170-6">
    <skos:narrower rdf:resource="descriptor/13649-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18206-4">
    <skos:broader rdf:resource="thsys/70265"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18206-4">
    <skos:broader rdf:resource="descriptor/12829-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18206-4">
    <skos:broader rdf:resource="descriptor/18211-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70889">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19718-0">
    <skos:broader rdf:resource="thsys/73366"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19718-0">
    <skos:broader rdf:resource="descriptor/16421-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11313-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10302-6">
    <skos:altLabel xml:lang="en">Status good</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10302-6">
    <skos:altLabel xml:lang="en">Premium product</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10302-6">
    <skos:altLabel xml:lang="de">Spitzenprodukt</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10302-6">
    <skos:altLabel xml:lang="de">Hochpreisprodukt</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10615-6">
    <skos:prefLabel xml:lang="en">International factor mobility</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10615-6">
    <skos:prefLabel xml:lang="de">Internationale Faktormobilität</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16654-1">
    <skos:scopeNote xml:lang="de">Ausschluss Einzelner oder sozialer Gruppen von der aktiven Teilnahme am gesellschaftlichen Leben.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19311-2">
    <skos:scopeNote xml:lang="de">Das Ausmaß der Widerspiegelung von Wechselkursänderungen in den Import- und Exportpreisen.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10348-3">
    <skos:altLabel xml:lang="de">Krisenzyklus</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19679-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19382-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19328-6">
    <skos:narrower rdf:resource="descriptor/11573-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19328-6">
    <skos:narrower rdf:resource="descriptor/19723-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19328-6">
    <skos:narrower rdf:resource="descriptor/10603-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13746-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14643-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10562-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13370-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10002-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19735-0">
    <skos:related rdf:resource="descriptor/15640-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17255-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18059-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16623-5">
    <skos:broader rdf:resource="thsys/73395"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16623-5">
    <skos:broader rdf:resource="thsys/73377"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16623-5">
    <skos:broader rdf:resource="descriptor/19768-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13608-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14710-6">
    <skos:scopeNote xml:lang="de">Nur die synthetisch erzeugten Polymere der chemischen Industrie.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15491-1">
    <skos:related rdf:resource="descriptor/15554-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12022-2">
    <skos:prefLabel xml:lang="en">Land rent</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12022-2">
    <skos:prefLabel xml:lang="de">Bodenrente</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12697-3">
    <skos:scopeNote xml:lang="de">Anpassung einer Volkswirtschaft / einer Branche an veränderte ökonomische Rahmenbedingungen; auch die staatlichen Maßnahmen zur Förderung dieses Prozesses.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15768-5">
    <skos:narrower rdf:resource="descriptor/18628-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15768-5">
    <skos:narrower rdf:resource="descriptor/18364-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15768-5">
    <skos:narrower rdf:resource="descriptor/19483-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15768-5">
    <skos:narrower rdf:resource="descriptor/15761-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15768-5">
    <skos:narrower rdf:resource="descriptor/15760-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15768-5">
    <skos:narrower rdf:resource="descriptor/15738-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15768-5">
    <skos:narrower rdf:resource="descriptor/19727-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12435-5">
    <skos:broader rdf:resource="thsys/71043"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12435-5">
    <skos:broader rdf:resource="descriptor/12408-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11651-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19082-5">
    <skos:altLabel xml:lang="de">Verlustübernahme</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19082-5">
    <skos:altLabel xml:lang="de">Gewinnabführung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10944-1">
    <skos:related rdf:resource="descriptor/10895-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10944-1">
    <skos:related rdf:resource="descriptor/10948-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16485-5">
    <skos:broader rdf:resource="thsys/73392"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16485-5">
    <skos:broader rdf:resource="thsys/70814"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16485-5">
    <skos:broader rdf:resource="thsys/70292"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16485-5">
    <skos:broader rdf:resource="descriptor/18976-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70160">
    <skos:broader rdf:resource="thsys/70154"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14985-2">
    <skos:narrower rdf:resource="descriptor/14981-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14985-2">
    <skos:narrower rdf:resource="descriptor/14980-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17950-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19789-5">
    <skos:prefLabel xml:lang="en">Diabetes</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19789-5">
    <skos:prefLabel xml:lang="de">Diabetes</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11353-5">
    <skos:narrower rdf:resource="descriptor/16275-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11353-5">
    <skos:narrower rdf:resource="descriptor/18863-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11353-5">
    <skos:narrower rdf:resource="descriptor/11352-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16404-3">
    <skos:prefLabel xml:lang="en">Radicalism</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16404-3">
    <skos:prefLabel xml:lang="de">Radikalismus</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19545-5">
    <skos:narrower rdf:resource="descriptor/19546-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71032">
    <skos:broader rdf:resource="thsys/70148"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19691-1">
    <skos:prefLabel xml:lang="en">Local self-government</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19691-1">
    <skos:prefLabel xml:lang="de">Kommunale Selbstverwaltung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70839">
    <skos:broader rdf:resource="thsys/w"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19847-3">
    <skos:broader rdf:resource="thsys/73360"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11963-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13427-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19270-4">
    <skos:altLabel xml:lang="de">Regulierung der Börse</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19270-4">
    <skos:altLabel xml:lang="de">Einschuss (Börse)</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19270-4">
    <skos:altLabel xml:lang="de">Einschuß (Börse)</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14005-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14617-3">
    <skos:related rdf:resource="descriptor/14803-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14617-3">
    <skos:related rdf:resource="descriptor/14802-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12451-0">
    <skos:broader rdf:resource="thsys/70186"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12451-0">
    <skos:broader rdf:resource="descriptor/12452-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19227-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70141">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11535-6">
    <skos:related rdf:resource="descriptor/11540-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11535-6">
    <skos:related rdf:resource="descriptor/11536-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11535-6">
    <skos:related rdf:resource="descriptor/11729-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11535-6">
    <skos:related rdf:resource="descriptor/11525-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11535-6">
    <skos:related rdf:resource="descriptor/11532-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11535-6">
    <skos:related rdf:resource="descriptor/19380-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/72180">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18614-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14037-0">
    <skos:prefLabel xml:lang="en">Coal power station</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14037-0">
    <skos:prefLabel xml:lang="de">Kohlekraftwerk</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19645-1">
    <skos:broader rdf:resource="thsys/70182"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19645-1">
    <skos:broader rdf:resource="descriptor/15916-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/24782-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15684-4">
    <skos:related rdf:resource="descriptor/10032-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15684-4">
    <skos:related rdf:resource="descriptor/18871-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15684-4">
    <skos:related rdf:resource="descriptor/11360-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15684-4">
    <skos:related rdf:resource="descriptor/12602-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13509-4">
    <skos:prefLabel xml:lang="en">Transit</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13509-4">
    <skos:prefLabel xml:lang="de">Transit</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10015-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17569-1">
    <skos:broader rdf:resource="thsys/70147"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17569-1">
    <skos:broader rdf:resource="descriptor/19166-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19616-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16410-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18993-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19595-4">
    <skos:broader rdf:resource="thsys/73104"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19595-4">
    <skos:broader rdf:resource="descriptor/15446-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18356-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73350">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13763-4">
    <skos:altLabel xml:lang="en">Funding</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12171-6">
    <skos:altLabel xml:lang="de">Mitarbeiterinformation</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12171-6">
    <skos:altLabel xml:lang="de">Interne Information</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12171-6">
    <skos:altLabel xml:lang="de">Innerbetriebliche Information</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12171-6">
    <skos:altLabel xml:lang="de">Inhouse-Kommunikation</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12171-6">
    <skos:altLabel xml:lang="de">Betriebsinterne Kommunikation</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12171-6">
    <skos:altLabel xml:lang="de">Betriebliche Kommunikationsstruktur</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12171-6">
    <skos:altLabel xml:lang="de">Betriebliche Informationsstruktur</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11765-3">
    <skos:broader rdf:resource="thsys/71114"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11765-3">
    <skos:broader rdf:resource="descriptor/10249-5"/>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id375">
    <rdfs:seeAlso rdf:resource="descriptor/10905-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70368">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19447-5">
    <skos:narrower rdf:resource="descriptor/11999-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19447-5">
    <skos:narrower rdf:resource="descriptor/18967-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19447-5">
    <skos:narrower rdf:resource="descriptor/11890-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17678-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18054-1">
    <skos:prefLabel xml:lang="en">Mediterranean region</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18054-1">
    <skos:prefLabel xml:lang="de">Mittelmeerraum</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13492-2">
    <skos:narrower rdf:resource="descriptor/18552-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16028-5">
    <skos:prefLabel xml:lang="en">Inheritance</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16028-5">
    <skos:prefLabel xml:lang="de">Erbe</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70131">
    <skos:prefLabel xml:lang="en">G.01.04  Southern Europe</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70131">
    <skos:prefLabel xml:lang="de">G.01.04  Südeuropa</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13629-1">
    <skos:narrower rdf:resource="descriptor/18612-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11490-2">
    <skos:prefLabel xml:lang="en">Interest rate policy</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11490-2">
    <skos:prefLabel xml:lang="de">Zinspolitik</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10958-4">
    <skos:related rdf:resource="descriptor/10913-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10958-4">
    <skos:related rdf:resource="descriptor/16051-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70580">
    <skos:narrower rdf:resource="descriptor/19779-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70580">
    <skos:narrower rdf:resource="descriptor/14003-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70580">
    <skos:narrower rdf:resource="descriptor/19778-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70580">
    <skos:narrower rdf:resource="descriptor/15676-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70580">
    <skos:narrower rdf:resource="descriptor/19777-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70580">
    <skos:narrower rdf:resource="descriptor/19776-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70580">
    <skos:narrower rdf:resource="descriptor/19775-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70580">
    <skos:narrower rdf:resource="descriptor/15657-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70580">
    <skos:narrower rdf:resource="descriptor/19608-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70580">
    <skos:narrower rdf:resource="descriptor/15642-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19214-0">
    <skos:related rdf:resource="descriptor/10060-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14195-3">
    <skos:broader rdf:resource="thsys/70418"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14195-3">
    <skos:broader rdf:resource="descriptor/14198-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11721-2">
    <skos:prefLabel xml:lang="en">Government size</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11721-2">
    <skos:prefLabel xml:lang="de">Staatsquote</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10508-0">
    <skos:broader rdf:resource="thsys/70307"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10508-0">
    <skos:broader rdf:resource="thsys/70091"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13392-6">
    <skos:scopeNote xml:lang="de">Gesellschaften, welche geschäftsmäßig jene Verwertungsrechte wahrnehmen, die sich für Publizist/innen und Künstler/innen aus dem Urheberrecht ergeben.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18688-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10668-6">
    <skos:broader rdf:resource="thsys/71099"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10668-6">
    <skos:broader rdf:resource="descriptor/10676-0"/>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id147">
    <rdf:value xml:lang="de">Für die Verbreitung von Informationen</rdf:value>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18630-5">
    <skos:related rdf:resource="descriptor/13590-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18630-5">
    <skos:related rdf:resource="descriptor/13179-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18630-5">
    <skos:related rdf:resource="descriptor/13514-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18630-5">
    <skos:related rdf:resource="descriptor/18501-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18338-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17994-0">
    <skos:broader rdf:resource="thsys/70307"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17994-0">
    <skos:broader rdf:resource="descriptor/11123-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70562">
    <skos:narrower rdf:resource="descriptor/12138-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70562">
    <skos:narrower rdf:resource="descriptor/19155-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70562">
    <skos:narrower rdf:resource="descriptor/12160-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70562">
    <skos:narrower rdf:resource="descriptor/19562-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70562">
    <skos:narrower rdf:resource="descriptor/12116-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70562">
    <skos:narrower rdf:resource="descriptor/15429-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70562">
    <skos:narrower rdf:resource="descriptor/12094-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70562">
    <skos:narrower rdf:resource="descriptor/12155-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70562">
    <skos:narrower rdf:resource="descriptor/12154-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70562">
    <skos:narrower rdf:resource="descriptor/12153-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70562">
    <skos:narrower rdf:resource="descriptor/12105-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70562">
    <skos:narrower rdf:resource="descriptor/24847-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70562">
    <skos:narrower rdf:resource="descriptor/12112-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70562">
    <skos:narrower rdf:resource="descriptor/12111-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70562">
    <skos:narrower rdf:resource="descriptor/12129-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70562">
    <skos:narrower rdf:resource="descriptor/12106-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70562">
    <skos:narrower rdf:resource="descriptor/12091-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70562">
    <skos:narrower rdf:resource="descriptor/20977-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70562">
    <skos:narrower rdf:resource="descriptor/12146-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70562">
    <skos:narrower rdf:resource="descriptor/18867-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70562">
    <skos:narrower rdf:resource="descriptor/20948-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70562">
    <skos:narrower rdf:resource="descriptor/11158-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70562">
    <skos:narrower rdf:resource="descriptor/24704-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70562">
    <skos:narrower rdf:resource="descriptor/12120-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70562">
    <skos:narrower rdf:resource="descriptor/12757-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70562">
    <skos:narrower rdf:resource="descriptor/12137-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70562">
    <skos:narrower rdf:resource="descriptor/24661-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70562">
    <skos:narrower rdf:resource="descriptor/12042-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70562">
    <skos:narrower rdf:resource="descriptor/12136-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70562">
    <skos:narrower rdf:resource="descriptor/12617-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70562">
    <skos:narrower rdf:resource="descriptor/12621-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70562">
    <skos:narrower rdf:resource="descriptor/12135-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70562">
    <skos:narrower rdf:resource="descriptor/12134-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19301-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16300-1">
    <skos:prefLabel xml:lang="en">Nation state</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16300-1">
    <skos:prefLabel xml:lang="de">Nationalstaat</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18556-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15940-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13469-4">
    <skos:related rdf:resource="descriptor/10940-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13469-4">
    <skos:related rdf:resource="descriptor/18527-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18749-1">
    <skos:related rdf:resource="descriptor/13831-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18749-1">
    <skos:related rdf:resource="descriptor/12932-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18749-1">
    <skos:related rdf:resource="descriptor/13840-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18749-1">
    <skos:related rdf:resource="descriptor/12014-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11823-1">
    <skos:altLabel xml:lang="de">Binnenhandelspolitik</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12724-5">
    <skos:broader rdf:resource="thsys/70310"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12724-5">
    <skos:broader rdf:resource="descriptor/12725-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12882-1">
    <skos:prefLabel xml:lang="en">Audit</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12882-1">
    <skos:prefLabel xml:lang="de">Revision</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20068-3">
    <skos:related rdf:resource="descriptor/13387-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20068-3">
    <skos:related rdf:resource="descriptor/18771-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="http://zbw.eu/namespaces/skos-extensions/useInsteadNote">
    <rdfs:subPropertyOf rdf:resource="http://www.w3.org/2004/02/skos/core#note"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14044-3">
    <skos:prefLabel xml:lang="en">Oil and fat</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14044-3">
    <skos:prefLabel xml:lang="de">Öl und Fett</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71069">
    <skos:notation rdf:datatype="http://www.w3.org/2001/XMLSchema#string">V.11.02</skos:notation>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14989-1">
    <skos:prefLabel xml:lang="en">Feed</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14989-1">
    <skos:prefLabel xml:lang="de">Futtermittel</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13808-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16797-0">
    <skos:altLabel xml:lang="de">Wörterbuch</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16797-0">
    <skos:altLabel xml:lang="de">Lexikon</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16797-0">
    <skos:altLabel xml:lang="de">Enzyklopädie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16797-0">
    <skos:altLabel xml:lang="de">Biographie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71041">
    <rdfs:label xml:lang="de">Revision und Controlling</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="http://www.w3.org/2004/02/skos/core#Concept">
    <rdf:type rdf:resource="http://www.w3.org/2002/07/owl#Class"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17624-5">
    <skos:scopeNote xml:lang="de">Verwendet für die gesamte Literatur über Jemen, auch aus der Zeit vor der staatlichen Wiedervereinigung.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13020-1">
    <skos:prefLabel xml:lang="en">Processing of non-metallic minerals</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13020-1">
    <skos:prefLabel xml:lang="de">Verarbeitung von Steinen und Erden</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16158-6">
    <skos:broader rdf:resource="thsys/73335"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16158-6">
    <skos:broader rdf:resource="thsys/70835"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16158-6">
    <skos:broader rdf:resource="descriptor/16159-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11525-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12735-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13694-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13199-0">
    <skos:broader rdf:resource="thsys/70957"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13199-0">
    <skos:broader rdf:resource="descriptor/13200-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16370-1">
    <skos:altLabel xml:lang="de">Parteikongress</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16370-1">
    <skos:altLabel xml:lang="de">Parteikongreß</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10730-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18334-2">
    <skos:related rdf:resource="descriptor/13428-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18334-2">
    <skos:related rdf:resource="descriptor/18892-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18334-2">
    <skos:related rdf:resource="descriptor/10495-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18334-2">
    <skos:related rdf:resource="descriptor/11801-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10005-5">
    <skos:prefLabel xml:lang="en">Property</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10005-5">
    <skos:prefLabel xml:lang="de">Eigentum</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14561-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13441-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13546-5">
    <skos:related rdf:resource="descriptor/13513-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13546-5">
    <skos:related rdf:resource="descriptor/13610-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13546-5">
    <skos:related rdf:resource="descriptor/18592-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13546-5">
    <skos:related rdf:resource="descriptor/14455-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13546-5">
    <skos:related rdf:resource="descriptor/13252-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13546-5">
    <skos:related rdf:resource="descriptor/13600-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18170-6">
    <skos:broader rdf:resource="thsys/73339"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18170-6">
    <skos:broader rdf:resource="descriptor/15611-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18170-6">
    <skos:broader rdf:resource="descriptor/15606-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18938-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19224-4">
    <skos:narrower rdf:resource="descriptor/19266-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15437-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13799-4">
    <skos:related rdf:resource="descriptor/12302-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13799-4">
    <skos:related rdf:resource="descriptor/24859-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73306">
    <skos:narrower rdf:resource="descriptor/14779-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73306">
    <skos:narrower rdf:resource="descriptor/14778-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73306">
    <skos:narrower rdf:resource="descriptor/14777-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73306">
    <skos:narrower rdf:resource="descriptor/14776-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73306">
    <skos:narrower rdf:resource="descriptor/14775-6"/>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id240">
    <rdf:value xml:lang="de">Für Staatsunternehmen sozialistischer Länder</rdf:value>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18880-3">
    <skos:scopeNote xml:lang="de">Für Wirtschaftshochschulen und einzelne Fachbereiche.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70962">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11721-2">
    <skos:broader rdf:resource="thsys/71083"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11721-2">
    <skos:broader rdf:resource="thsys/70858"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11721-2">
    <skos:broader rdf:resource="descriptor/15075-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73350">
    <skos:narrower rdf:resource="descriptor/19784-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73350">
    <skos:narrower rdf:resource="descriptor/15900-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73350">
    <skos:narrower rdf:resource="descriptor/19442-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73350">
    <skos:narrower rdf:resource="descriptor/19529-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73350">
    <skos:narrower rdf:resource="descriptor/15669-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73350">
    <skos:narrower rdf:resource="descriptor/15628-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73350">
    <skos:narrower rdf:resource="descriptor/15033-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73350">
    <skos:narrower rdf:resource="descriptor/14174-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19135-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18455-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19070-5">
    <skos:altLabel xml:lang="de">Empirisches Verfahren</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19070-5">
    <skos:altLabel xml:lang="de">Empirische Untersuchung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13120-4">
    <skos:broader rdf:resource="thsys/70991"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13120-4">
    <skos:broader rdf:resource="descriptor/13106-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10733-0">
    <skos:prefLabel xml:lang="en">ECU</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10733-0">
    <skos:prefLabel xml:lang="de">ECU</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11261-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70397">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11479-4">
    <skos:related rdf:resource="descriptor/11487-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11479-4">
    <skos:related rdf:resource="descriptor/11484-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11479-4">
    <skos:related rdf:resource="descriptor/11494-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11479-4">
    <skos:related rdf:resource="descriptor/11448-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16757-5">
    <skos:scopeNote xml:lang="de">Für die in Unternehmen, Verwaltungen etc. vorhandene und eingesetzte DV-technische Ausstattung.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19549-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12765-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20306-6">
    <skos:related rdf:resource="descriptor/19564-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20306-6">
    <skos:related rdf:resource="descriptor/12809-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20306-6">
    <skos:related rdf:resource="descriptor/19128-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16389-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70843">
    <skos:notation rdf:datatype="http://www.w3.org/2001/XMLSchema#string">W.24.03</skos:notation>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14822-2">
    <skos:broader rdf:resource="thsys/70372"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15924-3">
    <skos:altLabel xml:lang="de">Jugend</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10151-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70416">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10572-5">
    <skos:broader rdf:resource="thsys/71090"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10572-5">
    <skos:broader rdf:resource="thsys/71084"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10572-5">
    <skos:broader rdf:resource="thsys/70140"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10572-5">
    <skos:broader rdf:resource="descriptor/18121-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18397-6">
    <skos:altLabel xml:lang="en">Business service</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18397-6">
    <skos:altLabel xml:lang="de">Unternehmensorientierte Dienstleistung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18397-6">
    <skos:altLabel xml:lang="de">Unternehmensinterne Dienstleistung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18397-6">
    <skos:altLabel xml:lang="de">Unternehmensbezogene Dienstleistung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18397-6">
    <skos:altLabel xml:lang="de">Dienstleistung für Unternehmen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18663-4">
    <skos:related rdf:resource="descriptor/18643-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18663-4">
    <skos:related rdf:resource="descriptor/18653-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18663-4">
    <skos:related rdf:resource="descriptor/13278-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18663-4">
    <skos:related rdf:resource="descriptor/13682-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16960-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15125-5">
    <skos:related rdf:resource="descriptor/15023-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16741-6">
    <skos:related rdf:resource="descriptor/10986-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16741-6">
    <skos:related rdf:resource="descriptor/15965-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16741-6">
    <skos:related rdf:resource="descriptor/15704-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16741-6">
    <skos:related rdf:resource="descriptor/10041-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11448-1">
    <skos:narrower rdf:resource="descriptor/11446-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19068-6">
    <skos:narrower rdf:resource="descriptor/13830-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19068-6">
    <skos:narrower rdf:resource="descriptor/12562-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19068-6">
    <skos:narrower rdf:resource="descriptor/18951-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14052-4">
    <skos:altLabel xml:lang="de">Wasserentsalzungsanlage</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14052-4">
    <skos:altLabel xml:lang="de">Wasseraufbereitungstechnik</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14052-4">
    <skos:altLabel xml:lang="de">Meerwasserentsalzungsanlage</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14052-4">
    <skos:altLabel xml:lang="de">Entsalzungsanlage</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/18277-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/12649-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/12841-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/18278-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/10027-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/18279-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/18559-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/18280-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/14586-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/14581-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/12613-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/14048-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/14593-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/14047-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/18455-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/10016-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/14961-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/18077-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/14044-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/18300-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/14573-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/14043-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/18252-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/14042-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/18292-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/14041-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/14040-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/18276-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/14151-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/10007-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/14404-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/14033-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/14032-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/18613-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/18562-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/14030-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/14029-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/14251-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/14028-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/14849-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/14724-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/14026-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/14723-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/24664-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/14025-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/18275-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/14024-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/14023-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/14022-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/14021-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/14020-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70201">
    <skos:narrower rdf:resource="descriptor/14019-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10542-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15102-3">
    <skos:prefLabel xml:lang="en">Income statistics</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15102-3">
    <skos:prefLabel xml:lang="de">Einkommensstatistik</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70029">
    <skos:narrower rdf:resource="descriptor/20206-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70029">
    <skos:narrower rdf:resource="descriptor/20277-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70029">
    <skos:narrower rdf:resource="descriptor/12761-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70029">
    <skos:narrower rdf:resource="descriptor/12714-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70029">
    <skos:narrower rdf:resource="descriptor/12759-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70029">
    <skos:narrower rdf:resource="descriptor/12758-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70029">
    <skos:narrower rdf:resource="descriptor/12755-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70029">
    <skos:narrower rdf:resource="descriptor/12754-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70029">
    <skos:narrower rdf:resource="descriptor/12643-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70029">
    <skos:narrower rdf:resource="descriptor/12760-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70029">
    <skos:narrower rdf:resource="descriptor/12757-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70029">
    <skos:narrower rdf:resource="descriptor/12750-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70029">
    <skos:narrower rdf:resource="descriptor/12749-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70029">
    <skos:narrower rdf:resource="descriptor/19074-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70029">
    <skos:narrower rdf:resource="descriptor/12765-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70029">
    <skos:narrower rdf:resource="descriptor/12748-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70029">
    <skos:narrower rdf:resource="descriptor/12747-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19066-3">
    <skos:narrower rdf:resource="descriptor/13248-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18550-3">
    <skos:related rdf:resource="descriptor/13862-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18550-3">
    <skos:related rdf:resource="descriptor/13218-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18550-3">
    <skos:related rdf:resource="descriptor/18548-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18343-1">
    <skos:broader rdf:resource="thsys/73351"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18343-1">
    <skos:broader rdf:resource="thsys/71018"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18343-1">
    <skos:broader rdf:resource="thsys/70811"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18343-1">
    <skos:broader rdf:resource="descriptor/15745-3"/>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id126">
    <rdf:value xml:lang="de">Für die natürliche Kautschukgewinnung</rdf:value>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12880-5">
    <skos:related rdf:resource="descriptor/11679-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12880-5">
    <skos:related rdf:resource="descriptor/11709-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12880-5">
    <skos:related rdf:resource="descriptor/12876-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12880-5">
    <skos:related rdf:resource="descriptor/16104-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12880-5">
    <skos:related rdf:resource="descriptor/11536-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16090-0">
    <skos:prefLabel xml:lang="en">EU tax law</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16090-0">
    <skos:prefLabel xml:lang="de">EU-Steuerrecht</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18175-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13499-2">
    <skos:related rdf:resource="descriptor/13501-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15074-3">
    <skos:prefLabel xml:lang="en">Environmental statistics</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15074-3">
    <skos:prefLabel xml:lang="de">Umweltstatistik</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15938-6">
    <skos:prefLabel xml:lang="en">Family</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15938-6">
    <skos:prefLabel xml:lang="de">Familie</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20018-4">
    <skos:scopeNote xml:lang="de">Breites Spektrum nicht öffentlich gehandelter Unternehmensbeteiligungen, die der Finanzierung in entscheidenden Entwicklungsphasen der Unternehmen dienen; ohne ausreichende Sicherheiten, ggf. unter Einflussnahme auf das Management und mit der Absicht, zur Realisierung eines dem Risiko entsprechenden Gewinns die Beteiligung wieder zu veräußern</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13744-1">
    <skos:altLabel xml:lang="de">Wertpapierterminhandel</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13744-1">
    <skos:altLabel xml:lang="de">Wertpapier-Futures</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14027-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15272-6">
    <skos:broader rdf:resource="thsys/72186"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15272-6">
    <skos:broader rdf:resource="descriptor/15258-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70029">
    <skos:notation rdf:datatype="http://www.w3.org/2001/XMLSchema#string">B.06.04</skos:notation>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19673-3">
    <skos:related rdf:resource="descriptor/12438-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19673-3">
    <skos:related rdf:resource="descriptor/12427-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19673-3">
    <skos:related rdf:resource="descriptor/12423-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70198">
    <rdfs:label xml:lang="de">Geographische Begriffe</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73300">
    <skos:prefLabel xml:lang="de">P.20.05  Getränke</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19834-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17994-0">
    <skos:prefLabel xml:lang="en">CMEA countries</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17994-0">
    <skos:prefLabel xml:lang="de">RGW-Staaten</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18716-2">
    <skos:broader rdf:resource="thsys/70900"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18716-2">
    <skos:broader rdf:resource="descriptor/18717-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13775-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19387-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19174-0">
    <skos:prefLabel xml:lang="en">CARICOM countries</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19174-0">
    <skos:prefLabel xml:lang="de">CARICOM-Staaten</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70505">
    <skos:prefLabel xml:lang="en">G.01.02  Northern Europe</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70505">
    <skos:prefLabel xml:lang="de">G.01.02  Nordeuropa</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71052">
    <skos:prefLabel xml:lang="de">V.13.06.03  Führungskräfte und akademische Berufe</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13410-2">
    <skos:related rdf:resource="descriptor/18793-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13410-2">
    <skos:related rdf:resource="descriptor/15971-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13410-2">
    <skos:related rdf:resource="descriptor/15970-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13410-2">
    <skos:related rdf:resource="descriptor/13995-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13410-2">
    <skos:related rdf:resource="descriptor/13389-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13410-2">
    <skos:related rdf:resource="descriptor/15966-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13410-2">
    <skos:related rdf:resource="descriptor/15962-2"/>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id128">
    <rdf:value xml:lang="de">Für Binnenhäfen</rdf:value>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19171-6">
    <skos:prefLabel xml:lang="en">APEC Countries</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19171-6">
    <skos:prefLabel xml:lang="de">APEC-Staaten</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18725-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13397-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18384-1">
    <skos:broader rdf:resource="thsys/71009"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18384-1">
    <skos:broader rdf:resource="thsys/70878"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18384-1">
    <skos:broader rdf:resource="descriptor/10436-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19615-3">
    <skos:prefLabel xml:lang="en">Earthquake</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19615-3">
    <skos:prefLabel xml:lang="de">Erdbeben</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18891-5">
    <skos:related rdf:resource="descriptor/13371-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18891-5">
    <skos:related rdf:resource="descriptor/16479-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18891-5">
    <skos:related rdf:resource="descriptor/16635-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14337-2">
    <skos:broader rdf:resource="thsys/70549"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14337-2">
    <skos:broader rdf:resource="descriptor/14336-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16373-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12376-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19060-1">
    <skos:broader rdf:resource="thsys/70960"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19060-1">
    <skos:broader rdf:resource="descriptor/13219-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19060-1">
    <skos:broader rdf:resource="descriptor/13209-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18555-0">
    <skos:altLabel xml:lang="de">Preispolitik des Einzelhandels</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70406">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14643-2">
    <skos:related rdf:resource="descriptor/14300-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73365">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14317-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12307-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18940-4">
    <skos:related rdf:resource="descriptor/14514-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18940-4">
    <skos:related rdf:resource="descriptor/18767-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18940-4">
    <skos:related rdf:resource="descriptor/20341-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17947-2">
    <skos:broader rdf:resource="thsys/70128"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17947-2">
    <skos:broader rdf:resource="descriptor/17948-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10392-0">
    <skos:related rdf:resource="descriptor/11494-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10030-6">
    <skos:prefLabel xml:lang="en">Goods</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10030-6">
    <skos:prefLabel xml:lang="de">Güter</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="http://www.w3.org/2004/02/skos/core#semanticRelation">
    <rdfs:domain rdf:resource="http://www.w3.org/2004/02/skos/core#Concept"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12665-2">
    <zbwext:useInsteadNote rdf:nodeID="id195"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12246-1">
    <skos:altLabel xml:lang="en">Guarantee</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18134-3">
    <skos:prefLabel xml:lang="en">Saxony</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18134-3">
    <skos:prefLabel xml:lang="de">Sachsen</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10696-1">
    <skos:altLabel xml:lang="de">Freier Welthandel</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17599-6">
    <skos:prefLabel xml:lang="en">Myanmar</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17599-6">
    <skos:prefLabel xml:lang="de">Myanmar</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id14">
    <rdf:value xml:lang="de">Für den Bau von Industrie- und Verwaltungsgebäuden</rdf:value>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11535-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14396-0">
    <skos:prefLabel xml:lang="en">Industrial truck</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14396-0">
    <skos:prefLabel xml:lang="de">Flurförderzeug</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13894-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13361-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71073">
    <skos:narrower rdf:resource="descriptor/16122-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71073">
    <skos:narrower rdf:resource="descriptor/11710-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71073">
    <skos:narrower rdf:resource="descriptor/16087-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71073">
    <skos:narrower rdf:resource="descriptor/11640-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71073">
    <skos:narrower rdf:resource="descriptor/16112-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71073">
    <skos:narrower rdf:resource="descriptor/16111-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71073">
    <skos:narrower rdf:resource="descriptor/10830-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71073">
    <skos:narrower rdf:resource="descriptor/16110-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71073">
    <skos:narrower rdf:resource="descriptor/16104-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71073">
    <skos:narrower rdf:resource="descriptor/10829-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71073">
    <skos:narrower rdf:resource="descriptor/16100-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71073">
    <skos:narrower rdf:resource="descriptor/18831-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71073">
    <skos:narrower rdf:resource="descriptor/11525-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71073">
    <skos:narrower rdf:resource="descriptor/11532-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71073">
    <skos:narrower rdf:resource="descriptor/16090-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71073">
    <skos:narrower rdf:resource="descriptor/16092-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71073">
    <skos:narrower rdf:resource="descriptor/10828-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71073">
    <skos:narrower rdf:resource="descriptor/11698-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71073">
    <skos:narrower rdf:resource="descriptor/10827-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19553-6">
    <skos:related rdf:resource="descriptor/16619-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19553-6">
    <skos:related rdf:resource="descriptor/10622-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19553-6">
    <skos:related rdf:resource="descriptor/19550-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19553-6">
    <skos:related rdf:resource="descriptor/10488-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15910-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19066-3">
    <skos:broader rdf:resource="thsys/70943"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19066-3">
    <skos:broader rdf:resource="thsys/70883"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19066-3">
    <skos:broader rdf:resource="descriptor/12254-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10928-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14436-0">
    <skos:prefLabel xml:lang="en">Truck</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14436-0">
    <skos:prefLabel xml:lang="de">Lastkraftwagen</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12175-5">
    <skos:prefLabel xml:lang="en">Supervisory board</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12175-5">
    <skos:prefLabel xml:lang="de">Aufsichtsrat</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18629-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13709-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12473-4">
    <skos:altLabel xml:lang="de">Kosten- und Erlös-Informationssystem</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12473-4">
    <skos:altLabel xml:lang="de">EDV-gestützte Kostenrechnung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12473-4">
    <skos:altLabel xml:lang="de">Computergestützte Kostenrechnung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11818-1">
    <skos:prefLabel xml:lang="en">Crafts board</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11818-1">
    <skos:prefLabel xml:lang="de">Handwerkskammer</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18682-0">
    <skos:related rdf:resource="descriptor/13743-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18682-0">
    <skos:related rdf:resource="descriptor/16080-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18682-0">
    <skos:related rdf:resource="descriptor/13742-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18682-0">
    <skos:related rdf:resource="descriptor/13769-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18682-0">
    <skos:related rdf:resource="descriptor/12265-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18682-0">
    <skos:related rdf:resource="descriptor/12299-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18682-0">
    <skos:related rdf:resource="descriptor/13713-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13401-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16588-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16480-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10220-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11339-6">
    <skos:narrower rdf:resource="descriptor/11348-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11339-6">
    <skos:narrower rdf:resource="descriptor/11340-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16290-6">
    <skos:prefLabel xml:lang="en">Political change</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16290-6">
    <skos:prefLabel xml:lang="de">Politischer Wandel</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19470-3">
    <skos:related rdf:resource="descriptor/11627-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19470-3">
    <skos:related rdf:resource="descriptor/18345-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17787-5">
    <skos:altLabel xml:lang="de">Republik Kuba</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13071-5">
    <skos:related rdf:resource="descriptor/14750-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18873-0">
    <skos:altLabel xml:lang="de">Universitätsbibliothek</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20897-6">
    <skos:altLabel xml:lang="en">Hub-and-spoke transportation system</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20897-6">
    <skos:altLabel xml:lang="en">Hub-and-spoke transportation network</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20897-6">
    <skos:altLabel xml:lang="de">Hub-and-Spoke-Verkehr</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20897-6">
    <skos:altLabel xml:lang="de">Hub-and-Spoke-Netz</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20897-6">
    <skos:altLabel xml:lang="de">Hub-and-Spoke Verkehr</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20897-6">
    <skos:altLabel xml:lang="de">Hub-and-Spoke Netz</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70902">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15682-1">
    <skos:prefLabel xml:lang="en">Weltanschauung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15682-1">
    <skos:prefLabel xml:lang="de">Weltanschauung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10227-1">
    <skos:altLabel xml:lang="en">Competitive-equilibrium model</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10227-1">
    <skos:altLabel xml:lang="en">Competitive equilibrium model</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10227-1">
    <skos:altLabel xml:lang="de">Vollständiger Wettbewerb</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10227-1">
    <skos:altLabel xml:lang="de">Vollständige Konkurrenz</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10227-1">
    <skos:altLabel xml:lang="de">Konkurrenzgleichgewicht</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18364-0">
    <skos:related rdf:resource="descriptor/15775-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18364-0">
    <skos:related rdf:resource="descriptor/18362-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12198-0">
    <skos:broader rdf:resource="thsys/70087"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12198-0">
    <skos:broader rdf:resource="descriptor/12181-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15713-2">
    <skos:altLabel xml:lang="de">Soziale Benachteiligung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11164-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11295-0">
    <skos:broader rdf:resource="thsys/73385"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11295-0">
    <skos:broader rdf:resource="thsys/71058"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70209">
    <skos:narrower rdf:resource="descriptor/15778-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70209">
    <skos:narrower rdf:resource="descriptor/10111-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70209">
    <skos:narrower rdf:resource="descriptor/15074-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70209">
    <skos:narrower rdf:resource="descriptor/15773-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70209">
    <skos:narrower rdf:resource="descriptor/15767-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70209">
    <skos:narrower rdf:resource="descriptor/19633-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70209">
    <skos:narrower rdf:resource="descriptor/15760-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70209">
    <skos:narrower rdf:resource="descriptor/15759-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70209">
    <skos:narrower rdf:resource="descriptor/19442-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70209">
    <skos:narrower rdf:resource="descriptor/18072-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70209">
    <skos:narrower rdf:resource="descriptor/18325-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70209">
    <skos:narrower rdf:resource="descriptor/10097-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70209">
    <skos:narrower rdf:resource="descriptor/10411-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70209">
    <skos:narrower rdf:resource="descriptor/19831-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70209">
    <skos:narrower rdf:resource="descriptor/10092-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70209">
    <skos:narrower rdf:resource="descriptor/15776-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70209">
    <skos:narrower rdf:resource="descriptor/18957-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70209">
    <skos:narrower rdf:resource="thsys/70238"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70209">
    <skos:narrower rdf:resource="thsys/70239"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16156-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18241-2">
    <skos:prefLabel xml:lang="en">Container terminal</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18241-2">
    <skos:prefLabel xml:lang="de">Containerhafen</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73298">
    <skos:broader rdf:resource="thsys/70498"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13557-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15472-5">
    <skos:altLabel xml:lang="en">Group decision making</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15472-5">
    <skos:altLabel xml:lang="en">Committee decision making</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15472-5">
    <skos:altLabel xml:lang="de">Multipersonale Entscheidung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15472-5">
    <skos:altLabel xml:lang="de">Kollektiventscheidung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15472-5">
    <skos:altLabel xml:lang="de">Kollektive Entscheidung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15472-5">
    <skos:altLabel xml:lang="de">Interpersonale Entscheidung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19495-1">
    <skos:broader rdf:resource="thsys/71062"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19495-1">
    <skos:broader rdf:resource="thsys/71060"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19495-1">
    <skos:broader rdf:resource="descriptor/11219-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16159-4">
    <skos:narrower rdf:resource="descriptor/16160-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16159-4">
    <skos:narrower rdf:resource="descriptor/16158-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16159-4">
    <skos:narrower rdf:resource="descriptor/16156-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16159-4">
    <skos:narrower rdf:resource="descriptor/16155-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16159-4">
    <skos:narrower rdf:resource="descriptor/16143-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16159-4">
    <skos:narrower rdf:resource="descriptor/16481-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16159-4">
    <skos:narrower rdf:resource="descriptor/18904-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19550-5">
    <skos:related rdf:resource="descriptor/19553-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19550-5">
    <skos:related rdf:resource="descriptor/10492-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16605-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id363">
    <rdfs:seeAlso rdf:resource="descriptor/12320-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14829-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10822-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12846-5">
    <skos:related rdf:resource="descriptor/12845-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12846-5">
    <skos:related rdf:resource="descriptor/12837-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12846-5">
    <skos:related rdf:resource="descriptor/12829-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12846-5">
    <skos:related rdf:resource="descriptor/15858-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12846-5">
    <skos:related rdf:resource="descriptor/12844-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12846-5">
    <skos:related rdf:resource="descriptor/12818-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12846-5">
    <skos:related rdf:resource="descriptor/19747-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14440-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70561">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11965-2">
    <skos:altLabel xml:lang="de">Städtestatistik</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18636-0">
    <skos:altLabel xml:lang="de">Umweltverträglicher Tourismus</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18636-0">
    <skos:altLabel xml:lang="de">Umweltschonender Tourismus</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18636-0">
    <skos:altLabel xml:lang="de">Sanfter Tourismus</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18636-0">
    <skos:altLabel xml:lang="de">Ökotourismus</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70562">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19328-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18787-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15494-2">
    <skos:altLabel xml:lang="de">Vollständige Enumeration</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15494-2">
    <skos:altLabel xml:lang="de">Vollenumeration</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16716-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14281-3">
    <skos:prefLabel xml:lang="en">Ferro-alloy</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14281-3">
    <skos:prefLabel xml:lang="de">Ferrolegierung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14070-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19226-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13052-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10434-3">
    <skos:broader rdf:resource="thsys/70406"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10434-3">
    <skos:broader rdf:resource="descriptor/10249-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11976-4">
    <skos:broader rdf:resource="thsys/71064"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12747-0">
    <skos:prefLabel xml:lang="en">Production scheduling</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12747-0">
    <skos:prefLabel xml:lang="de">Ablaufplanung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12033-4">
    <skos:broader rdf:resource="thsys/73392"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12033-4">
    <skos:broader rdf:resource="thsys/70040"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12033-4">
    <skos:broader rdf:resource="descriptor/16039-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14916-0">
    <skos:broader rdf:resource="thsys/70031"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14916-0">
    <skos:broader rdf:resource="descriptor/14129-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10329-0">
    <skos:broader rdf:resource="thsys/70406"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10329-0">
    <skos:broader rdf:resource="thsys/70233"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10329-0">
    <skos:broader rdf:resource="descriptor/10256-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10227-1">
    <skos:broader rdf:resource="thsys/71119"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10227-1">
    <skos:broader rdf:resource="thsys/70242"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10227-1">
    <skos:broader rdf:resource="descriptor/10956-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10227-1">
    <skos:broader rdf:resource="descriptor/10905-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71029">
    <rdfs:label xml:lang="en">Plant production</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71029">
    <rdfs:label xml:lang="de">Pflanzenbau</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16247-0">
    <skos:related rdf:resource="descriptor/16295-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16247-0">
    <skos:related rdf:resource="descriptor/16286-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16247-0">
    <skos:related rdf:resource="descriptor/11047-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16247-0">
    <skos:related rdf:resource="descriptor/16249-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16397-2">
    <skos:altLabel xml:lang="de">Anarchismus</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15664-3">
    <skos:broader rdf:resource="thsys/70151"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15664-3">
    <skos:broader rdf:resource="descriptor/15685-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15858-4">
    <skos:prefLabel xml:lang="en">Advertising psychology</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15858-4">
    <skos:prefLabel xml:lang="de">Werbepsychologie</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10250-6">
    <skos:related rdf:resource="descriptor/11473-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10250-6">
    <skos:related rdf:resource="descriptor/19229-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10250-6">
    <skos:related rdf:resource="descriptor/10249-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10250-6">
    <skos:related rdf:resource="descriptor/10377-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15107-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/21315-0">
    <skos:scopeNote xml:lang="de">Werbung im Internet: Z.B. Bannerwerbung und Werbe-Mails.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id103">
    <rdf:value xml:lang="de">Für Bundesstaaten</rdf:value>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70171">
    <skos:prefLabel xml:lang="de">V.06.01  Wirtschaftssysteme</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16674-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10673-6">
    <skos:related rdf:resource="descriptor/10771-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18200-2">
    <skos:broader rdf:resource="thsys/73332"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18200-2">
    <skos:broader rdf:resource="thsys/71010"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18200-2">
    <skos:broader rdf:resource="descriptor/10593-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14759-4">
    <skos:broader rdf:resource="thsys/73305"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14759-4">
    <skos:broader rdf:resource="descriptor/14752-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13255-2">
    <skos:broader rdf:resource="thsys/70941"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13255-2">
    <skos:broader rdf:resource="descriptor/13510-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19687-6">
    <skos:prefLabel xml:lang="en">Citizenship</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19687-6">
    <skos:prefLabel xml:lang="de">Staatsangehörigkeit</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12212-4">
    <skos:prefLabel xml:lang="en">Portfolio management</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12212-4">
    <skos:prefLabel xml:lang="de">Portfolio-Management</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11036-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12812-1">
    <skos:broader rdf:resource="thsys/70459"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12812-1">
    <skos:broader rdf:resource="descriptor/19140-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19299-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14759-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12518-1">
    <skos:prefLabel xml:lang="en">Differential costing</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12518-1">
    <skos:prefLabel xml:lang="de">Grenzplankostenrechnung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11845-5">
    <skos:altLabel xml:lang="de">Wohnungsbausubvention</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11845-5">
    <skos:altLabel xml:lang="de">Wohnungsbaurecht</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11845-5">
    <skos:altLabel xml:lang="de">Wohnungsbaugesetz</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11845-5">
    <skos:altLabel xml:lang="de">Wohnungsbauförderungsgesetz</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11845-5">
    <skos:altLabel xml:lang="de">Wohnungsbauförderung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11845-5">
    <skos:altLabel xml:lang="de">Wohnbauförderung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11845-5">
    <skos:altLabel xml:lang="de">Öffentliches Baudarlehen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11845-5">
    <skos:altLabel xml:lang="de">Neubauförderung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18287-6">
    <skos:prefLabel xml:lang="en">Storage tank</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18287-6">
    <skos:prefLabel xml:lang="de">Tanklager</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11090-4">
    <skos:altLabel xml:lang="de">Wirtschaftstheorie des Sozialismus</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11090-4">
    <skos:altLabel xml:lang="de">Politische Ökonomie des Marxismus</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11090-4">
    <skos:altLabel xml:lang="de">Marxistische Wirtschaftstheorie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11090-4">
    <skos:altLabel xml:lang="de">Marxistische Politische Ökonomie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70086">
    <skos:narrower rdf:resource="descriptor/17804-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70086">
    <skos:narrower rdf:resource="descriptor/17801-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70086">
    <skos:narrower rdf:resource="descriptor/17800-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70086">
    <skos:narrower rdf:resource="descriptor/17799-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70086">
    <skos:narrower rdf:resource="descriptor/17793-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70086">
    <skos:narrower rdf:resource="descriptor/17792-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70086">
    <skos:narrower rdf:resource="descriptor/17791-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70086">
    <skos:narrower rdf:resource="descriptor/17790-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70086">
    <skos:narrower rdf:resource="descriptor/17787-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70086">
    <skos:narrower rdf:resource="descriptor/17785-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70086">
    <skos:narrower rdf:resource="descriptor/17784-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70086">
    <skos:narrower rdf:resource="descriptor/17783-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70086">
    <skos:narrower rdf:resource="descriptor/17782-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70086">
    <skos:narrower rdf:resource="descriptor/17781-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70086">
    <skos:narrower rdf:resource="descriptor/17780-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70086">
    <skos:narrower rdf:resource="descriptor/17779-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70086">
    <skos:narrower rdf:resource="descriptor/17778-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70086">
    <skos:narrower rdf:resource="descriptor/17777-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70086">
    <skos:narrower rdf:resource="descriptor/17773-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70086">
    <skos:narrower rdf:resource="descriptor/17772-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70086">
    <skos:narrower rdf:resource="descriptor/17771-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70086">
    <skos:narrower rdf:resource="descriptor/17770-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19191-0">
    <skos:broader rdf:resource="thsys/71028"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19191-0">
    <skos:broader rdf:resource="descriptor/12041-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19191-0">
    <skos:broader rdf:resource="descriptor/18318-0"/>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id307">
    <rdf:value xml:lang="de">Für städtische Wirtschaftsentwicklung</rdf:value>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18087-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70175">
    <skos:broader rdf:resource="thsys/v"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11111-1">
    <skos:narrower rdf:resource="descriptor/11079-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11111-1">
    <skos:narrower rdf:resource="descriptor/11071-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11704-2">
    <skos:narrower rdf:resource="descriptor/11679-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11704-2">
    <skos:narrower rdf:resource="descriptor/10404-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11704-2">
    <skos:narrower rdf:resource="descriptor/19404-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11704-2">
    <skos:narrower rdf:resource="descriptor/19567-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11704-2">
    <skos:narrower rdf:resource="descriptor/19408-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11704-2">
    <skos:narrower rdf:resource="descriptor/21014-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11704-2">
    <skos:narrower rdf:resource="descriptor/11706-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11704-2">
    <skos:narrower rdf:resource="descriptor/11703-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11704-2">
    <skos:narrower rdf:resource="descriptor/21011-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11704-2">
    <skos:narrower rdf:resource="descriptor/11702-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11704-2">
    <skos:narrower rdf:resource="descriptor/11660-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11704-2">
    <skos:narrower rdf:resource="descriptor/19413-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11911-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11751-0">
    <skos:narrower rdf:resource="descriptor/19234-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12882-1">
    <skos:narrower rdf:resource="descriptor/12880-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12882-1">
    <skos:narrower rdf:resource="descriptor/12891-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12882-1">
    <skos:narrower rdf:resource="descriptor/12883-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12529-3">
    <skos:related rdf:resource="descriptor/10931-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12529-3">
    <skos:related rdf:resource="descriptor/18555-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13658-1">
    <skos:altLabel xml:lang="de">Medien</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13658-1">
    <skos:altLabel xml:lang="de">Massenmedien</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13658-1">
    <skos:altLabel xml:lang="de">Audiovisuelle Medien</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19488-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15979-6">
    <skos:narrower rdf:resource="descriptor/16304-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15298-2">
    <skos:altLabel xml:lang="en">Test statistics</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15298-2">
    <skos:altLabel xml:lang="en">Test for equality</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15298-2">
    <skos:altLabel xml:lang="en">Power function</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15298-2">
    <skos:altLabel xml:lang="en">Dominance test</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15298-2">
    <skos:altLabel xml:lang="de">Testtheorie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15298-2">
    <skos:altLabel xml:lang="de">Teststärke</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15298-2">
    <skos:altLabel xml:lang="de">Test (Statistik)</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15298-2">
    <skos:altLabel xml:lang="de">Test auf Gleichheit</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15298-2">
    <skos:altLabel xml:lang="de">Signifikanzniveau</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15298-2">
    <skos:altLabel xml:lang="de">Parametertest</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15298-2">
    <skos:altLabel xml:lang="de">Macht eines Tests</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15298-2">
    <skos:altLabel xml:lang="de">Hypothesentest</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15298-2">
    <skos:altLabel xml:lang="de">Homogenitätstest</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15298-2">
    <skos:altLabel xml:lang="de">Gütefunktion</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15298-2">
    <skos:altLabel xml:lang="de">Fehler zweiter Art</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15298-2">
    <skos:altLabel xml:lang="de">Fehler erster Art</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15298-2">
    <skos:altLabel xml:lang="de">Durbin-Watson-Test</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15298-2">
    <skos:altLabel xml:lang="de">Differenzentest</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15621-0">
    <skos:narrower rdf:resource="descriptor/19804-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15621-0">
    <skos:narrower rdf:resource="descriptor/18020-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15621-0">
    <skos:narrower rdf:resource="descriptor/24784-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15621-0">
    <skos:narrower rdf:resource="descriptor/18139-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10595-0">
    <skos:broader rdf:resource="thsys/71085"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10595-0">
    <skos:broader rdf:resource="descriptor/10555-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71062">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14217-5">
    <skos:related rdf:resource="descriptor/14218-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10298-6">
    <skos:altLabel xml:lang="de">Verbraucherinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10298-6">
    <skos:altLabel xml:lang="de">Nachfragerinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10298-6">
    <skos:altLabel xml:lang="de">Nachfrager</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10298-6">
    <skos:altLabel xml:lang="de">Konsumentinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10298-6">
    <skos:altLabel xml:lang="de">Konsumenten</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10298-6">
    <skos:altLabel xml:lang="de">Konsument</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16976-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18376-0">
    <zbwext:useInsteadNote rdf:nodeID="id84"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12702-1">
    <skos:related rdf:resource="descriptor/12805-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12702-1">
    <skos:related rdf:resource="descriptor/10459-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12702-1">
    <skos:related rdf:resource="descriptor/10443-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12702-1">
    <skos:related rdf:resource="descriptor/18495-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12702-1">
    <skos:related rdf:resource="descriptor/18492-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19083-3">
    <skos:broader rdf:resource="thsys/70035"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19083-3">
    <skos:broader rdf:resource="descriptor/16815-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13020-1">
    <skos:scopeNote xml:lang="de">Verarbeitung von Mineralien, die weder zu den Metallen noch zu den Energierohstoffen zählen</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18320-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15762-3">
    <skos:related rdf:resource="descriptor/15769-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15762-3">
    <skos:related rdf:resource="descriptor/15768-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15762-3">
    <skos:related rdf:resource="descriptor/19483-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15762-3">
    <skos:related rdf:resource="descriptor/19473-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16708-4">
    <skos:scopeNote xml:lang="de">Im weiteren Sinne die Lehre vom Wesen und den Voraussetzungen von Erkenntnis.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19032-6">
    <skos:editorialNote xml:lang="de">Sparsam verwenden.</skos:editorialNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10658-2">
    <skos:altLabel xml:lang="en">Intra-regional trade</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10658-2">
    <skos:altLabel xml:lang="de">Binnenhandel</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11064-5">
    <skos:broader rdf:resource="thsys/70171"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11064-5">
    <skos:broader rdf:resource="descriptor/11068-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13398-1">
    <skos:altLabel xml:lang="de">Privathaushalt</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13398-1">
    <skos:altLabel xml:lang="de">Haushalt</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18328-4">
    <skos:related rdf:resource="descriptor/12032-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18328-4">
    <skos:related rdf:resource="descriptor/12023-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18328-4">
    <skos:related rdf:resource="descriptor/11921-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18328-4">
    <skos:related rdf:resource="descriptor/11859-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18067-6">
    <skos:altLabel xml:lang="de">Schadenersatzhaftung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18067-6">
    <skos:altLabel xml:lang="de">Haftungsrisiko</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18067-6">
    <skos:altLabel xml:lang="de">Haftungsrecht</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18067-6">
    <skos:altLabel xml:lang="de">Haftpflicht</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13161-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18332-6">
    <skos:narrower rdf:resource="descriptor/11806-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13523-3">
    <skos:broader rdf:resource="thsys/70941"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13523-3">
    <skos:broader rdf:resource="descriptor/12013-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13299-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12805-5">
    <skos:altLabel xml:lang="en">Industrial design</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12805-5">
    <skos:altLabel xml:lang="de">Produktform</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12805-5">
    <skos:altLabel xml:lang="de">Produktfarbe</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12805-5">
    <skos:altLabel xml:lang="de">Industriedesign</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13034-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17938-3">
    <skos:prefLabel xml:lang="en">Kiribati</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17938-3">
    <skos:prefLabel xml:lang="de">Kiribati</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19477-3">
    <skos:broader rdf:resource="thsys/71064"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19477-3">
    <skos:broader rdf:resource="thsys/70182"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19477-3">
    <skos:broader rdf:resource="descriptor/11894-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17695-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10276-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11823-1">
    <skos:narrower rdf:resource="descriptor/18545-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14603-0">
    <skos:editorialNote xml:lang="de">Möglichst spezifischer indexieren.</skos:editorialNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15103-1">
    <skos:broader rdf:resource="thsys/72181"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15103-1">
    <skos:broader rdf:resource="thsys/71005"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15103-1">
    <skos:broader rdf:resource="descriptor/15076-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18942-0">
    <skos:broader rdf:resource="thsys/73345"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18942-0">
    <skos:broader rdf:resource="thsys/70823"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18942-0">
    <skos:broader rdf:resource="descriptor/16754-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18226-5">
    <skos:altLabel xml:lang="x-other">Slovenija</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18226-5">
    <skos:altLabel xml:lang="de">Republik Slowenien</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12824-1">
    <skos:broader rdf:resource="thsys/70384"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12824-1">
    <skos:broader rdf:resource="descriptor/12846-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12824-1">
    <skos:broader rdf:resource="descriptor/12780-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19737-3">
    <skos:altLabel xml:lang="de">Monastery</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19737-3">
    <skos:altLabel xml:lang="de">Kloster</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11206-4">
    <skos:altLabel xml:lang="en">Regional division of labor</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11206-4">
    <skos:altLabel xml:lang="de">Regionale Spezialisierung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11206-4">
    <skos:altLabel xml:lang="de">Räumliche Arbeitsteilung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11206-4">
    <skos:altLabel xml:lang="de">Interregionale Arbeitsteilung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70882">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18745-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11741-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19444-4">
    <skos:altLabel xml:lang="de">Verstädterungseffekt</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19444-4">
    <skos:altLabel xml:lang="de">Urbanisierungsvorteil</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19444-4">
    <skos:altLabel xml:lang="de">Urbanisierungsnachteil</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19444-4">
    <skos:altLabel xml:lang="de">Urbanisationseffekt</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10255-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73372">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15714-0">
    <skos:broader rdf:resource="thsys/73386"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15714-0">
    <skos:broader rdf:resource="thsys/73358"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13325-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19218-6">
    <skos:prefLabel xml:lang="en">Marginal analysis</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19218-6">
    <skos:prefLabel xml:lang="de">Marginalanalyse</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11669-6">
    <skos:prefLabel xml:lang="en">Wage tax</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11669-6">
    <skos:prefLabel xml:lang="de">Lohnsteuer</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14230-6">
    <skos:prefLabel xml:lang="en">Mica</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14230-6">
    <skos:prefLabel xml:lang="de">Glimmer</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19216-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15969-2">
    <skos:related rdf:resource="descriptor/15976-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15969-2">
    <skos:related rdf:resource="descriptor/15966-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15969-2">
    <skos:related rdf:resource="descriptor/19768-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11562-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12198-0">
    <skos:related rdf:resource="descriptor/12184-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14931-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id36">
    <rdf:value xml:lang="de">Für Auslandsaufträge des produzierenden Gewerbes</rdf:value>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11526-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70040">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71045">
    <skos:broader rdf:resource="thsys/70183"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19065-5">
    <skos:prefLabel xml:lang="en">Land development</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19065-5">
    <skos:prefLabel xml:lang="de">Grundstückserschließung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70416">
    <skos:notation rdf:datatype="http://www.w3.org/2001/XMLSchema#string">P.13</skos:notation>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13736-0">
    <skos:altLabel xml:lang="en">Covered bond</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13085-1">
    <skos:narrower rdf:resource="descriptor/13090-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18704-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18008-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12436-3">
    <skos:related rdf:resource="descriptor/12435-5"/>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id113">
    <rdf:value xml:lang="de">Für betriebswirtschaftliche Ansätze der Investitionstheorie</rdf:value>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16476-6">
    <skos:related rdf:resource="descriptor/16479-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16476-6">
    <skos:related rdf:resource="descriptor/20409-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16476-6">
    <skos:related rdf:resource="descriptor/16668-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16476-6">
    <skos:related rdf:resource="descriptor/14723-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71100">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17709-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18001-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10327-4">
    <skos:altLabel xml:lang="en">Aggregate production function</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10327-4">
    <skos:altLabel xml:lang="de">Produktionsfunktion der Gesamtwirtschaft</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10327-4">
    <skos:altLabel xml:lang="de">Makroökonomische Produktionsfunktion</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10327-4">
    <skos:altLabel xml:lang="de">Gesamtwirtschaftliche Produktionsfunktion</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10327-4">
    <skos:altLabel xml:lang="de">Aggregierte Produktionsfunktion</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19478-1">
    <skos:prefLabel xml:lang="en">Population structure of communities</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19478-1">
    <skos:prefLabel xml:lang="de">Städtische Bevölkerungsstruktur</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13136-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15266-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15709-0">
    <skos:editorialNote xml:lang="de">Möglichst spezifischer indexieren.</skos:editorialNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13244-0">
    <skos:related rdf:resource="descriptor/14436-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13244-0">
    <skos:related rdf:resource="descriptor/13558-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13244-0">
    <skos:related rdf:resource="descriptor/18582-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18663-4">
    <skos:scopeNote xml:lang="de">Gesamtheit aller Einrichtungen und Anlagen im Bereich der Telekommunikation.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16525-5">
    <skos:broader rdf:resource="thsys/70834"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16525-5">
    <skos:broader rdf:resource="descriptor/16475-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19336-0">
    <skos:prefLabel xml:lang="en">European Economic and Monetary Union</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19336-0">
    <skos:prefLabel xml:lang="de">Europäische Wirtschafts- und Währungsunion</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16245-4">
    <skos:narrower rdf:resource="descriptor/16247-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16547-2">
    <skos:altLabel xml:lang="de">Sozialabgabe</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16547-2">
    <skos:altLabel xml:lang="de">Arbeitgeberbeitrag</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13446-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12276-6">
    <skos:prefLabel xml:lang="en">Payout policy</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12276-6">
    <skos:prefLabel xml:lang="de">Gewinnverwendung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13704-6">
    <skos:related rdf:resource="descriptor/18681-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10805-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18630-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13514-4">
    <skos:broader rdf:resource="thsys/70925"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13514-4">
    <skos:broader rdf:resource="descriptor/12013-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18924-2">
    <zbwext:useInsteadNote rdf:nodeID="id182"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14488-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19098-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13137-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14981-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11388-0">
    <skos:altLabel xml:lang="de">Berufsförderung Behinderter</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11388-0">
    <skos:altLabel xml:lang="de">Berufliche Behindertenrehabilitation</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11388-0">
    <skos:altLabel xml:lang="de">Arbeitsförderung Behinderter</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13064-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13283-4">
    <skos:prefLabel xml:lang="en">Bank</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13283-4">
    <skos:prefLabel xml:lang="de">Bank</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16648-3">
    <skos:related rdf:resource="descriptor/16515-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16648-3">
    <skos:related rdf:resource="descriptor/15654-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16648-3">
    <skos:related rdf:resource="descriptor/19712-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16648-3">
    <skos:related rdf:resource="descriptor/16489-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19681-4">
    <skos:broader rdf:resource="thsys/73382"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19681-4">
    <skos:broader rdf:resource="descriptor/16305-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19681-4">
    <skos:broader rdf:resource="descriptor/16278-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11793-5">
    <skos:related rdf:resource="descriptor/10414-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11793-5">
    <skos:related rdf:resource="descriptor/11788-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11793-5">
    <skos:related rdf:resource="descriptor/10533-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11793-5">
    <skos:related rdf:resource="descriptor/24782-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11793-5">
    <skos:related rdf:resource="descriptor/19248-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18932-3">
    <skos:altLabel xml:lang="de">Zuschauerverhalten</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18932-3">
    <skos:altLabel xml:lang="de">Mediennutzung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18932-3">
    <skos:altLabel xml:lang="de">Leseverhalten</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18932-3">
    <skos:altLabel xml:lang="de">Hörfunknutzung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18932-3">
    <skos:altLabel xml:lang="de">Fernsehnutzung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16306-3">
    <skos:broader rdf:resource="thsys/73380"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16306-3">
    <skos:broader rdf:resource="thsys/73375"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16306-3">
    <skos:broader rdf:resource="descriptor/16290-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12209-0">
    <skos:broader rdf:resource="thsys/71044"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12209-0">
    <skos:broader rdf:resource="descriptor/12041-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19841-1">
    <skos:broader rdf:resource="thsys/70862"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19841-1">
    <skos:broader rdf:resource="thsys/70154"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15038-0">
    <skos:narrower rdf:resource="descriptor/15051-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13352-4">
    <skos:altLabel xml:lang="en">Motion picture industry</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13352-4">
    <skos:altLabel xml:lang="de">Videoverleih</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13352-4">
    <skos:altLabel xml:lang="de">Videoindustrie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13352-4">
    <skos:altLabel xml:lang="de">Videofilmverleih</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13352-4">
    <skos:altLabel xml:lang="de">Videofilmproduktion</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13352-4">
    <skos:altLabel xml:lang="de">Kinofilmproduktion</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13352-4">
    <skos:altLabel xml:lang="de">Filmverleih</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13352-4">
    <skos:altLabel xml:lang="de">Filmproduzent</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13352-4">
    <skos:altLabel xml:lang="de">Filmproduktion</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13352-4">
    <skos:altLabel xml:lang="de">Filmindustrie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13352-4">
    <skos:altLabel xml:lang="de">Filmgesellschaft</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13352-4">
    <skos:altLabel xml:lang="de">Filmbranche</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70651">
    <skos:broader rdf:resource="thsys/70538"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15266-1">
    <skos:prefLabel xml:lang="en">Method of moments</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15266-1">
    <skos:prefLabel xml:lang="de">Momentenmethode</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19762-4">
    <skos:prefLabel xml:lang="en">Fathers</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19762-4">
    <skos:prefLabel xml:lang="de">Väter</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73385">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17595-0">
    <skos:broader rdf:resource="thsys/71032"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17595-0">
    <skos:broader rdf:resource="descriptor/17553-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11651-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12573-0">
    <skos:broader rdf:resource="thsys/70244"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12573-0">
    <skos:broader rdf:resource="descriptor/12567-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12573-0">
    <skos:broader rdf:resource="descriptor/12640-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12796-1">
    <skos:related rdf:resource="descriptor/19153-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12796-1">
    <skos:related rdf:resource="descriptor/12062-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12796-1">
    <skos:related rdf:resource="descriptor/12474-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12796-1">
    <skos:related rdf:resource="descriptor/12452-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12796-1">
    <skos:related rdf:resource="descriptor/12520-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12796-1">
    <skos:related rdf:resource="descriptor/12446-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70855">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14731-5">
    <skos:broader rdf:resource="thsys/70199"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14731-5">
    <skos:broader rdf:resource="descriptor/14728-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18908-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12013-3">
    <skos:narrower rdf:resource="descriptor/13514-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12013-3">
    <skos:narrower rdf:resource="descriptor/18090-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12013-3">
    <skos:narrower rdf:resource="descriptor/13533-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12013-3">
    <skos:narrower rdf:resource="descriptor/18617-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12013-3">
    <skos:narrower rdf:resource="descriptor/13516-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12013-3">
    <skos:narrower rdf:resource="descriptor/19610-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12013-3">
    <skos:narrower rdf:resource="descriptor/13523-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18632-1">
    <skos:altLabel xml:lang="en">Regional traffic management</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18632-1">
    <skos:altLabel xml:lang="de">Regionaler Verkehrsplan</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18632-1">
    <skos:altLabel xml:lang="de">Regionale Verkehrsplanung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15021-3">
    <skos:altLabel xml:lang="de">Delphi-Methode</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15021-3">
    <skos:altLabel xml:lang="de">Delphi-Befragung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18676-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18178-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11197-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17735-3">
    <skos:broader rdf:resource="thsys/71031"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17735-3">
    <skos:broader rdf:resource="descriptor/17743-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15429-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11691-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15362-5">
    <skos:prefLabel xml:lang="en">Heteroscedasticity</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15362-5">
    <skos:prefLabel xml:lang="de">Heteroskedastizität</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10446-3">
    <skos:related rdf:resource="descriptor/19244-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19519-6">
    <skos:prefLabel xml:lang="en">Business history</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19519-6">
    <skos:prefLabel xml:lang="de">Business History</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12961-5">
    <skos:altLabel xml:lang="de">Waldwirtschaft</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16509-3">
    <skos:broader rdf:resource="thsys/73373"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16509-3">
    <skos:broader rdf:resource="descriptor/16273-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15656-2">
    <skos:prefLabel xml:lang="en">Learning</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15656-2">
    <skos:prefLabel xml:lang="de">Lernen</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19614-5">
    <skos:prefLabel xml:lang="en">Ocean utilization</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19614-5">
    <skos:prefLabel xml:lang="de">Meeresnutzung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12981-6">
    <skos:broader rdf:resource="thsys/71009"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12981-6">
    <skos:broader rdf:resource="descriptor/12990-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14317-1">
    <skos:prefLabel xml:lang="en">Offshore equipment</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14317-1">
    <skos:prefLabel xml:lang="de">Offshore-Technik</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19854-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10307-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <rdfs:label xml:lang="de">Personalführung, -planung und -entwicklung</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18942-0">
    <skos:narrower rdf:resource="descriptor/19128-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14295-6">
    <skos:broader rdf:resource="thsys/70134"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14295-6">
    <skos:broader rdf:resource="descriptor/14274-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14295-6">
    <skos:broader rdf:resource="descriptor/14302-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17988-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13294-6">
    <skos:broader rdf:resource="thsys/70891"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13294-6">
    <skos:broader rdf:resource="descriptor/13828-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14599-0">
    <skos:prefLabel xml:lang="en">Chemical</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14599-0">
    <skos:prefLabel xml:lang="de">Chemikalie</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11848-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73305">
    <rdfs:label xml:lang="de">Büromaschinen und Datenverarbeitungsgeräte</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16977-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70851">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10961-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18157-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19606-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18428-0">
    <skos:related rdf:resource="descriptor/18649-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18428-0">
    <skos:related rdf:resource="descriptor/13278-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18428-0">
    <skos:related rdf:resource="descriptor/14490-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18428-0">
    <skos:related rdf:resource="descriptor/13682-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18719-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70416">
    <rdfs:label xml:lang="de">Holzprodukte</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18818-1">
    <skos:broader rdf:resource="thsys/73365"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18818-1">
    <skos:broader rdf:resource="thsys/71098"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18818-1">
    <skos:broader rdf:resource="thsys/70982"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18818-1">
    <skos:broader rdf:resource="descriptor/10692-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18818-1">
    <skos:broader rdf:resource="descriptor/16445-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18139-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12917-1">
    <skos:altLabel xml:lang="en">Small-scale manufacturing</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14712-2">
    <skos:altLabel xml:lang="de">PS (Polystyrol)</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70140">
    <skos:prefLabel xml:lang="de">B.00  Betriebswirtschaft</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19468-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id320">
    <rdfs:seeAlso rdf:resource="descriptor/13630-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19482-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12183-6">
    <skos:related rdf:resource="descriptor/12187-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12183-6">
    <skos:related rdf:resource="descriptor/12182-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12183-6">
    <skos:related rdf:resource="descriptor/19729-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18906-4">
    <skos:broader rdf:resource="thsys/70834"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18906-4">
    <skos:broader rdf:resource="descriptor/12047-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16719-6">
    <skos:prefLabel xml:lang="en">Philosophy</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16719-6">
    <skos:prefLabel xml:lang="de">Philosophie</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13712-0">
    <skos:broader rdf:resource="thsys/72184"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13712-0">
    <skos:broader rdf:resource="thsys/71106"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13712-0">
    <skos:broader rdf:resource="descriptor/15082-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18270-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13217-3">
    <skos:related rdf:resource="descriptor/19549-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13217-3">
    <skos:related rdf:resource="descriptor/13051-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13217-3">
    <skos:related rdf:resource="descriptor/13052-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13217-3">
    <skos:related rdf:resource="descriptor/14433-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13217-3">
    <skos:related rdf:resource="descriptor/13248-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73342">
    <skos:notation rdf:datatype="http://www.w3.org/2001/XMLSchema#string">N.10.07</skos:notation>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19301-5">
    <skos:scopeNote xml:lang="de">Nur für die Gesamtheit des Teesektors.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11510-1">
    <skos:prefLabel xml:lang="en">Wage indexation</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11510-1">
    <skos:prefLabel xml:lang="de">Lohnindexierung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19593-1">
    <skos:broader rdf:resource="thsys/73104"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19593-1">
    <skos:broader rdf:resource="descriptor/15458-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14180-2">
    <skos:altLabel xml:lang="de">Erdwärme</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18951-6">
    <skos:broader rdf:resource="thsys/70822"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18951-6">
    <skos:broader rdf:resource="descriptor/19068-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13635-6">
    <skos:altLabel xml:lang="en">Farm tourism</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13635-6">
    <skos:altLabel xml:lang="en">Agrotourism</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13635-6">
    <skos:altLabel xml:lang="de">Urlaub auf dem Bauernhof</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13635-6">
    <skos:altLabel xml:lang="de">Tourismus auf dem Lande</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13635-6">
    <skos:altLabel xml:lang="de">Landtourismus</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13635-6">
    <skos:altLabel xml:lang="de">Ländlicher Tourismus</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13635-6">
    <skos:altLabel xml:lang="de">Bauernhoftourismus</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14012-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11422-5">
    <skos:altLabel xml:lang="en">Money demand</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11422-5">
    <skos:altLabel xml:lang="de">Geldnachfragefunktion der Gesamtwirtschaft</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71079">
    <skos:broader rdf:resource="thsys/70144"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16193-4">
    <skos:altLabel xml:lang="de">Schmiergeld</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16193-4">
    <skos:altLabel xml:lang="de">Bribery</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16193-4">
    <skos:altLabel xml:lang="de">Bestechung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16193-4">
    <skos:altLabel xml:lang="de">Bestechlichkeit</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16193-4">
    <skos:altLabel xml:lang="de">Ämterkauf</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11844-0">
    <skos:prefLabel xml:lang="en">Urban construction policy</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11844-0">
    <skos:prefLabel xml:lang="de">Städtebaupolitik</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11912-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13560-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13561-2">
    <skos:prefLabel xml:lang="en">Road financing</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13561-2">
    <skos:prefLabel xml:lang="de">Straßenbaufinanzierung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16989-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14364-6">
    <skos:prefLabel xml:lang="en">Wind power plant</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14364-6">
    <skos:prefLabel xml:lang="de">Windkraftanlage</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19664-4">
    <skos:narrower rdf:resource="descriptor/19337-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19664-4">
    <skos:narrower rdf:resource="descriptor/18730-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19664-4">
    <skos:narrower rdf:resource="descriptor/13688-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11064-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18317-2">
    <skos:prefLabel xml:lang="en">Agricultural biotechnology</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18317-2">
    <skos:prefLabel xml:lang="de">Agrarbiotechnologie</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18971-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12960-0">
    <skos:altLabel xml:lang="de">Zierpflanzenanbau</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12960-0">
    <skos:altLabel xml:lang="de">Blumenzucht</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/24665-0">
    <skos:prefLabel xml:lang="en">Direct banking</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/24665-0">
    <skos:prefLabel xml:lang="de">Direktbank</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11269-1">
    <skos:prefLabel xml:lang="en">Disabled workers</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11269-1">
    <skos:prefLabel xml:lang="de">Behinderte Arbeitskräfte</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18479-4">
    <skos:prefLabel xml:lang="en">Small- and medium-scale industry</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18479-4">
    <skos:prefLabel xml:lang="de">Mittelständische Industrie</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13225-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14805-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12047-0">
    <skos:prefLabel xml:lang="en">Nonprofit organization</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12047-0">
    <skos:prefLabel xml:lang="de">Nonprofit-Organisation</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19419-3">
    <skos:broader rdf:resource="thsys/71074"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19419-3">
    <skos:broader rdf:resource="thsys/71019"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19419-3">
    <skos:broader rdf:resource="descriptor/18338-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10882-4">
    <skos:prefLabel xml:lang="en">Foreign trade institution</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10882-4">
    <skos:prefLabel xml:lang="de">Staatliche Außenhandelsorganisation</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id277">
    <rdf:value xml:lang="de">Für die rechtsprechende Gewalt</rdf:value>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16353-1">
    <skos:altLabel xml:lang="en">Voters' behaviour</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16353-1">
    <skos:altLabel xml:lang="de">Wahlsoziologie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16353-1">
    <skos:altLabel xml:lang="de">Wahlforschung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16353-1">
    <skos:altLabel xml:lang="de">Wählerverhalten</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16353-1">
    <skos:altLabel xml:lang="de">Wählersoziologie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16353-1">
    <skos:altLabel xml:lang="de">Wählerpsychologie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18766-1">
    <skos:prefLabel xml:lang="en">Computer programming</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18766-1">
    <skos:prefLabel xml:lang="de">Programmierung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13029-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13620-5">
    <skos:narrower rdf:resource="descriptor/13537-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13620-5">
    <skos:narrower rdf:resource="descriptor/18622-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10038-4">
    <skos:prefLabel xml:lang="en">Expectations hypothesis</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10038-4">
    <skos:prefLabel xml:lang="de">Erwartungstheorie</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11570-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18911-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18842-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13630-2">
    <skos:related rdf:resource="descriptor/14440-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13630-2">
    <skos:related rdf:resource="descriptor/14437-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11151-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11495-6">
    <skos:narrower rdf:resource="descriptor/11447-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19314-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11430-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10950-6">
    <skos:broader rdf:resource="thsys/70242"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10950-6">
    <skos:broader rdf:resource="descriptor/10891-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13163-0">
    <skos:prefLabel xml:lang="en">Confectionery industry</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13163-0">
    <skos:prefLabel xml:lang="de">Süßwarenindustrie</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18022-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19670-2">
    <skos:broader rdf:resource="thsys/70234"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18664-2">
    <skos:narrower rdf:resource="descriptor/19145-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18535-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18150-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11551-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10267-3">
    <skos:altLabel xml:lang="de">Staatsverbrauch</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10267-3">
    <skos:altLabel xml:lang="de">Staatskonsum</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10267-3">
    <skos:altLabel xml:lang="de">Öffentlicher Verbrauch</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19261-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19156-2">
    <skos:broader rdf:resource="thsys/70087"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16633-2">
    <skos:narrower rdf:resource="descriptor/15764-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12085-6">
    <skos:editorialNote xml:lang="de">Sparsam und möglichst spezifischer indexieren.</skos:editorialNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16504-6">
    <skos:prefLabel xml:lang="en">Impunity</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16504-6">
    <skos:prefLabel xml:lang="de">Straffreiheit</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10545-1">
    <skos:scopeNote xml:lang="de">Marktausgleichslager für Rohstoffe und Agrarprodukte zur Exportpreisstabilisierung in Entwicklungsländern.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14516-2">
    <skos:altLabel xml:lang="de">Tonbandgerät</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14516-2">
    <skos:altLabel xml:lang="de">Rundfunkgerät</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14516-2">
    <skos:altLabel xml:lang="de">Radiogerät</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14516-2">
    <skos:altLabel xml:lang="de">Plattenspieler</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14516-2">
    <skos:altLabel xml:lang="de">Mikrophon</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14516-2">
    <skos:altLabel xml:lang="de">Lautsprecher</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14516-2">
    <skos:altLabel xml:lang="de">Kopfhörer</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14516-2">
    <skos:altLabel xml:lang="de">Kassettenrecorder</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14516-2">
    <skos:altLabel xml:lang="de">Hifi-Gerät</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14516-2">
    <skos:altLabel xml:lang="de">CD-Spieler</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12049-3">
    <skos:narrower rdf:resource="descriptor/12908-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12049-3">
    <skos:narrower rdf:resource="descriptor/13701-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19155-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10161-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71099">
    <skos:broader rdf:resource="thsys/71100"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16521-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73385">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13360-5">
    <skos:altLabel xml:lang="de">Rundfunksender</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13360-5">
    <skos:altLabel xml:lang="de">Rundfunk- und Fernsehanstalt</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13360-5">
    <skos:altLabel xml:lang="de">Radiosender</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13360-5">
    <skos:altLabel xml:lang="de">Öffentlich-rechtliche Rundfunkanstalt</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13360-5">
    <skos:altLabel xml:lang="de">Hörfunksender</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/72394">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id98">
    <rdfs:seeAlso rdf:resource="descriptor/12711-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18668-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14251-5">
    <skos:broader rdf:resource="thsys/70201"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14251-5">
    <skos:broader rdf:resource="descriptor/14021-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10658-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13641-4">
    <skos:related rdf:resource="descriptor/19854-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10040-3">
    <skos:narrower rdf:resource="descriptor/10184-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10040-3">
    <skos:narrower rdf:resource="descriptor/24857-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10040-3">
    <skos:narrower rdf:resource="descriptor/19209-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10040-3">
    <skos:narrower rdf:resource="descriptor/19208-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15734-1">
    <skos:broader rdf:resource="thsys/73351"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15734-1">
    <skos:broader rdf:resource="thsys/71011"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15734-1">
    <skos:broader rdf:resource="thsys/70817"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15734-1">
    <skos:broader rdf:resource="thsys/70239"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15734-1">
    <skos:broader rdf:resource="descriptor/18379-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15734-1">
    <skos:broader rdf:resource="descriptor/15770-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19452-5">
    <skos:broader rdf:resource="thsys/71067"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19452-5">
    <skos:broader rdf:resource="thsys/71064"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19452-5">
    <skos:broader rdf:resource="descriptor/11932-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19452-5">
    <skos:broader rdf:resource="descriptor/11990-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12230-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14197-6">
    <skos:related rdf:resource="descriptor/17985-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14197-6">
    <skos:related rdf:resource="descriptor/14193-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14197-6">
    <skos:related rdf:resource="descriptor/14044-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14197-6">
    <skos:related rdf:resource="descriptor/12920-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14197-6">
    <skos:related rdf:resource="descriptor/14218-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14197-6">
    <skos:related rdf:resource="descriptor/19182-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14197-6">
    <skos:related rdf:resource="descriptor/13221-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14197-6">
    <skos:related rdf:resource="descriptor/19387-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14197-6">
    <skos:related rdf:resource="descriptor/19181-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14197-6">
    <skos:related rdf:resource="descriptor/18373-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14197-6">
    <skos:related rdf:resource="descriptor/19388-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16430-2">
    <skos:broader rdf:resource="thsys/73394"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16430-2">
    <skos:broader rdf:resource="thsys/73383"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16430-2">
    <skos:broader rdf:resource="thsys/73377"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16430-2">
    <skos:broader rdf:resource="descriptor/16709-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/24783-1">
    <skos:altLabel xml:lang="en">NPM (New Public Management)</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/24783-1">
    <skos:altLabel xml:lang="de">Wirkungsorientierte Verwaltungsführung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/24783-1">
    <skos:altLabel xml:lang="de">Neues Steuerungsmodell</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14383-2">
    <skos:related rdf:resource="descriptor/18095-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14383-2">
    <skos:related rdf:resource="descriptor/14392-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14383-2">
    <skos:related rdf:resource="descriptor/14846-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14383-2">
    <skos:related rdf:resource="descriptor/14829-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11817-3">
    <skos:broader rdf:resource="thsys/71110"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11817-3">
    <skos:broader rdf:resource="thsys/70038"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11817-3">
    <skos:broader rdf:resource="descriptor/10981-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17179-0">
    <skos:related rdf:resource="descriptor/17016-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17179-0">
    <skos:related rdf:resource="descriptor/19077-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17179-0">
    <skos:related rdf:resource="descriptor/18054-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19229-1">
    <skos:prefLabel xml:lang="en">New classical macroeconomics</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19229-1">
    <skos:prefLabel xml:lang="de">Neue klassische Makroökonomik</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18496-4">
    <skos:altLabel xml:lang="de">Haus</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71011">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16525-5">
    <skos:scopeNote xml:lang="de">Ambulante und stationäre Betreuung alter Menschen.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13981-1">
    <skos:related rdf:resource="descriptor/18644-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13981-1">
    <skos:related rdf:resource="descriptor/13270-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13981-1">
    <skos:related rdf:resource="descriptor/11559-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16192-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10213-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18914-5">
    <skos:broader rdf:resource="thsys/73335"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18914-5">
    <skos:broader rdf:resource="thsys/70833"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18914-5">
    <skos:broader rdf:resource="thsys/70324"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18914-5">
    <skos:broader rdf:resource="descriptor/16160-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16031-2">
    <skos:prefLabel xml:lang="en">Cooperative legislation</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16031-2">
    <skos:prefLabel xml:lang="de">Genossenschaftsrecht</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13163-0">
    <skos:related rdf:resource="descriptor/13237-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13163-0">
    <skos:related rdf:resource="descriptor/14996-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13163-0">
    <skos:related rdf:resource="descriptor/18213-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13163-0">
    <skos:related rdf:resource="descriptor/19296-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13163-0">
    <skos:related rdf:resource="descriptor/14065-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13163-0">
    <skos:related rdf:resource="descriptor/14942-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11438-4">
    <skos:prefLabel xml:lang="en">Silver standard</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11438-4">
    <skos:prefLabel xml:lang="de">Silberwährung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18187-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15728-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11969-1">
    <skos:altLabel xml:lang="de">Verslummung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16704-5">
    <skos:scopeNote xml:lang="de">Geistesbewegung des 17. bis 18. Jahrhunderts (ca. 1680-1790)</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18705-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13075-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19498-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11580-1">
    <skos:broader rdf:resource="thsys/73390"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11580-1">
    <skos:broader rdf:resource="thsys/70859"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11580-1">
    <skos:broader rdf:resource="thsys/70144"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11580-1">
    <skos:broader rdf:resource="descriptor/16007-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11675-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10510-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13274-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12513-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73348">
    <skos:notation rdf:datatype="http://www.w3.org/2001/XMLSchema#string">N.10.04</skos:notation>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10110-1">
    <skos:broader rdf:resource="thsys/71113"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10110-1">
    <skos:broader rdf:resource="thsys/70057"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10110-1">
    <skos:broader rdf:resource="descriptor/16623-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15013-2">
    <skos:prefLabel xml:lang="en">Radioactive waste</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15013-2">
    <skos:prefLabel xml:lang="de">Radioaktiver Abfall</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12523-1">
    <skos:narrower rdf:resource="descriptor/12518-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16792-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14327-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15611-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70209">
    <skos:notation rdf:datatype="http://www.w3.org/2001/XMLSchema#string">V.12.01</skos:notation>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19168-2">
    <skos:prefLabel xml:lang="en">Marshall Islands</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19168-2">
    <skos:prefLabel xml:lang="de">Marshallinseln</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11065-3">
    <skos:altLabel xml:lang="de">Theorie der Verfügungsrechte</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11065-3">
    <skos:altLabel xml:lang="de">Theorie der Handlungsrechte</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11065-3">
    <skos:altLabel xml:lang="de">Theorie der Eigentumsrechte</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11065-3">
    <skos:altLabel xml:lang="de">Property-Rights-Theorie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11065-3">
    <skos:altLabel xml:lang="de">Ökonomische Theorie der Eigentumsrechte</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11065-3">
    <skos:altLabel xml:lang="de">Ökonomik der Eigentumsrechte</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11346-2">
    <skos:broader rdf:resource="thsys/70278"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11346-2">
    <skos:broader rdf:resource="descriptor/16440-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11346-2">
    <skos:broader rdf:resource="descriptor/11345-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18479-4">
    <skos:related rdf:resource="descriptor/12917-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10329-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19090-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19344-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18031-6">
    <skos:related rdf:resource="descriptor/12070-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18031-6">
    <skos:related rdf:resource="descriptor/10472-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18031-6">
    <skos:related rdf:resource="descriptor/11981-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18031-6">
    <skos:related rdf:resource="descriptor/11940-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13066-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20176-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18099-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16355-4">
    <skos:broader rdf:resource="thsys/73376"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13667-0">
    <skos:altLabel xml:lang="de">Telephonausrüstung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13667-0">
    <skos:altLabel xml:lang="de">Telephon</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13667-0">
    <skos:altLabel xml:lang="de">Telefonzelle</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13667-0">
    <skos:altLabel xml:lang="de">Telefonverkehr</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13667-0">
    <skos:altLabel xml:lang="de">Telefonausrüstung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13667-0">
    <skos:altLabel xml:lang="de">Telefonapparat</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13667-0">
    <skos:altLabel xml:lang="de">Öffentliches Telefon</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13667-0">
    <skos:altLabel xml:lang="de">Fernsprechausrüstung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13667-0">
    <skos:altLabel xml:lang="de">Anrufbeantworter</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19372-3">
    <skos:broader rdf:resource="thsys/71061"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19372-3">
    <skos:broader rdf:resource="thsys/70833"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19372-3">
    <skos:broader rdf:resource="thsys/70324"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19372-3">
    <skos:broader rdf:resource="thsys/70144"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19372-3">
    <skos:broader rdf:resource="thsys/70052"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19372-3">
    <skos:broader rdf:resource="descriptor/11722-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12571-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10030-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11434-5">
    <skos:altLabel xml:lang="en">Coin</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11434-5">
    <skos:altLabel xml:lang="de">Scheidemünze</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11434-5">
    <skos:altLabel xml:lang="de">Numismatik</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11434-5">
    <skos:altLabel xml:lang="de">Münzprägestätte</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11434-5">
    <skos:altLabel xml:lang="de">Münzkunde</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11434-5">
    <skos:altLabel xml:lang="de">Münze</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19522-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13324-2">
    <skos:narrower rdf:resource="descriptor/18965-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13324-2">
    <skos:narrower rdf:resource="descriptor/13190-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13324-2">
    <skos:narrower rdf:resource="descriptor/18963-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13324-2">
    <skos:narrower rdf:resource="descriptor/18962-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13324-2">
    <skos:narrower rdf:resource="descriptor/13191-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19690-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11968-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13006-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14384-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19495-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19648-2">
    <skos:broader rdf:resource="thsys/73356"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19648-2">
    <skos:broader rdf:resource="thsys/70572"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19648-2">
    <skos:broader rdf:resource="descriptor/19639-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13409-1">
    <skos:narrower rdf:resource="descriptor/13424-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13409-1">
    <skos:narrower rdf:resource="descriptor/13420-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13409-1">
    <skos:narrower rdf:resource="descriptor/13414-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13409-1">
    <skos:narrower rdf:resource="descriptor/11852-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10909-3">
    <skos:altLabel xml:lang="en">Competitive pricing</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10909-3">
    <skos:altLabel xml:lang="de">Wettbewerbspreis</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10909-3">
    <skos:altLabel xml:lang="de">Preiskonkurrenz</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10909-3">
    <skos:altLabel xml:lang="de">Konkurrenzpreis</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71038">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15922-0">
    <skos:related rdf:resource="descriptor/15917-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18897-0">
    <skos:narrower rdf:resource="descriptor/19793-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18897-0">
    <skos:narrower rdf:resource="descriptor/19790-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18897-0">
    <skos:narrower rdf:resource="descriptor/18898-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18243-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18343-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18593-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18741-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12399-4">
    <skos:broader rdf:resource="thsys/71043"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12399-4">
    <skos:broader rdf:resource="descriptor/12356-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11986-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15738-0">
    <skos:altLabel xml:lang="de">Internationaler Umweltschutz</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15738-0">
    <skos:altLabel xml:lang="de">Internationale Umweltschutzpolitik</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15738-0">
    <skos:altLabel xml:lang="de">Globale Umweltpolitik</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13615-5">
    <skos:related rdf:resource="descriptor/18622-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13615-5">
    <skos:related rdf:resource="descriptor/18621-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13615-5">
    <skos:related rdf:resource="descriptor/14318-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11154-4">
    <skos:related rdf:resource="descriptor/10469-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11154-4">
    <skos:related rdf:resource="descriptor/11559-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11154-4">
    <skos:related rdf:resource="descriptor/13413-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11154-4">
    <skos:related rdf:resource="descriptor/11158-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11154-4">
    <skos:related rdf:resource="descriptor/11551-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11154-4">
    <skos:related rdf:resource="descriptor/11038-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18200-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10690-6">
    <skos:prefLabel xml:lang="en">Dumping</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10690-6">
    <skos:prefLabel xml:lang="de">Dumping</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16267-1">
    <skos:prefLabel xml:lang="en">Civil war</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16267-1">
    <skos:prefLabel xml:lang="de">Bürgerkrieg</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12891-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17609-1">
    <skos:altLabel xml:lang="de">Königreich Nepal</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17621-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18867-2">
    <skos:prefLabel xml:lang="en">Learning organization</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18867-2">
    <skos:prefLabel xml:lang="de">Lernende Organisation</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id368">
    <rdf:value xml:lang="de">Für das Studium der Wirtschaftswissenschaft</rdf:value>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10558-6">
    <skos:altLabel xml:lang="de">Entwicklungsinstitution</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10558-6">
    <skos:altLabel xml:lang="de">Entwicklungshilfeorganisation</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14230-6">
    <skos:broader rdf:resource="thsys/70348"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14230-6">
    <skos:broader rdf:resource="descriptor/14236-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18650-6">
    <skos:scopeNote xml:lang="de">Betreiber und Anbieter von Fernsprechnetzen und -diensten</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id376">
    <rdf:value xml:lang="de">für die Struktur einer einzelnen Region</rdf:value>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20888-0">
    <skos:prefLabel xml:lang="en">Green certificates</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20888-0">
    <skos:prefLabel xml:lang="de">Grüne Zertifikate</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18878-4">
    <skos:broader rdf:resource="thsys/70844"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15977-3">
    <skos:prefLabel xml:lang="en">Arbitration</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15977-3">
    <skos:prefLabel xml:lang="de">Schiedsgerichtsbarkeit</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13525-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11054-1">
    <skos:broader rdf:resource="thsys/70858"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11054-1">
    <skos:broader rdf:resource="thsys/70274"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11054-1">
    <skos:broader rdf:resource="descriptor/10201-5"/>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id300">
    <rdf:value xml:lang="de">Für Fachliteratur, die sich an bestimmte Fachdisziplinen oder Berufsgruppen wendet,</rdf:value>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17502-5">
    <skos:prefLabel xml:lang="en">Turkmenistan</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17502-5">
    <skos:prefLabel xml:lang="de">Turkmenistan</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12618-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18453-1">
    <skos:broader rdf:resource="thsys/71005"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18453-1">
    <skos:broader rdf:resource="thsys/70238"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18453-1">
    <skos:broader rdf:resource="descriptor/15763-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17778-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13747-2">
    <skos:related rdf:resource="descriptor/18718-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10605-2">
    <skos:broader rdf:resource="thsys/70179"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70871">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11907-2">
    <skos:altLabel xml:lang="de">Regionale Verteilungswirkung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11907-2">
    <skos:altLabel xml:lang="de">Raumwirkung von Maßnahmen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11907-2">
    <skos:altLabel xml:lang="de">Raumwirksamkeit von Maßnahmen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11907-2">
    <skos:altLabel xml:lang="de">Raumwirksame Maßnahme</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11907-2">
    <skos:altLabel xml:lang="de">Räumliche Wirkung von Maßnahmen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11907-2">
    <skos:altLabel xml:lang="de">Räumliche Inzidenz</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10968-1">
    <skos:prefLabel xml:lang="en">Lobbying</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10968-1">
    <skos:prefLabel xml:lang="de">Interessenpolitik</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19509-2">
    <skos:narrower rdf:resource="descriptor/19325-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15267-6">
    <skos:prefLabel xml:lang="en">Monte Carlo method</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15267-6">
    <skos:prefLabel xml:lang="de">Monte-Carlo-Methode</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13076-2">
    <skos:altLabel xml:lang="de">Elektrotechnische Industrie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14218-3">
    <skos:prefLabel xml:lang="en">Petrochemical</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14218-3">
    <skos:prefLabel xml:lang="de">Mineralölprodukt</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10010-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18125-4">
    <skos:broader rdf:resource="thsys/70851"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18125-4">
    <skos:broader rdf:resource="thsys/70235"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18125-4">
    <skos:broader rdf:resource="descriptor/11168-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18125-4">
    <skos:broader rdf:resource="descriptor/11219-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71095">
    <skos:broader rdf:resource="thsys/70179"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16680-0">
    <skos:altLabel xml:lang="de">Musiksoziologie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16680-0">
    <skos:altLabel xml:lang="de">Literatursoziologie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16680-0">
    <skos:altLabel xml:lang="de">Kunstsoziologie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16680-0">
    <skos:altLabel xml:lang="de">Kulturtheorie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16342-6">
    <skos:scopeNote xml:lang="de">Politische Ordnung mit Beteiligung des Parlaments am politischen Entscheidungsprozess.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10099-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14485-1">
    <skos:altLabel xml:lang="de">Kraftfahrzeugelektronik</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14485-1">
    <skos:altLabel xml:lang="de">Kraftfahrzeugbeleuchtung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14485-1">
    <skos:altLabel xml:lang="de">Kfz-Elektronik</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14485-1">
    <skos:altLabel xml:lang="de">Kfz-Elektrik</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14485-1">
    <skos:altLabel xml:lang="de">Autoelektronik</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12273-5">
    <skos:related rdf:resource="descriptor/12259-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12273-5">
    <skos:related rdf:resource="descriptor/12385-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12273-5">
    <skos:related rdf:resource="descriptor/12244-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12273-5">
    <skos:related rdf:resource="descriptor/12284-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12273-5">
    <skos:related rdf:resource="descriptor/13727-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12273-5">
    <skos:related rdf:resource="descriptor/12274-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12273-5">
    <skos:related rdf:resource="descriptor/19080-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12273-5">
    <skos:related rdf:resource="descriptor/18722-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11753-3">
    <zbwext:useInsteadNote rdf:nodeID="id73"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14737-0">
    <skos:broader rdf:resource="thsys/70536"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14737-0">
    <skos:broader rdf:resource="descriptor/14734-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13080-4">
    <skos:broader rdf:resource="thsys/70995"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13080-4">
    <skos:broader rdf:resource="thsys/70964"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13080-4">
    <skos:broader rdf:resource="descriptor/12910-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11783-1">
    <skos:broader rdf:resource="thsys/71110"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11783-1">
    <skos:broader rdf:resource="descriptor/11782-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11800-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13683-2">
    <skos:related rdf:resource="descriptor/18661-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13683-2">
    <skos:related rdf:resource="descriptor/19808-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16961-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19355-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16496-0">
    <skos:related rdf:resource="descriptor/16495-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16496-0">
    <skos:related rdf:resource="descriptor/16815-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16496-0">
    <skos:related rdf:resource="descriptor/18772-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16512-0">
    <skos:broader rdf:resource="thsys/73373"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16512-0">
    <skos:broader rdf:resource="descriptor/16509-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11905-6">
    <skos:broader rdf:resource="thsys/71067"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11905-6">
    <skos:broader rdf:resource="thsys/71034"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11905-6">
    <skos:broader rdf:resource="descriptor/11913-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15706-6">
    <skos:narrower rdf:resource="descriptor/15704-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15706-6">
    <skos:narrower rdf:resource="descriptor/15703-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15706-6">
    <skos:narrower rdf:resource="descriptor/10500-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15706-6">
    <skos:narrower rdf:resource="descriptor/13462-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15706-6">
    <skos:narrower rdf:resource="descriptor/18838-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15706-6">
    <skos:narrower rdf:resource="descriptor/11416-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15706-6">
    <skos:narrower rdf:resource="descriptor/12046-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15706-6">
    <skos:narrower rdf:resource="descriptor/11533-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15706-6">
    <skos:narrower rdf:resource="descriptor/19519-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15706-6">
    <skos:narrower rdf:resource="descriptor/13691-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15706-6">
    <skos:narrower rdf:resource="descriptor/13444-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14734-6">
    <zbwext:useInsteadNote rdf:nodeID="id173"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19793-0">
    <skos:altLabel xml:lang="de">Schistosomiasis</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19793-0">
    <skos:altLabel xml:lang="de">Malaria</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19793-0">
    <skos:altLabel xml:lang="de">Bilharziose</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17746-5">
    <skos:prefLabel xml:lang="en">Algeria</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17746-5">
    <skos:prefLabel xml:lang="de">Algerien</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/21061-5">
    <skos:prefLabel xml:lang="en">Asset</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/21061-5">
    <skos:prefLabel xml:lang="de">Vermögensgegenstand</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14537-1">
    <skos:broader rdf:resource="thsys/70423"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/19306-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/19349-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/19303-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/13234-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/19347-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/19301-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/18521-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/13238-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/13237-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/19346-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/19345-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/18551-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/19344-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/19343-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/19300-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/19297-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/19342-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/19338-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/19394-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/19677-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/19183-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/19189-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/19395-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/13219-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/19060-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/13218-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/18520-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/13188-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/19366-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/19296-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/19294-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/18519-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/19293-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/19188-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/18517-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/13207-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/19341-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/19292-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/13225-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/19340-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/19382-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/13205-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/18516-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/19290-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/19674-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70960">
    <skos:narrower rdf:resource="descriptor/13431-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18818-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14011-4">
    <skos:related rdf:resource="descriptor/15664-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71100">
    <skos:prefLabel xml:lang="en">V.07.01  International economics</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71100">
    <skos:prefLabel xml:lang="de">V.07.01  Außenwirtschaftstheorie</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12184-4">
    <skos:altLabel xml:lang="de">GmbH und Stille Gesellschaft</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18195-4">
    <skos:prefLabel xml:lang="en">Tropical commodity</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18195-4">
    <skos:prefLabel xml:lang="de">Tropisches Produkt</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11934-6">
    <skos:related rdf:resource="descriptor/13590-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11934-6">
    <skos:related rdf:resource="descriptor/11834-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10548-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12304-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12788-0">
    <skos:related rdf:resource="descriptor/10964-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12788-0">
    <skos:related rdf:resource="descriptor/21408-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13007-0">
    <skos:related rdf:resource="descriptor/14824-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13007-0">
    <skos:related rdf:resource="descriptor/13053-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13309-5">
    <skos:broader rdf:resource="thsys/70944"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13309-5">
    <skos:broader rdf:resource="thsys/70245"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13309-5">
    <skos:broader rdf:resource="descriptor/13306-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20497-1">
    <skos:related rdf:resource="descriptor/15836-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20497-1">
    <skos:related rdf:resource="descriptor/16566-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20497-1">
    <skos:related rdf:resource="descriptor/21306-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11521-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19202-0">
    <skos:scopeNote xml:lang="de">Zeitliche/dynamische Konsistenz bzw. Inkonsistenz von beabsichtigten Handlungen vor allem wirtschaftspolitischer Entscheidungsträger.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13731-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14353-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13773-1">
    <skos:related rdf:resource="descriptor/13693-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15940-5">
    <skos:prefLabel xml:lang="en">Family statistics</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15940-5">
    <skos:prefLabel xml:lang="de">Familienstatistik</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15078-2">
    <skos:prefLabel xml:lang="en">Price index for external trade</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15078-2">
    <skos:prefLabel xml:lang="de">Außenhandelspreisindex</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73380">
    <rdfs:label xml:lang="de">Regierung und öffentliche Verwaltung</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17255-3">
    <skos:prefLabel xml:lang="en">France</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17255-3">
    <skos:prefLabel xml:lang="de">Frankreich</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14537-1">
    <skos:narrower rdf:resource="descriptor/18251-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14537-1">
    <skos:narrower rdf:resource="descriptor/14527-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17642-3">
    <skos:related rdf:resource="descriptor/19718-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17642-3">
    <skos:related rdf:resource="descriptor/17992-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17642-3">
    <skos:related rdf:resource="descriptor/17977-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16023-1">
    <skos:related rdf:resource="descriptor/12979-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16023-1">
    <skos:related rdf:resource="descriptor/18379-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16023-1">
    <skos:related rdf:resource="descriptor/14188-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16023-1">
    <skos:related rdf:resource="descriptor/18261-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16023-1">
    <skos:related rdf:resource="descriptor/13329-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16023-1">
    <skos:related rdf:resource="descriptor/15730-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11354-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13002-3">
    <skos:related rdf:resource="descriptor/14728-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13002-3">
    <skos:related rdf:resource="descriptor/19785-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13002-3">
    <skos:related rdf:resource="descriptor/13193-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13002-3">
    <skos:related rdf:resource="descriptor/18259-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13002-3">
    <skos:related rdf:resource="descriptor/19675-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13407-5">
    <skos:altLabel xml:lang="de">Vertretung fremder Staaten</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13407-5">
    <skos:altLabel xml:lang="de">Konsulat</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13407-5">
    <skos:altLabel xml:lang="de">Diplomatische Vertretung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13407-5">
    <skos:altLabel xml:lang="de">Botschaft im Ausland</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13407-5">
    <skos:altLabel xml:lang="de">Auswärtiger Dienst</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73336">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11931-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70875">
    <skos:prefLabel xml:lang="de">W.21.01  Beratungsdienstleistungen</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19186-0">
    <skos:related rdf:resource="descriptor/19062-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19186-0">
    <skos:related rdf:resource="descriptor/13058-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19186-0">
    <skos:related rdf:resource="descriptor/14381-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13385-3">
    <skos:related rdf:resource="descriptor/12613-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13385-3">
    <skos:related rdf:resource="descriptor/16328-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12917-1">
    <skos:narrower rdf:resource="descriptor/18404-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12917-1">
    <skos:narrower rdf:resource="descriptor/18389-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19052-0">
    <skos:related rdf:resource="descriptor/14435-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19052-0">
    <skos:related rdf:resource="descriptor/14434-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12994-4">
    <skos:broader rdf:resource="thsys/70994"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12994-4">
    <skos:broader rdf:resource="descriptor/12996-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13164-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11818-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13142-1">
    <skos:related rdf:resource="descriptor/19391-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13142-1">
    <skos:related rdf:resource="descriptor/13232-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13142-1">
    <skos:related rdf:resource="descriptor/14833-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13142-1">
    <skos:related rdf:resource="descriptor/13137-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13142-1">
    <skos:related rdf:resource="descriptor/13904-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13142-1">
    <skos:related rdf:resource="descriptor/13004-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13142-1">
    <skos:related rdf:resource="descriptor/13128-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12750-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16173-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18207-2">
    <skos:prefLabel xml:lang="en">Company magazine</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18207-2">
    <skos:prefLabel xml:lang="de">Betriebszeitschrift</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16426-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19333-6">
    <skos:related rdf:resource="descriptor/10781-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18020-4">
    <skos:related rdf:resource="descriptor/18004-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19133-0">
    <skos:broader rdf:resource="thsys/73384"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19133-0">
    <skos:broader rdf:resource="thsys/70292"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11590-5">
    <skos:broader rdf:resource="thsys/73367"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11590-5">
    <skos:broader rdf:resource="thsys/71081"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11590-5">
    <skos:broader rdf:resource="thsys/71064"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11590-5">
    <skos:broader rdf:resource="descriptor/11595-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13425-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10348-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14940-3">
    <skos:narrower rdf:resource="descriptor/14942-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14940-3">
    <skos:narrower rdf:resource="descriptor/14941-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18963-6">
    <skos:related rdf:resource="descriptor/18230-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16768-0">
    <skos:altLabel xml:lang="de">Bibliographienkunde</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18943-5">
    <skos:related rdf:resource="descriptor/19475-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18943-5">
    <skos:related rdf:resource="descriptor/10142-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18943-5">
    <skos:related rdf:resource="descriptor/10141-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18943-5">
    <skos:related rdf:resource="descriptor/13345-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18943-5">
    <skos:related rdf:resource="descriptor/16754-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11914-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15662-0">
    <skos:related rdf:resource="descriptor/15759-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15662-0">
    <skos:related rdf:resource="descriptor/15664-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15662-0">
    <skos:related rdf:resource="descriptor/15746-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15662-0">
    <skos:related rdf:resource="descriptor/15633-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19765-5">
    <skos:broader rdf:resource="thsys/73356"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19401-1">
    <skos:broader rdf:resource="thsys/71077"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18944-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11909-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13420-6">
    <skos:narrower rdf:resource="descriptor/16318-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13420-6">
    <skos:narrower rdf:resource="descriptor/15974-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13420-6">
    <skos:narrower rdf:resource="descriptor/16300-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13420-6">
    <skos:narrower rdf:resource="descriptor/19713-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13420-6">
    <skos:narrower rdf:resource="descriptor/19228-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13420-6">
    <skos:narrower rdf:resource="descriptor/19709-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18633-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19676-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14122-2">
    <skos:narrower rdf:resource="descriptor/18219-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14122-2">
    <skos:narrower rdf:resource="descriptor/19021-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14122-2">
    <skos:narrower rdf:resource="descriptor/18220-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14122-2">
    <skos:narrower rdf:resource="descriptor/18218-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13409-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11740-5">
    <skos:related rdf:resource="descriptor/12057-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11740-5">
    <skos:related rdf:resource="descriptor/19761-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11740-5">
    <skos:related rdf:resource="descriptor/11739-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11740-5">
    <skos:related rdf:resource="descriptor/10282-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10028-0">
    <skos:prefLabel xml:lang="en">Value added</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10028-0">
    <skos:prefLabel xml:lang="de">Wertschöpfung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13400-5">
    <skos:prefLabel xml:lang="en">Environmental organization</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13400-5">
    <skos:prefLabel xml:lang="de">Umweltorganisation</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14261-2">
    <skos:altLabel xml:lang="de">Weißblech</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14261-2">
    <skos:altLabel xml:lang="de">Stahlblech</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14261-2">
    <skos:altLabel xml:lang="de">Feinblech</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14261-2">
    <skos:altLabel xml:lang="de">Eisenblech</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71063">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17990-1">
    <skos:related rdf:resource="descriptor/17931-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17990-1">
    <skos:related rdf:resource="descriptor/17791-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17990-1">
    <skos:related rdf:resource="descriptor/17989-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17990-1">
    <skos:related rdf:resource="descriptor/19170-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70561">
    <skos:notation rdf:datatype="http://www.w3.org/2001/XMLSchema#string">G.02.03</skos:notation>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70397">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18815-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10038-4">
    <skos:altLabel xml:lang="de">Sichere Erwartung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10038-4">
    <skos:altLabel xml:lang="de">Erwartungshypothese</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10038-4">
    <skos:altLabel xml:lang="de">Erwartungsbildung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12807-1">
    <skos:prefLabel xml:lang="en">Product life cycle</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12807-1">
    <skos:prefLabel xml:lang="de">Produktlebenszyklus</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10269-6">
    <skos:prefLabel xml:lang="en">National income</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10269-6">
    <skos:prefLabel xml:lang="de">Volkseinkommen</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19501-4">
    <skos:broader rdf:resource="thsys/70278"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12849-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13355-5">
    <skos:altLabel xml:lang="de">Unterhaltungskünstlerinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13355-5">
    <skos:altLabel xml:lang="de">Unterhaltungskünstler</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13355-5">
    <skos:altLabel xml:lang="de">Schauspielerinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13355-5">
    <skos:altLabel xml:lang="de">Schauspieler</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13355-5">
    <skos:altLabel xml:lang="de">Sängerinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13355-5">
    <skos:altLabel xml:lang="de">Sänger</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13355-5">
    <skos:altLabel xml:lang="de">Pop-Sängerinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13355-5">
    <skos:altLabel xml:lang="de">Pop-Sänger</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13355-5">
    <skos:altLabel xml:lang="de">Musikerinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13355-5">
    <skos:altLabel xml:lang="de">Musiker</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13355-5">
    <skos:altLabel xml:lang="de">Kunstmalerinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13355-5">
    <skos:altLabel xml:lang="de">Kunstmaler</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13355-5">
    <skos:altLabel xml:lang="de">Künstlerinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13355-5">
    <skos:altLabel xml:lang="de">Künstler</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13355-5">
    <skos:altLabel xml:lang="de">Kreative Berufe</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13355-5">
    <skos:altLabel xml:lang="de">Komponistinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13355-5">
    <skos:altLabel xml:lang="de">Komponisten</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13355-5">
    <skos:altLabel xml:lang="de">Graphikerinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13355-5">
    <skos:altLabel xml:lang="de">Graphiker</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13355-5">
    <skos:altLabel xml:lang="de">Grafikerinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13355-5">
    <skos:altLabel xml:lang="de">Grafiker</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13355-5">
    <skos:altLabel xml:lang="de">Freischaffende Künstlerinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13355-5">
    <skos:altLabel xml:lang="de">Freischaffende Künstler</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13355-5">
    <skos:altLabel xml:lang="de">Bühnenkünstlerinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13355-5">
    <skos:altLabel xml:lang="de">Bühnenkünstler</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13355-5">
    <skos:altLabel xml:lang="de">Bildende Künstlerinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13355-5">
    <skos:altLabel xml:lang="de">Bildende Künstler</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13852-5">
    <skos:related rdf:resource="descriptor/12031-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13852-5">
    <skos:related rdf:resource="descriptor/12905-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13852-5">
    <skos:related rdf:resource="descriptor/13853-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13852-5">
    <skos:related rdf:resource="descriptor/18506-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14793-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18727-4">
    <skos:related rdf:resource="descriptor/11441-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11735-5">
    <skos:broader rdf:resource="thsys/71114"/>
  </rdf:Description>
  <rdf:Description rdf:about="http://www.w3.org/2004/02/skos/core#hiddenLabel">
    <rdfs:isDefinedBy rdf:resource="http://www.w3.org/2004/02/skos/core"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19661-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71091">
    <skos:narrower rdf:resource="descriptor/10847-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71091">
    <skos:narrower rdf:resource="descriptor/13509-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71091">
    <skos:narrower rdf:resource="descriptor/10675-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71091">
    <skos:narrower rdf:resource="descriptor/11125-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71091">
    <skos:narrower rdf:resource="descriptor/10882-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71091">
    <skos:narrower rdf:resource="descriptor/19357-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71091">
    <skos:narrower rdf:resource="descriptor/10877-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71091">
    <skos:narrower rdf:resource="descriptor/10843-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71091">
    <skos:narrower rdf:resource="descriptor/18126-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71091">
    <skos:narrower rdf:resource="descriptor/10656-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71091">
    <skos:narrower rdf:resource="descriptor/19356-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71091">
    <skos:narrower rdf:resource="descriptor/10838-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71091">
    <skos:narrower rdf:resource="descriptor/19316-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71091">
    <skos:narrower rdf:resource="descriptor/18437-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71091">
    <skos:narrower rdf:resource="descriptor/20817-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71091">
    <skos:narrower rdf:resource="descriptor/10865-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71091">
    <skos:narrower rdf:resource="descriptor/10836-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71091">
    <skos:narrower rdf:resource="descriptor/10604-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71091">
    <skos:narrower rdf:resource="descriptor/18544-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71091">
    <skos:narrower rdf:resource="descriptor/10852-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71091">
    <skos:narrower rdf:resource="descriptor/19355-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71091">
    <skos:narrower rdf:resource="descriptor/15078-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71091">
    <skos:narrower rdf:resource="descriptor/10834-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71091">
    <skos:narrower rdf:resource="descriptor/10686-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71091">
    <skos:narrower rdf:resource="descriptor/18534-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71091">
    <skos:narrower rdf:resource="descriptor/10854-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71091">
    <skos:narrower rdf:resource="descriptor/10833-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71091">
    <skos:narrower rdf:resource="descriptor/18008-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="http://www.w3.org/2004/02/skos/core#notation">
    <rdfs:comment xml:lang="en">By convention, skos:notation is used with a typed literal in the
      object position of the triple.</rdfs:comment>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/19655-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/12587-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/11281-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/12575-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/12155-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/19112-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/12565-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/19007-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/12585-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/12589-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/12563-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/19001-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/12574-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/12562-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/12573-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/12572-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/12571-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/19009-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/19008-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/15839-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/19002-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/11052-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/11203-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/10261-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/11191-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/18070-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/12580-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/12588-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/12314-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/15825-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/12570-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/18143-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/21306-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/19005-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/18207-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/12577-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/15842-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/18885-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/11365-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/11288-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/19656-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/11384-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/11358-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/12569-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/15837-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/25881-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/18140-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/11184-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/11306-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/11303-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:narrower rdf:resource="descriptor/19003-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13383-0">
    <skos:prefLabel xml:lang="en">Opinion polls</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13383-0">
    <skos:prefLabel xml:lang="de">Meinungsforschung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15801-5">
    <skos:prefLabel xml:lang="en">Motivation</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15801-5">
    <skos:prefLabel xml:lang="de">Motivation</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18371-3">
    <skos:prefLabel xml:lang="en">Natural gas policy</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18371-3">
    <skos:prefLabel xml:lang="de">Erdgaspolitik</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12783-3">
    <skos:prefLabel xml:lang="en">Trade fair</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12783-3">
    <skos:prefLabel xml:lang="de">Messe</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18985-3">
    <skos:related rdf:resource="descriptor/18984-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18985-3">
    <skos:related rdf:resource="descriptor/12024-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18985-3">
    <skos:related rdf:resource="descriptor/19054-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11105-3">
    <skos:altLabel xml:lang="en">Transitional society</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11105-3">
    <skos:altLabel xml:lang="de">Übergangsgesellschaft</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15714-0">
    <skos:related rdf:resource="descriptor/15717-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15714-0">
    <skos:related rdf:resource="descriptor/16615-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15714-0">
    <skos:related rdf:resource="descriptor/15712-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15714-0">
    <skos:related rdf:resource="descriptor/16650-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15714-0">
    <skos:related rdf:resource="descriptor/15659-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15714-0">
    <skos:related rdf:resource="descriptor/10984-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15714-0">
    <skos:related rdf:resource="descriptor/15472-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15714-0">
    <skos:related rdf:resource="descriptor/12119-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15714-0">
    <skos:related rdf:resource="descriptor/15909-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18280-6">
    <skos:broader rdf:resource="thsys/73344"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18280-6">
    <skos:broader rdf:resource="thsys/70201"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18664-2">
    <zbwext:useInsteadNote rdf:nodeID="id340"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11411-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18900-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10455-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70239">
    <skos:broader rdf:resource="thsys/70209"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71006">
    <skos:narrower rdf:resource="descriptor/14317-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71006">
    <skos:narrower rdf:resource="descriptor/18394-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71006">
    <skos:narrower rdf:resource="descriptor/19182-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71006">
    <skos:narrower rdf:resource="descriptor/19387-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71006">
    <skos:narrower rdf:resource="descriptor/19181-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71006">
    <skos:narrower rdf:resource="descriptor/18372-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71006">
    <skos:narrower rdf:resource="descriptor/12984-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71006">
    <skos:narrower rdf:resource="descriptor/18393-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71006">
    <skos:narrower rdf:resource="descriptor/19047-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71006">
    <skos:narrower rdf:resource="descriptor/19386-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71006">
    <skos:narrower rdf:resource="descriptor/19385-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71006">
    <skos:narrower rdf:resource="descriptor/12983-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18124-6">
    <skos:prefLabel xml:lang="en">Long-term unemployment</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18124-6">
    <skos:prefLabel xml:lang="de">Langzeitarbeitslosigkeit</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/24663-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id138">
    <rdfs:seeAlso rdf:resource="descriptor/18502-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18789-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13001-5">
    <skos:broader rdf:resource="thsys/70992"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13001-5">
    <skos:broader rdf:resource="descriptor/12920-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13001-5">
    <skos:broader rdf:resource="descriptor/12995-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19678-0">
    <skos:related rdf:resource="descriptor/18649-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19678-0">
    <skos:related rdf:resource="descriptor/12010-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19678-0">
    <skos:related rdf:resource="descriptor/19431-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19678-0">
    <skos:related rdf:resource="descriptor/24662-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19678-0">
    <skos:related rdf:resource="descriptor/12975-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12064-0">
    <skos:altLabel xml:lang="de">Privatunternehmen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12064-0">
    <skos:altLabel xml:lang="de">Privatsektor</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12064-0">
    <skos:altLabel xml:lang="de">Privates Unternehmen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12064-0">
    <skos:altLabel xml:lang="de">Privater Sektor</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13421-4">
    <skos:scopeNote xml:lang="de">Mitgliedstaaten eines Bundesstaates.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70538">
    <skos:narrower rdf:resource="descriptor/18234-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70538">
    <skos:narrower rdf:resource="descriptor/14184-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70538">
    <skos:narrower rdf:resource="descriptor/14215-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70538">
    <skos:narrower rdf:resource="descriptor/14603-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70538">
    <skos:narrower rdf:resource="descriptor/18235-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70538">
    <skos:narrower rdf:resource="descriptor/14177-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70538">
    <skos:narrower rdf:resource="descriptor/14176-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70538">
    <skos:narrower rdf:resource="descriptor/14175-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70538">
    <skos:narrower rdf:resource="descriptor/14174-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70538">
    <skos:narrower rdf:resource="descriptor/14173-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70538">
    <skos:narrower rdf:resource="thsys/70651"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70538">
    <skos:narrower rdf:resource="thsys/70649"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70538">
    <skos:narrower rdf:resource="thsys/70650"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70538">
    <skos:narrower rdf:resource="thsys/70648"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14792-6">
    <skos:related rdf:resource="descriptor/14788-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16112-2">
    <skos:narrower rdf:resource="descriptor/10830-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16112-2">
    <skos:narrower rdf:resource="descriptor/10845-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15437-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19618-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13979-2">
    <skos:related rdf:resource="descriptor/13264-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13979-2">
    <skos:related rdf:resource="descriptor/13510-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13979-2">
    <skos:related rdf:resource="descriptor/11559-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12949-2">
    <skos:related rdf:resource="descriptor/14074-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12949-2">
    <skos:related rdf:resource="descriptor/14073-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12949-2">
    <skos:related rdf:resource="descriptor/13434-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12949-2">
    <skos:related rdf:resource="descriptor/13452-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="http://www.w3.org/2004/02/skos/core#memberList">
    <rdf:type rdf:resource="http://www.w3.org/1999/02/22-rdf-syntax-ns#Property"/>
  </rdf:Description>
  <rdf:Description rdf:about="http://www.w3.org/2004/02/skos/core#memberList">
    <rdf:type rdf:resource="http://www.w3.org/2002/07/owl#FunctionalProperty"/>
  </rdf:Description>
  <rdf:Description rdf:about="http://www.w3.org/2004/02/skos/core#memberList">
    <rdf:type rdf:resource="http://www.w3.org/2002/07/owl#ObjectProperty"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10831-0">
    <skos:related rdf:resource="descriptor/11709-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10831-0">
    <skos:related rdf:resource="descriptor/10830-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10831-0">
    <skos:related rdf:resource="descriptor/10817-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10831-0">
    <skos:related rdf:resource="descriptor/10829-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10831-0">
    <skos:related rdf:resource="descriptor/12446-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10831-0">
    <skos:related rdf:resource="descriptor/12872-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10831-0">
    <skos:related rdf:resource="descriptor/10826-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10831-0">
    <skos:related rdf:resource="descriptor/10827-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10256-1">
    <skos:broader rdf:resource="thsys/70233"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10256-1">
    <skos:broader rdf:resource="descriptor/10249-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19832-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id373">
    <rdfs:seeAlso rdf:resource="descriptor/10414-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20977-1">
    <skos:scopeNote xml:lang="de">Bildung von organisatorischen Einheiten nach dem Prinzip sich ergänzender Grundbausteine, die nach Bedarf unterschiedlich kombiniert werden können.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71101">
    <rdfs:label xml:lang="en">Centrally planned economy</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71101">
    <rdfs:label xml:lang="de">Planwirtschaft</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12770-5">
    <skos:altLabel xml:lang="de">Strategische Marketingplanung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12770-5">
    <skos:altLabel xml:lang="de">Marketingstrategie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12770-5">
    <skos:altLabel xml:lang="de">Marketingplanung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12770-5">
    <skos:altLabel xml:lang="de">Marketing-Mix</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12770-5">
    <skos:altLabel xml:lang="de">Marketingkonzeption</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12770-5">
    <skos:altLabel xml:lang="de">Kommunikationsstrategie (Marketing)</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12770-5">
    <skos:altLabel xml:lang="de">Kommunikationspolitik (Marketing)</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19718-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11681-2">
    <skos:broader rdf:resource="thsys/71074"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11681-2">
    <skos:broader rdf:resource="descriptor/11661-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11637-5">
    <skos:broader rdf:resource="thsys/71077"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11637-5">
    <skos:broader rdf:resource="descriptor/11526-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71069">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14070-2">
    <skos:prefLabel xml:lang="en">Oil Seed Plant</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14070-2">
    <skos:prefLabel xml:lang="de">Ölpflanze</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14631-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12251-1">
    <skos:editorialNote xml:lang="de">Möglichst spezifischer indexieren.</skos:editorialNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10558-6">
    <skos:related rdf:resource="descriptor/11886-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10558-6">
    <skos:related rdf:resource="descriptor/10589-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10558-6">
    <skos:related rdf:resource="descriptor/13395-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10558-6">
    <skos:related rdf:resource="descriptor/10618-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10558-6">
    <skos:related rdf:resource="descriptor/16439-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10558-6">
    <skos:related rdf:resource="descriptor/10560-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10558-6">
    <skos:related rdf:resource="descriptor/10555-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10558-6">
    <skos:related rdf:resource="descriptor/10552-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10558-6">
    <skos:related rdf:resource="descriptor/10550-1"/>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id21">
    <rdfs:seeAlso rdf:resource="descriptor/12501-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14674-5">
    <skos:prefLabel xml:lang="en">Epoxyde</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14674-5">
    <skos:prefLabel xml:lang="de">Epoxid</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18266-0">
    <skos:prefLabel xml:lang="en">Insecticide</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18266-0">
    <skos:prefLabel xml:lang="de">Insektizid</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18438-4">
    <skos:related rdf:resource="descriptor/18382-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70259">
    <skos:prefLabel xml:lang="en">V.05.05  Credit</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70259">
    <skos:prefLabel xml:lang="de">V.05.05  Kredit</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18521-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10085-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11968-3">
    <skos:broader rdf:resource="thsys/71064"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11968-3">
    <skos:broader rdf:resource="descriptor/11970-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15010-1">
    <skos:broader rdf:resource="thsys/70238"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15010-1">
    <skos:broader rdf:resource="thsys/70161"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15010-1">
    <skos:broader rdf:resource="descriptor/15743-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15010-1">
    <skos:broader rdf:resource="descriptor/15009-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17937-5">
    <skos:prefLabel xml:lang="en">Fiji</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17937-5">
    <skos:prefLabel xml:lang="de">Fidschi</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17496-2">
    <skos:prefLabel xml:lang="en">Kazakhstan</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17496-2">
    <skos:prefLabel xml:lang="de">Kasachstan</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19707-5">
    <skos:related rdf:resource="descriptor/15676-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19707-5">
    <skos:related rdf:resource="descriptor/19775-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/21072-0">
    <skos:prefLabel xml:lang="en">Insurance coverage</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/21072-0">
    <skos:prefLabel xml:lang="de">Versicherungsschutz</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10619-5">
    <skos:related rdf:resource="descriptor/10626-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10619-5">
    <skos:related rdf:resource="descriptor/10625-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10619-5">
    <skos:related rdf:resource="descriptor/10624-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10619-5">
    <skos:related rdf:resource="descriptor/18064-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10619-5">
    <skos:related rdf:resource="descriptor/10586-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10619-5">
    <skos:related rdf:resource="descriptor/10618-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10619-5">
    <skos:related rdf:resource="descriptor/10617-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10619-5">
    <skos:related rdf:resource="descriptor/10682-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18360-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16783-4">
    <skos:altLabel xml:lang="de">Bibliotheksunterricht</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16783-4">
    <skos:altLabel xml:lang="de">Benutzerverhalten in Bibliotheken</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16783-4">
    <skos:altLabel xml:lang="de">Benutzerschulung in Bibliotheken</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13701-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12230-2">
    <skos:prefLabel xml:lang="en">Security analysis</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12230-2">
    <skos:prefLabel xml:lang="de">Wertpapieranalyse</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19860-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14302-0">
    <skos:broader rdf:resource="thsys/70134"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14302-0">
    <skos:broader rdf:resource="descriptor/14266-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10126-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16374-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19626-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10462-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10470-6">
    <skos:related rdf:resource="descriptor/10473-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10470-6">
    <skos:related rdf:resource="descriptor/10472-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10470-6">
    <skos:related rdf:resource="descriptor/10471-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10470-6">
    <skos:related rdf:resource="descriptor/10466-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10470-6">
    <skos:related rdf:resource="descriptor/13962-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10470-6">
    <skos:related rdf:resource="descriptor/16695-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10470-6">
    <skos:related rdf:resource="descriptor/10465-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10470-6">
    <skos:related rdf:resource="descriptor/16696-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10470-6">
    <skos:related rdf:resource="descriptor/15664-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10470-6">
    <skos:related rdf:resource="descriptor/19795-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10470-6">
    <skos:related rdf:resource="descriptor/10437-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15392-3">
    <skos:broader rdf:resource="thsys/72183"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15392-3">
    <skos:broader rdf:resource="descriptor/15396-2"/>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id125">
    <rdf:value xml:lang="de">Für menschliche Grundrechte im internationalen Recht</rdf:value>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70415">
    <rdfs:label xml:lang="de">Wasserfahrzeuge</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12391-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11658-4">
    <skos:prefLabel xml:lang="en">Real estate transfer tax</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11658-4">
    <skos:prefLabel xml:lang="de">Grunderwerbsteuer</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17632-6">
    <skos:broader rdf:resource="thsys/70253"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17632-6">
    <skos:broader rdf:resource="descriptor/17608-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17632-6">
    <skos:broader rdf:resource="descriptor/17978-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12794-5">
    <skos:prefLabel xml:lang="en">Pricing behaviour of firms</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12794-5">
    <skos:prefLabel xml:lang="de">Betriebliche Preispolitik</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11237-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10106-6">
    <skos:altLabel xml:lang="en">Social choice function</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10106-6">
    <skos:altLabel xml:lang="de">Soziale Präferenzordnung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10106-6">
    <skos:altLabel xml:lang="de">Soziale Präferenzen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10106-6">
    <skos:altLabel xml:lang="de">Kollektive Wohlfahrtsfunktion</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10106-6">
    <skos:altLabel xml:lang="de">Kollektive Präferenzordnung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10106-6">
    <skos:altLabel xml:lang="de">Kollektive Nutzenfunktion</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10106-6">
    <skos:altLabel xml:lang="de">Gesellschaftliche Wohlfahrtsfunktion</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10106-6">
    <skos:altLabel xml:lang="de">Gesellschaftliche Präferenzordnung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15635-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15498-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16717-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13824-3">
    <skos:altLabel xml:lang="de">Versicherungstarif</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13824-3">
    <skos:altLabel xml:lang="de">Versicherungsbeitrag</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13824-3">
    <skos:altLabel xml:lang="de">Prämie für Versicherungen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13824-3">
    <skos:altLabel xml:lang="de">Beitrag für Versicherungen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12164-3">
    <skos:broader rdf:resource="thsys/70383"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70856">
    <skos:narrower rdf:resource="descriptor/18837-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70856">
    <skos:narrower rdf:resource="descriptor/18097-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70856">
    <skos:narrower rdf:resource="descriptor/18836-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70856">
    <skos:narrower rdf:resource="descriptor/12047-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70856">
    <skos:narrower rdf:resource="descriptor/18835-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70856">
    <skos:narrower rdf:resource="descriptor/18834-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70856">
    <skos:narrower rdf:resource="descriptor/18833-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70856">
    <skos:narrower rdf:resource="descriptor/18830-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70856">
    <skos:narrower rdf:resource="descriptor/18831-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70856">
    <skos:narrower rdf:resource="thsys/70855"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70856">
    <skos:narrower rdf:resource="thsys/70853"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13571-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11433-0">
    <skos:related rdf:resource="descriptor/11459-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11433-0">
    <skos:related rdf:resource="descriptor/18698-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11433-0">
    <skos:related rdf:resource="descriptor/13776-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11433-0">
    <skos:related rdf:resource="descriptor/12251-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15716-3">
    <skos:prefLabel xml:lang="en">Social mobility</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15716-3">
    <skos:prefLabel xml:lang="de">Soziale Mobilität</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11582-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16191-1">
    <skos:broader rdf:resource="thsys/73334"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16191-1">
    <skos:broader rdf:resource="descriptor/16201-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18350-4">
    <skos:related rdf:resource="descriptor/12975-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18350-4">
    <skos:related rdf:resource="descriptor/14176-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18350-4">
    <skos:related rdf:resource="descriptor/19487-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18350-4">
    <skos:related rdf:resource="descriptor/11810-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18350-4">
    <skos:related rdf:resource="descriptor/18996-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18350-4">
    <skos:related rdf:resource="descriptor/18989-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18350-4">
    <skos:related rdf:resource="descriptor/18348-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18350-4">
    <skos:related rdf:resource="descriptor/14175-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17578-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17586-1">
    <skos:broader rdf:resource="thsys/70327"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17586-1">
    <skos:broader rdf:resource="descriptor/17589-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17586-1">
    <skos:broader rdf:resource="descriptor/17979-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70876">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13312-2">
    <skos:related rdf:resource="descriptor/13849-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13312-2">
    <skos:related rdf:resource="descriptor/13829-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13312-2">
    <skos:related rdf:resource="descriptor/18180-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13312-2">
    <skos:related rdf:resource="descriptor/18907-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13312-2">
    <skos:related rdf:resource="descriptor/14007-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13312-2">
    <skos:related rdf:resource="descriptor/18864-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18140-1">
    <skos:prefLabel xml:lang="en">Job search</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18140-1">
    <skos:prefLabel xml:lang="de">Arbeitsuche</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12046-2">
    <skos:scopeNote xml:lang="de">Geschichte einzelner Unternehmen.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13671-2">
    <skos:prefLabel xml:lang="en">Office automation</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13671-2">
    <skos:prefLabel xml:lang="de">Bürokommunikation</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19470-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10178-2">
    <skos:broader rdf:resource="thsys/71112"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10178-2">
    <skos:broader rdf:resource="thsys/70493"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10178-2">
    <skos:broader rdf:resource="descriptor/10301-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12665-2">
    <skos:broader rdf:resource="thsys/73384"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12665-2">
    <skos:broader rdf:resource="thsys/70368"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12665-2">
    <skos:broader rdf:resource="descriptor/12036-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11939-3">
    <skos:prefLabel xml:lang="en">Gemeinschaftsaufgabe Regionale Wirtschaftsstruktur</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11939-3">
    <skos:prefLabel xml:lang="de">Gemeinschaftsaufgabe Regionale Wirtschaftsstruktur</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12592-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14803-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="http://www.w3.org/2004/02/skos/core#broader">
    <rdfs:subPropertyOf rdf:resource="http://www.w3.org/2004/02/skos/core#broaderTransitive"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19340-2">
    <skos:related rdf:resource="descriptor/19347-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19340-2">
    <skos:related rdf:resource="descriptor/12955-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19340-2">
    <skos:related rdf:resource="descriptor/13155-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19340-2">
    <skos:related rdf:resource="descriptor/13940-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19340-2">
    <skos:related rdf:resource="descriptor/14122-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12284-0">
    <skos:prefLabel xml:lang="en">Capital increase</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12284-0">
    <skos:prefLabel xml:lang="de">Kapitalerhöhung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18345-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14033-1">
    <skos:prefLabel xml:lang="en">DIY-product</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14033-1">
    <skos:prefLabel xml:lang="de">Heimwerkerartikel</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13006-2">
    <skos:prefLabel xml:lang="en">Plastic products industry</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13006-2">
    <skos:prefLabel xml:lang="de">Kunststoffverarbeitung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18979-5">
    <skos:broader rdf:resource="thsys/71020"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18979-5">
    <skos:broader rdf:resource="thsys/70867"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18979-5">
    <skos:broader rdf:resource="descriptor/18810-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20241-1">
    <skos:prefLabel xml:lang="en">Virtual enterprise</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20241-1">
    <skos:prefLabel xml:lang="de">Virtuelles Unternehmen</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19751-2">
    <skos:prefLabel xml:lang="en">Self-organization</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19751-2">
    <skos:prefLabel xml:lang="de">Selbstorganisation</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13731-3">
    <skos:related rdf:resource="descriptor/16080-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13731-3">
    <skos:related rdf:resource="descriptor/13742-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13731-3">
    <skos:related rdf:resource="descriptor/19321-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13731-3">
    <skos:related rdf:resource="descriptor/16050-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13731-3">
    <skos:related rdf:resource="descriptor/13723-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13731-3">
    <skos:related rdf:resource="descriptor/13693-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14735-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15775-1">
    <skos:altLabel xml:lang="en">Environmental impact assessment</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15775-1">
    <skos:altLabel xml:lang="de">UVP (Umweltverträglichkeitsprüfung)</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15775-1">
    <skos:altLabel xml:lang="de">Umweltverträglichkeitsprüfung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15767-0">
    <skos:scopeNote xml:lang="de">Abwägung von (sozialen) Kosten und Nutzen der Umweltnutzung. Zielkonflikte zwischen Wirtschaftswachstum und Umweltbelastung. Analyse der Allokationswirkungen verschiedener umweltpolitischer Instrumente.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18382-5">
    <skos:narrower rdf:resource="descriptor/19181-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16288-0">
    <skos:related rdf:resource="descriptor/16440-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16288-0">
    <skos:related rdf:resource="descriptor/19684-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16288-0">
    <skos:related rdf:resource="descriptor/15719-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16288-0">
    <skos:related rdf:resource="descriptor/16463-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16288-0">
    <skos:related rdf:resource="descriptor/18064-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16288-0">
    <skos:related rdf:resource="descriptor/16286-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16288-0">
    <skos:related rdf:resource="descriptor/16280-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16288-0">
    <skos:related rdf:resource="descriptor/16395-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16288-0">
    <skos:related rdf:resource="descriptor/19715-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16288-0">
    <skos:related rdf:resource="descriptor/16435-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16288-0">
    <skos:related rdf:resource="descriptor/19851-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16288-0">
    <skos:related rdf:resource="descriptor/15878-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16288-0">
    <skos:related rdf:resource="descriptor/16497-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16288-0">
    <skos:related rdf:resource="descriptor/16204-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10612-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18393-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70834">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13207-6">
    <skos:altLabel xml:lang="de">Getränkegroßhandel</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13207-6">
    <skos:altLabel xml:lang="de">Getränkeeinzelhandel</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13207-6">
    <skos:altLabel xml:lang="de">Getränkeabholmarkt</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71114">
    <rdfs:label xml:lang="de">Einkommens- und Vermögensverteilung</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18461-2">
    <skos:prefLabel xml:lang="en">Industrial research</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18461-2">
    <skos:prefLabel xml:lang="de">Industrielle Forschung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10523-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19195-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16950-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13207-6">
    <skos:broader rdf:resource="thsys/70960"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13207-6">
    <skos:broader rdf:resource="descriptor/13219-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15637-6">
    <skos:broader rdf:resource="thsys/73388"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15637-6">
    <skos:broader rdf:resource="descriptor/15671-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11197-0">
    <skos:related rdf:resource="descriptor/18993-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11197-0">
    <skos:related rdf:resource="descriptor/12910-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18652-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14646-3">
    <skos:narrower rdf:resource="descriptor/14045-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14096-5">
    <skos:prefLabel xml:lang="en">Rye</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14096-5">
    <skos:prefLabel xml:lang="de">Roggen</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13766-5">
    <skos:prefLabel xml:lang="en">Swap</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13766-5">
    <skos:prefLabel xml:lang="de">Swap</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12298-3">
    <skos:broader rdf:resource="thsys/70036"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12298-3">
    <skos:broader rdf:resource="descriptor/12296-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19169-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15519-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70995">
    <rdfs:label xml:lang="de">Feinmechanische und Optische Industrie</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15966-1">
    <skos:related rdf:resource="descriptor/15976-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15966-1">
    <skos:related rdf:resource="descriptor/15971-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15966-1">
    <skos:related rdf:resource="descriptor/15970-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15966-1">
    <skos:related rdf:resource="descriptor/15969-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15966-1">
    <skos:related rdf:resource="descriptor/19607-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15966-1">
    <skos:related rdf:resource="descriptor/15968-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15966-1">
    <skos:related rdf:resource="descriptor/13995-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15966-1">
    <skos:related rdf:resource="descriptor/13389-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15966-1">
    <skos:related rdf:resource="descriptor/19841-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15966-1">
    <skos:related rdf:resource="descriptor/16338-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15966-1">
    <skos:related rdf:resource="descriptor/13410-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13873-4">
    <skos:altLabel xml:lang="de">Fischerinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13873-4">
    <skos:altLabel xml:lang="de">Fischer</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71023">
    <skos:broader rdf:resource="thsys/71028"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15927-4">
    <skos:prefLabel xml:lang="en">Men</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15927-4">
    <skos:prefLabel xml:lang="de">Männer</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13983-4">
    <skos:broader rdf:resource="thsys/71055"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13983-4">
    <skos:broader rdf:resource="thsys/70936"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13983-4">
    <skos:broader rdf:resource="descriptor/13979-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12022-2">
    <skos:altLabel xml:lang="en">Ground rent</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12022-2">
    <skos:altLabel xml:lang="de">Grundrente</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18538-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16808-0">
    <skos:narrower rdf:resource="descriptor/16806-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16808-0">
    <skos:narrower rdf:resource="descriptor/16805-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16335-3">
    <skos:scopeNote xml:lang="de">Kontrolle der öffentlichen Verwaltung.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12312-0">
    <skos:altLabel xml:lang="de">Kurzfristige Erfolgsrechnung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12312-0">
    <skos:altLabel xml:lang="de">Betriebsergebnisrechnung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12057-4">
    <skos:broader rdf:resource="thsys/71034"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12057-4">
    <skos:broader rdf:resource="thsys/70049"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18622-4">
    <skos:prefLabel xml:lang="en">Container handling</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18622-4">
    <skos:prefLabel xml:lang="de">Containerumschlag</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19730-3">
    <skos:prefLabel xml:lang="en">Constructivism</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19730-3">
    <skos:prefLabel xml:lang="de">Konstruktivismus</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10195-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12577-6">
    <skos:related rdf:resource="descriptor/12108-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12577-6">
    <skos:related rdf:resource="descriptor/12585-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12577-6">
    <skos:related rdf:resource="descriptor/15839-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12577-6">
    <skos:related rdf:resource="descriptor/11052-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12577-6">
    <skos:related rdf:resource="descriptor/15835-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12577-6">
    <skos:related rdf:resource="descriptor/11192-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12577-6">
    <skos:related rdf:resource="descriptor/15837-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12577-6">
    <skos:related rdf:resource="descriptor/12617-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12577-6">
    <skos:related rdf:resource="descriptor/11314-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12577-6">
    <skos:related rdf:resource="descriptor/11305-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70992">
    <skos:notation rdf:datatype="http://www.w3.org/2001/XMLSchema#string">W.06.01.06.02</skos:notation>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18805-3">
    <skos:narrower rdf:resource="descriptor/18372-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19306-2">
    <skos:broader rdf:resource="thsys/71029"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19306-2">
    <skos:broader rdf:resource="thsys/70960"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19306-2">
    <skos:broader rdf:resource="descriptor/13431-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11233-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70459">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15966-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="http://www.w3.org/2004/02/skos/core#narrower">
    <rdfs:isDefinedBy rdf:resource="http://www.w3.org/2004/02/skos/core"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14703-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15088-6">
    <skos:broader rdf:resource="thsys/72184"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15088-6">
    <skos:broader rdf:resource="thsys/70814"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15088-6">
    <skos:broader rdf:resource="thsys/70504"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15088-6">
    <skos:broader rdf:resource="descriptor/15073-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15088-6">
    <skos:broader rdf:resource="descriptor/15093-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12981-6">
    <skos:prefLabel xml:lang="en">Lignite mining</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12981-6">
    <skos:prefLabel xml:lang="de">Braunkohlenbergbau</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16051-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13072-3">
    <skos:broader rdf:resource="thsys/73297"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13072-3">
    <skos:broader rdf:resource="thsys/70799"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13072-3">
    <skos:broader rdf:resource="descriptor/18424-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19707-5">
    <skos:scopeNote xml:lang="de">Alle politischen Maßnahmen, die an der Sprache von Bevölkerungsgruppen ansetzen</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19453-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19801-6">
    <skos:related rdf:resource="descriptor/19805-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19801-6">
    <skos:related rdf:resource="descriptor/15416-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19801-6">
    <skos:related rdf:resource="descriptor/19651-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19801-6">
    <skos:related rdf:resource="descriptor/14765-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15947-5">
    <skos:broader rdf:resource="thsys/73347"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15947-5">
    <skos:broader rdf:resource="thsys/70573"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15947-5">
    <skos:broader rdf:resource="thsys/70182"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70328">
    <skos:prefLabel xml:lang="de">P.14  Pappe, Papier und Papierprodukte</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70927">
    <skos:notation rdf:datatype="http://www.w3.org/2001/XMLSchema#string">W.12.05.01</skos:notation>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13513-6">
    <skos:scopeNote xml:lang="de">Zu den Verkehrsmitteln zählen auch Nachrichtenverkehrsmittel, Zugtiere, Pipelines, usw.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12801-6">
    <skos:scopeNote xml:lang="de">Für generische Arzneimittel BENUTZE: Generika.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18676-2">
    <skos:scopeNote xml:lang="de">Vorwiegend für Wertpapierbörsen, aber auch für Devisen- und Warenbörsen.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12747-0">
    <skos:broader rdf:resource="thsys/71035"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12747-0">
    <skos:broader rdf:resource="thsys/70029"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12747-0">
    <skos:broader rdf:resource="descriptor/12758-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18374-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13688-6">
    <skos:related rdf:resource="descriptor/19337-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13688-6">
    <skos:related rdf:resource="descriptor/18730-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13688-6">
    <skos:related rdf:resource="descriptor/13692-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13688-6">
    <skos:related rdf:resource="descriptor/13746-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71101">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="http://zbw.eu/namespaces/skos-extensions/indexedItem">
    <skos:definition xml:lang="en">The concept is used as an index term or subject 
    for the resource.</skos:definition>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19314-3">
    <skos:broader rdf:resource="thsys/71098"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19314-3">
    <skos:broader rdf:resource="descriptor/10686-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18610-4">
    <skos:prefLabel xml:lang="en">Public transport policy</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18610-4">
    <skos:prefLabel xml:lang="de">Nahverkehrspolitik</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11239-3">
    <skos:broader rdf:resource="thsys/71061"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11239-3">
    <skos:broader rdf:resource="thsys/70038"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11239-3">
    <skos:broader rdf:resource="descriptor/10987-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12165-1">
    <skos:related rdf:resource="descriptor/12172-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12165-1">
    <skos:related rdf:resource="descriptor/18825-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12165-1">
    <skos:related rdf:resource="descriptor/20921-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12165-1">
    <skos:related rdf:resource="descriptor/12171-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12165-1">
    <skos:related rdf:resource="descriptor/18017-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12165-1">
    <skos:related rdf:resource="descriptor/12039-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70859">
    <skos:narrower rdf:resource="descriptor/18825-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70859">
    <skos:narrower rdf:resource="descriptor/11580-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70859">
    <skos:narrower rdf:resource="descriptor/11589-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70859">
    <skos:narrower rdf:resource="descriptor/18823-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70859">
    <skos:narrower rdf:resource="descriptor/11579-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70859">
    <skos:narrower rdf:resource="descriptor/18835-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70859">
    <skos:narrower rdf:resource="descriptor/18834-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70859">
    <skos:narrower rdf:resource="descriptor/18833-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70859">
    <skos:narrower rdf:resource="descriptor/11576-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13273-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19420-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19081-0">
    <skos:broader rdf:resource="thsys/71046"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19081-0">
    <skos:broader rdf:resource="descriptor/19080-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19417-0">
    <skos:prefLabel xml:lang="en">Securities transaction tax</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19417-0">
    <skos:prefLabel xml:lang="de">Börsenumsatzsteuer</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14479-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19217-1">
    <skos:altLabel xml:lang="de">Intangible Güter</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19217-1">
    <skos:altLabel xml:lang="de">Immaterielles Gut</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19217-1">
    <skos:altLabel xml:lang="de">Immaterielle Güter</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19189-1">
    <skos:broader rdf:resource="thsys/71029"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19189-1">
    <skos:broader rdf:resource="thsys/70960"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19189-1">
    <skos:broader rdf:resource="descriptor/19188-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10629-2">
    <skos:related rdf:resource="descriptor/19356-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10629-2">
    <skos:related rdf:resource="descriptor/10682-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10629-2">
    <skos:related rdf:resource="descriptor/10605-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10629-2">
    <skos:related rdf:resource="descriptor/10686-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15064-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10183-2">
    <skos:prefLabel xml:lang="en">Optimal consumption</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10183-2">
    <skos:prefLabel xml:lang="de">Optimaler Konsum</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12188-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18941-2">
    <skos:altLabel xml:lang="de">Online-Informationsbank</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18941-2">
    <skos:altLabel xml:lang="de">Informations-Datenbank</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18941-2">
    <skos:altLabel xml:lang="de">Informationsbank</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15628-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19568-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14953-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18411-3">
    <skos:altLabel xml:lang="de">Kautschukmaschinenbau</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18411-3">
    <skos:altLabel xml:lang="de">Gummimaschinenbau</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11340-0">
    <skos:related rdf:resource="descriptor/11348-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10912-0">
    <skos:altLabel xml:lang="de">Vertikale Integration</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18557-3">
    <skos:broader rdf:resource="thsys/70239"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18557-3">
    <skos:broader rdf:resource="descriptor/19564-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14461-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id255">
    <rdf:value xml:lang="de">Für die Postdienste allgemein</rdf:value>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73372">
    <skos:narrower rdf:resource="descriptor/10987-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73372">
    <skos:narrower rdf:resource="descriptor/10439-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73372">
    <skos:narrower rdf:resource="descriptor/11779-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73372">
    <skos:narrower rdf:resource="descriptor/18976-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73372">
    <skos:narrower rdf:resource="descriptor/11704-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73372">
    <skos:narrower rdf:resource="descriptor/10978-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73372">
    <skos:narrower rdf:resource="descriptor/10976-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73372">
    <skos:narrower rdf:resource="descriptor/10387-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73372">
    <skos:narrower rdf:resource="descriptor/10438-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73372">
    <skos:narrower rdf:resource="descriptor/10970-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73372">
    <skos:narrower rdf:resource="descriptor/19251-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73372">
    <skos:narrower rdf:resource="descriptor/10382-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73372">
    <skos:narrower rdf:resource="descriptor/11728-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73372">
    <skos:narrower rdf:resource="descriptor/11235-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16440-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14397-5">
    <skos:broader rdf:resource="thsys/70549"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14397-5">
    <skos:broader rdf:resource="descriptor/12693-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70467">
    <skos:prefLabel xml:lang="de">P.01.02  Tierische Produkte</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18905-6">
    <skos:related rdf:resource="descriptor/16017-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18905-6">
    <skos:related rdf:resource="descriptor/16545-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18905-6">
    <skos:related rdf:resource="descriptor/11711-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18905-6">
    <skos:related rdf:resource="descriptor/16401-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19642-0">
    <skos:altLabel xml:lang="en">Non-white population</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19642-0">
    <skos:altLabel xml:lang="en">Coloured people</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19642-0">
    <skos:altLabel xml:lang="de">Farbige</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73393">
    <skos:narrower rdf:resource="descriptor/16732-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73393">
    <skos:narrower rdf:resource="descriptor/15686-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73393">
    <skos:narrower rdf:resource="descriptor/19010-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73393">
    <skos:narrower rdf:resource="descriptor/16727-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73393">
    <skos:narrower rdf:resource="descriptor/15685-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73393">
    <skos:narrower rdf:resource="descriptor/19253-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73393">
    <skos:narrower rdf:resource="descriptor/16730-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73393">
    <skos:narrower rdf:resource="descriptor/16729-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73393">
    <skos:narrower rdf:resource="descriptor/15429-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73393">
    <skos:narrower rdf:resource="descriptor/19746-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73393">
    <skos:narrower rdf:resource="descriptor/19749-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73393">
    <skos:narrower rdf:resource="descriptor/16720-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73393">
    <skos:narrower rdf:resource="descriptor/20022-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73393">
    <skos:narrower rdf:resource="descriptor/19989-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73393">
    <skos:narrower rdf:resource="descriptor/19770-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73393">
    <skos:narrower rdf:resource="descriptor/19219-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73393">
    <skos:narrower rdf:resource="descriptor/16726-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73393">
    <skos:narrower rdf:resource="descriptor/16716-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73393">
    <skos:narrower rdf:resource="descriptor/19744-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73393">
    <skos:narrower rdf:resource="descriptor/19743-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73393">
    <skos:narrower rdf:resource="descriptor/10436-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73393">
    <skos:narrower rdf:resource="descriptor/19741-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73393">
    <skos:narrower rdf:resource="descriptor/19204-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73393">
    <skos:narrower rdf:resource="descriptor/19070-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73393">
    <skos:narrower rdf:resource="descriptor/16745-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73393">
    <skos:narrower rdf:resource="descriptor/19203-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73393">
    <skos:narrower rdf:resource="descriptor/19745-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73393">
    <skos:narrower rdf:resource="descriptor/19742-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19358-4">
    <skos:scopeNote xml:lang="de">Problematik des Schuldendienstes (Zinsen, Tilgung) für Auslandsschulden und Lösungsalternativen.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17668-6">
    <skos:altLabel xml:lang="de">Republik Mauritius</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18996-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10718-3">
    <skos:broader rdf:resource="thsys/71095"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10718-3">
    <skos:broader rdf:resource="descriptor/10722-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15961-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19434-0">
    <skos:broader rdf:resource="thsys/73391"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19434-0">
    <skos:broader rdf:resource="thsys/71071"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19434-0">
    <skos:broader rdf:resource="descriptor/15981-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19434-0">
    <skos:broader rdf:resource="descriptor/16051-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12955-0">
    <skos:narrower rdf:resource="descriptor/12956-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12955-0">
    <skos:narrower rdf:resource="descriptor/12972-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12955-0">
    <skos:narrower rdf:resource="descriptor/12953-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12955-0">
    <skos:narrower rdf:resource="descriptor/12952-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12955-0">
    <skos:narrower rdf:resource="descriptor/12950-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12955-0">
    <skos:narrower rdf:resource="descriptor/12971-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12955-0">
    <skos:narrower rdf:resource="descriptor/12946-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12955-0">
    <skos:narrower rdf:resource="descriptor/12941-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12955-0">
    <skos:narrower rdf:resource="descriptor/12969-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10590-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18747-5">
    <skos:altLabel xml:lang="de">Immobilienökonomie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18747-5">
    <skos:altLabel xml:lang="de">Immobiliengesellschaft</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18747-5">
    <skos:altLabel xml:lang="de">Grundstückswirtschaft</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18747-5">
    <skos:altLabel xml:lang="de">Grundstücks- und Wohnungswirtschaft</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12304-6">
    <skos:prefLabel xml:lang="en">Takeover</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12304-6">
    <skos:prefLabel xml:lang="de">Übernahme</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19483-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11309-1">
    <skos:broader rdf:resource="thsys/70052"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18375-2">
    <skos:broader rdf:resource="thsys/71009"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18375-2">
    <skos:broader rdf:resource="thsys/70979"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18375-2">
    <skos:broader rdf:resource="descriptor/15752-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18375-2">
    <skos:broader rdf:resource="descriptor/11820-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18978-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13775-4">
    <skos:broader rdf:resource="thsys/73392"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13775-4">
    <skos:broader rdf:resource="thsys/71045"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13775-4">
    <skos:broader rdf:resource="thsys/70899"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13775-4">
    <skos:broader rdf:resource="descriptor/12252-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10761-2">
    <skos:prefLabel xml:lang="en">Crawling peg</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10761-2">
    <skos:prefLabel xml:lang="de">Stufenflexibilität</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19774-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12737-3">
    <skos:related rdf:resource="descriptor/15611-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12737-3">
    <skos:related rdf:resource="descriptor/19660-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12470-3">
    <skos:related rdf:resource="descriptor/12208-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12470-3">
    <skos:related rdf:resource="descriptor/12514-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12470-3">
    <skos:related rdf:resource="descriptor/12053-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13643-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17161-5">
    <skos:broader rdf:resource="thsys/70131"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17161-5">
    <skos:broader rdf:resource="descriptor/17016-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17161-5">
    <skos:broader rdf:resource="descriptor/17991-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17161-5">
    <skos:broader rdf:resource="descriptor/17983-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16326-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14169-4">
    <skos:prefLabel xml:lang="en">Animal</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14169-4">
    <skos:prefLabel xml:lang="de">Tier</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12913-2">
    <skos:related rdf:resource="descriptor/15103-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12913-2">
    <skos:related rdf:resource="descriptor/16692-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12913-2">
    <skos:related rdf:resource="descriptor/10007-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12913-2">
    <skos:related rdf:resource="descriptor/11820-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12913-2">
    <skos:related rdf:resource="descriptor/15019-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12913-2">
    <skos:related rdf:resource="descriptor/18488-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12913-2">
    <skos:related rdf:resource="descriptor/15703-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12913-2">
    <skos:related rdf:resource="descriptor/12051-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12913-2">
    <skos:related rdf:resource="descriptor/10500-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11438-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11807-6">
    <skos:altLabel xml:lang="de">Fischwirtschaftspolitik</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19840-3">
    <skos:related rdf:resource="descriptor/18314-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19840-3">
    <skos:related rdf:resource="descriptor/15889-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19840-3">
    <skos:related rdf:resource="descriptor/10583-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19840-3">
    <skos:related rdf:resource="descriptor/10495-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19840-3">
    <skos:related rdf:resource="descriptor/10488-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14204-0">
    <skos:related rdf:resource="descriptor/12988-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18872-2">
    <skos:broader rdf:resource="thsys/70844"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18872-2">
    <skos:broader rdf:resource="thsys/70140"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18872-2">
    <skos:broader rdf:resource="descriptor/18871-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11551-1">
    <skos:altLabel xml:lang="en">Taking</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11551-1">
    <skos:altLabel xml:lang="de">Kosten der Bürokratieüberwälzung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11551-1">
    <skos:altLabel xml:lang="de">Folgekosten gesetzlicher Regelungen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11551-1">
    <skos:altLabel xml:lang="de">Bürokratiefolgekosten</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10902-3">
    <skos:prefLabel xml:lang="en">Market share</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10902-3">
    <skos:prefLabel xml:lang="de">Marktanteil</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10511-4">
    <skos:related rdf:resource="descriptor/16566-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10511-4">
    <skos:related rdf:resource="descriptor/10506-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10511-4">
    <skos:related rdf:resource="descriptor/18313-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10511-4">
    <skos:related rdf:resource="descriptor/10501-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10511-4">
    <skos:related rdf:resource="descriptor/10498-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10511-4">
    <skos:related rdf:resource="descriptor/10522-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10511-4">
    <skos:related rdf:resource="descriptor/19286-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10511-4">
    <skos:related rdf:resource="descriptor/13425-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18836-6">
    <skos:broader rdf:resource="thsys/70856"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18836-6">
    <skos:broader rdf:resource="thsys/70834"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18836-6">
    <skos:broader rdf:resource="descriptor/18835-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19474-2">
    <skos:prefLabel xml:lang="en">Urban poverty</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19474-2">
    <skos:prefLabel xml:lang="de">Städtische Armut</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71083">
    <skos:broader rdf:resource="thsys/70144"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18007-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19052-0">
    <skos:broader rdf:resource="thsys/70997"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19052-0">
    <skos:broader rdf:resource="descriptor/13051-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19816-0">
    <skos:broader rdf:resource="thsys/73334"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19816-0">
    <skos:broader rdf:resource="descriptor/15981-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19816-0">
    <skos:broader rdf:resource="descriptor/16198-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10779-4">
    <skos:broader rdf:resource="thsys/71103"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10779-4">
    <skos:broader rdf:resource="thsys/71088"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10779-4">
    <skos:broader rdf:resource="descriptor/10807-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19146-5">
    <skos:broader rdf:resource="thsys/70485"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13410-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10185-5">
    <skos:prefLabel xml:lang="en">Factor demand</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10185-5">
    <skos:prefLabel xml:lang="de">Faktornachfrage</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18316-4">
    <skos:broader rdf:resource="thsys/71029"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18316-4">
    <skos:broader rdf:resource="descriptor/12949-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70967">
    <skos:narrower rdf:resource="descriptor/11845-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70967">
    <skos:narrower rdf:resource="descriptor/13848-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70967">
    <skos:narrower rdf:resource="descriptor/18503-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70967">
    <skos:narrower rdf:resource="descriptor/18502-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70967">
    <skos:narrower rdf:resource="descriptor/12932-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70967">
    <skos:narrower rdf:resource="descriptor/18753-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70967">
    <skos:narrower rdf:resource="descriptor/11843-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70967">
    <skos:narrower rdf:resource="descriptor/11563-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70967">
    <skos:narrower rdf:resource="descriptor/12014-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70901">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16002-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18722-0">
    <skos:scopeNote xml:lang="de">Grundsätze über eine ausreichende Eigenkapitalausstattung und Zahlungsbereitschaft.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71111">
    <skos:prefLabel xml:lang="en">V.03.06  National accounts</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71111">
    <skos:prefLabel xml:lang="de">V.03.06  Volkswirtschaftliche Gesamtrechnung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14596-6">
    <skos:related rdf:resource="descriptor/14731-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14596-6">
    <skos:related rdf:resource="descriptor/13188-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14596-6">
    <skos:related rdf:resource="descriptor/14030-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14596-6">
    <skos:related rdf:resource="descriptor/18320-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14596-6">
    <skos:related rdf:resource="descriptor/19339-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10843-0">
    <skos:related rdf:resource="descriptor/12810-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10843-0">
    <skos:related rdf:resource="descriptor/18437-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15683-6">
    <skos:altLabel xml:lang="en">Snowboarding</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15683-6">
    <skos:altLabel xml:lang="de">Skisport</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15683-6">
    <skos:altLabel xml:lang="de">Schisport</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13177-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14268-2">
    <skos:related rdf:resource="descriptor/14378-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14268-2">
    <skos:related rdf:resource="descriptor/13028-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16287-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19204-3">
    <skos:prefLabel xml:lang="en">Evolutionary economics</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19204-3">
    <skos:prefLabel xml:lang="de">Evolutionsökonomik</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12065-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18156-0">
    <skos:related rdf:resource="descriptor/10179-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18156-0">
    <skos:related rdf:resource="descriptor/19376-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18156-0">
    <skos:related rdf:resource="descriptor/19374-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18156-0">
    <skos:related rdf:resource="descriptor/10381-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70816">
    <skos:broader rdf:resource="thsys/70818"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18398-4">
    <skos:broader rdf:resource="thsys/70985"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18398-4">
    <skos:broader rdf:resource="descriptor/10470-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12936-4">
    <skos:related rdf:resource="descriptor/15869-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14744-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14188-0">
    <skos:related rdf:resource="descriptor/12979-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14188-0">
    <skos:related rdf:resource="descriptor/18378-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14188-0">
    <skos:related rdf:resource="descriptor/16023-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14188-0">
    <skos:related rdf:resource="descriptor/18990-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14188-0">
    <skos:related rdf:resource="descriptor/14189-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14188-0">
    <skos:related rdf:resource="descriptor/13179-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14188-0">
    <skos:related rdf:resource="descriptor/19624-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14188-0">
    <skos:related rdf:resource="descriptor/13256-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14188-0">
    <skos:related rdf:resource="descriptor/15733-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14188-0">
    <skos:related rdf:resource="descriptor/10490-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14983-6">
    <skos:prefLabel xml:lang="en">Spirits</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14983-6">
    <skos:prefLabel xml:lang="de">Spirituosen</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17745-0">
    <skos:altLabel xml:lang="de">Arabische Republik Ägypten</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10065-1">
    <skos:related rdf:resource="descriptor/16727-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11335-0">
    <skos:related rdf:resource="descriptor/18173-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11346-2">
    <skos:related rdf:resource="descriptor/16150-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11346-2">
    <skos:related rdf:resource="descriptor/16484-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11346-2">
    <skos:related rdf:resource="descriptor/11350-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11346-2">
    <skos:related rdf:resource="descriptor/11337-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11346-2">
    <skos:related rdf:resource="descriptor/11342-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11346-2">
    <skos:related rdf:resource="descriptor/20455-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11346-2">
    <skos:related rdf:resource="descriptor/18169-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11346-2">
    <skos:related rdf:resource="descriptor/11339-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11346-2">
    <skos:related rdf:resource="descriptor/11314-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19437-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13465-5">
    <skos:narrower rdf:resource="descriptor/15080-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13465-5">
    <skos:narrower rdf:resource="descriptor/15077-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13465-5">
    <skos:narrower rdf:resource="descriptor/10835-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13136-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13420-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10524-2">
    <skos:narrower rdf:resource="descriptor/10541-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10524-2">
    <skos:narrower rdf:resource="descriptor/18325-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10524-2">
    <skos:narrower rdf:resource="descriptor/10505-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10524-2">
    <skos:narrower rdf:resource="descriptor/10575-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10524-2">
    <skos:narrower rdf:resource="descriptor/18481-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10524-2">
    <skos:narrower rdf:resource="descriptor/10570-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10524-2">
    <skos:narrower rdf:resource="descriptor/10517-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10524-2">
    <skos:narrower rdf:resource="descriptor/10562-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10524-2">
    <skos:narrower rdf:resource="descriptor/10534-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14509-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13841-3">
    <skos:altLabel xml:lang="en">Housing expenditures</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70095">
    <skos:broader rdf:resource="thsys/n"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70852">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70968">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18344-6">
    <skos:altLabel xml:lang="en">Driftnet fishing</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18344-6">
    <skos:altLabel xml:lang="de">Treibnetztechnik</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18344-6">
    <skos:altLabel xml:lang="de">Fischfangtechnik</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18805-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12014-1">
    <skos:altLabel xml:lang="de">Baulandausweisung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19558-3">
    <skos:scopeNote xml:lang="de">Verfahren zur Bewertung der Güter Umwelt, Naturparks, Erholungsgebiete, usw.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11895-4">
    <skos:broader rdf:resource="thsys/70058"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11895-4">
    <skos:broader rdf:resource="descriptor/10513-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12575-3">
    <skos:prefLabel xml:lang="en">Redundancy programme</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12575-3">
    <skos:prefLabel xml:lang="de">Sozialplan</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17632-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id248">
    <rdf:value xml:lang="de">Für die organisierte Verfolgung spezieller Interessen durch Verbände u.ä.</rdf:value>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11215-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16052-1">
    <skos:prefLabel xml:lang="en">Trading law</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16052-1">
    <skos:prefLabel xml:lang="de">Gewerberecht</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18509-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10978-5">
    <skos:related rdf:resource="descriptor/11024-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10978-5">
    <skos:related rdf:resource="descriptor/10217-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10978-5">
    <skos:related rdf:resource="descriptor/10397-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10978-5">
    <skos:related rdf:resource="descriptor/10960-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10978-5">
    <skos:related rdf:resource="descriptor/10213-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10978-5">
    <skos:related rdf:resource="descriptor/10976-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10978-5">
    <skos:related rdf:resource="descriptor/10201-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10978-5">
    <skos:related rdf:resource="descriptor/12475-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10978-5">
    <skos:related rdf:resource="descriptor/11494-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10978-5">
    <skos:related rdf:resource="descriptor/11543-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10978-5">
    <skos:related rdf:resource="descriptor/10380-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10978-5">
    <skos:related rdf:resource="descriptor/12794-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11147-1">
    <skos:prefLabel xml:lang="en">Agroindustrial complex</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11147-1">
    <skos:prefLabel xml:lang="de">Agrar-Industrie-Komplex</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13023-2">
    <skos:prefLabel xml:lang="en">Cement industry</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13023-2">
    <skos:prefLabel xml:lang="de">Zementindustrie</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19384-3">
    <skos:prefLabel xml:lang="en">Voucher</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19384-3">
    <skos:prefLabel xml:lang="de">Voucher</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10217-4">
    <skos:broader rdf:resource="thsys/70178"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10217-4">
    <skos:broader rdf:resource="descriptor/10144-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13777-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11560-0">
    <skos:prefLabel xml:lang="en">Military budget</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11560-0">
    <skos:prefLabel xml:lang="de">Verteidigungshaushalt</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16970-5">
    <skos:broader rdf:resource="thsys/70003"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16970-5">
    <skos:broader rdf:resource="descriptor/16972-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18332-6">
    <skos:broader rdf:resource="thsys/73362"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18332-6">
    <skos:broader rdf:resource="thsys/71020"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18332-6">
    <skos:broader rdf:resource="descriptor/11801-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11487-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70270">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10460-2">
    <skos:narrower rdf:resource="descriptor/10125-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10460-2">
    <skos:narrower rdf:resource="descriptor/10440-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73369">
    <skos:narrower rdf:resource="descriptor/16487-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73369">
    <skos:narrower rdf:resource="descriptor/19707-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73369">
    <skos:narrower rdf:resource="descriptor/16483-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73369">
    <skos:narrower rdf:resource="descriptor/11404-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73369">
    <skos:narrower rdf:resource="descriptor/16517-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73369">
    <skos:narrower rdf:resource="descriptor/16516-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73369">
    <skos:narrower rdf:resource="descriptor/16515-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73369">
    <skos:narrower rdf:resource="descriptor/19706-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73369">
    <skos:narrower rdf:resource="descriptor/11402-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73369">
    <skos:narrower rdf:resource="descriptor/16514-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73369">
    <skos:narrower rdf:resource="descriptor/11399-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73369">
    <skos:narrower rdf:resource="descriptor/11398-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73369">
    <skos:narrower rdf:resource="descriptor/11397-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73369">
    <skos:narrower rdf:resource="descriptor/18945-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73369">
    <skos:narrower rdf:resource="descriptor/11392-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10949-5">
    <skos:scopeNote xml:lang="de">Alle Anbieter, die aktuell oder potenziell in Wettbewerb zueinander stehen.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19784-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12243-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19773-6">
    <skos:related rdf:resource="descriptor/19752-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19773-6">
    <skos:related rdf:resource="descriptor/16308-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19773-6">
    <skos:related rdf:resource="descriptor/10595-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19773-6">
    <skos:related rdf:resource="descriptor/19680-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19773-6">
    <skos:related rdf:resource="descriptor/16587-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19773-6">
    <skos:related rdf:resource="descriptor/19521-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19773-6">
    <skos:related rdf:resource="descriptor/16266-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19773-6">
    <skos:related rdf:resource="descriptor/11243-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19773-6">
    <skos:related rdf:resource="descriptor/18073-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12725-3">
    <skos:altLabel xml:lang="de">Produktionstyp</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12725-3">
    <skos:altLabel xml:lang="de">Produktionssystem</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12725-3">
    <skos:altLabel xml:lang="de">Fertigungstyp</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14381-6">
    <skos:narrower rdf:resource="descriptor/14393-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14381-6">
    <skos:narrower rdf:resource="descriptor/14343-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14381-6">
    <skos:narrower rdf:resource="descriptor/14392-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14381-6">
    <skos:narrower rdf:resource="descriptor/14385-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14381-6">
    <skos:narrower rdf:resource="descriptor/14384-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14381-6">
    <skos:narrower rdf:resource="descriptor/14383-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14381-6">
    <skos:narrower rdf:resource="descriptor/14380-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14381-6">
    <skos:narrower rdf:resource="descriptor/14379-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14381-6">
    <skos:narrower rdf:resource="descriptor/14355-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14381-6">
    <skos:narrower rdf:resource="descriptor/14378-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14381-6">
    <skos:narrower rdf:resource="descriptor/14371-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14381-6">
    <skos:narrower rdf:resource="descriptor/14368-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14381-6">
    <skos:narrower rdf:resource="descriptor/14366-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10303-4">
    <zbwext:useInsteadNote rdf:nodeID="id9"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19664-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70816">
    <skos:notation rdf:datatype="http://www.w3.org/2001/XMLSchema#string">W.32.02</skos:notation>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18548-4">
    <skos:broader rdf:resource="thsys/71065"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18548-4">
    <skos:broader rdf:resource="thsys/70947"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18548-4">
    <skos:broader rdf:resource="descriptor/19460-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18548-4">
    <skos:broader rdf:resource="descriptor/13200-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17994-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20404-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14435-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70997">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="http://www.w3.org/2004/02/skos/core#hiddenLabel">
    <skos:definition xml:lang="en">A lexical label for a resource that should be hidden when
      generating visual displays of the resource, but should still be accessible to free text search
      operations.</skos:definition>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71067">
    <skos:narrower rdf:resource="descriptor/13862-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71067">
    <skos:narrower rdf:resource="descriptor/12005-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71067">
    <skos:narrower rdf:resource="descriptor/11934-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71067">
    <skos:narrower rdf:resource="descriptor/18160-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71067">
    <skos:narrower rdf:resource="descriptor/11915-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71067">
    <skos:narrower rdf:resource="descriptor/11932-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71067">
    <skos:narrower rdf:resource="descriptor/19291-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71067">
    <skos:narrower rdf:resource="descriptor/19448-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71067">
    <skos:narrower rdf:resource="descriptor/11914-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71067">
    <skos:narrower rdf:resource="descriptor/11913-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71067">
    <skos:narrower rdf:resource="descriptor/19452-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71067">
    <skos:narrower rdf:resource="descriptor/11897-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71067">
    <skos:narrower rdf:resource="descriptor/11849-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71067">
    <skos:narrower rdf:resource="descriptor/20321-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71067">
    <skos:narrower rdf:resource="descriptor/18816-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71067">
    <skos:narrower rdf:resource="descriptor/18799-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71067">
    <skos:narrower rdf:resource="descriptor/19364-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71067">
    <skos:narrower rdf:resource="descriptor/19451-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71067">
    <skos:narrower rdf:resource="descriptor/18490-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71067">
    <skos:narrower rdf:resource="descriptor/11906-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71067">
    <skos:narrower rdf:resource="descriptor/11863-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71067">
    <skos:narrower rdf:resource="descriptor/18546-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71067">
    <skos:narrower rdf:resource="descriptor/11905-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13729-4">
    <skos:related rdf:resource="descriptor/12265-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13729-4">
    <skos:related rdf:resource="descriptor/18677-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13729-4">
    <skos:related rdf:resource="descriptor/13716-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13729-4">
    <skos:related rdf:resource="descriptor/18736-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14729-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15050-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19519-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19269-3">
    <skos:related rdf:resource="descriptor/19271-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14383-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12786-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18623-2">
    <skos:altLabel xml:lang="en">Transport ecology</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18623-2">
    <skos:altLabel xml:lang="de">Umweltbelastung durch Verkehr</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17933-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15731-0">
    <skos:narrower rdf:resource="descriptor/13327-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13337-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id62">
    <rdfs:seeAlso rdf:resource="descriptor/13306-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18032-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19902-0">
    <skos:altLabel xml:lang="de">Vollzeitarbeit</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19902-0">
    <skos:altLabel xml:lang="de">Normalarbeitsverhältnis</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19902-0">
    <skos:altLabel xml:lang="de">Beschäftigungsverhältnis</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19854-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/24704-2">
    <skos:prefLabel xml:lang="en">Business process</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/24704-2">
    <skos:prefLabel xml:lang="de">Geschäftsprozess</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15463-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19229-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11708-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10642-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73393">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12208-2">
    <skos:narrower rdf:resource="descriptor/12203-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10940-2">
    <skos:altLabel xml:lang="en">Exclusive trading</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10940-2">
    <skos:altLabel xml:lang="de">Vertragshändlersystem</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10940-2">
    <skos:altLabel xml:lang="de">Selektiver Vertrieb</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10940-2">
    <skos:altLabel xml:lang="de">Ausschließlichkeitsvertrag</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10940-2">
    <skos:altLabel xml:lang="de">Alleinvertrieb</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10940-2">
    <skos:altLabel xml:lang="de">Alleinbezugsbindung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10948-0">
    <skos:related rdf:resource="descriptor/10895-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10948-0">
    <skos:related rdf:resource="descriptor/19432-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10948-0">
    <skos:related rdf:resource="descriptor/10949-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10948-0">
    <skos:related rdf:resource="descriptor/10928-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10948-0">
    <skos:related rdf:resource="descriptor/10944-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12306-2">
    <skos:broader rdf:resource="thsys/70005"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14940-3">
    <skos:prefLabel xml:lang="en">Bakery product</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14940-3">
    <skos:prefLabel xml:lang="de">Backwaren</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16786-5">
    <skos:broader rdf:resource="thsys/70823"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16786-5">
    <skos:broader rdf:resource="descriptor/15473-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19573-0">
    <skos:related rdf:resource="descriptor/15328-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18111-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12914-0">
    <zbwext:useInsteadNote rdf:nodeID="id14"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18915-3">
    <skos:related rdf:resource="descriptor/13214-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18915-3">
    <skos:related rdf:resource="descriptor/14033-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17947-2">
    <skos:prefLabel xml:lang="en">Samoa</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17947-2">
    <skos:prefLabel xml:lang="de">Samoa</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14182-5">
    <skos:broader rdf:resource="thsys/70650"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14182-5">
    <skos:broader rdf:resource="thsys/70227"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14182-5">
    <skos:broader rdf:resource="descriptor/14175-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19159-3">
    <skos:broader rdf:resource="thsys/73392"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19159-3">
    <skos:broader rdf:resource="thsys/71034"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19159-3">
    <skos:broader rdf:resource="descriptor/16036-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12285-5">
    <skos:prefLabel xml:lang="en">Return to capital</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12285-5">
    <skos:prefLabel xml:lang="de">Kapitalertrag</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18375-2">
    <skos:narrower rdf:resource="descriptor/18374-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18375-2">
    <skos:narrower rdf:resource="descriptor/18373-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18375-2">
    <skos:narrower rdf:resource="descriptor/18371-3"/>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id318">
    <rdf:value xml:lang="de">Für die distributive Wirkung von Steuern</rdf:value>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16007-6">
    <skos:related rdf:resource="descriptor/12189-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13683-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15467-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18758-0">
    <skos:scopeNote xml:lang="de">Leasing von Hardware und Software</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15640-3">
    <skos:narrower rdf:resource="descriptor/19737-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15640-3">
    <skos:narrower rdf:resource="descriptor/19740-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15640-3">
    <skos:narrower rdf:resource="descriptor/19736-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15640-3">
    <skos:narrower rdf:resource="descriptor/16401-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15640-3">
    <skos:narrower rdf:resource="descriptor/19739-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13620-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11372-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18663-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18839-0">
    <skos:prefLabel xml:lang="en">Cooperative management</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18839-0">
    <skos:prefLabel xml:lang="de">Genossenschaftsmanagement</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17700-1">
    <skos:prefLabel xml:lang="en">Cote d'Ivoire</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17700-1">
    <skos:prefLabel xml:lang="de">Elfenbeinküste</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18922-6">
    <skos:narrower rdf:resource="descriptor/18099-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14984-4">
    <skos:broader rdf:resource="thsys/73300"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14984-4">
    <skos:broader rdf:resource="descriptor/14971-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15765-4">
    <skos:prefLabel xml:lang="en">Ecology</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15765-4">
    <skos:prefLabel xml:lang="de">Umweltforschung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13823-5">
    <skos:prefLabel xml:lang="en">Actuarial theory</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13823-5">
    <skos:prefLabel xml:lang="de">Versicherungstechnik</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19790-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16783-4">
    <skos:prefLabel xml:lang="en">Library use</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16783-4">
    <skos:prefLabel xml:lang="de">Bibliotheksbenutzung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12655-5">
    <skos:prefLabel xml:lang="en">Bill of materials</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12655-5">
    <skos:prefLabel xml:lang="de">Stückliste</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19551-3">
    <skos:prefLabel xml:lang="en">Managed care</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19551-3">
    <skos:prefLabel xml:lang="de">Managed Care</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15458-6">
    <skos:broader rdf:resource="thsys/73104"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15458-6">
    <skos:broader rdf:resource="thsys/71035"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15458-6">
    <skos:broader rdf:resource="descriptor/15045-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19454-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="http://www.w3.org/2004/02/skos/core#topConceptOf">
    <rdfs:subPropertyOf rdf:resource="http://www.w3.org/2004/02/skos/core#inScheme"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16080-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16295-3">
    <skos:related rdf:resource="descriptor/10343-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16295-3">
    <skos:related rdf:resource="descriptor/19285-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16295-3">
    <skos:related rdf:resource="descriptor/11127-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16295-3">
    <skos:related rdf:resource="descriptor/16332-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16295-3">
    <skos:related rdf:resource="descriptor/13420-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16295-3">
    <skos:related rdf:resource="descriptor/11034-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16295-3">
    <skos:related rdf:resource="descriptor/16286-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16295-3">
    <skos:related rdf:resource="descriptor/19683-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16295-3">
    <skos:related rdf:resource="descriptor/19668-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16295-3">
    <skos:related rdf:resource="descriptor/15889-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16295-3">
    <skos:related rdf:resource="descriptor/16521-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16295-3">
    <skos:related rdf:resource="descriptor/10816-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16295-3">
    <skos:related rdf:resource="descriptor/16003-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16295-3">
    <skos:related rdf:resource="descriptor/16470-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16295-3">
    <skos:related rdf:resource="descriptor/16524-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16295-3">
    <skos:related rdf:resource="descriptor/16510-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16295-3">
    <skos:related rdf:resource="descriptor/16247-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12292-1">
    <skos:broader rdf:resource="thsys/71090"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12292-1">
    <skos:broader rdf:resource="thsys/71089"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12292-1">
    <skos:broader rdf:resource="descriptor/18681-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12292-1">
    <skos:broader rdf:resource="descriptor/10811-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12292-1">
    <skos:broader rdf:resource="descriptor/10823-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19035-0">
    <skos:altLabel xml:lang="de">Vorgabe</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19035-0">
    <skos:altLabel xml:lang="de">Plan</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15050-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15264-5">
    <skos:broader rdf:resource="thsys/72186"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15264-5">
    <skos:broader rdf:resource="descriptor/15272-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19210-1">
    <skos:broader rdf:resource="thsys/71118"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19210-1">
    <skos:broader rdf:resource="thsys/70057"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19210-1">
    <skos:broader rdf:resource="descriptor/10164-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18756-4">
    <skos:broader rdf:resource="thsys/70884"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18756-4">
    <skos:broader rdf:resource="descriptor/13837-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70968">
    <skos:narrower rdf:resource="descriptor/13903-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70968">
    <skos:narrower rdf:resource="descriptor/13186-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70968">
    <skos:narrower rdf:resource="descriptor/13185-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70968">
    <skos:narrower rdf:resource="descriptor/13077-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70968">
    <skos:narrower rdf:resource="descriptor/13181-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70968">
    <skos:narrower rdf:resource="descriptor/13180-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16136-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19703-6">
    <skos:prefLabel xml:lang="en">Constitutional reform</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19703-6">
    <skos:prefLabel xml:lang="de">Verfassungsreform</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18383-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13862-2">
    <skos:prefLabel xml:lang="en">Residential location</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13862-2">
    <skos:prefLabel xml:lang="de">Wohnstandort</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18219-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11397-6">
    <skos:editorialNote xml:lang="de">Möglichst spezifischer indexieren.</skos:editorialNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16516-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70386">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18738-6">
    <skos:prefLabel xml:lang="en">Private health insurance</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18738-6">
    <skos:prefLabel xml:lang="de">Private Krankenversicherung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19164-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10606-0">
    <skos:scopeNote xml:lang="de">Vgl. auch Außenhandelsbeschränkung plus Unterbegriffe.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13620-5">
    <skos:altLabel xml:lang="de">Stauerei</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13620-5">
    <skos:altLabel xml:lang="de">Frachtumschlag</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13381-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14583-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16016-5">
    <skos:altLabel xml:lang="de">Verfassungstheorie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16016-5">
    <skos:altLabel xml:lang="de">Verfassungssystem</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16016-5">
    <skos:altLabel xml:lang="de">Staatsverfassung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16016-5">
    <skos:altLabel xml:lang="de">Staatliche Verfassung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16016-5">
    <skos:altLabel xml:lang="de">Konstitutionalismus</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16016-5">
    <skos:altLabel xml:lang="de">Grundgesetz</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16782-6">
    <skos:broader rdf:resource="thsys/70823"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16782-6">
    <skos:broader rdf:resource="thsys/70383"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16782-6">
    <skos:broader rdf:resource="descriptor/16760-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10693-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71110">
    <rdfs:label xml:lang="en">Economic structure</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71110">
    <rdfs:label xml:lang="de">Wirtschaftsstruktur</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13727-1">
    <skos:broader rdf:resource="thsys/71107"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13727-1">
    <skos:broader rdf:resource="thsys/71046"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13727-1">
    <skos:broader rdf:resource="descriptor/12299-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18674-6">
    <skos:narrower rdf:resource="descriptor/24707-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70368">
    <skos:notation rdf:datatype="http://www.w3.org/2001/XMLSchema#string">B.05.01</skos:notation>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15105-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18806-1">
    <skos:related rdf:resource="descriptor/19446-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18806-1">
    <skos:related rdf:resource="descriptor/19378-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18806-1">
    <skos:related rdf:resource="descriptor/11553-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18806-1">
    <skos:related rdf:resource="descriptor/11552-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19038-1">
    <skos:broader rdf:resource="thsys/70582"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16708-4">
    <skos:broader rdf:resource="thsys/73394"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16708-4">
    <skos:broader rdf:resource="descriptor/16719-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11180-3">
    <skos:prefLabel xml:lang="en">Labour</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11180-3">
    <skos:prefLabel xml:lang="de">Arbeit</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19577-6">
    <skos:altLabel xml:lang="en">Wavelets</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19577-6">
    <skos:altLabel xml:lang="en">Random coefficient model</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19577-6">
    <skos:altLabel xml:lang="en">Kalman filter model</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10000-1">
    <skos:broader rdf:resource="thsys/70175"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10000-1">
    <skos:broader rdf:resource="thsys/70140"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10000-1">
    <skos:broader rdf:resource="descriptor/10012-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12570-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16749-4">
    <skos:altLabel xml:lang="de">Neomalthusianismus</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16749-4">
    <skos:altLabel xml:lang="de">Malthusianismus</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14614-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15722-1">
    <skos:prefLabel xml:lang="en">Social behaviour</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15722-1">
    <skos:prefLabel xml:lang="de">Soziales Verhalten</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18667-3">
    <skos:prefLabel xml:lang="en">Financial engineering</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18667-3">
    <skos:prefLabel xml:lang="de">Financial Engineering</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11203-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11063-0">
    <skos:broader rdf:resource="thsys/73382"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11063-0">
    <skos:broader rdf:resource="thsys/70039"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12212-4">
    <skos:broader rdf:resource="thsys/70897"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12212-4">
    <skos:broader rdf:resource="thsys/70485"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12212-4">
    <skos:broader rdf:resource="thsys/70187"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10772-4">
    <skos:altLabel xml:lang="de">Währungskonkurrenz</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10772-4">
    <skos:altLabel xml:lang="de">Parallelwährung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10772-4">
    <skos:altLabel xml:lang="de">Konkurrenz der Währungen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10772-4">
    <skos:altLabel xml:lang="de">Entnationalisierung des Geldes</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10772-4">
    <skos:altLabel xml:lang="de">Doppelwährung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10772-4">
    <skos:altLabel xml:lang="de">Bimetallismus</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10715-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11400-1">
    <skos:prefLabel xml:lang="en">Educational opportunities</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11400-1">
    <skos:prefLabel xml:lang="de">Bildungschancen</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11568-5">
    <skos:narrower rdf:resource="descriptor/11573-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11568-5">
    <skos:narrower rdf:resource="descriptor/19384-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11568-5">
    <skos:narrower rdf:resource="descriptor/11572-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11568-5">
    <skos:narrower rdf:resource="descriptor/11570-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12713-3">
    <skos:altLabel xml:lang="en">TQM</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12713-3">
    <skos:altLabel xml:lang="en">Total quality management</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12713-3">
    <skos:altLabel xml:lang="en">Six Sigma</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12713-3">
    <skos:altLabel xml:lang="en">Quality assurance</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12713-3">
    <skos:altLabel xml:lang="de">Qualitätswirtschaft</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12713-3">
    <skos:altLabel xml:lang="de">Qualitätswesen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12713-3">
    <skos:altLabel xml:lang="de">Qualitätsüberwachung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12713-3">
    <skos:altLabel xml:lang="de">Qualitätssicherung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12713-3">
    <skos:altLabel xml:lang="de">Qualitätskontrolle</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12713-3">
    <skos:altLabel xml:lang="de">Gütesicherung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12713-3">
    <skos:altLabel xml:lang="de">Ausschusskontrolle</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12713-3">
    <skos:altLabel xml:lang="de">Ausschußkontrolle</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16245-4">
    <skos:prefLabel xml:lang="en">Authoritarianism</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16245-4">
    <skos:prefLabel xml:lang="de">Autoritäres System</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19840-3">
    <skos:broader rdf:resource="thsys/73347"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19840-3">
    <skos:broader rdf:resource="thsys/70504"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19840-3">
    <skos:broader rdf:resource="thsys/70091"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15466-0">
    <skos:narrower rdf:resource="descriptor/16277-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15466-0">
    <skos:narrower rdf:resource="descriptor/15476-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15466-0">
    <skos:narrower rdf:resource="descriptor/15475-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15466-0">
    <skos:narrower rdf:resource="descriptor/15472-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15466-0">
    <skos:narrower rdf:resource="descriptor/15468-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15466-0">
    <skos:narrower rdf:resource="descriptor/15467-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15466-0">
    <skos:narrower rdf:resource="descriptor/20756-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10627-6">
    <skos:prefLabel xml:lang="en">Economic union</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10627-6">
    <skos:prefLabel xml:lang="de">Wirtschaftsunion</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id356">
    <rdfs:seeAlso rdf:resource="descriptor/14548-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70969">
    <skos:broader rdf:resource="thsys/70970"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13151-0">
    <skos:broader rdf:resource="thsys/73295"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13151-0">
    <skos:broader rdf:resource="descriptor/13157-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19332-1">
    <skos:broader rdf:resource="thsys/71095"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19332-1">
    <skos:broader rdf:resource="descriptor/10764-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16896-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19795-3">
    <skos:prefLabel xml:lang="en">Engineering</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19795-3">
    <skos:prefLabel xml:lang="de">Ingenieurwissenschaft</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14327-5">
    <skos:prefLabel xml:lang="en">Catalyst</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14327-5">
    <skos:prefLabel xml:lang="de">Katalysator</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15267-6">
    <skos:altLabel xml:lang="de">Monte-Carlo-Simulation</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15267-6">
    <skos:altLabel xml:lang="de">Monte-Carlo Methode</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15267-6">
    <skos:altLabel xml:lang="de">Monte Carlo Methode</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id168">
    <rdf:value xml:lang="de">Für Literatur zur rechtlichen Stellung der Gemeindevertretung</rdf:value>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13075-4">
    <skos:broader rdf:resource="thsys/70996"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13075-4">
    <skos:broader rdf:resource="descriptor/13076-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10494-6">
    <skos:prefLabel xml:lang="en">Development indicator</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10494-6">
    <skos:prefLabel xml:lang="de">Entwicklungsindikator</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11821-5">
    <skos:related rdf:resource="descriptor/11820-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11821-5">
    <skos:related rdf:resource="descriptor/18478-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19284-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11718-5">
    <skos:prefLabel xml:lang="en">Public Good</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11718-5">
    <skos:prefLabel xml:lang="de">Öffentliches Gut</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16628-2">
    <skos:related rdf:resource="descriptor/19756-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16628-2">
    <skos:related rdf:resource="descriptor/18142-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16628-2">
    <skos:related rdf:resource="descriptor/16678-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16628-2">
    <skos:related rdf:resource="descriptor/15920-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16338-4">
    <skos:broader rdf:resource="thsys/73379"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15716-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11611-2">
    <skos:narrower rdf:resource="descriptor/11609-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18980-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16713-4">
    <skos:broader rdf:resource="thsys/73394"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16713-4">
    <skos:broader rdf:resource="descriptor/16719-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14130-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19804-0">
    <skos:altLabel xml:lang="de">Agenten-Technologie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17497-0">
    <skos:prefLabel xml:lang="en">Kyrgyzstan</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17497-0">
    <skos:prefLabel xml:lang="de">Kirgisistan</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18190-0">
    <skos:prefLabel xml:lang="en">Cotton production</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18190-0">
    <skos:prefLabel xml:lang="de">Baumwollanbau</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16072-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15715-5">
    <skos:broader rdf:resource="thsys/73395"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15715-5">
    <skos:broader rdf:resource="thsys/70504"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19152-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12592-3">
    <skos:related rdf:resource="descriptor/11341-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12592-3">
    <skos:related rdf:resource="descriptor/12502-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12592-3">
    <skos:related rdf:resource="descriptor/11558-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12592-3">
    <skos:related rdf:resource="descriptor/15839-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12592-3">
    <skos:related rdf:resource="descriptor/11052-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12592-3">
    <skos:related rdf:resource="descriptor/13309-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12592-3">
    <skos:related rdf:resource="descriptor/15837-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10501-0">
    <skos:prefLabel xml:lang="en">Informal sector</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10501-0">
    <skos:prefLabel xml:lang="de">Informeller Sektor</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16740-1">
    <skos:broader rdf:resource="thsys/70141"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16740-1">
    <skos:broader rdf:resource="descriptor/16739-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16740-1">
    <skos:broader rdf:resource="descriptor/16745-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16797-0">
    <skos:narrower rdf:resource="descriptor/16768-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13496-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14192-2">
    <skos:prefLabel xml:lang="en">Mining product</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14192-2">
    <skos:prefLabel xml:lang="de">Bergbauprodukt</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70244">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11957-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12298-3">
    <skos:prefLabel xml:lang="en">Hidden Reserves</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12298-3">
    <skos:prefLabel xml:lang="de">Stille Reserve</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17724-1">
    <skos:altLabel xml:lang="de">Westafrikanische Staaten</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17724-1">
    <skos:altLabel xml:lang="de">Westafrikanische Länder</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18351-2">
    <skos:prefLabel xml:lang="en">Energy statistics</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18351-2">
    <skos:prefLabel xml:lang="de">Energiestatistik</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18162-5">
    <skos:related rdf:resource="descriptor/14266-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18216-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10667-1">
    <skos:broader rdf:resource="thsys/71099"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10667-1">
    <skos:broader rdf:resource="thsys/71095"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10667-1">
    <skos:broader rdf:resource="thsys/70355"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10667-1">
    <skos:broader rdf:resource="descriptor/11506-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73356">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11734-0">
    <skos:related rdf:resource="descriptor/11613-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11734-0">
    <skos:related rdf:resource="descriptor/11556-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11734-0">
    <skos:related rdf:resource="descriptor/11554-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70039">
    <skos:notation rdf:datatype="http://www.w3.org/2001/XMLSchema#string">V.06</skos:notation>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10223-2">
    <skos:prefLabel xml:lang="en">Incomplete market</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10223-2">
    <skos:prefLabel xml:lang="de">Unvollkommener Markt</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10683-3">
    <skos:related rdf:resource="descriptor/19310-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10145-3">
    <skos:related rdf:resource="descriptor/10144-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20810-2">
    <skos:altLabel xml:lang="en">EU-Stability and Growth Pact</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20810-2">
    <skos:altLabel xml:lang="de">Stabilitätspakt</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20810-2">
    <skos:altLabel xml:lang="de">Stabilitätskriterien</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13536-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13374-1">
    <skos:altLabel xml:lang="en">Veterinarians</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13374-1">
    <skos:altLabel xml:lang="de">Veterinärmedizin</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13374-1">
    <skos:altLabel xml:lang="de">Veterinärinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13374-1">
    <skos:altLabel xml:lang="de">Veterinäre</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13374-1">
    <skos:altLabel xml:lang="de">Tiermedizinerinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13374-1">
    <skos:altLabel xml:lang="de">Tiermediziner</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13374-1">
    <skos:altLabel xml:lang="de">Tiermedizin</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13374-1">
    <skos:altLabel xml:lang="de">Tierklinik</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13374-1">
    <skos:altLabel xml:lang="de">Tierhygiene</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13374-1">
    <skos:altLabel xml:lang="de">Tierheilkunde</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13374-1">
    <skos:altLabel xml:lang="de">Tierarztpraxis</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13374-1">
    <skos:altLabel xml:lang="de">Tierärztinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13374-1">
    <skos:altLabel xml:lang="de">Tierärzte</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13374-1">
    <skos:altLabel xml:lang="de">Tierarzt</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13374-1">
    <skos:altLabel xml:lang="de">Fleischbeschau</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10272-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18620-1">
    <skos:altLabel xml:lang="de">Logistikdienstleistung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11266-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17570-2">
    <skos:related rdf:resource="descriptor/17569-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19510-3">
    <skos:altLabel xml:lang="de">Soziale Sachleistung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19510-3">
    <skos:altLabel xml:lang="de">Sachleistungstransfer</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19510-3">
    <skos:altLabel xml:lang="de">Sachleistung in der Sozialhilfe</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19510-3">
    <skos:altLabel xml:lang="de">Naturalleistung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17999-4">
    <skos:broader rdf:resource="thsys/70307"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10236-0">
    <skos:prefLabel xml:lang="en">Monetary theory</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10236-0">
    <skos:prefLabel xml:lang="de">Geldtheorie</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18204-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12818-3">
    <skos:broader rdf:resource="thsys/73384"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12818-3">
    <skos:broader rdf:resource="thsys/70874"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12818-3">
    <skos:broader rdf:resource="thsys/70384"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12818-3">
    <skos:broader rdf:resource="descriptor/12770-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12309-3">
    <skos:broader rdf:resource="thsys/70037"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12309-3">
    <skos:broader rdf:resource="descriptor/12215-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16245-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10513-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16122-6">
    <skos:prefLabel xml:lang="en">Customs law</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16122-6">
    <skos:prefLabel xml:lang="de">Zollrecht</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16324-1">
    <skos:related rdf:resource="descriptor/13421-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16324-1">
    <skos:related rdf:resource="descriptor/18808-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16324-1">
    <skos:related rdf:resource="descriptor/13414-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16324-1">
    <skos:related rdf:resource="descriptor/18809-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16324-1">
    <skos:related rdf:resource="descriptor/16551-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16324-1">
    <skos:related rdf:resource="descriptor/16314-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12689-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15119-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10313-1">
    <skos:narrower rdf:resource="descriptor/10122-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10313-1">
    <skos:narrower rdf:resource="descriptor/18328-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10313-1">
    <skos:narrower rdf:resource="descriptor/10304-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13460-1">
    <skos:broader rdf:resource="thsys/70963"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13460-1">
    <skos:broader rdf:resource="descriptor/10032-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14127-6">
    <skos:prefLabel xml:lang="en">Hides and skins</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14127-6">
    <skos:prefLabel xml:lang="de">Häute und Felle</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18881-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13028-6">
    <skos:broader rdf:resource="thsys/71003"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13028-6">
    <skos:broader rdf:resource="descriptor/13034-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11560-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id235">
    <rdfs:seeAlso rdf:resource="descriptor/19553-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13342-0">
    <skos:prefLabel xml:lang="en">Driving school</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13342-0">
    <skos:prefLabel xml:lang="de">Fahrschule</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16421-3">
    <skos:narrower rdf:resource="descriptor/19719-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16421-3">
    <skos:narrower rdf:resource="descriptor/19718-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16421-3">
    <skos:narrower rdf:resource="descriptor/18181-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16079-2">
    <skos:altLabel xml:lang="de">Wechselgesetz</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11298-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13699-1">
    <skos:prefLabel xml:lang="en">Equity mutual funds</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13699-1">
    <skos:prefLabel xml:lang="de">Aktienfonds</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13047-2">
    <skos:prefLabel xml:lang="en">Vehicle construction</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13047-2">
    <skos:prefLabel xml:lang="de">Fahrzeugbau</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70342">
    <skos:notation rdf:datatype="http://www.w3.org/2001/XMLSchema#string">P.20.01</skos:notation>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14393-6">
    <skos:altLabel xml:lang="de">Schleifmaschine</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14393-6">
    <skos:altLabel xml:lang="de">Presse (Werkzeugmaschine)</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13723-2">
    <skos:related rdf:resource="descriptor/12210-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13723-2">
    <skos:related rdf:resource="descriptor/13731-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13723-2">
    <skos:related rdf:resource="descriptor/19321-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13723-2">
    <skos:related rdf:resource="descriptor/10121-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13723-2">
    <skos:related rdf:resource="descriptor/12287-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13723-2">
    <skos:related rdf:resource="descriptor/18671-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13723-2">
    <skos:related rdf:resource="descriptor/11414-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13723-2">
    <skos:related rdf:resource="descriptor/25742-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13723-2">
    <skos:related rdf:resource="descriptor/18085-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19708-3">
    <skos:related rdf:resource="descriptor/16440-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19708-3">
    <skos:related rdf:resource="descriptor/16278-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19708-3">
    <skos:related rdf:resource="descriptor/19715-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19708-3">
    <skos:related rdf:resource="descriptor/16184-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19708-3">
    <skos:related rdf:resource="descriptor/16455-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19708-3">
    <skos:related rdf:resource="descriptor/16439-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19708-3">
    <skos:related rdf:resource="descriptor/19711-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19708-3">
    <skos:related rdf:resource="descriptor/20826-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19708-3">
    <skos:related rdf:resource="descriptor/16497-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12747-0">
    <skos:related rdf:resource="descriptor/12644-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12747-0">
    <skos:related rdf:resource="descriptor/12755-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12747-0">
    <skos:related rdf:resource="descriptor/12760-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12747-0">
    <skos:related rdf:resource="descriptor/12765-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12747-0">
    <skos:related rdf:resource="descriptor/10002-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12747-0">
    <skos:related rdf:resource="descriptor/12134-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16978-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11802-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15746-1">
    <skos:narrower rdf:resource="descriptor/19627-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15746-1">
    <skos:narrower rdf:resource="descriptor/18967-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15746-1">
    <skos:narrower rdf:resource="descriptor/19629-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15746-1">
    <skos:narrower rdf:resource="descriptor/19628-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15746-1">
    <skos:narrower rdf:resource="descriptor/19625-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15746-1">
    <skos:narrower rdf:resource="descriptor/18336-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16973-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18907-2">
    <skos:altLabel xml:lang="en">Long term care</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18907-2">
    <skos:altLabel xml:lang="de">Krankenpflegedienst</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18907-2">
    <skos:altLabel xml:lang="de">Hauspflege</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18907-2">
    <skos:altLabel xml:lang="de">Häuslicher Pflegedienst</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18907-2">
    <skos:altLabel xml:lang="de">Ambulanter Pflegedienst</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18907-2">
    <skos:altLabel xml:lang="de">Ambulante Pflege</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18565-4">
    <skos:altLabel xml:lang="de">Speisewagenwirtschaft</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18565-4">
    <skos:altLabel xml:lang="de">Raststätte</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70892">
    <rdfs:label xml:lang="de">Versicherungswesen</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15448-2">
    <skos:altLabel xml:lang="en">Strategic equilibrium</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15448-2">
    <skos:altLabel xml:lang="en">Nash solution</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15448-2">
    <skos:altLabel xml:lang="en">Cournot-Nash-equilibrium</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15448-2">
    <skos:altLabel xml:lang="en">Cournot-Nash equilibrium</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15448-2">
    <skos:altLabel xml:lang="de">Strategisches Gleichgewicht</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15448-2">
    <skos:altLabel xml:lang="de">Nash-Verhandlungslösung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15448-2">
    <skos:altLabel xml:lang="de">Nash-Lösung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15448-2">
    <skos:altLabel xml:lang="de">Nash Gleichgewicht</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15448-2">
    <skos:altLabel xml:lang="de">Cournot-Nash-Gleichgewicht</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17176-6">
    <skos:altLabel xml:lang="en">Socialist Federal Republic of Yugoslavia</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17176-6">
    <skos:altLabel xml:lang="de">Sozialistische Föderative Republik Jugoslawien</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17176-6">
    <skos:altLabel xml:lang="de">Jugoslavija (bis 1990)</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11558-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13533-0">
    <skos:altLabel xml:lang="de">Seehafen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10016-0">
    <skos:broader rdf:resource="thsys/70550"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10016-0">
    <skos:broader rdf:resource="thsys/70233"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10016-0">
    <skos:broader rdf:resource="thsys/70201"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10016-0">
    <skos:broader rdf:resource="thsys/70030"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73348">
    <skos:broader rdf:resource="thsys/70151"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14888-0">
    <skos:altLabel xml:lang="de">Webtextilien</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14888-0">
    <skos:altLabel xml:lang="de">Webereiprodukt</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14888-0">
    <skos:altLabel xml:lang="de">Velours</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14888-0">
    <skos:altLabel xml:lang="de">Tuch</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14888-0">
    <skos:altLabel xml:lang="de">Samt</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14888-0">
    <skos:altLabel xml:lang="de">Plüsch</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14888-0">
    <skos:altLabel xml:lang="de">Kunstleder</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14888-0">
    <skos:altLabel xml:lang="de">Gummiertes Gewebe</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14888-0">
    <skos:altLabel xml:lang="de">Gewebe</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14888-0">
    <skos:altLabel xml:lang="de">Beschichtetes Gewebe</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14888-0">
    <skos:altLabel xml:lang="de">Beschichtete Textilien</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13820-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11556-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12247-6">
    <skos:altLabel xml:lang="de">Industrieschuldverschreibung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12247-6">
    <skos:altLabel xml:lang="de">Industrieanleihe</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12247-6">
    <skos:altLabel xml:lang="de">Anleihe der Industrie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18896-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13312-2">
    <skos:narrower rdf:resource="descriptor/13310-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19447-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="http://www.w3.org/2004/02/skos/core#historyNote">
    <rdf:type rdf:resource="http://www.w3.org/1999/02/22-rdf-syntax-ns#Property"/>
  </rdf:Description>
  <rdf:Description rdf:about="http://www.w3.org/2004/02/skos/core#historyNote">
    <rdf:type rdf:resource="http://www.w3.org/2002/07/owl#AnnotationProperty"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12540-1">
    <skos:broader rdf:resource="thsys/70855"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12540-1">
    <skos:broader rdf:resource="thsys/70578"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12540-1">
    <skos:broader rdf:resource="descriptor/10011-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13085-1">
    <skos:related rdf:resource="descriptor/19858-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13085-1">
    <skos:related rdf:resource="descriptor/14548-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18231-5">
    <skos:related rdf:resource="descriptor/14364-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18231-5">
    <skos:related rdf:resource="descriptor/15901-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14948-1">
    <skos:broader rdf:resource="thsys/70342"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14948-1">
    <skos:broader rdf:resource="descriptor/14931-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16438-0">
    <skos:related rdf:resource="descriptor/10626-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16438-0">
    <skos:related rdf:resource="descriptor/20449-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16438-0">
    <skos:related rdf:resource="descriptor/10618-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16438-0">
    <skos:related rdf:resource="descriptor/19509-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18218-4">
    <skos:altLabel xml:lang="en">Chicken meat</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18218-4">
    <skos:altLabel xml:lang="de">Hühnerfleisch</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14664-1">
    <skos:prefLabel xml:lang="en">Alkanes</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14664-1">
    <skos:prefLabel xml:lang="de">Alkane</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13434-2">
    <skos:broader rdf:resource="thsys/71028"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13434-2">
    <skos:broader rdf:resource="descriptor/18980-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10850-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12697-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10757-0">
    <skos:prefLabel xml:lang="en">Swiss Franc</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10757-0">
    <skos:prefLabel xml:lang="de">Schweizer Franken</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11970-2">
    <zbwext:useInsteadNote rdf:nodeID="id304"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73393">
    <rdfs:label xml:lang="en">Philosophy of science</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73393">
    <rdfs:label xml:lang="de">Wissenschaftstheorie</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12309-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70301">
    <skos:prefLabel xml:lang="de">B.05  Materialwirtschaft und Logistik</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13160-6">
    <skos:related rdf:resource="descriptor/18991-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13160-6">
    <skos:related rdf:resource="descriptor/18413-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13160-6">
    <skos:related rdf:resource="descriptor/14384-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13160-6">
    <skos:related rdf:resource="descriptor/19338-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13160-6">
    <skos:related rdf:resource="descriptor/14931-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13160-6">
    <skos:related rdf:resource="descriptor/18443-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13160-6">
    <skos:related rdf:resource="descriptor/16004-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13160-6">
    <skos:related rdf:resource="descriptor/13219-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13160-6">
    <skos:related rdf:resource="descriptor/18442-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13160-6">
    <skos:related rdf:resource="descriptor/18222-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13160-6">
    <skos:related rdf:resource="descriptor/13306-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13160-6">
    <skos:related rdf:resource="descriptor/13949-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13160-6">
    <skos:related rdf:resource="descriptor/18320-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19668-3">
    <skos:broader rdf:resource="thsys/73366"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19668-3">
    <skos:broader rdf:resource="thsys/70039"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11752-5">
    <skos:altLabel xml:lang="de">Verteilungskampf</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14909-4">
    <skos:prefLabel xml:lang="en">Children's wear</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14909-4">
    <skos:prefLabel xml:lang="de">Kinderbekleidung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12385-1">
    <skos:related rdf:resource="descriptor/12401-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12385-1">
    <skos:related rdf:resource="descriptor/12297-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12385-1">
    <skos:related rdf:resource="descriptor/12273-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12385-1">
    <skos:related rdf:resource="descriptor/12361-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12385-1">
    <skos:related rdf:resource="descriptor/12406-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13109-6">
    <skos:prefLabel xml:lang="en">Carpentry</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13109-6">
    <skos:prefLabel xml:lang="de">Holzhandwerk</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16664-5">
    <skos:altLabel xml:lang="en">Social position</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16664-5">
    <skos:altLabel xml:lang="de">Sozioökonomischer Status</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16664-5">
    <skos:altLabel xml:lang="de">Soziale Stellung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16664-5">
    <skos:altLabel xml:lang="de">Soziale Position</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id232">
    <rdf:value xml:lang="de">Für die Analyse chaotischer Systeme</rdf:value>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18422-5">
    <skos:broader rdf:resource="thsys/71056"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18422-5">
    <skos:broader rdf:resource="thsys/70997"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18422-5">
    <skos:broader rdf:resource="descriptor/18400-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14762-1">
    <skos:broader rdf:resource="thsys/73305"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14762-1">
    <skos:broader rdf:resource="thsys/71038"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14762-1">
    <skos:broader rdf:resource="descriptor/14751-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16312-1">
    <skos:prefLabel xml:lang="en">Centralized state</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16312-1">
    <skos:prefLabel xml:lang="de">Zentralstaat</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71020">
    <skos:broader rdf:resource="thsys/71028"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11430-6">
    <skos:related rdf:resource="descriptor/11438-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11430-6">
    <skos:related rdf:resource="descriptor/14298-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11430-6">
    <skos:related rdf:resource="descriptor/11444-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11430-6">
    <skos:related rdf:resource="descriptor/19260-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11430-6">
    <skos:related rdf:resource="descriptor/11443-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19478-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18187-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13995-4">
    <skos:narrower rdf:resource="descriptor/16301-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12700-5">
    <skos:prefLabel xml:lang="en">Capacity utilization</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12700-5">
    <skos:prefLabel xml:lang="de">Kapazitätsauslastung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19166-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15488-4">
    <skos:prefLabel xml:lang="en">Branch-and-Bound algorithm</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15488-4">
    <skos:prefLabel xml:lang="de">Branch-and-Bound-Verfahren</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19666-0">
    <skos:broader rdf:resource="thsys/70234"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12591-5">
    <skos:altLabel xml:lang="de">Unterstützungskasse</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12591-5">
    <skos:altLabel xml:lang="de">Recht der betrieblichen Altersversorgung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12591-5">
    <skos:altLabel xml:lang="de">Betriebsrentenrecht</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12591-5">
    <skos:altLabel xml:lang="de">Betriebsrente</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12591-5">
    <skos:altLabel xml:lang="de">Betriebliche Alterssicherung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16441-4">
    <skos:narrower rdf:resource="descriptor/10597-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16441-4">
    <skos:narrower rdf:resource="descriptor/10623-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16441-4">
    <skos:narrower rdf:resource="descriptor/10587-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16441-4">
    <skos:narrower rdf:resource="descriptor/16648-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16441-4">
    <skos:narrower rdf:resource="descriptor/19708-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16441-4">
    <skos:narrower rdf:resource="descriptor/10617-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16441-4">
    <skos:narrower rdf:resource="descriptor/19711-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71101">
    <skos:narrower rdf:resource="descriptor/11033-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71101">
    <skos:narrower rdf:resource="descriptor/11146-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71101">
    <skos:narrower rdf:resource="descriptor/11030-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71101">
    <skos:narrower rdf:resource="descriptor/10985-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71101">
    <skos:narrower rdf:resource="descriptor/11125-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71101">
    <skos:narrower rdf:resource="descriptor/11124-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71101">
    <skos:narrower rdf:resource="descriptor/11142-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71101">
    <skos:narrower rdf:resource="descriptor/11149-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71101">
    <skos:narrower rdf:resource="descriptor/11090-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71101">
    <skos:narrower rdf:resource="descriptor/11143-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71101">
    <skos:narrower rdf:resource="descriptor/11141-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71101">
    <skos:narrower rdf:resource="descriptor/11024-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71101">
    <skos:narrower rdf:resource="descriptor/11151-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71101">
    <skos:narrower rdf:resource="descriptor/11060-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71101">
    <skos:narrower rdf:resource="descriptor/11034-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71101">
    <skos:narrower rdf:resource="descriptor/11061-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71101">
    <skos:narrower rdf:resource="descriptor/11020-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71101">
    <skos:narrower rdf:resource="descriptor/11073-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71101">
    <skos:narrower rdf:resource="descriptor/11088-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71101">
    <skos:narrower rdf:resource="descriptor/11048-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71101">
    <skos:narrower rdf:resource="descriptor/11051-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71101">
    <skos:narrower rdf:resource="descriptor/11047-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71101">
    <skos:narrower rdf:resource="descriptor/11134-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71101">
    <skos:narrower rdf:resource="descriptor/11044-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71101">
    <skos:narrower rdf:resource="descriptor/11001-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71101">
    <skos:narrower rdf:resource="descriptor/11129-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71101">
    <skos:narrower rdf:resource="descriptor/10996-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71101">
    <skos:narrower rdf:resource="descriptor/11147-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19433-2">
    <skos:related rdf:resource="descriptor/19533-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70394">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19491-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70071">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11685-1">
    <skos:related rdf:resource="descriptor/10112-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11685-1">
    <skos:related rdf:resource="descriptor/11688-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13010-4">
    <skos:prefLabel xml:lang="en">Fine ceramics industry</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13010-4">
    <skos:prefLabel xml:lang="de">Feinkeramische Industrie</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18681-2">
    <skos:narrower rdf:resource="descriptor/12292-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11834-3">
    <skos:prefLabel xml:lang="en">Transportation rate</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11834-3">
    <skos:prefLabel xml:lang="de">Verkehrstarif</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12069-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/72182">
    <skos:narrower rdf:resource="descriptor/15025-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/72182">
    <skos:narrower rdf:resource="descriptor/15211-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/72182">
    <skos:narrower rdf:resource="descriptor/19581-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/72182">
    <skos:narrower rdf:resource="descriptor/15064-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/72182">
    <skos:narrower rdf:resource="descriptor/15814-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/72182">
    <skos:narrower rdf:resource="descriptor/15063-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/72182">
    <skos:narrower rdf:resource="descriptor/15062-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/72182">
    <skos:narrower rdf:resource="descriptor/19568-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/72182">
    <skos:narrower rdf:resource="descriptor/19150-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/72182">
    <skos:narrower rdf:resource="descriptor/15372-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/72182">
    <skos:narrower rdf:resource="descriptor/19070-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/72182">
    <skos:narrower rdf:resource="descriptor/19569-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/72182">
    <skos:narrower rdf:resource="descriptor/10229-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="http://zbw.eu/namespaces/skos-extensions/Descriptor">
    <rdfs:label xml:lang="en">Descriptor</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14456-1">
    <skos:prefLabel xml:lang="en">Ship's equipment</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14456-1">
    <skos:prefLabel xml:lang="de">Schiffsausrüstung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11740-5">
    <skos:broader rdf:resource="thsys/71115"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11740-5">
    <skos:broader rdf:resource="descriptor/10006-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16639-4">
    <skos:altLabel xml:lang="de">Lebenshaltung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18067-6">
    <skos:related rdf:resource="descriptor/19733-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18067-6">
    <skos:related rdf:resource="descriptor/13810-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13145-2">
    <skos:broader rdf:resource="thsys/70987"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13145-2">
    <skos:broader rdf:resource="descriptor/18094-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15956-4">
    <skos:prefLabel xml:lang="en">Return migration</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15956-4">
    <skos:prefLabel xml:lang="de">Rückwanderung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13475-2">
    <skos:related rdf:resource="descriptor/19139-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13475-2">
    <skos:related rdf:resource="descriptor/12820-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13475-2">
    <skos:related rdf:resource="descriptor/13479-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13475-2">
    <skos:related rdf:resource="descriptor/13466-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13475-2">
    <skos:related rdf:resource="descriptor/13200-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16943-1">
    <skos:broader rdf:resource="thsys/70438"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16943-1">
    <skos:broader rdf:resource="descriptor/16950-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19104-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10748-1">
    <skos:prefLabel xml:lang="en">Yen</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10748-1">
    <skos:prefLabel xml:lang="de">Yen</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15264-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14610-3">
    <skos:prefLabel xml:lang="en">Plastics additive</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14610-3">
    <skos:prefLabel xml:lang="de">Kunststoffhilfsmittel</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18073-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12564-1">
    <skos:scopeNote xml:lang="de">Einsatz von EDV im Personalwesen.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19292-1">
    <skos:broader rdf:resource="thsys/71029"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19292-1">
    <skos:broader rdf:resource="thsys/70986"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19292-1">
    <skos:broader rdf:resource="thsys/70960"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19292-1">
    <skos:broader rdf:resource="descriptor/19338-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10421-5">
    <skos:broader rdf:resource="thsys/70406"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10421-5">
    <skos:broader rdf:resource="descriptor/10434-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70554">
    <rdfs:label xml:lang="en">Central Europe</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70554">
    <rdfs:label xml:lang="de">Mitteleuropa</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14933-0">
    <skos:altLabel xml:lang="de">Gefrierkost</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18683-5">
    <skos:scopeNote xml:lang="de">Computergestützte Hedging-Strategien, mit Hilfe von mathematischen Programmen große Aktienportfolios gegen Kursverluste zu schützen, was durch Bildung sog. idealer Portfolios erreicht werden soll.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16976-0">
    <skos:prefLabel xml:lang="en">Ticino</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16976-0">
    <skos:prefLabel xml:lang="de">Tessin</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15491-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13989-6">
    <skos:narrower rdf:resource="descriptor/13984-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73394">
    <rdfs:label xml:lang="en">Philosophy</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73394">
    <rdfs:label xml:lang="de">Philosophie</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17580-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19576-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18234-6">
    <skos:altLabel xml:lang="de">Industrielle Abwärme</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18234-6">
    <skos:altLabel xml:lang="de">Abwärme</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12612-2">
    <skos:related rdf:resource="descriptor/15416-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12612-2">
    <skos:related rdf:resource="descriptor/12615-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12612-2">
    <skos:related rdf:resource="descriptor/12617-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12612-2">
    <skos:related rdf:resource="descriptor/12607-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15932-4">
    <skos:prefLabel xml:lang="en">Ethnic discrimination</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15932-4">
    <skos:prefLabel xml:lang="de">Ethnische Diskriminierung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18338-1">
    <skos:prefLabel xml:lang="en">Forest policy</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18338-1">
    <skos:prefLabel xml:lang="de">Forstpolitik</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18094-3">
    <skos:prefLabel xml:lang="en">Textile and clothing industry</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18094-3">
    <skos:prefLabel xml:lang="de">Textil- und Bekleidungsindustrie</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18531-0">
    <skos:broader rdf:resource="thsys/70956"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18531-0">
    <skos:broader rdf:resource="descriptor/18717-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15989-3">
    <skos:broader rdf:resource="thsys/73360"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15989-3">
    <skos:broader rdf:resource="descriptor/16019-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18392-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12927-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11701-1">
    <skos:altLabel xml:lang="de">Zonenrandförderungsgesetz</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11701-1">
    <skos:altLabel xml:lang="de">Zonenrandförderung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11701-1">
    <skos:altLabel xml:lang="de">Steuerliche Standortpolitik</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11701-1">
    <skos:altLabel xml:lang="de">Regionales Steuergefälle</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11701-1">
    <skos:altLabel xml:lang="de">Regionale Steuerdifferenzierung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11701-1">
    <skos:altLabel xml:lang="de">Gesetz zur Förderung des Zonenrandgebietes</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11701-1">
    <skos:altLabel xml:lang="de">Gesetz zur Förderung der Berliner Wirtschaft</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11701-1">
    <skos:altLabel xml:lang="de">Fördergebietsgesetz</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11701-1">
    <skos:altLabel xml:lang="de">Berlinförderungsgesetz</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11701-1">
    <skos:altLabel xml:lang="de">Berlinförderung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12502-2">
    <skos:broader rdf:resource="thsys/70245"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12502-2">
    <skos:broader rdf:resource="descriptor/12501-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12502-2">
    <skos:broader rdf:resource="descriptor/19566-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10508-0">
    <skos:altLabel xml:lang="en">SIC (Semi-Industrialized Countries)</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10508-0">
    <skos:altLabel xml:lang="en">Semi-industrialized countries</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10508-0">
    <skos:altLabel xml:lang="en">NIC (Newly Industrializing Countries)</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10508-0">
    <skos:altLabel xml:lang="de">Halbindustrialisierte Länder</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18707-3">
    <skos:narrower rdf:resource="descriptor/18708-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18707-3">
    <skos:narrower rdf:resource="descriptor/13687-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13253-6">
    <skos:broader rdf:resource="thsys/70924"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13253-6">
    <skos:broader rdf:resource="descriptor/12927-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19376-2">
    <skos:broader rdf:resource="thsys/71083"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13479-1">
    <skos:broader rdf:resource="thsys/70956"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13940-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18648-0">
    <skos:broader rdf:resource="thsys/70922"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18648-0">
    <skos:broader rdf:resource="thsys/70900"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18648-0">
    <skos:broader rdf:resource="descriptor/18718-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19546-3">
    <skos:broader rdf:resource="thsys/73362"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19546-3">
    <skos:broader rdf:resource="thsys/71020"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19546-3">
    <skos:broader rdf:resource="descriptor/19545-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19546-3">
    <skos:broader rdf:resource="descriptor/11806-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19276-6">
    <skos:prefLabel xml:lang="en">Certificate of deposit</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19276-6">
    <skos:prefLabel xml:lang="de">Depositenzertifikat</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16155-5">
    <skos:broader rdf:resource="thsys/73335"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16155-5">
    <skos:broader rdf:resource="thsys/70835"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16155-5">
    <skos:broader rdf:resource="thsys/70833"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16155-5">
    <skos:broader rdf:resource="thsys/70324"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16155-5">
    <skos:broader rdf:resource="descriptor/16159-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19686-1">
    <skos:scopeNote xml:lang="de">Das Verhältnis zwischen Staat und gesellschaftlichen Gruppen ist bestimmt durch Laissez-Faire oder staatliches Eingreifen in direkter oder indirekter Weise. Die Palette der Möglichkeiten reicht von staatlicher Öffentlichkeitsarbeit über finanzielle Anreize bis hin zu rechtlichen Ge- oder Verboten.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17940-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12794-5">
    <skos:related rdf:resource="descriptor/19127-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12794-5">
    <skos:related rdf:resource="descriptor/10978-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12794-5">
    <skos:related rdf:resource="descriptor/12808-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12794-5">
    <skos:related rdf:resource="descriptor/10909-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12794-5">
    <skos:related rdf:resource="descriptor/10216-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12794-5">
    <skos:related rdf:resource="descriptor/10213-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12794-5">
    <skos:related rdf:resource="descriptor/12531-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12794-5">
    <skos:related rdf:resource="descriptor/10198-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15658-5">
    <skos:related rdf:resource="descriptor/19529-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15658-5">
    <skos:related rdf:resource="descriptor/15790-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15658-5">
    <skos:related rdf:resource="descriptor/19785-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15658-5">
    <skos:related rdf:resource="descriptor/15664-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15658-5">
    <skos:related rdf:resource="descriptor/14042-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15658-5">
    <skos:related rdf:resource="descriptor/16670-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15658-5">
    <skos:related rdf:resource="descriptor/13371-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15658-5">
    <skos:related rdf:resource="descriptor/18892-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15658-5">
    <skos:related rdf:resource="descriptor/16635-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15658-5">
    <skos:related rdf:resource="descriptor/18777-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15658-5">
    <skos:related rdf:resource="descriptor/19811-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15658-5">
    <skos:related rdf:resource="descriptor/15633-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15658-5">
    <skos:related rdf:resource="descriptor/16697-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11046-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13310-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15787-1">
    <skos:narrower rdf:resource="descriptor/15823-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11999-6">
    <skos:related rdf:resource="descriptor/11983-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11999-6">
    <skos:related rdf:resource="descriptor/11969-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11999-6">
    <skos:related rdf:resource="descriptor/11998-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11999-6">
    <skos:related rdf:resource="descriptor/11890-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11999-6">
    <skos:related rdf:resource="descriptor/11901-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12741-5">
    <skos:broader rdf:resource="thsys/70270"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12741-5">
    <skos:broader rdf:resource="descriptor/12744-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70361">
    <skos:prefLabel xml:lang="en">G.01.01.01  Germany</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70361">
    <skos:prefLabel xml:lang="de">G.01.01.01  Deutschland</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13671-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10282-0">
    <skos:prefLabel xml:lang="en">Income hypothesis</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10282-0">
    <skos:prefLabel xml:lang="de">Einkommenshypothese</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15460-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14741-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10432-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12602-5">
    <skos:broader rdf:resource="thsys/71050"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12602-5">
    <skos:broader rdf:resource="descriptor/15685-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19118-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15446-6">
    <skos:narrower rdf:resource="descriptor/19595-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18426-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11194-6">
    <skos:altLabel xml:lang="en">Leisure time</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11194-6">
    <skos:altLabel xml:lang="de">Erholung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11194-6">
    <skos:altLabel xml:lang="de">Eigenzeit</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10278-5">
    <zbwext:useInsteadNote rdf:nodeID="id114"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19285-5">
    <skos:scopeNote xml:lang="de">Instabilität von Volkswirtschaften, Märkten oder Wirtschaftsordnungen sowie systembedingte Knappheiten oder Mangelerscheinungen.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13514-4">
    <skos:related rdf:resource="descriptor/13590-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13514-4">
    <skos:related rdf:resource="descriptor/18630-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11753-3">
    <skos:scopeNote xml:lang="de">Nur zur Messung von Verteilung und Konzentration des Einkommens bzw. des Vermögens.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19858-5">
    <skos:altLabel xml:lang="en">Gun-control law</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19858-5">
    <skos:altLabel xml:lang="de">WaffG</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19858-5">
    <skos:altLabel xml:lang="de">Waffenschein</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19858-5">
    <skos:altLabel xml:lang="de">Waffengesetz</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19858-5">
    <skos:altLabel xml:lang="de">Waffenbesitzkarte</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18719-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70037">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18760-6">
    <skos:altLabel xml:lang="de">Leasinggeschäft</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19476-5">
    <skos:prefLabel xml:lang="en">City portrait</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19476-5">
    <skos:prefLabel xml:lang="de">Stadtbeschreibung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10249-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13588-3">
    <skos:related rdf:resource="descriptor/11833-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13588-3">
    <skos:related rdf:resource="descriptor/13264-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13588-3">
    <skos:related rdf:resource="descriptor/13594-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13588-3">
    <skos:related rdf:resource="descriptor/15520-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13588-3">
    <skos:related rdf:resource="descriptor/15519-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13588-3">
    <skos:related rdf:resource="descriptor/15518-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15715-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14087-6">
    <skos:prefLabel xml:lang="en">Barley</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14087-6">
    <skos:prefLabel xml:lang="de">Gerste</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18928-1">
    <skos:broader rdf:resource="thsys/70825"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18928-1">
    <skos:broader rdf:resource="descriptor/10032-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11702-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18703-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20442-5">
    <skos:scopeNote xml:lang="de">Effiziente Reaktion der Anbieter auf die Konsumentennachfrage durch Zusammenarbeit zwischen allen Beteiligten der logistischen Kette</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14683-4">
    <skos:broader rdf:resource="thsys/70556"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14683-4">
    <skos:broader rdf:resource="descriptor/14656-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19508-4">
    <skos:prefLabel xml:lang="en">Workfare</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19508-4">
    <skos:prefLabel xml:lang="de">Workfare</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14920-2">
    <skos:broader rdf:resource="thsys/70031"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14920-2">
    <skos:broader rdf:resource="descriptor/14586-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14920-2">
    <skos:broader rdf:resource="descriptor/14915-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11241-2">
    <skos:broader rdf:resource="thsys/71080"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11241-2">
    <skos:broader rdf:resource="thsys/71061"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11241-2">
    <skos:broader rdf:resource="descriptor/11572-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11241-2">
    <skos:broader rdf:resource="descriptor/11235-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73395">
    <rdfs:label xml:lang="de">Soziale Schichtung</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13493-0">
    <skos:broader rdf:resource="thsys/70947"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13493-0">
    <skos:broader rdf:resource="descriptor/13200-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18727-4">
    <skos:broader rdf:resource="thsys/71107"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18727-4">
    <skos:broader rdf:resource="thsys/70899"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18727-4">
    <skos:broader rdf:resource="descriptor/13769-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13177-3">
    <skos:narrower rdf:resource="descriptor/13179-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13177-3">
    <skos:narrower rdf:resource="descriptor/18500-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18992-6">
    <skos:broader rdf:resource="thsys/73295"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18992-6">
    <skos:broader rdf:resource="descriptor/10981-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18992-6">
    <skos:broader rdf:resource="descriptor/16476-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11311-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70845">
    <skos:broader rdf:resource="thsys/70847"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16297-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16483-2">
    <skos:broader rdf:resource="thsys/73369"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16483-2">
    <skos:broader rdf:resource="thsys/70819"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16483-2">
    <skos:broader rdf:resource="descriptor/16273-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18759-5">
    <skos:related rdf:resource="descriptor/18760-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18759-5">
    <skos:related rdf:resource="descriptor/12254-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10427-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14106-0">
    <skos:prefLabel xml:lang="en">Leguminosae</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14106-0">
    <skos:prefLabel xml:lang="de">Hülsenfrucht</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16122-6">
    <skos:broader rdf:resource="thsys/73337"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16122-6">
    <skos:broader rdf:resource="thsys/71096"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16122-6">
    <skos:broader rdf:resource="thsys/71073"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16122-6">
    <skos:broader rdf:resource="descriptor/11525-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18795-1">
    <skos:broader rdf:resource="thsys/70873"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18795-1">
    <skos:broader rdf:resource="thsys/70459"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70996">
    <skos:prefLabel xml:lang="en">W.06.01.04  Electrical industry</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70996">
    <skos:prefLabel xml:lang="de">W.06.01.04  Elektroindustrie</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15963-0">
    <skos:related rdf:resource="descriptor/16198-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15963-0">
    <skos:related rdf:resource="descriptor/16504-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15963-0">
    <skos:related rdf:resource="descriptor/18011-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15686-0">
    <skos:prefLabel xml:lang="en">Science studies</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15686-0">
    <skos:prefLabel xml:lang="de">Wissenschaftsforschung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16968-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11679-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15807-0">
    <skos:related rdf:resource="descriptor/15810-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15807-0">
    <skos:related rdf:resource="descriptor/15722-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15807-0">
    <skos:related rdf:resource="descriptor/15806-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15807-0">
    <skos:related rdf:resource="descriptor/19758-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16611-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19668-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10383-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15964-5">
    <skos:related rdf:resource="descriptor/19860-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15964-5">
    <skos:related rdf:resource="descriptor/15965-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15964-5">
    <skos:related rdf:resource="descriptor/15659-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15964-5">
    <skos:related rdf:resource="descriptor/16713-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15964-5">
    <skos:related rdf:resource="descriptor/15998-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15964-5">
    <skos:related rdf:resource="descriptor/19768-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15964-5">
    <skos:related rdf:resource="descriptor/16426-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11516-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19609-5">
    <skos:scopeNote xml:lang="de">Nichtparametrisches Verfahren zur Bestimmung der relativen Effizienz von Unternehmen.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19729-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70865">
    <rdfs:label xml:lang="en">Armed forces</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70865">
    <rdfs:label xml:lang="de">Militär</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13338-5">
    <skos:broader rdf:resource="thsys/70876"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18551-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19494-3">
    <skos:related rdf:resource="descriptor/11278-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19494-3">
    <skos:related rdf:resource="descriptor/11183-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19494-3">
    <skos:related rdf:resource="descriptor/11182-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10659-0">
    <skos:broader rdf:resource="thsys/71099"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10659-0">
    <skos:broader rdf:resource="descriptor/10678-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10659-0">
    <skos:broader rdf:resource="descriptor/10773-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13264-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16090-0">
    <skos:altLabel xml:lang="de">EU-Steuerrichtlinie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16090-0">
    <skos:altLabel xml:lang="de">EU-Steuerharmonisierung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16090-0">
    <skos:altLabel xml:lang="de">EG-Steuerrecht</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16090-0">
    <skos:altLabel xml:lang="de">EG-Steuerharmonisierung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18441-1">
    <skos:altLabel xml:lang="de">Lebensmittelrecht der EU</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18441-1">
    <skos:altLabel xml:lang="de">EU-Bedarfsgegenständerecht</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70903">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18633-6">
    <skos:broader rdf:resource="thsys/71064"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18633-6">
    <skos:broader rdf:resource="thsys/70925"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18633-6">
    <skos:broader rdf:resource="descriptor/11833-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18633-6">
    <skos:broader rdf:resource="descriptor/16549-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18794-3">
    <skos:broader rdf:resource="thsys/70951"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18794-3">
    <skos:broader rdf:resource="thsys/70873"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18794-3">
    <skos:broader rdf:resource="descriptor/12783-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13588-3">
    <skos:broader rdf:resource="thsys/70928"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13588-3">
    <skos:broader rdf:resource="descriptor/10032-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13588-3">
    <skos:broader rdf:resource="descriptor/13573-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19348-0">
    <skos:related rdf:resource="descriptor/12958-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19348-0">
    <skos:related rdf:resource="descriptor/14985-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13003-1">
    <skos:scopeNote xml:lang="de">Umfasst im wesentlichen die Stufen des nuklearen Brennstoffkreislaufs: Förderung und Aufbereitung von Uranerz, Anreicherung und Brennelementfertigung sowie Wiederaufarbeitung und Lagerung gebrauchter Brennstäbe.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13026-3">
    <skos:prefLabel xml:lang="en">Precious metal industry</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13026-3">
    <skos:prefLabel xml:lang="de">Edelmetallindustrie</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18087-0">
    <skos:related rdf:resource="descriptor/18693-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18087-0">
    <skos:related rdf:resource="descriptor/10135-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18087-0">
    <skos:related rdf:resource="descriptor/10803-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12920-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73333">
    <skos:prefLabel xml:lang="en">N.05.08  International law</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73333">
    <skos:prefLabel xml:lang="de">N.05.08  Internationales Recht</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12184-4">
    <skos:prefLabel xml:lang="en">Limited liability company with a dormant partner</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12184-4">
    <skos:prefLabel xml:lang="de">GmbH &amp;amp; Still</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19360-3">
    <skos:altLabel xml:lang="de">Migrantenüberweisung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19360-3">
    <skos:altLabel xml:lang="de">Heimatüberweisung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19360-3">
    <skos:altLabel xml:lang="de">Heimattransfer</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19360-3">
    <skos:altLabel xml:lang="de">Gastarbeitertransfers</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19360-3">
    <skos:altLabel xml:lang="de">Gastarbeitertransfer</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12501-4">
    <skos:related rdf:resource="descriptor/11341-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12501-4">
    <skos:related rdf:resource="descriptor/11241-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12501-4">
    <skos:related rdf:resource="descriptor/19566-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13713-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17801-2">
    <skos:prefLabel xml:lang="en">St. Vincent and the Grenadines</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17801-2">
    <skos:prefLabel xml:lang="de">St. Vincent und die Grenadinen</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15859-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18291-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71053">
    <skos:broader rdf:resource="thsys/71055"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71096">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14122-2">
    <skos:prefLabel xml:lang="en">Meat</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14122-2">
    <skos:prefLabel xml:lang="de">Fleisch</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13349-0">
    <skos:broader rdf:resource="thsys/71052"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13349-0">
    <skos:broader rdf:resource="thsys/70879"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13349-0">
    <skos:broader rdf:resource="descriptor/11356-6"/>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id324">
    <rdfs:seeAlso rdf:resource="descriptor/14997-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19298-3">
    <skos:prefLabel xml:lang="en">Rice policy</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19298-3">
    <skos:prefLabel xml:lang="de">Reispolitik</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13600-4">
    <skos:related rdf:resource="descriptor/13513-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13600-4">
    <skos:related rdf:resource="descriptor/13610-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13600-4">
    <skos:related rdf:resource="descriptor/15518-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13600-4">
    <skos:related rdf:resource="descriptor/13546-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13600-4">
    <skos:related rdf:resource="descriptor/12689-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18193-1">
    <skos:prefLabel xml:lang="en">Cocoa production</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18193-1">
    <skos:prefLabel xml:lang="de">Kakaoanbau</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14734-6">
    <skos:broader rdf:resource="thsys/70536"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14734-6">
    <skos:broader rdf:resource="descriptor/14599-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71023">
    <skos:notation rdf:datatype="http://www.w3.org/2001/XMLSchema#string">W.01.04</skos:notation>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16333-0">
    <skos:scopeNote xml:lang="de">Oberster staatlicher Repräsentant</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19622-6">
    <skos:narrower rdf:resource="descriptor/15901-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12727-6">
    <skos:prefLabel xml:lang="en">Series production</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12727-6">
    <skos:prefLabel xml:lang="de">Serienfertigung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12441-3">
    <skos:related rdf:resource="descriptor/12408-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11143-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18940-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19500-6">
    <skos:prefLabel xml:lang="en">Non-cash employee benefits</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19500-6">
    <skos:prefLabel xml:lang="de">Geldwerter Vorteil</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13573-2">
    <skos:narrower rdf:resource="descriptor/13571-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13573-2">
    <skos:narrower rdf:resource="descriptor/13588-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13573-2">
    <skos:narrower rdf:resource="descriptor/18623-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13573-2">
    <skos:narrower rdf:resource="descriptor/13511-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13573-2">
    <skos:narrower rdf:resource="descriptor/13594-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13573-2">
    <skos:narrower rdf:resource="descriptor/18418-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13573-2">
    <skos:narrower rdf:resource="descriptor/18423-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10064-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15740-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12958-1">
    <skos:broader rdf:resource="thsys/71026"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12958-1">
    <skos:broader rdf:resource="descriptor/12947-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12605-6">
    <skos:altLabel xml:lang="de">Strahlenschutzverordnung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12605-6">
    <skos:altLabel xml:lang="de">Strahlenschutzrichtlinie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18062-2">
    <skos:related rdf:resource="descriptor/16389-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18062-2">
    <skos:related rdf:resource="descriptor/19688-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18062-2">
    <skos:related rdf:resource="descriptor/19684-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18062-2">
    <skos:related rdf:resource="descriptor/19705-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18062-2">
    <skos:related rdf:resource="descriptor/16300-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18062-2">
    <skos:related rdf:resource="descriptor/16416-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18062-2">
    <skos:related rdf:resource="descriptor/16264-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18062-2">
    <skos:related rdf:resource="descriptor/16299-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18062-2">
    <skos:related rdf:resource="descriptor/15797-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18062-2">
    <skos:related rdf:resource="descriptor/15918-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71093">
    <skos:prefLabel xml:lang="en">V.07.04  Economic integration</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71093">
    <skos:prefLabel xml:lang="de">V.07.04  Wirtschaftsintegration</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18843-2">
    <skos:broader rdf:resource="thsys/70854"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18843-2">
    <skos:broader rdf:resource="descriptor/12180-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13729-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19203-5">
    <skos:broader rdf:resource="thsys/73393"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19203-5">
    <skos:broader rdf:resource="thsys/70141"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19203-5">
    <skos:broader rdf:resource="descriptor/10032-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19469-2">
    <skos:broader rdf:resource="thsys/71064"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19469-2">
    <skos:broader rdf:resource="descriptor/11973-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11286-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13085-1">
    <skos:prefLabel xml:lang="en">Metal goods industry</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13085-1">
    <skos:prefLabel xml:lang="de">EBM-Industrie</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18012-3">
    <skos:broader rdf:resource="thsys/70361"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18012-3">
    <skos:broader rdf:resource="descriptor/17991-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18012-3">
    <skos:broader rdf:resource="descriptor/16825-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18012-3">
    <skos:broader rdf:resource="descriptor/19178-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18012-3">
    <skos:broader rdf:resource="descriptor/19177-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18012-3">
    <skos:broader rdf:resource="descriptor/17983-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11282-2">
    <skos:prefLabel xml:lang="en">Unskilled workers</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11282-2">
    <skos:prefLabel xml:lang="de">Ungelernte Arbeitskräfte</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18407-1">
    <skos:related rdf:resource="descriptor/14368-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18407-1">
    <skos:related rdf:resource="descriptor/18390-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18407-1">
    <skos:related rdf:resource="descriptor/12980-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12056-6">
    <skos:related rdf:resource="descriptor/16063-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12056-6">
    <skos:related rdf:resource="descriptor/12452-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12056-6">
    <skos:related rdf:resource="descriptor/12446-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12056-6">
    <skos:related rdf:resource="descriptor/10897-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14255-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id380">
    <rdfs:seeAlso rdf:resource="descriptor/19210-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19126-4">
    <skos:broader rdf:resource="thsys/70040"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19126-4">
    <skos:broader rdf:resource="descriptor/12788-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70539">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11829-3">
    <skos:prefLabel xml:lang="en">Transport investment</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11829-3">
    <skos:prefLabel xml:lang="de">Verkehrsinvestition</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19808-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73340">
    <skos:broader rdf:resource="thsys/73342"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13655-0">
    <skos:scopeNote xml:lang="de">Für Veranstalter und Programme BENUTZE die entsprechenden Deskriptoren.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19356-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19685-3">
    <skos:prefLabel xml:lang="en">Capital City</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19685-3">
    <skos:prefLabel xml:lang="de">Hauptstadt</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15972-6">
    <skos:altLabel xml:lang="de">Vorsorglicher Rechtsschutz</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15972-6">
    <skos:altLabel xml:lang="de">Vorläufiger Rechtsschutz</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15972-6">
    <skos:altLabel xml:lang="de">Einstweilige Verfügung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15972-6">
    <skos:altLabel xml:lang="de">Einstweilige Anordnung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18019-3">
    <skos:narrower rdf:resource="descriptor/17948-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18019-3">
    <skos:narrower rdf:resource="descriptor/19172-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11356-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11790-4">
    <skos:prefLabel xml:lang="en">Economic change</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11790-4">
    <skos:prefLabel xml:lang="de">Strukturwandel</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17772-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14683-4">
    <skos:narrower rdf:resource="descriptor/14692-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14683-4">
    <skos:narrower rdf:resource="descriptor/18079-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14683-4">
    <skos:narrower rdf:resource="descriptor/14673-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14683-4">
    <skos:narrower rdf:resource="descriptor/14662-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14683-4">
    <skos:narrower rdf:resource="descriptor/14664-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/21041-4">
    <skos:prefLabel xml:lang="en">Systems selling strategy</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/21041-4">
    <skos:prefLabel xml:lang="de">Systemgeschäft</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14307-4">
    <skos:prefLabel xml:lang="en">Mercury</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14307-4">
    <skos:prefLabel xml:lang="de">Quecksilber</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10314-6">
    <skos:related rdf:resource="descriptor/18160-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10314-6">
    <skos:related rdf:resource="descriptor/10326-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10314-6">
    <skos:related rdf:resource="descriptor/15709-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13028-6">
    <skos:prefLabel xml:lang="en">Foundry</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13028-6">
    <skos:prefLabel xml:lang="de">Gießereiindustrie</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20206-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10076-3">
    <skos:narrower rdf:resource="descriptor/10085-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10076-3">
    <skos:narrower rdf:resource="descriptor/11927-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10076-3">
    <skos:narrower rdf:resource="descriptor/10081-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10076-3">
    <skos:narrower rdf:resource="descriptor/10077-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10076-3">
    <skos:narrower rdf:resource="descriptor/10075-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10076-3">
    <skos:narrower rdf:resource="descriptor/10073-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10076-3">
    <skos:narrower rdf:resource="descriptor/10070-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12469-2">
    <skos:prefLabel xml:lang="en">ABC analysis</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12469-2">
    <skos:prefLabel xml:lang="de">ABC-Analyse</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19550-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10697-6">
    <skos:prefLabel xml:lang="en">Green money</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10697-6">
    <skos:prefLabel xml:lang="de">Grenzausgleich</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12703-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11030-1">
    <skos:prefLabel xml:lang="en">National economic plan</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11030-1">
    <skos:prefLabel xml:lang="de">Volkswirtschaftsplan</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10179-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11659-2">
    <skos:broader rdf:resource="thsys/71074"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11659-2">
    <skos:broader rdf:resource="thsys/71066"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11659-2">
    <skos:broader rdf:resource="thsys/70889"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11659-2">
    <skos:broader rdf:resource="thsys/70184"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11659-2">
    <skos:broader rdf:resource="descriptor/11676-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14181-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16726-2">
    <skos:related rdf:resource="descriptor/16729-3"/>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id332">
    <rdfs:seeAlso rdf:resource="descriptor/12955-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10382-3">
    <skos:narrower rdf:resource="descriptor/11490-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10382-3">
    <skos:narrower rdf:resource="descriptor/21101-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10382-3">
    <skos:narrower rdf:resource="descriptor/11521-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10382-3">
    <skos:narrower rdf:resource="descriptor/10721-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10382-3">
    <skos:narrower rdf:resource="descriptor/11487-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10382-3">
    <skos:narrower rdf:resource="descriptor/11484-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10382-3">
    <skos:narrower rdf:resource="descriptor/11494-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10382-3">
    <skos:narrower rdf:resource="descriptor/19547-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10382-3">
    <skos:narrower rdf:resource="descriptor/19262-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10382-3">
    <skos:narrower rdf:resource="descriptor/11479-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18936-2">
    <skos:altLabel xml:lang="en">TV commercial</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18936-2">
    <skos:altLabel xml:lang="en">Television commercial</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18936-2">
    <skos:altLabel xml:lang="de">Werbefernsehen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18936-2">
    <skos:altLabel xml:lang="de">TV-Werbung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18936-2">
    <skos:altLabel xml:lang="de">TV-Werbespot</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18936-2">
    <skos:altLabel xml:lang="de">Fernseh-Werbespot</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12603-3">
    <skos:prefLabel xml:lang="en">Humanization of work</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12603-3">
    <skos:prefLabel xml:lang="de">Humanisierung der Arbeitswelt</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14135-0">
    <skos:prefLabel xml:lang="en">Poultry</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14135-0">
    <skos:prefLabel xml:lang="de">Geflügel</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18979-5">
    <skos:prefLabel xml:lang="en">Agricultural administration</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18979-5">
    <skos:prefLabel xml:lang="de">Landwirtschaftsverwaltung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12307-0">
    <skos:broader rdf:resource="thsys/70005"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11817-3">
    <skos:altLabel xml:lang="de">Gewerbeförderung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11817-3">
    <skos:altLabel xml:lang="de">Förderung von Gewerbebetrieben</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id163">
    <rdfs:seeAlso rdf:resource="descriptor/11683-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12916-3">
    <skos:related rdf:resource="descriptor/13058-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12916-3">
    <skos:related rdf:resource="descriptor/18100-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12916-3">
    <skos:related rdf:resource="descriptor/12278-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12916-3">
    <skos:related rdf:resource="descriptor/12914-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10018-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10676-0">
    <skos:scopeNote xml:lang="de">Die monetäre Außenwirtschaftstheorie oder Währungstheorie beinhaltet die theoretischen Grundlagen der internationalen Währungsordnung und des internationalen Kapitalverkehrs sowie die Zahlungsbilanztheorie.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11516-3">
    <skos:broader rdf:resource="thsys/70355"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11516-3">
    <skos:broader rdf:resource="descriptor/11507-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18501-2">
    <skos:broader rdf:resource="thsys/70969"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18501-2">
    <skos:broader rdf:resource="descriptor/13176-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11894-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18799-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16792-3">
    <skos:broader rdf:resource="thsys/70822"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11213-0">
    <skos:broader rdf:resource="thsys/71060"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11213-0">
    <skos:broader rdf:resource="descriptor/11182-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11754-1">
    <skos:related rdf:resource="descriptor/11765-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11754-1">
    <skos:related rdf:resource="descriptor/18155-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11754-1">
    <skos:related rdf:resource="descriptor/10217-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11754-1">
    <skos:related rdf:resource="descriptor/10186-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16209-1">
    <skos:broader rdf:resource="thsys/70095"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16209-1">
    <skos:broader rdf:resource="descriptor/16563-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16509-3">
    <skos:related rdf:resource="descriptor/16332-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16509-3">
    <skos:related rdf:resource="descriptor/15970-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16509-3">
    <skos:related rdf:resource="descriptor/16283-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16509-3">
    <skos:related rdf:resource="descriptor/16551-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16509-3">
    <skos:related rdf:resource="descriptor/16510-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10697-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19392-4">
    <skos:prefLabel xml:lang="en">Private school</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19392-4">
    <skos:prefLabel xml:lang="de">Privatschule</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19158-5">
    <skos:broader rdf:resource="thsys/71043"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19158-5">
    <skos:broader rdf:resource="thsys/71034"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19158-5">
    <skos:broader rdf:resource="descriptor/12337-5"/>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id352">
    <rdfs:seeAlso rdf:resource="descriptor/19670-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16463-1">
    <skos:altLabel xml:lang="de">Sicherheitspartnerschaft</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16463-1">
    <skos:altLabel xml:lang="de">Internationale Sicherheitsstrategie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16463-1">
    <skos:altLabel xml:lang="de">Bündnisstrategie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13703-1">
    <skos:related rdf:resource="descriptor/18590-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13703-1">
    <skos:related rdf:resource="descriptor/12257-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13703-1">
    <skos:related rdf:resource="descriptor/13736-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13703-1">
    <skos:related rdf:resource="descriptor/13775-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17641-5">
    <skos:altLabel xml:lang="x-other">Kypros</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17641-5">
    <skos:altLabel xml:lang="x-other">Kybriaki Dimokratia</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17641-5">
    <skos:altLabel xml:lang="x-other">Kibris Cumhuriyeti</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17641-5">
    <skos:altLabel xml:lang="de">Republik Zypern</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16229-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19619-2">
    <skos:prefLabel xml:lang="en">Volcano</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19619-2">
    <skos:prefLabel xml:lang="de">Vulkan</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15675-5">
    <skos:broader rdf:resource="thsys/70819"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15675-5">
    <skos:broader rdf:resource="thsys/70581"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18884-2">
    <skos:prefLabel xml:lang="en">Education finance</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18884-2">
    <skos:prefLabel xml:lang="de">Bildungsfinanzierung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19642-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15902-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19316-6">
    <skos:broader rdf:resource="thsys/71091"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19316-6">
    <skos:broader rdf:resource="descriptor/10683-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16090-0">
    <skos:broader rdf:resource="thsys/73331"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16090-0">
    <skos:broader rdf:resource="thsys/71073"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16090-0">
    <skos:broader rdf:resource="descriptor/10829-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16090-0">
    <skos:broader rdf:resource="descriptor/16182-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14902-4">
    <skos:prefLabel xml:lang="en">Women's wear</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14902-4">
    <skos:prefLabel xml:lang="de">Damenbekleidung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11901-0">
    <skos:altLabel xml:lang="de">Sanierung von Gebäuden</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11901-0">
    <skos:altLabel xml:lang="de">Gebäudesanierung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11901-0">
    <skos:altLabel xml:lang="de">Fassadensanierung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11901-0">
    <skos:altLabel xml:lang="de">Fassadenreinigung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14298-0">
    <skos:prefLabel xml:lang="en">Gold</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14298-0">
    <skos:prefLabel xml:lang="de">Gold</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15176-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10615-6">
    <skos:narrower rdf:resource="descriptor/10811-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10615-6">
    <skos:narrower rdf:resource="descriptor/10613-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13529-5">
    <skos:narrower rdf:resource="descriptor/13541-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10945-6">
    <skos:related rdf:resource="descriptor/10466-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10945-6">
    <skos:related rdf:resource="descriptor/19251-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10945-6">
    <skos:related rdf:resource="descriptor/19548-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10945-6">
    <skos:related rdf:resource="descriptor/18082-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10945-6">
    <skos:related rdf:resource="descriptor/10459-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70074">
    <skos:notation rdf:datatype="http://www.w3.org/2001/XMLSchema#string">P.12.07</skos:notation>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16562-6">
    <skos:broader rdf:resource="thsys/70180"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16562-6">
    <skos:broader rdf:resource="thsys/70141"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16562-6">
    <skos:broader rdf:resource="descriptor/10032-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13079-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14157-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10194-4">
    <skos:broader rdf:resource="thsys/71117"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10194-4">
    <skos:broader rdf:resource="descriptor/10141-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18942-0">
    <skos:related rdf:resource="descriptor/20314-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18615-1">
    <skos:broader rdf:resource="thsys/70940"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18615-1">
    <skos:broader rdf:resource="descriptor/13264-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="http://www.w3.org/2004/02/skos/core#OrderedCollection">
    <skos:definition xml:lang="en">An ordered collection of concepts, where both the grouping and
      the ordering are meaningful.</skos:definition>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70941">
    <skos:prefLabel xml:lang="en">W.12.01.01  Rail transport</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70941">
    <skos:prefLabel xml:lang="de">W.12.01.01  Schienenverkehr</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="http://www.w3.org/2004/02/skos/core#narrowerTransitive">
    <skos:definition>skos:narrowerTransitive is a transitive superproperty of skos:broader. By
      convention, skos:narrowerTransitive is not intended to be used in assertions, but provides a
      mechanism whereby the transitive closure of skos:narrower can be queried.</skos:definition>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19702-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16541-0">
    <zbwext:useInsteadNote rdf:nodeID="id283"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17983-5">
    <skos:prefLabel xml:lang="en">EU countries</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17983-5">
    <skos:prefLabel xml:lang="de">EU-Staaten</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14014-5">
    <skos:altLabel xml:lang="de">Sozialpädagoginnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14014-5">
    <skos:altLabel xml:lang="de">Sozialpädagogen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14014-5">
    <skos:altLabel xml:lang="de">Sozialhelfer</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14014-5">
    <skos:altLabel xml:lang="de">Sozialfürsorgerinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14014-5">
    <skos:altLabel xml:lang="de">Sozialfürsorger</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14014-5">
    <skos:altLabel xml:lang="de">Sozialarbeiterinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14014-5">
    <skos:altLabel xml:lang="de">Sozialarbeiter</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14014-5">
    <skos:altLabel xml:lang="de">Kindergärtnerinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14014-5">
    <skos:altLabel xml:lang="de">Kindergärtner</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14014-5">
    <skos:altLabel xml:lang="de">Jugendpfleger</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14014-5">
    <skos:altLabel xml:lang="de">Jugendhelfer</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18599-1">
    <skos:broader rdf:resource="thsys/71055"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18599-1">
    <skos:broader rdf:resource="thsys/70933"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18599-1">
    <skos:broader rdf:resource="descriptor/13979-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10022-5">
    <skos:narrower rdf:resource="descriptor/18157-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10088-3">
    <skos:related rdf:resource="descriptor/10109-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10088-3">
    <skos:related rdf:resource="descriptor/10106-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10088-3">
    <skos:related rdf:resource="descriptor/10089-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10347-5">
    <skos:broader rdf:resource="thsys/70020"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10347-5">
    <skos:broader rdf:resource="descriptor/10249-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11370-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12774-4">
    <skos:narrower rdf:resource="descriptor/19149-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12774-4">
    <skos:narrower rdf:resource="descriptor/13485-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12774-4">
    <skos:narrower rdf:resource="descriptor/10851-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19460-6">
    <skos:broader rdf:resource="thsys/71065"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19460-6">
    <skos:broader rdf:resource="descriptor/10025-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18992-6">
    <skos:narrower rdf:resource="descriptor/11646-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12543-2">
    <skos:prefLabel xml:lang="en">Depreciation</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12543-2">
    <skos:prefLabel xml:lang="de">Abschreibung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16509-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15733-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10704-0">
    <skos:prefLabel xml:lang="en">Most favoured nation</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10704-0">
    <skos:prefLabel xml:lang="de">Meistbegünstigung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18314-1">
    <zbwext:useInsteadNote rdf:nodeID="id338"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19507-6">
    <skos:prefLabel xml:lang="en">Welfare recipients</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19507-6">
    <skos:prefLabel xml:lang="de">Sozialhilfeempfänger</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16615-4">
    <skos:broader rdf:resource="thsys/70321"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13537-6">
    <skos:prefLabel xml:lang="en">Cargo handling in port</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13537-6">
    <skos:prefLabel xml:lang="de">Hafenumschlag</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19368-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18740-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19547-1">
    <skos:related rdf:resource="descriptor/19263-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19547-1">
    <skos:related rdf:resource="descriptor/11495-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19547-1">
    <skos:related rdf:resource="descriptor/11494-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19547-1">
    <skos:related rdf:resource="descriptor/19262-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18210-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13769-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14633-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18325-3">
    <skos:prefLabel xml:lang="en">Sustainable development</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18325-3">
    <skos:prefLabel xml:lang="de">Nachhaltige Entwicklung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18937-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14195-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70897">
    <skos:broader rdf:resource="thsys/70900"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10621-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12619-2">
    <skos:prefLabel xml:lang="en">Learning process</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12619-2">
    <skos:prefLabel xml:lang="de">Lernprozess</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18092-0">
    <skos:altLabel xml:lang="en">Distribution information system</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18092-0">
    <skos:altLabel xml:lang="de">WWS (Warenwirtschaftssystem)</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19337-5">
    <skos:prefLabel xml:lang="en">Currency crisis</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19337-5">
    <skos:prefLabel xml:lang="de">Währungskrise</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16027-0">
    <skos:prefLabel xml:lang="en">Marriage law</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16027-0">
    <skos:prefLabel xml:lang="de">Eherecht</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19184-4">
    <skos:broader rdf:resource="thsys/71007"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19184-4">
    <skos:broader rdf:resource="thsys/70957"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19184-4">
    <skos:broader rdf:resource="descriptor/18995-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11658-4">
    <skos:broader rdf:resource="thsys/71074"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11658-4">
    <skos:broader rdf:resource="thsys/71066"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11658-4">
    <skos:broader rdf:resource="descriptor/11681-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11020-4">
    <skos:prefLabel xml:lang="en">Planning agency</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11020-4">
    <skos:prefLabel xml:lang="de">Planungsbehörde</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13470-5">
    <skos:prefLabel xml:lang="en">Market fair</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13470-5">
    <skos:prefLabel xml:lang="de">Marktveranstaltung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11547-6">
    <skos:altLabel xml:lang="de">Besteuerung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14337-2">
    <skos:prefLabel xml:lang="en">Air conditioner</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14337-2">
    <skos:prefLabel xml:lang="de">Klimaanlage</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11679-3">
    <skos:altLabel xml:lang="de">Unternehmensteuer</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13530-6">
    <skos:broader rdf:resource="thsys/70936"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13530-6">
    <skos:broader rdf:resource="descriptor/13256-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19537-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12401-1">
    <skos:broader rdf:resource="thsys/71043"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12401-1">
    <skos:broader rdf:resource="descriptor/10019-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12401-1">
    <skos:broader rdf:resource="descriptor/12274-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17176-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14034-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16014-2">
    <skos:prefLabel xml:lang="en">Liability of the state</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16014-2">
    <skos:prefLabel xml:lang="de">Staatshaftung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10543-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16283-3">
    <skos:related rdf:resource="descriptor/16336-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16283-3">
    <skos:related rdf:resource="descriptor/19703-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16283-3">
    <skos:related rdf:resource="descriptor/11127-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16283-3">
    <skos:related rdf:resource="descriptor/18068-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16283-3">
    <skos:related rdf:resource="descriptor/16509-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18270-2">
    <skos:altLabel xml:lang="en">MIMD (Multiple Instruction Multiple Data)</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18270-2">
    <skos:altLabel xml:lang="de">Multiprozessorrechner</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13055-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id201">
    <rdf:value xml:lang="de">Für Effekte wirtschaftspolitischer Maßnahmen</rdf:value>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13584-4">
    <skos:altLabel xml:lang="en">Modal choice in transportation</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13584-4">
    <skos:altLabel xml:lang="en">Choice of mode</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13584-4">
    <skos:altLabel xml:lang="de">Transportmittelwahl</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13584-4">
    <skos:altLabel xml:lang="de">Reisemittelwahl</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11407-1">
    <skos:scopeNote xml:lang="de">Bezieht sich auf die wirtschaftlichen Aspekte des Bildungsverhaltens und die gesamtwirtschaftliche Auswirkung von Struktur und Entwicklung des Bildungswesens.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16539-1">
    <skos:prefLabel xml:lang="en">Pension finance</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16539-1">
    <skos:prefLabel xml:lang="de">Rentenfinanzierung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14906-3">
    <skos:altLabel xml:lang="de">Herrenwäsche</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14906-3">
    <skos:altLabel xml:lang="de">Herrenoberbekleidung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19306-2">
    <skos:related rdf:resource="descriptor/19307-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19306-2">
    <skos:related rdf:resource="descriptor/18316-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19306-2">
    <skos:related rdf:resource="descriptor/14084-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19306-2">
    <skos:related rdf:resource="descriptor/13165-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15773-5">
    <skos:prefLabel xml:lang="en">Environmental costs</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15773-5">
    <skos:prefLabel xml:lang="de">Umweltschutzkosten</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10344-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11321-4">
    <skos:broader rdf:resource="thsys/71113"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11321-4">
    <skos:broader rdf:resource="thsys/70278"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11321-4">
    <skos:broader rdf:resource="thsys/70245"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11321-4">
    <skos:broader rdf:resource="descriptor/11341-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11321-4">
    <skos:broader rdf:resource="descriptor/11322-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11321-4">
    <skos:broader rdf:resource="descriptor/11769-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16995-3">
    <skos:altLabel xml:lang="en">Danmark</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16995-3">
    <skos:altLabel xml:lang="de">Königreich Dänemark</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12570-6">
    <skos:broader rdf:resource="thsys/73385"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12570-6">
    <skos:broader rdf:resource="thsys/70244"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12570-6">
    <skos:broader rdf:resource="descriptor/12571-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71028">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18986-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71004">
    <skos:broader rdf:resource="thsys/71005"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18943-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10973-1">
    <skos:broader rdf:resource="thsys/70038"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10973-1">
    <skos:broader rdf:resource="descriptor/10981-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14728-1">
    <skos:related rdf:resource="descriptor/13002-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14728-1">
    <skos:related rdf:resource="descriptor/19785-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14728-1">
    <skos:related rdf:resource="descriptor/13193-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14728-1">
    <skos:related rdf:resource="descriptor/14042-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14728-1">
    <skos:related rdf:resource="descriptor/14068-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14728-1">
    <skos:related rdf:resource="descriptor/16670-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14728-1">
    <skos:related rdf:resource="descriptor/14734-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14728-1">
    <skos:related rdf:resource="descriptor/13371-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14728-1">
    <skos:related rdf:resource="descriptor/14724-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14728-1">
    <skos:related rdf:resource="descriptor/14026-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14728-1">
    <skos:related rdf:resource="descriptor/14723-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14728-1">
    <skos:related rdf:resource="descriptor/19539-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14728-1">
    <skos:related rdf:resource="descriptor/18259-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14728-1">
    <skos:related rdf:resource="descriptor/19675-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19410-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19198-0">
    <skos:scopeNote xml:lang="de">Auch für Glaubwürdigkeit wirtschaftspolitischer Ankündigungen.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11849-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71010">
    <skos:broader rdf:resource="thsys/w"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19037-3">
    <skos:broader rdf:resource="thsys/72186"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15971-1">
    <skos:altLabel xml:lang="de">Rechtsentscheidung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15971-1">
    <skos:altLabel xml:lang="de">Rechtsentscheid</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15971-1">
    <skos:altLabel xml:lang="de">Präzedenzfall</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15971-1">
    <skos:altLabel xml:lang="de">Gerichtsentscheidung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15971-1">
    <skos:altLabel xml:lang="de">Gerichtsentscheid</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14936-1">
    <skos:broader rdf:resource="thsys/70498"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14936-1">
    <skos:broader rdf:resource="descriptor/14931-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19764-0">
    <skos:altLabel xml:lang="de">Gesetz zum Schutz der Beschäftigten vor sexueller Belästigung am Arbeitsplatz</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70337">
    <skos:narrower rdf:resource="descriptor/15005-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70337">
    <skos:narrower rdf:resource="descriptor/14422-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70337">
    <skos:narrower rdf:resource="descriptor/14413-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70337">
    <skos:narrower rdf:resource="descriptor/18223-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70337">
    <skos:narrower rdf:resource="descriptor/14450-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70337">
    <skos:narrower rdf:resource="descriptor/14600-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70337">
    <skos:narrower rdf:resource="descriptor/15001-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12592-3">
    <skos:prefLabel xml:lang="en">Fringe benefits</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12592-3">
    <skos:prefLabel xml:lang="de">Betriebliche Sozialleistungen</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11361-6">
    <skos:prefLabel xml:lang="en">Vocational training</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11361-6">
    <skos:prefLabel xml:lang="de">Berufsausbildung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10597-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14164-0">
    <skos:related rdf:resource="descriptor/12963-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17753-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16771-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13571-6">
    <skos:prefLabel xml:lang="en">Transport sociology</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13571-6">
    <skos:prefLabel xml:lang="de">Verkehrssoziologie</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19174-0">
    <skos:altLabel xml:lang="de">CARICOM-Länder</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16300-1">
    <skos:related rdf:resource="descriptor/16416-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16300-1">
    <skos:related rdf:resource="descriptor/16264-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16300-1">
    <skos:related rdf:resource="descriptor/18062-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16300-1">
    <skos:related rdf:resource="descriptor/16299-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16300-1">
    <skos:related rdf:resource="descriptor/15797-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11068-4">
    <skos:broader rdf:resource="thsys/70039"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15918-5">
    <skos:related rdf:resource="descriptor/16615-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15918-5">
    <skos:related rdf:resource="descriptor/16421-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15918-5">
    <skos:related rdf:resource="descriptor/15928-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15918-5">
    <skos:related rdf:resource="descriptor/16264-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15918-5">
    <skos:related rdf:resource="descriptor/18062-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15918-5">
    <skos:related rdf:resource="descriptor/16299-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15918-5">
    <skos:related rdf:resource="descriptor/16512-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15918-5">
    <skos:related rdf:resource="descriptor/16661-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15918-5">
    <skos:related rdf:resource="descriptor/19639-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15918-5">
    <skos:related rdf:resource="descriptor/16556-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15918-5">
    <skos:related rdf:resource="descriptor/15931-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15918-5">
    <skos:related rdf:resource="descriptor/15907-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18165-6">
    <skos:related rdf:resource="descriptor/15771-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18165-6">
    <skos:related rdf:resource="descriptor/15770-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18165-6">
    <skos:related rdf:resource="descriptor/15768-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18165-6">
    <skos:related rdf:resource="descriptor/15767-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18165-6">
    <skos:related rdf:resource="descriptor/19633-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18165-6">
    <skos:related rdf:resource="descriptor/18186-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18165-6">
    <skos:related rdf:resource="descriptor/20125-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18165-6">
    <skos:related rdf:resource="descriptor/18453-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18165-6">
    <skos:related rdf:resource="descriptor/12879-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71074">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11526-0">
    <skos:related rdf:resource="descriptor/16212-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11526-0">
    <skos:related rdf:resource="descriptor/10975-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11526-0">
    <skos:related rdf:resource="descriptor/11540-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11526-0">
    <skos:related rdf:resource="descriptor/11525-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11526-0">
    <skos:related rdf:resource="descriptor/11728-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13361-3">
    <skos:broader rdf:resource="thsys/70822"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13361-3">
    <skos:broader rdf:resource="descriptor/13350-1"/>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id257">
    <rdf:value xml:lang="de">Für Fernmeldeunternehmen allein</rdf:value>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13967-2">
    <skos:broader rdf:resource="thsys/71055"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13967-2">
    <skos:broader rdf:resource="thsys/70876"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13967-2">
    <skos:broader rdf:resource="descriptor/18535-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11735-5">
    <skos:related rdf:resource="descriptor/21082-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11735-5">
    <skos:related rdf:resource="descriptor/11765-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11735-5">
    <skos:related rdf:resource="descriptor/11779-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11735-5">
    <skos:related rdf:resource="descriptor/11752-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11735-5">
    <skos:related rdf:resource="descriptor/11751-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11735-5">
    <skos:related rdf:resource="descriptor/11692-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11735-5">
    <skos:related rdf:resource="descriptor/11770-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11735-5">
    <skos:related rdf:resource="descriptor/11753-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11735-5">
    <skos:related rdf:resource="descriptor/11713-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16030-4">
    <skos:related rdf:resource="descriptor/19774-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16030-4">
    <skos:related rdf:resource="descriptor/16477-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16030-4">
    <skos:related rdf:resource="descriptor/15938-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16030-4">
    <skos:related rdf:resource="descriptor/16029-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15860-3">
    <skos:narrower rdf:resource="descriptor/10056-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15860-3">
    <skos:narrower rdf:resource="descriptor/19216-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15163-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12253-4">
    <skos:prefLabel xml:lang="en">Credit rating</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12253-4">
    <skos:prefLabel xml:lang="de">Kreditwürdigkeit</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10725-6">
    <skos:altLabel xml:lang="en">Capital control</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10725-6">
    <skos:altLabel xml:lang="de">Kapitalverkehrskontrolle</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10725-6">
    <skos:altLabel xml:lang="de">Kapitalverkehrsbeschränkung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10725-6">
    <skos:altLabel xml:lang="de">Kapitalexportverbot</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10725-6">
    <skos:altLabel xml:lang="de">Kapitalausfuhrverbot</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/24707-3">
    <skos:related rdf:resource="descriptor/10021-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/24707-3">
    <skos:related rdf:resource="descriptor/19196-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12302-3">
    <skos:narrower rdf:resource="descriptor/19379-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12302-3">
    <skos:narrower rdf:resource="descriptor/25621-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12302-3">
    <skos:narrower rdf:resource="descriptor/13692-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16201-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13011-2">
    <skos:broader rdf:resource="thsys/71008"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13011-2">
    <skos:broader rdf:resource="descriptor/13020-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18157-5">
    <skos:broader rdf:resource="thsys/71089"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18157-5">
    <skos:broader rdf:resource="thsys/71084"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18157-5">
    <skos:broader rdf:resource="descriptor/10022-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18157-5">
    <skos:broader rdf:resource="descriptor/19358-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19381-2">
    <skos:related rdf:resource="descriptor/19416-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11893-1">
    <skos:altLabel xml:lang="de">Wochenendpendlerinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11893-1">
    <skos:altLabel xml:lang="de">Wochenendpendler</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11893-1">
    <skos:altLabel xml:lang="de">Tagespendlerinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11893-1">
    <skos:altLabel xml:lang="de">Tagespendler</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11893-1">
    <skos:altLabel xml:lang="de">Schülerpendlerinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11893-1">
    <skos:altLabel xml:lang="de">Schülerpendler</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11893-1">
    <skos:altLabel xml:lang="de">Pendlerinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11893-1">
    <skos:altLabel xml:lang="de">Pendler</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11893-1">
    <skos:altLabel xml:lang="de">Pendelwanderung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11893-1">
    <skos:altLabel xml:lang="de">Pendelströme</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11893-1">
    <skos:altLabel xml:lang="de">Grenzpendlerinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11893-1">
    <skos:altLabel xml:lang="de">Grenzpendler</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18413-6">
    <skos:broader rdf:resource="thsys/71002"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18413-6">
    <skos:broader rdf:resource="descriptor/13058-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10963-4">
    <skos:related rdf:resource="descriptor/10956-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10963-4">
    <skos:related rdf:resource="descriptor/10964-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10963-4">
    <skos:related rdf:resource="descriptor/10942-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10963-4">
    <skos:related rdf:resource="descriptor/10895-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10963-4">
    <skos:related rdf:resource="descriptor/10949-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10963-4">
    <skos:related rdf:resource="descriptor/10891-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14784-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16084-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13336-2">
    <skos:broader rdf:resource="thsys/70818"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13336-2">
    <skos:broader rdf:resource="descriptor/15727-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18832-0">
    <skos:broader rdf:resource="thsys/73386"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18832-0">
    <skos:broader rdf:resource="thsys/70853"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18832-0">
    <skos:broader rdf:resource="thsys/70180"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18832-0">
    <skos:broader rdf:resource="descriptor/15722-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18832-0">
    <skos:broader rdf:resource="descriptor/16709-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16295-3">
    <skos:narrower rdf:resource="descriptor/19379-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19734-2">
    <skos:altLabel xml:lang="en">Philosophy of economics</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19734-2">
    <skos:altLabel xml:lang="de">Philosophie der Ökonomik</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13680-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15772-0">
    <skos:broader rdf:resource="thsys/70239"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15772-0">
    <skos:broader rdf:resource="descriptor/19711-0"/>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id348">
    <rdf:value xml:lang="de">Für verhaltenswissenschaftlich/verhaltenspsychologisch ausgerichtete ökonomische Analysen</rdf:value>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18762-2">
    <skos:narrower rdf:resource="descriptor/13390-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18762-2">
    <skos:narrower rdf:resource="descriptor/13346-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18762-2">
    <skos:narrower rdf:resource="descriptor/18424-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18762-2">
    <skos:narrower rdf:resource="descriptor/13379-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18762-2">
    <skos:narrower rdf:resource="descriptor/18763-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19053-5">
    <skos:related rdf:resource="descriptor/19063-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19053-5">
    <skos:related rdf:resource="descriptor/14042-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19053-5">
    <skos:related rdf:resource="descriptor/15908-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70838">
    <skos:prefLabel xml:lang="en">W.25.01  Occupational health</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70838">
    <skos:prefLabel xml:lang="de">W.25.01  Betriebliche Gesundheitspolitik</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19680-6">
    <skos:related rdf:resource="descriptor/16544-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19680-6">
    <skos:related rdf:resource="descriptor/19752-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19680-6">
    <skos:related rdf:resource="descriptor/18830-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19680-6">
    <skos:related rdf:resource="descriptor/11825-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19680-6">
    <skos:related rdf:resource="descriptor/19773-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19680-6">
    <skos:related rdf:resource="descriptor/16587-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19680-6">
    <skos:related rdf:resource="descriptor/18073-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11326-1">
    <skos:altLabel xml:lang="en">Wage Share</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11326-1">
    <skos:altLabel xml:lang="de">Gesamtwirtschaftliche Lohnquote</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71009">
    <skos:prefLabel xml:lang="en">W.05.01  Mining</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71009">
    <skos:prefLabel xml:lang="de">W.05.01  Bergbau</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id377">
    <rdfs:seeAlso rdf:resource="descriptor/12041-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10567-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11558-1">
    <skos:related rdf:resource="descriptor/16545-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11558-1">
    <skos:related rdf:resource="descriptor/16542-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11558-1">
    <skos:related rdf:resource="descriptor/12592-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11521-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18612-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14608-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14015-3">
    <skos:prefLabel xml:lang="en">Social scientists</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14015-3">
    <skos:prefLabel xml:lang="de">Sozialwissenschaftler</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12206-6">
    <skos:altLabel xml:lang="de">Finanzierungslehre</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13995-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10241-0">
    <skos:altLabel xml:lang="en">Aggregate supply function</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10241-0">
    <skos:altLabel xml:lang="de">Makroökonomische Angebotsfunktion</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10241-0">
    <skos:altLabel xml:lang="de">Angebotsfunktion der Gesamtwirtschaft</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10241-0">
    <skos:altLabel xml:lang="de">Angebot der Gesamtwirtschaft</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19451-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17609-1">
    <skos:broader rdf:resource="thsys/70561"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17609-1">
    <skos:broader rdf:resource="descriptor/19167-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19518-1">
    <skos:related rdf:resource="descriptor/18903-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19518-1">
    <skos:related rdf:resource="descriptor/13372-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16957-4">
    <skos:altLabel xml:lang="de">Appenzell Innerrhoden</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16957-4">
    <skos:altLabel xml:lang="de">Appenzell Außerrhoden</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11771-1">
    <skos:narrower rdf:resource="descriptor/10985-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11771-1">
    <skos:narrower rdf:resource="descriptor/19235-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19623-4">
    <skos:prefLabel xml:lang="en">Air</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19623-4">
    <skos:prefLabel xml:lang="de">Luft</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13283-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13516-0">
    <skos:prefLabel xml:lang="en">Airport</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13516-0">
    <skos:prefLabel xml:lang="de">Flughafen</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19416-2">
    <skos:broader rdf:resource="thsys/71075"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19416-2">
    <skos:broader rdf:resource="descriptor/20189-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19416-2">
    <skos:broader rdf:resource="descriptor/11547-6"/>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id11">
    <rdf:value xml:lang="de">Für ambulante Pflege</rdf:value>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16541-0">
    <skos:altLabel xml:lang="de">Soziale Rehabilitation</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16541-0">
    <skos:altLabel xml:lang="de">Schwerbehindertenrehabilitation</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16541-0">
    <skos:altLabel xml:lang="de">Rehabilitationsmaßnahme</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16541-0">
    <skos:altLabel xml:lang="de">Medizinische Rehabilitation</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16541-0">
    <skos:altLabel xml:lang="de">Behindertenrehabilitation</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10124-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19941-4">
    <skos:scopeNote xml:lang="de">Aufsicht bzw. Kontrolle der EU über die Subventionspolitik der Mitgliedstaaten zur Verhinderung missbräuchlicher Beihilfen und Subventionen.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19804-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19305-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70866">
    <skos:narrower rdf:resource="descriptor/11125-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70866">
    <skos:narrower rdf:resource="descriptor/10882-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70866">
    <skos:narrower rdf:resource="descriptor/16648-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70866">
    <skos:narrower rdf:resource="descriptor/10603-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70866">
    <skos:narrower rdf:resource="descriptor/13407-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70866">
    <skos:narrower rdf:resource="descriptor/16489-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11956-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18955-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10628-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11702-6">
    <skos:scopeNote xml:lang="de">Selektive Ausnahmen von der allgemeinen Steuerpflicht.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18655-3">
    <skos:broader rdf:resource="thsys/70922"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18655-3">
    <skos:broader rdf:resource="descriptor/13278-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15742-2">
    <skos:broader rdf:resource="thsys/73351"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15742-2">
    <skos:broader rdf:resource="thsys/70239"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15742-2">
    <skos:broader rdf:resource="descriptor/15737-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18844-0">
    <skos:prefLabel xml:lang="en">Tenants' association</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18844-0">
    <skos:prefLabel xml:lang="de">Mieterorganisation</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11966-0">
    <skos:broader rdf:resource="thsys/71064"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11966-0">
    <skos:broader rdf:resource="descriptor/11970-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12736-5">
    <skos:narrower rdf:resource="descriptor/12737-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14439-1">
    <skos:prefLabel xml:lang="en">Bus</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14439-1">
    <skos:prefLabel xml:lang="de">Omnibus</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18882-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/21072-0">
    <skos:scopeNote xml:lang="de">Literatur über den Umfang des Versicherungsschutzes und über den Anteil der gegen ein Risiko versicherten bzw. nicht versicherten Bevölkerung. Es wird mit der jeweiligen Versicherungssparte postkoordiniert.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14428-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10984-3">
    <skos:prefLabel xml:lang="en">Interest group</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10984-3">
    <skos:prefLabel xml:lang="de">Interessenvertretung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17727-2">
    <skos:prefLabel xml:lang="en">Angola</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17727-2">
    <skos:prefLabel xml:lang="de">Angola</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18214-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17626-1">
    <skos:broader rdf:resource="thsys/70253"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17626-1">
    <skos:broader rdf:resource="descriptor/17608-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17626-1">
    <skos:broader rdf:resource="descriptor/17978-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19136-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18531-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12898-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13340-4">
    <skos:related rdf:resource="descriptor/13560-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13340-4">
    <skos:related rdf:resource="descriptor/13330-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70199">
    <rdfs:label xml:lang="de">Pharmazeutische Produkte</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73355">
    <skos:prefLabel xml:lang="de">N.06.04.01  Wirtschafts- und Industriesoziologie, Siedlungssoziologie</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18170-6">
    <skos:scopeNote xml:lang="de">Konstruktion und Rekonstruktion von Bildern aus Daten</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19823-3">
    <skos:broader rdf:resource="thsys/73392"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19823-3">
    <skos:broader rdf:resource="descriptor/16035-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14310-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12897-2">
    <skos:altLabel xml:lang="de">Grundsätze ordnungsmäßiger Abschlussprüfung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12897-2">
    <skos:altLabel xml:lang="de">Grundsätze ordnungsmäßiger Abschlußprüfung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10112-4">
    <skos:broader rdf:resource="thsys/71111"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10112-4">
    <skos:broader rdf:resource="thsys/70057"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10112-4">
    <skos:broader rdf:resource="descriptor/10113-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15993-5">
    <skos:altLabel xml:lang="de">Kohleverstromungsgesetz</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15993-5">
    <skos:altLabel xml:lang="de">EnWG (Energiewirtschaftsgesetz)</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15993-5">
    <skos:altLabel xml:lang="de">Energiewirtschaftsrecht</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15993-5">
    <skos:altLabel xml:lang="de">Energiewirtschaftsgesetz</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15993-5">
    <skos:altLabel xml:lang="de">Energiesicherungsgesetz</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15993-5">
    <skos:altLabel xml:lang="de">Energiegesetz</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15993-5">
    <skos:altLabel xml:lang="de">Energieeinsparungsgesetz</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16521-6">
    <skos:prefLabel xml:lang="en">National security</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16521-6">
    <skos:prefLabel xml:lang="de">Nationale Sicherheit</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13281-1">
    <skos:prefLabel xml:lang="en">Pawnshop</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13281-1">
    <skos:prefLabel xml:lang="de">Leihhaus</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15880-4">
    <skos:broader rdf:resource="thsys/73352"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10465-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18006-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14723-4">
    <skos:scopeNote xml:lang="de">für Sucht, Drogenpolitik und drogenökonomische Fragen BENUTZE die entsprechenden Deskriptoren.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14723-4">
    <skos:scopeNote xml:lang="de">Natürliche, halbsynthetische oder künstlich hergestellte Stoffe, die zu einer Veränderung des Bewusstseinszustands führen können.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16564-2">
    <skos:narrower rdf:resource="descriptor/19766-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16564-2">
    <skos:narrower rdf:resource="descriptor/16687-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16564-2">
    <skos:narrower rdf:resource="descriptor/13571-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16564-2">
    <skos:narrower rdf:resource="descriptor/16695-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16564-2">
    <skos:narrower rdf:resource="descriptor/11992-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16564-2">
    <skos:narrower rdf:resource="descriptor/13861-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16564-2">
    <skos:narrower rdf:resource="descriptor/16688-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16564-2">
    <skos:narrower rdf:resource="descriptor/12110-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16564-2">
    <skos:narrower rdf:resource="descriptor/16684-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16564-2">
    <skos:narrower rdf:resource="descriptor/16680-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16564-2">
    <skos:narrower rdf:resource="descriptor/16700-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16564-2">
    <skos:narrower rdf:resource="descriptor/16692-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16564-2">
    <skos:narrower rdf:resource="descriptor/16683-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16564-2">
    <skos:narrower rdf:resource="descriptor/16698-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16564-2">
    <skos:narrower rdf:resource="descriptor/13445-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10717-5">
    <skos:broader rdf:resource="thsys/71095"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10717-5">
    <skos:broader rdf:resource="descriptor/10722-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70932">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20002-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11262-1">
    <skos:altLabel xml:lang="de">Werktätige</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11262-1">
    <skos:altLabel xml:lang="de">Personal</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11262-1">
    <skos:altLabel xml:lang="de">Mitarbeiter</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11262-1">
    <skos:altLabel xml:lang="de">Lohnempfänger</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11262-1">
    <skos:altLabel xml:lang="de">Lohnabhängige</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11262-1">
    <skos:altLabel xml:lang="de">Erwerbstätige</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11262-1">
    <skos:altLabel xml:lang="de">Betriebsangehörige</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11262-1">
    <skos:altLabel xml:lang="de">Beschäftigte</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11262-1">
    <skos:altLabel xml:lang="de">Besatzung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11262-1">
    <skos:altLabel xml:lang="de">Belegschaft</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11262-1">
    <skos:altLabel xml:lang="de">Arbeitskräftestruktur</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11262-1">
    <skos:altLabel xml:lang="de">Arbeitnehmer</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15628-0">
    <skos:altLabel xml:lang="de">Nukleartechnik</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15628-0">
    <skos:altLabel xml:lang="de">Nuklearforschung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15628-0">
    <skos:altLabel xml:lang="de">Kerntechnik</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15628-0">
    <skos:altLabel xml:lang="de">Kernphysik</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15628-0">
    <skos:altLabel xml:lang="de">Kernenergieforschung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15628-0">
    <skos:altLabel xml:lang="de">Atomtechnik</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15628-0">
    <skos:altLabel xml:lang="de">Atomforschung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15628-0">
    <skos:altLabel xml:lang="de">Atomenergieforschung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13678-2">
    <skos:prefLabel xml:lang="en">Telephone network</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13678-2">
    <skos:prefLabel xml:lang="de">Telefonnetz</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19524-6">
    <skos:broader rdf:resource="thsys/70049"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71119">
    <skos:prefLabel xml:lang="de">V.02.04  Markttheorie</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18078-1">
    <skos:prefLabel xml:lang="en">Engineering plastics</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18078-1">
    <skos:prefLabel xml:lang="de">Technischer Kunststoff</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12204-3">
    <skos:broader rdf:resource="thsys/70897"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12204-3">
    <skos:broader rdf:resource="thsys/70187"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12204-3">
    <skos:broader rdf:resource="descriptor/12210-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13962-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18841-6">
    <skos:scopeNote xml:lang="de">Beinhaltet vor allem rechts- und sozialwissenschaftliche sowie ökonomische Aspekte.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16143-5">
    <skos:altLabel xml:lang="en">Short-term disability benefit</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16143-5">
    <skos:altLabel xml:lang="de">Lohngarantie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16143-5">
    <skos:altLabel xml:lang="de">Lohnfortzahlungsgesetz</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16143-5">
    <skos:altLabel xml:lang="de">Gesetz über die Fortzahlung des Arbeitsentgelts im Krankheitsfalle</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16143-5">
    <skos:altLabel xml:lang="de">Garantierter Jahreslohn</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14053-2">
    <skos:related rdf:resource="descriptor/14189-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14053-2">
    <skos:related rdf:resource="descriptor/13179-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14053-2">
    <skos:related rdf:resource="descriptor/18380-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11258-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18222-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13024-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14236-1">
    <skos:related rdf:resource="descriptor/14255-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14236-1">
    <skos:related rdf:resource="descriptor/18388-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14236-1">
    <skos:related rdf:resource="descriptor/13019-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14236-1">
    <skos:related rdf:resource="descriptor/14601-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14236-1">
    <skos:related rdf:resource="descriptor/14192-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14236-1">
    <skos:related rdf:resource="descriptor/12980-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14236-1">
    <skos:related rdf:resource="descriptor/14021-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70536">
    <skos:narrower rdf:resource="descriptor/14741-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70536">
    <skos:narrower rdf:resource="descriptor/14739-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70536">
    <skos:narrower rdf:resource="descriptor/14738-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70536">
    <skos:narrower rdf:resource="descriptor/14622-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70536">
    <skos:narrower rdf:resource="descriptor/14737-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70536">
    <skos:narrower rdf:resource="descriptor/14736-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70536">
    <skos:narrower rdf:resource="descriptor/14735-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70536">
    <skos:narrower rdf:resource="descriptor/14734-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70536">
    <skos:narrower rdf:resource="descriptor/18263-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70536">
    <skos:narrower rdf:resource="descriptor/14733-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70536">
    <skos:narrower rdf:resource="descriptor/14732-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70536">
    <skos:narrower rdf:resource="descriptor/18264-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70536">
    <skos:narrower rdf:resource="descriptor/18265-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70536">
    <skos:narrower rdf:resource="descriptor/18282-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14525-1">
    <skos:prefLabel xml:lang="en">Video product</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14525-1">
    <skos:prefLabel xml:lang="de">Videoprodukt</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70927">
    <skos:broader rdf:resource="thsys/70928"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19412-3">
    <skos:related rdf:resource="descriptor/19236-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11629-4">
    <skos:narrower rdf:resource="descriptor/13249-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19374-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13315-3">
    <skos:altLabel xml:lang="en">Funeral director</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13315-3">
    <skos:altLabel xml:lang="de">Leichenbestatter</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13315-3">
    <skos:altLabel xml:lang="de">Krematorium</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13315-3">
    <skos:altLabel xml:lang="de">Grabverkauf</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13315-3">
    <skos:altLabel xml:lang="de">Friedhof</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13315-3">
    <skos:altLabel xml:lang="de">Beerdigungsinstitut</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11302-1">
    <skos:related rdf:resource="descriptor/13992-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11302-1">
    <skos:related rdf:resource="descriptor/18159-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11302-1">
    <skos:related rdf:resource="descriptor/18083-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11302-1">
    <skos:related rdf:resource="descriptor/12085-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11302-1">
    <skos:related rdf:resource="descriptor/20948-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11302-1">
    <skos:related rdf:resource="descriptor/11274-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11302-1">
    <skos:related rdf:resource="descriptor/11320-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11302-1">
    <skos:related rdf:resource="descriptor/15825-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11302-1">
    <skos:related rdf:resource="descriptor/15823-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11302-1">
    <skos:related rdf:resource="descriptor/12570-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11302-1">
    <skos:related rdf:resource="descriptor/18143-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11302-1">
    <skos:related rdf:resource="descriptor/16658-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13333-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19081-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18323-0">
    <skos:prefLabel xml:lang="en">Financing of rural development</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18323-0">
    <skos:prefLabel xml:lang="de">Ländliche Entwicklungsfinanzierung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10781-3">
    <skos:related rdf:resource="descriptor/13743-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10781-3">
    <skos:related rdf:resource="descriptor/10821-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10781-3">
    <skos:related rdf:resource="descriptor/10773-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10781-3">
    <skos:related rdf:resource="descriptor/19337-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10781-3">
    <skos:related rdf:resource="descriptor/19333-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10781-3">
    <skos:related rdf:resource="descriptor/10779-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10781-3">
    <skos:related rdf:resource="descriptor/13757-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10781-3">
    <skos:related rdf:resource="descriptor/10776-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15908-1">
    <skos:related rdf:resource="descriptor/15679-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15908-1">
    <skos:related rdf:resource="descriptor/16155-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15908-1">
    <skos:related rdf:resource="descriptor/18180-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15908-1">
    <skos:related rdf:resource="descriptor/16670-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15908-1">
    <skos:related rdf:resource="descriptor/16529-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15908-1">
    <skos:related rdf:resource="descriptor/19053-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19450-2">
    <skos:broader rdf:resource="thsys/71068"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19450-2">
    <skos:broader rdf:resource="descriptor/11869-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13202-2">
    <skos:broader rdf:resource="thsys/70959"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13202-2">
    <skos:broader rdf:resource="descriptor/18522-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11504-3">
    <zbwext:useInsteadNote rdf:nodeID="id140"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12284-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17497-0">
    <skos:broader rdf:resource="thsys/71032"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17497-0">
    <skos:broader rdf:resource="descriptor/17595-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17497-0">
    <skos:broader rdf:resource="descriptor/19078-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/21094-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16300-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18664-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19626-5">
    <skos:broader rdf:resource="thsys/73351"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19626-5">
    <skos:broader rdf:resource="descriptor/19630-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17783-6">
    <skos:altLabel xml:lang="de">Republik Haiti</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18245-1">
    <skos:prefLabel xml:lang="en">Mobile robot</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18245-1">
    <skos:prefLabel xml:lang="de">Mobiler Roboter</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18498-0">
    <skos:related rdf:resource="descriptor/18604-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18498-0">
    <skos:related rdf:resource="descriptor/13516-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10223-2">
    <skos:broader rdf:resource="thsys/71119"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10223-2">
    <skos:broader rdf:resource="thsys/70242"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10223-2">
    <skos:broader rdf:resource="descriptor/10905-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18536-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19712-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/21082-4">
    <skos:prefLabel xml:lang="en">Distributional effect</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/21082-4">
    <skos:prefLabel xml:lang="de">Verteilungswirkung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70292">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12196-4">
    <skos:related rdf:resource="descriptor/10911-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12196-4">
    <skos:related rdf:resource="descriptor/12868-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12196-4">
    <skos:related rdf:resource="descriptor/16076-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12196-4">
    <skos:related rdf:resource="descriptor/12304-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12196-4">
    <skos:related rdf:resource="descriptor/11696-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12196-4">
    <skos:related rdf:resource="descriptor/12094-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12196-4">
    <skos:related rdf:resource="descriptor/12194-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12196-4">
    <skos:related rdf:resource="descriptor/18032-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19488-5">
    <skos:scopeNote xml:lang="de">Natürliche Ressourcen im Gemeineigentum.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13608-2">
    <skos:prefLabel xml:lang="en">Transport Management Science</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13608-2">
    <skos:prefLabel xml:lang="de">Verkehrsbetriebslehre</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14169-4">
    <skos:broader rdf:resource="thsys/73351"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14169-4">
    <skos:broader rdf:resource="thsys/70403"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13647-6">
    <skos:scopeNote xml:lang="de">Gesamtheit der Rechtsnormen zum Post- und Fernmeldewesen.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12292-1">
    <skos:scopeNote xml:lang="de">Wertpapierkäufe im Ausland zu Zwecken der Kapitalanlage ohne Absicht der Einflussnahme auf den Geschäftsbetrieb.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12779-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15765-4">
    <skos:scopeNote xml:lang="de">Interdisziplinärer Wissenschaftsbereich zur Analyse der Wechselbeziehungen zwischen Lebewesen und ihrer Umwelt bzw. von Ökosystemen.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19220-5">
    <skos:altLabel xml:lang="en">Wants</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19220-5">
    <skos:altLabel xml:lang="de">Bedürfnislehre</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19220-5">
    <skos:altLabel xml:lang="de">Bedürfnis</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19079-1">
    <skos:broader rdf:resource="thsys/70183"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19079-1">
    <skos:broader rdf:resource="descriptor/12251-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18676-2">
    <skos:broader rdf:resource="thsys/73390"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18676-2">
    <skos:broader rdf:resource="thsys/70893"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18676-2">
    <skos:broader rdf:resource="thsys/70187"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18676-2">
    <skos:broader rdf:resource="descriptor/13731-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14015-3">
    <skos:broader rdf:resource="thsys/71052"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14015-3">
    <skos:broader rdf:resource="descriptor/13349-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14522-0">
    <skos:broader rdf:resource="thsys/70373"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14522-0">
    <skos:broader rdf:resource="descriptor/18103-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19814-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10505-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12564-1">
    <skos:related rdf:resource="descriptor/19001-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12564-1">
    <skos:related rdf:resource="descriptor/19008-3"/>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id188">
    <rdfs:seeAlso rdf:resource="descriptor/18983-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11972-5">
    <skos:altLabel xml:lang="en">Megacity</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11972-5">
    <skos:altLabel xml:lang="de">Städteballung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11972-5">
    <skos:altLabel xml:lang="de">Megastadt</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13260-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13420-6">
    <skos:altLabel xml:lang="de">Staatsfunktion</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13420-6">
    <skos:altLabel xml:lang="de">Staatliche Rolle</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13420-6">
    <skos:altLabel xml:lang="de">Staatliche Ordnung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13420-6">
    <skos:altLabel xml:lang="de">Rolle des Staates</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19084-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19372-3">
    <skos:related rdf:resource="descriptor/19508-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19372-3">
    <skos:related rdf:resource="descriptor/11578-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19372-3">
    <skos:related rdf:resource="descriptor/11552-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19372-3">
    <skos:related rdf:resource="descriptor/11243-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12177-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16455-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71060">
    <skos:prefLabel xml:lang="en">V.13.01.03  Unemployment</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71060">
    <skos:prefLabel xml:lang="de">V.13.01.03  Arbeitslosigkeit</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19384-3">
    <skos:broader rdf:resource="thsys/71080"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19384-3">
    <skos:broader rdf:resource="descriptor/11568-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10183-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71096">
    <rdfs:label xml:lang="en">Tariffs</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71096">
    <rdfs:label xml:lang="de">Zoll</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18995-0">
    <skos:broader rdf:resource="thsys/71010"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18995-0">
    <skos:broader rdf:resource="thsys/70957"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18995-0">
    <skos:broader rdf:resource="thsys/70811"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18995-0">
    <skos:broader rdf:resource="descriptor/10012-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/71015">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Thsys"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10627-6">
    <skos:scopeNote xml:lang="de">Gemeinsamer Markt plus Koordinierung der Wirtschaftspolitik.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19376-2">
    <skos:prefLabel xml:lang="en">Generational accounting</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19376-2">
    <skos:prefLabel xml:lang="de">Intergenerative Belastungsrechnung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10147-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15063-1">
    <skos:broader rdf:resource="thsys/72182"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15063-1">
    <skos:broader rdf:resource="descriptor/15064-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16472-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18078-1">
    <skos:broader rdf:resource="thsys/70476"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18078-1">
    <skos:broader rdf:resource="descriptor/14702-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14188-0">
    <skos:prefLabel xml:lang="en">Water</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14188-0">
    <skos:prefLabel xml:lang="de">Wasser</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70134">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10208-5">
    <skos:related rdf:resource="descriptor/20522-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10208-5">
    <skos:related rdf:resource="descriptor/10894-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10208-5">
    <skos:related rdf:resource="descriptor/19223-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10208-5">
    <skos:related rdf:resource="descriptor/24662-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15019-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18970-2">
    <skos:altLabel xml:lang="en">Motherhood</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18970-2">
    <skos:altLabel xml:lang="en">Maternity</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18970-2">
    <skos:altLabel xml:lang="de">Mutterschaft</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18970-2">
    <skos:altLabel xml:lang="de">Mutter</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11187-3">
    <skos:broader rdf:resource="thsys/71116"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11187-3">
    <skos:broader rdf:resource="thsys/71059"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11187-3">
    <skos:broader rdf:resource="thsys/71050"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11187-3">
    <skos:broader rdf:resource="descriptor/19784-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16786-5">
    <skos:prefLabel xml:lang="en">Information retrieval</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16786-5">
    <skos:prefLabel xml:lang="de">Informationsretrieval</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70997">
    <skos:narrower rdf:resource="descriptor/13069-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70997">
    <skos:narrower rdf:resource="descriptor/13065-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70997">
    <skos:narrower rdf:resource="descriptor/13060-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70997">
    <skos:narrower rdf:resource="descriptor/13055-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70997">
    <skos:narrower rdf:resource="descriptor/13053-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70997">
    <skos:narrower rdf:resource="descriptor/18422-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70997">
    <skos:narrower rdf:resource="descriptor/18421-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70997">
    <skos:narrower rdf:resource="descriptor/19549-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70997">
    <skos:narrower rdf:resource="descriptor/13051-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70997">
    <skos:narrower rdf:resource="descriptor/18423-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70997">
    <skos:narrower rdf:resource="descriptor/19052-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70997">
    <skos:narrower rdf:resource="descriptor/13046-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13655-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15712-4">
    <skos:narrower rdf:resource="descriptor/16699-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15712-4">
    <skos:narrower rdf:resource="descriptor/15931-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15712-4">
    <skos:narrower rdf:resource="descriptor/12577-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15712-4">
    <skos:narrower rdf:resource="descriptor/11314-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12796-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16304-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12543-2">
    <skos:altLabel xml:lang="de">Abschreibungsverfahren</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12543-2">
    <skos:altLabel xml:lang="de">Abschreibungsplan</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12543-2">
    <skos:altLabel xml:lang="de">Abschreibungsmethode</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12737-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11191-5">
    <skos:altLabel xml:lang="en">Worker dislocation</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11191-5">
    <skos:altLabel xml:lang="en">Layoff</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11191-5">
    <skos:altLabel xml:lang="en">Employee dismissal</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11191-5">
    <skos:altLabel xml:lang="de">Personalfreisetzung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11191-5">
    <skos:altLabel xml:lang="de">Freisetzung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11191-5">
    <skos:altLabel xml:lang="de">Entlassung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11191-5">
    <skos:altLabel xml:lang="de">Betriebsbedingte Kündigung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11191-5">
    <skos:altLabel xml:lang="de">Arbeitsvertragsbeendigung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11191-5">
    <skos:altLabel xml:lang="de">Arbeitsplatzverlust</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14070-2">
    <skos:related rdf:resource="descriptor/14961-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14070-2">
    <skos:related rdf:resource="descriptor/14055-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11235-4">
    <skos:related rdf:resource="descriptor/11233-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11235-4">
    <skos:related rdf:resource="descriptor/16011-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11235-4">
    <skos:related rdf:resource="descriptor/11239-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11235-4">
    <skos:related rdf:resource="descriptor/11238-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11235-4">
    <skos:related rdf:resource="descriptor/11392-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11235-4">
    <skos:related rdf:resource="descriptor/11389-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11235-4">
    <skos:related rdf:resource="descriptor/11237-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11235-4">
    <skos:related rdf:resource="descriptor/11185-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11235-4">
    <skos:related rdf:resource="descriptor/11246-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11235-4">
    <skos:related rdf:resource="descriptor/11219-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11235-4">
    <skos:related rdf:resource="descriptor/19767-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11235-4">
    <skos:related rdf:resource="descriptor/19493-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11235-4">
    <skos:related rdf:resource="descriptor/11183-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11235-4">
    <skos:related rdf:resource="descriptor/11182-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11235-4">
    <skos:related rdf:resource="descriptor/10996-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11928-1">
    <skos:narrower rdf:resource="descriptor/11932-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11928-1">
    <skos:narrower rdf:resource="descriptor/10219-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11928-1">
    <skos:narrower rdf:resource="descriptor/11927-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11928-1">
    <skos:narrower rdf:resource="descriptor/20321-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13974-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15914-6">
    <skos:scopeNote xml:lang="de">Zusammensetzung der Bevölkerung nach den Merkmalen Geschlecht, Beruf, Familienstand, Konfession, Rasse, Nationalität usw.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70328">
    <skos:narrower rdf:resource="descriptor/14810-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70328">
    <skos:narrower rdf:resource="descriptor/14808-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70328">
    <skos:narrower rdf:resource="descriptor/14809-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70328">
    <skos:narrower rdf:resource="descriptor/14807-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70328">
    <skos:narrower rdf:resource="descriptor/14805-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70328">
    <skos:narrower rdf:resource="descriptor/14804-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70328">
    <skos:narrower rdf:resource="descriptor/14803-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70328">
    <skos:narrower rdf:resource="descriptor/14802-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70328">
    <skos:narrower rdf:resource="descriptor/14798-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70328">
    <skos:narrower rdf:resource="descriptor/18205-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70328">
    <skos:narrower rdf:resource="descriptor/14796-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11305-2">
    <skos:scopeNote xml:lang="de">Allgemeine physische, soziale und unternehmensbezogene Faktoren, welche die Arbeitsumgebung beeinflussen.</skos:scopeNote>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19265-4">
    <skos:related rdf:resource="descriptor/12230-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19265-4">
    <skos:related rdf:resource="descriptor/12295-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19265-4">
    <skos:related rdf:resource="descriptor/12272-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10785-2">
    <skos:broader rdf:resource="thsys/71089"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10785-2">
    <skos:broader rdf:resource="thsys/70114"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10785-2">
    <skos:broader rdf:resource="descriptor/13807-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10785-2">
    <skos:broader rdf:resource="descriptor/10811-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19367-3">
    <skos:broader rdf:resource="thsys/71019"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19367-3">
    <skos:broader rdf:resource="thsys/70991"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19367-3">
    <skos:broader rdf:resource="thsys/70957"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19367-3">
    <skos:broader rdf:resource="descriptor/18995-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12284-0">
    <skos:broader rdf:resource="thsys/71046"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12284-0">
    <skos:broader rdf:resource="thsys/70036"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19290-5">
    <skos:related rdf:resource="descriptor/14055-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19290-5">
    <skos:related rdf:resource="descriptor/18190-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18075-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19916-3">
    <skos:prefLabel xml:lang="en">Educational attainment</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19916-3">
    <skos:prefLabel xml:lang="de">Bildungsabschluss</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10876-6">
    <skos:broader rdf:resource="thsys/70951"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10876-6">
    <skos:broader rdf:resource="thsys/70041"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10876-6">
    <skos:broader rdf:resource="descriptor/12766-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19359-2">
    <skos:broader rdf:resource="thsys/73366"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19359-2">
    <skos:broader rdf:resource="thsys/73332"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19359-2">
    <skos:broader rdf:resource="thsys/71089"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19359-2">
    <skos:broader rdf:resource="descriptor/16184-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19359-2">
    <skos:broader rdf:resource="descriptor/18694-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19359-2">
    <skos:broader rdf:resource="descriptor/19358-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18553-4">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10602-1">
    <skos:prefLabel xml:lang="en">Foreign operations</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10602-1">
    <skos:prefLabel xml:lang="de">Auslandsgeschäft</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16046-3">
    <skos:related rdf:resource="descriptor/18704-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16046-3">
    <skos:related rdf:resource="descriptor/10774-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12585-0">
    <skos:altLabel xml:lang="en">Managerial grid</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12585-0">
    <skos:altLabel xml:lang="en">Management grid</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12585-0">
    <skos:altLabel xml:lang="de">Personalbetreuung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12585-0">
    <skos:altLabel xml:lang="de">Mitarbeiterführung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12585-0">
    <skos:altLabel xml:lang="de">Managementtechnik</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12585-0">
    <skos:altLabel xml:lang="de">Management-by-Prinzip</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12585-0">
    <skos:altLabel xml:lang="de">Führungstechnik</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12585-0">
    <skos:altLabel xml:lang="de">Führungsprinzip</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12585-0">
    <skos:altLabel xml:lang="de">Führungskonzeption</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70932">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19328-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13446-2">
    <skos:broader rdf:resource="thsys/73348"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13446-2">
    <skos:broader rdf:resource="thsys/71028"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13446-2">
    <skos:broader rdf:resource="descriptor/15685-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12064-0">
    <skos:narrower rdf:resource="descriptor/13811-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12064-0">
    <skos:narrower rdf:resource="descriptor/19392-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12064-0">
    <skos:narrower rdf:resource="descriptor/18005-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14798-1">
    <skos:altLabel xml:lang="de">Toilettenpapier</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14798-1">
    <skos:altLabel xml:lang="de">Tampon</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14798-1">
    <skos:altLabel xml:lang="de">Papierwindel</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14798-1">
    <skos:altLabel xml:lang="de">Papiertuch</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14798-1">
    <skos:altLabel xml:lang="de">Papiertaschentuch</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14798-1">
    <skos:altLabel xml:lang="de">Papierserviette</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14798-1">
    <skos:altLabel xml:lang="de">Mehrzwecktuch</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14798-1">
    <skos:altLabel xml:lang="de">Hygienepapierprodukt</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13557-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10590-3">
    <skos:related rdf:resource="descriptor/12154-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10590-3">
    <skos:related rdf:resource="descriptor/11556-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10590-3">
    <skos:related rdf:resource="descriptor/11531-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10590-3">
    <skos:related rdf:resource="descriptor/11530-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10590-3">
    <skos:related rdf:resource="descriptor/11529-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10590-3">
    <skos:related rdf:resource="descriptor/12208-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10590-3">
    <skos:related rdf:resource="descriptor/10561-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10590-3">
    <skos:related rdf:resource="descriptor/10548-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19327-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18935-4">
    <skos:related rdf:resource="descriptor/18929-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18935-4">
    <skos:related rdf:resource="descriptor/18936-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18935-4">
    <skos:related rdf:resource="descriptor/18934-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18935-4">
    <skos:related rdf:resource="descriptor/13655-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19800-1">
    <skos:related rdf:resource="descriptor/15605-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19800-1">
    <skos:related rdf:resource="descriptor/15599-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19800-1">
    <skos:related rdf:resource="descriptor/19247-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19039-6">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13287-3">
    <skos:altLabel xml:lang="en">Credit union</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13287-3">
    <skos:altLabel xml:lang="de">Volksbank</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13287-3">
    <skos:altLabel xml:lang="de">Raiffeisenkasse</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13287-3">
    <skos:altLabel xml:lang="de">Genossenschaftsbank</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14633-5">
    <skos:related rdf:resource="descriptor/14129-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14633-5">
    <skos:related rdf:resource="descriptor/14656-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14633-5">
    <skos:related rdf:resource="descriptor/14044-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14633-5">
    <skos:related rdf:resource="descriptor/14131-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16757-5">
    <skos:prefLabel xml:lang="en">Information technology</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16757-5">
    <skos:prefLabel xml:lang="de">Informationstechnik</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15778-2">
    <skos:related rdf:resource="descriptor/15768-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15757-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12981-6">
    <skos:altLabel xml:lang="de">Pechkohlenbergbau</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12981-6">
    <skos:altLabel xml:lang="de">Braunkohlenindustrie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18730-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14630-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70354">
    <rdfs:label xml:lang="en">Africa South of Sahara</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70354">
    <rdfs:label xml:lang="de">Afrika südlich der Sahara</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11441-1">
    <skos:prefLabel xml:lang="en">Financial innovation</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11441-1">
    <skos:prefLabel xml:lang="de">Finanzinnovation</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18947-4">
    <skos:altLabel xml:lang="de">Telekommunikationselektronikerinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18947-4">
    <skos:altLabel xml:lang="de">Telekommunikationselektroniker</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18947-4">
    <skos:altLabel xml:lang="de">Telegraphistinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18947-4">
    <skos:altLabel xml:lang="de">Telegraphisten</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18947-4">
    <skos:altLabel xml:lang="de">Telegrafistinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18947-4">
    <skos:altLabel xml:lang="de">Telegrafisten</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18947-4">
    <skos:altLabel xml:lang="de">Telefonistinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18947-4">
    <skos:altLabel xml:lang="de">Telefonisten</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18947-4">
    <skos:altLabel xml:lang="de">Funkerinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18947-4">
    <skos:altLabel xml:lang="de">Funker</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18947-4">
    <skos:altLabel xml:lang="de">Fernmeldetechnische Berufe</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18947-4">
    <skos:altLabel xml:lang="de">Fernmeldetechnikerinnen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18947-4">
    <skos:altLabel xml:lang="de">Fernmeldetechniker</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18947-4">
    <skos:altLabel xml:lang="de">Fernmeldeberufe</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10575-6">
    <skos:broader rdf:resource="thsys/71065"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10575-6">
    <skos:broader rdf:resource="thsys/70091"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10575-6">
    <skos:broader rdf:resource="descriptor/11895-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10575-6">
    <skos:broader rdf:resource="descriptor/10524-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11090-4">
    <skos:broader rdf:resource="thsys/71101"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11090-4">
    <skos:broader rdf:resource="thsys/70141"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11090-4">
    <skos:broader rdf:resource="descriptor/10062-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13181-5">
    <skos:altLabel xml:lang="de">Wärmeschutzinstallation</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13181-5">
    <skos:altLabel xml:lang="de">Schallschutzinstallation</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13181-5">
    <skos:altLabel xml:lang="de">Installationshandwerk</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13181-5">
    <skos:altLabel xml:lang="de">Gebäudeisolierung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13181-5">
    <skos:altLabel xml:lang="de">Gebäudedämmung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13181-5">
    <skos:altLabel xml:lang="de">Abdämmungsgewerbe</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14251-5">
    <skos:altLabel xml:lang="en">Refractory material</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14251-5">
    <skos:altLabel xml:lang="de">Feuerfester Stoff</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14251-5">
    <skos:altLabel xml:lang="de">Feuerfeste Keramik</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13966-4">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18636-0">
    <skos:related rdf:resource="descriptor/18640-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18636-0">
    <skos:related rdf:resource="descriptor/13635-6"/>
  </rdf:Description>
  <rdf:Description rdf:nodeID="id379">
    <rdf:value xml:lang="de">Für den Bestand an Wohnraum</rdf:value>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19324-0">
    <skos:altLabel xml:lang="de">Handelskrieg</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19324-0">
    <skos:altLabel xml:lang="de">Außenhandelskonflikt</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18877-6">
    <skos:broader rdf:resource="thsys/70844"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18877-6">
    <skos:broader rdf:resource="thsys/70176"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18877-6">
    <skos:broader rdf:resource="descriptor/11402-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18877-6">
    <skos:broader rdf:resource="descriptor/11398-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15124-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13307-2">
    <skos:altLabel xml:lang="en">Catering and hotels</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13307-2">
    <skos:altLabel xml:lang="de">Hotel- und Gaststättengewerbe</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19323-2">
    <skos:related rdf:resource="descriptor/16081-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19323-2">
    <skos:related rdf:resource="descriptor/16017-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19323-2">
    <skos:related rdf:resource="descriptor/19687-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19323-2">
    <skos:related rdf:resource="descriptor/15994-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19323-2">
    <skos:related rdf:resource="descriptor/19649-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19323-2">
    <skos:related rdf:resource="descriptor/10917-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19323-2">
    <skos:related rdf:resource="descriptor/18001-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19323-2">
    <skos:related rdf:resource="descriptor/15989-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15775-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12777-5">
    <skos:narrower rdf:resource="descriptor/12782-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14293-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19520-0">
    <skos:altLabel xml:lang="de">Handelshaus</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19520-0">
    <skos:altLabel xml:lang="de">Handelsgesellschaft</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10160-0">
    <skos:altLabel xml:lang="en">Utility measurement</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10160-0">
    <skos:altLabel xml:lang="de">Ordinaler Nutzen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10160-0">
    <skos:altLabel xml:lang="de">Nutzenmaßstab</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10160-0">
    <skos:altLabel xml:lang="de">Kardinaler Nutzen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10160-0">
    <skos:altLabel xml:lang="de">Interdependenter Nutzen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10160-0">
    <skos:altLabel xml:lang="de">Indirekter Nutzen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10160-0">
    <skos:altLabel xml:lang="de">Additiver Nutzen</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18089-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13239-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15711-6">
    <skos:related rdf:resource="descriptor/20261-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15711-6">
    <skos:related rdf:resource="descriptor/16595-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15711-6">
    <skos:related rdf:resource="descriptor/16396-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15711-6">
    <skos:related rdf:resource="descriptor/16226-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15711-6">
    <skos:related rdf:resource="descriptor/16630-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15711-6">
    <skos:related rdf:resource="descriptor/10984-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15711-6">
    <skos:related rdf:resource="descriptor/16266-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="http://www.w3.org/2004/02/skos/core#related">
    <rdfs:comment xml:lang="en">skos:related is disjoint with skos:broaderTransitive</rdfs:comment>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13285-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11664-2">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18166-4">
    <skos:altLabel xml:lang="de">Sonntagsarbeit</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18166-4">
    <skos:altLabel xml:lang="de">Samstagsarbeit</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18166-4">
    <skos:altLabel xml:lang="de">Feiertagsarbeit</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10772-4">
    <skos:related rdf:resource="descriptor/18127-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10772-4">
    <skos:related rdf:resource="descriptor/10754-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10772-4">
    <skos:related rdf:resource="descriptor/10746-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10772-4">
    <skos:related rdf:resource="descriptor/10745-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10772-4">
    <skos:related rdf:resource="descriptor/11494-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10772-4">
    <skos:related rdf:resource="descriptor/10236-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10772-4">
    <skos:related rdf:resource="descriptor/19261-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10772-4">
    <skos:related rdf:resource="descriptor/19260-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11134-3">
    <skos:broader rdf:resource="thsys/71101"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11134-3">
    <skos:broader rdf:resource="descriptor/10911-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18955-5">
    <skos:broader rdf:resource="thsys/70819"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18955-5">
    <skos:broader rdf:resource="descriptor/10032-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70245">
    <rdfs:label xml:lang="de">Vergütungssysteme und betriebliche Sozialleistungen</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11869-5">
    <skos:altLabel xml:lang="de">Raumordnerisches Leitbild</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11869-5">
    <skos:altLabel xml:lang="de">Räumliche Ordnung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11869-5">
    <skos:altLabel xml:lang="de">Ordnung im Raum</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11869-5">
    <skos:altLabel xml:lang="de">Leitbild des Raumes</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16767-2">
    <skos:related rdf:resource="descriptor/16788-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16767-2">
    <skos:related rdf:resource="descriptor/15473-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16767-2">
    <skos:related rdf:resource="descriptor/13197-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16767-2">
    <skos:related rdf:resource="descriptor/18951-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16767-2">
    <skos:related rdf:resource="descriptor/18950-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13849-1">
    <skos:broader rdf:resource="thsys/70888"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16019-6">
    <skos:broader rdf:resource="thsys/73380"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16019-6">
    <skos:broader rdf:resource="thsys/73360"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16019-6">
    <skos:broader rdf:resource="thsys/70871"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16019-6">
    <skos:broader rdf:resource="descriptor/16007-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12738-1">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16309-4">
    <skos:altLabel xml:lang="en">State autonomy</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16309-4">
    <skos:altLabel xml:lang="de">Staatliche Souveränität</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16309-4">
    <skos:altLabel xml:lang="de">Staatliche Autonomie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16309-4">
    <skos:altLabel xml:lang="de">Innere Souveränität</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16309-4">
    <skos:altLabel xml:lang="de">Äußere Souveränität</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19437-1">
    <skos:prefLabel xml:lang="en">Declining industrial area</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19437-1">
    <skos:prefLabel xml:lang="de">Alternde Industrieregion</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14798-1">
    <skos:related rdf:resource="descriptor/14042-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12371-5">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13159-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70925">
    <skos:prefLabel xml:lang="de">W.12.06  Verkehrsgeographie und regionale Verkehrspolitik</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10042-6">
    <skos:broader rdf:resource="thsys/71100"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10042-6">
    <skos:broader rdf:resource="thsys/70234"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10042-6">
    <skos:broader rdf:resource="descriptor/10065-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18445-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20104-4">
    <skos:broader rdf:resource="thsys/70305"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/20104-4">
    <skos:broader rdf:resource="descriptor/11490-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18899-3">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19206-6">
    <skos:broader rdf:resource="thsys/71083"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19206-6">
    <skos:broader rdf:resource="thsys/70141"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19206-6">
    <skos:broader rdf:resource="descriptor/11526-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19206-6">
    <skos:broader rdf:resource="descriptor/16745-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18292-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11844-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/73340">
    <skos:prefLabel xml:lang="de">N.10.07.02  Programmierung und Software</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18514-0">
    <skos:altLabel xml:lang="de">Gebrauchtwagenhandel</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/12625-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10945-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11986-1">
    <skos:related rdf:resource="descriptor/13860-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11986-1">
    <skos:related rdf:resource="descriptor/11990-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11986-1">
    <skos:related rdf:resource="descriptor/19473-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11986-1">
    <skos:related rdf:resource="descriptor/11988-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11986-1">
    <skos:related rdf:resource="descriptor/15695-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11986-1">
    <skos:related rdf:resource="descriptor/11970-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11986-1">
    <skos:related rdf:resource="descriptor/11951-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11986-1">
    <skos:related rdf:resource="descriptor/16205-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18848-6">
    <skos:altLabel xml:lang="en">Insider-outsider approach</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18848-6">
    <skos:altLabel xml:lang="de">Insider-Outsider Theorie</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19729-2">
    <skos:altLabel xml:lang="de">Haftungsbeschränkung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19729-2">
    <skos:altLabel xml:lang="de">Durchgriffshaftung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13445-4">
    <skos:related rdf:resource="descriptor/16688-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13445-4">
    <skos:related rdf:resource="descriptor/10503-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13445-4">
    <skos:related rdf:resource="descriptor/19461-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13445-4">
    <skos:related rdf:resource="descriptor/13454-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13445-4">
    <skos:related rdf:resource="descriptor/13451-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13445-4">
    <skos:related rdf:resource="descriptor/13425-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16142-0">
    <skos:altLabel xml:lang="en">Wrongful-discharge law</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16142-0">
    <skos:altLabel xml:lang="en">Protection against dismissal</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16142-0">
    <skos:altLabel xml:lang="de">Kündigungsschutzrecht</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16142-0">
    <skos:altLabel xml:lang="de">Kündigungsschutzgesetz</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16142-0">
    <skos:altLabel xml:lang="de">Kündigungsfrist</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16142-0">
    <skos:altLabel xml:lang="de">KSchG (Kündigungsschutzgesetz)</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16142-0">
    <skos:altLabel xml:lang="de">Arbeitsrechtlicher Kündigungsschutz</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14504-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16588-2">
    <skos:broader rdf:resource="thsys/70321"/>
  </rdf:Description>
  <rdf:Description rdf:about="thsys/70328">
    <rdfs:label xml:lang="de">Pappe, Papier und Papierprodukte</rdfs:label>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19803-2">
    <skos:altLabel xml:lang="de">Objektorientierte Systementwicklung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19803-2">
    <skos:altLabel xml:lang="de">Objektorientierte Systemanalyse</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19803-2">
    <skos:altLabel xml:lang="de">Objektorientierte Software-Entwicklung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14715-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19784-1">
    <skos:broader rdf:resource="thsys/73350"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19178-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18153-6">
    <skos:prefLabel xml:lang="en">Industrial service</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18153-6">
    <skos:prefLabel xml:lang="de">Industrielle Dienstleistung</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16026-2">
    <skos:prefLabel xml:lang="en">Civil code</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16026-2">
    <skos:prefLabel xml:lang="de">Bürgerliches Recht</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16549-5">
    <skos:altLabel xml:lang="en">Local policy</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16549-5">
    <skos:altLabel xml:lang="de">Stadtpolitik</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16549-5">
    <skos:altLabel xml:lang="de">Lokalpolitik</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16549-5">
    <skos:altLabel xml:lang="de">Gemeindepolitik</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19708-3">
    <skos:prefLabel xml:lang="en">International cooperation</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19708-3">
    <skos:prefLabel xml:lang="de">Internationale Zusammenarbeit</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13545-0">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10517-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13337-0">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13390-3">
    <skos:prefLabel xml:lang="en">Software industry</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13390-3">
    <skos:prefLabel xml:lang="de">Softwareindustrie</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13745-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19342-5">
    <skos:prefLabel xml:lang="en">Fruit market</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/19342-5">
    <skos:prefLabel xml:lang="de">Obstmarkt</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11979-5">
    <skos:narrower rdf:resource="descriptor/11972-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10823-6">
    <skos:broader rdf:resource="thsys/71090"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10823-6">
    <skos:broader rdf:resource="thsys/71044"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10823-6">
    <skos:broader rdf:resource="descriptor/10008-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10823-6">
    <skos:broader rdf:resource="descriptor/10811-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10823-6">
    <skos:broader rdf:resource="descriptor/10605-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14703-3">
    <skos:prefLabel xml:lang="en">Synthetic resin</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/14703-3">
    <skos:prefLabel xml:lang="de">Kunstharz</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11817-3">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18002-6">
    <skos:narrower rdf:resource="descriptor/18023-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18002-6">
    <skos:narrower rdf:resource="descriptor/19117-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13715-1">
    <skos:related rdf:resource="descriptor/13743-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13715-1">
    <skos:related rdf:resource="descriptor/13742-5"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13715-1">
    <skos:related rdf:resource="descriptor/12299-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13715-1">
    <skos:related rdf:resource="descriptor/10773-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13715-1">
    <skos:related rdf:resource="descriptor/18679-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13715-1">
    <skos:related rdf:resource="descriptor/19274-3"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13715-1">
    <skos:related rdf:resource="descriptor/19554-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13715-1">
    <skos:related rdf:resource="descriptor/19669-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13715-1">
    <skos:related rdf:resource="descriptor/19671-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13715-1">
    <skos:related rdf:resource="descriptor/18730-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13715-1">
    <skos:related rdf:resource="descriptor/13279-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13715-1">
    <skos:related rdf:resource="descriptor/10001-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18278-0">
    <skos:related rdf:resource="descriptor/10016-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18278-0">
    <skos:related rdf:resource="descriptor/13459-0"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16030-4">
    <skos:broader rdf:resource="thsys/73392"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16030-4">
    <skos:broader rdf:resource="thsys/70814"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16030-4">
    <skos:broader rdf:resource="descriptor/16026-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16055-2">
    <skos:altLabel xml:lang="de">HandwO</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/16055-2">
    <skos:altLabel xml:lang="de">Handwerksordnung</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15396-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18538-0">
    <skos:prefLabel xml:lang="en">Export industry</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18538-0">
    <skos:prefLabel xml:lang="de">Exportindustrie</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10436-6">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11559-6">
    <skos:narrower rdf:resource="descriptor/11289-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13368-3">
    <skos:broader rdf:resource="thsys/73296"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13368-3">
    <skos:broader rdf:resource="descriptor/18449-6"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/18764-5">
    <skos:inScheme rdf:resource="../stw"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15708-2">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17743-4">
    <skos:altLabel xml:lang="de">Zentralafrikanische Staaten</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17743-4">
    <skos:altLabel xml:lang="de">Zentralafrikanische Länder</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/17743-4">
    <skos:altLabel xml:lang="de">Äquatorialafrika</skos:altLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10150-3">
    <skos:broader rdf:resource="thsys/73386"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10150-3">
    <skos:broader rdf:resource="thsys/70180"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10150-3">
    <skos:broader rdf:resource="descriptor/15722-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/10150-3">
    <skos:broader rdf:resource="descriptor/16709-2"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11668-1">
    <rdf:type rdf:resource="../namespaces/skos-extensions/Descriptor"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13645-3">
    <skos:prefLabel xml:lang="en">Vacation behaviour</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/13645-3">
    <skos:prefLabel xml:lang="de">Urlaubsverhalten</skos:prefLabel>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15473-3">
    <skos:broader rdf:resource="thsys/70383"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15473-3">
    <skos:broader rdf:resource="descriptor/13345-1"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/15473-3">
    <skos:broader rdf:resource="descriptor/12640-4"/>
  </rdf:Description>
  <rdf:Description rdf:about="descriptor/11888-1">
    <skos:prefLabel xml:lang="en">Internal migration</skos:prefLabel>
  </rdf:Description>
  <rdf:Description