# Generated by default/object.tt
package Paws::LookoutVision::DatasetImageStats;
  use Moose;
  has Anomaly => (is => 'ro', isa => 'Int');
  has Labeled => (is => 'ro', isa => 'Int');
  has Normal => (is => 'ro', isa => 'Int');
  has Total => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::LookoutVision::DatasetImageStats

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LookoutVision::DatasetImageStats object:

  $service_obj->Method(Att1 => { Anomaly => $value, ..., Total => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LookoutVision::DatasetImageStats object:

  $result = $service_obj->Method(...);
  $result->Att1->Anomaly

=head1 DESCRIPTION

Statistics about the images in a dataset.

=head1 ATTRIBUTES


=head2 Anomaly => Int

the total number of images labeled as an anomaly.


=head2 Labeled => Int

The total number of labeled images.


=head2 Normal => Int

The total number of images labeled as normal.


=head2 Total => Int

The total number of images in the dataset.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LookoutVision>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

