#!/usr/bin/env perl   # shebang line so this program is opened with perl interpreter
use JSON::Karabiner;  # make sure this Perl package is installed on your machine

use strict;    # always set these in perl for your
use warnings;  # own sanity

# Create an object by passiing it a title and the name of the file you will write to:
my $kb_obj = JSON::Karabiner->new('Mission Control Rules', 'my_awesome_karbiner_mod.json');

# Now add a rule and give it description:
my $rule = $kb_obj->add_rule('Type emojis');

# Add a manipulator to the rule:
my $manip_1 = $rule->add_manipulator;

# Add a description to the manipulaor:
$manip_1->add_description('Press a-s-d simultaneously to launch emoji helper');

# Add a "from" and "to" action to the manipulator
my $from = $manip_1->add_action('from');
my $to = $manip_1->add_action('to');

# Tell the "from" action what to do
$from->add_simultaneous('a', 's', 'd');
$from->add_optional_modifiers('any');

# Tell the "to" action what to do
$to->add_key_code('spacebar');
$to->add_modifiers('control', 'command');

# Done! Now it's time to write the file:

$kb_obj->write_file;
