# Generated by default/object.tt
package Paws::SageMaker::UiConfig;
  use Moose;
  has HumanTaskUiArn => (is => 'ro', isa => 'Str');
  has UiTemplateS3Uri => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::UiConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::UiConfig object:

  $service_obj->Method(Att1 => { HumanTaskUiArn => $value, ..., UiTemplateS3Uri => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::UiConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->HumanTaskUiArn

=head1 DESCRIPTION

Provided configuration information for the worker UI for a labeling
job.

=head1 ATTRIBUTES


=head2 HumanTaskUiArn => Str

The ARN of the worker task template used to render the worker UI and
tools for labeling job tasks.

Use this parameter when you are creating a labeling job for 3D point
cloud and video fram labeling jobs. Use your labeling job task type to
select one of the following ARNs and use it with this parameter when
you create a labeling job. Replace C<aws-region> with the Amazon Web
Services region you are creating your labeling job in.

B<3D Point Cloud HumanTaskUiArns>

Use this C<HumanTaskUiArn> for 3D point cloud object detection and 3D
point cloud object detection adjustment labeling jobs.

=over

=item *

C<arn:aws:sagemaker:aws-region:394669845002:human-task-ui/PointCloudObjectDetection>

=back

Use this C<HumanTaskUiArn> for 3D point cloud object tracking and 3D
point cloud object tracking adjustment labeling jobs.

=over

=item *

C<arn:aws:sagemaker:aws-region:394669845002:human-task-ui/PointCloudObjectTracking>

=back

Use this C<HumanTaskUiArn> for 3D point cloud semantic segmentation and
3D point cloud semantic segmentation adjustment labeling jobs.

=over

=item *

C<arn:aws:sagemaker:aws-region:394669845002:human-task-ui/PointCloudSemanticSegmentation>

=back

B<Video Frame HumanTaskUiArns>

Use this C<HumanTaskUiArn> for video frame object detection and video
frame object detection adjustment labeling jobs.

=over

=item *

C<arn:aws:sagemaker:region:394669845002:human-task-ui/VideoObjectDetection>

=back

Use this C<HumanTaskUiArn> for video frame object tracking and video
frame object tracking adjustment labeling jobs.

=over

=item *

C<arn:aws:sagemaker:aws-region:394669845002:human-task-ui/VideoObjectTracking>

=back



=head2 UiTemplateS3Uri => Str

The Amazon S3 bucket location of the UI template, or worker task
template. This is the template used to render the worker UI and tools
for labeling job tasks. For more information about the contents of a UI
template, see Creating Your Custom Labeling Task Template
(https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates-step2.html).



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

