/*                                                                
**  Copyright (C) 1996,2007  Smithsonian Astrophysical Observatory 
*/                                                                

/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 3 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License along */
/*  with this program; if not, write to the Free Software Foundation, Inc., */
/*  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.             */
/*                                                                          */

/* pline.c
**/

#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#include "pfile.h"
#include "ptemplat.h"
#include "parameter.h"

int
main(int argc, char *argv[])
{
  int dopkg;
  int pname;
  int i;
  char *name;
  char value[SZ_PFLINE];
  paramfile pfile;
  pmatchlist pml;

  if ( argc == 1 ) {
    fprintf(stderr, "pline: no paramfiles to list\n");
    exit(1);
  }

  /* look for flag to print out pkg name */
  if( !strcmp(argv[1], "-pkg") ){
    dopkg = 1;
    pname = 2;
  }
  else{
    dopkg = 0;
    pname = 1;
  }

  if ( (pfile = paramopen(argv[pname], &argv[pname], argc - pname, "rH")) == NULL ) {
    fprintf(stderr, "pdump: can't open parameter file: %s\n", pfilelast());
    exit(1);
  }

  /* open the match list for all params */
  pml = pmatchopen(pfile, NULL);
  /* display each param value in name='value' format */
  for(i=0; (name=pmatchnext(pml)) != NULL; i++ ){
    if( pgetstr(pfile, name, value, SZ_PFLINE) ){
      if( dopkg ){
	printf("%s.%s='%s'\n", argv[pname], name, value);
      }
      else{
	printf("%s='%s'\n", name, value);
      }
    }
  }
  /* close the match list */
  pmatchclose(pml);
  printf("# EOF\n");
  paramclose(pfile);
  exit(0);
}
