#!/usr/bin/perl

package eBay::API::XML::DataType::FeatureDefinitionsType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. FeatureDefinitionsType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::FeatureDefinitionsType

=head1 DESCRIPTION

A container node for definitions of the features specified in FeatureID in the
GetCategoryFeatures request. If no feature ID was specified, all definitions are
returned.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::FeatureDefinitionsType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::AdFormatEnabledDefinitionType;
use eBay::API::XML::DataType::BasicUpgradePackEnabledDefinitionType;
use eBay::API::XML::DataType::BestOfferAutoAcceptEnabledDefinitionType;
use eBay::API::XML::DataType::BestOfferAutoDeclineEnabledDefinitionType;
use eBay::API::XML::DataType::BestOfferCounterEnabledDefinitionType;
use eBay::API::XML::DataType::BestOfferEnabledDefinitionType;
use eBay::API::XML::DataType::BuyerGuaranteeEnabledDefinitionType;
use eBay::API::XML::DataType::ClassifiedAdAutoAcceptEnabledDefinitionType;
use eBay::API::XML::DataType::ClassifiedAdAutoDeclineEnabledDefinitionType;
use eBay::API::XML::DataType::ClassifiedAdBestOfferEnabledDefinitionType;
use eBay::API::XML::DataType::ClassifiedAdCompanyNameEnabledDefinitionType;
use eBay::API::XML::DataType::ClassifiedAdContactByAddressEnabledDefinitionType;
use eBay::API::XML::DataType::ClassifiedAdContactByEmailEnabledDefintionType;
use eBay::API::XML::DataType::ClassifiedAdContactByPhoneEnabledDefinitionType;
use eBay::API::XML::DataType::ClassifiedAdCounterOfferEnabledDefinitionType;
use eBay::API::XML::DataType::ClassifiedAdPayPerLeadEnabledDefinitionType;
use eBay::API::XML::DataType::ClassifiedAdPaymentMethodEnabledDefinitionType;
use eBay::API::XML::DataType::ClassifiedAdPhoneCountDefinitionType;
use eBay::API::XML::DataType::ClassifiedAdShippingMethodEnabledDefinitionType;
use eBay::API::XML::DataType::ClassifiedAdStreetCountDefinitionType;
use eBay::API::XML::DataType::CombinedFixedPriceTreatmentEnabledDefinitionType;
use eBay::API::XML::DataType::CrossBorderTradeAustraliaEnabledDefinitionType;
use eBay::API::XML::DataType::CrossBorderTradeGBEnabledDefinitionType;
use eBay::API::XML::DataType::CrossBorderTradeNorthAmericaEnabledDefinitionType;
use eBay::API::XML::DataType::DutchBINEnabledDefinitionType;
use eBay::API::XML::DataType::ExpressConditionRequiredDefinitionType;
use eBay::API::XML::DataType::ExpressEnabledDefinitionType;
use eBay::API::XML::DataType::ExpressPicturesRequiredDefinitionType;
use eBay::API::XML::DataType::HomePageFeaturedEnabledDefinitionType;
use eBay::API::XML::DataType::INEscrowWorkflowTimelineDefinitionType;
use eBay::API::XML::DataType::ItemSpecificsEnabledDefinitionType;
use eBay::API::XML::DataType::ListingDurationDefinitionsType;
use eBay::API::XML::DataType::ListingEnhancementDurationDefinitionType;
use eBay::API::XML::DataType::LocalListingDistancesNonSubscriptionDefinitionType;
use eBay::API::XML::DataType::LocalListingDistancesRegularDefinitionType;
use eBay::API::XML::DataType::LocalListingDistancesSpecialtyDefinitionType;
use eBay::API::XML::DataType::LocalMarketAdFormatEnabledDefinitionType;
use eBay::API::XML::DataType::LocalMarketAutoAcceptEnabledDefinitionType;
use eBay::API::XML::DataType::LocalMarketAutoDeclineEnabledDefinitionType;
use eBay::API::XML::DataType::LocalMarketBestOfferEnabledDefinitionType;
use eBay::API::XML::DataType::LocalMarketCompanyNameEnabledDefinitionType;
use eBay::API::XML::DataType::LocalMarketContactByAddressEnabledDefinitionType;
use eBay::API::XML::DataType::LocalMarketContactByEmailEnabledDefinitionType;
use eBay::API::XML::DataType::LocalMarketContactByPhoneEnabledDefinitionType;
use eBay::API::XML::DataType::LocalMarketCounterOfferEnabledDefinitionType;
use eBay::API::XML::DataType::LocalMarketNonSubscriptionDefinitionType;
use eBay::API::XML::DataType::LocalMarketPaymentMethodCheckOutEnabledDefinitionType;
use eBay::API::XML::DataType::LocalMarketPhoneCountDefinitionType;
use eBay::API::XML::DataType::LocalMarketPremiumSubscriptionDefinitionType;
use eBay::API::XML::DataType::LocalMarketRegularSubscriptionDefinitionType;
use eBay::API::XML::DataType::LocalMarketSellerContactDetailsEnabledDefinitionType;
use eBay::API::XML::DataType::LocalMarketShippingMethodEnabledDefinitionType;
use eBay::API::XML::DataType::LocalMarketSpecialitySubscriptionDefinitionType;
use eBay::API::XML::DataType::LocalMarketStreetCountDefinitionType;
use eBay::API::XML::DataType::MinimumReservePriceDefinitionType;
use eBay::API::XML::DataType::NonSubscriptionDefinitionType;
use eBay::API::XML::DataType::PaisaPayFullEscrowEnabledDefinitionType;
use eBay::API::XML::DataType::PayPalBuyerProtectionEnabledDefinitionType;
use eBay::API::XML::DataType::PayPalRequiredDefinitionType;
use eBay::API::XML::DataType::PremiumSubscriptionDefinitionType;
use eBay::API::XML::DataType::ProPackEnabledDefinitionType;
use eBay::API::XML::DataType::ProPackPlusEnabledDefinitionType;
use eBay::API::XML::DataType::RegularSubscriptionDefinitionType;
use eBay::API::XML::DataType::SafePaymentRequiredDefinitionType;
use eBay::API::XML::DataType::SellerContactDetailsEnabledDefinitionType;
use eBay::API::XML::DataType::ShippingTermRequiredDefinitionType;
use eBay::API::XML::DataType::SkypeMeNonTransactionalEnabledDefinitionType;
use eBay::API::XML::DataType::SkypeMeTransactionalEnabledDefinitionType;
use eBay::API::XML::DataType::SpecialitySubscriptionDefinitionType;
use eBay::API::XML::DataType::StoreInventoryEnabledDefinitionType;
use eBay::API::XML::DataType::TCREnabledDefinitionType;
use eBay::API::XML::DataType::UserConsentRequiredDefinitionType;
use eBay::API::XML::DataType::ValuePackEnabledDefinitionType;
use eBay::API::XML::DataType::eBayMotorsProAdFormatEnabledDefinitionType;
use eBay::API::XML::DataType::eBayMotorsProAutoAcceptEnabledDefinitionType;
use eBay::API::XML::DataType::eBayMotorsProAutoDeclineEnabledDefinitionType;
use eBay::API::XML::DataType::eBayMotorsProBestOfferEnabledDefinitionType;
use eBay::API::XML::DataType::eBayMotorsProCompanyNameEnabledDefinitionType;
use eBay::API::XML::DataType::eBayMotorsProContactByAddressEnabledDefinitionType;
use eBay::API::XML::DataType::eBayMotorsProContactByEmailEnabledDefinitionType;
use eBay::API::XML::DataType::eBayMotorsProContactByPhoneEnabledDefinitionType;
use eBay::API::XML::DataType::eBayMotorsProCounterOfferEnabledDefinitionType;
use eBay::API::XML::DataType::eBayMotorsProPaymentMethodCheckOutEnabledDefinitionType;
use eBay::API::XML::DataType::eBayMotorsProPhoneCountDefinitionType;
use eBay::API::XML::DataType::eBayMotorsProSellerContactDetailsEnabledDefinitionType;
use eBay::API::XML::DataType::eBayMotorsProShippingMethodEnabledDefinitionType;
use eBay::API::XML::DataType::eBayMotorsProStreetCountDefinitionType;


my @gaProperties = ( [ 'AdFormatEnabled', 'ns:AdFormatEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::AdFormatEnabledDefinitionType', '1' ]
	, [ 'BasicUpgradePackEnabled', 'ns:BasicUpgradePackEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::BasicUpgradePackEnabledDefinitionType', '1' ]
	, [ 'BestOfferAutoAcceptEnabled', 'ns:BestOfferAutoAcceptEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::BestOfferAutoAcceptEnabledDefinitionType', '1' ]
	, [ 'BestOfferAutoDeclineEnabled', 'ns:BestOfferAutoDeclineEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::BestOfferAutoDeclineEnabledDefinitionType', '1' ]
	, [ 'BestOfferCounterEnabled', 'ns:BestOfferCounterEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::BestOfferCounterEnabledDefinitionType', '1' ]
	, [ 'BestOfferEnabled', 'ns:BestOfferEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::BestOfferEnabledDefinitionType', '1' ]
	, [ 'BuyerGuaranteeEnabled', 'ns:BuyerGuaranteeEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::BuyerGuaranteeEnabledDefinitionType', '1' ]
	, [ 'ClassifiedAdAutoAcceptEnabled', 'ns:ClassifiedAdAutoAcceptEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::ClassifiedAdAutoAcceptEnabledDefinitionType', '1' ]
	, [ 'ClassifiedAdAutoDeclineEnabled', 'ns:ClassifiedAdAutoDeclineEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::ClassifiedAdAutoDeclineEnabledDefinitionType', '1' ]
	, [ 'ClassifiedAdBestOfferEnabled', 'ns:ClassifiedAdBestOfferEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::ClassifiedAdBestOfferEnabledDefinitionType', '1' ]
	, [ 'ClassifiedAdCompanyNameEnabled', 'ns:ClassifiedAdCompanyNameEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::ClassifiedAdCompanyNameEnabledDefinitionType', '1' ]
	, [ 'ClassifiedAdContactByAddressEnabled', 'ns:ClassifiedAdContactByAddressEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::ClassifiedAdContactByAddressEnabledDefinitionType', '1' ]
	, [ 'ClassifiedAdContactByEmailEnabled', 'ns:ClassifiedAdContactByEmailEnabledDefintionType', ''
	     ,'eBay::API::XML::DataType::ClassifiedAdContactByEmailEnabledDefintionType', '1' ]
	, [ 'ClassifiedAdContactByPhoneEnabled', 'ns:ClassifiedAdContactByPhoneEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::ClassifiedAdContactByPhoneEnabledDefinitionType', '1' ]
	, [ 'ClassifiedAdCounterOfferEnabled', 'ns:ClassifiedAdCounterOfferEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::ClassifiedAdCounterOfferEnabledDefinitionType', '1' ]
	, [ 'ClassifiedAdPayPerLeadEnabled', 'ns:ClassifiedAdPayPerLeadEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::ClassifiedAdPayPerLeadEnabledDefinitionType', '1' ]
	, [ 'ClassifiedAdPaymentMethodEnabled', 'ns:ClassifiedAdPaymentMethodEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::ClassifiedAdPaymentMethodEnabledDefinitionType', '1' ]
	, [ 'ClassifiedAdPhoneCount', 'ns:ClassifiedAdPhoneCountDefinitionType', ''
	     ,'eBay::API::XML::DataType::ClassifiedAdPhoneCountDefinitionType', '1' ]
	, [ 'ClassifiedAdShippingMethodEnabled', 'ns:ClassifiedAdShippingMethodEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::ClassifiedAdShippingMethodEnabledDefinitionType', '1' ]
	, [ 'ClassifiedAdStreetCount', 'ns:ClassifiedAdStreetCountDefinitionType', ''
	     ,'eBay::API::XML::DataType::ClassifiedAdStreetCountDefinitionType', '1' ]
	, [ 'CombinedFixedPriceTreatmentEnabled', 'ns:CombinedFixedPriceTreatmentEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::CombinedFixedPriceTreatmentEnabledDefinitionType', '1' ]
	, [ 'CrossBorderTradeAustraliaEnabled', 'ns:CrossBorderTradeAustraliaEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::CrossBorderTradeAustraliaEnabledDefinitionType', '1' ]
	, [ 'CrossBorderTradeGBEnabled', 'ns:CrossBorderTradeGBEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::CrossBorderTradeGBEnabledDefinitionType', '1' ]
	, [ 'CrossBorderTradeNorthAmericaEnabled', 'ns:CrossBorderTradeNorthAmericaEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::CrossBorderTradeNorthAmericaEnabledDefinitionType', '1' ]
	, [ 'DutchBINEnabled', 'ns:DutchBINEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::DutchBINEnabledDefinitionType', '1' ]
	, [ 'ExpressConditionRequired', 'ns:ExpressConditionRequiredDefinitionType', ''
	     ,'eBay::API::XML::DataType::ExpressConditionRequiredDefinitionType', '1' ]
	, [ 'ExpressEnabled', 'ns:ExpressEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::ExpressEnabledDefinitionType', '1' ]
	, [ 'ExpressPicturesRequired', 'ns:ExpressPicturesRequiredDefinitionType', ''
	     ,'eBay::API::XML::DataType::ExpressPicturesRequiredDefinitionType', '1' ]
	, [ 'GalleryFeaturedDurations', 'ns:ListingEnhancementDurationDefinitionType', ''
	     ,'eBay::API::XML::DataType::ListingEnhancementDurationDefinitionType', '1' ]
	, [ 'HomePageFeaturedEnabled', 'ns:HomePageFeaturedEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::HomePageFeaturedEnabledDefinitionType', '1' ]
	, [ 'INEscrowWorkflowTimeline', 'ns:INEscrowWorkflowTimelineDefinitionType', ''
	     ,'eBay::API::XML::DataType::INEscrowWorkflowTimelineDefinitionType', '1' ]
	, [ 'ItemSpecificsEnabled', 'ns:ItemSpecificsEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::ItemSpecificsEnabledDefinitionType', '1' ]
	, [ 'ListingDurations', 'ns:ListingDurationDefinitionsType', ''
	     ,'eBay::API::XML::DataType::ListingDurationDefinitionsType', '1' ]
	, [ 'LocalListingDistancesNonSubscription', 'ns:LocalListingDistancesNonSubscriptionDefinitionType', ''
	     ,'eBay::API::XML::DataType::LocalListingDistancesNonSubscriptionDefinitionType', '1' ]
	, [ 'LocalListingDistancesRegular', 'ns:LocalListingDistancesRegularDefinitionType', ''
	     ,'eBay::API::XML::DataType::LocalListingDistancesRegularDefinitionType', '1' ]
	, [ 'LocalListingDistancesSpecialty', 'ns:LocalListingDistancesSpecialtyDefinitionType', ''
	     ,'eBay::API::XML::DataType::LocalListingDistancesSpecialtyDefinitionType', '1' ]
	, [ 'LocalMarketAdFormatEnabled', 'ns:LocalMarketAdFormatEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::LocalMarketAdFormatEnabledDefinitionType', '1' ]
	, [ 'LocalMarketAutoAcceptEnabled', 'ns:LocalMarketAutoAcceptEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::LocalMarketAutoAcceptEnabledDefinitionType', '1' ]
	, [ 'LocalMarketAutoDeclineEnabled', 'ns:LocalMarketAutoDeclineEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::LocalMarketAutoDeclineEnabledDefinitionType', '1' ]
	, [ 'LocalMarketBestOfferEnabled', 'ns:LocalMarketBestOfferEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::LocalMarketBestOfferEnabledDefinitionType', '1' ]
	, [ 'LocalMarketCompanyNameEnabled', 'ns:LocalMarketCompanyNameEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::LocalMarketCompanyNameEnabledDefinitionType', '1' ]
	, [ 'LocalMarketContactByAddressEnabled', 'ns:LocalMarketContactByAddressEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::LocalMarketContactByAddressEnabledDefinitionType', '1' ]
	, [ 'LocalMarketContactByEmailEnabled', 'ns:LocalMarketContactByEmailEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::LocalMarketContactByEmailEnabledDefinitionType', '1' ]
	, [ 'LocalMarketContactByPhoneEnabled', 'ns:LocalMarketContactByPhoneEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::LocalMarketContactByPhoneEnabledDefinitionType', '1' ]
	, [ 'LocalMarketCounterOfferEnabled', 'ns:LocalMarketCounterOfferEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::LocalMarketCounterOfferEnabledDefinitionType', '1' ]
	, [ 'LocalMarketNonSubscription', 'ns:LocalMarketNonSubscriptionDefinitionType', ''
	     ,'eBay::API::XML::DataType::LocalMarketNonSubscriptionDefinitionType', '1' ]
	, [ 'LocalMarketPaymentMethodCheckOutEnabled', 'ns:LocalMarketPaymentMethodCheckOutEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::LocalMarketPaymentMethodCheckOutEnabledDefinitionType', '1' ]
	, [ 'LocalMarketPhoneCount', 'ns:LocalMarketPhoneCountDefinitionType', ''
	     ,'eBay::API::XML::DataType::LocalMarketPhoneCountDefinitionType', '1' ]
	, [ 'LocalMarketPremiumSubscription', 'ns:LocalMarketPremiumSubscriptionDefinitionType', ''
	     ,'eBay::API::XML::DataType::LocalMarketPremiumSubscriptionDefinitionType', '1' ]
	, [ 'LocalMarketRegularSubscription', 'ns:LocalMarketRegularSubscriptionDefinitionType', ''
	     ,'eBay::API::XML::DataType::LocalMarketRegularSubscriptionDefinitionType', '1' ]
	, [ 'LocalMarketSellerContactDetailsEnabled', 'ns:LocalMarketSellerContactDetailsEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::LocalMarketSellerContactDetailsEnabledDefinitionType', '1' ]
	, [ 'LocalMarketShippingMethodEnabled', 'ns:LocalMarketShippingMethodEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::LocalMarketShippingMethodEnabledDefinitionType', '1' ]
	, [ 'LocalMarketSpecialitySubscription', 'ns:LocalMarketSpecialitySubscriptionDefinitionType', ''
	     ,'eBay::API::XML::DataType::LocalMarketSpecialitySubscriptionDefinitionType', '1' ]
	, [ 'LocalMarketStreetCount', 'ns:LocalMarketStreetCountDefinitionType', ''
	     ,'eBay::API::XML::DataType::LocalMarketStreetCountDefinitionType', '1' ]
	, [ 'MinimumReservePrice', 'ns:MinimumReservePriceDefinitionType', ''
	     ,'eBay::API::XML::DataType::MinimumReservePriceDefinitionType', '1' ]
	, [ 'NonSubscription', 'ns:NonSubscriptionDefinitionType', ''
	     ,'eBay::API::XML::DataType::NonSubscriptionDefinitionType', '1' ]
	, [ 'PaisaPayFullEscrowEnabled', 'ns:PaisaPayFullEscrowEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::PaisaPayFullEscrowEnabledDefinitionType', '1' ]
	, [ 'PayPalBuyerProtectionEnabled', 'ns:PayPalBuyerProtectionEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::PayPalBuyerProtectionEnabledDefinitionType', '1' ]
	, [ 'PayPalRequired', 'ns:PayPalRequiredDefinitionType', ''
	     ,'eBay::API::XML::DataType::PayPalRequiredDefinitionType', '1' ]
	, [ 'PremiumSubscription', 'ns:PremiumSubscriptionDefinitionType', ''
	     ,'eBay::API::XML::DataType::PremiumSubscriptionDefinitionType', '1' ]
	, [ 'ProPackEnabled', 'ns:ProPackEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::ProPackEnabledDefinitionType', '1' ]
	, [ 'ProPackPlusEnabled', 'ns:ProPackPlusEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::ProPackPlusEnabledDefinitionType', '1' ]
	, [ 'RegularSubscription', 'ns:RegularSubscriptionDefinitionType', ''
	     ,'eBay::API::XML::DataType::RegularSubscriptionDefinitionType', '1' ]
	, [ 'SafePaymentRequired', 'ns:SafePaymentRequiredDefinitionType', ''
	     ,'eBay::API::XML::DataType::SafePaymentRequiredDefinitionType', '1' ]
	, [ 'SellerContactDetailsEnabled', 'ns:SellerContactDetailsEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::SellerContactDetailsEnabledDefinitionType', '1' ]
	, [ 'ShippingTermsRequired', 'ns:ShippingTermRequiredDefinitionType', ''
	     ,'eBay::API::XML::DataType::ShippingTermRequiredDefinitionType', '1' ]
	, [ 'SkypeMeNonTransactionalEnabled', 'ns:SkypeMeNonTransactionalEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::SkypeMeNonTransactionalEnabledDefinitionType', '1' ]
	, [ 'SkypeMeTransactionalEnabled', 'ns:SkypeMeTransactionalEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::SkypeMeTransactionalEnabledDefinitionType', '1' ]
	, [ 'SpecialitySubscription', 'ns:SpecialitySubscriptionDefinitionType', ''
	     ,'eBay::API::XML::DataType::SpecialitySubscriptionDefinitionType', '1' ]
	, [ 'StoreInventoryEnabled', 'ns:StoreInventoryEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::StoreInventoryEnabledDefinitionType', '1' ]
	, [ 'TransactionConfirmationRequestEnabled', 'ns:TCREnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::TCREnabledDefinitionType', '1' ]
	, [ 'UserConsentRequired', 'ns:UserConsentRequiredDefinitionType', ''
	     ,'eBay::API::XML::DataType::UserConsentRequiredDefinitionType', '1' ]
	, [ 'ValuePackEnabled', 'ns:ValuePackEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::ValuePackEnabledDefinitionType', '1' ]
	, [ 'eBayMotorsProAdFormatEnabled', 'ns:eBayMotorsProAdFormatEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::eBayMotorsProAdFormatEnabledDefinitionType', '1' ]
	, [ 'eBayMotorsProAutoAcceptEnabled', 'ns:eBayMotorsProAutoAcceptEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::eBayMotorsProAutoAcceptEnabledDefinitionType', '1' ]
	, [ 'eBayMotorsProAutoDeclineEnabled', 'ns:eBayMotorsProAutoDeclineEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::eBayMotorsProAutoDeclineEnabledDefinitionType', '1' ]
	, [ 'eBayMotorsProBestOfferEnabled', 'ns:eBayMotorsProBestOfferEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::eBayMotorsProBestOfferEnabledDefinitionType', '1' ]
	, [ 'eBayMotorsProCompanyNameEnabled', 'ns:eBayMotorsProCompanyNameEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::eBayMotorsProCompanyNameEnabledDefinitionType', '1' ]
	, [ 'eBayMotorsProContactByAddressEnabled', 'ns:eBayMotorsProContactByAddressEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::eBayMotorsProContactByAddressEnabledDefinitionType', '1' ]
	, [ 'eBayMotorsProContactByEmailEnabled', 'ns:eBayMotorsProContactByEmailEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::eBayMotorsProContactByEmailEnabledDefinitionType', '1' ]
	, [ 'eBayMotorsProContactByPhoneEnabled', 'ns:eBayMotorsProContactByPhoneEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::eBayMotorsProContactByPhoneEnabledDefinitionType', '1' ]
	, [ 'eBayMotorsProCounterOfferEnabled', 'ns:eBayMotorsProCounterOfferEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::eBayMotorsProCounterOfferEnabledDefinitionType', '1' ]
	, [ 'eBayMotorsProPaymentMethodCheckOutEnabled', 'ns:eBayMotorsProPaymentMethodCheckOutEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::eBayMotorsProPaymentMethodCheckOutEnabledDefinitionType', '1' ]
	, [ 'eBayMotorsProPhoneCount', 'ns:eBayMotorsProPhoneCountDefinitionType', ''
	     ,'eBay::API::XML::DataType::eBayMotorsProPhoneCountDefinitionType', '1' ]
	, [ 'eBayMotorsProSellerContactDetailsEnabled', 'ns:eBayMotorsProSellerContactDetailsEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::eBayMotorsProSellerContactDetailsEnabledDefinitionType', '1' ]
	, [ 'eBayMotorsProShippingMethodEnabled', 'ns:eBayMotorsProShippingMethodEnabledDefinitionType', ''
	     ,'eBay::API::XML::DataType::eBayMotorsProShippingMethodEnabledDefinitionType', '1' ]
	, [ 'eBayMotorsProStreetCount', 'ns:eBayMotorsProStreetCountDefinitionType', ''
	     ,'eBay::API::XML::DataType::eBayMotorsProStreetCountDefinitionType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAdFormatEnabled()

If present, the corresponding feature ID was passed in the request or all
features were requested (i.e., no feature IDs were specified). Currently, this
field contains no other special meta-data. (An empty element is returned.) Use
the data provided in SiteDefaults and Category to determine which categories
(if any) support this feature.

#    Argument: 'ns:AdFormatEnabledDefinitionType'

=cut

sub setAdFormatEnabled {
  my $self = shift;
  $self->{'AdFormatEnabled'} = shift
}

=head2 getAdFormatEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:AdFormatEnabledDefinitionType'

=cut

sub getAdFormatEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'AdFormatEnabled'
		,'eBay::API::XML::DataType::AdFormatEnabledDefinitionType');
}


=head2 setBasicUpgradePackEnabled()

Not applicable to any site.
Defined the BasicUpgradePack bundle feature (a feature pack).
Formerly, applicable to the Australia site (site ID 15, abbreviation AU) only.

#    Argument: 'ns:BasicUpgradePackEnabledDefinitionType'

=cut

sub setBasicUpgradePackEnabled {
  my $self = shift;
  $self->{'BasicUpgradePackEnabled'} = shift
}

=head2 getBasicUpgradePackEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:BasicUpgradePackEnabledDefinitionType'

=cut

sub getBasicUpgradePackEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'BasicUpgradePackEnabled'
		,'eBay::API::XML::DataType::BasicUpgradePackEnabledDefinitionType');
}


=head2 setBestOfferAutoAcceptEnabled()

Defines the feature that allows sellers to set a
price at which best offers are automatically accepted.
If present, the corresponding feature ID is passed in the request or all
features are requested (i.e., no feature IDs are specified). Currently, this
field contains no other special meta-data. (An empty element is returned.) Use
the data provided in SiteDefaults and Category to determine which categories
(if any) support this feature.

#    Argument: 'ns:BestOfferAutoAcceptEnabledDefinitionType'

=cut

sub setBestOfferAutoAcceptEnabled {
  my $self = shift;
  $self->{'BestOfferAutoAcceptEnabled'} = shift
}

=head2 getBestOfferAutoAcceptEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:BestOfferAutoAcceptEnabledDefinitionType'

=cut

sub getBestOfferAutoAcceptEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'BestOfferAutoAcceptEnabled'
		,'eBay::API::XML::DataType::BestOfferAutoAcceptEnabledDefinitionType');
}


=head2 setBestOfferAutoDeclineEnabled()

If present, the corresponding feature ID was passed in the request or all
features were requested (i.e., no feature IDs were specified). Currently, this
field contains no other special meta-data. (An empty element is returned.) Use
the data provided in SiteDefaults and Category to determine which categories
(if any) support this feature.

#    Argument: 'ns:BestOfferAutoDeclineEnabledDefinitionType'

=cut

sub setBestOfferAutoDeclineEnabled {
  my $self = shift;
  $self->{'BestOfferAutoDeclineEnabled'} = shift
}

=head2 getBestOfferAutoDeclineEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:BestOfferAutoDeclineEnabledDefinitionType'

=cut

sub getBestOfferAutoDeclineEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'BestOfferAutoDeclineEnabled'
		,'eBay::API::XML::DataType::BestOfferAutoDeclineEnabledDefinitionType');
}


=head2 setBestOfferCounterEnabled()

If present, the corresponding feature ID was passed in the request or all
features were requested (i.e., no feature IDs were specified). Currently, this
field contains no other special meta-data. (An empty element is returned.) Use
the data provided in SiteDefaults and Category to determine which categories
(if any) support this feature.

#    Argument: 'ns:BestOfferCounterEnabledDefinitionType'

=cut

sub setBestOfferCounterEnabled {
  my $self = shift;
  $self->{'BestOfferCounterEnabled'} = shift
}

=head2 getBestOfferCounterEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:BestOfferCounterEnabledDefinitionType'

=cut

sub getBestOfferCounterEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'BestOfferCounterEnabled'
		,'eBay::API::XML::DataType::BestOfferCounterEnabledDefinitionType');
}


=head2 setBestOfferEnabled()

If present, the corresponding feature ID was passed in the request or all
features were requested (i.e., no feature IDs were specified). Currently, this
field contains no other special meta-data. (An empty element is returned.) Use
the data provided in SiteDefaults and Category to determine which categories
(if any) support this feature.

#    Argument: 'ns:BestOfferEnabledDefinitionType'

=cut

sub setBestOfferEnabled {
  my $self = shift;
  $self->{'BestOfferEnabled'} = shift
}

=head2 getBestOfferEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:BestOfferEnabledDefinitionType'

=cut

sub getBestOfferEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'BestOfferEnabled'
		,'eBay::API::XML::DataType::BestOfferEnabledDefinitionType');
}


=head2 setBuyerGuaranteeEnabled()

For the Australia site, PayPalBuyerProtectionEnabled and BuyerGuaranteeEnabled
define the feature that allows buyer protection.
If BuyerGuaranteeEnabled present, the corresponding feature ID was passed in the request or all
features were requested (i.e., no feature IDs were specified). Currently, this
field contains no other special meta-data. (An empty element is returned.) Use
the data provided in SiteDefaults and Category to determine which categories
(if any) support this feature.

#    Argument: 'ns:BuyerGuaranteeEnabledDefinitionType'

=cut

sub setBuyerGuaranteeEnabled {
  my $self = shift;
  $self->{'BuyerGuaranteeEnabled'} = shift
}

=head2 getBuyerGuaranteeEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:BuyerGuaranteeEnabledDefinitionType'

=cut

sub getBuyerGuaranteeEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'BuyerGuaranteeEnabled'
		,'eBay::API::XML::DataType::BuyerGuaranteeEnabledDefinitionType');
}


=head2 setClassifiedAdAutoAcceptEnabled()

Defines the feature that allows sellers to set a
price at which best offers are automatically accepted for Classified Ads.
If present, the corresponding feature ID is passed in the request or all
features are requested (i.e., no feature IDs are specified).
Currently, this field contains no other special meta-data.
(An empty element is returned.) Use the data provided
in SiteDefaults and Category to determine
which categories (if any) support this feature.

#    Argument: 'ns:ClassifiedAdAutoAcceptEnabledDefinitionType'

=cut

sub setClassifiedAdAutoAcceptEnabled {
  my $self = shift;
  $self->{'ClassifiedAdAutoAcceptEnabled'} = shift
}

=head2 getClassifiedAdAutoAcceptEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:ClassifiedAdAutoAcceptEnabledDefinitionType'

=cut

sub getClassifiedAdAutoAcceptEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ClassifiedAdAutoAcceptEnabled'
		,'eBay::API::XML::DataType::ClassifiedAdAutoAcceptEnabledDefinitionType');
}


=head2 setClassifiedAdAutoDeclineEnabled()

Indicates whether automatic decline for Best Offers is allowed for Classified
Ad listings in this category. Returned only if this category overrides
the site default.

#    Argument: 'ns:ClassifiedAdAutoDeclineEnabledDefinitionType'

=cut

sub setClassifiedAdAutoDeclineEnabled {
  my $self = shift;
  $self->{'ClassifiedAdAutoDeclineEnabled'} = shift
}

=head2 getClassifiedAdAutoDeclineEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:ClassifiedAdAutoDeclineEnabledDefinitionType'

=cut

sub getClassifiedAdAutoDeclineEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ClassifiedAdAutoDeclineEnabled'
		,'eBay::API::XML::DataType::ClassifiedAdAutoDeclineEnabledDefinitionType');
}


=head2 setClassifiedAdBestOfferEnabled()

Indicates if Best Offer is enabled for Classified Ad listings in this
category.

#    Argument: 'ns:ClassifiedAdBestOfferEnabledDefinitionType'

=cut

sub setClassifiedAdBestOfferEnabled {
  my $self = shift;
  $self->{'ClassifiedAdBestOfferEnabled'} = shift
}

=head2 getClassifiedAdBestOfferEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:ClassifiedAdBestOfferEnabledDefinitionType'

=cut

sub getClassifiedAdBestOfferEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ClassifiedAdBestOfferEnabled'
		,'eBay::API::XML::DataType::ClassifiedAdBestOfferEnabledDefinitionType');
}


=head2 setClassifiedAdCompanyNameEnabled()

Indicates whether the category supports including the company name in the
seller's contact information for Classified Ad listings. Added for For Sale By Owner.

#    Argument: 'ns:ClassifiedAdCompanyNameEnabledDefinitionType'

=cut

sub setClassifiedAdCompanyNameEnabled {
  my $self = shift;
  $self->{'ClassifiedAdCompanyNameEnabled'} = shift
}

=head2 getClassifiedAdCompanyNameEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:ClassifiedAdCompanyNameEnabledDefinitionType'

=cut

sub getClassifiedAdCompanyNameEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ClassifiedAdCompanyNameEnabled'
		,'eBay::API::XML::DataType::ClassifiedAdCompanyNameEnabledDefinitionType');
}


=head2 setClassifiedAdContactByAddressEnabled()

Indicates whether the category supports including an address in the
seller's contact information for Classified Ad listings. Added for For Sale By Owner.

#    Argument: 'ns:ClassifiedAdContactByAddressEnabledDefinitionType'

=cut

sub setClassifiedAdContactByAddressEnabled {
  my $self = shift;
  $self->{'ClassifiedAdContactByAddressEnabled'} = shift
}

=head2 getClassifiedAdContactByAddressEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:ClassifiedAdContactByAddressEnabledDefinitionType'

=cut

sub getClassifiedAdContactByAddressEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ClassifiedAdContactByAddressEnabled'
		,'eBay::API::XML::DataType::ClassifiedAdContactByAddressEnabledDefinitionType');
}


=head2 setClassifiedAdContactByEmailEnabled()

Indicates whether the category supports including an email address in the
seller's contact information for Classified Ad listings.

#    Argument: 'ns:ClassifiedAdContactByEmailEnabledDefintionType'

=cut

sub setClassifiedAdContactByEmailEnabled {
  my $self = shift;
  $self->{'ClassifiedAdContactByEmailEnabled'} = shift
}

=head2 getClassifiedAdContactByEmailEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:ClassifiedAdContactByEmailEnabledDefintionType'

=cut

sub getClassifiedAdContactByEmailEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ClassifiedAdContactByEmailEnabled'
		,'eBay::API::XML::DataType::ClassifiedAdContactByEmailEnabledDefintionType');
}


=head2 setClassifiedAdContactByPhoneEnabled()

Indicates whether the category supports including a telephone number in the
seller's contact information for Classified Ad listings.

#    Argument: 'ns:ClassifiedAdContactByPhoneEnabledDefinitionType'

=cut

sub setClassifiedAdContactByPhoneEnabled {
  my $self = shift;
  $self->{'ClassifiedAdContactByPhoneEnabled'} = shift
}

=head2 getClassifiedAdContactByPhoneEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:ClassifiedAdContactByPhoneEnabledDefinitionType'

=cut

sub getClassifiedAdContactByPhoneEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ClassifiedAdContactByPhoneEnabled'
		,'eBay::API::XML::DataType::ClassifiedAdContactByPhoneEnabledDefinitionType');
}


=head2 setClassifiedAdCounterOfferEnabled()

Indicates whether counter offers are allowed on Best Offers for Classified Ad
listings in this category.
Returned only if this category overrides the site default.

#    Argument: 'ns:ClassifiedAdCounterOfferEnabledDefinitionType'

=cut

sub setClassifiedAdCounterOfferEnabled {
  my $self = shift;
  $self->{'ClassifiedAdCounterOfferEnabled'} = shift
}

=head2 getClassifiedAdCounterOfferEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:ClassifiedAdCounterOfferEnabledDefinitionType'

=cut

sub getClassifiedAdCounterOfferEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ClassifiedAdCounterOfferEnabled'
		,'eBay::API::XML::DataType::ClassifiedAdCounterOfferEnabledDefinitionType');
}


=head2 setClassifiedAdPayPerLeadEnabled()

Some categories can support pay-per-lead listings.
If present, the corresponding feature ID was passed in the request or all
features were requested (i.e., no feature IDs were specified). Currently, this
field contains no other special meta-data. (An empty element is returned.) Use
the data provided in SiteDefaults and Category to determine which categories
(if any) support this feature.

#    Argument: 'ns:ClassifiedAdPayPerLeadEnabledDefinitionType'

=cut

sub setClassifiedAdPayPerLeadEnabled {
  my $self = shift;
  $self->{'ClassifiedAdPayPerLeadEnabled'} = shift
}

=head2 getClassifiedAdPayPerLeadEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:ClassifiedAdPayPerLeadEnabledDefinitionType'

=cut

sub getClassifiedAdPayPerLeadEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ClassifiedAdPayPerLeadEnabled'
		,'eBay::API::XML::DataType::ClassifiedAdPayPerLeadEnabledDefinitionType');
}


=head2 setClassifiedAdPaymentMethodEnabled()

Indicates if the payment method should be displayed to the user for
Classified Ad format listings.
Even if enabled, checkout may or may not be enabled.

#    Argument: 'ns:ClassifiedAdPaymentMethodEnabledDefinitionType'

=cut

sub setClassifiedAdPaymentMethodEnabled {
  my $self = shift;
  $self->{'ClassifiedAdPaymentMethodEnabled'} = shift
}

=head2 getClassifiedAdPaymentMethodEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:ClassifiedAdPaymentMethodEnabledDefinitionType'

=cut

sub getClassifiedAdPaymentMethodEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ClassifiedAdPaymentMethodEnabled'
		,'eBay::API::XML::DataType::ClassifiedAdPaymentMethodEnabledDefinitionType');
}


=head2 setClassifiedAdPhoneCount()

Indicates which telephone option is enabled for the seller's contact information for Classified Ad listings. Added for For Sale By Owner.

#    Argument: 'ns:ClassifiedAdPhoneCountDefinitionType'

=cut

sub setClassifiedAdPhoneCount {
  my $self = shift;
  $self->{'ClassifiedAdPhoneCount'} = shift
}

=head2 getClassifiedAdPhoneCount()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:ClassifiedAdPhoneCountDefinitionType'

=cut

sub getClassifiedAdPhoneCount {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ClassifiedAdPhoneCount'
		,'eBay::API::XML::DataType::ClassifiedAdPhoneCountDefinitionType');
}


=head2 setClassifiedAdShippingMethodEnabled()

Indicates if shipping options are available for Classified Ad listings
in this category.

#    Argument: 'ns:ClassifiedAdShippingMethodEnabledDefinitionType'

=cut

sub setClassifiedAdShippingMethodEnabled {
  my $self = shift;
  $self->{'ClassifiedAdShippingMethodEnabled'} = shift
}

=head2 getClassifiedAdShippingMethodEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:ClassifiedAdShippingMethodEnabledDefinitionType'

=cut

sub getClassifiedAdShippingMethodEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ClassifiedAdShippingMethodEnabled'
		,'eBay::API::XML::DataType::ClassifiedAdShippingMethodEnabledDefinitionType');
}


=head2 setClassifiedAdStreetCount()

Indicates which address option is enabled for the seller's contact information for Classified Ad format listings.
Added for For Sale By Owner.

#    Argument: 'ns:ClassifiedAdStreetCountDefinitionType'

=cut

sub setClassifiedAdStreetCount {
  my $self = shift;
  $self->{'ClassifiedAdStreetCount'} = shift
}

=head2 getClassifiedAdStreetCount()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:ClassifiedAdStreetCountDefinitionType'

=cut

sub getClassifiedAdStreetCount {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ClassifiedAdStreetCount'
		,'eBay::API::XML::DataType::ClassifiedAdStreetCountDefinitionType');
}


=head2 setCombinedFixedPriceTreatmentEnabled()

Defines the feature that combines the following two
listing types: Store Inventory Format and Basic Fixed Price.
If present, the corresponding feature ID was passed in the request or all
features were requested (i.e., no feature IDs were specified). Currently, this
field contains no other special meta-data. (An empty element is returned.) Use
the data provided in SiteDefaults and Category to determine which categories
(if any) support this feature

#    Argument: 'ns:CombinedFixedPriceTreatmentEnabledDefinitionType'

=cut

sub setCombinedFixedPriceTreatmentEnabled {
  my $self = shift;
  $self->{'CombinedFixedPriceTreatmentEnabled'} = shift
}

=head2 getCombinedFixedPriceTreatmentEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:CombinedFixedPriceTreatmentEnabledDefinitionType'

=cut

sub getCombinedFixedPriceTreatmentEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'CombinedFixedPriceTreatmentEnabled'
		,'eBay::API::XML::DataType::CombinedFixedPriceTreatmentEnabledDefinitionType');
}


=head2 setCrossBorderTradeAustraliaEnabled()

Defines the feature that allows you to specify that listings be displayed
in the default search results of the respective site.
If present, the corresponding feature ID was passed in the request or all
features were requested (i.e., no feature IDs were specified). Currently, this
field contains no other special meta-data. (An empty element is returned.) Use
the data provided in SiteDefaults and Category to determine which categories
(if any) support this feature.

#    Argument: 'ns:CrossBorderTradeAustraliaEnabledDefinitionType'

=cut

sub setCrossBorderTradeAustraliaEnabled {
  my $self = shift;
  $self->{'CrossBorderTradeAustraliaEnabled'} = shift
}

=head2 getCrossBorderTradeAustraliaEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:CrossBorderTradeAustraliaEnabledDefinitionType'

=cut

sub getCrossBorderTradeAustraliaEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'CrossBorderTradeAustraliaEnabled'
		,'eBay::API::XML::DataType::CrossBorderTradeAustraliaEnabledDefinitionType');
}


=head2 setCrossBorderTradeGBEnabled()

Defines the feature that allows you to specify that listings be displayed
in the default search results of the respective site.
If present, the corresponding feature ID was passed in the request or all
features were requested (i.e., no feature IDs were specified). Currently, this
field contains no other special meta-data. (An empty element is returned.) Use
the data provided in SiteDefaults and Category to determine which categories
(if any) support this feature.

#    Argument: 'ns:CrossBorderTradeGBEnabledDefinitionType'

=cut

sub setCrossBorderTradeGBEnabled {
  my $self = shift;
  $self->{'CrossBorderTradeGBEnabled'} = shift
}

=head2 getCrossBorderTradeGBEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:CrossBorderTradeGBEnabledDefinitionType'

=cut

sub getCrossBorderTradeGBEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'CrossBorderTradeGBEnabled'
		,'eBay::API::XML::DataType::CrossBorderTradeGBEnabledDefinitionType');
}


=head2 setCrossBorderTradeNorthAmericaEnabled()

Defines the feature that allows you to specify that listings be displayed
in the default search results of the respective site.
If present, the corresponding feature ID was passed in the request or all
features were requested (i.e., no feature IDs were specified). Currently, this
field contains no other special meta-data. (An empty element is returned.) Use
the data provided in SiteDefaults and Category to determine which categories
(if any) support this feature.

#    Argument: 'ns:CrossBorderTradeNorthAmericaEnabledDefinitionType'

=cut

sub setCrossBorderTradeNorthAmericaEnabled {
  my $self = shift;
  $self->{'CrossBorderTradeNorthAmericaEnabled'} = shift
}

=head2 getCrossBorderTradeNorthAmericaEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:CrossBorderTradeNorthAmericaEnabledDefinitionType'

=cut

sub getCrossBorderTradeNorthAmericaEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'CrossBorderTradeNorthAmericaEnabled'
		,'eBay::API::XML::DataType::CrossBorderTradeNorthAmericaEnabledDefinitionType');
}


=head2 setDutchBINEnabled()

If present, the corresponding feature ID was passed in the request or all
features were requested (i.e., no feature IDs were specified). Currently, this
field contains no other special meta-data. (An empty element is returned.) Use
the data provided in SiteDefaults and Category to determine which categories
(if any) support this feature.

#    Argument: 'ns:DutchBINEnabledDefinitionType'

=cut

sub setDutchBINEnabled {
  my $self = shift;
  $self->{'DutchBINEnabled'} = shift
}

=head2 getDutchBINEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:DutchBINEnabledDefinitionType'

=cut

sub getDutchBINEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'DutchBINEnabled'
		,'eBay::API::XML::DataType::DutchBINEnabledDefinitionType');
}


=head2 setExpressConditionRequired()

For the US and Germany sites, an eBay item must meet a number of eligibility
requirements in order to also be included on eBay Express. One requirement is
that the item must include the Item Condition attribute (using Item
Specifics). Some categories may waive this requirement.<br><br> If
present, the corresponding feature ID was passed in the request or all
features were requested (i.e., no feature IDs were specified). Currently, this
field contains no other special meta-data. (An empty element is returned.) Use
the data provided in SiteDefaults and Category to determine which categories
require an item to include the Item Condition attribute in order to be
eligible for Express.

#    Argument: 'ns:ExpressConditionRequiredDefinitionType'

=cut

sub setExpressConditionRequired {
  my $self = shift;
  $self->{'ExpressConditionRequired'} = shift
}

=head2 getExpressConditionRequired()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:ExpressConditionRequiredDefinitionType'

=cut

sub getExpressConditionRequired {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ExpressConditionRequired'
		,'eBay::API::XML::DataType::ExpressConditionRequiredDefinitionType');
}


=head2 setExpressEnabled()

For the US and Germany sites, an eBay item must meet a number of eligibility
requirements in order to also be included on eBay Express. One requirement is
that the category needs to support Express. For example, categories that are
not covered by PayPal Buyer Protection (e.g., Live Auctions and Motors
vehicles) are excluded from Express.<br><br> If present, the
corresponding feature ID was passed in the request or all features were
requested (i.e., no feature IDs were specified). Currently, this field
contains no other special meta-data. (An empty element is returned.) Use the
data provided in SiteDefaults and Category to determine which categories are
enabled for Express.

#    Argument: 'ns:ExpressEnabledDefinitionType'

=cut

sub setExpressEnabled {
  my $self = shift;
  $self->{'ExpressEnabled'} = shift
}

=head2 getExpressEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:ExpressEnabledDefinitionType'

=cut

sub getExpressEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ExpressEnabled'
		,'eBay::API::XML::DataType::ExpressEnabledDefinitionType');
}


=head2 setExpressPicturesRequired()

For the US and Germany sites, an eBay item must meet a number of eligibility
requirements in order to also be included on eBay Express. One requirement is
that the item must include a picture (or gallery image). Some categories
(e.g., Event Tickets) may waive this requirement if a picture is not normally
expected.<br><br> If present, the corresponding feature ID was
passed in the request or all features were requested (i.e., no feature IDs
were specified). Currently, this field contains no other special meta-data.
(An empty element is returned.) Use the data provided in SiteDefaults and
Category to determine which categories requires an item to include a picture
in order to be eligible for Express.

#    Argument: 'ns:ExpressPicturesRequiredDefinitionType'

=cut

sub setExpressPicturesRequired {
  my $self = shift;
  $self->{'ExpressPicturesRequired'} = shift
}

=head2 getExpressPicturesRequired()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:ExpressPicturesRequiredDefinitionType'

=cut

sub getExpressPicturesRequired {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ExpressPicturesRequired'
		,'eBay::API::XML::DataType::ExpressPicturesRequiredDefinitionType');
}


=head2 setGalleryFeaturedDurations()

Defines the feature that enables durations for "Gallery Featured".
If present, the corresponding feature ID was passed in the request or all
features were requested (i.e., no feature IDs were specified). Currently, this
field contains no other special meta-data. (An empty element is returned.) Use
the data provided in SiteDefaults and Category to determine which categories
(if any) support this feature.

#    Argument: 'ns:ListingEnhancementDurationDefinitionType'

=cut

sub setGalleryFeaturedDurations {
  my $self = shift;
  $self->{'GalleryFeaturedDurations'} = shift
}

=head2 getGalleryFeaturedDurations()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:ListingEnhancementDurationDefinitionType'

=cut

sub getGalleryFeaturedDurations {
  my $self = shift;
  return $self->_getDataTypeInstance( 'GalleryFeaturedDurations'
		,'eBay::API::XML::DataType::ListingEnhancementDurationDefinitionType');
}


=head2 setHomePageFeaturedEnabled()

Some categories allow you to enhance a listing by putting it into a rotation
for display on a special area of the eBay home page. Item or feedback
restrictions may apply.<br><br> If present, the corresponding
feature ID was passed in the request or all features were requested (i.e., no
feature IDs were specified). Currently, this field contains no other special
meta-data. (An empty element is returned.) Use the data provided in
SiteDefaults and Category to determine which categories (if any) support this
feature.

#    Argument: 'ns:HomePageFeaturedEnabledDefinitionType'

=cut

sub setHomePageFeaturedEnabled {
  my $self = shift;
  $self->{'HomePageFeaturedEnabled'} = shift
}

=head2 getHomePageFeaturedEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:HomePageFeaturedEnabledDefinitionType'

=cut

sub getHomePageFeaturedEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'HomePageFeaturedEnabled'
		,'eBay::API::XML::DataType::HomePageFeaturedEnabledDefinitionType');
}


=head2 setINEscrowWorkflowTimeline()

Indicates the workflow timeline applicable for the given category on the India site, if
the category supports PaisaPayFullEscrow. If present, the corresponding feature
ID was passed in the request or all features were requested (i.e., no feature IDs were specified).
Currently, this field contains no other special meta-data. (An empty element is returned.) Use
the data provided in SiteDefaults and Category to determine which categories
(if any) support this feature.

#    Argument: 'ns:INEscrowWorkflowTimelineDefinitionType'

=cut

sub setINEscrowWorkflowTimeline {
  my $self = shift;
  $self->{'INEscrowWorkflowTimeline'} = shift
}

=head2 getINEscrowWorkflowTimeline()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:INEscrowWorkflowTimelineDefinitionType'

=cut

sub getINEscrowWorkflowTimeline {
  my $self = shift;
  return $self->_getDataTypeInstance( 'INEscrowWorkflowTimeline'
		,'eBay::API::XML::DataType::INEscrowWorkflowTimelineDefinitionType');
}


=head2 setItemSpecificsEnabled()

Some categories can support custom Item Specifics.
Item Specifics are typical aspects of items in the same category.
They enable users to classify items by presenting descriptive details
in a structured way. For example, in a jewelry category, sellers might
describe lockets with specifics like "Chain Length=18 in." and
"Main Shape=Heart", but in a Washers & Dryers category,
sellers might include "Type=Top-Loading" instead of "Main Shape=Heart".<br>
<br>
If present, the corresponding feature ID was passed in the request
or all features were requested (i.e., no feature IDs were specified).
Currently, this field contains no other special meta-data.
(An empty element is returned.) Use the data provided in SiteDefaults
and Category to determine which categories (if any) support
this feature.

#    Argument: 'ns:ItemSpecificsEnabledDefinitionType'

=cut

sub setItemSpecificsEnabled {
  my $self = shift;
  $self->{'ItemSpecificsEnabled'} = shift
}

=head2 getItemSpecificsEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:ItemSpecificsEnabledDefinitionType'

=cut

sub getItemSpecificsEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ItemSpecificsEnabled'
		,'eBay::API::XML::DataType::ItemSpecificsEnabledDefinitionType');
}


=head2 setListingDurations()

Specifies one or more sets of listing durations. Each set gives durations for
listing types a category could allow. If present, the corresponding feature
ID was passed in the request or all features were requested (i.e., no feature
IDs were specified). Use the data provided in SiteDefaults and Category to
determine which listing formats support each listing duration and whether any
categories override the standard settings.
<br><br>
<bold>Note:</bold> Durations for Local Market listings are not
supported by GetCategoryFeatures.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=localMarketOnMotors
Title: Local Market Listings

#    Argument: 'ns:ListingDurationDefinitionsType'

=cut

sub setListingDurations {
  my $self = shift;
  $self->{'ListingDurations'} = shift
}

=head2 getListingDurations()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:ListingDurationDefinitionsType'

=cut

sub getListingDurations {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ListingDurations'
		,'eBay::API::XML::DataType::ListingDurationDefinitionsType');
}


=head2 setLocalListingDistancesNonSubscription()

Indicates the valid local listing distances allowed for listing Local Market
items by sellers who have not subscribed to either Local Market for Vehicles
or Local Market for Specialty Vehicles.
<br>
Some categories support listing vehicles for the eBay Motors Local Market
only, where Local Market is defined as the area within a set radius about a
specified postal code. The set of valid distances (radii) supported by a
category is based on subscription level.
<br>
Local Market listings are supported for vehicle categories on the US eBay
Motors site only and for US postal codes only.

#    Argument: 'ns:LocalListingDistancesNonSubscriptionDefinitionType'

=cut

sub setLocalListingDistancesNonSubscription {
  my $self = shift;
  $self->{'LocalListingDistancesNonSubscription'} = shift
}

=head2 getLocalListingDistancesNonSubscription()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:LocalListingDistancesNonSubscriptionDefinitionType'

=cut

sub getLocalListingDistancesNonSubscription {
  my $self = shift;
  return $self->_getDataTypeInstance( 'LocalListingDistancesNonSubscription'
		,'eBay::API::XML::DataType::LocalListingDistancesNonSubscriptionDefinitionType');
}


=head2 setLocalListingDistancesRegular()

Indicates the valid local listing distances allowed for listing Local Market
items by sellers subscribed to Local Market for Vehicles.
<br>
Some categories support listing vehicles for the eBay Motors Local Market
only, where Local Market is defined as the area within a set radius about a
specified postal code. The set of valid distances (radii) supported by a
category is based on subscription level.
<br>
Local Market listings are supported for vehicle categories on the US eBay
Motors site only and for US postal codes only.

#    Argument: 'ns:LocalListingDistancesRegularDefinitionType'

=cut

sub setLocalListingDistancesRegular {
  my $self = shift;
  $self->{'LocalListingDistancesRegular'} = shift
}

=head2 getLocalListingDistancesRegular()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:LocalListingDistancesRegularDefinitionType'

=cut

sub getLocalListingDistancesRegular {
  my $self = shift;
  return $self->_getDataTypeInstance( 'LocalListingDistancesRegular'
		,'eBay::API::XML::DataType::LocalListingDistancesRegularDefinitionType');
}


=head2 setLocalListingDistancesSpecialty()

Indicates the valid local listing distances allowed for listing Local Market
items by sellers subscribed to Local Market for Specialty Vehicles.
<br>
Some categories support listing vehicles for the eBay Motors Local Market
only, where Local Market is defined as the area within a set radius about a
specified postal code. The set of valid distances (radii) supported by a
category is based on subscription level.
<br>
Local Market listings are supported for vehicle categories on the US eBay
Motors site only and for US postal codes only.

#    Argument: 'ns:LocalListingDistancesSpecialtyDefinitionType'

=cut

sub setLocalListingDistancesSpecialty {
  my $self = shift;
  $self->{'LocalListingDistancesSpecialty'} = shift
}

=head2 getLocalListingDistancesSpecialty()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:LocalListingDistancesSpecialtyDefinitionType'

=cut

sub getLocalListingDistancesSpecialty {
  my $self = shift;
  return $self->_getDataTypeInstance( 'LocalListingDistancesSpecialty'
		,'eBay::API::XML::DataType::LocalListingDistancesSpecialtyDefinitionType');
}


=head2 setLocalMarketAdFormatEnabled()

If present, the corresponding feature ID was passed in the request or all
features were requested (i.e., no feature IDs were specified). Currently, this
field contains no other special meta-data. (An empty element is returned.) Use
the data provided in SiteDefaults and Category to determine which categories
(if any) support this feature.Added for Local Market users.

#    Argument: 'ns:LocalMarketAdFormatEnabledDefinitionType'

=cut

sub setLocalMarketAdFormatEnabled {
  my $self = shift;
  $self->{'LocalMarketAdFormatEnabled'} = shift
}

=head2 getLocalMarketAdFormatEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:LocalMarketAdFormatEnabledDefinitionType'

=cut

sub getLocalMarketAdFormatEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'LocalMarketAdFormatEnabled'
		,'eBay::API::XML::DataType::LocalMarketAdFormatEnabledDefinitionType');
}


=head2 setLocalMarketAutoAcceptEnabled()

Indicates whether the category supports the use of auto accept
for Classified Ad listings. Added for Local Market users.

#    Argument: 'ns:LocalMarketAutoAcceptEnabledDefinitionType'

=cut

sub setLocalMarketAutoAcceptEnabled {
  my $self = shift;
  $self->{'LocalMarketAutoAcceptEnabled'} = shift
}

=head2 getLocalMarketAutoAcceptEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:LocalMarketAutoAcceptEnabledDefinitionType'

=cut

sub getLocalMarketAutoAcceptEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'LocalMarketAutoAcceptEnabled'
		,'eBay::API::XML::DataType::LocalMarketAutoAcceptEnabledDefinitionType');
}


=head2 setLocalMarketAutoDeclineEnabled()

Indicates whether the category supports the use of auto decline
for Classified Ad listings. Added for Local Market users.

#    Argument: 'ns:LocalMarketAutoDeclineEnabledDefinitionType'

=cut

sub setLocalMarketAutoDeclineEnabled {
  my $self = shift;
  $self->{'LocalMarketAutoDeclineEnabled'} = shift
}

=head2 getLocalMarketAutoDeclineEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:LocalMarketAutoDeclineEnabledDefinitionType'

=cut

sub getLocalMarketAutoDeclineEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'LocalMarketAutoDeclineEnabled'
		,'eBay::API::XML::DataType::LocalMarketAutoDeclineEnabledDefinitionType');
}


=head2 setLocalMarketBestOfferEnabled()

If present, the corresponding feature ID was passed in the request or all
features were requested (i.e., no feature IDs were specified). Currently, this
field contains no other special meta-data. (An empty element is returned.) Use
the data provided in SiteDefaults and Category to determine which categories
(if any) support this feature.Added for  Local Market users.

#    Argument: 'ns:LocalMarketBestOfferEnabledDefinitionType'

=cut

sub setLocalMarketBestOfferEnabled {
  my $self = shift;
  $self->{'LocalMarketBestOfferEnabled'} = shift
}

=head2 getLocalMarketBestOfferEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:LocalMarketBestOfferEnabledDefinitionType'

=cut

sub getLocalMarketBestOfferEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'LocalMarketBestOfferEnabled'
		,'eBay::API::XML::DataType::LocalMarketBestOfferEnabledDefinitionType');
}


=head2 setLocalMarketCompanyNameEnabled()

Indicates whether the category supports including a company name in the
seller's contact information for Classified Ad listings. Added for Local Market users.

#    Argument: 'ns:LocalMarketCompanyNameEnabledDefinitionType'

=cut

sub setLocalMarketCompanyNameEnabled {
  my $self = shift;
  $self->{'LocalMarketCompanyNameEnabled'} = shift
}

=head2 getLocalMarketCompanyNameEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:LocalMarketCompanyNameEnabledDefinitionType'

=cut

sub getLocalMarketCompanyNameEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'LocalMarketCompanyNameEnabled'
		,'eBay::API::XML::DataType::LocalMarketCompanyNameEnabledDefinitionType');
}


=head2 setLocalMarketContactByAddressEnabled()

Indicates whether the category supports including an address in the
seller's contact information for Classified Ad listings. Added for Local Market users.

#    Argument: 'ns:LocalMarketContactByAddressEnabledDefinitionType'

=cut

sub setLocalMarketContactByAddressEnabled {
  my $self = shift;
  $self->{'LocalMarketContactByAddressEnabled'} = shift
}

=head2 getLocalMarketContactByAddressEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:LocalMarketContactByAddressEnabledDefinitionType'

=cut

sub getLocalMarketContactByAddressEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'LocalMarketContactByAddressEnabled'
		,'eBay::API::XML::DataType::LocalMarketContactByAddressEnabledDefinitionType');
}


=head2 setLocalMarketContactByEmailEnabled()

Indicates whether the category supports including an email address in the
seller's contact information for Classified Ad format listings. Added for  Local Market users.

#    Argument: 'ns:LocalMarketContactByEmailEnabledDefinitionType'

=cut

sub setLocalMarketContactByEmailEnabled {
  my $self = shift;
  $self->{'LocalMarketContactByEmailEnabled'} = shift
}

=head2 getLocalMarketContactByEmailEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:LocalMarketContactByEmailEnabledDefinitionType'

=cut

sub getLocalMarketContactByEmailEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'LocalMarketContactByEmailEnabled'
		,'eBay::API::XML::DataType::LocalMarketContactByEmailEnabledDefinitionType');
}


=head2 setLocalMarketContactByPhoneEnabled()

Indicates whether the category supports including a phone number in the
seller's contact information for Classified Ad listings. Added for Local Market users.

#    Argument: 'ns:LocalMarketContactByPhoneEnabledDefinitionType'

=cut

sub setLocalMarketContactByPhoneEnabled {
  my $self = shift;
  $self->{'LocalMarketContactByPhoneEnabled'} = shift
}

=head2 getLocalMarketContactByPhoneEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:LocalMarketContactByPhoneEnabledDefinitionType'

=cut

sub getLocalMarketContactByPhoneEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'LocalMarketContactByPhoneEnabled'
		,'eBay::API::XML::DataType::LocalMarketContactByPhoneEnabledDefinitionType');
}


=head2 setLocalMarketCounterOfferEnabled()

Indicates whether counter offers are allowed on Best Offers for Classified Ad
listings in this category.
Returned only if this category overrides the site default. Added for Local Market users.

#    Argument: 'ns:LocalMarketCounterOfferEnabledDefinitionType'

=cut

sub setLocalMarketCounterOfferEnabled {
  my $self = shift;
  $self->{'LocalMarketCounterOfferEnabled'} = shift
}

=head2 getLocalMarketCounterOfferEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:LocalMarketCounterOfferEnabledDefinitionType'

=cut

sub getLocalMarketCounterOfferEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'LocalMarketCounterOfferEnabled'
		,'eBay::API::XML::DataType::LocalMarketCounterOfferEnabledDefinitionType');
}


=head2 setLocalMarketNonSubscription()

Indicates category support for listing of Local Market items by sellers who
have not subscribed to either Local Market for Vehicles or Local Market for
Specialty Vehicles. If the field is present, the category supports Local
Market listings by sellers without a Local Market subscription. The field is
returned as an empty element (i.e., a boolean value is not returned).
<br>
Some categories support listing vehicles for the eBay Motors Local Market
only, where Local Market is defined as the area within a set radius about a
specified postal code. Support in some categories is based on subscription
level.
<br>
Local Market listings are supported for vehicle categories on the US eBay
Motors site only and for US postal codes only.

#    Argument: 'ns:LocalMarketNonSubscriptionDefinitionType'

=cut

sub setLocalMarketNonSubscription {
  my $self = shift;
  $self->{'LocalMarketNonSubscription'} = shift
}

=head2 getLocalMarketNonSubscription()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:LocalMarketNonSubscriptionDefinitionType'

=cut

sub getLocalMarketNonSubscription {
  my $self = shift;
  return $self->_getDataTypeInstance( 'LocalMarketNonSubscription'
		,'eBay::API::XML::DataType::LocalMarketNonSubscriptionDefinitionType');
}


=head2 setLocalMarketPaymentMethodCheckOutEnabled()

Indicates whether the category supports the use of payment method checkOut
for Classified Ad listings. Added for Local Market users.

#    Argument: 'ns:LocalMarketPaymentMethodCheckOutEnabledDefinitionType'

=cut

sub setLocalMarketPaymentMethodCheckOutEnabled {
  my $self = shift;
  $self->{'LocalMarketPaymentMethodCheckOutEnabled'} = shift
}

=head2 getLocalMarketPaymentMethodCheckOutEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:LocalMarketPaymentMethodCheckOutEnabledDefinitionType'

=cut

sub getLocalMarketPaymentMethodCheckOutEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'LocalMarketPaymentMethodCheckOutEnabled'
		,'eBay::API::XML::DataType::LocalMarketPaymentMethodCheckOutEnabledDefinitionType');
}


=head2 setLocalMarketPhoneCount()

Indicates which telephone option is enabled for the seller's contact information for Classified Ad listings. Added for Local Market users.

#    Argument: 'ns:LocalMarketPhoneCountDefinitionType'

=cut

sub setLocalMarketPhoneCount {
  my $self = shift;
  $self->{'LocalMarketPhoneCount'} = shift
}

=head2 getLocalMarketPhoneCount()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:LocalMarketPhoneCountDefinitionType'

=cut

sub getLocalMarketPhoneCount {
  my $self = shift;
  return $self->_getDataTypeInstance( 'LocalMarketPhoneCount'
		,'eBay::API::XML::DataType::LocalMarketPhoneCountDefinitionType');
}


=head2 setLocalMarketPremiumSubscription()

Indicates category support for listing of Local Market items by sellers with
premium Local Market subscriptions. If the field is present, the category
supports Local Market listings by sellers with a premium Local Market
subscription. The field is returned as an empty element (i.e., a boolean
value is not returned).
<br>
Some categories support listing vehicles for the eBay Motors Local Market
only, where Local Market is defined as the area within a set radius about a
specified postal code. Support in some categories is based on subscription
level.
<br>
Local Market listings are supported for vehicle categories on the US eBay
Motors site only and for US postal codes only.

#    Argument: 'ns:LocalMarketPremiumSubscriptionDefinitionType'

=cut

sub setLocalMarketPremiumSubscription {
  my $self = shift;
  $self->{'LocalMarketPremiumSubscription'} = shift
}

=head2 getLocalMarketPremiumSubscription()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:LocalMarketPremiumSubscriptionDefinitionType'

=cut

sub getLocalMarketPremiumSubscription {
  my $self = shift;
  return $self->_getDataTypeInstance( 'LocalMarketPremiumSubscription'
		,'eBay::API::XML::DataType::LocalMarketPremiumSubscriptionDefinitionType');
}


=head2 setLocalMarketRegularSubscription()

Indicates category support for listing of Local Market items by sellers
subscribed to Local Market for Vehicles. If the field is present, the
category supports Local Market listings by sellers with a Local Market for
Vehicles subscription. The field is returned as an empty element (i.e., a
boolean value is not returned).
<br>
Some categories support listing vehicles for the eBay Motors Local Market
only, where Local Market is defined as the area within a set radius about a
specified postal code. Support in some categories is based on subscription
level.
<br>
Local Market listings are supported for vehicle categories on the US eBay
Motors site only and for US postal codes only.

#    Argument: 'ns:LocalMarketRegularSubscriptionDefinitionType'

=cut

sub setLocalMarketRegularSubscription {
  my $self = shift;
  $self->{'LocalMarketRegularSubscription'} = shift
}

=head2 getLocalMarketRegularSubscription()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:LocalMarketRegularSubscriptionDefinitionType'

=cut

sub getLocalMarketRegularSubscription {
  my $self = shift;
  return $self->_getDataTypeInstance( 'LocalMarketRegularSubscription'
		,'eBay::API::XML::DataType::LocalMarketRegularSubscriptionDefinitionType');
}


=head2 setLocalMarketSellerContactDetailsEnabled()

Defines the SellerContactDetails feature. If the field is present, the
corresponding feature applies to the category. The field is returned as an
empty element (e.g., a boolean value is not returned).
Added for Local Market users.

#    Argument: 'ns:LocalMarketSellerContactDetailsEnabledDefinitionType'

=cut

sub setLocalMarketSellerContactDetailsEnabled {
  my $self = shift;
  $self->{'LocalMarketSellerContactDetailsEnabled'} = shift
}

=head2 getLocalMarketSellerContactDetailsEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:LocalMarketSellerContactDetailsEnabledDefinitionType'

=cut

sub getLocalMarketSellerContactDetailsEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'LocalMarketSellerContactDetailsEnabled'
		,'eBay::API::XML::DataType::LocalMarketSellerContactDetailsEnabledDefinitionType');
}


=head2 setLocalMarketShippingMethodEnabled()

Indicates if shipping options are available for Classified Ad format listings
in this category. Added for Local Market users.

#    Argument: 'ns:LocalMarketShippingMethodEnabledDefinitionType'

=cut

sub setLocalMarketShippingMethodEnabled {
  my $self = shift;
  $self->{'LocalMarketShippingMethodEnabled'} = shift
}

=head2 getLocalMarketShippingMethodEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:LocalMarketShippingMethodEnabledDefinitionType'

=cut

sub getLocalMarketShippingMethodEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'LocalMarketShippingMethodEnabled'
		,'eBay::API::XML::DataType::LocalMarketShippingMethodEnabledDefinitionType');
}


=head2 setLocalMarketSpecialitySubscription()

Indicates category support for listing of Local Market items by sellers
subscribed to Local Market for Specialty Vehicles. If the field is present,
the category supports Local Market listings by sellers with a Local Market
for Specialty Vehicles subscription. The field is returned as an empty
element (i.e., a boolean value is not returned).
<br>
Some categories support listing vehicles for the eBay Motors Local Market
only, where Local Market is defined as the area within a set radius about a
specified postal code. Support in some categories is based on subscription
level.
<br>
Local Market listings are supported for vehicle categories on the US eBay
Motors site only and for US postal codes only.

#    Argument: 'ns:LocalMarketSpecialitySubscriptionDefinitionType'

=cut

sub setLocalMarketSpecialitySubscription {
  my $self = shift;
  $self->{'LocalMarketSpecialitySubscription'} = shift
}

=head2 getLocalMarketSpecialitySubscription()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:LocalMarketSpecialitySubscriptionDefinitionType'

=cut

sub getLocalMarketSpecialitySubscription {
  my $self = shift;
  return $self->_getDataTypeInstance( 'LocalMarketSpecialitySubscription'
		,'eBay::API::XML::DataType::LocalMarketSpecialitySubscriptionDefinitionType');
}


=head2 setLocalMarketStreetCount()

Indicates which address option is enabled for the seller's contact information for Classified Ad format listings.
Added for  Local Market users.

#    Argument: 'ns:LocalMarketStreetCountDefinitionType'

=cut

sub setLocalMarketStreetCount {
  my $self = shift;
  $self->{'LocalMarketStreetCount'} = shift
}

=head2 getLocalMarketStreetCount()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:LocalMarketStreetCountDefinitionType'

=cut

sub getLocalMarketStreetCount {
  my $self = shift;
  return $self->_getDataTypeInstance( 'LocalMarketStreetCount'
		,'eBay::API::XML::DataType::LocalMarketStreetCountDefinitionType');
}


=head2 setMinimumReservePrice()

If present, the corresponding feature ID was passed in the request or all
features were requested (i.e., no feature IDs were specified). On the Germany,
Austria, Belgium French, and Belgium
Dutch sites, Minimum Reserve Price is supported for the Art and Antiques,
Watches and Jewelry, and Motorbikes categories.

#    Argument: 'ns:MinimumReservePriceDefinitionType'

=cut

sub setMinimumReservePrice {
  my $self = shift;
  $self->{'MinimumReservePrice'} = shift
}

=head2 getMinimumReservePrice()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:MinimumReservePriceDefinitionType'

=cut

sub getMinimumReservePrice {
  my $self = shift;
  return $self->_getDataTypeInstance( 'MinimumReservePrice'
		,'eBay::API::XML::DataType::MinimumReservePriceDefinitionType');
}


=head2 setNonSubscription()

This is for For Sale By Owner.
Each of the subscriptions will have following options, which will define
"National" vs "Local" ad format listing.
"LocalOptional" : This will allow national and local listing.
"LocalOnly" : Seller can have Local listings only.
"NationalOnly" : Seller can not opt into local only exposure. It has to be
national listing.

#    Argument: 'ns:NonSubscriptionDefinitionType'

=cut

sub setNonSubscription {
  my $self = shift;
  $self->{'NonSubscription'} = shift
}

=head2 getNonSubscription()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:NonSubscriptionDefinitionType'

=cut

sub getNonSubscription {
  my $self = shift;
  return $self->_getDataTypeInstance( 'NonSubscription'
		,'eBay::API::XML::DataType::NonSubscriptionDefinitionType');
}


=head2 setPaisaPayFullEscrowEnabled()

Indicates whether the category supports Paisapay Escrow payment method.
If present, the corresponding feature ID was passed in the request or all
features were requested (i.e., no feature IDs were specified). Currently, this
field contains no other special meta-data. (An empty element is returned.) Use
the data provided in SiteDefaults and Category to determine which categories
(if any) support this feature.

#    Argument: 'ns:PaisaPayFullEscrowEnabledDefinitionType'

=cut

sub setPaisaPayFullEscrowEnabled {
  my $self = shift;
  $self->{'PaisaPayFullEscrowEnabled'} = shift
}

=head2 getPaisaPayFullEscrowEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:PaisaPayFullEscrowEnabledDefinitionType'

=cut

sub getPaisaPayFullEscrowEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'PaisaPayFullEscrowEnabled'
		,'eBay::API::XML::DataType::PaisaPayFullEscrowEnabledDefinitionType');
}


=head2 setPayPalBuyerProtectionEnabled()

For the Australia site, PayPalBuyerProtectionEnabled and BuyerGuaranteeEnabled
define the feature that allows buyer protection.
If PayPalBuyerProtectionEnabled present, the corresponding feature ID was passed in the request or all
features were requested (i.e., no feature IDs were specified). Currently, this
field contains no other special meta-data. (An empty element is returned.) Use
the data provided in SiteDefaults and Category to determine which categories
(if any) support this feature.

#    Argument: 'ns:PayPalBuyerProtectionEnabledDefinitionType'

=cut

sub setPayPalBuyerProtectionEnabled {
  my $self = shift;
  $self->{'PayPalBuyerProtectionEnabled'} = shift
}

=head2 getPayPalBuyerProtectionEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:PayPalBuyerProtectionEnabledDefinitionType'

=cut

sub getPayPalBuyerProtectionEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'PayPalBuyerProtectionEnabled'
		,'eBay::API::XML::DataType::PayPalBuyerProtectionEnabledDefinitionType');
}


=head2 setPayPalRequired()

Defines PayPal as a required payment method.
If present, the corresponding feature ID was passed in the request or all
features were requested (i.e., no feature IDs were specified). Currently, this
field contains no other special meta-data. (An empty element is returned.) Use
the data provided in SiteDefaults and Category to determine which categories
(if any) support this feature.

#    Argument: 'ns:PayPalRequiredDefinitionType'

=cut

sub setPayPalRequired {
  my $self = shift;
  $self->{'PayPalRequired'} = shift
}

=head2 getPayPalRequired()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:PayPalRequiredDefinitionType'

=cut

sub getPayPalRequired {
  my $self = shift;
  return $self->_getDataTypeInstance( 'PayPalRequired'
		,'eBay::API::XML::DataType::PayPalRequiredDefinitionType');
}


=head2 setPremiumSubscription()

Indicates category support for listing of Local Market items by sellers
subscribed to Local Market for Premium Vehicles.
Each of the subscriptions will have following options, which will define
"National" vs "Local" ad format listing.
"LocalOptional" : This will allow national and local listing.
"LocalOnly" : Seller can have Local listings only.
"NationalOnly" : Seller can not opt into local only exposure. It has to be
national listing.

#    Argument: 'ns:PremiumSubscriptionDefinitionType'

=cut

sub setPremiumSubscription {
  my $self = shift;
  $self->{'PremiumSubscription'} = shift
}

=head2 getPremiumSubscription()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:PremiumSubscriptionDefinitionType'

=cut

sub getPremiumSubscription {
  my $self = shift;
  return $self->_getDataTypeInstance( 'PremiumSubscription'
		,'eBay::API::XML::DataType::PremiumSubscriptionDefinitionType');
}


=head2 setProPackEnabled()

Defines the ProPack feature (a feature pack).
If present, the corresponding feature ID was passed in the request or all
features were requested (i.e., no feature IDs were specified). Currently, this
field contains no other special meta-data. (An empty element is returned.) Use
the data provided in SiteDefaults and Category to determine which categories
(if any) support this feature.

#    Argument: 'ns:ProPackEnabledDefinitionType'

=cut

sub setProPackEnabled {
  my $self = shift;
  $self->{'ProPackEnabled'} = shift
}

=head2 getProPackEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:ProPackEnabledDefinitionType'

=cut

sub getProPackEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ProPackEnabled'
		,'eBay::API::XML::DataType::ProPackEnabledDefinitionType');
}


=head2 setProPackPlusEnabled()

Defines the ProPackPlus bundle feature (a feature pack).
If present, the corresponding feature ID was passed in the request or all
features were requested (i.e., no feature IDs were specified). Currently, this
field contains no other special meta-data. (An empty element is returned.) Use
the data provided in SiteDefaults and Category to determine which categories
(if any) support this feature.

#    Argument: 'ns:ProPackPlusEnabledDefinitionType'

=cut

sub setProPackPlusEnabled {
  my $self = shift;
  $self->{'ProPackPlusEnabled'} = shift
}

=head2 getProPackPlusEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:ProPackPlusEnabledDefinitionType'

=cut

sub getProPackPlusEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ProPackPlusEnabled'
		,'eBay::API::XML::DataType::ProPackPlusEnabledDefinitionType');
}


=head2 setRegularSubscription()

Indicates category support for listing of Local Market items by sellers
subscribed to Local Market for Regular Vehicles.
Each of the subscriptions will have following options, which will define
"National" vs "Local" ad format listing.
"LocalOptional" : This will allow national and local listing.
"LocalOnly" : Seller can have Local listings only.
"NationalOnly" : Seller can not opt into local only exposure. It has to be
national listing.

#    Argument: 'ns:RegularSubscriptionDefinitionType'

=cut

sub setRegularSubscription {
  my $self = shift;
  $self->{'RegularSubscription'} = shift
}

=head2 getRegularSubscription()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:RegularSubscriptionDefinitionType'

=cut

sub getRegularSubscription {
  my $self = shift;
  return $self->_getDataTypeInstance( 'RegularSubscription'
		,'eBay::API::XML::DataType::RegularSubscriptionDefinitionType');
}


=head2 setSafePaymentRequired()

For the US, Canada and Australia sites, users registered after January
17,2007 are required to offer at least one safe payment method (i.e.
PayPal/PaisaPay, or one of the credit cards specified in
Item.PaymentMethods).
<br>
If a seller has a 'SafePaymentExempt' status, they are exempt from the
category requirement to offer at least one safe payment method when listing
an item on a site that has the safe payment requirement.
<br>
The safe payment requirement also applies to two-category listings that have
one ship-to or available-to location in the US, Canada, or Australia. The
French Canadian (CAFR) site is a special case, because listings on the CAFR
site with ship-to or available-to locations in Canada do not require a Safe
Payment method, yet listings on the CAFR site with ship-to or available-to
locations in the US or Australia do require a Safe Payment method.
<br>
The Business and Industrial, Motors, Real Estate, and Mature Audiences
categories, and all listings that don't support Item.PaymentMethods are
exempt from this requirement. Therefore, listings in those categories do not
require a safe payment method.
<br>
Currently, this field contains no other special meta-data.(An empty element
is returned.)
<br>
Use SiteDefaults.SafePaymentRequired and Category.SafePaymentRequired to
determine which categories require a safe payment method.

#    Argument: 'ns:SafePaymentRequiredDefinitionType'

=cut

sub setSafePaymentRequired {
  my $self = shift;
  $self->{'SafePaymentRequired'} = shift
}

=head2 getSafePaymentRequired()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:SafePaymentRequiredDefinitionType'

=cut

sub getSafePaymentRequired {
  my $self = shift;
  return $self->_getDataTypeInstance( 'SafePaymentRequired'
		,'eBay::API::XML::DataType::SafePaymentRequiredDefinitionType');
}


=head2 setSellerContactDetailsEnabled()

Defines the SellerContactDetails feature. If the field is present, the
corresponding feature applies to the category. The field is returned as an
empty element (e.g., a boolean value is not returned).
Applies to Classified Ad format listings.

#    Argument: 'ns:SellerContactDetailsEnabledDefinitionType'

=cut

sub setSellerContactDetailsEnabled {
  my $self = shift;
  $self->{'SellerContactDetailsEnabled'} = shift
}

=head2 getSellerContactDetailsEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:SellerContactDetailsEnabledDefinitionType'

=cut

sub getSellerContactDetailsEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'SellerContactDetailsEnabled'
		,'eBay::API::XML::DataType::SellerContactDetailsEnabledDefinitionType');
}


=head2 setShippingTermsRequired()

Some categories may require the seller to specify at least one
domestic shipping service and associated cost for an listing.
If present, the corresponding feature ID was passed in the request
or all features were requested (i.e., no feature IDs were specified). Currently,
this field contains no other special meta-data. (An empty element is
returned.) Use the data provided in SiteDefaults and Category to determine
which categories (if any) support this feature.

#    Argument: 'ns:ShippingTermRequiredDefinitionType'

=cut

sub setShippingTermsRequired {
  my $self = shift;
  $self->{'ShippingTermsRequired'} = shift
}

=head2 getShippingTermsRequired()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:ShippingTermRequiredDefinitionType'

=cut

sub getShippingTermsRequired {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ShippingTermsRequired'
		,'eBay::API::XML::DataType::ShippingTermRequiredDefinitionType');
}


=head2 setSkypeMeNonTransactionalEnabled()

If present, the corresponding feature ID was passed in the request or all
features were requested (i.e., no feature IDs were specified). Currently, this
field contains no other special meta-data. (An empty element is returned.) Use
the data provided in SiteDefaults and Category to determine which categories
(if any) support this feature.

#    Argument: 'ns:SkypeMeNonTransactionalEnabledDefinitionType'

=cut

sub setSkypeMeNonTransactionalEnabled {
  my $self = shift;
  $self->{'SkypeMeNonTransactionalEnabled'} = shift
}

=head2 getSkypeMeNonTransactionalEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:SkypeMeNonTransactionalEnabledDefinitionType'

=cut

sub getSkypeMeNonTransactionalEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'SkypeMeNonTransactionalEnabled'
		,'eBay::API::XML::DataType::SkypeMeNonTransactionalEnabledDefinitionType');
}


=head2 setSkypeMeTransactionalEnabled()

If present, the corresponding feature ID was passed in the request or all
features were requested (i.e., no feature IDs were specified). Currently, this
field contains no other special meta-data. (An empty element is returned.) Use
the data provided in SiteDefaults and Category to determine which categories
(if any) support this feature.

#    Argument: 'ns:SkypeMeTransactionalEnabledDefinitionType'

=cut

sub setSkypeMeTransactionalEnabled {
  my $self = shift;
  $self->{'SkypeMeTransactionalEnabled'} = shift
}

=head2 getSkypeMeTransactionalEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:SkypeMeTransactionalEnabledDefinitionType'

=cut

sub getSkypeMeTransactionalEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'SkypeMeTransactionalEnabled'
		,'eBay::API::XML::DataType::SkypeMeTransactionalEnabledDefinitionType');
}


=head2 setSpecialitySubscription()

Indicates category support for listing of Local Market items by sellers
subscribed to Local Market for Specialty Vehicles.
Each of the subscriptions will have following options, which will define
"National" vs "Local" ad format listing.
"LocalOptional" : This will allow national and local listing.
"LocalOnly" : Seller can have Local listings only.
"NationalOnly" : Seller can not opt into local only exposure. It has to be
national listing.

#    Argument: 'ns:SpecialitySubscriptionDefinitionType'

=cut

sub setSpecialitySubscription {
  my $self = shift;
  $self->{'SpecialitySubscription'} = shift
}

=head2 getSpecialitySubscription()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:SpecialitySubscriptionDefinitionType'

=cut

sub getSpecialitySubscription {
  my $self = shift;
  return $self->_getDataTypeInstance( 'SpecialitySubscription'
		,'eBay::API::XML::DataType::SpecialitySubscriptionDefinitionType');
}


=head2 setStoreInventoryEnabled()

If present, the corresponding feature ID was passed
in the request or all features were requested (i.e., no feature IDs were specified).
Currently, this field contains no other special meta-data. (An empty element is returned.)
Use the data provided in SiteDefaults and Category to determine
which categories (if any) support this feature.

#    Argument: 'ns:StoreInventoryEnabledDefinitionType'

=cut

sub setStoreInventoryEnabled {
  my $self = shift;
  $self->{'StoreInventoryEnabled'} = shift
}

=head2 getStoreInventoryEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:StoreInventoryEnabledDefinitionType'

=cut

sub getStoreInventoryEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'StoreInventoryEnabled'
		,'eBay::API::XML::DataType::StoreInventoryEnabledDefinitionType');
}


=head2 setTransactionConfirmationRequestEnabled()

Applies to the US eBay Motors site (except Parts and Accessories category).
Defines the Transaction Confirmation Request feature. If the field is
present, the corresponding feature applies to the category. The field is
returned as an empty element (i.e., a boolean value is not returned).

#    Argument: 'ns:TCREnabledDefinitionType'

=cut

sub setTransactionConfirmationRequestEnabled {
  my $self = shift;
  $self->{'TransactionConfirmationRequestEnabled'} = shift
}

=head2 getTransactionConfirmationRequestEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:TCREnabledDefinitionType'

=cut

sub getTransactionConfirmationRequestEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'TransactionConfirmationRequestEnabled'
		,'eBay::API::XML::DataType::TCREnabledDefinitionType');
}


=head2 setUserConsentRequired()

If present, the corresponding feature ID was passed in the request or all
features were requested (i.e., no feature IDs were specified). Currently, this
field contains no other special meta-data. (An empty element is returned.) Use
the data provided in SiteDefaults and Category to determine which categories
(if any) support this feature.

#    Argument: 'ns:UserConsentRequiredDefinitionType'

=cut

sub setUserConsentRequired {
  my $self = shift;
  $self->{'UserConsentRequired'} = shift
}

=head2 getUserConsentRequired()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:UserConsentRequiredDefinitionType'

=cut

sub getUserConsentRequired {
  my $self = shift;
  return $self->_getDataTypeInstance( 'UserConsentRequired'
		,'eBay::API::XML::DataType::UserConsentRequiredDefinitionType');
}


=head2 setValuePackEnabled()

Defines the ValuePack bundle feature (a feature pack).
If present, the corresponding feature ID was passed in the request or all
features were requested (i.e., no feature IDs were specified). Currently, this
field contains no other special meta-data. (An empty element is returned.) Use
the data provided in SiteDefaults and Category to determine which categories
(if any) support this feature.

#    Argument: 'ns:ValuePackEnabledDefinitionType'

=cut

sub setValuePackEnabled {
  my $self = shift;
  $self->{'ValuePackEnabled'} = shift
}

=head2 getValuePackEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:ValuePackEnabledDefinitionType'

=cut

sub getValuePackEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ValuePackEnabled'
		,'eBay::API::XML::DataType::ValuePackEnabledDefinitionType');
}


=head2 setEBayMotorsProAdFormatEnabled()

If present, the corresponding feature ID was passed in the request or all
features were requested (i.e., no feature IDs were specified). Currently, this
field contains no other special meta-data. (An empty element is returned.) Use
the data provided in SiteDefaults and Category to determine which categories
(if any) support this feature.Added for eBay Motors Pro users

#    Argument: 'ns:eBayMotorsProAdFormatEnabledDefinitionType'

=cut

sub setEBayMotorsProAdFormatEnabled {
  my $self = shift;
  $self->{'eBayMotorsProAdFormatEnabled'} = shift
}

=head2 getEBayMotorsProAdFormatEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:eBayMotorsProAdFormatEnabledDefinitionType'

=cut

sub getEBayMotorsProAdFormatEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'eBayMotorsProAdFormatEnabled'
		,'eBay::API::XML::DataType::eBayMotorsProAdFormatEnabledDefinitionType');
}


=head2 setEBayMotorsProAutoAcceptEnabled()

Indicates whether the category supports the use of auto accept
for Classified Ad listings. Added for eBay Motors Pro users.

#    Argument: 'ns:eBayMotorsProAutoAcceptEnabledDefinitionType'

=cut

sub setEBayMotorsProAutoAcceptEnabled {
  my $self = shift;
  $self->{'eBayMotorsProAutoAcceptEnabled'} = shift
}

=head2 getEBayMotorsProAutoAcceptEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:eBayMotorsProAutoAcceptEnabledDefinitionType'

=cut

sub getEBayMotorsProAutoAcceptEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'eBayMotorsProAutoAcceptEnabled'
		,'eBay::API::XML::DataType::eBayMotorsProAutoAcceptEnabledDefinitionType');
}


=head2 setEBayMotorsProAutoDeclineEnabled()

Indicates whether the category supports the use of auto decline
for Classified Ad listings. Added for eBay Motors Pro users.

#    Argument: 'ns:eBayMotorsProAutoDeclineEnabledDefinitionType'

=cut

sub setEBayMotorsProAutoDeclineEnabled {
  my $self = shift;
  $self->{'eBayMotorsProAutoDeclineEnabled'} = shift
}

=head2 getEBayMotorsProAutoDeclineEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:eBayMotorsProAutoDeclineEnabledDefinitionType'

=cut

sub getEBayMotorsProAutoDeclineEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'eBayMotorsProAutoDeclineEnabled'
		,'eBay::API::XML::DataType::eBayMotorsProAutoDeclineEnabledDefinitionType');
}


=head2 setEBayMotorsProBestOfferEnabled()

Indicates if Best Offer is enabled for Classified Ad listings in this
category. Added for eBay Motors Pro users.

#    Argument: 'ns:eBayMotorsProBestOfferEnabledDefinitionType'

=cut

sub setEBayMotorsProBestOfferEnabled {
  my $self = shift;
  $self->{'eBayMotorsProBestOfferEnabled'} = shift
}

=head2 getEBayMotorsProBestOfferEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:eBayMotorsProBestOfferEnabledDefinitionType'

=cut

sub getEBayMotorsProBestOfferEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'eBayMotorsProBestOfferEnabled'
		,'eBay::API::XML::DataType::eBayMotorsProBestOfferEnabledDefinitionType');
}


=head2 setEBayMotorsProCompanyNameEnabled()

Indicates whether the category supports including a company name in the
seller's contact information for Classified Ad listings. Added for eBay Motors Pro users.

#    Argument: 'ns:eBayMotorsProCompanyNameEnabledDefinitionType'

=cut

sub setEBayMotorsProCompanyNameEnabled {
  my $self = shift;
  $self->{'eBayMotorsProCompanyNameEnabled'} = shift
}

=head2 getEBayMotorsProCompanyNameEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:eBayMotorsProCompanyNameEnabledDefinitionType'

=cut

sub getEBayMotorsProCompanyNameEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'eBayMotorsProCompanyNameEnabled'
		,'eBay::API::XML::DataType::eBayMotorsProCompanyNameEnabledDefinitionType');
}


=head2 setEBayMotorsProContactByAddressEnabled()

Indicates whether the category supports including an address in the
seller's contact information for Classified Ad listings. Added for eBay Motors Pro users.

#    Argument: 'ns:eBayMotorsProContactByAddressEnabledDefinitionType'

=cut

sub setEBayMotorsProContactByAddressEnabled {
  my $self = shift;
  $self->{'eBayMotorsProContactByAddressEnabled'} = shift
}

=head2 getEBayMotorsProContactByAddressEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:eBayMotorsProContactByAddressEnabledDefinitionType'

=cut

sub getEBayMotorsProContactByAddressEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'eBayMotorsProContactByAddressEnabled'
		,'eBay::API::XML::DataType::eBayMotorsProContactByAddressEnabledDefinitionType');
}


=head2 setEBayMotorsProContactByEmailEnabled()

Indicates whether the category supports including an email address in the
seller's contact information for Classified Ad listings. Added for eBay Motors Pro users.

#    Argument: 'ns:eBayMotorsProContactByEmailEnabledDefinitionType'

=cut

sub setEBayMotorsProContactByEmailEnabled {
  my $self = shift;
  $self->{'eBayMotorsProContactByEmailEnabled'} = shift
}

=head2 getEBayMotorsProContactByEmailEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:eBayMotorsProContactByEmailEnabledDefinitionType'

=cut

sub getEBayMotorsProContactByEmailEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'eBayMotorsProContactByEmailEnabled'
		,'eBay::API::XML::DataType::eBayMotorsProContactByEmailEnabledDefinitionType');
}


=head2 setEBayMotorsProContactByPhoneEnabled()

Indicates whether the category supports including a phone number in the
seller's contact information for Classified Ad listings. Added for eBay Motors Pro users.

#    Argument: 'ns:eBayMotorsProContactByPhoneEnabledDefinitionType'

=cut

sub setEBayMotorsProContactByPhoneEnabled {
  my $self = shift;
  $self->{'eBayMotorsProContactByPhoneEnabled'} = shift
}

=head2 getEBayMotorsProContactByPhoneEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:eBayMotorsProContactByPhoneEnabledDefinitionType'

=cut

sub getEBayMotorsProContactByPhoneEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'eBayMotorsProContactByPhoneEnabled'
		,'eBay::API::XML::DataType::eBayMotorsProContactByPhoneEnabledDefinitionType');
}


=head2 setEBayMotorsProCounterOfferEnabled()

Indicates whether counter offers are allowed on Best Offers for Classified Ad
listings in this category.
Returned only if this category overrides the site default.
Added for eBay Motors Pro users.

#    Argument: 'ns:eBayMotorsProCounterOfferEnabledDefinitionType'

=cut

sub setEBayMotorsProCounterOfferEnabled {
  my $self = shift;
  $self->{'eBayMotorsProCounterOfferEnabled'} = shift
}

=head2 getEBayMotorsProCounterOfferEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:eBayMotorsProCounterOfferEnabledDefinitionType'

=cut

sub getEBayMotorsProCounterOfferEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'eBayMotorsProCounterOfferEnabled'
		,'eBay::API::XML::DataType::eBayMotorsProCounterOfferEnabledDefinitionType');
}


=head2 setEBayMotorsProPaymentMethodCheckOutEnabled()

Indicates whether the category supports the use of payment method checkOut
for Classified Ad listings. Added for eBay Motors Pro users.

#    Argument: 'ns:eBayMotorsProPaymentMethodCheckOutEnabledDefinitionType'

=cut

sub setEBayMotorsProPaymentMethodCheckOutEnabled {
  my $self = shift;
  $self->{'eBayMotorsProPaymentMethodCheckOutEnabled'} = shift
}

=head2 getEBayMotorsProPaymentMethodCheckOutEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:eBayMotorsProPaymentMethodCheckOutEnabledDefinitionType'

=cut

sub getEBayMotorsProPaymentMethodCheckOutEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'eBayMotorsProPaymentMethodCheckOutEnabled'
		,'eBay::API::XML::DataType::eBayMotorsProPaymentMethodCheckOutEnabledDefinitionType');
}


=head2 setEBayMotorsProPhoneCount()

Indicates which telephone option is enabled for the seller's contact information for Classified Ad listings. Added for eBay Motors Pro users.

#    Argument: 'ns:eBayMotorsProPhoneCountDefinitionType'

=cut

sub setEBayMotorsProPhoneCount {
  my $self = shift;
  $self->{'eBayMotorsProPhoneCount'} = shift
}

=head2 getEBayMotorsProPhoneCount()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:eBayMotorsProPhoneCountDefinitionType'

=cut

sub getEBayMotorsProPhoneCount {
  my $self = shift;
  return $self->_getDataTypeInstance( 'eBayMotorsProPhoneCount'
		,'eBay::API::XML::DataType::eBayMotorsProPhoneCountDefinitionType');
}


=head2 setEBayMotorsProSellerContactDetailsEnabled()

Defines the SellerContactDetails feature. If the field is present, the
corresponding feature applies to the category. The field is returned as an
empty element (e.g., a boolean value is not returned).
Applies to Classified Ad listings. Added for eBay Motors Pro users.

#    Argument: 'ns:eBayMotorsProSellerContactDetailsEnabledDefinitionType'

=cut

sub setEBayMotorsProSellerContactDetailsEnabled {
  my $self = shift;
  $self->{'eBayMotorsProSellerContactDetailsEnabled'} = shift
}

=head2 getEBayMotorsProSellerContactDetailsEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll

#    Returns: 'ns:eBayMotorsProSellerContactDetailsEnabledDefinitionType'

=cut

sub getEBayMotorsProSellerContactDetailsEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'eBayMotorsProSellerContactDetailsEnabled'
		,'eBay::API::XML::DataType::eBayMotorsProSellerContactDetailsEnabledDefinitionType');
}


=head2 setEBayMotorsProShippingMethodEnabled()

Indicates if shipping options are available for Classified Ad format listings
in this category. Added for eBay Motors Pro users.

#    Argument: 'ns:eBayMotorsProShippingMethodEnabledDefinitionType'

=cut

sub setEBayMotorsProShippingMethodEnabled {
  my $self = shift;
  $self->{'eBayMotorsProShippingMethodEnabled'} = shift
}

=head2 getEBayMotorsProShippingMethodEnabled()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:eBayMotorsProShippingMethodEnabledDefinitionType'

=cut

sub getEBayMotorsProShippingMethodEnabled {
  my $self = shift;
  return $self->_getDataTypeInstance( 'eBayMotorsProShippingMethodEnabled'
		,'eBay::API::XML::DataType::eBayMotorsProShippingMethodEnabledDefinitionType');
}


=head2 setEBayMotorsProStreetCount()

Indicates which address option this category supports for Classified Ad listings. Added for eBay Motors Pro users.

#    Argument: 'ns:eBayMotorsProStreetCountDefinitionType'

=cut

sub setEBayMotorsProStreetCount {
  my $self = shift;
  $self->{'eBayMotorsProStreetCount'} = shift
}

=head2 getEBayMotorsProStreetCount()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:eBayMotorsProStreetCountDefinitionType'

=cut

sub getEBayMotorsProStreetCount {
  my $self = shift;
  return $self->_getDataTypeInstance( 'eBayMotorsProStreetCount'
		,'eBay::API::XML::DataType::eBayMotorsProStreetCountDefinitionType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
