#
#   thwait.rb - 
#   	$Release Version: $
#   	$Revision: 1.1 $
#   	$Date: 1997/08/18 03:13:14 $
#   	by Keiju ISHITSUKA(Nippon Rational Inc.)
#
# --
#
#   
#

require "thread.rb"
require "e2mmap.rb"

class ThreadsWait
  RCS_ID='-$Header: /home/keiju/var/src/var.lib/ruby/RCS/thwait.rb,v 1.1 1997/08/18 03:13:14 keiju Exp keiju $-'
  
  Exception2MessageMapper.extend_to(binding)
  def_exception("ErrWaitThreadsNothing", "Wait threads nothing.")
  def_exception("FinshedThreadsNothing", "finished thread nothing.")
  
  # class mthods
  #	all_waits
  
  #
  # ꤷåɤƽλޤԤ. ƥ졼ȤƸƤФ
  # ꤷåɤλȥƥ졼ƤӽФ.
  #
  def ThreadsWait.all_waits(*threads)
    tw = ThreadsWait.new(th1, th2, th3, th4, th5)
    if iterator?
      tw.all_waits do
	|th|
	yield th
      end
    else
      tw.all_waits
    end
  end
  
  # initialize and terminating:
  #	initialize
  
  #
  # . Ԥĥåɤλ꤬Ǥ.
  #
  def initialize(*threads)
    @threads = []
    @wait_queue = Queue.new
    join_nowait(*threads) unless threads.empty?
  end
  
  # accessing
  #	threads
  
  # Ԥåɤΰ֤.
  attr :threads
  
  # testing
  #	empty?
  #	finished?
  #
  
  #
  # Ԥåɤ¸ߤ뤫ɤ֤.
  def empty?
    @threads.empty?
  end
  
  #
  # Ǥ˽λåɤ뤫ɤ֤
  def finished?
    !@wait_queue.empty?
  end
  
  # main process:
  #	join
  #	join_nowait
  #	next_wait
  #	all_wait
  
  #
  # ԤäƤ륹åɤɲäԤˤϤ.
  #
  def join(*threads)
    join_nowait(*threads)
    next_wait
  end
  
  #
  # ԤäƤ륹åɤɲä. Ԥˤʤ.
  #
  def join_nowait(*threads)
    @threads.concat threads
    for th in threads
      Thread.start do
	th = Thread.join(th)
	@wait_queue.push th
      end
    end
  end
  
  #
  # ԤˤϤ.
  # ԤĤ٤åɤʤ, 㳰ErrWaitThreadsNothing ֤.
  # nonnlockλˤ, nonblockingĴ٤. ¸ߤʤ, 㳰
  # FinishedThreadNothing֤.
  #
  def next_wait(nonblock = nil)
    Threads.Wait.fail ErrWaitThreadsNothing if @threads.empty?
    
    th = @wait_queue.pop(nonblock)
    @threads.delete th
    th
  end
  
  #
  # ƤΥåɤλޤԤ. ƥ졼ȤƸƤФ줿, 
  # åɤλ٤, ƥ졼ƤӽФ.
  #
  def all_waits
    until @threads.empty?
      th = next_wait
      yield th if iterator?
    end
  end
end
