#
#   thwait.rb - åƱ饹
#   	$Release Version: 0.9 $
#   	$Revision: 1.3 $
#   	$Date: 1998/06/26 03:19:34 $
#   	by Keiju ISHITSUKA(Nihpon Rational Software Co.,Ltd.)
#
# --
#  ǽ:
#  ʣΥåɤؤΥåɤλޤwait뵡ǽ
#  . 
#
#  饹᥽å:
#  * ThreadsWait.all_waits(thread1,...)
#    ƤΥåɤλޤԤ. ƥ졼ȤƸƤФ줿ˤ, 
#    åɤλ٤˥ƥ졼¹Ԥ.
#  * th = ThreadsWait.new(thread1,...)
#    Ʊ륹åɤꤷƱ֥Ȥ.
#  
#  ᥽å:
#  * th.threads
#    Ʊ٤åɤΰ
#  * th.empty?
#    Ʊ٤åɤ뤫ɤ
#  * th.finished?
#    Ǥ˽λåɤ뤫ɤ
#  * th.join(thread1,...) 
#    Ʊ륹åɤꤷ, 줫ΥåɤλޤԤˤϤ.
#  * th.join_nowait(threa1,...)
#    Ʊ륹åɤꤹ. Ԥˤʤ.
#  * th.next_wait
#    줫ΥåɤλޤԤˤϤ.
#  * th.all_waits
#    ƤΥåɤλޤԤ. ƥ졼ȤƸƤФ줿ˤ, 
#    åɤλ٤˥ƥ졼¹Ԥ.
#

require "thread.rb"
require "e2mmap.rb"

class ThreadsWait
  RCS_ID='-$Id: thwait.rb,v 1.3 1998/06/26 03:19:34 keiju Exp keiju $-'
  
  Exception2MessageMapper.extend_to(binding)
  def_exception("ErrNoWaitingThread", "No threads for waiting.")
  def_exception("ErrNoFinshedThread", "No finished threads.")
  
  # class mthods
  #	all_waits
  
  #
  # ꤷåɤƽλޤԤ. ƥ졼ȤƸƤФ
  # ꤷåɤλȤνλåɤȤƥƥ졼
  # ƤӽФ. 
  #
  def ThreadsWait.all_waits(*threads)
    tw = ThreadsWait.new(*threads)
    if iterator?
      tw.all_waits do
	|th|
	yield th
      end
    else
      tw.all_waits
    end
  end
  
  # initialize and terminating:
  #	initialize
  
  #
  # . Ԥĥåɤλ꤬Ǥ.
  #
  def initialize(*threads)
    @threads = []
    @wait_queue = Queue.new
    join_nowait(*threads) unless threads.empty?
  end
  
  # accessing
  #	threads
  
  # Ԥåɤΰ֤.
  attr :threads
  
  # testing
  #	empty?
  #	finished?
  #
  
  #
  # Ԥåɤ¸ߤ뤫ɤ֤.
  def empty?
    @threads.empty?
  end
  
  #
  # Ǥ˽λåɤ뤫ɤ֤
  def finished?
    !@wait_queue.empty?
  end
  
  # main process:
  #	join
  #	join_nowait
  #	next_wait
  #	all_wait
  
  #
  # ԤäƤ륹åɤɲä. 줫Υåɤ1Ľλޤ
  # ˤϤ.
  #
  def join(*threads)
    join_nowait(*threads)
    next_wait
  end
  
  #
  # ԤäƤ륹åɤɲä. Ԥˤʤ.
  #
  def join_nowait(*threads)
    @threads.concat threads
    for th in threads
      Thread.start do
	th = Thread.join(th)
	@wait_queue.push th
      end
    end
  end
  
  #
  # 줫ΥåɤλޤԤˤϤ.
  # ԤĤ٤åɤʤ, 㳰ErrNoWaitingThread֤.
  # nonnlockλˤ, nonblockingĴ٤. ¸ߤʤ, 㳰
  # ErrNoFinishedThread֤.
  #
  def next_wait(nonblock = nil)
    ThreadsWait.fail ErrNoWaitingThread if @threads.empty?
    begin
      @threads.delete(th = @wait_queue.pop(nonblock))
      th
    rescue ThreadError
      ThreadsWait.fail ErrNoFinshedThread
    end
  end
  
  #
  # ƤΥåɤλޤԤ. ƥ졼ȤƸƤФ줿, 
  # åɤλ٤, ƥ졼ƤӽФ.
  #
  def all_waits
    until @threads.empty?
      th = next_wait
      yield th if iterator?
    end
  end
end

ThWait = ThreadsWait
