# -*- coding: euc-jp -*-
#
# text widget peering demo (called by 'widget')
#
# based on Tcl/Tk8.5.0 widget demos

if defined?($textpeer_demo) && $textpeer_demo
  $textpeer_demo.destroy 
  $textpeer_demo = nil
end

# demo toplevel widget
$textpeer_demo = TkToplevel.new {|w|
  title("Text Wdget Peering Demonstration")
  iconname("textpeer")
  positionWindow(w)
}

count = [0]

## Define a widget that we peer from; it won't ever actually be shown though
first = TkText.new($textpeer_demo, :widgetname=>"text#{count[0] += 1}")
first.insert :end,"ΥǥϰĤȤƥȥåȤ򼨤ޤ"
first.insert :end,"ΥƥȥåȤ(ԥ;peer)δط"
first.insert :end,"ʤäƤޤ"
first.insert :end,"ϡפȤʤǡǥ϶̤ΤΤޤ"
first.insert :end,"ɽ֡Խ֡ϰ(selection)ˤĤƤ"
first.insert :end,"Ω˻ĤȤǤޤ"
first.insert :end,"ƥƥȥåȤƤˤ"
first.insert :end,"֥ԥ(peer)κץܥȤС"
first.insert :end,"ʥԥɲä뤳ȤǽǤ"
first.insert :end,"ޤ֥ԥ(peer)ξõץܥȤС"
first.insert :end,"ΥԥåȤõ뤳ȤǤޤ"

## Procedures to make and kill clones; most of this is just so that the demo
## looks nice...
def makeClone(count, win, txt)
  cnt = (count[0] += 1)
  peer = TkText::Peer.new(txt, win, :widgetname=>"text#{cnt}")
  sbar = TkScrollbar.new(win, :widgetname=>"sb#{cnt}")
  peer.yscrollbar sbar
  b1 = TkButton.new(win, :widgetname=>"clone#{cnt}", 
                    :text=>'ԥ(peer)κ', 
                    :command=>proc{makeClone(count, win, peer)})
  b2 = TkButton.new(win, :widgetname=>"kill#{cnt}", 
                    :text=>'ԥ(peer)ξõ', 
                    :command=>proc{killClone(win, cnt)})
  row = cnt * 2
  TkGrid.configure(peer, sbar, b1, :sticky=>'nsew', :row=>row)
  TkGrid.configure('^',  '^',  b2, :sticky=>'nsew', :row=>(row+=1))
  TkGrid.configure(b1,  b2, :sticky=>'new')
  TkGrid.rowconfigure(win,  b2, :weight=>1)
end

def killClone(win, cnt)
  Tk.destroy("#{win.path}.text#{cnt}",  "#{win.path}.sb#{cnt}", 
             "#{win.path}.clone#{cnt}", "#{win.path}.kill#{cnt}")
end

## Now set up the GUI
makeClone(count, $textpeer_demo, first)
makeClone(count, $textpeer_demo, first)
first.destroy

## See Code / Dismiss buttons
TkFrame.new($textpeer_demo){|f|
  TkButton.new(f, :text=>'Ĥ', :width=>15, :command=>proc{
                 $textpeer_demo.destroy
                 $textpeer_demo = nil
               }).pack(:side=>:left, :expand=>true)

  TkButton.new(f, :text=>'ɻ', :width=>15, :command=>proc{
                 showCode 'textpeer'
               }).pack(:side=>:left, :expand=>true)

  TkGrid.configure(f, '-', '-', :sticky=>'ew', :row=>5000)
}
TkGrid.columnconfigure($textpeer_demo, 0, :weight=>1)
