$DEBUG_RDOC = nil

##
# RDoc - Ruby Documentation System
#
# This package contains RDoc and RDoc::Markup.  RDoc is an application that
# produces documentation for one or more Ruby source files.  We work similarly
# to JavaDoc, parsing the source, and extracting the definition for classes,
# modules, and methods (along with includes and requires).  We associate with
# these optional documentation contained in the immediately preceding comment
# block, and then render the result using a pluggable output formatter.
# RDoc::Markup is a library that converts plain text into various output
# formats.  The markup library is used to interpret the comment blocks that
# RDoc uses to document methods, classes, and so on.
#
# == Roadmap
#
# * If you want to use RDoc to create documentation for your Ruby source files,
#   read on.
# * If you want to include extensions written in C, see RDoc::Parser::C
# * For information on the various markups available in comment blocks, see
#   RDoc::Markup.
# * If you want to drive RDoc programmatically, see RDoc::RDoc.
# * If you want to use the library to format text blocks into HTML, have a look
#   at RDoc::Markup.
# * If you want to try writing your own HTML output template, see
#   RDoc::Generator::HTML
#
# == Summary
#
# Once installed, you can create documentation using the 'rdoc' command
# (the command is 'rdoc.bat' under Windows)
#
#   % rdoc [options] [names...]
#
# Type "rdoc --help" for an up-to-date option summary.
#
# A typical use might be to generate documentation for a package of Ruby
# source (such as rdoc itself).
#
#   % rdoc
#
# This command generates documentation for all the Ruby and C source
# files in and below the current directory.  These will be stored in a
# documentation tree starting in the subdirectory 'doc'.
#
# You can make this slightly more useful for your readers by having the
# index page contain the documentation for the primary file.  In our
# case, we could type
#
#   % rdoc --main rdoc.rb
#
# You'll find information on the various formatting tricks you can use
# in comment blocks in the documentation this generates.
#
# RDoc uses file extensions to determine how to process each file.  File names
# ending +.rb+ and <tt>.rbw</tt> are assumed to be Ruby source.  Files
# ending +.c+ are parsed as C files.  All other files are assumed to
# contain just Markup-style markup (with or without leading '#' comment
# markers).  If directory names are passed to RDoc, they are scanned
# recursively for C and Ruby source files only.
#
# = Markup
#
# For information on how to make lists, hyperlinks, etc. with RDoc, see
# RDoc::Markup.
#
# Comment blocks can be written fairly naturally, either using '#' on
# successive lines of the comment, or by including the comment in
# an =begin/=end block.  If you use the latter form, the =begin line must be
# flagged with an RDoc tag:
#
#   =begin rdoc
#   Documentation to be processed by RDoc.
#   
#   ...
#   =end
#
# RDoc stops processing comments if it finds a comment line containing
# a <tt>--</tt>.  This can be used to separate external from internal
# comments, or to stop a comment being associated with a method, class, or
# module.  Commenting can be turned back on with a line that starts with a
# <tt>++</tt>.
#
#   ##
#   # Extract the age and calculate the date-of-birth.
#   #--
#   # FIXME: fails if the birthday falls on February 29th
#   #++
#   # The DOB is returned as a Time object.
#   
#   def get_dob(person)
#     # ...
#   end
#
# Names of classes, source files, and any method names containing an
# underscore or preceded by a hash character are automatically hyperlinked
# from comment text to their description.
#
# Method parameter lists are extracted and displayed with the method
# description.  If a method calls +yield+, then the parameters passed to yield
# will also be displayed:
#
#   def fred
#     ...
#     yield line, address
#
# This will get documented as:
#
#   fred() { |line, address| ... }
#
# You can override this using a comment containing ':yields: ...' immediately
# after the method definition
#
#   def fred # :yields: index, position
#     # ...
#   
#     yield line, address
#
# which will get documented as
#
#    fred() { |index, position| ... }
#
# +:yields:+ is an example of a documentation directive.  These appear
# immediately after the start of the document element they are modifying.
#
# == Directives
#
# [+:nodoc:+ / +:nodoc:+ all]
#   Don't include this element in the documentation.  For classes
#   and modules, the methods, aliases, constants, and attributes
#   directly within the affected class or module will also be
#   omitted.  By default, though, modules and classes within that
#   class of module _will_ be documented.  This is turned off by
#   adding the +all+ modifier.
#   
#     module MyModule # :nodoc:
#       class Input
#       end
#     end
#     
#     module OtherModule # :nodoc: all
#       class Output
#       end
#     end
#
#   In the above code, only class +MyModule::Input+ will be documented.The
#   The :nodoc: directive is global across all files the class or module
#   appears in, so use :stopdoc:/:startdoc: to only omit documentation for a
#   particular set of methods, etc.
#
# [+:doc:+]
#   Force a method or attribute to be documented even if it wouldn't otherwise
#   be.  Useful if, for example, you want to include documentation of a
#   particular private method.
#
# [+:notnew:+]
#   Only applicable to the +initialize+ instance method.  Normally RDoc
#   assumes that the documentation and parameters for #initialize are
#   actually for the ::new method, and so fakes out a ::new for the class.
#   The :notnew: modifier stops this.  Remember that #initialize is protected,
#   so you won't see the documentation unless you use the -a command line
#   option.
#
# Comment blocks can contain other directives:
#
# [<tt>:section: title</tt>]
#   Starts a new section in the output.  The title following +:section:+ is
#   used as the section heading, and the remainder of the comment containing
#   the section is used as introductory text.  Subsequent methods, aliases,
#   attributes, and classes will be documented in this section.  A :section:
#   comment block may have one or more lines before the :section: directive.
#   These will be removed, and any identical lines at the end of the block are
#   also removed.  This allows you to add visual cues such as:
#     
#     # ----------------------------------------
#     # :section: My Section
#     # This is the section that I wrote.
#     # See it glisten in the noon-day sun.
#     # ----------------------------------------
#
# [+:call-seq:+]
#   Lines up to the next blank line in the comment are treated as the method's
#   calling sequence, overriding the default parsing of method parameters and
#   yield arguments.
#
# [+:include:+ _filename_]
#   \Include the contents of the named file at this point.  The file will be
#   searched for in the directories listed by the +--include+ option, or in
#   the current directory by default.  The contents of the file will be
#   shifted to have the same indentation as the ':' at the start of
#   the :include: directive.
#
# [+:title:+ _text_]
#   Sets the title for the document.  Equivalent to the <tt>--title</tt>
#   command line parameter.  (The command line parameter overrides any :title:
#   directive in the source).
#
# [+:enddoc:+]
#   Document nothing further at the current level.
#
# [+:main:+ _name_]
#   Equivalent to the <tt>--main</tt> command line parameter.
#
# [+:stopdoc:+ / +:startdoc:+]
#   Stop and start adding new documentation elements to the current container.
#   For example, if a class has a number of constants that you don't want to
#   document, put a +:stopdoc:+ before the first, and a +:startdoc:+ after the
#   last.  If you don't specify a +:startdoc:+ by the end of the container,
#   disables documentation for the entire class or module.
#
# = Other stuff
#
# RDoc is currently being maintained by Eric Hodel <drbrain@segment7.net>
#
# Dave Thomas <dave@pragmaticprogrammer.com> is the original author of RDoc.
#
# == Credits
#
# * The Ruby parser in rdoc/parse.rb is based heavily on the outstanding
#   work of Keiju ISHITSUKA of Nippon Rational Inc, who produced the Ruby
#   parser for irb and the rtags package.
#
# * Code to diagram classes and modules was written by Sergey A Yanovitsky
#   (Jah) of Enticla.
#
# * Charset patch from MoonWolf.
#
# * Rich Kilmer wrote the kilmer.rb output template.
#
# * Dan Brickley led the design of the RDF format.
#
# == License
#
# RDoc is Copyright (c) 2001-2003 Dave Thomas, The Pragmatic Programmers.  It
# is free software, and may be redistributed under the terms specified
# in the README file of the Ruby distribution.
#
# == Warranty
#
# This software is provided "as is" and without any express or implied
# warranties, including, without limitation, the implied warranties of
# merchantibility and fitness for a particular purpose.

module RDoc

  ##
  # Exception thrown by any rdoc error.

  class Error < RuntimeError; end

  RDocError = Error # :nodoc:

  ##
  # RDoc version you are using

  VERSION = "2.1.0"

  ##
  # Name of the dotfile that contains the description of files to be processed
  # in the current directory

  DOT_DOC_FILENAME = ".document"

  GENERAL_MODIFIERS = %w[nodoc].freeze

  CLASS_MODIFIERS = GENERAL_MODIFIERS

  ATTR_MODIFIERS  = GENERAL_MODIFIERS

  CONSTANT_MODIFIERS = GENERAL_MODIFIERS

  METHOD_MODIFIERS = GENERAL_MODIFIERS +
    %w[arg args yield yields notnew not-new not_new doc]

end

