/* autogenerated. */
/* src="transcode-tblgen.rb", len=15275, checksum=6321 */
/* src="iso2022.trans", len=3873, checksum=8158 */

#include "transcode_data.h"



static const unsigned char
iso2022jp_to_eucjp_1B_24_offsets[5] = { 64, 66,
      1,  0,  1,
};
static const struct byte_lookup* const
iso2022jp_to_eucjp_1B_24_infos[2] = {
     INVALID,   FUNso,
};
static const BYTE_LOOKUP
iso2022jp_to_eucjp_1B_24 = {
    iso2022jp_to_eucjp_1B_24_offsets,
    iso2022jp_to_eucjp_1B_24_infos
};

static const unsigned char
iso2022jp_to_eucjp_1B_28_offsets[11] = { 66, 74,
      1,  0,  0,  0,  0,  0,  0,  0,    1,
};
static const BYTE_LOOKUP
iso2022jp_to_eucjp_1B_28 = {
    iso2022jp_to_eucjp_1B_28_offsets,
    iso2022jp_to_eucjp_1B_24_infos
};

static const unsigned char
iso2022jp_to_eucjp_1B_offsets[7] = { 36, 40,
      1,  0,  0,  0,  2,
};
static const struct byte_lookup* const
iso2022jp_to_eucjp_1B_infos[3] = {
                       INVALID, &iso2022jp_to_eucjp_1B_24,
     &iso2022jp_to_eucjp_1B_28,
};
static const BYTE_LOOKUP
iso2022jp_to_eucjp_1B = {
    iso2022jp_to_eucjp_1B_offsets,
    iso2022jp_to_eucjp_1B_infos
};

static const unsigned char
iso2022jp_to_eucjp_offsets[130] = { 0, 127,
      0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  1,  1,
      0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  2,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
};
static const struct byte_lookup* const
iso2022jp_to_eucjp_infos[3] = {
                      FUNsi,                INVALID,
     &iso2022jp_to_eucjp_1B,
};
static const BYTE_LOOKUP
iso2022jp_to_eucjp = {
    iso2022jp_to_eucjp_offsets,
    iso2022jp_to_eucjp_infos
};


static const unsigned char
iso2022jp_to_eucjp_jisx0208_rest_offsets[96] = { 33, 126,
      1,  1,  1,  1,  1,  1,  1,  1,    1,  1,  1,  1,  1,  1,  1,  1,
      1,  1,  1,  1,  1,  1,  1,  1,    1,  1,  1,  1,  1,  1,  1,  1,
      1,  1,  1,  1,  1,  1,  1,  1,    1,  1,  1,  1,  1,  1,  1,  1,
      1,  1,  1,  1,  1,  1,  1,  1,    1,  1,  1,  1,  1,  1,  1,  1,
      1,  1,  1,  1,  1,  1,  1,  1,    1,  1,  1,  1,  1,  1,  1,  1,
      1,  1,  1,  1,  1,  1,  1,  1,    1,  1,  1,  1,  1,  1,
};
static const BYTE_LOOKUP
iso2022jp_to_eucjp_jisx0208_rest = {
    iso2022jp_to_eucjp_jisx0208_rest_offsets,
    iso2022jp_to_eucjp_1B_24_infos
};



static VALUE
fun_si_iso2022jp_to_eucjp(rb_transcoding* t, const unsigned char* s, size_t l)
{
    if (t->stateful[0] == 0)
        return (VALUE)NOMAP;
    else if (0x21 <= s[0] && s[0] <= 0x7e)
        return (VALUE)&iso2022jp_to_eucjp_jisx0208_rest;
    else
        return (VALUE)INVALID;
}

static int
fun_so_iso2022jp_to_eucjp(rb_transcoding* t, const unsigned char* s, size_t l, unsigned char* o)
{
    if (s[0] == 0x1b) {
        if (s[1] == '(') {
            switch (s[l-1]) {
              case 'B':
              case 'J':
                t->stateful[0] = 0;
                break;
            }
        }
        else {
            switch (s[l-1]) {
              case '@':
              case 'B':
                t->stateful[0] = 1;
                break;
            }
        }
        return 0;
    }
    else {
        o[0] = s[0] | 0x80;
        o[1] = s[1] | 0x80;
        return 2;
    }
}

static const rb_transcoder
rb_ISO_2022_JP_to_EUC_JP = {
    "ISO-2022-JP", "EUC-JP", &iso2022jp_to_eucjp,
    1, /* input_unit_length */
    3, /* max_input */
    3, /* max_output */
    stateful_decoder, /* stateful_type */
    NULL, fun_si_iso2022jp_to_eucjp, NULL, fun_so_iso2022jp_to_eucjp
};



static const unsigned char
eucjp_to_iso2022jp_8E_offsets[96] = { 161, 254,
      1,  1,  1,  1,  1,  1,  1,  1,    1,  1,  1,  1,  1,  1,  1,  1,
      1,  1,  1,  1,  1,  1,  1,  1,    1,  1,  1,  1,  1,  1,  1,  1,
      1,  1,  1,  1,  1,  1,  1,  1,    1,  1,  1,  1,  1,  1,  1,  1,
      1,  1,  1,  1,  1,  1,  1,  1,    1,  1,  1,  1,  1,  1,  1,  1,
      1,  1,  1,  1,  1,  1,  1,  1,    1,  1,  1,  1,  1,  1,  1,  1,
      1,  1,  1,  1,  1,  1,  1,  1,    1,  1,  1,  1,  1,  1,
};
static const struct byte_lookup* const
eucjp_to_iso2022jp_8E_infos[2] = {
     INVALID,   UNDEF,
};
static const BYTE_LOOKUP
eucjp_to_iso2022jp_8E = {
    eucjp_to_iso2022jp_8E_offsets,
    eucjp_to_iso2022jp_8E_infos
};

static const struct byte_lookup* const
eucjp_to_iso2022jp_8F_infos[2] = {
                    INVALID, &eucjp_to_iso2022jp_8E,
};
static const BYTE_LOOKUP
eucjp_to_iso2022jp_8F = {
    eucjp_to_iso2022jp_8E_offsets,
    eucjp_to_iso2022jp_8F_infos
};

static const BYTE_LOOKUP
eucjp_to_iso2022jp_A1 = {
    eucjp_to_iso2022jp_8E_offsets,
    iso2022jp_to_eucjp_1B_24_infos
};

static const unsigned char
eucjp_to_iso2022jp_offsets[257] = { 0, 254,
      0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  1,  1,
      0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  1,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,    0,  0,  0,  0,  0,  0,  0,  0,
      2,  2,  2,  2,  2,  2,  2,  2,    2,  2,  2,  2,  2,  2,  3,  4,
      2,  2,  2,  2,  2,  2,  2,  2,    2,  2,  2,  2,  2,  2,  2,  2,
      2,  5,  5,  5,  5,  5,  5,  5,    5,  5,  5,  5,  5,  5,  5,  5,
      5,  5,  5,  5,  5,  5,  5,  5,    5,  5,  5,  5,  5,  5,  5,  5,
      5,  5,  5,  5,  5,  5,  5,  5,    5,  5,  5,  5,  5,  5,  5,  5,
      5,  5,  5,  5,  5,  5,  5,  5,    5,  5,  5,  5,  5,  5,  5,  5,
      5,  5,  5,  5,  5,  5,  5,  5,    5,  5,  5,  5,  5,  5,  5,  5,
      5,  5,  5,  5,  5,  5,  5,  5,    5,  5,  5,  5,  5,  5,  5,
};
static const struct byte_lookup* const
eucjp_to_iso2022jp_infos[6] = {
                      FUNso,                  UNDEF,
                    INVALID, &eucjp_to_iso2022jp_8E,
     &eucjp_to_iso2022jp_8F, &eucjp_to_iso2022jp_A1,
};
static const BYTE_LOOKUP
eucjp_to_iso2022jp = {
    eucjp_to_iso2022jp_offsets,
    eucjp_to_iso2022jp_infos
};



static int
fun_so_eucjp_to_iso2022jp(rb_transcoding *t, const unsigned char *s, size_t l, unsigned char *o)
{
    unsigned char *output0 = o;

    if (t->stateful[0] == 0) {
        t->stateful[0] = 1; /* initialized flag */
        t->stateful[1] = 1; /* G0 = ASCII */
    }

    if (l != t->stateful[1]) {
        if (l == 1) {
            *o++ = 0x1b;
            *o++ = '(';
            *o++ = 'B';
            t->stateful[1] = 1; /* G0 = ASCII */
        }
        else {
            *o++ = 0x1b;
            *o++ = '$';
            *o++ = 'B';
            t->stateful[1] = 2; /* G0 = JIS X 0208 1983 */
        }
    }

    if (l == 1) {
        *o++ = s[0] & 0x7f;
    }
    else {
        *o++ = s[0] & 0x7f;
        *o++ = s[1] & 0x7f;
    }

    return o - output0;
}

static int
iso2022jp_reset_sequence_size(rb_transcoding *t)
{
    if (t->stateful[1] == 2)
        return 3;
    return 0;
}

static int
finish_eucjp_to_iso2022jp(rb_transcoding *t, unsigned char *o)
{
    unsigned char *output0 = o;

    if (t->stateful[0] == 0)
        return 0;

    if (t->stateful[1] != 1) {
        *o++ = 0x1b;
        *o++ = '(';
        *o++ = 'B';
        t->stateful[1] = 1;
    }

    return o - output0;
}

static const rb_transcoder
rb_EUC_JP_to_ISO_2022_JP = {
    "EUC-JP", "ISO-2022-JP", &eucjp_to_iso2022jp,
    1, /* input_unit_length */
    3, /* max_input */
    5, /* max_output */
    stateful_encoder, /* stateful_type */
    NULL, NULL, NULL, fun_so_eucjp_to_iso2022jp,
    finish_eucjp_to_iso2022jp,
    iso2022jp_reset_sequence_size, finish_eucjp_to_iso2022jp
};

void
Init_iso2022(void)
{
    rb_register_transcoder(&rb_ISO_2022_JP_to_EUC_JP);
    rb_register_transcoder(&rb_EUC_JP_to_ISO_2022_JP);
}


