/* -*-c-*-
 THIS FILE WAS AUTOGENERATED BY template/prelude.c.tmpl. DO NOT EDIT.

 sources: ./prelude, ./gem_prelude
*/
#include "ruby/ruby.h"
#include "internal.h"
#include "vm_core.h"
#include "iseq.h"


static const char prelude_name0[] = "<internal:prelude>";
static const struct {
    char L0[491]; /* 1..130 */
    char L130[215]; /* 131..155 */
} prelude_code0 = {
#line 1 "prelude.rb"
"class << Thread\n"
"\n"/* call-seq: */
"\n"/*    Thread.exclusive { block }   => obj */
"\n"/*  */
"\n"/* Wraps the block in a single, VM-global Mutex.synchronize, returning the */
"\n"/* value of the block. A thread executing inside the exclusive section will */
"\n"/* only block other threads which also use the Thread.exclusive mechanism. */
"  def exclusive(&block) end if false\n"
"  mutex = Mutex.new\n"/* :nodoc: */
"  define_method(:exclusive) do |&block|\n"
"    warn \"Thread.exclusive is deprecated, use Thread::Mutex\", caller\n"
"    mutex.synchronize(&block)\n"
"  end\n"
"end\n"
"\n"
"class IO\n"
"\n"
"\n"/* call-seq: */
"\n"/*    ios.read_nonblock(maxlen [, options])              -> string */
"\n"/*    ios.read_nonblock(maxlen, outbuf [, options])      -> outbuf */
"\n"/*  */
"\n"/* Reads at most <i>maxlen</i> bytes from <em>ios</em> using */
"\n"/* the read(2) system call after O_NONBLOCK is set for */
"\n"/* the underlying file descriptor. */
"\n"/*  */
"\n"/* If the optional <i>outbuf</i> argument is present, */
"\n"/* it must reference a String, which will receive the data. */
"\n"/* The <i>outbuf</i> will contain only the received data after the method call */
"\n"/* even if it is not empty at the beginning. */
"\n"/*  */
"\n"/* read_nonblock just calls the read(2) system call. */
"\n"/* It causes all errors the read(2) system call causes: Errno::EWOULDBLOCK, Errno::EINTR, etc. */
"\n"/* The caller should care such errors. */
"\n"/*  */
"\n"/* If the exception is Errno::EWOULDBLOCK or Errno::EAGAIN, */
"\n"/* it is extended by IO::WaitReadable. */
"\n"/* So IO::WaitReadable can be used to rescue the exceptions for retrying */
"\n"/* read_nonblock. */
"\n"/*  */
"\n"/* read_nonblock causes EOFError on EOF. */
"\n"/*  */
"\n"/* If the read byte buffer is not empty, */
"\n"/* read_nonblock reads from the buffer like readpartial. */
"\n"/* In this case, the read(2) system call is not called. */
"\n"/*  */
"\n"/* When read_nonblock raises an exception kind of IO::WaitReadable, */
"\n"/* read_nonblock should not be called */
"\n"/* until io is readable for avoiding busy loop. */
"\n"/* This can be done as follows. */
"\n"/*  */
"\n"/*   # emulates blocking read (readpartial). */
"\n"/*   begin */
"\n"/*     result = io.read_nonblock(maxlen) */
"\n"/*   rescue IO::WaitReadable */
"\n"/*     IO.select([io]) */
"\n"/*     retry */
"\n"/*   end */
"\n"/*  */
"\n"/* Although IO#read_nonblock doesn't raise IO::WaitWritable. */
"\n"/* OpenSSL::Buffering#read_nonblock can raise IO::WaitWritable. */
"\n"/* If IO and SSL should be used polymorphically, */
"\n"/* IO::WaitWritable should be rescued too. */
"\n"/* See the document of OpenSSL::Buffering#read_nonblock for sample code. */
"\n"/*  */
"\n"/* Note that this method is identical to readpartial */
"\n"/* except the non-blocking flag is set. */
"\n"/*  */
"\n"/* By specifying a keyword argument _exception_ to +false+, you can indicate */
"\n"/* that read_nonblock should not raise an IO::WaitReadable exception, but */
"\n"/* return the symbol +:wait_readable+ instead. At EOF, it will return nil */
"\n"/* instead of raising EOFError. */
"  def read_nonblock(len, buf = nil, exception: true)\n"
"    __read_nonblock(len, buf, exception)\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    ios.write_nonblock(string)   -> integer */
"\n"/*    ios.write_nonblock(string [, options])   -> integer */
"\n"/*  */
"\n"/* Writes the given string to <em>ios</em> using */
"\n"/* the write(2) system call after O_NONBLOCK is set for */
"\n"/* the underlying file descriptor. */
"\n"/*  */
"\n"/* It returns the number of bytes written. */
"\n"/*  */
"\n"/* write_nonblock just calls the write(2) system call. */
"\n"/* It causes all errors the write(2) system call causes: Errno::EWOULDBLOCK, Errno::EINTR, etc. */
"\n"/* The result may also be smaller than string.length (partial write). */
"\n"/* The caller should care such errors and partial write. */
"\n"/*  */
"\n"/* If the exception is Errno::EWOULDBLOCK or Errno::EAGAIN, */
"\n"/* it is extended by IO::WaitWritable. */
"\n"/* So IO::WaitWritable can be used to rescue the exceptions for retrying write_nonblock. */
"\n"/*  */
"\n"/*   # Creates a pipe. */
"\n"/*   r, w = IO.pipe */
"\n"/*  */
"\n"/*   # write_nonblock writes only 65536 bytes and return 65536. */
"\n"/*   # (The pipe size is 65536 bytes on this environment.) */
"\n"/*   s = \"a\" * 100000 */
"\n"/*   p w.write_nonblock(s)     #=> 65536 */
"\n"/*  */
"\n"/*   # write_nonblock cannot write a byte and raise EWOULDBLOCK (EAGAIN). */
"\n"/*   p w.write_nonblock(\"b\")   # Resource temporarily unavailable (Errno::EAGAIN) */
"\n"/*  */
"\n"/* If the write buffer is not empty, it is flushed at first. */
"\n"/*  */
"\n"/* When write_nonblock raises an exception kind of IO::WaitWritable, */
"\n"/* write_nonblock should not be called */
"\n"/* until io is writable for avoiding busy loop. */
"\n"/* This can be done as follows. */
"\n"/*  */
"\n"/*   begin */
"\n"/*     result = io.write_nonblock(string) */
"\n"/*   rescue IO::WaitWritable, Errno::EINTR */
"\n"/*     IO.select(nil, [io]) */
"\n"/*     retry */
"\n"/*   end */
"\n"/*  */
"\n"/* Note that this doesn't guarantee to write all data in string. */
"\n"/* The length written is reported as result and it should be checked later. */
"\n"/*  */
"\n"/* On some platforms such as Windows, write_nonblock is not supported */
"\n"/* according to the kind of the IO object. */
"\n"/* In such cases, write_nonblock raises <code>Errno::EBADF</code>. */
"\n"/*  */
"\n"/* By specifying a keyword argument _exception_ to +false+, you can indicate */
"\n"/* that write_nonblock should not raise an IO::WaitWritable exception, but */
"\n"/* return the symbol +:wait_writable+ instead. */
"  def write_nonblock(buf, exception: true)\n"
,
#line 131 "prelude.rb"
"    __write_nonblock(buf, exception)\n"
"  end\n"
"end\n"
"\n"
"\n"/* :stopdoc: */
"class Binding\n"
"  def irb\n"
"    require 'irb'\n"
"    irb\n"
"  end\n"
"\n"
"\n"/* suppress redefinition warning */
"  alias irb irb\n"/* :nodoc: */
"end\n"
"\n"
"module Kernel\n"
"  def pp(*objs)\n"
"    require 'pp'\n"
"    pp(*objs)\n"
"  end\n"
"\n"
"\n"/* suppress redefinition warning */
"  alias pp pp\n"/* :nodoc: */
"end\n"
#line 175 "prelude.c"
};

static const char prelude_name1[] = "<internal:gem_prelude>";
static const struct {
    char L0[168]; /* 1..9 */
} prelude_code1 = {
#line 1 "gem_prelude.rb"
"if defined?(Gem)\n"
"  require 'rubygems.rb'\n"
"  begin\n"
"    gem 'did_you_mean'\n"
"    require 'did_you_mean'\n"
"  rescue Gem::LoadError, LoadError\n"
"  end if defined?(DidYouMean)\n"
"end\n"
#line 191 "prelude.c"
};


#define PRELUDE_NAME(n) rb_usascii_str_new_static(prelude_name##n, sizeof(prelude_name##n)-1)
#define PRELUDE_CODE(n) rb_usascii_str_new_static(prelude_code##n.L0, sizeof(prelude_code##n))
#if defined __GNUC__ && __GNUC__ >= 5
# pragma GCC diagnostic push
# pragma GCC diagnostic error "-Wmissing-field-initializers"
#endif
static void
prelude_eval(VALUE code, VALUE name, int line)
{
    static const rb_compile_option_t optimization = {
	TRUE, /* int inline_const_cache; */
	TRUE, /* int peephole_optimization; */
	TRUE, /* int tailcall_optimization; */
	TRUE, /* int specialized_instruction; */
	TRUE, /* int operands_unification; */
	TRUE, /* int instructions_unification; */
	TRUE, /* int stack_caching; */
	TRUE, /* int frozen_string_literal; */
	FALSE, /* int debug_frozen_string_literal; */
	FALSE, /* unsigned int coverage_enabled; */
	0, /* int debug_level; */
    };

    rb_ast_t *ast = rb_parser_compile_string_path(rb_parser_new(), name, code, line);
    if (!ast->body.root) {
	rb_ast_dispose(ast);
	rb_exc_raise(rb_errinfo());
    }
    rb_iseq_eval(rb_iseq_new_with_opt(&ast->body, name, name, Qnil, INT2FIX(line),
				      NULL, ISEQ_TYPE_TOP, &optimization));
    rb_ast_dispose(ast);
}
#if defined __GNUC__ && __GNUC__ >= 5
# pragma GCC diagnostic pop
#endif

void
Init_prelude(void)
{
    prelude_eval(PRELUDE_CODE(0), PRELUDE_NAME(0), 1);
    prelude_eval(PRELUDE_CODE(1), PRELUDE_NAME(1), 1);

#if 0
    printf("%.*s", (int)sizeof(prelude_code0), prelude_code0.L0);
    printf("%.*s", (int)sizeof(prelude_code1), prelude_code1.L0);
#endif
}
