#
# DO NOT MODIFY!!!!
# This file is automatically generated by Racc 1.5.1
# from Racc grammar file "".
#

require 'racc/parser.rb'
module RBS
  class Parser < Racc::Parser

module_eval(<<'...end parser.y/module_eval...', 'parser.y', 1066)

Types = RBS::Types
Namespace = RBS::Namespace
TypeName = RBS::TypeName
Declarations = RBS::AST::Declarations
Members = RBS::AST::Members
MethodType = RBS::MethodType
Annotation = RBS::AST::Annotation

class LocatedValue
  attr_reader :location
  attr_reader :value

  def initialize(location:, value:)
    @location = location
    @value = value
  end
end

require "strscan"

attr_reader :input
attr_reader :buffer
attr_reader :eof_re

def initialize(type, buffer:, eof_re:)
  super()
  @type = type
  @buffer = buffer
  @input = StringScanner.new(buffer.content)
  @eof_re = eof_re
  @eof = false
  @bound_variables_stack = []
  @comments = {}
  @ascii_only = buffer.content.ascii_only?
end

def start_merged_variables_scope
  set = @bound_variables_stack.last&.dup || Set.new
  @bound_variables_stack.push set
end

def start_new_variables_scope
  @bound_variables_stack.push Set.new
end

def reset_variable_scope
  @bound_variables_stack.pop
end

def insert_bound_variable(var)
  @bound_variables_stack.last << var
end

def is_bound_variable?(var)
  (@bound_variables_stack.last || Set.new).member?(var)
end

def self.parse_signature(input, eof_re: nil)
  case input
  when RBS::Buffer
    buffer = input
  else
    buffer = RBS::Buffer.new(name: nil, content: input.to_s)
  end

  self.new(:SIGNATURE, buffer: buffer, eof_re: eof_re).do_parse
end

def self.parse_type(input, variables: [], eof_re: nil)
  case input
  when RBS::Buffer
    buffer = input
  else
    buffer = RBS::Buffer.new(name: nil, content: input.to_s)
  end

  self.new(:TYPE, buffer: buffer, eof_re: eof_re).yield_self do |parser|
    parser.start_new_variables_scope

    variables.each do |var|
      parser.insert_bound_variable var
    end

    parser.do_parse
  ensure
    parser.reset_variable_scope
  end
end

def self.parse_method_type(input, variables: [], eof_re: nil)
  case input
  when RBS::Buffer
    buffer = input
  else
    buffer = RBS::Buffer.new(name: nil, content: input.to_s)
  end

  self.new(:METHODTYPE, buffer: buffer, eof_re: eof_re).yield_self do |parser|
    parser.start_new_variables_scope

    variables.each do |var|
      parser.insert_bound_variable var
    end

    parser.do_parse
  ensure
    parser.reset_variable_scope
  end
end

def leading_comment(location)
  @comments[location.start_line-1]
end

def push_comment(string, location)
  if (comment = leading_comment(location)) && comment.location.start_column == location.start_column
    comment.concat(string: "#{string}\n", location: location)
    @comments[comment.location.end_line] = comment
  else
    new_comment = AST::Comment.new(string: "#{string}\n", location: location)
    @comments[new_comment.location.end_line] = new_comment
  end
end

def new_token(type, value = input.matched)
  charpos = charpos(input)
  matched = input.matched

  if matched
    start_index = charpos - matched.size
    end_index = charpos

    location = RBS::Location.new(buffer: buffer,
                                 start_pos: start_index,
                                 end_pos: end_index)

    [type, LocatedValue.new(location: location, value: value)]
  else
    # scanner hasn't matched yet
    [false, nil]
  end
end

def charpos(scanner)
  if @ascii_only
    scanner.pos
  else
    scanner.charpos
  end
end

def empty_params_result
  [
    [],
    [],
    nil,
    [],
    {},
    {},
    nil
  ]
end

KEYWORDS = {
  "class" => :kCLASS,
  "type" => :kTYPE,
  "def" => :kDEF,
  "self" => :kSELF,
  "void" => :kVOID,
  "any" => :kANY,
  "untyped" => :kUNTYPED,
  "top" => :kTOP,
  "bot" => :kBOT,
  "instance" => :kINSTANCE,
  "bool" => :kBOOL,
  "nil" => :kNIL,
  "true" => :kTRUE,
  "false" => :kFALSE,
  "singleton" => :kSINGLETON,
  "interface" => :kINTERFACE,
  "end" => :kEND,
  "include" => :kINCLUDE,
  "extend" => :kEXTEND,
  "prepend" => :kPREPEND,
  "module" => :kMODULE,
  "attr_reader" => :kATTRREADER,
  "attr_writer" => :kATTRWRITER,
  "attr_accessor" => :kATTRACCESSOR,
  "public" => :kPUBLIC,
  "private" => :kPRIVATE,
  "alias" => :kALIAS,
  "extension" => :kEXTENSION,
  "incompatible" => :kINCOMPATIBLE,
  "unchecked" => :kUNCHECKED,
  "overload" => :kOVERLOAD,
  "out" => :kOUT,
  "in" => :kIN,
}
KEYWORDS_RE = /#{Regexp.union(*KEYWORDS.keys)}\b/

PUNCTS = {
  "===" => :tOPERATOR,
  "==" => :tOPERATOR,
  "=~" => :tOPERATOR,
  "!~" => :tOPERATOR,
  "!=" => :tOPERATOR,
  ">=" => :tOPERATOR,
  "<<" => :tOPERATOR,
  "<=>" => :tOPERATOR,
  "<=" => :tOPERATOR,
  ">>" => :tOPERATOR,
  ">" => :tOPERATOR,
  "~" => :tOPERATOR,
  "+@" => :tOPERATOR,
  "+" => :tOPERATOR,
  "[]=" => :tOPERATOR,
  "[]" => :tOPERATOR,
  "::" => :kCOLON2,
  ":" => :kCOLON,
  "(" => :kLPAREN,
  ")" => :kRPAREN,
  "[" => :kLBRACKET,
  "]" => :kRBRACKET,
  "{" => :kLBRACE,
  "}" => :kRBRACE,
  "," => :kCOMMA,
  "|" => :kBAR,
  "&" => :kAMP,
  "^" => :kHAT,
  "->" => :kARROW,
  "=>" => :kFATARROW,
  "=" => :kEQ,
  "?" => :kQUESTION,
  "!" => :kEXCLAMATION,
  "**" => :kSTAR2,
  "*" => :kSTAR,
  "..." => :kDOT3,
  "." => :kDOT,
  "<" => :kLT,
  "-@" => :tOPERATOR,
  "-" => :tOPERATOR,
  "/" => :tOPERATOR,
  "`" => :tOPERATOR,
  "%" => :tOPERATOR,
}
PUNCTS_RE = Regexp.union(*PUNCTS.keys)

ANNOTATION_RE = Regexp.union(/%a\{.*?\}/,
                             /%a\[.*?\]/,
                             /%a\(.*?\)/,
                             /%a\<.*?\>/,
                             /%a\|.*?\|/)

escape_sequences = %w[a b e f n r s t v "].map { |l| "\\\\#{l}" }
DBL_QUOTE_STR_ESCAPE_SEQUENCES_RE = /(#{escape_sequences.join("|")})/

def next_token
  if @type
    type = @type
    @type = nil
    return [:"type_#{type}", nil]
  end

  return new_token(false, '') if @eof

  while true
    return new_token(false, '') if input.eos?

    case
    when input.scan(/\s+/)
      # skip
    when input.scan(/#(( *)|( ?(?<string>.*)))\n/)
      charpos = charpos(input)
      start_index = charpos - input.matched.size
      end_index = charpos-1

      location = RBS::Location.new(buffer: buffer,
                                               start_pos: start_index,
                                               end_pos: end_index)

      push_comment input[:string] || "", location
    else
      break
    end
  end

  case
  when eof_re && input.scan(eof_re)
    @eof = true
    [:tEOF, input.matched]
  when input.scan(/`[a-zA-Z_]\w*`/)
    s = input.matched.yield_self {|s| s[1, s.length-2] }
    new_token(:tQUOTEDIDENT, s)
  when input.scan(/`(\\`|[^` :])+`/)
    s = input.matched.yield_self {|s| s[1, s.length-2] }.gsub(/\\`/, '`')
    new_token(:tQUOTEDMETHOD, s)
  when input.scan(ANNOTATION_RE)
    s = input.matched.yield_self {|s| s[3, s.length-4] }.strip
    new_token(:tANNOTATION, s)
  when input.scan(/self\?/)
    new_token(:kSELFQ, "self?")
  when input.scan(/(([a-zA-Z]\w*)|(_\w+))=/)
    new_token(:tWRITE_ATTR)
  when input.scan(KEYWORDS_RE)
    new_token(KEYWORDS[input.matched], input.matched.to_sym)
  when input.scan(/:((@{,2}|\$)?\w+(\?|\!)?|\+|\-)\b?/)
    s = input.matched.yield_self {|s| s[1, s.length] }.to_sym
    new_token(:tSYMBOL, s)
  when input.scan(/[+-]?\d[\d_]*/)
    new_token(:tINTEGER, input.matched.to_i)
  when input.scan(PUNCTS_RE)
    new_token(PUNCTS[input.matched])
  when input.scan(/(::)?([A-Z]\w*::)+/)
    new_token(:tNAMESPACE)
  when input.scan(/[a-z_]\w*:/)
    new_token(:tLKEYWORD, input.matched.chop.to_sym)
  when input.scan(/[a-z_]\w*[?!]:/)
    new_token(:tLKEYWORD_Q_E, input.matched.chop.to_sym)
  when input.scan(/[A-Z]\w*:/)
    new_token(:tUKEYWORD, input.matched.chop.to_sym)
  when input.scan(/[A-Z]\w*[?!]:/)
    new_token(:tUKEYWORD_Q_E, input.matched.chop.to_sym)
  when input.scan(/\$[A-Za-z_]\w*/)
    new_token(:tGLOBALIDENT)
  when input.scan(/@[a-zA-Z_]\w*/)
    new_token(:tIVAR, input.matched.to_sym)
  when input.scan(/@@[a-zA-Z_]\w*/)
    new_token(:tCLASSVAR, input.matched.to_sym)
  when input.scan(/_[a-zA-Z]\w*\b/)
    new_token(:tINTERFACEIDENT)
  when input.scan(/[A-Z]\w*\b/)
    new_token(:tUIDENT)
  when input.scan(/[a-z_]\w*\b/)
    new_token(:tLIDENT)
  when input.scan(/"(\\"|[^"])*"/)
    s = input.matched.yield_self {|s| s[1, s.length - 2] }
                     .gsub(DBL_QUOTE_STR_ESCAPE_SEQUENCES_RE) do |match|
                       case match
                       when '\\a' then "\a"
                       when '\\b' then "\b"
                       when '\\e' then "\e"
                       when '\\f' then "\f"
                       when '\\n' then "\n"
                       when '\\r' then "\r"
                       when '\\s' then "\s"
                       when '\\t' then "\t"
                       when '\\v' then "\v"
                       when '\\"' then '"'
                       end
                     end
    new_token(:tSTRING, s)
  when input.scan(/'(\\'|[^'])*'/)
    s = input.matched.yield_self {|s| s[1, s.length - 2] }.gsub(/\\'/, "'")
    new_token(:tSTRING, s)
  else
    raise "Unexpected token: #{input.peek(10)}..."
  end
end

def on_error(token_id, error_value, value_stack)
  raise SyntaxError.new(token_str: token_to_str(token_id), error_value: error_value, value_stack: value_stack)
end

class SyntaxError < StandardError
  attr_reader :token_str, :error_value, :value_stack

  def initialize(token_str:, error_value:, value_stack: nil)
    @token_str = token_str
    @error_value = error_value
    @value_stack = value_stack

    super "parse error on value: #{error_value.inspect} (#{token_str})"
  end
end

class SemanticsError < StandardError
  attr_reader :subject, :location, :original_message

  def initialize(message, subject:, location:)
    @subject = subject
    @location = location
    @original_message = message

    super "parse error on #{location}: #{message}"
  end
end

...end parser.y/module_eval...
##### State transition tables begin ###

clist = [
'351,352,33,353,163,78,5,33,33,338,162,395,49,33,33,350,37,336,239,394',
'40,41,213,214,215,216,217,218,219,220,355,33,221,212,222,223,107,118',
'108,109,110,124,33,32,53,346,340,341,32,32,344,342,345,303,32,32,33',
'343,123,111,112,113,115,117,116,339,348,349,114,119,121,91,32,89,42',
'125,126,122,127,351,352,33,353,32,60,61,62,63,43,49,48,33,33,33,350',
'188,188,32,90,40,41,213,214,215,216,217,218,219,220,224,33,221,212,222',
'223,107,118,108,109,110,124,53,32,145,346,340,341,53,53,344,342,345',
'32,32,32,168,343,123,111,112,113,115,117,116,339,348,349,114,119,121',
'203,32,146,278,125,126,122,127,351,352,90,353,68,60,61,62,63,65,66,39',
'67,40,41,350,85,204,326,361,279,149,213,214,215,216,217,218,219,220',
'224,398,221,212,222,223,107,118,108,109,110,124,39,90,90,346,340,341',
'399,400,344,342,345,322,40,41,90,343,123,111,112,113,115,117,116,339',
'348,349,114,119,121,150,318,90,90,125,126,122,127,351,352,151,353,152',
'60,61,62,63,60,61,62,63,40,41,350,57,56,58,2,3,4,213,214,215,216,217',
'218,219,220,224,153,221,212,222,223,107,118,108,109,110,124,40,41,78',
'346,340,341,40,41,344,342,345,40,41,40,41,343,123,111,112,113,115,117',
'116,339,348,349,114,119,121,351,352,161,353,125,126,122,127,-4,164,-242',
'167,33,41,82,350,-242,40,41,40,41,78,213,214,215,216,217,218,219,220',
'224,170,221,212,222,223,107,118,108,109,110,124,40,41,163,346,340,341',
'274,275,344,342,345,32,281,282,171,343,123,111,112,113,115,117,116,339',
'348,349,114,119,121,351,352,-108,353,125,126,122,127,-109,60,61,62,63',
'39,-110,350,57,56,58,373,374,-111,213,214,215,216,217,218,219,220,224',
'-112,221,212,222,223,107,118,108,109,110,124,40,41,-113,346,340,341',
'40,41,344,342,345,389,390,40,41,343,123,111,112,113,115,117,116,339',
'348,349,114,119,121,40,41,40,41,125,126,122,127,351,352,-114,353,-115',
'60,61,62,63,40,41,40,41,40,41,350,40,41,-116,-117,-118,48,213,214,215',
'216,217,218,219,220,224,-133,221,212,222,223,107,118,108,109,110,124',
'176,177,178,346,340,341,179,180,344,342,345,181,189,190,42,343,123,111',
'112,113,115,117,116,339,348,349,114,119,121,351,352,205,353,125,126',
'122,127,232,242,243,245,247,248,42,350,85,251,251,251,257,42,213,214',
'215,216,217,218,219,220,224,205,221,212,222,223,107,118,108,109,110',
'124,260,262,266,346,340,341,268,270,344,342,345,271,309,311,266,343',
'123,111,112,113,115,117,116,339,348,349,114,119,121,313,270,323,324',
'125,126,122,127,33,325,329,60,61,62,63,329,329,359,22,23,21,362,26,-220',
'25,369,30,370,96,97,98,99,100,101,102,103,120,16,104,95,105,106,107',
'118,108,109,110,124,371,32,372,375,377,28,380,141,380,142,144,380,393',
'396,397,404,123,111,112,113,115,117,116,405,406,408,114,119,121,413',
'414,415,416,125,126,122,127,33,413,,60,61,62,63,,,,22,23,21,,26,,25',
',30,,96,97,98,99,100,101,102,103,120,16,104,95,105,106,107,118,108,109',
'110,124,,32,,,,28,,,,,,,,,,,123,111,112,113,115,117,116,,,,114,119,121',
',,,,125,126,122,127,33,,,60,61,62,63,,,,22,23,21,,26,-220,25,,30,,96',
'97,98,99,100,101,102,103,120,16,104,95,105,106,107,118,108,109,110,124',
',32,,,,28,,141,,142,144,,,,,,123,111,112,113,115,117,116,,,,114,119',
'121,,,,,125,126,122,127,33,,,60,61,62,63,,,,22,23,21,,26,-220,25,,30',
',96,97,98,99,100,101,102,103,120,16,104,95,105,106,107,118,108,109,110',
'124,,32,,,,28,,141,,142,144,,,,,,123,111,112,113,115,117,116,,,,114',
'119,121,,,,,125,126,122,127,33,,,60,61,62,63,,,,22,23,21,,26,-220,25',
',30,,96,97,98,99,100,101,102,103,120,16,104,95,105,106,107,118,108,109',
'110,124,,32,,,,28,,211,,,144,,,,,,123,111,112,113,115,117,116,,,,114',
'119,121,,,,,125,126,122,127,33,,,60,61,62,63,,,,22,23,21,,26,-220,25',
',30,,96,97,98,99,100,101,102,103,120,16,104,95,105,106,107,118,108,109',
'110,124,,32,,,,28,,141,,142,144,,,,,,123,111,112,113,115,117,116,,,',
'114,119,121,,,,,125,126,122,127,33,,,60,61,62,63,,,,22,23,21,,26,-220',
'25,,30,,96,97,98,99,100,101,102,103,120,16,104,95,105,106,107,118,108',
'109,110,124,173,32,174,,,28,,211,,,144,,,,,,123,111,112,113,115,117',
'116,173,,174,114,119,121,60,61,62,63,125,126,122,127,,,,,,,,40,41,213',
'214,215,216,217,218,219,220,224,,221,212,222,223,107,118,108,109,110',
'124,175,40,41,,,,,211,,,144,,,,,,123,111,112,113,115,117,116,175,,,114',
'119,121,60,61,62,63,125,126,122,127,,,,,,,,,,213,214,215,216,217,218',
'219,220,224,,221,212,222,223,107,118,108,109,110,124,173,,174,,,,,211',
',,144,,,,,,123,111,112,113,115,117,116,173,,174,114,119,121,60,61,62',
'63,125,126,122,127,,,,,,,,40,41,213,214,215,216,217,218,219,220,224',
',221,212,222,223,107,118,108,109,110,124,175,40,41,173,157,174,173,160',
'174,158,,,,,,,123,111,112,113,115,117,116,175,,,114,119,121,159,,,,125',
'126,122,127,,,,156,,,,,,,40,41,,40,41,-242,,33,,82,,-242,,,298,299,78',
'-242,,33,,82,175,-242,,175,298,299,78,,,,-242,,33,300,82,,-242,,,298',
'299,78,295,294,,300,32,,,,,,,,295,294,,-242,32,33,300,82,286,-242,,',
'298,299,78,295,294,,,32,310,,,,,,,,,,,,,300,,314,,,,,,,295,294,,33,32',
',,,,,,,,22,23,21,,26,,25,360,30,,8,12,19,20,9,10,13,14,15,16,17,18,11',
'27,,,33,,,,,32,,,,28,22,23,21,,26,,25,45,30,,8,12,19,20,9,10,13,14,15',
'16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9',
'10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8',
'12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26',
',25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22',
'23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,',
'32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11',
'27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15',
'16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9',
'10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8',
'12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26',
',25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22',
'23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,',
'32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11',
'27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15',
'16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9',
'10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8',
'12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26',
',25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22',
'23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,',
'32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11',
'27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15',
'16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9',
'10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8',
'12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26',
',25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22',
'23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,',
'32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11',
'27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15',
'16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9',
'10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8',
'12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26',
',25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22',
'23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,',
'32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11',
'27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15',
'16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9',
'10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8',
'12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26',
',25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22',
'23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,157,,,160',
',158,,32,322,,,28,,,,,,,,,,,,,,159,,318,319,315,316,317,,,,320,156' ]
        racc_action_table = arr = ::Array.new(2787, nil)
        idx = 0
        clist.each do |str|
          str.split(',', -1).each do |i|
            arr[idx] = i.to_i unless i.empty?
            idx += 1
          end
        end

clist = [
'322,322,48,322,81,272,1,160,195,321,81,380,28,196,197,322,5,321,197',
'380,44,44,322,322,322,322,322,322,322,322,322,198,322,322,322,322,322',
'322,322,322,322,322,239,48,28,322,322,322,160,195,322,322,322,272,196',
'197,262,322,322,322,322,322,322,322,322,322,322,322,322,322,322,47,198',
'46,7,322,322,322,322,330,330,268,330,239,330,330,330,330,24,84,27,270',
'318,319,330,145,189,262,46,47,47,330,330,330,330,330,330,330,330,330',
'320,330,330,330,330,330,330,330,330,330,330,84,268,51,330,330,330,145',
'189,330,330,330,270,318,319,88,330,330,330,330,330,330,330,330,330,330',
'330,330,330,330,166,320,51,263,330,330,330,330,331,331,88,331,32,331',
'331,331,331,31,31,35,31,6,6,331,36,166,302,328,263,54,331,331,331,331',
'331,331,331,331,331,385,331,331,331,331,331,331,331,331,331,331,6,302',
'328,331,331,331,386,387,331,331,331,308,154,154,385,331,331,331,331',
'331,331,331,331,331,331,331,331,331,331,55,308,386,387,331,331,331,331',
'332,332,56,332,57,332,332,332,332,30,30,30,30,169,169,332,30,30,30,0',
'0,0,332,332,332,332,332,332,332,332,332,58,332,332,332,332,332,332,332',
'332,332,332,192,192,78,332,332,332,193,193,332,332,332,194,194,200,200',
'332,332,332,332,332,332,332,332,332,332,332,332,332,332,356,356,80,356',
'332,332,332,332,34,82,34,85,34,86,34,356,34,201,201,202,202,34,356,356',
'356,356,356,356,356,356,356,92,356,356,356,356,356,356,356,356,356,356',
'258,258,93,356,356,356,260,260,356,356,356,34,265,265,94,356,356,356',
'356,356,356,356,356,356,356,356,356,356,356,375,375,95,375,356,356,356',
'356,96,150,150,150,150,34,97,375,150,150,150,347,347,98,375,375,375',
'375,375,375,375,375,375,99,375,375,375,375,375,375,375,375,375,375,357',
'357,100,375,375,375,358,358,375,375,375,372,372,378,378,375,375,375',
'375,375,375,375,375,375,375,375,375,375,375,381,381,383,383,375,375',
'375,375,388,388,101,388,102,388,388,388,388,392,392,407,407,409,409',
'388,410,410,103,104,105,106,388,388,388,388,388,388,388,388,388,120',
'388,388,388,388,388,388,388,388,388,388,130,131,133,388,388,388,135',
'138,388,388,388,139,146,147,148,388,388,388,388,388,388,388,388,388',
'388,388,388,388,388,415,415,171,415,388,388,388,388,187,199,204,209',
'233,234,235,415,236,237,238,240,241,244,415,415,415,415,415,415,415',
'415,415,247,415,415,415,415,415,415,415,415,415,415,249,250,251,415',
'415,415,252,253,415,415,415,255,273,277,279,415,415,415,415,415,415',
'415,415,415,415,415,415,415,415,280,284,298,299,415,415,415,415,49,300',
'315,49,49,49,49,316,317,325,49,49,49,329,49,49,49,333,49,334,49,49,49',
'49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,335,49,337,355,359',
'49,364,49,366,49,49,368,379,382,384,389,49,49,49,49,49,49,49,390,391',
'395,49,49,49,401,403,406,412,49,49,49,49,141,416,,141,141,141,141,,',
',141,141,141,,141,,141,,141,,141,141,141,141,141,141,141,141,141,141',
'141,141,141,141,141,141,141,141,141,141,,141,,,,141,,,,,,,,,,,141,141',
'141,141,141,141,141,,,,141,141,141,,,,,141,141,141,141,177,,,177,177',
'177,177,,,,177,177,177,,177,177,177,,177,,177,177,177,177,177,177,177',
'177,177,177,177,177,177,177,177,177,177,177,177,177,,177,,,,177,,177',
',177,177,,,,,,177,177,177,177,177,177,177,,,,177,177,177,,,,,177,177',
'177,177,178,,,178,178,178,178,,,,178,178,178,,178,178,178,,178,,178',
'178,178,178,178,178,178,178,178,178,178,178,178,178,178,178,178,178',
'178,178,,178,,,,178,,178,,178,178,,,,,,178,178,178,178,178,178,178,',
',,178,178,178,,,,,178,178,178,178,179,,,179,179,179,179,,,,179,179,179',
',179,179,179,,179,,179,179,179,179,179,179,179,179,179,179,179,179,179',
'179,179,179,179,179,179,179,,179,,,,179,,179,,,179,,,,,,179,179,179',
'179,179,179,179,,,,179,179,179,,,,,179,179,179,179,188,,,188,188,188',
'188,,,,188,188,188,,188,188,188,,188,,188,188,188,188,188,188,188,188',
'188,188,188,188,188,188,188,188,188,188,188,188,,188,,,,188,,188,,188',
'188,,,,,,188,188,188,188,188,188,188,,,,188,188,188,,,,,188,188,188',
'188,245,,,245,245,245,245,,,,245,245,245,,245,245,245,,245,,245,245',
'245,245,245,245,245,245,245,245,245,245,245,245,245,245,245,245,245',
'245,128,245,128,,,245,,245,,,245,,,,,,245,245,245,245,245,245,245,182',
',182,245,245,245,180,180,180,180,245,245,245,245,,,,,,,,128,128,180',
'180,180,180,180,180,180,180,180,,180,180,180,180,180,180,180,180,180',
'180,128,182,182,,,,,180,,,180,,,,,,180,180,180,180,180,180,180,182,',
',180,180,180,181,181,181,181,180,180,180,180,,,,,,,,,,181,181,181,181',
'181,181,181,181,181,,181,181,181,181,181,181,181,181,181,181,184,,184',
',,,,181,,,181,,,,,,181,181,181,181,181,181,181,185,,185,181,181,181',
'211,211,211,211,181,181,181,181,,,,,,,,184,184,211,211,211,211,211,211',
'211,211,211,,211,211,211,211,211,211,211,211,211,211,184,185,185,186',
'79,186,228,79,228,79,,,,,,,211,211,211,211,211,211,211,185,,,211,211',
'211,79,,,,211,211,211,211,,,,79,,,,,,,186,186,,228,228,269,,269,,269',
',269,,,269,269,269,276,,276,,276,186,276,,228,276,276,276,,,,283,,283',
'269,283,,283,,,283,283,283,269,269,,276,269,,,,,,,,276,276,,327,276',
'327,283,327,269,327,,,327,327,327,283,283,,,283,276,,,,,,,,,,,,,327',
',283,,,,,,,327,327,,2,327,,,,,,,,,2,2,2,,2,,2,327,2,,2,2,2,2,2,2,2,2',
'2,2,2,2,2,2,,,25,,,,,2,,,,2,25,25,25,,25,,25,25,25,,25,25,25,25,25,25',
'25,25,25,25,25,25,25,25,,,26,,,,,25,,,,25,26,26,26,,26,,26,,26,,26,26',
'26,26,26,26,26,26,26,26,26,26,26,26,,,40,,,,,26,,,,26,40,40,40,,40,',
'40,,40,,40,40,40,40,40,40,40,40,40,40,40,40,40,40,,,41,,,,,40,,,,40',
'41,41,41,,41,,41,,41,,41,41,41,41,41,41,41,41,41,41,41,41,41,41,,,43',
',,,,41,,,,41,43,43,43,,43,,43,,43,,43,43,43,43,43,43,43,43,43,43,43',
'43,43,43,,,53,,,,,43,,,,43,53,53,53,,53,,53,,53,,53,53,53,53,53,53,53',
'53,53,53,53,53,53,53,,,59,,,,,53,,,,53,59,59,59,,59,,59,,59,,59,59,59',
'59,59,59,59,59,59,59,59,59,59,59,,,90,,,,,59,,,,59,90,90,90,,90,,90',
',90,,90,90,90,90,90,90,90,90,90,90,90,90,90,90,,,142,,,,,90,,,,90,142',
'142,142,,142,,142,,142,,142,142,142,142,142,142,142,142,142,142,142',
'142,142,142,,,143,,,,,142,,,,142,143,143,143,,143,,143,,143,,143,143',
'143,143,143,143,143,143,143,143,143,143,143,143,,,144,,,,,143,,,,143',
'144,144,144,,144,,144,,144,,144,144,144,144,144,144,144,144,144,144',
'144,144,144,144,,,151,,,,,144,,,,144,151,151,151,,151,,151,,151,,151',
'151,151,151,151,151,151,151,151,151,151,151,151,151,,,152,,,,,151,,',
',151,152,152,152,,152,,152,,152,,152,152,152,152,152,152,152,152,152',
'152,152,152,152,152,,,153,,,,,152,,,,152,153,153,153,,153,,153,,153',
',153,153,153,153,153,153,153,153,153,153,153,153,153,153,,,161,,,,,153',
',,,153,161,161,161,,161,,161,,161,,161,161,161,161,161,161,161,161,161',
'161,161,161,161,161,,,162,,,,,161,,,,161,162,162,162,,162,,162,,162',
',162,162,162,162,162,162,162,162,162,162,162,162,162,162,,,164,,,,,162',
',,,162,164,164,164,,164,,164,,164,,164,164,164,164,164,164,164,164,164',
'164,164,164,164,164,,,183,,,,,164,,,,164,183,183,183,,183,,183,,183',
',183,183,183,183,183,183,183,183,183,183,183,183,183,183,,,190,,,,,183',
',,,183,190,190,190,,190,,190,,190,,190,190,190,190,190,190,190,190,190',
'190,190,190,190,190,,,205,,,,,190,,,,190,205,205,205,,205,,205,,205',
',205,205,205,205,205,205,205,205,205,205,205,205,205,205,,,242,,,,,205',
',,,205,242,242,242,,242,,242,,242,,242,242,242,242,242,242,242,242,242',
'242,242,242,242,242,,,271,,,,,242,,,,242,271,271,271,,271,,271,,271',
',271,271,271,271,271,271,271,271,271,271,271,271,271,271,,,311,,,,,271',
',,,271,311,311,311,,311,,311,,311,,311,311,311,311,311,311,311,311,311',
'311,311,311,311,311,,,323,,,,,311,,,,311,323,323,323,,323,,323,,323',
',323,323,323,323,323,323,323,323,323,323,323,323,323,323,,,324,,,,,323',
',,,323,324,324,324,,324,,324,,324,,324,324,324,324,324,324,324,324,324',
'324,324,324,324,324,,,363,,,,,324,,,,324,363,363,363,,363,,363,,363',
',363,363,363,363,363,363,363,363,363,363,363,363,363,363,,,365,,,,,363',
',,,363,365,365,365,,365,,365,,365,,365,365,365,365,365,365,365,365,365',
'365,365,365,365,365,,,367,,,,,365,,,,365,367,367,367,,367,,367,,367',
',367,367,367,367,367,367,367,367,367,367,367,367,367,367,,,369,,,,,367',
',,,367,369,369,369,,369,,369,,369,,369,369,369,369,369,369,369,369,369',
'369,369,369,369,369,,,370,,,,,369,,,,369,370,370,370,,370,,370,,370',
',370,370,370,370,370,370,370,370,370,370,370,370,370,370,,,371,,,,,370',
',,,370,371,371,371,,371,,371,,371,,371,371,371,371,371,371,371,371,371',
'371,371,371,371,371,,,377,,,,,371,,,,371,377,377,377,,377,,377,,377',
',377,377,377,377,377,377,377,377,377,377,377,377,377,377,,,393,,,,,377',
',,,377,393,393,393,,393,,393,,393,,393,393,393,393,393,393,393,393,393',
'393,393,393,393,393,,,396,,,,,393,,,,393,396,396,396,,396,,396,,396',
',396,396,396,396,396,396,396,396,396,396,396,396,396,396,,,397,,,,,396',
',,,396,397,397,397,,397,,397,,397,,397,397,397,397,397,397,397,397,397',
'397,397,397,397,397,285,,,285,,285,,397,285,,,397,,,,,,,,,,,,,,285,',
'285,285,285,285,285,,,,285,285' ]
        racc_action_check = arr = ::Array.new(2787, nil)
        idx = 0
        clist.each do |str|
          str.split(',', -1).each do |i|
            arr[idx] = i.to_i unless i.empty?
            idx += 1
          end
        end

racc_action_pointer = [
   183,     6,  1452,   nil,   nil,    16,   124,    23,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,    68,  1488,  1524,    72,    -6,   nil,
   239,   165,   158,   nil,   316,    93,   154,   nil,   nil,   nil,
  1560,  1596,   nil,  1632,   -27,   nil,    52,    52,    -2,   604,
   nil,   101,   nil,  1668,   156,   183,   184,   186,   213,  1704,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   268,  1277,
   266,     2,   273,   nil,    71,   317,   273,   nil,   114,   nil,
  1740,   nil,   320,   350,   345,   337,   343,   349,   356,   366,
   379,   416,   418,   432,   433,   434,   461,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   445,   nil,   nil,   nil,   nil,   nil,   nil,   nil,  1107,   nil,
   456,   455,   nil,   456,   nil,   460,   nil,   nil,   461,   465,
   nil,   681,  1776,  1812,  1848,    77,   490,   463,   463,   nil,
   381,  1884,  1920,  1956,   165,   nil,   nil,   nil,   nil,   nil,
     3,  1992,  2028,   nil,  2064,   nil,   129,   nil,   nil,   203,
   nil,   481,   nil,   nil,   nil,   nil,   nil,   758,   835,   912,
  1132,  1198,  1130,  2100,  1239,  1262,  1308,   514,   989,    78,
  2136,   nil,   232,   238,   243,     4,     9,    10,    27,   482,
   245,   278,   280,   nil,   537,  2172,   nil,   nil,   nil,   494,
   nil,  1264,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,  1311,   nil,
   nil,   nil,   nil,   522,   519,   492,   525,   526,   527,    38,
   528,   544,  2208,   nil,   499,  1066,   nil,   510,   nil,   553,
   513,   494,   533,   532,   nil,   562,   nil,   nil,   303,   nil,
   354,   nil,    52,   132,   nil,   285,   nil,   nil,    77,  1358,
    87,  2244,    -8,   564,   nil,   nil,  1370,   564,   nil,   506,
   598,   nil,   nil,  1385,   555,  2715,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   558,   559,
   552,   nil,   155,   nil,   nil,   nil,   nil,   nil,   168,   nil,
   nil,  2280,   nil,   nil,   nil,   578,   583,   584,    88,    89,
   106,   -63,    -2,  2316,  2352,   606,   nil,  1412,   156,   564,
    77,   156,   235,   605,   607,   628,   nil,   611,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   347,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   594,   306,   374,   380,   608,
   nil,   nil,   nil,  2388,   636,  2424,   638,  2460,   641,  2496,
  2532,  2568,   400,   nil,   nil,   377,   nil,  2604,   387,   616,
     0,   403,   617,   405,   618,   168,   185,   186,   456,   606,
   614,   640,   420,  2640,   nil,   654,  2676,  2712,   nil,   nil,
   nil,   619,   nil,   634,   nil,   nil,   622,   422,   nil,   424,
   427,   nil,   633,   nil,   nil,   527,   628,   nil,   nil ]

racc_action_default = [
  -246,  -246,  -242,    -6,   -16,  -246,    -4,  -161,  -164,  -165,
  -166,  -167,  -168,  -169,  -170,  -171,  -172,  -173,  -174,  -175,
  -176,  -177,  -178,  -179,  -180,  -242,  -242,  -246,   -84,  -188,
  -246,  -246,  -243,  -245,   -17,    -4,  -151,   419,    -1,    -5,
  -242,  -242,  -187,  -242,  -189,  -182,  -246,  -246,  -242,  -242,
  -186,  -246,  -205,  -242,  -246,  -192,  -246,  -246,  -246,  -242,
  -200,  -201,  -202,  -203,  -236,  -237,  -238,  -239,  -244,    -2,
    -7,    -8,    -9,   -10,   -11,   -12,   -13,   -14,   -17,  -246,
  -246,  -246,  -246,    -3,   -84,  -246,  -162,  -163,  -246,  -183,
  -242,  -184,  -246,  -246,  -246,  -174,  -164,  -168,  -175,  -176,
  -165,  -166,  -169,  -170,  -173,  -167,  -119,  -120,  -121,  -122,
  -123,  -124,  -125,  -126,  -127,  -128,  -129,  -130,  -131,  -132,
  -171,  -134,  -135,  -136,  -137,  -138,  -139,  -140,  -232,  -198,
  -246,  -209,  -210,  -212,  -213,  -215,  -216,  -219,  -222,  -224,
  -225,  -242,  -242,  -242,  -242,  -246,  -246,  -246,  -207,  -191,
  -246,  -242,  -242,  -242,  -197,   -18,   -15,   -15,   -15,   -15,
  -242,  -242,  -242,  -241,  -242,   -83,  -246,  -153,  -181,  -190,
  -185,   -85,  -226,  -233,  -234,  -235,  -199,  -242,  -242,  -242,
  -220,  -220,  -232,  -242,  -232,  -232,  -232,  -246,  -242,  -246,
  -242,  -193,  -194,  -195,  -196,  -242,  -242,  -242,  -242,  -246,
  -158,  -159,  -160,  -152,  -246,  -242,  -208,  -216,  -211,  -218,
  -214,  -246,  -108,  -109,  -110,  -111,  -112,  -113,  -114,  -115,
  -116,  -117,  -118,  -119,  -133,  -221,  -223,  -227,  -232,  -228,
  -229,  -231,   -86,  -246,  -246,  -204,  -151,  -141,  -141,  -242,
  -141,  -246,  -242,  -154,  -206,  -242,  -230,  -246,   -87,  -246,
   -23,  -149,   -28,   -34,   -30,   -33,   -61,  -240,  -157,  -217,
  -246,   -34,  -242,  -246,  -143,  -146,  -150,   -34,  -242,   -17,
  -242,  -242,   -17,  -246,   -20,   -21,   -17,   -24,  -142,  -149,
  -246,  -147,  -148,   -17,   -29,   -75,   -27,   -35,   -36,   -37,
   -38,   -39,   -40,   -41,   -42,   -43,   -44,   -45,  -246,  -246,
  -246,   -31,  -246,   -60,   -62,   -63,   -64,   -65,   -75,   -34,
   -22,  -242,  -144,  -145,   -26,   -46,   -46,   -46,  -242,  -242,
  -242,   -72,  -246,  -242,  -242,  -246,   -32,   -17,  -246,  -246,
  -246,  -246,  -246,   -66,   -68,   -70,   -73,  -246,   -76,   -90,
   -91,   -92,   -93,   -94,   -95,   -96,   -97,   -98,  -101,  -102,
  -103,  -104,  -105,  -106,  -107,  -133,  -246,   -57,   -58,  -246,
   -19,   -25,   -47,  -242,   -54,  -242,   -54,  -242,   -54,  -242,
  -242,  -242,   -77,   -99,  -100,  -246,  -155,  -242,   -48,  -246,
  -246,   -50,  -246,   -52,  -246,  -246,  -246,  -246,  -246,  -246,
  -246,  -246,   -59,  -242,   -55,  -246,  -242,  -242,   -67,   -69,
   -71,   -16,   -88,  -246,   -78,   -79,  -246,   -49,   -56,   -51,
   -53,   -74,   -80,   -81,   -89,  -246,   -16,  -156,   -82 ]

racc_goto_table = [
     6,    59,    46,    81,    79,    92,    84,    54,    94,   148,
   199,   172,   183,   207,    50,   210,   264,    93,   187,   356,
    88,    38,     1,   253,    47,   411,   354,   364,   366,   368,
   209,   209,   225,   226,   354,   354,   354,   269,    86,    87,
   418,   330,   331,   332,   312,   276,    34,   128,   155,    69,
    83,   283,   284,   376,   379,    35,   382,   154,   384,    70,
   354,   273,   234,   250,   252,   227,   256,   229,   230,   231,
   165,   261,   391,   195,   196,   197,   198,   267,   301,   354,
   305,   259,   183,   306,   307,   403,   240,   272,   169,   255,
   304,   337,   354,   327,   388,   401,   147,   209,   263,   280,
   166,   208,    64,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   246,   417,   nil,   nil,   nil,   nil,   nil,   255,   354,
   255,    59,   nil,   nil,   nil,   nil,   nil,   191,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   206,   nil,   nil,   182,
   184,   185,   186,   nil,   nil,   nil,   235,   233,   nil,   192,
   193,   194,   236,   237,   238,   nil,   nil,   nil,   nil,   200,
   201,   244,   202,   nil,    93,    93,    93,   241,   333,   334,
   335,   nil,   nil,   nil,   nil,   128,   128,   128,   nil,   nil,
   nil,   228,   nil,   nil,   nil,   nil,   128,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   249,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   277,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,    93,   nil,   nil,   nil,   nil,   nil,   nil,    81,   nil,
   258,   nil,   308,   128,   nil,    81,   nil,   nil,   302,   nil,
   nil,   nil,    81,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   328,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,    81,   nil,   nil,   nil,
   nil,   363,   365,   367,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   357,   358,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   385,   386,   387,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   402,
   nil,   378,   nil,   381,   nil,   383,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   392,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   407,   nil,   nil,   409,   410 ]

racc_goto_check = [
     2,    37,    23,    60,    16,    17,    18,    63,    50,    61,
    27,    76,    65,    71,    48,    71,    56,    60,    52,    38,
    23,     3,     1,    25,     2,    47,    54,    38,    38,    38,
    66,    66,    72,    72,    54,    54,    54,    20,     2,     2,
    47,    36,    36,    36,    56,    20,     4,     2,    16,     3,
     3,    20,    25,    38,    39,     5,    39,     2,    39,     6,
    54,    19,    52,    21,    21,    76,    21,    76,    76,    76,
    48,    22,    38,    14,    14,    14,    14,    24,    26,    54,
    29,    71,    65,    30,    35,    38,    40,    41,     2,    27,
    42,    43,    54,    20,    45,    46,    51,    66,    55,    58,
    59,    67,    77,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,    76,    38,   nil,   nil,   nil,   nil,   nil,    27,    54,
    27,    37,   nil,   nil,   nil,   nil,   nil,    63,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,    50,   nil,   nil,     2,
     2,     2,     2,   nil,   nil,   nil,    61,    50,   nil,     2,
     2,     2,    17,    17,    17,   nil,   nil,   nil,   nil,     2,
     2,    61,     2,   nil,    60,    60,    60,    60,    27,    27,
    27,   nil,   nil,   nil,   nil,     2,     2,     2,   nil,   nil,
   nil,     2,   nil,   nil,   nil,   nil,     2,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,    18,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,    17,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,    60,   nil,   nil,   nil,   nil,   nil,   nil,    60,   nil,
     2,   nil,    16,     2,   nil,    60,   nil,   nil,    23,   nil,
   nil,   nil,    60,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,    23,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,    60,   nil,   nil,   nil,
   nil,    37,    37,    37,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,     2,     2,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,    23,    23,    23,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,    37,
   nil,     2,   nil,     2,   nil,     2,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,     2,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,     2,   nil,   nil,     2,     2 ]

racc_goto_pointer = [
   nil,    22,    -2,    15,    43,    51,    25,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   -83,   nil,   -30,   -43,   -30,  -199,
  -216,  -174,  -179,   -23,  -175,  -216,  -192,  -150,   nil,  -192,
  -189,   nil,   nil,   nil,   nil,  -188,  -274,   -29,  -303,  -310,
  -112,  -169,  -182,  -230,   nil,  -278,  -293,  -376,   -14,   nil,
   -41,    45,  -127,   nil,  -296,  -153,  -235,   nil,  -166,    15,
   -31,   -44,   nil,   -23,   nil,  -129,  -148,   -77,   nil,   nil,
   nil,  -164,  -148,   nil,   nil,   nil,  -117,    71 ]

racc_goto_default = [
   nil,   nil,    44,   nil,   nil,   412,   297,    71,    72,    73,
    74,    75,    76,    77,   nil,    36,   285,    80,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   254,    24,   287,   288,
   289,   290,   291,   292,   293,   296,   nil,   129,   nil,   nil,
   nil,   nil,   nil,   nil,   321,   nil,   nil,   nil,   nil,    51,
   nil,   nil,    52,   347,   130,   nil,   nil,   265,   nil,   nil,
    31,     7,    29,   nil,    55,   143,   131,   132,   133,   134,
   135,   136,   137,   138,   139,   140,   nil,   nil ]

racc_reduce_table = [
  0, 0, :racc_error,
  3, 82, :_reduce_1,
  3, 82, :_reduce_2,
  3, 82, :_reduce_3,
  0, 84, :_reduce_none,
  1, 84, :_reduce_none,
  0, 85, :_reduce_6,
  2, 85, :_reduce_7,
  1, 87, :_reduce_none,
  1, 87, :_reduce_none,
  1, 87, :_reduce_none,
  1, 87, :_reduce_none,
  1, 87, :_reduce_none,
  1, 87, :_reduce_none,
  1, 87, :_reduce_none,
  0, 95, :_reduce_15,
  0, 96, :_reduce_16,
  0, 97, :_reduce_17,
  2, 97, :_reduce_18,
  10, 94, :_reduce_19,
  1, 100, :_reduce_none,
  1, 100, :_reduce_none,
  8, 93, :_reduce_22,
  0, 103, :_reduce_23,
  2, 103, :_reduce_24,
  5, 103, :_reduce_25,
  8, 92, :_reduce_26,
  7, 92, :_reduce_27,
  0, 105, :_reduce_28,
  2, 105, :_reduce_29,
  1, 106, :_reduce_30,
  3, 106, :_reduce_31,
  4, 107, :_reduce_32,
  1, 107, :_reduce_33,
  0, 101, :_reduce_34,
  2, 101, :_reduce_35,
  1, 109, :_reduce_none,
  1, 109, :_reduce_none,
  1, 109, :_reduce_none,
  1, 109, :_reduce_none,
  1, 109, :_reduce_none,
  1, 109, :_reduce_none,
  1, 109, :_reduce_42,
  1, 109, :_reduce_43,
  1, 109, :_reduce_none,
  1, 109, :_reduce_none,
  0, 117, :_reduce_46,
  2, 117, :_reduce_47,
  5, 115, :_reduce_48,
  7, 115, :_reduce_49,
  5, 115, :_reduce_50,
  7, 115, :_reduce_51,
  5, 115, :_reduce_52,
  7, 115, :_reduce_53,
  0, 120, :_reduce_54,
  2, 120, :_reduce_55,
  3, 120, :_reduce_56,
  3, 114, :_reduce_57,
  3, 114, :_reduce_58,
  5, 114, :_reduce_59,
  7, 91, :_reduce_60,
  0, 122, :_reduce_61,
  2, 122, :_reduce_62,
  1, 123, :_reduce_63,
  1, 123, :_reduce_64,
  1, 123, :_reduce_none,
  3, 111, :_reduce_66,
  6, 111, :_reduce_67,
  3, 112, :_reduce_68,
  6, 112, :_reduce_69,
  3, 113, :_reduce_70,
  6, 113, :_reduce_71,
  0, 124, :_reduce_72,
  1, 124, :_reduce_73,
  7, 110, :_reduce_74,
  0, 125, :_reduce_none,
  2, 125, :_reduce_76,
  0, 126, :_reduce_77,
  2, 126, :_reduce_78,
  2, 126, :_reduce_79,
  1, 128, :_reduce_80,
  1, 128, :_reduce_81,
  3, 128, :_reduce_82,
  3, 86, :_reduce_83,
  0, 130, :_reduce_84,
  3, 130, :_reduce_85,
  3, 132, :_reduce_86,
  4, 132, :_reduce_87,
  1, 127, :_reduce_none,
  2, 127, :_reduce_89,
  1, 119, :_reduce_none,
  1, 119, :_reduce_none,
  1, 119, :_reduce_none,
  1, 119, :_reduce_none,
  1, 119, :_reduce_none,
  1, 119, :_reduce_none,
  1, 119, :_reduce_none,
  1, 119, :_reduce_none,
  1, 119, :_reduce_none,
  2, 119, :_reduce_99,
  2, 119, :_reduce_100,
  1, 119, :_reduce_none,
  1, 119, :_reduce_none,
  1, 119, :_reduce_none,
  1, 134, :_reduce_none,
  1, 134, :_reduce_none,
  1, 134, :_reduce_none,
  1, 134, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  0, 102, :_reduce_141,
  3, 102, :_reduce_142,
  1, 136, :_reduce_143,
  3, 136, :_reduce_144,
  3, 137, :_reduce_145,
  0, 139, :_reduce_146,
  1, 139, :_reduce_147,
  1, 139, :_reduce_148,
  0, 138, :_reduce_149,
  1, 138, :_reduce_150,
  0, 99, :_reduce_151,
  3, 99, :_reduce_152,
  1, 140, :_reduce_153,
  3, 140, :_reduce_154,
  4, 116, :_reduce_155,
  8, 116, :_reduce_156,
  5, 88, :_reduce_157,
  3, 89, :_reduce_158,
  3, 89, :_reduce_159,
  3, 90, :_reduce_160,
  1, 83, :_reduce_none,
  3, 83, :_reduce_162,
  3, 83, :_reduce_163,
  1, 142, :_reduce_164,
  1, 142, :_reduce_165,
  1, 142, :_reduce_166,
  1, 142, :_reduce_167,
  1, 142, :_reduce_168,
  1, 142, :_reduce_169,
  1, 142, :_reduce_170,
  1, 142, :_reduce_171,
  1, 142, :_reduce_172,
  1, 142, :_reduce_173,
  1, 142, :_reduce_174,
  1, 142, :_reduce_175,
  1, 142, :_reduce_176,
  1, 142, :_reduce_177,
  1, 142, :_reduce_178,
  1, 142, :_reduce_179,
  1, 142, :_reduce_180,
  4, 142, :_reduce_181,
  2, 142, :_reduce_182,
  3, 142, :_reduce_183,
  3, 142, :_reduce_184,
  4, 142, :_reduce_185,
  2, 142, :_reduce_186,
  2, 142, :_reduce_187,
  1, 142, :_reduce_none,
  1, 104, :_reduce_189,
  3, 104, :_reduce_190,
  3, 143, :_reduce_191,
  1, 144, :_reduce_192,
  3, 144, :_reduce_193,
  3, 145, :_reduce_194,
  3, 145, :_reduce_195,
  3, 145, :_reduce_196,
  2, 145, :_reduce_197,
  1, 146, :_reduce_none,
  2, 146, :_reduce_199,
  1, 118, :_reduce_none,
  1, 118, :_reduce_none,
  1, 118, :_reduce_none,
  1, 118, :_reduce_none,
  4, 129, :_reduce_204,
  1, 129, :_reduce_205,
  5, 133, :_reduce_206,
  2, 133, :_reduce_207,
  3, 131, :_reduce_208,
  1, 131, :_reduce_209,
  1, 131, :_reduce_none,
  3, 148, :_reduce_211,
  1, 148, :_reduce_212,
  1, 148, :_reduce_none,
  3, 150, :_reduce_214,
  1, 150, :_reduce_215,
  1, 150, :_reduce_none,
  3, 152, :_reduce_217,
  1, 152, :_reduce_218,
  1, 152, :_reduce_none,
  0, 153, :_reduce_220,
  3, 153, :_reduce_221,
  1, 153, :_reduce_222,
  3, 153, :_reduce_223,
  1, 153, :_reduce_224,
  1, 153, :_reduce_225,
  2, 147, :_reduce_226,
  3, 149, :_reduce_227,
  3, 151, :_reduce_228,
  3, 154, :_reduce_229,
  4, 155, :_reduce_230,
  3, 156, :_reduce_231,
  0, 157, :_reduce_none,
  1, 157, :_reduce_none,
  1, 157, :_reduce_none,
  1, 157, :_reduce_none,
  2, 108, :_reduce_236,
  1, 158, :_reduce_none,
  1, 158, :_reduce_none,
  1, 158, :_reduce_none,
  2, 121, :_reduce_240,
  2, 98, :_reduce_241,
  0, 141, :_reduce_242,
  1, 141, :_reduce_243,
  2, 141, :_reduce_244,
  1, 141, :_reduce_245 ]

racc_reduce_n = 246

racc_shift_n = 419

racc_token_table = {
  false => 0,
  :error => 1,
  :tUIDENT => 2,
  :tLIDENT => 3,
  :tNAMESPACE => 4,
  :tINTERFACEIDENT => 5,
  :tGLOBALIDENT => 6,
  :tLKEYWORD => 7,
  :tUKEYWORD => 8,
  :tLKEYWORD_Q_E => 9,
  :tUKEYWORD_Q_E => 10,
  :tIVAR => 11,
  :tCLASSVAR => 12,
  :tANNOTATION => 13,
  :tSTRING => 14,
  :tSYMBOL => 15,
  :tINTEGER => 16,
  :tWRITE_ATTR => 17,
  :kLPAREN => 18,
  :kRPAREN => 19,
  :kLBRACKET => 20,
  :kRBRACKET => 21,
  :kLBRACE => 22,
  :kRBRACE => 23,
  :kVOID => 24,
  :kNIL => 25,
  :kTRUE => 26,
  :kFALSE => 27,
  :kANY => 28,
  :kUNTYPED => 29,
  :kTOP => 30,
  :kBOT => 31,
  :kSELF => 32,
  :kSELFQ => 33,
  :kINSTANCE => 34,
  :kCLASS => 35,
  :kBOOL => 36,
  :kSINGLETON => 37,
  :kTYPE => 38,
  :kDEF => 39,
  :kMODULE => 40,
  :kPRIVATE => 41,
  :kPUBLIC => 42,
  :kALIAS => 43,
  :kCOLON => 44,
  :kCOLON2 => 45,
  :kCOMMA => 46,
  :kBAR => 47,
  :kAMP => 48,
  :kHAT => 49,
  :kARROW => 50,
  :kQUESTION => 51,
  :kEXCLAMATION => 52,
  :kSTAR => 53,
  :kSTAR2 => 54,
  :kFATARROW => 55,
  :kEQ => 56,
  :kDOT => 57,
  :kDOT3 => 58,
  :kLT => 59,
  :kINTERFACE => 60,
  :kEND => 61,
  :kINCLUDE => 62,
  :kEXTEND => 63,
  :kATTRREADER => 64,
  :kATTRWRITER => 65,
  :kATTRACCESSOR => 66,
  :tOPERATOR => 67,
  :tQUOTEDMETHOD => 68,
  :tQUOTEDIDENT => 69,
  :kPREPEND => 70,
  :kEXTENSION => 71,
  :kINCOMPATIBLE => 72,
  :type_TYPE => 73,
  :type_SIGNATURE => 74,
  :type_METHODTYPE => 75,
  :tEOF => 76,
  :kOUT => 77,
  :kIN => 78,
  :kUNCHECKED => 79,
  :kOVERLOAD => 80 }

racc_nt_base = 81

racc_use_result_var = true

Racc_arg = [
  racc_action_table,
  racc_action_check,
  racc_action_default,
  racc_action_pointer,
  racc_goto_table,
  racc_goto_check,
  racc_goto_default,
  racc_goto_pointer,
  racc_nt_base,
  racc_reduce_table,
  racc_token_table,
  racc_shift_n,
  racc_reduce_n,
  racc_use_result_var ]

Racc_token_to_s_table = [
  "$end",
  "error",
  "tUIDENT",
  "tLIDENT",
  "tNAMESPACE",
  "tINTERFACEIDENT",
  "tGLOBALIDENT",
  "tLKEYWORD",
  "tUKEYWORD",
  "tLKEYWORD_Q_E",
  "tUKEYWORD_Q_E",
  "tIVAR",
  "tCLASSVAR",
  "tANNOTATION",
  "tSTRING",
  "tSYMBOL",
  "tINTEGER",
  "tWRITE_ATTR",
  "kLPAREN",
  "kRPAREN",
  "kLBRACKET",
  "kRBRACKET",
  "kLBRACE",
  "kRBRACE",
  "kVOID",
  "kNIL",
  "kTRUE",
  "kFALSE",
  "kANY",
  "kUNTYPED",
  "kTOP",
  "kBOT",
  "kSELF",
  "kSELFQ",
  "kINSTANCE",
  "kCLASS",
  "kBOOL",
  "kSINGLETON",
  "kTYPE",
  "kDEF",
  "kMODULE",
  "kPRIVATE",
  "kPUBLIC",
  "kALIAS",
  "kCOLON",
  "kCOLON2",
  "kCOMMA",
  "kBAR",
  "kAMP",
  "kHAT",
  "kARROW",
  "kQUESTION",
  "kEXCLAMATION",
  "kSTAR",
  "kSTAR2",
  "kFATARROW",
  "kEQ",
  "kDOT",
  "kDOT3",
  "kLT",
  "kINTERFACE",
  "kEND",
  "kINCLUDE",
  "kEXTEND",
  "kATTRREADER",
  "kATTRWRITER",
  "kATTRACCESSOR",
  "tOPERATOR",
  "tQUOTEDMETHOD",
  "tQUOTEDIDENT",
  "kPREPEND",
  "kEXTENSION",
  "kINCOMPATIBLE",
  "type_TYPE",
  "type_SIGNATURE",
  "type_METHODTYPE",
  "tEOF",
  "kOUT",
  "kIN",
  "kUNCHECKED",
  "kOVERLOAD",
  "$start",
  "target",
  "type",
  "eof",
  "signatures",
  "method_type",
  "signature",
  "type_decl",
  "const_decl",
  "global_decl",
  "interface_decl",
  "module_decl",
  "class_decl",
  "extension_decl",
  "start_new_scope",
  "start_merged_scope",
  "annotations",
  "class_name",
  "type_params",
  "extension_name",
  "class_members",
  "module_type_params",
  "super_class",
  "type_list",
  "colon_module_self_types",
  "module_self_types",
  "module_self_type",
  "qualified_name",
  "class_member",
  "method_member",
  "include_member",
  "extend_member",
  "prepend_member",
  "var_type_member",
  "attribute_member",
  "alias_member",
  "attribute_kind",
  "keyword",
  "method_name",
  "attr_var_opt",
  "interface_name",
  "interface_members",
  "interface_member",
  "overload",
  "attributes",
  "method_kind",
  "def_name",
  "method_types",
  "proc_type",
  "params_opt",
  "params",
  "block",
  "simple_function_type",
  "method_name0",
  "identifier_keywords",
  "module_type_params0",
  "module_type_param",
  "type_param_check",
  "type_param_variance",
  "type_params0",
  "namespace",
  "simple_type",
  "record_type",
  "record_fields",
  "record_field",
  "keyword_name",
  "required_positional",
  "optional_positional_params",
  "optional_positional",
  "rest_positional_param",
  "rest_positional",
  "trailing_positional_params",
  "keyword_params",
  "required_keyword",
  "optional_keyword",
  "rest_keyword",
  "var_name_opt",
  "simple_name" ]

Racc_debug_parser = false

##### State transition tables end #####

# reduce 0 omitted

module_eval(<<'.,.,', 'parser.y', 28)
  def _reduce_1(val, _values, result)
            result = val[1]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 31)
  def _reduce_2(val, _values, result)
            result = val[1]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 34)
  def _reduce_3(val, _values, result)
            result = val[1]

    result
  end
.,.,

# reduce 4 omitted

# reduce 5 omitted

module_eval(<<'.,.,', 'parser.y', 40)
  def _reduce_6(val, _values, result)
     result = []
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 42)
  def _reduce_7(val, _values, result)
            result = val[0].push(val[1])

    result
  end
.,.,

# reduce 8 omitted

# reduce 9 omitted

# reduce 10 omitted

# reduce 11 omitted

# reduce 12 omitted

# reduce 13 omitted

# reduce 14 omitted

module_eval(<<'.,.,', 'parser.y', 54)
  def _reduce_15(val, _values, result)
     start_new_variables_scope
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 55)
  def _reduce_16(val, _values, result)
     start_merged_variables_scope
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 58)
  def _reduce_17(val, _values, result)
     result = []
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 60)
  def _reduce_18(val, _values, result)
            result = val[1].unshift(Annotation.new(string: val[0].value, location: val[0].location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 65)
  def _reduce_19(val, _values, result)
            reset_variable_scope

        location = val[1].location + val[9].location
        result = Declarations::Extension.new(
          name: val[3].value,
          type_params: val[4]&.value || [],
          extension_name: val[6].value.to_sym,
          members: val[8],
          annotations: val[0],
          location: location,
          comment: leading_comment(val[0].first&.location || location)
        )

    result
  end
.,.,

# reduce 20 omitted

# reduce 21 omitted

module_eval(<<'.,.,', 'parser.y', 83)
  def _reduce_22(val, _values, result)
            reset_variable_scope

        location = val[1].location + val[7].location
        result = Declarations::Class.new(
          name: val[3].value,
          type_params: val[4]&.value || Declarations::ModuleTypeParams.empty,
          super_class: val[5],
          members: val[6],
          annotations: val[0],
          location: location,
          comment: leading_comment(val[0].first&.location || location)
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 98)
  def _reduce_23(val, _values, result)
     result = nil
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 100)
  def _reduce_24(val, _values, result)
            result = Declarations::Class::Super.new(name: val[1].value,
                                                args: [])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 104)
  def _reduce_25(val, _values, result)
            result = Declarations::Class::Super.new(name: val[1].value,
                                                args: val[3])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 110)
  def _reduce_26(val, _values, result)
            reset_variable_scope

        location = val[1].location + val[7].location
        result = Declarations::Module.new(
          name: val[3].value,
          type_params: val[4]&.value || Declarations::ModuleTypeParams.empty,
          self_types: val[5],
          members: val[6],
          annotations: val[0],
          location: location,
          comment: leading_comment(val[0].first&.location || location)
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 124)
  def _reduce_27(val, _values, result)
            reset_variable_scope

        location = val[1].location + val[6].location
        result = Declarations::Module.new(
          name: val[3].value,
          type_params: Declarations::ModuleTypeParams.empty,
          self_types: val[4],
          members: val[5],
          annotations: val[0],
          location: location,
          comment: leading_comment(val[0].first&.location || location)
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 139)
  def _reduce_28(val, _values, result)
     result = []
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 141)
  def _reduce_29(val, _values, result)
            result = val[1]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 146)
  def _reduce_30(val, _values, result)
            result = [val[0]]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 149)
  def _reduce_31(val, _values, result)
            result = val[0].push(val[2])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 154)
  def _reduce_32(val, _values, result)
            name = val[0].value
        args = val[2]
        location = val[0].location + val[3].location

        case
        when name.class?
          result = Declarations::Module::Self.new(name: name, args: args, location: location)
        when name.interface?
          result = Declarations::Module::Self.new(name: name, args: args, location: location)
        else
          raise SemanticsError.new("Module self type should be instance or interface", subject: val[0], location: val[0].location)
        end

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 168)
  def _reduce_33(val, _values, result)
            name = val[0].value
        args = []
        location = val[0].location

        case
        when name.class?
          result = Declarations::Module::Self.new(name: name, args: args, location: location)
        when name.interface?
          result = Declarations::Module::Self.new(name: name, args: args, location: location)
        else
          raise SemanticsError.new("Module self type should be instance or interface", subject: val[0], location: val[0].location)
        end

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 183)
  def _reduce_34(val, _values, result)
     result = []
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 185)
  def _reduce_35(val, _values, result)
            result = val[0].push(val[1])

    result
  end
.,.,

# reduce 36 omitted

# reduce 37 omitted

# reduce 38 omitted

# reduce 39 omitted

# reduce 40 omitted

# reduce 41 omitted

module_eval(<<'.,.,', 'parser.y', 196)
  def _reduce_42(val, _values, result)
            result = Members::Public.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 199)
  def _reduce_43(val, _values, result)
            result = Members::Private.new(location: val[0].location)

    result
  end
.,.,

# reduce 44 omitted

# reduce 45 omitted

module_eval(<<'.,.,', 'parser.y', 205)
  def _reduce_46(val, _values, result)
     result = :instance
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 206)
  def _reduce_47(val, _values, result)
     result = :singleton
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 210)
  def _reduce_48(val, _values, result)
            location = val[1].location + val[4].location
        result = Members::AttrReader.new(name: val[3].value,
                                         ivar_name: nil,
                                         type: val[4],
                                         kind: val[2],
                                         annotations: val[0],
                                         location: location,
                                         comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 220)
  def _reduce_49(val, _values, result)
            location = val[1].location + val[6].location
        result = Members::AttrReader.new(name: val[3].value.to_sym,
                                         ivar_name: val[4],
                                         type: val[6],
                                         kind: val[2],
                                         annotations: val[0],
                                         location: location,
                                         comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 230)
  def _reduce_50(val, _values, result)
            location = val[1].location + val[4].location
        result = Members::AttrWriter.new(name: val[3].value,
                                         ivar_name: nil,
                                         kind: val[2],
                                         type: val[4],
                                         annotations: val[0],
                                         location: location,
                                         comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 240)
  def _reduce_51(val, _values, result)
            location = val[1].location + val[6].location
        result = Members::AttrWriter.new(name: val[3].value.to_sym,
                                         ivar_name: val[4],
                                         kind: val[2],
                                         type: val[6],
                                         annotations: val[0],
                                         location: location,
                                         comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 250)
  def _reduce_52(val, _values, result)
            location = val[1].location + val[4].location
        result = Members::AttrAccessor.new(name: val[3].value,
                                           ivar_name: nil,
                                           kind: val[2],
                                           type: val[4],
                                           annotations: val[0],
                                           location: location,
                                           comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 260)
  def _reduce_53(val, _values, result)
            location = val[1].location + val[6].location
        result = Members::AttrAccessor.new(name: val[3].value.to_sym,
                                           ivar_name: val[4],
                                           kind: val[2],
                                           type: val[6],
                                           annotations: val[0],
                                           location: location,
                                           comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 271)
  def _reduce_54(val, _values, result)
     result = nil
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 272)
  def _reduce_55(val, _values, result)
     result = false
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 273)
  def _reduce_56(val, _values, result)
     result = val[1].value
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 277)
  def _reduce_57(val, _values, result)
            location = val[0].location + val[2].location
        result = Members::InstanceVariable.new(
          name: val[0].value,
          type: val[2],
          location: location,
          comment: leading_comment(location)
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 286)
  def _reduce_58(val, _values, result)
            type = val[2]

        if type.is_a?(Types::Variable)
          type = Types::ClassInstance.new(
            name: TypeName.new(name: type.name, namespace: Namespace.empty),
            args: [],
            location: type.location
          )
        end

        location = val[0].location + val[2].location
        result = Members::ClassVariable.new(
          name: val[0].value,
          type: type,
          location: location,
          comment: leading_comment(location)
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 305)
  def _reduce_59(val, _values, result)
          type = val[4]

      if type.is_a?(Types::Variable)
        type = Types::ClassInstance.new(
          name: TypeName.new(name: type.name, namespace: Namespace.empty),
          args: [],
          location: type.location
        )
      end

      location = val[0].location + val[4].location
      result = Members::ClassInstanceVariable.new(
        name: val[2].value,
        type: type,
        location: location,
        comment: leading_comment(location)
      )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 326)
  def _reduce_60(val, _values, result)
            reset_variable_scope

        location = val[1].location + val[6].location
        result = Declarations::Interface.new(
          name: val[3].value,
          type_params: val[4]&.value || Declarations::ModuleTypeParams.empty,
          members: val[5],
          annotations: val[0],
          location: location,
          comment: leading_comment(val[0].first&.location || location)
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 340)
  def _reduce_61(val, _values, result)
     result = []
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 342)
  def _reduce_62(val, _values, result)
            result = val[0].push(val[1])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 347)
  def _reduce_63(val, _values, result)
            unless val[0].kind == :instance
          raise SemanticsError.new("Interface cannot have singleton method", subject: val[0], location: val[0].location)
        end

        if val[0].types.last == :super
          raise SemanticsError.new("Interface method cannot have `super` type", subject: val[0], location: val[0].location)
        end

        result = val[0]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 358)
  def _reduce_64(val, _values, result)
            unless val[0].name.interface?
          raise SemanticsError.new("Interface should include an interface", subject: val[0], location: val[0].location)
        end

        result = val[0]

    result
  end
.,.,

# reduce 65 omitted

module_eval(<<'.,.,', 'parser.y', 368)
  def _reduce_66(val, _values, result)
            if val[2].value.alias?
          raise SemanticsError.new("Should include module or interface", subject: val[2].value, location: val[2].location)
        end
        location = val[1].location + val[2].location
        result = Members::Include.new(name: val[2].value,
                                      args: [],
                                      annotations: val[0],
                                      location: location,
                                      comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 379)
  def _reduce_67(val, _values, result)
            if val[2].value.alias?
          raise SemanticsError.new("Should include module or interface", subject: val[2].value, location: val[2].location)
        end
        location = val[1].location + val[5].location
        result = Members::Include.new(name: val[2].value,
                                      args: val[4],
                                      annotations: val[0],
                                      location: location,
                                      comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 392)
  def _reduce_68(val, _values, result)
            if val[2].value.alias?
          raise SemanticsError.new("Should extend module or interface", subject: val[2].value, location: val[2].location)
        end
        location = val[1].location + val[2].location
        result = Members::Extend.new(name: val[2].value,
                                     args: [],
                                     annotations: val[0],
                                     location: location,
                                     comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 403)
  def _reduce_69(val, _values, result)
            if val[2].value.alias?
          raise SemanticsError.new("Should extend module or interface", subject: val[2].value, location: val[2].location)
        end
        location = val[1].location + val[5].location
        result = Members::Extend.new(name: val[2].value,
                                     args: val[4],
                                     annotations: val[0],
                                     location: location,
                                     comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 416)
  def _reduce_70(val, _values, result)
            unless val[2].value.class?
          raise SemanticsError.new("Should prepend module", subject: val[2].value, location: val[2].location)
        end
        location = val[1].location + val[2].location
        result = Members::Prepend.new(name: val[2].value,
                                      args: [],
                                      annotations: val[0],
                                      location: location,
                                      comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 427)
  def _reduce_71(val, _values, result)
            unless val[2].value.class?
          raise SemanticsError.new("Should prepend module", subject: val[2].value, location: val[2].location)
        end
        location = val[1].location + val[5].location
        result = Members::Prepend.new(name: val[2].value,
                                      args: val[4],
                                      annotations: val[0],
                                      location: location,
                                      comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 439)
  def _reduce_72(val, _values, result)
     result = nil
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 441)
  def _reduce_73(val, _values, result)
            RBS.logger.warn "`overload def` syntax is deprecated. Use `...` syntax instead."
        result = val[0]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 447)
  def _reduce_74(val, _values, result)
            location = val[3].location + val[6].last.location

        last_type = val[6].last
        if last_type.is_a?(LocatedValue) && last_type.value == :dot3
          overload = true
          val[6].pop
        else
          overload = false
        end

        result = Members::MethodDefinition.new(
          name: val[5].value,
          kind: val[4],
          types: val[6],
          annotations: val[0],
          location: location,
          comment: leading_comment(val[0].first&.location || val[2]&.location || val[3].location),
          overload: overload || !!val[2]
        )

    result
  end
.,.,

# reduce 75 omitted

module_eval(<<'.,.,', 'parser.y', 470)
  def _reduce_76(val, _values, result)
            RBS.logger.warn "`incompatible` method attribute is deprecated and ignored."

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 474)
  def _reduce_77(val, _values, result)
     result = :instance
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 475)
  def _reduce_78(val, _values, result)
     result = :singleton
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 476)
  def _reduce_79(val, _values, result)
     result = :singleton_instance
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 479)
  def _reduce_80(val, _values, result)
     result = [val[0]]
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 480)
  def _reduce_81(val, _values, result)
     result = [LocatedValue.new(value: :dot3, location: val[0].location)]
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 482)
  def _reduce_82(val, _values, result)
            result = val[2].unshift(val[0])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 487)
  def _reduce_83(val, _values, result)
            reset_variable_scope

        location = (val[1] || val[2]).location + val[2].location
        type_params = val[1]&.value || []

        type, block = val[2].value

        result = MethodType.new(type_params: type_params,
                                type: type,
                                block: block,
                                location: location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 501)
  def _reduce_84(val, _values, result)
     result = nil
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 503)
  def _reduce_85(val, _values, result)
            result = LocatedValue.new(value: val[1], location: val[0].location + val[2].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 508)
  def _reduce_86(val, _values, result)
            block = Types::Block.new(type: val[1].value, required: true)
        result = LocatedValue.new(value: block, location: val[0].location + val[2].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 512)
  def _reduce_87(val, _values, result)
            block = Types::Block.new(type: val[2].value, required: false)
        result = LocatedValue.new(value: block, location: val[0].location + val[3].location)

    result
  end
.,.,

# reduce 88 omitted

module_eval(<<'.,.,', 'parser.y', 519)
  def _reduce_89(val, _values, result)
            result = LocatedValue.new(value: val[0].value.to_sym,
                                  location: val[0].location + val[1].location)

    result
  end
.,.,

# reduce 90 omitted

# reduce 91 omitted

# reduce 92 omitted

# reduce 93 omitted

# reduce 94 omitted

# reduce 95 omitted

# reduce 96 omitted

# reduce 97 omitted

# reduce 98 omitted

module_eval(<<'.,.,', 'parser.y', 528)
  def _reduce_99(val, _values, result)
            unless val[0].location.pred?(val[1].location)
          raise SyntaxError.new(token_str: "kQUESTION", error_value: val[1])
        end

        result = LocatedValue.new(value: "#{val[0].value}?",
                                  location: val[0].location + val[1].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 536)
  def _reduce_100(val, _values, result)
            unless val[0].location.pred?(val[1].location)
          raise SyntaxError.new(token_str: "kEXCLAMATION", error_value: val[1])
        end

        result = LocatedValue.new(value: "#{val[0].value}!",
                                  location: val[0].location + val[1].location)

    result
  end
.,.,

# reduce 101 omitted

# reduce 102 omitted

# reduce 103 omitted

# reduce 104 omitted

# reduce 105 omitted

# reduce 106 omitted

# reduce 107 omitted

# reduce 108 omitted

# reduce 109 omitted

# reduce 110 omitted

# reduce 111 omitted

# reduce 112 omitted

# reduce 113 omitted

# reduce 114 omitted

# reduce 115 omitted

# reduce 116 omitted

# reduce 117 omitted

# reduce 118 omitted

# reduce 119 omitted

# reduce 120 omitted

# reduce 121 omitted

# reduce 122 omitted

# reduce 123 omitted

# reduce 124 omitted

# reduce 125 omitted

# reduce 126 omitted

# reduce 127 omitted

# reduce 128 omitted

# reduce 129 omitted

# reduce 130 omitted

# reduce 131 omitted

# reduce 132 omitted

# reduce 133 omitted

# reduce 134 omitted

# reduce 135 omitted

# reduce 136 omitted

# reduce 137 omitted

# reduce 138 omitted

# reduce 139 omitted

# reduce 140 omitted

module_eval(<<'.,.,', 'parser.y', 556)
  def _reduce_141(val, _values, result)
     result = nil
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 558)
  def _reduce_142(val, _values, result)
            val[1].each {|p| insert_bound_variable(p.name) }

        result = LocatedValue.new(value: val[1], location: val[0].location + val[2].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 565)
  def _reduce_143(val, _values, result)
            result = Declarations::ModuleTypeParams.new()
        result.add(val[0])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 569)
  def _reduce_144(val, _values, result)
            result = val[0].add(val[2])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 574)
  def _reduce_145(val, _values, result)
            result = Declarations::ModuleTypeParams::TypeParam.new(name: val[2].value.to_sym,
                                                               variance: val[1],
                                                               skip_validation: val[0])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 580)
  def _reduce_146(val, _values, result)
     result = :invariant
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 581)
  def _reduce_147(val, _values, result)
     result = :covariant
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 582)
  def _reduce_148(val, _values, result)
     result = :contravariant
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 585)
  def _reduce_149(val, _values, result)
     result = false
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 586)
  def _reduce_150(val, _values, result)
     result = true
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 589)
  def _reduce_151(val, _values, result)
     result = nil
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 591)
  def _reduce_152(val, _values, result)
            val[1].each {|var| insert_bound_variable(var) }

        result = LocatedValue.new(value: val[1],
                                  location: val[0].location + val[2].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 599)
  def _reduce_153(val, _values, result)
            result = [val[0].value.to_sym]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 602)
  def _reduce_154(val, _values, result)
            result = val[0].push(val[2].value.to_sym)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 607)
  def _reduce_155(val, _values, result)
            location = val[1].location + val[3].location
        result = Members::Alias.new(
          new_name: val[2].value.to_sym,
          old_name: val[3].value.to_sym,
          kind: :instance,
          annotations: val[0],
          location: location,
          comment: leading_comment(val[0].first&.location || location)
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 618)
  def _reduce_156(val, _values, result)
            location = val[1].location + val[7].location
        result = Members::Alias.new(
          new_name: val[4].value.to_sym,
          old_name: val[7].value.to_sym,
          kind: :singleton,
          annotations: val[0],
          location: location,
          comment: leading_comment(val[0].first&.location || location)
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 631)
  def _reduce_157(val, _values, result)
            location = val[1].location + val[4].location
        result = Declarations::Alias.new(name: val[2].value,
                                         type: val[4],
                                         annotations: val[0],
                                         location: location,
                                         comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 641)
  def _reduce_158(val, _values, result)
            location = val[0].location + val[2].location
        result = Declarations::Constant.new(name: val[0].value,
                                            type: val[2],
                                            location: location,
                                            comment: leading_comment(location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 648)
  def _reduce_159(val, _values, result)
            location = (val[0] || val[1]).location + val[2].location
        name = TypeName.new(name: val[1].value, namespace: val[0]&.value || Namespace.empty)
        result = Declarations::Constant.new(name: name,
                                            type: val[2],
                                            location: location,
                                            comment: leading_comment(location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 658)
  def _reduce_160(val, _values, result)
            location = val[0].location + val[2].location
        result = Declarations::Global.new(name: val[0].value.to_sym,
                                          type: val[2],
                                          location: location,
                                          comment: leading_comment(location))

    result
  end
.,.,

# reduce 161 omitted

module_eval(<<'.,.,', 'parser.y', 668)
  def _reduce_162(val, _values, result)
            types = case l = val[0]
                when Types::Union
                  l.types + [val[2]]
                else
                  [l, val[2]]
                end

        result = Types::Union.new(types: types, location: val[0].location + val[2].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 678)
  def _reduce_163(val, _values, result)
            types = case l = val[0]
                when Types::Intersection
                  l.types + [val[2]]
                else
                  [l, val[2]]
                end

        result = Types::Intersection.new(types: types,
                                         location: val[0].location + val[2].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 691)
  def _reduce_164(val, _values, result)
            result = Types::Bases::Void.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 694)
  def _reduce_165(val, _values, result)
            RBS.logger.warn "`any` type is deprecated. Use `untyped` instead. (#{val[0].location.to_s})"
        result = Types::Bases::Any.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 698)
  def _reduce_166(val, _values, result)
            result = Types::Bases::Any.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 701)
  def _reduce_167(val, _values, result)
            result = Types::Bases::Bool.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 704)
  def _reduce_168(val, _values, result)
            result = Types::Bases::Nil.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 707)
  def _reduce_169(val, _values, result)
            result = Types::Bases::Top.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 710)
  def _reduce_170(val, _values, result)
            result = Types::Bases::Bottom.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 713)
  def _reduce_171(val, _values, result)
            result = Types::Bases::Self.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 716)
  def _reduce_172(val, _values, result)
            result = Types::Optional.new(type: Types::Bases::Self.new(location: val[0].location),
                                     location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 720)
  def _reduce_173(val, _values, result)
            result = Types::Bases::Instance.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 723)
  def _reduce_174(val, _values, result)
            result = Types::Bases::Class.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 726)
  def _reduce_175(val, _values, result)
            result = Types::Literal.new(literal: true, location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 729)
  def _reduce_176(val, _values, result)
            result = Types::Literal.new(literal: false, location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 732)
  def _reduce_177(val, _values, result)
            result = Types::Literal.new(literal: val[0].value, location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 735)
  def _reduce_178(val, _values, result)
            result = Types::Literal.new(literal: val[0].value, location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 738)
  def _reduce_179(val, _values, result)
            result = Types::Literal.new(literal: val[0].value, location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 741)
  def _reduce_180(val, _values, result)
            name = val[0].value
        args = []
        location = val[0].location

        case
        when name.class?
          if is_bound_variable?(name.name)
            result = Types::Variable.new(name: name.name, location: location)
          else
            result = Types::ClassInstance.new(name: name, args: args, location: location)
          end
        when name.alias?
          result = Types::Alias.new(name: name, location: location)
        when name.interface?
          result = Types::Interface.new(name: name, args: args, location: location)
        end

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 759)
  def _reduce_181(val, _values, result)
            name = val[0].value
        args = val[2]
        location = val[0].location + val[3].location

        case
        when name.class?
          if is_bound_variable?(name.name)
            raise SemanticsError.new("#{name.name} is type variable and cannot be applied", subject: name, location: location)
          end
          result = Types::ClassInstance.new(name: name, args: args, location: location)
        when name.interface?
          result = Types::Interface.new(name: name, args: args, location: location)
        else
          raise SyntaxError.new(token_str: "kLBRACKET", error_value: val[1])
        end

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 776)
  def _reduce_182(val, _values, result)
            location = val[0].location + val[1].location
        result = Types::Tuple.new(types: [], location: location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 780)
  def _reduce_183(val, _values, result)
            location = val[0].location + val[2].location
        types = val[1]
        result = Types::Tuple.new(types: types, location: location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 785)
  def _reduce_184(val, _values, result)
            type = val[1].dup
        type.instance_eval do
          @location = val[0].location + val[2].location
        end
        result = type

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 792)
  def _reduce_185(val, _values, result)
            result = Types::ClassSingleton.new(name: val[2].value,
                                           location: val[0].location + val[3].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 796)
  def _reduce_186(val, _values, result)
            type, block = val[1].value
        result = Types::Proc.new(type: type, block: block, location: val[0].location + val[1].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 800)
  def _reduce_187(val, _values, result)
            result = Types::Optional.new(type: val[0], location: val[0].location + val[1].location)

    result
  end
.,.,

# reduce 188 omitted

module_eval(<<'.,.,', 'parser.y', 806)
  def _reduce_189(val, _values, result)
            result = [val[0]]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 809)
  def _reduce_190(val, _values, result)
            result = val[0] + [val[2]]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 814)
  def _reduce_191(val, _values, result)
            result = Types::Record.new(
          fields: val[1],
          location: val[0].location + val[2].location
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 822)
  def _reduce_192(val, _values, result)
            result = val[0]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 825)
  def _reduce_193(val, _values, result)
            result = val[0].merge!(val[2])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 830)
  def _reduce_194(val, _values, result)
            result = { val[0].value => val[2] }

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 833)
  def _reduce_195(val, _values, result)
            result = { val[0].value => val[2] }

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 836)
  def _reduce_196(val, _values, result)
            result = { val[0].value => val[2] }

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 839)
  def _reduce_197(val, _values, result)
            result = { val[0].value => val[1] }

    result
  end
.,.,

# reduce 198 omitted

module_eval(<<'.,.,', 'parser.y', 845)
  def _reduce_199(val, _values, result)
            result = val[0]

    result
  end
.,.,

# reduce 200 omitted

# reduce 201 omitted

# reduce 202 omitted

# reduce 203 omitted

module_eval(<<'.,.,', 'parser.y', 852)
  def _reduce_204(val, _values, result)
            location = (val[0] || val[1] || val[2]).location + val[3].location

        params = val[0]&.value || [[], [], nil, [], {}, {}, nil]

        type = Types::Function.new(
          required_positionals: params[0],
          optional_positionals: params[1],
          rest_positionals: params[2],
          trailing_positionals: params[3],
          required_keywords: params[4],
          optional_keywords: params[5],
          rest_keywords: params[6],
          return_type: val[3]
        )

        block = val[1].value

        result = LocatedValue.new(value: [type, block], location: location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 872)
  def _reduce_205(val, _values, result)
            result = LocatedValue.new(value: [val[0].value, nil], location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 877)
  def _reduce_206(val, _values, result)
            location = val[0].location + val[4].location
        type = Types::Function.new(
          required_positionals: val[1][0],
          optional_positionals: val[1][1],
          rest_positionals: val[1][2],
          trailing_positionals: val[1][3],
          required_keywords: val[1][4],
          optional_keywords: val[1][5],
          rest_keywords: val[1][6],
          return_type: val[4],
        )

        result = LocatedValue.new(value: type, location: location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 892)
  def _reduce_207(val, _values, result)
            location = val[0].location + val[1].location
        type = Types::Function.new(
          required_positionals: [],
          optional_positionals: [],
          rest_positionals: nil,
          trailing_positionals: [],
          required_keywords: {},
          optional_keywords: {},
          rest_keywords: nil,
          return_type: val[1]
        )

        result = LocatedValue.new(value: type, location: location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 909)
  def _reduce_208(val, _values, result)
            result = val[2]
        result[0].unshift(val[0])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 913)
  def _reduce_209(val, _values, result)
            result = empty_params_result
        result[0].unshift(val[0])

    result
  end
.,.,

# reduce 210 omitted

module_eval(<<'.,.,', 'parser.y', 920)
  def _reduce_211(val, _values, result)
            result = val[2]
        result[1].unshift(val[0])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 924)
  def _reduce_212(val, _values, result)
            result = empty_params_result
        result[1].unshift(val[0])

    result
  end
.,.,

# reduce 213 omitted

module_eval(<<'.,.,', 'parser.y', 931)
  def _reduce_214(val, _values, result)
            result = val[2]
        result[2] = val[0]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 935)
  def _reduce_215(val, _values, result)
            result = empty_params_result
        result[2] = val[0]

    result
  end
.,.,

# reduce 216 omitted

module_eval(<<'.,.,', 'parser.y', 942)
  def _reduce_217(val, _values, result)
            result = val[2]
        result[3].unshift(val[0])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 946)
  def _reduce_218(val, _values, result)
            result = empty_params_result
        result[3].unshift(val[0])

    result
  end
.,.,

# reduce 219 omitted

module_eval(<<'.,.,', 'parser.y', 953)
  def _reduce_220(val, _values, result)
            result = empty_params_result

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 956)
  def _reduce_221(val, _values, result)
            result = val[2]
        result[4].merge!(val[0])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 960)
  def _reduce_222(val, _values, result)
            result = empty_params_result
        result[4].merge!(val[0])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 964)
  def _reduce_223(val, _values, result)
            result = val[2]
        result[5].merge!(val[0])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 968)
  def _reduce_224(val, _values, result)
            result = empty_params_result
        result[5].merge!(val[0])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 972)
  def _reduce_225(val, _values, result)
            result = empty_params_result
        result[6] = val[0]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 978)
  def _reduce_226(val, _values, result)
            result = Types::Function::Param.new(type: val[0],
                                            name: val[1]&.value&.to_sym)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 984)
  def _reduce_227(val, _values, result)
            result = Types::Function::Param.new(type: val[1],
                                            name: val[2]&.value&.to_sym)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 990)
  def _reduce_228(val, _values, result)
            result = Types::Function::Param.new(type: val[1],
                                            name: val[2]&.value&.to_sym)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 996)
  def _reduce_229(val, _values, result)
            param = Types::Function::Param.new(type: val[1],
                                           name: val[2]&.value&.to_sym)
        result = { val[0].value => param }

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1003)
  def _reduce_230(val, _values, result)
            param = Types::Function::Param.new(type: val[2],
                                           name: val[3]&.value&.to_sym)
        result = { val[1].value => param }

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1010)
  def _reduce_231(val, _values, result)
            result = Types::Function::Param.new(type: val[1],
                                            name: val[2]&.value&.to_sym)

    result
  end
.,.,

# reduce 232 omitted

# reduce 233 omitted

# reduce 234 omitted

# reduce 235 omitted

module_eval(<<'.,.,', 'parser.y', 1019)
  def _reduce_236(val, _values, result)
            namespace = val[0]&.value || Namespace.empty
        name = val[1].value.to_sym
        type_name = TypeName.new(namespace: namespace, name: name)
        location = (loc0 = val[0]&.location) ? loc0 + val[1].location : val[1].location
        result = LocatedValue.new(value: type_name, location: location)

    result
  end
.,.,

# reduce 237 omitted

# reduce 238 omitted

# reduce 239 omitted

module_eval(<<'.,.,', 'parser.y', 1031)
  def _reduce_240(val, _values, result)
            namespace = val[0]&.value || Namespace.empty
        name = val[1].value.to_sym
        type_name = TypeName.new(namespace: namespace, name: name)
        location = (loc0 = val[0]&.location) ? loc0 + val[1].location : val[1].location
        result = LocatedValue.new(value: type_name, location: location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1040)
  def _reduce_241(val, _values, result)
            namespace = val[0]&.value || Namespace.empty
        name = val[1].value.to_sym
        type_name = TypeName.new(namespace: namespace, name: name)
        location = (loc0 = val[0]&.location) ? loc0 + val[1].location : val[1].location
        result = LocatedValue.new(value: type_name, location: location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1049)
  def _reduce_242(val, _values, result)
            result = nil

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1052)
  def _reduce_243(val, _values, result)
            result = LocatedValue.new(value: Namespace.root, location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1055)
  def _reduce_244(val, _values, result)
            namespace = Namespace.parse(val[1].value).absolute!
        result = LocatedValue.new(value: namespace, location: val[0].location + val[1].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1059)
  def _reduce_245(val, _values, result)
            namespace = Namespace.parse(val[0].value)
        result = LocatedValue.new(value: namespace, location: val[0].location)

    result
  end
.,.,

def _reduce_none(val, _values, result)
  val[0]
end

  end   # class Parser
end   # module RBS


