#
# DO NOT MODIFY!!!!
# This file is automatically generated by Racc 1.5.1
# from Racc grammar file "".
#

require 'racc/parser.rb'
module RBS
  class Parser < Racc::Parser

module_eval(<<'...end parser.y/module_eval...', 'parser.y', 1077)

Types = RBS::Types
Namespace = RBS::Namespace
TypeName = RBS::TypeName
Declarations = RBS::AST::Declarations
Members = RBS::AST::Members
MethodType = RBS::MethodType
Annotation = RBS::AST::Annotation

class LocatedValue
  attr_reader :location
  attr_reader :value

  def initialize(location:, value:)
    @location = location
    @value = value
  end
end

require "strscan"

attr_reader :input
attr_reader :buffer
attr_reader :eof_re

def initialize(type, buffer:, eof_re:)
  super()
  @type = type
  @buffer = buffer
  @input = StringScanner.new(buffer.content)
  @eof_re = eof_re
  @eof = false
  @bound_variables_stack = []
  @comments = {}
  @ascii_only = buffer.content.ascii_only?
end

def start_merged_variables_scope
  set = @bound_variables_stack.last&.dup || Set.new
  @bound_variables_stack.push set
end

def start_new_variables_scope
  @bound_variables_stack.push Set.new
end

def reset_variable_scope
  @bound_variables_stack.pop
end

def insert_bound_variable(var)
  @bound_variables_stack.last << var
end

def is_bound_variable?(var)
  (@bound_variables_stack.last || Set.new).member?(var)
end

def self.parse_signature(input, eof_re: nil)
  case input
  when RBS::Buffer
    buffer = input
  else
    buffer = RBS::Buffer.new(name: nil, content: input.to_s)
  end

  self.new(:SIGNATURE, buffer: buffer, eof_re: eof_re).do_parse
end

def self.parse_type(input, variables: [], eof_re: nil)
  case input
  when RBS::Buffer
    buffer = input
  else
    buffer = RBS::Buffer.new(name: nil, content: input.to_s)
  end

  self.new(:TYPE, buffer: buffer, eof_re: eof_re).yield_self do |parser|
    parser.start_new_variables_scope

    variables.each do |var|
      parser.insert_bound_variable var
    end

    parser.do_parse
  ensure
    parser.reset_variable_scope
  end
end

def self.parse_method_type(input, variables: [], eof_re: nil)
  case input
  when RBS::Buffer
    buffer = input
  else
    buffer = RBS::Buffer.new(name: nil, content: input.to_s)
  end

  self.new(:METHODTYPE, buffer: buffer, eof_re: eof_re).yield_self do |parser|
    parser.start_new_variables_scope

    variables.each do |var|
      parser.insert_bound_variable var
    end

    parser.do_parse
  ensure
    parser.reset_variable_scope
  end
end

def leading_comment(location)
  @comments[location.start_line-1]
end

def push_comment(string, location)
  if (comment = leading_comment(location)) && comment.location.start_column == location.start_column
    comment.concat(string: "#{string}\n", location: location)
    @comments[comment.location.end_line] = comment
  else
    new_comment = AST::Comment.new(string: "#{string}\n", location: location)
    @comments[new_comment.location.end_line] = new_comment
  end
end

def new_token(type, value = input.matched)
  charpos = charpos(input)
  matched = input.matched

  if matched
    start_index = charpos - matched.size
    end_index = charpos

    location = RBS::Location.new(buffer: buffer,
                                 start_pos: start_index,
                                 end_pos: end_index)

    [type, LocatedValue.new(location: location, value: value)]
  else
    # scanner hasn't matched yet
    [false, nil]
  end
end

def charpos(scanner)
  if @ascii_only
    scanner.pos
  else
    scanner.charpos
  end
end

def empty_params_result
  [
    [],
    [],
    nil,
    [],
    {},
    {},
    nil
  ]
end

KEYWORDS = {
  "class" => :kCLASS,
  "type" => :kTYPE,
  "def" => :kDEF,
  "self" => :kSELF,
  "void" => :kVOID,
  "any" => :kANY,
  "untyped" => :kUNTYPED,
  "top" => :kTOP,
  "bot" => :kBOT,
  "instance" => :kINSTANCE,
  "bool" => :kBOOL,
  "nil" => :kNIL,
  "true" => :kTRUE,
  "false" => :kFALSE,
  "singleton" => :kSINGLETON,
  "interface" => :kINTERFACE,
  "end" => :kEND,
  "include" => :kINCLUDE,
  "extend" => :kEXTEND,
  "prepend" => :kPREPEND,
  "module" => :kMODULE,
  "attr_reader" => :kATTRREADER,
  "attr_writer" => :kATTRWRITER,
  "attr_accessor" => :kATTRACCESSOR,
  "public" => :kPUBLIC,
  "private" => :kPRIVATE,
  "alias" => :kALIAS,
  "extension" => :kEXTENSION,
  "incompatible" => :kINCOMPATIBLE,
  "unchecked" => :kUNCHECKED,
  "overload" => :kOVERLOAD,
  "out" => :kOUT,
  "in" => :kIN,
}
KEYWORDS_RE = /#{Regexp.union(*KEYWORDS.keys)}\b/

PUNCTS = {
  "===" => :tOPERATOR,
  "==" => :tOPERATOR,
  "=~" => :tOPERATOR,
  "!~" => :tOPERATOR,
  "!=" => :tOPERATOR,
  ">=" => :tOPERATOR,
  "<<" => :tOPERATOR,
  "<=>" => :tOPERATOR,
  "<=" => :tOPERATOR,
  ">>" => :tOPERATOR,
  ">" => :tOPERATOR,
  "~" => :tOPERATOR,
  "+@" => :tOPERATOR,
  "+" => :tOPERATOR,
  "[]=" => :tOPERATOR,
  "[]" => :tOPERATOR,
  "::" => :kCOLON2,
  ":" => :kCOLON,
  "(" => :kLPAREN,
  ")" => :kRPAREN,
  "[" => :kLBRACKET,
  "]" => :kRBRACKET,
  "{" => :kLBRACE,
  "}" => :kRBRACE,
  "," => :kCOMMA,
  "|" => :kBAR,
  "&" => :kAMP,
  "^" => :kHAT,
  "->" => :kARROW,
  "=>" => :kFATARROW,
  "=" => :kEQ,
  "?" => :kQUESTION,
  "!" => :kEXCLAMATION,
  "**" => :kSTAR2,
  "*" => :kSTAR,
  "..." => :kDOT3,
  "." => :kDOT,
  "<" => :kLT,
  "-@" => :tOPERATOR,
  "-" => :tOPERATOR,
  "/" => :tOPERATOR,
  "`" => :tOPERATOR,
  "%" => :tOPERATOR,
}
PUNCTS_RE = Regexp.union(*PUNCTS.keys)

ANNOTATION_RE = Regexp.union(/%a\{.*?\}/,
                             /%a\[.*?\]/,
                             /%a\(.*?\)/,
                             /%a\<.*?\>/,
                             /%a\|.*?\|/)

escape_sequences = %w[a b e f n r s t v "].map { |l| "\\\\#{l}" }
DBL_QUOTE_STR_ESCAPE_SEQUENCES_RE = /(#{escape_sequences.join("|")})/

def next_token
  if @type
    type = @type
    @type = nil
    return [:"type_#{type}", nil]
  end

  return new_token(false, '') if @eof

  while true
    return new_token(false, '') if input.eos?

    case
    when input.scan(/\s+/)
      # skip
    when input.scan(/#(( *)|( ?(?<string>.*)))\n/)
      charpos = charpos(input)
      start_index = charpos - input.matched.size
      end_index = charpos-1

      location = RBS::Location.new(buffer: buffer,
                                               start_pos: start_index,
                                               end_pos: end_index)

      push_comment input[:string] || "", location
    else
      break
    end
  end

  case
  when eof_re && input.scan(eof_re)
    @eof = true
    [:tEOF, input.matched]
  when input.scan(/`[a-zA-Z_]\w*`/)
    s = input.matched.yield_self {|s| s[1, s.length-2] }
    new_token(:tQUOTEDIDENT, s)
  when input.scan(/`(\\`|[^` :])+`/)
    s = input.matched.yield_self {|s| s[1, s.length-2] }.gsub(/\\`/, '`')
    new_token(:tQUOTEDMETHOD, s)
  when input.scan(ANNOTATION_RE)
    s = input.matched.yield_self {|s| s[3, s.length-4] }.strip
    new_token(:tANNOTATION, s)
  when input.scan(/self\?/)
    new_token(:kSELFQ, "self?")
  when input.scan(/(([a-zA-Z]\w*)|(_\w+))=/)
    new_token(:tWRITE_ATTR)
  when input.scan(KEYWORDS_RE)
    new_token(KEYWORDS[input.matched], input.matched.to_sym)
  when input.scan(/:((@{,2}|\$)?\w+(\?|\!)?|\+|\-)\b?/)
    s = input.matched.yield_self {|s| s[1, s.length] }.to_sym
    new_token(:tSYMBOL, s)
  when input.scan(/[+-]?\d[\d_]*/)
    new_token(:tINTEGER, input.matched.to_i)
  when input.scan(PUNCTS_RE)
    new_token(PUNCTS[input.matched])
  when input.scan(/(::)?([A-Z]\w*::)+/)
    new_token(:tNAMESPACE)
  when input.scan(/[a-z_]\w*:/)
    new_token(:tLKEYWORD, input.matched.chop.to_sym)
  when input.scan(/[a-z_]\w*[?!]:/)
    new_token(:tLKEYWORD_Q_E, input.matched.chop.to_sym)
  when input.scan(/[A-Z]\w*:/)
    new_token(:tUKEYWORD, input.matched.chop.to_sym)
  when input.scan(/[A-Z]\w*[?!]:/)
    new_token(:tUKEYWORD_Q_E, input.matched.chop.to_sym)
  when input.scan(/\$[A-Za-z_]\w*/)
    new_token(:tGLOBALIDENT)
  when input.scan(/@[a-zA-Z_]\w*/)
    new_token(:tIVAR, input.matched.to_sym)
  when input.scan(/@@[a-zA-Z_]\w*/)
    new_token(:tCLASSVAR, input.matched.to_sym)
  when input.scan(/_[a-zA-Z]\w*\b/)
    new_token(:tINTERFACEIDENT)
  when input.scan(/[A-Z]\w*\b/)
    new_token(:tUIDENT)
  when input.scan(/[a-z_]\w*\b/)
    new_token(:tLIDENT)
  when input.scan(/"(\\"|[^"])*"/)
    s = input.matched.yield_self {|s| s[1, s.length - 2] }
                     .gsub(DBL_QUOTE_STR_ESCAPE_SEQUENCES_RE) do |match|
                       case match
                       when '\\a' then "\a"
                       when '\\b' then "\b"
                       when '\\e' then "\e"
                       when '\\f' then "\f"
                       when '\\n' then "\n"
                       when '\\r' then "\r"
                       when '\\s' then "\s"
                       when '\\t' then "\t"
                       when '\\v' then "\v"
                       when '\\"' then '"'
                       end
                     end
    new_token(:tSTRING, s)
  when input.scan(/'(\\'|[^'])*'/)
    s = input.matched.yield_self {|s| s[1, s.length - 2] }.gsub(/\\'/, "'")
    new_token(:tSTRING, s)
  else
    raise "Unexpected token: #{input.peek(10)}..."
  end
end

def on_error(token_id, error_value, value_stack)
  raise SyntaxError.new(token_str: token_to_str(token_id), error_value: error_value, value_stack: value_stack)
end

class SyntaxError < StandardError
  attr_reader :token_str, :error_value, :value_stack

  def initialize(token_str:, error_value:, value_stack: nil)
    @token_str = token_str
    @error_value = error_value
    @value_stack = value_stack

    super "parse error on value: #{error_value.inspect} (#{token_str})"
  end
end

class SemanticsError < StandardError
  attr_reader :subject, :location, :original_message

  def initialize(message, subject:, location:)
    @subject = subject
    @location = location
    @original_message = message

    super "parse error on #{location}: #{message}"
  end
end

...end parser.y/module_eval...
##### State transition tables begin ###

clist = [
'360,361,33,362,182,114,5,33,33,347,181,404,49,33,33,359,37,345,248,403',
'40,41,55,56,57,58,59,60,61,62,364,33,63,54,64,65,66,77,67,68,69,83,33',
'32,53,355,349,350,32,32,353,351,354,312,32,32,33,352,82,70,71,72,74',
'76,75,348,357,358,73,78,80,127,32,125,42,84,85,81,86,360,361,33,362',
'32,96,97,98,99,43,49,48,33,33,33,359,207,207,32,126,40,41,55,56,57,58',
'59,60,61,62,79,33,63,54,64,65,66,77,67,68,69,83,53,32,161,355,349,350',
'53,53,353,351,354,32,32,32,187,352,82,70,71,72,74,76,75,348,357,358',
'73,78,80,225,32,162,287,84,85,81,86,360,361,126,362,104,96,97,98,99',
'101,102,39,103,40,41,359,121,226,335,370,288,165,55,56,57,58,59,60,61',
'62,79,407,63,54,64,65,66,77,67,68,69,83,39,126,126,355,349,350,408,409',
'353,351,354,331,40,41,126,352,82,70,71,72,74,76,75,348,357,358,73,78',
'80,166,327,126,126,84,85,81,86,360,361,167,362,168,96,97,98,99,2,3,4',
'40,41,169,359,40,41,40,41,40,41,55,56,57,58,59,60,61,62,79,171,63,54',
'64,65,66,77,67,68,69,83,40,41,172,355,349,350,40,41,353,351,354,40,41',
'40,41,352,82,70,71,72,74,76,75,348,357,358,73,78,80,360,361,173,362',
'84,85,81,86,-4,114,-245,180,33,183,118,359,-245,40,41,40,41,114,55,56',
'57,58,59,60,61,62,79,186,63,54,64,65,66,77,67,68,69,83,40,41,41,355',
'349,350,283,284,353,351,354,32,290,291,189,352,82,70,71,72,74,76,75',
'348,357,358,73,78,80,360,361,182,362,84,85,81,86,382,383,40,41,190,39',
'-108,359,40,41,398,399,40,41,55,56,57,58,59,60,61,62,79,-109,63,54,64',
'65,66,77,67,68,69,83,40,41,-110,355,349,350,40,41,353,351,354,40,41',
'40,41,352,82,70,71,72,74,76,75,348,357,358,73,78,80,40,41,40,41,84,85',
'81,86,360,361,-111,362,-112,96,97,98,99,-113,-114,-115,-116,-117,-118',
'359,48,-133,195,196,197,198,55,56,57,58,59,60,61,62,79,199,63,54,64',
'65,66,77,67,68,69,83,200,208,209,355,349,350,42,227,353,351,354,241',
'251,252,254,352,82,70,71,72,74,76,75,348,357,358,73,78,80,360,361,256',
'362,84,85,81,86,257,42,121,260,260,260,266,359,42,227,269,271,275,277',
'55,56,57,58,59,60,61,62,79,279,63,54,64,65,66,77,67,68,69,83,280,318',
'320,355,349,350,275,322,353,351,354,279,332,333,334,352,82,70,71,72',
'74,76,75,348,357,358,73,78,80,338,338,338,368,84,85,81,86,33,371,378',
'96,97,98,99,379,380,381,22,23,21,384,26,-223,25,386,30,389,132,133,134',
'135,136,137,138,139,143,16,140,131,141,142,66,77,67,68,69,83,389,32',
'389,402,405,28,406,157,413,158,160,414,415,417,422,423,82,70,71,72,74',
'76,75,424,425,422,73,78,80,,,,,84,85,81,86,33,,,96,97,98,99,,,,22,23',
'21,,26,,25,,30,,132,133,134,135,136,137,138,139,143,16,140,131,141,142',
'66,77,67,68,69,83,,32,,,,28,,,,,,,,,,,82,70,71,72,74,76,75,,,,73,78',
'80,,,,,84,85,81,86,33,,,96,97,98,99,,,,22,23,21,,26,-223,25,,30,,132',
'133,134,135,136,137,138,139,143,16,140,131,141,142,66,77,67,68,69,83',
',32,,,,28,,157,,158,160,,,,,,82,70,71,72,74,76,75,,,,73,78,80,,,,,84',
'85,81,86,33,,,96,97,98,99,,,,22,23,21,,26,-223,25,,30,,132,133,134,135',
'136,137,138,139,143,16,140,131,141,142,66,77,67,68,69,83,,32,,,,28,',
'157,,158,160,,,,,,82,70,71,72,74,76,75,,,,73,78,80,,,,,84,85,81,86,33',
',,96,97,98,99,,,,22,23,21,,26,-223,25,,30,,132,133,134,135,136,137,138',
'139,143,16,140,131,141,142,66,77,67,68,69,83,,32,,,,28,,233,,,160,,',
',,,82,70,71,72,74,76,75,,,,73,78,80,,,,,84,85,81,86,33,,,96,97,98,99',
',,,22,23,21,,26,-223,25,,30,,132,133,134,135,136,137,138,139,143,16',
'140,131,141,142,66,77,67,68,69,83,,32,,,,28,,157,,158,160,,,,,,82,70',
'71,72,74,76,75,,,,73,78,80,,,,,84,85,81,86,33,,,96,97,98,99,,,,22,23',
'21,,26,-223,25,,30,,132,133,134,135,136,137,138,139,143,16,140,131,141',
'142,66,77,67,68,69,83,,32,,,,28,176,233,,179,160,177,,,,,82,70,71,72',
'74,76,75,,,,73,78,80,,,178,,84,85,81,86,96,97,98,99,,175,,90,89,91,',
',,,,,,55,56,57,58,59,60,61,62,79,,63,54,64,65,66,77,67,68,69,83,,,,',
',,,,192,,193,,,,,,82,70,71,72,74,76,75,,95,94,73,78,80,,,,,84,85,81',
'86,96,97,98,99,,,,90,89,91,,,,,,40,41,55,56,57,58,59,60,61,62,79,,63',
'54,64,65,66,77,67,68,69,83,194,,,,,,,,,,,,,,,,82,70,71,72,74,76,75,',
'95,94,73,78,80,96,97,98,99,84,85,81,86,,,,,,,,,,55,56,57,58,59,60,61',
'62,79,,63,54,64,65,66,77,67,68,69,83,192,,193,,,,,233,,,160,,,,,,82',
'70,71,72,74,76,75,192,,193,73,78,80,96,97,98,99,84,85,81,86,,,,,,,,40',
'41,55,56,57,58,59,60,61,62,79,,63,54,64,65,66,77,67,68,69,83,194,40',
'41,,,,,233,,,160,,,,,,82,70,71,72,74,76,75,194,,,73,78,80,96,97,98,99',
'84,85,81,86,,,,,,,,,,55,56,57,58,59,60,61,62,79,,63,54,64,65,66,77,67',
'68,69,83,192,,193,192,,193,192,,193,,,,,,,,82,70,71,72,74,76,75,,,,73',
'78,80,,,,,84,85,81,86,,,,,,,,40,41,,40,41,,40,41,-245,,33,,118,,-245',
',,307,308,114,,,194,,,194,,,194,,-245,,33,,118,,-245,,309,307,308,114',
',,,,,304,303,,,32,-245,,33,,118,,-245,,309,307,308,114,,,,295,,304,303',
',,32,-245,,33,,118,,-245,,309,307,308,114,,,,319,,304,303,,,32,,,,,',
',,,309,,,,,,,323,,304,303,,33,32,,,,,,,,,22,23,21,,26,,25,369,30,,8',
'12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26',
',25,45,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28',
'22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,',
',,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18',
'11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14',
'15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20',
'9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30',
',8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21',
',26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,',
'28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33',
',,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18',
'11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14',
'15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20',
'9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30',
',8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21',
',26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,',
'28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33',
',,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18',
'11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14',
'15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20',
'9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30',
',8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21',
',26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,',
'28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33',
',,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18',
'11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14',
'15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20',
'9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30',
',8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21',
',26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,',
'28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33',
',,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18',
'11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14',
'15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20',
'9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30',
',8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21',
',26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,',
'28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33',
',,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18',
'11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14',
'15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20',
'9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30',
',8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21',
',26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,',
'28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,176',
',,179,,177,,32,331,,,28,,,,,,,,,,,,,,178,,327,328,324,325,326,,,,329',
'175' ]
        racc_action_table = arr = ::Array.new(3055, nil)
        idx = 0
        clist.each do |str|
          str.split(',', -1).each do |i|
            arr[idx] = i.to_i unless i.empty?
            idx += 1
          end
        end

clist = [
'331,331,48,331,117,281,1,179,217,330,117,389,28,218,219,331,5,330,219',
'389,44,44,331,331,331,331,331,331,331,331,331,220,331,331,331,331,331',
'331,331,331,331,331,248,48,28,331,331,331,179,217,331,331,331,281,218',
'219,271,331,331,331,331,331,331,331,331,331,331,331,331,331,331,47,220',
'46,7,331,331,331,331,339,339,277,339,248,339,339,339,339,24,120,27,279',
'327,328,339,161,208,271,46,47,47,339,339,339,339,339,339,339,339,339',
'329,339,339,339,339,339,339,339,339,339,339,120,277,51,339,339,339,161',
'208,339,339,339,279,327,328,124,339,339,339,339,339,339,339,339,339',
'339,339,339,339,339,185,329,51,272,339,339,339,339,340,340,124,340,32',
'340,340,340,340,31,31,35,31,6,6,340,36,185,311,337,272,87,340,340,340',
'340,340,340,340,340,340,394,340,340,340,340,340,340,340,340,340,340',
'6,311,337,340,340,340,395,396,340,340,340,317,170,170,394,340,340,340',
'340,340,340,340,340,340,340,340,340,340,340,88,317,395,396,340,340,340',
'340,341,341,89,341,90,341,341,341,341,0,0,0,188,188,91,341,211,211,212',
'212,213,213,341,341,341,341,341,341,341,341,341,93,341,341,341,341,341',
'341,341,341,341,341,214,214,94,341,341,341,215,215,341,341,341,216,216',
'222,222,341,341,341,341,341,341,341,341,341,341,341,341,341,341,365',
'365,95,365,341,341,341,341,34,114,34,116,34,118,34,365,34,223,223,224',
'224,34,365,365,365,365,365,365,365,365,365,121,365,365,365,365,365,365',
'365,365,365,365,267,267,122,365,365,365,269,269,365,365,365,34,274,274',
'128,365,365,365,365,365,365,365,365,365,365,365,365,365,365,384,384',
'129,384,365,365,365,365,356,356,366,366,130,34,131,384,367,367,381,381',
'387,387,384,384,384,384,384,384,384,384,384,132,384,384,384,384,384',
'384,384,384,384,384,390,390,133,384,384,384,392,392,384,384,384,401',
'401,416,416,384,384,384,384,384,384,384,384,384,384,384,384,384,384',
'418,418,419,419,384,384,384,384,397,397,134,397,135,397,397,397,397',
'136,137,138,139,140,141,397,142,143,146,147,149,151,397,397,397,397',
'397,397,397,397,397,154,397,397,397,397,397,397,397,397,397,397,155',
'162,163,397,397,397,164,190,397,397,397,206,221,226,231,397,397,397',
'397,397,397,397,397,397,397,397,397,397,397,424,424,242,424,397,397',
'397,397,243,244,245,246,247,249,250,424,253,256,258,259,260,261,424',
'424,424,424,424,424,424,424,424,262,424,424,424,424,424,424,424,424',
'424,424,264,282,286,424,424,424,288,289,424,424,424,293,307,308,309',
'424,424,424,424,424,424,424,424,424,424,424,424,424,424,324,325,326',
'334,424,424,424,424,49,338,342,49,49,49,49,343,344,346,49,49,49,364',
'49,49,49,368,49,373,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49',
'49,49,49,49,375,49,377,388,391,49,393,49,398,49,49,399,400,404,410,412',
'49,49,49,49,49,49,49,415,421,425,49,49,49,,,,,49,49,49,49,157,,,157',
'157,157,157,,,,157,157,157,,157,,157,,157,,157,157,157,157,157,157,157',
'157,157,157,157,157,157,157,157,157,157,157,157,157,,157,,,,157,,,,',
',,,,,,157,157,157,157,157,157,157,,,,157,157,157,,,,,157,157,157,157',
'196,,,196,196,196,196,,,,196,196,196,,196,196,196,,196,,196,196,196',
'196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196',
',196,,,,196,,196,,196,196,,,,,,196,196,196,196,196,196,196,,,,196,196',
'196,,,,,196,196,196,196,197,,,197,197,197,197,,,,197,197,197,,197,197',
'197,,197,,197,197,197,197,197,197,197,197,197,197,197,197,197,197,197',
'197,197,197,197,197,,197,,,,197,,197,,197,197,,,,,,197,197,197,197,197',
'197,197,,,,197,197,197,,,,,197,197,197,197,198,,,198,198,198,198,,,',
'198,198,198,,198,198,198,,198,,198,198,198,198,198,198,198,198,198,198',
'198,198,198,198,198,198,198,198,198,198,,198,,,,198,,198,,,198,,,,,',
'198,198,198,198,198,198,198,,,,198,198,198,,,,,198,198,198,198,207,',
',207,207,207,207,,,,207,207,207,,207,207,207,,207,,207,207,207,207,207',
'207,207,207,207,207,207,207,207,207,207,207,207,207,207,207,,207,,,',
'207,,207,,207,207,,,,,,207,207,207,207,207,207,207,,,,207,207,207,,',
',,207,207,207,207,254,,,254,254,254,254,,,,254,254,254,,254,254,254',
',254,,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254',
'254,254,254,254,,254,,,,254,115,254,,115,254,115,,,,,254,254,254,254',
'254,254,254,,,,254,254,254,,,115,,254,254,254,254,30,30,30,30,,115,',
'30,30,30,,,,,,,,30,30,30,30,30,30,30,30,30,,30,30,30,30,30,30,30,30',
'30,30,,,,,,,,,144,,144,,,,,,30,30,30,30,30,30,30,,30,30,30,30,30,,,',
',30,30,30,30,166,166,166,166,,,,166,166,166,,,,,,144,144,166,166,166',
'166,166,166,166,166,166,,166,166,166,166,166,166,166,166,166,166,144',
',,,,,,,,,,,,,,,166,166,166,166,166,166,166,,166,166,166,166,166,199',
'199,199,199,166,166,166,166,,,,,,,,,,199,199,199,199,199,199,199,199',
'199,,199,199,199,199,199,199,199,199,199,199,201,,201,,,,,199,,,199',
',,,,,199,199,199,199,199,199,199,203,,203,199,199,199,200,200,200,200',
'199,199,199,199,,,,,,,,201,201,200,200,200,200,200,200,200,200,200,',
'200,200,200,200,200,200,200,200,200,200,201,203,203,,,,,200,,,200,,',
',,,200,200,200,200,200,200,200,203,,,200,200,200,233,233,233,233,200',
'200,200,200,,,,,,,,,,233,233,233,233,233,233,233,233,233,,233,233,233',
'233,233,233,233,233,233,233,204,,204,205,,205,237,,237,,,,,,,,233,233',
'233,233,233,233,233,,,,233,233,233,,,,,233,233,233,233,,,,,,,,204,204',
',205,205,,237,237,278,,278,,278,,278,,,278,278,278,,,204,,,205,,,237',
',285,,285,,285,,285,,278,285,285,285,,,,,,278,278,,,278,292,,292,,292',
',292,,285,292,292,292,,,,278,,285,285,,,285,336,,336,,336,,336,,292',
'336,336,336,,,,285,,292,292,,,292,,,,,,,,,336,,,,,,,292,,336,336,,2',
'336,,,,,,,,,2,2,2,,2,,2,336,2,,2,2,2,2,2,2,2,2,2,2,2,2,2,2,,,25,,,,',
'2,,,,2,25,25,25,,25,,25,25,25,,25,25,25,25,25,25,25,25,25,25,25,25,25',
'25,,,26,,,,,25,,,,25,26,26,26,,26,,26,,26,,26,26,26,26,26,26,26,26,26',
'26,26,26,26,26,,,40,,,,,26,,,,26,40,40,40,,40,,40,,40,,40,40,40,40,40',
'40,40,40,40,40,40,40,40,40,,,41,,,,,40,,,,40,41,41,41,,41,,41,,41,,41',
'41,41,41,41,41,41,41,41,41,41,41,41,41,,,43,,,,,41,,,,41,43,43,43,,43',
',43,,43,,43,43,43,43,43,43,43,43,43,43,43,43,43,43,,,53,,,,,43,,,,43',
'53,53,53,,53,,53,,53,,53,53,53,53,53,53,53,53,53,53,53,53,53,53,,,92',
',,,,53,,,,53,92,92,92,,92,,92,,92,,92,92,92,92,92,92,92,92,92,92,92',
'92,92,92,,,126,,,,,92,,,,92,126,126,126,,126,,126,,126,,126,126,126',
'126,126,126,126,126,126,126,126,126,126,126,,,158,,,,,126,,,,126,158',
'158,158,,158,,158,,158,,158,158,158,158,158,158,158,158,158,158,158',
'158,158,158,,,159,,,,,158,,,,158,159,159,159,,159,,159,,159,,159,159',
'159,159,159,159,159,159,159,159,159,159,159,159,,,160,,,,,159,,,,159',
'160,160,160,,160,,160,,160,,160,160,160,160,160,160,160,160,160,160',
'160,160,160,160,,,167,,,,,160,,,,160,167,167,167,,167,,167,,167,,167',
'167,167,167,167,167,167,167,167,167,167,167,167,167,,,168,,,,,167,,',
',167,168,168,168,,168,,168,,168,,168,168,168,168,168,168,168,168,168',
'168,168,168,168,168,,,169,,,,,168,,,,168,169,169,169,,169,,169,,169',
',169,169,169,169,169,169,169,169,169,169,169,169,169,169,,,171,,,,,169',
',,,169,171,171,171,,171,,171,,171,,171,171,171,171,171,171,171,171,171',
'171,171,171,171,171,,,172,,,,,171,,,,171,172,172,172,,172,,172,,172',
',172,172,172,172,172,172,172,172,172,172,172,172,172,172,,,173,,,,,172',
',,,172,173,173,173,,173,,173,,173,,173,173,173,173,173,173,173,173,173',
'173,173,173,173,173,,,180,,,,,173,,,,173,180,180,180,,180,,180,,180',
',180,180,180,180,180,180,180,180,180,180,180,180,180,180,,,181,,,,,180',
',,,180,181,181,181,,181,,181,,181,,181,181,181,181,181,181,181,181,181',
'181,181,181,181,181,,,183,,,,,181,,,,181,183,183,183,,183,,183,,183',
',183,183,183,183,183,183,183,183,183,183,183,183,183,183,,,202,,,,,183',
',,,183,202,202,202,,202,,202,,202,,202,202,202,202,202,202,202,202,202',
'202,202,202,202,202,,,209,,,,,202,,,,202,209,209,209,,209,,209,,209',
',209,209,209,209,209,209,209,209,209,209,209,209,209,209,,,227,,,,,209',
',,,209,227,227,227,,227,,227,,227,,227,227,227,227,227,227,227,227,227',
'227,227,227,227,227,,,251,,,,,227,,,,227,251,251,251,,251,,251,,251',
',251,251,251,251,251,251,251,251,251,251,251,251,251,251,,,280,,,,,251',
',,,251,280,280,280,,280,,280,,280,,280,280,280,280,280,280,280,280,280',
'280,280,280,280,280,,,320,,,,,280,,,,280,320,320,320,,320,,320,,320',
',320,320,320,320,320,320,320,320,320,320,320,320,320,320,,,332,,,,,320',
',,,320,332,332,332,,332,,332,,332,,332,332,332,332,332,332,332,332,332',
'332,332,332,332,332,,,333,,,,,332,,,,332,333,333,333,,333,,333,,333',
',333,333,333,333,333,333,333,333,333,333,333,333,333,333,,,372,,,,,333',
',,,333,372,372,372,,372,,372,,372,,372,372,372,372,372,372,372,372,372',
'372,372,372,372,372,,,374,,,,,372,,,,372,374,374,374,,374,,374,,374',
',374,374,374,374,374,374,374,374,374,374,374,374,374,374,,,376,,,,,374',
',,,374,376,376,376,,376,,376,,376,,376,376,376,376,376,376,376,376,376',
'376,376,376,376,376,,,378,,,,,376,,,,376,378,378,378,,378,,378,,378',
',378,378,378,378,378,378,378,378,378,378,378,378,378,378,,,379,,,,,378',
',,,378,379,379,379,,379,,379,,379,,379,379,379,379,379,379,379,379,379',
'379,379,379,379,379,,,380,,,,,379,,,,379,380,380,380,,380,,380,,380',
',380,380,380,380,380,380,380,380,380,380,380,380,380,380,,,386,,,,,380',
',,,380,386,386,386,,386,,386,,386,,386,386,386,386,386,386,386,386,386',
'386,386,386,386,386,,,402,,,,,386,,,,386,402,402,402,,402,,402,,402',
',402,402,402,402,402,402,402,402,402,402,402,402,402,402,,,405,,,,,402',
',,,402,405,405,405,,405,,405,,405,,405,405,405,405,405,405,405,405,405',
'405,405,405,405,405,,,406,,,,,405,,,,405,406,406,406,,406,,406,,406',
',406,406,406,406,406,406,406,406,406,406,406,406,406,406,294,,,294,',
'294,,406,294,,,406,,,,,,,,,,,,,,294,,294,294,294,294,294,,,,294,294' ]
        racc_action_check = arr = ::Array.new(3055, nil)
        idx = 0
        clist.each do |str|
          str.split(',', -1).each do |i|
            arr[idx] = i.to_i unless i.empty?
            idx += 1
          end
        end

racc_action_pointer = [
   173,     6,  1612,   nil,   nil,    16,   124,    23,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,    68,  1648,  1684,    72,    -6,   nil,
  1140,   165,   158,   nil,   316,    93,   154,   nil,   nil,   nil,
  1720,  1756,   nil,  1792,   -27,   nil,    52,    52,    -2,   604,
   nil,   101,   nil,  1828,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   156,   183,   184,
   186,   196,  1864,   224,   237,   266,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   304,  1081,   275,     2,   277,   nil,
    71,   337,   304,   nil,   114,   nil,  1900,   nil,   345,   379,
   372,   349,   366,   379,   416,   418,   423,   424,   425,   426,
   427,   428,   456,   431,  1189,   nil,   432,   431,   nil,   432,
   nil,   433,   nil,   nil,   443,   454,   nil,   681,  1936,  1972,
  2008,    77,   479,   452,   455,   nil,  1214,  2044,  2080,  2116,
   165,  2152,  2188,  2224,   nil,   nil,   nil,   nil,   nil,     3,
  2260,  2296,   nil,  2332,   nil,   129,   nil,   nil,   202,   nil,
   457,   nil,   nil,   nil,   nil,   nil,   758,   835,   912,  1280,
  1346,  1321,  2368,  1344,  1453,  1456,   488,   989,    78,  2404,
   nil,   206,   208,   210,   232,   238,   243,     4,     9,    10,
    27,   456,   245,   278,   280,   nil,   511,  2440,   nil,   nil,
   nil,   468,   nil,  1412,   nil,   nil,   nil,  1459,   nil,   nil,
   nil,   nil,   512,   514,   487,   519,   520,   521,    38,   522,
   538,  2476,   nil,   494,  1066,   nil,   496,   nil,   529,   489,
   470,   506,   514,   nil,   551,   nil,   nil,   303,   nil,   354,
   nil,    52,   132,   nil,   285,   nil,   nil,    77,  1506,    87,
  2512,    -8,   553,   nil,   nil,  1528,   553,   nil,   498,   576,
   nil,   nil,  1550,   536,  2983,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   539,   540,   528,
   nil,   155,   nil,   nil,   nil,   nil,   nil,   168,   nil,   nil,
  2548,   nil,   nil,   nil,   568,   569,   570,    88,    89,   106,
   -63,    -2,  2584,  2620,   592,   nil,  1572,   156,   552,    77,
   156,   235,   590,   595,   596,   nil,   578,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   336,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   564,   306,   342,   348,   581,   nil,
   nil,   nil,  2656,   609,  2692,   630,  2728,   632,  2764,  2800,
  2836,   365,   nil,   nil,   377,   nil,  2872,   352,   607,     0,
   374,   608,   380,   610,   168,   185,   186,   456,   599,   602,
   628,   385,  2908,   nil,   642,  2944,  2980,   nil,   nil,   nil,
   604,   nil,   619,   nil,   nil,   614,   387,   nil,   403,   405,
   nil,   625,   nil,   nil,   527,   615,   nil,   nil ]

racc_action_default = [
  -249,  -249,  -245,    -6,   -16,  -249,    -4,  -161,  -164,  -165,
  -166,  -167,  -168,  -169,  -170,  -171,  -172,  -173,  -174,  -175,
  -176,  -177,  -178,  -179,  -180,  -245,  -245,  -249,   -84,  -188,
  -249,  -249,  -246,  -248,   -17,    -4,  -151,   428,    -1,    -5,
  -245,  -245,  -187,  -245,  -189,  -182,  -249,  -249,  -245,  -245,
  -186,  -249,  -208,  -245,  -108,  -109,  -110,  -111,  -112,  -113,
  -114,  -115,  -116,  -117,  -118,  -119,  -120,  -121,  -122,  -123,
  -124,  -125,  -126,  -127,  -128,  -129,  -130,  -131,  -132,  -133,
  -134,  -135,  -136,  -137,  -138,  -139,  -140,  -249,  -192,  -249,
  -249,  -249,  -245,  -249,  -249,  -249,  -203,  -204,  -205,  -206,
  -239,  -240,  -241,  -242,  -247,    -2,    -7,    -8,    -9,   -10,
   -11,   -12,   -13,   -14,   -17,  -249,  -249,  -249,  -249,    -3,
   -84,  -249,  -162,  -163,  -249,  -183,  -245,  -184,  -249,  -249,
  -249,  -174,  -164,  -168,  -175,  -176,  -165,  -166,  -169,  -170,
  -173,  -167,  -119,  -171,  -235,  -201,  -249,  -212,  -213,  -215,
  -216,  -218,  -219,  -222,  -225,  -227,  -228,  -245,  -245,  -245,
  -245,  -249,  -249,  -249,  -210,  -191,  -249,  -245,  -245,  -245,
  -197,  -245,  -245,  -245,   -18,   -15,   -15,   -15,   -15,  -245,
  -245,  -245,  -244,  -245,   -83,  -249,  -153,  -181,  -190,  -185,
   -85,  -229,  -236,  -237,  -238,  -202,  -245,  -245,  -245,  -223,
  -223,  -235,  -245,  -235,  -235,  -235,  -249,  -245,  -249,  -245,
  -193,  -194,  -195,  -196,  -198,  -199,  -200,  -245,  -245,  -245,
  -245,  -249,  -158,  -159,  -160,  -152,  -249,  -245,  -211,  -219,
  -214,  -221,  -217,  -249,  -224,  -226,  -230,  -235,  -231,  -232,
  -234,   -86,  -249,  -249,  -207,  -151,  -141,  -141,  -245,  -141,
  -249,  -245,  -154,  -209,  -245,  -233,  -249,   -87,  -249,   -23,
  -149,   -28,   -34,   -30,   -33,   -61,  -243,  -157,  -220,  -249,
   -34,  -245,  -249,  -143,  -146,  -150,   -34,  -245,   -17,  -245,
  -245,   -17,  -249,   -20,   -21,   -17,   -24,  -142,  -149,  -249,
  -147,  -148,   -17,   -29,   -75,   -27,   -35,   -36,   -37,   -38,
   -39,   -40,   -41,   -42,   -43,   -44,   -45,  -249,  -249,  -249,
   -31,  -249,   -60,   -62,   -63,   -64,   -65,   -75,   -34,   -22,
  -245,  -144,  -145,   -26,   -46,   -46,   -46,  -245,  -245,  -245,
   -72,  -249,  -245,  -245,  -249,   -32,   -17,  -249,  -249,  -249,
  -249,  -249,   -66,   -68,   -70,   -73,  -249,   -76,   -90,   -91,
   -92,   -93,   -94,   -95,   -96,   -97,   -98,  -101,  -102,  -103,
  -104,  -105,  -106,  -107,  -133,  -249,   -57,   -58,  -249,   -19,
   -25,   -47,  -245,   -54,  -245,   -54,  -245,   -54,  -245,  -245,
  -245,   -77,   -99,  -100,  -249,  -155,  -245,   -48,  -249,  -249,
   -50,  -249,   -52,  -249,  -249,  -249,  -249,  -249,  -249,  -249,
  -249,   -59,  -245,   -55,  -249,  -245,  -245,   -67,   -69,   -71,
   -16,   -88,  -249,   -78,   -79,  -249,   -49,   -56,   -51,   -53,
   -74,   -80,   -81,   -89,  -249,   -16,  -156,   -82 ]

racc_goto_table = [
     6,    93,   117,    46,    92,   128,   120,   115,   164,    87,
   365,   191,   202,    50,   130,   229,   129,   232,   373,   375,
   377,   124,   231,   231,    47,    38,   278,   206,   262,     1,
   273,   420,    34,   388,   285,   391,    35,   393,   122,   123,
   292,   221,   259,   261,   385,   265,   427,   144,   217,   218,
   219,   220,   106,   105,   119,   234,   235,   293,   321,   339,
   340,   341,   282,   400,   270,   276,   310,   314,   236,   315,
   238,   239,   240,   268,   243,   316,   412,   249,   281,   231,
   313,   346,   336,   397,   410,   163,   272,   174,   202,   289,
   170,   185,   230,   100,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   426,   255,   184,   nil,   nil,   nil,   nil,
   264,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   188,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,    93,   nil,   264,
    92,   264,   nil,   nil,   nil,   210,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   201,   203,   204,   205,   nil,
   nil,   228,   nil,   nil,   244,   211,   212,   213,   nil,   214,
   215,   216,   242,   nil,   245,   246,   247,   nil,   222,   223,
   nil,   224,   253,   nil,   nil,   129,   129,   129,   250,   342,
   343,   344,   nil,   nil,   144,   144,   144,   nil,   nil,   nil,
   237,   nil,   nil,   nil,   nil,   144,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   258,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   286,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   129,
   nil,   nil,   nil,   nil,   nil,   nil,   117,   nil,   nil,   267,
   nil,   nil,   144,   117,   317,   nil,   nil,   nil,   311,   nil,
   117,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   337,   nil,
   nil,   nil,   363,   nil,   117,   nil,   nil,   nil,   nil,   nil,
   363,   363,   363,   372,   374,   376,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   366,   367,   nil,   nil,   nil,   nil,   363,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   363,   394,   395,   396,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   363,   nil,
   387,   411,   390,   nil,   392,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   401,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   363,   nil,   nil,   nil,   nil,
   416,   nil,   nil,   418,   419 ]

racc_goto_check = [
     2,    54,    60,    23,    37,    17,    18,    16,    61,    63,
    38,    76,    65,    48,    50,    71,    60,    71,    38,    38,
    38,    23,    66,    66,     2,     3,    20,    52,    25,     1,
    56,    47,     4,    39,    20,    39,     5,    39,     2,     2,
    20,    27,    21,    21,    38,    21,    47,     2,    14,    14,
    14,    14,     6,     3,     3,    72,    72,    25,    56,    36,
    36,    36,    19,    38,    22,    24,    26,    29,    76,    30,
    76,    76,    76,    71,    52,    35,    38,    40,    41,    66,
    42,    43,    20,    45,    46,    51,    55,    16,    65,    58,
     2,    59,    67,    77,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,    38,    76,    48,   nil,   nil,   nil,   nil,
    27,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,     2,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,    54,   nil,    27,
    37,    27,   nil,   nil,   nil,    63,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,     2,     2,     2,     2,   nil,
   nil,    50,   nil,   nil,    61,     2,     2,     2,   nil,     2,
     2,     2,    50,   nil,    17,    17,    17,   nil,     2,     2,
   nil,     2,    61,   nil,   nil,    60,    60,    60,    60,    27,
    27,    27,   nil,   nil,     2,     2,     2,   nil,   nil,   nil,
     2,   nil,   nil,   nil,   nil,     2,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,    18,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,    17,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,    60,
   nil,   nil,   nil,   nil,   nil,   nil,    60,   nil,   nil,     2,
   nil,   nil,     2,    60,    16,   nil,   nil,   nil,    23,   nil,
    60,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,    23,   nil,
   nil,   nil,    54,   nil,    60,   nil,   nil,   nil,   nil,   nil,
    54,    54,    54,    37,    37,    37,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
     2,     2,   nil,   nil,   nil,   nil,    54,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,    54,    23,    23,    23,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,    54,   nil,
     2,    37,     2,   nil,     2,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,     2,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,    54,   nil,   nil,   nil,   nil,
     2,   nil,   nil,     2,     2 ]

racc_goto_pointer = [
   nil,    29,    -2,    19,    29,    32,    18,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,  -127,   nil,   -27,   -43,   -30,  -207,
  -236,  -204,  -195,   -22,  -196,  -220,  -213,  -138,   nil,  -214,
  -212,   nil,   nil,   nil,   nil,  -206,  -265,   -26,  -321,  -340,
  -143,  -187,  -201,  -249,   nil,  -298,  -313,  -379,   -15,   nil,
   -35,    34,  -134,   nil,   -29,  -174,  -230,   nil,  -185,   -30,
   -32,   -45,   nil,   -21,   nil,  -145,  -175,  -105,   nil,   nil,
   nil,  -181,  -144,   nil,   nil,   nil,  -133,    62 ]

racc_goto_default = [
   nil,   nil,    44,   nil,   nil,   421,   306,   107,   108,   109,
   110,   111,   112,   113,   nil,    36,   294,   116,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   263,    24,   296,   297,
   298,   299,   300,   301,   302,   305,   nil,   145,   nil,   nil,
   nil,   nil,   nil,   nil,   330,   nil,   nil,   nil,   nil,    51,
   nil,   nil,    52,   356,   146,   nil,   nil,   274,   nil,   nil,
    31,     7,    29,   nil,    88,   159,   147,   148,   149,   150,
   151,   152,   153,   154,   155,   156,   nil,   nil ]

racc_reduce_table = [
  0, 0, :racc_error,
  3, 82, :_reduce_1,
  3, 82, :_reduce_2,
  3, 82, :_reduce_3,
  0, 84, :_reduce_none,
  1, 84, :_reduce_none,
  0, 85, :_reduce_6,
  2, 85, :_reduce_7,
  1, 87, :_reduce_none,
  1, 87, :_reduce_none,
  1, 87, :_reduce_none,
  1, 87, :_reduce_none,
  1, 87, :_reduce_none,
  1, 87, :_reduce_none,
  1, 87, :_reduce_none,
  0, 95, :_reduce_15,
  0, 96, :_reduce_16,
  0, 97, :_reduce_17,
  2, 97, :_reduce_18,
  10, 94, :_reduce_19,
  1, 100, :_reduce_none,
  1, 100, :_reduce_none,
  8, 93, :_reduce_22,
  0, 103, :_reduce_23,
  2, 103, :_reduce_24,
  5, 103, :_reduce_25,
  8, 92, :_reduce_26,
  7, 92, :_reduce_27,
  0, 105, :_reduce_28,
  2, 105, :_reduce_29,
  1, 106, :_reduce_30,
  3, 106, :_reduce_31,
  4, 107, :_reduce_32,
  1, 107, :_reduce_33,
  0, 101, :_reduce_34,
  2, 101, :_reduce_35,
  1, 109, :_reduce_none,
  1, 109, :_reduce_none,
  1, 109, :_reduce_none,
  1, 109, :_reduce_none,
  1, 109, :_reduce_none,
  1, 109, :_reduce_none,
  1, 109, :_reduce_42,
  1, 109, :_reduce_43,
  1, 109, :_reduce_none,
  1, 109, :_reduce_none,
  0, 117, :_reduce_46,
  2, 117, :_reduce_47,
  5, 115, :_reduce_48,
  7, 115, :_reduce_49,
  5, 115, :_reduce_50,
  7, 115, :_reduce_51,
  5, 115, :_reduce_52,
  7, 115, :_reduce_53,
  0, 120, :_reduce_54,
  2, 120, :_reduce_55,
  3, 120, :_reduce_56,
  3, 114, :_reduce_57,
  3, 114, :_reduce_58,
  5, 114, :_reduce_59,
  7, 91, :_reduce_60,
  0, 122, :_reduce_61,
  2, 122, :_reduce_62,
  1, 123, :_reduce_63,
  1, 123, :_reduce_64,
  1, 123, :_reduce_none,
  3, 111, :_reduce_66,
  6, 111, :_reduce_67,
  3, 112, :_reduce_68,
  6, 112, :_reduce_69,
  3, 113, :_reduce_70,
  6, 113, :_reduce_71,
  0, 124, :_reduce_72,
  1, 124, :_reduce_73,
  7, 110, :_reduce_74,
  0, 125, :_reduce_none,
  2, 125, :_reduce_76,
  0, 126, :_reduce_77,
  2, 126, :_reduce_78,
  2, 126, :_reduce_79,
  1, 128, :_reduce_80,
  1, 128, :_reduce_81,
  3, 128, :_reduce_82,
  3, 86, :_reduce_83,
  0, 130, :_reduce_84,
  3, 130, :_reduce_85,
  3, 132, :_reduce_86,
  4, 132, :_reduce_87,
  1, 127, :_reduce_none,
  2, 127, :_reduce_89,
  1, 119, :_reduce_none,
  1, 119, :_reduce_none,
  1, 119, :_reduce_none,
  1, 119, :_reduce_none,
  1, 119, :_reduce_none,
  1, 119, :_reduce_none,
  1, 119, :_reduce_none,
  1, 119, :_reduce_none,
  1, 119, :_reduce_none,
  2, 119, :_reduce_99,
  2, 119, :_reduce_100,
  1, 119, :_reduce_none,
  1, 119, :_reduce_none,
  1, 119, :_reduce_none,
  1, 134, :_reduce_none,
  1, 134, :_reduce_none,
  1, 134, :_reduce_none,
  1, 134, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  0, 102, :_reduce_141,
  3, 102, :_reduce_142,
  1, 136, :_reduce_143,
  3, 136, :_reduce_144,
  3, 137, :_reduce_145,
  0, 139, :_reduce_146,
  1, 139, :_reduce_147,
  1, 139, :_reduce_148,
  0, 138, :_reduce_149,
  1, 138, :_reduce_150,
  0, 99, :_reduce_151,
  3, 99, :_reduce_152,
  1, 140, :_reduce_153,
  3, 140, :_reduce_154,
  4, 116, :_reduce_155,
  8, 116, :_reduce_156,
  5, 88, :_reduce_157,
  3, 89, :_reduce_158,
  3, 89, :_reduce_159,
  3, 90, :_reduce_160,
  1, 83, :_reduce_none,
  3, 83, :_reduce_162,
  3, 83, :_reduce_163,
  1, 142, :_reduce_164,
  1, 142, :_reduce_165,
  1, 142, :_reduce_166,
  1, 142, :_reduce_167,
  1, 142, :_reduce_168,
  1, 142, :_reduce_169,
  1, 142, :_reduce_170,
  1, 142, :_reduce_171,
  1, 142, :_reduce_172,
  1, 142, :_reduce_173,
  1, 142, :_reduce_174,
  1, 142, :_reduce_175,
  1, 142, :_reduce_176,
  1, 142, :_reduce_177,
  1, 142, :_reduce_178,
  1, 142, :_reduce_179,
  1, 142, :_reduce_180,
  4, 142, :_reduce_181,
  2, 142, :_reduce_182,
  3, 142, :_reduce_183,
  3, 142, :_reduce_184,
  4, 142, :_reduce_185,
  2, 142, :_reduce_186,
  2, 142, :_reduce_187,
  1, 142, :_reduce_none,
  1, 104, :_reduce_189,
  3, 104, :_reduce_190,
  3, 143, :_reduce_191,
  1, 144, :_reduce_192,
  3, 144, :_reduce_193,
  3, 145, :_reduce_194,
  3, 145, :_reduce_195,
  3, 145, :_reduce_196,
  2, 145, :_reduce_197,
  3, 145, :_reduce_198,
  3, 145, :_reduce_199,
  3, 145, :_reduce_200,
  1, 146, :_reduce_none,
  2, 146, :_reduce_202,
  1, 118, :_reduce_none,
  1, 118, :_reduce_none,
  1, 118, :_reduce_none,
  1, 118, :_reduce_none,
  4, 129, :_reduce_207,
  1, 129, :_reduce_208,
  5, 133, :_reduce_209,
  2, 133, :_reduce_210,
  3, 131, :_reduce_211,
  1, 131, :_reduce_212,
  1, 131, :_reduce_none,
  3, 148, :_reduce_214,
  1, 148, :_reduce_215,
  1, 148, :_reduce_none,
  3, 150, :_reduce_217,
  1, 150, :_reduce_218,
  1, 150, :_reduce_none,
  3, 152, :_reduce_220,
  1, 152, :_reduce_221,
  1, 152, :_reduce_none,
  0, 153, :_reduce_223,
  3, 153, :_reduce_224,
  1, 153, :_reduce_225,
  3, 153, :_reduce_226,
  1, 153, :_reduce_227,
  1, 153, :_reduce_228,
  2, 147, :_reduce_229,
  3, 149, :_reduce_230,
  3, 151, :_reduce_231,
  3, 154, :_reduce_232,
  4, 155, :_reduce_233,
  3, 156, :_reduce_234,
  0, 157, :_reduce_none,
  1, 157, :_reduce_none,
  1, 157, :_reduce_none,
  1, 157, :_reduce_none,
  2, 108, :_reduce_239,
  1, 158, :_reduce_none,
  1, 158, :_reduce_none,
  1, 158, :_reduce_none,
  2, 121, :_reduce_243,
  2, 98, :_reduce_244,
  0, 141, :_reduce_245,
  1, 141, :_reduce_246,
  2, 141, :_reduce_247,
  1, 141, :_reduce_248 ]

racc_reduce_n = 249

racc_shift_n = 428

racc_token_table = {
  false => 0,
  :error => 1,
  :tUIDENT => 2,
  :tLIDENT => 3,
  :tNAMESPACE => 4,
  :tINTERFACEIDENT => 5,
  :tGLOBALIDENT => 6,
  :tLKEYWORD => 7,
  :tUKEYWORD => 8,
  :tLKEYWORD_Q_E => 9,
  :tUKEYWORD_Q_E => 10,
  :tIVAR => 11,
  :tCLASSVAR => 12,
  :tANNOTATION => 13,
  :tSTRING => 14,
  :tSYMBOL => 15,
  :tINTEGER => 16,
  :tWRITE_ATTR => 17,
  :kLPAREN => 18,
  :kRPAREN => 19,
  :kLBRACKET => 20,
  :kRBRACKET => 21,
  :kLBRACE => 22,
  :kRBRACE => 23,
  :kVOID => 24,
  :kNIL => 25,
  :kTRUE => 26,
  :kFALSE => 27,
  :kANY => 28,
  :kUNTYPED => 29,
  :kTOP => 30,
  :kBOT => 31,
  :kSELF => 32,
  :kSELFQ => 33,
  :kINSTANCE => 34,
  :kCLASS => 35,
  :kBOOL => 36,
  :kSINGLETON => 37,
  :kTYPE => 38,
  :kDEF => 39,
  :kMODULE => 40,
  :kPRIVATE => 41,
  :kPUBLIC => 42,
  :kALIAS => 43,
  :kCOLON => 44,
  :kCOLON2 => 45,
  :kCOMMA => 46,
  :kBAR => 47,
  :kAMP => 48,
  :kHAT => 49,
  :kARROW => 50,
  :kQUESTION => 51,
  :kEXCLAMATION => 52,
  :kSTAR => 53,
  :kSTAR2 => 54,
  :kFATARROW => 55,
  :kEQ => 56,
  :kDOT => 57,
  :kDOT3 => 58,
  :kLT => 59,
  :kINTERFACE => 60,
  :kEND => 61,
  :kINCLUDE => 62,
  :kEXTEND => 63,
  :kATTRREADER => 64,
  :kATTRWRITER => 65,
  :kATTRACCESSOR => 66,
  :tOPERATOR => 67,
  :tQUOTEDMETHOD => 68,
  :tQUOTEDIDENT => 69,
  :kPREPEND => 70,
  :kEXTENSION => 71,
  :kINCOMPATIBLE => 72,
  :type_TYPE => 73,
  :type_SIGNATURE => 74,
  :type_METHODTYPE => 75,
  :tEOF => 76,
  :kOUT => 77,
  :kIN => 78,
  :kUNCHECKED => 79,
  :kOVERLOAD => 80 }

racc_nt_base = 81

racc_use_result_var = true

Racc_arg = [
  racc_action_table,
  racc_action_check,
  racc_action_default,
  racc_action_pointer,
  racc_goto_table,
  racc_goto_check,
  racc_goto_default,
  racc_goto_pointer,
  racc_nt_base,
  racc_reduce_table,
  racc_token_table,
  racc_shift_n,
  racc_reduce_n,
  racc_use_result_var ]

Racc_token_to_s_table = [
  "$end",
  "error",
  "tUIDENT",
  "tLIDENT",
  "tNAMESPACE",
  "tINTERFACEIDENT",
  "tGLOBALIDENT",
  "tLKEYWORD",
  "tUKEYWORD",
  "tLKEYWORD_Q_E",
  "tUKEYWORD_Q_E",
  "tIVAR",
  "tCLASSVAR",
  "tANNOTATION",
  "tSTRING",
  "tSYMBOL",
  "tINTEGER",
  "tWRITE_ATTR",
  "kLPAREN",
  "kRPAREN",
  "kLBRACKET",
  "kRBRACKET",
  "kLBRACE",
  "kRBRACE",
  "kVOID",
  "kNIL",
  "kTRUE",
  "kFALSE",
  "kANY",
  "kUNTYPED",
  "kTOP",
  "kBOT",
  "kSELF",
  "kSELFQ",
  "kINSTANCE",
  "kCLASS",
  "kBOOL",
  "kSINGLETON",
  "kTYPE",
  "kDEF",
  "kMODULE",
  "kPRIVATE",
  "kPUBLIC",
  "kALIAS",
  "kCOLON",
  "kCOLON2",
  "kCOMMA",
  "kBAR",
  "kAMP",
  "kHAT",
  "kARROW",
  "kQUESTION",
  "kEXCLAMATION",
  "kSTAR",
  "kSTAR2",
  "kFATARROW",
  "kEQ",
  "kDOT",
  "kDOT3",
  "kLT",
  "kINTERFACE",
  "kEND",
  "kINCLUDE",
  "kEXTEND",
  "kATTRREADER",
  "kATTRWRITER",
  "kATTRACCESSOR",
  "tOPERATOR",
  "tQUOTEDMETHOD",
  "tQUOTEDIDENT",
  "kPREPEND",
  "kEXTENSION",
  "kINCOMPATIBLE",
  "type_TYPE",
  "type_SIGNATURE",
  "type_METHODTYPE",
  "tEOF",
  "kOUT",
  "kIN",
  "kUNCHECKED",
  "kOVERLOAD",
  "$start",
  "target",
  "type",
  "eof",
  "signatures",
  "method_type",
  "signature",
  "type_decl",
  "const_decl",
  "global_decl",
  "interface_decl",
  "module_decl",
  "class_decl",
  "extension_decl",
  "start_new_scope",
  "start_merged_scope",
  "annotations",
  "class_name",
  "type_params",
  "extension_name",
  "class_members",
  "module_type_params",
  "super_class",
  "type_list",
  "colon_module_self_types",
  "module_self_types",
  "module_self_type",
  "qualified_name",
  "class_member",
  "method_member",
  "include_member",
  "extend_member",
  "prepend_member",
  "var_type_member",
  "attribute_member",
  "alias_member",
  "attribute_kind",
  "keyword",
  "method_name",
  "attr_var_opt",
  "interface_name",
  "interface_members",
  "interface_member",
  "overload",
  "attributes",
  "method_kind",
  "def_name",
  "method_types",
  "proc_type",
  "params_opt",
  "params",
  "block",
  "simple_function_type",
  "method_name0",
  "identifier_keywords",
  "module_type_params0",
  "module_type_param",
  "type_param_check",
  "type_param_variance",
  "type_params0",
  "namespace",
  "simple_type",
  "record_type",
  "record_fields",
  "record_field",
  "keyword_name",
  "required_positional",
  "optional_positional_params",
  "optional_positional",
  "rest_positional_param",
  "rest_positional",
  "trailing_positional_params",
  "keyword_params",
  "required_keyword",
  "optional_keyword",
  "rest_keyword",
  "var_name_opt",
  "simple_name" ]

Racc_debug_parser = false

##### State transition tables end #####

# reduce 0 omitted

module_eval(<<'.,.,', 'parser.y', 28)
  def _reduce_1(val, _values, result)
            result = val[1]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 31)
  def _reduce_2(val, _values, result)
            result = val[1]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 34)
  def _reduce_3(val, _values, result)
            result = val[1]

    result
  end
.,.,

# reduce 4 omitted

# reduce 5 omitted

module_eval(<<'.,.,', 'parser.y', 40)
  def _reduce_6(val, _values, result)
     result = []
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 42)
  def _reduce_7(val, _values, result)
            result = val[0].push(val[1])

    result
  end
.,.,

# reduce 8 omitted

# reduce 9 omitted

# reduce 10 omitted

# reduce 11 omitted

# reduce 12 omitted

# reduce 13 omitted

# reduce 14 omitted

module_eval(<<'.,.,', 'parser.y', 54)
  def _reduce_15(val, _values, result)
     start_new_variables_scope
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 55)
  def _reduce_16(val, _values, result)
     start_merged_variables_scope
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 58)
  def _reduce_17(val, _values, result)
     result = []
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 60)
  def _reduce_18(val, _values, result)
            result = val[1].unshift(Annotation.new(string: val[0].value, location: val[0].location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 65)
  def _reduce_19(val, _values, result)
            reset_variable_scope

        location = val[1].location + val[9].location
        result = Declarations::Extension.new(
          name: val[3].value,
          type_params: val[4]&.value || [],
          extension_name: val[6].value.to_sym,
          members: val[8],
          annotations: val[0],
          location: location,
          comment: leading_comment(val[0].first&.location || location)
        )

    result
  end
.,.,

# reduce 20 omitted

# reduce 21 omitted

module_eval(<<'.,.,', 'parser.y', 83)
  def _reduce_22(val, _values, result)
            reset_variable_scope

        location = val[1].location + val[7].location
        result = Declarations::Class.new(
          name: val[3].value,
          type_params: val[4]&.value || Declarations::ModuleTypeParams.empty,
          super_class: val[5],
          members: val[6],
          annotations: val[0],
          location: location,
          comment: leading_comment(val[0].first&.location || location)
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 98)
  def _reduce_23(val, _values, result)
     result = nil
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 100)
  def _reduce_24(val, _values, result)
            result = Declarations::Class::Super.new(name: val[1].value,
                                                args: [],
                                                location: val[1].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 105)
  def _reduce_25(val, _values, result)
            result = Declarations::Class::Super.new(name: val[1].value,
                                                args: val[3],
                                                location: val[1].location + val[4].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 112)
  def _reduce_26(val, _values, result)
            reset_variable_scope

        location = val[1].location + val[7].location
        result = Declarations::Module.new(
          name: val[3].value,
          type_params: val[4]&.value || Declarations::ModuleTypeParams.empty,
          self_types: val[5],
          members: val[6],
          annotations: val[0],
          location: location,
          comment: leading_comment(val[0].first&.location || location)
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 126)
  def _reduce_27(val, _values, result)
            reset_variable_scope

        location = val[1].location + val[6].location
        result = Declarations::Module.new(
          name: val[3].value,
          type_params: Declarations::ModuleTypeParams.empty,
          self_types: val[4],
          members: val[5],
          annotations: val[0],
          location: location,
          comment: leading_comment(val[0].first&.location || location)
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 141)
  def _reduce_28(val, _values, result)
     result = []
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 143)
  def _reduce_29(val, _values, result)
            result = val[1]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 148)
  def _reduce_30(val, _values, result)
            result = [val[0]]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 151)
  def _reduce_31(val, _values, result)
            result = val[0].push(val[2])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 156)
  def _reduce_32(val, _values, result)
            name = val[0].value
        args = val[2]
        location = val[0].location + val[3].location

        case
        when name.class?
          result = Declarations::Module::Self.new(name: name, args: args, location: location)
        when name.interface?
          result = Declarations::Module::Self.new(name: name, args: args, location: location)
        else
          raise SemanticsError.new("Module self type should be instance or interface", subject: val[0], location: val[0].location)
        end

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 170)
  def _reduce_33(val, _values, result)
            name = val[0].value
        args = []
        location = val[0].location

        case
        when name.class?
          result = Declarations::Module::Self.new(name: name, args: args, location: location)
        when name.interface?
          result = Declarations::Module::Self.new(name: name, args: args, location: location)
        else
          raise SemanticsError.new("Module self type should be instance or interface", subject: val[0], location: val[0].location)
        end

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 185)
  def _reduce_34(val, _values, result)
     result = []
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 187)
  def _reduce_35(val, _values, result)
            result = val[0].push(val[1])

    result
  end
.,.,

# reduce 36 omitted

# reduce 37 omitted

# reduce 38 omitted

# reduce 39 omitted

# reduce 40 omitted

# reduce 41 omitted

module_eval(<<'.,.,', 'parser.y', 198)
  def _reduce_42(val, _values, result)
            result = Members::Public.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 201)
  def _reduce_43(val, _values, result)
            result = Members::Private.new(location: val[0].location)

    result
  end
.,.,

# reduce 44 omitted

# reduce 45 omitted

module_eval(<<'.,.,', 'parser.y', 207)
  def _reduce_46(val, _values, result)
     result = :instance
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 208)
  def _reduce_47(val, _values, result)
     result = :singleton
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 212)
  def _reduce_48(val, _values, result)
            location = val[1].location + val[4].location
        result = Members::AttrReader.new(name: val[3].value,
                                         ivar_name: nil,
                                         type: val[4],
                                         kind: val[2],
                                         annotations: val[0],
                                         location: location,
                                         comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 222)
  def _reduce_49(val, _values, result)
            location = val[1].location + val[6].location
        result = Members::AttrReader.new(name: val[3].value.to_sym,
                                         ivar_name: val[4],
                                         type: val[6],
                                         kind: val[2],
                                         annotations: val[0],
                                         location: location,
                                         comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 232)
  def _reduce_50(val, _values, result)
            location = val[1].location + val[4].location
        result = Members::AttrWriter.new(name: val[3].value,
                                         ivar_name: nil,
                                         kind: val[2],
                                         type: val[4],
                                         annotations: val[0],
                                         location: location,
                                         comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 242)
  def _reduce_51(val, _values, result)
            location = val[1].location + val[6].location
        result = Members::AttrWriter.new(name: val[3].value.to_sym,
                                         ivar_name: val[4],
                                         kind: val[2],
                                         type: val[6],
                                         annotations: val[0],
                                         location: location,
                                         comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 252)
  def _reduce_52(val, _values, result)
            location = val[1].location + val[4].location
        result = Members::AttrAccessor.new(name: val[3].value,
                                           ivar_name: nil,
                                           kind: val[2],
                                           type: val[4],
                                           annotations: val[0],
                                           location: location,
                                           comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 262)
  def _reduce_53(val, _values, result)
            location = val[1].location + val[6].location
        result = Members::AttrAccessor.new(name: val[3].value.to_sym,
                                           ivar_name: val[4],
                                           kind: val[2],
                                           type: val[6],
                                           annotations: val[0],
                                           location: location,
                                           comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 273)
  def _reduce_54(val, _values, result)
     result = nil
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 274)
  def _reduce_55(val, _values, result)
     result = false
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 275)
  def _reduce_56(val, _values, result)
     result = val[1].value
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 279)
  def _reduce_57(val, _values, result)
            location = val[0].location + val[2].location
        result = Members::InstanceVariable.new(
          name: val[0].value,
          type: val[2],
          location: location,
          comment: leading_comment(location)
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 288)
  def _reduce_58(val, _values, result)
            type = val[2]

        if type.is_a?(Types::Variable)
          type = Types::ClassInstance.new(
            name: TypeName.new(name: type.name, namespace: Namespace.empty),
            args: [],
            location: type.location
          )
        end

        location = val[0].location + val[2].location
        result = Members::ClassVariable.new(
          name: val[0].value,
          type: type,
          location: location,
          comment: leading_comment(location)
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 307)
  def _reduce_59(val, _values, result)
          type = val[4]

      if type.is_a?(Types::Variable)
        type = Types::ClassInstance.new(
          name: TypeName.new(name: type.name, namespace: Namespace.empty),
          args: [],
          location: type.location
        )
      end

      location = val[0].location + val[4].location
      result = Members::ClassInstanceVariable.new(
        name: val[2].value,
        type: type,
        location: location,
        comment: leading_comment(location)
      )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 328)
  def _reduce_60(val, _values, result)
            reset_variable_scope

        location = val[1].location + val[6].location
        result = Declarations::Interface.new(
          name: val[3].value,
          type_params: val[4]&.value || Declarations::ModuleTypeParams.empty,
          members: val[5],
          annotations: val[0],
          location: location,
          comment: leading_comment(val[0].first&.location || location)
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 342)
  def _reduce_61(val, _values, result)
     result = []
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 344)
  def _reduce_62(val, _values, result)
            result = val[0].push(val[1])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 349)
  def _reduce_63(val, _values, result)
            unless val[0].kind == :instance
          raise SemanticsError.new("Interface cannot have singleton method", subject: val[0], location: val[0].location)
        end

        if val[0].types.last == :super
          raise SemanticsError.new("Interface method cannot have `super` type", subject: val[0], location: val[0].location)
        end

        result = val[0]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 360)
  def _reduce_64(val, _values, result)
            unless val[0].name.interface?
          raise SemanticsError.new("Interface should include an interface", subject: val[0], location: val[0].location)
        end

        result = val[0]

    result
  end
.,.,

# reduce 65 omitted

module_eval(<<'.,.,', 'parser.y', 370)
  def _reduce_66(val, _values, result)
            if val[2].value.alias?
          raise SemanticsError.new("Should include module or interface", subject: val[2].value, location: val[2].location)
        end
        location = val[1].location + val[2].location
        result = Members::Include.new(name: val[2].value,
                                      args: [],
                                      annotations: val[0],
                                      location: location,
                                      comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 381)
  def _reduce_67(val, _values, result)
            if val[2].value.alias?
          raise SemanticsError.new("Should include module or interface", subject: val[2].value, location: val[2].location)
        end
        location = val[1].location + val[5].location
        result = Members::Include.new(name: val[2].value,
                                      args: val[4],
                                      annotations: val[0],
                                      location: location,
                                      comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 394)
  def _reduce_68(val, _values, result)
            if val[2].value.alias?
          raise SemanticsError.new("Should extend module or interface", subject: val[2].value, location: val[2].location)
        end
        location = val[1].location + val[2].location
        result = Members::Extend.new(name: val[2].value,
                                     args: [],
                                     annotations: val[0],
                                     location: location,
                                     comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 405)
  def _reduce_69(val, _values, result)
            if val[2].value.alias?
          raise SemanticsError.new("Should extend module or interface", subject: val[2].value, location: val[2].location)
        end
        location = val[1].location + val[5].location
        result = Members::Extend.new(name: val[2].value,
                                     args: val[4],
                                     annotations: val[0],
                                     location: location,
                                     comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 418)
  def _reduce_70(val, _values, result)
            unless val[2].value.class?
          raise SemanticsError.new("Should prepend module", subject: val[2].value, location: val[2].location)
        end
        location = val[1].location + val[2].location
        result = Members::Prepend.new(name: val[2].value,
                                      args: [],
                                      annotations: val[0],
                                      location: location,
                                      comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 429)
  def _reduce_71(val, _values, result)
            unless val[2].value.class?
          raise SemanticsError.new("Should prepend module", subject: val[2].value, location: val[2].location)
        end
        location = val[1].location + val[5].location
        result = Members::Prepend.new(name: val[2].value,
                                      args: val[4],
                                      annotations: val[0],
                                      location: location,
                                      comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 441)
  def _reduce_72(val, _values, result)
     result = nil
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 443)
  def _reduce_73(val, _values, result)
            RBS.logger.warn "`overload def` syntax is deprecated. Use `...` syntax instead."
        result = val[0]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 449)
  def _reduce_74(val, _values, result)
            location = val[3].location + val[6].last.location

        last_type = val[6].last
        if last_type.is_a?(LocatedValue) && last_type.value == :dot3
          overload = true
          val[6].pop
        else
          overload = false
        end

        result = Members::MethodDefinition.new(
          name: val[5].value,
          kind: val[4],
          types: val[6],
          annotations: val[0],
          location: location,
          comment: leading_comment(val[0].first&.location || val[2]&.location || val[3].location),
          overload: overload || !!val[2]
        )

    result
  end
.,.,

# reduce 75 omitted

module_eval(<<'.,.,', 'parser.y', 472)
  def _reduce_76(val, _values, result)
            RBS.logger.warn "`incompatible` method attribute is deprecated and ignored."

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 476)
  def _reduce_77(val, _values, result)
     result = :instance
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 477)
  def _reduce_78(val, _values, result)
     result = :singleton
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 478)
  def _reduce_79(val, _values, result)
     result = :singleton_instance
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 481)
  def _reduce_80(val, _values, result)
     result = [val[0]]
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 482)
  def _reduce_81(val, _values, result)
     result = [LocatedValue.new(value: :dot3, location: val[0].location)]
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 484)
  def _reduce_82(val, _values, result)
            result = val[2].unshift(val[0])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 489)
  def _reduce_83(val, _values, result)
            reset_variable_scope

        location = (val[1] || val[2]).location + val[2].location
        type_params = val[1]&.value || []

        type, block = val[2].value

        result = MethodType.new(type_params: type_params,
                                type: type,
                                block: block,
                                location: location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 503)
  def _reduce_84(val, _values, result)
     result = nil
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 505)
  def _reduce_85(val, _values, result)
            result = LocatedValue.new(value: val[1], location: val[0].location + val[2].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 510)
  def _reduce_86(val, _values, result)
            block = Types::Block.new(type: val[1].value, required: true)
        result = LocatedValue.new(value: block, location: val[0].location + val[2].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 514)
  def _reduce_87(val, _values, result)
            block = Types::Block.new(type: val[2].value, required: false)
        result = LocatedValue.new(value: block, location: val[0].location + val[3].location)

    result
  end
.,.,

# reduce 88 omitted

module_eval(<<'.,.,', 'parser.y', 521)
  def _reduce_89(val, _values, result)
            result = LocatedValue.new(value: val[0].value.to_sym,
                                  location: val[0].location + val[1].location)

    result
  end
.,.,

# reduce 90 omitted

# reduce 91 omitted

# reduce 92 omitted

# reduce 93 omitted

# reduce 94 omitted

# reduce 95 omitted

# reduce 96 omitted

# reduce 97 omitted

# reduce 98 omitted

module_eval(<<'.,.,', 'parser.y', 530)
  def _reduce_99(val, _values, result)
            unless val[0].location.pred?(val[1].location)
          raise SyntaxError.new(token_str: "kQUESTION", error_value: val[1])
        end

        result = LocatedValue.new(value: "#{val[0].value}?",
                                  location: val[0].location + val[1].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 538)
  def _reduce_100(val, _values, result)
            unless val[0].location.pred?(val[1].location)
          raise SyntaxError.new(token_str: "kEXCLAMATION", error_value: val[1])
        end

        result = LocatedValue.new(value: "#{val[0].value}!",
                                  location: val[0].location + val[1].location)

    result
  end
.,.,

# reduce 101 omitted

# reduce 102 omitted

# reduce 103 omitted

# reduce 104 omitted

# reduce 105 omitted

# reduce 106 omitted

# reduce 107 omitted

# reduce 108 omitted

# reduce 109 omitted

# reduce 110 omitted

# reduce 111 omitted

# reduce 112 omitted

# reduce 113 omitted

# reduce 114 omitted

# reduce 115 omitted

# reduce 116 omitted

# reduce 117 omitted

# reduce 118 omitted

# reduce 119 omitted

# reduce 120 omitted

# reduce 121 omitted

# reduce 122 omitted

# reduce 123 omitted

# reduce 124 omitted

# reduce 125 omitted

# reduce 126 omitted

# reduce 127 omitted

# reduce 128 omitted

# reduce 129 omitted

# reduce 130 omitted

# reduce 131 omitted

# reduce 132 omitted

# reduce 133 omitted

# reduce 134 omitted

# reduce 135 omitted

# reduce 136 omitted

# reduce 137 omitted

# reduce 138 omitted

# reduce 139 omitted

# reduce 140 omitted

module_eval(<<'.,.,', 'parser.y', 558)
  def _reduce_141(val, _values, result)
     result = nil
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 560)
  def _reduce_142(val, _values, result)
            val[1].each {|p| insert_bound_variable(p.name) }

        result = LocatedValue.new(value: val[1], location: val[0].location + val[2].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 567)
  def _reduce_143(val, _values, result)
            result = Declarations::ModuleTypeParams.new()
        result.add(val[0])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 571)
  def _reduce_144(val, _values, result)
            result = val[0].add(val[2])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 576)
  def _reduce_145(val, _values, result)
            result = Declarations::ModuleTypeParams::TypeParam.new(name: val[2].value.to_sym,
                                                               variance: val[1],
                                                               skip_validation: val[0])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 582)
  def _reduce_146(val, _values, result)
     result = :invariant
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 583)
  def _reduce_147(val, _values, result)
     result = :covariant
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 584)
  def _reduce_148(val, _values, result)
     result = :contravariant
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 587)
  def _reduce_149(val, _values, result)
     result = false
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 588)
  def _reduce_150(val, _values, result)
     result = true
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 591)
  def _reduce_151(val, _values, result)
     result = nil
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 593)
  def _reduce_152(val, _values, result)
            val[1].each {|var| insert_bound_variable(var) }

        result = LocatedValue.new(value: val[1],
                                  location: val[0].location + val[2].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 601)
  def _reduce_153(val, _values, result)
            result = [val[0].value.to_sym]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 604)
  def _reduce_154(val, _values, result)
            result = val[0].push(val[2].value.to_sym)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 609)
  def _reduce_155(val, _values, result)
            location = val[1].location + val[3].location
        result = Members::Alias.new(
          new_name: val[2].value.to_sym,
          old_name: val[3].value.to_sym,
          kind: :instance,
          annotations: val[0],
          location: location,
          comment: leading_comment(val[0].first&.location || location)
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 620)
  def _reduce_156(val, _values, result)
            location = val[1].location + val[7].location
        result = Members::Alias.new(
          new_name: val[4].value.to_sym,
          old_name: val[7].value.to_sym,
          kind: :singleton,
          annotations: val[0],
          location: location,
          comment: leading_comment(val[0].first&.location || location)
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 633)
  def _reduce_157(val, _values, result)
            location = val[1].location + val[4].location
        result = Declarations::Alias.new(name: val[2].value,
                                         type: val[4],
                                         annotations: val[0],
                                         location: location,
                                         comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 643)
  def _reduce_158(val, _values, result)
            location = val[0].location + val[2].location
        result = Declarations::Constant.new(name: val[0].value,
                                            type: val[2],
                                            location: location,
                                            comment: leading_comment(location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 650)
  def _reduce_159(val, _values, result)
            location = (val[0] || val[1]).location + val[2].location
        name = TypeName.new(name: val[1].value, namespace: val[0]&.value || Namespace.empty)
        result = Declarations::Constant.new(name: name,
                                            type: val[2],
                                            location: location,
                                            comment: leading_comment(location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 660)
  def _reduce_160(val, _values, result)
            location = val[0].location + val[2].location
        result = Declarations::Global.new(name: val[0].value.to_sym,
                                          type: val[2],
                                          location: location,
                                          comment: leading_comment(location))

    result
  end
.,.,

# reduce 161 omitted

module_eval(<<'.,.,', 'parser.y', 670)
  def _reduce_162(val, _values, result)
            types = case l = val[0]
                when Types::Union
                  l.types + [val[2]]
                else
                  [l, val[2]]
                end

        result = Types::Union.new(types: types, location: val[0].location + val[2].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 680)
  def _reduce_163(val, _values, result)
            types = case l = val[0]
                when Types::Intersection
                  l.types + [val[2]]
                else
                  [l, val[2]]
                end

        result = Types::Intersection.new(types: types,
                                         location: val[0].location + val[2].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 693)
  def _reduce_164(val, _values, result)
            result = Types::Bases::Void.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 696)
  def _reduce_165(val, _values, result)
            RBS.logger.warn "`any` type is deprecated. Use `untyped` instead. (#{val[0].location.to_s})"
        result = Types::Bases::Any.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 700)
  def _reduce_166(val, _values, result)
            result = Types::Bases::Any.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 703)
  def _reduce_167(val, _values, result)
            result = Types::Bases::Bool.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 706)
  def _reduce_168(val, _values, result)
            result = Types::Bases::Nil.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 709)
  def _reduce_169(val, _values, result)
            result = Types::Bases::Top.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 712)
  def _reduce_170(val, _values, result)
            result = Types::Bases::Bottom.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 715)
  def _reduce_171(val, _values, result)
            result = Types::Bases::Self.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 718)
  def _reduce_172(val, _values, result)
            result = Types::Optional.new(type: Types::Bases::Self.new(location: val[0].location),
                                     location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 722)
  def _reduce_173(val, _values, result)
            result = Types::Bases::Instance.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 725)
  def _reduce_174(val, _values, result)
            result = Types::Bases::Class.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 728)
  def _reduce_175(val, _values, result)
            result = Types::Literal.new(literal: true, location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 731)
  def _reduce_176(val, _values, result)
            result = Types::Literal.new(literal: false, location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 734)
  def _reduce_177(val, _values, result)
            result = Types::Literal.new(literal: val[0].value, location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 737)
  def _reduce_178(val, _values, result)
            result = Types::Literal.new(literal: val[0].value, location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 740)
  def _reduce_179(val, _values, result)
            result = Types::Literal.new(literal: val[0].value, location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 743)
  def _reduce_180(val, _values, result)
            name = val[0].value
        args = []
        location = val[0].location

        case
        when name.class?
          if is_bound_variable?(name.name)
            result = Types::Variable.new(name: name.name, location: location)
          else
            result = Types::ClassInstance.new(name: name, args: args, location: location)
          end
        when name.alias?
          result = Types::Alias.new(name: name, location: location)
        when name.interface?
          result = Types::Interface.new(name: name, args: args, location: location)
        end

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 761)
  def _reduce_181(val, _values, result)
            name = val[0].value
        args = val[2]
        location = val[0].location + val[3].location

        case
        when name.class?
          if is_bound_variable?(name.name)
            raise SemanticsError.new("#{name.name} is type variable and cannot be applied", subject: name, location: location)
          end
          result = Types::ClassInstance.new(name: name, args: args, location: location)
        when name.interface?
          result = Types::Interface.new(name: name, args: args, location: location)
        else
          raise SyntaxError.new(token_str: "kLBRACKET", error_value: val[1])
        end

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 778)
  def _reduce_182(val, _values, result)
            location = val[0].location + val[1].location
        result = Types::Tuple.new(types: [], location: location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 782)
  def _reduce_183(val, _values, result)
            location = val[0].location + val[2].location
        types = val[1]
        result = Types::Tuple.new(types: types, location: location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 787)
  def _reduce_184(val, _values, result)
            type = val[1].dup
        type.instance_eval do
          @location = val[0].location + val[2].location
        end
        result = type

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 794)
  def _reduce_185(val, _values, result)
            result = Types::ClassSingleton.new(name: val[2].value,
                                           location: val[0].location + val[3].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 798)
  def _reduce_186(val, _values, result)
            type, block = val[1].value
        result = Types::Proc.new(type: type, block: block, location: val[0].location + val[1].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 802)
  def _reduce_187(val, _values, result)
            result = Types::Optional.new(type: val[0], location: val[0].location + val[1].location)

    result
  end
.,.,

# reduce 188 omitted

module_eval(<<'.,.,', 'parser.y', 808)
  def _reduce_189(val, _values, result)
            result = [val[0]]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 811)
  def _reduce_190(val, _values, result)
            result = val[0] + [val[2]]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 816)
  def _reduce_191(val, _values, result)
            result = Types::Record.new(
          fields: val[1],
          location: val[0].location + val[2].location
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 824)
  def _reduce_192(val, _values, result)
            result = val[0]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 827)
  def _reduce_193(val, _values, result)
            result = val[0].merge!(val[2])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 832)
  def _reduce_194(val, _values, result)
            result = { val[0].value => val[2] }

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 835)
  def _reduce_195(val, _values, result)
            result = { val[0].value => val[2] }

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 838)
  def _reduce_196(val, _values, result)
            result = { val[0].value => val[2] }

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 841)
  def _reduce_197(val, _values, result)
            result = { val[0].value => val[1] }

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 844)
  def _reduce_198(val, _values, result)
            result = { val[0].value => val[2] }

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 847)
  def _reduce_199(val, _values, result)
            result = { val[0].value => val[2] }

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 850)
  def _reduce_200(val, _values, result)
            result = { val[0].value => val[2] }

    result
  end
.,.,

# reduce 201 omitted

module_eval(<<'.,.,', 'parser.y', 856)
  def _reduce_202(val, _values, result)
            result = val[0]

    result
  end
.,.,

# reduce 203 omitted

# reduce 204 omitted

# reduce 205 omitted

# reduce 206 omitted

module_eval(<<'.,.,', 'parser.y', 863)
  def _reduce_207(val, _values, result)
            location = (val[0] || val[1] || val[2]).location + val[3].location

        params = val[0]&.value || [[], [], nil, [], {}, {}, nil]

        type = Types::Function.new(
          required_positionals: params[0],
          optional_positionals: params[1],
          rest_positionals: params[2],
          trailing_positionals: params[3],
          required_keywords: params[4],
          optional_keywords: params[5],
          rest_keywords: params[6],
          return_type: val[3]
        )

        block = val[1].value

        result = LocatedValue.new(value: [type, block], location: location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 883)
  def _reduce_208(val, _values, result)
            result = LocatedValue.new(value: [val[0].value, nil], location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 888)
  def _reduce_209(val, _values, result)
            location = val[0].location + val[4].location
        type = Types::Function.new(
          required_positionals: val[1][0],
          optional_positionals: val[1][1],
          rest_positionals: val[1][2],
          trailing_positionals: val[1][3],
          required_keywords: val[1][4],
          optional_keywords: val[1][5],
          rest_keywords: val[1][6],
          return_type: val[4],
        )

        result = LocatedValue.new(value: type, location: location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 903)
  def _reduce_210(val, _values, result)
            location = val[0].location + val[1].location
        type = Types::Function.new(
          required_positionals: [],
          optional_positionals: [],
          rest_positionals: nil,
          trailing_positionals: [],
          required_keywords: {},
          optional_keywords: {},
          rest_keywords: nil,
          return_type: val[1]
        )

        result = LocatedValue.new(value: type, location: location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 920)
  def _reduce_211(val, _values, result)
            result = val[2]
        result[0].unshift(val[0])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 924)
  def _reduce_212(val, _values, result)
            result = empty_params_result
        result[0].unshift(val[0])

    result
  end
.,.,

# reduce 213 omitted

module_eval(<<'.,.,', 'parser.y', 931)
  def _reduce_214(val, _values, result)
            result = val[2]
        result[1].unshift(val[0])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 935)
  def _reduce_215(val, _values, result)
            result = empty_params_result
        result[1].unshift(val[0])

    result
  end
.,.,

# reduce 216 omitted

module_eval(<<'.,.,', 'parser.y', 942)
  def _reduce_217(val, _values, result)
            result = val[2]
        result[2] = val[0]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 946)
  def _reduce_218(val, _values, result)
            result = empty_params_result
        result[2] = val[0]

    result
  end
.,.,

# reduce 219 omitted

module_eval(<<'.,.,', 'parser.y', 953)
  def _reduce_220(val, _values, result)
            result = val[2]
        result[3].unshift(val[0])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 957)
  def _reduce_221(val, _values, result)
            result = empty_params_result
        result[3].unshift(val[0])

    result
  end
.,.,

# reduce 222 omitted

module_eval(<<'.,.,', 'parser.y', 964)
  def _reduce_223(val, _values, result)
            result = empty_params_result

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 967)
  def _reduce_224(val, _values, result)
            result = val[2]
        result[4].merge!(val[0])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 971)
  def _reduce_225(val, _values, result)
            result = empty_params_result
        result[4].merge!(val[0])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 975)
  def _reduce_226(val, _values, result)
            result = val[2]
        result[5].merge!(val[0])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 979)
  def _reduce_227(val, _values, result)
            result = empty_params_result
        result[5].merge!(val[0])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 983)
  def _reduce_228(val, _values, result)
            result = empty_params_result
        result[6] = val[0]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 989)
  def _reduce_229(val, _values, result)
            result = Types::Function::Param.new(type: val[0],
                                            name: val[1]&.value&.to_sym)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 995)
  def _reduce_230(val, _values, result)
            result = Types::Function::Param.new(type: val[1],
                                            name: val[2]&.value&.to_sym)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1001)
  def _reduce_231(val, _values, result)
            result = Types::Function::Param.new(type: val[1],
                                            name: val[2]&.value&.to_sym)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1007)
  def _reduce_232(val, _values, result)
            param = Types::Function::Param.new(type: val[1],
                                           name: val[2]&.value&.to_sym)
        result = { val[0].value => param }

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1014)
  def _reduce_233(val, _values, result)
            param = Types::Function::Param.new(type: val[2],
                                           name: val[3]&.value&.to_sym)
        result = { val[1].value => param }

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1021)
  def _reduce_234(val, _values, result)
            result = Types::Function::Param.new(type: val[1],
                                            name: val[2]&.value&.to_sym)

    result
  end
.,.,

# reduce 235 omitted

# reduce 236 omitted

# reduce 237 omitted

# reduce 238 omitted

module_eval(<<'.,.,', 'parser.y', 1030)
  def _reduce_239(val, _values, result)
            namespace = val[0]&.value || Namespace.empty
        name = val[1].value.to_sym
        type_name = TypeName.new(namespace: namespace, name: name)
        location = (loc0 = val[0]&.location) ? loc0 + val[1].location : val[1].location
        result = LocatedValue.new(value: type_name, location: location)

    result
  end
.,.,

# reduce 240 omitted

# reduce 241 omitted

# reduce 242 omitted

module_eval(<<'.,.,', 'parser.y', 1042)
  def _reduce_243(val, _values, result)
            namespace = val[0]&.value || Namespace.empty
        name = val[1].value.to_sym
        type_name = TypeName.new(namespace: namespace, name: name)
        location = (loc0 = val[0]&.location) ? loc0 + val[1].location : val[1].location
        result = LocatedValue.new(value: type_name, location: location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1051)
  def _reduce_244(val, _values, result)
            namespace = val[0]&.value || Namespace.empty
        name = val[1].value.to_sym
        type_name = TypeName.new(namespace: namespace, name: name)
        location = (loc0 = val[0]&.location) ? loc0 + val[1].location : val[1].location
        result = LocatedValue.new(value: type_name, location: location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1060)
  def _reduce_245(val, _values, result)
            result = nil

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1063)
  def _reduce_246(val, _values, result)
            result = LocatedValue.new(value: Namespace.root, location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1066)
  def _reduce_247(val, _values, result)
            namespace = Namespace.parse(val[1].value).absolute!
        result = LocatedValue.new(value: namespace, location: val[0].location + val[1].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1070)
  def _reduce_248(val, _values, result)
            namespace = Namespace.parse(val[0].value)
        result = LocatedValue.new(value: namespace, location: val[0].location)

    result
  end
.,.,

def _reduce_none(val, _values, result)
  val[0]
end

  end   # class Parser
end   # module RBS


