/* -*-c-*-
 THIS FILE WAS AUTOGENERATED BY template/prelude.c.tmpl. DO NOT EDIT.

 sources: ./ast, ./dir, ./gc, ./integer, ./io, ./pack, ./trace_point, ./warning, ./array, ./kernel, ./ractor, ./prelude, ./gem_prelude
*/
#include "internal.h"
#include "internal/warnings.h"
#include "iseq.h"
#include "ruby/ruby.h"
#include "vm_core.h"

COMPILER_WARNING_PUSH
#if __has_warning("-Wstring-concatenation")
COMPILER_WARNING_IGNORED(-Wstring-concatenation)
#endif

static const char prelude_name0[] = "<internal:ast>";
static const struct {
    char L0[507]; /* 1..106 */
    char L106[361]; /* 107..147 */
} prelude_code0 = {
#line 1 "ast.rb"
"\n"/* for ast.c */
"\n"
"class RubyVM\n"
"\n"
"\n"/* AbstractSyntaxTree provides methods to parse Ruby code into */
"\n"/* abstract syntax trees. The nodes in the tree */
"\n"/* are instances of RubyVM::AbstractSyntaxTree::Node. */
"\n"/*  */
"\n"/* This module is MRI specific as it exposes implementation details */
"\n"/* of the MRI abstract syntax tree. */
"\n"/*  */
"\n"/* This module is experimental and its API is not stable, therefore it might */
"\n"/* change without notice. As examples, the order of children nodes is not */
"\n"/* guaranteed, the number of children nodes might change, there is no way to */
"\n"/* access children nodes by name, etc. */
"\n"/*  */
"\n"/* If you are looking for a stable API or an API working under multiple Ruby */
"\n"/* implementations, consider using the _parser_ gem or Ripper. If you would */
"\n"/* like to make RubyVM::AbstractSyntaxTree stable, please join the discussion */
"\n"/* at https://bugs.ruby-lang.org/issues/14844. */
"\n"/*  */
"  module AbstractSyntaxTree\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     RubyVM::AbstractSyntaxTree.parse(string) -> RubyVM::AbstractSyntaxTree::Node */
"\n"/*  */
"\n"/*  Parses the given _string_ into an abstract syntax tree, */
"\n"/*  returning the root node of that tree. */
"\n"/*  */
"\n"/*  SyntaxError is raised if the given _string_ is invalid syntax. */
"\n"/*  */
"\n"/*    RubyVM::AbstractSyntaxTree.parse("x = 1 + 2") */
"\n"/*    # => #<RubyVM::AbstractSyntaxTree::Node:SCOPE@1:0-1:9> */
"    def self.parse string\n"
"      Primitive.ast_s_parse string\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     RubyVM::AbstractSyntaxTree.parse_file(pathname) -> RubyVM::AbstractSyntaxTree::Node */
"\n"/*  */
"\n"/*   Reads the file from _pathname_, then parses it like ::parse, */
"\n"/*   returning the root node of the abstract syntax tree. */
"\n"/*  */
"\n"/*   SyntaxError is raised if _pathname_'s contents are not */
"\n"/*   valid Ruby syntax. */
"\n"/*  */
"\n"/*     RubyVM::AbstractSyntaxTree.parse_file("my-app/app.rb") */
"\n"/*     # => #<RubyVM::AbstractSyntaxTree::Node:SCOPE@1:0-31:3> */
"    def self.parse_file pathname\n"
"      Primitive.ast_s_parse_file pathname\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     RubyVM::AbstractSyntaxTree.of(proc)   -> RubyVM::AbstractSyntaxTree::Node */
"\n"/*     RubyVM::AbstractSyntaxTree.of(method) -> RubyVM::AbstractSyntaxTree::Node */
"\n"/*  */
"\n"/*   Returns AST nodes of the given _proc_ or _method_. */
"\n"/*  */
"\n"/*     RubyVM::AbstractSyntaxTree.of(proc {1 + 2}) */
"\n"/*     # => #<RubyVM::AbstractSyntaxTree::Node:SCOPE@1:35-1:42> */
"\n"/*  */
"\n"/*     def hello */
"\n"/*       puts "hello, world" */
"\n"/*     end */
"\n"/*  */
"\n"/*     RubyVM::AbstractSyntaxTree.of(method(:hello)) */
"\n"/*     # => #<RubyVM::AbstractSyntaxTree::Node:SCOPE@1:0-3:3> */
"    def self.of body\n"
"      Primitive.ast_s_of body\n"
"    end\n"
"\n"
"\n"/* RubyVM::AbstractSyntaxTree::Node instances are created by parse methods in */
"\n"/* RubyVM::AbstractSyntaxTree. */
"\n"/*  */
"\n"/* This class is MRI specific. */
"\n"/*  */
"    class Node\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.type -> symbol */
"\n"/*  */
"\n"/*  Returns the type of this node as a symbol. */
"\n"/*  */
"\n"/*    root = RubyVM::AbstractSyntaxTree.parse("x = 1 + 2") */
"\n"/*    root.type # => :SCOPE */
"\n"/*    lasgn = root.children[2] */
"\n"/*    lasgn.type # => :LASGN */
"\n"/*    call = lasgn.children[1] */
"\n"/*    call.type # => :OPCALL */
"      def type\n"
"        Primitive.ast_node_type\n"
"      end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.first_lineno -> integer */
"\n"/*  */
"\n"/*  The line number in the source code where this AST's text began. */
"      def first_lineno\n"
"        Primitive.ast_node_first_lineno\n"
"      end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.first_column -> integer */
"\n"/*  */
"\n"/*  The column number in the source code where this AST's text began. */
"      def first_column\n"
,
#line 107 "ast.rb"
"        Primitive.ast_node_first_column\n"
"      end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.last_lineno -> integer */
"\n"/*  */
"\n"/*  The line number in the source code where this AST's text ended. */
"      def last_lineno\n"
"        Primitive.ast_node_last_lineno\n"
"      end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.last_column -> integer */
"\n"/*  */
"\n"/*  The column number in the source code where this AST's text ended. */
"      def last_column\n"
"        Primitive.ast_node_last_column\n"
"      end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.children -> array */
"\n"/*  */
"\n"/*  Returns AST nodes under this one.  Each kind of node */
"\n"/*  has different children, depending on what kind of node it is. */
"\n"/*  */
"\n"/*  The returned array may contain other nodes or <code>nil</code>. */
"      def children\n"
"        Primitive.ast_node_children\n"
"      end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.inspect -> string */
"\n"/*  */
"\n"/*  Returns debugging information about this node as a string. */
"      def inspect\n"
"        Primitive.ast_node_inspect\n"
"      end\n"
"    end\n"
"  end\n"
"end\n"
#line 172 "miniprelude.c"
};

static const char prelude_name1[] = "<internal:dir>";
static const struct {
    char L0[508]; /* 1..109 */
    char L109[161]; /* 110..137 */
} prelude_code1 = {
#line 1 "dir.rb"
"class Dir\n"
"\n"/*    Dir.open( string ) -> aDir */
"\n"/*    Dir.open( string, encoding: enc ) -> aDir */
"\n"/*    Dir.open( string ) {| aDir | block } -> anObject */
"\n"/*    Dir.open( string, encoding: enc ) {| aDir | block } -> anObject */
"\n"/*  */
"\n"/* The optional <i>encoding</i> keyword argument specifies the encoding of the directory. */
"\n"/* If not specified, the filesystem encoding is used. */
"\n"/*  */
"\n"/* With no block, <code>open</code> is a synonym for Dir::new. If a */
"\n"/* block is present, it is passed <i>aDir</i> as a parameter. The */
"\n"/* directory is closed at the end of the block, and Dir::open returns */
"\n"/* the value of the block. */
"  def self.open(name, encoding: nil, &block)\n"
"    dir = Primitive.dir_s_open(name, encoding)\n"
"    if block\n"
"      begin\n"
"        yield dir\n"
"      ensure\n"
"        Primitive.dir_s_close(dir)\n"
"      end\n"
"    else\n"
"      dir\n"
"    end\n"
"  end\n"
"\n"
"\n"/*    Dir.new( string ) -> aDir */
"\n"/*    Dir.new( string, encoding: enc ) -> aDir */
"\n"/*  */
"\n"/* Returns a new directory object for the named directory. */
"\n"/*  */
"\n"/* The optional <i>encoding</i> keyword argument specifies the encoding of the directory. */
"\n"/* If not specified, the filesystem encoding is used. */
"  def initialize(name, encoding: nil)\n"
"    Primitive.dir_initialize(name, encoding)\n"
"  end\n"
"\n"
"\n"/*    Dir[ string [, string ...] [, base: path] [, sort: true] ] -> array */
"\n"/*  */
"\n"/* Equivalent to calling */
"\n"/* <code>Dir.glob([</code><i>string,...</i><code>], 0)</code>. */
"  def self.[](*args, base: nil, sort: true)\n"
"    Primitive.dir_s_aref(args, base, sort)\n"
"  end\n"
"\n"
"\n"/*    Dir.glob( pattern, [flags], [base: path] [, sort: true] )                       -> array */
"\n"/*    Dir.glob( pattern, [flags], [base: path] [, sort: true] ) { |filename| block }  -> nil */
"\n"/*  */
"\n"/* Expands +pattern+, which is a pattern string or an Array of pattern */
"\n"/* strings, and returns an array containing the matching filenames. */
"\n"/* If a block is given, calls the block once for each matching filename, */
"\n"/* passing the filename as a parameter to the block. */
"\n"/*  */
"\n"/* The optional +base+ keyword argument specifies the base directory for */
"\n"/* interpreting relative pathnames instead of the current working directory. */
"\n"/* As the results are not prefixed with the base directory name in this */
"\n"/* case, you will need to prepend the base directory name if you want real */
"\n"/* paths. */
"\n"/*  */
"\n"/* The results which matched single wildcard or character set are sorted in */
"\n"/* binary ascending order, unless false is given as the optional +sort+ */
"\n"/* keyword argument.  The order of an Array of pattern strings and braces */
"\n"/* are preserved. */
"\n"/*  */
"\n"/* Note that the pattern is not a regexp, it's closer to a shell glob. */
"\n"/* See File::fnmatch for the meaning of the +flags+ parameter. */
"\n"/* Case sensitivity depends on your system (File::FNM_CASEFOLD is ignored). */
"\n"/*  */
"\n"/* <code>*</code>:: */
"\n"/*   Matches any file. Can be restricted by other values in the glob. */
"\n"/*   Equivalent to <code>/ .* /mx</code> in regexp. */
"\n"/*  */
"\n"/*   <code>*</code>::     Matches all files */
"\n"/*   <code>c*</code>::    Matches all files beginning with <code>c</code> */
"\n"/*   <code>*c</code>::    Matches all files ending with <code>c</code> */
"\n"/*   <code>\*c\*</code>:: Match all files that have <code>c</code> in them */
"\n"/*                        (including at the beginning or end). */
"\n"/*  */
"\n"/*   Note, this will not match Unix-like hidden files (dotfiles).  In order */
"\n"/*   to include those in the match results, you must use the */
"\n"/*   File::FNM_DOTMATCH flag or something like <code>"{*,.*}"</code>. */
"\n"/*  */
"\n"/* <code>**</code>:: */
"\n"/*   Matches directories recursively if followed by <code>/</code>.  If */
"\n"/*   this path segment contains any other characters, it is the same as the */
"\n"/*   usual <code>*</code>. */
"\n"/*  */
"\n"/* <code>?</code>:: */
"\n"/*   Matches any one character. Equivalent to <code>/.{1}/</code> in regexp. */
"\n"/*  */
"\n"/* <code>[set]</code>:: */
"\n"/*   Matches any one character in +set+.  Behaves exactly like character sets */
"\n"/*   in Regexp, including set negation (<code>[^a-z]</code>). */
"\n"/*  */
"\n"/* <code>{p,q}</code>:: */
"\n"/*   Matches either literal <code>p</code> or literal <code>q</code>. */
"\n"/*   Equivalent to pattern alternation in regexp. */
"\n"/*  */
"\n"/*   Matching literals may be more than one character in length.  More than */
"\n"/*   two literals may be specified. */
"\n"/*  */
"\n"/* <code> \\ </code>:: */
"\n"/*   Escapes the next metacharacter. */
"\n"/*  */
"\n"/*   Note that this means you cannot use backslash on windows as part of a */
"\n"/*   glob, i.e.  <code>Dir["c:\\foo*"]</code> will not work, use */
"\n"/*   <code>Dir["c:/foo*"]</code> instead. */
"\n"/*  */
"\n"/* Examples: */
,
#line 110 "dir.rb"
"\n"/*  */
"\n"/*    Dir["config.?"]                     #=> ["config.h"] */
"\n"/*    Dir.glob("config.?")                #=> ["config.h"] */
"\n"/*    Dir.glob("*.[a-z][a-z]")            #=> ["main.rb"] */
"\n"/*    Dir.glob("*.[^r]*")                 #=> ["config.h"] */
"\n"/*    Dir.glob("*.{rb,h}")                #=> ["main.rb", "config.h"] */
"\n"/*    Dir.glob("*")                       #=> ["config.h", "main.rb"] */
"\n"/*    Dir.glob("*", File::FNM_DOTMATCH)   #=> [".", "..", "config.h", "main.rb"] */
"\n"/*    Dir.glob(["*.rb", "*.h"])           #=> ["main.rb", "config.h"] */
"\n"/*  */
"\n"/*    Dir.glob("**\/\*.rb")                 #=> ["main.rb", */
"\n"/*                                        #    "lib/song.rb", */
"\n"/*                                        #    "lib/song/karaoke.rb"] */
"\n"/*  */
"\n"/*    Dir.glob("**\/\*.rb", base: "lib")    #=> ["song.rb", */
"\n"/*                                        #    "song/karaoke.rb"] */
"\n"/*  */
"\n"/*    Dir.glob("**\/lib")                  #=> ["lib"] */
"\n"/*  */
"\n"/*    Dir.glob("**\/lib/\**\/\*.rb")          #=> ["lib/song.rb", */
"\n"/*                                        #    "lib/song/karaoke.rb"] */
"\n"/*  */
"\n"/*    Dir.glob("**\/lib/\*.rb")             #=> ["lib/song.rb"] */
"  def self.glob(pattern, _flags = 0, flags: _flags, base: nil, sort: true)\n"
"    Primitive.dir_s_glob(pattern, flags, base, sort)\n"
"  end\n"
"end\n"
#line 319 "miniprelude.c"
};

static const char prelude_name2[] = "<internal:gc>";
static const struct {
    char L0[489]; /* 1..58 */
    char L58[486]; /* 59..182 */
    char L182[430]; /* 183..235 */
    char L235[211]; /* 236..242 */
} prelude_code2 = {
#line 1 "gc.rb"
"\n"/* for gc.c */
"\n"
"\n"/*  The GC module provides an interface to Ruby's mark and */
"\n"/*  sweep garbage collection mechanism. */
"\n"/*  */
"\n"/*  Some of the underlying methods are also available via the ObjectSpace */
"\n"/*  module. */
"\n"/*  */
"\n"/*  You may obtain information about the operation of the GC through */
"\n"/*  GC::Profiler. */
"module GC\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     GC.start                     -> nil */
"\n"/*     ObjectSpace.garbage_collect  -> nil */
"\n"/*     include GC; garbage_collect  -> nil */
"\n"/*     GC.start(full_mark: true, immediate_sweep: true)           -> nil */
"\n"/*     ObjectSpace.garbage_collect(full_mark: true, immediate_sweep: true) -> nil */
"\n"/*     include GC; garbage_collect(full_mark: true, immediate_sweep: true) -> nil */
"\n"/*  */
"\n"/*  Initiates garbage collection, even if manually disabled. */
"\n"/*  */
"\n"/*  This method is defined with keyword arguments that default to true: */
"\n"/*  */
"\n"/*     def GC.start(full_mark: true, immediate_sweep: true); end */
"\n"/*  */
"\n"/*  Use full_mark: false to perform a minor GC. */
"\n"/*  Use immediate_sweep: false to defer sweeping (use lazy sweep). */
"\n"/*  */
"\n"/*  Note: These keyword arguments are implementation and version dependent. They */
"\n"/*  are not guaranteed to be future-compatible, and may be ignored if the */
"\n"/*  underlying implementation does not support them. */
"  def self.start full_mark: true, immediate_mark: true, immediate_sweep: true\n"
"    Primitive.gc_start_internal full_mark, immediate_mark, immediate_sweep, false\n"
"  end\n"
"\n"
"  def garbage_collect full_mark: true, immediate_mark: true, immediate_sweep: true\n"
"    Primitive.gc_start_internal full_mark, immediate_mark, immediate_sweep, false\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     GC.auto_compact    -> true or false */
"\n"/*  */
"\n"/*  Returns whether or not automatic compaction has been enabled. */
"\n"/*  */
"  def self.auto_compact\n"
"    Primitive.gc_get_auto_compact\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     GC.auto_compact = flag */
"\n"/*  */
"\n"/*  Updates automatic compaction mode. */
"\n"/*  */
"\n"/*  When enabled, the compactor will execute on every major collection. */
"\n"/*  */
"\n"/*  Enabling compaction will degrade performance on major collections. */
"  def self.auto_compact=(flag)\n"
,
#line 59 "gc.rb"
"    Primitive.gc_set_auto_compact(flag)\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     GC.enable    -> true or false */
"\n"/*  */
"\n"/*  Enables garbage collection, returning +true+ if garbage */
"\n"/*  collection was previously disabled. */
"\n"/*  */
"\n"/*     GC.disable   #=> false */
"\n"/*     GC.enable    #=> true */
"\n"/*     GC.enable    #=> false */
"\n"/*  */
"  def self.enable\n"
"    Primitive.gc_enable\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     GC.disable    -> true or false */
"\n"/*  */
"\n"/*  Disables garbage collection, returning +true+ if garbage */
"\n"/*  collection was already disabled. */
"\n"/*  */
"\n"/*     GC.disable   #=> false */
"\n"/*     GC.disable   #=> true */
"  def self.disable\n"
"    Primitive.gc_disable\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*    GC.stress	    -> integer, true or false */
"\n"/*  */
"\n"/*  Returns current status of GC stress mode. */
"  def self.stress\n"
"    Primitive.gc_stress_get\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*    GC.stress = flag          -> flag */
"\n"/*  */
"\n"/*  Updates the GC stress mode. */
"\n"/*  */
"\n"/*  When stress mode is enabled, the GC is invoked at every GC opportunity: */
"\n"/*  all memory and object allocations. */
"\n"/*  */
"\n"/*  Enabling stress mode will degrade performance, it is only for debugging. */
"\n"/*  */
"\n"/*  flag can be true, false, or an integer bit-ORed following flags. */
"\n"/*    0x01:: no major GC */
"\n"/*    0x02:: no immediate sweep */
"\n"/*    0x04:: full mark after malloc/calloc/realloc */
"  def self.stress=(flag)\n"
"    Primitive.gc_stress_set_m flag\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     GC.count -> Integer */
"\n"/*  */
"\n"/*  The number of times GC occurred. */
"\n"/*  */
"\n"/*  It returns the number of times GC occurred since the process started. */
"  def self.count\n"
"    Primitive.gc_count\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     GC.stat -> Hash */
"\n"/*     GC.stat(hash) -> hash */
"\n"/*     GC.stat(:key) -> Numeric */
"\n"/*  */
"\n"/*  Returns a Hash containing information about the GC. */
"\n"/*  */
"\n"/*  The hash includes information about internal statistics about GC such as: */
"\n"/*  */
"\n"/*      { */
"\n"/*          :count=>0, */
"\n"/*          :heap_allocated_pages=>24, */
"\n"/*          :heap_sorted_length=>24, */
"\n"/*          :heap_allocatable_pages=>0, */
"\n"/*          :heap_available_slots=>9783, */
"\n"/*          :heap_live_slots=>7713, */
"\n"/*          :heap_free_slots=>2070, */
"\n"/*          :heap_final_slots=>0, */
"\n"/*          :heap_marked_slots=>0, */
"\n"/*          :heap_eden_pages=>24, */
"\n"/*          :heap_tomb_pages=>0, */
"\n"/*          :total_allocated_pages=>24, */
"\n"/*          :total_freed_pages=>0, */
"\n"/*          :total_allocated_objects=>7796, */
"\n"/*          :total_freed_objects=>83, */
"\n"/*          :malloc_increase_bytes=>2389312, */
"\n"/*          :malloc_increase_bytes_limit=>16777216, */
"\n"/*          :minor_gc_count=>0, */
"\n"/*          :major_gc_count=>0, */
"\n"/*          :remembered_wb_unprotected_objects=>0, */
"\n"/*          :remembered_wb_unprotected_objects_limit=>0, */
"\n"/*          :old_objects=>0, */
"\n"/*          :old_objects_limit=>0, */
"\n"/*          :oldmalloc_increase_bytes=>2389760, */
"\n"/*          :oldmalloc_increase_bytes_limit=>16777216 */
"\n"/*      } */
"\n"/*  */
"\n"/*  The contents of the hash are implementation specific and may be changed in */
"\n"/*  the future. */
"\n"/*  */
"\n"/*  If the optional argument, hash, is given, */
"\n"/*  it is overwritten and returned. */
"\n"/*  This is intended to avoid probe effect. */
"\n"/*  */
"\n"/*  This method is only expected to work on C Ruby. */
"  def self.stat hash_or_key = nil\n"
"    Primitive.gc_stat hash_or_key\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     GC.latest_gc_info -> {:gc_by=>:newobj} */
"\n"/*     GC.latest_gc_info(hash) -> hash */
"\n"/*     GC.latest_gc_info(:major_by) -> :malloc */
"\n"/*  */
"\n"/*  Returns information about the most recent garbage collection. */
"\n"/*  */
"\n"/* If the optional argument, hash, is given, */
"\n"/* it is overwritten and returned. */
"\n"/* This is intended to avoid probe effect. */
,
#line 183 "gc.rb"
"  def self.latest_gc_info hash_or_key = nil\n"
"    Primitive.gc_latest_gc_info hash_or_key\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     GC.latest_compact_info -> {:considered=>{:T_CLASS=>11}, :moved=>{:T_CLASS=>11}} */
"\n"/*  */
"\n"/*  Returns information about object moved in the most recent GC compaction. */
"\n"/*  */
"\n"/* The returned hash has two keys :considered and :moved.  The hash for */
"\n"/* :considered lists the number of objects that were considered for movement */
"\n"/* by the compactor, and the :moved hash lists the number of objects that */
"\n"/* were actually moved.  Some objects can't be moved (maybe they were pinned) */
"\n"/* so these numbers can be used to calculate compaction efficiency. */
"  def self.latest_compact_info\n"
"    Primitive.gc_compact_stats\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     GC.compact */
"\n"/*  */
"\n"/* This function compacts objects together in Ruby's heap.  It eliminates */
"\n"/* unused space (or fragmentation) in the heap by moving objects in to that */
"\n"/* unused space.  This function returns a hash which contains statistics about */
"\n"/* which objects were moved.  See `GC.latest_gc_info` for details about */
"\n"/* compaction statistics. */
"\n"/*  */
"\n"/* This method is implementation specific and not expected to be implemented */
"\n"/* in any implementation besides MRI. */
"  def self.compact\n"
"    Primitive.gc_compact\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    GC.verify_compaction_references(toward: nil, double_heap: false) -> hash */
"\n"/*  */
"\n"/* Verify compaction reference consistency. */
"\n"/*  */
"\n"/* This method is implementation specific.  During compaction, objects that */
"\n"/* were moved are replaced with T_MOVED objects.  No object should have a */
"\n"/* reference to a T_MOVED object after compaction. */
"\n"/*  */
"\n"/* This function doubles the heap to ensure room to move all objects, */
"\n"/* compacts the heap to make sure everything moves, updates all references, */
"\n"/* then performs a full GC.  If any object contains a reference to a T_MOVED */
"\n"/* object, that object should be pushed on the mark stack, and will */
"\n"/* make a SEGV. */
"  def self.verify_compaction_references(toward: nil, double_heap: false)\n"
"    Primitive.gc_verify_compaction_references(double_heap, toward == :empty)\n"
"  end\n"
"end\n"
"\n"
"module ObjectSpace\n"
,
#line 236 "gc.rb"
"  def garbage_collect full_mark: true, immediate_mark: true, immediate_sweep: true\n"
"    Primitive.gc_start_internal full_mark, immediate_mark, immediate_sweep, false\n"
"  end\n"
"\n"
"  module_function :garbage_collect\n"
"end\n"
#line 577 "miniprelude.c"
};

static const char prelude_name3[] = "<internal:integer>";
static const struct {
    char L0[485]; /* 1..79 */
    char L79[300]; /* 80..126 */
} prelude_code3 = {
#line 1 "integer.rb"
"class Integer\n"
"  def abs\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_int_abs(self)'\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    int.bit_length  ->  integer */
"\n"/*  */
"\n"/* Returns the number of bits of the value of +int+. */
"\n"/*  */
"\n"/* "Number of bits" means the bit position of the highest bit */
"\n"/* which is different from the sign bit */
"\n"/* (where the least significant bit has bit position 1). */
"\n"/* If there is no such bit (zero or minus one), zero is returned. */
"\n"/*  */
"\n"/* I.e. this method returns <i>ceil(log2(int < 0 ? -int : int+1))</i>. */
"\n"/*  */
"\n"/*    (-2**1000-1).bit_length   #=> 1001 */
"\n"/*    (-2**1000).bit_length     #=> 1000 */
"\n"/*    (-2**1000+1).bit_length   #=> 1000 */
"\n"/*    (-2**12-1).bit_length     #=> 13 */
"\n"/*    (-2**12).bit_length       #=> 12 */
"\n"/*    (-2**12+1).bit_length     #=> 12 */
"\n"/*    -0x101.bit_length         #=> 9 */
"\n"/*    -0x100.bit_length         #=> 8 */
"\n"/*    -0xff.bit_length          #=> 8 */
"\n"/*    -2.bit_length             #=> 1 */
"\n"/*    -1.bit_length             #=> 0 */
"\n"/*    0.bit_length              #=> 0 */
"\n"/*    1.bit_length              #=> 1 */
"\n"/*    0xff.bit_length           #=> 8 */
"\n"/*    0x100.bit_length          #=> 9 */
"\n"/*    (2**12-1).bit_length      #=> 12 */
"\n"/*    (2**12).bit_length        #=> 13 */
"\n"/*    (2**12+1).bit_length      #=> 13 */
"\n"/*    (2**1000-1).bit_length    #=> 1000 */
"\n"/*    (2**1000).bit_length      #=> 1001 */
"\n"/*    (2**1000+1).bit_length    #=> 1001 */
"\n"/*  */
"\n"/* This method can be used to detect overflow in Array#pack as follows: */
"\n"/*  */
"\n"/*    if n.bit_length < 32 */
"\n"/*      [n].pack("l") # no overflow */
"\n"/*    else */
"\n"/*      raise "overflow" */
"\n"/*    end */
"  def bit_length\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_int_bit_length(self)'\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     int.even?  ->  true or false */
"\n"/*  */
"\n"/*  Returns +true+ if +int+ is an even number. */
"  def even?\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_int_even_p(self)'\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     int.integer?  ->  true */
"\n"/*  */
"\n"/*  Since +int+ is already an Integer, this always returns +true+. */
"  def integer?\n"
"    return true\n"
"  end\n"
"\n"
"  def magnitude\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_int_abs(self)'\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     int.odd?  ->  true or false */
"\n"/*  */
"\n"/*  Returns +true+ if +int+ is an odd number. */
"  def odd?\n"
,
#line 80 "integer.rb"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_int_odd_p(self)'\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     int.ord  ->  self */
"\n"/*  */
"\n"/*  Returns the +int+ itself. */
"\n"/*  */
"\n"/*     97.ord   #=> 97 */
"\n"/*  */
"\n"/*  This method is intended for compatibility to character literals */
"\n"/*  in Ruby 1.9. */
"\n"/*  */
"\n"/*  For example, <code>?a.ord</code> returns 97 both in 1.8 and 1.9. */
"  def ord\n"
"    return self\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     int.to_i    ->  integer */
"\n"/*  */
"\n"/*  Since +int+ is already an Integer, returns +self+. */
"\n"/*  */
"\n"/*  #to_int is an alias for #to_i. */
"  def to_i\n"
"    return self\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     int.to_int  ->  integer */
"\n"/*  */
"\n"/*  Since +int+ is already an Integer, returns +self+. */
"  def to_int\n"
"    return self\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    int.zero? -> true or false */
"\n"/*  */
"\n"/* Returns +true+ if +int+ has a zero value. */
"  def zero?\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_int_zero_p(self)'\n"
"  end\n"
"end\n"
#line 713 "miniprelude.c"
};

static const char prelude_name4[] = "<internal:io>";
static const struct {
    char L0[336]; /* 1..124 */
} prelude_code4 = {
#line 1 "io.rb"
"class IO\n"
"\n"/* other IO methods are defined in io.c */
"\n"
"\n"/* call-seq: */
"\n"/*    ios.read_nonblock(maxlen [, options])              -> string */
"\n"/*    ios.read_nonblock(maxlen, outbuf [, options])      -> outbuf */
"\n"/*  */
"\n"/* Reads at most <i>maxlen</i> bytes from <em>ios</em> using */
"\n"/* the read(2) system call after O_NONBLOCK is set for */
"\n"/* the underlying file descriptor. */
"\n"/*  */
"\n"/* If the optional <i>outbuf</i> argument is present, */
"\n"/* it must reference a String, which will receive the data. */
"\n"/* The <i>outbuf</i> will contain only the received data after the method call */
"\n"/* even if it is not empty at the beginning. */
"\n"/*  */
"\n"/* read_nonblock just calls the read(2) system call. */
"\n"/* It causes all errors the read(2) system call causes: Errno::EWOULDBLOCK, Errno::EINTR, etc. */
"\n"/* The caller should care such errors. */
"\n"/*  */
"\n"/* If the exception is Errno::EWOULDBLOCK or Errno::EAGAIN, */
"\n"/* it is extended by IO::WaitReadable. */
"\n"/* So IO::WaitReadable can be used to rescue the exceptions for retrying */
"\n"/* read_nonblock. */
"\n"/*  */
"\n"/* read_nonblock causes EOFError on EOF. */
"\n"/*  */
"\n"/* On some platforms, such as Windows, non-blocking mode is not supported */
"\n"/* on IO objects other than sockets. In such cases, Errno::EBADF will */
"\n"/* be raised. */
"\n"/*  */
"\n"/* If the read byte buffer is not empty, */
"\n"/* read_nonblock reads from the buffer like readpartial. */
"\n"/* In this case, the read(2) system call is not called. */
"\n"/*  */
"\n"/* When read_nonblock raises an exception kind of IO::WaitReadable, */
"\n"/* read_nonblock should not be called */
"\n"/* until io is readable for avoiding busy loop. */
"\n"/* This can be done as follows. */
"\n"/*  */
"\n"/*   # emulates blocking read (readpartial). */
"\n"/*   begin */
"\n"/*     result = io.read_nonblock(maxlen) */
"\n"/*   rescue IO::WaitReadable */
"\n"/*     IO.select([io]) */
"\n"/*     retry */
"\n"/*   end */
"\n"/*  */
"\n"/* Although IO#read_nonblock doesn't raise IO::WaitWritable. */
"\n"/* OpenSSL::Buffering#read_nonblock can raise IO::WaitWritable. */
"\n"/* If IO and SSL should be used polymorphically, */
"\n"/* IO::WaitWritable should be rescued too. */
"\n"/* See the document of OpenSSL::Buffering#read_nonblock for sample code. */
"\n"/*  */
"\n"/* Note that this method is identical to readpartial */
"\n"/* except the non-blocking flag is set. */
"\n"/*  */
"\n"/* By specifying a keyword argument _exception_ to +false+, you can indicate */
"\n"/* that read_nonblock should not raise an IO::WaitReadable exception, but */
"\n"/* return the symbol +:wait_readable+ instead. At EOF, it will return nil */
"\n"/* instead of raising EOFError. */
"  def read_nonblock(len, buf = nil, exception: true)\n"
"    Primitive.io_read_nonblock(len, buf, exception)\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    ios.write_nonblock(string)   -> integer */
"\n"/*    ios.write_nonblock(string [, options])   -> integer */
"\n"/*  */
"\n"/* Writes the given string to <em>ios</em> using */
"\n"/* the write(2) system call after O_NONBLOCK is set for */
"\n"/* the underlying file descriptor. */
"\n"/*  */
"\n"/* It returns the number of bytes written. */
"\n"/*  */
"\n"/* write_nonblock just calls the write(2) system call. */
"\n"/* It causes all errors the write(2) system call causes: Errno::EWOULDBLOCK, Errno::EINTR, etc. */
"\n"/* The result may also be smaller than string.length (partial write). */
"\n"/* The caller should care such errors and partial write. */
"\n"/*  */
"\n"/* If the exception is Errno::EWOULDBLOCK or Errno::EAGAIN, */
"\n"/* it is extended by IO::WaitWritable. */
"\n"/* So IO::WaitWritable can be used to rescue the exceptions for retrying write_nonblock. */
"\n"/*  */
"\n"/*   # Creates a pipe. */
"\n"/*   r, w = IO.pipe */
"\n"/*  */
"\n"/*   # write_nonblock writes only 65536 bytes and return 65536. */
"\n"/*   # (The pipe size is 65536 bytes on this environment.) */
"\n"/*   s = "a" * 100000 */
"\n"/*   p w.write_nonblock(s)     #=> 65536 */
"\n"/*  */
"\n"/*   # write_nonblock cannot write a byte and raise EWOULDBLOCK (EAGAIN). */
"\n"/*   p w.write_nonblock("b")   # Resource temporarily unavailable (Errno::EAGAIN) */
"\n"/*  */
"\n"/* If the write buffer is not empty, it is flushed at first. */
"\n"/*  */
"\n"/* When write_nonblock raises an exception kind of IO::WaitWritable, */
"\n"/* write_nonblock should not be called */
"\n"/* until io is writable for avoiding busy loop. */
"\n"/* This can be done as follows. */
"\n"/*  */
"\n"/*   begin */
"\n"/*     result = io.write_nonblock(string) */
"\n"/*   rescue IO::WaitWritable, Errno::EINTR */
"\n"/*     IO.select(nil, [io]) */
"\n"/*     retry */
"\n"/*   end */
"\n"/*  */
"\n"/* Note that this doesn't guarantee to write all data in string. */
"\n"/* The length written is reported as result and it should be checked later. */
"\n"/*  */
"\n"/* On some platforms such as Windows, write_nonblock is not supported */
"\n"/* according to the kind of the IO object. */
"\n"/* In such cases, write_nonblock raises <code>Errno::EBADF</code>. */
"\n"/*  */
"\n"/* By specifying a keyword argument _exception_ to +false+, you can indicate */
"\n"/* that write_nonblock should not raise an IO::WaitWritable exception, but */
"\n"/* return the symbol +:wait_writable+ instead. */
"  def write_nonblock(buf, exception: true)\n"
"    Primitive.io_write_nonblock(buf, exception)\n"
"  end\n"
"end\n"
#line 844 "miniprelude.c"
};

static const char prelude_name5[] = "<internal:pack>";
static const struct {
    char L0[487]; /* 1..284 */
} prelude_code5 = {
#line 1 "pack.rb"
"\n"/* for pack.c */
"\n"
"class Array\n"
"\n"/*  call-seq: */
"\n"/*     arr.pack( aTemplateString ) -> aBinaryString */
"\n"/*     arr.pack( aTemplateString, buffer: aBufferString ) -> aBufferString */
"\n"/*  */
"\n"/*  Packs the contents of <i>arr</i> into a binary sequence according to */
"\n"/*  the directives in <i>aTemplateString</i> (see the table below) */
"\n"/*  Directives ``A,'' ``a,'' and ``Z'' may be followed by a count, */
"\n"/*  which gives the width of the resulting field. The remaining */
"\n"/*  directives also may take a count, indicating the number of array */
"\n"/*  elements to convert. If the count is an asterisk */
"\n"/*  (``<code>*</code>''), all remaining array elements will be */
"\n"/*  converted. Any of the directives ``<code>sSiIlL</code>'' may be */
"\n"/*  followed by an underscore (``<code>_</code>'') or */
"\n"/*  exclamation mark (``<code>!</code>'') to use the underlying */
"\n"/*  platform's native size for the specified type; otherwise, they use a */
"\n"/*  platform-independent size. Spaces are ignored in the template */
"\n"/*  string. See also String#unpack. */
"\n"/*  */
"\n"/*     a = [ "a", "b", "c" ] */
"\n"/*     n = [ 65, 66, 67 ] */
"\n"/*     a.pack("A3A3A3")   #=> "a  b  c  " */
"\n"/*     a.pack("a3a3a3")   #=> "a\000\000b\000\000c\000\000" */
"\n"/*     n.pack("ccc")      #=> "ABC" */
"\n"/*  */
"\n"/*  If <i>aBufferString</i> is specified and its capacity is enough, */
"\n"/*  +pack+ uses it as the buffer and returns it. */
"\n"/*  When the offset is specified by the beginning of <i>aTemplateString</i>, */
"\n"/*  the result is filled after the offset. */
"\n"/*  If original contents of <i>aBufferString</i> exists and it's longer than */
"\n"/*  the offset, the rest of <i>offsetOfBuffer</i> are overwritten by the result. */
"\n"/*  If it's shorter, the gap is filled with ``<code>\0</code>''. */
"\n"/*  */
"\n"/*  Note that ``buffer:'' option does not guarantee not to allocate memory */
"\n"/*  in +pack+.  If the capacity of <i>aBufferString</i> is not enough, */
"\n"/*  +pack+ allocates memory. */
"\n"/*  */
"\n"/*  Directives for +pack+. */
"\n"/*  */
"\n"/*   Integer       | Array   | */
"\n"/*   Directive     | Element | Meaning */
"\n"/*   ---------------------------------------------------------------------------- */
"\n"/*   C             | Integer | 8-bit unsigned (unsigned char) */
"\n"/*   S             | Integer | 16-bit unsigned, native endian (uint16_t) */
"\n"/*   L             | Integer | 32-bit unsigned, native endian (uint32_t) */
"\n"/*   Q             | Integer | 64-bit unsigned, native endian (uint64_t) */
"\n"/*   J             | Integer | pointer width unsigned, native endian (uintptr_t) */
"\n"/*                 |         | (J is available since Ruby 2.3.) */
"\n"/*                 |         | */
"\n"/*   c             | Integer | 8-bit signed (signed char) */
"\n"/*   s             | Integer | 16-bit signed, native endian (int16_t) */
"\n"/*   l             | Integer | 32-bit signed, native endian (int32_t) */
"\n"/*   q             | Integer | 64-bit signed, native endian (int64_t) */
"\n"/*   j             | Integer | pointer width signed, native endian (intptr_t) */
"\n"/*                 |         | (j is available since Ruby 2.3.) */
"\n"/*                 |         | */
"\n"/*   S_ S!         | Integer | unsigned short, native endian */
"\n"/*   I I_ I!       | Integer | unsigned int, native endian */
"\n"/*   L_ L!         | Integer | unsigned long, native endian */
"\n"/*   Q_ Q!         | Integer | unsigned long long, native endian (ArgumentError */
"\n"/*                 |         | if the platform has no long long type.) */
"\n"/*                 |         | (Q_ and Q! is available since Ruby 2.1.) */
"\n"/*   J!            | Integer | uintptr_t, native endian (same with J) */
"\n"/*                 |         | (J! is available since Ruby 2.3.) */
"\n"/*                 |         | */
"\n"/*   s_ s!         | Integer | signed short, native endian */
"\n"/*   i i_ i!       | Integer | signed int, native endian */
"\n"/*   l_ l!         | Integer | signed long, native endian */
"\n"/*   q_ q!         | Integer | signed long long, native endian (ArgumentError */
"\n"/*                 |         | if the platform has no long long type.) */
"\n"/*                 |         | (q_ and q! is available since Ruby 2.1.) */
"\n"/*   j!            | Integer | intptr_t, native endian (same with j) */
"\n"/*                 |         | (j! is available since Ruby 2.3.) */
"\n"/*                 |         | */
"\n"/*   S> s> S!> s!> | Integer | same as the directives without ">" except */
"\n"/*   L> l> L!> l!> |         | big endian */
"\n"/*   I!> i!>       |         | (available since Ruby 1.9.3) */
"\n"/*   Q> q> Q!> q!> |         | "S>" is same as "n" */
"\n"/*   J> j> J!> j!> |         | "L>" is same as "N" */
"\n"/*                 |         | */
"\n"/*   S< s< S!< s!< | Integer | same as the directives without "<" except */
"\n"/*   L< l< L!< l!< |         | little endian */
"\n"/*   I!< i!<       |         | (available since Ruby 1.9.3) */
"\n"/*   Q< q< Q!< q!< |         | "S<" is same as "v" */
"\n"/*   J< j< J!< j!< |         | "L<" is same as "V" */
"\n"/*                 |         | */
"\n"/*   n             | Integer | 16-bit unsigned, network (big-endian) byte order */
"\n"/*   N             | Integer | 32-bit unsigned, network (big-endian) byte order */
"\n"/*   v             | Integer | 16-bit unsigned, VAX (little-endian) byte order */
"\n"/*   V             | Integer | 32-bit unsigned, VAX (little-endian) byte order */
"\n"/*                 |         | */
"\n"/*   U             | Integer | UTF-8 character */
"\n"/*   w             | Integer | BER-compressed integer */
"\n"/*  */
"\n"/*   Float        | Array   | */
"\n"/*   Directive    | Element | Meaning */
"\n"/*   --------------------------------------------------------------------------- */
"\n"/*   D d          | Float   | double-precision, native format */
"\n"/*   F f          | Float   | single-precision, native format */
"\n"/*   E            | Float   | double-precision, little-endian byte order */
"\n"/*   e            | Float   | single-precision, little-endian byte order */
"\n"/*   G            | Float   | double-precision, network (big-endian) byte order */
"\n"/*   g            | Float   | single-precision, network (big-endian) byte order */
"\n"/*  */
"\n"/*   String       | Array   | */
"\n"/*   Directive    | Element | Meaning */
"\n"/*   --------------------------------------------------------------------------- */
"\n"/*   A            | String  | arbitrary binary string (space padded, count is width) */
"\n"/*   a            | String  | arbitrary binary string (null padded, count is width) */
"\n"/*   Z            | String  | same as ``a'', except that null is added with * */
"\n"/*   B            | String  | bit string (MSB first) */
"\n"/*   b            | String  | bit string (LSB first) */
"\n"/*   H            | String  | hex string (high nibble first) */
"\n"/*   h            | String  | hex string (low nibble first) */
"\n"/*   u            | String  | UU-encoded string */
"\n"/*   M            | String  | quoted printable, MIME encoding (see also RFC2045) */
"\n"/*                |         | (text mode but input must use LF and output LF) */
"\n"/*   m            | String  | base64 encoded string (see RFC 2045) */
"\n"/*                |         | (if count is 0, no line feed are added, see RFC 4648) */
"\n"/*                |         | (count specifies input bytes between each LF, */
"\n"/*                |         | rounded down to nearest multiple of 3) */
"\n"/*   P            | String  | pointer to a structure (fixed-length string) */
"\n"/*   p            | String  | pointer to a null-terminated string */
"\n"/*  */
"\n"/*   Misc.        | Array   | */
"\n"/*   Directive    | Element | Meaning */
"\n"/*   --------------------------------------------------------------------------- */
"\n"/*   @            | ---     | moves to absolute position */
"\n"/*   X            | ---     | back up a byte */
"\n"/*   x            | ---     | null byte */
"  def pack(fmt, buffer: nil)\n"
"    Primitive.pack_pack(fmt, buffer)\n"
"  end\n"
"end\n"
"\n"
"class String\n"
"\n"/* call-seq: */
"\n"/*    str.unpack(format)    ->  anArray */
"\n"/*  */
"\n"/* Decodes <i>str</i> (which may contain binary data) according to the */
"\n"/* format string, returning an array of each value extracted. The */
"\n"/* format string consists of a sequence of single-character directives, */
"\n"/* summarized in the table at the end of this entry. */
"\n"/* Each directive may be followed */
"\n"/* by a number, indicating the number of times to repeat with this */
"\n"/* directive. An asterisk (``<code>*</code>'') will use up all */
"\n"/* remaining elements. The directives <code>sSiIlL</code> may each be */
"\n"/* followed by an underscore (``<code>_</code>'') or */
"\n"/* exclamation mark (``<code>!</code>'') to use the underlying */
"\n"/* platform's native size for the specified type; otherwise, it uses a */
"\n"/* platform-independent consistent size. Spaces are ignored in the */
"\n"/* format string. See also String#unpack1,  Array#pack. */
"\n"/*  */
"\n"/*    "abc \0\0abc \0\0".unpack('A6Z6')   #=> ["abc", "abc "] */
"\n"/*    "abc \0\0".unpack('a3a3')           #=> ["abc", " \000\000"] */
"\n"/*    "abc \0abc \0".unpack('Z*Z*')       #=> ["abc ", "abc "] */
"\n"/*    "aa".unpack('b8B8')                 #=> ["10000110", "01100001"] */
"\n"/*    "aaa".unpack('h2H2c')               #=> ["16", "61", 97] */
"\n"/*    "\xfe\xff\xfe\xff".unpack('sS')     #=> [-2, 65534] */
"\n"/*    "now=20is".unpack('M*')             #=> ["now is"] */
"\n"/*    "whole".unpack('xax2aX2aX1aX2a')    #=> ["h", "e", "l", "l", "o"] */
"\n"/*  */
"\n"/* This table summarizes the various formats and the Ruby classes */
"\n"/* returned by each. */
"\n"/*  */
"\n"/*  Integer       |         | */
"\n"/*  Directive     | Returns | Meaning */
"\n"/*  ------------------------------------------------------------------ */
"\n"/*  C             | Integer | 8-bit unsigned (unsigned char) */
"\n"/*  S             | Integer | 16-bit unsigned, native endian (uint16_t) */
"\n"/*  L             | Integer | 32-bit unsigned, native endian (uint32_t) */
"\n"/*  Q             | Integer | 64-bit unsigned, native endian (uint64_t) */
"\n"/*  J             | Integer | pointer width unsigned, native endian (uintptr_t) */
"\n"/*                |         | */
"\n"/*  c             | Integer | 8-bit signed (signed char) */
"\n"/*  s             | Integer | 16-bit signed, native endian (int16_t) */
"\n"/*  l             | Integer | 32-bit signed, native endian (int32_t) */
"\n"/*  q             | Integer | 64-bit signed, native endian (int64_t) */
"\n"/*  j             | Integer | pointer width signed, native endian (intptr_t) */
"\n"/*                |         | */
"\n"/*  S_ S!         | Integer | unsigned short, native endian */
"\n"/*  I I_ I!       | Integer | unsigned int, native endian */
"\n"/*  L_ L!         | Integer | unsigned long, native endian */
"\n"/*  Q_ Q!         | Integer | unsigned long long, native endian (ArgumentError */
"\n"/*                |         | if the platform has no long long type.) */
"\n"/*  J!            | Integer | uintptr_t, native endian (same with J) */
"\n"/*                |         | */
"\n"/*  s_ s!         | Integer | signed short, native endian */
"\n"/*  i i_ i!       | Integer | signed int, native endian */
"\n"/*  l_ l!         | Integer | signed long, native endian */
"\n"/*  q_ q!         | Integer | signed long long, native endian (ArgumentError */
"\n"/*                |         | if the platform has no long long type.) */
"\n"/*  j!            | Integer | intptr_t, native endian (same with j) */
"\n"/*                |         | */
"\n"/*  S> s> S!> s!> | Integer | same as the directives without ">" except */
"\n"/*  L> l> L!> l!> |         | big endian */
"\n"/*  I!> i!>       |         | */
"\n"/*  Q> q> Q!> q!> |         | "S>" is same as "n" */
"\n"/*  J> j> J!> j!> |         | "L>" is same as "N" */
"\n"/*                |         | */
"\n"/*  S< s< S!< s!< | Integer | same as the directives without "<" except */
"\n"/*  L< l< L!< l!< |         | little endian */
"\n"/*  I!< i!<       |         | */
"\n"/*  Q< q< Q!< q!< |         | "S<" is same as "v" */
"\n"/*  J< j< J!< j!< |         | "L<" is same as "V" */
"\n"/*                |         | */
"\n"/*  n             | Integer | 16-bit unsigned, network (big-endian) byte order */
"\n"/*  N             | Integer | 32-bit unsigned, network (big-endian) byte order */
"\n"/*  v             | Integer | 16-bit unsigned, VAX (little-endian) byte order */
"\n"/*  V             | Integer | 32-bit unsigned, VAX (little-endian) byte order */
"\n"/*                |         | */
"\n"/*  U             | Integer | UTF-8 character */
"\n"/*  w             | Integer | BER-compressed integer (see Array#pack) */
"\n"/*  */
"\n"/*  Float        |         | */
"\n"/*  Directive    | Returns | Meaning */
"\n"/*  ----------------------------------------------------------------- */
"\n"/*  D d          | Float   | double-precision, native format */
"\n"/*  F f          | Float   | single-precision, native format */
"\n"/*  E            | Float   | double-precision, little-endian byte order */
"\n"/*  e            | Float   | single-precision, little-endian byte order */
"\n"/*  G            | Float   | double-precision, network (big-endian) byte order */
"\n"/*  g            | Float   | single-precision, network (big-endian) byte order */
"\n"/*  */
"\n"/*  String       |         | */
"\n"/*  Directive    | Returns | Meaning */
"\n"/*  ----------------------------------------------------------------- */
"\n"/*  A            | String  | arbitrary binary string (remove trailing nulls and ASCII spaces) */
"\n"/*  a            | String  | arbitrary binary string */
"\n"/*  Z            | String  | null-terminated string */
"\n"/*  B            | String  | bit string (MSB first) */
"\n"/*  b            | String  | bit string (LSB first) */
"\n"/*  H            | String  | hex string (high nibble first) */
"\n"/*  h            | String  | hex string (low nibble first) */
"\n"/*  u            | String  | UU-encoded string */
"\n"/*  M            | String  | quoted-printable, MIME encoding (see RFC2045) */
"\n"/*  m            | String  | base64 encoded string (RFC 2045) (default) */
"\n"/*               |         | base64 encoded string (RFC 4648) if followed by 0 */
"\n"/*  P            | String  | pointer to a structure (fixed-length string) */
"\n"/*  p            | String  | pointer to a null-terminated string */
"\n"/*  */
"\n"/*  Misc.        |         | */
"\n"/*  Directive    | Returns | Meaning */
"\n"/*  ----------------------------------------------------------------- */
"\n"/*  @            | ---     | skip to the offset given by the length argument */
"\n"/*  X            | ---     | skip backward one byte */
"\n"/*  x            | ---     | skip forward one byte */
"\n"/*  */
"\n"/* HISTORY */
"\n"/*  */
"\n"/* * J, J! j, and j! are available since Ruby 2.3. */
"\n"/* * Q_, Q!, q_, and q! are available since Ruby 2.1. */
"\n"/* * I!<, i!<, I!>, and i!> are available since Ruby 1.9.3. */
"  def unpack(fmt)\n"
"    Primitive.pack_unpack(fmt)\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    str.unpack1(format)    ->  obj */
"\n"/*  */
"\n"/* Decodes <i>str</i> (which may contain binary data) according to the */
"\n"/* format string, returning the first value extracted. */
"\n"/* See also String#unpack, Array#pack. */
"\n"/*  */
"\n"/* Contrast with String#unpack: */
"\n"/*  */
"\n"/*    "abc \0\0abc \0\0".unpack('A6Z6')   #=> ["abc", "abc "] */
"\n"/*    "abc \0\0abc \0\0".unpack1('A6Z6')  #=> "abc" */
"\n"/*  */
"\n"/* In that case data would be lost but often it's the case that the array */
"\n"/* only holds one value, especially when unpacking binary data. For instance: */
"\n"/*  */
"\n"/* "\xff\x00\x00\x00".unpack("l")         #=>  [255] */
"\n"/* "\xff\x00\x00\x00".unpack1("l")        #=>  255 */
"\n"/*  */
"\n"/* Thus unpack1 is convenient, makes clear the intention and signals */
"\n"/* the expected return value to those reading the code. */
"  def unpack1(fmt)\n"
"    Primitive.pack_unpack1(fmt)\n"
"  end\n"
"end\n"
#line 1135 "miniprelude.c"
};

static const char prelude_name6[] = "<internal:trace_point>";
static const struct {
    char L0[447]; /* 1..194 */
    char L194[479]; /* 195..262 */
    char L262[490]; /* 263..331 */
    char L331[215]; /* 332..349 */
} prelude_code6 = {
#line 1 "trace_point.rb"
"\n"/* loaded from vm_trace.c */
"\n"
"\n"/* Document-class: TracePoint */
"\n"/*  */
"\n"/* A class that provides the functionality of Kernel#set_trace_func in a */
"\n"/* nice Object-Oriented API. */
"\n"/*  */
"\n"/* == Example */
"\n"/*  */
"\n"/* We can use TracePoint to gather information specifically for exceptions: */
"\n"/*  */
"\n"/*     trace = TracePoint.new(:raise) do |tp| */
"\n"/* 	p [tp.lineno, tp.event, tp.raised_exception] */
"\n"/*     end */
"\n"/*     #=> #<TracePoint:disabled> */
"\n"/*  */
"\n"/*     trace.enable */
"\n"/*     #=> false */
"\n"/*  */
"\n"/*     0 / 0 */
"\n"/*     #=> [5, :raise, #<ZeroDivisionError: divided by 0>] */
"\n"/*  */
"\n"/* == Events */
"\n"/*  */
"\n"/* If you don't specify the type of events you want to listen for, */
"\n"/* TracePoint will include all available events. */
"\n"/*  */
"\n"/* *Note* do not depend on current event set, as this list is subject to */
"\n"/* change. Instead, it is recommended you specify the type of events you */
"\n"/* want to use. */
"\n"/*  */
"\n"/* To filter what is traced, you can pass any of the following as +events+: */
"\n"/*  */
"\n"/* +:line+:: execute code on a new line */
"\n"/* +:class+:: start a class or module definition */
"\n"/* +:end+:: finish a class or module definition */
"\n"/* +:call+:: call a Ruby method */
"\n"/* +:return+:: return from a Ruby method */
"\n"/* +:c_call+:: call a C-language routine */
"\n"/* +:c_return+:: return from a C-language routine */
"\n"/* +:raise+:: raise an exception */
"\n"/* +:b_call+:: event hook at block entry */
"\n"/* +:b_return+:: event hook at block ending */
"\n"/* +:thread_begin+:: event hook at thread beginning */
"\n"/* +:thread_end+:: event hook at thread ending */
"\n"/* +:fiber_switch+:: event hook at fiber switch */
"\n"/* +:script_compiled+:: new Ruby code compiled (with +eval+, +load+ or +require+) */
"\n"/*  */
"class TracePoint\n"
"\n"/* call-seq: */
"\n"/* TracePoint.new(*events) { |obj| block }	    -> obj */
"\n"/*  */
"\n"/* Returns a new TracePoint object, not enabled by default. */
"\n"/*  */
"\n"/* Next, in order to activate the trace, you must use TracePoint#enable */
"\n"/*  */
"\n"/* trace = TracePoint.new(:call) do |tp| */
"\n"/*     p [tp.lineno, tp.defined_class, tp.method_id, tp.event] */
"\n"/* end */
"\n"/* #=> #<TracePoint:disabled> */
"\n"/*  */
"\n"/* trace.enable */
"\n"/* #=> false */
"\n"/*  */
"\n"/* puts "Hello, TracePoint!" */
"\n"/* # ... */
"\n"/* # [48, IRB::Notifier::AbstractNotifier, :printf, :call] */
"\n"/* # ... */
"\n"/*  */
"\n"/* When you want to deactivate the trace, you must use TracePoint#disable */
"\n"/*  */
"\n"/* trace.disable */
"\n"/*  */
"\n"/* See TracePoint@Events for possible events and more information. */
"\n"/*  */
"\n"/* A block must be given, otherwise an ArgumentError is raised. */
"\n"/*  */
"\n"/* If the trace method isn't included in the given events filter, a */
"\n"/* RuntimeError is raised. */
"\n"/*  */
"\n"/* TracePoint.trace(:line) do |tp| */
"\n"/*     p tp.raised_exception */
"\n"/* end */
"\n"/* #=> RuntimeError: 'raised_exception' not supported by this event */
"\n"/*  */
"\n"/* If the trace method is called outside block, a RuntimeError is raised. */
"\n"/*  */
"\n"/*      TracePoint.trace(:line) do |tp| */
"\n"/*        $tp = tp */
"\n"/*      end */
"\n"/*      $tp.lineno #=> access from outside (RuntimeError) */
"\n"/*  */
"\n"/* Access from other threads is also forbidden. */
"\n"/*  */
"  def self.new(*events)\n"
"    Primitive.tracepoint_new_s(events)\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*    trace.inspect  -> string */
"\n"/*  */
"\n"/*  Return a string containing a human-readable TracePoint */
"\n"/*  status. */
"  def inspect\n"
"    Primitive.tracepoint_inspect\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/* TracePoint.stat -> obj */
"\n"/*  */
"\n"/*  Returns internal information of TracePoint. */
"\n"/*  */
"\n"/*  The contents of the returned value are implementation specific. */
"\n"/*  It may be changed in future. */
"\n"/*  */
"\n"/*  This method is only for debugging TracePoint itself. */
"  def self.stat\n"
"    Primitive.tracepoint_stat_s\n"
"  end\n"
"\n"
"\n"/* Document-method: trace */
"\n"/*  */
"\n"/* call-seq: */
"\n"/* TracePoint.trace(*events) { |obj| block }	-> obj */
"\n"/*  */
"\n"/*  A convenience method for TracePoint.new, that activates the trace */
"\n"/*  automatically. */
"\n"/*  */
"\n"/*     trace = TracePoint.trace(:call) { |tp| [tp.lineno, tp.event] } */
"\n"/*     #=> #<TracePoint:enabled> */
"\n"/*  */
"\n"/*     trace.enabled? #=> true */
"\n"/*  */
"  def self.trace(*events)\n"
"    Primitive.tracepoint_trace_s(events)\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    trace.enable(target: nil, target_line: nil, target_thread: nil)    -> true or false */
"\n"/*    trace.enable(target: nil, target_line: nil, target_thread: nil) { block }  -> obj */
"\n"/*  */
"\n"/* Activates the trace. */
"\n"/*  */
"\n"/* Returns +true+ if trace was enabled. */
"\n"/* Returns +false+ if trace was disabled. */
"\n"/*  */
"\n"/*   trace.enabled?  #=> false */
"\n"/*   trace.enable    #=> false (previous state) */
"\n"/*                   #   trace is enabled */
"\n"/*   trace.enabled?  #=> true */
"\n"/*   trace.enable    #=> true (previous state) */
"\n"/*                   #   trace is still enabled */
"\n"/*  */
"\n"/* If a block is given, the trace will only be enabled within the scope of the */
"\n"/* block. */
"\n"/*  */
"\n"/*    trace.enabled? */
"\n"/*    #=> false */
"\n"/*  */
"\n"/*    trace.enable do */
"\n"/*      trace.enabled? */
"\n"/*      # only enabled for this block */
"\n"/*    end */
"\n"/*  */
"\n"/*    trace.enabled? */
"\n"/*    #=> false */
"\n"/*  */
"\n"/* +target+, +target_line+ and +target_thread+ parameters are used to */
"\n"/* limit tracing only to specified code objects. +target+ should be a */
"\n"/* code object for which RubyVM::InstructionSequence.of will return */
"\n"/* an instruction sequence. */
"\n"/*  */
"\n"/*    t = TracePoint.new(:line) { |tp| p tp } */
"\n"/*  */
"\n"/*    def m1 */
"\n"/*      p 1 */
"\n"/*    end */
"\n"/*  */
"\n"/*    def m2 */
"\n"/*      p 2 */
"\n"/*    end */
"\n"/*  */
"\n"/*    t.enable(target: method(:m1)) */
"\n"/*  */
"\n"/*    m1 */
"\n"/*    # prints #<TracePoint:line test.rb:4 in `m1'> */
"\n"/*    m2 */
"\n"/*    # prints nothing */
"\n"/*  */
"\n"/* Note: You cannot access event hooks within the +enable+ block. */
"\n"/*  */
"\n"/*    trace.enable { p tp.lineno } */
"\n"/*    #=> RuntimeError: access from outside */
"\n"/*  */
,
#line 195 "trace_point.rb"
"  def enable(target: nil, target_line: nil, target_thread: nil)\n"
"    Primitive.tracepoint_enable_m(target, target_line, target_thread)\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/* trace.disable		-> true or false */
"\n"/* trace.disable { block } -> obj */
"\n"/*  */
"\n"/* Deactivates the trace */
"\n"/*  */
"\n"/* Return true if trace was enabled. */
"\n"/* Return false if trace was disabled. */
"\n"/*  */
"\n"/* trace.enabled?	#=> true */
"\n"/* trace.disable	#=> true (previous status) */
"\n"/* trace.enabled?	#=> false */
"\n"/* trace.disable	#=> false */
"\n"/*  */
"\n"/* If a block is given, the trace will only be disable within the scope of the */
"\n"/* block. */
"\n"/*  */
"\n"/* trace.enabled? */
"\n"/* #=> true */
"\n"/*  */
"\n"/* trace.disable do */
"\n"/*     trace.enabled? */
"\n"/*     # only disabled for this block */
"\n"/* end */
"\n"/*  */
"\n"/* trace.enabled? */
"\n"/* #=> true */
"\n"/*  */
"\n"/* Note: You cannot access event hooks within the block. */
"\n"/*  */
"\n"/* trace.disable { p tp.lineno } */
"\n"/* #=> RuntimeError: access from outside */
"  def disable\n"
"    Primitive.tracepoint_disable_m\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/* trace.enabled?	    -> true or false */
"\n"/*  */
"\n"/* The current status of the trace */
"  def enabled?\n"
"    Primitive.tracepoint_enabled_p\n"
"  end\n"
"\n"
"\n"/* Type of event */
"\n"/*  */
"\n"/* See TracePoint@Events for more information. */
"  def event\n"
"    Primitive.tracepoint_attr_event\n"
"  end\n"
"\n"
"\n"/* Line number of the event */
"  def lineno\n"
"    Primitive.tracepoint_attr_lineno\n"
"  end\n"
"\n"
"\n"/* Path of the file being run */
"  def path\n"
"    Primitive.tracepoint_attr_path\n"
"  end\n"
"\n"
"\n"/* Return the parameters definition of the method or block that the */
"\n"/* current hook belongs to. Format is the same as for Method#parameters */
"  def parameters\n"
,
#line 263 "trace_point.rb"
"    Primitive.tracepoint_attr_parameters\n"
"  end\n"
"\n"
"\n"/* Return the name at the definition of the method being called */
"  def method_id\n"
"    Primitive.tracepoint_attr_method_id\n"
"  end\n"
"\n"
"\n"/* Return the called name of the method being called */
"  def callee_id\n"
"    Primitive.tracepoint_attr_callee_id\n"
"  end\n"
"\n"
"\n"/* Return class or module of the method being called. */
"\n"/*  */
"\n"/* class C; def foo; end; end */
"\n"/* 	trace = TracePoint.new(:call) do |tp| */
"\n"/* 	  p tp.defined_class #=> C */
"\n"/* 	end.enable do */
"\n"/* 	  C.new.foo */
"\n"/* 	end */
"\n"/*  */
"\n"/* If method is defined by a module, then that module is returned. */
"\n"/*  */
"\n"/* module M; def foo; end; end */
"\n"/* 	class C; include M; end; */
"\n"/* 	trace = TracePoint.new(:call) do |tp| */
"\n"/* 	  p tp.defined_class #=> M */
"\n"/* 	end.enable do */
"\n"/* 	  C.new.foo */
"\n"/* 	end */
"\n"/*  */
"\n"/* <b>Note:</b> #defined_class returns singleton class. */
"\n"/*  */
"\n"/* 6th block parameter of Kernel#set_trace_func passes original class */
"\n"/* of attached by singleton class. */
"\n"/*  */
"\n"/* <b>This is a difference between Kernel#set_trace_func and TracePoint.</b> */
"\n"/*  */
"\n"/* class C; def self.foo; end; end */
"\n"/* 	trace = TracePoint.new(:call) do |tp| */
"\n"/* 	  p tp.defined_class #=> #<Class:C> */
"\n"/* 	end.enable do */
"\n"/* 	  C.foo */
"\n"/* 	end */
"  def defined_class\n"
"    Primitive.tracepoint_attr_defined_class\n"
"  end\n"
"\n"
"\n"/* Return the generated binding object from event */
"  def binding\n"
"    Primitive.tracepoint_attr_binding\n"
"  end\n"
"\n"
"\n"/* Return the trace object during event */
"\n"/*  */
"\n"/* Same as TracePoint#binding: */
"\n"/* trace.binding.eval('self') */
"  def self\n"
"    Primitive.tracepoint_attr_self\n"
"  end\n"
"\n"
"\n"/*  Return value from +:return+, +c_return+, and +b_return+ event */
"  def return_value\n"
"    Primitive.tracepoint_attr_return_value\n"
"  end\n"
"\n"
"\n"/* Value from exception raised on the +:raise+ event */
"  def raised_exception\n"
,
#line 332 "trace_point.rb"
"    Primitive.tracepoint_attr_raised_exception\n"
"  end\n"
"\n"
"\n"/* Compiled source code (String) on *eval methods on the +:script_compiled+ event. */
"\n"/* If loaded from a file, it will return nil. */
"  def eval_script\n"
"    Primitive.tracepoint_attr_eval_script\n"
"  end\n"
"\n"
"\n"/* Compiled instruction sequence represented by a RubyVM::InstructionSequence instance */
"\n"/* on the +:script_compiled+ event. */
"\n"/*  */
"\n"/* Note that this method is MRI specific. */
"  def instruction_sequence\n"
"    Primitive.tracepoint_attr_instruction_sequence\n"
"  end\n"
"end\n"
#line 1500 "miniprelude.c"
};

static const char prelude_name7[] = "<internal:warning>";
static const struct {
    char L0[185]; /* 1..54 */
} prelude_code7 = {
#line 1 "warning.rb"
"\n"/* encoding: utf-8 */
"\n"/* frozen-string-literal: true */
"\n"
"module Kernel\n"
"  module_function\n"
"\n"
"\n"/* call-seq: */
"\n"/*    warn(*msgs, uplevel: nil, category: nil)   -> nil */
"\n"/*  */
"\n"/* If warnings have been disabled (for example with the */
"\n"/* <code>-W0</code> flag), does nothing.  Otherwise, */
"\n"/* converts each of the messages to strings, appends a newline */
"\n"/* character to the string if the string does not end in a newline, */
"\n"/* and calls Warning.warn with the string. */
"\n"/*  */
"\n"/*    warn("warning 1", "warning 2") */
"\n"/*  */
"\n"/*  <em>produces:</em> */
"\n"/*  */
"\n"/*    warning 1 */
"\n"/*    warning 2 */
"\n"/*  */
"\n"/* If the <code>uplevel</code> keyword argument is given, the string will */
"\n"/* be prepended with information for the given caller frame in */
"\n"/* the same format used by the <code>rb_warn</code> C function. */
"\n"/*  */
"\n"/*    # In baz.rb */
"\n"/*    def foo */
"\n"/*      warn("invalid call to foo", uplevel: 1) */
"\n"/*    end */
"\n"/*  */
"\n"/*    def bar */
"\n"/*      foo */
"\n"/*    end */
"\n"/*  */
"\n"/*    bar */
"\n"/*  */
"\n"/*  <em>produces:</em> */
"\n"/*  */
"\n"/*    baz.rb:6: warning: invalid call to foo */
"\n"/*  */
"\n"/* If <code>category</code> keyword argument is given, passes the category */
"\n"/* to <code>Warning.warn</code>.  The category given must be be one of the */
"\n"/* following categories: */
"\n"/*  */
"\n"/* :deprecated :: Used for warning for deprecated functionality that may */
"\n"/*                be removed in the future. */
"\n"/* :experimental :: Used for experimental features that may change in */
"\n"/*                  future releases. */
"  def warn(*msgs, uplevel: nil, category: nil)\n"
"    Primitive.rb_warn_m(msgs, uplevel, category)\n"
"  end\n"
"end\n"
#line 1561 "miniprelude.c"
};

static const char prelude_name8[] = "<internal:array>";
static const struct {
    char L0[316]; /* 1..62 */
} prelude_code8 = {
#line 1 "array.rb"
"class Array\n"
"\n"/* call-seq: */
"\n"/*    array.shuffle!(random: Random) -> array */
"\n"/*  */
"\n"/* Shuffles the elements of +self+ in place. */
"\n"/*    a = [1, 2, 3] #=> [1, 2, 3] */
"\n"/*    a.shuffle!    #=> [2, 3, 1] */
"\n"/*    a             #=> [2, 3, 1] */
"\n"/*  */
"\n"/* The optional +random+ argument will be used as the random number generator: */
"\n"/*    a.shuffle!(random: Random.new(1))  #=> [1, 3, 2] */
"  def shuffle!(random: Random)\n"
"    Primitive.rb_ary_shuffle_bang(random)\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    array.shuffle(random: Random) -> new_ary */
"\n"/*  */
"\n"/* Returns a new array with elements of +self+ shuffled. */
"\n"/*    a = [1, 2, 3] #=> [1, 2, 3] */
"\n"/*    a.shuffle     #=> [2, 3, 1] */
"\n"/*    a             #=> [1, 2, 3] */
"\n"/*  */
"\n"/* The optional +random+ argument will be used as the random number generator: */
"\n"/*    a.shuffle(random: Random.new(1))  #=> [1, 3, 2] */
"  def shuffle(random: Random)\n"
"    Primitive.rb_ary_shuffle(random)\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    array.sample(random: Random) -> object */
"\n"/*    array.sample(n, random: Random) -> new_ary */
"\n"/*  */
"\n"/* Returns random elements from +self+. */
"\n"/*  */
"\n"/* When no arguments are given, returns a random element from +self+: */
"\n"/*    a = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10] */
"\n"/*    a.sample # => 3 */
"\n"/*    a.sample # => 8 */
"\n"/* If +self+ is empty, returns +nil+. */
"\n"/*  */
"\n"/* When argument +n+ is given, returns a new \Array containing +n+ random */
"\n"/* elements from +self+: */
"\n"/*    a.sample(3) # => [8, 9, 2] */
"\n"/*    a.sample(6) # => [9, 6, 10, 3, 1, 4] */
"\n"/* Returns no more than <tt>a.size</tt> elements */
"\n"/* (because no new duplicates are introduced): */
"\n"/*    a.sample(a.size * 2) # => [6, 4, 1, 8, 5, 9, 10, 2, 3, 7] */
"\n"/* But +self+ may contain duplicates: */
"\n"/*    a = [1, 1, 1, 2, 2, 3] */
"\n"/*    a.sample(a.size * 2) # => [1, 1, 3, 2, 1, 2] */
"\n"/* Returns a new empty \Array if +self+ is empty. */
"\n"/*  */
"\n"/* The optional +random+ argument will be used as the random number generator: */
"\n"/*    a = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10] */
"\n"/*    a.sample(random: Random.new(1))     #=> 6 */
"\n"/*    a.sample(4, random: Random.new(1))  #=> [6, 10, 9, 2] */
"  def sample(n = (ary = false), random: Random)\n"
"    Primitive.rb_ary_sample(random, n, ary)\n"
"  end\n"
"end\n"
#line 1630 "miniprelude.c"
};

static const char prelude_name9[] = "<internal:kernel>";
static const struct {
    char L0[484]; /* 1..121 */
    char L121[401]; /* 122..175 */
} prelude_code9 = {
#line 1 "kernel.rb"
"module Kernel\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     obj.class    -> class */
"\n"/*  */
"\n"/*  Returns the class of <i>obj</i>. This method must always be called */
"\n"/*  with an explicit receiver, as #class is also a reserved word in */
"\n"/*  Ruby. */
"\n"/*  */
"\n"/*     1.class      #=> Integer */
"\n"/*     self.class   #=> Object */
"  #--\n"
"\n"/* Equivalent to \c Object\#class in Ruby. */
"\n"/*  */
"\n"/* Returns the class of \c obj, skipping singleton classes or module inclusions. */
"  #++\n"
"\n"/*  */
"  def class\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_obj_class(self)'\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     obj.clone(freeze: nil) -> an_object */
"\n"/*  */
"\n"/*  Produces a shallow copy of <i>obj</i>---the instance variables of */
"\n"/*  <i>obj</i> are copied, but not the objects they reference. */
"\n"/*  #clone copies the frozen value state of <i>obj</i>, unless the */
"\n"/*  +:freeze+ keyword argument is given with a false or true value. */
"\n"/*  See also the discussion under Object#dup. */
"\n"/*  */
"\n"/*     class Klass */
"\n"/*        attr_accessor :str */
"\n"/*     end */
"\n"/*     s1 = Klass.new      #=> #<Klass:0x401b3a38> */
"\n"/*     s1.str = "Hello"    #=> "Hello" */
"\n"/*     s2 = s1.clone       #=> #<Klass:0x401b3998 @str="Hello"> */
"\n"/*     s2.str[1,4] = "i"   #=> "i" */
"\n"/*     s1.inspect          #=> "#<Klass:0x401b3a38 @str=\"Hi\">" */
"\n"/*     s2.inspect          #=> "#<Klass:0x401b3998 @str=\"Hi\">" */
"\n"/*  */
"\n"/*  This method may have class-specific behavior.  If so, that */
"\n"/*  behavior will be documented under the #+initialize_copy+ method of */
"\n"/*  the class. */
"\n"/*  */
"  def clone(freeze: nil)\n"
"    Primitive.rb_obj_clone2(freeze)\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     obj.frozen?    -> true or false */
"\n"/*  */
"\n"/*  Returns the freeze status of <i>obj</i>. */
"\n"/*  */
"\n"/*     a = [ "a", "b", "c" ] */
"\n"/*     a.freeze    #=> ["a", "b", "c"] */
"\n"/*     a.frozen?   #=> true */
"  #--\n"
"\n"/* Determines if the object is frozen. Equivalent to \c Object\#frozen? in Ruby. */
"\n"/* \param[in] obj  the object to be determines */
"\n"/* \retval Qtrue if frozen */
"\n"/* \retval Qfalse if not frozen */
"  #++\n"
"\n"/*  */
"  def frozen?\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_obj_frozen_p(self)'\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     obj.tap {|x| block }    -> obj */
"\n"/*  */
"\n"/*  Yields self to the block, and then returns self. */
"\n"/*  The primary purpose of this method is to "tap into" a method chain, */
"\n"/*  in order to perform operations on intermediate results within the chain. */
"\n"/*  */
"\n"/*     (1..10)                  .tap {|x| puts "original: #{x}" } */
"\n"/*       .to_a                  .tap {|x| puts "array:    #{x}" } */
"\n"/*       .select {|x| x.even? } .tap {|x| puts "evens:    #{x}" } */
"\n"/*       .map {|x| x*x }        .tap {|x| puts "squares:  #{x}" } */
"\n"/*  */
"  #--\n"
"\n"/* \private */
"  #++\n"
"\n"/*  */
"  def tap\n"
"    yield(self)\n"
"    self\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     obj.then {|x| block }          -> an_object */
"\n"/*  */
"\n"/*  Yields self to the block and returns the result of the block. */
"\n"/*  */
"\n"/*     3.next.then {|x| x**x }.to_s             #=> "256" */
"\n"/*  */
"\n"/*  Good usage for +then+ is value piping in method chains: */
"\n"/*  */
"\n"/*     require 'open-uri' */
"\n"/*     require 'json' */
"\n"/*  */
"\n"/*     construct_url(arguments). */
"\n"/*       then {|url| open(url).read }. */
"\n"/*       then {|response| JSON.parse(response) } */
"\n"/*  */
"\n"/*  When called without block, the method returns +Enumerator+, */
"\n"/*  which can be used, for example, for conditional */
"\n"/*  circuit-breaking: */
"\n"/*  */
"\n"/*     # meets condition, no-op */
"\n"/*     1.then.detect(&:odd?)            # => 1 */
"\n"/*     # does not meet condition, drop value */
"\n"/*     2.then.detect(&:odd?)            # => nil */
"\n"/*  */
"  def then\n"
"    unless Primitive.block_given_p\n"
,
#line 122 "kernel.rb"
"      return Primitive.cexpr! 'SIZED_ENUMERATOR(self, 0, 0, rb_obj_size)'\n"
"    end\n"
"    yield(self)\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     obj.yield_self {|x| block }    -> an_object */
"\n"/*  */
"\n"/*  Yields self to the block and returns the result of the block. */
"\n"/*  */
"\n"/*     "my string".yield_self {|s| s.upcase }   #=> "MY STRING" */
"\n"/*  */
"\n"/*  Good usage for +then+ is value piping in method chains: */
"\n"/*  */
"\n"/*     require 'open-uri' */
"\n"/*     require 'json' */
"\n"/*  */
"\n"/*     construct_url(arguments). */
"\n"/*       then {|url| open(url).read }. */
"\n"/*       then {|response| JSON.parse(response) } */
"\n"/*  */
"  def yield_self\n"
"    unless Primitive.block_given_p\n"
"      return Primitive.cexpr! 'SIZED_ENUMERATOR(self, 0, 0, rb_obj_size)'\n"
"    end\n"
"    yield(self)\n"
"  end\n"
"\n"
"  module_function\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     Float(arg, exception: true)    -> float or nil */
"\n"/*  */
"\n"/*  Returns <i>arg</i> converted to a float. Numeric types are */
"\n"/*  converted directly, and with exception to String and */
"\n"/*  <code>nil</code> the rest are converted using */
"\n"/*  <i>arg</i><code>.to_f</code>.  Converting a String with invalid */
"\n"/*  characters will result in a ArgumentError.  Converting */
"\n"/*  <code>nil</code> generates a TypeError.  Exceptions can be */
"\n"/*  suppressed by passing <code>exception: false</code>. */
"\n"/*  */
"\n"/*     Float(1)                 #=> 1.0 */
"\n"/*     Float("123.456")         #=> 123.456 */
"\n"/*     Float("123.0_badstring") #=> ArgumentError: invalid value for Float(): "123.0_badstring" */
"\n"/*     Float(nil)               #=> TypeError: can't convert nil into Float */
"\n"/*     Float("123.0_badstring", exception: false)  #=> nil */
"\n"/*  */
"  def Float(arg, exception: true)\n"
"    Primitive.rb_f_float(arg, exception)\n"
"  end\n"
"end\n"
#line 1815 "miniprelude.c"
};

static const char prelude_name10[] = "<internal:ractor>";
static const struct {
    char L0[508]; /* 1..249 */
    char L249[457]; /* 250..321 */
    char L321[507]; /* 322..391 */
    char L391[496]; /* 392..545 */
    char L545[456]; /* 546..654 */
    char L654[480]; /* 655..682 */
    char L682[508]; /* 683..754 */
    char L754[65]; /* 755..760 */
} prelude_code10 = {
#line 1 "ractor.rb"
"\n"/* Ractor is a Actor-model abstraction for Ruby that provides thread-safe parallel execution. */
"\n"/*  */
"\n"/* To achieve this, ractors severely limit data sharing between different ractors. */
"\n"/* Unlike threads, ractors can't access each other's data, nor any data through variables of */
"\n"/* the outer scope. */
"\n"/*  */
"\n"/*     # The simplest ractor */
"\n"/*     r = Ractor.new {puts "I am in Ractor!"} */
"\n"/*     r.take # allow it to finish */
"\n"/*     # here "I am in Ractor!" would be printed */
"\n"/*  */
"\n"/*     a = 1 */
"\n"/*     r = Ractor.new {puts "I am in Ractor! a=#{a}"} */
"\n"/*     # fails immediately with */
"\n"/*     # ArgumentError (can not isolate a Proc because it accesses outer variables (a).) */
"\n"/*  */
"\n"/* On CRuby (the default implementation), Global Virtual Machine Lock (GVL) is held per ractor, so */
"\n"/* ractors are performed in parallel without locking each other. */
"\n"/*  */
"\n"/* Instead of accessing the shared state, the data should be passed to and from ractors via */
"\n"/* sending and receiving messages, thus making them _actors_ ("Ractor" stands for "Ruby Actor"). */
"\n"/*  */
"\n"/*     a = 1 */
"\n"/*     r = Ractor.new do */
"\n"/*       a_in_ractor = receive # receive blocks till somebody will pass message */
"\n"/*       puts "I am in Ractor! a=#{a_in_ractor}" */
"\n"/*     end */
"\n"/*     r.send(a)  # pass it */
"\n"/*     r.take */
"\n"/*     # here "I am in Ractor! a=1" would be printed */
"\n"/*  */
"\n"/* There are two pairs of methods for sending/receiving messages: */
"\n"/*  */
"\n"/* * Ractor#send and Ractor.receive for when the _sender_ knows the receiver (push); */
"\n"/* * Ractor.yield and Ractor#take for when the _receiver_ knows the sender (pull); */
"\n"/*  */
"\n"/* In addition to that, an argument to Ractor.new would be passed to block and available there */
"\n"/* as if received by Ractor.receive, and the last block value would be sent outside of the */
"\n"/* ractor as if sent by Ractor.yield. */
"\n"/*  */
"\n"/* A little demonstration on a classic ping-pong: */
"\n"/*  */
"\n"/*     server = Ractor.new do */
"\n"/*       puts "Server starts: #{self.inspect}" */
"\n"/*       puts "Server sends: ping" */
"\n"/*       Ractor.yield 'ping'                       # The server doesn't know the receiver and sends to whoever interested */
"\n"/*       received = Ractor.receive                 # The server doesn't know the sender and receives from whoever sent */
"\n"/*       puts "Server received: #{received}" */
"\n"/*     end */
"\n"/*  */
"\n"/*     client = Ractor.new(server) do |srv|        # The server is sent inside client, and available as srv */
"\n"/*       puts "Client starts: #{self.inspect}" */
"\n"/*       received = srv.take                       # The Client takes a message specifically from the server */
"\n"/*       puts "Client received from " \ */
"\n"/*            "#{srv.inspect}: #{received}" */
"\n"/*       puts "Client sends to " \ */
"\n"/*            "#{srv.inspect}: pong" */
"\n"/*       srv.send 'pong'                           # The client sends a message specifically to the server */
"\n"/*     end */
"\n"/*  */
"\n"/*     [client, server].each(&:take)               # Wait till they both finish */
"\n"/*  */
"\n"/* This will output: */
"\n"/*  */
"\n"/*     Server starts: #<Ractor:#2 test.rb:1 running> */
"\n"/*     Server sends: ping */
"\n"/*     Client starts: #<Ractor:#3 test.rb:8 running> */
"\n"/*     Client received from #<Ractor:#2 rac.rb:1 blocking>: ping */
"\n"/*     Client sends to #<Ractor:#2 rac.rb:1 blocking>: pong */
"\n"/*     Server received: pong */
"\n"/*  */
"\n"/* It is said that Ractor receives messages via the <em>incoming port</em>, and sends them */
"\n"/* to the <em>outgoing port</em>. Either one can be disabled with Ractor#close_incoming and */
"\n"/* Ractor#close_outgoing respectively. */
"\n"/*  */
"\n"/* == Shareable and unshareable objects */
"\n"/*  */
"\n"/* When the object is sent to and from the ractor, it is important to understand whether the */
"\n"/* object is shareable or not. Shareable objects are basically those which can be used by several */
"\n"/* threads without compromising thread-safety; e.g. immutable ones. Ractor.shareable? allows to */
"\n"/* check this, and Ractor.make_shareable tries to make object shareable if it is not. */
"\n"/*  */
"\n"/*     Ractor.shareable?(1)            #=> true -- numbers and other immutable basic values are */
"\n"/*     Ractor.shareable?('foo')        #=> false, unless the string is frozen due to # freeze_string_literals: true */
"\n"/*     Ractor.shareable?('foo'.freeze) #=> true */
"\n"/*  */
"\n"/*     ary = ['hello', 'world'] */
"\n"/*     ary.frozen?                 #=> false */
"\n"/*     ary[0].frozen?              #=> false */
"\n"/*     Ractor.make_shareable(ary) */
"\n"/*     ary.frozen?                 #=> true */
"\n"/*     ary[0].frozen?              #=> true */
"\n"/*     ary[1].frozen?              #=> true */
"\n"/*  */
"\n"/* When a shareable object is sent (via #send or Ractor.yield), no additional processing happens, */
"\n"/* and it just becomes usable by both ractors. When an unshareable object is sent, it can be */
"\n"/* either _copied_ or _moved_. The first is the default, and it makes the object's full copy by */
"\n"/* deep cloning of non-shareable parts of its structure. */
"\n"/*  */
"\n"/*     data = ['foo', 'bar'.freeze] */
"\n"/*     r = Ractor.new do */
"\n"/*       data2 = Ractor.receive */
"\n"/*       puts "In ractor: #{data2.object_id}, #{data2[0].object_id}, #{data2[1].object_id}" */
"\n"/*     end */
"\n"/*     r.send(data) */
"\n"/*     r.take */
"\n"/*     puts "Outside  : #{data.object_id}, #{data[0].object_id}, #{data[1].object_id}" */
"\n"/*  */
"\n"/* This will output: */
"\n"/*  */
"\n"/*     In ractor: 340, 360, 320 */
"\n"/*     Outside  : 380, 400, 320 */
"\n"/*  */
"\n"/* (Note that object id of both array and non-frozen string inside array have changed inside */
"\n"/* the ractor, showing it is different objects. But the second array's element, which is a */
"\n"/* shareable frozen string, has the same object_id.) */
"\n"/*  */
"\n"/* Deep cloning of the data may be slow, and sometimes impossible. Alternatively, */
"\n"/* <tt>move: true</tt> may be used on sending. This will <em>move</em> the object to the */
"\n"/* receiving ractor, making it inaccessible for a sending ractor. */
"\n"/*  */
"\n"/*     data = ['foo', 'bar'] */
"\n"/*     r = Ractor.new do */
"\n"/*       data_in_ractor = Ractor.receive */
"\n"/*       puts "In ractor: #{data_in_ractor.object_id}, #{data_in_ractor[0].object_id}" */
"\n"/*     end */
"\n"/*     r.send(data, move: true) */
"\n"/*     r.take */
"\n"/*     puts "Outside: moved? #{Ractor::MovedObject === data}" */
"\n"/*     puts "Outside: #{data.inspect}" */
"\n"/*  */
"\n"/* This will output: */
"\n"/*  */
"\n"/*     In ractor: 100, 120 */
"\n"/*     Outside: moved? true */
"\n"/*     test.rb:9:in `method_missing': can not send any methods to a moved object (Ractor::MovedError) */
"\n"/*  */
"\n"/* Notice that even +inspect+ (and more basic methods like <tt>__id__</tt>) is inaccessible */
"\n"/* on a moved object. */
"\n"/*  */
"\n"/* Besides frozen objects, shareable objects are instances of Module, Class and Ractor itself. Modules */
"\n"/* and classes, though, can not access instance variables from ractors other than main: */
"\n"/*  */
"\n"/*     class C */
"\n"/*       class << self */
"\n"/*         attr_accessor :tricky */
"\n"/*       end */
"\n"/*     end */
"\n"/*  */
"\n"/*     C.tricky = 'test' */
"\n"/*  */
"\n"/*     r = Ractor.new(C) do |cls| */
"\n"/*       puts "I see #{cls}" */
"\n"/*       puts "I can't see #{cls.tricky}" */
"\n"/*     end */
"\n"/*     r.take */
"\n"/*     # I see C */
"\n"/*     # can not access instance variables of classes/modules from non-main Ractors (RuntimeError) */
"\n"/*  */
"\n"/* Ractors can access constants if they are shareable. The main Ractor is the only one that can */
"\n"/* access non-shareable constants. */
"\n"/*  */
"\n"/*     GOOD = 'good'.freeze */
"\n"/*     BAD = 'bad' */
"\n"/*  */
"\n"/*     r = Ractor.new do */
"\n"/*       puts "GOOD=#{GOOD}" */
"\n"/*       puts "BAD=#{BAD}" */
"\n"/*     end */
"\n"/*     r.take */
"\n"/*     # GOOD=good */
"\n"/*     # can not access non-shareable objects in constant Object::BAD by non-main Ractor. (NameError) */
"\n"/*  */
"\n"/*     # Consider the same C class from above */
"\n"/*  */
"\n"/*     r = Ractor.new do */
"\n"/*       puts "I see #{C}" */
"\n"/*       puts "I can't see #{C.tricky}" */
"\n"/*     end */
"\n"/*     r.take */
"\n"/*     # I see C */
"\n"/*     # can not access instance variables of classes/modules from non-main Ractors (RuntimeError) */
"\n"/*  */
"\n"/* See also the description of <tt># shareable_constant_value</tt> pragma in */
"\n"/* {Comments syntax}[rdoc-ref:doc/syntax/comments.rdoc] explanation. */
"\n"/*  */
"\n"/* == Ractors vs threads */
"\n"/*  */
"\n"/* Each ractor creates its own thread. New threads can be created from inside ractor, having the full */
"\n"/* access to its data (and, on CRuby, sharing GVL with other threads of this ractor). */
"\n"/*  */
"\n"/*     r = Ractor.new do */
"\n"/*       a = 1 */
"\n"/*       Thread.new {puts "Thread in ractor: a=#{a}"}.join */
"\n"/*     end */
"\n"/*     r.take */
"\n"/*     # Here "Thread in ractor: a=1" will be printed */
"\n"/*  */
"\n"/* == Note on code examples */
"\n"/*  */
"\n"/* In examples below, sometimes we use the following method to wait till ractors that */
"\n"/* are not currently blocked will finish (or process till next blocking) method. */
"\n"/*  */
"\n"/*     def wait */
"\n"/*       sleep(0.1) */
"\n"/*     end */
"\n"/*  */
"\n"/* It is **only for demonstration purposes** and shouldn't be used in a real code. */
"\n"/* Most of the times, just #take is used to wait till ractor will finish. */
"\n"/*  */
"class Ractor\n"
"\n"/* Create a new Ractor with args and a block. */
"\n"/*  */
"\n"/* A block (Proc) will be isolated (can't access to outer variables). +self+ */
"\n"/* inside the block will refer to the current Ractor. */
"\n"/*  */
"\n"/*    r = Ractor.new {puts "Hi, I am #{self.inspect}"} */
"\n"/*    r.take */
"\n"/*    # Prints "Hi, I am #<Ractor:#2 test.rb:1 running>" */
"\n"/*  */
"\n"/* +args+ passed to the method would be propagated to block args by the same rules as */
"\n"/* objects passed through #send/Ractor.receive: if +args+ are not shareable, they */
"\n"/* will be copied (via deep cloning, which might be inefficient). */
"\n"/*  */
"\n"/*    arg = [1, 2, 3] */
"\n"/*    puts "Passing: #{arg} (##{arg.object_id})" */
"\n"/*    r = Ractor.new(arg) {|received_arg| */
"\n"/*     puts "Received: #{received_arg} (##{received_arg.object_id})" */
"\n"/*    } */
"\n"/*    r.take */
"\n"/*    # Prints: */
"\n"/*    #   Passing: [1, 2, 3] (#280) */
"\n"/*    #   Received: [1, 2, 3] (#300) */
"\n"/*  */
"\n"/* Ractor's +name+ can be set for debugging purposes: */
"\n"/*  */
"\n"/*    r = Ractor.new(name: 'my ractor') {} */
"\n"/*    p r */
"\n"/*    #=> #<Ractor:#3 my ractor test.rb:1 terminated> */
"\n"/*  */
"  def self.new(*args, name: nil, &block)\n"
"    b = block\n"/* TODO: builtin bug */
"    raise ArgumentError, \"must be called with a block\" unless block\n"
"    loc = caller_locations(1, 1).first\n"
"    loc = \"#{loc.path}:#{loc.lineno}\"\n"
"    __builtin_ractor_create(loc, name, args, b)\n"
"  end\n"
"\n"
"\n"/* Returns the currently executing Ractor. */
,
#line 250 "ractor.rb"
"\n"/*  */
"\n"/*   Ractor.current #=> #<Ractor:#1 running> */
"  def self.current\n"
"    __builtin_cexpr! %q{\n"
"      rb_ec_ractor_ptr(ec)->self\n"
"    }\n"
"  end\n"
"\n"
"\n"/* Returns total count of Ractors currently running. */
"\n"/*  */
"\n"/*    Ractor.count                   #=> 1 */
"\n"/*    r = Ractor.new(name: 'example') {sleep(0.1)} */
"\n"/*    Ractor.count                   #=> 2 (main + example ractor) */
"\n"/*    r.take                         # wait till r will finish */
"\n"/*    Ractor.count                   #=> 1 */
"  def self.count\n"
"    __builtin_cexpr! %q{\n"
"      ULONG2NUM(GET_VM()->ractor.cnt);\n"
"    }\n"
"  end\n"
"\n"
"\n"/* call-seq: Ractor.select(*ractors, [yield_value:, move: false]) -> [ractor or symbol, obj] */
"\n"/*  */
"\n"/* Waits for the first ractor to have something in its outgoing port, reads from this ractor, and */
"\n"/* returns that ractor and the object received. */
"\n"/*  */
"\n"/*    r1 = Ractor.new {Ractor.yield 'from 1'} */
"\n"/*    r2 = Ractor.new {Ractor.yield 'from 2'} */
"\n"/*  */
"\n"/*    r, obj = Ractor.select(r1, r2) */
"\n"/*  */
"\n"/*    puts "received #{obj.inspect} from #{r.inspect}" */
"\n"/*    # Prints: received "from 1" from #<Ractor:#2 test.rb:1 running> */
"\n"/*  */
"\n"/* If one of the given ractors is the current ractor, and it would be selected, +r+ will contain */
"\n"/* +:receive+ symbol instead of the ractor object. */
"\n"/*  */
"\n"/*    r1 = Ractor.new(Ractor.current) do |main| */
"\n"/*      main.send 'to main' */
"\n"/*      Ractor.yield 'from 1' */
"\n"/*    end */
"\n"/*    r2 = Ractor.new do */
"\n"/*      Ractor.yield 'from 2' */
"\n"/*    end */
"\n"/*  */
"\n"/*    r, obj = Ractor.select(r1, r2, Ractor.current) */
"\n"/*    puts "received #{obj.inspect} from #{r.inspect}" */
"\n"/*    # Prints: received "to main" from :receive */
"\n"/*  */
"\n"/* If +yield_value+ is provided, that value may be yielded if another Ractor is calling #take. */
"\n"/* In this case, the pair <tt>[:yield, nil]</tt> would be returned: */
"\n"/*  */
"\n"/*    r1 = Ractor.new(Ractor.current) do |main| */
"\n"/*      puts "Received from main: #{main.take}" */
"\n"/*    end */
"\n"/*  */
"\n"/*    puts "Trying to select" */
"\n"/*    r, obj = Ractor.select(r1, Ractor.current, yield_value: 123) */
"\n"/*    wait */
"\n"/*    puts "Received #{obj.inspect} from #{r.inspect}" */
"\n"/*  */
"\n"/* This will print: */
"\n"/*  */
"\n"/*    Trying to select */
"\n"/*    Received from main: 123 */
"\n"/*    Received nil from :yield */
"\n"/*  */
"\n"/* +move+ boolean flag defines whether yielded value should be copied (default) or moved. */
"  def self.select(*ractors, yield_value: yield_unspecified = true, move: false)\n"
"    raise ArgumentError, 'specify at least one ractor or `yield_value`' if yield_unspecified && ractors.empty?\n"
"\n"
"    __builtin_cstmt! %q{\n"
,
#line 322 "ractor.rb"
"      const VALUE *rs = RARRAY_CONST_PTR_TRANSIENT(ractors);\n"
"      VALUE rv;\n"
"      VALUE v = ractor_select(ec, rs, RARRAY_LENINT(ractors),\n"
"                              yield_unspecified == Qtrue ? Qundef : yield_value,\n"
"                              (bool)RTEST(move) ? true : false, &rv);\n"
"      return rb_ary_new_from_args(2, rv, v);\n"
"    }\n"
"  end\n"
"\n"
"\n"/* Receive an incoming message from the current Ractor's incoming port's queue, which was */
"\n"/* sent there by #send. */
"\n"/*  */
"\n"/*     r = Ractor.new do */
"\n"/*       v1 = Ractor.receive */
"\n"/*       puts "Received: #{v1}" */
"\n"/*     end */
"\n"/*     r.send('message1') */
"\n"/*     r.take */
"\n"/*     # Here will be printed: "Received: message1" */
"\n"/*  */
"\n"/* Alternatively, private instance method +receive+ may be used: */
"\n"/*  */
"\n"/*     r = Ractor.new do */
"\n"/*       v1 = receive */
"\n"/*       puts "Received: #{v1}" */
"\n"/*     end */
"\n"/*     r.send('message1') */
"\n"/*     r.take */
"\n"/*     # Here will be printed: "Received: message1" */
"\n"/*  */
"\n"/* The method blocks if the queue is empty. */
"\n"/*  */
"\n"/*     r = Ractor.new do */
"\n"/*       puts "Before first receive" */
"\n"/*       v1 = Ractor.receive */
"\n"/*       puts "Received: #{v1}" */
"\n"/*       v2 = Ractor.receive */
"\n"/*       puts "Received: #{v2}" */
"\n"/*     end */
"\n"/*     wait */
"\n"/*     puts "Still not received" */
"\n"/*     r.send('message1') */
"\n"/*     wait */
"\n"/*     puts "Still received only one" */
"\n"/*     r.send('message2') */
"\n"/*     r.take */
"\n"/*  */
"\n"/* Output: */
"\n"/*  */
"\n"/*     Before first receive */
"\n"/*     Still not received */
"\n"/*     Received: message1 */
"\n"/*     Still received only one */
"\n"/*     Received: message2 */
"\n"/*  */
"\n"/* If close_incoming was called on the ractor, the method raises Ractor::ClosedError: */
"\n"/*  */
"\n"/*     Ractor.new do */
"\n"/*       close_incoming */
"\n"/*       receive */
"\n"/*     end */
"\n"/*     wait */
"\n"/*     # in `receive': The incoming port is already closed => #<Ractor:#2 test.rb:1 running> (Ractor::ClosedError) */
"\n"/*  */
"  def self.receive\n"
"    __builtin_cexpr! %q{\n"
"      ractor_receive(ec, rb_ec_ractor_ptr(ec))\n"
"    }\n"
"  end\n"
"\n"
,
#line 392 "ractor.rb"
"  class << self\n"
"    alias recv receive\n"
"  end\n"
"\n"
"\n"/* same as Ractor.receive */
"  private def receive\n"
"    __builtin_cexpr! %q{\n"
"      ractor_receive(ec, rb_ec_ractor_ptr(ec))\n"
"    }\n"
"  end\n"
"  alias recv receive\n"
"\n"
"\n"/* Receive only a specific message. */
"\n"/*  */
"\n"/* Instead of Ractor.receive, Ractor.receive_if can provide a pattern */
"\n"/* by a block and you can choose the receiving message. */
"\n"/*  */
"\n"/*     r = Ractor.new do */
"\n"/*       p Ractor.receive_if{|msg| msg.match?(/foo/)} #=> "foo3" */
"\n"/*       p Ractor.receive_if{|msg| msg.match?(/bar/)} #=> "bar1" */
"\n"/*       p Ractor.receive_if{|msg| msg.match?(/baz/)} #=> "baz2" */
"\n"/*     end */
"\n"/*     r << "bar1" */
"\n"/*     r << "baz2" */
"\n"/*     r << "foo3" */
"\n"/*     r.take */
"\n"/*  */
"\n"/* This will output: */
"\n"/*  */
"\n"/*     foo3 */
"\n"/*     bar1 */
"\n"/*     baz2 */
"\n"/*  */
"\n"/* If the block returns a truthy value, the message will be removed from the incoming queue */
"\n"/* and return this method with the message. */
"\n"/* When the block is escaped by break/return/exception and so on, the message also */
"\n"/* removed from the incoming queue. */
"\n"/* Otherwise, the messsage remains in the incoming queue and the next received */
"\n"/* message is checked by the given block. */
"\n"/*  */
"\n"/* If there is no messages in the incoming queue matching the check, the method will */
"\n"/* block until such message arrives. */
"\n"/*  */
"\n"/*     r = Ractor.new do */
"\n"/*       val = Ractor.receive_if{|msg| msg.is_a?(Array)} */
"\n"/*       puts "Received successfully: #{val}" */
"\n"/*     end */
"\n"/*  */
"\n"/*     r.send(1) */
"\n"/*     r.send('test') */
"\n"/*     wait */
"\n"/*     puts "2 non-matching sent, nothing received" */
"\n"/*     r.send([1, 2, 3]) */
"\n"/*     wait */
"\n"/*  */
"\n"/* Prints: */
"\n"/*  */
"\n"/*     2 non-matching sent, nothing received */
"\n"/*     Received successfully: [1, 2, 3] */
"\n"/*  */
"\n"/* Note that you can not call receive/receive_if in the given block recursively. */
"\n"/* It means that you should not do any tasks in the block. */
"\n"/*  */
"\n"/*     Ractor.current << true */
"\n"/*     Ractor.receive_if{|msg| Ractor.receive} */
"\n"/*     #=> `receive': can not call receive/receive_if recursively (Ractor::Error) */
"\n"/*  */
"  def self.receive_if &b\n"
"    Primitive.ractor_receive_if b\n"
"  end\n"
"\n"
"  private def receive_if &b\n"
"    Primitive.ractor_receive_if b\n"
"  end\n"
"\n"
"\n"/* Send a message to a Ractor's incoming queue to be consumed by Ractor.receive. */
"\n"/*  */
"\n"/*   r = Ractor.new do */
"\n"/*     value = Ractor.receive */
"\n"/*     puts "Received #{value}" */
"\n"/*   end */
"\n"/*   r.send 'message' */
"\n"/*   # Prints: "Received: message" */
"\n"/*  */
"\n"/* The method is non-blocking (will return immediately even if the ractor is not ready */
"\n"/* to receive anything): */
"\n"/*  */
"\n"/*    r = Ractor.new {sleep(5)} */
"\n"/*    r.send('test') */
"\n"/*    puts "Sent successfully" */
"\n"/*    # Prints: "Sent successfully" immediately */
"\n"/*  */
"\n"/* Attempt to send to ractor which already finished its execution will raise Ractor::ClosedError. */
"\n"/*  */
"\n"/*   r = Ractor.new {} */
"\n"/*   r.take */
"\n"/*   p r */
"\n"/*   # "#<Ractor:#6 (irb):23 terminated>" */
"\n"/*   r.send('test') */
"\n"/*   # Ractor::ClosedError (The incoming-port is already closed) */
"\n"/*  */
"\n"/* If close_incoming was called on the ractor, the method also raises Ractor::ClosedError. */
"\n"/*  */
"\n"/*    r =  Ractor.new do */
"\n"/*      sleep(500) */
"\n"/*      receive */
"\n"/*    end */
"\n"/*    r.close_incoming */
"\n"/*    r.send('test') */
"\n"/*    # Ractor::ClosedError (The incoming-port is already closed) */
"\n"/*    # The error would be raised immediately, not when ractor will try to receive */
"\n"/*  */
"\n"/* If the +obj+ is unshareable, by default it would be copied into ractor by deep cloning. */
"\n"/* If the <tt>move: true</tt> is passed, object is _moved_ into ractor and becomes */
"\n"/* inaccessible to sender. */
"\n"/*  */
"\n"/*    r = Ractor.new {puts "Received: #{receive}"} */
"\n"/*    msg = 'message' */
"\n"/*    r.send(msg, move: true) */
"\n"/*    r.take */
"\n"/*    p msg */
"\n"/*  */
"\n"/* This prints: */
"\n"/*  */
"\n"/*    Received: message */
"\n"/*    in `p': undefined method `inspect' for #<Ractor::MovedObject:0x000055c99b9b69b8> */
"\n"/*  */
"\n"/* All references to the object and its parts will become invalid in sender. */
"\n"/*  */
"\n"/*    r = Ractor.new {puts "Received: #{receive}"} */
"\n"/*    s = 'message' */
"\n"/*    ary = [s] */
"\n"/*    copy = ary.dup */
"\n"/*    r.send(ary, move: true) */
"\n"/*  */
"\n"/*    s.inspect */
"\n"/*    # Ractor::MovedError (can not send any methods to a moved object) */
"\n"/*    ary.class */
"\n"/*    # Ractor::MovedError (can not send any methods to a moved object) */
"\n"/*    copy.class */
"\n"/*    # => Array, it is different object */
"\n"/*    copy[0].inspect */
"\n"/*    # Ractor::MovedError (can not send any methods to a moved object) */
"\n"/*    # ...but its item was still a reference to `s`, which was moved */
"\n"/*  */
"\n"/* If the object was shareable, <tt>move: true</tt> has no effect on it: */
"\n"/*  */
"\n"/*    r = Ractor.new {puts "Received: #{receive}"} */
"\n"/*    s = 'message'.freeze */
"\n"/*    r.send(s, move: true) */
"\n"/*    s.inspect #=> "message", still available */
"\n"/*  */
"  def send(obj, move: false)\n"
"    __builtin_cexpr! %q{\n"
,
#line 546 "ractor.rb"
"      ractor_send(ec, RACTOR_PTR(self), obj, move)\n"
"    }\n"
"  end\n"
"  alias << send\n"
"\n"
"\n"/* Send a message to the current ractor's outgoing port to be consumed by #take. */
"\n"/*  */
"\n"/*    r = Ractor.new {Ractor.yield 'Hello from ractor'} */
"\n"/*    puts r.take */
"\n"/*    # Prints: "Hello from ractor" */
"\n"/*  */
"\n"/* The method is blocking, and will return only when somebody consumes the */
"\n"/* sent message. */
"\n"/*  */
"\n"/*    r = Ractor.new do */
"\n"/*      Ractor.yield 'Hello from ractor' */
"\n"/*      puts "Ractor: after yield" */
"\n"/*    end */
"\n"/*    wait */
"\n"/*    puts "Still not taken" */
"\n"/*    puts r.take */
"\n"/*  */
"\n"/* This will print: */
"\n"/*  */
"\n"/*    Still not taken */
"\n"/*    Hello from ractor */
"\n"/*    Ractor: after yield */
"\n"/*  */
"\n"/* If the outgoing port was closed with #close_outgoing, the method will raise: */
"\n"/*  */
"\n"/*    r = Ractor.new do */
"\n"/*      close_outgoing */
"\n"/*      Ractor.yield 'Hello from ractor' */
"\n"/*    end */
"\n"/*    wait */
"\n"/*    # `yield': The outgoing-port is already closed (Ractor::ClosedError) */
"\n"/*  */
"\n"/* The meaning of +move+ argument is the same as for #send. */
"  def self.yield(obj, move: false)\n"
"    __builtin_cexpr! %q{\n"
"      ractor_yield(ec, rb_ec_ractor_ptr(ec), obj, move)\n"
"    }\n"
"  end\n"
"\n"
"\n"/* Take a message from ractor's outgoing port, which was put there by Ractor.yield or at ractor's */
"\n"/* finalization. */
"\n"/*  */
"\n"/*   r = Ractor.new do */
"\n"/*     Ractor.yield 'explicit yield' */
"\n"/*     'last value' */
"\n"/*   end */
"\n"/*   puts r.take #=> 'explicit yield' */
"\n"/*   puts r.take #=> 'last value' */
"\n"/*   puts r.take # Ractor::ClosedError (The outgoing-port is already closed) */
"\n"/*  */
"\n"/* The fact that the last value is also put to outgoing port means that +take+ can be used */
"\n"/* as some analog of Thread#join ("just wait till ractor finishes"), but don't forget it */
"\n"/* will raise if somebody had already consumed everything ractor have produced. */
"\n"/*  */
"\n"/* If the outgoing port was closed with #close_outgoing, the method will raise Ractor::ClosedError. */
"\n"/*  */
"\n"/*    r = Ractor.new do */
"\n"/*      sleep(500) */
"\n"/*      Ractor.yield 'Hello from ractor' */
"\n"/*    end */
"\n"/*    r.close_outgoing */
"\n"/*    r.take */
"\n"/*    # Ractor::ClosedError (The outgoing-port is already closed) */
"\n"/*    # The error would be raised immediately, not when ractor will try to receive */
"\n"/*  */
"\n"/* If an uncaught exception is raised in the Ractor, it is propagated on take as a */
"\n"/* Ractor::RemoteError. */
"\n"/*  */
"\n"/*   r = Ractor.new {raise "Something weird happened"} */
"\n"/*  */
"\n"/*   begin */
"\n"/*     r.take */
"\n"/*   rescue => e */
"\n"/*     p e              #  => #<Ractor::RemoteError: thrown by remote Ractor.> */
"\n"/*     p e.ractor == r  # => true */
"\n"/*     p e.cause        # => #<RuntimeError: Something weird happened> */
"\n"/*   end */
"\n"/*  */
"\n"/* Ractor::ClosedError is a descendant of StopIteration, so the closing of the ractor will break */
"\n"/* the loops without propagating the error: */
"\n"/*  */
"\n"/*     r = Ractor.new do */
"\n"/*       3.times {|i| Ractor.yield "message #{i}"} */
"\n"/*       "finishing" */
"\n"/*     end */
"\n"/*  */
"\n"/*     loop {puts "Received: " + r.take} */
"\n"/*     puts "Continue successfully" */
"\n"/*  */
"\n"/* This will print: */
"\n"/*  */
"\n"/*     Received: message 0 */
"\n"/*     Received: message 1 */
"\n"/*     Received: message 2 */
"\n"/*     Received: finishing */
"\n"/*     Continue successfully */
"  def take\n"
"    __builtin_cexpr! %q{\n"
"      ractor_take(ec, RACTOR_PTR(self))\n"
"    }\n"
"  end\n"
"\n"
"  def inspect\n"/* :nodoc: */
"    loc  = __builtin_cexpr! %q{RACTOR_PTR(self)->loc}\n"
,
#line 655 "ractor.rb"
"    name = __builtin_cexpr! %q{RACTOR_PTR(self)->name}\n"
"    id   = __builtin_cexpr! %q{INT2FIX(RACTOR_PTR(self)->id)}\n"
"    status = __builtin_cexpr! %q{\n"
"      rb_str_new2(ractor_status_str(RACTOR_PTR(self)->status_))\n"
"    }\n"
"    \"#<Ractor:##{id}#{name ? ' '+name : ''}#{loc ? \" \" + loc : ''} #{status}>\"\n"
"  end\n"
"\n"
"\n"/* The name set in Ractor.new, or +nil+. */
"  def name\n"
"    __builtin_cexpr! %q{RACTOR_PTR(self)->name}\n"
"  end\n"
"\n"
"  class RemoteError\n"
"    attr_reader :ractor\n"
"  end\n"
"\n"
"\n"/* Closes the incoming port and returns its previous state. */
"\n"/* All further attempts to Ractor.receive in the ractor, and #send to the ractor */
"\n"/* will fail with Ractor::ClosedError. */
"\n"/*  */
"\n"/*   r = Ractor.new {sleep(500)} */
"\n"/*   r.close_incoming  #=> false */
"\n"/*   r.close_incoming  #=> true */
"\n"/*   r.send('test') */
"\n"/*   # Ractor::ClosedError (The incoming-port is already closed) */
"  def close_incoming\n"
"    __builtin_cexpr! %q{\n"
,
#line 683 "ractor.rb"
"      ractor_close_incoming(ec, RACTOR_PTR(self));\n"
"    }\n"
"  end\n"
"\n"
"\n"/* Closes the outgoing port and returns its previous state. */
"\n"/* All further attempts to Ractor.yield in the ractor, and #take from the ractor */
"\n"/* will fail with Ractor::ClosedError. */
"\n"/*  */
"\n"/*   r = Ractor.new {sleep(500)} */
"\n"/*   r.close_outgoing  #=> false */
"\n"/*   r.close_outgoing  #=> true */
"\n"/*   r.take */
"\n"/*   # Ractor::ClosedError (The outgoing-port is already closed) */
"  def close_outgoing\n"
"    __builtin_cexpr! %q{\n"
"      ractor_close_outgoing(ec, RACTOR_PTR(self));\n"
"    }\n"
"  end\n"
"\n"
"\n"/* Checks if the object is shareable by ractors. */
"\n"/*  */
"\n"/*     Ractor.shareable?(1)            #=> true -- numbers and other immutable basic values are frozen */
"\n"/*     Ractor.shareable?('foo')        #=> false, unless the string is frozen due to # freeze_string_literals: true */
"\n"/*     Ractor.shareable?('foo'.freeze) #=> true */
"\n"/*  */
"\n"/* See also the "Shareable and unshareable objects" section in the Ractor class docs. */
"  def self.shareable? obj\n"
"    __builtin_cexpr! %q{\n"
"      rb_ractor_shareable_p(obj) ? Qtrue : Qfalse;\n"
"    }\n"
"  end\n"
"\n"
"\n"/* Make +obj+ sharable. */
"\n"/*  */
"\n"/* Basically, traverse referring objects from obj and freeze them. */
"\n"/*  */
"\n"/* When a sharable object is found in traversing, stop traversing */
"\n"/* from this shareable object. */
"\n"/*  */
"\n"/* If +copy+ keyword is +true+, it makes a deep copied object */
"\n"/* and make it sharable. This is safer option (but it can take more time). */
"\n"/*  */
"\n"/* Note that the specification and implementation of this method are not */
"\n"/* matured and can be changed in a future. */
"\n"/*  */
"\n"/*   obj = ['test'] */
"\n"/*   Ractor.shareable?(obj)     #=> false */
"\n"/*   Ractor.make_shareable(obj) #=> ["test"] */
"\n"/*   Ractor.shareable?(obj)     #=> true */
"\n"/*   obj.frozen?                #=> true */
"\n"/*   obj[0].frozen?             #=> true */
"\n"/*  */
"\n"/*   # Copy vs non-copy versions: */
"\n"/*   obj1 = ['test'] */
"\n"/*   obj1s = Ractor.make_shareable(obj1) */
"\n"/*   obj1.frozen?                        #=> true */
"\n"/*   obj1s.object_id == obj1.object_id   #=> true */
"\n"/*   obj2 = ['test'] */
"\n"/*   obj2s = Ractor.make_shareable(obj2, copy: true) */
"\n"/*   obj2.frozen?                        #=> false */
"\n"/*   obj2s.frozen?                       #=> true */
"\n"/*   obj2s.object_id == obj1.object_id   #=> false */
"\n"/*   obj2s[0].object_id == obj2[0].object_id #=> false */
"\n"/*  */
"\n"/* See also the "Shareable and unshareable objects" section in the Ractor class docs. */
"  def self.make_shareable obj, copy: false\n"
"    if copy\n"
"      __builtin_cexpr! %q{\n"
"        rb_ractor_make_copy_shareable(obj);\n"
"      }\n"
"    else\n"
"      __builtin_cexpr! %q{\n"
,
#line 755 "ractor.rb"
"        rb_ractor_make_shareable(obj);\n"
"      }\n"
"    end\n"
"  end\n"
"end\n"
#line 2603 "miniprelude.c"
};

static const char prelude_name11[] = "<internal:prelude>";
static const struct {
    char L0[182]; /* 1..23 */
} prelude_code11 = {
#line 1 "prelude.rb"
"class Binding\n"
"\n"/* :nodoc: */
"  def irb\n"
"    require 'irb'\n"
"    irb\n"
"  end\n"
"\n"
"\n"/* suppress redefinition warning */
"  alias irb irb\n"/* :nodoc: */
"end\n"
"\n"
"module Kernel\n"
"  def pp(*objs)\n"
"    require 'pp'\n"
"    pp(*objs)\n"
"  end\n"
"\n"
"\n"/* suppress redefinition warning */
"  alias pp pp\n"/* :nodoc: */
"\n"
"  private :pp\n"
"end\n"
#line 2633 "miniprelude.c"
};

static const char prelude_name12[] = "<internal:gem_prelude>";
static const struct {
    char L0[219]; /* 1..12 */
} prelude_code12 = {
#line 1 "gem_prelude.rb"
"begin\n"
"  require 'rubygems'\n"
"rescue LoadError\n"
"  warn \"`RubyGems' were not loaded.\"\n"
"end if defined?(Gem)\n"
"\n"
"begin\n"
"  require 'did_you_mean'\n"
"rescue LoadError\n"
"  warn \"`did_you_mean' was not loaded.\"\n"
"end if defined?(DidYouMean)\n"
#line 2652 "miniprelude.c"
};

COMPILER_WARNING_POP

#define PRELUDE_NAME(n) rb_usascii_str_new_static(prelude_name##n, sizeof(prelude_name##n)-1)
#define PRELUDE_CODE(n) rb_utf8_str_new_static(prelude_code##n.L0, sizeof(prelude_code##n))

static rb_ast_t *
prelude_ast(VALUE name, VALUE code, int line)
{
    rb_ast_t *ast = rb_parser_compile_string_path(rb_parser_new(), name, code, line);
    if (!ast->body.root) {
	rb_ast_dispose(ast);
	rb_exc_raise(rb_errinfo());
    }
    return ast;
}

#define PRELUDE_AST(n, name_str) \
    (((sizeof(prelude_name##n) - prefix_len - 2) == namelen) && \
     (strncmp(prelude_name##n + prefix_len, feature_name, namelen) == 0) ? \
     prelude_ast((name_str) = PRELUDE_NAME(n), PRELUDE_CODE(n), 1) : 0)

rb_ast_t *
rb_builtin_ast(const char *feature_name, VALUE *name_str)
{
    const size_t prefix_len = rb_strlen_lit("<internal:");
    size_t namelen = strlen(feature_name);
    rb_ast_t *ast = 0;

    if ((ast = PRELUDE_AST(0, *name_str)) != 0) return ast;
    if ((ast = PRELUDE_AST(1, *name_str)) != 0) return ast;
    if ((ast = PRELUDE_AST(2, *name_str)) != 0) return ast;
    if ((ast = PRELUDE_AST(3, *name_str)) != 0) return ast;
    if ((ast = PRELUDE_AST(4, *name_str)) != 0) return ast;
    if ((ast = PRELUDE_AST(5, *name_str)) != 0) return ast;
    if ((ast = PRELUDE_AST(6, *name_str)) != 0) return ast;
    if ((ast = PRELUDE_AST(7, *name_str)) != 0) return ast;
    if ((ast = PRELUDE_AST(8, *name_str)) != 0) return ast;
    if ((ast = PRELUDE_AST(9, *name_str)) != 0) return ast;
    if ((ast = PRELUDE_AST(10, *name_str)) != 0) return ast;
    if ((ast = PRELUDE_AST(11, *name_str)) != 0) return ast;
    if ((ast = PRELUDE_AST(12, *name_str)) != 0) return ast;
    return ast;
}

void
Init_prelude(void)
{
}
