#
# DO NOT MODIFY!!!!
# This file is automatically generated by Racc 1.5.1
# from Racc grammar file "".
#

require 'racc/parser.rb'
module RBS
  class Parser < Racc::Parser

module_eval(<<'...end parser.y/module_eval...', 'parser.y', 1058)

Types = RBS::Types
Namespace = RBS::Namespace
TypeName = RBS::TypeName
Declarations = RBS::AST::Declarations
Members = RBS::AST::Members
MethodType = RBS::MethodType
Annotation = RBS::AST::Annotation

class LocatedValue
  attr_reader :location
  attr_reader :value

  def initialize(location:, value:)
    @location = location
    @value = value
  end
end

require "strscan"

attr_reader :input
attr_reader :buffer
attr_reader :eof_re

def initialize(type, buffer:, eof_re:)
  super()
  @type = type
  @buffer = buffer
  @input = StringScanner.new(buffer.content)
  @eof_re = eof_re
  @eof = false
  @bound_variables_stack = []
  @comments = {}
  @ascii_only = buffer.content.ascii_only?
end

def start_merged_variables_scope
  set = @bound_variables_stack.last&.dup || Set.new
  @bound_variables_stack.push set
end

def start_new_variables_scope
  @bound_variables_stack.push Set.new
end

def reset_variable_scope
  @bound_variables_stack.pop
end

def insert_bound_variable(var)
  @bound_variables_stack.last << var
end

def is_bound_variable?(var)
  (@bound_variables_stack.last || Set.new).member?(var)
end

def self.parse_signature(input, eof_re: nil)
  case input
  when RBS::Buffer
    buffer = input
  else
    buffer = RBS::Buffer.new(name: nil, content: input.to_s)
  end

  self.new(:SIGNATURE, buffer: buffer, eof_re: eof_re).do_parse
end

def self.parse_type(input, variables: [], eof_re: nil)
  case input
  when RBS::Buffer
    buffer = input
  else
    buffer = RBS::Buffer.new(name: nil, content: input.to_s)
  end

  self.new(:TYPE, buffer: buffer, eof_re: eof_re).yield_self do |parser|
    parser.start_new_variables_scope

    variables.each do |var|
      parser.insert_bound_variable var
    end

    parser.do_parse
  ensure
    parser.reset_variable_scope
  end
end

def self.parse_method_type(input, variables: [], eof_re: nil)
  case input
  when RBS::Buffer
    buffer = input
  else
    buffer = RBS::Buffer.new(name: nil, content: input.to_s)
  end

  self.new(:METHODTYPE, buffer: buffer, eof_re: eof_re).yield_self do |parser|
    parser.start_new_variables_scope

    variables.each do |var|
      parser.insert_bound_variable var
    end

    parser.do_parse
  ensure
    parser.reset_variable_scope
  end
end

def leading_comment(location)
  @comments[location.start_line-1]
end

def push_comment(string, location)
  if (comment = leading_comment(location)) && comment.location.start_column == location.start_column
    comment.concat(string: "#{string}\n", location: location)
    @comments[comment.location.end_line] = comment
  else
    new_comment = AST::Comment.new(string: "#{string}\n", location: location)
    @comments[new_comment.location.end_line] = new_comment
  end
end

def new_token(type, value = input.matched)
  charpos = charpos(input)
  matched = input.matched

  if matched
    start_index = charpos - matched.size
    end_index = charpos

    location = RBS::Location.new(buffer: buffer,
                                 start_pos: start_index,
                                 end_pos: end_index)

    [type, LocatedValue.new(location: location, value: value)]
  else
    # scanner hasn't matched yet
    [false, nil]
  end
end

def charpos(scanner)
  if @ascii_only
    scanner.pos
  else
    scanner.charpos
  end
end

def empty_params_result
  [
    [],
    [],
    nil,
    [],
    {},
    {},
    nil
  ]
end

KEYWORDS = {
  "class" => :kCLASS,
  "type" => :kTYPE,
  "def" => :kDEF,
  "self" => :kSELF,
  "void" => :kVOID,
  "any" => :kANY,
  "untyped" => :kUNTYPED,
  "top" => :kTOP,
  "bot" => :kBOT,
  "instance" => :kINSTANCE,
  "bool" => :kBOOL,
  "nil" => :kNIL,
  "true" => :kTRUE,
  "false" => :kFALSE,
  "singleton" => :kSINGLETON,
  "interface" => :kINTERFACE,
  "end" => :kEND,
  "include" => :kINCLUDE,
  "extend" => :kEXTEND,
  "prepend" => :kPREPEND,
  "module" => :kMODULE,
  "attr_reader" => :kATTRREADER,
  "attr_writer" => :kATTRWRITER,
  "attr_accessor" => :kATTRACCESSOR,
  "public" => :kPUBLIC,
  "private" => :kPRIVATE,
  "alias" => :kALIAS,
  "extension" => :kEXTENSION,
  "incompatible" => :kINCOMPATIBLE,
  "unchecked" => :kUNCHECKED,
  "overload" => :kOVERLOAD,
  "out" => :kOUT,
  "in" => :kIN,
}
KEYWORDS_RE = /#{Regexp.union(*KEYWORDS.keys)}\b/

PUNCTS = {
  "===" => :tOPERATOR,
  "==" => :tOPERATOR,
  "=~" => :tOPERATOR,
  "!~" => :tOPERATOR,
  "!=" => :tOPERATOR,
  ">=" => :tOPERATOR,
  "<<" => :tOPERATOR,
  "<=>" => :tOPERATOR,
  "<=" => :tOPERATOR,
  ">>" => :tOPERATOR,
  ">" => :tOPERATOR,
  "~" => :tOPERATOR,
  "+@" => :tOPERATOR,
  "+" => :tOPERATOR,
  "[]=" => :tOPERATOR,
  "[]" => :tOPERATOR,
  "::" => :kCOLON2,
  ":" => :kCOLON,
  "(" => :kLPAREN,
  ")" => :kRPAREN,
  "[" => :kLBRACKET,
  "]" => :kRBRACKET,
  "{" => :kLBRACE,
  "}" => :kRBRACE,
  "," => :kCOMMA,
  "|" => :kBAR,
  "&" => :kAMP,
  "^" => :kHAT,
  "->" => :kARROW,
  "=>" => :kFATARROW,
  "=" => :kEQ,
  "?" => :kQUESTION,
  "!" => :kEXCLAMATION,
  "**" => :kSTAR2,
  "*" => :kSTAR,
  "..." => :kDOT3,
  "." => :kDOT,
  "<" => :kLT,
  "-@" => :tOPERATOR,
  "-" => :tOPERATOR,
  "/" => :tOPERATOR,
  "`" => :tOPERATOR,
  "%" => :tOPERATOR,
}
PUNCTS_RE = Regexp.union(*PUNCTS.keys)

ANNOTATION_RE = Regexp.union(/%a\{.*?\}/,
                             /%a\[.*?\]/,
                             /%a\(.*?\)/,
                             /%a\<.*?\>/,
                             /%a\|.*?\|/)

escape_sequences = %w[a b e f n r s t v "].map { |l| "\\\\#{l}" }
DBL_QUOTE_STR_ESCAPE_SEQUENCES_RE = /(#{escape_sequences.join("|")})/

def next_token
  if @type
    type = @type
    @type = nil
    return [:"type_#{type}", nil]
  end

  return new_token(false, '') if @eof

  while true
    return new_token(false, '') if input.eos?

    case
    when input.scan(/\s+/)
      # skip
    when input.scan(/#(( *)|( ?(?<string>.*)))\n/)
      charpos = charpos(input)
      start_index = charpos - input.matched.size
      end_index = charpos-1

      location = RBS::Location.new(buffer: buffer,
                                               start_pos: start_index,
                                               end_pos: end_index)

      push_comment input[:string] || "", location
    else
      break
    end
  end

  case
  when eof_re && input.scan(eof_re)
    @eof = true
    [:tEOF, input.matched]
  when input.scan(/`[a-zA-Z_]\w*`/)
    s = input.matched.yield_self {|s| s[1, s.length-2] }
    new_token(:tQUOTEDIDENT, s)
  when input.scan(/`(\\`|[^` :])+`/)
    s = input.matched.yield_self {|s| s[1, s.length-2] }.gsub(/\\`/, '`')
    new_token(:tQUOTEDMETHOD, s)
  when input.scan(ANNOTATION_RE)
    s = input.matched.yield_self {|s| s[3, s.length-4] }.strip
    new_token(:tANNOTATION, s)
  when input.scan(/self\?/)
    new_token(:kSELFQ, "self?")
  when input.scan(/(([a-zA-Z]\w*)|(_\w+))=/)
    new_token(:tWRITE_ATTR)
  when input.scan(KEYWORDS_RE)
    new_token(KEYWORDS[input.matched], input.matched.to_sym)
  when input.scan(/:((@{,2}|\$)?\w+(\?|\!)?|\+|\-)\b?/)
    s = input.matched.yield_self {|s| s[1, s.length] }.to_sym
    new_token(:tSYMBOL, s)
  when input.scan(/[+-]?\d[\d_]*/)
    new_token(:tINTEGER, input.matched.to_i)
  when input.scan(PUNCTS_RE)
    new_token(PUNCTS[input.matched])
  when input.scan(/(::)?([A-Z]\w*::)+/)
    new_token(:tNAMESPACE)
  when input.scan(/[a-z_]\w*:/)
    new_token(:tLKEYWORD, input.matched.chop.to_sym)
  when input.scan(/[a-z_]\w*[?!]:/)
    new_token(:tLKEYWORD_Q_E, input.matched.chop.to_sym)
  when input.scan(/[A-Z]\w*:/)
    new_token(:tUKEYWORD, input.matched.chop.to_sym)
  when input.scan(/[A-Z]\w*[?!]:/)
    new_token(:tUKEYWORD_Q_E, input.matched.chop.to_sym)
  when input.scan(/\$[A-Za-z_]\w*/)
    new_token(:tGLOBALIDENT)
  when input.scan(/@[a-zA-Z_]\w*/)
    new_token(:tIVAR, input.matched.to_sym)
  when input.scan(/@@[a-zA-Z_]\w*/)
    new_token(:tCLASSVAR, input.matched.to_sym)
  when input.scan(/_[a-zA-Z]\w*\b/)
    new_token(:tINTERFACEIDENT)
  when input.scan(/[A-Z]\w*\b/)
    new_token(:tUIDENT)
  when input.scan(/[a-z_]\w*\b/)
    new_token(:tLIDENT)
  when input.scan(/"(\\"|[^"])*"/)
    s = input.matched.yield_self {|s| s[1, s.length - 2] }
                     .gsub(DBL_QUOTE_STR_ESCAPE_SEQUENCES_RE) do |match|
                       case match
                       when '\\a' then "\a"
                       when '\\b' then "\b"
                       when '\\e' then "\e"
                       when '\\f' then "\f"
                       when '\\n' then "\n"
                       when '\\r' then "\r"
                       when '\\s' then "\s"
                       when '\\t' then "\t"
                       when '\\v' then "\v"
                       when '\\"' then '"'
                       end
                     end
    new_token(:tSTRING, s)
  when input.scan(/'(\\'|[^'])*'/)
    s = input.matched.yield_self {|s| s[1, s.length - 2] }.gsub(/\\'/, "'")
    new_token(:tSTRING, s)
  else
    raise "Unexpected token: #{input.peek(10)}..."
  end
end

def on_error(token_id, error_value, value_stack)
  raise SyntaxError.new(token_str: token_to_str(token_id), error_value: error_value, value_stack: value_stack)
end

class SyntaxError < StandardError
  attr_reader :token_str, :error_value, :value_stack

  def initialize(token_str:, error_value:, value_stack: nil)
    @token_str = token_str
    @error_value = error_value
    @value_stack = value_stack

    super "parse error on value: #{error_value.inspect} (#{token_str})"
  end
end

class SemanticsError < StandardError
  attr_reader :subject, :location, :original_message

  def initialize(message, subject:, location:)
    @subject = subject
    @location = location
    @original_message = message

    super "parse error on #{location}: #{message}"
  end
end

...end parser.y/module_eval...
##### State transition tables begin ###

clist = [
'349,350,33,351,5,113,37,33,33,42,336,392,49,33,33,348,43,244,334,391',
'40,41,55,56,57,58,59,60,61,62,353,33,63,54,64,65,66,77,67,68,69,83,33',
'32,53,344,338,339,32,32,342,340,343,303,32,32,33,341,82,70,71,72,74',
'76,75,337,346,347,73,78,80,126,32,124,48,84,85,81,86,349,350,33,351',
'32,96,97,98,99,104,49,39,33,33,33,348,205,205,32,125,40,41,55,56,57',
'58,59,60,61,62,79,185,63,54,64,65,66,77,67,68,69,83,53,32,160,344,338',
'339,53,53,342,340,343,32,32,32,125,341,82,70,71,72,74,76,75,337,346',
'347,73,78,80,40,41,161,222,84,85,81,86,349,350,120,351,180,96,97,98',
'99,164,179,101,102,165,103,348,166,278,325,358,223,39,55,56,57,58,59',
'60,61,62,79,395,63,54,64,65,66,77,67,68,69,83,279,125,125,344,338,339',
'396,397,342,340,343,321,40,41,125,341,82,70,71,72,74,76,75,337,346,347',
'73,78,80,167,317,125,125,84,85,81,86,349,350,168,351,170,96,97,98,99',
'2,3,4,40,41,171,348,40,41,40,41,40,41,55,56,57,58,59,60,61,62,79,172',
'63,54,64,65,66,77,67,68,69,83,40,41,113,344,338,339,40,41,342,340,343',
'40,41,40,41,341,82,70,71,72,74,76,75,337,346,347,73,78,80,349,350,178',
'351,84,85,81,86,-4,181,-241,184,33,41,117,348,-241,40,41,40,41,113,55',
'56,57,58,59,60,61,62,79,187,63,54,64,65,66,77,67,68,69,83,40,41,180',
'344,338,339,281,282,342,340,343,32,370,371,188,341,82,70,71,72,74,76',
'75,337,346,347,73,78,80,349,350,-104,351,84,85,81,86,40,41,40,41,-105',
'39,-106,348,386,387,40,41,40,41,55,56,57,58,59,60,61,62,79,-107,63,54',
'64,65,66,77,67,68,69,83,40,41,-108,344,338,339,40,41,342,340,343,40',
'41,40,41,341,82,70,71,72,74,76,75,337,346,347,73,78,80,40,41,-109,-110',
'84,85,81,86,349,350,-111,351,-112,96,97,98,99,-113,-114,48,-129,193',
'194,348,195,196,197,198,206,207,55,56,57,58,59,60,61,62,79,42,63,54',
'64,65,66,77,67,68,69,83,224,238,247,344,338,339,248,250,342,340,343',
'252,253,42,255,341,82,70,71,72,74,76,75,337,346,347,73,78,80,349,350',
'255,351,84,85,81,86,255,261,42,224,265,269,271,348,273,274,310,269,312',
'273,55,56,57,58,59,60,61,62,79,322,63,54,64,65,66,77,67,68,69,83,323',
'324,327,344,338,339,327,327,342,340,343,357,359,366,367,341,82,70,71',
'72,74,76,75,337,346,347,73,78,80,368,369,372,374,84,85,81,86,33,377',
'377,96,97,98,99,377,390,393,22,23,21,394,26,-219,25,401,30,402,131,132',
'133,134,135,136,137,138,142,16,139,130,140,141,66,77,67,68,69,83,403',
'32,405,410,411,28,412,156,413,157,159,410,,,,,82,70,71,72,74,76,75,',
',,73,78,80,,,,,84,85,81,86,33,,,96,97,98,99,,,,22,23,21,,26,,25,,30',
',131,132,133,134,135,136,137,138,142,16,139,130,140,141,66,77,67,68',
'69,83,,32,,,174,28,,177,,175,,,,,,,82,70,71,72,74,76,75,,,,73,78,80',
'176,,,,84,85,81,86,33,,,96,97,98,99,,,,22,23,21,,26,-219,25,,30,,131',
'132,133,134,135,136,137,138,142,16,139,130,140,141,66,77,67,68,69,83',
',32,,,,28,,156,,157,159,,,,,,82,70,71,72,74,76,75,,,,73,78,80,,,,,84',
'85,81,86,33,,,96,97,98,99,,,,22,23,21,,26,-219,25,,30,,131,132,133,134',
'135,136,137,138,142,16,139,130,140,141,66,77,67,68,69,83,,32,,,,28,',
'156,,157,159,,,,,,82,70,71,72,74,76,75,,,,73,78,80,,,,,84,85,81,86,33',
',,96,97,98,99,,,,22,23,21,,26,-219,25,,30,,131,132,133,134,135,136,137',
'138,142,16,139,130,140,141,66,77,67,68,69,83,,32,,,,28,,230,,,159,,',
',,,82,70,71,72,74,76,75,,,,73,78,80,,,,,84,85,81,86,33,,,96,97,98,99',
',,,22,23,21,,26,-219,25,,30,,131,132,133,134,135,136,137,138,142,16',
'139,130,140,141,66,77,67,68,69,83,,32,,,,28,,156,,157,159,,,,,,82,70',
'71,72,74,76,75,,,,73,78,80,,,,,84,85,81,86,33,,,96,97,98,99,,,,22,23',
'21,,26,-219,25,,30,,131,132,133,134,135,136,137,138,142,16,139,130,140',
'141,66,77,67,68,69,83,,32,,,,28,,230,,,159,,,,,,82,70,71,72,74,76,75',
',,,73,78,80,,,,,84,85,81,86,96,97,98,99,,,,90,89,91,,,,,,,,55,56,57',
'58,59,60,61,62,79,,63,54,64,65,66,77,67,68,69,83,,,,,,,,,190,,191,,',
',,,82,70,71,72,74,76,75,,95,94,73,78,80,,,,,84,85,81,86,96,97,98,99',
',,,90,89,91,,,,,,40,41,55,56,57,58,59,60,61,62,79,,63,54,64,65,66,77',
'67,68,69,83,192,,,,,,,,,,,,,,,,82,70,71,72,74,76,75,,95,94,73,78,80',
'96,97,98,99,84,85,81,86,,,,,,,,,,55,56,57,58,59,60,61,62,79,,63,54,64',
'65,66,77,67,68,69,83,190,,191,,,,,230,,,159,,,,,,82,70,71,72,74,76,75',
'190,,191,73,78,80,96,97,98,99,84,85,81,86,,,,,,,,40,41,55,56,57,58,59',
'60,61,62,79,,63,54,64,65,66,77,67,68,69,83,192,40,41,,,,,230,,,159,',
',,,,82,70,71,72,74,76,75,192,,,73,78,80,96,97,98,99,84,85,81,86,,,,',
',,,,,55,56,57,58,59,60,61,62,79,,63,54,64,65,66,77,67,68,69,83,190,',
'191,190,,191,190,,191,,,,,,,,82,70,71,72,74,76,75,,,,73,78,80,,,,,84',
'85,81,86,,,,,,,,40,41,,40,41,,40,41,-241,,33,,117,,-241,,,298,299,113',
',,192,,,192,,,192,,-241,,33,,117,,-241,,300,298,299,113,,,,,,295,294',
',,32,-241,,33,,117,,-241,,300,298,299,113,,,,286,,295,294,,174,32,,177',
',175,,,321,,300,,,,,,,309,,295,294,,33,32,,176,,317,318,314,315,316',
'22,23,21,319,26,,25,313,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27',
',,33,,,,,32,,,,28,22,23,21,,26,,25,45,30,,8,12,19,20,9,10,13,14,15,16',
'17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10',
'13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12',
'19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25',
',30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23',
'21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32',
',,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27',
',,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16',
'17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10',
'13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12',
'19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25',
',30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23',
'21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32',
',,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27',
',,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16',
'17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10',
'13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12',
'19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25',
',30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23',
'21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32',
',,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27',
',,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16',
'17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10',
'13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12',
'19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25',
',30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23',
'21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32',
',,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27',
',,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16',
'17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10',
'13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12',
'19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25',
',30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23',
'21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32',
',,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27',
',,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16',
'17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10',
'13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12',
'19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25',
',30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23',
'21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32',
',,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27',
',,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16',
'17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10',
'13,14,15,16,17,18,11,27,,,,,,,,32,,,,28' ]
        racc_action_table = arr = ::Array.new(3008, nil)
        idx = 0
        clist.each do |str|
          str.split(',', -1).each do |i|
            arr[idx] = i.to_i unless i.empty?
            idx += 1
          end
        end

clist = [
'321,321,48,321,1,275,5,177,215,7,320,377,28,216,217,321,24,216,320,377',
'44,44,321,321,321,321,321,321,321,321,321,244,321,321,321,321,321,321',
'321,321,321,321,265,48,28,321,321,321,177,215,321,321,321,275,216,217',
'271,321,321,321,321,321,321,321,321,321,321,321,321,321,321,47,244,46',
'27,321,321,321,321,328,328,273,328,265,328,328,328,328,32,119,35,317',
'318,319,328,160,206,271,46,47,47,328,328,328,328,328,328,328,328,328',
'123,328,328,328,328,328,328,328,328,328,328,119,273,51,328,328,328,160',
'206,328,328,328,317,318,319,123,328,328,328,328,328,328,328,328,328',
'328,328,328,328,328,6,6,51,183,328,328,328,328,329,329,36,329,116,329',
'329,329,329,87,116,31,31,88,31,329,89,266,302,326,183,6,329,329,329',
'329,329,329,329,329,329,382,329,329,329,329,329,329,329,329,329,329',
'266,302,326,329,329,329,383,384,329,329,329,308,169,169,382,329,329',
'329,329,329,329,329,329,329,329,329,329,329,329,90,308,383,384,329,329',
'329,329,330,330,91,330,93,330,330,330,330,0,0,0,186,186,94,330,209,209',
'210,210,211,211,330,330,330,330,330,330,330,330,330,95,330,330,330,330',
'330,330,330,330,330,330,212,212,113,330,330,330,213,213,330,330,330',
'214,214,219,219,330,330,330,330,330,330,330,330,330,330,330,330,330',
'330,354,354,115,354,330,330,330,330,34,117,34,120,34,121,34,354,34,220',
'220,221,221,34,354,354,354,354,354,354,354,354,354,127,354,354,354,354',
'354,354,354,354,354,354,262,262,128,354,354,354,268,268,354,354,354',
'34,345,345,129,354,354,354,354,354,354,354,354,354,354,354,354,354,354',
'372,372,130,372,354,354,354,354,355,355,356,356,131,34,132,372,369,369',
'375,375,378,378,372,372,372,372,372,372,372,372,372,133,372,372,372',
'372,372,372,372,372,372,372,380,380,134,372,372,372,389,389,372,372',
'372,404,404,406,406,372,372,372,372,372,372,372,372,372,372,372,372',
'372,372,407,407,135,136,372,372,372,372,385,385,137,385,138,385,385',
'385,385,139,140,141,142,145,146,385,148,150,153,154,161,162,385,385',
'385,385,385,385,385,385,385,163,385,385,385,385,385,385,385,385,385',
'385,188,204,218,385,385,385,223,228,385,385,385,239,240,241,242,385',
'385,385,385,385,385,385,385,385,385,385,385,385,385,412,412,243,412',
'385,385,385,385,245,246,249,252,254,255,256,412,257,259,277,279,280',
'284,412,412,412,412,412,412,412,412,412,298,412,412,412,412,412,412',
'412,412,412,412,299,300,314,412,412,412,315,316,412,412,412,324,327',
'331,332,412,412,412,412,412,412,412,412,412,412,412,412,412,412,333',
'335,353,357,412,412,412,412,49,361,363,49,49,49,49,365,376,379,49,49',
'49,381,49,49,49,386,49,387,49,49,49,49,49,49,49,49,49,49,49,49,49,49',
'49,49,49,49,49,49,388,49,392,398,400,49,403,49,409,49,49,413,,,,,49',
'49,49,49,49,49,49,,,,49,49,49,,,,,49,49,49,49,156,,,156,156,156,156',
',,,156,156,156,,156,,156,,156,,156,156,156,156,156,156,156,156,156,156',
'156,156,156,156,156,156,156,156,156,156,,156,,,114,156,,114,,114,,,',
',,,156,156,156,156,156,156,156,,,,156,156,156,114,,,,156,156,156,156',
'194,,,194,194,194,194,,,,194,194,194,,194,194,194,,194,,194,194,194',
'194,194,194,194,194,194,194,194,194,194,194,194,194,194,194,194,194',
',194,,,,194,,194,,194,194,,,,,,194,194,194,194,194,194,194,,,,194,194',
'194,,,,,194,194,194,194,195,,,195,195,195,195,,,,195,195,195,,195,195',
'195,,195,,195,195,195,195,195,195,195,195,195,195,195,195,195,195,195',
'195,195,195,195,195,,195,,,,195,,195,,195,195,,,,,,195,195,195,195,195',
'195,195,,,,195,195,195,,,,,195,195,195,195,196,,,196,196,196,196,,,',
'196,196,196,,196,196,196,,196,,196,196,196,196,196,196,196,196,196,196',
'196,196,196,196,196,196,196,196,196,196,,196,,,,196,,196,,,196,,,,,',
'196,196,196,196,196,196,196,,,,196,196,196,,,,,196,196,196,196,205,',
',205,205,205,205,,,,205,205,205,,205,205,205,,205,,205,205,205,205,205',
'205,205,205,205,205,205,205,205,205,205,205,205,205,205,205,,205,,,',
'205,,205,,205,205,,,,,,205,205,205,205,205,205,205,,,,205,205,205,,',
',,205,205,205,205,250,,,250,250,250,250,,,,250,250,250,,250,250,250',
',250,,250,250,250,250,250,250,250,250,250,250,250,250,250,250,250,250',
'250,250,250,250,,250,,,,250,,250,,,250,,,,,,250,250,250,250,250,250',
'250,,,,250,250,250,,,,,250,250,250,250,30,30,30,30,,,,30,30,30,,,,,',
',,30,30,30,30,30,30,30,30,30,,30,30,30,30,30,30,30,30,30,30,,,,,,,,',
'143,,143,,,,,,30,30,30,30,30,30,30,,30,30,30,30,30,,,,,30,30,30,30,165',
'165,165,165,,,,165,165,165,,,,,,143,143,165,165,165,165,165,165,165',
'165,165,,165,165,165,165,165,165,165,165,165,165,143,,,,,,,,,,,,,,,',
'165,165,165,165,165,165,165,,165,165,165,165,165,197,197,197,197,165',
'165,165,165,,,,,,,,,,197,197,197,197,197,197,197,197,197,,197,197,197',
'197,197,197,197,197,197,197,199,,199,,,,,197,,,197,,,,,,197,197,197',
'197,197,197,197,201,,201,197,197,197,198,198,198,198,197,197,197,197',
',,,,,,,199,199,198,198,198,198,198,198,198,198,198,,198,198,198,198',
'198,198,198,198,198,198,199,201,201,,,,,198,,,198,,,,,,198,198,198,198',
'198,198,198,201,,,198,198,198,230,230,230,230,198,198,198,198,,,,,,',
',,,230,230,230,230,230,230,230,230,230,,230,230,230,230,230,230,230',
'230,230,230,202,,202,203,,203,234,,234,,,,,,,,230,230,230,230,230,230',
'230,,,,230,230,230,,,,,230,230,230,230,,,,,,,,202,202,,203,203,,234',
'234,272,,272,,272,,272,,,272,272,272,,,202,,,203,,,234,,276,,276,,276',
',276,,272,276,276,276,,,,,,272,272,,,272,283,,283,,283,,283,,276,283',
'283,283,,,,272,,276,276,,285,276,,285,,285,,,285,,283,,,,,,,276,,283',
'283,,2,283,,285,,285,285,285,285,285,2,2,2,285,2,,2,283,2,,2,2,2,2,2',
'2,2,2,2,2,2,2,2,2,,,25,,,,,2,,,,2,25,25,25,,25,,25,25,25,,25,25,25,25',
'25,25,25,25,25,25,25,25,25,25,,,26,,,,,25,,,,25,26,26,26,,26,,26,,26',
',26,26,26,26,26,26,26,26,26,26,26,26,26,26,,,40,,,,,26,,,,26,40,40,40',
',40,,40,,40,,40,40,40,40,40,40,40,40,40,40,40,40,40,40,,,41,,,,,40,',
',,40,41,41,41,,41,,41,,41,,41,41,41,41,41,41,41,41,41,41,41,41,41,41',
',,43,,,,,41,,,,41,43,43,43,,43,,43,,43,,43,43,43,43,43,43,43,43,43,43',
'43,43,43,43,,,53,,,,,43,,,,43,53,53,53,,53,,53,,53,,53,53,53,53,53,53',
'53,53,53,53,53,53,53,53,,,92,,,,,53,,,,53,92,92,92,,92,,92,,92,,92,92',
'92,92,92,92,92,92,92,92,92,92,92,92,,,125,,,,,92,,,,92,125,125,125,',
'125,,125,,125,,125,125,125,125,125,125,125,125,125,125,125,125,125,125',
',,157,,,,,125,,,,125,157,157,157,,157,,157,,157,,157,157,157,157,157',
'157,157,157,157,157,157,157,157,157,,,158,,,,,157,,,,157,158,158,158',
',158,,158,,158,,158,158,158,158,158,158,158,158,158,158,158,158,158',
'158,,,159,,,,,158,,,,158,159,159,159,,159,,159,,159,,159,159,159,159',
'159,159,159,159,159,159,159,159,159,159,,,166,,,,,159,,,,159,166,166',
'166,,166,,166,,166,,166,166,166,166,166,166,166,166,166,166,166,166',
'166,166,,,167,,,,,166,,,,166,167,167,167,,167,,167,,167,,167,167,167',
'167,167,167,167,167,167,167,167,167,167,167,,,168,,,,,167,,,,167,168',
'168,168,,168,,168,,168,,168,168,168,168,168,168,168,168,168,168,168',
'168,168,168,,,170,,,,,168,,,,168,170,170,170,,170,,170,,170,,170,170',
'170,170,170,170,170,170,170,170,170,170,170,170,,,171,,,,,170,,,,170',
'171,171,171,,171,,171,,171,,171,171,171,171,171,171,171,171,171,171',
'171,171,171,171,,,172,,,,,171,,,,171,172,172,172,,172,,172,,172,,172',
'172,172,172,172,172,172,172,172,172,172,172,172,172,,,178,,,,,172,,',
',172,178,178,178,,178,,178,,178,,178,178,178,178,178,178,178,178,178',
'178,178,178,178,178,,,179,,,,,178,,,,178,179,179,179,,179,,179,,179',
',179,179,179,179,179,179,179,179,179,179,179,179,179,179,,,181,,,,,179',
',,,179,181,181,181,,181,,181,,181,,181,181,181,181,181,181,181,181,181',
'181,181,181,181,181,,,200,,,,,181,,,,181,200,200,200,,200,,200,,200',
',200,200,200,200,200,200,200,200,200,200,200,200,200,200,,,207,,,,,200',
',,,200,207,207,207,,207,,207,,207,,207,207,207,207,207,207,207,207,207',
'207,207,207,207,207,,,224,,,,,207,,,,207,224,224,224,,224,,224,,224',
',224,224,224,224,224,224,224,224,224,224,224,224,224,224,,,247,,,,,224',
',,,224,247,247,247,,247,,247,,247,,247,247,247,247,247,247,247,247,247',
'247,247,247,247,247,,,274,,,,,247,,,,247,274,274,274,,274,,274,,274',
',274,274,274,274,274,274,274,274,274,274,274,274,274,274,,,310,,,,,274',
',,,274,310,310,310,,310,,310,,310,,310,310,310,310,310,310,310,310,310',
'310,310,310,310,310,,,322,,,,,310,,,,310,322,322,322,,322,,322,,322',
',322,322,322,322,322,322,322,322,322,322,322,322,322,322,,,323,,,,,322',
',,,322,323,323,323,,323,,323,,323,,323,323,323,323,323,323,323,323,323',
'323,323,323,323,323,,,360,,,,,323,,,,323,360,360,360,,360,,360,,360',
',360,360,360,360,360,360,360,360,360,360,360,360,360,360,,,362,,,,,360',
',,,360,362,362,362,,362,,362,,362,,362,362,362,362,362,362,362,362,362',
'362,362,362,362,362,,,364,,,,,362,,,,362,364,364,364,,364,,364,,364',
',364,364,364,364,364,364,364,364,364,364,364,364,364,364,,,366,,,,,364',
',,,364,366,366,366,,366,,366,,366,,366,366,366,366,366,366,366,366,366',
'366,366,366,366,366,,,367,,,,,366,,,,366,367,367,367,,367,,367,,367',
',367,367,367,367,367,367,367,367,367,367,367,367,367,367,,,368,,,,,367',
',,,367,368,368,368,,368,,368,,368,,368,368,368,368,368,368,368,368,368',
'368,368,368,368,368,,,374,,,,,368,,,,368,374,374,374,,374,,374,,374',
',374,374,374,374,374,374,374,374,374,374,374,374,374,374,,,390,,,,,374',
',,,374,390,390,390,,390,,390,,390,,390,390,390,390,390,390,390,390,390',
'390,390,390,390,390,,,393,,,,,390,,,,390,393,393,393,,393,,393,,393',
',393,393,393,393,393,393,393,393,393,393,393,393,393,393,,,394,,,,,393',
',,,393,394,394,394,,394,,394,,394,,394,394,394,394,394,394,394,394,394',
'394,394,394,394,394,,,,,,,,394,,,,394' ]
        racc_action_check = arr = ::Array.new(3008, nil)
        idx = 0
        clist.each do |str|
          str.split(',', -1).each do |i|
            arr[idx] = i.to_i unless i.empty?
            idx += 1
          end
        end

racc_action_pointer = [
   173,     4,  1590,   nil,   nil,     6,   103,   -42,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,    -4,  1626,  1662,    56,    -6,   nil,
  1140,   167,    84,   nil,   316,    14,   140,   nil,   nil,   nil,
  1698,  1734,   nil,  1770,   -27,   nil,    52,    52,    -2,   604,
   nil,   101,   nil,  1806,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   144,   125,   119,
   174,   184,  1842,   197,   207,   224,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   268,   694,   266,   160,   273,   nil,    71,
   317,   273,   nil,    89,   nil,  1878,   nil,   320,   350,   345,
   337,   347,   349,   366,   379,   408,   409,   416,   418,   423,
   424,   451,   426,  1189,   nil,   427,   426,   nil,   428,   nil,
   429,   nil,   nil,   430,   431,   nil,   681,  1914,  1950,  1986,
    77,   456,   429,   438,   nil,  1214,  2022,  2058,  2094,   165,
  2130,  2166,  2202,   nil,   nil,   nil,   nil,     3,  2238,  2274,
   nil,  2310,   nil,   132,   nil,   nil,   202,   nil,   450,   nil,
   nil,   nil,   nil,   nil,   758,   835,   912,  1280,  1346,  1321,
  2346,  1344,  1453,  1456,   478,   989,    78,  2382,   nil,   206,
   208,   210,   232,   238,   243,     4,     9,    10,   446,   245,
   278,   280,   nil,   504,  2418,   nil,   nil,   nil,   461,   nil,
  1412,   nil,   nil,   nil,  1459,   nil,   nil,   nil,   nil,   492,
   489,   462,   494,   511,    27,   517,   533,  2454,   nil,   488,
  1066,   nil,   490,   nil,   482,   463,   499,   499,   nil,   526,
   nil,   nil,   303,   nil,   nil,    38,   154,   nil,   279,   nil,
   nil,    52,  1506,    77,  2490,    -8,  1528,   527,   nil,   469,
   547,   nil,   nil,  1550,   504,  1537,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   516,   527,
   515,   nil,   155,   nil,   nil,   nil,   nil,   nil,   168,   nil,
  2526,   nil,   nil,   nil,   541,   545,   546,    87,    88,    89,
   -62,    -2,  2562,  2598,   571,   nil,   156,   526,    77,   156,
   235,   564,   565,   580,   nil,   562,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   311,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   545,   306,   340,   342,   559,   nil,   nil,
  2634,   591,  2670,   592,  2706,   597,  2742,  2778,  2814,   363,
   nil,   nil,   377,   nil,  2850,   350,   572,     0,   352,   573,
   374,   577,   168,   185,   186,   456,   568,   570,   616,   380,
  2886,   nil,   631,  2922,  2958,   nil,   nil,   nil,   593,   nil,
   608,   nil,   nil,   597,   385,   nil,   387,   403,   nil,   609,
   nil,   nil,   527,   601,   nil,   nil ]

racc_action_default = [
  -245,  -245,  -241,    -6,   -15,  -245,    -4,  -157,  -160,  -161,
  -162,  -163,  -164,  -165,  -166,  -167,  -168,  -169,  -170,  -171,
  -172,  -173,  -174,  -175,  -176,  -241,  -241,  -245,   -80,  -184,
  -245,  -245,  -242,  -244,   -16,    -4,  -147,   416,    -1,    -5,
  -241,  -241,  -183,  -241,  -185,  -178,  -245,  -245,  -241,  -241,
  -182,  -245,  -204,  -241,  -104,  -105,  -106,  -107,  -108,  -109,
  -110,  -111,  -112,  -113,  -114,  -115,  -116,  -117,  -118,  -119,
  -120,  -121,  -122,  -123,  -124,  -125,  -126,  -127,  -128,  -129,
  -130,  -131,  -132,  -133,  -134,  -135,  -136,  -245,  -188,  -245,
  -245,  -245,  -241,  -245,  -245,  -245,  -199,  -200,  -201,  -202,
  -235,  -236,  -237,  -238,  -243,    -2,    -7,    -8,    -9,   -10,
   -11,   -12,   -13,   -16,  -245,  -245,  -245,  -245,    -3,   -80,
  -245,  -158,  -159,  -245,  -179,  -241,  -180,  -245,  -245,  -245,
  -170,  -160,  -164,  -171,  -172,  -161,  -162,  -165,  -166,  -169,
  -163,  -115,  -167,  -231,  -197,  -245,  -208,  -209,  -211,  -212,
  -214,  -215,  -218,  -221,  -223,  -224,  -241,  -241,  -241,  -241,
  -245,  -245,  -245,  -206,  -187,  -245,  -241,  -241,  -241,  -193,
  -241,  -241,  -241,   -17,   -14,   -14,   -14,  -241,  -241,  -241,
  -240,  -241,   -79,  -245,  -149,  -177,  -186,  -181,   -81,  -225,
  -232,  -233,  -234,  -198,  -241,  -241,  -241,  -219,  -219,  -231,
  -241,  -231,  -231,  -231,  -245,  -241,  -245,  -241,  -189,  -190,
  -191,  -192,  -194,  -195,  -196,  -241,  -241,  -241,  -245,  -154,
  -155,  -156,  -148,  -245,  -241,  -207,  -215,  -210,  -217,  -213,
  -245,  -220,  -222,  -226,  -231,  -227,  -228,  -230,   -82,  -245,
  -245,  -203,  -137,  -137,  -241,  -137,  -245,  -241,  -150,  -205,
  -241,  -229,  -245,   -83,   -19,  -145,   -24,   -30,   -26,   -29,
   -57,  -239,  -153,  -216,   -30,  -241,  -245,  -139,  -142,  -146,
   -30,  -241,   -16,  -241,  -241,   -16,   -16,   -20,  -138,  -145,
  -245,  -143,  -144,   -16,   -25,   -71,   -23,   -31,   -32,   -33,
   -34,   -35,   -36,   -37,   -38,   -39,   -40,   -41,  -245,  -245,
  -245,   -27,  -245,   -56,   -58,   -59,   -60,   -61,   -71,   -18,
  -241,  -140,  -141,   -22,   -42,   -42,   -42,  -241,  -241,  -241,
   -68,  -245,  -241,  -241,  -245,   -28,  -245,  -245,  -245,  -245,
  -245,   -62,   -64,   -66,   -69,  -245,   -72,   -86,   -87,   -88,
   -89,   -90,   -91,   -92,   -93,   -94,   -97,   -98,   -99,  -100,
  -101,  -102,  -103,  -129,  -245,   -53,   -54,  -245,   -21,   -43,
  -241,   -50,  -241,   -50,  -241,   -50,  -241,  -241,  -241,   -73,
   -95,   -96,  -245,  -151,  -241,   -44,  -245,  -245,   -46,  -245,
   -48,  -245,  -245,  -245,  -245,  -245,  -245,  -245,  -245,   -55,
  -241,   -51,  -245,  -241,  -241,   -63,   -65,   -67,   -15,   -84,
  -245,   -74,   -75,  -245,   -45,   -52,   -47,   -49,   -70,   -76,
   -77,   -85,  -245,   -15,  -152,   -78 ]

racc_goto_table = [
     6,    93,   116,    46,    92,   114,   127,   163,   218,    87,
   354,   200,    50,   228,   228,   129,   128,   361,   363,   365,
   189,   123,    38,   204,    47,   226,   257,   229,   267,   408,
   376,     1,   379,   272,   381,   215,   216,   217,   121,   122,
   276,   231,   232,   373,   415,    34,   283,   143,    35,   106,
   105,   118,   311,   284,   254,   256,   264,   260,   328,   329,
   330,   388,   270,   301,   305,   306,   307,   245,   228,   240,
   275,   304,   335,   385,   400,   259,   233,   398,   235,   236,
   237,   263,   119,   162,   173,   200,   266,   280,   183,   227,
   169,   100,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   414,   259,   182,   259,   nil,   nil,   nil,   nil,   nil,
   nil,   251,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   186,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,    93,   nil,   nil,    92,
   nil,   nil,   nil,   nil,   208,   nil,   nil,   nil,   331,   332,
   333,   nil,   nil,   nil,   199,   201,   202,   203,   nil,   nil,
   225,   241,   nil,   nil,   209,   210,   211,   nil,   212,   213,
   214,   239,   nil,   242,   243,   nil,   219,   220,   249,   221,
   nil,   nil,   nil,   128,   128,   246,   nil,   nil,   nil,   nil,
   nil,   nil,   143,   143,   143,   nil,   nil,   nil,   234,   nil,
   nil,   nil,   nil,   143,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   277,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   128,   nil,   nil,   nil,   nil,   nil,   nil,
   116,   nil,   nil,   nil,   116,   262,   308,   nil,   143,   nil,
   nil,   116,   302,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   326,   nil,
   nil,   nil,   352,   nil,   nil,   nil,   nil,   nil,   nil,   352,
   352,   352,   360,   362,   364,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   355,   356,   nil,   nil,   nil,   352,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   352,   382,   383,   384,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   352,   nil,   375,   399,
   378,   nil,   380,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   389,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   352,   nil,   nil,   nil,   nil,   404,   nil,
   nil,   406,   407 ]

racc_goto_check = [
     2,    52,    58,    20,    34,    15,    16,    59,    24,    61,
    35,    63,    46,    64,    64,    48,    58,    35,    35,    35,
    74,    20,     3,    50,     2,    69,    22,    69,    54,    44,
    36,     1,    36,    19,    36,    13,    13,    13,     2,     2,
    19,    70,    70,    35,    44,     4,    19,     2,     5,     6,
     3,     3,    54,    22,    17,    17,    18,    17,    33,    33,
    33,    35,    21,    23,    26,    27,    32,    37,    64,    50,
    38,    39,    40,    42,    35,    24,    74,    43,    74,    74,
    74,    69,    45,    49,    15,    63,    53,    56,    57,    65,
     2,    75,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,    35,    24,    46,    24,   nil,   nil,   nil,   nil,   nil,
   nil,    74,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,     2,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,    52,   nil,   nil,    34,
   nil,   nil,   nil,   nil,    61,   nil,   nil,   nil,    24,    24,
    24,   nil,   nil,   nil,     2,     2,     2,     2,   nil,   nil,
    48,    59,   nil,   nil,     2,     2,     2,   nil,     2,     2,
     2,    48,   nil,    16,    16,   nil,     2,     2,    59,     2,
   nil,   nil,   nil,    58,    58,    58,   nil,   nil,   nil,   nil,
   nil,   nil,     2,     2,     2,   nil,   nil,   nil,     2,   nil,
   nil,   nil,   nil,     2,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,    16,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,    58,   nil,   nil,   nil,   nil,   nil,   nil,
    58,   nil,   nil,   nil,    58,     2,    15,   nil,     2,   nil,
   nil,    58,    20,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,    20,   nil,
   nil,   nil,    52,   nil,   nil,   nil,   nil,   nil,   nil,    52,
    52,    52,    34,    34,    34,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
     2,     2,   nil,   nil,   nil,    52,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,    52,    20,    20,    20,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,    52,   nil,     2,    34,
     2,   nil,     2,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,     2,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,    52,   nil,   nil,   nil,   nil,     2,   nil,
   nil,     2,     2 ]

racc_goto_pointer = [
   nil,    31,    -2,    16,    42,    44,    15,   nil,   nil,   nil,
   nil,   nil,   nil,  -139,   nil,   -29,   -42,  -188,  -198,  -224,
   -22,  -194,  -218,  -210,  -169,   nil,  -211,  -210,   nil,   nil,
   nil,   nil,  -209,  -256,   -26,  -311,  -331,  -150,  -190,  -204,
  -248,   nil,  -296,  -308,  -369,    46,   -16,   nil,   -34,    32,
  -137,   nil,   -29,  -169,  -227,   nil,  -181,   -32,   -32,   -46,
   nil,   -21,   nil,  -145,  -182,  -106,   nil,   nil,   nil,  -169,
  -156,   nil,   nil,   nil,  -123,    60 ]

racc_goto_default = [
   nil,   nil,    44,   nil,   nil,   409,   297,   107,   108,   109,
   110,   111,   112,   nil,    36,   285,   115,   nil,   nil,   nil,
   nil,   nil,   nil,   258,    24,   287,   288,   289,   290,   291,
   292,   293,   296,   nil,   144,   nil,   nil,   nil,   nil,   nil,
   nil,   320,   nil,   nil,   nil,   nil,   nil,    51,   nil,   nil,
    52,   345,   145,   nil,   nil,   268,   nil,   nil,    31,     7,
    29,   nil,    88,   158,   146,   147,   148,   149,   150,   151,
   152,   153,   154,   155,   nil,   nil ]

racc_reduce_table = [
  0, 0, :racc_error,
  3, 82, :_reduce_1,
  3, 82, :_reduce_2,
  3, 82, :_reduce_3,
  0, 84, :_reduce_none,
  1, 84, :_reduce_none,
  0, 85, :_reduce_6,
  2, 85, :_reduce_7,
  1, 87, :_reduce_none,
  1, 87, :_reduce_none,
  1, 87, :_reduce_none,
  1, 87, :_reduce_none,
  1, 87, :_reduce_none,
  1, 87, :_reduce_none,
  0, 94, :_reduce_14,
  0, 95, :_reduce_15,
  0, 96, :_reduce_16,
  2, 96, :_reduce_17,
  8, 93, :_reduce_18,
  0, 99, :_reduce_19,
  2, 99, :_reduce_20,
  5, 99, :_reduce_21,
  8, 92, :_reduce_22,
  7, 92, :_reduce_23,
  0, 102, :_reduce_24,
  2, 102, :_reduce_25,
  1, 103, :_reduce_26,
  3, 103, :_reduce_27,
  4, 104, :_reduce_28,
  1, 104, :_reduce_29,
  0, 100, :_reduce_30,
  2, 100, :_reduce_31,
  1, 106, :_reduce_none,
  1, 106, :_reduce_none,
  1, 106, :_reduce_none,
  1, 106, :_reduce_none,
  1, 106, :_reduce_none,
  1, 106, :_reduce_none,
  1, 106, :_reduce_38,
  1, 106, :_reduce_39,
  1, 106, :_reduce_none,
  1, 106, :_reduce_none,
  0, 114, :_reduce_42,
  2, 114, :_reduce_43,
  5, 112, :_reduce_44,
  7, 112, :_reduce_45,
  5, 112, :_reduce_46,
  7, 112, :_reduce_47,
  5, 112, :_reduce_48,
  7, 112, :_reduce_49,
  0, 117, :_reduce_50,
  2, 117, :_reduce_51,
  3, 117, :_reduce_52,
  3, 111, :_reduce_53,
  3, 111, :_reduce_54,
  5, 111, :_reduce_55,
  7, 91, :_reduce_56,
  0, 119, :_reduce_57,
  2, 119, :_reduce_58,
  1, 120, :_reduce_59,
  1, 120, :_reduce_60,
  1, 120, :_reduce_none,
  3, 108, :_reduce_62,
  6, 108, :_reduce_63,
  3, 109, :_reduce_64,
  6, 109, :_reduce_65,
  3, 110, :_reduce_66,
  6, 110, :_reduce_67,
  0, 121, :_reduce_68,
  1, 121, :_reduce_69,
  7, 107, :_reduce_70,
  0, 122, :_reduce_none,
  2, 122, :_reduce_72,
  0, 123, :_reduce_73,
  2, 123, :_reduce_74,
  2, 123, :_reduce_75,
  1, 125, :_reduce_76,
  1, 125, :_reduce_77,
  3, 125, :_reduce_78,
  3, 86, :_reduce_79,
  0, 128, :_reduce_80,
  3, 128, :_reduce_81,
  3, 130, :_reduce_82,
  4, 130, :_reduce_83,
  1, 124, :_reduce_none,
  2, 124, :_reduce_85,
  1, 116, :_reduce_none,
  1, 116, :_reduce_none,
  1, 116, :_reduce_none,
  1, 116, :_reduce_none,
  1, 116, :_reduce_none,
  1, 116, :_reduce_none,
  1, 116, :_reduce_none,
  1, 116, :_reduce_none,
  1, 116, :_reduce_none,
  2, 116, :_reduce_95,
  2, 116, :_reduce_96,
  1, 116, :_reduce_none,
  1, 116, :_reduce_none,
  1, 116, :_reduce_none,
  1, 132, :_reduce_none,
  1, 132, :_reduce_none,
  1, 132, :_reduce_none,
  1, 132, :_reduce_none,
  1, 133, :_reduce_none,
  1, 133, :_reduce_none,
  1, 133, :_reduce_none,
  1, 133, :_reduce_none,
  1, 133, :_reduce_none,
  1, 133, :_reduce_none,
  1, 133, :_reduce_none,
  1, 133, :_reduce_none,
  1, 133, :_reduce_none,
  1, 133, :_reduce_none,
  1, 133, :_reduce_none,
  1, 133, :_reduce_none,
  1, 133, :_reduce_none,
  1, 133, :_reduce_none,
  1, 133, :_reduce_none,
  1, 133, :_reduce_none,
  1, 133, :_reduce_none,
  1, 133, :_reduce_none,
  1, 133, :_reduce_none,
  1, 133, :_reduce_none,
  1, 133, :_reduce_none,
  1, 133, :_reduce_none,
  1, 133, :_reduce_none,
  1, 133, :_reduce_none,
  1, 133, :_reduce_none,
  1, 133, :_reduce_none,
  1, 133, :_reduce_none,
  1, 133, :_reduce_none,
  1, 133, :_reduce_none,
  1, 133, :_reduce_none,
  1, 133, :_reduce_none,
  1, 133, :_reduce_none,
  1, 133, :_reduce_none,
  0, 98, :_reduce_137,
  3, 98, :_reduce_138,
  1, 134, :_reduce_139,
  3, 134, :_reduce_140,
  3, 135, :_reduce_141,
  0, 137, :_reduce_142,
  1, 137, :_reduce_143,
  1, 137, :_reduce_144,
  0, 136, :_reduce_145,
  1, 136, :_reduce_146,
  0, 126, :_reduce_147,
  3, 126, :_reduce_148,
  1, 138, :_reduce_149,
  3, 138, :_reduce_150,
  4, 113, :_reduce_151,
  8, 113, :_reduce_152,
  5, 88, :_reduce_153,
  3, 89, :_reduce_154,
  3, 89, :_reduce_155,
  3, 90, :_reduce_156,
  1, 83, :_reduce_none,
  3, 83, :_reduce_158,
  3, 83, :_reduce_159,
  1, 140, :_reduce_160,
  1, 140, :_reduce_161,
  1, 140, :_reduce_162,
  1, 140, :_reduce_163,
  1, 140, :_reduce_164,
  1, 140, :_reduce_165,
  1, 140, :_reduce_166,
  1, 140, :_reduce_167,
  1, 140, :_reduce_168,
  1, 140, :_reduce_169,
  1, 140, :_reduce_170,
  1, 140, :_reduce_171,
  1, 140, :_reduce_172,
  1, 140, :_reduce_173,
  1, 140, :_reduce_174,
  1, 140, :_reduce_175,
  1, 140, :_reduce_176,
  4, 140, :_reduce_177,
  2, 140, :_reduce_178,
  3, 140, :_reduce_179,
  3, 140, :_reduce_180,
  4, 140, :_reduce_181,
  2, 140, :_reduce_182,
  2, 140, :_reduce_183,
  1, 140, :_reduce_none,
  1, 101, :_reduce_185,
  3, 101, :_reduce_186,
  3, 141, :_reduce_187,
  1, 142, :_reduce_188,
  3, 142, :_reduce_189,
  3, 143, :_reduce_190,
  3, 143, :_reduce_191,
  3, 143, :_reduce_192,
  2, 143, :_reduce_193,
  3, 143, :_reduce_194,
  3, 143, :_reduce_195,
  3, 143, :_reduce_196,
  1, 144, :_reduce_none,
  2, 144, :_reduce_198,
  1, 115, :_reduce_none,
  1, 115, :_reduce_none,
  1, 115, :_reduce_none,
  1, 115, :_reduce_none,
  4, 127, :_reduce_203,
  1, 127, :_reduce_204,
  5, 131, :_reduce_205,
  2, 131, :_reduce_206,
  3, 129, :_reduce_207,
  1, 129, :_reduce_208,
  1, 129, :_reduce_none,
  3, 146, :_reduce_210,
  1, 146, :_reduce_211,
  1, 146, :_reduce_none,
  3, 148, :_reduce_213,
  1, 148, :_reduce_214,
  1, 148, :_reduce_none,
  3, 150, :_reduce_216,
  1, 150, :_reduce_217,
  1, 150, :_reduce_none,
  0, 151, :_reduce_219,
  3, 151, :_reduce_220,
  1, 151, :_reduce_221,
  3, 151, :_reduce_222,
  1, 151, :_reduce_223,
  1, 151, :_reduce_224,
  2, 145, :_reduce_225,
  3, 147, :_reduce_226,
  3, 149, :_reduce_227,
  3, 152, :_reduce_228,
  4, 153, :_reduce_229,
  3, 154, :_reduce_230,
  0, 155, :_reduce_none,
  1, 155, :_reduce_none,
  1, 155, :_reduce_none,
  1, 155, :_reduce_none,
  2, 105, :_reduce_235,
  1, 156, :_reduce_none,
  1, 156, :_reduce_none,
  1, 156, :_reduce_none,
  2, 118, :_reduce_239,
  2, 97, :_reduce_240,
  0, 139, :_reduce_241,
  1, 139, :_reduce_242,
  2, 139, :_reduce_243,
  1, 139, :_reduce_244 ]

racc_reduce_n = 245

racc_shift_n = 416

racc_token_table = {
  false => 0,
  :error => 1,
  :tUIDENT => 2,
  :tLIDENT => 3,
  :tNAMESPACE => 4,
  :tINTERFACEIDENT => 5,
  :tGLOBALIDENT => 6,
  :tLKEYWORD => 7,
  :tUKEYWORD => 8,
  :tLKEYWORD_Q_E => 9,
  :tUKEYWORD_Q_E => 10,
  :tIVAR => 11,
  :tCLASSVAR => 12,
  :tANNOTATION => 13,
  :tSTRING => 14,
  :tSYMBOL => 15,
  :tINTEGER => 16,
  :tWRITE_ATTR => 17,
  :kLPAREN => 18,
  :kRPAREN => 19,
  :kLBRACKET => 20,
  :kRBRACKET => 21,
  :kLBRACE => 22,
  :kRBRACE => 23,
  :kVOID => 24,
  :kNIL => 25,
  :kTRUE => 26,
  :kFALSE => 27,
  :kANY => 28,
  :kUNTYPED => 29,
  :kTOP => 30,
  :kBOT => 31,
  :kSELF => 32,
  :kSELFQ => 33,
  :kINSTANCE => 34,
  :kCLASS => 35,
  :kBOOL => 36,
  :kSINGLETON => 37,
  :kTYPE => 38,
  :kDEF => 39,
  :kMODULE => 40,
  :kPRIVATE => 41,
  :kPUBLIC => 42,
  :kALIAS => 43,
  :kCOLON => 44,
  :kCOLON2 => 45,
  :kCOMMA => 46,
  :kBAR => 47,
  :kAMP => 48,
  :kHAT => 49,
  :kARROW => 50,
  :kQUESTION => 51,
  :kEXCLAMATION => 52,
  :kSTAR => 53,
  :kSTAR2 => 54,
  :kFATARROW => 55,
  :kEQ => 56,
  :kDOT => 57,
  :kDOT3 => 58,
  :kLT => 59,
  :kINTERFACE => 60,
  :kEND => 61,
  :kINCLUDE => 62,
  :kEXTEND => 63,
  :kATTRREADER => 64,
  :kATTRWRITER => 65,
  :kATTRACCESSOR => 66,
  :tOPERATOR => 67,
  :tQUOTEDMETHOD => 68,
  :tQUOTEDIDENT => 69,
  :kPREPEND => 70,
  :kEXTENSION => 71,
  :kINCOMPATIBLE => 72,
  :type_TYPE => 73,
  :type_SIGNATURE => 74,
  :type_METHODTYPE => 75,
  :tEOF => 76,
  :kOUT => 77,
  :kIN => 78,
  :kUNCHECKED => 79,
  :kOVERLOAD => 80 }

racc_nt_base = 81

racc_use_result_var = true

Racc_arg = [
  racc_action_table,
  racc_action_check,
  racc_action_default,
  racc_action_pointer,
  racc_goto_table,
  racc_goto_check,
  racc_goto_default,
  racc_goto_pointer,
  racc_nt_base,
  racc_reduce_table,
  racc_token_table,
  racc_shift_n,
  racc_reduce_n,
  racc_use_result_var ]

Racc_token_to_s_table = [
  "$end",
  "error",
  "tUIDENT",
  "tLIDENT",
  "tNAMESPACE",
  "tINTERFACEIDENT",
  "tGLOBALIDENT",
  "tLKEYWORD",
  "tUKEYWORD",
  "tLKEYWORD_Q_E",
  "tUKEYWORD_Q_E",
  "tIVAR",
  "tCLASSVAR",
  "tANNOTATION",
  "tSTRING",
  "tSYMBOL",
  "tINTEGER",
  "tWRITE_ATTR",
  "kLPAREN",
  "kRPAREN",
  "kLBRACKET",
  "kRBRACKET",
  "kLBRACE",
  "kRBRACE",
  "kVOID",
  "kNIL",
  "kTRUE",
  "kFALSE",
  "kANY",
  "kUNTYPED",
  "kTOP",
  "kBOT",
  "kSELF",
  "kSELFQ",
  "kINSTANCE",
  "kCLASS",
  "kBOOL",
  "kSINGLETON",
  "kTYPE",
  "kDEF",
  "kMODULE",
  "kPRIVATE",
  "kPUBLIC",
  "kALIAS",
  "kCOLON",
  "kCOLON2",
  "kCOMMA",
  "kBAR",
  "kAMP",
  "kHAT",
  "kARROW",
  "kQUESTION",
  "kEXCLAMATION",
  "kSTAR",
  "kSTAR2",
  "kFATARROW",
  "kEQ",
  "kDOT",
  "kDOT3",
  "kLT",
  "kINTERFACE",
  "kEND",
  "kINCLUDE",
  "kEXTEND",
  "kATTRREADER",
  "kATTRWRITER",
  "kATTRACCESSOR",
  "tOPERATOR",
  "tQUOTEDMETHOD",
  "tQUOTEDIDENT",
  "kPREPEND",
  "kEXTENSION",
  "kINCOMPATIBLE",
  "type_TYPE",
  "type_SIGNATURE",
  "type_METHODTYPE",
  "tEOF",
  "kOUT",
  "kIN",
  "kUNCHECKED",
  "kOVERLOAD",
  "$start",
  "target",
  "type",
  "eof",
  "signatures",
  "method_type",
  "signature",
  "type_decl",
  "const_decl",
  "global_decl",
  "interface_decl",
  "module_decl",
  "class_decl",
  "start_new_scope",
  "start_merged_scope",
  "annotations",
  "class_name",
  "module_type_params",
  "super_class",
  "class_members",
  "type_list",
  "colon_module_self_types",
  "module_self_types",
  "module_self_type",
  "qualified_name",
  "class_member",
  "method_member",
  "include_member",
  "extend_member",
  "prepend_member",
  "var_type_member",
  "attribute_member",
  "alias_member",
  "attribute_kind",
  "keyword",
  "method_name",
  "attr_var_opt",
  "interface_name",
  "interface_members",
  "interface_member",
  "overload",
  "attributes",
  "method_kind",
  "def_name",
  "method_types",
  "type_params",
  "proc_type",
  "params_opt",
  "params",
  "block",
  "simple_function_type",
  "method_name0",
  "identifier_keywords",
  "module_type_params0",
  "module_type_param",
  "type_param_check",
  "type_param_variance",
  "type_params0",
  "namespace",
  "simple_type",
  "record_type",
  "record_fields",
  "record_field",
  "keyword_name",
  "required_positional",
  "optional_positional_params",
  "optional_positional",
  "rest_positional_param",
  "rest_positional",
  "trailing_positional_params",
  "keyword_params",
  "required_keyword",
  "optional_keyword",
  "rest_keyword",
  "var_name_opt",
  "simple_name" ]

Racc_debug_parser = false

##### State transition tables end #####

# reduce 0 omitted

module_eval(<<'.,.,', 'parser.y', 28)
  def _reduce_1(val, _values, result)
            result = val[1]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 31)
  def _reduce_2(val, _values, result)
            result = val[1]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 34)
  def _reduce_3(val, _values, result)
            result = val[1]

    result
  end
.,.,

# reduce 4 omitted

# reduce 5 omitted

module_eval(<<'.,.,', 'parser.y', 40)
  def _reduce_6(val, _values, result)
     result = []
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 42)
  def _reduce_7(val, _values, result)
            result = val[0].push(val[1])

    result
  end
.,.,

# reduce 8 omitted

# reduce 9 omitted

# reduce 10 omitted

# reduce 11 omitted

# reduce 12 omitted

# reduce 13 omitted

module_eval(<<'.,.,', 'parser.y', 53)
  def _reduce_14(val, _values, result)
     start_new_variables_scope
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 54)
  def _reduce_15(val, _values, result)
     start_merged_variables_scope
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 57)
  def _reduce_16(val, _values, result)
     result = []
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 59)
  def _reduce_17(val, _values, result)
            result = val[1].unshift(Annotation.new(string: val[0].value, location: val[0].location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 64)
  def _reduce_18(val, _values, result)
            reset_variable_scope

        location = val[1].location + val[7].location
        result = Declarations::Class.new(
          name: val[3].value,
          type_params: val[4]&.value || Declarations::ModuleTypeParams.empty,
          super_class: val[5],
          members: val[6],
          annotations: val[0],
          location: location,
          comment: leading_comment(val[0].first&.location || location)
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 79)
  def _reduce_19(val, _values, result)
     result = nil
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 81)
  def _reduce_20(val, _values, result)
            result = Declarations::Class::Super.new(name: val[1].value,
                                                args: [],
                                                location: val[1].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 86)
  def _reduce_21(val, _values, result)
            result = Declarations::Class::Super.new(name: val[1].value,
                                                args: val[3],
                                                location: val[1].location + val[4].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 93)
  def _reduce_22(val, _values, result)
            reset_variable_scope

        location = val[1].location + val[7].location
        result = Declarations::Module.new(
          name: val[3].value,
          type_params: val[4]&.value || Declarations::ModuleTypeParams.empty,
          self_types: val[5],
          members: val[6],
          annotations: val[0],
          location: location,
          comment: leading_comment(val[0].first&.location || location)
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 107)
  def _reduce_23(val, _values, result)
            reset_variable_scope

        location = val[1].location + val[6].location
        result = Declarations::Module.new(
          name: val[3].value,
          type_params: Declarations::ModuleTypeParams.empty,
          self_types: val[4],
          members: val[5],
          annotations: val[0],
          location: location,
          comment: leading_comment(val[0].first&.location || location)
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 122)
  def _reduce_24(val, _values, result)
     result = []
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 124)
  def _reduce_25(val, _values, result)
            result = val[1]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 129)
  def _reduce_26(val, _values, result)
            result = [val[0]]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 132)
  def _reduce_27(val, _values, result)
            result = val[0].push(val[2])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 137)
  def _reduce_28(val, _values, result)
            name = val[0].value
        args = val[2]
        location = val[0].location + val[3].location

        case
        when name.class?
          result = Declarations::Module::Self.new(name: name, args: args, location: location)
        when name.interface?
          result = Declarations::Module::Self.new(name: name, args: args, location: location)
        else
          raise SemanticsError.new("Module self type should be instance or interface", subject: val[0], location: val[0].location)
        end

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 151)
  def _reduce_29(val, _values, result)
            name = val[0].value
        args = []
        location = val[0].location

        case
        when name.class?
          result = Declarations::Module::Self.new(name: name, args: args, location: location)
        when name.interface?
          result = Declarations::Module::Self.new(name: name, args: args, location: location)
        else
          raise SemanticsError.new("Module self type should be instance or interface", subject: val[0], location: val[0].location)
        end

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 166)
  def _reduce_30(val, _values, result)
     result = []
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 168)
  def _reduce_31(val, _values, result)
            result = val[0].push(val[1])

    result
  end
.,.,

# reduce 32 omitted

# reduce 33 omitted

# reduce 34 omitted

# reduce 35 omitted

# reduce 36 omitted

# reduce 37 omitted

module_eval(<<'.,.,', 'parser.y', 179)
  def _reduce_38(val, _values, result)
            result = Members::Public.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 182)
  def _reduce_39(val, _values, result)
            result = Members::Private.new(location: val[0].location)

    result
  end
.,.,

# reduce 40 omitted

# reduce 41 omitted

module_eval(<<'.,.,', 'parser.y', 188)
  def _reduce_42(val, _values, result)
     result = :instance
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 189)
  def _reduce_43(val, _values, result)
     result = :singleton
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 193)
  def _reduce_44(val, _values, result)
            location = val[1].location + val[4].location
        result = Members::AttrReader.new(name: val[3].value,
                                         ivar_name: nil,
                                         type: val[4],
                                         kind: val[2],
                                         annotations: val[0],
                                         location: location,
                                         comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 203)
  def _reduce_45(val, _values, result)
            location = val[1].location + val[6].location
        result = Members::AttrReader.new(name: val[3].value.to_sym,
                                         ivar_name: val[4],
                                         type: val[6],
                                         kind: val[2],
                                         annotations: val[0],
                                         location: location,
                                         comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 213)
  def _reduce_46(val, _values, result)
            location = val[1].location + val[4].location
        result = Members::AttrWriter.new(name: val[3].value,
                                         ivar_name: nil,
                                         kind: val[2],
                                         type: val[4],
                                         annotations: val[0],
                                         location: location,
                                         comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 223)
  def _reduce_47(val, _values, result)
            location = val[1].location + val[6].location
        result = Members::AttrWriter.new(name: val[3].value.to_sym,
                                         ivar_name: val[4],
                                         kind: val[2],
                                         type: val[6],
                                         annotations: val[0],
                                         location: location,
                                         comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 233)
  def _reduce_48(val, _values, result)
            location = val[1].location + val[4].location
        result = Members::AttrAccessor.new(name: val[3].value,
                                           ivar_name: nil,
                                           kind: val[2],
                                           type: val[4],
                                           annotations: val[0],
                                           location: location,
                                           comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 243)
  def _reduce_49(val, _values, result)
            location = val[1].location + val[6].location
        result = Members::AttrAccessor.new(name: val[3].value.to_sym,
                                           ivar_name: val[4],
                                           kind: val[2],
                                           type: val[6],
                                           annotations: val[0],
                                           location: location,
                                           comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 254)
  def _reduce_50(val, _values, result)
     result = nil
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 255)
  def _reduce_51(val, _values, result)
     result = false
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 256)
  def _reduce_52(val, _values, result)
     result = val[1].value
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 260)
  def _reduce_53(val, _values, result)
            location = val[0].location + val[2].location
        result = Members::InstanceVariable.new(
          name: val[0].value,
          type: val[2],
          location: location,
          comment: leading_comment(location)
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 269)
  def _reduce_54(val, _values, result)
            type = val[2]

        if type.is_a?(Types::Variable)
          type = Types::ClassInstance.new(
            name: TypeName.new(name: type.name, namespace: Namespace.empty),
            args: [],
            location: type.location
          )
        end

        location = val[0].location + val[2].location
        result = Members::ClassVariable.new(
          name: val[0].value,
          type: type,
          location: location,
          comment: leading_comment(location)
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 288)
  def _reduce_55(val, _values, result)
          type = val[4]

      if type.is_a?(Types::Variable)
        type = Types::ClassInstance.new(
          name: TypeName.new(name: type.name, namespace: Namespace.empty),
          args: [],
          location: type.location
        )
      end

      location = val[0].location + val[4].location
      result = Members::ClassInstanceVariable.new(
        name: val[2].value,
        type: type,
        location: location,
        comment: leading_comment(location)
      )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 309)
  def _reduce_56(val, _values, result)
            reset_variable_scope

        location = val[1].location + val[6].location
        result = Declarations::Interface.new(
          name: val[3].value,
          type_params: val[4]&.value || Declarations::ModuleTypeParams.empty,
          members: val[5],
          annotations: val[0],
          location: location,
          comment: leading_comment(val[0].first&.location || location)
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 323)
  def _reduce_57(val, _values, result)
     result = []
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 325)
  def _reduce_58(val, _values, result)
            result = val[0].push(val[1])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 330)
  def _reduce_59(val, _values, result)
            unless val[0].kind == :instance
          raise SemanticsError.new("Interface cannot have singleton method", subject: val[0], location: val[0].location)
        end

        if val[0].types.last == :super
          raise SemanticsError.new("Interface method cannot have `super` type", subject: val[0], location: val[0].location)
        end

        result = val[0]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 341)
  def _reduce_60(val, _values, result)
            unless val[0].name.interface?
          raise SemanticsError.new("Interface should include an interface", subject: val[0], location: val[0].location)
        end

        result = val[0]

    result
  end
.,.,

# reduce 61 omitted

module_eval(<<'.,.,', 'parser.y', 351)
  def _reduce_62(val, _values, result)
            if val[2].value.alias?
          raise SemanticsError.new("Should include module or interface", subject: val[2].value, location: val[2].location)
        end
        location = val[1].location + val[2].location
        result = Members::Include.new(name: val[2].value,
                                      args: [],
                                      annotations: val[0],
                                      location: location,
                                      comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 362)
  def _reduce_63(val, _values, result)
            if val[2].value.alias?
          raise SemanticsError.new("Should include module or interface", subject: val[2].value, location: val[2].location)
        end
        location = val[1].location + val[5].location
        result = Members::Include.new(name: val[2].value,
                                      args: val[4],
                                      annotations: val[0],
                                      location: location,
                                      comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 375)
  def _reduce_64(val, _values, result)
            if val[2].value.alias?
          raise SemanticsError.new("Should extend module or interface", subject: val[2].value, location: val[2].location)
        end
        location = val[1].location + val[2].location
        result = Members::Extend.new(name: val[2].value,
                                     args: [],
                                     annotations: val[0],
                                     location: location,
                                     comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 386)
  def _reduce_65(val, _values, result)
            if val[2].value.alias?
          raise SemanticsError.new("Should extend module or interface", subject: val[2].value, location: val[2].location)
        end
        location = val[1].location + val[5].location
        result = Members::Extend.new(name: val[2].value,
                                     args: val[4],
                                     annotations: val[0],
                                     location: location,
                                     comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 399)
  def _reduce_66(val, _values, result)
            unless val[2].value.class?
          raise SemanticsError.new("Should prepend module", subject: val[2].value, location: val[2].location)
        end
        location = val[1].location + val[2].location
        result = Members::Prepend.new(name: val[2].value,
                                      args: [],
                                      annotations: val[0],
                                      location: location,
                                      comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 410)
  def _reduce_67(val, _values, result)
            unless val[2].value.class?
          raise SemanticsError.new("Should prepend module", subject: val[2].value, location: val[2].location)
        end
        location = val[1].location + val[5].location
        result = Members::Prepend.new(name: val[2].value,
                                      args: val[4],
                                      annotations: val[0],
                                      location: location,
                                      comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 422)
  def _reduce_68(val, _values, result)
     result = nil
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 424)
  def _reduce_69(val, _values, result)
            RBS.logger.warn "`overload def` syntax is deprecated. Use `...` syntax instead."
        result = val[0]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 430)
  def _reduce_70(val, _values, result)
            location = val[3].location + val[6].last.location

        last_type = val[6].last
        if last_type.is_a?(LocatedValue) && last_type.value == :dot3
          overload = true
          val[6].pop
        else
          overload = false
        end

        result = Members::MethodDefinition.new(
          name: val[5].value,
          kind: val[4],
          types: val[6],
          annotations: val[0],
          location: location,
          comment: leading_comment(val[0].first&.location || val[2]&.location || val[3].location),
          overload: overload || !!val[2]
        )

    result
  end
.,.,

# reduce 71 omitted

module_eval(<<'.,.,', 'parser.y', 453)
  def _reduce_72(val, _values, result)
            RBS.logger.warn "`incompatible` method attribute is deprecated and ignored."

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 457)
  def _reduce_73(val, _values, result)
     result = :instance
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 458)
  def _reduce_74(val, _values, result)
     result = :singleton
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 459)
  def _reduce_75(val, _values, result)
     result = :singleton_instance
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 462)
  def _reduce_76(val, _values, result)
     result = [val[0]]
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 463)
  def _reduce_77(val, _values, result)
     result = [LocatedValue.new(value: :dot3, location: val[0].location)]
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 465)
  def _reduce_78(val, _values, result)
            result = val[2].unshift(val[0])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 470)
  def _reduce_79(val, _values, result)
            reset_variable_scope

        location = (val[1] || val[2]).location + val[2].location
        type_params = val[1]&.value || []

        type, block = val[2].value

        result = MethodType.new(type_params: type_params,
                                type: type,
                                block: block,
                                location: location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 484)
  def _reduce_80(val, _values, result)
     result = nil
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 486)
  def _reduce_81(val, _values, result)
            result = LocatedValue.new(value: val[1], location: val[0].location + val[2].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 491)
  def _reduce_82(val, _values, result)
            block = Types::Block.new(type: val[1].value, required: true)
        result = LocatedValue.new(value: block, location: val[0].location + val[2].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 495)
  def _reduce_83(val, _values, result)
            block = Types::Block.new(type: val[2].value, required: false)
        result = LocatedValue.new(value: block, location: val[0].location + val[3].location)

    result
  end
.,.,

# reduce 84 omitted

module_eval(<<'.,.,', 'parser.y', 502)
  def _reduce_85(val, _values, result)
            result = LocatedValue.new(value: val[0].value.to_sym,
                                  location: val[0].location + val[1].location)

    result
  end
.,.,

# reduce 86 omitted

# reduce 87 omitted

# reduce 88 omitted

# reduce 89 omitted

# reduce 90 omitted

# reduce 91 omitted

# reduce 92 omitted

# reduce 93 omitted

# reduce 94 omitted

module_eval(<<'.,.,', 'parser.y', 511)
  def _reduce_95(val, _values, result)
            unless val[0].location.pred?(val[1].location)
          raise SyntaxError.new(token_str: "kQUESTION", error_value: val[1])
        end

        result = LocatedValue.new(value: "#{val[0].value}?",
                                  location: val[0].location + val[1].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 519)
  def _reduce_96(val, _values, result)
            unless val[0].location.pred?(val[1].location)
          raise SyntaxError.new(token_str: "kEXCLAMATION", error_value: val[1])
        end

        result = LocatedValue.new(value: "#{val[0].value}!",
                                  location: val[0].location + val[1].location)

    result
  end
.,.,

# reduce 97 omitted

# reduce 98 omitted

# reduce 99 omitted

# reduce 100 omitted

# reduce 101 omitted

# reduce 102 omitted

# reduce 103 omitted

# reduce 104 omitted

# reduce 105 omitted

# reduce 106 omitted

# reduce 107 omitted

# reduce 108 omitted

# reduce 109 omitted

# reduce 110 omitted

# reduce 111 omitted

# reduce 112 omitted

# reduce 113 omitted

# reduce 114 omitted

# reduce 115 omitted

# reduce 116 omitted

# reduce 117 omitted

# reduce 118 omitted

# reduce 119 omitted

# reduce 120 omitted

# reduce 121 omitted

# reduce 122 omitted

# reduce 123 omitted

# reduce 124 omitted

# reduce 125 omitted

# reduce 126 omitted

# reduce 127 omitted

# reduce 128 omitted

# reduce 129 omitted

# reduce 130 omitted

# reduce 131 omitted

# reduce 132 omitted

# reduce 133 omitted

# reduce 134 omitted

# reduce 135 omitted

# reduce 136 omitted

module_eval(<<'.,.,', 'parser.y', 539)
  def _reduce_137(val, _values, result)
     result = nil
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 541)
  def _reduce_138(val, _values, result)
            val[1].each {|p| insert_bound_variable(p.name) }

        result = LocatedValue.new(value: val[1], location: val[0].location + val[2].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 548)
  def _reduce_139(val, _values, result)
            result = Declarations::ModuleTypeParams.new()
        result.add(val[0])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 552)
  def _reduce_140(val, _values, result)
            result = val[0].add(val[2])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 557)
  def _reduce_141(val, _values, result)
            result = Declarations::ModuleTypeParams::TypeParam.new(name: val[2].value.to_sym,
                                                               variance: val[1],
                                                               skip_validation: val[0])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 563)
  def _reduce_142(val, _values, result)
     result = :invariant
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 564)
  def _reduce_143(val, _values, result)
     result = :covariant
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 565)
  def _reduce_144(val, _values, result)
     result = :contravariant
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 568)
  def _reduce_145(val, _values, result)
     result = false
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 569)
  def _reduce_146(val, _values, result)
     result = true
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 572)
  def _reduce_147(val, _values, result)
     result = nil
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 574)
  def _reduce_148(val, _values, result)
            val[1].each {|var| insert_bound_variable(var) }

        result = LocatedValue.new(value: val[1],
                                  location: val[0].location + val[2].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 582)
  def _reduce_149(val, _values, result)
            result = [val[0].value.to_sym]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 585)
  def _reduce_150(val, _values, result)
            result = val[0].push(val[2].value.to_sym)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 590)
  def _reduce_151(val, _values, result)
            location = val[1].location + val[3].location
        result = Members::Alias.new(
          new_name: val[2].value.to_sym,
          old_name: val[3].value.to_sym,
          kind: :instance,
          annotations: val[0],
          location: location,
          comment: leading_comment(val[0].first&.location || location)
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 601)
  def _reduce_152(val, _values, result)
            location = val[1].location + val[7].location
        result = Members::Alias.new(
          new_name: val[4].value.to_sym,
          old_name: val[7].value.to_sym,
          kind: :singleton,
          annotations: val[0],
          location: location,
          comment: leading_comment(val[0].first&.location || location)
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 614)
  def _reduce_153(val, _values, result)
            location = val[1].location + val[4].location
        result = Declarations::Alias.new(name: val[2].value,
                                         type: val[4],
                                         annotations: val[0],
                                         location: location,
                                         comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 624)
  def _reduce_154(val, _values, result)
            location = val[0].location + val[2].location
        result = Declarations::Constant.new(name: val[0].value,
                                            type: val[2],
                                            location: location,
                                            comment: leading_comment(location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 631)
  def _reduce_155(val, _values, result)
            location = (val[0] || val[1]).location + val[2].location
        name = TypeName.new(name: val[1].value, namespace: val[0]&.value || Namespace.empty)
        result = Declarations::Constant.new(name: name,
                                            type: val[2],
                                            location: location,
                                            comment: leading_comment(location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 641)
  def _reduce_156(val, _values, result)
            location = val[0].location + val[2].location
        result = Declarations::Global.new(name: val[0].value.to_sym,
                                          type: val[2],
                                          location: location,
                                          comment: leading_comment(location))

    result
  end
.,.,

# reduce 157 omitted

module_eval(<<'.,.,', 'parser.y', 651)
  def _reduce_158(val, _values, result)
            types = case l = val[0]
                when Types::Union
                  l.types + [val[2]]
                else
                  [l, val[2]]
                end

        result = Types::Union.new(types: types, location: val[0].location + val[2].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 661)
  def _reduce_159(val, _values, result)
            types = case l = val[0]
                when Types::Intersection
                  l.types + [val[2]]
                else
                  [l, val[2]]
                end

        result = Types::Intersection.new(types: types,
                                         location: val[0].location + val[2].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 674)
  def _reduce_160(val, _values, result)
            result = Types::Bases::Void.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 677)
  def _reduce_161(val, _values, result)
            RBS.logger.warn "`any` type is deprecated. Use `untyped` instead. (#{val[0].location.to_s})"
        result = Types::Bases::Any.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 681)
  def _reduce_162(val, _values, result)
            result = Types::Bases::Any.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 684)
  def _reduce_163(val, _values, result)
            result = Types::Bases::Bool.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 687)
  def _reduce_164(val, _values, result)
            result = Types::Bases::Nil.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 690)
  def _reduce_165(val, _values, result)
            result = Types::Bases::Top.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 693)
  def _reduce_166(val, _values, result)
            result = Types::Bases::Bottom.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 696)
  def _reduce_167(val, _values, result)
            result = Types::Bases::Self.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 699)
  def _reduce_168(val, _values, result)
            result = Types::Optional.new(type: Types::Bases::Self.new(location: val[0].location),
                                     location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 703)
  def _reduce_169(val, _values, result)
            result = Types::Bases::Instance.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 706)
  def _reduce_170(val, _values, result)
            result = Types::Bases::Class.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 709)
  def _reduce_171(val, _values, result)
            result = Types::Literal.new(literal: true, location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 712)
  def _reduce_172(val, _values, result)
            result = Types::Literal.new(literal: false, location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 715)
  def _reduce_173(val, _values, result)
            result = Types::Literal.new(literal: val[0].value, location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 718)
  def _reduce_174(val, _values, result)
            result = Types::Literal.new(literal: val[0].value, location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 721)
  def _reduce_175(val, _values, result)
            result = Types::Literal.new(literal: val[0].value, location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 724)
  def _reduce_176(val, _values, result)
            name = val[0].value
        args = []
        location = val[0].location

        case
        when name.class?
          if is_bound_variable?(name.name)
            result = Types::Variable.new(name: name.name, location: location)
          else
            result = Types::ClassInstance.new(name: name, args: args, location: location)
          end
        when name.alias?
          result = Types::Alias.new(name: name, location: location)
        when name.interface?
          result = Types::Interface.new(name: name, args: args, location: location)
        end

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 742)
  def _reduce_177(val, _values, result)
            name = val[0].value
        args = val[2]
        location = val[0].location + val[3].location

        case
        when name.class?
          if is_bound_variable?(name.name)
            raise SemanticsError.new("#{name.name} is type variable and cannot be applied", subject: name, location: location)
          end
          result = Types::ClassInstance.new(name: name, args: args, location: location)
        when name.interface?
          result = Types::Interface.new(name: name, args: args, location: location)
        else
          raise SyntaxError.new(token_str: "kLBRACKET", error_value: val[1])
        end

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 759)
  def _reduce_178(val, _values, result)
            location = val[0].location + val[1].location
        result = Types::Tuple.new(types: [], location: location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 763)
  def _reduce_179(val, _values, result)
            location = val[0].location + val[2].location
        types = val[1]
        result = Types::Tuple.new(types: types, location: location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 768)
  def _reduce_180(val, _values, result)
            type = val[1].dup
        type.instance_eval do
          @location = val[0].location + val[2].location
        end
        result = type

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 775)
  def _reduce_181(val, _values, result)
            result = Types::ClassSingleton.new(name: val[2].value,
                                           location: val[0].location + val[3].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 779)
  def _reduce_182(val, _values, result)
            type, block = val[1].value
        result = Types::Proc.new(type: type, block: block, location: val[0].location + val[1].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 783)
  def _reduce_183(val, _values, result)
            result = Types::Optional.new(type: val[0], location: val[0].location + val[1].location)

    result
  end
.,.,

# reduce 184 omitted

module_eval(<<'.,.,', 'parser.y', 789)
  def _reduce_185(val, _values, result)
            result = [val[0]]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 792)
  def _reduce_186(val, _values, result)
            result = val[0] + [val[2]]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 797)
  def _reduce_187(val, _values, result)
            result = Types::Record.new(
          fields: val[1],
          location: val[0].location + val[2].location
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 805)
  def _reduce_188(val, _values, result)
            result = val[0]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 808)
  def _reduce_189(val, _values, result)
            result = val[0].merge!(val[2])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 813)
  def _reduce_190(val, _values, result)
            result = { val[0].value => val[2] }

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 816)
  def _reduce_191(val, _values, result)
            result = { val[0].value => val[2] }

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 819)
  def _reduce_192(val, _values, result)
            result = { val[0].value => val[2] }

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 822)
  def _reduce_193(val, _values, result)
            result = { val[0].value => val[1] }

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 825)
  def _reduce_194(val, _values, result)
            result = { val[0].value => val[2] }

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 828)
  def _reduce_195(val, _values, result)
            result = { val[0].value => val[2] }

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 831)
  def _reduce_196(val, _values, result)
            result = { val[0].value => val[2] }

    result
  end
.,.,

# reduce 197 omitted

module_eval(<<'.,.,', 'parser.y', 837)
  def _reduce_198(val, _values, result)
            result = val[0]

    result
  end
.,.,

# reduce 199 omitted

# reduce 200 omitted

# reduce 201 omitted

# reduce 202 omitted

module_eval(<<'.,.,', 'parser.y', 844)
  def _reduce_203(val, _values, result)
            location = (val[0] || val[1] || val[2]).location + val[3].location

        params = val[0]&.value || [[], [], nil, [], {}, {}, nil]

        type = Types::Function.new(
          required_positionals: params[0],
          optional_positionals: params[1],
          rest_positionals: params[2],
          trailing_positionals: params[3],
          required_keywords: params[4],
          optional_keywords: params[5],
          rest_keywords: params[6],
          return_type: val[3]
        )

        block = val[1].value

        result = LocatedValue.new(value: [type, block], location: location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 864)
  def _reduce_204(val, _values, result)
            result = LocatedValue.new(value: [val[0].value, nil], location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 869)
  def _reduce_205(val, _values, result)
            location = val[0].location + val[4].location
        type = Types::Function.new(
          required_positionals: val[1][0],
          optional_positionals: val[1][1],
          rest_positionals: val[1][2],
          trailing_positionals: val[1][3],
          required_keywords: val[1][4],
          optional_keywords: val[1][5],
          rest_keywords: val[1][6],
          return_type: val[4],
        )

        result = LocatedValue.new(value: type, location: location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 884)
  def _reduce_206(val, _values, result)
            location = val[0].location + val[1].location
        type = Types::Function.new(
          required_positionals: [],
          optional_positionals: [],
          rest_positionals: nil,
          trailing_positionals: [],
          required_keywords: {},
          optional_keywords: {},
          rest_keywords: nil,
          return_type: val[1]
        )

        result = LocatedValue.new(value: type, location: location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 901)
  def _reduce_207(val, _values, result)
            result = val[2]
        result[0].unshift(val[0])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 905)
  def _reduce_208(val, _values, result)
            result = empty_params_result
        result[0].unshift(val[0])

    result
  end
.,.,

# reduce 209 omitted

module_eval(<<'.,.,', 'parser.y', 912)
  def _reduce_210(val, _values, result)
            result = val[2]
        result[1].unshift(val[0])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 916)
  def _reduce_211(val, _values, result)
            result = empty_params_result
        result[1].unshift(val[0])

    result
  end
.,.,

# reduce 212 omitted

module_eval(<<'.,.,', 'parser.y', 923)
  def _reduce_213(val, _values, result)
            result = val[2]
        result[2] = val[0]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 927)
  def _reduce_214(val, _values, result)
            result = empty_params_result
        result[2] = val[0]

    result
  end
.,.,

# reduce 215 omitted

module_eval(<<'.,.,', 'parser.y', 934)
  def _reduce_216(val, _values, result)
            result = val[2]
        result[3].unshift(val[0])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 938)
  def _reduce_217(val, _values, result)
            result = empty_params_result
        result[3].unshift(val[0])

    result
  end
.,.,

# reduce 218 omitted

module_eval(<<'.,.,', 'parser.y', 945)
  def _reduce_219(val, _values, result)
            result = empty_params_result

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 948)
  def _reduce_220(val, _values, result)
            result = val[2]
        result[4].merge!(val[0])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 952)
  def _reduce_221(val, _values, result)
            result = empty_params_result
        result[4].merge!(val[0])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 956)
  def _reduce_222(val, _values, result)
            result = val[2]
        result[5].merge!(val[0])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 960)
  def _reduce_223(val, _values, result)
            result = empty_params_result
        result[5].merge!(val[0])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 964)
  def _reduce_224(val, _values, result)
            result = empty_params_result
        result[6] = val[0]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 970)
  def _reduce_225(val, _values, result)
            result = Types::Function::Param.new(type: val[0],
                                            name: val[1]&.value&.to_sym)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 976)
  def _reduce_226(val, _values, result)
            result = Types::Function::Param.new(type: val[1],
                                            name: val[2]&.value&.to_sym)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 982)
  def _reduce_227(val, _values, result)
            result = Types::Function::Param.new(type: val[1],
                                            name: val[2]&.value&.to_sym)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 988)
  def _reduce_228(val, _values, result)
            param = Types::Function::Param.new(type: val[1],
                                           name: val[2]&.value&.to_sym)
        result = { val[0].value => param }

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 995)
  def _reduce_229(val, _values, result)
            param = Types::Function::Param.new(type: val[2],
                                           name: val[3]&.value&.to_sym)
        result = { val[1].value => param }

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1002)
  def _reduce_230(val, _values, result)
            result = Types::Function::Param.new(type: val[1],
                                            name: val[2]&.value&.to_sym)

    result
  end
.,.,

# reduce 231 omitted

# reduce 232 omitted

# reduce 233 omitted

# reduce 234 omitted

module_eval(<<'.,.,', 'parser.y', 1011)
  def _reduce_235(val, _values, result)
            namespace = val[0]&.value || Namespace.empty
        name = val[1].value.to_sym
        type_name = TypeName.new(namespace: namespace, name: name)
        location = (loc0 = val[0]&.location) ? loc0 + val[1].location : val[1].location
        result = LocatedValue.new(value: type_name, location: location)

    result
  end
.,.,

# reduce 236 omitted

# reduce 237 omitted

# reduce 238 omitted

module_eval(<<'.,.,', 'parser.y', 1023)
  def _reduce_239(val, _values, result)
            namespace = val[0]&.value || Namespace.empty
        name = val[1].value.to_sym
        type_name = TypeName.new(namespace: namespace, name: name)
        location = (loc0 = val[0]&.location) ? loc0 + val[1].location : val[1].location
        result = LocatedValue.new(value: type_name, location: location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1032)
  def _reduce_240(val, _values, result)
            namespace = val[0]&.value || Namespace.empty
        name = val[1].value.to_sym
        type_name = TypeName.new(namespace: namespace, name: name)
        location = (loc0 = val[0]&.location) ? loc0 + val[1].location : val[1].location
        result = LocatedValue.new(value: type_name, location: location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1041)
  def _reduce_241(val, _values, result)
            result = nil

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1044)
  def _reduce_242(val, _values, result)
            result = LocatedValue.new(value: Namespace.root, location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1047)
  def _reduce_243(val, _values, result)
            namespace = Namespace.parse(val[1].value).absolute!
        result = LocatedValue.new(value: namespace, location: val[0].location + val[1].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1051)
  def _reduce_244(val, _values, result)
            namespace = Namespace.parse(val[0].value)
        result = LocatedValue.new(value: namespace, location: val[0].location)

    result
  end
.,.,

def _reduce_none(val, _values, result)
  val[0]
end

  end   # class Parser
end   # module RBS


