/* -*-c-*-
 THIS FILE WAS AUTOGENERATED BY template/prelude.c.tmpl. DO NOT EDIT.

 sources: ./ast, ./dir, ./gc, ./numeric, ./io, ./marshal, ./rjit, ./rjit_c, ./pack, ./trace_point, ./warning, ./array, ./hash, ./kernel, ./ractor, ./symbol, ./timev, ./thread_sync, ./nilclass, ./prelude, ./gem_prelude, ./yjit, ./yjit_hook
*/
#include "internal.h"
#include "internal/ruby_parser.h"
#include "internal/warnings.h"
#include "iseq.h"
#include "ruby/ruby.h"
#include "vm_core.h"

COMPILER_WARNING_PUSH
#if __has_warning("-Wstring-concatenation")
COMPILER_WARNING_IGNORED(-Wstring-concatenation)
#endif

static const char prelude_name0[] = "<internal:ast>";
static const struct {
    char L0[508]; /* 1..87 */
    char L87[498]; /* 88..147 */
    char L147[491]; /* 148..190 */
    char L190[465]; /* 191..265 */
    char L265[505]; /* 266..312 */
    char L312[199]; /* 313..333 */
} prelude_code0 = {
#line 1 "ast.rb"
""/* for ast.c */
""
""/* AbstractSyntaxTree provides methods to parse Ruby code into */
""/* abstract syntax trees. The nodes in the tree */
""/* are instances of RubyVM::AbstractSyntaxTree::Node. */
""/*  */
""/* This module is MRI specific as it exposes implementation details */
""/* of the MRI abstract syntax tree. */
""/*  */
""/* This module is experimental and its API is not stable, therefore it might */
""/* change without notice. As examples, the order of children nodes is not */
""/* guaranteed, the number of children nodes might change, there is no way to */
""/* access children nodes by name, etc. */
""/*  */
""/* If you are looking for a stable API or an API working under multiple Ruby */
""/* implementations, consider using the _prism_ gem, which is the official */
""/* Ruby API to parse Ruby code. */
""/*  */
"module RubyVM::AbstractSyntaxTree\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     RubyVM::AbstractSyntaxTree.parse(string, keep_script_lines: RubyVM.keep_script_lines, error_tolerant: false, keep_tokens: false) -> RubyVM::AbstractSyntaxTree::Node */
"\n"/*  */
"\n"/*  Parses the given _string_ into an abstract syntax tree, */
"\n"/*  returning the root node of that tree. */
"\n"/*  */
"\n"/*    RubyVM::AbstractSyntaxTree.parse(\"x = 1 + 2\") */
"\n"/*    # => #<RubyVM::AbstractSyntaxTree::Node:SCOPE@1:0-1:9> */
"\n"/*  */
"\n"/*  If <tt>keep_script_lines: true</tt> option is provided, the text of the parsed */
"\n"/*  source is associated with nodes and is available via Node#script_lines. */
"\n"/*  */
"\n"/*  If <tt>keep_tokens: true</tt> option is provided, Node#tokens are populated. */
"\n"/*  */
"\n"/*  SyntaxError is raised if the given _string_ is invalid syntax. To overwrite this */
"\n"/*  behavior, <tt>error_tolerant: true</tt> can be provided. In this case, the parser */
"\n"/*  will produce a tree where expressions with syntax errors would be represented by */
"\n"/*  Node with <tt>type=:ERROR</tt>. */
"\n"/*  */
"\n"/*     root = RubyVM::AbstractSyntaxTree.parse(\"x = 1; p(x; y=2\") */
"\n"/*     # <internal:ast>:33:in `parse': syntax error, unexpected ';', expecting ')' (SyntaxError) */
"\n"/*     # x = 1; p(x; y=2 */
"\n"/*     #           ^ */
"\n"/*  */
"\n"/*     root = RubyVM::AbstractSyntaxTree.parse(\"x = 1; p(x; y=2\", error_tolerant: true) */
"\n"/*     # (SCOPE@1:0-1:15 */
"\n"/*     #  tbl: [:x, :y] */
"\n"/*     #  args: nil */
"\n"/*     #  body: (BLOCK@1:0-1:15 (LASGN@1:0-1:5 :x (LIT@1:4-1:5 1)) (ERROR@1:7-1:11) (LASGN@1:12-1:15 :y (LIT@1:14-1:15 2)))) */
"\n"/*     root.children.last.children */
"\n"/*     # [(LASGN@1:0-1:5 :x (LIT@1:4-1:5 1)), */
"\n"/*     #  (ERROR@1:7-1:11), */
"\n"/*     #  (LASGN@1:12-1:15 :y (LIT@1:14-1:15 2))] */
"\n"/*  */
"\n"/*  Note that parsing continues even after the errored expression. */
"\n"/*  */
"  def self.parse string, keep_script_lines: RubyVM.keep_script_lines, error_tolerant: false, keep_tokens: false\n"
"    Primitive.ast_s_parse string, keep_script_lines, error_tolerant, keep_tokens\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     RubyVM::AbstractSyntaxTree.parse_file(pathname, keep_script_lines: RubyVM.keep_script_lines, error_tolerant: false, keep_tokens: false) -> RubyVM::AbstractSyntaxTree::Node */
"\n"/*  */
"\n"/*   Reads the file from _pathname_, then parses it like ::parse, */
"\n"/*   returning the root node of the abstract syntax tree. */
"\n"/*  */
"\n"/*   SyntaxError is raised if _pathname_'s contents are not */
"\n"/*   valid Ruby syntax. */
"\n"/*  */
"\n"/*     RubyVM::AbstractSyntaxTree.parse_file(\"my-app/app.rb\") */
"\n"/*     # => #<RubyVM::AbstractSyntaxTree::Node:SCOPE@1:0-31:3> */
"\n"/*  */
"\n"/*   See ::parse for explanation of keyword argument meaning and usage. */
"  def self.parse_file pathname, keep_script_lines: RubyVM.keep_script_lines, error_tolerant: false, keep_tokens: false\n"
"    Primitive.ast_s_parse_file pathname, keep_script_lines, error_tolerant, keep_tokens\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     RubyVM::AbstractSyntaxTree.of(proc, keep_script_lines: RubyVM.keep_script_lines, error_tolerant: false, keep_tokens: false)   -> RubyVM::AbstractSyntaxTree::Node */
"\n"/*     RubyVM::AbstractSyntaxTree.of(method, keep_script_lines: RubyVM.keep_script_lines, error_tolerant: false, keep_tokens: false) -> RubyVM::AbstractSyntaxTree::Node */
"\n"/*  */
"\n"/*   Returns AST nodes of the given _proc_ or _method_. */
"\n"/*  */
"\n"/*     RubyVM::AbstractSyntaxTree.of(proc {1 + 2}) */
"\n"/*     # => #<RubyVM::AbstractSyntaxTree::Node:SCOPE@1:35-1:42> */
"\n"/*  */
"\n"/*     def hello */
,
#line 88 "ast.rb"
"\n"/*       puts \"hello, world\" */
"\n"/*     end */
"\n"/*  */
"\n"/*     RubyVM::AbstractSyntaxTree.of(method(:hello)) */
"\n"/*     # => #<RubyVM::AbstractSyntaxTree::Node:SCOPE@1:0-3:3> */
"\n"/*  */
"\n"/*   See ::parse for explanation of keyword argument meaning and usage. */
"  def self.of body, keep_script_lines: RubyVM.keep_script_lines, error_tolerant: false, keep_tokens: false\n"
"    Primitive.ast_s_of body, keep_script_lines, error_tolerant, keep_tokens\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     RubyVM::AbstractSyntaxTree.node_id_for_backtrace_location(backtrace_location)   -> integer */
"\n"/*  */
"\n"/*   Returns the node id for the given backtrace location. */
"\n"/*  */
"\n"/*     begin */
"\n"/*       raise */
"\n"/*     rescue =>  e */
"\n"/*       loc = e.backtrace_locations.first */
"\n"/*       RubyVM::AbstractSyntaxTree.node_id_for_backtrace_location(loc) */
"\n"/*     end # => 0 */
"  def self.node_id_for_backtrace_location backtrace_location\n"
"    Primitive.node_id_for_backtrace_location backtrace_location\n"
"  end\n"
"\n"
"\n"/* RubyVM::AbstractSyntaxTree::Node instances are created by parse methods in */
"\n"/* RubyVM::AbstractSyntaxTree. */
"\n"/*  */
"\n"/* This class is MRI specific. */
"\n"/*  */
"  class Node\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.type -> symbol */
"\n"/*  */
"\n"/*  Returns the type of this node as a symbol. */
"\n"/*  */
"\n"/*    root = RubyVM::AbstractSyntaxTree.parse(\"x = 1 + 2\") */
"\n"/*    root.type # => :SCOPE */
"\n"/*    lasgn = root.children[2] */
"\n"/*    lasgn.type # => :LASGN */
"\n"/*    call = lasgn.children[1] */
"\n"/*    call.type # => :OPCALL */
"    def type\n"
"      Primitive.ast_node_type\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.first_lineno -> integer */
"\n"/*  */
"\n"/*  The line number in the source code where this AST's text began. */
"    def first_lineno\n"
"      Primitive.ast_node_first_lineno\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.first_column -> integer */
"\n"/*  */
"\n"/*  The column number in the source code where this AST's text began. */
,
#line 148 "ast.rb"
"    def first_column\n"
"      Primitive.ast_node_first_column\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.last_lineno -> integer */
"\n"/*  */
"\n"/*  The line number in the source code where this AST's text ended. */
"    def last_lineno\n"
"      Primitive.ast_node_last_lineno\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.last_column -> integer */
"\n"/*  */
"\n"/*  The column number in the source code where this AST's text ended. */
"    def last_column\n"
"      Primitive.ast_node_last_column\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.tokens -> array */
"\n"/*  */
"\n"/*  Returns tokens corresponding to the location of the node. */
"\n"/*  Returns +nil+ if +keep_tokens+ is not enabled when #parse method is called. */
"\n"/*  */
"\n"/*    root = RubyVM::AbstractSyntaxTree.parse(\"x = 1 + 2\", keep_tokens: true) */
"\n"/*    root.tokens # => [[0, :tIDENTIFIER, \"x\", [1, 0, 1, 1]], [1, :tSP, \" \", [1, 1, 1, 2]], ...] */
"\n"/*    root.tokens.map{_1[2]}.join # => \"x = 1 + 2\" */
"\n"/*  */
"\n"/*  Token is an array of: */
"\n"/*  */
"\n"/*  - id */
"\n"/*  - token type */
"\n"/*  - source code text */
"\n"/*  - location [ first_lineno, first_column, last_lineno, last_column ] */
"    def tokens\n"
"      return nil unless all_tokens\n"
"\n"
"      all_tokens.each_with_object([]) do |token, a|\n"
"        loc = token.last\n"
"        if ([first_lineno, first_column] <=> [loc[0], loc[1]]) <= 0 &&\n"
"           ([last_lineno, last_column]   <=> [loc[2], loc[3]]) >= 0\n"
,
#line 191 "ast.rb"
"           a << token\n"
"        end\n"
"      end\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.all_tokens -> array */
"\n"/*  */
"\n"/*  Returns all tokens for the input script regardless the receiver node. */
"\n"/*  Returns +nil+ if +keep_tokens+ is not enabled when #parse method is called. */
"\n"/*  */
"\n"/*    root = RubyVM::AbstractSyntaxTree.parse(\"x = 1 + 2\", keep_tokens: true) */
"\n"/*    root.all_tokens # => [[0, :tIDENTIFIER, \"x\", [1, 0, 1, 1]], [1, :tSP, \" \", [1, 1, 1, 2]], ...] */
"\n"/*    root.children[-1].all_tokens # => [[0, :tIDENTIFIER, \"x\", [1, 0, 1, 1]], [1, :tSP, \" \", [1, 1, 1, 2]], ...] */
"    def all_tokens\n"
"      Primitive.ast_node_all_tokens\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.children -> array */
"\n"/*  */
"\n"/*  Returns AST nodes under this one.  Each kind of node */
"\n"/*  has different children, depending on what kind of node it is. */
"\n"/*  */
"\n"/*  The returned array may contain other nodes or <code>nil</code>. */
"    def children\n"
"      Primitive.ast_node_children\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.inspect -> string */
"\n"/*  */
"\n"/*  Returns debugging information about this node as a string. */
"    def inspect\n"
"      Primitive.ast_node_inspect\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.node_id -> integer */
"\n"/*  */
"\n"/*  Returns an internal node_id number. */
"\n"/*  Note that this is an API for ruby internal use, debugging, */
"\n"/*  and research. Do not use this for any other purpose. */
"\n"/*  The compatibility is not guaranteed. */
"    def node_id\n"
"      Primitive.ast_node_node_id\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.script_lines -> array */
"\n"/*  */
"\n"/*  Returns the original source code as an array of lines. */
"\n"/*  */
"\n"/*  Note that this is an API for ruby internal use, debugging, */
"\n"/*  and research. Do not use this for any other purpose. */
"\n"/*  The compatibility is not guaranteed. */
"    def script_lines\n"
"      Primitive.ast_node_script_lines\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.source -> string */
"\n"/*  */
"\n"/*  Returns the code fragment that corresponds to this AST. */
"\n"/*  */
"\n"/*  Note that this is an API for ruby internal use, debugging, */
"\n"/*  and research. Do not use this for any other purpose. */
"\n"/*  The compatibility is not guaranteed. */
"\n"/*  */
"\n"/*  Also note that this API may return an incomplete code fragment */
"\n"/*  that does not parse; for example, a here document following */
"\n"/*  an expression may be dropped. */
"    def source\n"
"      lines = script_lines\n"
"      if lines\n"
,
#line 266 "ast.rb"
"        lines = lines[first_lineno - 1 .. last_lineno - 1]\n"
"        lines[-1] = lines[-1].byteslice(0...last_column)\n"
"        lines[0] = lines[0].byteslice(first_column..-1)\n"
"        lines.join\n"
"      else\n"
"        nil\n"
"      end\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.locations -> array */
"\n"/*  */
"\n"/*  Returns location objects associated with the AST node. */
"\n"/*  The returned array contains RubyVM::AbstractSyntaxTree::Location. */
"    def locations\n"
"      Primitive.ast_node_locations\n"
"    end\n"
"  end\n"
"\n"
"\n"/* RubyVM::AbstractSyntaxTree::Location instances are created by */
"\n"/* RubyVM::AbstractSyntaxTree#locations. */
"\n"/*  */
"\n"/* This class is MRI specific. */
"\n"/*  */
"  class Location\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     location.first_lineno -> integer */
"\n"/*  */
"\n"/*  The line number in the source code where this AST's text began. */
"    def first_lineno\n"
"      Primitive.ast_location_first_lineno\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     location.first_column -> integer */
"\n"/*  */
"\n"/*  The column number in the source code where this AST's text began. */
"    def first_column\n"
"      Primitive.ast_location_first_column\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     location.last_lineno -> integer */
"\n"/*  */
"\n"/*  The line number in the source code where this AST's text ended. */
"    def last_lineno\n"
,
#line 313 "ast.rb"
"      Primitive.ast_location_last_lineno\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     location.last_column -> integer */
"\n"/*  */
"\n"/*  The column number in the source code where this AST's text ended. */
"    def last_column\n"
"      Primitive.ast_location_last_column\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     location.inspect -> string */
"\n"/*  */
"\n"/*  Returns debugging information about this location as a string. */
"    def inspect\n"
"      Primitive.ast_location_inspect\n"
"    end\n"
"  end\n"
"end\n"
#line 371 "miniprelude.c"
};

static const char prelude_name1[] = "<internal:dir>";
static const struct {
    char L0[508]; /* 1..266 */
    char L266[497]; /* 267..507 */
} prelude_code1 = {
#line 1 "dir.rb"
""/* An object of class \\Dir represents a directory in the underlying file system. */
""/*  */
""/* It consists mainly of: */
""/*  */
""/* - A string _path_, given when the object is created, */
""/*   that specifies a directory in the underlying file system; */
""/*   method #path returns the path. */
""/* - A collection of string <i>entry names</i>, */
""/*   each of which is the name of a directory or file in the underlying file system; */
""/*   the entry names may be retrieved */
""/*   in an {array-like fashion}[rdoc-ref:Dir@Dir+As+Array-Like] */
""/*   or in a {stream-like fashion}[rdoc-ref:Dir@Dir+As+Stream-Like]. */
""/*  */
""/* == About the Examples */
""/*  */
""/* Some examples on this page use this simple file tree: */
""/*  */
""/*   example/ */
""/*   \xE2\x94\x9C\xE2\x94\x80\xE2\x94\x80 config.h */
""/*   \xE2\x94\x9C\xE2\x94\x80\xE2\x94\x80 lib/ */
""/*   \xE2\x94\x82   \xE2\x94\x9C\xE2\x94\x80\xE2\x94\x80 song/ */
""/*   \xE2\x94\x82   \xE2\x94\x82   \xE2\x94\x94\xE2\x94\x80\xE2\x94\x80 karaoke.rb */
""/*   \xE2\x94\x82   \xE2\x94\x94\xE2\x94\x80\xE2\x94\x80 song.rb */
""/*   \xE2\x94\x94\xE2\x94\x80\xE2\x94\x80 main.rb */
""/*  */
""/* Others use the file tree for the */
""/* {Ruby project itself}[https://github.com/ruby/ruby]. */
""/*  */
""/* == \\Dir As \\Array-Like */
""/*  */
""/* A \\Dir object is in some ways array-like: */
""/*  */
""/* - It has instance methods #children, #each, and #each_child. */
""/* - It includes {module Enumerable}[rdoc-ref:Enumerable@What-27s+Here]. */
""/*  */
""/* == \\Dir As Stream-Like */
""/*  */
""/* A \\Dir object is in some ways stream-like. */
""/*  */
""/* The stream is initially open for reading, */
""/* but may be closed manually (using method #close), */
""/* and will be closed on block exit if created by Dir.open called with a block. */
""/* The closed stream may not be further manipulated, */
""/* and may not be reopened. */
""/*  */
""/* The stream has a _position_, which is the index of an entry in the directory: */
""/*  */
""/* - The initial position is zero (before the first entry). */
""/* - \\Method #tell (aliased as #pos) returns the position. */
""/* - \\Method #pos= sets the position (but ignores a value outside the stream), */
""/*   and returns the position. */
""/* - \\Method #seek is like #pos=, but returns +self+ (convenient for chaining). */
""/* - \\Method #read, if not at end-of-stream, reads the next entry and increments */
""/*   the position; */
""/*   if at end-of-stream, does not increment the position. */
""/* - \\Method #rewind sets the position to zero. */
""/*  */
""/* Examples (using the {simple file tree}[rdoc-ref:Dir@About+the+Examples]): */
""/*  */
""/*   dir = Dir.new('example') # => #<Dir:example> */
""/*   dir.pos                  # => 0 */
""/*  */
""/*   dir.read # => \".\" */
""/*   dir.read # => \"..\" */
""/*   dir.read # => \"config.h\" */
""/*   dir.read # => \"lib\" */
""/*   dir.read # => \"main.rb\" */
""/*   dir.pos  # => 5 */
""/*   dir.read # => nil */
""/*   dir.pos  # => 5 */
""/*  */
""/*   dir.rewind # => #<Dir:example> */
""/*   dir.pos    # => 0 */
""/*  */
""/*   dir.pos = 3 # => 3 */
""/*   dir.pos     # => 3 */
""/*  */
""/*   dir.seek(4) # => #<Dir:example> */
""/*   dir.pos     # => 4 */
""/*  */
""/*   dir.close # => nil */
""/*   dir.read  # Raises IOError. */
""/*  */
""/* == What's Here */
""/*  */
""/* First, what's elsewhere. \\Class \\Dir: */
""/*  */
""/* - Inherits from {class Object}[rdoc-ref:Object@What-27s+Here]. */
""/* - Includes {module Enumerable}[rdoc-ref:Enumerable@What-27s+Here], */
""/*   which provides dozens of additional methods. */
""/*  */
""/* Here, class \\Dir provides methods that are useful for: */
""/*  */
""/* - {Reading}[rdoc-ref:Dir@Reading] */
""/* - {Setting}[rdoc-ref:Dir@Setting] */
""/* - {Querying}[rdoc-ref:Dir@Querying] */
""/* - {Iterating}[rdoc-ref:Dir@Iterating] */
""/* - {Other}[rdoc-ref:Dir@Other] */
""/*  */
""/* === Reading */
""/*  */
""/* - #close: Closes the directory stream for +self+. */
""/* - #pos=: Sets the position in the directory stream for +self+. */
""/* - #read: Reads and returns the next entry in the directory stream for +self+. */
""/* - #rewind: Sets the position in the directory stream for +self+ to the first entry. */
""/* - #seek: Sets the position in the directory stream for +self+ */
""/*   the entry at the given offset. */
""/*  */
""/* === Setting */
""/*  */
""/* - ::chdir: Changes the working directory of the current process */
""/*   to the given directory. */
""/* - ::chroot: Changes the file-system root for the current process */
""/*   to the given directory. */
""/*  */
""/* === Querying */
""/*  */
""/* - ::[]: Same as ::glob without the ability to pass flags. */
""/* - ::children: Returns an array of names of the children */
""/*   (both files and directories) of the given directory, */
""/*   but not including <tt>.</tt> or <tt>..</tt>. */
""/* - ::empty?: Returns whether the given path is an empty directory. */
""/* - ::entries: Returns an array of names of the children */
""/*   (both files and directories) of the given directory, */
""/*   including <tt>.</tt> and <tt>..</tt>. */
""/* - ::exist?: Returns whether the given path is a directory. */
""/* - ::getwd (aliased as #pwd): Returns the path to the current working directory. */
""/* - ::glob: Returns an array of file paths matching the given pattern and flags. */
""/* - ::home: Returns the home directory path for a given user or the current user. */
""/* - #children: Returns an array of names of the children */
""/*   (both files and directories) of +self+, */
""/*   but not including <tt>.</tt> or <tt>..</tt>. */
""/* - #fileno: Returns the integer file descriptor for +self+. */
""/* - #path (aliased as #to_path): Returns the path used to create +self+. */
""/* - #tell (aliased as #pos): Returns the integer position */
""/*   in the directory stream for +self+. */
""/*  */
""/* === Iterating */
""/*  */
""/* - ::each_child: Calls the given block with each entry in the given directory, */
""/*   but not including <tt>.</tt> or <tt>..</tt>. */
""/* - ::foreach: Calls the given block with each entry in the given directory, */
""/*   including <tt>.</tt> and <tt>..</tt>. */
""/* - #each: Calls the given block with each entry in +self+, */
""/*   including <tt>.</tt> and <tt>..</tt>. */
""/* - #each_child: Calls the given block with each entry in +self+, */
""/*   but not including <tt>.</tt> or <tt>..</tt>. */
""/*  */
""/* === Other */
""/*  */
""/* - ::mkdir: Creates a directory at the given path, with optional permissions. */
""/* - ::new: Returns a new \\Dir for the given path, with optional encoding. */
""/* - ::open: Same as ::new, but if a block is given, yields the \\Dir to the block, */
""/*   closing it upon block exit. */
""/* - ::unlink (aliased as ::delete and ::rmdir): Removes the given directory. */
""/* - #inspect: Returns a string description of +self+. */
""/*  */
"class Dir\n"
"\n"/* call-seq: */
"\n"/*   Dir.open(dirpath) -> dir */
"\n"/*   Dir.open(dirpath, encoding: nil) -> dir */
"\n"/*   Dir.open(dirpath) {|dir| ... } -> object */
"\n"/*   Dir.open(dirpath, encoding: nil) {|dir| ... } -> object */
"\n"/*  */
"\n"/* Creates a new \\Dir object _dir_ for the directory at +dirpath+. */
"\n"/*  */
"\n"/* With no block, the method equivalent to Dir.new(dirpath, encoding): */
"\n"/*  */
"\n"/*   Dir.open('.') # => #<Dir:.> */
"\n"/*  */
"\n"/* With a block given, the block is called with the created _dir_; */
"\n"/* on block exit _dir_ is closed and the block's value is returned: */
"\n"/*  */
"\n"/*   Dir.open('.') {|dir| dir.inspect } # => \"#<Dir:.>\" */
"\n"/*  */
"\n"/* The value given with optional keyword argument +encoding+ */
"\n"/* specifies the encoding for the directory entry names; */
"\n"/* if +nil+ (the default), the file system's encoding is used: */
"\n"/*  */
"\n"/*   Dir.open('.').read.encoding                       # => #<Encoding:UTF-8> */
"\n"/*   Dir.open('.', encoding: 'US-ASCII').read.encoding # => #<Encoding:US-ASCII> */
"\n"/*  */
"  def self.open(name, encoding: nil, &block)\n"
"    dir = Primitive.dir_s_open(name, encoding)\n"
"    if block\n"
"      begin\n"
"        yield dir\n"
"      ensure\n"
"        Primitive.dir_s_close(dir)\n"
"      end\n"
"    else\n"
"      dir\n"
"    end\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*   Dir.new(dirpath) -> dir */
"\n"/*   Dir.new(dirpath, encoding: nil) -> dir */
"\n"/*  */
"\n"/* Returns a new \\Dir object for the directory at +dirpath+: */
"\n"/*  */
"\n"/*   Dir.new('.') # => #<Dir:.> */
"\n"/*  */
"\n"/* The value given with optional keyword argument +encoding+ */
"\n"/* specifies the encoding for the directory entry names; */
"\n"/* if +nil+ (the default), the file system's encoding is used: */
"\n"/*  */
"\n"/*   Dir.new('.').read.encoding                       # => #<Encoding:UTF-8> */
"\n"/*   Dir.new('.', encoding: 'US-ASCII').read.encoding # => #<Encoding:US-ASCII> */
"\n"/*  */
"  def initialize(name, encoding: nil)\n"
"    Primitive.dir_initialize(name, encoding)\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*   Dir[*patterns, base: nil, sort: true] -> array */
"\n"/*  */
"\n"/* Calls Dir.glob with argument +patterns+ */
"\n"/* and the values of keyword arguments +base+ and +sort+; */
"\n"/* returns the array of selected entry names. */
"\n"/*  */
"  def self.[](*args, base: nil, sort: true)\n"
"    Primitive.dir_s_aref(args, base, sort)\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*   Dir.glob(*patterns, flags: 0, base: nil, sort: true) -> array */
"\n"/*   Dir.glob(*patterns, flags: 0, base: nil, sort: true) {|entry_name| ... } -> nil */
"\n"/*  */
"\n"/* Forms an array _entry_names_ of the entry names selected by the arguments. */
"\n"/*  */
"\n"/* Argument +patterns+ is a string pattern or an array of string patterns; */
"\n"/* note that these are not regexps; see below. */
"\n"/*  */
"\n"/* Notes for the following examples: */
"\n"/*  */
"\n"/* - <tt>'*'</tt> is the pattern that matches any entry name */
"\n"/*   except those that begin with <tt>'.'</tt>. */
"\n"/* - We use method Array#take to shorten returned arrays */
"\n"/*   that otherwise would be very large. */
"\n"/*  */
"\n"/* With no block, returns array _entry_names_; */
"\n"/* example (using the {simple file tree}[rdoc-ref:Dir@About+the+Examples]): */
"\n"/*  */
"\n"/*   Dir.glob('*') # => [\"config.h\", \"lib\", \"main.rb\"] */
"\n"/*  */
"\n"/* With a block, calls the block with each of the _entry_names_ */
"\n"/* and returns +nil+: */
"\n"/*  */
"\n"/*   Dir.glob('*') {|entry_name| puts entry_name } # => nil */
"\n"/*  */
"\n"/* Output: */
"\n"/*  */
"\n"/*   config.h */
"\n"/*   lib */
"\n"/*   main.rb */
"\n"/*  */
"\n"/* If optional keyword argument +flags+ is given, */
"\n"/* the value modifies the matching; see below. */
"\n"/*  */
"\n"/* If optional keyword argument +base+ is given, */
"\n"/* its value specifies the base directory. */
"\n"/* Each pattern string specifies entries relative to the base directory; */
"\n"/* the default is <tt>'.'</tt>. */
"\n"/* The base directory is not prepended to the entry names in the result: */
"\n"/*  */
,
#line 267 "dir.rb"
"\n"/*   Dir.glob(pattern, base: 'lib').take(5) */
"\n"/*   # => [\"abbrev.gemspec\", \"abbrev.rb\", \"base64.gemspec\", \"base64.rb\", \"benchmark.gemspec\"] */
"\n"/*   Dir.glob(pattern, base: 'lib/irb').take(5) */
"\n"/*   # => [\"cmd\", \"color.rb\", \"color_printer.rb\", \"completion.rb\", \"context.rb\"] */
"\n"/*  */
"\n"/* If optional keyword +sort+ is given, its value specifies whether */
"\n"/* the array is to be sorted; the default is +true+. */
"\n"/* Passing value +false+ with that keyword disables sorting */
"\n"/* (though the underlying file system may already have sorted the array). */
"\n"/*  */
"\n"/* <b>Patterns</b> */
"\n"/*  */
"\n"/* Each pattern string is expanded */
"\n"/* according to certain metacharacters; */
"\n"/* examples below use the {Ruby file tree}[rdoc-ref:Dir@About+the+Examples]: */
"\n"/*  */
"\n"/* - <tt>'*'</tt>: Matches any substring in an entry name, */
"\n"/*   similar in meaning to regexp <tt>/.*\/mx</tt>; */
"\n"/*   may be restricted by other values in the pattern strings: */
"\n"/*  */
"\n"/*   - <tt>'*'</tt> matches all entry names: */
"\n"/*  */
"\n"/*       Dir.glob('*').take(3)  # => [\"BSDL\", \"CONTRIBUTING.md\", \"COPYING\"] */
"\n"/*  */
"\n"/*   - <tt>'c*'</tt> matches entry names beginning with <tt>'c'</tt>: */
"\n"/*  */
"\n"/*       Dir.glob('c*').take(3) # => [\"CONTRIBUTING.md\", \"COPYING\", \"COPYING.ja\"] */
"\n"/*  */
"\n"/*   - <tt>'*c'</tt> matches entry names ending with <tt>'c'</tt>: */
"\n"/*  */
"\n"/*       Dir.glob('*c').take(3) # => [\"addr2line.c\", \"array.c\", \"ast.c\"] */
"\n"/*  */
"\n"/*   - <tt>'\\*c\\*'</tt> matches entry names that contain <tt>'c'</tt>, */
"\n"/*     even at the beginning or end: */
"\n"/*  */
"\n"/*       Dir.glob('*c*').take(3) # => [\"CONTRIBUTING.md\", \"COPYING\", \"COPYING.ja\"] */
"\n"/*  */
"\n"/*   Does not match Unix-like hidden entry names (\"dot files\"). */
"\n"/*   To include those in the matched entry names, */
"\n"/*   use flag IO::FNM_DOTMATCH or something like <tt>'{*,.*}'</tt>. */
"\n"/*  */
"\n"/*  - <tt>'**'</tt>: Matches entry names recursively */
"\n"/*    if followed by  the slash character <tt>'/'</tt>: */
"\n"/*  */
"\n"/*      Dir.glob('**\/').take(3) # => [\"basictest/\", \"benchmark/\", \"benchmark/gc/\"] */
"\n"/*  */
"\n"/*    If the string pattern contains other characters */
"\n"/*    or is not followed by a slash character, */
"\n"/*    it is equivalent to <tt>'*'</tt>. */
"\n"/*  */
"\n"/* - <tt>'?'</tt> Matches any single character; */
"\n"/*   similar in meaning to regexp <tt>/./</tt>: */
"\n"/*  */
"\n"/*     Dir.glob('io.?') # => [\"io.c\"] */
"\n"/*  */
"\n"/* - <tt>'[_set_]'</tt>: Matches any one character in the string _set_; */
"\n"/*   behaves like a {Regexp character class}[rdoc-ref:Regexp@Character+Classes], */
"\n"/*   including set negation (<tt>'[^a-z]'</tt>): */
"\n"/*  */
"\n"/*     Dir.glob('*.[a-z][a-z]').take(3) */
"\n"/*     # => [\"CONTRIBUTING.md\", \"COPYING.ja\", \"KNOWNBUGS.rb\"] */
"\n"/*  */
"\n"/* - <tt>'{_abc_,_xyz_}'</tt>: */
"\n"/*   Matches either string _abc_ or string _xyz_; */
"\n"/*   behaves like {Regexp alternation}[rdoc-ref:Regexp@Alternation]: */
"\n"/*  */
"\n"/*     Dir.glob('{LEGAL,BSDL}') # => [\"LEGAL\", \"BSDL\"] */
"\n"/*  */
"\n"/*   More than two alternatives may be given. */
"\n"/*  */
"\n"/* - <tt>\\\\</tt>: Escapes the following metacharacter. */
"\n"/*  */
"\n"/*   Note that on Windows, the backslash character may not be used */
"\n"/*   in a string pattern: */
"\n"/*   <tt>Dir['c:\\\\foo*']</tt> will not work, use <tt>Dir['c:/foo*']</tt> instead. */
"\n"/*  */
"\n"/* More examples (using the {simple file tree}[rdoc-ref:Dir@About+the+Examples]): */
"\n"/*  */
"\n"/*   # We're in the example directory. */
"\n"/*   File.basename(Dir.pwd) # => \"example\" */
"\n"/*   Dir.glob('config.?')              # => [\"config.h\"] */
"\n"/*   Dir.glob('*.[a-z][a-z]')          # => [\"main.rb\"] */
"\n"/*   Dir.glob('*.[^r]*')               # => [\"config.h\"] */
"\n"/*   Dir.glob('*.{rb,h}')              # => [\"main.rb\", \"config.h\"] */
"\n"/*   Dir.glob('*')                     # => [\"config.h\", \"lib\", \"main.rb\"] */
"\n"/*   Dir.glob('*', File::FNM_DOTMATCH) # => [\".\", \"config.h\", \"lib\", \"main.rb\"] */
"\n"/*   Dir.glob([\"*.rb\", \"*.h\"])         # => [\"main.rb\", \"config.h\"] */
"\n"/*  */
"\n"/*   Dir.glob('**\/\*.rb') */
"\n"/*   => [\"lib/song/karaoke.rb\", \"lib/song.rb\", \"main.rb\"] */
"\n"/*  */
"\n"/*   Dir.glob('**\/\*.rb', base: 'lib')  #   => [\"song/karaoke.rb\", \"song.rb\"] */
"\n"/*  */
"\n"/*   Dir.glob('**\/lib')                # => [\"lib\"] */
"\n"/*  */
"\n"/*   Dir.glob('**\/lib/\**\/\*.rb')        # => [\"lib/song/karaoke.rb\", \"lib/song.rb\"] */
"\n"/*  */
"\n"/*   Dir.glob('**\/lib/\*.rb')           # => [\"lib/song.rb\"] */
"\n"/*  */
"\n"/* <b>Flags</b> */
"\n"/*  */
"\n"/* If optional keyword argument +flags+ is given (the default is zero -- no flags), */
"\n"/* its value should be the bitwise OR of one or more of the constants */
"\n"/* defined in module File::Constants. */
"\n"/*  */
"\n"/* Example: */
"\n"/*  */
"\n"/*   flags = File::FNM_EXTGLOB | File::FNM_DOTMATCH */
"\n"/*  */
"\n"/* Specifying flags can extend, restrict, or otherwise modify the matching. */
"\n"/*  */
"\n"/* The flags for this method (other constants in File::Constants do not apply): */
"\n"/*  */
"\n"/* - File::FNM_DOTMATCH: */
"\n"/*   specifies that entry names beginning with <tt>'.'</tt> */
"\n"/*   should be considered for matching: */
"\n"/*  */
"\n"/*     Dir.glob('*').take(5) */
"\n"/*     # => [\"BSDL\", \"CONTRIBUTING.md\", \"COPYING\", \"COPYING.ja\", \"GPL\"] */
"\n"/*     Dir.glob('*', flags: File::FNM_DOTMATCH).take(5) */
"\n"/*     # => [\".\", \".appveyor.yml\", \".cirrus.yml\", \".dir-locals.el\", \".document\"] */
"\n"/*  */
"\n"/* - File::FNM_EXTGLOB: */
"\n"/*   enables the pattern extension */
"\n"/*   <tt>'{_a_,_b_}'</tt>, which matches pattern _a_ and pattern _b_; */
"\n"/*   behaves like a */
"\n"/*   {regexp union}[rdoc-ref:Regexp.union] */
"\n"/*   (e.g., <tt>'(?:_a_|_b_)'</tt>): */
"\n"/*  */
"\n"/*     pattern = '{LEGAL,BSDL}' */
"\n"/*     Dir.glob(pattern)      # => [\"LEGAL\", \"BSDL\"] */
"\n"/*  */
"\n"/* - File::FNM_NOESCAPE: */
"\n"/*   specifies that escaping with the backslash character <tt>'\\'</tt> */
"\n"/*   is disabled; the character is not an escape character. */
"\n"/*  */
"\n"/* - File::FNM_PATHNAME: */
"\n"/*   specifies that metacharacters <tt>'*'</tt> and <tt>'?'</tt> */
"\n"/*   do not match directory separators. */
"\n"/*  */
"\n"/* - File::FNM_SHORTNAME: */
"\n"/*   specifies that patterns may match short names if they exist; Windows only. */
"\n"/*  */
"  def self.glob(pattern, _flags = 0, flags: _flags, base: nil, sort: true)\n"
"    Primitive.attr! :use_block\n"
"    Primitive.dir_s_glob(pattern, flags, base, sort)\n"
"  end\n"
"end\n"
"\n"
"class << File\n"
"\n"/* call-seq: */
"\n"/*    File.fnmatch( pattern, path, [flags] ) -> (true or false) */
"\n"/*    File.fnmatch?( pattern, path, [flags] ) -> (true or false) */
"\n"/*  */
"\n"/* Returns true if +path+ matches against +pattern+.  The pattern is not a */
"\n"/* regular expression; instead it follows rules similar to shell filename */
"\n"/* globbing.  It may contain the following metacharacters: */
"\n"/*  */
"\n"/* <code>*</code>:: */
"\n"/*   Matches any file. Can be restricted by other values in the glob. */
"\n"/*   Equivalent to <code>/.*\/x</code> in regexp. */
"\n"/*  */
"\n"/*   <code>*</code>::    Matches all regular files */
"\n"/*   <code>c*</code>::   Matches all files beginning with <code>c</code> */
"\n"/*   <code>*c</code>::   Matches all files ending with <code>c</code> */
"\n"/*   <code>\\*c*</code>:: Matches all files that have <code>c</code> in them */
"\n"/*                       (including at the beginning or end). */
"\n"/*  */
"\n"/*   To match hidden files (that start with a <code>.</code>) set the */
"\n"/*   File::FNM_DOTMATCH flag. */
"\n"/*  */
"\n"/* <code>**</code>:: */
"\n"/*   Matches directories recursively or files expansively. */
"\n"/*  */
"\n"/* <code>?</code>:: */
"\n"/*   Matches any one character. Equivalent to <code>/.{1}/</code> in regexp. */
"\n"/*  */
"\n"/* <code>[set]</code>:: */
"\n"/*   Matches any one character in +set+.  Behaves exactly like character sets */
"\n"/*   in Regexp, including set negation (<code>[^a-z]</code>). */
"\n"/*  */
"\n"/* <code>\\\\</code>:: */
"\n"/*   Escapes the next metacharacter. */
"\n"/*  */
"\n"/* <code>{a,b}</code>:: */
"\n"/*   Matches pattern a and pattern b if File::FNM_EXTGLOB flag is enabled. */
"\n"/*   Behaves like a Regexp union (<code>(?:a|b)</code>). */
"\n"/*  */
"\n"/* +flags+ is a bitwise OR of the <code>FNM_XXX</code> constants. The same */
"\n"/* glob pattern and flags are used by Dir::glob. */
"\n"/*  */
"\n"/* Examples: */
"\n"/*  */
"\n"/*    File.fnmatch('cat',       'cat')        #=> true  # match entire string */
"\n"/*    File.fnmatch('cat',       'category')   #=> false # only match partial string */
"\n"/*  */
"\n"/*    File.fnmatch('c{at,ub}s', 'cats')                    #=> false # { } isn't supported by default */
"\n"/*    File.fnmatch('c{at,ub}s', 'cats', File::FNM_EXTGLOB) #=> true  # { } is supported on FNM_EXTGLOB */
"\n"/*  */
"\n"/*    File.fnmatch('c?t',     'cat')          #=> true  # '?' match only 1 character */
"\n"/*    File.fnmatch('c??t',    'cat')          #=> false # ditto */
"\n"/*    File.fnmatch('c*',      'cats')         #=> true  # '*' match 0 or more characters */
"\n"/*    File.fnmatch('c*t',     'c/a/b/t')      #=> true  # ditto */
"\n"/*    File.fnmatch('ca[a-z]', 'cat')          #=> true  # inclusive bracket expression */
"\n"/*    File.fnmatch('ca[^t]',  'cat')          #=> false # exclusive bracket expression ('^' or '!') */
"\n"/*  */
"\n"/*    File.fnmatch('cat', 'CAT')                     #=> false # case sensitive */
"\n"/*    File.fnmatch('cat', 'CAT', File::FNM_CASEFOLD) #=> true  # case insensitive */
"\n"/*    File.fnmatch('cat', 'CAT', File::FNM_SYSCASE)  #=> true or false # depends on the system default */
"\n"/*  */
"\n"/*    File.fnmatch('?',   '/', File::FNM_PATHNAME)  #=> false # wildcard doesn't match '/' on FNM_PATHNAME */
"\n"/*    File.fnmatch('*',   '/', File::FNM_PATHNAME)  #=> false # ditto */
"\n"/*    File.fnmatch('[/]', '/', File::FNM_PATHNAME)  #=> false # ditto */
"\n"/*  */
"\n"/*    File.fnmatch('\\?',   '?')                       #=> true  # escaped wildcard becomes ordinary */
"\n"/*    File.fnmatch('\\a',   'a')                       #=> true  # escaped ordinary remains ordinary */
"\n"/*    File.fnmatch('\\a',   '\\a', File::FNM_NOESCAPE)  #=> true  # FNM_NOESCAPE makes '\\' ordinary */
"\n"/*    File.fnmatch('[\\?]', '?')                       #=> true  # can escape inside bracket expression */
"\n"/*  */
"\n"/*    File.fnmatch('*',   '.profile')                      #=> false # wildcard doesn't match leading */
"\n"/*    File.fnmatch('*',   '.profile', File::FNM_DOTMATCH)  #=> true  # period by default. */
"\n"/*    File.fnmatch('.*',  '.profile')                      #=> true */
"\n"/*  */
"\n"/*    File.fnmatch('**\/\*.rb', 'main.rb')                  #=> false */
"\n"/*    File.fnmatch('**\/\*.rb', './main.rb')                #=> false */
"\n"/*    File.fnmatch('**\/\*.rb', 'lib/song.rb')              #=> true */
"\n"/*    File.fnmatch('**.rb', 'main.rb')                    #=> true */
"\n"/*    File.fnmatch('**.rb', './main.rb')                  #=> false */
"\n"/*    File.fnmatch('**.rb', 'lib/song.rb')                #=> true */
"\n"/*    File.fnmatch('*',     'dave/.profile')              #=> true */
"\n"/*  */
"\n"/*    File.fnmatch('**\/foo', 'a/b/c/foo', File::FNM_PATHNAME)     #=> true */
"\n"/*    File.fnmatch('**\/foo', '/a/b/c/foo', File::FNM_PATHNAME)    #=> true */
"\n"/*    File.fnmatch('**\/foo', 'c:/a/b/c/foo', File::FNM_PATHNAME)  #=> true */
"\n"/*    File.fnmatch('**\/foo', 'a/.b/c/foo', File::FNM_PATHNAME)    #=> false */
"\n"/*    File.fnmatch('**\/foo', 'a/.b/c/foo', File::FNM_PATHNAME | File::FNM_DOTMATCH) #=> true */
"  def fnmatch(pattern, path, flags = 0)\n"
"  end\n"
"  alias fnmatch? fnmatch\n"
"end if false\n"
#line 888 "miniprelude.c"
};

static const char prelude_name2[] = "<internal:gc>";
static const struct {
    char L0[498]; /* 1..73 */
    char L73[505]; /* 74..248 */
    char L248[493]; /* 249..330 */
    char L330[489]; /* 331..360 */
    char L360[443]; /* 361..384 */
} prelude_code2 = {
#line 1 "gc.rb"
""/* for gc.c */
""
""/*  The \\GC module provides an interface to Ruby's mark-and-sweep garbage collection mechanism. */
""/*  */
""/*  Some of the underlying methods are also available via the ObjectSpace module. */
""/*  */
""/*  You may obtain information about the operation of the \\GC through GC::Profiler. */
"module GC\n"
"\n"
"\n"/* Initiates garbage collection, even if manually disabled. */
"\n"/*  */
"\n"/* The +full_mark+ keyword argument determines whether or not to perform a */
"\n"/* major garbage collection cycle. When set to +true+, a major garbage */
"\n"/* collection cycle is run, meaning all objects are marked. When set to */
"\n"/* +false+, a minor garbage collection cycle is run, meaning only young */
"\n"/* objects are marked. */
"\n"/*  */
"\n"/* The +immediate_mark+ keyword argument determines whether or not to perform */
"\n"/* incremental marking. When set to +true+, marking is completed during the */
"\n"/* call to this method. When set to +false+, marking is performed in steps */
"\n"/* that are interleaved with future Ruby code execution, so marking might not */
"\n"/* be completed during this method call. Note that if +full_mark+ is +false+, */
"\n"/* then marking will always be immediate, regardless of the value of */
"\n"/* +immediate_mark+. */
"\n"/*  */
"\n"/* The +immediate_sweep+ keyword argument determines whether or not to defer */
"\n"/* sweeping (using lazy sweep). When set to +false+, sweeping is performed in */
"\n"/* steps that are interleaved with future Ruby code execution, so sweeping might */
"\n"/* not be completed during this method call. When set to +true+, sweeping is */
"\n"/* completed during the call to this method. */
"\n"/*  */
"\n"/* Note: These keyword arguments are implementation and version-dependent. They */
"\n"/* are not guaranteed to be future-compatible and may be ignored if the */
"\n"/* underlying implementation does not support them. */
"  def self.start full_mark: true, immediate_mark: true, immediate_sweep: true\n"
"    Primitive.gc_start_internal full_mark, immediate_mark, immediate_sweep, false\n"
"  end\n"
"\n"
"\n"/* Alias of GC.start */
"  def garbage_collect full_mark: true, immediate_mark: true, immediate_sweep: true\n"
"    Primitive.gc_start_internal full_mark, immediate_mark, immediate_sweep, false\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    GC.enable -> true or false */
"\n"/*  */
"\n"/* Enables garbage collection, returning +true+ if garbage */
"\n"/* collection was previously disabled. */
"\n"/*  */
"\n"/*    GC.disable   #=> false */
"\n"/*    GC.enable    #=> true */
"\n"/*    GC.enable    #=> false */
"\n"/*  */
"  def self.enable\n"
"    Primitive.gc_enable\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    GC.disable -> true or false */
"\n"/*  */
"\n"/* Disables garbage collection, returning +true+ if garbage */
"\n"/* collection was already disabled. */
"\n"/*  */
"\n"/*    GC.disable   #=> false */
"\n"/*    GC.disable   #=> true */
"  def self.disable\n"
"    Primitive.gc_disable\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*   GC.stress -> integer, true, or false */
"\n"/*  */
"\n"/* Returns the current status of \\GC stress mode. */
,
#line 74 "gc.rb"
"  def self.stress\n"
"    Primitive.gc_stress_get\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*   GC.stress = flag -> flag */
"\n"/*  */
"\n"/* Updates the \\GC stress mode. */
"\n"/*  */
"\n"/* When stress mode is enabled, the \\GC is invoked at every \\GC opportunity: */
"\n"/* all memory and object allocations. */
"\n"/*  */
"\n"/* Enabling stress mode will degrade performance; it is only for debugging. */
"\n"/*  */
"\n"/* The flag can be true, false, or an integer bitwise-ORed with the following flags: */
"\n"/*   0x01:: no major GC */
"\n"/*   0x02:: no immediate sweep */
"\n"/*   0x04:: full mark after malloc/calloc/realloc */
"  def self.stress=(flag)\n"
"    Primitive.gc_stress_set_m flag\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    GC.count -> Integer */
"\n"/*  */
"\n"/* Returns the number of times \\GC has occurred since the process started. */
"  def self.count\n"
"    Primitive.gc_count\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    GC.stat -> Hash */
"\n"/*    GC.stat(hash) -> Hash */
"\n"/*    GC.stat(:key) -> Numeric */
"\n"/*  */
"\n"/* Returns a Hash containing information about the \\GC. */
"\n"/*  */
"\n"/* The contents of the hash are implementation-specific and may change in */
"\n"/* the future without notice. */
"\n"/*  */
"\n"/* The hash includes internal statistics about \\GC such as: */
"\n"/*  */
"\n"/* [count] */
"\n"/*   The total number of garbage collections run since application start */
"\n"/*   (count includes both minor and major garbage collections) */
"\n"/* [time] */
"\n"/*   The total time spent in garbage collections (in milliseconds) */
"\n"/* [heap_allocated_pages] */
"\n"/*   The total number of +:heap_eden_pages+ + +:heap_tomb_pages+ */
"\n"/* [heap_sorted_length] */
"\n"/*   The number of pages that can fit into the buffer that holds references to */
"\n"/*   all pages */
"\n"/* [heap_allocatable_pages] */
"\n"/*   The total number of pages the application could allocate without additional \\GC */
"\n"/* [heap_available_slots] */
"\n"/*   The total number of slots in all +:heap_allocated_pages+ */
"\n"/* [heap_live_slots] */
"\n"/*   The total number of slots which contain live objects */
"\n"/* [heap_free_slots] */
"\n"/*   The total number of slots which do not contain live objects */
"\n"/* [heap_final_slots] */
"\n"/*   The total number of slots with pending finalizers to be run */
"\n"/* [heap_marked_slots] */
"\n"/*   The total number of objects marked in the last \\GC */
"\n"/* [heap_eden_pages] */
"\n"/*   The total number of pages which contain at least one live slot */
"\n"/* [heap_tomb_pages] */
"\n"/*   The total number of pages which do not contain any live slots */
"\n"/* [total_allocated_pages] */
"\n"/*   The cumulative number of pages allocated since application start */
"\n"/* [total_freed_pages] */
"\n"/*   The cumulative number of pages freed since application start */
"\n"/* [total_allocated_objects] */
"\n"/*   The cumulative number of objects allocated since application start */
"\n"/* [total_freed_objects] */
"\n"/*   The cumulative number of objects freed since application start */
"\n"/* [malloc_increase_bytes] */
"\n"/*   Amount of memory allocated on the heap for objects. Decreased by any \\GC */
"\n"/* [malloc_increase_bytes_limit] */
"\n"/*   When +:malloc_increase_bytes+ crosses this limit, \\GC is triggered */
"\n"/* [minor_gc_count] */
"\n"/*   The total number of minor garbage collections run since process start */
"\n"/* [major_gc_count] */
"\n"/*   The total number of major garbage collections run since process start */
"\n"/* [compact_count] */
"\n"/*   The total number of compactions run since process start */
"\n"/* [read_barrier_faults] */
"\n"/*   The total number of times the read barrier was triggered during */
"\n"/*   compaction */
"\n"/* [total_moved_objects] */
"\n"/*   The total number of objects compaction has moved */
"\n"/* [remembered_wb_unprotected_objects] */
"\n"/*   The total number of objects without write barriers */
"\n"/* [remembered_wb_unprotected_objects_limit] */
"\n"/*   When +:remembered_wb_unprotected_objects+ crosses this limit, */
"\n"/*   major \\GC is triggered */
"\n"/* [old_objects] */
"\n"/*   Number of live, old objects which have survived at least 3 garbage collections */
"\n"/* [old_objects_limit] */
"\n"/*   When +:old_objects+ crosses this limit, major \\GC is triggered */
"\n"/* [oldmalloc_increase_bytes] */
"\n"/*   Amount of memory allocated on the heap for objects. Decreased by major \\GC */
"\n"/* [oldmalloc_increase_bytes_limit] */
"\n"/*   When +:oldmalloc_increase_bytes+ crosses this limit, major \\GC is triggered */
"\n"/*  */
"\n"/* If the optional argument, hash, is given, */
"\n"/* it is overwritten and returned. */
"\n"/* This is intended to avoid the probe effect. */
"\n"/*  */
"\n"/* This method is only expected to work on CRuby. */
"  def self.stat hash_or_key = nil\n"
"    Primitive.gc_stat hash_or_key\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    GC.stat_heap -> Hash */
"\n"/*    GC.stat_heap(nil, hash) -> Hash */
"\n"/*    GC.stat_heap(heap_name) -> Hash */
"\n"/*    GC.stat_heap(heap_name, hash) -> Hash */
"\n"/*    GC.stat_heap(heap_name, :key) -> Numeric */
"\n"/*  */
"\n"/* Returns information for heaps in the \\GC. */
"\n"/*  */
"\n"/* If the first optional argument, +heap_name+, is passed in and not +nil+, it */
"\n"/* returns a +Hash+ containing information about the particular heap. */
"\n"/* Otherwise, it will return a +Hash+ with heap names as keys and */
"\n"/* a +Hash+ containing information about the heap as values. */
"\n"/*  */
"\n"/* If the second optional argument, +hash_or_key+, is given as a +Hash+, it will */
"\n"/* be overwritten and returned. This is intended to avoid the probe effect. */
"\n"/*  */
"\n"/* If both optional arguments are passed in and the second optional argument is */
"\n"/* a symbol, it will return a +Numeric+ value for the particular heap. */
"\n"/*  */
"\n"/* On CRuby, +heap_name+ is of the type +Integer+ but may be of type +String+ */
"\n"/* on other implementations. */
"\n"/*  */
"\n"/* The contents of the hash are implementation-specific and may change in */
"\n"/* the future without notice. */
"\n"/*  */
"\n"/* If the optional argument, hash, is given, it is overwritten and returned. */
"\n"/*  */
"\n"/* This method is only expected to work on CRuby. */
"\n"/*  */
"\n"/* The hash includes the following keys about the internal information in */
"\n"/* the \\GC: */
"\n"/*  */
"\n"/* [slot_size] */
"\n"/*   The slot size of the heap in bytes. */
"\n"/* [heap_allocatable_pages] */
"\n"/*   The number of pages that can be allocated without triggering a new */
"\n"/*   garbage collection cycle. */
"\n"/* [heap_eden_pages] */
"\n"/*   The number of pages in the eden heap. */
"\n"/* [heap_eden_slots] */
"\n"/*   The total number of slots in all of the pages in the eden heap. */
"\n"/* [heap_tomb_pages] */
"\n"/*   The number of pages in the tomb heap. The tomb heap only contains pages */
"\n"/*   that do not have any live objects. */
"\n"/* [heap_tomb_slots] */
"\n"/*   The total number of slots in all of the pages in the tomb heap. */
"\n"/* [total_allocated_pages] */
"\n"/*   The total number of pages that have been allocated in the heap. */
"\n"/* [total_freed_pages] */
"\n"/*   The total number of pages that have been freed and released back to the */
"\n"/*   system in the heap. */
"\n"/* [force_major_gc_count] */
"\n"/*   The number of times this heap has forced major garbage collection cycles */
"\n"/*   to start due to running out of free slots. */
"\n"/* [force_incremental_marking_finish_count] */
"\n"/*   The number of times this heap has forced incremental marking to complete */
"\n"/*   due to running out of pooled slots. */
"\n"/*  */
"  def self.stat_heap heap_name = nil, hash_or_key = nil\n"
"    Primitive.gc_stat_heap heap_name, hash_or_key\n"
,
#line 249 "gc.rb"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*     GC.config -> hash */
"\n"/*     GC.config(hash) -> hash */
"\n"/*  */
"\n"/* Sets or gets information about the current \\GC config. */
"\n"/*  */
"\n"/* Configuration parameters are \\GC implementation-specific and may change */
"\n"/* without notice. */
"\n"/*  */
"\n"/* This method can be called without parameters to retrieve the current config. */
"\n"/*  */
"\n"/* This method can also be called with a +Hash+ argument to assign values to */
"\n"/* valid config keys. Config keys missing from the passed +Hash+ will be left */
"\n"/* unmodified. */
"\n"/*  */
"\n"/* If a key/value pair is passed to this function that does not correspond to */
"\n"/* a valid config key for the \\GC implementation being used, no config will be */
"\n"/* updated, the key will be present in the returned Hash, and its value will */
"\n"/* be +nil+. This is to facilitate easy migration between \\GC implementations. */
"\n"/*  */
"\n"/* In both call-seqs, the return value of <code>GC.config</code> will be a +Hash+ */
"\n"/* containing the most recent full configuration, i.e., all keys and values */
"\n"/* defined by the specific \\GC implementation being used. In the case of a */
"\n"/* config update, the return value will include the new values being updated. */
"\n"/*  */
"\n"/* This method is only expected to work on CRuby. */
"\n"/*  */
"\n"/* Valid config keys for Ruby's default \\GC implementation are: */
"\n"/*  */
"\n"/* [rgengc_allow_full_mark] */
"\n"/*   Controls whether the \\GC is allowed to run a full mark (young & old objects). */
"\n"/*  */
"\n"/*   When +true+, \\GC interleaves major and minor collections. This is the default. \\GC */
"\n"/*   will function as intended. */
"\n"/*  */
"\n"/*   When +false+, the \\GC will never trigger a full marking cycle unless */
"\n"/*   explicitly requested by user code. Instead, only a minor mark will run\xE2\x80\x94 */
"\n"/*   only young objects will be marked. When the heap space is exhausted, new */
"\n"/*   pages will be allocated immediately instead of running a full mark. */
"\n"/*  */
"\n"/*   A flag will be set to notify that a full mark has been */
"\n"/*   requested. This flag is accessible using */
"\n"/*   <code>GC.latest_gc_info(:needs_major_by)</code> */
"\n"/*  */
"\n"/*   The user can trigger a major collection at any time using */
"\n"/*   <code>GC.start(full_mark: true)</code> */
"\n"/*  */
"\n"/*   When +false+, Young to Old object promotion is disabled. For performance */
"\n"/*   reasons, it is recommended to warm up an application using +Process.warmup+ */
"\n"/*   before setting this parameter to +false+. */
"  def self.config hash = nil\n"
"    return Primitive.gc_config_get unless hash\n"
"\n"
"    if(Primitive.cexpr!(\"RBOOL(RB_TYPE_P(hash, T_HASH))\"))\n"
"      if hash.include?(:implementation)\n"
"        raise ArgumentError, 'Attempting to set read-only key \"Implementation\"'\n"
"      end\n"
"\n"
"      Primitive.gc_config_set hash\n"
"    else\n"
"      raise ArgumentError\n"
"    end\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*     GC.latest_gc_info -> hash */
"\n"/*     GC.latest_gc_info(hash) -> hash */
"\n"/*     GC.latest_gc_info(key) -> value */
"\n"/*  */
"\n"/* Returns information about the most recent garbage collection. */
"\n"/*  */
"\n"/* If the argument +hash+ is given and is a Hash object, */
"\n"/* it is overwritten and returned. */
"\n"/* This is intended to avoid the probe effect. */
"\n"/*  */
"\n"/* If the argument +key+ is given and is a Symbol object, */
"\n"/* it returns the value associated with the key. */
"\n"/* This is equivalent to <tt>GC.latest_gc_info[key]</tt>. */
"  def self.latest_gc_info hash_or_key = nil\n"
"    if hash_or_key == nil\n"
,
#line 331 "gc.rb"
"      hash_or_key = {}\n"
"    elsif Primitive.cexpr!(\"RBOOL(!SYMBOL_P(hash_or_key) && !RB_TYPE_P(hash_or_key, T_HASH))\")\n"
"      raise TypeError, \"non-hash or symbol given\"\n"
"    end\n"
"\n"
"    Primitive.cstmt! %{\n"
"      return rb_gc_latest_gc_info(hash_or_key);\n"
"    }\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    GC.measure_total_time = true/false */
"\n"/*  */
"\n"/* Enables measuring \\GC time. */
"\n"/* You can get the result with <tt>GC.stat(:time)</tt>. */
"\n"/* Note that \\GC time measurement can cause some performance overhead. */
"  def self.measure_total_time=(flag)\n"
"    Primitive.cstmt! %{\n"
"      rb_gc_impl_set_measure_total_time(rb_gc_get_objspace(), flag);\n"
"      return flag;\n"
"    }\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    GC.measure_total_time -> true/false */
"\n"/*  */
"\n"/* Returns the measure_total_time flag (default: +true+). */
"\n"/* Note that measurement can affect the application's performance. */
"  def self.measure_total_time\n"
"    Primitive.cexpr! %{\n"
,
#line 361 "gc.rb"
"      RBOOL(rb_gc_impl_get_measure_total_time(rb_gc_get_objspace()))\n"
"    }\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    GC.total_time -> int */
"\n"/*  */
"\n"/* Returns the measured \\GC total time in nanoseconds. */
"  def self.total_time\n"
"    Primitive.cexpr! %{\n"
"      ULL2NUM(rb_gc_impl_get_total_time(rb_gc_get_objspace()))\n"
"    }\n"
"  end\n"
"end\n"
"\n"
"module ObjectSpace\n"
"\n"/* Alias of GC.start */
"  def garbage_collect full_mark: true, immediate_mark: true, immediate_sweep: true\n"
"    Primitive.gc_start_internal full_mark, immediate_mark, immediate_sweep, false\n"
"  end\n"
"\n"
"  module_function :garbage_collect\n"
"end\n"
#line 1291 "miniprelude.c"
};

static const char prelude_name3[] = "<internal:numeric>";
static const struct {
    char L0[502]; /* 1..118 */
    char L118[496]; /* 119..208 */
    char L208[501]; /* 209..282 */
    char L282[503]; /* 283..335 */
    char L335[504]; /* 336..391 */
    char L391[227]; /* 392..413 */
} prelude_code3 = {
#line 1 "numeric.rb"
"class Numeric\n"
"\n"/*  call-seq: */
"\n"/*    dup -> self */
"\n"/*  */
"\n"/*  Returns +self+. */
"\n"/*  */
"\n"/*  Related: Numeric#clone. */
"\n"/*  */
"  def dup\n"
"    self\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*    real? -> true or false */
"\n"/*  */
"\n"/*  Returns +true+ if +self+ is a real number (i.e. not Complex). */
"\n"/*  */
"  def real?\n"
"    true\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*   real -> self */
"\n"/*  */
"\n"/* Returns +self+. */
"\n"/*  */
"  def real\n"
"    self\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*    integer? -> true or false */
"\n"/*  */
"\n"/*  Returns +true+ if +self+ is an Integer. */
"\n"/*  */
"\n"/*    1.0.integer? # => false */
"\n"/*    1.integer?   # => true */
"\n"/*  */
"  def integer?\n"
"    false\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*    finite? -> true or false */
"\n"/*  */
"\n"/*  Returns +true+ if +self+ is a finite number, +false+ otherwise. */
"\n"/*  */
"  def finite?\n"
"    true\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*    infinite? -> -1, 1, or nil */
"\n"/*  */
"\n"/*  Returns +nil+, -1, or 1 depending on whether +self+ is */
"\n"/*  finite, <tt>-Infinity</tt>, or <tt>+Infinity</tt>. */
"\n"/*  */
"  def infinite?\n"
"    nil\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*   imag -> 0 */
"\n"/*  */
"\n"/* Returns zero. */
"\n"/*  */
"  def imaginary\n"
"    0\n"
"  end\n"
"\n"
"  alias imag imaginary\n"
"\n"
"\n"/* call-seq: */
"\n"/*   conj -> self */
"\n"/*  */
"\n"/* Returns +self+. */
"\n"/*  */
"  def conjugate\n"
"    self\n"
"  end\n"
"\n"
"  alias conj conjugate\n"
"\n"
"\n"/*  call-seq: */
"\n"/*    +self -> self */
"\n"/*  */
"\n"/*  Returns +self+. */
"\n"/*  */
"  def +@\n"
"    self\n"
"  end\n"
"end\n"
"\n"
"class Integer\n"
"\n"/* call-seq: */
"\n"/*    -int -> integer */
"\n"/*  */
"\n"/* Returns +self+, negated. */
"  def -@\n"
"    Primitive.attr! :leaf\n"
"    Primitive.cexpr! 'rb_int_uminus(self)'\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*   ~int -> integer */
"\n"/*  */
"\n"/* One's complement: */
"\n"/* returns the value of +self+ with each bit inverted. */
"\n"/*  */
"\n"/* Because an integer value is conceptually of infinite length, */
"\n"/* the result acts as if it had an infinite number of */
"\n"/* one bits to the left. */
"\n"/* In hex representations, this is displayed */
"\n"/* as two periods to the left of the digits: */
"\n"/*  */
"\n"/*   sprintf(\"%X\", ~0x1122334455)    # => \"..FEEDDCCBBAA\" */
"\n"/*  */
"  def ~\n"
,
#line 119 "numeric.rb"
"    Primitive.attr! :leaf\n"
"    Primitive.cexpr! 'rb_int_comp(self)'\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*   abs -> integer */
"\n"/*  */
"\n"/* Returns the absolute value of +self+. */
"\n"/*  */
"\n"/*   (-12345).abs # => 12345 */
"\n"/*   -12345.abs   # => 12345 */
"\n"/*   12345.abs    # => 12345 */
"\n"/*  */
"  def abs\n"
"    Primitive.attr! :leaf\n"
"    Primitive.cexpr! 'rb_int_abs(self)'\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*   bit_length -> integer */
"\n"/*  */
"\n"/* Returns the number of bits of the value of +self+, */
"\n"/* which is the bit position of the highest-order bit */
"\n"/* that is different from the sign bit */
"\n"/* (where the least significant bit has bit position 1). */
"\n"/* If there is no such bit (zero or minus one), returns zero. */
"\n"/*  */
"\n"/* This method returns <tt>ceil(log2(self < 0 ? -self : self + 1))</tt>>. */
"\n"/*  */
"\n"/*   (-2**1000-1).bit_length   # => 1001 */
"\n"/*   (-2**1000).bit_length     # => 1000 */
"\n"/*   (-2**1000+1).bit_length   # => 1000 */
"\n"/*   (-2**12-1).bit_length     # => 13 */
"\n"/*   (-2**12).bit_length       # => 12 */
"\n"/*   (-2**12+1).bit_length     # => 12 */
"\n"/*   -0x101.bit_length         # => 9 */
"\n"/*   -0x100.bit_length         # => 8 */
"\n"/*   -0xff.bit_length          # => 8 */
"\n"/*   -2.bit_length             # => 1 */
"\n"/*   -1.bit_length             # => 0 */
"\n"/*   0.bit_length              # => 0 */
"\n"/*   1.bit_length              # => 1 */
"\n"/*   0xff.bit_length           # => 8 */
"\n"/*   0x100.bit_length          # => 9 */
"\n"/*   (2**12-1).bit_length      # => 12 */
"\n"/*   (2**12).bit_length        # => 13 */
"\n"/*   (2**12+1).bit_length      # => 13 */
"\n"/*   (2**1000-1).bit_length    # => 1000 */
"\n"/*   (2**1000).bit_length      # => 1001 */
"\n"/*   (2**1000+1).bit_length    # => 1001 */
"\n"/*  */
"\n"/* For \\Integer _n_, */
"\n"/* this method can be used to detect overflow in Array#pack: */
"\n"/*  */
"\n"/*   if n.bit_length < 32 */
"\n"/*     [n].pack('l') # No overflow. */
"\n"/*   else */
"\n"/*     raise 'Overflow' */
"\n"/*   end */
"\n"/*  */
"  def bit_length\n"
"    Primitive.attr! :leaf\n"
"    Primitive.cexpr! 'rb_int_bit_length(self)'\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*    even? -> true or false */
"\n"/*  */
"\n"/*  Returns +true+ if +self+ is an even number, +false+ otherwise. */
"  def even?\n"
"    Primitive.attr! :leaf\n"
"    Primitive.cexpr! 'rb_int_even_p(self)'\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*    integer? -> true */
"\n"/*  */
"\n"/*  Since +self+ is already an \\Integer, always returns +true+. */
"  def integer?\n"
"    true\n"
"  end\n"
"\n"
"  alias magnitude abs\n"
"\n"
"\n"/*  call-seq: */
"\n"/*    odd? -> true or false */
"\n"/*  */
"\n"/*  Returns +true+ if +self+ is an odd number, +false+ otherwise. */
"  def odd?\n"
"    Primitive.attr! :leaf\n"
,
#line 209 "numeric.rb"
"    Primitive.cexpr! 'rb_int_odd_p(self)'\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*    ord -> self */
"\n"/*  */
"\n"/*  Returns +self+; */
"\n"/*  intended for compatibility to character literals in Ruby 1.9. */
"  def ord\n"
"    self\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*    size -> integer */
"\n"/*  */
"\n"/*  Returns the number of bytes in the machine representation of +self+; */
"\n"/*  the value is system-dependent: */
"\n"/*  */
"\n"/*    1.size             # => 8 */
"\n"/*    -1.size            # => 8 */
"\n"/*    2147483647.size    # => 8 */
"\n"/*    (256**10 - 1).size # => 10 */
"\n"/*    (256**20 - 1).size # => 20 */
"\n"/*    (256**40 - 1).size # => 40 */
"\n"/*  */
"  def size\n"
"    Primitive.attr! :leaf\n"
"    Primitive.cexpr! 'rb_int_size(self)'\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*   times {|i| ... } -> self */
"\n"/*   times            -> enumerator */
"\n"/*  */
"\n"/* Calls the given block +self+ times with each integer in <tt>(0..self-1)</tt>: */
"\n"/*  */
"\n"/*   a = [] */
"\n"/*   5.times {|i| a.push(i) } # => 5 */
"\n"/*   a                        # => [0, 1, 2, 3, 4] */
"\n"/*  */
"\n"/* With no block given, returns an Enumerator. */
"  def times\n"
"    Primitive.attr! :inline_block\n"
"    unless defined?(yield)\n"
"      return Primitive.cexpr! 'SIZED_ENUMERATOR(self, 0, 0, int_dotimes_size)'\n"
"    end\n"
"    i = 0\n"
"    while i < self\n"
"      yield i\n"
"      i = i.succ\n"
"    end\n"
"    self\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*    to_i -> self */
"\n"/*  */
"\n"/*  Returns +self+ (which is already an \\Integer). */
"  def to_i\n"
"    self\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*    to_int -> self */
"\n"/*  */
"\n"/*  Returns +self+ (which is already an \\Integer). */
"  def to_int\n"
"    self\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*   zero? -> true or false */
"\n"/*  */
"\n"/* Returns +true+ if +self+ has a zero value, +false+ otherwise. */
,
#line 283 "numeric.rb"
"  def zero?\n"
"    Primitive.attr! :leaf\n"
"    Primitive.cexpr! 'rb_int_zero_p(self)'\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*    ceildiv(numeric) -> integer */
"\n"/*  */
"\n"/*  Returns the result of division +self+ by +numeric+. */
"\n"/*  rounded up to the nearest integer. */
"\n"/*  */
"\n"/*    3.ceildiv(3)   # => 1 */
"\n"/*    4.ceildiv(3)   # => 2 */
"\n"/*  */
"\n"/*    4.ceildiv(-3)  # => -1 */
"\n"/*    -4.ceildiv(3)  # => -1 */
"\n"/*    -4.ceildiv(-3) # => 2 */
"\n"/*  */
"\n"/*    3.ceildiv(1.2) # => 3 */
"\n"/*  */
"  def ceildiv(other)\n"
"    -div(0 - other)\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/* call-seq: */
"\n"/*   numerator -> self */
"\n"/*  */
"\n"/* Returns +self+. */
"\n"/*  */
"  def numerator\n"
"    self\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*   denominator -> 1 */
"\n"/*  */
"\n"/* Returns +1+. */
"  def denominator\n"
"    1\n"
"  end\n"
"\n"
"  with_yjit do\n"
"    if Primitive.rb_builtin_basic_definition_p(:downto)\n"
"      undef :downto\n"
"\n"
"      def downto(to)\n"/* :nodoc: */
"        Primitive.attr! :inline_block, :c_trace\n"
"\n"
"\n"/* When no block is given, return an Enumerator that enumerates from `self` to `to`. */
"\n"/* Not using `block_given?` and `to_enum` to keep them unaffected by redefinitions. */
"        unless defined?(yield)\n"
"          return Primitive.cexpr! 'SIZED_ENUMERATOR(self, 1, &to, int_downto_size)'\n"
,
#line 336 "numeric.rb"
"        end\n"
"\n"
"        from = self\n"
"        while from >= to\n"
"          yield from\n"
"          from = from.pred\n"
"        end\n"
"        self\n"
"      end\n"
"    end\n"
"  end\n"
"end\n"
"\n"
"class Float\n"
"\n"
"\n"/* call-seq: */
"\n"/*   to_f -> self */
"\n"/*  */
"\n"/*  Returns +self+ (which is already a \\Float). */
"  def to_f\n"
"    self\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*    float.abs ->  float */
"\n"/*  */
"\n"/*  Returns the absolute value of +self+: */
"\n"/*  */
"\n"/*    (-34.56).abs # => 34.56 */
"\n"/*    -34.56.abs   # => 34.56 */
"\n"/*    34.56.abs    # => 34.56 */
"\n"/*  */
"  def abs\n"
"    Primitive.attr! :leaf\n"
"    Primitive.cexpr! 'rb_float_abs(self)'\n"
"  end\n"
"\n"
"  alias magnitude abs\n"
"\n"
"\n"/* call-seq: */
"\n"/*   -float -> float */
"\n"/*  */
"\n"/* Returns +self+, negated. */
"\n"/*  */
"  def -@\n"
"    Primitive.attr! :leaf\n"
"    Primitive.cexpr! 'rb_float_uminus(self)'\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*    zero? -> true or false */
"\n"/*  */
"\n"/*  Returns +true+ if +self+ is 0.0, +false+ otherwise. */
"  def zero?\n"
"    Primitive.attr! :leaf\n"
"    Primitive.cexpr! 'RBOOL(FLOAT_ZERO_P(self))'\n"
,
#line 392 "numeric.rb"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*    positive? -> true or false */
"\n"/*  */
"\n"/*  Returns +true+ if +self+ is greater than 0, +false+ otherwise. */
"  def positive?\n"
"    Primitive.attr! :leaf\n"
"    Primitive.cexpr! 'RBOOL(RFLOAT_VALUE(self) > 0.0)'\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*    negative? -> true or false */
"\n"/*  */
"\n"/*  Returns +true+ if +self+ is less than 0, +false+ otherwise. */
"  def negative?\n"
"    Primitive.attr! :leaf\n"
"    Primitive.cexpr! 'RBOOL(RFLOAT_VALUE(self) < 0.0)'\n"
"  end\n"
"\n"
"end\n"
#line 1726 "miniprelude.c"
};

static const char prelude_name4[] = "<internal:io>";
static const struct {
    char L0[449]; /* 1..137 */
} prelude_code4 = {
#line 1 "io.rb"
"class IO\n"
"\n"/* other IO methods are defined in io.c */
"\n"
"\n"/* call-seq: */
"\n"/*    ios.read_nonblock(maxlen [, options])              -> string */
"\n"/*    ios.read_nonblock(maxlen, outbuf [, options])      -> outbuf */
"\n"/*  */
"\n"/* Reads at most <i>maxlen</i> bytes from <em>ios</em> using */
"\n"/* the read(2) system call after O_NONBLOCK is set for */
"\n"/* the underlying file descriptor. */
"\n"/*  */
"\n"/* If the optional <i>outbuf</i> argument is present, */
"\n"/* it must reference a String, which will receive the data. */
"\n"/* The <i>outbuf</i> will contain only the received data after the method call */
"\n"/* even if it is not empty at the beginning. */
"\n"/*  */
"\n"/* read_nonblock just calls the read(2) system call. */
"\n"/* It causes all errors the read(2) system call causes: Errno::EWOULDBLOCK, Errno::EINTR, etc. */
"\n"/* The caller should care such errors. */
"\n"/*  */
"\n"/* If the exception is Errno::EWOULDBLOCK or Errno::EAGAIN, */
"\n"/* it is extended by IO::WaitReadable. */
"\n"/* So IO::WaitReadable can be used to rescue the exceptions for retrying */
"\n"/* read_nonblock. */
"\n"/*  */
"\n"/* read_nonblock causes EOFError on EOF. */
"\n"/*  */
"\n"/* On some platforms, such as Windows, non-blocking mode is not supported */
"\n"/* on IO objects other than sockets. In such cases, Errno::EBADF will */
"\n"/* be raised. */
"\n"/*  */
"\n"/* If the read byte buffer is not empty, */
"\n"/* read_nonblock reads from the buffer like readpartial. */
"\n"/* In this case, the read(2) system call is not called. */
"\n"/*  */
"\n"/* When read_nonblock raises an exception kind of IO::WaitReadable, */
"\n"/* read_nonblock should not be called */
"\n"/* until io is readable for avoiding busy loop. */
"\n"/* This can be done as follows. */
"\n"/*  */
"\n"/*   # emulates blocking read (readpartial). */
"\n"/*   begin */
"\n"/*     result = io.read_nonblock(maxlen) */
"\n"/*   rescue IO::WaitReadable */
"\n"/*     IO.select([io]) */
"\n"/*     retry */
"\n"/*   end */
"\n"/*  */
"\n"/* Although IO#read_nonblock doesn't raise IO::WaitWritable. */
"\n"/* OpenSSL::Buffering#read_nonblock can raise IO::WaitWritable. */
"\n"/* If IO and SSL should be used polymorphically, */
"\n"/* IO::WaitWritable should be rescued too. */
"\n"/* See the document of OpenSSL::Buffering#read_nonblock for sample code. */
"\n"/*  */
"\n"/* Note that this method is identical to readpartial */
"\n"/* except the non-blocking flag is set. */
"\n"/*  */
"\n"/* By specifying a keyword argument _exception_ to +false+, you can indicate */
"\n"/* that read_nonblock should not raise an IO::WaitReadable exception, but */
"\n"/* return the symbol +:wait_readable+ instead. At EOF, it will return nil */
"\n"/* instead of raising EOFError. */
"  def read_nonblock(len, buf = nil, exception: true)\n"
"    Primitive.io_read_nonblock(len, buf, exception)\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    ios.write_nonblock(string)   -> integer */
"\n"/*    ios.write_nonblock(string [, options])   -> integer */
"\n"/*  */
"\n"/* Writes the given string to <em>ios</em> using */
"\n"/* the write(2) system call after O_NONBLOCK is set for */
"\n"/* the underlying file descriptor. */
"\n"/*  */
"\n"/* It returns the number of bytes written. */
"\n"/*  */
"\n"/* write_nonblock just calls the write(2) system call. */
"\n"/* It causes all errors the write(2) system call causes: Errno::EWOULDBLOCK, Errno::EINTR, etc. */
"\n"/* The result may also be smaller than string.length (partial write). */
"\n"/* The caller should care such errors and partial write. */
"\n"/*  */
"\n"/* If the exception is Errno::EWOULDBLOCK or Errno::EAGAIN, */
"\n"/* it is extended by IO::WaitWritable. */
"\n"/* So IO::WaitWritable can be used to rescue the exceptions for retrying write_nonblock. */
"\n"/*  */
"\n"/*   # Creates a pipe. */
"\n"/*   r, w = IO.pipe */
"\n"/*  */
"\n"/*   # write_nonblock writes only 65536 bytes and return 65536. */
"\n"/*   # (The pipe size is 65536 bytes on this environment.) */
"\n"/*   s = \"a\" * 100000 */
"\n"/*   p w.write_nonblock(s)     #=> 65536 */
"\n"/*  */
"\n"/*   # write_nonblock cannot write a byte and raise EWOULDBLOCK (EAGAIN). */
"\n"/*   p w.write_nonblock(\"b\")   # Resource temporarily unavailable (Errno::EAGAIN) */
"\n"/*  */
"\n"/* If the write buffer is not empty, it is flushed at first. */
"\n"/*  */
"\n"/* When write_nonblock raises an exception kind of IO::WaitWritable, */
"\n"/* write_nonblock should not be called */
"\n"/* until io is writable for avoiding busy loop. */
"\n"/* This can be done as follows. */
"\n"/*  */
"\n"/*   begin */
"\n"/*     result = io.write_nonblock(string) */
"\n"/*   rescue IO::WaitWritable, Errno::EINTR */
"\n"/*     IO.select(nil, [io]) */
"\n"/*     retry */
"\n"/*   end */
"\n"/*  */
"\n"/* Note that this doesn't guarantee to write all data in string. */
"\n"/* The length written is reported as result and it should be checked later. */
"\n"/*  */
"\n"/* On some platforms such as Windows, write_nonblock is not supported */
"\n"/* according to the kind of the IO object. */
"\n"/* In such cases, write_nonblock raises <code>Errno::EBADF</code>. */
"\n"/*  */
"\n"/* By specifying a keyword argument _exception_ to +false+, you can indicate */
"\n"/* that write_nonblock should not raise an IO::WaitWritable exception, but */
"\n"/* return the symbol +:wait_writable+ instead. */
"  def write_nonblock(buf, exception: true)\n"
"    Primitive.io_write_nonblock(buf, exception)\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*   readline(sep = $/, chomp: false)   -> string */
"\n"/*   readline(limit, chomp: false)      -> string */
"\n"/*   readline(sep, limit, chomp: false) -> string */
"\n"/*  */
"\n"/* Reads a line as with IO#gets, but raises EOFError if already at end-of-stream. */
"\n"/*  */
"\n"/* Optional keyword argument +chomp+ specifies whether line separators */
"\n"/* are to be omitted. */
"  def readline(sep = $/, limit = nil, chomp: false)\n"
"    Primitive.io_readline(sep, limit, chomp)\n"
"  end\n"
"end\n"
#line 1870 "miniprelude.c"
};

static const char prelude_name5[] = "<internal:marshal>";
static const struct {
    char L0[202]; /* 1..41 */
} prelude_code5 = {
#line 1 "marshal.rb"
"module Marshal\n"
"\n"/* call-seq: */
"\n"/*    load(source, proc = nil, freeze: false) -> obj */
"\n"/*    restore(source, proc = nil, freeze: false) -> obj */
"\n"/*  */
"\n"/* Returns the result of converting the serialized data in source into a */
"\n"/* Ruby object (possibly with associated subordinate objects). source */
"\n"/* may be either an instance of IO or an object that responds to */
"\n"/* to_str. If proc is specified, each object will be passed to the proc, as the object */
"\n"/* is being deserialized. */
"\n"/*  */
"\n"/* Never pass untrusted data (including user supplied input) to this method. */
"\n"/* Please see the overview for further details. */
"\n"/*  */
"\n"/* If the <tt>freeze: true</tt> argument is passed, deserialized object would */
"\n"/* be deeply frozen. Note that it may lead to more efficient memory usage due to */
"\n"/* frozen strings deduplication: */
"\n"/*  */
"\n"/*    serialized = Marshal.dump(['value1', 'value2', 'value1', 'value2']) */
"\n"/*  */
"\n"/*    deserialized = Marshal.load(serialized) */
"\n"/*    deserialized.map(&:frozen?) */
"\n"/*    # => [false, false, false, false] */
"\n"/*    deserialized.map(&:object_id) */
"\n"/*    # => [1023900, 1023920, 1023940, 1023960] -- 4 different objects */
"\n"/*  */
"\n"/*    deserialized = Marshal.load(serialized, freeze: true) */
"\n"/*    deserialized.map(&:frozen?) */
"\n"/*    # => [true, true, true, true] */
"\n"/*    deserialized.map(&:object_id) */
"\n"/*    # => [1039360, 1039380, 1039360, 1039380] -- only 2 different objects, object_ids repeating */
"\n"/*  */
"  def self.load(source, proc = nil, freeze: false)\n"
"    Primitive.marshal_load(source, proc, freeze)\n"
"  end\n"
"\n"
"  class << self\n"
"    alias restore load\n"
"  end\n"
"end\n"
#line 1918 "miniprelude.c"
};

static const char prelude_name6[] = "<internal:rjit>";
static const struct {
    char L0[498]; /* 1..31 */
    char L31[197]; /* 32..42 */
} prelude_code6 = {
#line 1 "rjit.rb"
"module RubyVM::RJIT\n"
"\n"/* Return true if \\RJIT is enabled. */
"  def self.enabled?\n"
"    Primitive.cexpr! 'RBOOL(rb_rjit_enabled)'\n"
"  end\n"
"\n"
"\n"/* Start JIT compilation after \\--rjit-disable. */
"  def self.enable\n"
"    Primitive.cstmt! %{\n"
"      rb_rjit_call_p = true;\n"
"      return Qnil;\n"
"    }\n"
"  end\n"
"\n"
"  if Primitive.rjit_stats_enabled_p\n"
"    at_exit do\n"
"      Primitive.rjit_stop_stats\n"
"      print_stats\n"
"    end\n"
"  end\n"
"  if Primitive.rjit_trace_exits_enabled_p\n"
"    at_exit do\n"
"      Primitive.rjit_stop_stats\n"
"      dump_trace_exits\n"
"    end\n"
"  end\n"
"end\n"
"\n"
"if RubyVM::RJIT.enabled?\n"
"  begin\n"
"    require 'fiddle'\n"
,
#line 32 "rjit.rb"
"    require 'fiddle/import'\n"
"  rescue LoadError\n"
"    return\n"/* miniruby doesn't support RJIT */
"  end\n"
"\n"
"  require 'ruby_vm/rjit/c_type'\n"
"  require 'ruby_vm/rjit/compiler'\n"
"  require 'ruby_vm/rjit/hooks'\n"
"  require 'ruby_vm/rjit/stats'\n"
"end\n"
#line 1970 "miniprelude.c"
};

static const char prelude_name7[] = "<internal:rjit_c>";
static const struct {
    char L0[470]; /* 1..24 */
    char L24[506]; /* 25..45 */
    char L45[504]; /* 46..62 */
    char L62[499]; /* 63..78 */
    char L78[473]; /* 79..95 */
    char L95[480]; /* 96..109 */
    char L109[488]; /* 110..124 */
    char L124[478]; /* 125..144 */
    char L144[499]; /* 145..160 */
    char L160[474]; /* 161..175 */
    char L175[475]; /* 176..189 */
    char L189[470]; /* 190..201 */
    char L201[502]; /* 202..215 */
    char L215[499]; /* 216..232 */
    char L232[495]; /* 233..248 */
    char L248[488]; /* 249..271 */
    char L271[502]; /* 272..294 */
    char L294[413]; /* 295..311 */
    char L311[420]; /* 312..322 */
    char L322[487]; /* 323..345 */
    char L345[480]; /* 346..356 */
    char L356[456]; /* 357..364 */
    char L364[451]; /* 365..371 */
    char L371[490]; /* 372..377 */
    char L377[497]; /* 378..382 */
    char L382[445]; /* 383..387 */
    char L387[472]; /* 388..393 */
    char L393[458]; /* 394..399 */
    char L399[487]; /* 400..406 */
    char L406[495]; /* 407..413 */
    char L413[424]; /* 414..419 */
    char L419[456]; /* 420..425 */
    char L425[470]; /* 426..431 */
    char L431[498]; /* 432..437 */
    char L437[449]; /* 438..442 */
    char L442[506]; /* 443..448 */
    char L448[447]; /* 449..453 */
    char L453[499]; /* 454..460 */
    char L460[499]; /* 461..467 */
    char L467[486]; /* 468..475 */
    char L475[455]; /* 476..495 */
    char L495[508]; /* 496..515 */
    char L515[470]; /* 516..535 */
    char L535[455]; /* 536..555 */
    char L555[478]; /* 556..575 */
    char L575[473]; /* 576..595 */
    char L595[476]; /* 596..615 */
    char L615[507]; /* 616..635 */
    char L635[463]; /* 636..655 */
    char L655[487]; /* 656..675 */
    char L675[490]; /* 676..694 */
    char L694[452]; /* 695..711 */
    char L711[495]; /* 712..731 */
    char L731[505]; /* 732..750 */
    char L750[489]; /* 751..771 */
    char L771[499]; /* 772..779 */
    char L779[467]; /* 780..793 */
    char L793[492]; /* 794..804 */
    char L804[463]; /* 805..810 */
    char L810[477]; /* 811..821 */
    char L821[489]; /* 822..828 */
    char L828[493]; /* 829..840 */
    char L840[400]; /* 841..847 */
    char L847[504]; /* 848..860 */
    char L860[508]; /* 861..868 */
    char L868[408]; /* 869..872 */
    char L872[500]; /* 873..880 */
    char L880[457]; /* 881..888 */
    char L888[507]; /* 889..894 */
    char L894[496]; /* 895..910 */
    char L910[456]; /* 911..923 */
    char L923[379]; /* 924..926 */
    char L926[413]; /* 927..934 */
    char L934[461]; /* 935..942 */
    char L942[419]; /* 943..945 */
    char L945[446]; /* 946..953 */
    char L953[419]; /* 954..956 */
    char L956[459]; /* 957..965 */
    char L965[478]; /* 966..971 */
    char L971[442]; /* 972..982 */
    char L982[486]; /* 983..987 */
    char L987[395]; /* 988..995 */
    char L995[429]; /* 996..1003 */
    char L1003[465]; /* 1004..1010 */
    char L1010[448]; /* 1011..1022 */
    char L1022[493]; /* 1023..1026 */
    char L1026[447]; /* 1027..1034 */
    char L1034[458]; /* 1035..1038 */
    char L1038[474]; /* 1039..1046 */
    char L1046[432]; /* 1047..1049 */
    char L1049[423]; /* 1050..1052 */
    char L1052[474]; /* 1053..1055 */
    char L1055[438]; /* 1056..1058 */
    char L1058[396]; /* 1059..1061 */
    char L1061[475]; /* 1062..1065 */
    char L1065[403]; /* 1066..1068 */
    char L1068[453]; /* 1069..1079 */
    char L1079[488]; /* 1080..1083 */
    char L1083[507]; /* 1084..1092 */
    char L1092[505]; /* 1093..1101 */
    char L1101[373]; /* 1102..1104 */
    char L1104[420]; /* 1105..1107 */
    char L1107[426]; /* 1108..1110 */
    char L1110[498]; /* 1111..1114 */
    char L1114[443]; /* 1115..1117 */
    char L1117[490]; /* 1118..1121 */
    char L1121[472]; /* 1122..1125 */
    char L1125[382]; /* 1126..1128 */
    char L1128[437]; /* 1129..1131 */
    char L1131[427]; /* 1132..1134 */
    char L1134[437]; /* 1135..1138 */
    char L1138[430]; /* 1139..1143 */
    char L1143[441]; /* 1144..1146 */
    char L1146[424]; /* 1147..1154 */
    char L1154[382]; /* 1155..1157 */
    char L1157[452]; /* 1158..1165 */
    char L1165[398]; /* 1166..1168 */
    char L1168[490]; /* 1169..1176 */
    char L1176[446]; /* 1177..1181 */
    char L1181[378]; /* 1182..1186 */
    char L1186[421]; /* 1187..1191 */
    char L1191[473]; /* 1192..1207 */
    char L1207[484]; /* 1208..1216 */
    char L1216[468]; /* 1217..1224 */
    char L1224[474]; /* 1225..1231 */
    char L1231[481]; /* 1232..1240 */
    char L1240[472]; /* 1241..1249 */
    char L1249[452]; /* 1250..1257 */
    char L1257[494]; /* 1258..1261 */
    char L1261[418]; /* 1262..1269 */
    char L1269[429]; /* 1270..1277 */
    char L1277[467]; /* 1278..1293 */
    char L1293[508]; /* 1294..1298 */
    char L1298[420]; /* 1299..1302 */
    char L1302[418]; /* 1303..1310 */
    char L1310[476]; /* 1311..1313 */
    char L1313[358]; /* 1314..1315 */
    char L1315[358]; /* 1316..1317 */
    char L1317[350]; /* 1318..1319 */
    char L1319[484]; /* 1320..1322 */
    char L1322[466]; /* 1323..1325 */
    char L1325[484]; /* 1326..1328 */
    char L1328[434]; /* 1329..1331 */
    char L1331[432]; /* 1332..1334 */
    char L1334[450]; /* 1335..1337 */
    char L1337[502]; /* 1338..1340 */
    char L1340[462]; /* 1341..1343 */
    char L1343[470]; /* 1344..1346 */
    char L1346[486]; /* 1347..1349 */
    char L1349[332]; /* 1350..1351 */
    char L1351[374]; /* 1352..1353 */
    char L1353[492]; /* 1354..1356 */
    char L1356[488]; /* 1357..1359 */
    char L1359[494]; /* 1360..1362 */
    char L1362[344]; /* 1363..1364 */
    char L1364[344]; /* 1365..1366 */
    char L1366[344]; /* 1367..1368 */
    char L1368[358]; /* 1369..1370 */
    char L1370[344]; /* 1371..1372 */
    char L1372[498]; /* 1373..1375 */
    char L1375[484]; /* 1376..1378 */
    char L1378[470]; /* 1379..1381 */
    char L1381[366]; /* 1382..1383 */
    char L1383[386]; /* 1384..1385 */
    char L1385[348]; /* 1386..1387 */
    char L1387[344]; /* 1388..1389 */
    char L1389[358]; /* 1390..1391 */
    char L1391[346]; /* 1392..1393 */
    char L1393[494]; /* 1394..1396 */
    char L1396[468]; /* 1397..1399 */
    char L1399[504]; /* 1400..1402 */
    char L1402[342]; /* 1403..1404 */
    char L1404[352]; /* 1405..1406 */
    char L1406[364]; /* 1407..1408 */
    char L1408[478]; /* 1409..1411 */
    char L1411[488]; /* 1412..1414 */
    char L1414[476]; /* 1415..1417 */
    char L1417[486]; /* 1418..1420 */
    char L1420[464]; /* 1421..1423 */
    char L1423[476]; /* 1424..1426 */
    char L1426[336]; /* 1427..1428 */
    char L1428[364]; /* 1429..1430 */
    char L1430[506]; /* 1431..1433 */
    char L1433[445]; /* 1434..1445 */
    char L1445[483]; /* 1446..1449 */
    char L1449[474]; /* 1450..1461 */
    char L1461[469]; /* 1462..1465 */
    char L1465[503]; /* 1466..1469 */
    char L1469[471]; /* 1470..1473 */
    char L1473[390]; /* 1474..1476 */
    char L1476[387]; /* 1477..1479 */
    char L1479[423]; /* 1480..1482 */
    char L1482[393]; /* 1483..1485 */
    char L1485[441]; /* 1486..1490 */
    char L1490[486]; /* 1491..1495 */
    char L1495[437]; /* 1496..1500 */
    char L1500[479]; /* 1501..1504 */
    char L1504[346]; /* 1505..1507 */
    char L1507[496]; /* 1508..1520 */
    char L1520[488]; /* 1521..1546 */
    char L1546[490]; /* 1547..1575 */
    char L1575[499]; /* 1576..1606 */
    char L1606[500]; /* 1607..1635 */
    char L1635[484]; /* 1636..1662 */
    char L1662[173]; /* 1663..1673 */
} prelude_code7 = {
#line 1 "rjit_c.rb"
""/* frozen_string_literal: true */
""/* Part of this file is generated by tool/rjit/bindgen.rb. */
""/* Run `make rjit-bindgen` to update code between \"RJIT bindgen begin\" and \"RJIT bindgen end\". */
"module RubyVM::RJIT\n"/* :nodoc: all */
"\n"/*  */
"\n"/* Main: Used by RJIT */
"\n"/*  */
"\n"/* This `class << C` section is for calling C functions with Primitive. */
"\n"/* For importing variables or macros, use tool/rjit/bindgen.rb instead. */
"  class << C = Module.new\n"
"    def mmap(mem_size)\n"
"      Primitive.cexpr! 'SIZET2NUM((size_t)rjit_reserve_addr_space(NUM2UINT(mem_size)))'\n"
"    end\n"
"\n"
"    def mprotect_write(mem_block, mem_size)\n"
"      Primitive.mprotect_write(mem_block, mem_size)\n"
"    end\n"
"\n"
"    def mprotect_exec(mem_block, mem_size)\n"
"      Primitive.mprotect_exec(mem_block, mem_size)\n"
"    end\n"
"\n"
"    def rjit_insn_exits\n"
"      addr = Primitive.cexpr! 'SIZET2NUM((size_t)rjit_insn_exits)'\n"
,
#line 25 "rjit_c.rb"
"      CType::Immediate.parse(\"size_t\").new(addr)\n"
"    end\n"
"\n"
"    def rb_rjit_counters\n"
"      addr = Primitive.cexpr! 'SIZET2NUM((size_t)&rb_rjit_counters)'\n"
"      rb_rjit_runtime_counters.new(addr)\n"
"    end\n"
"\n"
"\n"/* @param from [Integer] - From address */
"\n"/* @param to [Integer]   - To address */
"    def dump_disasm(from, to, test: false)\n"
"      Primitive.dump_disasm(from, to, test)\n"
"    end\n"
"\n"
"\n"/* Convert a Ruby object to a VALUE in Integer */
"    def to_value(obj)\n"
"      Primitive.cexpr! 'SIZET2NUM((size_t)obj)'\n"
"    end\n"
"\n"
"    def BASIC_OP_UNREDEFINED_P(op, klass)\n"
"      Primitive.cexpr! 'RBOOL(BASIC_OP_UNREDEFINED_P(NUM2INT(op), NUM2INT(klass)))'\n"
,
#line 46 "rjit_c.rb"
"    end\n"
"\n"
"    def rb_iseq_line_no(iseq, pos)\n"
"      _iseq_addr = iseq.to_i\n"
"      Primitive.cexpr! 'UINT2NUM(rb_iseq_line_no((const rb_iseq_t *)NUM2SIZET(_iseq_addr), NUM2SIZET(pos)))'\n"
"    end\n"
"\n"
"    def rb_class_of(obj)\n"
"      Primitive.cexpr! 'rb_class_of(obj)'\n"
"    end\n"
"\n"
"    def rb_callable_method_entry(klass, mid)\n"
"      cme_addr = Primitive.cexpr! 'SIZET2NUM((size_t)rb_callable_method_entry(klass, NUM2UINT(mid)))'\n"
"      return nil if cme_addr == 0\n"
"      rb_callable_method_entry_t.new(cme_addr)\n"
"    end\n"
"\n"
,
#line 63 "rjit_c.rb"
"    def METHOD_ENTRY_VISI(cme)\n"
"      _cme_addr = cme.to_i\n"
"      Primitive.cexpr! 'UINT2NUM(METHOD_ENTRY_VISI((const rb_callable_method_entry_t *)NUM2SIZET(_cme_addr)))'\n"
"    end\n"
"\n"
"    def rb_simple_iseq_p(iseq)\n"
"      _iseq_addr = iseq.to_i\n"
"      Primitive.cexpr! 'RBOOL(rb_simple_iseq_p((rb_iseq_t *)NUM2SIZET(_iseq_addr)))'\n"
"    end\n"
"\n"
"    def SPECIAL_CONST_P(obj)\n"
"      _value = to_value(obj)\n"
"      Primitive.cexpr! 'RBOOL(SPECIAL_CONST_P((VALUE)NUM2SIZET(_value)))'\n"
"    end\n"
"\n"
"    def BUILTIN_TYPE(obj)\n"
,
#line 79 "rjit_c.rb"
"      _value = to_value(obj)\n"
"      Primitive.cexpr! 'INT2NUM(BUILTIN_TYPE((VALUE)NUM2SIZET(_value)))'\n"
"    end\n"
"\n"
"    def RB_TYPE_P(obj, type)\n"
"      Primitive.cexpr! 'RBOOL(RB_TYPE_P(obj, NUM2UINT(type)))'\n"
"    end\n"
"\n"
"    def rb_shape_get_shape_id(obj)\n"
"      _value = to_value(obj)\n"
"      Primitive.cexpr! 'UINT2NUM((unsigned int)rb_shape_get_shape_id((VALUE)NUM2SIZET(_value)))'\n"
"    end\n"
"\n"
"    def rb_shape_id_offset\n"
"      Primitive.cexpr! 'INT2NUM(rb_shape_id_offset())'\n"
"    end\n"
"\n"
,
#line 96 "rjit_c.rb"
"    def rb_shape_get_iv_index(shape_id, ivar_id)\n"
"      Primitive.cstmt! %{\n"
"        rb_shape_t *shape = rb_shape_get_shape_by_id((shape_id_t)NUM2SIZET(shape_id));\n"
"        attr_index_t index;\n"
"        bool found = rb_shape_get_iv_index(shape, (ID)NUM2SIZET(ivar_id), &index);\n"
"        return found ? UINT2NUM(index) : Qnil;\n"
"      }\n"
"    end\n"
"\n"
"    def FL_TEST_RAW(obj, flags)\n"
"      Primitive.cexpr! 'RBOOL(FL_TEST_RAW(obj, (VALUE)NUM2SIZET(flags)))'\n"
"    end\n"
"\n"
"    def FL_TEST(obj, flags)\n"
,
#line 110 "rjit_c.rb"
"      Primitive.cexpr! 'RBOOL(FL_TEST(obj, (VALUE)NUM2SIZET(flags)))'\n"
"    end\n"
"\n"
"    def rjit_for_each_iseq(&block)\n"
"      Primitive.rjit_for_each_iseq(block)\n"
"    end\n"
"\n"
"    def get_symbol_id(name)\n"
"      Primitive.cexpr! 'SIZET2NUM((size_t)rb_get_symbol_id(name))'\n"
"    end\n"
"\n"
"    def rb_vm_frame_method_entry(cfp)\n"
"      _cfp = cfp.to_i\n"
"      cme_addr = Primitive.cexpr! 'SIZET2NUM((size_t)rb_vm_frame_method_entry((const rb_control_frame_t *)NUM2SIZET(_cfp)))'\n"
"      return nil if cme_addr == 0\n"
,
#line 125 "rjit_c.rb"
"      rb_callable_method_entry_t.new(cme_addr)\n"
"    end\n"
"\n"
"    def rb_class_get_superclass(klass)\n"
"      Primitive.cexpr! 'rb_class_get_superclass(klass)'\n"
"    end\n"
"\n"
"    def ID2SYM(id)\n"
"      Primitive.cexpr! 'ID2SYM((ID)NUM2SIZET(id))'\n"
"    end\n"
"\n"
"    def obj_is_kind_of(obj, c)\n"
"      Primitive.cexpr! 'rb_obj_is_kind_of(obj, c)'\n"
"    end\n"
"\n"
"    def imemo_type_p(ptr, type)\n"
"      _ptr = ptr.to_i\n"
"      Primitive.cexpr! 'RBOOL(imemo_type_p((VALUE)NUM2SIZET(_ptr), NUM2UINT(type)))'\n"
"    end\n"
"\n"
,
#line 145 "rjit_c.rb"
"    def rb_iseq_only_optparam_p(iseq)\n"
"      _iseq = iseq.to_i\n"
"      Primitive.cstmt! %{\n"
"        extern bool rb_iseq_only_optparam_p(const rb_iseq_t *iseq);\n"
"        return RBOOL(rb_iseq_only_optparam_p((rb_iseq_t *)NUM2SIZET(_iseq)));\n"
"      }\n"
"    end\n"
"\n"
"    def rb_iseq_only_kwparam_p(iseq)\n"
"      _iseq = iseq.to_i\n"
"      Primitive.cstmt! %{\n"
"        extern bool rb_iseq_only_kwparam_p(const rb_iseq_t *iseq);\n"
"        return RBOOL(rb_iseq_only_kwparam_p((rb_iseq_t *)NUM2SIZET(_iseq)));\n"
"      }\n"
"    end\n"
"\n"
,
#line 161 "rjit_c.rb"
"    def rb_obj_frozen_p(obj)\n"
"      Primitive.cexpr! 'rb_obj_frozen_p(obj)'\n"
"    end\n"
"\n"
"    def rb_intern(str)\n"
"      Primitive.cexpr! 'SIZET2NUM((size_t)rb_intern(RSTRING_PTR(str)))'\n"
"    end\n"
"\n"
"    def rb_method_entry_at(klass, mid)\n"
"      me_addr = Primitive.cexpr! 'SIZET2NUM((size_t)rb_method_entry_at(klass, (ID)NUM2SIZET(mid)))'\n"
"      me_addr == 0 ? nil : rb_method_entry_t.new(me_addr)\n"
"    end\n"
"\n"
"    def rb_shape_get_next_no_warnings(shape, obj, id)\n"
"      _shape = shape.to_i\n"
,
#line 176 "rjit_c.rb"
"      shape_addr = Primitive.cexpr! 'SIZET2NUM((size_t)rb_shape_get_next_no_warnings((rb_shape_t *)NUM2SIZET(_shape), obj, (ID)NUM2SIZET(id)))'\n"
"      rb_shape_t.new(shape_addr)\n"
"    end\n"
"\n"
"    def rb_shape_id(shape)\n"
"      _shape = shape.to_i\n"
"      Primitive.cexpr! 'SIZET2NUM((size_t)rb_shape_id((rb_shape_t *)NUM2SIZET(_shape)))'\n"
"    end\n"
"\n"
"    def rb_class_attached_object(klass)\n"
"      Primitive.cexpr! 'rb_class_attached_object(klass)'\n"
"    end\n"
"\n"
"    def rb_singleton_class(obj)\n"
,
#line 190 "rjit_c.rb"
"      Primitive.cexpr! 'rb_singleton_class(obj)'\n"
"    end\n"
"\n"
"    def rb_aliased_callable_method_entry(cme)\n"
"      _cme = cme.to_i\n"
"      cme_addr = Primitive.cstmt! %{\n"
"        extern const rb_callable_method_entry_t * rb_aliased_callable_method_entry(const rb_callable_method_entry_t *me);\n"
"        return SIZET2NUM((size_t)rb_aliased_callable_method_entry((const rb_callable_method_entry_t *)NUM2SIZET(_cme)));\n"
"      }\n"
"      rb_callable_method_entry_t.new(cme_addr)\n"
"    end\n"
"\n"
,
#line 202 "rjit_c.rb"
"    def rb_yjit_get_proc_ptr(proc_addr)\n"
"      proc_t_addr = Primitive.cstmt! %{\n"
"        extern rb_proc_t * rjit_get_proc_ptr(VALUE procv);\n"
"        return SIZET2NUM((size_t)rjit_get_proc_ptr((VALUE)NUM2SIZET(proc_addr)));\n"
"      }\n"
"      rb_proc_t.new(proc_t_addr)\n"
"    end\n"
"\n"
"    def rb_shape_get_shape_by_id(shape_id)\n"
"      _shape_id = shape_id.to_i\n"
"      shape_addr = Primitive.cexpr! 'SIZET2NUM((VALUE)rb_shape_get_shape_by_id((shape_id_t)NUM2UINT(_shape_id)))'\n"
"      rb_shape_t.new(shape_addr)\n"
"    end\n"
"\n"
,
#line 216 "rjit_c.rb"
"    def rb_iseq_check(iseq)\n"
"      _iseq_addr = iseq.to_i\n"
"      iseq_addr = Primitive.cexpr! 'SIZET2NUM((VALUE)rb_iseq_check((rb_iseq_t *)NUM2SIZET(_iseq_addr)))'\n"
"      rb_iseq_t.new(iseq_addr)\n"
"    end\n"
"\n"
"    def rb_iseq_path(iseq)\n"
"      _iseq_addr = iseq.to_i\n"
"      Primitive.cexpr! 'rb_iseq_path((rb_iseq_t *)NUM2SIZET(_iseq_addr))'\n"
"    end\n"
"\n"
"    def vm_ci_argc(ci)\n"
"      _ci_addr = ci.to_i\n"
"      Primitive.cexpr! 'UINT2NUM(vm_ci_argc((CALL_INFO)NUM2SIZET(_ci_addr)))'\n"
"    end\n"
"\n"
"    def vm_ci_flag(ci)\n"
,
#line 233 "rjit_c.rb"
"      _ci_addr = ci.to_i\n"
"      Primitive.cexpr! 'UINT2NUM(vm_ci_flag((CALL_INFO)NUM2SIZET(_ci_addr)))'\n"
"    end\n"
"\n"
"    def vm_ci_kwarg(ci)\n"
"      _ci_addr = ci.to_i\n"
"      kwarg_addr = Primitive.cexpr! 'SIZET2NUM((size_t)vm_ci_kwarg((CALL_INFO)NUM2SIZET(_ci_addr)))'\n"
"      kwarg_addr == 0 ? nil : rb_callinfo_kwarg.new(kwarg_addr)\n"
"    end\n"
"\n"
"    def vm_ci_mid(ci)\n"
"      _ci_addr = ci.to_i\n"
"      Primitive.cexpr! 'SIZET2NUM((size_t)vm_ci_mid((CALL_INFO)NUM2SIZET(_ci_addr)))'\n"
"    end\n"
"\n"
"    def rjit_opts\n"
,
#line 249 "rjit_c.rb"
"      addr = Primitive.cexpr! 'SIZET2NUM((VALUE)&rb_rjit_opts)'\n"
"      rb_rjit_options.new(addr)\n"
"    end\n"
"\n"
"    def rjit_cancel_all(reason)\n"
"      Primitive.cstmt! %{\n"
"        rb_rjit_cancel_all(RSTRING_PTR(reason));\n"
"        return Qnil;\n"
"      }\n"
"    end\n"
"\n"
"\n"/* Convert an encoded VM pointer to an insn BIN. */
"    def rb_vm_insn_decode(encoded)\n"
"\n"/* Using rb_vm_insn_addr2opcode to return trace_ insns */
"      Primitive.cexpr! 'INT2NUM(rb_vm_insn_addr2opcode((void *)NUM2SIZET(encoded)))'\n"
"    end\n"
"\n"
"\n"/* Convert Integer VALUE to an actual Ruby object */
"    def to_ruby(value)\n"
"      Primitive.cexpr! '(VALUE)NUM2SIZET(value)'\n"
"    end\n"
"\n"
"    def HAVE_LIBCAPSTONE\n"
,
#line 272 "rjit_c.rb"
"      Primitive.cstmt! %{\n"
"        #ifdef HAVE_LIBCAPSTONE\n"
"          return Qtrue;\n"
"        #else\n"
"          return Qfalse;\n"
"        #endif\n"
"      }\n"
"    end\n"
"\n"
"    def rjit_exit_traces\n"
"      Primitive.cexpr! 'rjit_exit_traces()'\n"
"    end\n"
"\n"
"    def rb_vm_ep_local_ep(ep)\n"
"      _ep = ep.to_i\n"
"      lep_addr = Primitive.cexpr! 'SIZET2NUM((size_t)rb_vm_ep_local_ep((const VALUE *)NUM2SIZET(_ep)))'\n"
"      C.VALUE.new(lep_addr)\n"
"    end\n"
"\n"
"    def rb_hash_keys(hash)\n"
"      Primitive.cexpr! 'rb_hash_keys(hash)'\n"
"    end\n"
"\n"
,
#line 295 "rjit_c.rb"
"    def rb_hash_stlike_lookup(hash, key)\n"
"      Primitive.cstmt! %{\n"
"        VALUE result = Qnil;\n"
"        rb_hash_stlike_lookup(hash, key, &result);\n"
"        return result;\n"
"      }\n"
"    end\n"
"\n"
"    def rb_obj_class(obj)\n"
"      Primitive.cexpr! 'rb_obj_class(obj)'\n"
"    end\n"
"\n"
"    def rb_sym2id(sym)\n"
"      Primitive.cexpr! 'SIZET2NUM((size_t)rb_sym2id(sym))'\n"
"    end\n"
"\n"
"    def rb_callable_method_entry_or_negative(klass, mid)\n"
,
#line 312 "rjit_c.rb"
"      cme_addr = Primitive.cexpr! 'SIZET2NUM((size_t)rb_callable_method_entry_or_negative(klass, (ID)NUM2SIZET(mid)))'\n"
"      return nil if cme_addr == 0\n"
"      rb_callable_method_entry_t.new(cme_addr)\n"
"    end\n"
"\n"
"    def rb_method_basic_definition_p(klass, mid)\n"
"      Primitive.cexpr! 'RBOOL(rb_method_basic_definition_p(klass, (ID)NUM2SIZET(mid)))'\n"
"    end\n"
"\n"
"    def UNDEFINED_METHOD_ENTRY_P(cme)\n"
"      _cme_addr = cme.to_i\n"
,
#line 323 "rjit_c.rb"
"      Primitive.cexpr! 'RBOOL(UNDEFINED_METHOD_ENTRY_P((const rb_callable_method_entry_t *)NUM2SIZET(_cme_addr)))'\n"
"    end\n"
"\n"
"    def RCLASS_ORIGIN(klass)\n"
"      Primitive.cexpr! 'RCLASS_ORIGIN(klass)'\n"
"    end\n"
"\n"
"    def RCLASS_SINGLETON_P(klass)\n"
"      Primitive.cexpr! 'RCLASS_SINGLETON_P(klass)'\n"
"    end\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/* Utilities: Not used by RJIT, but useful for debugging */
"\n"/*  */
"  class << C\n"
"\n"/* Convert insn BINs to encoded VM pointers. */
"    def rb_vm_insn_encode(bin)\n"
"      Primitive.cexpr! 'SIZET2NUM((VALUE)rb_vm_get_insns_address_table()[NUM2INT(bin)])'\n"
"    end\n"
"\n"
"\n"/* Convert RubyVM::InstructionSequence to C.rb_iseq_t. */
"    def rb_iseqw_to_iseq(iseqw)\n"
,
#line 346 "rjit_c.rb"
"      iseq_addr = Primitive.cexpr! 'SIZET2NUM((VALUE)rb_iseqw_to_iseq(iseqw))'\n"
"      rb_iseq_t.new(iseq_addr)\n"
"    end\n"
"  end\n"
"\n"
"\n"/* # RJIT bindgen begin ### */
"\n"
"  C::UNLIMITED_ARGUMENTS = Primitive.cexpr! %q{ LONG2NUM(UNLIMITED_ARGUMENTS) }\n"
"  C::VM_ENV_DATA_INDEX_ME_CREF = Primitive.cexpr! %q{ LONG2NUM(VM_ENV_DATA_INDEX_ME_CREF) }\n"
"  C::VM_ENV_DATA_INDEX_SPECVAL = Primitive.cexpr! %q{ LONG2NUM(VM_ENV_DATA_INDEX_SPECVAL) }\n"
"  C::ARRAY_REDEFINED_OP_FLAG = Primitive.cexpr! %q{ SIZET2NUM(ARRAY_REDEFINED_OP_FLAG) }\n"
,
#line 357 "rjit_c.rb"
"  C::BOP_AND = Primitive.cexpr! %q{ SIZET2NUM(BOP_AND) }\n"
"  C::BOP_AREF = Primitive.cexpr! %q{ SIZET2NUM(BOP_AREF) }\n"
"  C::BOP_EQ = Primitive.cexpr! %q{ SIZET2NUM(BOP_EQ) }\n"
"  C::BOP_EQQ = Primitive.cexpr! %q{ SIZET2NUM(BOP_EQQ) }\n"
"  C::BOP_FREEZE = Primitive.cexpr! %q{ SIZET2NUM(BOP_FREEZE) }\n"
"  C::BOP_GE = Primitive.cexpr! %q{ SIZET2NUM(BOP_GE) }\n"
"  C::BOP_GT = Primitive.cexpr! %q{ SIZET2NUM(BOP_GT) }\n"
"  C::BOP_LE = Primitive.cexpr! %q{ SIZET2NUM(BOP_LE) }\n"
,
#line 365 "rjit_c.rb"
"  C::BOP_LT = Primitive.cexpr! %q{ SIZET2NUM(BOP_LT) }\n"
"  C::BOP_MINUS = Primitive.cexpr! %q{ SIZET2NUM(BOP_MINUS) }\n"
"  C::BOP_MOD = Primitive.cexpr! %q{ SIZET2NUM(BOP_MOD) }\n"
"  C::BOP_OR = Primitive.cexpr! %q{ SIZET2NUM(BOP_OR) }\n"
"  C::BOP_PLUS = Primitive.cexpr! %q{ SIZET2NUM(BOP_PLUS) }\n"
"  C::BUILTIN_ATTR_LEAF = Primitive.cexpr! %q{ SIZET2NUM(BUILTIN_ATTR_LEAF) }\n"
"  C::HASH_REDEFINED_OP_FLAG = Primitive.cexpr! %q{ SIZET2NUM(HASH_REDEFINED_OP_FLAG) }\n"
,
#line 372 "rjit_c.rb"
"  C::INTEGER_REDEFINED_OP_FLAG = Primitive.cexpr! %q{ SIZET2NUM(INTEGER_REDEFINED_OP_FLAG) }\n"
"  C::INVALID_SHAPE_ID = Primitive.cexpr! %q{ SIZET2NUM(INVALID_SHAPE_ID) }\n"
"  C::METHOD_VISI_PRIVATE = Primitive.cexpr! %q{ SIZET2NUM(METHOD_VISI_PRIVATE) }\n"
"  C::METHOD_VISI_PROTECTED = Primitive.cexpr! %q{ SIZET2NUM(METHOD_VISI_PROTECTED) }\n"
"  C::METHOD_VISI_PUBLIC = Primitive.cexpr! %q{ SIZET2NUM(METHOD_VISI_PUBLIC) }\n"
"  C::METHOD_VISI_UNDEF = Primitive.cexpr! %q{ SIZET2NUM(METHOD_VISI_UNDEF) }\n"
,
#line 378 "rjit_c.rb"
"  C::OBJ_TOO_COMPLEX_SHAPE_ID = Primitive.cexpr! %q{ SIZET2NUM(OBJ_TOO_COMPLEX_SHAPE_ID) }\n"
"  C::OPTIMIZED_METHOD_TYPE_BLOCK_CALL = Primitive.cexpr! %q{ SIZET2NUM(OPTIMIZED_METHOD_TYPE_BLOCK_CALL) }\n"
"  C::OPTIMIZED_METHOD_TYPE_CALL = Primitive.cexpr! %q{ SIZET2NUM(OPTIMIZED_METHOD_TYPE_CALL) }\n"
"  C::OPTIMIZED_METHOD_TYPE_SEND = Primitive.cexpr! %q{ SIZET2NUM(OPTIMIZED_METHOD_TYPE_SEND) }\n"
"  C::OPTIMIZED_METHOD_TYPE_STRUCT_AREF = Primitive.cexpr! %q{ SIZET2NUM(OPTIMIZED_METHOD_TYPE_STRUCT_AREF) }\n"
,
#line 383 "rjit_c.rb"
"  C::OPTIMIZED_METHOD_TYPE_STRUCT_ASET = Primitive.cexpr! %q{ SIZET2NUM(OPTIMIZED_METHOD_TYPE_STRUCT_ASET) }\n"
"  C::RARRAY_EMBED_FLAG = Primitive.cexpr! %q{ SIZET2NUM(RARRAY_EMBED_FLAG) }\n"
"  C::RARRAY_EMBED_LEN_MASK = Primitive.cexpr! %q{ SIZET2NUM(RARRAY_EMBED_LEN_MASK) }\n"
"  C::RARRAY_EMBED_LEN_SHIFT = Primitive.cexpr! %q{ SIZET2NUM(RARRAY_EMBED_LEN_SHIFT) }\n"
"  C::RHASH_PASS_AS_KEYWORDS = Primitive.cexpr! %q{ SIZET2NUM(RHASH_PASS_AS_KEYWORDS) }\n"
,
#line 388 "rjit_c.rb"
"  C::RMODULE_IS_REFINEMENT = Primitive.cexpr! %q{ SIZET2NUM(RMODULE_IS_REFINEMENT) }\n"
"  C::ROBJECT_EMBED = Primitive.cexpr! %q{ SIZET2NUM(ROBJECT_EMBED) }\n"
"  C::RSTRUCT_EMBED_LEN_MASK = Primitive.cexpr! %q{ SIZET2NUM(RSTRUCT_EMBED_LEN_MASK) }\n"
"  C::RUBY_ENCODING_MASK = Primitive.cexpr! %q{ SIZET2NUM(RUBY_ENCODING_MASK) }\n"
"  C::RUBY_EVENT_CLASS = Primitive.cexpr! %q{ SIZET2NUM(RUBY_EVENT_CLASS) }\n"
"  C::RUBY_EVENT_C_CALL = Primitive.cexpr! %q{ SIZET2NUM(RUBY_EVENT_C_CALL) }\n"
,
#line 394 "rjit_c.rb"
"  C::RUBY_EVENT_C_RETURN = Primitive.cexpr! %q{ SIZET2NUM(RUBY_EVENT_C_RETURN) }\n"
"  C::RUBY_FIXNUM_FLAG = Primitive.cexpr! %q{ SIZET2NUM(RUBY_FIXNUM_FLAG) }\n"
"  C::RUBY_FLONUM_FLAG = Primitive.cexpr! %q{ SIZET2NUM(RUBY_FLONUM_FLAG) }\n"
"  C::RUBY_FLONUM_MASK = Primitive.cexpr! %q{ SIZET2NUM(RUBY_FLONUM_MASK) }\n"
"  C::RUBY_FL_FREEZE = Primitive.cexpr! %q{ SIZET2NUM(RUBY_FL_FREEZE) }\n"
"  C::RUBY_IMMEDIATE_MASK = Primitive.cexpr! %q{ SIZET2NUM(RUBY_IMMEDIATE_MASK) }\n"
,
#line 400 "rjit_c.rb"
"  C::RUBY_SPECIAL_SHIFT = Primitive.cexpr! %q{ SIZET2NUM(RUBY_SPECIAL_SHIFT) }\n"
"  C::RUBY_SYMBOL_FLAG = Primitive.cexpr! %q{ SIZET2NUM(RUBY_SYMBOL_FLAG) }\n"
"  C::RUBY_T_ARRAY = Primitive.cexpr! %q{ SIZET2NUM(RUBY_T_ARRAY) }\n"
"  C::RUBY_T_CLASS = Primitive.cexpr! %q{ SIZET2NUM(RUBY_T_CLASS) }\n"
"  C::RUBY_T_HASH = Primitive.cexpr! %q{ SIZET2NUM(RUBY_T_HASH) }\n"
"  C::RUBY_T_ICLASS = Primitive.cexpr! %q{ SIZET2NUM(RUBY_T_ICLASS) }\n"
"  C::RUBY_T_MASK = Primitive.cexpr! %q{ SIZET2NUM(RUBY_T_MASK) }\n"
,
#line 407 "rjit_c.rb"
"  C::RUBY_T_MODULE = Primitive.cexpr! %q{ SIZET2NUM(RUBY_T_MODULE) }\n"
"  C::RUBY_T_OBJECT = Primitive.cexpr! %q{ SIZET2NUM(RUBY_T_OBJECT) }\n"
"  C::RUBY_T_STRING = Primitive.cexpr! %q{ SIZET2NUM(RUBY_T_STRING) }\n"
"  C::RUBY_T_SYMBOL = Primitive.cexpr! %q{ SIZET2NUM(RUBY_T_SYMBOL) }\n"
"  C::SHAPE_FLAG_SHIFT = Primitive.cexpr! %q{ SIZET2NUM(SHAPE_FLAG_SHIFT) }\n"
"  C::SHAPE_FROZEN = Primitive.cexpr! %q{ SIZET2NUM(SHAPE_FROZEN) }\n"
"  C::SHAPE_ID_NUM_BITS = Primitive.cexpr! %q{ SIZET2NUM(SHAPE_ID_NUM_BITS) }\n"
,
#line 414 "rjit_c.rb"
"  C::SHAPE_IVAR = Primitive.cexpr! %q{ SIZET2NUM(SHAPE_IVAR) }\n"
"  C::SHAPE_MASK = Primitive.cexpr! %q{ SIZET2NUM(SHAPE_MASK) }\n"
"  C::SHAPE_ROOT = Primitive.cexpr! %q{ SIZET2NUM(SHAPE_ROOT) }\n"
"  C::STRING_REDEFINED_OP_FLAG = Primitive.cexpr! %q{ SIZET2NUM(STRING_REDEFINED_OP_FLAG) }\n"
"  C::T_OBJECT = Primitive.cexpr! %q{ SIZET2NUM(T_OBJECT) }\n"
"  C::VM_BLOCK_HANDLER_NONE = Primitive.cexpr! %q{ SIZET2NUM(VM_BLOCK_HANDLER_NONE) }\n"
,
#line 420 "rjit_c.rb"
"  C::VM_CALL_ARGS_BLOCKARG = Primitive.cexpr! %q{ SIZET2NUM(VM_CALL_ARGS_BLOCKARG) }\n"
"  C::VM_CALL_ARGS_SPLAT = Primitive.cexpr! %q{ SIZET2NUM(VM_CALL_ARGS_SPLAT) }\n"
"  C::VM_CALL_FCALL = Primitive.cexpr! %q{ SIZET2NUM(VM_CALL_FCALL) }\n"
"  C::VM_CALL_FORWARDING = Primitive.cexpr! %q{ SIZET2NUM(VM_CALL_FORWARDING) }\n"
"  C::VM_CALL_KWARG = Primitive.cexpr! %q{ SIZET2NUM(VM_CALL_KWARG) }\n"
"  C::VM_CALL_KW_SPLAT = Primitive.cexpr! %q{ SIZET2NUM(VM_CALL_KW_SPLAT) }\n"
,
#line 426 "rjit_c.rb"
"  C::VM_CALL_KW_SPLAT_MUT = Primitive.cexpr! %q{ SIZET2NUM(VM_CALL_KW_SPLAT_MUT) }\n"
"  C::VM_CALL_KW_SPLAT_bit = Primitive.cexpr! %q{ SIZET2NUM(VM_CALL_KW_SPLAT_bit) }\n"
"  C::VM_CALL_OPT_SEND = Primitive.cexpr! %q{ SIZET2NUM(VM_CALL_OPT_SEND) }\n"
"  C::VM_CALL_TAILCALL = Primitive.cexpr! %q{ SIZET2NUM(VM_CALL_TAILCALL) }\n"
"  C::VM_CALL_TAILCALL_bit = Primitive.cexpr! %q{ SIZET2NUM(VM_CALL_TAILCALL_bit) }\n"
"  C::VM_CALL_ZSUPER = Primitive.cexpr! %q{ SIZET2NUM(VM_CALL_ZSUPER) }\n"
,
#line 432 "rjit_c.rb"
"  C::VM_ENV_DATA_INDEX_FLAGS = Primitive.cexpr! %q{ SIZET2NUM(VM_ENV_DATA_INDEX_FLAGS) }\n"
"  C::VM_ENV_DATA_SIZE = Primitive.cexpr! %q{ SIZET2NUM(VM_ENV_DATA_SIZE) }\n"
"  C::VM_ENV_FLAG_LOCAL = Primitive.cexpr! %q{ SIZET2NUM(VM_ENV_FLAG_LOCAL) }\n"
"  C::VM_ENV_FLAG_WB_REQUIRED = Primitive.cexpr! %q{ SIZET2NUM(VM_ENV_FLAG_WB_REQUIRED) }\n"
"  C::VM_FRAME_FLAG_BMETHOD = Primitive.cexpr! %q{ SIZET2NUM(VM_FRAME_FLAG_BMETHOD) }\n"
"  C::VM_FRAME_FLAG_CFRAME = Primitive.cexpr! %q{ SIZET2NUM(VM_FRAME_FLAG_CFRAME) }\n"
,
#line 438 "rjit_c.rb"
"  C::VM_FRAME_FLAG_CFRAME_KW = Primitive.cexpr! %q{ SIZET2NUM(VM_FRAME_FLAG_CFRAME_KW) }\n"
"  C::VM_FRAME_FLAG_LAMBDA = Primitive.cexpr! %q{ SIZET2NUM(VM_FRAME_FLAG_LAMBDA) }\n"
"  C::VM_FRAME_FLAG_MODIFIED_BLOCK_PARAM = Primitive.cexpr! %q{ SIZET2NUM(VM_FRAME_FLAG_MODIFIED_BLOCK_PARAM) }\n"
"  C::VM_FRAME_MAGIC_BLOCK = Primitive.cexpr! %q{ SIZET2NUM(VM_FRAME_MAGIC_BLOCK) }\n"
"  C::VM_FRAME_MAGIC_CFUNC = Primitive.cexpr! %q{ SIZET2NUM(VM_FRAME_MAGIC_CFUNC) }\n"
,
#line 443 "rjit_c.rb"
"  C::VM_FRAME_MAGIC_METHOD = Primitive.cexpr! %q{ SIZET2NUM(VM_FRAME_MAGIC_METHOD) }\n"
"  C::VM_METHOD_TYPE_ALIAS = Primitive.cexpr! %q{ SIZET2NUM(VM_METHOD_TYPE_ALIAS) }\n"
"  C::VM_METHOD_TYPE_ATTRSET = Primitive.cexpr! %q{ SIZET2NUM(VM_METHOD_TYPE_ATTRSET) }\n"
"  C::VM_METHOD_TYPE_BMETHOD = Primitive.cexpr! %q{ SIZET2NUM(VM_METHOD_TYPE_BMETHOD) }\n"
"  C::VM_METHOD_TYPE_CFUNC = Primitive.cexpr! %q{ SIZET2NUM(VM_METHOD_TYPE_CFUNC) }\n"
"  C::VM_METHOD_TYPE_ISEQ = Primitive.cexpr! %q{ SIZET2NUM(VM_METHOD_TYPE_ISEQ) }\n"
,
#line 449 "rjit_c.rb"
"  C::VM_METHOD_TYPE_IVAR = Primitive.cexpr! %q{ SIZET2NUM(VM_METHOD_TYPE_IVAR) }\n"
"  C::VM_METHOD_TYPE_MISSING = Primitive.cexpr! %q{ SIZET2NUM(VM_METHOD_TYPE_MISSING) }\n"
"  C::VM_METHOD_TYPE_NOTIMPLEMENTED = Primitive.cexpr! %q{ SIZET2NUM(VM_METHOD_TYPE_NOTIMPLEMENTED) }\n"
"  C::VM_METHOD_TYPE_OPTIMIZED = Primitive.cexpr! %q{ SIZET2NUM(VM_METHOD_TYPE_OPTIMIZED) }\n"
"  C::VM_METHOD_TYPE_REFINED = Primitive.cexpr! %q{ SIZET2NUM(VM_METHOD_TYPE_REFINED) }\n"
,
#line 454 "rjit_c.rb"
"  C::VM_METHOD_TYPE_UNDEF = Primitive.cexpr! %q{ SIZET2NUM(VM_METHOD_TYPE_UNDEF) }\n"
"  C::VM_METHOD_TYPE_ZSUPER = Primitive.cexpr! %q{ SIZET2NUM(VM_METHOD_TYPE_ZSUPER) }\n"
"  C::VM_SPECIAL_OBJECT_VMCORE = Primitive.cexpr! %q{ SIZET2NUM(VM_SPECIAL_OBJECT_VMCORE) }\n"
"\n"
"  def C.block_type_iseq = Primitive.cexpr!(%q{ SIZET2NUM(block_type_iseq) })\n"
"  def C.idRespond_to_missing = Primitive.cexpr!(%q{ SIZET2NUM(idRespond_to_missing) })\n"
"  def C.imemo_callinfo = Primitive.cexpr!(%q{ SIZET2NUM(imemo_callinfo) })\n"
,
#line 461 "rjit_c.rb"
"  def C.imemo_iseq = Primitive.cexpr!(%q{ SIZET2NUM(imemo_iseq) })\n"
"  def C.rb_block_param_proxy = Primitive.cexpr!(%q{ SIZET2NUM(rb_block_param_proxy) })\n"
"  def C.rb_cArray = Primitive.cexpr!(%q{ SIZET2NUM(rb_cArray) })\n"
"  def C.rb_cFalseClass = Primitive.cexpr!(%q{ SIZET2NUM(rb_cFalseClass) })\n"
"  def C.rb_cFloat = Primitive.cexpr!(%q{ SIZET2NUM(rb_cFloat) })\n"
"  def C.rb_cInteger = Primitive.cexpr!(%q{ SIZET2NUM(rb_cInteger) })\n"
"  def C.rb_cNilClass = Primitive.cexpr!(%q{ SIZET2NUM(rb_cNilClass) })\n"
,
#line 468 "rjit_c.rb"
"  def C.rb_cString = Primitive.cexpr!(%q{ SIZET2NUM(rb_cString) })\n"
"  def C.rb_cSymbol = Primitive.cexpr!(%q{ SIZET2NUM(rb_cSymbol) })\n"
"  def C.rb_cTrueClass = Primitive.cexpr!(%q{ SIZET2NUM(rb_cTrueClass) })\n"
"  def C.rb_mRubyVMFrozenCore = Primitive.cexpr!(%q{ SIZET2NUM(rb_mRubyVMFrozenCore) })\n"
"  def C.rb_rjit_global_events = Primitive.cexpr!(%q{ SIZET2NUM(rb_rjit_global_events) })\n"
"  def C.rb_vm_insns_count = Primitive.cexpr!(%q{ SIZET2NUM(rb_vm_insns_count) })\n"
"\n"
"  def C.rb_ary_clear\n"
,
#line 476 "rjit_c.rb"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_ary_clear) }\n"
"  end\n"
"\n"
"  def C.rb_ary_dup\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_ary_dup) }\n"
"  end\n"
"\n"
"  def C.rb_ary_entry_internal\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_ary_entry_internal) }\n"
"  end\n"
"\n"
"  def C.rb_ary_push\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_ary_push) }\n"
"  end\n"
"\n"
"  def C.rb_ary_resurrect\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_ary_resurrect) }\n"
"  end\n"
"\n"
"  def C.rb_ary_store\n"
,
#line 496 "rjit_c.rb"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_ary_store) }\n"
"  end\n"
"\n"
"  def C.rb_ary_tmp_new_from_values\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_ary_tmp_new_from_values) }\n"
"  end\n"
"\n"
"  def C.rb_ary_unshift_m\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_ary_unshift_m) }\n"
"  end\n"
"\n"
"  def C.rb_backref_get\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_backref_get) }\n"
"  end\n"
"\n"
"  def C.rb_ec_ary_new_from_values\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_ec_ary_new_from_values) }\n"
"  end\n"
"\n"
"  def C.rb_ec_str_resurrect\n"
,
#line 516 "rjit_c.rb"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_ec_str_resurrect) }\n"
"  end\n"
"\n"
"  def C.rb_ensure_iv_list_size\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_ensure_iv_list_size) }\n"
"  end\n"
"\n"
"  def C.rb_fix_aref\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_fix_aref) }\n"
"  end\n"
"\n"
"  def C.rb_fix_div_fix\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_fix_div_fix) }\n"
"  end\n"
"\n"
"  def C.rb_fix_mod_fix\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_fix_mod_fix) }\n"
"  end\n"
"\n"
"  def C.rb_fix_mul_fix\n"
,
#line 536 "rjit_c.rb"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_fix_mul_fix) }\n"
"  end\n"
"\n"
"  def C.rb_gc_writebarrier\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_gc_writebarrier) }\n"
"  end\n"
"\n"
"  def C.rb_get_symbol_id\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_get_symbol_id) }\n"
"  end\n"
"\n"
"  def C.rb_gvar_get\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_gvar_get) }\n"
"  end\n"
"\n"
"  def C.rb_hash_aref\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_hash_aref) }\n"
"  end\n"
"\n"
"  def C.rb_hash_aset\n"
,
#line 556 "rjit_c.rb"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_hash_aset) }\n"
"  end\n"
"\n"
"  def C.rb_hash_bulk_insert\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_hash_bulk_insert) }\n"
"  end\n"
"\n"
"  def C.rb_hash_new\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_hash_new) }\n"
"  end\n"
"\n"
"  def C.rb_hash_new_with_size\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_hash_new_with_size) }\n"
"  end\n"
"\n"
"  def C.rb_hash_resurrect\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_hash_resurrect) }\n"
"  end\n"
"\n"
"  def C.rb_ivar_defined\n"
,
#line 576 "rjit_c.rb"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_ivar_defined) }\n"
"  end\n"
"\n"
"  def C.rb_ivar_get\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_ivar_get) }\n"
"  end\n"
"\n"
"  def C.rb_obj_as_string_result\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_obj_as_string_result) }\n"
"  end\n"
"\n"
"  def C.rb_obj_is_kind_of\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_obj_is_kind_of) }\n"
"  end\n"
"\n"
"  def C.rb_range_new\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_range_new) }\n"
"  end\n"
"\n"
"  def C.rb_reg_last_match\n"
,
#line 596 "rjit_c.rb"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_reg_last_match) }\n"
"  end\n"
"\n"
"  def C.rb_reg_match_last\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_reg_match_last) }\n"
"  end\n"
"\n"
"  def C.rb_reg_match_post\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_reg_match_post) }\n"
"  end\n"
"\n"
"  def C.rb_reg_match_pre\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_reg_match_pre) }\n"
"  end\n"
"\n"
"  def C.rb_reg_new_ary\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_reg_new_ary) }\n"
"  end\n"
"\n"
"  def C.rb_reg_nth_match\n"
,
#line 616 "rjit_c.rb"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_reg_nth_match) }\n"
"  end\n"
"\n"
"  def C.rb_rjit_branch_stub_hit\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_rjit_branch_stub_hit) }\n"
"  end\n"
"\n"
"  def C.rb_rjit_entry_stub_hit\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_rjit_entry_stub_hit) }\n"
"  end\n"
"\n"
"  def C.rb_str_buf_append\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_str_buf_append) }\n"
"  end\n"
"\n"
"  def C.rb_str_bytesize\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_str_bytesize) }\n"
"  end\n"
"\n"
"  def C.rb_str_concat_literals\n"
,
#line 636 "rjit_c.rb"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_str_concat_literals) }\n"
"  end\n"
"\n"
"  def C.rb_str_dup\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_str_dup) }\n"
"  end\n"
"\n"
"  def C.rb_str_eql_internal\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_str_eql_internal) }\n"
"  end\n"
"\n"
"  def C.rb_str_getbyte\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_str_getbyte) }\n"
"  end\n"
"\n"
"  def C.rb_str_intern\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_str_intern) }\n"
"  end\n"
"\n"
"  def C.rb_sym_to_proc\n"
,
#line 656 "rjit_c.rb"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_sym_to_proc) }\n"
"  end\n"
"\n"
"  def C.rb_vm_bh_to_procval\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_vm_bh_to_procval) }\n"
"  end\n"
"\n"
"  def C.rb_vm_concat_array\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_vm_concat_array) }\n"
"  end\n"
"\n"
"  def C.rb_vm_defined\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_vm_defined) }\n"
"  end\n"
"\n"
"  def C.rb_vm_get_ev_const\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_vm_get_ev_const) }\n"
"  end\n"
"\n"
"  def C.rb_vm_getclassvariable\n"
,
#line 676 "rjit_c.rb"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_vm_getclassvariable) }\n"
"  end\n"
"\n"
"  def C.rb_vm_ic_hit_p\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_vm_ic_hit_p) }\n"
"  end\n"
"\n"
"  def C.rb_vm_opt_newarray_hash\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_vm_opt_newarray_hash) }\n"
"  end\n"
"\n"
"  def C.rb_vm_opt_newarray_max\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_vm_opt_newarray_max) }\n"
"  end\n"
"\n"
"  def C.rb_vm_opt_newarray_min\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_vm_opt_newarray_min) }\n"
"  end\n"
"\n"
,
#line 695 "rjit_c.rb"
"  def C.rb_vm_opt_newarray_pack\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_vm_opt_newarray_pack) }\n"
"  end\n"
"\n"
"  def C.rb_vm_set_ivar_id\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_vm_set_ivar_id) }\n"
"  end\n"
"\n"
"  def C.rb_vm_setclassvariable\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_vm_setclassvariable) }\n"
"  end\n"
"\n"
"  def C.rb_vm_setinstancevariable\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_vm_setinstancevariable) }\n"
"  end\n"
"\n"
"  def C.rb_vm_splat_array\n"
,
#line 712 "rjit_c.rb"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_vm_splat_array) }\n"
"  end\n"
"\n"
"  def C.rb_vm_throw\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_vm_throw) }\n"
"  end\n"
"\n"
"  def C.rb_vm_yield_with_cfunc\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rb_vm_yield_with_cfunc) }\n"
"  end\n"
"\n"
"  def C.rjit_build_kwhash\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rjit_build_kwhash) }\n"
"  end\n"
"\n"
"  def C.rjit_full_cfunc_return\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rjit_full_cfunc_return) }\n"
"  end\n"
"\n"
"  def C.rjit_optimized_call\n"
,
#line 732 "rjit_c.rb"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rjit_optimized_call) }\n"
"  end\n"
"\n"
"  def C.rjit_rb_ary_subseq_length\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rjit_rb_ary_subseq_length) }\n"
"  end\n"
"\n"
"  def C.rjit_record_exit_stack\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rjit_record_exit_stack) }\n"
"  end\n"
"\n"
"  def C.rjit_str_neq_internal\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rjit_str_neq_internal) }\n"
"  end\n"
"\n"
"  def C.rjit_str_simple_append\n"
"    Primitive.cexpr! %q{ SIZET2NUM((size_t)rjit_str_simple_append) }\n"
"  end\n"
"\n"
,
#line 751 "rjit_c.rb"
"  def C.CALL_DATA\n"
"    @CALL_DATA ||= self.rb_call_data\n"
"  end\n"
"\n"
"  def C.IC\n"
"    @IC ||= self.iseq_inline_constant_cache\n"
"  end\n"
"\n"
"  def C.ID\n"
"    @ID ||= CType::Immediate.parse(\"unsigned long\")\n"
"  end\n"
"\n"
"  def C.IVC\n"
"    @IVC ||= self.iseq_inline_iv_cache_entry\n"
"  end\n"
"\n"
"  def C.RArray\n"
"    @RArray ||= CType::Struct.new(\n"
"      \"RArray\", Primitive.cexpr!(\"SIZEOF(struct RArray)\"),\n"
"      basic: [self.RBasic, Primitive.cexpr!(\"OFFSETOF((*((struct RArray *)NULL)), basic)\")],\n"
"      as: [CType::Union.new(\n"
,
#line 772 "rjit_c.rb"
"        \"\", Primitive.cexpr!(\"SIZEOF(((struct RArray *)NULL)->as)\"),\n"
"        heap: CType::Struct.new(\n"
"          \"\", Primitive.cexpr!(\"SIZEOF(((struct RArray *)NULL)->as.heap)\"),\n"
"          len: [CType::Immediate.parse(\"long\"), Primitive.cexpr!(\"OFFSETOF(((struct RArray *)NULL)->as.heap, len)\")],\n"
"          aux: [CType::Union.new(\n"
"            \"\", Primitive.cexpr!(\"SIZEOF(((struct RArray *)NULL)->as.heap.aux)\"),\n"
"            capa: CType::Immediate.parse(\"long\"),\n"
"            shared_root: self.VALUE,\n"
,
#line 780 "rjit_c.rb"
"          ), Primitive.cexpr!(\"OFFSETOF(((struct RArray *)NULL)->as.heap, aux)\")],\n"
"          ptr: [CType::Pointer.new { self.VALUE }, Primitive.cexpr!(\"OFFSETOF(((struct RArray *)NULL)->as.heap, ptr)\")],\n"
"        ),\n"
"        ary: CType::Array.new { self.VALUE },\n"
"      ), Primitive.cexpr!(\"OFFSETOF((*((struct RArray *)NULL)), as)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.RB_BUILTIN\n"
"    @RB_BUILTIN ||= self.rb_builtin_function\n"
"  end\n"
"\n"
"  def C.RBasic\n"
"    @RBasic ||= CType::Struct.new(\n"
,
#line 794 "rjit_c.rb"
"      \"RBasic\", Primitive.cexpr!(\"SIZEOF(struct RBasic)\"),\n"
"      flags: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct RBasic *)NULL)), flags)\")],\n"
"      klass: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct RBasic *)NULL)), klass)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.RObject\n"
"    @RObject ||= CType::Struct.new(\n"
"      \"RObject\", Primitive.cexpr!(\"SIZEOF(struct RObject)\"),\n"
"      basic: [self.RBasic, Primitive.cexpr!(\"OFFSETOF((*((struct RObject *)NULL)), basic)\")],\n"
"      as: [CType::Union.new(\n"
,
#line 805 "rjit_c.rb"
"        \"\", Primitive.cexpr!(\"SIZEOF(((struct RObject *)NULL)->as)\"),\n"
"        heap: CType::Struct.new(\n"
"          \"\", Primitive.cexpr!(\"SIZEOF(((struct RObject *)NULL)->as.heap)\"),\n"
"          ivptr: [CType::Pointer.new { self.VALUE }, Primitive.cexpr!(\"OFFSETOF(((struct RObject *)NULL)->as.heap, ivptr)\")],\n"
"          iv_index_tbl: [CType::Pointer.new { self.rb_id_table }, Primitive.cexpr!(\"OFFSETOF(((struct RObject *)NULL)->as.heap, iv_index_tbl)\")],\n"
"        ),\n"
,
#line 811 "rjit_c.rb"
"        ary: CType::Array.new { self.VALUE },\n"
"      ), Primitive.cexpr!(\"OFFSETOF((*((struct RObject *)NULL)), as)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.RString\n"
"    @RString ||= CType::Struct.new(\n"
"      \"RString\", Primitive.cexpr!(\"SIZEOF(struct RString)\"),\n"
"      basic: [self.RBasic, Primitive.cexpr!(\"OFFSETOF((*((struct RString *)NULL)), basic)\")],\n"
"      len: [CType::Immediate.parse(\"long\"), Primitive.cexpr!(\"OFFSETOF((*((struct RString *)NULL)), len)\")],\n"
"      as: [CType::Union.new(\n"
,
#line 822 "rjit_c.rb"
"        \"\", Primitive.cexpr!(\"SIZEOF(((struct RString *)NULL)->as)\"),\n"
"        heap: CType::Struct.new(\n"
"          \"\", Primitive.cexpr!(\"SIZEOF(((struct RString *)NULL)->as.heap)\"),\n"
"          ptr: [CType::Pointer.new { CType::Immediate.parse(\"char\") }, Primitive.cexpr!(\"OFFSETOF(((struct RString *)NULL)->as.heap, ptr)\")],\n"
"          aux: [CType::Union.new(\n"
"            \"\", Primitive.cexpr!(\"SIZEOF(((struct RString *)NULL)->as.heap.aux)\"),\n"
"            capa: CType::Immediate.parse(\"long\"),\n"
,
#line 829 "rjit_c.rb"
"            shared: self.VALUE,\n"
"          ), Primitive.cexpr!(\"OFFSETOF(((struct RString *)NULL)->as.heap, aux)\")],\n"
"        ),\n"
"        embed: CType::Struct.new(\n"
"          \"\", Primitive.cexpr!(\"SIZEOF(((struct RString *)NULL)->as.embed)\"),\n"
"          ary: [CType::Array.new { CType::Immediate.parse(\"char\") }, Primitive.cexpr!(\"OFFSETOF(((struct RString *)NULL)->as.embed, ary)\")],\n"
"        ),\n"
"      ), Primitive.cexpr!(\"OFFSETOF((*((struct RString *)NULL)), as)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.RStruct\n"
,
#line 841 "rjit_c.rb"
"    @RStruct ||= CType::Struct.new(\n"
"      \"RStruct\", Primitive.cexpr!(\"SIZEOF(struct RStruct)\"),\n"
"      basic: [self.RBasic, Primitive.cexpr!(\"OFFSETOF((*((struct RStruct *)NULL)), basic)\")],\n"
"      as: [CType::Union.new(\n"
"        \"\", Primitive.cexpr!(\"SIZEOF(((struct RStruct *)NULL)->as)\"),\n"
"        heap: CType::Struct.new(\n"
"          \"\", Primitive.cexpr!(\"SIZEOF(((struct RStruct *)NULL)->as.heap)\"),\n"
,
#line 848 "rjit_c.rb"
"          len: [CType::Immediate.parse(\"long\"), Primitive.cexpr!(\"OFFSETOF(((struct RStruct *)NULL)->as.heap, len)\")],\n"
"          ptr: [CType::Pointer.new { self.VALUE }, Primitive.cexpr!(\"OFFSETOF(((struct RStruct *)NULL)->as.heap, ptr)\")],\n"
"        ),\n"
"        ary: CType::Array.new { self.VALUE },\n"
"      ), Primitive.cexpr!(\"OFFSETOF((*((struct RStruct *)NULL)), as)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.attr_index_t\n"
"    @attr_index_t ||= CType::Immediate.parse(\"uint32_t\")\n"
"  end\n"
"\n"
"  def C.iseq_inline_constant_cache\n"
,
#line 861 "rjit_c.rb"
"    @iseq_inline_constant_cache ||= CType::Struct.new(\n"
"      \"iseq_inline_constant_cache\", Primitive.cexpr!(\"SIZEOF(struct iseq_inline_constant_cache)\"),\n"
"      entry: [CType::Pointer.new { self.iseq_inline_constant_cache_entry }, Primitive.cexpr!(\"OFFSETOF((*((struct iseq_inline_constant_cache *)NULL)), entry)\")],\n"
"      segments: [CType::Pointer.new { self.ID }, Primitive.cexpr!(\"OFFSETOF((*((struct iseq_inline_constant_cache *)NULL)), segments)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.iseq_inline_constant_cache_entry\n"
,
#line 869 "rjit_c.rb"
"    @iseq_inline_constant_cache_entry ||= CType::Struct.new(\n"
"      \"iseq_inline_constant_cache_entry\", Primitive.cexpr!(\"SIZEOF(struct iseq_inline_constant_cache_entry)\"),\n"
"      flags: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct iseq_inline_constant_cache_entry *)NULL)), flags)\")],\n"
"      value: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct iseq_inline_constant_cache_entry *)NULL)), value)\")],\n"
,
#line 873 "rjit_c.rb"
"      _unused1: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct iseq_inline_constant_cache_entry *)NULL)), _unused1)\")],\n"
"      _unused2: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct iseq_inline_constant_cache_entry *)NULL)), _unused2)\")],\n"
"      ic_cref: [CType::Pointer.new { self.rb_cref_t }, Primitive.cexpr!(\"OFFSETOF((*((struct iseq_inline_constant_cache_entry *)NULL)), ic_cref)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.iseq_inline_iv_cache_entry\n"
"    @iseq_inline_iv_cache_entry ||= CType::Struct.new(\n"
,
#line 881 "rjit_c.rb"
"      \"iseq_inline_iv_cache_entry\", Primitive.cexpr!(\"SIZEOF(struct iseq_inline_iv_cache_entry)\"),\n"
"      value: [CType::Immediate.parse(\"uintptr_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct iseq_inline_iv_cache_entry *)NULL)), value)\")],\n"
"      iv_set_name: [self.ID, Primitive.cexpr!(\"OFFSETOF((*((struct iseq_inline_iv_cache_entry *)NULL)), iv_set_name)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.iseq_inline_storage_entry\n"
"    @iseq_inline_storage_entry ||= CType::Union.new(\n"
,
#line 889 "rjit_c.rb"
"      \"iseq_inline_storage_entry\", Primitive.cexpr!(\"SIZEOF(union iseq_inline_storage_entry)\"),\n"
"      once: CType::Struct.new(\n"
"        \"\", Primitive.cexpr!(\"SIZEOF(((union iseq_inline_storage_entry *)NULL)->once)\"),\n"
"        running_thread: [CType::Pointer.new { self.rb_thread_struct }, Primitive.cexpr!(\"OFFSETOF(((union iseq_inline_storage_entry *)NULL)->once, running_thread)\")],\n"
"        value: [self.VALUE, Primitive.cexpr!(\"OFFSETOF(((union iseq_inline_storage_entry *)NULL)->once, value)\")],\n"
"      ),\n"
,
#line 895 "rjit_c.rb"
"      ic_cache: self.iseq_inline_constant_cache,\n"
"      iv_cache: self.iseq_inline_iv_cache_entry,\n"
"    )\n"
"  end\n"
"\n"
"  def C.method_optimized_type\n"
"    @method_optimized_type ||= CType::Immediate.parse(\"int\")\n"
"  end\n"
"\n"
"  def C.rb_block\n"
"    @rb_block ||= CType::Struct.new(\n"
"      \"rb_block\", Primitive.cexpr!(\"SIZEOF(struct rb_block)\"),\n"
"      as: [CType::Union.new(\n"
"        \"\", Primitive.cexpr!(\"SIZEOF(((struct rb_block *)NULL)->as)\"),\n"
"        captured: self.rb_captured_block,\n"
"        symbol: self.VALUE,\n"
,
#line 911 "rjit_c.rb"
"        proc: self.VALUE,\n"
"      ), Primitive.cexpr!(\"OFFSETOF((*((struct rb_block *)NULL)), as)\")],\n"
"      type: [self.rb_block_type, Primitive.cexpr!(\"OFFSETOF((*((struct rb_block *)NULL)), type)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.rb_block_type\n"
"    @rb_block_type ||= CType::Immediate.parse(\"int\")\n"
"  end\n"
"\n"
"  def C.rb_builtin_function\n"
"    @rb_builtin_function ||= CType::Struct.new(\n"
"      \"rb_builtin_function\", Primitive.cexpr!(\"SIZEOF(struct rb_builtin_function)\"),\n"
,
#line 924 "rjit_c.rb"
"      func_ptr: [CType::Immediate.parse(\"void *\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_builtin_function *)NULL)), func_ptr)\")],\n"
"      argc: [CType::Immediate.parse(\"int\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_builtin_function *)NULL)), argc)\")],\n"
"      index: [CType::Immediate.parse(\"int\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_builtin_function *)NULL)), index)\")],\n"
,
#line 927 "rjit_c.rb"
"      name: [CType::Pointer.new { CType::Immediate.parse(\"char\") }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_builtin_function *)NULL)), name)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.rb_call_data\n"
"    @rb_call_data ||= CType::Struct.new(\n"
"      \"rb_call_data\", Primitive.cexpr!(\"SIZEOF(struct rb_call_data)\"),\n"
"      ci: [CType::Pointer.new { self.rb_callinfo }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_call_data *)NULL)), ci)\")],\n"
,
#line 935 "rjit_c.rb"
"      cc: [CType::Pointer.new { self.rb_callcache }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_call_data *)NULL)), cc)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.rb_callable_method_entry_struct\n"
"    @rb_callable_method_entry_struct ||= CType::Struct.new(\n"
"      \"rb_callable_method_entry_struct\", Primitive.cexpr!(\"SIZEOF(struct rb_callable_method_entry_struct)\"),\n"
"      flags: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_callable_method_entry_struct *)NULL)), flags)\")],\n"
,
#line 943 "rjit_c.rb"
"      defined_class: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_callable_method_entry_struct *)NULL)), defined_class)\"), true],\n"
"      def: [CType::Pointer.new { self.rb_method_definition_struct }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_callable_method_entry_struct *)NULL)), def)\")],\n"
"      called_id: [self.ID, Primitive.cexpr!(\"OFFSETOF((*((struct rb_callable_method_entry_struct *)NULL)), called_id)\")],\n"
,
#line 946 "rjit_c.rb"
"      owner: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_callable_method_entry_struct *)NULL)), owner)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.rb_callable_method_entry_t\n"
"    @rb_callable_method_entry_t ||= CType::Struct.new(\n"
"      \"rb_callable_method_entry_struct\", Primitive.cexpr!(\"SIZEOF(struct rb_callable_method_entry_struct)\"),\n"
"      flags: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_callable_method_entry_struct *)NULL)), flags)\")],\n"
,
#line 954 "rjit_c.rb"
"      defined_class: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_callable_method_entry_struct *)NULL)), defined_class)\"), true],\n"
"      def: [CType::Pointer.new { self.rb_method_definition_struct }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_callable_method_entry_struct *)NULL)), def)\")],\n"
"      called_id: [self.ID, Primitive.cexpr!(\"OFFSETOF((*((struct rb_callable_method_entry_struct *)NULL)), called_id)\")],\n"
,
#line 957 "rjit_c.rb"
"      owner: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_callable_method_entry_struct *)NULL)), owner)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.rb_callcache\n"
"    @rb_callcache ||= CType::Struct.new(\n"
"      \"rb_callcache\", Primitive.cexpr!(\"SIZEOF(struct rb_callcache)\"),\n"
"      flags: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_callcache *)NULL)), flags)\")],\n"
"      klass: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_callcache *)NULL)), klass)\")],\n"
,
#line 966 "rjit_c.rb"
"      cme_: [CType::Pointer.new { self.rb_callable_method_entry_struct }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_callcache *)NULL)), cme_)\")],\n"
"      call_: [self.vm_call_handler, Primitive.cexpr!(\"OFFSETOF((*((struct rb_callcache *)NULL)), call_)\")],\n"
"      aux_: [CType::Union.new(\n"
"        \"\", Primitive.cexpr!(\"SIZEOF(((struct rb_callcache *)NULL)->aux_)\"),\n"
"        attr: CType::Struct.new(\n"
"          \"\", Primitive.cexpr!(\"SIZEOF(((struct rb_callcache *)NULL)->aux_.attr)\"),\n"
,
#line 972 "rjit_c.rb"
"          value: [CType::Immediate.parse(\"uintptr_t\"), Primitive.cexpr!(\"OFFSETOF(((struct rb_callcache *)NULL)->aux_.attr, value)\")],\n"
"        ),\n"
"        method_missing_reason: self.method_missing_reason,\n"
"        v: self.VALUE,\n"
"        bf: CType::Pointer.new { self.rb_builtin_function },\n"
"      ), Primitive.cexpr!(\"OFFSETOF((*((struct rb_callcache *)NULL)), aux_)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.rb_callinfo\n"
"    @rb_callinfo ||= CType::Struct.new(\n"
,
#line 983 "rjit_c.rb"
"      \"rb_callinfo\", Primitive.cexpr!(\"SIZEOF(struct rb_callinfo)\"),\n"
"      flags: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_callinfo *)NULL)), flags)\")],\n"
"      kwarg: [CType::Pointer.new { self.rb_callinfo_kwarg }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_callinfo *)NULL)), kwarg)\")],\n"
"      mid: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_callinfo *)NULL)), mid)\")],\n"
"      flag: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_callinfo *)NULL)), flag)\")],\n"
,
#line 988 "rjit_c.rb"
"      argc: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_callinfo *)NULL)), argc)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.rb_callinfo_kwarg\n"
"    @rb_callinfo_kwarg ||= CType::Struct.new(\n"
"      \"rb_callinfo_kwarg\", Primitive.cexpr!(\"SIZEOF(struct rb_callinfo_kwarg)\"),\n"
"      keyword_len: [CType::Immediate.parse(\"int\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_callinfo_kwarg *)NULL)), keyword_len)\")],\n"
,
#line 996 "rjit_c.rb"
"      references: [CType::Immediate.parse(\"int\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_callinfo_kwarg *)NULL)), references)\")],\n"
"      keywords: [CType::Immediate.parse(\"void *\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_callinfo_kwarg *)NULL)), keywords)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.rb_captured_block\n"
"    @rb_captured_block ||= CType::Struct.new(\n"
"      \"rb_captured_block\", Primitive.cexpr!(\"SIZEOF(struct rb_captured_block)\"),\n"
,
#line 1004 "rjit_c.rb"
"      self: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_captured_block *)NULL)), self)\")],\n"
"      ep: [CType::Pointer.new { self.VALUE }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_captured_block *)NULL)), ep)\")],\n"
"      code: [CType::Union.new(\n"
"        \"\", Primitive.cexpr!(\"SIZEOF(((struct rb_captured_block *)NULL)->code)\"),\n"
"        iseq: CType::Pointer.new { self.rb_iseq_t },\n"
"        ifunc: CType::Pointer.new { self.vm_ifunc },\n"
"        val: self.VALUE,\n"
,
#line 1011 "rjit_c.rb"
"      ), Primitive.cexpr!(\"OFFSETOF((*((struct rb_captured_block *)NULL)), code)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.rb_cfunc_t\n"
"    @rb_cfunc_t ||= self.VALUE\n"
"  end\n"
"\n"
"  def C.rb_control_frame_t\n"
"    @rb_control_frame_t ||= CType::Struct.new(\n"
"      \"rb_control_frame_struct\", Primitive.cexpr!(\"SIZEOF(struct rb_control_frame_struct)\"),\n"
"      pc: [CType::Pointer.new { self.VALUE }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_control_frame_struct *)NULL)), pc)\")],\n"
,
#line 1023 "rjit_c.rb"
"      sp: [CType::Pointer.new { self.VALUE }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_control_frame_struct *)NULL)), sp)\")],\n"
"      iseq: [CType::Pointer.new { self.rb_iseq_t }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_control_frame_struct *)NULL)), iseq)\")],\n"
"      self: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_control_frame_struct *)NULL)), self)\")],\n"
"      ep: [CType::Pointer.new { self.VALUE }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_control_frame_struct *)NULL)), ep)\")],\n"
,
#line 1027 "rjit_c.rb"
"      block_code: [CType::Immediate.parse(\"void *\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_control_frame_struct *)NULL)), block_code)\")],\n"
"      jit_return: [CType::Pointer.new { CType::Immediate.parse(\"void\") }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_control_frame_struct *)NULL)), jit_return)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.rb_cref_t\n"
"    @rb_cref_t ||= CType::Struct.new(\n"
"      \"rb_cref_struct\", Primitive.cexpr!(\"SIZEOF(struct rb_cref_struct)\"),\n"
,
#line 1035 "rjit_c.rb"
"      flags: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_cref_struct *)NULL)), flags)\")],\n"
"      refinements: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_cref_struct *)NULL)), refinements)\")],\n"
"      klass_or_self: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_cref_struct *)NULL)), klass_or_self)\")],\n"
"      next: [CType::Pointer.new { self.rb_cref_struct }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_cref_struct *)NULL)), next)\")],\n"
,
#line 1039 "rjit_c.rb"
"      scope_visi: [self.rb_scope_visibility_t, Primitive.cexpr!(\"OFFSETOF((*((struct rb_cref_struct *)NULL)), scope_visi)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.rb_execution_context_struct\n"
"    @rb_execution_context_struct ||= CType::Struct.new(\n"
"      \"rb_execution_context_struct\", Primitive.cexpr!(\"SIZEOF(struct rb_execution_context_struct)\"),\n"
"      vm_stack: [CType::Pointer.new { self.VALUE }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_execution_context_struct *)NULL)), vm_stack)\")],\n"
,
#line 1047 "rjit_c.rb"
"      vm_stack_size: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_execution_context_struct *)NULL)), vm_stack_size)\")],\n"
"      cfp: [CType::Pointer.new { self.rb_control_frame_t }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_execution_context_struct *)NULL)), cfp)\")],\n"
"      tag: [CType::Pointer.new { self.rb_vm_tag }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_execution_context_struct *)NULL)), tag)\")],\n"
,
#line 1050 "rjit_c.rb"
"      interrupt_flag: [self.rb_atomic_t, Primitive.cexpr!(\"OFFSETOF((*((struct rb_execution_context_struct *)NULL)), interrupt_flag)\")],\n"
"      interrupt_mask: [self.rb_atomic_t, Primitive.cexpr!(\"OFFSETOF((*((struct rb_execution_context_struct *)NULL)), interrupt_mask)\")],\n"
"      fiber_ptr: [CType::Pointer.new { self.rb_fiber_t }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_execution_context_struct *)NULL)), fiber_ptr)\")],\n"
,
#line 1053 "rjit_c.rb"
"      thread_ptr: [CType::Pointer.new { self.rb_thread_struct }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_execution_context_struct *)NULL)), thread_ptr)\")],\n"
"      local_storage: [CType::Pointer.new { self.rb_id_table }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_execution_context_struct *)NULL)), local_storage)\")],\n"
"      local_storage_recursive_hash: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_execution_context_struct *)NULL)), local_storage_recursive_hash)\")],\n"
,
#line 1056 "rjit_c.rb"
"      local_storage_recursive_hash_for_trace: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_execution_context_struct *)NULL)), local_storage_recursive_hash_for_trace)\")],\n"
"      storage: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_execution_context_struct *)NULL)), storage)\")],\n"
"      root_lep: [CType::Pointer.new { self.VALUE }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_execution_context_struct *)NULL)), root_lep)\")],\n"
,
#line 1059 "rjit_c.rb"
"      root_svar: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_execution_context_struct *)NULL)), root_svar)\")],\n"
"      trace_arg: [CType::Pointer.new { self.rb_trace_arg_struct }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_execution_context_struct *)NULL)), trace_arg)\")],\n"
"      errinfo: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_execution_context_struct *)NULL)), errinfo)\")],\n"
,
#line 1062 "rjit_c.rb"
"      passed_block_handler: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_execution_context_struct *)NULL)), passed_block_handler)\")],\n"
"      raised_flag: [CType::Immediate.parse(\"uint8_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_execution_context_struct *)NULL)), raised_flag)\")],\n"
"      private_const_reference: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_execution_context_struct *)NULL)), private_const_reference)\")],\n"
"      machine: [CType::Struct.new(\n"
,
#line 1066 "rjit_c.rb"
"        \"\", Primitive.cexpr!(\"SIZEOF(((struct rb_execution_context_struct *)NULL)->machine)\"),\n"
"        stack_start: [CType::Pointer.new { self.VALUE }, Primitive.cexpr!(\"OFFSETOF(((struct rb_execution_context_struct *)NULL)->machine, stack_start)\")],\n"
"        stack_end: [CType::Pointer.new { self.VALUE }, Primitive.cexpr!(\"OFFSETOF(((struct rb_execution_context_struct *)NULL)->machine, stack_end)\")],\n"
,
#line 1069 "rjit_c.rb"
"        stack_maxsize: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF(((struct rb_execution_context_struct *)NULL)->machine, stack_maxsize)\")],\n"
"      ), Primitive.cexpr!(\"OFFSETOF((*((struct rb_execution_context_struct *)NULL)), machine)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.rb_execution_context_t\n"
"    @rb_execution_context_t ||= self.rb_execution_context_struct\n"
"  end\n"
"\n"
"  def C.rb_iseq_constant_body\n"
"    @rb_iseq_constant_body ||= CType::Struct.new(\n"
,
#line 1080 "rjit_c.rb"
"      \"rb_iseq_constant_body\", Primitive.cexpr!(\"SIZEOF(struct rb_iseq_constant_body)\"),\n"
"      type: [self.rb_iseq_type, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), type)\")],\n"
"      iseq_size: [CType::Immediate.parse(\"unsigned int\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), iseq_size)\")],\n"
"      iseq_encoded: [CType::Pointer.new { self.VALUE }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), iseq_encoded)\")],\n"
,
#line 1084 "rjit_c.rb"
"      param: [CType::Struct.new(\n"
"        \"\", Primitive.cexpr!(\"SIZEOF(((struct rb_iseq_constant_body *)NULL)->param)\"),\n"
"        flags: [CType::Struct.new(\n"
"          \"\", Primitive.cexpr!(\"SIZEOF(((struct rb_iseq_constant_body *)NULL)->param.flags)\"),\n"
"          has_lead: [CType::BitField.new(1, 0), 0],\n"
"          has_opt: [CType::BitField.new(1, 1), 1],\n"
"          has_rest: [CType::BitField.new(1, 2), 2],\n"
"          has_post: [CType::BitField.new(1, 3), 3],\n"
"          has_kw: [CType::BitField.new(1, 4), 4],\n"
,
#line 1093 "rjit_c.rb"
"          has_kwrest: [CType::BitField.new(1, 5), 5],\n"
"          has_block: [CType::BitField.new(1, 6), 6],\n"
"          ambiguous_param0: [CType::BitField.new(1, 7), 7],\n"
"          accepts_no_kwarg: [CType::BitField.new(1, 0), 8],\n"
"          ruby2_keywords: [CType::BitField.new(1, 1), 9],\n"
"          anon_rest: [CType::BitField.new(1, 2), 10],\n"
"          anon_kwrest: [CType::BitField.new(1, 3), 11],\n"
"          use_block: [CType::BitField.new(1, 4), 12],\n"
"          forwardable: [CType::BitField.new(1, 5), 13],\n"
,
#line 1102 "rjit_c.rb"
"        ), Primitive.cexpr!(\"OFFSETOF(((struct rb_iseq_constant_body *)NULL)->param, flags)\")],\n"
"        size: [CType::Immediate.parse(\"unsigned int\"), Primitive.cexpr!(\"OFFSETOF(((struct rb_iseq_constant_body *)NULL)->param, size)\")],\n"
"        lead_num: [CType::Immediate.parse(\"int\"), Primitive.cexpr!(\"OFFSETOF(((struct rb_iseq_constant_body *)NULL)->param, lead_num)\")],\n"
,
#line 1105 "rjit_c.rb"
"        opt_num: [CType::Immediate.parse(\"int\"), Primitive.cexpr!(\"OFFSETOF(((struct rb_iseq_constant_body *)NULL)->param, opt_num)\")],\n"
"        rest_start: [CType::Immediate.parse(\"int\"), Primitive.cexpr!(\"OFFSETOF(((struct rb_iseq_constant_body *)NULL)->param, rest_start)\")],\n"
"        post_start: [CType::Immediate.parse(\"int\"), Primitive.cexpr!(\"OFFSETOF(((struct rb_iseq_constant_body *)NULL)->param, post_start)\")],\n"
,
#line 1108 "rjit_c.rb"
"        post_num: [CType::Immediate.parse(\"int\"), Primitive.cexpr!(\"OFFSETOF(((struct rb_iseq_constant_body *)NULL)->param, post_num)\")],\n"
"        block_start: [CType::Immediate.parse(\"int\"), Primitive.cexpr!(\"OFFSETOF(((struct rb_iseq_constant_body *)NULL)->param, block_start)\")],\n"
"        opt_table: [CType::Pointer.new { self.VALUE }, Primitive.cexpr!(\"OFFSETOF(((struct rb_iseq_constant_body *)NULL)->param, opt_table)\")],\n"
,
#line 1111 "rjit_c.rb"
"        keyword: [CType::Pointer.new { self.rb_iseq_param_keyword }, Primitive.cexpr!(\"OFFSETOF(((struct rb_iseq_constant_body *)NULL)->param, keyword)\")],\n"
"      ), Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), param)\")],\n"
"      location: [self.rb_iseq_location_t, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), location)\")],\n"
"      insns_info: [self.iseq_insn_info, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), insns_info)\")],\n"
,
#line 1115 "rjit_c.rb"
"      local_table: [CType::Pointer.new { self.ID }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), local_table)\")],\n"
"      catch_table: [CType::Pointer.new { self.iseq_catch_table }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), catch_table)\")],\n"
"      parent_iseq: [CType::Pointer.new { self.rb_iseq_struct }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), parent_iseq)\")],\n"
,
#line 1118 "rjit_c.rb"
"      local_iseq: [CType::Pointer.new { self.rb_iseq_struct }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), local_iseq)\")],\n"
"      is_entries: [CType::Pointer.new { self.iseq_inline_storage_entry }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), is_entries)\")],\n"
"      call_data: [CType::Pointer.new { self.rb_call_data }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), call_data)\")],\n"
"      variable: [CType::Struct.new(\n"
,
#line 1122 "rjit_c.rb"
"        \"\", Primitive.cexpr!(\"SIZEOF(((struct rb_iseq_constant_body *)NULL)->variable)\"),\n"
"        flip_count: [self.rb_snum_t, Primitive.cexpr!(\"OFFSETOF(((struct rb_iseq_constant_body *)NULL)->variable, flip_count)\")],\n"
"        script_lines: [self.VALUE, Primitive.cexpr!(\"OFFSETOF(((struct rb_iseq_constant_body *)NULL)->variable, script_lines)\")],\n"
"        coverage: [self.VALUE, Primitive.cexpr!(\"OFFSETOF(((struct rb_iseq_constant_body *)NULL)->variable, coverage)\")],\n"
,
#line 1126 "rjit_c.rb"
"        pc2branchindex: [self.VALUE, Primitive.cexpr!(\"OFFSETOF(((struct rb_iseq_constant_body *)NULL)->variable, pc2branchindex)\")],\n"
"        original_iseq: [CType::Pointer.new { self.VALUE }, Primitive.cexpr!(\"OFFSETOF(((struct rb_iseq_constant_body *)NULL)->variable, original_iseq)\")],\n"
"      ), Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), variable)\")],\n"
,
#line 1129 "rjit_c.rb"
"      local_table_size: [CType::Immediate.parse(\"unsigned int\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), local_table_size)\")],\n"
"      ic_size: [CType::Immediate.parse(\"unsigned int\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), ic_size)\")],\n"
"      ise_size: [CType::Immediate.parse(\"unsigned int\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), ise_size)\")],\n"
,
#line 1132 "rjit_c.rb"
"      ivc_size: [CType::Immediate.parse(\"unsigned int\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), ivc_size)\")],\n"
"      icvarc_size: [CType::Immediate.parse(\"unsigned int\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), icvarc_size)\")],\n"
"      ci_size: [CType::Immediate.parse(\"unsigned int\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), ci_size)\")],\n"
,
#line 1135 "rjit_c.rb"
"      stack_max: [CType::Immediate.parse(\"unsigned int\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), stack_max)\")],\n"
"      builtin_attrs: [CType::Immediate.parse(\"unsigned int\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), builtin_attrs)\")],\n"
"      prism: [self._Bool, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), prism)\")],\n"
"      mark_bits: [CType::Union.new(\n"
,
#line 1139 "rjit_c.rb"
"        \"\", Primitive.cexpr!(\"SIZEOF(((struct rb_iseq_constant_body *)NULL)->mark_bits)\"),\n"
"        list: CType::Pointer.new { self.iseq_bits_t },\n"
"        single: self.iseq_bits_t,\n"
"      ), Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), mark_bits)\")],\n"
"      outer_variables: [CType::Pointer.new { self.rb_id_table }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), outer_variables)\")],\n"
,
#line 1144 "rjit_c.rb"
"      mandatory_only_iseq: [CType::Pointer.new { self.rb_iseq_t }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), mandatory_only_iseq)\")],\n"
"      jit_entry: [self.rb_jit_func_t, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), jit_entry)\")],\n"
"      jit_entry_calls: [CType::Immediate.parse(\"unsigned long\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), jit_entry_calls)\")],\n"
,
#line 1147 "rjit_c.rb"
"      rjit_blocks: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), rjit_blocks)\"), true],\n"
"    )\n"
"  end\n"
"\n"
"  def C.rb_iseq_location_t\n"
"    @rb_iseq_location_t ||= CType::Struct.new(\n"
"      \"rb_iseq_location_struct\", Primitive.cexpr!(\"SIZEOF(struct rb_iseq_location_struct)\"),\n"
"      pathobj: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_location_struct *)NULL)), pathobj)\"), true],\n"
,
#line 1155 "rjit_c.rb"
"      base_label: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_location_struct *)NULL)), base_label)\"), true],\n"
"      label: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_location_struct *)NULL)), label)\"), true],\n"
"      first_lineno: [CType::Immediate.parse(\"int\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_location_struct *)NULL)), first_lineno)\")],\n"
,
#line 1158 "rjit_c.rb"
"      node_id: [CType::Immediate.parse(\"int\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_location_struct *)NULL)), node_id)\")],\n"
"      code_location: [self.rb_code_location_t, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_location_struct *)NULL)), code_location)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.rb_iseq_param_keyword\n"
"    @rb_iseq_param_keyword ||= CType::Struct.new(\n"
"      \"rb_iseq_param_keyword\", Primitive.cexpr!(\"SIZEOF(struct rb_iseq_param_keyword)\"),\n"
,
#line 1166 "rjit_c.rb"
"      num: [CType::Immediate.parse(\"int\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_param_keyword *)NULL)), num)\")],\n"
"      required_num: [CType::Immediate.parse(\"int\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_param_keyword *)NULL)), required_num)\")],\n"
"      bits_start: [CType::Immediate.parse(\"int\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_param_keyword *)NULL)), bits_start)\")],\n"
,
#line 1169 "rjit_c.rb"
"      rest_start: [CType::Immediate.parse(\"int\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_param_keyword *)NULL)), rest_start)\")],\n"
"      table: [CType::Pointer.new { self.ID }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_param_keyword *)NULL)), table)\")],\n"
"      default_values: [CType::Pointer.new { self.VALUE }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_param_keyword *)NULL)), default_values)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.rb_iseq_struct\n"
"    @rb_iseq_struct ||= CType::Struct.new(\n"
,
#line 1177 "rjit_c.rb"
"      \"rb_iseq_struct\", Primitive.cexpr!(\"SIZEOF(struct rb_iseq_struct)\"),\n"
"      flags: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_struct *)NULL)), flags)\")],\n"
"      wrapper: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_struct *)NULL)), wrapper)\")],\n"
"      body: [CType::Pointer.new { self.rb_iseq_constant_body }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_struct *)NULL)), body)\")],\n"
"      aux: [CType::Union.new(\n"
,
#line 1182 "rjit_c.rb"
"        \"\", Primitive.cexpr!(\"SIZEOF(((struct rb_iseq_struct *)NULL)->aux)\"),\n"
"        compile_data: CType::Pointer.new { self.iseq_compile_data },\n"
"        loader: CType::Struct.new(\n"
"          \"\", Primitive.cexpr!(\"SIZEOF(((struct rb_iseq_struct *)NULL)->aux.loader)\"),\n"
"          obj: [self.VALUE, Primitive.cexpr!(\"OFFSETOF(((struct rb_iseq_struct *)NULL)->aux.loader, obj)\")],\n"
,
#line 1187 "rjit_c.rb"
"          index: [CType::Immediate.parse(\"int\"), Primitive.cexpr!(\"OFFSETOF(((struct rb_iseq_struct *)NULL)->aux.loader, index)\")],\n"
"        ),\n"
"        exec: CType::Struct.new(\n"
"          \"\", Primitive.cexpr!(\"SIZEOF(((struct rb_iseq_struct *)NULL)->aux.exec)\"),\n"
"          local_hooks: [CType::Pointer.new { self.rb_hook_list_struct }, Primitive.cexpr!(\"OFFSETOF(((struct rb_iseq_struct *)NULL)->aux.exec, local_hooks)\")],\n"
,
#line 1192 "rjit_c.rb"
"          global_trace_events: [self.rb_event_flag_t, Primitive.cexpr!(\"OFFSETOF(((struct rb_iseq_struct *)NULL)->aux.exec, global_trace_events)\")],\n"
"        ),\n"
"      ), Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_struct *)NULL)), aux)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.rb_iseq_t\n"
"    @rb_iseq_t ||= self.rb_iseq_struct\n"
"  end\n"
"\n"
"  def C.rb_jit_func_t\n"
"    @rb_jit_func_t ||= CType::Immediate.parse(\"void *\")\n"
"  end\n"
"\n"
"  def C.rb_method_attr_t\n"
"    @rb_method_attr_t ||= CType::Struct.new(\n"
,
#line 1208 "rjit_c.rb"
"      \"rb_method_attr_struct\", Primitive.cexpr!(\"SIZEOF(struct rb_method_attr_struct)\"),\n"
"      id: [self.ID, Primitive.cexpr!(\"OFFSETOF((*((struct rb_method_attr_struct *)NULL)), id)\")],\n"
"      location: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_method_attr_struct *)NULL)), location)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.rb_method_bmethod_t\n"
"    @rb_method_bmethod_t ||= CType::Struct.new(\n"
"      \"rb_method_bmethod_struct\", Primitive.cexpr!(\"SIZEOF(struct rb_method_bmethod_struct)\"),\n"
,
#line 1217 "rjit_c.rb"
"      proc: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_method_bmethod_struct *)NULL)), proc)\")],\n"
"      hooks: [CType::Pointer.new { self.rb_hook_list_struct }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_method_bmethod_struct *)NULL)), hooks)\")],\n"
"      defined_ractor: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_method_bmethod_struct *)NULL)), defined_ractor)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.rb_method_cfunc_t\n"
"    @rb_method_cfunc_t ||= CType::Struct.new(\n"
,
#line 1225 "rjit_c.rb"
"      \"rb_method_cfunc_struct\", Primitive.cexpr!(\"SIZEOF(struct rb_method_cfunc_struct)\"),\n"
"      func: [self.rb_cfunc_t, Primitive.cexpr!(\"OFFSETOF((*((struct rb_method_cfunc_struct *)NULL)), func)\")],\n"
"      invoker: [CType::Immediate.parse(\"void *\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_method_cfunc_struct *)NULL)), invoker)\")],\n"
"      argc: [CType::Immediate.parse(\"int\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_method_cfunc_struct *)NULL)), argc)\")],\n"
"    )\n"
"  end\n"
"\n"
,
#line 1232 "rjit_c.rb"
"  def C.rb_method_definition_struct\n"
"    @rb_method_definition_struct ||= CType::Struct.new(\n"
"      \"rb_method_definition_struct\", Primitive.cexpr!(\"SIZEOF(struct rb_method_definition_struct)\"),\n"
"      type: [CType::BitField.new(4, 0), 0],\n"
"      iseq_overload: [CType::BitField.new(1, 4), 4],\n"
"      no_redef_warning: [CType::BitField.new(1, 5), 5],\n"
"      aliased: [CType::BitField.new(1, 6), 6],\n"
"      reference_count: [CType::BitField.new(28, 0), 32],\n"
"      body: [CType::Union.new(\n"
,
#line 1241 "rjit_c.rb"
"        \"\", Primitive.cexpr!(\"SIZEOF(((struct rb_method_definition_struct *)NULL)->body)\"),\n"
"        iseq: self.rb_method_iseq_t,\n"
"        cfunc: self.rb_method_cfunc_t,\n"
"        attr: self.rb_method_attr_t,\n"
"        alias: self.rb_method_alias_t,\n"
"        refined: self.rb_method_refined_t,\n"
"        bmethod: self.rb_method_bmethod_t,\n"
"        optimized: self.rb_method_optimized_t,\n"
"      ), Primitive.cexpr!(\"OFFSETOF((*((struct rb_method_definition_struct *)NULL)), body)\")],\n"
,
#line 1250 "rjit_c.rb"
"      original_id: [self.ID, Primitive.cexpr!(\"OFFSETOF((*((struct rb_method_definition_struct *)NULL)), original_id)\")],\n"
"      method_serial: [CType::Immediate.parse(\"uintptr_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_method_definition_struct *)NULL)), method_serial)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.rb_method_entry_t\n"
"    @rb_method_entry_t ||= CType::Struct.new(\n"
"      \"rb_method_entry_struct\", Primitive.cexpr!(\"SIZEOF(struct rb_method_entry_struct)\"),\n"
,
#line 1258 "rjit_c.rb"
"      flags: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_method_entry_struct *)NULL)), flags)\")],\n"
"      defined_class: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_method_entry_struct *)NULL)), defined_class)\")],\n"
"      def: [CType::Pointer.new { self.rb_method_definition_struct }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_method_entry_struct *)NULL)), def)\")],\n"
"      called_id: [self.ID, Primitive.cexpr!(\"OFFSETOF((*((struct rb_method_entry_struct *)NULL)), called_id)\")],\n"
,
#line 1262 "rjit_c.rb"
"      owner: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_method_entry_struct *)NULL)), owner)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.rb_method_iseq_t\n"
"    @rb_method_iseq_t ||= CType::Struct.new(\n"
"      \"rb_method_iseq_struct\", Primitive.cexpr!(\"SIZEOF(struct rb_method_iseq_struct)\"),\n"
"      iseqptr: [CType::Pointer.new { self.rb_iseq_t }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_method_iseq_struct *)NULL)), iseqptr)\")],\n"
,
#line 1270 "rjit_c.rb"
"      cref: [CType::Pointer.new { self.rb_cref_t }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_method_iseq_struct *)NULL)), cref)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.rb_method_optimized_t\n"
"    @rb_method_optimized_t ||= CType::Struct.new(\n"
"      \"rb_method_optimized\", Primitive.cexpr!(\"SIZEOF(struct rb_method_optimized)\"),\n"
"      type: [self.method_optimized_type, Primitive.cexpr!(\"OFFSETOF((*((struct rb_method_optimized *)NULL)), type)\")],\n"
,
#line 1278 "rjit_c.rb"
"      index: [CType::Immediate.parse(\"unsigned int\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_method_optimized *)NULL)), index)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.rb_method_type_t\n"
"    @rb_method_type_t ||= CType::Immediate.parse(\"int\")\n"
"  end\n"
"\n"
"  def C.rb_proc_t\n"
"    @rb_proc_t ||= CType::Struct.new(\n"
"      \"\", Primitive.cexpr!(\"SIZEOF(rb_proc_t)\"),\n"
"      block: [self.rb_block, Primitive.cexpr!(\"OFFSETOF((*((rb_proc_t *)NULL)), block)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.rb_rjit_options\n"
,
#line 1294 "rjit_c.rb"
"    @rb_rjit_options ||= CType::Struct.new(\n"
"      \"rb_rjit_options\", Primitive.cexpr!(\"SIZEOF(struct rb_rjit_options)\"),\n"
"      on: [self._Bool, Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_options *)NULL)), on)\")],\n"
"      exec_mem_size: [CType::Immediate.parse(\"unsigned int\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_options *)NULL)), exec_mem_size)\")],\n"
"      call_threshold: [CType::Immediate.parse(\"unsigned int\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_options *)NULL)), call_threshold)\")],\n"
,
#line 1299 "rjit_c.rb"
"      stats: [self._Bool, Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_options *)NULL)), stats)\")],\n"
"      disable: [self._Bool, Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_options *)NULL)), disable)\")],\n"
"      trace: [self._Bool, Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_options *)NULL)), trace)\")],\n"
"      trace_exits: [self._Bool, Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_options *)NULL)), trace_exits)\")],\n"
,
#line 1303 "rjit_c.rb"
"      dump_disasm: [self._Bool, Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_options *)NULL)), dump_disasm)\")],\n"
"      verify_ctx: [self._Bool, Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_options *)NULL)), verify_ctx)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.rb_rjit_runtime_counters\n"
"    @rb_rjit_runtime_counters ||= CType::Struct.new(\n"
"      \"rb_rjit_runtime_counters\", Primitive.cexpr!(\"SIZEOF(struct rb_rjit_runtime_counters)\"),\n"
,
#line 1311 "rjit_c.rb"
"      rjit_insns_count: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), rjit_insns_count)\")],\n"
"      send_args_splat_kw_splat: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_args_splat_kw_splat)\")],\n"
"      send_args_splat: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_args_splat)\")],\n"
,
#line 1314 "rjit_c.rb"
"      send_args_splat_not_array: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_args_splat_not_array)\")],\n"
"      send_args_splat_length_not_equal: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_args_splat_length_not_equal)\")],\n"
,
#line 1316 "rjit_c.rb"
"      send_args_splat_cfunc_var_args: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_args_splat_cfunc_var_args)\")],\n"
"      send_args_splat_arity_error: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_args_splat_arity_error)\")],\n"
,
#line 1318 "rjit_c.rb"
"      send_args_splat_ruby2_hash: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_args_splat_ruby2_hash)\")],\n"
"      send_args_splat_cfunc_zuper: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_args_splat_cfunc_zuper)\")],\n"
,
#line 1320 "rjit_c.rb"
"      send_args_splat_cfunc_ruby2_keywords: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_args_splat_cfunc_ruby2_keywords)\")],\n"
"      send_kw_splat: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_kw_splat)\")],\n"
"      send_kwarg: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_kwarg)\")],\n"
,
#line 1323 "rjit_c.rb"
"      send_klass_megamorphic: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_klass_megamorphic)\")],\n"
"      send_missing_cme: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_missing_cme)\")],\n"
"      send_private: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_private)\")],\n"
,
#line 1326 "rjit_c.rb"
"      send_protected_check_failed: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_protected_check_failed)\")],\n"
"      send_tailcall: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_tailcall)\")],\n"
"      send_notimplemented: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_notimplemented)\")],\n"
,
#line 1329 "rjit_c.rb"
"      send_missing: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_missing)\")],\n"
"      send_bmethod: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_bmethod)\")],\n"
"      send_alias: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_alias)\")],\n"
,
#line 1332 "rjit_c.rb"
"      send_undef: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_undef)\")],\n"
"      send_zsuper: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_zsuper)\")],\n"
"      send_refined: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_refined)\")],\n"
,
#line 1335 "rjit_c.rb"
"      send_stackoverflow: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_stackoverflow)\")],\n"
"      send_arity: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_arity)\")],\n"
"      send_c_tracing: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_c_tracing)\")],\n"
,
#line 1338 "rjit_c.rb"
"      send_is_a_class_mismatch: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_is_a_class_mismatch)\")],\n"
"      send_instance_of_class_mismatch: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_instance_of_class_mismatch)\")],\n"
"      send_keywords: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_keywords)\")],\n"
,
#line 1341 "rjit_c.rb"
"      send_blockiseq: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_blockiseq)\")],\n"
"      send_block_handler: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_block_handler)\")],\n"
"      send_block_setup: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_block_setup)\")],\n"
,
#line 1344 "rjit_c.rb"
"      send_block_not_nil: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_block_not_nil)\")],\n"
"      send_block_not_proxy: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_block_not_proxy)\")],\n"
"      send_block_arg: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_block_arg)\")],\n"
,
#line 1347 "rjit_c.rb"
"      send_iseq_kwparam: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_iseq_kwparam)\")],\n"
"      send_iseq_accepts_no_kwarg: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_iseq_accepts_no_kwarg)\")],\n"
"      send_iseq_has_opt: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_iseq_has_opt)\")],\n"
,
#line 1350 "rjit_c.rb"
"      send_iseq_has_kwrest: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_iseq_has_kwrest)\")],\n"
"      send_iseq_ruby2_keywords: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_iseq_ruby2_keywords)\")],\n"
,
#line 1352 "rjit_c.rb"
"      send_iseq_has_rest_and_captured: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_iseq_has_rest_and_captured)\")],\n"
"      send_iseq_has_rest_and_kw_supplied: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_iseq_has_rest_and_kw_supplied)\")],\n"
,
#line 1354 "rjit_c.rb"
"      send_iseq_has_no_kw: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_iseq_has_no_kw)\")],\n"
"      send_iseq_zsuper: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_iseq_zsuper)\")],\n"
"      send_iseq_materialized_block: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_iseq_materialized_block)\")],\n"
,
#line 1357 "rjit_c.rb"
"      send_iseq_has_rest: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_iseq_has_rest)\")],\n"
"      send_iseq_block_arg0_splat: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_iseq_block_arg0_splat)\")],\n"
"      send_iseq_kw_call: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_iseq_kw_call)\")],\n"
,
#line 1360 "rjit_c.rb"
"      send_iseq_kw_splat: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_iseq_kw_splat)\")],\n"
"      send_iseq_splat: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_iseq_splat)\")],\n"
"      send_iseq_has_rest_and_optional: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_iseq_has_rest_and_optional)\")],\n"
,
#line 1363 "rjit_c.rb"
"      send_iseq_arity_error: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_iseq_arity_error)\")],\n"
"      send_iseq_missing_optional_kw: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_iseq_missing_optional_kw)\")],\n"
,
#line 1365 "rjit_c.rb"
"      send_iseq_too_many_kwargs: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_iseq_too_many_kwargs)\")],\n"
"      send_iseq_kwargs_mismatch: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_iseq_kwargs_mismatch)\")],\n"
,
#line 1367 "rjit_c.rb"
"      send_iseq_splat_with_kw: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_iseq_splat_with_kw)\")],\n"
"      send_iseq_splat_arity_error: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_iseq_splat_arity_error)\")],\n"
,
#line 1369 "rjit_c.rb"
"      send_iseq_has_rest_and_splat_not_equal: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_iseq_has_rest_and_splat_not_equal)\")],\n"
"      send_cfunc_variadic: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_cfunc_variadic)\")],\n"
,
#line 1371 "rjit_c.rb"
"      send_cfunc_too_many_args: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_cfunc_too_many_args)\")],\n"
"      send_cfunc_ruby_array_varg: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_cfunc_ruby_array_varg)\")],\n"
,
#line 1373 "rjit_c.rb"
"      send_cfunc_splat_with_kw: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_cfunc_splat_with_kw)\")],\n"
"      send_cfunc_tracing: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_cfunc_tracing)\")],\n"
"      send_cfunc_argc_mismatch: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_cfunc_argc_mismatch)\")],\n"
,
#line 1376 "rjit_c.rb"
"      send_cfunc_toomany_args: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_cfunc_toomany_args)\")],\n"
"      send_attrset_splat: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_attrset_splat)\")],\n"
"      send_attrset_kwarg: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_attrset_kwarg)\")],\n"
,
#line 1379 "rjit_c.rb"
"      send_attrset_method: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_attrset_method)\")],\n"
"      send_ivar_splat: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_ivar_splat)\")],\n"
"      send_ivar_opt_send: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_ivar_opt_send)\")],\n"
,
#line 1382 "rjit_c.rb"
"      send_optimized_send_no_args: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_optimized_send_no_args)\")],\n"
"      send_optimized_send_not_sym_or_str: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_optimized_send_not_sym_or_str)\")],\n"
,
#line 1384 "rjit_c.rb"
"      send_optimized_send_mid_class_changed: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_optimized_send_mid_class_changed)\")],\n"
"      send_optimized_send_mid_id_changed: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_optimized_send_mid_id_changed)\")],\n"
,
#line 1386 "rjit_c.rb"
"      send_optimized_send_null_mid: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_optimized_send_null_mid)\")],\n"
"      send_optimized_send_send: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_optimized_send_send)\")],\n"
,
#line 1388 "rjit_c.rb"
"      send_optimized_call_block: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_optimized_call_block)\")],\n"
"      send_optimized_call_kwarg: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_optimized_call_kwarg)\")],\n"
,
#line 1390 "rjit_c.rb"
"      send_optimized_call_splat: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_optimized_call_splat)\")],\n"
"      send_optimized_struct_aref_error: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_optimized_struct_aref_error)\")],\n"
,
#line 1392 "rjit_c.rb"
"      send_optimized_block_call: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_optimized_block_call)\")],\n"
"      send_optimized_struct_aset: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_optimized_struct_aset)\")],\n"
,
#line 1394 "rjit_c.rb"
"      send_bmethod_not_iseq: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_bmethod_not_iseq)\")],\n"
"      send_bmethod_blockarg: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), send_bmethod_blockarg)\")],\n"
"      invokesuper_me_changed: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), invokesuper_me_changed)\")],\n"
,
#line 1397 "rjit_c.rb"
"      invokesuper_block: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), invokesuper_block)\")],\n"
"      invokeblock_none: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), invokeblock_none)\")],\n"
"      invokeblock_symbol: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), invokeblock_symbol)\")],\n"
,
#line 1400 "rjit_c.rb"
"      invokeblock_proc: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), invokeblock_proc)\")],\n"
"      invokeblock_tag_changed: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), invokeblock_tag_changed)\")],\n"
"      invokeblock_iseq_block_changed: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), invokeblock_iseq_block_changed)\")],\n"
,
#line 1403 "rjit_c.rb"
"      invokeblock_iseq_arity: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), invokeblock_iseq_arity)\")],\n"
"      invokeblock_iseq_arg0_splat: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), invokeblock_iseq_arg0_splat)\")],\n"
,
#line 1405 "rjit_c.rb"
"      invokeblock_ifunc_args_splat: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), invokeblock_ifunc_args_splat)\")],\n"
"      invokeblock_ifunc_kw_splat: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), invokeblock_ifunc_kw_splat)\")],\n"
,
#line 1407 "rjit_c.rb"
"      invokeblock_iseq_arg0_args_splat: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), invokeblock_iseq_arg0_args_splat)\")],\n"
"      invokeblock_iseq_arg0_has_kw: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), invokeblock_iseq_arg0_has_kw)\")],\n"
,
#line 1409 "rjit_c.rb"
"      getivar_megamorphic: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), getivar_megamorphic)\")],\n"
"      getivar_not_heap: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), getivar_not_heap)\")],\n"
"      getivar_special_const: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), getivar_special_const)\")],\n"
,
#line 1412 "rjit_c.rb"
"      getivar_too_complex: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), getivar_too_complex)\")],\n"
"      optaref_arg_not_fixnum: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), optaref_arg_not_fixnum)\")],\n"
"      optaref_argc_not_one: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), optaref_argc_not_one)\")],\n"
,
#line 1415 "rjit_c.rb"
"      optaref_recv_not_array: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), optaref_recv_not_array)\")],\n"
"      optaref_recv_not_hash: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), optaref_recv_not_hash)\")],\n"
"      optaref_send: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), optaref_send)\")],\n"
,
#line 1418 "rjit_c.rb"
"      optgetconst_not_cached: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), optgetconst_not_cached)\")],\n"
"      optgetconst_cref: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), optgetconst_cref)\")],\n"
"      optgetconst_cache_miss: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), optgetconst_cache_miss)\")],\n"
,
#line 1421 "rjit_c.rb"
"      setivar_frozen: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), setivar_frozen)\")],\n"
"      setivar_not_heap: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), setivar_not_heap)\")],\n"
"      setivar_megamorphic: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), setivar_megamorphic)\")],\n"
,
#line 1424 "rjit_c.rb"
"      setivar_too_complex: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), setivar_too_complex)\")],\n"
"      expandarray_splat: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), expandarray_splat)\")],\n"
"      expandarray_postarg: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), expandarray_postarg)\")],\n"
,
#line 1427 "rjit_c.rb"
"      expandarray_not_array: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), expandarray_not_array)\")],\n"
"      expandarray_rhs_too_small: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), expandarray_rhs_too_small)\")],\n"
,
#line 1429 "rjit_c.rb"
"      getblockpp_block_param_modified: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), getblockpp_block_param_modified)\")],\n"
"      getblockpp_block_handler_none: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), getblockpp_block_handler_none)\")],\n"
,
#line 1431 "rjit_c.rb"
"      getblockpp_not_gc_guarded: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), getblockpp_not_gc_guarded)\")],\n"
"      getblockpp_not_iseq_block: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), getblockpp_not_iseq_block)\")],\n"
"      compiled_block_count: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_rjit_runtime_counters *)NULL)), compiled_block_count)\")],\n"
,
#line 1434 "rjit_c.rb"
"    )\n"
"  end\n"
"\n"
"  def C.rb_serial_t\n"
"    @rb_serial_t ||= CType::Immediate.parse(\"unsigned long long\")\n"
"  end\n"
"\n"
"  def C.rb_shape\n"
"    @rb_shape ||= CType::Struct.new(\n"
"      \"rb_shape\", Primitive.cexpr!(\"SIZEOF(struct rb_shape)\"),\n"
"      edges: [CType::Pointer.new { self.rb_id_table }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_shape *)NULL)), edges)\")],\n"
"      edge_name: [self.ID, Primitive.cexpr!(\"OFFSETOF((*((struct rb_shape *)NULL)), edge_name)\")],\n"
,
#line 1446 "rjit_c.rb"
"      next_iv_index: [self.attr_index_t, Primitive.cexpr!(\"OFFSETOF((*((struct rb_shape *)NULL)), next_iv_index)\")],\n"
"      capacity: [CType::Immediate.parse(\"uint32_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_shape *)NULL)), capacity)\")],\n"
"      type: [CType::Immediate.parse(\"uint8_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_shape *)NULL)), type)\")],\n"
"      heap_index: [CType::Immediate.parse(\"uint8_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_shape *)NULL)), heap_index)\")],\n"
,
#line 1450 "rjit_c.rb"
"      parent_id: [self.shape_id_t, Primitive.cexpr!(\"OFFSETOF((*((struct rb_shape *)NULL)), parent_id)\")],\n"
"      ancestor_index: [CType::Pointer.new { self.redblack_node_t }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_shape *)NULL)), ancestor_index)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.rb_shape_t\n"
"    @rb_shape_t ||= self.rb_shape\n"
"  end\n"
"\n"
"  def C.rb_thread_struct\n"
"    @rb_thread_struct ||= CType::Struct.new(\n"
"      \"rb_thread_struct\", Primitive.cexpr!(\"SIZEOF(struct rb_thread_struct)\"),\n"
,
#line 1462 "rjit_c.rb"
"      lt_node: [self.ccan_list_node, Primitive.cexpr!(\"OFFSETOF((*((struct rb_thread_struct *)NULL)), lt_node)\")],\n"
"      self: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_thread_struct *)NULL)), self)\")],\n"
"      ractor: [CType::Pointer.new { self.rb_ractor_t }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_thread_struct *)NULL)), ractor)\")],\n"
"      vm: [CType::Pointer.new { self.rb_vm_t }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_thread_struct *)NULL)), vm)\")],\n"
,
#line 1466 "rjit_c.rb"
"      nt: [CType::Pointer.new { self.rb_native_thread }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_thread_struct *)NULL)), nt)\")],\n"
"      ec: [CType::Pointer.new { self.rb_execution_context_t }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_thread_struct *)NULL)), ec)\")],\n"
"      sched: [self.rb_thread_sched_item, Primitive.cexpr!(\"OFFSETOF((*((struct rb_thread_struct *)NULL)), sched)\")],\n"
"      mn_schedulable: [self._Bool, Primitive.cexpr!(\"OFFSETOF((*((struct rb_thread_struct *)NULL)), mn_schedulable)\")],\n"
,
#line 1470 "rjit_c.rb"
"      serial: [self.rb_atomic_t, Primitive.cexpr!(\"OFFSETOF((*((struct rb_thread_struct *)NULL)), serial)\")],\n"
"      last_status: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_thread_struct *)NULL)), last_status)\")],\n"
"      calling: [CType::Pointer.new { self.rb_calling_info }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_thread_struct *)NULL)), calling)\")],\n"
"      top_self: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_thread_struct *)NULL)), top_self)\")],\n"
,
#line 1474 "rjit_c.rb"
"      top_wrapper: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_thread_struct *)NULL)), top_wrapper)\")],\n"
"      priority: [CType::Immediate.parse(\"int8_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_thread_struct *)NULL)), priority)\")],\n"
"      running_time_us: [CType::Immediate.parse(\"uint32_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_thread_struct *)NULL)), running_time_us)\")],\n"
,
#line 1477 "rjit_c.rb"
"      blocking_region_buffer: [CType::Pointer.new { CType::Immediate.parse(\"void\") }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_thread_struct *)NULL)), blocking_region_buffer)\")],\n"
"      thgroup: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_thread_struct *)NULL)), thgroup)\")],\n"
"      value: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_thread_struct *)NULL)), value)\")],\n"
,
#line 1480 "rjit_c.rb"
"      pending_interrupt_queue: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_thread_struct *)NULL)), pending_interrupt_queue)\")],\n"
"      pending_interrupt_mask_stack: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_thread_struct *)NULL)), pending_interrupt_mask_stack)\")],\n"
"      interrupt_lock: [self.rb_nativethread_lock_t, Primitive.cexpr!(\"OFFSETOF((*((struct rb_thread_struct *)NULL)), interrupt_lock)\")],\n"
,
#line 1483 "rjit_c.rb"
"      unblock: [self.rb_unblock_callback, Primitive.cexpr!(\"OFFSETOF((*((struct rb_thread_struct *)NULL)), unblock)\")],\n"
"      locking_mutex: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_thread_struct *)NULL)), locking_mutex)\")],\n"
"      keeping_mutexes: [CType::Pointer.new { self.rb_mutex_struct }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_thread_struct *)NULL)), keeping_mutexes)\")],\n"
,
#line 1486 "rjit_c.rb"
"      interrupt_exec_tasks: [self.ccan_list_head, Primitive.cexpr!(\"OFFSETOF((*((struct rb_thread_struct *)NULL)), interrupt_exec_tasks)\")],\n"
"      join_list: [CType::Pointer.new { self.rb_waiting_list }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_thread_struct *)NULL)), join_list)\")],\n"
"      invoke_arg: [CType::Union.new(\n"
"        \"\", Primitive.cexpr!(\"SIZEOF(((struct rb_thread_struct *)NULL)->invoke_arg)\"),\n"
"        proc: CType::Struct.new(\n"
,
#line 1491 "rjit_c.rb"
"          \"\", Primitive.cexpr!(\"SIZEOF(((struct rb_thread_struct *)NULL)->invoke_arg.proc)\"),\n"
"          proc: [self.VALUE, Primitive.cexpr!(\"OFFSETOF(((struct rb_thread_struct *)NULL)->invoke_arg.proc, proc)\")],\n"
"          args: [self.VALUE, Primitive.cexpr!(\"OFFSETOF(((struct rb_thread_struct *)NULL)->invoke_arg.proc, args)\")],\n"
"          kw_splat: [CType::Immediate.parse(\"int\"), Primitive.cexpr!(\"OFFSETOF(((struct rb_thread_struct *)NULL)->invoke_arg.proc, kw_splat)\")],\n"
"        ),\n"
,
#line 1496 "rjit_c.rb"
"        func: CType::Struct.new(\n"
"          \"\", Primitive.cexpr!(\"SIZEOF(((struct rb_thread_struct *)NULL)->invoke_arg.func)\"),\n"
"          func: [CType::Immediate.parse(\"void *\"), Primitive.cexpr!(\"OFFSETOF(((struct rb_thread_struct *)NULL)->invoke_arg.func, func)\")],\n"
"          arg: [CType::Pointer.new { CType::Immediate.parse(\"void\") }, Primitive.cexpr!(\"OFFSETOF(((struct rb_thread_struct *)NULL)->invoke_arg.func, arg)\")],\n"
"        ),\n"
,
#line 1501 "rjit_c.rb"
"      ), Primitive.cexpr!(\"OFFSETOF((*((struct rb_thread_struct *)NULL)), invoke_arg)\")],\n"
"      invoke_type: [self.thread_invoke_type, Primitive.cexpr!(\"OFFSETOF((*((struct rb_thread_struct *)NULL)), invoke_type)\")],\n"
"      stat_insn_usage: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_thread_struct *)NULL)), stat_insn_usage)\")],\n"
"      root_fiber: [CType::Pointer.new { self.rb_fiber_t }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_thread_struct *)NULL)), root_fiber)\")],\n"
,
#line 1505 "rjit_c.rb"
"      scheduler: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_thread_struct *)NULL)), scheduler)\")],\n"
"      blocking: [CType::Immediate.parse(\"unsigned int\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_thread_struct *)NULL)), blocking)\")],\n"
"      name: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_thread_struct *)NULL)), name)\")],\n"
,
#line 1508 "rjit_c.rb"
"      specific_storage: [CType::Pointer.new { CType::Pointer.new { CType::Immediate.parse(\"void\") } }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_thread_struct *)NULL)), specific_storage)\")],\n"
"      ext_config: [self.rb_ext_config, Primitive.cexpr!(\"OFFSETOF((*((struct rb_thread_struct *)NULL)), ext_config)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.VALUE\n"
"    @VALUE ||= CType::Immediate.find(\n"
"      Primitive.cexpr!(\"SIZEOF(VALUE)\"),\n"
"      Primitive.cexpr!(\"SIGNED_TYPE_P(VALUE)\"),\n"
"    )\n"
"  end\n"
"\n"
"  def C.shape_id_t\n"
,
#line 1521 "rjit_c.rb"
"    @shape_id_t ||= CType::Immediate.find(\n"
"      Primitive.cexpr!(\"SIZEOF(shape_id_t)\"),\n"
"      Primitive.cexpr!(\"SIGNED_TYPE_P(shape_id_t)\"),\n"
"    )\n"
"  end\n"
"\n"
"  def C.rb_id_table\n"
"    CType::Stub.new(:rb_id_table)\n"
"  end\n"
"\n"
"  def C.vm_call_handler\n"
"    CType::Stub.new(:vm_call_handler)\n"
"  end\n"
"\n"
"  def C.method_missing_reason\n"
"    CType::Stub.new(:method_missing_reason)\n"
"  end\n"
"\n"
"  def C.vm_ifunc\n"
"    CType::Stub.new(:vm_ifunc)\n"
"  end\n"
"\n"
"  def C.rb_cref_struct\n"
"    CType::Stub.new(:rb_cref_struct)\n"
"  end\n"
"\n"
,
#line 1547 "rjit_c.rb"
"  def C.rb_scope_visibility_t\n"
"    CType::Stub.new(:rb_scope_visibility_t)\n"
"  end\n"
"\n"
"  def C.rb_vm_tag\n"
"    CType::Stub.new(:rb_vm_tag)\n"
"  end\n"
"\n"
"  def C.rb_atomic_t\n"
"    CType::Stub.new(:rb_atomic_t)\n"
"  end\n"
"\n"
"  def C.rb_fiber_t\n"
"    CType::Stub.new(:rb_fiber_t)\n"
"  end\n"
"\n"
"  def C.rb_trace_arg_struct\n"
"    CType::Stub.new(:rb_trace_arg_struct)\n"
"  end\n"
"\n"
"  def C.rb_iseq_type\n"
"    CType::Stub.new(:rb_iseq_type)\n"
"  end\n"
"\n"
"  def C.iseq_insn_info\n"
"    CType::Stub.new(:iseq_insn_info)\n"
"  end\n"
"\n"
"  def C.iseq_catch_table\n"
,
#line 1576 "rjit_c.rb"
"    CType::Stub.new(:iseq_catch_table)\n"
"  end\n"
"\n"
"  def C.rb_snum_t\n"
"    CType::Stub.new(:rb_snum_t)\n"
"  end\n"
"\n"
"  def C._Bool\n"
"    CType::Bool.new\n"
"  end\n"
"\n"
"  def C.iseq_bits_t\n"
"    CType::Stub.new(:iseq_bits_t)\n"
"  end\n"
"\n"
"  def C.rb_code_location_t\n"
"    CType::Stub.new(:rb_code_location_t)\n"
"  end\n"
"\n"
"  def C.iseq_compile_data\n"
"    CType::Stub.new(:iseq_compile_data)\n"
"  end\n"
"\n"
"  def C.rb_hook_list_struct\n"
"    CType::Stub.new(:rb_hook_list_struct)\n"
"  end\n"
"\n"
"  def C.rb_event_flag_t\n"
"    CType::Stub.new(:rb_event_flag_t)\n"
"  end\n"
"\n"
,
#line 1607 "rjit_c.rb"
"  def C.rb_method_alias_t\n"
"    CType::Stub.new(:rb_method_alias_t)\n"
"  end\n"
"\n"
"  def C.rb_method_refined_t\n"
"    CType::Stub.new(:rb_method_refined_t)\n"
"  end\n"
"\n"
"  def C.redblack_node_t\n"
"    CType::Stub.new(:redblack_node_t)\n"
"  end\n"
"\n"
"  def C.ccan_list_node\n"
"    CType::Stub.new(:ccan_list_node)\n"
"  end\n"
"\n"
"  def C.rb_ractor_t\n"
"    CType::Stub.new(:rb_ractor_t)\n"
"  end\n"
"\n"
"  def C.rb_vm_t\n"
"    CType::Stub.new(:rb_vm_t)\n"
"  end\n"
"\n"
"  def C.rb_native_thread\n"
"    CType::Stub.new(:rb_native_thread)\n"
"  end\n"
"\n"
"  def C.rb_thread_sched_item\n"
,
#line 1636 "rjit_c.rb"
"    CType::Stub.new(:rb_thread_sched_item)\n"
"  end\n"
"\n"
"  def C.rb_calling_info\n"
"    CType::Stub.new(:rb_calling_info)\n"
"  end\n"
"\n"
"  def C.rb_nativethread_lock_t\n"
"    CType::Stub.new(:rb_nativethread_lock_t)\n"
"  end\n"
"\n"
"  def C.rb_unblock_callback\n"
"    CType::Stub.new(:rb_unblock_callback)\n"
"  end\n"
"\n"
"  def C.rb_mutex_struct\n"
"    CType::Stub.new(:rb_mutex_struct)\n"
"  end\n"
"\n"
"  def C.ccan_list_head\n"
"    CType::Stub.new(:ccan_list_head)\n"
"  end\n"
"\n"
"  def C.rb_waiting_list\n"
"    CType::Stub.new(:rb_waiting_list)\n"
"  end\n"
"\n"
,
#line 1663 "rjit_c.rb"
"  def C.thread_invoke_type\n"
"    CType::Stub.new(:thread_invoke_type)\n"
"  end\n"
"\n"
"  def C.rb_ext_config\n"
"    CType::Stub.new(:rb_ext_config)\n"
"  end\n"
"\n"
"\n"/* # RJIT bindgen end ### */
"end if Primitive.rjit_enabled_p\n"
#line 4262 "miniprelude.c"
};

static const char prelude_name8[] = "<internal:pack>";
static const struct {
    char L0[308]; /* 1..37 */
} prelude_code8 = {
#line 1 "pack.rb"
"class Array\n"
"\n"/*  call-seq: */
"\n"/*    pack(template, buffer: nil) -> string */
"\n"/*  */
"\n"/*  Formats each element in +self+ into a binary string; returns that string. */
"\n"/*  See {Packed Data}[rdoc-ref:packed_data.rdoc]. */
"  def pack(fmt, buffer: nil)\n"
"    Primitive.pack_pack(fmt, buffer)\n"
"  end\n"
"end\n"
"\n"
"class String\n"
"\n"/* call-seq: */
"\n"/*   unpack(template, offset: 0, &block) -> array */
"\n"/*  */
"\n"/*  Extracts data from +self+. */
"\n"/*  */
"\n"/*  If +block+ is not given, forming objects that become the elements */
"\n"/*  of a new array, and returns that array.  Otherwise, yields each */
"\n"/*  object. */
"\n"/*  */
"\n"/*  See {Packed Data}[rdoc-ref:packed_data.rdoc]. */
"  def unpack(fmt, offset: 0)\n"
"    Primitive.attr! :use_block\n"
"    Primitive.pack_unpack(fmt, offset)\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*   unpack1(template, offset: 0) -> object */
"\n"/*  */
"\n"/*  Like String#unpack, but unpacks and returns only the first extracted object. */
"\n"/*  See {Packed Data}[rdoc-ref:packed_data.rdoc]. */
"  def unpack1(fmt, offset: 0)\n"
"    Primitive.pack_unpack1(fmt, offset)\n"
"  end\n"
"end\n"
#line 4306 "miniprelude.c"
};

static const char prelude_name9[] = "<internal:trace_point>";
static const struct {
    char L0[488]; /* 1..200 */
    char L200[507]; /* 201..316 */
    char L316[471]; /* 317..386 */
    char L386[413]; /* 387..424 */
} prelude_code9 = {
#line 1 "trace_point.rb"
""/* loaded from vm_trace.c */
""
""/* A class that provides the functionality of Kernel#set_trace_func in a */
""/* nice Object-Oriented API. */
""/*  */
""/* == Example */
""/*  */
""/* We can use TracePoint to gather information specifically for exceptions: */
""/*  */
""/*     trace = TracePoint.new(:raise) do |tp| */
""/* \tp [tp.lineno, tp.event, tp.raised_exception] */
""/*     end */
""/*     #=> #<TracePoint:disabled> */
""/*  */
""/*     trace.enable */
""/*     #=> false */
""/*  */
""/*     0 / 0 */
""/*     #=> [5, :raise, #<ZeroDivisionError: divided by 0>] */
""/*  */
""/* == Events */
""/*  */
""/* If you don't specify the type of events you want to listen for, */
""/* TracePoint will include all available events. */
""/*  */
""/* *Note* do not depend on current event set, as this list is subject to */
""/* change. Instead, it is recommended you specify the type of events you */
""/* want to use. */
""/*  */
""/* To filter what is traced, you can pass any of the following as +events+: */
""/*  */
""/* +:line+:: execute an expression or statement on a new line */
""/* +:class+:: start a class or module definition */
""/* +:end+:: finish a class or module definition */
""/* +:call+:: call a Ruby method */
""/* +:return+:: return from a Ruby method */
""/* +:c_call+:: call a C-language routine */
""/* +:c_return+:: return from a C-language routine */
""/* +:raise+:: raise an exception */
""/* +:rescue+:: rescue an exception */
""/* +:b_call+:: event hook at block entry */
""/* +:b_return+:: event hook at block ending */
""/* +:a_call+:: event hook at all calls (+call+, +b_call+, and +c_call+) */
""/* +:a_return+:: event hook at all returns (+return+, +b_return+, and +c_return+) */
""/* +:thread_begin+:: event hook at thread beginning */
""/* +:thread_end+:: event hook at thread ending */
""/* +:fiber_switch+:: event hook at fiber switch */
""/* +:script_compiled+:: new Ruby code compiled (with +eval+, +load+ or +require+) */
""/*  */
"class TracePoint\n"
"\n"/* call-seq: */
"\n"/* TracePoint.new(*events) { |obj| block }\t    -> obj */
"\n"/*  */
"\n"/* Returns a new TracePoint object, not enabled by default. */
"\n"/*  */
"\n"/* Next, in order to activate the trace, you must use TracePoint#enable */
"\n"/*  */
"\n"/* trace = TracePoint.new(:call) do |tp| */
"\n"/*     p [tp.lineno, tp.defined_class, tp.method_id, tp.event] */
"\n"/* end */
"\n"/* #=> #<TracePoint:disabled> */
"\n"/*  */
"\n"/* trace.enable */
"\n"/* #=> false */
"\n"/*  */
"\n"/* puts \"Hello, TracePoint!\" */
"\n"/* # ... */
"\n"/* # [48, IRB::Notifier::AbstractNotifier, :printf, :call] */
"\n"/* # ... */
"\n"/*  */
"\n"/* When you want to deactivate the trace, you must use TracePoint#disable */
"\n"/*  */
"\n"/* trace.disable */
"\n"/*  */
"\n"/* See TracePoint@Events for possible events and more information. */
"\n"/*  */
"\n"/* A block must be given, otherwise an ArgumentError is raised. */
"\n"/*  */
"\n"/* If the trace method isn't included in the given events filter, a */
"\n"/* RuntimeError is raised. */
"\n"/*  */
"\n"/* TracePoint.trace(:line) do |tp| */
"\n"/*     p tp.raised_exception */
"\n"/* end */
"\n"/* #=> RuntimeError: 'raised_exception' not supported by this event */
"\n"/*  */
"\n"/* If the trace method is called outside block, a RuntimeError is raised. */
"\n"/*  */
"\n"/*      TracePoint.trace(:line) do |tp| */
"\n"/*        $tp = tp */
"\n"/*      end */
"\n"/*      $tp.lineno #=> access from outside (RuntimeError) */
"\n"/*  */
"\n"/* Access from other threads is also forbidden. */
"\n"/*  */
"  def self.new(*events)\n"
"    Primitive.attr! :use_block\n"
"    Primitive.tracepoint_new_s(events)\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*    trace.inspect  -> string */
"\n"/*  */
"\n"/*  Return a string containing a human-readable TracePoint */
"\n"/*  status. */
"  def inspect\n"
"    Primitive.tracepoint_inspect\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/* TracePoint.stat -> obj */
"\n"/*  */
"\n"/*  Returns internal information of TracePoint. */
"\n"/*  */
"\n"/*  The contents of the returned value are implementation specific. */
"\n"/*  It may be changed in future. */
"\n"/*  */
"\n"/*  This method is only for debugging TracePoint itself. */
"  def self.stat\n"
"    Primitive.tracepoint_stat_s\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    TracePoint.trace(*events) { |obj| block }\t-> obj */
"\n"/*  */
"\n"/* A convenience method for TracePoint.new, that activates the trace */
"\n"/* automatically. */
"\n"/*  */
"\n"/*     trace = TracePoint.trace(:call) { |tp| [tp.lineno, tp.event] } */
"\n"/*     #=> #<TracePoint:enabled> */
"\n"/*  */
"\n"/*     trace.enabled? #=> true */
"\n"/*  */
"  def self.trace(*events)\n"
"    Primitive.attr! :use_block\n"
"    Primitive.tracepoint_trace_s(events)\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*   TracePoint.allow_reentry { block } */
"\n"/*  */
"\n"/* In general, while a TracePoint callback is running, */
"\n"/* other registered callbacks are not called to avoid */
"\n"/* confusion by reentrance. */
"\n"/* This method allows the reentrance in a given block. */
"\n"/* This method should be used carefully, otherwise the callback */
"\n"/* can be easily called infinitely. */
"\n"/*  */
"\n"/* If this method is called when the reentrance is already allowed, */
"\n"/* it raises a RuntimeError. */
"\n"/*  */
"\n"/* <b>Example:</b> */
"\n"/*  */
"\n"/*   # Without reentry */
"\n"/*   # --------------- */
"\n"/*  */
"\n"/*   line_handler = TracePoint.new(:line) do |tp| */
"\n"/*     next if tp.path != __FILE__ # only work in this file */
"\n"/*     puts \"Line handler\" */
"\n"/*     binding.eval(\"class C; end\") */
"\n"/*   end.enable */
"\n"/*  */
"\n"/*   class_handler = TracePoint.new(:class) do |tp| */
"\n"/*     puts \"Class handler\" */
"\n"/*   end.enable */
"\n"/*  */
"\n"/*   class B */
"\n"/*   end */
"\n"/*  */
"\n"/*   # This script will print \"Class handler\" only once: when inside :line */
"\n"/*   # handler, all other handlers are ignored */
"\n"/*  */
"\n"/*  */
"\n"/*   # With reentry */
"\n"/*   # ------------ */
"\n"/*  */
"\n"/*   line_handler = TracePoint.new(:line) do |tp| */
"\n"/*     next if tp.path != __FILE__ # only work in this file */
"\n"/*     next if (__LINE__..__LINE__+3).cover?(tp.lineno) # don't be invoked from itself */
"\n"/*     puts \"Line handler\" */
"\n"/*     TracePoint.allow_reentry { binding.eval(\"class C; end\") } */
"\n"/*   end.enable */
"\n"/*  */
"\n"/*   class_handler = TracePoint.new(:class) do |tp| */
"\n"/*     puts \"Class handler\" */
"\n"/*   end.enable */
"\n"/*  */
"\n"/*   class B */
"\n"/*   end */
"\n"/*  */
"\n"/*   # This wil print \"Class handler\" twice: inside allow_reentry block in :line */
"\n"/*   # handler, other handlers are enabled. */
"\n"/*  */
"\n"/* Note that the example shows the principal effect of the method, but its */
"\n"/* practical usage is for debugging libraries that sometimes require other libraries */
"\n"/* hooks to not be affected by debugger being inside trace point handling. Precautions */
"\n"/* should be taken against infinite recursion in this case (note that we needed to filter */
"\n"/* out calls by itself from :line handler, otherwise it will call itself infinitely). */
"\n"/*  */
"  def self.allow_reentry\n"
,
#line 201 "trace_point.rb"
"    Primitive.attr! :use_block\n"
"    Primitive.tracepoint_allow_reentry\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    trace.enable(target: nil, target_line: nil, target_thread: nil)    -> true or false */
"\n"/*    trace.enable(target: nil, target_line: nil, target_thread: :default) { block }  -> obj */
"\n"/*  */
"\n"/* Activates the trace. */
"\n"/*  */
"\n"/* Returns +true+ if trace was enabled. */
"\n"/* Returns +false+ if trace was disabled. */
"\n"/*  */
"\n"/*   trace.enabled?  #=> false */
"\n"/*   trace.enable    #=> false (previous state) */
"\n"/*                   #   trace is enabled */
"\n"/*   trace.enabled?  #=> true */
"\n"/*   trace.enable    #=> true (previous state) */
"\n"/*                   #   trace is still enabled */
"\n"/*  */
"\n"/* If a block is given, the trace will only be enabled during the block call. */
"\n"/* If target and target_line are both nil, then target_thread will default */
"\n"/* to the current thread if a block is given. */
"\n"/*  */
"\n"/*    trace.enabled? */
"\n"/*    #=> false */
"\n"/*  */
"\n"/*    trace.enable do */
"\n"/*      trace.enabled? */
"\n"/*      # only enabled for this block and thread */
"\n"/*    end */
"\n"/*  */
"\n"/*    trace.enabled? */
"\n"/*    #=> false */
"\n"/*  */
"\n"/* +target+, +target_line+ and +target_thread+ parameters are used to */
"\n"/* limit tracing only to specified code objects. +target+ should be a */
"\n"/* code object for which RubyVM::InstructionSequence.of will return */
"\n"/* an instruction sequence. */
"\n"/*  */
"\n"/*    t = TracePoint.new(:line) { |tp| p tp } */
"\n"/*  */
"\n"/*    def m1 */
"\n"/*      p 1 */
"\n"/*    end */
"\n"/*  */
"\n"/*    def m2 */
"\n"/*      p 2 */
"\n"/*    end */
"\n"/*  */
"\n"/*    t.enable(target: method(:m1)) */
"\n"/*  */
"\n"/*    m1 */
"\n"/*    # prints #<TracePoint:line test.rb:4 in `m1'> */
"\n"/*    m2 */
"\n"/*    # prints nothing */
"\n"/*  */
"\n"/* Note: You cannot access event hooks within the +enable+ block. */
"\n"/*  */
"\n"/*    trace.enable { p tp.lineno } */
"\n"/*    #=> RuntimeError: access from outside */
"\n"/*  */
"  def enable(target: nil, target_line: nil, target_thread: :default)\n"
"    Primitive.attr! :use_block\n"
"    Primitive.tracepoint_enable_m(target, target_line, target_thread)\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/* trace.disable\t\t-> true or false */
"\n"/* trace.disable { block } -> obj */
"\n"/*  */
"\n"/* Deactivates the trace */
"\n"/*  */
"\n"/* Return true if trace was enabled. */
"\n"/* Return false if trace was disabled. */
"\n"/*  */
"\n"/* trace.enabled?\t#=> true */
"\n"/* trace.disable\t#=> true (previous status) */
"\n"/* trace.enabled?\t#=> false */
"\n"/* trace.disable\t#=> false */
"\n"/*  */
"\n"/* If a block is given, the trace will only be disable within the scope of the */
"\n"/* block. */
"\n"/*  */
"\n"/* trace.enabled? */
"\n"/* #=> true */
"\n"/*  */
"\n"/* trace.disable do */
"\n"/*     trace.enabled? */
"\n"/*     # only disabled for this block */
"\n"/* end */
"\n"/*  */
"\n"/* trace.enabled? */
"\n"/* #=> true */
"\n"/*  */
"\n"/* Note: You cannot access event hooks within the block. */
"\n"/*  */
"\n"/* trace.disable { p tp.lineno } */
"\n"/* #=> RuntimeError: access from outside */
"  def disable\n"
"    Primitive.attr! :use_block\n"
"    Primitive.tracepoint_disable_m\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/* trace.enabled?\t    -> true or false */
"\n"/*  */
"\n"/* The current status of the trace */
"  def enabled?\n"
"    Primitive.tracepoint_enabled_p\n"
"  end\n"
"\n"
"\n"/* Type of event */
"\n"/*  */
"\n"/* See TracePoint@Events for more information. */
"  def event\n"
,
#line 317 "trace_point.rb"
"    Primitive.tracepoint_attr_event\n"
"  end\n"
"\n"
"\n"/* Line number of the event */
"  def lineno\n"
"    Primitive.tracepoint_attr_lineno\n"
"  end\n"
"\n"
"\n"/* Path of the file being run */
"  def path\n"
"    Primitive.tracepoint_attr_path\n"
"  end\n"
"\n"
"\n"/* Return the parameters definition of the method or block that the */
"\n"/* current hook belongs to. Format is the same as for Method#parameters */
"  def parameters\n"
"    Primitive.tracepoint_attr_parameters\n"
"  end\n"
"\n"
"\n"/* Return the name at the definition of the method being called */
"  def method_id\n"
"    Primitive.tracepoint_attr_method_id\n"
"  end\n"
"\n"
"\n"/* Return the called name of the method being called */
"  def callee_id\n"
"    Primitive.tracepoint_attr_callee_id\n"
"  end\n"
"\n"
"\n"/* Return class or module of the method being called. */
"\n"/*  */
"\n"/* class C; def foo; end; end */
"\n"/* \ttrace = TracePoint.new(:call) do |tp| */
"\n"/* \t  p tp.defined_class #=> C */
"\n"/* \tend.enable do */
"\n"/* \t  C.new.foo */
"\n"/* \tend */
"\n"/*  */
"\n"/* If method is defined by a module, then that module is returned. */
"\n"/*  */
"\n"/* module M; def foo; end; end */
"\n"/* \tclass C; include M; end; */
"\n"/* \ttrace = TracePoint.new(:call) do |tp| */
"\n"/* \t  p tp.defined_class #=> M */
"\n"/* \tend.enable do */
"\n"/* \t  C.new.foo */
"\n"/* \tend */
"\n"/*  */
"\n"/* <b>Note:</b> #defined_class returns singleton class. */
"\n"/*  */
"\n"/* 6th block parameter of Kernel#set_trace_func passes original class */
"\n"/* of attached by singleton class. */
"\n"/*  */
"\n"/* <b>This is a difference between Kernel#set_trace_func and TracePoint.</b> */
"\n"/*  */
"\n"/* class C; def self.foo; end; end */
"\n"/* \ttrace = TracePoint.new(:call) do |tp| */
"\n"/* \t  p tp.defined_class #=> #<Class:C> */
"\n"/* \tend.enable do */
"\n"/* \t  C.foo */
"\n"/* \tend */
"  def defined_class\n"
"    Primitive.tracepoint_attr_defined_class\n"
"  end\n"
"\n"
"\n"/* Return the generated binding object from event. */
"\n"/*  */
"\n"/* Note that for +:c_call+ and +:c_return+ events, the method will return */
"\n"/* +nil+, since C methods themselves do not have bindings. */
"  def binding\n"
,
#line 387 "trace_point.rb"
"    Primitive.tracepoint_attr_binding\n"
"  end\n"
"\n"
"\n"/* Return the trace object during event */
"\n"/*  */
"\n"/* Same as the following, except it returns the correct object (the method */
"\n"/* receiver) for +:c_call+ and +:c_return+ events: */
"\n"/*  */
"\n"/*   trace.binding.eval('self') */
"  def self\n"
"    Primitive.tracepoint_attr_self\n"
"  end\n"
"\n"
"\n"/*  Return value from +:return+, +:c_return+, and +:b_return+ event */
"  def return_value\n"
"    Primitive.tracepoint_attr_return_value\n"
"  end\n"
"\n"
"\n"/* Value from exception raised on the +:raise+ event, or rescued on the +:rescue+ event. */
"  def raised_exception\n"
"    Primitive.tracepoint_attr_raised_exception\n"
"  end\n"
"\n"
"\n"/* Compiled source code (String) on *eval methods on the +:script_compiled+ event. */
"\n"/* If loaded from a file, it will return nil. */
"  def eval_script\n"
"    Primitive.tracepoint_attr_eval_script\n"
"  end\n"
"\n"
"\n"/* Compiled instruction sequence represented by a RubyVM::InstructionSequence instance */
"\n"/* on the +:script_compiled+ event. */
"\n"/*  */
"\n"/* Note that this method is MRI specific. */
"  def instruction_sequence\n"
"    Primitive.tracepoint_attr_instruction_sequence\n"
"  end\n"
"end\n"
#line 4746 "miniprelude.c"
};

static const char prelude_name10[] = "<internal:warning>";
static const struct {
    char L0[361]; /* 1..60 */
} prelude_code10 = {
#line 1 "warning.rb"
""/* encoding: utf-8 */
""/* frozen-string-literal: true */
""
"module Kernel\n"
"  module_function\n"
"\n"
"\n"/* call-seq: */
"\n"/*    warn(*msgs, uplevel: nil, category: nil)   -> nil */
"\n"/*  */
"\n"/* If warnings have been disabled (for example with the */
"\n"/* <code>-W0</code> flag), does nothing.  Otherwise, */
"\n"/* converts each of the messages to strings, appends a newline */
"\n"/* character to the string if the string does not end in a newline, */
"\n"/* and calls Warning.warn with the string. */
"\n"/*  */
"\n"/*    warn(\"warning 1\", \"warning 2\") */
"\n"/*  */
"\n"/* <em>produces:</em> */
"\n"/*  */
"\n"/*    warning 1 */
"\n"/*    warning 2 */
"\n"/*  */
"\n"/* If the <code>uplevel</code> keyword argument is given, the string will */
"\n"/* be prepended with information for the given caller frame in */
"\n"/* the same format used by the <code>rb_warn</code> C function. */
"\n"/*  */
"\n"/*    # In baz.rb */
"\n"/*    def foo */
"\n"/*      warn(\"invalid call to foo\", uplevel: 1) */
"\n"/*    end */
"\n"/*  */
"\n"/*    def bar */
"\n"/*      foo */
"\n"/*    end */
"\n"/*  */
"\n"/*    bar */
"\n"/*  */
"\n"/* <em>produces:</em> */
"\n"/*  */
"\n"/*    baz.rb:6: warning: invalid call to foo */
"\n"/*  */
"\n"/* If <code>category</code> keyword argument is given, passes the category */
"\n"/* to <code>Warning.warn</code>.  The category given must be one of the */
"\n"/* following categories: */
"\n"/*  */
"\n"/* :deprecated :: Used for warning for deprecated functionality that may */
"\n"/*                be removed in the future. */
"\n"/* :experimental :: Used for experimental features that may change in */
"\n"/*                  future releases. */
"\n"/* :performance  :: Used for warning about APIs or pattern that have */
"\n"/*                  negative performance impact */
"  def warn(*msgs, uplevel: nil, category: nil)\n"
"    if Primitive.cexpr!(\"NIL_P(category)\")\n"
"      Primitive.rb_warn_m(msgs, uplevel, nil)\n"
"    elsif Warning[category = Primitive.cexpr!(\"rb_to_symbol_type(category)\")]\n"
"      Primitive.rb_warn_m(msgs, uplevel, category)\n"
"    end\n"
"  end\n"
"end\n"
#line 4813 "miniprelude.c"
};

static const char prelude_name11[] = "<internal:array>";
static const struct {
    char L0[489]; /* 1..130 */
    char L130[504]; /* 131..172 */
    char L172[485]; /* 173..224 */
    char L224[452]; /* 225..242 */
    char L242[463]; /* 243..260 */
    char L260[507]; /* 261..277 */
    char L277[147]; /* 278..287 */
} prelude_code11 = {
#line 1 "array.rb"
"class Array\n"
"\n"/* call-seq: */
"\n"/*   shuffle!(random: Random) -> self */
"\n"/*  */
"\n"/* Shuffles all elements in +self+ into a random order, */
"\n"/* as selected by the object given by keyword argument +random+; */
"\n"/* returns +self+: */
"\n"/*  */
"\n"/*   a =             [0, 1, 2, 3, 4, 5, 6, 7, 8, 9] */
"\n"/*   a.shuffle! # => [5, 3, 8, 7, 6, 1, 9, 4, 2, 0] */
"\n"/*   a.shuffle! # => [9, 4, 0, 6, 2, 8, 1, 5, 3, 7] */
"\n"/*  */
"\n"/*   Duplicate elements are included: */
"\n"/*  */
"\n"/*   a =             [0, 1, 0, 1, 0, 1, 0, 1, 0, 1] */
"\n"/*   a.shuffle! # => [1, 0, 0, 1, 1, 0, 1, 0, 0, 1] */
"\n"/*   a.shuffle! # => [0, 1, 0, 1, 1, 0, 1, 0, 1, 0] */
"\n"/*  */
"\n"/* The object given with keyword argument +random+ is used as the random number generator. */
"\n"/*  */
"\n"/* Related: see {Methods for Assigning}[rdoc-ref:Array@Methods+for+Assigning]. */
"  def shuffle!(random: Random)\n"
"    Primitive.rb_ary_shuffle_bang(random)\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*   shuffle(random: Random) -> new_array */
"\n"/*  */
"\n"/* Returns a new array containing all elements from +self+ in a random order, */
"\n"/* as selected by the object given by keyword argument +random+: */
"\n"/*  */
"\n"/*   a =            [0, 1, 2, 3, 4, 5, 6, 7, 8, 9] */
"\n"/*   a.shuffle # => [0, 8, 1, 9, 6, 3, 4, 7, 2, 5] */
"\n"/*   a.shuffle # => [8, 9, 0, 5, 1, 2, 6, 4, 7, 3] */
"\n"/*  */
"\n"/* Duplicate elements are included: */
"\n"/*  */
"\n"/*   a =            [0, 1, 0, 1, 0, 1, 0, 1, 0, 1] */
"\n"/*   a.shuffle # => [1, 0, 1, 1, 0, 0, 1, 0, 0, 1] */
"\n"/*   a.shuffle # => [1, 1, 0, 0, 0, 1, 1, 0, 0, 1] */
"\n"/*  */
"\n"/* The object given with keyword argument +random+ is used as the random number generator. */
"\n"/*  */
"\n"/* Related: see {Methods for Fetching}[rdoc-ref:Array@Methods+for+Fetching]. */
"  def shuffle(random: Random)\n"
"    Primitive.rb_ary_shuffle(random)\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*   sample(random: Random) -> object */
"\n"/*   sample(count, random: Random) -> new_ary */
"\n"/*  */
"\n"/* Returns random elements from +self+, */
"\n"/* as selected by the object given by keyword argument +random+. */
"\n"/*  */
"\n"/* With no argument +count+ given, returns one random element from +self+: */
"\n"/*  */
"\n"/*    a = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9] */
"\n"/*    a.sample # => 3 */
"\n"/*    a.sample # => 8 */
"\n"/*  */
"\n"/* Returns +nil+ if +self+ is empty: */
"\n"/*  */
"\n"/*    [].sample # => nil */
"\n"/*  */
"\n"/*  */
"\n"/* With non-negative numeric argument +count+ given, */
"\n"/* returns a new array containing +count+ random elements from +self+: */
"\n"/*  */
"\n"/*    a.sample(3) # => [8, 9, 2] */
"\n"/*    a.sample(6) # => [9, 6, 0, 3, 1, 4] */
"\n"/*  */
"\n"/* The order of the result array is unrelated to the order of +self+. */
"\n"/*  */
"\n"/* Returns a new empty +Array+ if +self+ is empty: */
"\n"/*  */
"\n"/*   [].sample(4) # => [] */
"\n"/*  */
"\n"/* May return duplicates in +self+: */
"\n"/*  */
"\n"/*    a = [1, 1, 1, 2, 2, 3] */
"\n"/*    a.sample(a.size) # => [1, 1, 3, 2, 1, 2] */
"\n"/*  */
"\n"/* Returns no more than <tt>a.size</tt> elements */
"\n"/* (because no new duplicates are introduced): */
"\n"/*  */
"\n"/*    a.sample(50) # => [6, 4, 1, 8, 5, 9, 0, 2, 3, 7] */
"\n"/*  */
"\n"/* The object given with keyword argument +random+ is used as the random number generator: */
"\n"/*  */
"\n"/*    a = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10] */
"\n"/*    a.sample(random: Random.new(1))     #=> 6 */
"\n"/*    a.sample(4, random: Random.new(1))  #=> [6, 10, 9, 2] */
"\n"/*  */
"\n"/* Related: see {Methods for Fetching}[rdoc-ref:Array@Methods+for+Fetching]. */
"  def sample(n = (ary = false), random: Random)\n"
"    if Primitive.mandatory_only?\n"
"\n"/* Primitive.cexpr! %{ rb_ary_sample(self, rb_cRandom, Qfalse, Qfalse) } */
"      Primitive.ary_sample0\n"
"    else\n"
"\n"/* Primitive.cexpr! %{ rb_ary_sample(self, random, n, ary) } */
"      Primitive.ary_sample(random, n, ary)\n"
"    end\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*   first -> object or nil */
"\n"/*   first(count) -> new_array */
"\n"/*  */
"\n"/* Returns elements from +self+, or +nil+; does not modify +self+. */
"\n"/*  */
"\n"/* With no argument given, returns the first element (if available): */
"\n"/*  */
"\n"/*   a = [:foo, 'bar', 2] */
"\n"/*   a.first # => :foo */
"\n"/*   a # => [:foo, \"bar\", 2] */
"\n"/*  */
"\n"/* If +self+ is empty, returns +nil+. */
"\n"/*  */
"\n"/*   [].first # => nil */
"\n"/*  */
"\n"/* With non-negative integer argument +count+ given, */
"\n"/* returns the first +count+ elements (as available) in a new array: */
"\n"/*  */
"\n"/*   a.first(0)  # => [] */
"\n"/*   a.first(2)  # => [:foo, \"bar\"] */
"\n"/*   a.first(50) # => [:foo, \"bar\", 2] */
"\n"/*  */
"\n"/* Related: see {Methods for Querying}[rdoc-ref:Array@Methods+for+Querying]. */
"  def first n = unspecified = true\n"
,
#line 131 "array.rb"
"    if Primitive.mandatory_only?\n"
"      Primitive.attr! :leaf\n"
"      Primitive.cexpr! %q{ ary_first(self) }\n"
"    else\n"
"      if unspecified\n"
"        Primitive.cexpr! %q{ ary_first(self) }\n"
"      else\n"
"        Primitive.cexpr! %q{  ary_take_first_or_last_n(self, NUM2LONG(n), ARY_TAKE_FIRST) }\n"
"      end\n"
"    end\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*  last  -> last_object or nil */
"\n"/*  last(n) -> new_array */
"\n"/*  */
"\n"/* Returns elements from +self+, or +nil+; +self+ is not modified. */
"\n"/*  */
"\n"/* With no argument given, returns the last element, or +nil+ if +self+ is empty: */
"\n"/*  */
"\n"/*   a = [:foo, 'bar', 2] */
"\n"/*   a.last # => 2 */
"\n"/*   a # => [:foo, \"bar\", 2] */
"\n"/*   [].last # => nil */
"\n"/*  */
"\n"/*  */
"\n"/* With non-negative integer argument +n+ is given, */
"\n"/* returns a new array containing the trailing +n+ elements of +self+, as available: */
"\n"/*  */
"\n"/*   a = [:foo, 'bar', 2] */
"\n"/*   a.last(2)  # => [\"bar\", 2] */
"\n"/*   a.last(50) # => [:foo, \"bar\", 2] */
"\n"/*   a.last(0)  # => [] */
"\n"/*   [].last(3) # => [] */
"\n"/*  */
"\n"/* Related: see {Methods for Fetching}[rdoc-ref:Array@Methods+for+Fetching]. */
"  def last n = unspecified = true\n"
"    if Primitive.mandatory_only?\n"
"      Primitive.attr! :leaf\n"
"      Primitive.cexpr! %q{ ary_last(self) }\n"
"    else\n"
"      if unspecified\n"
,
#line 173 "array.rb"
"        Primitive.cexpr! %q{ ary_last(self) }\n"
"      else\n"
"        Primitive.cexpr! %q{ ary_take_first_or_last_n(self, NUM2LONG(n), ARY_TAKE_LAST) }\n"
"      end\n"
"    end\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*    fetch_values(*indexes) -> new_array */
"\n"/*    fetch_values(*indexes) {|index| ... } -> new_array */
"\n"/*  */
"\n"/*  With no block given, returns a new array containing the elements of +self+ */
"\n"/*  at the offsets given by +indexes+; */
"\n"/*  each of the +indexes+ must be an */
"\n"/*  {integer-convertible object}[rdoc-ref:implicit_conversion.rdoc@Integer-Convertible+Objects]: */
"\n"/*  */
"\n"/*    a = [:foo, :bar, :baz] */
"\n"/*    a.fetch_values(3, 1)   # => [:baz, :foo] */
"\n"/*    a.fetch_values(3.1, 1) # => [:baz, :foo] */
"\n"/*    a.fetch_values         # => [] */
"\n"/*  */
"\n"/*  For a negative index, counts backwards from the end of the array: */
"\n"/*  */
"\n"/*    a.fetch_values([-2, -1]) # [:bar, :baz] */
"\n"/*  */
"\n"/*  When no block is given, raises an exception if any index is out of range. */
"\n"/*  */
"\n"/*  With a block given, for each index: */
"\n"/*  */
"\n"/*  - If the index in in range, uses an element of +self+ (as above). */
"\n"/*  - Otherwise calls, the block with the index, and uses the block's return value. */
"\n"/*  */
"\n"/*  Example: */
"\n"/*  */
"\n"/*    a = [:foo, :bar, :baz] */
"\n"/*    a.fetch_values(1, 0, 42, 777) {|index| index.to_s} */
"\n"/*    # => [:bar, :foo, \"42\", \"777\"] */
"\n"/*  */
"\n"/*  Related: see {Methods for Fetching}[rdoc-ref:Array@Methods+for+Fetching]. */
"  def fetch_values(*indexes, &block)\n"
"    indexes.map! { |i| fetch(i, &block) }\n"
"    indexes\n"
"  end\n"
"\n"
"  with_yjit do\n"
"    if Primitive.rb_builtin_basic_definition_p(:each)\n"
"      undef :each\n"
"\n"
"      def each\n"/* :nodoc: */
"        Primitive.attr! :inline_block, :c_trace\n"
"\n"
"        unless defined?(yield)\n"
,
#line 225 "array.rb"
"          return Primitive.cexpr! 'SIZED_ENUMERATOR(self, 0, 0, ary_enum_length)'\n"
"        end\n"
"        _i = 0\n"
"        value = nil\n"
"        while Primitive.cexpr!(%q{ ary_fetch_next(self, LOCAL_PTR(_i), LOCAL_PTR(value)) })\n"
"          yield value\n"
"        end\n"
"        self\n"
"      end\n"
"    end\n"
"\n"
"    if Primitive.rb_builtin_basic_definition_p(:map)\n"
"      undef :map\n"
"\n"
"      def map\n"/* :nodoc: */
"        Primitive.attr! :inline_block, :c_trace\n"
"\n"
"        unless defined?(yield)\n"
,
#line 243 "array.rb"
"          return Primitive.cexpr! 'SIZED_ENUMERATOR(self, 0, 0, ary_enum_length)'\n"
"        end\n"
"\n"
"        _i = 0\n"
"        value = nil\n"
"        result = Primitive.ary_sized_alloc\n"
"        while Primitive.cexpr!(%q{ ary_fetch_next(self, LOCAL_PTR(_i), LOCAL_PTR(value)) })\n"
"          result << yield(value)\n"
"        end\n"
"        result\n"
"      end\n"
"\n"
"      if Primitive.rb_builtin_basic_definition_p(:collect)\n"
"        undef :collect\n"
"        alias collect map\n"
"      end\n"
"    end\n"
"\n"
,
#line 261 "array.rb"
"    if Primitive.rb_builtin_basic_definition_p(:select)\n"
"      undef :select\n"
"\n"
"      def select\n"/* :nodoc: */
"        Primitive.attr! :inline_block, :c_trace\n"
"\n"
"        unless defined?(yield)\n"
"          return Primitive.cexpr! 'SIZED_ENUMERATOR(self, 0, 0, ary_enum_length)'\n"
"        end\n"
"\n"
"        _i = 0\n"
"        value = nil\n"
"        result = Primitive.ary_sized_alloc\n"
"        while Primitive.cexpr!(%q{ ary_fetch_next(self, LOCAL_PTR(_i), LOCAL_PTR(value)) })\n"
"          result << value if yield value\n"
"        end\n"
"        result\n"
,
#line 278 "array.rb"
"      end\n"
"\n"
"      if Primitive.rb_builtin_basic_definition_p(:filter)\n"
"        undef :filter\n"
"        alias filter select\n"
"      end\n"
"    end\n"
"  end\n"
"end\n"
#line 5125 "miniprelude.c"
};

static const char prelude_name12[] = "<internal:hash>";
static const struct {
    char L0[192]; /* 1..41 */
} prelude_code12 = {
#line 1 "hash.rb"
"class Hash\n"
"\n"/* call-seq: */
"\n"/*    Hash.new(default_value = nil) -> new_hash */
"\n"/*    Hash.new(default_value = nil, capacity: size) -> new_hash */
"\n"/*    Hash.new {|hash, key| ... } -> new_hash */
"\n"/*    Hash.new(capacity: size) {|hash, key| ... } -> new_hash */
"\n"/*  */
"\n"/* Returns a new empty +Hash+ object. */
"\n"/*  */
"\n"/* The initial default value and initial default proc for the new hash */
"\n"/* depend on which form above was used. See {Default Values}[rdoc-ref:Hash@Default+Values]. */
"\n"/*  */
"\n"/* If neither an argument nor a block is given, */
"\n"/* initializes both the default value and the default proc to <tt>nil</tt>: */
"\n"/*   h = Hash.new */
"\n"/*   h.default # => nil */
"\n"/*   h.default_proc # => nil */
"\n"/*  */
"\n"/* If argument <tt>default_value</tt> is given but no block is given, */
"\n"/* initializes the default value to the given <tt>default_value</tt> */
"\n"/* and the default proc to <tt>nil</tt>: */
"\n"/*   h = Hash.new(false) */
"\n"/*   h.default # => false */
"\n"/*   h.default_proc # => nil */
"\n"/*  */
"\n"/* If a block is given but no <tt>default_value</tt>, stores the block as the default proc */
"\n"/* and sets the default value to <tt>nil</tt>: */
"\n"/*   h = Hash.new {|hash, key| \"Default value for \#{key}\" } */
"\n"/*   h.default # => nil */
"\n"/*   h.default_proc.class # => Proc */
"\n"/*   h[:nosuch] # => \"Default value for nosuch\" */
"\n"/*  */
"\n"/* If both a block and a <tt>default_value</tt> are given, raises an +ArgumentError+ */
"\n"/*  */
"\n"/* If the optional keyword argument +capacity+ is given, the hash will be allocated */
"\n"/* with enough capacity to accommodate this many keys without having to be resized. */
"  def initialize(ifnone = (ifnone_unset = true), capacity: 0, &block)\n"
"    Primitive.rb_hash_init(capacity, ifnone_unset, ifnone, block)\n"
"  end\n"
"end\n"
#line 5173 "miniprelude.c"
};

static const char prelude_name13[] = "<internal:kernel>";
static const struct {
    char L0[508]; /* 1..123 */
    char L123[497]; /* 124..193 */
    char L193[488]; /* 194..299 */
    char L299[65]; /* 300..304 */
} prelude_code13 = {
#line 1 "kernel.rb"
"module Kernel\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     obj.class    -> class */
"\n"/*  */
"\n"/*  Returns the class of <i>obj</i>. This method must always be called */
"\n"/*  with an explicit receiver, as #class is also a reserved word in */
"\n"/*  Ruby. */
"\n"/*  */
"\n"/*     1.class      #=> Integer */
"\n"/*     self.class   #=> Object */
"\n"/* -- */
"\n"/* Equivalent to \\c Object\\#class in Ruby. */
"\n"/*  */
"\n"/* Returns the class of \\c obj, skipping singleton classes or module inclusions. */
"\n"/* ++ */
"\n"/*  */
"  def class\n"
"    Primitive.attr! :leaf\n"
"    Primitive.cexpr! 'rb_obj_class(self)'\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     obj.clone(freeze: nil) -> an_object */
"\n"/*  */
"\n"/*  Produces a shallow copy of <i>obj</i>---the instance variables of */
"\n"/*  <i>obj</i> are copied, but not the objects they reference. */
"\n"/*  #clone copies the frozen value state of <i>obj</i>, unless the */
"\n"/*  +:freeze+ keyword argument is given with a false or true value. */
"\n"/*  See also the discussion under Object#dup. */
"\n"/*  */
"\n"/*     class Klass */
"\n"/*        attr_accessor :str */
"\n"/*     end */
"\n"/*     s1 = Klass.new      #=> #<Klass:0x401b3a38> */
"\n"/*     s1.str = \"Hello\"    #=> \"Hello\" */
"\n"/*     s2 = s1.clone       #=> #<Klass:0x401b3998 @str=\"Hello\"> */
"\n"/*     s2.str[1,4] = \"i\"   #=> \"i\" */
"\n"/*     s1.inspect          #=> \"#<Klass:0x401b3a38 @str=\\\"Hi\\\">\" */
"\n"/*     s2.inspect          #=> \"#<Klass:0x401b3998 @str=\\\"Hi\\\">\" */
"\n"/*  */
"\n"/*  This method may have class-specific behavior. If so, that */
"\n"/*  behavior will be documented under the #+initialize_copy+ method of */
"\n"/*  the class. */
"\n"/*  */
"  def clone(freeze: nil)\n"
"    Primitive.rb_obj_clone2(freeze)\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     obj.frozen?    -> true or false */
"\n"/*  */
"\n"/*  Returns the freeze status of <i>obj</i>. */
"\n"/*  */
"\n"/*     a = [ \"a\", \"b\", \"c\" ] */
"\n"/*     a.freeze    #=> [\"a\", \"b\", \"c\"] */
"\n"/*     a.frozen?   #=> true */
"\n"/* -- */
"\n"/* Determines if the object is frozen. Equivalent to `Object#frozen?` in Ruby. */
"\n"/* @param[in] obj  the object to be determines */
"\n"/* @retval Qtrue if frozen */
"\n"/* @retval Qfalse if not frozen */
"\n"/* ++ */
"\n"/*  */
"  def frozen?\n"
"    Primitive.attr! :leaf\n"
"    Primitive.cexpr! 'rb_obj_frozen_p(self)'\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     obj.tap {|x| block }    -> obj */
"\n"/*  */
"\n"/*  Yields self to the block and then returns self. */
"\n"/*  The primary purpose of this method is to \"tap into\" a method chain, */
"\n"/*  in order to perform operations on intermediate results within the chain. */
"\n"/*  */
"\n"/*     (1..10)                  .tap {|x| puts \"original: \#{x}\" } */
"\n"/*       .to_a                  .tap {|x| puts \"array:    \#{x}\" } */
"\n"/*       .select {|x| x.even? } .tap {|x| puts \"evens:    \#{x}\" } */
"\n"/*       .map {|x| x*x }        .tap {|x| puts \"squares:  \#{x}\" } */
"\n"/*  */
"\n"/* -- */
"\n"/* \\private */
"\n"/* ++ */
"\n"/*  */
"  def tap\n"
"    Primitive.attr! :inline_block\n"
"    yield(self)\n"
"    self\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     obj.then {|x| block }          -> an_object */
"\n"/*  */
"\n"/*  Yields self to the block and returns the result of the block. */
"\n"/*  */
"\n"/*     3.next.then {|x| x**x }.to_s             #=> \"256\" */
"\n"/*  */
"\n"/*  A good use of +then+ is value piping in method chains: */
"\n"/*  */
"\n"/*     require 'open-uri' */
"\n"/*     require 'json' */
"\n"/*  */
"\n"/*     construct_url(arguments) */
"\n"/*       .then {|url| URI(url).read } */
"\n"/*       .then {|response| JSON.parse(response) } */
"\n"/*  */
"\n"/*  When called without a block, the method returns an +Enumerator+, */
"\n"/*  which can be used, for example, for conditional */
"\n"/*  circuit-breaking: */
"\n"/*  */
"\n"/*     # Meets condition, no-op */
"\n"/*     1.then.detect(&:odd?)            # => 1 */
"\n"/*     # Does not meet condition, drop value */
"\n"/*     2.then.detect(&:odd?)            # => nil */
"\n"/*  */
"  def then\n"
"    Primitive.attr! :inline_block\n"
"    unless defined?(yield)\n"
,
#line 124 "kernel.rb"
"      return Primitive.cexpr! 'SIZED_ENUMERATOR(self, 0, 0, rb_obj_size)'\n"
"    end\n"
"    yield(self)\n"
"  end\n"
"\n"
"  alias yield_self then\n"
"\n"
"  module_function\n"
"\n"
"\n"/* call-seq: */
"\n"/*    loop { block } */
"\n"/*    loop            -> an_enumerator */
"\n"/*  */
"\n"/* Repeatedly executes the block. */
"\n"/*  */
"\n"/* If no block is given, an enumerator is returned instead. */
"\n"/*  */
"\n"/*    loop do */
"\n"/*      print \"Input: \" */
"\n"/*      line = gets */
"\n"/*      break if !line or line =~ /^q/i */
"\n"/*      # ... */
"\n"/*    end */
"\n"/*  */
"\n"/* A StopIteration raised in the block breaks the loop. In this case, */
"\n"/* loop returns the \"result\" value stored in the exception. */
"\n"/*  */
"\n"/*    enum = Enumerator.new { |y| */
"\n"/*      y << \"one\" */
"\n"/*      y << \"two\" */
"\n"/*      :ok */
"\n"/*    } */
"\n"/*  */
"\n"/*    result = loop { */
"\n"/*      puts enum.next */
"\n"/*    } #=> :ok */
"  def loop\n"
"    Primitive.attr! :inline_block\n"
"    unless defined?(yield)\n"
"      return Primitive.cexpr! 'SIZED_ENUMERATOR(self, 0, 0, rb_f_loop_size)'\n"
"    end\n"
"\n"
"    begin\n"
"      while true\n"
"        yield\n"
"      end\n"
"    rescue StopIteration => e\n"
"      e.result\n"
"    end\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     Float(arg, exception: true)    -> float or nil */
"\n"/*  */
"\n"/*  Returns <i>arg</i> converted to a float. Numeric types are */
"\n"/*  converted directly, and with exception to String and */
"\n"/*  <code>nil</code>, the rest are converted using */
"\n"/*  <i>arg</i><code>.to_f</code>. Converting a String with invalid */
"\n"/*  characters will result in an ArgumentError. Converting */
"\n"/*  <code>nil</code> generates a TypeError. Exceptions can be */
"\n"/*  suppressed by passing <code>exception: false</code>. */
"\n"/*  */
"\n"/*     Float(1)                 #=> 1.0 */
"\n"/*     Float(\"123.456\")         #=> 123.456 */
"\n"/*     Float(\"123.0_badstring\") #=> ArgumentError: invalid value for Float(): \"123.0_badstring\" */
"\n"/*     Float(nil)               #=> TypeError: can't convert nil into Float */
"\n"/*     Float(\"123.0_badstring\", exception: false)  #=> nil */
"\n"/*  */
"  def Float(arg, exception: true)\n"
,
#line 194 "kernel.rb"
"    if Primitive.mandatory_only?\n"
"      Primitive.rb_f_float1(arg)\n"
"    else\n"
"      Primitive.rb_f_float(arg, exception)\n"
"    end\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*   Integer(object, base = 0, exception: true) -> integer or nil */
"\n"/*  */
"\n"/* Returns an integer converted from +object+. */
"\n"/*  */
"\n"/* Tries to convert +object+ to an integer */
"\n"/* using +to_int+ first and +to_i+ second; */
"\n"/* see below for exceptions. */
"\n"/*  */
"\n"/* With a non-zero +base+, +object+ must be a string or convertible */
"\n"/* to a string. */
"\n"/*  */
"\n"/* ==== \\Numeric objects */
"\n"/*  */
"\n"/* With an integer argument +object+ given, returns +object+: */
"\n"/*  */
"\n"/*   Integer(1)                # => 1 */
"\n"/*   Integer(-1)               # => -1 */
"\n"/*  */
"\n"/* With a floating-point argument +object+ given, */
"\n"/* returns +object+ truncated to an integer: */
"\n"/*  */
"\n"/*   Integer(1.9)              # => 1  # Rounds toward zero. */
"\n"/*   Integer(-1.9)             # => -1 # Rounds toward zero. */
"\n"/*  */
"\n"/* ==== \\String objects */
"\n"/*  */
"\n"/* With a string argument +object+ and zero +base+ given, */
"\n"/* returns +object+ converted to an integer in base 10: */
"\n"/*  */
"\n"/*   Integer('100')    # => 100 */
"\n"/*   Integer('-100')   # => -100 */
"\n"/*  */
"\n"/* With +base+ zero, string +object+ may contain leading characters */
"\n"/* to specify the actual base (radix indicator): */
"\n"/*  */
"\n"/*   Integer('0100')  # => 64  # Leading '0' specifies base 8. */
"\n"/*   Integer('0b100') # => 4   # Leading '0b' specifies base 2. */
"\n"/*   Integer('0x100') # => 256 # Leading '0x' specifies base 16. */
"\n"/*  */
"\n"/* With a positive +base+ (in range 2..36) given, returns +object+ */
"\n"/* converted to an integer in the given base: */
"\n"/*  */
"\n"/*   Integer('100', 2)   # => 4 */
"\n"/*   Integer('100', 8)   # => 64 */
"\n"/*   Integer('-100', 16) # => -256 */
"\n"/*  */
"\n"/* With a negative +base+ (in range -36..-2) given, returns +object+ */
"\n"/* converted to the radix indicator if it exists or */
"\n"/* +base+: */
"\n"/*  */
"\n"/*   Integer('0x100', -2)   # => 256 */
"\n"/*   Integer('100', -2)     # => 4 */
"\n"/*   Integer('0b100', -8)   # => 4 */
"\n"/*   Integer('100', -8)     # => 64 */
"\n"/*   Integer('0o100', -10)  # => 64 */
"\n"/*   Integer('100', -10)    # => 100 */
"\n"/*  */
"\n"/* +base+ -1 is equivalent to the -10 case. */
"\n"/*  */
"\n"/* When converting strings, surrounding whitespace and embedded underscores */
"\n"/* are allowed and ignored: */
"\n"/*  */
"\n"/*   Integer(' 100 ')      # => 100 */
"\n"/*   Integer('-1_0_0', 16) # => -256 */
"\n"/*  */
"\n"/* ==== Other classes */
"\n"/*  */
"\n"/* Examples with +object+ of various other classes: */
"\n"/*  */
"\n"/*   Integer(Rational(9, 10)) # => 0  # Rounds toward zero. */
"\n"/*   Integer(Complex(2, 0))   # => 2  # Imaginary part must be zero. */
"\n"/*   Integer(Time.now)        # => 1650974042 */
"\n"/*  */
"\n"/* ==== Keywords */
"\n"/*  */
"\n"/* With the optional keyword argument +exception+ given as +true+ (the default): */
"\n"/*  */
"\n"/* - Raises TypeError if +object+ does not respond to +to_int+ or +to_i+. */
"\n"/* - Raises TypeError if +object+ is +nil+. */
"\n"/* - Raises ArgumentError if +object+ is an invalid string. */
"\n"/*  */
"\n"/* With +exception+ given as +false+, an exception of any kind is suppressed */
"\n"/* and +nil+ is returned. */
"\n"/*  */
"  def Integer(arg, base = 0, exception: true)\n"
"    if Primitive.mandatory_only?\n"
"      Primitive.rb_f_integer1(arg)\n"
"    else\n"
"      Primitive.rb_f_integer(arg, base, exception)\n"
"    end\n"
"  end\n"
"end\n"
"\n"
"class Module\n"
"\n"/* Internal helper for built-in initializations to define methods only when YJIT is enabled. */
"\n"/* This method is removed in yjit_hook.rb. */
"  private def with_yjit(&block)\n"/* :nodoc: */
"    if defined?(RubyVM::YJIT)\n"
,
#line 300 "kernel.rb"
"      RubyVM::YJIT.send(:add_yjit_hook, block)\n"
"    end\n"
"  end\n"
"end\n"
#line 5493 "miniprelude.c"
};

static const char prelude_name14[] = "<internal:ractor>";
static const struct {
    char L0[502]; /* 1..281 */
    char L281[503]; /* 282..360 */
    char L360[465]; /* 361..442 */
    char L442[508]; /* 443..620 */
    char L620[503]; /* 621..719 */
    char L719[485]; /* 720..767 */
    char L767[488]; /* 768..839 */
    char L839[489]; /* 840..873 */
    char L873[432]; /* 874..901 */
} prelude_code14 = {
#line 1 "ractor.rb"
""/* \\Ractor is an Actor-model abstraction for Ruby that provides thread-safe parallel execution. */
""/*  */
""/* Ractor.new makes a new \\Ractor, which can run in parallel. */
""/*  */
""/*     # The simplest ractor */
""/*     r = Ractor.new {puts \"I am in Ractor!\"} */
""/*     r.take # wait for it to finish */
""/*     # Here, \"I am in Ractor!\" is printed */
""/*  */
""/* Ractors do not share all objects with each other. There are two main benefits to this: across ractors, thread-safety */
""/* concerns such as data-races and race-conditions are not possible. The other benefit is parallelism. */
""/*  */
""/* To achieve this, object sharing is limited across ractors. */
""/* For example, unlike in threads, ractors can't access all the objects available in other ractors. Even objects normally */
""/* available through variables in the outer scope are prohibited from being used across ractors. */
""/*  */
""/*     a = 1 */
""/*     r = Ractor.new {puts \"I am in Ractor! a=\#{a}\"} */
""/*     # fails immediately with */
""/*     # ArgumentError (can not isolate a Proc because it accesses outer variables (a).) */
""/*  */
""/* The object must be explicitly shared: */
""/*     a = 1 */
""/*     r = Ractor.new(a) { |a1| puts \"I am in Ractor! a=\#{a1}\"} */
""/*  */
""/* On CRuby (the default implementation), Global Virtual Machine Lock (GVL) is held per ractor, so */
""/* ractors can perform in parallel without locking each other. This is unlike the situation with threads */
""/* on CRuby. */
""/*  */
""/* Instead of accessing shared state, objects should be passed to and from ractors by */
""/* sending and receiving them as messages. */
""/*  */
""/*     a = 1 */
""/*     r = Ractor.new do */
""/*       a_in_ractor = receive # receive blocks until somebody passes a message */
""/*       puts \"I am in Ractor! a=\#{a_in_ractor}\" */
""/*     end */
""/*     r.send(a)  # pass it */
""/*     r.take */
""/*     # Here, \"I am in Ractor! a=1\" is printed */
""/*  */
""/* There are two pairs of methods for sending/receiving messages: */
""/*  */
""/* * Ractor#send and Ractor.receive for when the _sender_ knows the receiver (push); */
""/* * Ractor.yield and Ractor#take for when the _receiver_ knows the sender (pull); */
""/*  */
""/* In addition to that, any arguments passed to Ractor.new are passed to the block and available there */
""/* as if received by Ractor.receive, and the last block value is sent outside of the */
""/* ractor as if sent by Ractor.yield. */
""/*  */
""/* A little demonstration of a classic ping-pong: */
""/*  */
""/*     server = Ractor.new(name: \"server\") do */
""/*       puts \"Server starts: \#{self.inspect}\" */
""/*       puts \"Server sends: ping\" */
""/*       Ractor.yield 'ping'                       # The server doesn't know the receiver and sends to whoever interested */
""/*       received = Ractor.receive                 # The server doesn't know the sender and receives from whoever sent */
""/*       puts \"Server received: \#{received}\" */
""/*     end */
""/*  */
""/*     client = Ractor.new(server) do |srv|        # The server is sent to the client, and available as srv */
""/*       puts \"Client starts: \#{self.inspect}\" */
""/*       received = srv.take                       # The client takes a message from the server */
""/*       puts \"Client received from \" \\ */
""/*            \"\#{srv.inspect}: \#{received}\" */
""/*       puts \"Client sends to \" \\ */
""/*            \"\#{srv.inspect}: pong\" */
""/*       srv.send 'pong'                           # The client sends a message to the server */
""/*     end */
""/*  */
""/*     [client, server].each(&:take)               # Wait until they both finish */
""/*  */
""/* This will output something like: */
""/*  */
""/*     Server starts: #<Ractor:#2 server test.rb:1 running> */
""/*     Server sends: ping */
""/*     Client starts: #<Ractor:#3 test.rb:8 running> */
""/*     Client received from #<Ractor:#2 server test.rb:1 blocking>: ping */
""/*     Client sends to #<Ractor:#2 server test.rb:1 blocking>: pong */
""/*     Server received: pong */
""/*  */
""/* Ractors receive their messages via the <em>incoming port</em>, and send them */
""/* to the <em>outgoing port</em>. Either one can be disabled with Ractor#close_incoming and */
""/* Ractor#close_outgoing, respectively. When a ractor terminates, its ports are closed */
""/* automatically. */
""/*  */
""/* == Shareable and unshareable objects */
""/*  */
""/* When an object is sent to and from a ractor, it's important to understand whether the */
""/* object is shareable or unshareable. Most Ruby objects are unshareable objects. Even */
""/* frozen objects can be unshareable if they contain (through their instance variables) unfrozen */
""/* objects. */
""/*  */
""/* Shareable objects are those which can be used by several threads without compromising */
""/* thread-safety, for example numbers, +true+ and +false+. Ractor.shareable? allows you to check this, */
""/* and Ractor.make_shareable tries to make the object shareable if it's not already, and gives an error */
""/* if it can't do it. */
""/*  */
""/*     Ractor.shareable?(1)            #=> true -- numbers and other immutable basic values are shareable */
""/*     Ractor.shareable?('foo')        #=> false, unless the string is frozen due to # frozen_string_literal: true */
""/*     Ractor.shareable?('foo'.freeze) #=> true */
""/*     Ractor.shareable?([Object.new].freeze) #=> false, inner object is unfrozen */
""/*  */
""/*     ary = ['hello', 'world'] */
""/*     ary.frozen?                 #=> false */
""/*     ary[0].frozen?              #=> false */
""/*     Ractor.make_shareable(ary) */
""/*     ary.frozen?                 #=> true */
""/*     ary[0].frozen?              #=> true */
""/*     ary[1].frozen?              #=> true */
""/*  */
""/* When a shareable object is sent (via #send or Ractor.yield), no additional processing occurs */
""/* on it. It just becomes usable by both ractors. When an unshareable object is sent, it can be */
""/* either _copied_ or _moved_. The first is the default, and it copies the object fully by */
""/* deep cloning (Object#clone) the non-shareable parts of its structure. */
""/*  */
""/*     data = ['foo', 'bar'.freeze] */
""/*     r = Ractor.new do */
""/*       data2 = Ractor.receive */
""/*       puts \"In ractor: \#{data2.object_id}, \#{data2[0].object_id}, \#{data2[1].object_id}\" */
""/*     end */
""/*     r.send(data) */
""/*     r.take */
""/*     puts \"Outside  : \#{data.object_id}, \#{data[0].object_id}, \#{data[1].object_id}\" */
""/*  */
""/* This will output something like: */
""/*  */
""/*     In ractor: 340, 360, 320 */
""/*     Outside  : 380, 400, 320 */
""/*  */
""/* Note that the object ids of the array and the non-frozen string inside the array have changed in */
""/* the ractor because they are different objects. The second array's element, which is a */
""/* shareable frozen string, is the same object. */
""/*  */
""/* Deep cloning of objects may be slow, and sometimes impossible. Alternatively, <tt>move: true</tt> may */
""/* be used during sending. This will <em>move</em> the unshareable object to the receiving ractor, making it */
""/* inaccessible to the sending ractor. */
""/*  */
""/*     data = ['foo', 'bar'] */
""/*     r = Ractor.new do */
""/*       data_in_ractor = Ractor.receive */
""/*       puts \"In ractor: \#{data_in_ractor.object_id}, \#{data_in_ractor[0].object_id}\" */
""/*     end */
""/*     r.send(data, move: true) */
""/*     r.take */
""/*     puts \"Outside: moved? \#{Ractor::MovedObject === data}\" */
""/*     puts \"Outside: \#{data.inspect}\" */
""/*  */
""/* This will output: */
""/*  */
""/*     In ractor: 100, 120 */
""/*     Outside: moved? true */
""/*     test.rb:9:in `method_missing': can not send any methods to a moved object (Ractor::MovedError) */
""/*  */
""/* Notice that even +inspect+ (and more basic methods like <tt>__id__</tt>) is inaccessible */
""/* on a moved object. */
""/*  */
""/* Class and Module objects are shareable so the class/module definitions are shared between ractors. */
""/* \\Ractor objects are also shareable. All operations on shareable objects are thread-safe, so the thread-safety property */
""/* will be kept. We can not define mutable shareable objects in Ruby, but C extensions can introduce them. */
""/*  */
""/* It is prohibited to access (get) instance variables of shareable objects in other ractors if the values of the */
""/* variables aren't shareable. This can occur because modules/classes are shareable, but they can have */
""/* instance variables whose values are not. In non-main ractors, it's also prohibited to set instance */
""/* variables on classes/modules (even if the value is shareable). */
""/*  */
""/*     class C */
""/*       class << self */
""/*         attr_accessor :tricky */
""/*       end */
""/*     end */
""/*  */
""/*     C.tricky = \"unshareable\".dup */
""/*  */
""/*     r = Ractor.new(C) do |cls| */
""/*       puts \"I see \#{cls}\" */
""/*       puts \"I can't see \#{cls.tricky}\" */
""/*       cls.tricky = true # doesn't get here, but this would also raise an error */
""/*     end */
""/*     r.take */
""/*     # I see C */
""/*     # can not access instance variables of classes/modules from non-main Ractors (RuntimeError) */
""/*  */
""/* Ractors can access constants if they are shareable. The main \\Ractor is the only one that can */
""/* access non-shareable constants. */
""/*  */
""/*     GOOD = 'good'.freeze */
""/*     BAD = 'bad'.dup */
""/*  */
""/*     r = Ractor.new do */
""/*       puts \"GOOD=\#{GOOD}\" */
""/*       puts \"BAD=\#{BAD}\" */
""/*     end */
""/*     r.take */
""/*     # GOOD=good */
""/*     # can not access non-shareable objects in constant Object::BAD by non-main Ractor. (NameError) */
""/*  */
""/*     # Consider the same C class from above */
""/*  */
""/*     r = Ractor.new do */
""/*       puts \"I see \#{C}\" */
""/*       puts \"I can't see \#{C.tricky}\" */
""/*     end */
""/*     r.take */
""/*     # I see C */
""/*     # can not access instance variables of classes/modules from non-main Ractors (RuntimeError) */
""/*  */
""/* See also the description of <tt># shareable_constant_value</tt> pragma in */
""/* {Comments syntax}[rdoc-ref:syntax/comments.rdoc] explanation. */
""/*  */
""/* == Ractors vs threads */
""/*  */
""/* Each ractor has its own main Thread. New threads can be created from inside ractors */
""/* (and, on CRuby, they share the GVL with other threads of this ractor). */
""/*  */
""/*     r = Ractor.new do */
""/*       a = 1 */
""/*       Thread.new {puts \"Thread in ractor: a=\#{a}\"}.join */
""/*     end */
""/*     r.take */
""/*     # Here \"Thread in ractor: a=1\" will be printed */
""/*  */
""/* == Note on code examples */
""/*  */
""/* In the examples below, sometimes we use the following method to wait for ractors that */
""/* are not currently blocked to finish (or to make progress). */
""/*  */
""/*     def wait */
""/*       sleep(0.1) */
""/*     end */
""/*  */
""/* It is **only for demonstration purposes** and shouldn't be used in a real code. */
""/* Most of the time, #take is used to wait for ractors to finish. */
""/*  */
""/* == Reference */
""/*  */
""/* See {Ractor design doc}[rdoc-ref:ractor.md] for more details. */
""/*  */
"class Ractor\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     Ractor.new(*args, name: nil) {|*args| block } -> ractor */
"\n"/*  */
"\n"/* Create a new \\Ractor with args and a block. */
"\n"/*  */
"\n"/* The given block (Proc) will be isolated (can't access any outer variables). +self+ */
"\n"/* inside the block will refer to the current \\Ractor. */
"\n"/*  */
"\n"/*    r = Ractor.new { puts \"Hi, I am \#{self.inspect}\" } */
"\n"/*    r.take */
"\n"/*    # Prints \"Hi, I am #<Ractor:#2 test.rb:1 running>\" */
"\n"/*  */
"\n"/* Any +args+ passed are propagated to the block arguments by the same rules as */
"\n"/* objects sent via #send/Ractor.receive. If an argument in +args+ is not shareable, it */
"\n"/* will be copied (via deep cloning, which might be inefficient). */
"\n"/*  */
"\n"/*    arg = [1, 2, 3] */
"\n"/*    puts \"Passing: \#{arg} (#\#{arg.object_id})\" */
"\n"/*    r = Ractor.new(arg) {|received_arg| */
"\n"/*      puts \"Received: \#{received_arg} (#\#{received_arg.object_id})\" */
"\n"/*    } */
"\n"/*    r.take */
"\n"/*    # Prints: */
"\n"/*    #   Passing: [1, 2, 3] (#280) */
"\n"/*    #   Received: [1, 2, 3] (#300) */
"\n"/*  */
"\n"/* Ractor's +name+ can be set for debugging purposes: */
"\n"/*  */
"\n"/*    r = Ractor.new(name: 'my ractor') {}; r.take */
"\n"/*    p r */
"\n"/*    #=> #<Ractor:#3 my ractor test.rb:1 terminated> */
"\n"/*  */
"  def self.new(*args, name: nil, &block)\n"
"    b = block\n"/* TODO: builtin bug */
"    raise ArgumentError, \"must be called with a block\" unless block\n"
"    if __builtin_cexpr!(\"RBOOL(ruby_single_main_ractor)\")\n"
"      warn(\"Ractor is experimental, and the behavior may change in future versions of Ruby! \" \\\n"
"           \"Also there are many implementation issues.\", uplevel: 0, category: :experimental)\n"
"    end\n"
"    loc = caller_locations(1, 1).first\n"
"    loc = \"#{loc.path}:#{loc.lineno}\"\n"
,
#line 282 "ractor.rb"
"    __builtin_ractor_create(loc, name, args, b)\n"
"  end\n"
"\n"
"\n"/* Returns the currently executing Ractor. */
"\n"/*  */
"\n"/*   Ractor.current #=> #<Ractor:#1 running> */
"  def self.current\n"
"    __builtin_cexpr! %q{\n"
"      rb_ractor_self(rb_ec_ractor_ptr(ec));\n"
"    }\n"
"  end\n"
"\n"
"\n"/* Returns the number of Ractors currently running or blocking (waiting). */
"\n"/*  */
"\n"/*    Ractor.count                   #=> 1 */
"\n"/*    r = Ractor.new(name: 'example') { Ractor.yield(1) } */
"\n"/*    Ractor.count                   #=> 2 (main + example ractor) */
"\n"/*    r.take                         # wait for Ractor.yield(1) */
"\n"/*    r.take                         # wait until r will finish */
"\n"/*    Ractor.count                   #=> 1 */
"  def self.count\n"
"    __builtin_cexpr! %q{\n"
"      ULONG2NUM(GET_VM()->ractor.cnt);\n"
"    }\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/* call-seq: */
"\n"/*    Ractor.select(*ractors, [yield_value:, move: false]) -> [ractor or symbol, obj] */
"\n"/*  */
"\n"/* Wait for any ractor to have something in its outgoing port, read from this ractor, and */
"\n"/* then return that ractor and the object received. */
"\n"/*  */
"\n"/*    r1 = Ractor.new {Ractor.yield 'from 1'} */
"\n"/*    r2 = Ractor.new {Ractor.yield 'from 2'} */
"\n"/*  */
"\n"/*    r, obj = Ractor.select(r1, r2) */
"\n"/*  */
"\n"/*    puts \"received \#{obj.inspect} from \#{r.inspect}\" */
"\n"/*    # Prints: received \"from 1\" from #<Ractor:#2 test.rb:1 running> */
"\n"/*    # But could just as well print \"from r2\" here, either prints could be first. */
"\n"/*  */
"\n"/* If one of the given ractors is the current ractor, and it is selected, +r+ will contain */
"\n"/* the +:receive+ symbol instead of the ractor object. */
"\n"/*  */
"\n"/*    r1 = Ractor.new(Ractor.current) do |main| */
"\n"/*      main.send 'to main' */
"\n"/*      Ractor.yield 'from 1' */
"\n"/*    end */
"\n"/*    r2 = Ractor.new do */
"\n"/*      Ractor.yield 'from 2' */
"\n"/*    end */
"\n"/*  */
"\n"/*    r, obj = Ractor.select(r1, r2, Ractor.current) */
"\n"/*    puts \"received \#{obj.inspect} from \#{r.inspect}\" */
"\n"/*    # Could print: received \"to main\" from :receive */
"\n"/*  */
"\n"/* If +yield_value+ is provided, that value may be yielded if another ractor is calling #take. */
"\n"/* In this case, the pair <tt>[:yield, nil]</tt> is returned: */
"\n"/*  */
"\n"/*    r1 = Ractor.new(Ractor.current) do |main| */
"\n"/*      puts \"Received from main: \#{main.take}\" */
"\n"/*    end */
"\n"/*  */
"\n"/*    puts \"Trying to select\" */
"\n"/*    r, obj = Ractor.select(r1, Ractor.current, yield_value: 123) */
"\n"/*    wait */
"\n"/*    puts \"Received \#{obj.inspect} from \#{r.inspect}\" */
"\n"/*  */
"\n"/* This will print: */
"\n"/*  */
"\n"/*    Trying to select */
"\n"/*    Received from main: 123 */
"\n"/*    Received nil from :yield */
"\n"/*  */
"\n"/* +move+ boolean flag defines whether yielded value will be copied (default) or moved. */
"  def self.select(*ractors, yield_value: yield_unspecified = true, move: false)\n"
"    raise ArgumentError, 'specify at least one ractor or `yield_value`' if yield_unspecified && ractors.empty?\n"
"\n"
,
#line 361 "ractor.rb"
"    if ractors.delete Ractor.current\n"
"      do_receive = true\n"
"    else\n"
"      do_receive = false\n"
"    end\n"
"\n"
"    __builtin_ractor_select_internal ractors, do_receive, !yield_unspecified, yield_value, move\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/* call-seq: */
"\n"/*    Ractor.receive -> msg */
"\n"/*  */
"\n"/* Receive a message from the incoming port of the current ractor (which was */
"\n"/* sent there by #send from another ractor). */
"\n"/*  */
"\n"/*     r = Ractor.new do */
"\n"/*       v1 = Ractor.receive */
"\n"/*       puts \"Received: \#{v1}\" */
"\n"/*     end */
"\n"/*     r.send('message1') */
"\n"/*     r.take */
"\n"/*     # Here will be printed: \"Received: message1\" */
"\n"/*  */
"\n"/* Alternatively, the private instance method +receive+ may be used: */
"\n"/*  */
"\n"/*     r = Ractor.new do */
"\n"/*       v1 = receive */
"\n"/*       puts \"Received: \#{v1}\" */
"\n"/*     end */
"\n"/*     r.send('message1') */
"\n"/*     r.take */
"\n"/*     # This prints: \"Received: message1\" */
"\n"/*  */
"\n"/* The method blocks if the queue is empty. */
"\n"/*  */
"\n"/*     r = Ractor.new do */
"\n"/*       puts \"Before first receive\" */
"\n"/*       v1 = Ractor.receive */
"\n"/*       puts \"Received: \#{v1}\" */
"\n"/*       v2 = Ractor.receive */
"\n"/*       puts \"Received: \#{v2}\" */
"\n"/*     end */
"\n"/*     wait */
"\n"/*     puts \"Still not received\" */
"\n"/*     r.send('message1') */
"\n"/*     wait */
"\n"/*     puts \"Still received only one\" */
"\n"/*     r.send('message2') */
"\n"/*     r.take */
"\n"/*  */
"\n"/* Output: */
"\n"/*  */
"\n"/*     Before first receive */
"\n"/*     Still not received */
"\n"/*     Received: message1 */
"\n"/*     Still received only one */
"\n"/*     Received: message2 */
"\n"/*  */
"\n"/* If close_incoming was called on the ractor, the method raises Ractor::ClosedError */
"\n"/* if there are no more messages in the incoming queue: */
"\n"/*  */
"\n"/*     Ractor.new do */
"\n"/*       close_incoming */
"\n"/*       receive */
"\n"/*     end */
"\n"/*     wait */
"\n"/*     # in `receive': The incoming port is already closed => #<Ractor:#2 test.rb:1 running> (Ractor::ClosedError) */
"\n"/*  */
"  def self.receive\n"
"    __builtin_cexpr! %q{\n"
"      ractor_receive(ec, rb_ec_ractor_ptr(ec))\n"
"    }\n"
"  end\n"
"\n"
"  class << self\n"
"    alias recv receive\n"
"  end\n"
"\n"
"\n"/* same as Ractor.receive */
"  private def receive\n"
"    __builtin_cexpr! %q{\n"
,
#line 443 "ractor.rb"
"      ractor_receive(ec, rb_ec_ractor_ptr(ec))\n"
"    }\n"
"  end\n"
"  alias recv receive\n"
"\n"
"\n"/*  */
"\n"/* call-seq: */
"\n"/*    Ractor.receive_if {|msg| block } -> msg */
"\n"/*  */
"\n"/* Receive only a specific message. */
"\n"/*  */
"\n"/* Instead of Ractor.receive, Ractor.receive_if can be given a pattern (or any */
"\n"/* filter) in a block and you can choose the messages to accept that are available in */
"\n"/* your ractor's incoming queue. */
"\n"/*  */
"\n"/*     r = Ractor.new do */
"\n"/*       p Ractor.receive_if{|msg| msg.match?(/foo/)} #=> \"foo3\" */
"\n"/*       p Ractor.receive_if{|msg| msg.match?(/bar/)} #=> \"bar1\" */
"\n"/*       p Ractor.receive_if{|msg| msg.match?(/baz/)} #=> \"baz2\" */
"\n"/*     end */
"\n"/*     r << \"bar1\" */
"\n"/*     r << \"baz2\" */
"\n"/*     r << \"foo3\" */
"\n"/*     r.take */
"\n"/*  */
"\n"/* This will output: */
"\n"/*  */
"\n"/*     foo3 */
"\n"/*     bar1 */
"\n"/*     baz2 */
"\n"/*  */
"\n"/* If the block returns a truthy value, the message is removed from the incoming queue */
"\n"/* and returned. */
"\n"/* Otherwise, the message remains in the incoming queue and the next messages are checked */
"\n"/* by the given block. */
"\n"/*  */
"\n"/* If there are no messages left in the incoming queue, the method will */
"\n"/* block until new messages arrive. */
"\n"/*  */
"\n"/* If the block is escaped by break/return/exception/throw, the message is removed from */
"\n"/* the incoming queue as if a truthy value had been returned. */
"\n"/*  */
"\n"/*     r = Ractor.new do */
"\n"/*       val = Ractor.receive_if{|msg| msg.is_a?(Array)} */
"\n"/*       puts \"Received successfully: \#{val}\" */
"\n"/*     end */
"\n"/*  */
"\n"/*     r.send(1) */
"\n"/*     r.send('test') */
"\n"/*     wait */
"\n"/*     puts \"2 non-matching sent, nothing received\" */
"\n"/*     r.send([1, 2, 3]) */
"\n"/*     wait */
"\n"/*  */
"\n"/* Prints: */
"\n"/*  */
"\n"/*     2 non-matching sent, nothing received */
"\n"/*     Received successfully: [1, 2, 3] */
"\n"/*  */
"\n"/* Note that you can not call receive/receive_if in the given block recursively. */
"\n"/* You should not do any tasks in the block other than message filtration. */
"\n"/*  */
"\n"/*     Ractor.current << true */
"\n"/*     Ractor.receive_if{|msg| Ractor.receive} */
"\n"/*     #=> `receive': can not call receive/receive_if recursively (Ractor::Error) */
"\n"/*  */
"  def self.receive_if &b\n"
"    Primitive.ractor_receive_if b\n"
"  end\n"
"\n"
"\n"/* same as Ractor.receive_if */
"  private def receive_if &b\n"
"    Primitive.ractor_receive_if b\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/* call-seq: */
"\n"/*    ractor.send(msg, move: false) -> self */
"\n"/*  */
"\n"/* Send a message to a Ractor's incoming queue to be accepted by Ractor.receive. */
"\n"/*  */
"\n"/*   r = Ractor.new do */
"\n"/*     value = Ractor.receive */
"\n"/*     puts \"Received \#{value}\" */
"\n"/*   end */
"\n"/*   r.send 'message' */
"\n"/*   # Prints: \"Received: message\" */
"\n"/*  */
"\n"/* The method is non-blocking (will return immediately even if the ractor is not ready */
"\n"/* to receive anything): */
"\n"/*  */
"\n"/*    r = Ractor.new {sleep(5)} */
"\n"/*    r.send('test') */
"\n"/*    puts \"Sent successfully\" */
"\n"/*    # Prints: \"Sent successfully\" immediately */
"\n"/*  */
"\n"/* An attempt to send to a ractor which already finished its execution will raise Ractor::ClosedError. */
"\n"/*  */
"\n"/*   r = Ractor.new {} */
"\n"/*   r.take */
"\n"/*   p r */
"\n"/*   # \"#<Ractor:#6 (irb):23 terminated>\" */
"\n"/*   r.send('test') */
"\n"/*   # Ractor::ClosedError (The incoming-port is already closed) */
"\n"/*  */
"\n"/* If close_incoming was called on the ractor, the method also raises Ractor::ClosedError. */
"\n"/*  */
"\n"/*    r =  Ractor.new do */
"\n"/*      sleep(500) */
"\n"/*      receive */
"\n"/*    end */
"\n"/*    r.close_incoming */
"\n"/*    r.send('test') */
"\n"/*    # Ractor::ClosedError (The incoming-port is already closed) */
"\n"/*    # The error is raised immediately, not when the ractor tries to receive */
"\n"/*  */
"\n"/* If the +obj+ is unshareable, by default it will be copied into the receiving ractor by deep cloning. */
"\n"/* If <tt>move: true</tt> is passed, the object is _moved_ into the receiving ractor and becomes */
"\n"/* inaccessible to the sender. */
"\n"/*  */
"\n"/*    r = Ractor.new {puts \"Received: \#{receive}\"} */
"\n"/*    msg = 'message' */
"\n"/*    r.send(msg, move: true) */
"\n"/*    r.take */
"\n"/*    p msg */
"\n"/*  */
"\n"/* This prints: */
"\n"/*  */
"\n"/*    Received: message */
"\n"/*    in `p': undefined method `inspect' for #<Ractor::MovedObject:0x000055c99b9b69b8> */
"\n"/*  */
"\n"/* All references to the object and its parts will become invalid to the sender. */
"\n"/*  */
"\n"/*    r = Ractor.new {puts \"Received: \#{receive}\"} */
"\n"/*    s = 'message' */
"\n"/*    ary = [s] */
"\n"/*    copy = ary.dup */
"\n"/*    r.send(ary, move: true) */
"\n"/*  */
"\n"/*    s.inspect */
"\n"/*    # Ractor::MovedError (can not send any methods to a moved object) */
"\n"/*    ary.class */
"\n"/*    # Ractor::MovedError (can not send any methods to a moved object) */
"\n"/*    copy.class */
"\n"/*    # => Array, it is different object */
"\n"/*    copy[0].inspect */
"\n"/*    # Ractor::MovedError (can not send any methods to a moved object) */
"\n"/*    # ...but its item was still a reference to `s`, which was moved */
"\n"/*  */
"\n"/* If the object is shareable, <tt>move: true</tt> has no effect on it: */
"\n"/*  */
"\n"/*    r = Ractor.new {puts \"Received: \#{receive}\"} */
"\n"/*    s = 'message'.freeze */
"\n"/*    r.send(s, move: true) */
"\n"/*    s.inspect #=> \"message\", still available */
"\n"/*  */
"  def send(obj, move: false)\n"
"    __builtin_cexpr! %q{\n"
"      ractor_send(ec, RACTOR_PTR(self), obj, move)\n"
"    }\n"
"  end\n"
"  alias << send\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     Ractor.yield(msg, move: false) -> nil */
"\n"/*  */
"\n"/* Send a message to the current ractor's outgoing port to be accepted by #take. */
"\n"/*  */
"\n"/*    r = Ractor.new {Ractor.yield 'Hello from ractor'} */
"\n"/*    puts r.take */
"\n"/*    # Prints: \"Hello from ractor\" */
"\n"/*  */
"\n"/* This method is blocking, and will return only when somebody consumes the */
"\n"/* sent message. */
"\n"/*  */
"\n"/*    r = Ractor.new do */
"\n"/*      Ractor.yield 'Hello from ractor' */
,
#line 621 "ractor.rb"
"\n"/*      puts \"Ractor: after yield\" */
"\n"/*    end */
"\n"/*    wait */
"\n"/*    puts \"Still not taken\" */
"\n"/*    puts r.take */
"\n"/*  */
"\n"/* This will print: */
"\n"/*  */
"\n"/*    Still not taken */
"\n"/*    Hello from ractor */
"\n"/*    Ractor: after yield */
"\n"/*  */
"\n"/* If the outgoing port was closed with #close_outgoing, the method will raise: */
"\n"/*  */
"\n"/*    r = Ractor.new do */
"\n"/*      close_outgoing */
"\n"/*      Ractor.yield 'Hello from ractor' */
"\n"/*    end */
"\n"/*    wait */
"\n"/*    # `yield': The outgoing-port is already closed (Ractor::ClosedError) */
"\n"/*  */
"\n"/* The meaning of the +move+ argument is the same as for #send. */
"  def self.yield(obj, move: false)\n"
"    __builtin_cexpr! %q{\n"
"      ractor_yield(ec, rb_ec_ractor_ptr(ec), obj, move)\n"
"    }\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     ractor.take -> msg */
"\n"/*  */
"\n"/* Get a message from the ractor's outgoing port, which was put there by Ractor.yield or at ractor's */
"\n"/* termination. */
"\n"/*  */
"\n"/*   r = Ractor.new do */
"\n"/*     Ractor.yield 'explicit yield' */
"\n"/*     'last value' */
"\n"/*   end */
"\n"/*   puts r.take #=> 'explicit yield' */
"\n"/*   puts r.take #=> 'last value' */
"\n"/*   puts r.take # Ractor::ClosedError (The outgoing-port is already closed) */
"\n"/*  */
"\n"/* The fact that the last value is also sent to the outgoing port means that +take+ can be used */
"\n"/* as an analog of Thread#join (\"just wait until ractor finishes\"). However, it will raise if */
"\n"/* somebody has already consumed that message. */
"\n"/*  */
"\n"/* If the outgoing port was closed with #close_outgoing, the method will raise Ractor::ClosedError. */
"\n"/*  */
"\n"/*    r = Ractor.new do */
"\n"/*      sleep(500) */
"\n"/*      Ractor.yield 'Hello from ractor' */
"\n"/*    end */
"\n"/*    r.close_outgoing */
"\n"/*    r.take */
"\n"/*    # Ractor::ClosedError (The outgoing-port is already closed) */
"\n"/*    # The error would be raised immediately, not when ractor will try to receive */
"\n"/*  */
"\n"/* If an uncaught exception is raised in the Ractor, it is propagated by take as a */
"\n"/* Ractor::RemoteError. */
"\n"/*  */
"\n"/*   r = Ractor.new {raise \"Something weird happened\"} */
"\n"/*  */
"\n"/*   begin */
"\n"/*     r.take */
"\n"/*   rescue => e */
"\n"/*     p e              #  => #<Ractor::RemoteError: thrown by remote Ractor.> */
"\n"/*     p e.ractor == r  # => true */
"\n"/*     p e.cause        # => #<RuntimeError: Something weird happened> */
"\n"/*   end */
"\n"/*  */
"\n"/* Ractor::ClosedError is a descendant of StopIteration, so the termination of the ractor will break */
"\n"/* out of any loops that receive this message without propagating the error: */
"\n"/*  */
"\n"/*     r = Ractor.new do */
"\n"/*       3.times {|i| Ractor.yield \"message \#{i}\"} */
"\n"/*       \"finishing\" */
"\n"/*     end */
"\n"/*  */
"\n"/*     loop {puts \"Received: \" + r.take} */
"\n"/*     puts \"Continue successfully\" */
"\n"/*  */
"\n"/* This will print: */
"\n"/*  */
"\n"/*     Received: message 0 */
"\n"/*     Received: message 1 */
"\n"/*     Received: message 2 */
"\n"/*     Received: finishing */
"\n"/*     Continue successfully */
"  def take\n"
"    __builtin_cexpr! %q{\n"
"      ractor_take(ec, RACTOR_PTR(self))\n"
"    }\n"
"  end\n"
"\n"
"  def inspect\n"
"    loc  = __builtin_cexpr! %q{ RACTOR_PTR(self)->loc }\n"
"    name = __builtin_cexpr! %q{ RACTOR_PTR(self)->name }\n"
"    id   = __builtin_cexpr! %q{ UINT2NUM(rb_ractor_id(RACTOR_PTR(self))) }\n"
,
#line 720 "ractor.rb"
"    status = __builtin_cexpr! %q{\n"
"      rb_str_new2(ractor_status_str(RACTOR_PTR(self)->status_))\n"
"    }\n"
"    \"#<Ractor:##{id}#{name ? ' '+name : ''}#{loc ? \" \" + loc : ''} #{status}>\"\n"
"  end\n"
"\n"
"  alias to_s inspect\n"
"\n"
"\n"/* The name set in Ractor.new, or +nil+. */
"  def name\n"
"    __builtin_cexpr! %q{RACTOR_PTR(self)->name}\n"
"  end\n"
"\n"
"  class RemoteError\n"
"    attr_reader :ractor\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     ractor.close_incoming -> true | false */
"\n"/*  */
"\n"/* Closes the incoming port and returns whether it was already closed. All further attempts */
"\n"/* to Ractor.receive in the ractor, and #send to the ractor will fail with Ractor::ClosedError. */
"\n"/*  */
"\n"/*   r = Ractor.new {sleep(500)} */
"\n"/*   r.close_incoming  #=> false */
"\n"/*   r.close_incoming  #=> true */
"\n"/*   r.send('test') */
"\n"/*   # Ractor::ClosedError (The incoming-port is already closed) */
"  def close_incoming\n"
"    __builtin_cexpr! %q{\n"
"      ractor_close_incoming(ec, RACTOR_PTR(self));\n"
"    }\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/* call-seq: */
"\n"/*    ractor.close_outgoing -> true | false */
"\n"/*  */
"\n"/* Closes the outgoing port and returns whether it was already closed. All further attempts */
"\n"/* to Ractor.yield in the ractor, and #take from the ractor will fail with Ractor::ClosedError. */
"\n"/*  */
"\n"/*   r = Ractor.new {sleep(500)} */
"\n"/*   r.close_outgoing  #=> false */
"\n"/*   r.close_outgoing  #=> true */
"\n"/*   r.take */
"\n"/*   # Ractor::ClosedError (The outgoing-port is already closed) */
"  def close_outgoing\n"
,
#line 768 "ractor.rb"
"    __builtin_cexpr! %q{\n"
"      ractor_close_outgoing(ec, RACTOR_PTR(self));\n"
"    }\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/* call-seq: */
"\n"/*    Ractor.shareable?(obj) -> true | false */
"\n"/*  */
"\n"/* Checks if the object is shareable by ractors. */
"\n"/*  */
"\n"/*     Ractor.shareable?(1)            #=> true -- numbers and other immutable basic values are frozen */
"\n"/*     Ractor.shareable?('foo')        #=> false, unless the string is frozen due to # frozen_string_literal: true */
"\n"/*     Ractor.shareable?('foo'.freeze) #=> true */
"\n"/*  */
"\n"/* See also the \"Shareable and unshareable objects\" section in the \\Ractor class docs. */
"  def self.shareable? obj\n"
"    __builtin_cexpr! %q{\n"
"      RBOOL(rb_ractor_shareable_p(obj));\n"
"    }\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/* call-seq: */
"\n"/*    Ractor.make_shareable(obj, copy: false) -> shareable_obj */
"\n"/*  */
"\n"/* Make +obj+ shareable between ractors. */
"\n"/*  */
"\n"/* +obj+ and all the objects it refers to will be frozen, unless they are */
"\n"/* already shareable. */
"\n"/*  */
"\n"/* If +copy+ keyword is +true+, it will copy objects before freezing them, and will not */
"\n"/* modify +obj+ or its internal objects. */
"\n"/*  */
"\n"/* Note that the specification and implementation of this method are not */
"\n"/* mature and may be changed in the future. */
"\n"/*  */
"\n"/*   obj = ['test'] */
"\n"/*   Ractor.shareable?(obj)     #=> false */
"\n"/*   Ractor.make_shareable(obj) #=> [\"test\"] */
"\n"/*   Ractor.shareable?(obj)     #=> true */
"\n"/*   obj.frozen?                #=> true */
"\n"/*   obj[0].frozen?             #=> true */
"\n"/*  */
"\n"/*   # Copy vs non-copy versions: */
"\n"/*   obj1 = ['test'] */
"\n"/*   obj1s = Ractor.make_shareable(obj1) */
"\n"/*   obj1.frozen?                        #=> true */
"\n"/*   obj1s.object_id == obj1.object_id   #=> true */
"\n"/*   obj2 = ['test'] */
"\n"/*   obj2s = Ractor.make_shareable(obj2, copy: true) */
"\n"/*   obj2.frozen?                        #=> false */
"\n"/*   obj2s.frozen?                       #=> true */
"\n"/*   obj2s.object_id == obj2.object_id   #=> false */
"\n"/*   obj2s[0].object_id == obj2[0].object_id #=> false */
"\n"/*  */
"\n"/* See also the \"Shareable and unshareable objects\" section in the Ractor class docs. */
"  def self.make_shareable obj, copy: false\n"
"    if copy\n"
"      __builtin_cexpr! %q{\n"
"        rb_ractor_make_shareable_copy(obj);\n"
"      }\n"
"    else\n"
"      __builtin_cexpr! %q{\n"
"        rb_ractor_make_shareable(obj);\n"
"      }\n"
"    end\n"
"  end\n"
"\n"
"\n"/* get a value from ractor-local storage of current Ractor */
"\n"/* Obsolete and use Ractor.[] instead. */
"  def [](sym)\n"
,
#line 840 "ractor.rb"
"    Primitive.ractor_local_value(sym)\n"
"  end\n"
"\n"
"\n"/* set a value in ractor-local storage of current Ractor */
"\n"/* Obsolete and use Ractor.[]= instead. */
"  def []=(sym, val)\n"
"    Primitive.ractor_local_value_set(sym, val)\n"
"  end\n"
"\n"
"\n"/* get a value from ractor-local storage of current Ractor */
"  def self.[](sym)\n"
"    Primitive.ractor_local_value(sym)\n"
"  end\n"
"\n"
"\n"/* set a value in ractor-local storage of current Ractor */
"  def self.[]=(sym, val)\n"
"    Primitive.ractor_local_value_set(sym, val)\n"
"  end\n"
"\n"
"\n"/* returns main ractor */
"  def self.main\n"
"    __builtin_cexpr! %q{\n"
"      rb_ractor_self(GET_VM()->ractor.main_ractor);\n"
"    }\n"
"  end\n"
"\n"
"\n"/* return true if the current ractor is main ractor */
"  def self.main?\n"
"    __builtin_cexpr! %q{\n"
"      GET_VM()->ractor.main_ractor == rb_ec_ractor_ptr(ec)\n"
"    }\n"
"  end\n"
"\n"
"\n"/* internal method */
,
#line 874 "ractor.rb"
"  def self._require feature\n"
"    if main?\n"
"      super feature\n"
"    else\n"
"      Primitive.ractor_require feature\n"
"    end\n"
"  end\n"
"\n"
"  class << self\n"
"    private\n"
"\n"
"\n"/* internal method that is called when the first \"Ractor.new\" is called */
"    def _activated\n"
"      Kernel.prepend Module.new{|m|\n"
"        m.set_temporary_name '<RactorRequire>'\n"
"\n"
"        def require feature\n"
"          if Ractor.main?\n"
"            super\n"
"          else\n"
"            Ractor._require feature\n"
"          end\n"
"        end\n"
"      }\n"
"    end\n"
"  end\n"
"end\n"
#line 6425 "miniprelude.c"
};

static const char prelude_name15[] = "<internal:symbol>";
static const struct {
    char L0[282]; /* 1..43 */
} prelude_code15 = {
#line 1 "symbol.rb"
"class Symbol\n"
"\n"/* call-seq: */
"\n"/*   to_s -> string */
"\n"/*  */
"\n"/* Returns a string representation of +self+ (not including the leading colon): */
"\n"/*  */
"\n"/*   :foo.to_s # => \"foo\" */
"\n"/*  */
"\n"/* Related: Symbol#inspect, Symbol#name. */
"  def to_s\n"
"    Primitive.attr! :leaf\n"
"    Primitive.cexpr! 'rb_sym_to_s(self)'\n"
"  end\n"
"\n"
"  alias id2name to_s\n"
"\n"
"\n"/* call-seq: */
"\n"/*   name -> string */
"\n"/*  */
"\n"/* Returns a frozen string representation of +self+ (not including the leading colon): */
"\n"/*  */
"\n"/*   :foo.name         # => \"foo\" */
"\n"/*   :foo.name.frozen? # => true */
"\n"/*  */
"\n"/* Related: Symbol#to_s, Symbol#inspect. */
"  def name\n"
"    Primitive.attr! :leaf\n"
"    Primitive.cexpr! 'rb_sym2str(self)'\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*   to_sym -> self */
"\n"/*  */
"\n"/* Returns +self+. */
"\n"/*  */
"\n"/* Related: String#to_sym. */
"  def to_sym\n"
"    self\n"
"  end\n"
"\n"
"  alias intern to_sym\n"
"end\n"
#line 6475 "miniprelude.c"
};

static const char prelude_name16[] = "<internal:timev>";
static const struct {
    char L0[477]; /* 1..433 */
    char L433[507]; /* 434..451 */
    char L451[78]; /* 452..455 */
} prelude_code16 = {
#line 1 "timev.rb"
""/* A +Time+ object represents a date and time: */
""/*  */
""/*   Time.new(2000, 1, 1, 0, 0, 0) # => 2000-01-01 00:00:00 -0600 */
""/*  */
""/* Although its value can be expressed as a single numeric */
""/* (see {Epoch Seconds}[rdoc-ref:Time@Epoch+Seconds] below), */
""/* it can be convenient to deal with the value by parts: */
""/*  */
""/*   t = Time.new(-2000, 1, 1, 0, 0, 0.0) */
""/*   # => -2000-01-01 00:00:00 -0600 */
""/*   t.year # => -2000 */
""/*   t.month # => 1 */
""/*   t.mday # => 1 */
""/*   t.hour # => 0 */
""/*   t.min # => 0 */
""/*   t.sec # => 0 */
""/*   t.subsec # => 0 */
""/*  */
""/*   t = Time.new(2000, 12, 31, 23, 59, 59.5) */
""/*   # => 2000-12-31 23:59:59.5 -0600 */
""/*   t.year # => 2000 */
""/*   t.month # => 12 */
""/*   t.mday # => 31 */
""/*   t.hour # => 23 */
""/*   t.min # => 59 */
""/*   t.sec # => 59 */
""/*   t.subsec # => (1/2) */
""/*  */
""/* == Epoch Seconds */
""/*  */
""/* <i>Epoch seconds</i> is the exact number of seconds */
""/* (including fractional subseconds) since the Unix Epoch, January 1, 1970. */
""/*  */
""/* You can retrieve that value exactly using method Time.to_r: */
""/*  */
""/*   Time.at(0).to_r        # => (0/1) */
""/*   Time.at(0.999999).to_r # => (9007190247541737/9007199254740992) */
""/*  */
""/* Other retrieval methods such as Time#to_i and Time#to_f */
""/* may return a value that rounds or truncates subseconds. */
""/*  */
""/* == \\Time Resolution */
""/*  */
""/* A +Time+ object derived from the system clock */
""/* (for example, by method Time.now) */
""/* has the resolution supported by the system. */
""/*  */
""/* == \\Time Internal Representation */
""/*  */
""/* Time implementation uses a signed 63 bit integer, Integer, or */
""/* Rational. */
""/* It is a number of nanoseconds since the _Epoch_. */
""/* The signed 63 bit integer can represent 1823-11-12 to 2116-02-20. */
""/* When Integer or Rational is used (before 1823, after 2116, under */
""/* nanosecond), Time works slower than when the signed 63 bit integer is used. */
""/*  */
""/* Ruby uses the C function +localtime+ and +gmtime+ to map between the number */
""/* and 6-tuple (year,month,day,hour,minute,second). */
""/* +localtime+ is used for local time and \"gmtime\" is used for UTC. */
""/*  */
""/* Integer and Rational has no range limit, but the localtime and */
""/* gmtime has range limits due to the C types +time_t+ and <tt>struct tm</tt>. */
""/* If that limit is exceeded, Ruby extrapolates the localtime function. */
""/*  */
""/* The Time class always uses the Gregorian calendar. */
""/* I.e. the proleptic Gregorian calendar is used. */
""/* Other calendars, such as Julian calendar, are not supported. */
""/*  */
""/* +time_t+ can represent 1901-12-14 to 2038-01-19 if it is 32 bit signed integer, */
""/* -292277022657-01-27 to 292277026596-12-05 if it is 64 bit signed integer. */
""/* However +localtime+ on some platforms doesn't supports negative +time_t+ (before 1970). */
""/*  */
""/* <tt>struct tm</tt> has _tm_year_ member to represent years. */
""/* (<tt>tm_year = 0</tt> means the year 1900.) */
""/* It is defined as +int+ in the C standard. */
""/* _tm_year_ can represent between -2147481748 to 2147485547 if +int+ is 32 bit. */
""/*  */
""/* Ruby supports leap seconds as far as if the C function +localtime+ and */
""/* +gmtime+ supports it. */
""/* They use the tz database in most Unix systems. */
""/* The tz database has timezones which supports leap seconds. */
""/* For example, \"Asia/Tokyo\" doesn't support leap seconds but */
""/* \"right/Asia/Tokyo\" supports leap seconds. */
""/* So, Ruby supports leap seconds if the TZ environment variable is */
""/* set to \"right/Asia/Tokyo\" in most Unix systems. */
""/*  */
""/* == Examples */
""/*  */
""/* All of these examples were done using the EST timezone which is GMT-5. */
""/*  */
""/* === Creating a New +Time+ Instance */
""/*  */
""/* You can create a new instance of Time with Time.new. This will use the */
""/* current system time. Time.now is an alias for this. You can also */
""/* pass parts of the time to Time.new such as year, month, minute, etc. When */
""/* you want to construct a time this way you must pass at least a year. If you */
""/* pass the year with nothing else time will default to January 1 of that year */
""/* at 00:00:00 with the current system timezone. Here are some examples: */
""/*  */
""/*   Time.new(2002)         #=> 2002-01-01 00:00:00 -0500 */
""/*   Time.new(2002, 10)     #=> 2002-10-01 00:00:00 -0500 */
""/*   Time.new(2002, 10, 31) #=> 2002-10-31 00:00:00 -0500 */
""/*  */
""/* You can pass a UTC offset: */
""/*  */
""/*   Time.new(2002, 10, 31, 2, 2, 2, \"+02:00\") #=> 2002-10-31 02:02:02 +0200 */
""/*  */
""/* Or {a timezone object}[rdoc-ref:Time@Timezone+Objects]: */
""/*  */
""/*   zone = timezone(\"Europe/Athens\")      # Eastern European Time, UTC+2 */
""/*   Time.new(2002, 10, 31, 2, 2, 2, zone) #=> 2002-10-31 02:02:02 +0200 */
""/*  */
""/* You can also use Time.local and Time.utc to infer */
""/* local and UTC timezones instead of using the current system */
""/* setting. */
""/*  */
""/* You can also create a new time using Time.at which takes the number of */
""/* seconds (with subsecond) since the {Unix */
""/* Epoch}[https://en.wikipedia.org/wiki/Unix_time]. */
""/*  */
""/*   Time.at(628232400) #=> 1989-11-28 00:00:00 -0500 */
""/*  */
""/* === Working with an Instance of +Time+ */
""/*  */
""/* Once you have an instance of Time there is a multitude of things you can */
""/* do with it. Below are some examples. For all of the following examples, we */
""/* will work on the assumption that you have done the following: */
""/*  */
""/*   t = Time.new(1993, 02, 24, 12, 0, 0, \"+09:00\") */
""/*  */
""/* Was that a monday? */
""/*  */
""/*   t.monday? #=> false */
""/*  */
""/* What year was that again? */
""/*  */
""/*   t.year #=> 1993 */
""/*  */
""/* Was it daylight savings at the time? */
""/*  */
""/*   t.dst? #=> false */
""/*  */
""/* What's the day a year later? */
""/*  */
""/*   t + (60*60*24*365) #=> 1994-02-24 12:00:00 +0900 */
""/*  */
""/* How many seconds was that since the Unix Epoch? */
""/*  */
""/*   t.to_i #=> 730522800 */
""/*  */
""/* You can also do standard functions like compare two times. */
""/*  */
""/*   t1 = Time.new(2010) */
""/*   t2 = Time.new(2011) */
""/*  */
""/*   t1 == t2 #=> false */
""/*   t1 == t1 #=> true */
""/*   t1 <  t2 #=> true */
""/*   t1 >  t2 #=> false */
""/*  */
""/*   Time.new(2010,10,31).between?(t1, t2) #=> true */
""/*  */
""/* == What's Here */
""/*  */
""/* First, what's elsewhere. \\Class +Time+: */
""/*  */
""/* - Inherits from {class Object}[rdoc-ref:Object@What-27s+Here]. */
""/* - Includes {module Comparable}[rdoc-ref:Comparable@What-27s+Here]. */
""/*  */
""/* Here, class +Time+ provides methods that are useful for: */
""/*  */
""/* - {Creating Time objects}[rdoc-ref:Time@Methods+for+Creating]. */
""/* - {Fetching Time values}[rdoc-ref:Time@Methods+for+Fetching]. */
""/* - {Querying a Time object}[rdoc-ref:Time@Methods+for+Querying]. */
""/* - {Comparing Time objects}[rdoc-ref:Time@Methods+for+Comparing]. */
""/* - {Converting a Time object}[rdoc-ref:Time@Methods+for+Converting]. */
""/* - {Rounding a Time}[rdoc-ref:Time@Methods+for+Rounding]. */
""/*  */
""/* === Methods for Creating */
""/*  */
""/* - ::new: Returns a new time from specified arguments (year, month, etc.), */
""/*   including an optional timezone value. */
""/* - ::local (aliased as ::mktime): Same as ::new, except the */
""/*   timezone is the local timezone. */
""/* - ::utc (aliased as ::gm): Same as ::new, except the timezone is UTC. */
""/* - ::at: Returns a new time based on seconds since epoch. */
""/* - ::now: Returns a new time based on the current system time. */
""/* - #+ (plus): Returns a new time increased by the given number of seconds. */
""/* - #- (minus): Returns a new time decreased by the given number of seconds. */
""/*  */
""/* === Methods for Fetching */
""/*  */
""/* - #year: Returns the year of the time. */
""/* - #month (aliased as #mon): Returns the month of the time. */
""/* - #mday (aliased as #day): Returns the day of the month. */
""/* - #hour: Returns the hours value for the time. */
""/* - #min: Returns the minutes value for the time. */
""/* - #sec: Returns the seconds value for the time. */
""/* - #usec (aliased as #tv_usec): Returns the number of microseconds */
""/*   in the subseconds value of the time. */
""/* - #nsec (aliased as #tv_nsec: Returns the number of nanoseconds */
""/*   in the subsecond part of the time. */
""/* - #subsec: Returns the subseconds value for the time. */
""/* - #wday: Returns the integer weekday value of the time (0 == Sunday). */
""/* - #yday: Returns the integer yearday value of the time (1 == January 1). */
""/* - #hash: Returns the integer hash value for the time. */
""/* - #utc_offset (aliased as #gmt_offset and #gmtoff): Returns the offset */
""/*   in seconds between time and UTC. */
""/* - #to_f: Returns the float number of seconds since epoch for the time. */
""/* - #to_i (aliased as #tv_sec): Returns the integer number of seconds since epoch */
""/*   for the time. */
""/* - #to_r: Returns the Rational number of seconds since epoch for the time. */
""/* - #zone: Returns a string representation of the timezone of the time. */
""/*  */
""/* === Methods for Querying */
""/*  */
""/* - #utc? (aliased as #gmt?): Returns whether the time is UTC. */
""/* - #dst? (aliased as #isdst): Returns whether the time is DST (daylight saving time). */
""/* - #sunday?: Returns whether the time is a Sunday. */
""/* - #monday?: Returns whether the time is a Monday. */
""/* - #tuesday?: Returns whether the time is a Tuesday. */
""/* - #wednesday?: Returns whether the time is a Wednesday. */
""/* - #thursday?: Returns whether the time is a Thursday. */
""/* - #friday?: Returns whether time is a Friday. */
""/* - #saturday?: Returns whether the time is a Saturday. */
""/*  */
""/* === Methods for Comparing */
""/*  */
""/* - #<=>: Compares +self+ to another time. */
""/* - #eql?: Returns whether the time is equal to another time. */
""/*  */
""/* === Methods for Converting */
""/*  */
""/* - #asctime (aliased as #ctime): Returns the time as a string. */
""/* - #inspect: Returns the time in detail as a string. */
""/* - #strftime: Returns the time as a string, according to a given format. */
""/* - #to_a: Returns a 10-element array of values from the time. */
""/* - #to_s: Returns a string representation of the time. */
""/* - #getutc (aliased as #getgm): Returns a new time converted to UTC. */
""/* - #getlocal: Returns a new time converted to local time. */
""/* - #utc (aliased as #gmtime): Converts time to UTC in place. */
""/* - #localtime: Converts time to local time in place. */
""/* - #deconstruct_keys: Returns a hash of time components used in pattern-matching. */
""/*  */
""/* === Methods for Rounding */
""/*  */
""/* - #round:Returns a new time with subseconds rounded. */
""/* - #ceil: Returns a new time with subseconds raised to a ceiling. */
""/* - #floor: Returns a new time with subseconds lowered to a floor. */
""/*  */
""/* For the forms of argument +zone+, see */
""/* {Timezone Specifiers}[rdoc-ref:Time@Timezone+Specifiers]. */
""/*  */
""/* :include: doc/_timezones.rdoc */
"class Time\n"
"\n"/* Creates a new +Time+ object from the current system time. */
"\n"/* This is the same as Time.new without arguments. */
"\n"/*  */
"\n"/*    Time.now               # => 2009-06-24 12:39:54 +0900 */
"\n"/*    Time.now(in: '+04:00') # => 2009-06-24 07:39:54 +0400 */
"\n"/*  */
"\n"/* For forms of argument +zone+, see */
"\n"/* {Timezone Specifiers}[rdoc-ref:Time@Timezone+Specifiers]. */
"  def self.now(in: nil)\n"
"    Primitive.time_s_now(Primitive.arg!(:in))\n"
"  end\n"
"\n"
"\n"/* Returns a new +Time+ object based on the given arguments. */
"\n"/*  */
"\n"/* Required argument +time+ may be either of: */
"\n"/*  */
"\n"/* - A +Time+ object, whose value is the basis for the returned time; */
"\n"/*   also influenced by optional keyword argument +in:+ (see below). */
"\n"/* - A numeric number of */
"\n"/*   {Epoch seconds}[rdoc-ref:Time@Epoch+Seconds] */
"\n"/*   for the returned time. */
"\n"/*  */
"\n"/* Examples: */
"\n"/*  */
"\n"/*   t = Time.new(2000, 12, 31, 23, 59, 59) # => 2000-12-31 23:59:59 -0600 */
"\n"/*   secs = t.to_i                          # => 978328799 */
"\n"/*   Time.at(secs)                          # => 2000-12-31 23:59:59 -0600 */
"\n"/*   Time.at(secs + 0.5)                    # => 2000-12-31 23:59:59.5 -0600 */
"\n"/*   Time.at(1000000000)                    # => 2001-09-08 20:46:40 -0500 */
"\n"/*   Time.at(0)                             # => 1969-12-31 18:00:00 -0600 */
"\n"/*   Time.at(-1000000000)                   # => 1938-04-24 17:13:20 -0500 */
"\n"/*  */
"\n"/* Optional numeric argument +subsec+ and optional symbol argument +units+ */
"\n"/* work together to specify subseconds for the returned time; */
"\n"/* argument +units+ specifies the units for +subsec+: */
"\n"/*  */
"\n"/* - +:millisecond+: +subsec+ in milliseconds: */
"\n"/*  */
"\n"/*     Time.at(secs, 0, :millisecond)     # => 2000-12-31 23:59:59 -0600 */
"\n"/*     Time.at(secs, 500, :millisecond)   # => 2000-12-31 23:59:59.5 -0600 */
"\n"/*     Time.at(secs, 1000, :millisecond)  # => 2001-01-01 00:00:00 -0600 */
"\n"/*     Time.at(secs, -1000, :millisecond) # => 2000-12-31 23:59:58 -0600 */
"\n"/*  */
"\n"/* - +:microsecond+ or +:usec+: +subsec+ in microseconds: */
"\n"/*  */
"\n"/*     Time.at(secs, 0, :microsecond)        # => 2000-12-31 23:59:59 -0600 */
"\n"/*     Time.at(secs, 500000, :microsecond)   # => 2000-12-31 23:59:59.5 -0600 */
"\n"/*     Time.at(secs, 1000000, :microsecond)  # => 2001-01-01 00:00:00 -0600 */
"\n"/*     Time.at(secs, -1000000, :microsecond) # => 2000-12-31 23:59:58 -0600 */
"\n"/*  */
"\n"/* - +:nanosecond+ or +:nsec+: +subsec+ in nanoseconds: */
"\n"/*  */
"\n"/*     Time.at(secs, 0, :nanosecond)           # => 2000-12-31 23:59:59 -0600 */
"\n"/*     Time.at(secs, 500000000, :nanosecond)   # => 2000-12-31 23:59:59.5 -0600 */
"\n"/*     Time.at(secs, 1000000000, :nanosecond)  # => 2001-01-01 00:00:00 -0600 */
"\n"/*     Time.at(secs, -1000000000, :nanosecond) # => 2000-12-31 23:59:58 -0600 */
"\n"/*  */
"\n"/*  */
"\n"/* Optional keyword argument <tt>in: zone</tt> specifies the timezone */
"\n"/* for the returned time: */
"\n"/*  */
"\n"/*   Time.at(secs, in: '+12:00') # => 2001-01-01 17:59:59 +1200 */
"\n"/*   Time.at(secs, in: '-12:00') # => 2000-12-31 17:59:59 -1200 */
"\n"/*  */
"\n"/* For the forms of argument +zone+, see */
"\n"/* {Timezone Specifiers}[rdoc-ref:Time@Timezone+Specifiers]. */
"\n"/*  */
"  def self.at(time, subsec = false, unit = :microsecond, in: nil)\n"
"    if Primitive.mandatory_only?\n"
"      Primitive.time_s_at1(time)\n"
"    else\n"
"      Primitive.time_s_at(time, subsec, unit, Primitive.arg!(:in))\n"
"    end\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*   Time.new(year = nil, mon = nil, mday = nil, hour = nil, min = nil, sec = nil, zone = nil, in: nil, precision: 9) */
"\n"/*  */
"\n"/* Returns a new +Time+ object based on the given arguments, */
"\n"/* by default in the local timezone. */
"\n"/*  */
"\n"/* With no positional arguments, returns the value of Time.now: */
"\n"/*  */
"\n"/*   Time.new # => 2021-04-24 17:27:46.0512465 -0500 */
"\n"/*  */
"\n"/* With one string argument that represents a time, returns a new */
"\n"/* +Time+ object based on the given argument, in the local timezone. */
"\n"/*  */
"\n"/*   Time.new('2000-12-31 23:59:59.5')              # => 2000-12-31 23:59:59.5 -0600 */
"\n"/*   Time.new('2000-12-31 23:59:59.5 +0900')        # => 2000-12-31 23:59:59.5 +0900 */
"\n"/*   Time.new('2000-12-31 23:59:59.5', in: '+0900') # => 2000-12-31 23:59:59.5 +0900 */
"\n"/*   Time.new('2000-12-31 23:59:59.5')              # => 2000-12-31 23:59:59.5 -0600 */
"\n"/*   Time.new('2000-12-31 23:59:59.56789', precision: 3) # => 2000-12-31 23:59:59.567 -0600 */
"\n"/*  */
"\n"/* With one to six arguments, returns a new +Time+ object */
"\n"/* based on the given arguments, in the local timezone. */
"\n"/*  */
"\n"/*   Time.new(2000, 1, 2, 3, 4, 5) # => 2000-01-02 03:04:05 -0600 */
"\n"/*  */
"\n"/* For the positional arguments (other than +zone+): */
"\n"/*  */
"\n"/* - +year+: Year, with no range limits: */
"\n"/*  */
"\n"/*     Time.new(999999999)  # => 999999999-01-01 00:00:00 -0600 */
"\n"/*     Time.new(-999999999) # => -999999999-01-01 00:00:00 -0600 */
"\n"/*  */
"\n"/* - +month+: Month in range (1..12), or case-insensitive */
"\n"/*   3-letter month name: */
"\n"/*  */
"\n"/*     Time.new(2000, 1)     # => 2000-01-01 00:00:00 -0600 */
"\n"/*     Time.new(2000, 12)    # => 2000-12-01 00:00:00 -0600 */
"\n"/*     Time.new(2000, 'jan') # => 2000-01-01 00:00:00 -0600 */
"\n"/*     Time.new(2000, 'JAN') # => 2000-01-01 00:00:00 -0600 */
"\n"/*  */
"\n"/* - +mday+: Month day in range(1..31): */
"\n"/*  */
"\n"/*     Time.new(2000, 1, 1)  # => 2000-01-01 00:00:00 -0600 */
"\n"/*     Time.new(2000, 1, 31) # => 2000-01-31 00:00:00 -0600 */
"\n"/*  */
"\n"/* - +hour+: Hour in range (0..23), or 24 if +min+, +sec+, and +usec+ */
"\n"/*   are zero: */
"\n"/*  */
"\n"/*     Time.new(2000, 1, 1, 0)  # => 2000-01-01 00:00:00 -0600 */
"\n"/*     Time.new(2000, 1, 1, 23) # => 2000-01-01 23:00:00 -0600 */
"\n"/*     Time.new(2000, 1, 1, 24) # => 2000-01-02 00:00:00 -0600 */
"\n"/*  */
"\n"/* - +min+: Minute in range (0..59): */
"\n"/*  */
"\n"/*     Time.new(2000, 1, 1, 0, 0)  # => 2000-01-01 00:00:00 -0600 */
"\n"/*     Time.new(2000, 1, 1, 0, 59) # => 2000-01-01 00:59:00 -0600 */
"\n"/*  */
"\n"/* - +sec+: Second in range (0...61): */
"\n"/*  */
"\n"/*     Time.new(2000, 1, 1, 0, 0, 0)  # => 2000-01-01 00:00:00 -0600 */
"\n"/*     Time.new(2000, 1, 1, 0, 0, 59) # => 2000-01-01 00:00:59 -0600 */
"\n"/*     Time.new(2000, 1, 1, 0, 0, 60) # => 2000-01-01 00:01:00 -0600 */
"\n"/*  */
"\n"/*   +sec+ may be Float or Rational. */
"\n"/*  */
"\n"/*     Time.new(2000, 1, 1, 0, 0, 59.5)  # => 2000-12-31 23:59:59.5 +0900 */
"\n"/*     Time.new(2000, 1, 1, 0, 0, 59.7r) # => 2000-12-31 23:59:59.7 +0900 */
"\n"/*  */
"\n"/* These values may be: */
"\n"/*  */
"\n"/* - Integers, as above. */
"\n"/* - Numerics convertible to integers: */
"\n"/*  */
"\n"/*     Time.new(Float(0.0), Rational(1, 1), 1.0, 0.0, 0.0, 0.0) */
"\n"/*     # => 0000-01-01 00:00:00 -0600 */
"\n"/*  */
"\n"/* - String integers: */
"\n"/*  */
"\n"/*     a = %w[0 1 1 0 0 0] */
"\n"/*     # => [\"0\", \"1\", \"1\", \"0\", \"0\", \"0\"] */
"\n"/*     Time.new(*a) # => 0000-01-01 00:00:00 -0600 */
"\n"/*  */
"\n"/* When positional argument +zone+ or keyword argument +in:+ is given, */
"\n"/* the new +Time+ object is in the specified timezone. */
"\n"/* For the forms of argument +zone+, see */
"\n"/* {Timezone Specifiers}[rdoc-ref:Time@Timezone+Specifiers]: */
"\n"/*  */
"\n"/*   Time.new(2000, 1, 1, 0, 0, 0, '+12:00') */
"\n"/*   # => 2000-01-01 00:00:00 +1200 */
"\n"/*   Time.new(2000, 1, 1, 0, 0, 0, in: '-12:00') */
"\n"/*   # => 2000-01-01 00:00:00 -1200 */
"\n"/*   Time.new(in: '-12:00') */
"\n"/*   # => 2022-08-23 08:49:26.1941467 -1200 */
"\n"/*  */
"\n"/* Since +in:+ keyword argument just provides the default, so if the */
"\n"/* first argument in single string form contains time zone information, */
"\n"/* this keyword argument will be silently ignored. */
"\n"/*  */
"\n"/*   Time.new('2000-01-01 00:00:00 +0100', in: '-0500').utc_offset  # => 3600 */
"\n"/*  */
"\n"/* - +precision+: maximum effective digits in sub-second part, default is 9. */
"\n"/*   More digits will be truncated, as other operations of +Time+. */
"\n"/*   Ignored unless the first argument is a string. */
"\n"/*  */
,
#line 434 "timev.rb"
"  def initialize(year = (now = true), mon = (str = year; nil), mday = nil, hour = nil, min = nil, sec = nil, zone = nil,\n"
"                 in: nil, precision: 9)\n"
"    if zone\n"
"      if Primitive.arg!(:in)\n"
"        raise ArgumentError, \"timezone argument given as positional and keyword arguments\"\n"
"      end\n"
"    else\n"
"      zone = Primitive.arg!(:in)\n"
"    end\n"
"\n"
"    if now\n"
"      return Primitive.time_init_now(zone)\n"
"    end\n"
"\n"
"    if str and Primitive.time_init_parse(str, zone, precision)\n"
"      return self\n"
"    end\n"
"\n"
,
#line 452 "timev.rb"
"    Primitive.time_init_args(year, mon, mday, hour, min, sec, zone)\n"
"  end\n"
"end\n"
#line 6943 "miniprelude.c"
};

static const char prelude_name17[] = "<internal:thread_sync>";
static const struct {
    char L0[500]; /* 1..38 */
    char L38[446]; /* 39..69 */
} prelude_code17 = {
#line 1 "thread_sync.rb"
"class Thread\n"
"  class Queue\n"
"\n"/* call-seq: */
"\n"/*   pop(non_block=false, timeout: nil) */
"\n"/*  */
"\n"/* Retrieves data from the queue. */
"\n"/*  */
"\n"/* If the queue is empty, the calling thread is suspended until data is pushed */
"\n"/* onto the queue. If +non_block+ is true, the thread isn't suspended, and */
"\n"/* +ThreadError+ is raised. */
"\n"/*  */
"\n"/* If +timeout+ seconds have passed and no data is available +nil+ is */
"\n"/* returned. If +timeout+ is +0+ it returns immediately. */
"    def pop(non_block = false, timeout: nil)\n"
"      if non_block && timeout\n"
"        raise ArgumentError, \"can't set a timeout if non_block is enabled\"\n"
"      end\n"
"      Primitive.rb_queue_pop(non_block, timeout)\n"
"    end\n"
"    alias_method :deq, :pop\n"
"    alias_method :shift, :pop\n"
"  end\n"
"\n"
"  class SizedQueue\n"
"\n"/* call-seq: */
"\n"/*   pop(non_block=false, timeout: nil) */
"\n"/*  */
"\n"/* Retrieves data from the queue. */
"\n"/*  */
"\n"/* If the queue is empty, the calling thread is suspended until data is */
"\n"/* pushed onto the queue. If +non_block+ is true, the thread isn't */
"\n"/* suspended, and +ThreadError+ is raised. */
"\n"/*  */
"\n"/* If +timeout+ seconds have passed and no data is available +nil+ is */
"\n"/* returned. If +timeout+ is +0+ it returns immediately. */
"    def pop(non_block = false, timeout: nil)\n"
"      if non_block && timeout\n"
"        raise ArgumentError, \"can't set a timeout if non_block is enabled\"\n"
,
#line 39 "thread_sync.rb"
"      end\n"
"      Primitive.rb_szqueue_pop(non_block, timeout)\n"
"    end\n"
"    alias_method :deq, :pop\n"
"    alias_method :shift, :pop\n"
"\n"
"\n"/* call-seq: */
"\n"/*   push(object, non_block=false, timeout: nil) */
"\n"/*   enq(object, non_block=false, timeout: nil) */
"\n"/*   <<(object) */
"\n"/*  */
"\n"/* Pushes +object+ to the queue. */
"\n"/*  */
"\n"/* If there is no space left in the queue, waits until space becomes */
"\n"/* available, unless +non_block+ is true.  If +non_block+ is true, the */
"\n"/* thread isn't suspended, and +ThreadError+ is raised. */
"\n"/*  */
"\n"/* If +timeout+ seconds have passed and no space is available +nil+ is */
"\n"/* returned. If +timeout+ is +0+ it returns immediately. */
"\n"/* Otherwise it returns +self+. */
"    def push(object, non_block = false, timeout: nil)\n"
"      if non_block && timeout\n"
"        raise ArgumentError, \"can't set a timeout if non_block is enabled\"\n"
"      end\n"
"      Primitive.rb_szqueue_push(object, non_block, timeout)\n"
"    end\n"
"    alias_method :enq, :push\n"
"    alias_method :<<, :push\n"
"  end\n"
"end\n"
#line 7022 "miniprelude.c"
};

static const char prelude_name18[] = "<internal:nilclass>";
static const struct {
    char L0[98]; /* 1..26 */
} prelude_code18 = {
#line 1 "nilclass.rb"
"class NilClass\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     nil.to_i -> 0 */
"\n"/*  */
"\n"/*  Always returns zero. */
"\n"/*  */
"\n"/*     nil.to_i   #=> 0 */
"\n"/*  */
"  def to_i\n"
"    return 0\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     nil.to_f    -> 0.0 */
"\n"/*  */
"\n"/*  Always returns zero. */
"\n"/*  */
"\n"/*     nil.to_f   #=> 0.0 */
"\n"/*  */
"  def to_f\n"
"    return 0.0\n"
"  end\n"
"end\n"
#line 7055 "miniprelude.c"
};

static const char prelude_name19[] = "<internal:prelude>";
static const struct {
    char L0[352]; /* 1..32 */
} prelude_code19 = {
#line 1 "prelude.rb"
"class Binding\n"
"\n"/* :nodoc: */
"  def irb\n"
"    require 'irb'\n"
"    irb\n"
"  end\n"
"\n"
"\n"/* suppress redefinition warning */
"  alias irb irb\n"/* :nodoc: */
"end\n"
"\n"
"module Kernel\n"
"  def pp(*objs)\n"
"    require 'pp'\n"
"    pp(*objs)\n"
"  end\n"
"\n"
"\n"/* suppress redefinition warning */
"  alias pp pp\n"/* :nodoc: */
"\n"
"  private :pp\n"
"end\n"
"\n"
"autoload :Set, 'set'\n"
"\n"
"module Enumerable\n"
"\n"/* Makes a set from the enumerable object with given arguments. */
"  def to_set(klass = Set, *args, &block)\n"
"    klass.new(self, *args, &block)\n"
"  end unless instance_methods.include?(:to_set)\n"/* RJIT could already load this from builtin prelude */
"end\n"
#line 7094 "miniprelude.c"
};

static const char prelude_name20[] = "<internal:gem_prelude>";
static const struct {
    char L0[478]; /* 1..25 */
    char L25[74]; /* 26..29 */
} prelude_code20 = {
#line 1 "gem_prelude.rb"
"begin\n"
"  require 'rubygems'\n"
"rescue LoadError => e\n"
"  raise unless e.path == 'rubygems'\n"
"\n"
"  warn \"`RubyGems' were not loaded.\"\n"
"else\n"
"  require 'bundled_gems'\n"
"end if defined?(Gem)\n"
"\n"
"begin\n"
"  require 'error_highlight'\n"
"rescue LoadError\n"
"  warn \"`error_highlight' was not loaded.\"\n"
"end if defined?(ErrorHighlight)\n"
"\n"
"begin\n"
"  require 'did_you_mean'\n"
"rescue LoadError\n"
"  warn \"`did_you_mean' was not loaded.\"\n"
"end if defined?(DidYouMean)\n"
"\n"
"begin\n"
"  require 'syntax_suggest/core_ext'\n"
"rescue LoadError\n"
,
#line 26 "gem_prelude.rb"
"  warn \"`syntax_suggest' was not loaded.\"\n"
"end if defined?(SyntaxSuggest)\n"
"\n"
#line 7133 "miniprelude.c"
};

static const char prelude_name21[] = "<internal:yjit>";
static const struct {
    char L0[494]; /* 1..49 */
    char L49[477]; /* 50..71 */
    char L71[506]; /* 72..98 */
    char L98[501]; /* 99..117 */
    char L117[474]; /* 118..161 */
    char L161[508]; /* 162..189 */
    char L189[497]; /* 190..213 */
    char L213[508]; /* 214..242 */
    char L242[503]; /* 243..276 */
    char L276[484]; /* 277..291 */
    char L291[415]; /* 292..295 */
    char L295[498]; /* 296..309 */
    char L309[475]; /* 310..325 */
    char L325[487]; /* 326..341 */
    char L341[418]; /* 342..346 */
    char L346[445]; /* 347..350 */
    char L350[506]; /* 351..355 */
    char L355[478]; /* 356..361 */
    char L361[419]; /* 362..365 */
    char L365[476]; /* 366..371 */
    char L371[421]; /* 372..376 */
    char L376[373]; /* 377..380 */
    char L380[419]; /* 381..384 */
    char L384[453]; /* 385..389 */
    char L389[494]; /* 390..395 */
    char L395[467]; /* 396..402 */
    char L402[466]; /* 403..408 */
    char L408[472]; /* 409..414 */
    char L414[462]; /* 415..420 */
    char L420[432]; /* 421..425 */
    char L425[491]; /* 426..433 */
    char L433[499]; /* 434..446 */
    char L446[469]; /* 447..458 */
    char L458[454]; /* 459..473 */
    char L473[439]; /* 474..485 */
    char L485[506]; /* 486..501 */
    char L501[491]; /* 502..514 */
    char L514[449]; /* 515..537 */
} prelude_code21 = {
#line 1 "yjit.rb"
""/* frozen_string_literal: true */
""/* :markup: markdown */
""
""/* This module allows for introspection of \\YJIT, CRuby's just-in-time compiler. */
""/* Everything in the module is highly implementation specific and the API might */
""/* be less stable compared to the standard library. */
""/*  */
""/* This module may not exist if \\YJIT does not support the particular platform */
""/* for which CRuby is built. */
"module RubyVM::YJIT\n"
"\n"/* Check if \\YJIT is enabled. */
"  def self.enabled?\n"
"    Primitive.cexpr! 'RBOOL(rb_yjit_enabled_p)'\n"
"  end\n"
"\n"
"\n"/* Check if `--yjit-stats` is used. */
"  def self.stats_enabled?\n"
"    Primitive.rb_yjit_stats_enabled_p\n"
"  end\n"
"\n"
"\n"/* Check if `--yjit-log` is used. */
"  def self.log_enabled?\n"
"    Primitive.rb_yjit_log_enabled_p\n"
"  end\n"
"\n"
"\n"/* Check if rb_yjit_trace_exit_locations_enabled_p is enabled. */
"  def self.trace_exit_locations_enabled?\n"/* :nodoc: */
"    Primitive.rb_yjit_trace_exit_locations_enabled_p\n"
"  end\n"
"\n"
"\n"/* Discard statistics collected for `--yjit-stats`. */
"  def self.reset_stats!\n"
"    Primitive.rb_yjit_reset_stats_bang\n"
"  end\n"
"\n"
"\n"/* Enable \\YJIT compilation. `stats` option decides whether to enable \\YJIT stats or not. `compilation_log` decides */
"\n"/* whether to enable \\YJIT compilation logging or not. */
"\n"/*  */
"\n"/* `stats`: */
"\n"/* * `false`: Don't enable stats. */
"\n"/* * `true`: Enable stats. Print stats at exit. */
"\n"/* * `:quiet`: Enable stats. Do not print stats at exit. */
"\n"/*  */
"\n"/* `log`: */
"\n"/* * `false`: Don't enable the log. */
"\n"/* * `true`: Enable the log. Print log at exit. */
"\n"/* * `:quiet`: Enable the log. Do not print log at exit. */
"  def self.enable(stats: false, log: false)\n"
"    return false if enabled?\n"
,
#line 50 "yjit.rb"
"    at_exit { print_and_dump_stats } if stats\n"
"    call_yjit_hooks\n"
"    Primitive.rb_yjit_enable(stats, stats != :quiet, log, log != :quiet)\n"
"  end\n"
"\n"
"\n"/* If --yjit-trace-exits is enabled parse the hashes from */
"\n"/* Primitive.rb_yjit_get_exit_locations into a format readable */
"\n"/* by Stackprof. This will allow us to find the exact location of a */
"\n"/* side exit in YJIT based on the instruction that is exiting. */
"  def self.exit_locations\n"/* :nodoc: */
"    return unless trace_exit_locations_enabled?\n"
"\n"
"    results = Primitive.rb_yjit_get_exit_locations\n"
"    raw_samples = results[:raw].dup\n"
"    line_samples = results[:lines].dup\n"
"    frames = results[:frames].dup\n"
"    samples_count = 0\n"
"\n"
"\n"/* Loop through the instructions and set the frame hash with the data. */
"\n"/* We use nonexistent.def for the file name, otherwise insns.def will be displayed */
"\n"/* and that information isn't useful in this context. */
"    RubyVM::INSTRUCTION_NAMES.each_with_index do |name, frame_id|\n"
,
#line 72 "yjit.rb"
"      frame_hash = { samples: 0, total_samples: 0, edges: {}, name: name, file: \"nonexistent.def\", line: nil, lines: {} }\n"
"      results[:frames][frame_id] = frame_hash\n"
"      frames[frame_id] = frame_hash\n"
"    end\n"
"\n"
"\n"/* Loop through the raw_samples and build the hashes for StackProf. */
"\n"/* The loop is based off an example in the StackProf documentation and therefore */
"\n"/* this functionality can only work with that library. */
"\n"/*  */
"\n"/* Raw Samples: */
"\n"/* [ length, frame1, frame2, frameN, ..., instruction, count */
"\n"/*  */
"\n"/* Line Samples */
"\n"/* [ length, line_1, line_2, line_n, ..., dummy value, count */
"    i = 0\n"
"    while i < raw_samples.length\n"
"      stack_length = raw_samples[i]\n"
"      i += 1\n"/* consume the stack length */
"\n"
"      sample_count = raw_samples[i + stack_length]\n"
"\n"
"      prev_frame_id = nil\n"
"      stack_length.times do |idx|\n"
"        idx += i\n"
"        frame_id = raw_samples[idx]\n"
"\n"
"        if prev_frame_id\n"
,
#line 99 "yjit.rb"
"          prev_frame = frames[prev_frame_id]\n"
"          prev_frame[:edges][frame_id] ||= 0\n"
"          prev_frame[:edges][frame_id] += sample_count\n"
"        end\n"
"\n"
"        frame_info = frames[frame_id]\n"
"        frame_info[:total_samples] += sample_count\n"
"\n"
"        frame_info[:lines][line_samples[idx]] ||= [0, 0]\n"
"        frame_info[:lines][line_samples[idx]][0] += sample_count\n"
"\n"
"        prev_frame_id = frame_id\n"
"      end\n"
"\n"
"      i += stack_length\n"/* consume the stack */
"\n"
"      top_frame_id = prev_frame_id\n"
"      top_frame_line = 1\n"
"\n"
,
#line 118 "yjit.rb"
"      frames[top_frame_id][:samples] += sample_count\n"
"      frames[top_frame_id][:lines] ||= {}\n"
"      frames[top_frame_id][:lines][top_frame_line] ||= [0, 0]\n"
"      frames[top_frame_id][:lines][top_frame_line][1] += sample_count\n"
"\n"
"      samples_count += sample_count\n"
"      i += 1\n"
"    end\n"
"\n"
"    results[:samples] = samples_count\n"
"\n"/* Set missed_samples and gc_samples to 0 as their values */
"\n"/* don't matter to us in this context. */
"    results[:missed_samples] = 0\n"
"    results[:gc_samples] = 0\n"
"    results\n"
"  end\n"
"\n"
"\n"/* Marshal dumps exit locations to the given filename. */
"\n"/*  */
"\n"/* Usage: */
"\n"/*  */
"\n"/* If `--yjit-exit-locations` is passed, a file named */
"\n"/* \"yjit_exit_locations.dump\" will automatically be generated. */
"\n"/*  */
"\n"/* If you want to collect traces manually, call `dump_exit_locations` */
"\n"/* directly. */
"\n"/*  */
"\n"/* Note that calling this in a script will generate stats after the */
"\n"/* dump is created, so the stats data may include exits from the */
"\n"/* dump itself. */
"\n"/*  */
"\n"/* In a script call: */
"\n"/*  */
"\n"/*     at_exit do */
"\n"/*       RubyVM::YJIT.dump_exit_locations(\"my_file.dump\") */
"\n"/*     end */
"\n"/*  */
"\n"/* Then run the file with the following options: */
"\n"/*  */
"\n"/*     ruby --yjit --yjit-trace-exits test.rb */
"\n"/*  */
"\n"/* Once the code is done running, use Stackprof to read the dump file. */
"\n"/* See Stackprof documentation for options. */
"  def self.dump_exit_locations(filename)\n"
,
#line 162 "yjit.rb"
"    unless trace_exit_locations_enabled?\n"
"      raise ArgumentError, \"--yjit-trace-exits must be enabled to use dump_exit_locations.\"\n"
"    end\n"
"\n"
"    File.binwrite(filename, Marshal.dump(RubyVM::YJIT.exit_locations))\n"
"  end\n"
"\n"
"\n"/* Return a hash for statistics generated for the `--yjit-stats` command line option. */
"\n"/* Return `nil` when option is not passed or unavailable. */
"\n"/* If a symbol argument is provided, return only the value for the named stat. */
"\n"/* If any other type is provided, raises TypeError. */
"  def self.runtime_stats(key = nil)\n"
"    raise TypeError, \"non-symbol given\" unless key.nil? || Symbol === key\n"
"\n"
"    Primitive.rb_yjit_get_stats(key)\n"
"  end\n"
"\n"
"\n"/* Format and print out counters as a String. This returns a non-empty */
"\n"/* content only when `--yjit-stats` is enabled. */
"  def self.stats_string\n"
"\n"/* Lazily require StringIO to avoid breaking miniruby */
"    require 'stringio'\n"
"    strio = StringIO.new\n"
"    _print_stats(out: strio)\n"
"    strio.string\n"
"  end\n"
"\n"
"\n"/* Return an array of log entries. */
,
#line 190 "yjit.rb"
"\n"/* Return `nil` when option is not passed or unavailable. */
"  def self.log\n"
"    return nil unless log_enabled?\n"
"\n"
"    Primitive.rb_yjit_get_log.map do |timestamp, path|\n"
"      [Time.at(timestamp), path]\n"
"    end\n"
"  end\n"
"\n"
"\n"/* Produce disassembly for an iseq. This requires a `--enable-yjit=dev` build. */
"  def self.disasm(iseq)\n"/* :nodoc: */
"\n"/* If a method or proc is passed in, get its iseq */
"    iseq = RubyVM::InstructionSequence.of(iseq)\n"
"\n"
"    if !self.enabled?\n"
"      warn(\n"
"        \"YJIT needs to be enabled to produce disasm output, e.g.\\n\" +\n"
"        \"ruby --yjit-call-threshold=1 my_script.rb (see doc/yjit/yjit.md)\"\n"
"      )\n"
"      return nil\n"
"    end\n"
"\n"
"    disasm_str = Primitive.rb_yjit_disasm_iseq(iseq)\n"
"\n"
,
#line 214 "yjit.rb"
"    if !disasm_str\n"
"      warn(\n"
"        \"YJIT disasm is only available when YJIT is built in dev mode, i.e.\\n\" +\n"
"        \"./configure --enable-yjit=dev (see doc/yjit/yjit.md)\\n\"\n"
"      )\n"
"      return nil\n"
"    end\n"
"\n"
"\n"/* Produce the disassembly string */
"\n"/* Include the YARV iseq disasm in the string for additional context */
"    iseq.disasm + \"\\n\" + disasm_str\n"
"  end\n"
"\n"
"\n"/* Produce a list of instructions compiled by YJIT for an iseq */
"  def self.insns_compiled(iseq)\n"/* :nodoc: */
"    return nil unless self.enabled?\n"
"\n"
"\n"/* If a method or proc is passed in, get its iseq */
"    iseq = RubyVM::InstructionSequence.of(iseq)\n"
"    Primitive.rb_yjit_insns_compiled(iseq)\n"
"  end\n"
"\n"
"\n"/* Discard existing compiled code to reclaim memory */
"\n"/* and allow for recompilations in the future. */
"  def self.code_gc\n"
"    Primitive.rb_yjit_code_gc\n"
"  end\n"
"\n"
"  def self.simulate_oom!\n"/* :nodoc: */
,
#line 243 "yjit.rb"
"    Primitive.rb_yjit_simulate_oom_bang\n"
"  end\n"
"\n"
"\n"/* Avoid calling a Ruby method here to not interfere with compilation tests */
"  if Primitive.rb_yjit_stats_enabled_p\n"
"    at_exit { print_and_dump_stats }\n"
"  end\n"
"\n"
"\n"/* Blocks that are called when YJIT is enabled */
"  @yjit_hooks = []\n"
"\n"
"  class << self\n"
"\n"/* :stopdoc: */
"    private\n"
"\n"
"\n"/* Register a block to be called when YJIT is enabled */
"    def add_yjit_hook(hook)\n"
"      @yjit_hooks << hook\n"
"    end\n"
"\n"
"\n"/* Run YJIT hooks registered by RubyVM::YJIT.with_yjit */
"    def call_yjit_hooks\n"
"\n"/* Skip using builtin methods in Ruby if --yjit-c-builtin is given */
"      return if Primitive.yjit_c_builtin_p\n"
"      @yjit_hooks.each(&:call)\n"
"      @yjit_hooks.clear\n"
"    end\n"
"\n"
"\n"/* Print stats and dump exit locations */
"    def print_and_dump_stats\n"/* :nodoc: */
"      if Primitive.rb_yjit_print_stats_p\n"
"        _print_stats\n"
"      end\n"
"      _dump_locations\n"
,
#line 277 "yjit.rb"
"    end\n"
"\n"
"    def _dump_locations\n"/* :nodoc: */
"      return unless trace_exit_locations_enabled?\n"
"\n"
"      filename = \"yjit_exit_locations.dump\"\n"
"      dump_exit_locations(filename)\n"
"\n"
"      $stderr.puts(\"YJIT exit locations dumped to `#{filename}`.\")\n"
"    end\n"
"\n"
"\n"/* Print a summary of reasons for adverse performance events (e.g. exits) */
"    def _print_stats_reasons(stats, out)\n"/* :nodoc: */
"      print_counters(stats, out: out, prefix: 'send_', prompt: 'method call fallback reasons: ')\n"
"      print_counters(stats, out: out, prefix: 'invokeblock_', prompt: 'invokeblock fallback reasons: ')\n"
,
#line 292 "yjit.rb"
"      print_counters(stats, out: out, prefix: 'invokesuper_', prompt: 'invokesuper fallback reasons: ')\n"
"      print_counters(stats, out: out, prefix: 'guard_send_', prompt: 'method call exit reasons: ')\n"
"      print_counters(stats, out: out, prefix: 'guard_invokeblock_', prompt: 'invokeblock exit reasons: ')\n"
"      print_counters(stats, out: out, prefix: 'guard_invokesuper_', prompt: 'invokesuper exit reasons: ')\n"
,
#line 296 "yjit.rb"
"      print_counters(stats, out: out, prefix: 'gbpp_', prompt: 'getblockparamproxy exit reasons: ')\n"
"      print_counters(stats, out: out, prefix: 'getivar_', prompt: 'getinstancevariable exit reasons:')\n"
"      print_counters(stats, out: out, prefix: 'setivar_', prompt: 'setinstancevariable exit reasons:')\n"
"      %w[\n"
"        branchif\n"
"        branchnil\n"
"        branchunless\n"
"        definedivar\n"
"        expandarray\n"
"        invokebuiltin\n"
"        jump\n"
"        leave\n"
"        objtostring\n"
"        opt_aref\n"
,
#line 310 "yjit.rb"
"        opt_aref_with\n"
"        opt_aset\n"
"        opt_case_dispatch\n"
"        opt_div\n"
"        opt_getconstant_path\n"
"        opt_minus\n"
"        opt_mod\n"
"        opt_mult\n"
"        opt_plus\n"
"        opt_succ\n"
"        setlocal\n"
"        splatkw\n"
"      ].each do |insn|\n"
"        print_counters(stats, out: out, prefix: \"#{insn}_\", prompt: \"#{insn} exit reasons:\", optional: true)\n"
"      end\n"
"      print_counters(stats, out: out, prefix: 'lshift_', prompt: 'left shift (opt_ltlt) exit reasons: ')\n"
,
#line 326 "yjit.rb"
"      print_counters(stats, out: out, prefix: 'rshift_', prompt: 'right shift (>>) exit reasons: ')\n"
"      print_counters(stats, out: out, prefix: 'invalidate_', prompt: 'invalidation reasons: ')\n"
"    end\n"
"\n"
"\n"/* Format and print out counters */
"    def _print_stats(out: $stderr)\n"/* :nodoc: */
"      stats = runtime_stats()\n"
"      return unless Primitive.rb_yjit_stats_enabled_p\n"
"\n"
"      out.puts(\"***YJIT: Printing YJIT statistics on exit***\")\n"
"\n"
"      _print_stats_reasons(stats, out)\n"
"\n"
"\n"/* Number of failed compiler invocations */
"      compilation_failure = stats[:compilation_failure]\n"
"\n"
,
#line 342 "yjit.rb"
"      code_region_overhead = stats[:code_region_size] - (stats[:inline_code_size] + stats[:outlined_code_size])\n"
"\n"
"      out.puts \"num_send:              \" + format_number(13, stats[:num_send])\n"
"      out.puts \"num_send_known_class:  \" + format_number_pct(13, stats[:num_send_known_class], stats[:num_send])\n"
"      out.puts \"num_send_polymorphic:  \" + format_number_pct(13, stats[:num_send_polymorphic], stats[:num_send])\n"
,
#line 347 "yjit.rb"
"      out.puts \"num_send_megamorphic:  \" + format_number_pct(13, stats[:send_megamorphic], stats[:num_send])\n"
"      out.puts \"num_send_dynamic:      \" + format_number_pct(13, stats[:num_send_dynamic], stats[:num_send])\n"
"      out.puts \"num_send_cfunc:        \" + format_number_pct(13, stats[:num_send_cfunc], stats[:num_send])\n"
"      out.puts \"num_send_cfunc_inline: \" + format_number_pct(13, stats[:num_send_cfunc_inline], stats[:num_send_cfunc])\n"
,
#line 351 "yjit.rb"
"      out.puts \"num_send_iseq:         \" + format_number_pct(13, stats[:num_send_iseq], stats[:num_send])\n"
"      out.puts \"num_send_iseq_leaf:    \" + format_number_pct(13, stats[:num_send_iseq_leaf], stats[:num_send_iseq])\n"
"      out.puts \"num_send_iseq_inline:  \" + format_number_pct(13, stats[:num_send_iseq_inline], stats[:num_send_iseq])\n"
"      if stats[:num_send_x86_rel32] != 0 || stats[:num_send_x86_reg] != 0\n"
"        out.puts \"num_send_x86_rel32:    \" + format_number(13,  stats[:num_send_x86_rel32])\n"
,
#line 356 "yjit.rb"
"        out.puts \"num_send_x86_reg:      \" + format_number(13, stats[:num_send_x86_reg])\n"
"      end\n"
"      out.puts \"num_getivar_megamorphic: \" + format_number(11, stats[:num_getivar_megamorphic])\n"
"      out.puts \"num_setivar_megamorphic: \" + format_number(11, stats[:num_setivar_megamorphic])\n"
"      out.puts \"num_opt_case_megamorphic: \" + format_number(10, stats[:num_opt_case_dispatch_megamorphic])\n"
"      out.puts \"num_throw:             \" + format_number(13, stats[:num_throw])\n"
,
#line 362 "yjit.rb"
"      out.puts \"num_throw_break:       \" + format_number_pct(13, stats[:num_throw_break], stats[:num_throw])\n"
"      out.puts \"num_throw_retry:       \" + format_number_pct(13, stats[:num_throw_retry], stats[:num_throw])\n"
"      out.puts \"num_throw_return:      \" + format_number_pct(13, stats[:num_throw_return], stats[:num_throw])\n"
"      out.puts \"num_lazy_frame_check:  \" + format_number(13, stats[:num_lazy_frame_check])\n"
,
#line 366 "yjit.rb"
"      out.puts \"num_lazy_frame_push:   \" + format_number_pct(13, stats[:num_lazy_frame_push], stats[:num_lazy_frame_check])\n"
"      out.puts \"lazy_frame_count:      \" + format_number(13, stats[:lazy_frame_count])\n"
"      out.puts \"lazy_frame_failure:    \" + format_number(13, stats[:lazy_frame_failure])\n"
"\n"
"      out.puts \"iseq_stack_too_large:  \" + format_number(13, stats[:iseq_stack_too_large])\n"
"      out.puts \"iseq_too_long:         \" + format_number(13, stats[:iseq_too_long])\n"
,
#line 372 "yjit.rb"
"      out.puts \"temp_reg_opnd:         \" + format_number(13, stats[:temp_reg_opnd])\n"
"      out.puts \"temp_mem_opnd:         \" + format_number(13, stats[:temp_mem_opnd])\n"
"      out.puts \"temp_spill:            \" + format_number(13, stats[:temp_spill])\n"
"      out.puts \"bindings_allocations:  \" + format_number(13, stats[:binding_allocations])\n"
"      out.puts \"bindings_set:          \" + format_number(13, stats[:binding_set])\n"
,
#line 377 "yjit.rb"
"      out.puts \"compilation_failure:   \" + format_number(13, compilation_failure) if compilation_failure != 0\n"
"      out.puts \"live_iseq_count:       \" + format_number(13, stats[:live_iseq_count])\n"
"      out.puts \"iseq_alloc_count:      \" + format_number(13, stats[:iseq_alloc_count])\n"
"      out.puts \"compiled_iseq_entry:   \" + format_number(13, stats[:compiled_iseq_entry])\n"
,
#line 381 "yjit.rb"
"      out.puts \"cold_iseq_entry:       \" + format_number_pct(13, stats[:cold_iseq_entry], stats[:compiled_iseq_entry] + stats[:cold_iseq_entry])\n"
"      out.puts \"compiled_iseq_count:   \" + format_number(13, stats[:compiled_iseq_count])\n"
"      out.puts \"compiled_blockid_count:\" + format_number(13, stats[:compiled_blockid_count])\n"
"      out.puts \"compiled_block_count:  \" + format_number(13, stats[:compiled_block_count])\n"
,
#line 385 "yjit.rb"
"      out.puts \"inline_block_count:    \" + format_number_pct(13, stats[:inline_block_count], stats[:compiled_block_count])\n"
"      out.puts \"deleted_defer_block_count:\" + format_number_pct(10, stats[:deleted_defer_block_count], stats[:compiled_block_count])\n"
"      if stats[:compiled_blockid_count] != 0\n"
"        out.puts \"versions_per_block:    \" + format_number(13, \"%4.3f\" % (stats[:compiled_block_count].fdiv(stats[:compiled_blockid_count])))\n"
"      end\n"
,
#line 390 "yjit.rb"
"      out.puts \"max_inline_versions:   \" + format_number(13, stats[:max_inline_versions])\n"
"      out.puts \"compiled_branch_count: \" + format_number(13, stats[:compiled_branch_count])\n"
"\n"
"      out.puts \"yjit_active_ms:        \" + format_number(13, stats[:yjit_active_ns] / 10**6)\n"
"      out.puts \"compile_time_ms:       \" + format_number_pct(13, stats[:compile_time_ns] / 10**6 , stats[:yjit_active_ns] / 10**6)\n"
"      out.puts \"block_next_count:      \" + format_number(13, stats[:block_next_count])\n"
,
#line 396 "yjit.rb"
"      out.puts \"defer_count:           \" + format_number(13, stats[:defer_count])\n"
"      out.puts \"defer_empty_count:     \" + format_number(13, stats[:defer_empty_count])\n"
"\n"
"      out.puts \"branch_insn_count:     \" + format_number(13, stats[:branch_insn_count])\n"
"      out.puts \"branch_known_count:    \" + format_number_pct(13, stats[:branch_known_count], stats[:branch_insn_count])\n"
"\n"
"      out.puts \"freed_iseq_count:      \" + format_number(13, stats[:freed_iseq_count])\n"
,
#line 403 "yjit.rb"
"      out.puts \"invalidation_count:    \" + format_number(13, stats[:invalidation_count])\n"
"      out.puts \"inline_code_size:      \" + format_number(13, stats[:inline_code_size])\n"
"      out.puts \"outlined_code_size:    \" + format_number(13, stats[:outlined_code_size])\n"
"      out.puts \"code_region_size:      \" + format_number(13, stats[:code_region_size])\n"
"      out.puts \"code_region_overhead:  \" + format_number_pct(13, code_region_overhead, stats[:code_region_size])\n"
"\n"
,
#line 409 "yjit.rb"
"      out.puts \"freed_code_size:       \" + format_number(13, stats[:freed_code_size])\n"
"      out.puts \"yjit_alloc_size:       \" + format_number(13, stats[:yjit_alloc_size]) if stats.key?(:yjit_alloc_size)\n"
"\n"
"      bytes_per_context = stats[:context_data_bytes].fdiv(stats[:num_contexts_encoded])\n"
"      out.puts \"context_data_bytes:    \" + format_number(13, stats[:context_data_bytes])\n"
"      out.puts \"context_cache_bytes:   \" + format_number(13, stats[:context_cache_bytes])\n"
,
#line 415 "yjit.rb"
"      out.puts \"num_contexts_encoded:  \" + format_number(13, stats[:num_contexts_encoded])\n"
"      out.puts \"bytes_per_context:     \" + (\"%13.2f\" % bytes_per_context)\n"
"      out.puts \"context_cache_hit_rate:\" + format_number_pct(13, stats[:context_cache_hits], stats[:num_contexts_encoded])\n"
"\n"
"      out.puts \"live_page_count:       \" + format_number(13, stats[:live_page_count])\n"
"      out.puts \"freed_page_count:      \" + format_number(13, stats[:freed_page_count])\n"
,
#line 421 "yjit.rb"
"      out.puts \"code_gc_count:         \" + format_number(13, stats[:code_gc_count])\n"
"      out.puts \"num_gc_obj_refs:       \" + format_number(13, stats[:num_gc_obj_refs])\n"
"      out.puts \"object_shape_count:    \" + format_number(13, stats[:object_shape_count])\n"
"      out.puts \"side_exit_count:       \" + format_number(13, stats[:side_exit_count])\n"
"      out.puts \"total_exit_count:      \" + format_number(13, stats[:total_exit_count])\n"
,
#line 426 "yjit.rb"
"      out.puts \"total_insns_count:     \" + format_number(13, stats[:total_insns_count])\n"
"      out.puts \"vm_insns_count:        \" + format_number(13, stats[:vm_insns_count])\n"
"      out.puts \"yjit_insns_count:      \" + format_number(13, stats[:yjit_insns_count])\n"
"      out.puts \"ratio_in_yjit:         \" + (\"%12.1f\" % stats[:ratio_in_yjit]) + \"%\"\n"
"      out.puts \"avg_len_in_yjit:       \" + (\"%13.1f\" % stats[:avg_len_in_yjit])\n"
"\n"
"      print_sorted_exit_counts(stats, out: out, prefix: \"exit_\")\n"
"\n"
,
#line 434 "yjit.rb"
"      print_sorted_method_calls(stats[:cfunc_calls], stats[:num_send_cfunc], out: out, type: 'C')\n"
"      print_sorted_method_calls(stats[:iseq_calls], stats[:num_send_iseq], out: out, type: 'ISEQ')\n"
"    end\n"
"\n"
"    def print_sorted_method_calls(calls, num_calls, out:, type:, how_many: 20, left_pad: 4)\n"/* :nodoc: */
"      return if calls.empty?\n"
"\n"
"\n"/* Sort calls by decreasing frequency and keep the top N */
"      pairs = calls.map { |k,v| [k, v] }\n"
"      pairs.sort_by! {|pair| -pair[1] }\n"
"      pairs = pairs[0...how_many]\n"
"\n"
"      top_n_total = pairs.sum { |name, count| count }\n"
,
#line 447 "yjit.rb"
"      top_n_pct = 100.0 * top_n_total / num_calls\n"
"\n"
"      out.puts \"Top-#{pairs.size} most frequent #{type} calls (#{\"%.1f\" % top_n_pct}% of #{type} calls):\"\n"
"\n"
"      count_width = format_number(0, pairs[0][1]).length\n"
"      pairs.each do |name, count|\n"
"        padded_count = format_number_pct(count_width, count, num_calls)\n"
"        out.puts(\"  #{padded_count}: #{name}\")\n"
"      end\n"
"    end\n"
"\n"
"    def print_sorted_exit_counts(stats, out:, prefix:, how_many: 20, left_pad: 4)\n"/* :nodoc: */
,
#line 459 "yjit.rb"
"      total_exits = stats[:side_exit_count]\n"
"\n"
"      if total_exits > 0\n"
"        exits = []\n"
"        stats.each do |k, v|\n"
"          if k.start_with?(prefix)\n"
"            exits.push [k.to_s.delete_prefix(prefix), v]\n"
"          end\n"
"        end\n"
"\n"
"        exits = exits.select { |_name, count| count > 0 }.max_by(how_many) { |_name, count| count }\n"
"\n"
"        top_n_total = exits.sum { |name, count| count }\n"
"        top_n_exit_pct = 100.0 * top_n_total / total_exits\n"
"\n"
,
#line 474 "yjit.rb"
"        out.puts \"Top-#{exits.size} most frequent exit ops (#{\"%.1f\" % top_n_exit_pct}% of exits):\"\n"
"\n"
"        count_width = format_number(0, exits[0][1]).length\n"
"        exits.each do |name, count|\n"
"          padded_count = format_number_pct(count_width, count, total_exits)\n"
"          out.puts(\"  #{padded_count}: #{name}\")\n"
"        end\n"
"      else\n"
"        out.puts \"total_exits:           \" + format_number(13, total_exits)\n"
"      end\n"
"    end\n"
"\n"
,
#line 486 "yjit.rb"
"    def print_counters(counters, out:, prefix:, prompt:, optional: false)\n"/* :nodoc: */
"      counters = counters.filter { |key, _| key.start_with?(prefix) }\n"
"      counters.filter! { |_, value| value != 0 }\n"
"      counters.transform_keys! { |key| key.to_s.delete_prefix(prefix) }\n"
"\n"
"      if counters.empty?\n"
"        unless optional\n"
"          out.puts(prompt)\n"
"          out.puts(\"    (all relevant counters are zero)\")\n"
"        end\n"
"        return\n"
"      else\n"
"        out.puts(prompt)\n"
"      end\n"
"\n"
"      counters = counters.to_a\n"
,
#line 502 "yjit.rb"
"      counters.sort_by! { |(_, counter_value)| counter_value }\n"
"      longest_name_length = counters.max_by { |(name, _)| name.length }.first.length\n"
"      total = counters.sum { |(_, counter_value)| counter_value }\n"
"\n"
"      counters.reverse_each do |(name, value)|\n"
"        padded_name = name.rjust(longest_name_length, ' ')\n"
"        padded_count = format_number_pct(10, value, total)\n"
"        out.puts(\"    #{padded_name}: #{padded_count}\")\n"
"      end\n"
"    end\n"
"\n"
"\n"/* Format large numbers with comma separators for readability */
"    def format_number(pad, number)\n"/* :nodoc: */
,
#line 515 "yjit.rb"
"      s = number.to_s\n"
"      i = s.index('.') || s.size\n"
"      s.insert(i -= 3, ',') while i > 3\n"
"      s.rjust(pad, ' ')\n"
"    end\n"
"\n"
"\n"/* Format a number along with a percentage over a total value */
"    def format_number_pct(pad, number, total)\n"/* :nodoc: */
"      padded_count = format_number(pad, number)\n"
"\n"
"      if total != 0\n"
"        percentage = number.fdiv(total) * 100\n"
"        formatted_pct = \"%4.1f%%\" % percentage\n"
"        \"#{padded_count} (#{formatted_pct})\"\n"
"      else\n"
"        \"#{padded_count}\"\n"
"      end\n"
"    end\n"
"\n"
"\n"/* :startdoc: */
"  end\n"
"end\n"
#line 7788 "miniprelude.c"
};

static const char prelude_name22[] = "<internal:yjit_hook>";
static const struct {
    char L0[131]; /* 1..10 */
} prelude_code22 = {
#line 1 "yjit_hook.rb"
""/* If YJIT is enabled, load the YJIT-only version of builtin methods */
"if defined?(RubyVM::YJIT) && RubyVM::YJIT.enabled?\n"
"  RubyVM::YJIT.send(:call_yjit_hooks)\n"
"end\n"
"\n"
"\n"/* Remove the helper defined in kernel.rb */
"class Module\n"
"  undef :with_yjit\n"
"end\n"
#line 7805 "miniprelude.c"
};

COMPILER_WARNING_POP

#define PRELUDE_NAME(n) rb_usascii_str_new_static(prelude_name##n, sizeof(prelude_name##n)-1)
#define PRELUDE_CODE(n) rb_utf8_str_new_static(prelude_code##n.L0, sizeof(prelude_code##n))

#define PRELUDE_MATCH(n) \
    (((sizeof(prelude_name##n) - prefix_len - 2) == namelen) && \
     (strncmp(prelude_name##n + prefix_len, feature_name, namelen) == 0))

VALUE
rb_builtin_find(const char *feature_name, VALUE *name_str, int *start_line)
{
    const size_t prefix_len = rb_strlen_lit("<internal:");
    size_t namelen = strlen(feature_name);

#define PRELUDE_FOUND(n, l) \
    (*name_str = PRELUDE_NAME(n), *start_line = (l), PRELUDE_CODE(n))

    if (PRELUDE_MATCH(0)) return PRELUDE_FOUND(0, 19);
    if (PRELUDE_MATCH(1)) return PRELUDE_FOUND(1, 158);
    if (PRELUDE_MATCH(2)) return PRELUDE_FOUND(2, 8);
    if (PRELUDE_MATCH(3)) return PRELUDE_FOUND(3, 1);
    if (PRELUDE_MATCH(4)) return PRELUDE_FOUND(4, 1);
    if (PRELUDE_MATCH(5)) return PRELUDE_FOUND(5, 1);
    if (PRELUDE_MATCH(6)) return PRELUDE_FOUND(6, 1);
    if (PRELUDE_MATCH(7)) return PRELUDE_FOUND(7, 4);
    if (PRELUDE_MATCH(8)) return PRELUDE_FOUND(8, 1);
    if (PRELUDE_MATCH(9)) return PRELUDE_FOUND(9, 50);
    if (PRELUDE_MATCH(10)) return PRELUDE_FOUND(10, 4);
    if (PRELUDE_MATCH(11)) return PRELUDE_FOUND(11, 1);
    if (PRELUDE_MATCH(12)) return PRELUDE_FOUND(12, 1);
    if (PRELUDE_MATCH(13)) return PRELUDE_FOUND(13, 1);
    if (PRELUDE_MATCH(14)) return PRELUDE_FOUND(14, 239);
    if (PRELUDE_MATCH(15)) return PRELUDE_FOUND(15, 1);
    if (PRELUDE_MATCH(16)) return PRELUDE_FOUND(16, 255);
    if (PRELUDE_MATCH(17)) return PRELUDE_FOUND(17, 1);
    if (PRELUDE_MATCH(18)) return PRELUDE_FOUND(18, 1);
    if (PRELUDE_MATCH(19)) return PRELUDE_FOUND(19, 1);
    if (PRELUDE_MATCH(20)) return PRELUDE_FOUND(20, 1);
    if (PRELUDE_MATCH(21)) return PRELUDE_FOUND(21, 10);
    if (PRELUDE_MATCH(22)) return PRELUDE_FOUND(22, 2);
#undef PRELUDE_FOUND

    return Qnil;
}

void
Init_prelude(void)
{
}
