# frozen_string_literal: true

# This group classifies test files into 4 groups by running `bin/rspec --profile 10000`
# to ensure balanced execution times. When adding new test files, it is recommended to
# re-aggregate and adjust the groups to keep them balanced.
# For now, please add new files to group 'windows_d'.

module Spec
  module WindowsTagGroup
    EXAMPLE_MAPPINGS = {
      windows_a: [
        "spec/runtime/setup_spec.rb",
        "spec/commands/install_spec.rb",
        "spec/commands/add_spec.rb",
        "spec/install/gems/compact_index_spec.rb",
        "spec/commands/config_spec.rb",
        "spec/commands/pristine_spec.rb",
        "spec/install/gemfile/path_spec.rb",
        "spec/update/git_spec.rb",
        "spec/commands/open_spec.rb",
        "spec/commands/remove_spec.rb",
        "spec/commands/show_spec.rb",
        "spec/plugins/source/example_spec.rb",
        "spec/commands/console_spec.rb",
        "spec/runtime/require_spec.rb",
        "spec/runtime/env_helpers_spec.rb",
        "spec/runtime/gem_tasks_spec.rb",
        "spec/install/gemfile_spec.rb",
        "spec/commands/fund_spec.rb",
        "spec/commands/init_spec.rb",
        "spec/bundler/ruby_dsl_spec.rb",
        "spec/bundler/mirror_spec.rb",
        "spec/bundler/source/git/git_proxy_spec.rb",
        "spec/bundler/source_list_spec.rb",
        "spec/bundler/plugin/installer_spec.rb",
        "spec/bundler/friendly_errors_spec.rb",
        "spec/resolver/platform_spec.rb",
        "spec/bundler/fetcher/downloader_spec.rb",
        "spec/update/force_spec.rb",
        "spec/bundler/env_spec.rb",
        "spec/install/gems/mirror_spec.rb",
        "spec/install/failure_spec.rb",
        "spec/bundler/yaml_serializer_spec.rb",
        "spec/bundler/environment_preserver_spec.rb",
        "spec/install/gemfile/install_if_spec.rb",
        "spec/install/gems/gemfile_source_header_spec.rb",
        "spec/bundler/fetcher/base_spec.rb",
        "spec/bundler/rubygems_integration_spec.rb",
        "spec/bundler/worker_spec.rb",
        "spec/bundler/dependency_spec.rb",
        "spec/bundler/ui_spec.rb",
        "spec/bundler/plugin/source_list_spec.rb",
        "spec/bundler/source/path_spec.rb",
      ],
      windows_b: [
        "spec/install/gemfile/git_spec.rb",
        "spec/install/gems/standalone_spec.rb",
        "spec/commands/lock_spec.rb",
        "spec/cache/gems_spec.rb",
        "spec/other/major_deprecation_spec.rb",
        "spec/install/gems/dependency_api_spec.rb",
        "spec/install/gemfile/gemspec_spec.rb",
        "spec/plugins/install_spec.rb",
        "spec/commands/binstubs_spec.rb",
        "spec/install/gems/flex_spec.rb",
        "spec/runtime/inline_spec.rb",
        "spec/commands/post_bundle_message_spec.rb",
        "spec/runtime/executable_spec.rb",
        "spec/lock/git_spec.rb",
        "spec/plugins/hook_spec.rb",
        "spec/install/allow_offline_install_spec.rb",
        "spec/install/gems/post_install_spec.rb",
        "spec/install/gemfile/ruby_spec.rb",
        "spec/install/security_policy_spec.rb",
        "spec/install/yanked_spec.rb",
        "spec/update/gemfile_spec.rb",
        "spec/runtime/load_spec.rb",
        "spec/plugins/command_spec.rb",
        "spec/commands/version_spec.rb",
        "spec/install/prereleases_spec.rb",
        "spec/bundler/uri_credentials_filter_spec.rb",
        "spec/bundler/plugin_spec.rb",
        "spec/install/gems/mirror_probe_spec.rb",
        "spec/plugins/list_spec.rb",
        "spec/bundler/compact_index_client/parser_spec.rb",
        "spec/bundler/gem_version_promoter_spec.rb",
        "spec/other/cli_dispatch_spec.rb",
        "spec/bundler/source/rubygems_spec.rb",
        "spec/cache/platform_spec.rb",
        "spec/update/gems/fund_spec.rb",
        "spec/bundler/stub_specification_spec.rb",
        "spec/bundler/retry_spec.rb",
        "spec/bundler/installer/spec_installation_spec.rb",
        "spec/bundler/spec_set_spec.rb",
        "spec/quality_es_spec.rb",
        "spec/bundler/index_spec.rb",
        "spec/other/cli_man_pages_spec.rb",
      ],
      windows_c: [
        "spec/commands/newgem_spec.rb",
        "spec/commands/exec_spec.rb",
        "spec/commands/clean_spec.rb",
        "spec/commands/platform_spec.rb",
        "spec/cache/git_spec.rb",
        "spec/install/gemfile/groups_spec.rb",
        "spec/commands/cache_spec.rb",
        "spec/commands/check_spec.rb",
        "spec/commands/list_spec.rb",
        "spec/install/path_spec.rb",
        "spec/bundler/cli_spec.rb",
        "spec/install/bundler_spec.rb",
        "spec/install/git_spec.rb",
        "spec/commands/doctor_spec.rb",
        "spec/bundler/dsl_spec.rb",
        "spec/install/gems/fund_spec.rb",
        "spec/install/gems/env_spec.rb",
        "spec/bundler/ruby_version_spec.rb",
        "spec/bundler/definition_spec.rb",
        "spec/install/gemfile/eval_gemfile_spec.rb",
        "spec/plugins/source_spec.rb",
        "spec/install/gems/dependency_api_fallback_spec.rb",
        "spec/plugins/uninstall_spec.rb",
        "spec/bundler/plugin/index_spec.rb",
        "spec/bundler/bundler_spec.rb",
        "spec/bundler/fetcher_spec.rb",
        "spec/bundler/source/rubygems/remote_spec.rb",
        "spec/bundler/lockfile_parser_spec.rb",
        "spec/cache/cache_path_spec.rb",
        "spec/bundler/source/git_spec.rb",
        "spec/bundler/source_spec.rb",
        "spec/commands/ssl_spec.rb",
        "spec/bundler/fetcher/compact_index_spec.rb",
        "spec/bundler/plugin/api_spec.rb",
        "spec/bundler/endpoint_specification_spec.rb",
        "spec/bundler/fetcher/index_spec.rb",
        "spec/bundler/settings/validator_spec.rb",
        "spec/bundler/build_metadata_spec.rb",
        "spec/bundler/current_ruby_spec.rb",
        "spec/bundler/installer/gem_installer_spec.rb",
        "spec/bundler/cli_common_spec.rb",
        "spec/bundler/ci_detector_spec.rb",
      ],
      windows_d: [
        "spec/commands/outdated_spec.rb",
        "spec/commands/update_spec.rb",
        "spec/lock/lockfile_spec.rb",
        "spec/install/deploy_spec.rb",
        "spec/install/gemfile/sources_spec.rb",
        "spec/runtime/self_management_spec.rb",
        "spec/install/gemfile/specific_platform_spec.rb",
        "spec/commands/info_spec.rb",
        "spec/install/gems/resolving_spec.rb",
        "spec/install/gemfile/platform_spec.rb",
        "spec/bundler/gem_helper_spec.rb",
        "spec/install/global_cache_spec.rb",
        "spec/runtime/platform_spec.rb",
        "spec/update/gems/post_install_spec.rb",
        "spec/install/gems/native_extensions_spec.rb",
        "spec/install/force_spec.rb",
        "spec/cache/path_spec.rb",
        "spec/install/gemspecs_spec.rb",
        "spec/commands/help_spec.rb",
        "spec/bundler/shared_helpers_spec.rb",
        "spec/bundler/settings_spec.rb",
        "spec/resolver/basic_spec.rb",
        "spec/install/gemfile/force_ruby_platform_spec.rb",
        "spec/commands/licenses_spec.rb",
        "spec/install/gemfile/lockfile_spec.rb",
        "spec/bundler/fetcher/dependency_spec.rb",
        "spec/quality_spec.rb",
        "spec/bundler/remote_specification_spec.rb",
        "spec/install/process_lock_spec.rb",
        "spec/install/binstubs_spec.rb",
        "spec/bundler/compact_index_client/updater_spec.rb",
        "spec/bundler/ui/shell_spec.rb",
        "spec/other/ext_spec.rb",
        "spec/commands/issue_spec.rb",
        "spec/update/path_spec.rb",
        "spec/bundler/plugin/api/source_spec.rb",
        "spec/install/gems/win32_spec.rb",
        "spec/bundler/plugin/dsl_spec.rb",
        "spec/runtime/requiring_spec.rb",
        "spec/bundler/plugin/events_spec.rb",
        "spec/bundler/resolver/candidate_spec.rb",
        "spec/bundler/digest_spec.rb",
        "spec/bundler/fetcher/gem_remote_fetcher_spec.rb",
      ],
    }.freeze
  end
end
