#!/usr/local/bin/ruby

#==============================================================================#
# bin/brbcmp.rb
# $Id: brbcmp.rb,v 1.6 2003/03/06 06:25:12 yuya Exp $
#==============================================================================#

require 'bruby'
require 'getoptlong'

#==============================================================================#
# BRbCmpCommand Module
module BRbCmpCommand

  def self.main
    options = parse_argv

    if options[:help] || ARGV.size < 1
      print_usage
    end

    $KCODE    = options[:kcode]
    BRb.debug = options[:debug]

    if ARGV.size > 1
      ARGV.each { |inputfile|
        puts(inputfile) if @@verbose

        outputfile = inputfile.sub(/(\.rb$|$)/, '.brb')

        binary = BRb.dumpfile(inputfile)
        File.open(outputfile, 'wb') { |file| file.write(binary) }
      }
    else
      inputfile  = ARGV[0]
      outputfile = options[:output] || inputfile.sub(/(\.rb$|$)/, '.brb')

      binary = BRb.dumpfile(inputfile)
      File.open(outputfile, 'wb') { |file| file.write(binary) }
    end
  end

  def self.parse_argv
    parser = GetoptLong.new
    parser.set_options(
      ['--kcode',   '-K', GetoptLong::REQUIRED_ARGUMENT],
      ['--output',  '-o', GetoptLong::REQUIRED_ARGUMENT],
      ['--verbose', '-v', GetoptLong::NO_ARGUMENT],
      ['--debug',   '-g', GetoptLong::NO_ARGUMENT],
      ['--help',    '-h', GetoptLong::NO_ARGUMENT]
    )

    options = {}
    parser.each_option { |name, argument|
      options[name.sub(/^--/, '').intern] = argument
    }

    options[:kcode]   = 'n' if options[:kcode].nil?
    options[:verbose] = !!options[:verbose]
    options[:debug]   = !!options[:debug]
    options[:help]    = !!options[:help]

    @@verbose = options[:verbose]

    return options
  rescue GetoptLong::InvalidOption
    exit(1)
  end

  def self.print_usage
    STDERR.puts "bRuby #{BRb::VERSION}"
    STDERR.puts "Usage: brbcmp.rb [options] file"
    STDERR.puts "Options:"
    STDERR.puts "  -K  --kcode    specifies KANJI code-set."
    STDERR.puts "  -o  --output   specifies output file name."
    STDERR.puts "  -v  --verbose  enable verbose mode."
    STDERR.puts "  -g  --debug    enable debug mode."
    STDERR.puts "  -h  --help     display this information."
    exit(1)
  end

end # BRbCmpCommand

#==============================================================================#

BRbCmpCommand.main

#==============================================================================#
#==============================================================================#
