require 'runit/testcase'
require 'dpklib/dataconv'

class TESTCASE_Dataconv < RUNIT::TestCase
  include Dpklib

  def setup
    @srchash = {:a => 10, :b => 20, :c => 66}

    dest_struct_klass = Struct.new(:a, :b, :c)
    @dest_struct = dest_struct_klass.new

    dconv = DataConvertor.new
    dconv.getter = DataConvertor::GETTER_HASH
    dconv.setter = DataConvertor::SETTER_MEMBER
    @dconv = dconv
  end

  def test_dataconv
    srchash = @srchash
    dest_struct = @dest_struct

    dconv = @dconv
    dconv.set :a do |n, v|
      v + 5
    end
    dconv.set :b do |n, v|
      v - 20
    end
    dconv.set :c

    dconv.perform srchash, dest_struct
    assert_equal srchash[:a] + 5, dest_struct.a
    assert_equal srchash[:b] - 20, dest_struct.b
    assert_equal srchash[:c], dest_struct.c

  end

  def test_mset
    @dconv.set :b
    @dconv.mset :a, :b do |a, b|
      {:a => a + 3, :c => b - 9}
    end

    @dconv.perform @srchash, @dest_struct

    assert_equal @srchash[:a] + 3, @dest_struct.a
    assert_equal @srchash[:b], @dest_struct.b
    assert_equal @srchash[:b] - 9, @dest_struct.c
  end
  
  def test_chain
    @dconv.chain :a do |k, v|
      v + 2
    end
    @dconv.chain :a do |k, v|
      v * 4
    end

    @dconv.perform @srchash, @dest_struct
    assert_equal @srchash[:a] * 4 + 2, @dest_struct.a
  end

end
