require "dpklib/class"

module Dpklib
  module AcquisitionModule
    CannotImportError = Class.new(NameError)
    include Dpklib::EachargMethod

    attr_reader :acq_outer
    def acq_outer=(outer)
      @acq_outer = outer
    end

    def acq_invoke(name, *args, &block)
      obj = acq_object(name)
      if obj
        obj.__send__(name, *args, &block)
      else
        Dpklib::Acquisition.fail_import(name)
      end
    end
    
    def acq_object(name)
      acq_search_object(Acquisition.exported_name(name.to_s).intern)
    end
    
    def acq_invoke_super(name, *args, &block)
      assert_acq_outer(name)
      @acq_outer.acq_invoke(name, *args, &block)
    end
    
    def acq_object_super(name)
      assert_acq_outer(name)
      @acq_outer.acq_object(name)
    end

    def acq_search_object(exported_name)
      if respond_to?(exported_name)
        self
      elsif @acq_outer
        @acq_outer.acq_search_object(exported_name)
      else
        nil
      end
    end

    def acq_export(name)
      acqexp = class << self
                 extend Dpklib::Acquisition::ClassModule
                 method(:acq_export)
               end
      acqexp[name]
    end
    eacharg_method :acq_export

    def acq_export_method(name, &block)
      Dpklib.install_singleton_method(self, name, &block)
      acq_export(name)
    end

    def acq_export_object(name, object)
      acq_export_method(name) {
        object
      }
    end

    private
    def assert_acq_outer(name)
      @acq_outer || raise(CannotImportError, "No outer to import method: #{name}")
    end
  end #/AcquisitionModule
  
  module Acquisition
    include AcquisitionModule
    Dpklib.install_class_module(self) do
      include Dpklib::EachargMethod
      def acq_import(name)
        exported_name = Dpklib::Acquisition.exported_name(name.to_s)
        orig_name = "acqimport_orig_#{name}"
        if method_defined?(name)
          alias_method(orig_name, name)
        end
        module_eval(<<-END, __FILE__, __LINE__ + 1)
        def #{name}(*args, &block)
          obj = acq_object(:#{name})
          if obj.equal?(self)
            respond_to?(:#{orig_name}) ? #{orig_name}(*args, &block) : super
          elsif obj.nil?
            Dpklib::Acquisition.fail_import(:#{name})
          else
            obj.__send__(:#{name}, *args, &block)
          end
        end
        END
      end
    
      def acq_import_super(name, &default_implement)
        if block_given?
          module_eval(<<-END, __FILE__, __LINE__ + 1)
          def #{name}(*args, &block)
            begin
              acq_invoke_super(:#{name}, *args, &block)
            rescue Dpklib::Acquisition::CannotImportError
              #{name}_acqdefault(*args, &block)
            end
          end
          END
          define_method("#{name}_acqdefault", &default_implement)
        else
          module_eval(<<-END, __FILE__, __LINE__ + 1)
          def #{name}(*args, &block)
            acq_invoke_super(:#{name}, *args, &block)
          end
          END
        end
      end

      def acq_export(name)
        define_method(Dpklib::Acquisition.exported_name(name)) do
        end
      end

      def acq_export_self(name)
        module_eval(<<-END, __FILE__, __LINE__ + 1)
        def #{name}
          self
        end
        END
        acq_export(name)
      end

      eacharg_method :acq_import, :acq_import_super, :acq_export
    end #/install_class_module
  end #/Acquisition
  
  class << Acquisition
    def exported_name(name)
      "dpkacq_exported_#{name}"
    end

    def fail_import(name)
      raise(Acquisition::CannotImportError,
            "Failed to import method: #{name}.")
    end
  end #/<< Acquisition

  class AcqObject
    include Acquisition
    def initialize(outer = nil)
      self.acq_outer = outer
      acq_init
    end

    def acq_init
    end
  end #/AcqObject
end #/Dpklib
