module Dpklib
  class DataConvertor
    DEAULT_CONV = proc { |key,val| val; }
    
    GETTER_MEMBER = proc {|src, key|
      src.__send__(key)
    }
    SETTER_MEMBER = proc {|dest, key, val|
      dest.__send__("#{key}=", val)
    }
    GETTER_HASH = proc {|src, key|
      src[key]
    }
    SETTER_HASH = proc {|dest, key, val|
      dest[key] = val
    }

    MultipleConvertor = Struct.new(:keys, :conv)

    def initialize
      @convertor_hash = {}
      @mconvs = []
      @getter = GETTER_MEMBER
      @setter = SETTER_MEMBER
    end
    attr_accessor :getter, :setter

    def set(*keys, &block)
      cnvhash = @convertor_hash
      
      block = DEAULT_CONV if block.nil?
      keys.each do |key|
	cnvhash[key] = block
      end
    end
    
    def chain(*keys, &block)
      cnvhash = @convertor_hash
      keys.each do |key|
	conv = cnvhash[key]
	case conv
	  when nil
	  conv = []
	  when Proc
	  conv = [conv]
	end
	conv.unshift(block)
	cnvhash[key] = conv
      end
    end

    def mset(*keys, &block)
      mconv = MultipleConvertor.new
      mconv.keys = keys
      mconv.conv = block

      @mconvs << mconv
    end

    def perform(src, dest)
      getr,setr = @getter, @setter
      @convertor_hash.each do |key, conv|
	v = getr[src, key]

	case conv
	when Proc
	  v = conv[key, v]
	when Array
	  conv.each { |c|
	    v = c[key, v]
	  }
	end

	setr[dest, key, v]
      end

      @mconvs.each do |mconv|
	args = mconv.keys.collect do |key|
	  getr[src, key]
	end
	value_hash = mconv.conv[*args]
	value_hash.each do |key, value|
	  setr[dest, key, value]
	end
      end

      dest
    end
  end
end
